      SUBROUTINE BARPLT(INDIC,KNDBGN,KNDEND,KNTBAR,MSTBAR,RATIO,TOTAL,
     1XWIDTH,YWIDTH,XCORNR,YCORNR,RELHIT,NAME,LASTX,LASTY)
C                                                               06/22/67
C     BAR CHART PLOTTING SUBROUTINE FOR GENERAL PLOT PACKAGE GENPLT-II
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE BARPLT ARGUMENT LIST DEFINITIONS
C
C     INDIC  = 1 PLOTS HORIZONTAL BAR.
C     INDIC  = 2 PLOTS VERTICAL BAR.
C     INDIC  = 3 PLOTS HATCHING IDENTIFICATION BLOCKS.
C     KNDBGN = NUMBER OF FIRST COMPONENT TO PLOT, NOT LARGER THAN KNDEND
C     KNDEND = NUMBER OF FINAL COMPONENT TO PLOT, MAXIMUM IS 7.
C     KNTBAR = NUMBER OF THIS BAR IN PLOTTING SEQUENCE, FIRST BAR IS 1.
C     MSTBAR = TOTAL NUMBER OF BARS TO BE PLOTTED.
C     RATIO  = ARRAY OF SEGMENT LENGTHS IN DATA UNITS.
C     TOTAL  = DATA UNITS CORRESPONDING TO TOTAL WIDTH OF PLOT AREA.
C     XWIDTH = HORIZONTAL WIDTH OF PLOT AREA.
C     YWIDTH = VERTICAL HEIGHT OF PLOT AREA.
C     XCORNR = X DISTANCE FROM PLOTTING TABLE ORIGIN TO LEFT PLOT EDGE.
C     YCORNR = Y DISTANCE FROM PLOTTING TABLE ORIGIN TO LOWER PLOT EDGE.
C     RELHIT = HEIGHT OF PLOTTED ALPHANUMERIC CHARACTERS/(0.02*YWIDTH).
C     NAME   = 10 LETTER BAR TITLE OR SEQUENCE OF 10 LETTER BLOCK TITLES
C     LASTX  = HORIZONTAL (X) GRID COORDINATE OF LAST POINT PLOTTED.
C     LASTY  = VERTICAL (Y) GRID COORDINATE OF LAST POINT PLOTTED.
C
      DIMENSION RATIO(7),NAME(12)
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      MODE = ILINE
      WIDTHX=FACTOR*XWIDTH
      WIDTHY=FACTOR*YWIDTH
      CORNRX=FACTOR*XCORNR + OFSETX
      CORNRY=FACTOR*YCORNR + OFSETY
      KSCALE=RELHIT*WIDTHY/300.0
      IF(KSCALE)1,1,2
    1 KSCALE=1
    2 INTRVL=2*KSCALE
      IF(INDIC-2)3,8,13
C
C     ***********************PLOT HORIZONTAL BAR************************
    3 MINY=CORNRY+WIDTHY-(FLOAT(KNTBAR)*WIDTHY/FLOAT(MSTBAR))
      MAXY=CORNRY+WIDTHY-(FLOAT(KNTBAR-1)*WIDTHY/FLOAT(MSTBAR))
      MINX=CORNRX
      SUM=0.0
      DO 5 I=KNDBGN,KNDEND
      SUM=SUM+RATIO(I)
      MAXX=CORNRX+(SUM*WIDTHX/TOTAL)
      IF(MINX-MAXX)4,5,5
    4 CALL HCHPLT(I,INTRVL,MINX,MINY,MAXX,MAXY,LASTX,LASTY)
      CALL PENUP(LASTX,LASTY,MAXX,MAXY)
      CALL PENDWN(LASTX,LASTY,MAXX,MINY)
      MINX=MAXX
    5 CONTINUE
      MINX=CORNRX
      IF(MINX-MAXX)6,7,7
    6 CALL PENDWN(LASTX,LASTY,MINX,MINY)
      CALL PENDWN(LASTX,LASTY,MINX,MAXY)
      CALL PENDWN(LASTX,LASTY,MAXX,MAXY)
      LENGTH=0
      CALL LTRPLT(NAME,1,10,0,KSCALE,LASTX,LASTY,LENGTH,MINY)
      MINX=MINX-LENGTH-4*KSCALE
      MINY=MINY+((MAXY-MINY-(6*KSCALE))/2)
      CALL LTRPLT(NAME,1,10,1,KSCALE,LASTX,LASTY,MINX,MINY)
    7 RETURN
C
C     ************************PLOT VERTICAL BAR*************************
    8 MINX=CORNRX+(FLOAT(KNTBAR-1)*WIDTHX/FLOAT(MSTBAR))
      MAXX=CORNRX+(FLOAT(KNTBAR)*WIDTHX/FLOAT(MSTBAR))
      MINY=CORNRY
      SUM=0.0
      DO 10 I=KNDBGN,KNDEND
      SUM=SUM+RATIO(I)
      MAXY=CORNRY+(SUM*WIDTHY/TOTAL)
      IF(MINY-MAXY)9,10,10
    9 CALL HCHPLT(I,INTRVL,MINX,MINY,MAXX,MAXY,LASTX,LASTY)
      CALL PENUP(LASTX,LASTY,MINX,MAXY)
      CALL PENDWN(LASTX,LASTY,MAXX,MAXY)
      MINY=MAXY
   10 CONTINUE
      MINY=CORNRY
      IF(MINY-MAXY)11,12,12
   11 CALL PENDWN(LASTX,LASTY,MAXX,MINY)
      CALL PENDWN(LASTX,LASTY,MINX,MINY)
      CALL PENDWN(LASTX,LASTY,MINX,MAXY)
      LENGTH=0
      CALL LTRPLT(NAME,1,10,0,KSCALE,LASTX,LASTY,LENGTH,MINY)
      MINX=MINX+((MAXX-MINX+(6*KSCALE))/2)
      MINY=MINY-LENGTH-4*KSCALE
      CALL LTRPLT(NAME,1,10,2,KSCALE,LASTX,LASTY,MINX,MINY)
   12 RETURN
C
C     ****************PLOT HATCHING IDENTICATION BLOCKS*****************
   13 MINX=CORNRX+WIDTHX+(6.0*FLOAT(KSCALE))
      MAXX=MINX+(30*KSCALE)
      MAXY=CORNRY+WIDTHY
      DO 14 J=KNDBGN,KNDEND
      MINY=MAXY-(20*KSCALE)
      LX7=MINX
      LY7=MAXY-(30*KSCALE)
      I=KNDBGN+KNDEND-J
      CALL HCHPLT(I,INTRVL,MINX,MINY,MAXX,MAXY,LASTX,LASTY)
      CALL PENUP(LASTX,LASTY,MINX,MAXY)
      CALL PENDWN(LASTX,LASTY,MAXX,MAXY)
      CALL PENDWN(LASTX,LASTY,MAXX,MINY)
      CALL PENDWN(LASTX,LASTY,MINX,MINY)
      CALL PENDWN(LASTX,LASTY,MINX,MAXY)
      LTREND=10*I
      LTRBGN=LTREND-9
      CALL LTRPLT(NAME,LTRBGN,LTREND,1,KSCALE,LASTX,LASTY,LX7,LY7)
   14 MAXY=MAXY-(40*KSCALE)
      RETURN
      END
