00100	C***********************************************************************
00200	C
 00300	C	DECREV.FOR VERSION 1
00400	C
 00500	C
 00600	C	THIS PROGRAM CREATES A 'RUNOFF' FILE WHICH CONTAINS THE REVIEW
   00700	C	OF DECUS DECSYSTEM-10 LIBRARY PROGRAMS.
 00800	C
 00900	C	THE PROGRAM IS ENTIRELY TABLE-DRIVEN IN THE QUESTION
   01000	C	SECTION, AND THE TABLES ARE SET UP IN THE BLOCK DATA SUBROUTINE
  01100	C	AND PASSED TO THE MAIN ROUTINE THROUGH THE COMMON BLOCK /QUES/.
  01200	C	CHECK THAT SECTION TO ADD QUESTIONS OR CATEGORIES OF QUESTIONS.
  01300	C
 01400	C	RESTRICTIONS IN THIS PROGRAM:
                          01500	C		PROGRAM TITLE <= 10 CHAR LONG  [PROGTI]
01600	C		NAME OF REVIEWER <= 30 CHAR LONG  [RNAM]
    01700	C		TITLE OF REVIEWER <= 40 CHAR LONG  [RTIT]
   01800	C		COMPANY OR INSTITUTION NAME <= 40 CHAR LONG  [COMP]
   01900	C		DEPARTMENT NAME <= 40 CHAR LONG  [DEPT]
02000	C		CITY+STATE+ZIP <= 40 CHAR LONG  [CSZ]
  02100	C		COUNTRY NAME <= 40 CHAR LONG  [CNTRY]
  02200	C
 02300	C	TO CHANGE ANY OF THESE RESTRICTIONS, CHANGE THE LENGTH
 02400	C	OF THE ARRAY NAME GIVEN IN THE [ ] FOLLOWING THE RESTRICTION
02500	C
 02600	C	TO CHANGE THE MAXIMUM LENGTH OF ANY LINE USED TO
                                                    02700	C	REPLY TO QUESTIONS,  CHANGE THE DIMENSION OF THE
  02800	C	ARRAY 'LINE' AND CHANGE THE FORMAT STATEMENTS 106 AND 108.
  02900	C
 03000	C
 03100	C	WRITTEN BY H. D. TODD, WESLEYAN UNIVERSITY, MAY, 1975.
 03200	C
 03300	C***********************************************************************
03400		INTEGER DECSYS,REV,QUSCAT,QUSPTR
    03500		DOUBLE PRECISION PROGTI,VERSCD,RNAM(3),RTIT(5),COMP(4),
 03600		1 DEPT(4),CSZ(4),ADATE,CNTRY(4)
03700		DIMENSION LINE(16)
   03800		COMMON/QUES/NUMCAT,MAXQUS(4),LQSTRT(30),LQEND(30),HLCAT(12,4),
    03900		1QUEST(12,50)
   04000	C
 04100	C	VERSION NUMBER
 04200	C
           04300		DATA REV/1/, REVVER/'1'/
  04400	C***********************************************************************
04500	C
 04600	C	SECTION 1
 04700	C	REQUEST BIOGRAPHICAL DATA FROM THE REVIEWER FOR THE REVIEW
  04800	C	FILE.  REVIEW FILEIS ON UNIT 'REV'.
04900	C
 05000	C***********************************************************************
05100		OPEN(UNIT=5,DEVICE='TTY')
 05200		WRITE (5,1)
05300	1	FORMAT (//,' DECUS DECSYSTEM-10 LIBRARY PROGRAM REVIEW',//,
 05400		1 ' WHAT IS THE NUMBER OF THE PROGRAM YOU ARE REVIEWING? ',$)
05500	C
 05600	C	ALLOW THE USER TO TYPE IN THE PROGRAM NUMBER AS EITHER
                     05700	C	'NNN' OR '10-NNN', WHERE NNN IS THE PROGRAM NUMBER.
    05800	C
 05900		READ (5,2) DECSYS,NPROG
   06000	2	FORMAT (2I)
    06100		IF (NPROG.EQ.0) NPROG = DECSYS
 06200		IF (NPROG.EQ.DECSYS) DECSYS = 10
    06300		NPROG = IABS(NPROG)
  06400	C
 06500	C	CREATE FILE 'DECXXX.RNO', WHERE 'XXX'
   06600	C	IS THE DECUS CATALOG NUMBER.
  06700	C
 06800		CALL OPNOUT(REV,NPROG)
    06900		WRITE (5,3)
07000	3	FORMAT (/,' WHAT IS THE PROGRAM TITLE? '$)
   07100		READ (5,4) PROGTI
    07200	4	FORMAT (5A10)
  07300		WRITE (5,5)
07400	5	FORMAT(/,' WHAT IS THE VERSION NUMBER OF THE PROGRAM -
                               07500		1 OR SOURCE FILE',/,' CREATION DATE AS DD-MON-YY (LATEST
07600		2 DATE IF THERE ARE SEVERAL SOURCE FILES)? ')
 07700		READ (5,4) VERSCD
    07800		WRITE (5,6)
07900	6	FORMAT (/,' WHAT IS YOUR NAME? ',$)
08000		READ (5,4) RNAM
 08100		WRITE (5,7)
08200	7	FORMAT (/,' WHAT IS YOUR TITLE? (OPTIONAL) ',$)
   08300		READ(5,4) RTIT
  08400		WRITE (5,8)
08500	8	FORMAT (/,' WHAT IS YOUR ADDRESS OR DEPARTMENT WITHIN YOUR
  08600		1 COMPANY OR INSTITUTION? ')
   08700		READ (5,4) DEPT
 08800		WRITE (5,9)
08900	9	FORMAT (/,' WITH WHAT COMPANY OR INSTITUTION ARE YOU
   09000		1 ASSOCIATED? ')
09100		READ(5,4) COMP
       09200		WRITE (5,10)
    09300	10	FORMAT (/,' CITY, STATE  ZIPCODE ')
    09400		READ(5,4) CSZ
   09500		WRITE (5,11)
    09600	11	FORMAT (/,' COUNTRY? ',$)
    09700		READ (5,4) CNTRY
09800		CALL DATE(ADATE)
09900		WRITE (REV,19) REVVER
10000	C
 10100	C	DUMP REVIEWER BIOGRAPHICAL
    10200	C
 10300	19	FORMAT ('.PS 58,65;.FLAG CAP;.LC',/,
   10400		1 '^^DECREV.FOR VERSION ',A5,'\\',/,
10500		2 '.S 2;.TITLE <DECUS ^LIBRARY ^PROGRAM ^REVIEW',/,
10600		3 '.CENTER; <DECUS ^LIBRARY ^PROGRAM ^REVIEW',/,
   10700		4 '.S 3;.LM 45')
10800		WRITE (REV,20) DECSYS,NPROG,PROGTI,VERSCD,RNAM,RTIT,DEPT,
                             10900		1 COMP,CSZ,CNTRY,ADATE
    11000	20	FORMAT ('.I -34',/, '<DECUS ^LIBRARY ^PROGRAM ^BEING
  11100		1 ^REVIEWED:', I4,'-',I3,/,'.I -24',/,
   11200		2 '<DECUS ^LIBRARY ^PROGRAM ^NAME: ^^',A10,'\\',/,'.I -29',/,
11300		3 '^SOURCE ^VERSION OR ^CREATION ^DATE: ^^',A10,'\\',/,
 11400		3 '.S 2;.LM 25;.I -18',/,
 11500		4 '^REVIEWER''S ^NAME: ^^',3X,3A10,'\\',/,'.I -19',/,
   11600		5 '^REVIEWER''S ^TITLE: ^^',2X,5A10,'\\',/,'.I -21',/,
  11700		6 '^REVIEWER''S ^ADDRESS: ^^',4A10,'\\',/,'.I 0',/,
11800		7 '^^',4A10,'\\',/,'.I 0',/,
   11900		8 '^^',4A10,'\\',/,'.I 0',/,
   12000		9 '^^',4A10,'\\',/,'.I 0',/,
             12100		1 '.S 2;.I -17',/, '^DATE OF ^REVIEW: ^^',A10,'\\',/,
   12200		2 '.S 2')
  12300	C***********************************************************************
12400	C
 12500	C	END SECTION 1, BEGIN
12600	C
 12700	C	SECTION 2
 12800	C	THE QUESTION-AND-ANSWER PHASE.
12900	C
 13000	C***********************************************************************
13100		WRITE (5,30)
    13200	30	FORMAT (//,' FOR EACH OF THE FOLLOWING QUESTIONS, PLEASE TYPE
   13300		1 YOUR RESPONSE USING',/,' AS MANY LINES AS REQUIRED. PLEASE USE
  13400		2 NO MORE THAN 80 CHARACTERS',/,' PER LINE. WHEN YOU
                                       13500		2 FINISH YOUR RESPONSE TO A QUESTION,',/,
13600		3 ' TYPE A <CONTROL-Z> CHARACTER.')
 13700	C
 13800	C	THIS IS THE QUESTION-AND-ANSWER MAIN LOOP
    13900	C
 14000	C	NQUEST = # OF THE QUESTION BEING PROCESSED
   14100	C	NUMCAT = # OF CATEGORIES OF QUESTIONS
   14200	C	QUSCAT = CURRENT CATEGORY # 
  14300	C	MAXQUS(QUSCAT) = # OF QUESTIONS IN CURRENT CATEGORY
    14400	C	QUSPTR = # OF CURRENT QUESTION WITHIN ITS CATEGORY
14500	C		LQSTRT(NQUEST) = INDEX FOR FIRST LINE OF CURRENT QUESTION
  14600	C		LQEND(NQUEST) = INDEX FOR LAST LINE OF CURRENT QUESTION
    14700	C
 14800		NQUEST = 0
                               14900		    DO 100 QUSCAT = 1,NUMCAT
   15000		    WRITE (REV,107) (HLCAT(J,QUSCAT),J=1,12)
  15100	107	    FORMAT ('.LM 0;.S 2; ^^^&',12A5,'\\\&',/,'.S 1;.UC;.LS')
   15200			DO 110 QUSPTR = 1, MAXQUS(QUSCAT)
  15300			NQUEST = NQUEST + 1
 15400			WRITE (5,101) NQUEST,((QUEST(I,J),I=1,12),
   15500		1	J=LQSTRT(NQUEST),LQEND(NQUEST))
   15600	101		FORMAT (//,1X,I2,'.',(1X,12A5))
 15700			WRITE(5,102)
   15800	102		FORMAT (/)
  15900			WRITE(REV,103) ((QUEST(I,J),I=1,12),J=LQSTRT(NQUEST),
  16000		1	 LQEND(NQUEST))
    16100	103		FORMAT ('.LM 10;.LE',/,(12A5))
  16200			WRITE (REV,104) 
                                  16300	104		FORMAT ('.S 1',/,'<RESPONSE:')
  16400	C
 16500	C	LOOP ON INPUT UNTIL EOF
  16600	C
 16700	105		    READ (5,106,END=110) LINE
   16800	106		    FORMAT (16A5)
16900			    WRITE (REV,108) LINE
 17000	108		    FORMAT (16A5)
17100			    GO TO 105
  17200	110		WRITE (REV,113)
  17300	113		FORMAT ('.S 1')
  17400	100	    WRITE (REV,111)
    17500	111	    FORMAT ('.ELS')
    17600		WRITE (REV,112) PROGTI
    17700	112	FORMAT ('.S 2;.LM 0;[END OF REVIEW OF ',A10,']',/,'.PG')
  17800		STOP
  17900		END
   18000		BLOCK DATA
 18100	C****************************************************************************
     18200	C
 18300	C	THIS ROUTINE SETS UP THE TABLES OF POINTERS AND QUESTIONS USED BY THE 
18400	C	MAIN ROUTINE.  VARIABLES USED HERE ARE DESCRIBED IN THE MAIN ROUTINE,
 18500	C	EXCEPT FOR 'HLCAT', THE ARRAY CONTAINING THE CATEGORY TITLE, AND
 18600	C	'QUEST', WHICH CONTAINS THE QUESTIONS.
  18700	C	QUESTIONS ARE STORED IN QUEST WITH UP TO 60 CHAR PER LINE.  LINES OF
  18800	C	LESS THAN 56 CHAR ARE PADDED WITH INTEGER 0 TO FORCE THEM TO
18900	C	USE 12 WORDS.
  19000	C
 19100	C******************************************************************************
   19200	C
                                                             19300	C	THE FOLLOWING PARAMETERS SET THE STARTING AND ENDING LINES OF THE
19400	C	QUESTIONS.  TO CHANGE THE ORDER OF THE QUESTIONS OR TO INSERT OR
 19500	C	ADD QUESTIONS, EXTEND THE LENGTH OF THE ARRAY 'QUEST'
  19600	C	AND INSERT THE APPROPRIATE PARAMETERS HERE AND INSERT THE
   19700	C	DATA STATEMENT SUPPLYING THE QUESTION IN THE APPROPRIATE PLACE BELOW.
 19800	C
 19900		PARAMETER
  20000		1 BQA1=1,EQA1=2,
20100		2 BQA2=3,EQA2=5,
20200		3 BQB1=6,EQB1=7,
20300		4 BQB2=8,EQB2=9,
20400		5 BQB3=10,EQB3=11,
   20500		6 BQB4=12,EQB4=14,
   20600		7 BQB5=15,EQB5=17,
   20700		8 BQC1=18,EQC1=21,
                            20800		9 BQC2=22,EQC2=24,
   20900		1 BQC3=25,EQC3=27,
   21000		1 BQC4=28,EQC4=29,
   21100		2 BQC5=30,EQC5=32,
   21200		3 BQC6=33,EQC6=35,
   21300		4 BQC7=36,EQC7=37,
   21400		5 BQC8=38,EQC8=39,
   21500		6 BQC9=40,EQC9=44,
   21600		7 BQD1=45,EQD1=46,
   21700		8 BQD2=47,EQD2=48
    21800		COMMON/QUES/NUMCAT,MAXQUS(4),LQSTRT(30),LQEND(30),HLCAT(12,4),
    21900		1QUEST(12,50)
   22000		DATA NUMCAT/4/
  22100		DATA MAXQUS/2,5,9,2/
 22200		DATA (HLCAT(J,1),J=1,12)/'DISTRIBUTION PROCEDURE REVIEW',6*0/
22300		DATA (HLCAT(J,2),J=1,12)/'DOCUMENTATION REVIEW',8*0/
                                                      22400		DATA (HLCAT(J,3),J=1,12)/'PROGRAM REVIEW',9*0/
22500		DATA (HLCAT(J,4),J=1,12)/'GENERAL COMMENTS',8*0/
   22600	C
 22700	C	CATEGORY A, QUESTION 1
   22800	C
 22900		DATA LQSTRT(1),LQEND(1)/BQA1,EQA1/
  23000		DATA ((QUEST(I,J),I=1,12),J=BQA1,EQA1)/
  23100		1 'Were all files present and complete? If not, which files or',
  23200		2 'parts thereof were missing?',6*0/
23300	C
 23400	C	CATEGORY A, QUESTION 2
   23500	C
 23600		DATA LQSTRT(2),LQEND(2)/BQA2,EQA2/
  23700		DATA ((QUEST(I,J),I=1,12),J=BQA2,EQA2)/
  23800		1 'Were all files readable in the format you requested?',0,
                                     23900		2 'If not, indicate the format requested for the programs and',
   24000		3 'describe the problems you had.',6*0/
  24100	C
 24200	C	CATEGORY B QUESTION 1
    24300	C
 24400		DATA LQSTRT(3),LQEND(3)/BQB1,EQB1/
  24500		DATA ((QUEST(I,J),I=1,12),J=BQB1,EQB1)/
  24600		1 'Does the documentation accompanying the program meet or',0,
    24700		2 'exceed the standard? If not, what improvements are required?'/
 24800	C
 24900	C	CATEGORY B QUESTION 2
    25000	C
 25100		DATA LQSTRT(4),LQEND(4)/BQB2,EQB2/
  25200		DATA ((QUEST(I,J),I=1,12),J=BQB2,EQB2)/
                                                                   25300		1 'Is the documentation complete?  (Are there unstated',0,
   25400		2 'restrictions or features?  If so, please indicate them.)'/
25500	C
 25600	C	CATEGORY B QUESTION 3
    25700	C
 25800		DATA LQSTRT(5),LQEND(5)/BQB3,EQB3/
  25900		DATA ((QUEST(I,J),I=1,12),J=BQB3,EQB3)/
  26000		1 'Is the documentation easy to use?  Suggest reasonable',0,
 26100		2 'reorganization if possible.',6*0/
26200	C
 26300	C	CATEGORY B QUESTION 4
    26400	C
 26500		DATA LQSTRT(6),LQEND(6)/BQB4,EQB4/
  26600		DATA ((QUEST(I,J),I=1,12),J=BQB4,EQB4)/
  26700		1 'Is the program abstract in the catalog accurate in its',0,
               26800		2 'description of the program?  What amendments would you',0,
26900		3 'suggest?',10*0/
   27000	C
 27100	C	CATEGORY B QUESTION 5
    27200	C
 27300		DATA LQSTRT(7),LQEND(7)/BQB5,EQB5/
  27400		DATA ((QUEST(I,J),I=1,12),J=BQB5,EQB5)/
  27500		1 'Are there "dangerous" features which installation management',
 27600		2 'might want to disable before putting the program onto',0,
 27700		3 'a system?',10*0/
  27800	C
 27900	C	CATEGORY C QUESTION 1
    28000	C
 28100		DATA LQSTRT(8),LQEND(8)/BQC1,EQC1/
  28200		DATA ((QUEST(I,J),I=1,12),J=BQC1,EQC1)/
                                                                   28300		1 'Did the program files all compile without errors?  If not,',
   28400		2 'list the names of files which did not compile or attach',0,
    28500		3 'listings of the compilations.  Also include the name and',
28600		4 'version of the compiler.',7*0/
   28700	C
 28800	C	CATEGORY C QUESTION 2
    28900	C
 29000		DATA LQSTRT(9),LQEND(9)/BQC2,EQC2/
  29100		DATA ((QUEST(I,J),I=1,12),J=BQC2,EQC2)/
  29200		1 'Did the program files load correctly? List names of',0,
   29300		2  'missing global references. Include the name and version of',
  29400		3 'the compiler.',9*0/
    29500	C
                                    29600	C	CATEGORY C QUESTION 3
    29700	C
 29800		DATA LQSTRT(10),LQEND(10)/BQC3,EQC3/
29900		DATA ((QUEST(I,J),I=1,12),J=BQC3,EQC3)/
  30000		1 'Can the loading process be revised to take advantage',0,
  30100		2 'of the LINK overlay feature to produce programs',2*0,
30200		3 'which run more efficiently?',6*0/
30300	C
 30400	C	CATEGORY C QUESTION 4
    30500	C
 30600		DATA LQSTRT(11),LQEND(11)/BQC4,EQC4/
30700		DATA ((QUEST(I,J),I=1,12),J=BQC4,EQC4)/
  30800		1 'If you loaded the ".REL" files you created, did the ".SAV"',
   30900		2 'OR ".SHR" files distributed match the file you created?',0/
    31000	C
           31100	C	CATEGORY C QUESTION 5
    31200	C
 31300		DATA LQSTRT(12),LQEND(12)/BQC5,EQC5/
31400		DATA ((QUEST(I,J),I=1,12),J=BQC5,EQC5)/
  31500		1 'Does the program perform as documented? List any',2*0,
    31600		2 'undocumented program error messages or monitor error',0,
  31700		3 'messages you discovered.',7*0/
   31800	C
 31900	C	CATEGORY C QUESTION 6
    32000	C
 32100		DATA LQSTRT(13),LQEND(13)/BQC6,EQC6/
32200		DATA ((QUEST(I,J),I=1,12),J=BQC6,EQC6)/
  32300		1 'List deficiencies which might be easily remedied or any',0,
    32400		2 'error-detecting which should be implemented within the',0,
                    32500		3 'program.',10*0/
   32600	C
 32700	C	CATEGORY C QUESTION 7
    32800	C
 32900		DATA LQSTRT(14),LQEND(14)/BQC7,EQC7/
33000		DATA ((QUEST(I,J),I=1,12),J=BQC7,EQC7)/
  33100		1 'Is the program easy to use? Are the commands or input',0,
 33200		2 'data formats ambiguous?',7*0/
    33300	C
 33400	C	CATEGORY C QUESTION 8
    33500	C
 33600		DATA LQSTRT(15),LQEND(15)/BQC8,EQC8/
33700		DATA ((QUEST(I,J),I=1,12),J=BQC8,EQC8)/
  33800		1 'Is the program documented internally well enough for a user',
  33900		1 'to make minor changes easily if necessary?',3*0/
34000	C
 34100	C	CATEGORY C QUESTION 9
    34200	C
      34300		DATA LQSTRT(16),LQEND(16)/BQC9,EQC9/
34400		DATA ((QUEST(I,J),I=1,12),J=BQC9,EQC9)/
  34500		1 'If you have made improvements to the programs or',2*0,
    34600		2 'documentation (if it is machine-readable) which might be ',
    34700		3 'of general use, please attach the changed files as you now',
   34800		4 'have them and a FILCOM between your version and the',0,
   34900		5 'distributed version.',8*0/
  35000	C
 35100	C	CATEGORY D QUESTION 1
    35200	C
 35300		DATA LQSTRT(17),LQEND(17)/BQD1,EQD1/
35400		DATA ((QUEST(I,J),I=1,12),J=BQD1,EQD1)/
                                                                   35500		1 'Does the program provide the same service as programs',0,
 35600		2 'already available on the DECsystem-10? Which ones?',2*0/
  35700	C
 35800	C	CATEGORY D QUESTION 2
    35900	C
 36000		DATA LQSTRT(18),LQEND(18)/BQD2,EQD2/
36100		DATA ((QUEST(I,J),I=1,12),J=BQD2,EQD2)/
  36200		1 'Please enter below any general comments you have about',0,
36300		2 'the program or its documentation.',5*0/
    36400		END
   36500		SUBROUTINE OPNOUT(IREV,NUM)
    36600		DOUBLE PRECISION FILNAM
   36700		N1 = MOD(NUM,10)
36800		N2 = (MOD(NUM,100))/10
    36900		N3 = MOD(NUM,1000)/100
                                            37000		ENCODE(10,1,FILNAM) N3,N2,N1
   37100	1	FORMAT ('DEC',3I1,'.RNO')
37200		OPEN(UNIT=IREV,DEVICE='DSK',FILE=FILNAM,ACCESS='SEQOUT',
37300		1 MODE='ASCII')
 37400		RETURN
37500		END
   
