C     RENBR(JOBTIM/JOBS - TIME ASSIGNMENT PROGRAM)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS PROGRAM IS PART OF THE JOB INTERVIEW REQUEST SYSTEM
C
C     ARRAYS WHICH STORE FIRM NAME, DEPARTMENT AND ADDRESS
      DIMENSION LTRINC(40),LTRDPT(30),LTRADR(30)
C
C     ARRAYS WHICH STORE INFORMATION FOR EACH BLOCK OF INTERVIEWS
      DIMENSION JDATE(150),JFIRST(150),JFINAL(150),JSCHDL(150)
C
C     ARRAYS WHICH STORE INFORMATION FOR EACH RECRUITER
      DIMENSION IWHOM(16,130),MFIRST(130),MFINAL(130)
C
C     ODD STUFF
      DIMENSION LTRTIM(15),IDUMMY(12),JDUMMY(13)
C
C     ARRAYS CONTAINING 1 NUMBER FOR EACH TIME PROFILE
      DIMENSION KNTSLT(50),NUMSLT(50),LNGSLT(50)
C
C     ARRAY CONTAINING 1 NUMBER FOR EACH TIME IN ALL PROFILES
      DIMENSION INI060(500)
C
C     ARRAYS WHICH STORE THE REQUESTS FOR THE CURRENT FIRM.
C     350 IS MAXIMUM NUMBER OF STUDENTS THAT A SINGLE FIRM CAN
C         TALK TO ON ALL THE DAYS IT IS HOLDING INTERVIEWS.
      DIMENSION IPREFR(13,350),KNTPRF(350),LTRSTD(30,350),
     1 NUMSTD(350),KLOCK(350),MTIME(350),MDATE(350),
     2 MRECRT(350),IDATE(350)
C
C     ARRAYS WHICH ARE USED TO PREVENT SCHEDULING CONFLICTS.
C     20  IS MAXIMUM NUMBER OF FIRMS THAT A STUDENT REQUESTING
C         A PARTICULAR FIRM CAN BE TALKING TO ON THE SAME DAYS AS
C         ALL OF THE RECRUITERS FOR THAT FIRM ARE INTERVIEWING.
      DIMENSION KNTINT(350),LNGINT(20,350),INIINT(20,350),
     1 IDAINT(20,350)
C
C     IDENTIFICATION OF A SINGLE STUDENT
C     LTRWHO = THE NAME OF THE ACCOUNT
C     LTRNAM = THE PERSON'S NAME
C     LTRPSW = THE PASSWORD USED BY THE STUDENT
      DIMENSION LTRWHO(40),LTRNAM(30),LTRPSW(20)
C
C     LTRBFR = INPUT/OUTPUT BUFFER
      DIMENSION LTRBFR(80)
C
C     ODD LETTERS
      DATA LTRSPA,LTRMIN/1H ,1H-/
C
C     UNIT NUMBERS FOR TERMINAL AND FILES
      DATA ITTY,IDISK,JDISK,KDISK,LDISK/5,1,20,21,22/
C
C     DIMENSIONS OF ARRAYS CONTAINING CHARACTER INFORMATION
C     LMTINC = NUMBER OF CHARACTERS IN FIRM NAME
C     LMTDPT = NUMBER OF CHARACTERS IN DEPARTMENT
C     LMTADR = NUMBER OF CHARACTERS IN ADDRESS
C     LMTNAM = NUMBER OF CHARACTERS IN STUDENT NAME
C     LMTBFR = NUMBER OF CHARACTERS IN INPUT BUFFER ARRAY
      DATA LMTINC,LMTDPT,LMTADR,LMTNAM,LMTBFR/
     1 40,30,30,30,80/
C
C     DIMENSIONS OF ARRAYS LIMITING SIZE OF CASE HANDLED
C     LMTINT = MAXIMUM NUMBER OF SCHEDULES FOR SINGLE FIRM
C     LMTPRF = MAXIMUM NUMBER OF TIME PREFERENCES SELECTED BY A
C              SINGLE STUDENT
C     LMTTLK = MAXIMUM NUMBER OF STUDENT SINGLE FIRM CAN TALK TO
C     LMTREQ = MAXIMUM NUMBER OF FIRMS THAT ANY 1 STUDENT CAN
C              BE TALKING TO ON THE SAME DAYS AS ALL OF THE
C              RECRUITERS FOR A SINGLE FIRM ARE INTERVIEWING
C     LMTSCH = MAXIMUM NUMBER OF PEOPLE ANY ONE RECRUITER CAN
C              TALK TO IN 1 DAY.  MAXIMUM NUMBER OF TIMES IN 1
C              SCHEDULE.
C     LMTSLT = MAXIMUM NUMBER OF DIFFERENT PROFILES OF INTERVIEW
C              SCHEDULES
C     LMTTIM = MAXIMUM NUMBER OF DIFFERENT TIMES FOR ALL DIFFERENT
C              PROFILES OF INTERVIEW SCHEDULES.
C     LMTLIN = MAXIMUM NUMBER OF RECRUITERS FOR SINGLE FIRM
      DATA LMTINT,LMTPRF,LMTTLK,LMTREQ,LMTSCH,LMTSLT,LMTTIM,LMTLIN/
     1 150,13,350,20,16,50,500,130/
C
C     TELL USER WHAT PROGRAM THIS IS
      WRITE(ITTY,1)
    1 FORMAT(' JOBTIM'/
     1' Assigns job interview time slots'/
     2' The ranking must already have been done'/
     3' ')
C
C     GET CURRENT DATE AND TIME
      CALL TSTAMP(LTRTIM)
C
C     ASK FOR LENGTH OF BREAK BETWEEN INTERVIEWS
    2 WRITE(ITTY,3)
    3 FORMAT(' Student has at least how many minutes b',
     1'etween interviews? ',$)
      READ(ITTY,4)IBREAK
    4 FORMAT(I)
      IF(IBREAK.LT.0)GO TO 2
C
C     ************************************
C     *                                  *
C     *  GET PROFILES OF STARTING TIMES  *
C     *                                  *
C     ************************************
C
      WRITE(ITTY,5)
    5 FORMAT(' ***** Input files *****')
      CALL LCLOPN(3,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL JOBPRO(NUMWHO,KLASS,ITTY,IDISK,
     1 LMTSCH,KNTSLT,LNGSLT,NUMSLT,LMTSLT,MAXSLT,
     2 INI060,LMTTIM,MAXTIM,LTRBFR,LMTBFR)
      CALL LCLCLS(3,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(MAXSLT.LE.0)GO TO 188
C
C     ***************************************************
C     *                                                 *
C     *  ASK FOR USER TO IDENTIFY THE FILES TO BE READ  *
C     *                                                 *
C     ***************************************************
C
C     LOCATE THE ADMINISTRATOR FIRM FILE
      CALL LCLOPN( 5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS( 5,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     LOCATE THE STUDENT DECISION FILE
      CALL LCLOPN( 6,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS( 6,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     ASK FOR NAME OF THE UPDATED STUDENT DECISION FILE TO BE WRITTEN
      WRITE(ITTY,6)
    6 FORMAT(' ***** Output files *****')
      CALL LCLOPN( 8,1,4,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS( 8,1,4,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     ASK FOR NAME OF LISTING FILE
      CALL LCLOPN( 9,1,2,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     **************************************
C     *                                    *
C     *  READ THE ADMINISTRATOR FIRM FILE  *
C     *                                    *
C     **************************************
C
C     INDICATE THAT HAVE NOT BEGUN UPDATE OF STUDENT FILE
      JVERSN=0
C
C     ASK FOR FIRM NUMBER
      GO TO 8
    7 IF(MFIRM.NE.0)GO TO 11
      JFIRM=JFIRM+1
      IF(JFIRM.LE.KFIRM)GO TO 13
    8 WRITE(ITTY,9)
    9 FORMAT(' First and last firm (-1 for all, 0 to exit)? ',$)
      READ(ITTY,10)JFIRM,KFIRM
   10 FORMAT(2I)
      IF(JFIRM.EQ.0)GO TO 218
      MFIRM=0
      IF(JFIRM.LT.0)MFIRM=1
      GO TO 12
   11 IF(MFIRM.GT.KNTINC)GO TO 218
   12 CONTINUE
C
C     EXPUNGE OLD SCRATCH FILES TO MAKE WAY FOR NEW
   13 CALL EXPUNG
C
C     OPEN THE FIRM FILE
      CALL LCLOPN( 5,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     READ FIRST LINE OF FIRM FILE
      READ(IDISK,14)IAUTHR,ICLASS,JMOVE,JPASS,IVERSN,NUMWHO
   14 FORMAT(6I)
      JCLASS=ICLASS
      IF(IAUTHR.LT.1)GO TO 200
      IF(IAUTHR.GT.3)GO TO 200
      IF(IAUTHR.EQ.1)GO TO 202
      READ(IDISK,15)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
   15 FORMAT(8I)
      NOWINC=0
   16 NOWINC=NOWINC+1
      IF(NOWINC.GT.KNTINC)GO TO 25
      READ(IDISK,17)(LTRINC(I),I=1,LMTINC)
      READ(IDISK,18)(LTRDPT(I),I=1,LMTDPT)
      READ(IDISK,19)(LTRADR(I),I=1,LMTADR)
      READ(IDISK,20)NUMBER,
     1LENGTH,KNTOPN,INTRVW,IUSDUP,
     2INCLSD,JNCLSD
   17 FORMAT(40A1)
   18 FORMAT(30A1)
   19 FORMAT(30A1)
   20 FORMAT(7I)
      IF(INTRVW.LE.0)GO TO 23
      IF(INTRVW.GT.LMTINT)GO TO 25
      DO 22 I=1,INTRVW
      READ(IDISK,21)JDATE(I),JFIRST(I),JFINAL(I),JSCHDL(I)
   21 FORMAT(4I)
   22 CONTINUE
   23 IF(MFIRM.EQ.0)GO TO 24
      IF(NOWINC.LT.MFIRM)GO TO 16
      JFIRM=NUMBER
      MFIRM=MFIRM+1
      GO TO 25
   24 IF(JFIRM.NE.NUMBER)GO TO 16
   25 CALL LCLCLS( 5,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(KNTINC.EQ.0)GO TO 196
      IF(INTRVW.GT.LMTINT)GO TO 198
      IF(NOWINC.LE.KNTINC)GO TO 27
      WRITE(ITTY,26)JFIRM
   26 FORMAT(1X,1I5,' is not a firm number')
      GO TO 7
   27 CONTINUE
C
C     *************************************************
C     *                                               *
C     *  CONVERT TIMES OF INTERVIEWS INTO SUBSCRIPTS  *
C     *                                               *
C     *************************************************
C
      IF(INTRVW.EQ.0)GO TO 34
      DO 33 IPERSN=1,INTRVW
      IF(JFIRST(IPERSN).LT.0)GO TO 33
      I=0
      J3045=0
   28 IF(I.GE.MAXSLT)GO TO 210
      I=I+1
      I3045=J3045+1
      J3045=J3045+KNTSLT(I)
      IF(LNGSLT(I).NE.LENGTH)GO TO 28
      IF(NUMSLT(I).NE.JSCHDL(IPERSN))GO TO 28
   29 IF(I3045.GT.J3045)GO TO 212
      IF(INI060(I3045).EQ.JFIRST(IPERSN))GO TO 30
      I3045=I3045+1
      GO TO 29
   30 JFIRST(IPERSN)=I3045
   31 IF(I3045.GT.J3045)GO TO 212
      IF(INI060(I3045).EQ.JFINAL(IPERSN))GO TO 32
      I3045=I3045+1
      GO TO 31
   32 JFINAL(IPERSN)=I3045
   33 CONTINUE
   34 CONTINUE
C
C     ***********************************
C     *                                 *
C     *  READ THE STUDENT REQUEST FILE  *
C     *                                 *
C     ***********************************
C
C     THE STUDENT REQUEST FILE IS READ ONCE FOR EACH FIRM WHICH
C     IS PROCESSED.  A LIST SORTED BY RANK IS KEPT FOR EACH STUDENT
C     WHO GOT AN INTERVIEW FOR THE PRESENT FIRM.  AS WE READ THE
C     INFORMATION FOR A STUDENT, WE PUT THE TIMES AND DATES OF ALL
C     INTERVIEWS WHICH COULD BLOCK A REQUEST FOR THE PRESENT FIRM BY
C     THAT STUDENT AT THE TOP OF THE LIST SINCE IT WILL NOT BE KNOWN
C     UNTIL THE END OF THE INFORMATION FOR THE STUDENT IS REACHED
C     WHETHER THE STUDENT REQUESTED CURRENT FIRM.  THE INFORMATION
C     FOR POSSIBLE BLOCKING FIRMS IS DISCARDED IF THE STUDENT DOES
C     NOT REQUEST THE FIRM, OR IS MOVED INTO THE CORRECT SPOT IF
C     THE STUDENT DID REQUEST THE FIRM.
C
      IF(JVERSN.EQ.0)CALL LCLOPN( 6,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(JVERSN.NE.0)CALL LCLOPN( 8,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     READ THE STUDENTS DECISION FILE
      MSTDNT=0
      KNTSTD=0
   35 KNTSTD=KNTSTD+1
      READ(IDISK,37,END=61)IAUTHR,ICLASS,IMOVE,IPASS,
     1 IVERSN,NUMWHO,LTRPSW
      IF(IAUTHR.LT.11)GO TO 204
      IF(IAUTHR.GT.15)GO TO 204
      IF(ICLASS.NE.JCLASS)GO TO 208
      IF(IAUTHR.EQ.13)GO TO 36
      IF(JVERSN.NE.0)GO TO 206
      IF(IAUTHR.EQ.12)GO TO 36
      GO TO 206
   36 CONTINUE
      READ(IDISK,38)ISUBMT,IUSED,KNTSIN,LOCKUP,IMANNR,KNTALL,IGVBAK
   37 FORMAT(6I,20A1)
   38 FORMAT(7I)
      READ(IDISK,39)LTRWHO
   39 FORMAT(40A1)
      READ(IDISK,40)LTRNAM
   40 FORMAT(30A1)
      IF(KNTSIN.LE.0)GO TO 59
C
C     STORE THE STUDENT NAME (WILL OVERWRITE IF NOT USED)
      KNTMJR=0
   41 KNTMJR=KNTMJR+1
      IF(KNTMJR.GT.MSTDNT)GO TO 42
      IF(NUMSTD(KNTMJR).NE.0)GO TO 41
      GO TO 43
   42 MSTDNT=KNTMJR
      IF(MSTDNT.GT.LMTTLK)GO TO 192
   43 KNTINT(KNTMJR)=0
      NUMSTD(KNTMJR)=0
C
C     READ THE INFORMATION FOR REQUESTED INTERVIEWS
      DO 58 KOMPNY=1,KNTSIN
      READ(IDISK,44)IDUMMY
   44 FORMAT(12I)
C     LOCATIONS OF VARIABLES IN THE IDUMMY ARRAY
C          1      2      3      4      5      6      7
C     NUMVOT,KNDVOT,KNTPRF, IDATE,KLOSED, IRANK, JRANK,
C          8      9     10     11     12
C      KLOCK, MTIME, MDATE,MRECRT,ISOURC
C
      LIMIT=IDUMMY(3)
      IF(LIMIT.GT.0)READ(IDISK,45)(JDUMMY(I),I=1,LIMIT)
C     IF(LIMIT.GT.0)READ(IDISK,44)(IPREFR(I,KOMPNY),I=1,LIMIT)
   45 FORMAT(13I)
C
C     CHECK FOR OTHER INTERVIEWS ON SAME DAYS AS THIS FIRM
      IF(IDUMMY(8).EQ.0)GO TO 48
      IF(IDUMMY(11).LE.0)GO TO 48
      IF(INTRVW.EQ.0)GO TO 48
      IF(JFIRM.EQ.IDUMMY(1))GO TO 48
      DO 46 I=1,INTRVW
      IF(JDATE(I).LT.0)GO TO 46
      IF(JFIRST(I).LT.0)GO TO 46
      IF(JDATE(I).EQ.IDUMMY(10))GO TO 47
   46 CONTINUE
      GO TO 48
   47 KNTINT(KNTMJR)=KNTINT(KNTMJR)+1
      I=KNTINT(KNTMJR)
      IF(I.GT.LMTREQ)GO TO 194
      IDAINT(I,KNTMJR)=IDUMMY(10)
      LNGINT(I,KNTMJR)=IDUMMY(8)
      INIINT(I,KNTMJR)=IDUMMY(9)
   48 CONTINUE
C
C     CHECK IF THIS IS REQUEST FOR THE FIRM BEING SCHEDULED
      IF(ISUBMT.EQ.4)GO TO 57
      IF(JFIRM.NE.IDUMMY(1))GO TO 57
C     REJECT IF ON CLOSED LIST OR CANCELLED BY STUDENT OR FIRM
      IF(IDUMMY(5).NE.0)GO TO 57
C     KEEP IF PREVIOUSLY ASSIGNED INTERVIEW EVEN IF SCHEDULE CANCELLED
      IF(IDUMMY(8).NE.0)GO TO 49
C     REJECT IF ON WAITING LIST
      IF(IDUMMY(7).GT.KNTOPN)GO TO 57
      IF(IDUMMY(7).EQ.0)GO TO 57
   49 CONTINUE
C
C     MOVE INFORMATION ABOUT INTERVIEW TIMES TO SORTED LOCATION
      NOWSTD=KNTMJR
      KNTMJR=IDUMMY(7)
      IF(KNTMJR.GT.LMTTLK)GO TO 192
   50 IF(MSTDNT.GE.KNTMJR)GO TO 51
      MSTDNT=MSTDNT+1
      NUMSTD(MSTDNT)=0
      GO TO 50
   51 KNTINT(KNTMJR)=KNTINT(NOWSTD)
      LIMIT=KNTINT(NOWSTD)
      IF(LIMIT.LE.0)GO TO 53
      DO 52 I=1,LIMIT
      IDAINT(I,KNTMJR)=IDAINT(I,NOWSTD)
      LNGINT(I,KNTMJR)=LNGINT(I,NOWSTD)
      INIINT(I,KNTMJR)=INIINT(I,NOWSTD)
   52 CONTINUE
   53 CONTINUE
C
C     STORE STUDENT NAME, NUMBER, PREFERRED TIMES
      DO 54 I=1,LMTNAM
      LTRSTD(I,KNTMJR)=LTRNAM(I)
   54 CONTINUE
      NUMSTD(KNTMJR)=KNTSTD
      KNTPRF(KNTMJR)=IDUMMY(3)
      IDATE(KNTMJR)=IDUMMY(4)
      KLOCK(KNTMJR)=IDUMMY(8)
      MTIME(KNTMJR)=IDUMMY(9)
      MDATE(KNTMJR)=IDUMMY(10)
      MRECRT(KNTMJR)=IDUMMY(11)
      LIMIT=KNTPRF(KNTMJR)
      IF(LIMIT.EQ.0)GO TO 56
      DO 55 I=1,LIMIT
      IPREFR(I,KNTMJR)=JDUMMY(I)
   55 CONTINUE
   56 CONTINUE
   57 CONTINUE
   58 CONTINUE
   59 READ(IDISK,60)LTREND
   60 FORMAT(1A1)
      IF(LTREND.NE.LTRMIN)GO TO 190
      GO TO 35
C
C     ALL DONE READING STUDENT DECISIONS
   61 IF(JVERSN.EQ.0)CALL LCLCLS( 6,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(JVERSN.NE.0)CALL LCLCLS( 8,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(MSTDNT.EQ.0)GO TO 62
      IF(NUMSTD(MSTDNT).EQ.0)MSTDNT=MSTDNT-1
   62 KNTSTD=KNTSTD-1
      WRITE(ITTY,63)JFIRM,MSTDNT
   63 FORMAT(' Firm',1I4,' interviewing',1I5,' students')
C
C     ***************************
C     *                         *
C     *  MAKE TIME ASSIGNMENTS  *
C     *                         *
C     ***************************
C
C     FIND MAXIMUM NUMBER OF INTERVIEWS IN ANY 1 SCHEDULE
C     L3045  = TOTAL SCHEDULES INCLUDING CANCELLED ONES
C     M3045  = MAXIMUM INTERVIEWS IN ANY 1 SCHEDULE
C     N3045  = NUMBER OF SCHEDULES NOT CANCELLED
      L3045=0
      NOWREQ=0
   64 NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.INTRVW)GO TO 65
      IF(JDATE(NOWREQ).GE.0)L3045=L3045+1
      GO TO 64
   65 CONTINUE
      M3045=0
      N3045=0
      NOWREQ=0
   66 NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.INTRVW)GO TO 68
      IF(JFIRST(NOWREQ).LT.0)GO TO 66
      IF(JDATE(NOWREQ).LT.0)GO TO 67
      J=0
      N3045=N3045+1
      IF(N3045.GT.LMTLIN)GO TO 216
   67 J=J+JFINAL(NOWREQ)-JFIRST(NOWREQ)+1
      IF(M3045.LT.J)M3045=J
      GO TO 66
   68 CONTINUE
      IF(M3045.GT.LMTSCH)GO TO 214
C
C     MARK IF SLOTS ARE AVAILABLE OR NOT INITIALLY
C     IWHOM  = -2 FOR SLOTS EARLIER OR LATER OR SKIPPED IN SCHEDULE
C            = -1 FOR SCHEDULES WHICH ARE NOT NECESSARY
C            = 0 FOR SLOTS WHICH CAN BE ALLOCATED
C
      NSTDNT=0
      NOWREQ=0
      NOWLIN=0
   69 NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.INTRVW)GO TO 74
      IF(JFIRST(NOWREQ).LT.0)GO TO 69
      NOWLIN=NOWLIN+1
      DO 70 I=1,M3045
      IWHOM(I,NOWLIN)=-2
   70 CONTINUE
      NBEGIN=JFIRST(NOWREQ)
      MFIRST(NOWLIN)=NOWREQ
      LSTDNT=0
   71 IBEGIN=JFIRST(NOWREQ)
      IEND=JFINAL(NOWREQ)
      MFINAL(NOWLIN)=NOWREQ
      LSTDNT=LSTDNT+IEND-IBEGIN+1
      DO 72 I=IBEGIN,IEND
      J=I-NBEGIN+1
      IWHOM(J,NOWLIN)=0
      IF(NSTDNT.GE.MSTDNT)IWHOM(J,NOWLIN)=-1
   72 CONTINUE
      IF(NOWREQ.GE.INTRVW)GO TO 73
      IF(JDATE(NOWREQ+1).GE.0)GO TO 73
      NOWREQ=NOWREQ+1
      GO TO 71
   73 NSTDNT=NSTDNT+LSTDNT
      GO TO 69
   74 CONTINUE
      IF(MSTDNT.EQ.0)GO TO 125
C
C     INSERT THOSE ALREADY ASSIGNED IN PREVIOUS MOVES
      DO 80 NOWSTD=1,MSTDNT
      IF(NUMSTD(NOWSTD).EQ.0)GO TO 80
      IF(KLOCK(NOWSTD).EQ.0)GO TO 80
      IF(MRECRT(NOWSTD).LE.0)GO TO 80
      IF(KLOCK(NOWSTD).NE.LENGTH)GO TO 79
      NOWLIN=0
      NOWREQ=0
      NOWLCL=0
   75 NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.INTRVW)GO TO 79
      NOWLCL=NOWLCL+1
      IF(JFIRST(NOWREQ).LT.0)GO TO 75
      NOWLIN=NOWLIN+1
   76 IF(NOWREQ.GE.INTRVW)GO TO 77
      IF(JDATE(NOWREQ+1).GE.0)GO TO 77
      NOWREQ=NOWREQ+1
      GO TO 76
   77 IF(NOWLCL.NE.MRECRT(NOWSTD))GO TO 75
      ILIMIT=MFIRST(NOWLIN)
      IF(JDATE(ILIMIT).NE.MDATE(NOWSTD))GO TO 79
      ILIMIT=JFIRST(ILIMIT)
      JLIMIT=MFINAL(NOWLIN)
      JLIMIT=JFINAL(JLIMIT)
      DO 78 ITIME=ILIMIT,JLIMIT
      IF(INI060(ITIME).NE.MTIME(NOWSTD))GO TO 78
      J=ITIME-ILIMIT+1
      IF(IWHOM(J,NOWLIN).NE.0)GO TO 79
      IWHOM(J,NOWLIN)=NOWSTD
      MRECRT(NOWSTD)=NOWLIN
      GO TO 80
   78 CONTINUE
C
C     IF INTERVIEW NO LONGER SCHEDULED, PREVENT IT BLOCKING NEW ONE
   79 MRECRT(NOWSTD)=-1
      MDATE(NOWSTD)=0
      MTIME(NOWSTD)=0
   80 CONTINUE
      IF(KNTOPN.EQ.0)GO TO 119
C
C     ASSIGN INTERVIEWS IF ASK FOR TIMES OR FOR DATE AND TIMES
      DO 88 NOWPRF=1,LMTPRF
      DO 87 NOWSTD=1,MSTDNT
      IF(NUMSTD(NOWSTD).EQ.0)GO TO 87
      IF(MRECRT(NOWSTD).GT.0)GO TO 87
      IF(KNTPRF(NOWSTD).LT.NOWPRF)GO TO 87
      JTIME=IPREFR(NOWPRF,NOWSTD)
      DO 86 NOWREQ=1,N3045
      ILIMIT=MFIRST(NOWREQ)
      KDATE=JDATE(ILIMIT)
      IF(IDATE(NOWSTD).EQ.0)GO TO 81
      IF(KDATE.NE.IDATE(NOWSTD))GO TO 86
   81 ILIMIT=JFIRST(ILIMIT)
      JLIMIT=MFINAL(NOWREQ)
      JLIMIT=JFINAL(JLIMIT)
      ITIME=1
   82 IF(JTIME.EQ.INI060(ILIMIT))GO TO 83
      ILIMIT=ILIMIT+1
      ITIME=ITIME+1
      IF(ILIMIT.LE.JLIMIT)GO TO 82
      GO TO 86
   83 IF(IWHOM(ITIME,NOWREQ).NE.0)GO TO 86
C
C     CHECK FOR BLOCKAGE BY PREVIOUSLY SCHEDULED INTERVIEW
      J=KNTINT(NOWSTD)
      IF(J.EQ.0)GO TO 85
      DO 84 I=1,J
      IF(IDAINT(I,NOWSTD).NE.KDATE)GO TO 84
      KTIME=INIINT(I,NOWSTD)+LNGINT(I,NOWSTD)+IBREAK
      IF(JTIME.GE.KTIME)GO TO 84
      KTIME=JTIME+LENGTH+IBREAK
      IF(KTIME.LE.INIINT(I,NOWSTD))GO TO 84
      GO TO 86
   84 CONTINUE
C
C     CAN SCHEDULE INTERVIEW
   85 IWHOM(ITIME,NOWREQ)=NOWSTD
      MRECRT(NOWSTD)=NOWREQ
      MDATE(NOWSTD)=-KDATE
      MTIME(NOWSTD)=JTIME
      GO TO 87
   86 CONTINUE
   87 CONTINUE
   88 CONTINUE
C
C     ASSIGN INTERVIEWS IF DON'T ASK FOR SPECIFIC TIMES
C     IASIGN = 1, IF ASK FOR DATE OR FOR DATE AND TIMES BUT TIMES
C              WERE ALL BLOCKED
C            = 2, IF COULD NOT ASSIGN AT ALL BEFORE THIS OR IF
C              DID NOT ASK FOR ANY DATE OR TIMES
      DO 96 IASIGN=1,2
      DO 95 NOWSTD=1,MSTDNT
      IF(NUMSTD(NOWSTD).EQ.0)GO TO 95
      IF(MRECRT(NOWSTD).GT.0)GO TO 95
      IF(IASIGN.EQ.2)GO TO 89
      IF(IDATE(NOWSTD).EQ.0)GO TO 95
   89 DO 94 NOWREQ=1,N3045
      KLIMIT=MFIRST(NOWREQ)
      KDATE=JDATE(KLIMIT)
      IF(IASIGN.EQ.2)GO TO 90
      IF(KDATE.NE.IDATE(NOWSTD))GO TO 94
   90 KLIMIT=JFIRST(KLIMIT)
      JLIMIT=MFINAL(NOWREQ)
      JLIMIT=JFINAL(JLIMIT)
      NTIME=0
      DO 93 ITIME=KLIMIT,JLIMIT
      NTIME=NTIME+1
      IF(IWHOM(NTIME,NOWREQ).NE.0)GO TO 93
      JTIME=INI060(ITIME)
C
C     CHECK FOR BLOCKAGE BY PREVIOUSLY SCHEDULED INTERVIEW
      J=KNTINT(NOWSTD)
      IF(J.EQ.0)GO TO 92
      DO 91 I=1,J
      IF(IDAINT(I,NOWSTD).NE.KDATE)GO TO 91
      KTIME=INIINT(I,NOWSTD)+LNGINT(I,NOWSTD)+IBREAK
      IF(JTIME.GE.KTIME)GO TO 91
      KTIME=JTIME+LENGTH+IBREAK
      IF(KTIME.LE.INIINT(I,NOWSTD))GO TO 91
      GO TO 93
   91 CONTINUE
C
C     CAN SCHEDULE INTERVIEW
   92 IWHOM(NTIME,NOWREQ)=NOWSTD
      MRECRT(NOWSTD)=NOWREQ
      MDATE(NOWSTD)=-KDATE
      MTIME(NOWSTD)=JTIME
      GO TO 95
   93 CONTINUE
   94 CONTINUE
   95 CONTINUE
   96 CONTINUE
C
C     ******************************************
C     *                                        *
C     *  ATTEMPT TO ASSIGN BLOCKED INTERVIEWS  *
C     *                                        *
C     ******************************************
C
C     CHECK IF FIT IS COMPLETE
      NOWSTD=0
      KNTBAD=0
   97 NOWSTD=NOWSTD+1
      IF(NOWSTD.GT.MSTDNT)GO TO 120
      IF(NUMSTD(NOWSTD).EQ.0)GO TO 97
      IF(MRECRT(NOWSTD).GT.0)GO TO 97
      WRITE(ITTY,98)NOWSTD
   98 FORMAT(' attempt to fit student',1I4)
      DO 99 I=1,N3045
      WRITE(ITTY,116)(IWHOM(J,I),J=1,M3045)
   99 CONTINUE
C
C     CHECK FOR A SLOT WHICH IS NOT BLOCKED FOR STUDENT
      MCHPRF=0
      DO 113 NTIME=1,M3045
      DO 112 NOWREQ=1,N3045
      MOVSTD=IWHOM(NTIME,NOWREQ)
      IF(MOVSTD.LE.0)GO TO 112
      IF(MDATE(MOVSTD).GT.0)GO TO 112
      ILIMIT=MFIRST(NOWREQ)
      ILIMIT=JFIRST(ILIMIT)
      JTIME=ILIMIT+NTIME-1
      JTIME=INI060(JTIME)
C
C     CHECK FOR BLOCKAGE BY PREVIOUSLY SCHEDULED INTERVIEW
      J=KNTINT(NOWSTD)
      IF(J.EQ.0)GO TO 101
      DO 100 I=1,J
      ILIMIT=MFIRST(NOWREQ)
      IF(IDAINT(I,NOWSTD).NE.JDATE(ILIMIT))GO TO 100
      KTIME=INIINT(I,NOWSTD)+LNGINT(I,NOWSTD)+IBREAK
      IF(JTIME.GE.KTIME)GO TO 100
      KTIME=JTIME+LENGTH+IBREAK
      IF(KTIME.LE.INIINT(I,NOWSTD))GO TO 100
      GO TO 112
  100 CONTINUE
C
C     CHECK IF STUDENT ALREADY IN SLOT CAN BE RESCHEDULED
  101 DO 111 MOVLIN=1,N3045
      DO 110 MOVCLM=1,M3045
      IF(IWHOM(MOVCLM,MOVLIN).NE.0)GO TO 110
      ILIMIT=MFIRST(MOVLIN)
      KDATE=JDATE(ILIMIT)
      ILIMIT=JFIRST(ILIMIT)
      JTIME=ILIMIT+MOVCLM-1
      JTIME=INI060(JTIME)
C
C     CHECK FOR BLOCKAGE BY PREVIOUSLY SCHEDULED INTERVIEW
      J=KNTINT(MOVSTD)
      IF(J.EQ.0)GO TO 103
      DO 102 I=1,J
      IF(IDAINT(I,MOVSTD).NE.KDATE)GO TO 102
      KTIME=INIINT(I,MOVSTD)+LNGINT(I,MOVSTD)+IBREAK
      IF(JTIME.GE.KTIME)GO TO 102
      KTIME=JTIME+LENGTH+IBREAK
      IF(KTIME.LE.INIINT(I,MOVSTD))GO TO 102
      GO TO 110
  102 CONTINUE
C
C     FIND THE DESTINATION TIME ON PREFERENCE LIST
C     ASSIGN STUDENT FOR WHOM RESULT IS HIGHEST ON LIST
  103 IF(IDATE(MOVSTD).EQ.0)GO TO 104
      IF(KDATE.NE.IDATE(MOVSTD))GO TO 106
  104 I=KNTPRF(MOVSTD)
      J=0
  105 J=J+1
      IF(J.GT.I)GO TO 107
      IF(JTIME.EQ.IPREFR(J,MOVSTD))GO TO 108
      GO TO 105
  106 J=LMTPRF+2
      GO TO 108
  107 J=LMTPRF+1
  108 IF(MCHPRF.EQ.0)GO TO 109
      IF(J.GE.MCHPRF)GO TO 110
  109 MCHPRF=J
      MCHSTD=MOVSTD
      MOVONE=MOVCLM
      MOVTWO=MOVLIN
      MOVTHR=NTIME
      MOVFOU=NOWREQ
      MOVTIM=JTIME
      MOVDAT=KDATE
      IF(MCHPRF.EQ.1)GO TO 114
  110 CONTINUE
  111 CONTINUE
  112 CONTINUE
  113 CONTINUE
C
C     SCHEDULE THE BEST INTERVIEW
      IF(MCHPRF.EQ.0)GO TO 118
  114 IWHOM(MOVONE,MOVTWO)=MCHSTD
      IWHOM(MOVTHR,MOVFOU)=NOWSTD
      MDATE(NOWSTD)=MDATE(MCHSTD)
      MDATE(MCHSTD)=-MOVDAT
      MTIME(NOWSTD)=MTIME(MCHSTD)
      MTIME(MCHSTD)=MOVTIM
      MRECRT(NOWSTD)=MRECRT(MCHSTD)
      MRECRT(MCHSTD)=MOVTWO
      WRITE(ITTY,115)MCHSTD,NOWSTD
  115 FORMAT(' Moving student',1I5,' to make room for',1I5)
      DO 117 I=1,N3045
      WRITE(ITTY,116)(IWHOM(J,I),J=1,M3045)
  116 FORMAT(1X,16I5)
  117 CONTINUE
      GO TO 97
  118 KNTBAD=KNTBAD+1
      GO TO 97
  119 KNTBAD=MSTDNT
  120 IF(KNTBAD.EQ.0)GO TO 125
      WRITE(ITTY,121)
  121 FORMAT(' *********************************************',
     1'**********************'/' ***',61X,'***')
      WRITE(ITTY,122)KNTBAD
  122 FORMAT(' *** Interview times could not be assigned for',
     11I5,' students     ***')
      I=MSTDNT-KNTOPN
      IF(I.GT.0)WRITE(ITTY,123)I
  123 FORMAT(' ***',1I6,' of these were promised intervi',
     1'ews in an earlier stage ***'/' ***       but cann',
     2'ot be fitted into currently reduced schedules ***')
      WRITE(ITTY,124)
  124 FORMAT(' ***',61X,'***'/' ************************',
     1'*******************************************')
      GO TO 127
  125 WRITE(ITTY,126)
  126 FORMAT(' OK')
  127 CONTINUE
C
C     ***********************************
C     *                                 *
C     *  COPY THE STUDENT REQUEST FILE  *
C     *                                 *
C     ***********************************
C
      IF(JVERSN.EQ.0)CALL LCLOPN( 6,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(JVERSN.NE.0)CALL LCLOPN( 8,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLOPN( 8,0,4,ITTY,IDISK,JDISK,KDISK,LDISK)
      DO 153 NOWSTD=1,KNTSTD
C
C     CHECK IF THIS IS ONE OF STUDENTS GETTING INTERVIEW
      IWRITE=0
      IF(MSTDNT.EQ.0)GO TO 129
      DO 128 I=1,MSTDNT
      IF(NUMSTD(I).NE.NOWSTD)GO TO 128
      IWRITE=I
      GO TO 129
  128 CONTINUE
  129 CONTINUE
C
C     COPY HEADER INFORMATION
      READ(IDISK,130)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,
     1 NUMWHO,LTRPSW
      READ(IDISK,131)ISUBMT,IUSED,KNTSIN,LOCKUP,MANNER,KNTALL,IGVBAK
  130 FORMAT(6I,20A1)
  131 FORMAT(7I)
      IAUTHR=13
      WRITE(LDISK,132)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,
     1 NUMWHO,LTRPSW
      WRITE(LDISK,133)ISUBMT,IUSED,KNTSIN,LOCKUP,MANNER,KNTALL,IGVBAK
  132 FORMAT(5I6,1I7,1X,20A1)
  133 FORMAT(1I6,1I10,4I6,1I10)
      READ(IDISK,134)LTRWHO
  134 FORMAT(40A1)
      WRITE(LDISK,135)LTRWHO
  135 FORMAT(40A1)
      READ(IDISK,136)LTRNAM
  136 FORMAT(30A1)
      WRITE(LDISK,137)LTRNAM
  137 FORMAT(30A1)
C
C     COPY INTERVIEW REQUESTS
      IF(KNTSIN.LE.0)GO TO 150
      DO 149 KOMPNY=1,KNTSIN
      READ(IDISK,138)IDUMMY
  138 FORMAT(12I)
C
C     INSERT SCHEDULE INFO IF STUDENT GETS INTERVIEW FOR THIS FIRM
      IF(IWRITE.EQ.0)GO TO 144
      IF(ISUBMT.EQ.4)GO TO 144
      IF(IDUMMY(1).NE.JFIRM)GO TO 144
C     REJECT IF CANCELLED OR REJECTED AS THIS FIRM COULD APPEAR AGAIN
      IF(IDUMMY(5).NE.0)GO TO 144
C     KEEP IF PREVIOUSLY ASSIGNED INTERVIEW EVEN IF SCHEDULE CANCELLED
      IF(IDUMMY(8).NE.0)GO TO 139
C     REJECT IF ON WAITING LIST (THIS TEST NOT NECESSARY)
      IF(IDUMMY(7).GT.KNTOPN)GO TO 144
      IF(IDUMMY(7).EQ.0)GO TO 144
  139 CONTINUE
      IDUMMY(8)=LENGTH
      IDUMMY(9)=MTIME(IWRITE)
      IF(MDATE(IWRITE).LT.0)MDATE(IWRITE)=-MDATE(IWRITE)
      IDUMMY(10)=MDATE(IWRITE)
      IF(MRECRT(IWRITE).LE.0)GO TO 142
      NOWLIN=0
      NOWREQ=0
      NOWLCL=0
  140 NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.INTRVW)GO TO 143
      NOWLCL=NOWLCL+1
      IF(JFIRST(NOWREQ).LT.0)GO TO 140
      NOWLIN=NOWLIN+1
      IF(NOWLIN.EQ.MRECRT(IWRITE))GO TO 143
  141 IF(NOWREQ.GE.INTRVW)GO TO 140
      IF(JDATE(NOWREQ+1).GE.0)GO TO 140
      NOWREQ=NOWREQ+1
      GO TO 141
  142 NOWLCL=MRECRT(IWRITE)
  143 IDUMMY(11)=NOWLCL
      IWRITE=0
  144 CONTINUE
C
C     WRITE THE INFORMATION BACK TO FILE
      WRITE(LDISK,145)IDUMMY
  145 FORMAT(1I6,1I10,10I6)
      LIMIT=IDUMMY(3)
      IF(LIMIT.EQ.0)GO TO 148
      READ(IDISK,146)(JDUMMY(I),I=1,LIMIT)
  146 FORMAT(13I)
      WRITE(LDISK,147)(JDUMMY(I),I=1,LIMIT)
  147 FORMAT(13I6)
  148 CONTINUE
  149 CONTINUE
  150 READ(IDISK,151)LTREND
  151 FORMAT(1A1)
      WRITE(LDISK,152)LTREND
  152 FORMAT(1A1)
  153 CONTINUE
      IF(JVERSN.EQ.0)CALL LCLCLS( 6,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      IF(JVERSN.NE.0)CALL LCLCLS( 8,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS( 8,0,4,ITTY,IDISK,JDISK,KDISK,LDISK)
      JVERSN=1
C
C     **********************************************
C     *                                            *
C     *  WRITE LISTING OF SCHEDULES FOR THIS FIRM  *
C     *                                            *
C     **********************************************
C
      IF(MSTDNT.NE.0)GO TO 154
      IF(KNTOPN.EQ.0)GO TO 182
  154 NOWREQ=0
      NOWLIN=0
      NOWLCL=0
  155 NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.INTRVW)GO TO 172
      NOWLCL=NOWLCL+1
      IF(JFIRST(NOWREQ).LT.0)GO TO 155
      NOWLIN=NOWLIN+1
      KNTLIN=-1
      ILIMIT=MFIRST(NOWLIN)
      ILIMIT=JFIRST(ILIMIT)
      JLIMIT=MFINAL(NOWLIN)
      JLIMIT=JFINAL(JLIMIT)
      NTIME=0
      DO 167 ITIME=ILIMIT,JLIMIT
      NTIME=NTIME+1
      IF(IWHOM(NTIME,NOWLIN).EQ.-2)GO TO 167
      IF(KNTLIN.GT.0)GO TO 161
      IF(KNTLIN.EQ.0)WRITE(JDISK,156)JCLASS,JMOVE,JPASS,LTRTIM
  156 FORMAT(1X/
     1' Class',1I5,', Round',1I3,', Stage',1I3,' (printed ',15A1,')')
      WRITE(JDISK,157)JFIRM,(LTRINC(I),I=1,LMTINC)
      LOWBFR=0
      ISMITH=JDATE(NOWREQ)
      CALL DAWHEN(ISMITH,JDAY,JMONTH,JYEAR,LTRBFR,LOWBFR,LMTBFR)
      WRITE(JDISK,158)(LTRBFR(I),I=1,9),(LTRDPT(I),I=1,LMTDPT)
      WRITE(JDISK,159)(LTRADR(I),I=1,LMTADR)
  157 FORMAT('1Code:',1I10,' Firm: ',40A1)
  158 FORMAT(' Date: ',9A1,' Dept: ',40A1)
  159 FORMAT(' ',15X,' Adrs: ',40A1)
      WRITE(JDISK,160)NOWLCL,L3045
  160 FORMAT(1X/' Open schedule',1I3,' of',1I3/1X)
C     FULL NUMBER OF LINES ON PAGE
      KNTLIN=62
C     REDUCE FOR HEADER
      KNTLIN=KNTLIN-6
C     REDUCE FOR TRAILER
      KNTLIN=KNTLIN-2
  161 KNTLIN=KNTLIN-2
      JTIME=INI060(ITIME)
      JTIME=40*(JTIME/60) + JTIME
      LOWBFR=0
      CALL DAHOUR(JTIME,1,0,1,LTRBFR,LMTBFR,LOWBFR,IERROR)
      J=IWHOM(NTIME,NOWLIN)
      IF(J.LE.0)GO TO 165
      K=LMTNAM
  162 IF(LTRSTD(K,J).NE.LTRSPA)GO TO 163
      K=K-1
      IF(K.GT.1)GO TO 162
  163 WRITE(JDISK,164)(LTRBFR(I),I=1,8),(LTRSTD(I,J),I=1,K)
  164 FORMAT(1X/1X,8A1,2X,60A1)
      GO TO 167
  165 WRITE(JDISK,166)(LTRBFR(I),I=1,8)
  166 FORMAT(1X/1X,8A1,'  .  .  .  .  .  .  .')
  167 CONTINUE
  168 IF(KNTLIN.LE.0)GO TO 170
      WRITE(JDISK,169)
  169 FORMAT(1X)
      KNTLIN=KNTLIN-1
      GO TO 168
  170 WRITE(JDISK,156)JCLASS,JMOVE,JPASS,LTRTIM
  171 IF(NOWREQ.GE.INTRVW)GO TO 155
      IF(JDATE(NOWREQ+1).GE.0)GO TO 155
      NOWREQ=NOWREQ+1
      GO TO 171
C
C     LIST UNSCHEDULABLE INTERVIEWS
  172 IF(MSTDNT.EQ.0)GO TO 187
      LIMIT=0
      DO 173 NOWSTD=1,MSTDNT
      IF(NUMSTD(NOWSTD).EQ.0)GO TO 173
      IF(MRECRT(NOWSTD).LE.0)LIMIT=LIMIT+1
  173 CONTINUE
      IF(LIMIT.EQ.0)GO TO 187
      NOWSTD=0
      KNTLIN=-1
      DO 179 NEWLIN=1,LIMIT
      IF(KNTLIN.GT.0)GO TO 175
      IF(KNTLIN.EQ.0)WRITE(JDISK,156)JCLASS,JMOVE,JPASS,LTRTIM
      WRITE(JDISK,157)JFIRM,(LTRINC(I),I=1,LMTINC)
      WRITE(JDISK,183)(LTRDPT(I),I=1,LMTDPT)
      WRITE(JDISK,159)(LTRADR(I),I=1,LMTADR)
      WRITE(JDISK,174)
  174 FORMAT(1X/
     1' Following students could not be scheduled'/
     21X)
      KNTLIN=62
C     REDUCE FOR HEADER
      KNTLIN=KNTLIN-6
C     REDUCE FOR TRAILER
      KNTLIN=KNTLIN-2
  175 KNTLIN=KNTLIN-1
  176 NOWSTD=NOWSTD+1
      IF(NOWSTD.GT.MSTDNT)GO TO 179
      IF(NUMSTD(NOWSTD).EQ.0)GO TO 176
      IF(MRECRT(NOWSTD).GT.0)GO TO 176
      IF(MRECRT(NOWSTD).EQ.0)WRITE(JDISK,177)
     1 (LTRSTD(I,NOWSTD),I=1,LMTNAM)
      IF(MRECRT(NOWSTD).LT.0)WRITE(JDISK,178)
     1 (LTRSTD(I,NOWSTD),I=1,LMTNAM)
  177 FORMAT(' Scheduling confict: ',60A1)
  178 FORMAT(' Cancelled Schedule: ',60A1)
  179 CONTINUE
  180 IF(KNTLIN.LE.0)GO TO 181
      KNTLIN=KNTLIN-1
      WRITE(JDISK,169)
      GO TO 180
  181 WRITE(JDISK,156)JCLASS,JMOVE,JPASS,LTRTIM
      GO TO 187
C
C     LIST A FIRM WHICH HAS CANCELLED
  182 KNTLIN=0
      WRITE(JDISK,157)JFIRM,(LTRINC(I),I=1,LMTINC)
      WRITE(JDISK,183)(LTRDPT(I),I=1,LMTDPT)
  183 FORMAT(' Date: ',9X,' Dept: ',40A1)
      WRITE(JDISK,159)(LTRADR(I),I=1,LMTADR)
      KNTLIN=KNTLIN+3
      WRITE(JDISK,184)
  184 FORMAT(1X/' This company has cancelled its interview schedule')
      KNTLIN=KNTLIN+2
  185 IF(KNTLIN.GE.60)GO TO 186
      WRITE(JDISK,169)
      KNTLIN=KNTLIN+1
      GO TO 185
  186 WRITE(JDISK,156)JCLASS,JMOVE,JPASS,LTRTIM
      GO TO 187
C
C     DONE WITH FIRM PORTION OF LISTING
  187 GO TO 7
C
C     ********************
C     *                  *
C     *  ERROR MESSAGES  *
C     *                  *
C     ********************
C
C     VARIOUS ERROR MESSAGES
  188 WRITE(ITTY,189)
  189 FORMAT(' Error in contents of schedule profile file')
      GO TO 220
  190 WRITE(ITTY,191)
  191 FORMAT(' Student information does not end in -')
      GO TO 218
  192 WRITE(ITTY,193)JFIRM
  193 FORMAT(' Too many students have interviews with firm',1I4)
      GO TO 218
  194 WRITE(ITTY,195)JFIRM,JFIRM
  195 FORMAT(' Students requesting firm',1I4,' have too ',
     1'many interviews with other firms on same days firm',
     21I4,' is interviewing')
      GO TO 218
  196 WRITE(ITTY,197)
  197 FORMAT(' No firms are recruiting')
      GO TO 218
  198 WRITE(ITTY,199)NUMBER,INTRVW,LMTINT
  199 FORMAT(' Firm',1I4,' with',1I4,
     1' schedules is above limit of',1I4,' schedules')
      GO TO 218
  200 WRITE(ITTY,201)
  201 FORMAT(' Input file is not a firm file')
      GO TO 218
  202 WRITE(ITTY,203)
  203 FORMAT(' Firm file not processed by ranking program')
      GO TO 218
  204 WRITE(ITTY,205)
  205 FORMAT(' Input file is not a student decision file')
      GO TO 218
  206 WRITE(ITTY,207)
  207 FORMAT(' Student decision file written by wrong program')
      GO TO 218
  208 WRITE(ITTY,209)
  209 FORMAT(' Student decision file for wrong class')
      GO TO 218
  210 WRITE(ITTY,211)
  211 FORMAT(' Firm file references unknown schedule profile')
      GO TO 218
  212 WRITE(ITTY,213)
  213 FORMAT(' Firm file contains time not in profile')
      GO TO 218
  214 WRITE(ITTY,215)JFIRM
  215 FORMAT(' Individual schedule in firm',1I4,
     1' contains too many interviews')
      GO TO 218
  216 WRITE(ITTY,217)JFIRM
  217 FORMAT(' Firm',1I4,' has too many recruiters')
      GO TO 218
  218 WRITE(JDISK,219)
  219 FORMAT(1H1,'END')
      CALL LCLCLS( 9,1,2,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 220
  220 STOP
      END
