C PLOTTER SEQUENCER
C
C THE PACKAGE CONSISTS OF THE SUBROUTINES OPLOT,DELETE,OLINE AND OPOINT.
C A SAMPLE PROGRAM IS ALSO GIVEN.
C
C		OPLOT(XX,YY,IPEN)
C THIS PROGRAM MOVES THE PEN FROM ITS CURRENT POSITION TO THE POINT
C (XX,YY). THE CONTROL (IPEN)  OF THE PEN IS
C		3, RISE THE PEN
C		2, LOVER THE PEN
C		1, POSITION UNCHANGED.
C THE POSITION OF THE PEN IS CONTROLLED BEFORE THE MOVEMENT. THE
C VERY LAST CALL OF OPLOT MUST CONTAIN A IPEN VALUE LESS THAN 0.
C THE ACTUAL PLOTTING IS MADE IN THE ORDER CONTROLLED BY THE 
C PROGRAM DELETE. FOR ADDITIONAL INFORMATION SEE: KUOKKANEN, LEIPALA, 
C NEVALAINEN: IMPLEMENTATION AND ANALYSIS OF A PLOTTING SEQUENCER,
C INST. OF COMP. SCI, UNIV. OF TURKU, FINLAND.
C INTERNAL VARIABLES:
C (X,Y) 	AN INTERNAL AREA FOR STORING THE POINTS OF THE CURVES,
C LSG		THE LENGTH OF THE CURVE SEGMENTS IN THE AREA (X,Y),
C N		THE NUMBER OF CURVE SEGMENTS IN THE AREA (X,Y),
C NS		THE NUMBER OF RESERVED CURVE SEGMENTS,
C IS		THE INDEX OF THE CURRENT CURVE SEGMENT,
C (IREAR,IFRONT)  VECTORS GIVING THE LAST AND FIRST USED ELEMENTS
C		IN THE CURVE SEGMENTS. AN EMPTY CURVE SEGMENT IS RECOGNISED
C		FROM THE CONDITION IREAR(J)=IFRONT(J)-1.
C IFIRST	0, WHEN CALLING THE SUBROUTINE FOR THE FIRST TIME
C		1, OTHERWISE.
C KON		1,WHEN THE PEN IS IN THE UPPER POSITION.
C IC		THE ABSOLUTE VALUE OF IPEN.
C (XN,YN)	THE CURRENT COORDINATES OF THE PHYSICAL PEN OF THE PLOTTER.
C (XE,YE)	THE CURRENT COORDINATES, WHEN MOVING THE PEN IN THE UPPER
C		POSITION.
C (XI,YI)	THE LAST POINT OF THE CURVE SEGMENT THAT MUST BE CONTINUED
C		TO ANOTHER SEGMENT.
C NRSEG		THE NUMBER OF RESERVED SEGMENTS AT THE TIME OF THE LAST CALL.
C LN		THE DEGREE OF THE HEURISTICS WHEN CHOOSING THE NEXT
C		SEGMENT AT THE TIME OF LAST CALL.
C WASTE		THE TOTAL LENGTH OF THE WASTE MOVEMENTS.
	SUBROUTINE OPLOT (XX,YY,IPEN)	
	DIMENSION X(1001),Y(1001),IFRONT(50),IREAR(50)	
	DATA LSG,N/20,50/
	DATA IFRST/0/
	IF(IFRST) 20,10,20

C INITIALIZATION
10	WASTE=0.
	XN=0.
	YN=0.
	NS=0
	KON=1
	DO 15 I=1,N
	IFRONT(I)=(I-1)*LSG+2
	IREAR(I) = (I-1)*LSG+1
15	CONTINUE
	IFRST=1
	XE=0.
	YE=0.

C TEST THE POSITION OF THE PEN	
20	IC=IABS(IPEN)
25	IF(IC-2) 60,35,30

C THE PEN IS LIFTED UP,IC=3
30	IF(KON.GT.0) GO TO 31
	NS=NS+1
	KON=1
31	XE=XX
	YE=YY
	GO TO 100

C THE PEN IS SET DOWN,IC=2
35	IF (KON.EQ.0) GO TO 61
	KON=0
	X1=XE
	Y1=YE
	IF(NS.GE.N) GO TO 63
	IS=NS+1
	GO TO 64

C THE PEN IS NEITHER LIFTED UP NOR SET DOWN
C IS IT IN THE UPPER POSITION
60	IF(KON) 130,61,130
130	XE=XX
	YE=YY
	GO TO 100

C STORE THE NEXT POINT
C IS THE SEGMENT FULL
61	LFREE=IREAR(IS)-IFRONT(IS)+1
	IF(LFREE-LSG) 65,62,62
62	L=IREAR(IS)
	X1=X(L)
	Y1=Y(L)
	NS=NS+1
	IS=NS+1
	IF(NS.LT.N) GO TO 64
C ALL SEGMENTS ARE RESERVED,
C DEALLOCATE ONE OF THE SEGMENTS
63	CALL DELETE (X,Y,IFRONT,IREAR,XN,YN,IS,N,WASTE)
64	L=IREAR(IS)+1
	IREAR(IS)=L
	X(L)=X1
	Y(L)=Y1
C STORE THE POINT OF THE CALL
65	L=IREAR(IS)+1
	IREAR(IS)=L
	X(L)=XX
	Y(L)=YY

C RETURN
100	IF(IPEN.GT.0) RETURN

C THE LAST CALL
	IF (KON.EQ.0) NS=NS+1
	NRSEG=N
	IFRST=0
	IF(NS.LT.N) NRSEG=NS

C DEALLOCATE ONE SEGMENT
	LN=NRSEG
160	IF(NRSEG) 150,150,120
120	CALL DELETE(X,Y,IFRONT,IREAR,XN,YN,IS,LN,WASTE)
	L=IFRONT(IS)
	X(L)=9999.
	Y(L)=9999.
	IREAR(IS)=L
	NRSEG=NRSEG-1
	GO TO 160
150	CALL PLOT(XX,YY,-3)
	RETURN
	END



C		DELETE (X,Y,IFRONT,IREAR,XN,YN,IS,N,WASTE)
C THE SELECTION OF THE NEXT CURVE AND ITS PLOTTING. THIS RPOGRAM IS
C USED ONLY BY OPLOT.
C INTERNAL VARIABLES:
C DN		THE MINIMUM DISTANCE TO THE NEXT CURVE SEGMENT.
C D,G		THE DISTANCES TO A CERTAIN CURVE SEGMENT.
C IDIR		THE DIRECTION OF THE CURVE DRAWING:
C		=1, IF THE DIRECTION IS FROM THE FIRST TO THE LAST COORDINATE,
C		=-1, FOR THE OPPOSITE.
C L		THE INDEX OF THE LAST POINT.
C IA		THE INDEX OF THE CURRENT POINT.
	SUBROUTINE DELETE(X,Y,IFRONT,IREAR,XN,YN,IS,N,WASTE)
	DIMENSION X(1),Y(1),IFRONT(1),IREAR(1)
	DN=9999999999.
	DO 45 J=1,N

C DETERMINE THE DISTANCE AND TEST, IF MINIMUM
	D= ABS(XN-X(IFRONT(J)))
	G= ABS(YN-Y(IFRONT(J)))
	IF (G.GT.D) D=G
	IF (D.GE.DN) GO TO 42
	DN = D
	IS=J
	IDIR=1
42	D= ABS(XN-X(IREAR(J)))
	G= ABS(YN-Y(IREAR(J)))
	IF (G.GT.D) D=G
	IF(D.GE.DN) GO TO 45
	DN=D
	IS=J
	IDIR=-1
45	CONTINUE

C PLOTTING OF THE SEGMENT
C CHOOSE THE DIRECTION
	IF(IDIR) 81,82,82
81	L=IFRONT(IS)
	IA=IREAR(IS)
	XN=X(L)
	YN=Y(L)
	GO TO 85
82	L=IREAR(IS)
	IA=IFRONT(IS)
	XN=X(L)
	YN=Y(L)
85	CALL PLOT(X(IA),Y(IA),3)
	CALL PLOT(X(IA),Y(IA),2)

C LOOP
	I=2
86	IF(I.GT.(IREAR(IS)-IFRONT(IS)+1)) GO TO 87
	I=I+1
	IA=IA+IDIR
	CALL PLOT (X(IA),Y(IA),1)
	GO TO 86

C MARK THE SEGMENT FREE
87	IREAR(IS)=IFRONT(IS)-1
	CALL PLOT(XN,YN,3)
	WASTE=WASTE+DN
	RETURN
	END
   
