00010  '  LAN2.BAS        DUANE MOORE        D I G I T A L
00020  '  USED IN CONJUNCTION WITH LAN1.BAS WHICH CREATES THE
  00030  '  FILE *YPARAM.LAN*.  THIS FILE HAS THE FOLLOWING FORMAT:
   00040  '  FREQ,MAG(Y(1,1)),ARG(Y(1,1)),MAG(Y(1,2)),ARG(Y(1,2)),
00050  '  MAG(Y(2,1)),ARG(Y(2,1)),MAG(Y(2,2)),ARG(Y(2,2))
 00060  '  ARGUMENTS ARE IN RADIANS.
   00070  '  FILE *TERM.LAN* CONTAINS THE TERMINATION INFORMATION:
00080  '  RS(1),CS(1),LS(1),RL(1),CL(1),LL(1),RS(2),...,LL(N)
  00090  '  WHICH ARE THE SERIES CONNECTED ELEMENTS OF THE SOURCE
00100  '  THE CALCULATED DATA IS WRITTEN INTO THE FILE *GAIN.LAN*
   00110  '  THIS FILE HAS THE FOLLOWING FORMAT:
   00120  '  [BLANK LINE]
 00130  '  RS(1),CS(1),LS(1)
 00140  '  RL(1),CL(1),LL(1)
 00150  '  [BLANK LINE]
 00160  '  MAGNITUDE AND ARGUMENT OF: AI, ZIN, AV, AND ZOUT
00170  '  MAGNITUDE AND ARGUMENT OF:  AVS, AIS
  00180  '  8 ZEROS (FOR FUTURE EXPANSION)
   00190  '  POWER GAIN, LINVILLE STABILITY FACTOR, STERN STABILITY FACTOR
  00200  '
00210  '  3-22-75
 00220  '
00230 FILES YPARAM.LAN,TERM.LAN,GAIN.LAN
   00240 MARGIN #3,132
    00250 SCRATCH #3
  00260 LET P1=3.141592654
    00270 LET P2=2*P1
 00280 DIM Y2(2,2),Y3(2,2)
   00290 DIM C0(8),C1(8),C2(8),C3(8),Y0(2,2),Y1(2,2)
    00300 DIM X(21),G(20)
  00310 GOTO 3000
   00320 IF END#1,GOTO 2940
    00330 INPUT #1,F
  00340 INPUT #1, Y2(1,1),Y3(1,1)
  00350 INPUT #1, Y2(1,2),Y3(1,2)
  00360 INPUT #1, Y2(2,1),Y3(2,1)
  00370 INPUT #1, Y2(2,2),Y3(2,2)
  00380 LET M0=4
    00390 LET C2(1)=Y2(1,1)
00400 LET C2(2)=Y2(1,2)
00410 LET C2(3)=Y2(2,1)
00420 LET C2(4)=Y2(2,2)
00430 LET C3(1)=Y3(1,1)
00440 LET C3(2)=Y3(1,2)
00450 LET C3(3)=Y3(2,1)
00460 LET C3(4)=Y3(2,2)
00470 GOSUB 2720
  00480 LET Y0(1,1)=C0(1)
00490 LET Y0(1,2)=C0(2)
00500 LET Y0(2,1)=C0(3)
00510 LET Y0(2,2)=C0(4)
00520 LET Y1(1,1)=C1(1)
00530 LET Y1(1,2)=C1(2)
00540 LET Y1(2,1)=C1(3)
00550 LET Y1(2,2)=C1(4)
00560 LET O=P2*F
  00570 IF X(1)=0 GOTO 600
    00580 LET X(6)=O*X(2)-1/(O*X(1))
 00590 GOTO 610
    00600 LET X(6)=O*X(2)
  00610 IF X(4)=0 GOTO 640
    00620 LET X(7)=O*X(5)-1/(O*X(4))
 00630 GOTO 650
    00640 LET X(7)=O*X(5)
  00650 LET M0=2
    00660 LET C0(1)=X(0)
   00670 LET C1(1)=X(6)
   00680 LET C0(2)=X(3)
   00690 LET C1(2)=X(7)
   00700 GOSUB 2370
  00710 LET X(8)=C2(1)
   00720 LET X(9)=C3(1)
   00730 LET X(10)=C2(2)
  00740 LET X(11)=C3(2)
  00750 IF C2(1)<>0 GOTO 780
  00760 LET C2(1)=1E35
   00770 GOTO 790
    00780 LET C2(1)=1/C2(1)
00790 IF C2(2)<>0 GOTO 820
  00800 LET C2(2)=1E35
   00810 GOTO 830
    00820 LET C2(2)=1/C2(2)
00830 LET C3(1)=-C3(1)
 00840 LET C3(2)=-C3(2)
 00850 GOSUB 2720
  00860 LET X(12)=C0(1)
  00870 LET X(13)=C0(2)
  00880 LET X(14)=Y0(2,1)*Y0(1,2)-Y1(2,1)*Y1(1,2)
 00890 LET X(15)=Y0(2,1)*Y1(1,2)+Y0(1,2)*Y1(2,1)
 00900 LET X(16)=Y0(1,1)+X(12)
    00910 LET X(17)=Y0(2,2)+X(13)
    00920 LET X(18)=C1(2)+Y1(2,2)
    00930 LET X(19)=C1(1)+Y1(1,1)
    00940  '  CURRENT GAIN
 00950 LET C2(1)=Y2(1,1)*Y2(2,2)
  00960 LET C3(1)=Y3(1,1)+Y3(2,2)
  00970 LET C2(2)=Y2(1,2)*Y2(2,1)
  00980 LET C3(2)=Y3(1,2)+Y3(2,1)
  00990 GOSUB 2720
  01000 LET C0(2)=C0(1)-C0(2)
 01010 LET C1(2)=C1(1)-C1(2)
 01020 GOSUB 2370
  01030 LET X(20)=C2(2)
  01040 LET X(21)=C3(2)
  01050 IF ABS(X(10))<1E20 GOTO 1070
    01060 GOTO 3080
   01070 LET C2(1)=C2(2)*X(10)
 01080 LET C3(1)=C3(2)+X(11)
 01090 GOSUB 2720
  01100 LET C0(2)=C0(1)+Y0(1,1)
    01110 LET C1(2)=C1(1)+Y1(1,1)
    01120 GOSUB 2370
  01130 IF C2(2)<>0 GOTO 1160
 01140 LET G(0)=1E35
    01150 GOTO 1170
   01160 LET G(0)=-Y2(2,1)/C2(2)
    01170 LET G(1)=Y3(2,1)-C3(2)
01180  '  INPUT IMPEDANCE
   01190 LET C2(1)=Y2(2,2)*X(10)
    01200 LET C3(1)=Y3(2,2)+X(11)
    01210 GOSUB 2720
  01220 LET C0(1)=1+C0(1)
01230 GOSUB 2370
  01240 IF C2(2)<>0 GOTO 1270
 01250 LET G(2)=1E35
    01260 GOTO 1280
   01270 LET G(2)=C2(1)/C2(2)
  01280 LET G(3)=C3(1)-C3(2)
  01290  '  VOLTAGE GAIN
 01300 LET C0(1)=X(17)
  01310 LET C1(1)=X(18)
  01320 GOSUB 2370
  01330 IF C2(1)<>0 GOTO 1370
 01340 LET G(4)=0
  01350 LET G(5)=0
  01360 GOTO 1410
   01370 LET G(4)=-Y2(2,1)/C2(1)
    01380 IF ABS(G(4))>1E-35 GOTO 1400
    01390 LET G(4)=0
  01400 LET G(5)=Y3(2,1)-C3(1)
01410  '  ZOUT
    01420 IF ABS(X(8))<1E20 GOTO 1460
01430 LET G(6)=Y2(1,1)/X(20)
01440 LET G(7)=Y3(1,1)-X(21)
01450 GOTO 1610
   01460 LET C2(1)=X(20)*X(8)
  01470 LET C3(1)=X(21)+X(9)
  01480 LET C2(2)=Y2(1,1)*X(8)
01490 LET C3(2)=Y3(1,1)+X(9)
01500 GOSUB 2720
  01510 LET C0(1)=C0(1)+Y0(2,2)
    01520 LET C1(1)=C1(1)+Y1(2,2)
    01530 LET C0(2)=C0(2)+1
01540 GOSUB 2370
  01550 IF ABS(C2(1))>1E-20 GOTO 1590
   01560 LET G(6)=1E35
    01570 LET G(7)=0
  01580 GOTO 1610
   01590 LET G(6)=C2(2)/C2(1)
  01600 LET G(7)=C3(2)-C3(1)
  01610  '  LINVILL STABILITY FACTOR
    01620 LET G(18)=(2*Y0(1,1)*Y0(2,2)-X(14))
  01630 IF G(18)=0 GOTO 1740
  01640 IF ABS(X(14))<1E18 GOTO 1660
    01650 LET X(14)=SGN(X(14))*1E18
  01660 IF ABS(X(15))<1E18 GOTO 1680
    01670 LET X(15)=SGN(X(15))*1E18
  01680 IF ABS(X(14))>1E-18 GOTO 1700
   01690 LET X(14)=0
 01700 IF ABS(X(15))>1E-18 GOTO 1720
   01710 LET X(15)=0
 01720 LET G(18)=SQR(X(14)*X(14)+X(15)*X(15))/G(18)
   01730 GOTO 1750
   01740 LET G(18)=1E35
   01750  '  STERN STABILITY FACTOR
 01760 LET G(19)=(SQR(X(14)*X(14)+X(15)*X(15))+X(14))
 01770 IF G(19)=0 GOTO 1810
  01780 IFABS(CLOG(ABS(X(16)))+CLOG(ABS(X(17)))-CLOG(ABS(G(19))))>35GOTO1810
    01790 LET G(19)=2*X(16)*X(17)/G(19)
   01800 GOTO 1820
   01810 LET G(19)=SGN(X(16))*1E35
  01820   ' AVSL   V(RL)/V(G)
 01830 IF ABS(X(10))>1E-20 GOTO 1870
   01840 LET G(8)=0
  01850 LET G(9)=0
  01860 GOTO 2060
   01870 IF ABS(G(2))<1E20 GOTO 1910
01880 LET G(8)=G(4)*X(3)/X(10)
   01890 LET G(9)=G(5)-X(11)
   01900 GOTO 2060
   01910 LET C2(1)=G(2)
   01920 LET C3(1)=G(3)
   01930 LET C2(2)=X(8)
   01940 LET C3(2)=X(9)
   01950 GOSUB 2720
  01960 LET C0(1)=C0(1)+C0(2)
 01970 LET C1(1)=C1(1)+C1(2)
 01980 GOSUB 2370
  01990 LET C2(1)=C2(1)*X(10)
 02000 LET C3(1)=C3(1)+X(11)
 02010 IF ABS(C2(1))>1E-20 GOTO 2040
   02020 LET G(8)=1E35
    02030 GOTO 2050
   02040 LET G(8)=G(2)*G(4)*X(3)/C2(1)
   02050 LET G(9)=G(3)+G(5)-C3(1)
   02060  '  POWER TO LOAD/POWER FROM SOURCE
  02070 LET M0=1
    02080 IF ABS(X(3))>1E-18 GOTO 2110
    02090 LET G(20)=0
 02100 GOTO 2190
   02110 LET C2(1)=G(2)
   02120 LET C3(1)=G(3)
   02130 GOSUB 2720
  02140 LET C0(1)=C0(1)+X(0)
  02150 LET C1(1)=C1(1)+X(6)
  02160 GOSUB 2370
  02170 LET C2(1)=C2(1)*C2(1)
 02180 LET G(20)=G(8)*G(8)*C2(1)/(X(3)*C0(1))
    02190  '  WRITE OUT RESULTS
 02200 PRINT #3,F
  02210 LET M0=8
    02220 FOR I=1 TO 8
02230 LET C2(I)=G(2*I-2)
    02240 LET C3(I)=G(2*I-1)
    02250 NEXT I
 02260 GOSUB 2800
  02270 FOR J=1 TO 7 STEP 2
   02280 FOR I=J TO J+1
   02290 PRINT #3,C2(I),C3(I),,;
    02300 NEXT I
 02310 PRINT #3,
   02320 NEXT J
 02330 PRINT #3,G(16),,G(17)
 02340 PRINT #3,G(20),,G(18),G(19)
02350 PRINT #3,
   02360 GOTO 320
    02370  '  RECTANGULAR TO POLAR CONVERSION
  02380 FOR M=1 TO M0
    02390 IF C0(M)<>0 GOTO 2430
 02400 LET C2(M)=ABS(C1(M))
  02410 LET C3(M)=90*SGN(C1(M))
    02420 GOTO 2700
   02430 IF C1(M)<>0 GOTO 2470
 02440 LET C2(M)=C0(M)
  02450 LET C3(M)=0
 02460 GOTO 2700
   02470 IF ABS(C0(M))>1E18 GOTO 2510
    02480 IF ABS(C0(M))<1E-18 GOTO 2510
   02490 IF ABS(C1(M))>1E18 GOTO 2510
    02500 IF ABS(C1(M))>=1E-18 GOTO 2660
  02510 LET A0=LOG(ABS(C0(M)))
02520 LET A1=LOG(ABS(C1(M)))
02530 IF ABS(A0-A1)<87 GOTO 2620
 02540 LET A2=(A0+A1)/2
 02550 IF A0>A1 GOTO 2590
    02560 LET C2(M)=C0(M)
  02570 LET C3(M)=0
 02580 GOTO 2700
   02590 LET C2(M)=C1(M)
  02600 LET C3(M)=90
02610 GOTO 2700
   02620 LET A0=EXP(2*(A0-A2))
 02630 LET A1=EXP(2*(A1-A2))
 02640 LET C2(M)=EXP(LOG(A0+A1)/2+A2)
  02650 GOTO 2670
   02660 LET C2(M)=SQR(C0(M)*C0(M)+C1(M)*C1(M))
    02670 LET C3(M)=57.295779*ATN(C1(M)/C0(M))
 02680 IF C0(M)>0 GOTO 2700
  02690 LET C2(M)=-C2(M)
 02700 NEXT M
 02710 RETURN
 02720  '  POLAR TO RECTANGULAR CONVERSION
  02730 FOR M=1 TO M0
    02740 IF ABS(C3(M))>1E-18 GOTO 2760
   02750 LET C3(M)=0
 02760 LET C0(M)=C2(M)*COS(C3(M)/57.295779)
 02770 LET C1(M)=C2(M)*SIN(C3(M)/57.295779)
 02780 NEXT M
 02790 RETURN
 02800  '  PHASE SCALER
 02810 FOR M=1 TO M0
    02820 IF C2(M)>=0 GOTO 2850
 02830 LET C2(M)=-C2(M)
 02840 LET C3(M)=C3(M)+180
   02850 IF C3(M)>=0 GOTO 2880
 02860 LET C3(M)=C3(M)+360
   02870 GOTO 2850
   02880 IF C3(M)<359.999 GOTO 2920
 02890 LET C3(M)=C3(M)-360
   02900 IF C3(M)>=0 GOTO 2920
 02910 LET C3(M)=0
 02920 NEXT M
 02930 RETURN
 02940 RESTORE #1
  02950 PRINT #3,-1010101" ";
 02960 FOR I=1 TO 30
    02970 PRINT #3,"*+";
   02980 NEXT I
 02990 PRINT #3,"*"
03000 IF END#2, GOTO 3070
   03010 INPUT #2,X(0),X(1),X(2),X(3),X(4),X(5)
    03020 PRINT #3,
   03030 PRINT #3,X(0),X(1),X(2)
    03040 PRINT #3,X(3),X(4),X(5)
    03050 PRINT #3,
   03060 GOTO 330
    03070 CHAIN LAN,200
    03080 LET G(0)=0
  03090 LET G(1)=0
  03100 LET G(2)=Y2(2,2)/X(20)
03110 LET G(3)=Y3(2,2)-X(21)
03120 LET G(4)=-Y2(2,1)/Y2(2,2)
  03130 LET G(5)=Y3(2,1)-Y3(2,2)
   03140 GOTO 1410
   03150 END
    
