
FILE: VIDED.VIP   1977-03-05  Last update: 1979-04-01

Swedish National Defense Research Institute       FOA Rapport
S-104 50 Stockholm 80                             C 10096-M3(E5)
SWEDEN                                            December 1978


VIDED - A DISPLAY-ORIENTED TEXT EDITOR

     By Jacob Palme


     ABSTRACT:  VIDED  is a text editor, that is a computer program used
     to produce, correct and modify texts stored in the computer.  VIDED
     uses display terminals, and is based on the idea that the screen of
     the terminal should always show a section of  text  from  the  text
     file being edited.

     After  an  editing operation, both the text in the computer and the
     image on the screen are immediately changed to  represent  the  new
     text.  The  user can directly and immediately see the effect of his
     editing.

     VIDED  can  thus not be used on printing terminals, but text edited
     with VIDED can of course be typed out on printing terminals.

     VIDED  contains facilities for reformatting sections of text to get
     lines  and pages of desired size after additions and deletions, in-
     cluding renumbering of pages. VIDED will thus not only replace con-
     ventional text editors, but also postprocessors like RUNOFF.

     VIDED  is  intended for use on many different kinds of display ter-
     minals, and is usually easy to adjust to a new terminal  type.  The
     present version 4A can be used on the following terminal models:

     Input terminal type: (Infoton) vista, i200, (vistar) sattelite,
     (DEC) vt52, vt100, Minitec, Teletec, (Tandberg) TDV 2000,
     (Elite) 1520, 1521, 2500, 3025, (Beehive) B100, (CDC) S713-10,
     (Volker) 404, 414H, Adm3A.

     VIDED is available from the DECUS library. VIDED version 4A will be
     submitted to the DECUS library in April 1979.

     The manual you are now reading has been produced with VIDED.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 2


TABLE OF CONTENTS:

     0. TABLE OF CONTENTS

     1. INTRODUCTION TO THE USE OF VIDED

          1.1  WHAT IS VIDED?
          1.2  CURSOR MOVEMENT, PART I
          1.3  INPUTTING COMMANDS WITHOUT SPECIAL KEYS
          1.4  CURSOR MOVEMENT, PART II
          1.5  TEXT INSERTION
          1.6  TEXT DELETION
          1.7  PARAGRAPH JUSTIFICATION
          1.8  MOVING AND COPYING
          1.9  PAGE HANDLING
          1.10 STATUS, HELP AND RESTORATION
          1.11 EXITING FROM VIDED
          1.12 FILE BACK-UP

     2. FULL DESCRIPTION OF THE VIDED COMMANDS

          2.1  STARTING AN EDITING SESSION

               2.1.1 VIDED START COMMAND
               2.1.2 SWITCHES TO THE START COMMAND
               2.1.3 READING THE SWITCH.INI FILE
               2.1.4 CALLING VIDED FROM OTHER PROGRAMS

          2.2  TYPING TEXT
          2.3  TYPING COMMANDS TO VIDED
          2.4  CURSOR MOVEMENT
          2.5  TEXT INSERTION COMMANDS
          2.6  TEXT DELETION COMMANDS
          2.7  PARAGRAPH JUSTIFICATION COMMANDS
          2.8  MOVING AND COPYING
          2.9  PAGE HANDLING
          2.10 STATUS, HELP and RESTORATION COMMANDS
          2.11 EXITING FROM VIDED
          2.12 MULTI-LINE APPLICATION IF VIDED COMMANDS
          2.13 RESTRICTIONS IN VIDED

     3. ONE-PAGE SUMMARIES

          3.1  ONE-PAGE SUMMARY OF VIDED COMMANDS
               3.1.1  ONE-PAGE SUMMARY OF VIDED INITIAL LINE COMMANDS
               3.1.2  ONE-PAGE SUMMARY OF VIDED TEXT EDITING COMMANDs
          3.2  ONE-PAGE SUMMARY OF DEC 10 TEXT HANDLING COMMANDS

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 3

     4. INFORMATION FOR VARIOUS TERMINALS

          4.1  FUNCTION KEYS
          4.2  TANDBERG TDV 2000
          4.3  ELITE 1520
          4.4  MINIBEE, BEEHIVE B 100, DEC VT52 AND DEC VT100
          4.5  CDC 713-10
          4.6  TELETEC
          4.7  ELITE 3025
          4.8  VOLKER 414H
          4.9  HAZELTINE 1510

     5. AUXILLIARY PROGRAMS

          5.1  FILCOM - COMPARING OLD AND NEW TEXT VERSION
          5.2  VIDEDP - UNDERLINING, SUBSCRIPTS AND NEATER RIGHT MARGIN
          5.3  INDEX  - PRODUCTION OF A SORTED INDEX FOR A TEXT
          5.4  ARNF   - LEFT-RIGHT-PAGINATION
          5.5  OVHEAD - BIG TEXT AND OVERHEAD PICTURES
          5.6  MARG   - SET MARGIN AND TAB STOPS ON TERMINAL
          5.7  VIDEDC - PRODUCE MULTI-COLUMN OUTPUT

     6. THE VIDED DISTRIBUTION TAPE AND HOW TO MODIFY VIDED

     7. MORE INFORMATION ABOUT VIDED

     8. INDEX

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 4


1. INTRODUCTION TO THE USE OF VIDED.

1.1 WHAT IS VIDED?

     VIDED  is  a  computer program to handle long and short texts which
     are stored in a computer.

     VIDED  can  only  be  used  on display terminals. The screen of the
     terminal shows a window of the text you are editing.

     You  can  type  on  the  terminal just as you type on a typewriter.
     There is a special marker called "cursor"  which  shows  where  the
     next character typed by you will appear on the screen.

     The  RETURN key on your terminal is used to get to the beginning of
     the next line. If you use the RETURN  key  at  the  bottom  of  the
     screen,  the  whole screen will "scroll", that is roll up one line.
     The top line will then disappear from the screen, but it  is  saved
     by  the computer. A new blank line will appear at the bottom of the
     screen.

     The  RETURN  key will NOT scroll in text from the input file. To do
     this, you must use the &Z command, see section 1.9 below.

     If  you  want  to  correct an error or modify what you have already
     written, there are a number of commands which you can give  to  the
     computer.  These  commands  allow  you  to  insert, delete and move
     portions of the text without rewriting anything already written.

     After  each such command, the screen will immediately show the text
     after the change.

     When  you have finished with VIDED, the text is saved by the compu-
     ter and you can type it out on a printing terminal.

     You  can also use VIDED on a saved text, if you want to add to, de-
     lete from or change the text.

     When you enter VIDED to work on an already existing text, there are
     commands to move to the portion of the text where you want to  make
     your modification.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 5
1.1 WHAT IS VIDED?

     VIDED  is  suitable also for putting simple pictures, flow diagrams
     and tables into your text. Here are some examples:

       ------------------------------------------------------------
       !  How to answer ! Fact --> ! Yes  ! No       ! Neither    !
       !                -------------------------------------------
       !  questions and ! Question ! Yes  ! No       ! Don't know !
       !                -------------------------------------------
       !  statements:   ! State-   ! I    ! Not      ! Accepted   !
       !                ! ment     ! know ! possible !            !
       ------------------------------------------------------------


----------------------------------------------------------------------
!                                                                    !
!       ^                                 __________                 !
!      / \                                !        !                 !
!     / o \            --------<---NO-<---! READY? !--->-YES---      !
!    / o o \           !                  !________!          !      !
!   / o o o \          V                      !               V      !
!  /_________\    _________      ________     !           ________   !
!  ! O O O O !    !       !      !      !     !           !      !   !
!  ! O O O O !    ! START !----->! EDIT !-->---           ! STOP !   !
!  ! O O O O !    !_______!      !______!                 !______!   !
!  ! O O O O !        ^                                       !      !
!  ! O O O O !        !                                       V      !
----------------------------------------------------------------------


             !
       1.00 -!- - - - - - oooooo  - - - - - - - - - - - - - - - - - -
             !          oo      oo
             !        oo          oo
             !       o              o
             !     oo                oo
             !    o                    o
             !   o                      o
       0.00  !--o------------------------o------------------------o---
             !                           ^o                      o
             !  The curve intersects     ! o                    o
             !  zero at this point ---->--  oo                oo
             !                                o              o
             !                                 oo          oo
             !                                   oo      oo
      -1.00 -!- - - - - - - - - - - - - - - - - -  oooooo - - - - - -
             !

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 6
1.1 WHAT IS VIDED?


                          \ ! /
                     ------(*)------     _____________
                          / ! \         /             \                /
                            !          /               \    \___/     /
  ((               ))                 /                 \  _(o.o)    /
  ! \_____________/ !                /                   \/___,,!___/___
  !  \           /  !_______________/_______________
  !   (0) \ / (0)   !===    ===   ==  =  ==         \      \       _____
__!_______ ! _______!__       ===   ===  = /    //   \      \     /
----------.!.----------            ===  = / //        \      \   /
  /\   \__/ \__/   /         \  ==   ==  !     !!    \\\      \ /
 !   \___________/           /           ! !!           \      /
 !                          /         ___!___       /\\  \ ___/
 \________!     !________  /_________/             /  \   !   \_______tm
 /        \_____/        \/         (_(_(_(__/____/    \\\\
(_(__(__(__)   (_)__)__)__)

(This beautiful lynx was created by Tomas Moll.)

1.2 CURSOR MOVEMENT, PART I

     There  are  a number of special keys and commands which you can use
     to move the cursor on the screen. After moving the cursor, you  can
     type new text which will replace the previous text.

     There  are  four special keys on your terminal with arrows pointing
     up, down, left and right. Pushing one of these keys will  move  the
     cursor one step in each direction.

     (If  your  terminal  does  not have these special keys, see section
     2.4.)

     The  key labelled HOME on your terminal will move the cursor to the
     upper left corner of the screen.

     The  key  labelled  RETURN will move the cursor to the beginning of
     the next line.

     The key labelled TAB will move the cursor to the next TAB position.

1.3 INPUTTING COMMANDS WITHOUT SPECIAL KEYS

     There  are  not  enough special keys on most terminals for all com-
     mands you can give to VIDED. The printing keys  must  therefore  be
     used. To tell VIDED that what you are typing is a command to VIDED,
     and not something to be inserted on the screen, you start such com-
     mands by pushing a special command starting key.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 7
1.3 INPUTTING COMMANDS WITHOUT SPECIAL KEYS

     This key is labelled ESC on INFOTON and MINITEC terminals. On other
     terminals the key may be labelled ESCAPE or  ALTMODE  or  something
     else.  See  chapter  4  to  check  which key to use on your type of
     terminal.

     When  you push this key, the character & will appear on the screen.
     You can then type the command. When the command is ready,  it  will
     disappear from the screen and the text which was overwritten by the
     command will be restored.

     Some of the special commands have to be finished by pushing the RE-
     TURN key on your terminal.

1.4 CURSOR MOVEMENT, PART II

     The  "&X" command will move the cursor past all text on the current
     line.

     Example:

     Mary had a little lamb.
     ^
     You type the "&X" command:

     &Xry had a little lamb.
       ^
     And the computer moves the cursor:

     Mary had a little lamb.
                            ^
     The  "&S"  command  can be used to search for a certain part of the
     text.

     Example:

     Mary had a little lamb.
     ^
     "&Slittle" will move the cursor to:

     Mary had a little lamb.
                      ^
     The  "&N"  command  is similar to the "&S" command, but will search
     past the end of the screen into unread parts of the  text  you  are
     editing.

1.5 TEXT INSERTION

     When  you  type  text  at the position of the cursor, existing text
     will  be  overwritten.  There  are  special commands to insert text
     without overwriting.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 8
1.5 TEXT INSERTION


     The "&I" command is used to insert new text. Example:

     Mary had a little lamb.
                       ^
     The "&Iblack " command will change this to:

     Mary had a little black lamb.

     The "&nL" command inserts blank lines. If you, for example, want to
     insert five blank lines, type "&5L". "&L" is equivalent to "&1L".

     A  simple way to delete text is to overwrite it with blanks or with
     other text.

1.6 TEXT DELETION

     The  key  labelled  DEL  or  DELETE or RUBOUT on your terminal will
     remove the last character and move the cursor back, so that you can
     correct it.

     Example:

     Mary had a littlr
                      ^
     Here, RUBOUT will give you:

     Mary had a littl
                     ^
     So that you can type in the correct character "e".

     The "&W" command removes the last word.
     The "&U" command removes the whole previous line.

     The "&K" command removes lines after the cursor.
     "&K" removes one line, "&5K" removes five lines.

     The "&nD" command will delete n characters and move the rest of the
     line back. Example:

     Mary had a littler lamb.
                      ^
     Here,  "&D" will remove the "r" in "littler" and move " lamb." back
     to give you:

     Mary had a little lamb.
                      ^
     By typing "&5D" you can delete 5 characters in the same way.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 9

1.7 PARAGRAPH JUSTIFICATION

     When you have added and deleted words in a paragraph, the lines are
     often uneven. The "&JU" command will move words from line  to  line
     to make the paragraph more even.

     Example:

     Jack and Jill went up the hill. Jill came tumbling after.
                                    ^
     To  insert  "Jack fell down." after "hill." you can first type "&L"
     to get blank space for the insertion:

     Jack and Jill went up the hill.
                                     Jill came tumbling after.

     You can then add the new sentence:

     Jack and Jill went up the hill. Jack fell down.
                                     Jill came tumbling after.

     Then  move  the  cursor  to the beginning of the paragraph and type
     "&JU" to fill the paragraph, and you will get:

     Jack  and Jill went up the hill. Jack fell down. Jill came tumbling
     after.

1.8 MOVING AND COPYING

     By typing "&Qreg 5" you will store a copy of the next five lines in
     a storage area under the name "reg". You can later  get  back  this
     stored text with the command "&Greg".

1.9 PAGE HANDLING

     The  command  "&Z" will scroll the screen and at the same time take
     in lines from the input file. For example, "&5Z"  will  output  the
     top  five  lines  of the screen and instead take in five lines from
     the input file at the bottom of the screen.

     The  command "&P" will move the screen to the top of the next page.
     By typing "&4PT" you can move to the top of page 4. By typing &+4PT
     you  can  move  four  pages forward, and by typing &-4PT four pages
     backward in the text.

     By  typing  "&PT"  you can get back to the top of the current page,
     and by typing "&PE" you can get to the bottom of the current page.

     The "&PF" command will find the end of the last page of the file.

     The "&PI" command divides a page into two pages at the cursor posi-
     tion.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 10
1.9 PAGE HANDLING

     New  pages  inserted with the "&PI" command get the same header and
     subheader as the previous page, except that the page number in  the
     header is increased by 1.

     Every time you modify a text, the date of this revision will be put
     into the first line of the first page of the text.

1.10 STATUS, HELP AND RESTORATION

     The "&O" gives information on which file you are editing, where you
     are in the file etc.

     The "&H" command prints a summary of the VIDED commands.

     The "&R" command restores a jumbled screen.

1.11 EXITING FROM VIDED

     The "&E" command finishes the current VIDED session.

1.12 FILE BACKUP

     The  &FB  command  will  produce  a backup file, which protects you
     against  losses in case of computer failure. If the computer is un-
     reliable, you are advised to use this command at least  every  15th
     minute.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 11

2. FULL DESCRIPTION OF THE VIDED COMMANDS

2.1 STARTING AN EDITING SESSION

2.1.1 VIDED START COMMAND

     Type  the  command "R VIDED" to the DEC-10 monitor. VIDED will then
     respond with a prompter:
     *

     Type the name of the file you want to edit or create.
     Example:
     *FIL.EXT

     You  can  also  type  the  monitor command "R VIDED-FIL.EXT" to get
     directly into the file you want to edit.

     If  you  use  VIDED  several times during a terminal session on the
     same file, you need only give the file name  the  first  time.  The
     next time, just type "R VIDED-".

     If no file called FIL.EXT exists, VIDED will produce a new file.

     IF  a file called FIL.EXT does exist, VIDED will produce a modified
     version of this file. The previous version  of  the  file  will  be
     kept,  but renamed to FIL.QXT, the same filename but with the first
     letter of the extension changed to Q.

     IF  you want VIDED to edit an input file and produce an edited copy
     with another name, write  the  new  name,  =,  and  the  old  name.
     Example: *NEW.EXT=OLD.EXT

2.1.2 SWITCHES TO THE START COMMAND

     You can also give other information on this initial line of data to
     VIDED  by  giving switches. Switches are preceded by "/". The foll-
     lowing switches exist:

  >  The  switch  /AUTOBACKUP  causes  VIDED  to  make  file  backups at
     interval to protect yourself  against  machine  errors  etc.  VIDED
     counts  the  number  of lines written and VIDED commands given, and
     makes a backup when this count reaches 10. The limit 10 can be  set
     to other values with /AUTOBACKUP:n.

     /AUTOBACKUP:0  gives  no such automatic file backups. If the switch
     is not given at all, VIDED assumes /AUTOBACKUP:20. For  a  13  page
     file, /AUTOBACKUP:20 gives 10% higher cost than /AUTOBACKUP:0.

  >  The  switch  /T  tells  VIDED what kind of display terminal you are
     using. For example:
     *NEW.FIL=OLD.FIL/T:VISTA
     will tell VIDED that you are using a terminal of type 1, that is an
     INFOTON VISTA terminal.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 12
2.1 STARTING AN EDITING SESSION

     The  parameter  to  /T:  is the same as the text given as answer to
     question which the program will ask if no terminal type  is  given,
     that is one of the text not inside parenthesis in the meny below:

     Input terminal type: (Infoton) vista, i200, (vistar) sattelite,
     (DEC) vt52, vt100, Minitec, Teletec, (Tandberg) TDV 2000,
     (Elite) 1520, 1521, 2500, 3025, (Beehive) B100, (CDC) S713-10,
     (Volker) 404, 414H, Adm3A.

  >  /N:n  if  you  want  VIDED to produce a line-numbered file with the
     increment n between successive line numbers.  This  switch  is  not
     necessary if the input file is already line-numbered.

  >  /-N  if  you want VIDED to remove line numbers from a line-numbered
     input file.

  >  /MP:n  to  indicate  maximum  number of lines per page. The default
     value is 56.

  >  /ML:n to indicate left margin. Default is 5.

  >  /MR:n to indicate right margin. Default is 72 for unnumbered files,
     78 for numbered files.

  >  /L:n  to  tell  VIDED  the  number  of  lines on the screen of your
     terminal. Default value is the common number of lines for each ter-
     minal model.

  >  /C:n  to  tell VIDED either a) the number of characters per line on
     your terminal, or b) the maximum number  of  characters  which  you
     want  to  allow  on  the lines in your file.

  >  /P  to indicate that you want titles and page numbers at the top of
     each page, and date on the first line of the first page.  You  will
     also get a warning line for pages with too many lines.

  >  /-P  to indicate that you do not want titles, page numbers, date or
     warning line for too long pages.

     If you give neither /P nor /-P then VIDED will assume /-P for files
     with extensions typical for RUNOFF files and source  program  files
     (e.g. ".FOR") and /P for all other files.

  >  /SPEED:N  to  indicate  the  transmission speed to your terminal in
     bits/second. If this siwtch  is  not  given,  VIDED  will  get  the
     transmission  speed from the operating system. The speed is used to
     govern the number of filler characters after certain control  codes
     which the terminal can not perform instantly. Thus, a /SPEED higher
     than the real speed can be used  if  your  terminal  requires  more
     fillers than VIDED provides.

  >  /DCA  to use the direct cursor addressing feature in your terminal.
     By  this  is meant that VIDED can move the cursor to any screen po-
     sition with a special screen addressing code sequence. This may not
     always  work,  but if it works, VIDED will be faster, especially at
     low line speeds.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 13
2.1 STARTING AN EDITING SESSION

  >  /-DCA  to inhibit direct cursor addressing. May be necessary to get
     VIDED working on some installations.

     Note:  VIDED  normally  gives the correct value for the /DCA switch
     depending on terminal type. By  using  the  /DCA  switch  you  will
     override  this  default value, which may cause VIDED not to work if
     you write /DCA for a terminal without this feature.

  >  /ALF  if your terminal has an auto-lf feature for carriage returns.
     VIDED will probably not work on such a terminal.

  >  /-ALF (default) for a terminal without the auto-lf feature.

  >  /SWEDISH  tells  VIDED that the text is in the Swedish language. If
     this switch is not given, the English language is assumed. The only
     effect  of the /SWEDISH switch is that the default word in front of
     the page number is "SID" instead of "PAGE" and  that  the  revision
     date  on  the first line will be preceded by "Reviderad" instead of
     "Revised". With the /-P switch setting, there is no  difference  in
     the functioning of VIDED with English or Swedish.

     NOTE: VIDED will assume a file to be in Swedish if the extension of
     the  file  is .SWE or .VIS. (.VIS is intended for texts to be post-
     processed by VIDEDP.)

  >  /OPTION:<name>  tells  VIDED  to  read  and  interpret lines in the
     SWITCH.INI file (see 2.1.3) beginning with
     VIDED:<name>

  >  /COUNT:<word>  tells  VIDED that the page count on top of each page
     is to preceded by this word. Defaults are "Page" or "Sid"  (="Page"
     in Swedish). Example:
     /COUNT:COLUMN

  >  /RUN:<file  spec> tells VIDED to call a program whose .EXE file has
     the given file specification when the user exits  from  VIDED  with
     the &E or &C commands. See further chapter 2.1.4.

 >   /JE:c  tells VIDED that a certain character c, when occuring as the
     leftmost character of a line, indicates  end-of-paragraph  for  the
     &FI, &FC and &JU VIDED commands. Default value is c = '.'(dot).

  >  /-JE  disables  the use of the &FI, &FC and &JU command without any
     explicit numerical parameter in the command  string.  /-JE  is  the
     default for files with common programming language extensions.

  >  /S:n indicates how many lines to display after &N-searches. Default
     value is to display the whole screen. This  parameter  makes  VIDED
     faster  with  low  terminal  transmission speeds, but is dangerous,
     since part of the screen is wrongly shown as blank.



VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 14
2.1 STARTING AN EDITING SESSION

2.1.3 READING THE SWITCH.INI FILE

     You  can  change  the  default  values  assumed  by VIDED for these
     switches by a line in your SWITCH.INI file. For  example,  if  your
     SWITCH.INI file includes the line
     "VIDED /MP:100/ML:0/-P"
     then VIDED will assume these default values for you.

     You  can  cause  VIDED  to  only  select  certain  lines  from  the
     SWITCH.INI file. These lines should begin with
     VIDED:<variant>
     where <variant> is a non-blank option name followed by a space.

     VIDED  will  read and interpret these lines only if the name of the
     output file contains the text in  <name>.  If  the  /OPTIONS:<name>
     switch  was given in the VIDED command string, then such lines will
     be read and interpreted only if the <name> in the /OPTIONS:  switch
     contains the text following VIDED: in the SWITCH.INI file.

     Example I: If you do not want any headers and page numbers in files
     with the extension .TXT then you write in your  SWITCH.INI  file  a
     line with the text:
     VIDED:.TXT /-P

     Example  II:  If  you  want  the page size to be 80 lines with left
     margin 0 and right margin 75, but only for the file  BIG.TXT,  then
     write  in  your SWITCH.INI file a line with the text:
     VIDED:BIG.TXT /mp:80/ml:0/mr:75

2.1.4 CALLING VIDED FROM OTHER PROGRAMS

     VIDED  can  be  called  from another program, and be made to return
     execution to that or another program instead of exiting to  monitor
     level.

     The  program calling VIDED should give a command string to VIDED in
     the TMPFILE "VID". Include in this command string "/RUN:PROG" where
     PROG  is  the  program  to be called from VIDED when the user exits
     with &E or &C.

     Example:  Below is a simple program VIDRUN which inputs a few lines
     into a temporary file, calls VIDED, and when VIDED is ready outputs
     the  file  after  editing with VIDED. The temporary file is given a
     temporary name with the job number and the letters "PRO".

     The  example  is  in SIMULA, but similar programs can be written in
     other programming languages.

     Your program file VIDRUN.SIM could look like this:




VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 15
2.1 STARTING AN EDITING SESSION

     BEGIN
     EXTERNAL INTEGER PROCEDURE rename;
     EXTERNAL PROCEDURE run;
     EXTERNAL TEXT PROCEDURE tmpnam, conc;
     EXTERNAL BOOLEAN PROCEDURE tmpout;
     EXTERNAL REF (infile) PROCEDURE findinfile;
     EXTERNAL REF (outfile) PROCEDURE findoutfile;

     TEXT filename; ! temporary name of the intermediate text file;
     REF (infile) from_vided; ! input of intermediate file;
     REF (outfile) to_vided; ! output of intermediate file;

     filename:- tmpnam("PRO");
     from_vided:- findinfile(filename);
     INSPECT from_vided DO
     BEGIN
       COMMENT treat the file you got from VIDED;
       open(sysout.image); outimage;
       outtext("----- FILE from VIDED -----"); outimage;
       WHILE TRUE DO ! Output the file you got from VIDED;
       BEGIN inimage;
         IF endfile THEN GOTO exit;
         outimage;
       END;
       exit: ! delete and close temporary file;
       rename(from_vided,NOTEXT,FALSE);
     END OTHERWISE
     BEGIN
       COMMENT prepare a file for VIDED;
       to_vided:- findoutfile(filename);
       INSPECT to_vided DO
       BEGIN
         COMMENT prepare a file for VIDED;
         sysout.outtext(
         "Input text to VIDED, finish with two returns.");
         sysout.outimage;
         open(sysin.image);
         WHILE TRUE DO ! move lines from TTY to temporary file;
         BEGIN inimage; IF image.strip == NOTEXT THEN GOTO exit;
           outimage;
         END;
         exit: close;
         ! Give command string to VIDED in tmpfile "VID";
         tmpout("VID",conc(filename,"=",filename,"/RUN:VIDRUN"));
         run("VIDEDB",1);
       END;
     END;
     END;





VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 16

2.2 TYPING TEXT

     The  display  screen  will  always  show  a  part of the text being
     edited. This means that when you are editing a new file, the screen
     will initially be blank.

     Any  printable character you type will immediately be placed on the
     screen and in the text file at the position of the  cursor  on  the
     screen.  You  can thus just begin to type the text of your file, it
     will be shown on the screen and put into the file in the computer.

2.3 TYPING COMMANDS TO VIDED

     There  are  a number of commands which you can give to VIDED to in-
     sert  text,  delete text, stop editing etc. To indicate to the com-
     puter that you are typing a command to VIDED and not text to be in-
     serted into the file, you start by typing a special key which indi-
     cates "start of a command".

     This  special  key is not the same on all display terminals, on the
     INFOTON VISTA terminal you can use the ESCAPE key. (On  some  other
     terminals  you  have  to type ESCAPE(ALTMODE) twice or use the CON-
     TROL-F key.) See chapter 4 for information on what key to  use  for
     your terminal model.

     The  character  "&"  will  show on your screen to indicate that the
     computer has received this special key input and is waiting  for  a
     command  to  VIDED.  In the examples below, the character "&" means
     this special command key and not the actual character "&".

     Do  not  be  afraid to type a VIDED command on top of other text on
     the screen. The command will be wiped out and  the  text  below  it
     restored as soon as you have typed in the full command.

     As  an example of a VIDED command, the H (Help) command will give a
     list of the VIDED commands. Thus,  to  get  a  list  of  the  VIDED
     commands,  you  just type ESCAPE(ALTMODE) (twice on some terminals)
     or CONTROL-F followed by the letter "H" or  "h".  This  command  is
     called the "&H" command.

2.4 CURSOR MOVEMENT

     The  cursor  on  the  screen indicates where text which you type in
     will be put. There are several commands to move  the  cursor  to  a
     desired position on the screen.

     The  CARRIAGE  RETURN  key will move the cursor to the beginning of
     the next line. If you are on the last  line,  the  CARRIAGE  RETURN
     will cause the screen to scroll, that is move up one line and bring
     in a new blank line. CARRIAGE RETURN always scrolls in blank  lines
     at  the  bottom, to scroll in lines from the input file, use the &Z
     command (see section 2.9).


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 17
2.4 CURSOR MOVEMENT

     There  are  four special keys on your terminal with arrows pointing
     LEFT, RIGHT, UP and DOWN. These keys can be used to move the cursor
     in  the  desired  direction. The key labelled "HOME" can be used to
     move the cursor to the upper left corner of the screen.

     (NOTE:  If you have a DATAMEDIA ELITE 1520 terminal without the op-
     tional "numeric" keyboard, your terminal lacks these four keys. See
     chapter 4.2 about how to handle such terminals.)

  &X (END OF LINE) COMMAND:
     The "&X" command will move the cursor past all non-blank characters
     on the current line. For example, assume that the current line is:

     Mary had a little lamb.

     The  "&X"  command  will then move the cursor to the blank position
     immediately after "lamb.".

  &-X (BEGINNING OF LINE) COMMAND:
     The  "&-X"  command will move the cursor in front of the first non-
     blank character of a line (except line number). Example:

               IF big THEN BEGIN
                 ! This is a SIMULA program;

     The  "&-X"  command  will  move the cursor in front of the ! on the
     second line.

  &Ah v (ADRESS SCREEN) COMMAND:
     The  "&Ah  v" command will move the cursor to the given position on
     the screen, counted from the upper left corner. Finish with  RETURN
     or  SPACE. For example "&A30 5" will move the cursor to position 30
     of line 5 on the screen.

  &S (SEARCH) COMMAND:
     The  "&S<search  string>"  command  will  search the screen for the
     search string immediately following "&S", beginning the  search  at
     the  current  screen  position.  If  this string is found, then the
     cursor is placed after it. If the string cannot  be  found  on  the
     screen, the cursor is not moved.

     Assume for example that the screen contains the line:

     Jack and Jill went up the hill.
     ^
     If  the  cursor  is  at the beginning of the line, then the command
     "&Sill" will move the cursor to the position after "Jack and Jill".
     If  the  command "&Sill" is given once more, the cursor is moved to
     the dot after "hill".

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 18
2.4 CURSOR MOVEMENT

     If  you  want  to search for the same string as in the last search,
     you need not give any search string at all. Thus,  in  the  example
     above,  you could give just the command "&S" instead of "&Sill" the
     second time.

     A  number  between  & and S indicates repetition of the same search
     several times. In the above example, "&3*S " would find  the  third
     next space, giving:

     Jack and Jill went up the hill.
                   ^

     The end of the search string can be indicated either by pushing the
     RETURN key, or by  pushing  the  command  indicating  key  (usually
     ESCAPE (ALTMODE) once or twice or CONTROL-F).

     The  "&N"  command is similar to the "&S" command but will continue
     to search past the end of the text shown on  the  screen  when  the
     command is given.

  &T (TAB) COMMAND:
     The  TAB  key  and  the &T command moves the cursor to the next TAB
     setting on the current line. The TAB settings are initially  5,  8,
     16, 24, 32, 40, 48, 56, 64 and 72.

  &nT COMMAND:
     The "&nT" command will move the cursor to position n on the current
     line. Assume for example that the current line is:

     Mary had a little lamb.

     Then the "&10T" command will move the cursor to the "h" in "had".

  &TZ (TAB ZERO) COMMAND:
     This command will remove all the TAB settings.

  &TR (TAB RESTORE) COMMAND:
     This command will restore the TAB settings to the initial 5, 8, 16,
     24, 32, 40, 48, 56, 64 and 72.

  &TS (TAB SET) COMMAND:
     This  command  will  make  a  TAB setting at the current horizontal
     position.

     Example:  If  you  want  only  one  TAB  setting  at the horizontal
     position 40, you can write the following series of commands:
     "&TZ &40T &TS ".

  &TnS (TAB SET) COMMAND:
     This  command  will  set  a  horizontal tab at position n. Example:
     "&T40S" will set the same tab as in the above example.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 19
2.4 CURSOR MOVEMENT

  &TC (TAB CANCEL) COMMAND:
     This  command  will  cancel the tab setting at the cursor position,
     but leave all other tab settings.

  &TnC (TAB CANCEL) COMMAND:
     This command will cancel the tab setting at horizontal position n.

2.5 TEXT INSERTION COMMANDS

     If  you  want to insert new text, you just move the cursor to where
     you want the text and type it. The new  text  will  then  overwrite
     previous text.

     The "&I", "&L" and "&V" commands can be used to insert text without
     overwriting previous text.

  &I (INSERT) COMMAND:
     The "&I<insertion text>" command will insert new text, shifting the
     rest of the text to make room for the addition. Finish  the  inser-
     tion  text with RETURN or with the command starting key (ALTMODE or
     CONTROL-F). Assume for example that the screen contains the text:

     Mary had a little lamb.
                       ^
     To change this to "Mary had a little black lamb.", you can move the
     cursor to the "l" in lamb and make the command "&Iblack ".

  &nV (INSERT BLANK) COMMAND:
     This  command  is  a  short form for the "&I<n spaces>&" command to
     insert n spaces. On most terminals, you can type CONTROL-V  instead
     of "&V" to insert a single space.

  &nL (LINE INSERTION) COMMAND
     The "&nL" command will insert n blank lines, displacing the rest of
     the text downwards. To insert one blank line, the short  form  "&L"
     can be used.

     Assume for example that the screen contains the two lines:

     Jack and Jill went up the hill.
^    Jack fell down, and Jill came tumbling after.

     Then  the  "&L"  command  at  the beginning of the second line will
     change this to:

     Jack and Jill went up the hill.

     Jack fell down, and Jill came tumbling after.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 20
2.5 TEXT INSERTION COMMANDS

     If  the  "&nL"  command  is used in the middle of a line, then that
     line will be split. Assume for example that the screen contains the
     line:

     Jack and Jill went up the hill.
                   ^
     If  the  cursor is at the "w" in "went", then the "&L" command will
     change this line to:

     Jack and Jill
                   went up the hill.

     If  you want to insert many words, then it is usually better to use
     the "&nL" command and type the new words into the blank lines  than
     to use the "&I" command.

  &LD (LINE DIVIDE) COMMAND
     The  "&LD"  command  is similar to the "&L" command, but the second
     part of the line is left justified. In the example above, you  will
     thus get:

     Jack and Jill
     went up the hill.

     If  you  want to insert blank lines between the parts, write "&LnD"
     where n is one more than the number of blank lines wanted.

2.6 TEXT DELETION COMMANDS

     One  way  to delete text on the screen is to move the cursor to the
     text to be deleted and overwrite it with other  text,  for  example
     with blanks.

     The key on your terminal labelled RUBOUT, DELETE or DEL can be used
     to make the character immediately to the left of the cursor blank.

     Assume for example that the screen contains:

     Jack and Jill wemt
                       ^
     To  change  the  last word to "went" you can first push the RUB OUT
     key twice, which gives you:

     Jack and Jill we
                     ^
     Then you type "nt" to get:

     Jack and Jill went
                       ^


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 21
2.6 TEXT DELETION COMMANDS

     RUBOUT  at  the beginning of a line will move the cursor to the end
     of the previous line. Example:

     Jack and Jill wemt
up
  ^
     Five succesive RUB OUTs will give:

     Jack and Jill we
                     ^

  &nD (DELETE) COMMAND
     The  "&nD"  command  can  be used to delete characters and move the
     succeeding text back so that there will be no blank  space.  Assume
     for example that you have:

     Jack and Jill went uppety the hill.
                          ^
     To change "uppety" to "up" you type the command "&4D".

     If  you  want  to  delete just one character, you can use the short
     form "&D". On most terminals, you can  also  delete  one  character
     with CONTROL-D.

     Suppose that the screen contains:

     Jack and Jill went up the hill.
^
     "&D" or CONTROL-D will move the text one step left:
    Jack and Jill went up the hill.
^
     "&V" or CONTROL-V will move the text one step right:
      Jack and Jill went up the hill.
^
  &nW (WORD DELETE) COMMAND
     The  "&nW" command will delete the last words preceding the cursor.
     On most terminals, CONTROL-W can also be used to remove  one  word.
     Assume the following text:

     Jack and Jill went uppety
                              ^
     "&W" will give:

     Jack and Jill went
                        ^
     A  number  between  "&" and "W" indicates the number of words to be
     removed. In the example above, "&3W" will give

     Jack and
              ^

  &U (UPTO DELETE) COMMAND
     The  "&U"  command  will make the line blank up to the cursor. CON-
     TROL-U can also be used on most terminals.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 22
2.6 TEXT DELETION COMMANDS

  &nK (DELETE LINES) COMMAND
     The "&nK" command will delete n lines and move the succeeding lines
     up to cover the blank lines. "&K" is short for "&1K".

     Example:

     Jack and Jill went up the hill.
     Jack fell down,
^    and Jill came tumbling after.

     The "&K" command will remove the entire second line:

     Jack and Jill went up the hill.
     and Jill came tumbling after.

     If  the  "&nK"  command  is used with the cursor in the middle of a
     line, then only the text after the cursor will be  deleted  on  the
     first line.

     Example:

     Jack and Jill went up the hill.
                  ^
     "&K" will change this to:

     Jack and Jill
                  ^

&_ (MASSIVE DELETION) COMMAND PREFIX

     Any  VIDED  command  can be preceded by the prefix _. The effect is
     that all text which would mormally be scrolled out on  top  of  the
     screen will instead be deleted.

     WARNING: This is a very dangerous prefix, to be used with care.

     Examples:  If  you  are  at the top of a page, then &_P will remove
     that page, and &_+5PT will  remove  5  pages,  beginning  with  the
     current page. &_n<searchword> will remove everything from where you
     are and upto the screen part shown where the word is found

     Note:  If the _ prefix is used in front of a command which produces
     a file backup, then all text to the end of the file plus  all  text
     from the beginning to the found page is deleted!

     Example: &_-PT will remove everything in the entire file except the
     previous page. &_FB will remove the entire file.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 23

2.7 PARAGRAPH JUSTIFICATION COMMANDS.

  &nFI (FILL) COMMAND
     If you have inserted new words into a paragraph, then the lines may
     be of uneven lengthes. By moving the cursor to the  first  line  of
     the  paragraph  and  typing  the  "&FI"  command  the  paragraph is
     justified. Example:

^    Jack went up the hill.
     Jill went up the hill.
     Jack fell down, and Jill came tumbling after.

     "&FI" will change this to:

     Jack went up the hill. Jill went up the hill. Jack fell down, and
     Jill came tumbling after.
^
     When  you  type  in  a  new paragraph, you can type it with uneven
     linelengthes like this:

Jack went up the hill. Jill went up the hill.
Jack fell down,
and Jill came tumbling after.

     Then  move  the  cursor  to  the start of the paragraph and use the
     "&FI" command and you will get:

     Jack went up the hill. Jill went up the hill. Jack fell down, and
     Jill came tumbling after.
^

     WARNING:  The  "&FI"  command  will regard succeeding lines upto an
     entirely blank line, or upto a line beginning with a dot,  as  part
     of  the  same  paragraph. If you want to justify only n lines, type
     "&nFI".

     If  you  want  the first line of the paragraph to start or end at a
     horizontal position different from the rest of the lines, then move
     the  cursor  past  this  irregular  start  before  making the "&FI"
     command. Example 1:

          Jack and Jill went up the hill.
     The man fell down, and the woman came tumbling after.

     Move  the cursor to the "J" in Jack before making the "&FI" command
     to get:

          Jack and Jill went up the hill. The man fell down, and the
     woman came tumbling after.





VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 24
2.7 PARAGRAPH JUSTIFICATION COMMANDS.

     Example 2:

  1) Jack and Jill went up the hill.
     The man fell down, and the woman came tumbling after.

     Move  the  cursor  to  the  "J"  in  "Jack" before making the "&FI"
     command to get:

  1) Jack and Jill went up the hill. The man fell down, and the
     woman came tumbling after.


     A COMBINED EXAMPLE OF INSERTION AND FILLING:

     Suppose you have the text:

     Jack and Jill went up the hill. Jill came tumbling after.

     You want to insert "Jack fell down." between the two sentences. One
     way to do this can be the following:

     1) Move the cursor to the insertion point with the "&S." command.

     Jack and Jill went up the hill. Jill came tumbling after.
                                    ^

     2) Use the "&L" command to get blank space for the insertion.

     Jack and Jill went up the hill.
                                    ^Jill came tumbling after.

     3) Insert the new sentence:

     Jack and Jill went up the hill. Jack fell down.
                                     Jill came tumbling after.

     4)  Move  the cursor to the start of the paragraph and use the &FI"
     command to fill it:

     Jack and Jill went up the hill. Jack fell down. Jill came tumbling
     after.

  &nFC (FILL COMPACTING) COMMAND

     The  &nFC command is similar to the &nFI command, but &FC will con-
     vert multiple spaces to a single space. Example - suppose that  you
     have added some words to a paragraph and got the following text:

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 25
2.7 PARAGRAPH JUSTIFICATION COMMANDS.

     Jack and Jill went up the hill. Jack fell down, and Peter fell down,
and Maria fell down,                               and Jill came
     tumbling after.

     In  this  case,  the &FI command will not compact the wide space in
     the middle of the second line, but &FC will compact it. The  result
     with &FI would be:

     Jack and Jill went up the hill. Jack fell down, and Peter fell
     down, and Maria fell down,                               and Jill
     came tumbling after.

     With &FC, the result would instead be:

     Jack and Jill went up the hill. Jack fell down, and Peter fell
     down, and Maria fell down, and Jill came tumbling after.

     WARNING:  There  is a risk with commands like &FI and &FC, that you
     will by mistake destroy a table or picture. The &FI command  has  a
     built  in  protection  against  this, by giving you a warning and a
     change to recover if the paragraph contains  multiple  spaces.  The
     &FC will not give this protection, and is therefore more dangerous.

  &nJU (JUSTIFY) COMMAND

     The  &nJU command is similar to the &nFC command, but will make the
     right margin even instead of  ragged.  The  even  right  margin  is
     achieved  by  making  some  of the spaces in the line into multiple
     spaces. The paragraph you are reading now was  justified  with  the
     &nJU  command.  If you print your text with a DIABLO-type terminal,
     you can convert texts with even right margins to a neater  kind  of
     even  right  margin, using the /A switch to the VIDEDP program. See
     chapter 5.2 for more information on VIDEDP.

     The  &nJU command will always compact spaces in the given text like
     &nFC, unlike &nFI. Note that if you want to change a paragraph from
     even right margin to ragged right margin, then the &FC command must
     be used, not the &FI command.

  &nML AND &nMR (LEFT AND RIGHT MARGIN SET) COMMANDS
     The  "&FI",  "&FC"  and  "&JU"  commands will justify the paragraph
     within a left and a right margin. The initial (default)  values  of
     these  margins  are  the  horizontal positions 5 and 72, unless you
     have given your own defaults in your SWITCH.INI file.

     These  margins  can be changed with the "&nML" and "&nMR" commands,
     to change respectively the left and right margin.






VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 26
2.7 PARAGRAPH JUSTIFICATION COMMANDS.

     Example: After "&ML10 &MR40" the "&FI" command will produce:

          Jack and Jill went up the
          hill. Jack fell down. Jill
          came tumbling after.

     You  can  give  the  &ML  and  &MR  commands  without any numerical
     arguments. The margins will then be set to the cursor  position  of
     the & in the &ML or &MR command.

  &F- (FILL DIVIDING) AND &J- (JUSTIFY DIVIDING) COMMANDS
     Sometimes,  some lines in a paragraph will be too short due to very
     long words. You can then use the "&F-" or "&J-" command  to  divide
     the long word. Example:

     Eine Arbeitsgruppe des Kurses befasste sich mit der
     prozessrechnergefuehrten Ueberwachung.
            ^
     Move  the  cursor  to the point where the word is to be divided and
     use the "&F-" command to get:

     Eine Arbeitsgruppe des Kurses befasste sich mit der prozess-
     rechnergefuehrten Ueberwachung.

     Always  use  the "&FI", "&FC" or "&JU" commands first, before using
     the "&F-" or "&J-" commands.

     The "&F-" command is just a shorter way to do the following:

     1) Do the "&I- " command.

     2) Move the cursor to the beginning of the previous line.

     3) Do the "&FI" command.

     The  "&F-"  command will always compact, thus act like "&FC" rather
     than like "&FI". The "&J-" is similar to the "&F-"  but  will  give
     even right margin instead of ragged right margin.

     A  numerical parameter can be given as "&nF-" or "&nJ-" to restrict
     the number of lines affected by the command.

     If  a filling or justifying command is used on a text which already
     has been divided, that is contains lines ending with a  dash,  then
     VIDED  will  ask  you what do do with each such dash. Three courses
     are open to you:

     COMMAND    ACTION
     R(emove)   Remove the dash from the text (default action).
     K(eep)     Keep the dash as a connector like the dash in "DEC-10".
     S(plit)    Put a space after the dash like in "pre- and post-
                processing".

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 27
2.7 PARAGRAPH JUSTIFICATION COMMANDS.

  &LnC (LINE CENTER) COMMAND
     This  command will place the text on the current line at the center
     of the line. As an example, here is the same line before and  after
     application of the &LC command:

     CENTER LINE
                               CENTER LINE

     Centering  is  done between n and the right margin. If no numerical
     parameter is given (&LC command), centering  is  done  between  the
     left and the right margin.

  &LU (LINE UPCASE) AND &LL (LINE LOWCASE) COMMAND
     These  commands will convert all letters after the cursor in a line
     to upper or lower case characters. Example:

     Initial line:       Jack and Jill went up the hill.
     &LU gives:          JACK AND JILL WENT UP THE HILL.
     &LL gives:          jack and jill went up the hill.

2.8 MOVING AND COPYING.

  &Q<name> n (Q-REGISTER STORE) COMMAND
     The  "&Q<name> n"  command  will  store  n lines in a Q-register (a
     nonvisible storage area). The contents of the Q-register  can  then
     be restored on another line.

     Just  "&Q<name>"  will  store  one line, "Q<name> 0" will store the
     rest of the screen. Only text visible on the screen can  be  stored
     in a Q-register.

  &G<name> (Q-REGISTER GET) COMMAND
     The  "&G<name>"  will  copy  the  contents of a Q-register onto the
     screen.

     NOTE: Copying will overwrite other text on the screen, but parts of
     the Q-register which do not fit in the  screen  area  will  not  be
     copied.

     Example: You want to exchange these two lines:

     Jack fell down, and Jill came tumbling after.
     Jack and Jill went up the hill.

     Then  move  the  cursor  to  the  first  line, and make the command
     "&Qfirst 1". Then delete the first line  with  "&K"  and  insert  a
     blank  line after the second line with "&L" and finally copy the Q-
     register content  onto  the  new  blank  line  with  the  "&Gfirst"
     command. You now have:

     Jack and Jill went up the hill.
     Jack fell down, and Jill came tumbling after.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 28
2.8 MOVING AND COPYING.

     If you just write "&Q<name>" then everything below and to the right
     of the cursor will be put into the q-register.

  &Q<name> n m (Q-REGISTER STORE BOX) COMMAND
     The "&Q<name> n m" command can be used to store any rectangular box
     on  the  screen  into  a q-register. The width of the box is n cha-
     racters  and  the  height is m lines. This is very useful when pro-
     ducing tables, flow diagrams etc.

     If  n or m is given as 0, the rest of the screen is put into the Q-
     register. Only text visible on the screen can  be  put  into  a  q-
     register.

     You can for example first type this text:

     !---------!
     !         !
     !         !
     !---------!

     Then  move  the cursor to the upper left corner of the box and type
     the command "&Qbox 11 4".

     You can now move the cursor to another position:

     !---------!
     !         !    ^
     !         !
     !---------!

     And get a copy of the box with "&Gbox".

     !---------!    !---------!
     !         !    !         !
     !         !    !         !
     !---------!    !---------!

     To produce a table, you can first produce one vertical line:

        !   Then store the line into a q-register with the
        !   "&Qline 1 0" command.
        !   (0 signifies the rest of the visible screen.)
        !
        !
        !
        !
        !
        !

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 29
2.8 MOVING AND COPYING.

     Then  you can get more vertical lines into your table by moving the
     cursor to the top of each line and typing the "&Gline" command.

        !       !       !       !       !       &Gline
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !

     You  can  insert  horizontal  lines in the same way, by storing one
     horizontal line in a Q-register and then inserting it several times
     with the "&G" command, to get:

        ---------------------------------------------------------
        !       !       !       !       !       !       !       !
        !       !       !       !       !       !       !       !
        ---------------------------------------------------------
        !       !       !       !       !       !       !       !
        !       !       !       !       !       !       !       !
        ---------------------------------------------------------
        !       !       !       !       !       !       !       !
        !       !       !       !       !       !       !       !
        ---------------------------------------------------------

     For another way of creating such a table, see section 2.12 below.

2.9 PAGE HANDLING

  &nZ (SCROLL) COMMAND

     The  "&nZ"  command will scroll the screen up n lines, that is take
     in n new lines from the input file at the bottom of the screen  and
     output  the  same  number  of  lines  at the top. If you regard the
     screen as a frame showing part of the text,  the  "&nZ"  will  move
     this frame down on the text.

     You can scroll the screen down (backwards) with a negative argument
     "&-nZ". On some terminals, the screen actually scrolls backward one
     line at a time. On other terminal, the whole screen is rewritten as
     it will look after the backward scroll.

  TITLE AND SUBTITLE

     VIDED  will  put  title,  subtitle and page number on all pages and
     todays  date  on  the first line of the first page, unless you dis-
     allow this with the "/-P" switch when starting VIDED or unless  the
     file has an extension typical for a source language file.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                            PAGE 30
2.9 PAGE HANDLING

  &nPT (PAGE TOP) COMMAND AND &nPE (PAGE END) COMMAND

     The "PT" command can be used to find the top of a certain page, and
     the "PE" to find the end of a certain page.
   > IF  no argument is given ("&PT" or "&PE") then the top or bottom of
     the current page is found.
   > If  the  argument  is an unsigned integer, then the top of the page
     with that number, counted from the beginning of the file, is found.
     Example: "&5PT" will find the top of page 5.
   > If  the  argument  is  a signed integer, then the n:th page counted
     from the current page is found. Example: "&+5PT" will find the  top
     of the 5th next page, "&-5PT" will find the top of the page 5 pages
     before the current page.

     Note:  If the current page is very large, then &PT may only back up
     to the top of the current subpage. In this case, you can get to the
     top of the current full page by the command &-0PT.

  &P (NEXT PAGE) COMMAND

     This  is  a  short form for the "&+1PT" command, that is to move to
     the top of the next page.

  &PF (PAGE AT END OF FILE) COMMAND

     This command will find the end of the last page of the file.

  &PI (PAGE DIVISION INSERT) COMMAND

     The  "&PI"  command will divide a page into two pages. The division
     will be done at the cursor position. This should be used if a  page
     becomes larger than the desired maximum page height.

     When  you  get  to  the  end  of  page, you will be warned with the
     following warning text:

     ***??? END OF PAGE *** USE &PI COMMAND ***???

     When  you  get  this  warning text, find a suitable place above the
     warning line and make the "&PI" command there. You may but need not
     remove the warning text, it will not be output.

     NOTE  for VIDEDP users: If the file extension begins with .VI, then
     VIDED will count lines in VIDEDP fashion  when  deciding  where  to
     give  the  warning  text,  e.g. .+ lines are not counted, .L and .U
     lines are only counted as half line feeds. See further chapter 5.2.

  &PA (PAGE APPEND) COMMAND

     The  "&PA"  command  will append the next page to the current page.
     Blank lines at the end of  the  current  page  and  the  title  and
     subtitle of the next page are deleted.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                            PAGE 31
2.9 PAGE HANDLING

  &nPS (PAGE SIZE) COMMAND

     After  using  the "&PA" command, the current page will often be too
     long. You can then use the command "&nPS" to  find  the  next  page
     which  is  longer  than  the maximum page height. This command will
     also find pages which are smaller than the maximum page  height  by
     more  than n lines. If you just write "&PS" then pages too large or
     more than 10 lines too small will be found.

     Here  is  the  normal sequence of activities for you when appending
     and dividing pages:

       -----------------------------------------------------
       !      Use the &PS command to find a page which     !
 ----->!      is too long or too short.                    !<----------
 !     -----------------------------------------------------          !
 !             !                                  !                   !
 !          TOO LONG                           TOO SHORT              !
 !             !                                  !                   !
 !  ---------------------------------   ----------------------------  !
 -<-! Use the "PI" command to split !   !  Use the "PA" command to !->-
    ! the current page.             !   !  append the next page.   !
    ---------------------------------   ----------------------------

  &N (LONG SEARCH) COMMAND

     The "&N<search string>" command is similar to the "&S" command (see
     section 2.4 above) but continues searching forward in the file past
     the  end  of  the screen and the page. "&n*N<string>" where n is an
     integer value, searches for the next n-th occurence of the string.

     When no match occurs, "&N" stops at the end of the entire file.

     If  you  want  to move many pages in the file, then the &P, &PT and
     &PE commands are much faster than the &N and &PF commands in  VIDED
     version  3F.  They  are  five  times  faster  for unnumbered files,
     fifteen times faster for numbered files.


  CONTROL-O COMMAND FOR SLOW TERMINALS

     If  you  have  a  slow terminal (less than 2400 baude) then you may
     find it irritating to wait for the whole screen to be filled  after
     a  "&P"  and "&N" command, especially if you did not find the place
     in the text you were really looking for. In such a  case,  you  can
     use the CONTROL-O command to interrupt the filling of the screen.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                            PAGE 32

2.10 STATUS, HELP AND RESTORATION COMMANDS

  &O (GET STATUS) COMMAND
     The  "&O" command will give you a report on the status of your edi-
     ting. You will be told the names of the  input  and  output  files,
     where you are on the current page, the contents of Q-registers etc.

  &H (HELP) COMMAND
     The  "&H"  command  can  be  used  if you do not have this handbook
     available and want to get a short summary of the VIDED commands.

  &nR (RESTORE SCREEN) COMMAND
     In  certain  cases,  the  text  on  the screen may be jumbled, even
     though the computer still has the correct text in  its  files.  The
     "&R"  command will then restore the screen to the correct text. The
     FORMFEED (CONTROL-L) key can also be used.

     Examples of causes of jumbled text:

  >  Terminal faults, electricity supply faults.

  >  Messages  sent  to  your  terminal  from the operator or from other
     users.

  >  You have been using the type ahead feature of the DEC-10 (inputting
     data  before the computer has handled your previous data.) Two com-
     mon cases of this:

  >  You  did  not  wait  for the echo "&" on the screen when starting a
     VIDED command before typing the rest of the command.

  >  You  typed  CARRIAGE  RETURN  at  the  end of screen, and continued
     typing before the new line had been scrolled onto the screen.

     Always  use  the  "&R"  command if you are not sure that the screen
     shows the correct text.

     A  numerical  parameter  reduces  the number of lines restored, for
     example, &1R only restores one line. To restore  the  screen  after
     receiving  a  send message, &4R i usually sufficient which may save
     time with slow terminal lines.

     (QUESTION: Why was VIDED designed in such a way that type ahead can
     cause  screen jumbling? ANSWER: Because otherwise your ordinary in-
     put  text  would not be echoed fast enough on a heavily loaded com-
     puter.)

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 33

2.11 EXITING FROM VIDED

     There  are  two  commands for leaving VIDED, the "&E" and then "&C"
     command.

  &E (EXIT) COMMAND
     The "&E" command finishes the editing operation, copies the rest of
     the input file to the output file, closes the output file. This  is
     the normal exit command.

     If  you  want  to  carry over the q-register contents, file opening
     switches, tabulator and margin settings from one edit to  the  next
     edit,  you  can  start  the  next  edit  with  the  monitor command
     "CONTINUE" after the end of the previous edit. When restarting with
     "CONTINUE", VIDED will not read the SWITCH.INI file again, and will
     remember previous values of switches given when starting VIDED.

     If  you  want  to  start  afresh,  you can restart with the "START"
     monitor command. VIDED will then read the  SWITCH.INI  file  again,
     and will not remember anything except the name of the edited file.

  &C (CANCEL EXIT) COMMAND
     The  "&C"  command exits immediately from VIDED without closing the
     output file. This command should be used if you want to cancel  the
     effect of the whole current session with VIDED. The input file will
     remain  as  it  was before the current editing session. The monitor
     command "CONTINUE" will return you to  the  editing  again  at  the
     point where you left it.

     NOTE:  You are advised to use the "&C" command instead of CONTROL-C
     to exit immediately from VIDED.

  &FB (FILE BACKUP) COMMAND
     This  command  will  create a backup copy of the text you have just
     edited, and then return you to the  point  where  you  exited  from
     VIDED.  If  the computer is unreliable, this command should be used
     at least every 15th minute to avoid information losses.

     Note  that the text "VIDED /AUTOBACKUP" in the SWITCH.INI file will
     give automatic such backups at regular intervals.

     The  first backup file in each VIDED session is given the same file
     name as the input file, but with the first letter in the  extension
     changed to Q. Later backup files will have the two first letters of
     their extension changed to QQ.

     Example:  If the input file is FILE.EXT, then the first backup file
     will have the file name FILE.QXT and later backup files during  the
     same VIDED session will have the file name FILE.QQT.

     Note:  The  "&PE" and "&PT" commands will also create a new backup,
     if used to move backwards to previous pages in the edited file.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 34

2.12 MULTI-LINE APPLICATION OF VIDED COMMANDS

     For  the VIDED commands &U, &D, &V, &FI, &FC, &JU, &K, &G, &I, &LC,
     &LU and &LL, preceding them with * will cause the  commands  to  be
     repeated  for several succeeding lines. Repetition is also possible
     for the &S and &N commands.

     Example, you have the text:

     =====  &4*2D will give you:  ===  while &4*2V    ==  ===
     = ^ =                        = =  will give you: =     =
     =   =                        = =                 =     =
     =====                        ===                 ==  ===

     You  can either explicitly give a number in front of the *, or just
     write &* without any number. In the latter case, VIDED has two ways
     of  deciding how many lines to apply the command to. The first rule
     is that a set of of lines all beginning with a dot will be regarded
     as a group to be treated:

     Example, you have the text:

.U            2    2
.U           a  + b
.    x = y + -------
.L        ^     z
.L

     The VIDED command &*5V will give you

.U                 2    2
.U                a  + b
.    x = y      + -------
.L        ^          z
.L

     Second example, given the text:

.U                  2    2
.U                 a  + b
.    x = y  + y  + -------
.L        1    2      z
.L        ^

     The VIDED command &*6D will give:

.U            2    2
.U           a  + b
.    x = y + -------
.L              z
.L

     Note  that  all  the lines of the formula are shifted with only one
     VIDED command.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 35

     If  there  is a group of lines beginning with ., then &* will apply
     the given command to all the lines in that group. If  there  is  no
     such  group, &* will be applied to the rest of the screen. If there
     is a number in fron of the *, e.g. &5*, then that number  of  lines
     will be affected by the command.

     The  VIDEDP  program  is  a postprocessor which can be used in com-
     bination with DIABLO type terminals to get half steps e.g. for for-
     mulas of the kind shown above. File extensions beginning with ".VI"
     are  recommended  for  such files, since VIDED will then count ".U"
     and ".L" lines as half lines when measuring page size. Here is  the
     formula above after processing with VIDEDP:

                    2    2
                   a  + b
     x = y  + y  + -------
          1    2      z


     More information on VIDEDP in chapter 5.2.

  &n*U COMMAND
     Example, you have the text:

     1976   1978   1979   1980   1981   1982   1983   1984
     ---------------------------^-------------------------
      100    150    200    300    300    340    450    120
      200    300    350    230    340    350    560    340
      400    450    700   1200   1345   2345   2380   4560

     The command &5*U will transform this text to:

                                 1981   1982   1983   1984
                                ^-------------------------
                                  300    340    450    120
                                  340    350    560    340
                                 1345   2345   2380   4560

  &n*K COMMAND
     With  the  same  initial text as in the previous example, &5*K will
     get you:

     1976   1978   1979   1980
     ---------------------------
      100    150    200    300
      200    300    350    230
      400    450    700   1200

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 36

  &n*I COMMAND
     Given again the same initial text, the &5*i!& command will give you

     1976   1978   1979   1980  ! 1981   1982   1983   1984
     ---------------------------!--------------------------
      100    150    200    300  !  300    340    450    120
      200    300    350    230  !  340    350    560    340
      400    450    700   1200  ! 1345   2345   2380   4560

  &n*G COMMAND
     Assuming  that  Q-register X contains the single character !, &5*GX
     will with the same initial text give you:

     1976   1978   1979   1980  !1981   1982   1983   1984
     ---------------------------!-------------------------
      100    150    200    300  ! 300    340    450    120
      200    300    350    230  ! 340    350    560    340
      400    450    700   1200  !1345   2345   2380   4560

     The  &nG  COMMAND  can  be used to rapidly create a table. Example,
     assume you have the following text:

        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------

     If  you  put the last two lines of this text into a qregister "row"
     then the VIDED command &8*Grow can get you:

        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 37

  &n*D AND &n*V commands
     The  &n*D  and  &n*V commands can be used to shift part or whole of
     the screen contents to the left or right. Example, given:

^       -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------
        !       !       !       !       !       !       !
        -------------------------------------------------

     The VIDED command &7*8D will then move the box to the right:

-------------------------------------------------
!       !       !       !       !       !       !
-------------------------------------------------
!       !       !       !       !       !       !
-------------------------------------------------
!       !       !       !       !       !       !
-------------------------------------------------

     while &7*8V will give you:

                -------------------------------------------------
                !       !       !       !       !       !       !
                -------------------------------------------------
                !       !       !       !       !       !       !
                -------------------------------------------------
                !       !       !       !       !       !       !
                -------------------------------------------------

  &n*nFI COMMAND
     I  am  not sure of any useful application of this command. But here
     is an example of what might happen, given the text:

     This
^         text
               will
                    be
                       justified.

     &5*1FI will convert this text to:

     This
     text
     will
     be
     justified.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 38

 &n*LC, &n*LU AND &nLL COMMANDS
     Example before centering:

     Swedish National Defense Research Institute
     S-10450 Stockholm 80
     Sweden

     After &3*LC

               Swedish National Defense Research Institute
                          S-10450 Stockholm 80
                                 Sweden


     Further after &3*LU

               SWEDISH NATIONAL DEFENSE RESEARCH INSTITUTE
                          S-10450 STOCKHOLM 80
                                 SWEDEN

2.13 RESTRICTIONS IN VIDED

     The  input  text to be edited by VIDED should not contain any other
     non-printable characters than space, tab, carriage  return-linefeed
     and  formfeed. This restriction may be lifted in future versions of
     VIDED.

     VIDED  will convert tabs into multiple spaces (except the TAB after
     line-numbers for line-numbered files).

     VIDED  will  insert a carriage return in front of any line feed not
     preceded by a carriage return.

     VIDED  will  insert  carriage return-line feed in front of any form
     feed not preceded by carriage return-line feed.

     The lines in the input file may not be longer than 140 characters.

     If  the  lines  in  the input file are longer than the width of the
     terminal screen, then they will permanently be split into two lines
     by VIDED.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 39

3. ONE-PAGE SUMMARIES

VIDED is a text editor specially suitable for display terminals.
The screen will always show the new text after each edit operation.

3.1.1 ONE-PAGE SUMMARY OF VIDED INITIAL LINE OR SWITCH.INI COMMANDS

OUTFIL.EXT=INFIL.EXT/T:<model>/N:n
IF no input file, or same input and output file, omit "=INFIL.EXT".
/T:<model> indicates terminal model. Can be omitted if unknown.
/N:n produces a line numbered file with increment n (default:10).
/-N removes line numbers.
/AUTOBACKUP:n = file backup for every n:th command. Suppress with n=0.
/MP:n sets number of lines per page (default:56),
/ML:n sets left margin (default:5).
/MR:n sets right margin (default:72).
/L:n sets number of lines per page (default terminal dependent).
/C:n number of characters per line (on screen or max allowed).
/P or /-P to govern page headers with page numbers.
/SPEED:n to indicate terminal speed in bps, controls filler characters.
/DCA use direct cursor addressing facility of the terminal.
/-DCA do not use the same facility.
/ALF the terminal has built-in auto-line feed at carriage return.
/-ALF no such feature.
/SWEDISH the text is in the swedish language.
/OPTION:<name> select certain lines from the SWITCH.INI file.
/COUNT:<word> word preceding page numbers on page top lines.
/RUN:<file spec> program to be run when user exits from VIDED.
/JE:c character ending paragraph when first in line (default='.').
/-JE to disable &JU, &FI and &FC command without explicit numerical parameter.
/S:n how much to show after &N-search. Default: The whole screen.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 40

3.1.2 ONE-PAGE SUMMARY OF VIDED EDITING COMMANDS:

The character printed as & below is actually ALTMODE (once or twice)
or CONTROL-F. On some terminal types, & may another key on the
keyboard. Check chapter 4. of the VIDED manual.

CURSOR MOVEMENT                   TEXT INSERTION
&X      Skip to end of line       &I      Insert text
&-X     To beginning of line      &nV or CONTROL-V Insert blanks
&Ah v   Address screen            &nL     Insert n blank lines
&S      Search within screen      &LnD    Divide line
&N      Search beyond screen
&T or <TAB> To next tab position  TEXT DELETION
&nT     To horizontal pos n       &nD     Delete n characters
&TZ     Zero tab settings         &D      Delete one character
&TR     Restore tab settings      &nW     Delete last words
&TS,&TnS Make one tab setting     &U      Delete line up to cursor
&TC,&TnC Remove one tab setting   &K      Delete line from cursor
                                  &nK     Delete n lines
PARAGRAPH JUSTIFICATION
&FI     Fill paragraph            MOVING AND COPYING
&nFI    Fill n lines(ragged marg) &Qreg n Store n lines in
&nFC    Fill n lines compacting           Q-register
&nJU    Justify (even right marg) &Qreg m n Store box of width m,
&F-     Divide word and fill              height n in Q-register
&J-     Divide word and justify   &Greg   Get Q-register
&nML    Set left margin
&nMR    Set right margin          PAGE HANDLING
&LC     Center line               &nZ     Scroll screen forwards
&LU     Upcase line               &-nZ    Scroll screen backwards
&LL     Lowcase line              &PT     Find top of current page
&LnN    Renumber lines            &PE     Find end of current page
                                  &nPT    Find top of page n
STATUS, HELP, RESTORATION         &+nPT   Find top of n:th next page
&O      Get status                &-nPT   Find top of n:th previous page
&H      Type command summary      &nPE    Find end of page n
&nR     Restore jumbled screen    &+nPE   Find end of n:th next page
                                  &-nPE   Find end of n:th previous page
EXITING                           &P      Find top of next page
&E      Normal exit               &-0PT   Find top of current full page
&C      Cancel exit               &PF     Find page at end of file
                                  &nPS    Find too big/small page
MULTI-LINE ACTION &n*<command>    &PI     Insert page division
MASSIVE ERASURE &_<command>       &PA     Append next page
                                  &FB     File backup

WARNING: Always do the &R command after receiving messages
from the system, operator or from other users, like
"OPR:- Timesharing ends in 30 minutes"

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 41
3.2  ONE-PAGE SUMMARY OF DEC 10 TEXT HANDLING COMMANDS

(Capital letters indicate what you write.)

Starting to use the computer:
     .LOGIN PPP,NNN    ; Give your project number and programmer number
     password: YYY     ; Give your password
     .ATTACH NN[PPP,NNN]        ; Attach to detached job

Stopping the use of the computer:
     .K/F               ; Good-bye to the computer

File names: 1-6 letters or digits, a dot, 1-3 letters or digits. The
     letters and digits after the dot are called "extensions". Some
     typical extensions:                        Backup extension:
     .TXT  = Text file with page numbers        .QXT
     .BAS  = Text file without page numbers     .QAS
     .LPT  = To be listed and deleted           .QPT
     .MIC  = Command file                       .QIC
     .INI  = Initialization file
     Example: LETTER.TXT

Listing your file names:
     .DIR               ; List names of all your files
     .DIR *.TXT         ; List all file names ending with ".TXT"
     .DIR *.Q??         ; List names of all backup files
     .DIR LET???.*      ; List all file names beginning with "LET"
     .DIR/F/W:80        ; Short, compact listing
     .DIR/SLOW          ; Listing with the time the file was read last
     .DIR/SINCE:1-May-78; List files changed after given date
     .DIR/SINCE:0       ; List files changed today

Deleting files:
     .DEL FIL.EXT       ; Delete file "FIL.EXT"
     .DEL *.Q??         ; Delete all VIDED backup files

Renaming files:
     .RENAME NEW.EXT=OLD.EXT    ; File "OLD.EXT" is renamed "NEW.EXT"

Copying files:
     .COPY NEW.EXT=OLD.EXT      ; File "NEW.EXT" becomes a copy of "OLD.EXT"
     .COPY SUM.EXT=PART1.EXT,PART2.EXT ; File "SUM.EXT" becomes a copy
                                         of the texts of both PART1
                                         and PART2 after each other.
Running programs:
     .RUN PROG          ; Run your program "PROG"
     .R PROG            ; Run system program "PROG"
     .R PUB:PROG        ; Run public program "PROG"

Printing files:
     .TYPE FIL.EXT      ; Type on your terminal
     .PRINT FIL.EXT     ; Print on the line printer
     .DO P4 FIL.EXT     ; Print on the local printer
     .DO P4B 3,FIL.EXT  ; Print on the local printer, bold face

Control commands:
     CONTROL-C          ; Interrupt execution immediately (push twice)
     CONTROL-O          ; Skip typing, but continue
     CONTROL-S          ; Pause in typing
     CONTROL-Q          ; Continue to type after CONTROL-S
     CONTROL-T          ; What is the computer doing?

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 42

4. SPECIAL INFORMATION FOR VARIOUS TERMINALS

4.1 FUNCTION KEYS

     On  some  terminal models with function keys, these can be used for
     the most common VIDED commands. Usually, the function keys  PF1  to
     PF8 cause the VIDED commands &, &I, &X, &-X, &S, &N, &K, &1L.

     You  can  cut  out  one of the two paper strips below, and paste it
     immediately behind these function keys on the keyboard.

------------------------------------------------------------------------
!   &    !   &I   !  &X   !  &-X   !   &S   !   &N   !   &K   !  &1L   !

     -------------------------------------------------------------
     !  &   !  &I   !  &X   !  &-X !  &S  !  &N   !  &K  !  &1L  !

4.2 TANDBERG TDV 2000

     On  this terminal, use the key labelled "UNDERLINE" on the terminal
     instead of ALTMODE or CONTROL-F to start a command to VIDED.

     Use  the  key  labelled "BLINK" to get the effect which the TAB key
     gives on other terminals.

     WARNING:  The  CR  key will blank the next line, the LF key part of
     the next line, and should only be used if you want this blanking or
     if the next line already is blank.

4.3 DATAMEDIA ELITE 1520

     NOTE:  If  you  have  a  DATAMEDIA  ELITE 1520 terminal without the
     optional "numeric" keyboard, your terminal lacks these  four  keys.
     You can then instead use:

                UP    CONTROL-_
                DOWN  LINE FEED
                LEFT  BACKSPACE
                RIGHT CONTROL-@ or CONTROL-\
                HOME  CONTROL-Y

4.4 MINIBEE, BEEHIVE B 100, DEC VT52 AND DEC VT100

     A  single altmode cannot be used to indicate the start of a command
     to VIDED. Use CONTROL-F or two successive altmodes instead.

     On  the DEC VT52, the leftmost blank control key (immediately above
     the digit 7 on the numeric pad) can be used to indicate  the  start
     of a VIDED command. On the DEC VT100, the PF1 key can be used.

     On  the DEC VT100, VIDED will set the terminal in VT52 mode. If you
     need the ANSI mode setting after using VIDED,  you  must  reset  to
     ANSI mode using the SET-UP and RESET keys.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 43
4. SPECIAL INFORMATION FOR VARIOUS TERMINALS

     On  some BEEHIVE terminals, the cursor control keys with arrows up,
     down, left, right and home work only locally.  On  such  terminals,
     these  keys  MAY NOT be used. Instead, use the corresponding ESCAPE
     sequences to get the same effect:

     UP     ESCAPE-A
     DOWN   ESCAPE-B
     LEFT   ESCAPE-D
     RIGHT  ESCAPE-C
     HOME   ESCAPE-H

4.5 CDC 713-10

     This  terminal has a key labelled "SCROLL DISABLE". This key should
     NOT be set!

     The  "home" key is labelled "reset" on the CDC 713-10, and it moves
     the cursor not to the upper left, but to the lower left corner. You
     can reach the upper left corner by the command "&a0 0".

     CONTROL-U cannot be used on the CDC 713-10. Use ALTMODE-U instead.

4.6 TELETEC

     The  TELETEC  has an option displaying only 40 extra big characters
     per line. With the switch /C:39, VIDED can be used with this option
     editing text where no line exceeds 39 characters.

4.7 ELITE 3025

     On  the  ELITE  3025,  you  should  push the PF1 key instead of the
     ESCAPE key to start a text editing command. Two succesive pushes on
     the  ESCAPE key will also work. The function keys described in sec-
     tion 4.1 above can be used on the ELITE 3025.

4.8 VOLKER 414H

     On  the  Volker  414H,  the PF1 key is recommended to start a VIDED
     editing commands. Warning: If the terminal  internally  is  set  to
     transmit carriage return as EOM, then the PF1 key cannot be used to
     start VIDED editing command. Users  are  recommended  to  set  this
     internal  switch  to  make EOM no character at all. VIDED will also
     work with EOM = CONTROL-D or EOM = Carriage Return, but  not  quite
     as well in all cases.

     The following special key functions can be used on the Volker 414H:


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 44
4. SPECIAL INFORMATION FOR VARIOUS TERMINALS

     D/L = Delete  Line  (Note:  A  blank  line  is  added  at bottom of
           screen).
     I/L = Insert Line (Note: Bottom line of screen is pushed down below
           screen but not deleted.)
     D/C = Delete Character
     I/C = Insert  Character  (Warning:  Character  may  appear  on line
           position 80, which is not part of the edited text.)

     The function keys described in section 4.1 above can also be used
     on Volker 414H terminals.

     If  you  want  to start VIDED from a MIC on a Volker 414H terminal,
     then the line in the MIC file after the line containing the name of
     the  file to be edited, must be "*p" if your terminal is set for no
     EOM character and "*" if your terminal is set for  Carriage  Return
     as  EOM character. If your terminal is set for EOT=Control-D as EOM
     character, then you will have trouble calling VIDED from a MIC.

4.9 HAZELTINE 1510

     VIDED  has  not  been  tested on the Hazeltine 1510, but since this
     terminal is claimed to be similar to the  Volker  414H,  VIDED  may
     work with the Volker 414H setting.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 45

5. AUXILLIARY PROGRAMS

5.1  FILCOM - COMPARING OLD AND NEW TEXT VERSION

     FILCOM  can be used to compare an old and a new version of the same
     file. Remember to save old versions of a file at suitable stages of
     development, using e.g. the "COPY" monitor command:
     .COPY fil.old=fil.ext

     FILCOM can be run in two modes: compare mode and update mode.

     In  compare mode, FILCOM will produce a listing of only those lines
     which differ between the compared files. For each changed  section,
     FILCOM will list both the old and the new version of the text.

     In  update mode, FILCOM will produce a listing of the new file, but
     with the character '|' added in the  left  margin  of  all  changed
     lines since the previous version.

     FILCOM is run in the following way:

     In compare mode:
     .R FILCOM
     *FIL.SCM=FIL.OLD,FIL.EXT
     *^C

     FIL.SCM will indicate the differences between FIL.OLD and FIL.EXT.

     In update mode:
     .R FILCOM
     *FIL.SCM/U=FIL.OLD,FIL.EXT
     *^C

     FIL.SCM  will  contain  a  copy  of FIL.EXT with all differences as
     compared to FIL.OLD marked with '|' in the left margin.

     Warning:  Do not apply FILCOM to entirely different files. The cost
     and CPU time will be enormous for large files.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 46

5.2  VIDEDP - UNDERLINING, SUBSCRIPTS AND NEATER RIGHT MARGIN

     This chapter is itself written with VIDEDP commands in it, and will
     thus only look right if it is printed on a DIABLO-type terminal.

5.2.1 VIDEDP FACILITIES

     VIDEDP is a program for outputting texts mainly on terminals compa-
     tible with the Diablo 1620 terminal. VIDEDP provides the  following
     facilities:

  >  Straight  left and right margins with all spaces in a line of equal
     length (looks neater than with some spaces  doubled  and  some  not
     doubled).

  >  Underlining of certain words, where the underlining can be made to
                            _____
     automatically adjust to the shifts necessary to get straight right
     margins.

  >  Subscripts, superscripts and even multiline formulas, which all can
     be made to adjust automatically to the shifts necessary to get
                                                  2     2
     straight margins. You can for example write x  or x  or even formu-
                                                        1
                      2    2
                     y  + z
     las such as x + ------- and you can, if you so want, include such
                        x
     formulas in ordinary text with adjustments for straight right mar-
     gins.

VIDEDP RESTRICTIONS

     VIDEDP does not move words from line to line, since this is easily
                 ___
     done using VIDED (&FI, &FC or &JU command), RUNOFF (.FILL command)
     or SOS (JU command). VIDEDP thus assumes that this has already been
     done with VIDED, RUNOFF or SOS.

VIDEDP COMMANDS

     VIDEDP takes a command string of the format
     outfil.ext=infil.ext/switch1/switch2 ...
     VIDEDP also interprets commands in the input file.

VIDEDP INPUT FILE COMMANDS

     All  VIDEDP  input  file commands begin with a dot (.) in the first
     position of a line. This dot is followed by a command  letter.  For
     some  commands,  a  number  may  be  given  between the dot and the
     command letter.

     VIDEDP  commands  will  be replaced with blanks in the output file,
     except for lines beginning with the VIDEDP command  .&,  where  the
     whole line is omitted from the output text.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 47
5.2  VIDEDP - UNDERLINING, SUBSCRIPTS AND NEATER RIGHT MARGIN

.& COMMAND - DELETE COMMAND LINE

     The  .&  command  is  used  to give VIDEDP a line of several VIDEDP
     commands. This line is not output. Example:
.&;.5L;.72R

.nL AND .nR COMMANDS - TO SET THE LEFT AND RIGHT MARGIN

     The  .nL  command  is  used to tell VIDEDP the position of the left
     margin. Example: .5L sets the left  margin  to  5  character  posi-
     tions.

     The  .nR  command  is used to tell VIDEDP the position of the right
     margin. Example: .5R sets the right margin  to  5  character  posi-
     tions.

.J AND .F COMMANDS - TO START RIGHT MARGIN ADJUSTMENT

     The  .J  and .F commands starts right margin adjustment. The diffe-
     rence is that the right margin adjustment after .J continues  until
     the  next  .J, .F, .A or .N command, while the right margin adjust-
     ment after .F only lasts for one paragraph.

     The  last line of a paragraph is not adjusted. A paragraph finishes
     with a wholly blank line or a line containing one of  the  commands
     .J, .F, .A or .N.

.N COMMANDS - TO STOP RIGHT MARGIN ADJUSTMENT

     This command stops right margin adjustment. It can be used in front
     of tables and other data for which right margin adjustment  is  not
     wanted.

.A COMMAND - AUTOMATIC RIGHT MARGIN ADJUSTMENT

     This  command can be used to minimize the number of VIDEDP commands
     which must be inserted in the input file. The command can  only  be
     used  for  texts  which  already have straight right margins of the
     kind which you get with the RUNOFF  .JUSTIFY,  SOS  JU  command  or
     VIDED &JU command.

     After  the .A command, VIDEDP will only change the right-adjustment
     on lines which already have been right adjusted in the more  clumsy
     way done by RUNOFF, SOS and VIDED.

     VIDEDP will regard a line as right-adjusted by RUNOFF, SOS or VIDED
     if the line (i) ends at the right margin given to VIDEDP  with  the
     .R  command,  and  (ii)  the  shortest  space  is not more than two
     characters shorter than the widest space between the left  and  the
     right margin.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 48
5.2  VIDEDP - UNDERLINING, SUBSCRIPTS AND NEATER RIGHT MARGIN

.+ AND ._ COMMANDS FOR OVERWRITING AND UNDERLINING

     The .+ command can be used to write two lines on top of each other,
     e.g. for underlining, accents or creating special symbols like
     danish O by overwriting O with /.
            /

     Further example:

     This text is to be underlined.
.+   _____________________________

     French "realite" has accents, "etre" circumflex, Danish "Kobenhavn"
.+            '    '                ^                          /
     a funny o.
.+           /

     which will be printed as

     This text is to be underlined.
     _____________________________

     French "realite" has accents, "etre" circumflex, Danish "Kobenhavn"
              '    '                ^                          /
     a funny o.
             /


     The command "._" in the first two columns is similar to .+ but
     causes underlining also of column 1 and 2. Example:

This text is to be underlined.
.____________________________

     which will come out as

This text is to be underlined.
_____________________________

     You can overwrite the same line many times e.g. to get both accents
     and underlining. Example:

French "realite" has accents, "etre" circumflex.
.+       '    '                ^
.______________________________________________

     which will come out as

French "realite" has accents, "etre" circumflex.
         '    '                ^
_______________________________________________

.U AND .L COMMAND FOR SUBSCRIPTS AND SUPERSCRIPTS

     .U  tells VIDEDP that the current line is to be printed only a half
     step above the next line, and .L that the current  line  is  to  be
     printed  only  a  half  step below the previous line. The main line
     can, but must not, begin with a dot followed by a space.

     Each  line  containing  superscripts in the input file should begin
     with .U, and each line containing subscripts with .L.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 49
5.2  VIDEDP - UNDERLINING, SUBSCRIPTS AND NEATER RIGHT MARGIN

     Example of an input file

.U                   4     3     2
     This formula: ax  + bx  + cx  + d contains superscripts.
     This line contains neither subscript nor superscript.
.U
     This line contains subscripts: x  + y    = x'.
.L                                   i    i+1    i
     This line contains neither subscript nor superscript.
.U                                               -n
     This line contains both: ker x + i kei x = i  K (x(sqrt(i)).
.L                               n         a        n
.U                                       n    inx
     Only superscripts: (cos x + i sin x)  = e   .
     And here comes a multiline formula:
.L
.                                         1
.U                       1       -1
.               cosh x = - ( log   x + -------- )
.L                       2      e
.U                                        -1
.                                      log    x
.L                                        e

     which will come out like this:

                     4     3     2
     This formula: ax  + bx  + cx  + d contains superscripts.
     This line contains neither subscript nor superscript.

     This line contains subscripts: x  + y    = x'.
                                     i    i+1    i
     This line contains neither subscript nor superscript.
                                                 -n
     This line contains both: ker x + i kei x = i  K (x(sqrt(i)).
                                 n         a        n
                                         n    inx
     Only superscripts: (cos x + i sin x)  = e   .
     And here comes a multiline formula:

                                          1
                         1       -1
                cosh x = - ( log   x + -------- )
                         2      e
                                          -1
                                       log    x
                                          e






VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 50
5.2  VIDEDP - UNDERLINING, SUBSCRIPTS AND NEATER RIGHT MARGIN

     Underlining and formula handling can be combined:

.U         y     y
.+         _     _
         x  + x
.+       _    _
.L        1    2

     which will come out as

           y     y
           _     _
         x  + x
         _    _
          1    2


.% COMMAND

     Since VIDEDP does not allow any lines beginning with dot other than
     VIDEDP command lines and lines where there is  a  space  after  the
     dot,  there  is a need for a command to output lines beginning with
     dots. This is done using  the  .%  command,  where  the  first  two
     characters are deleted from the input line. Thus

.%.RUN VIDEDP

     will come out as

.RUN VIDEDP

RUNNING THE VIDEDP PROGRAM

     Write
.RUN VIDEDP-<outfile>=<infile>/<switch1>/<switch2> ...

     <outfile>  can  be a file name or TTY: for the current terminal. If
     <outfile>= is omitted, TTY: is assumed.

     The extensions .VIP for English texts and .VIS for Swedish texts is
     recommended, since VIDED will count lines  in  VIDEDP  fashion  for
     files with extension beginning with .VI.

     Switches:

     /J     identical to .&;.J on the first line of the input file (see
            above)
     /A     identical to .&;.A on the first line of the input file
     /L:n   identical to .&;.nL on the first line of the input file, de-
            fault value: /L:5
     /R:n   identical to .&;.nR on the first line of the input file de-
            fault value: /R:72
     /COG:n line spacing, number of half cogs, default = 2 = single line
            spacing
     /O     other terminal than DIABLO. Only .+ and ._ VIDEDP commands
            can at present be used.
     /D     Diablo terminal (default value).

     VIDEDP was written in SIMULA for the DECsystem-10 computer by B`rje
     Ohlman, section 142, Swedish National Defense  Research  Institute.
     The program will be submitted to the DECUS library.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 51

5.3  INDEX  - PRODUCTION OF A SORTED INDEX FOR A TEXT

     INDEX  makes  it  very  simple to produce an index of the following
     kind:

          --- A ---

          Adding text . . . . . . . . . . . . 2.5
          Address screen command  . . . . . . 2.4

          --- C ---

          Cursor movement . . . . . . . . . . 1.2, 1.4, 2.4

     INDEX is used in five stages:

     1. Entry of new index words.
     2. Sorting in alphabetical order (English or Swedish word order).
     3. Correction and modification.
     4. Index text production.
     5. Postprocessing with VIDED, insertion into the full text.

     After  stage  2  or 3, you can go back to stage 1 or 2, e.g. to add
     more index words to your index. Stage 4 must be  directly  preceded
     by stage 2, to ensure a fully sorted index.

     INDEX  will  produce  the  following files (where "FIL" is the name
     chosen by you for your index):

     FIL.USR  Unsorted or updated index file.
     FIL.SRT  Sorted index file.
     FIL.IND  Index text in readable format.
     FIL.MIC  Command file to the SORT program.

     You  need  only  save the file FIL.USR, the other files can be pro-
     duced again by the INDEX program when you need them.

     To run INDEX, type
     .R INDEX
     and answer the questions from the computer. If you are unsure about
     what to do, type ? and push the RETURN key to get help information.

     When  inputting  index  words, go through the text page by page and
     input to the INDEX program the index words  on  that  page.  It  is
     usually better to refer not to page numbers but to decimal numbered
     chapter. INDEX can handle chapter numbers of  the  kind  "AB.1.c.2"
     with dots to separate groups.

     When  inputting  index  words, you can use RUB OUT and CONTROL-U to
     remove the current line and !!! followed by RETURN  to  remove  the
     previous index word. Repeated use of !!! can remove all index words
     on the current page.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 52
5.3  INDEX  - PRODUCTION OF A SORTED INDEX FOR A TEXT

     Sorting  is  not done by the INDEX program but by the SORT program,
     but INDEX will tell you how to start SORT when you leave the  INDEX
     program.  Sorting is only done on alphabetical characters, thus AB,
     'AC' and AD will follow each other.

     During editing, you can use the following six editing commands:

     0  Go to the next index word.
     1  Combine the two displayed index words into one
        word, equal to the first displayed word.
     2  Combine the two displayed index words into one
        word, equal to the second displayed word.
     3  Change the first index word.
     4  Search for a certain index word in the index.
     5  Finish editing.
     6  Go back to the previous index word.

     Example:

     If the program displays the following two words:
     Price . . . . . . . . . . . . . 5.3
     Pricing . . . . . . . . . . . . 6.7

     then the command 1 will change this to:

     Price . . . . . . . . . . . . . 5.3, 6.7

     A  suggestion:  Use  many worded index terms and try to imagine not
     only which words you would use to search for information  but  also
     which words other people would use.

     A  fuller manual for the INDEX program is available in Swedish from
     FOA 1 rapportcentral, 104 50 Stockholm 80, report no C 10016.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 53

5.4  ARNF - LEFT-RIGHT-PAGINATION

     The  ARNF program can be used to convert a text produced with VIDED
     or RUNOFF so that odd page numbers are in the upper  right  corner,
     even  page  numbers  in the upper left corner, for printing on both
     paper sides.

     ARNF  can  also  be  used  to  move  certain characters, which your
     printer cannot handle properly, to the margin  outside  the  proper
     text,  to  make  it  simpler for you to manually insert the correct
     characters in the listings.

5.5  OVHEAD - BIG TEXT AND OVERHEAD PICTURES

     OVHEAD can be used to produce big letters using the CALCOMP plotter
     for signposts, overhead pictures  etc.  For  more  information  see
     HLP:OVHEAD.HLP.

5.6  MARG - SET MARGIN AND TAB STOPS ON TERMINAL

     MARG  is  a  program  f`r  setting the left margin and tab stops on
     terminals of type GNT,  TERMINET  or  DIABLO.  When  running  MARG,
     answer  the  first  question with G for GNT and TERMINET, with D if
     you have a DIABLO terminal with wide paper, with A if  you  have  a
     DIABLO terminal with narrow paper (e.g. upright A4 paper).

     Answer the second question with the wanted left margin.

     MARG  will also set tab stops and .TTY TAB. This means that in most
     cases, you can get faster typeout of your files by the command
     .type/c fil.ext

     MARG will set .TTY GAG, so that your nicely margined printouts will
     not be cluttered up with messages from other users.

     MARG will set .TTY FORM and .TTY BLANKS so that new pages and blank
     lines will be printed correctly.

     MARG will set a suitable .TTY WIDTH but also .TTY NO CRLF (no right
     margin). If you want too long lines  to  be  divided  into  several
     output lines, type .TTY CRLF after running MARG.

     On DIABLO terminals, MARG will set .TTY FILL 0.

     Normally,  MARG  will  set  TABS  at  the  standard  distances of 8
     character positions between each TAB. You can however get  MARG  to
     set TABS at any other positions.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 54
5.6  MARG - SET MARGIN AND TAB STOPS ON TERMINAL

     Example;  You  have  a  file  containing  the  text  (<HT> is a TAB
     character in your file):
     Name<TAB>Age<TAB>Telephone number
     Eliza<TAB>23<TAB>23 45 99
     Eve<TAB>25<TAB>45 23 99

     You want this file typed in the following manner:
     Name      Age     Telephone number
     Eliza     23      23 45 99
     Eve       25      45 23 99

     Then first prepare a file (e.g. file.ext) with the content:
     Name----- Age---- Telephone-number

     And call marg in the following manner:
     .RUN PUB:MARG-FILE.EXT
     (Where file.ext is the name of the file you have prepared.)

     If  called  in  this  manner,  MARG  will set a tab in the position
     following each blank space in the first line of the file  given  to
     the MARG program.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 55

5.7  VIDEDC - PRODUCE MULTI-COLUMN OUTPUT

  VIDEDC is a program to convert a      Switches:
  single-column text to a multi-
  column text. The page you are         /COLUMNS:n to indicate wanted
  reading now was produced with         number of columns in output.
  VIDEDC.
                                        /TABS move from column to column
  .RUN VIDEDC                           by outputting a horizontal
  %VIDEDC VERSION 1 IS HERE             tab character. This
  *outfil.ext=infil.ext/switches        a) Requires that horizontal tabs
  Input no of columns: 2                   have been set on the terminal.
  Input tab positions for all except       The "MARG" program can be used
  the first column:                        to set such tabs at arbitrary
  40                                       positions.
  Give page numbers from input file:    b) Gives faster output than
  8 1                                      simulating tabs with spaces.
  Give page numbers from input file:    c) Is the only possible choice if
  2 7                                      the input file contains back-
  Give page numbers from input file:       space characters or special
  6 3                                      terminal control characters
  Give page numbers from input file:       (such as VIDEDP produces for
  4 5                                      Diablo terminals with the
  Give page numbers from input file:       VIDEDP commands .A or .J).
  -1
                                        /DIABLO indicates output to a
  Combining VIDEDP with VIDEDC:         Diablo 1620 terminal. Note that
  Always use VIDEDP first, and then     VIDEDC can correctly handle files
  use VIDEDC on the file produced by    containing half-line-feed control
  VIDEDP. If you use the special        and changing horizontal motion
  facilities for even right margins     index, but n o t negative half-
  in VIDEDP, then the /TABS switch      line-feeds and changing vertical
  must be given to VIDEDC.              motion index.

  If you want one column to be          /TERMINET indicates output to a
  blank, write the page number 0.       Terminet terminal.
  Page number -1 indicates end of
  execution.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 56

6. THE VIDED DISTRIBUTION TAPE AND HOW TO MODIFY VIDED

     This  chapter  is  only of use for the system specialist setting up
     VIDED at a computer site or  who  wants  to  modify  and  recompile
     VIDED.

6.1 SETTING UP VIDED WITHOUT RECOMPILING

     The following files must be copied from the VIDED distribution tape
     to  the  SYS  area (Unless you have later versions of the files al-
     ready on the SYS area):
     VIDED.EXE,SIMR41.EXE,SIMR42.EXE,SIMDD4.ABS

     The following file must be copied to the HLP area: VIDED.HLP

     The following files are recommended but not necessary:
     VIDEDP.EXE,INDEX.SAV,ARNF.SAV,VIDED.MAN

6.2 SIMULA VERSION FOR RECOMPILING VIDED

     To recompile VIDED, you must have SIMULA version 4 or later on SYS.
     SIMULA is available as a separate entry in the DECUS library.

     The  following files, belonging to the SIMULA system, must be taken
     from the VIDED tape to SYS (unless you already have later  versions
     of them on SYS): LIBSIM.REL,LIBSIM.ATR,SIMLIB.REL.

     Note that if the SIMULA version you get has older versions of these
     files, then the versions on the VIDED tape must be used.

6.3 RECOMPILING VIDED

     All  the  MACRO-10 source files on the VIDED distribution tape must
     be reassembled. VTMVDA.MAC  must  be  assembled  before  the  other
     files.

     The  following  SIMULA  files  must be compiled in the given order:
     TERMTY.SIM,   SSCAN.SIM,   MMISTA.SIM,   MIDED1.SIM,    MIDED2.SIM,
     MIDED3.SIM, MIDEDB.SIM.

     If  you  want to produce a production version of VIDED, these files
     should be compiled with the compiler switches (-D-I-A-Q). There  is
     a MIC file MIDED1.MIC on the distribution tape to simplify this.

6.4 RELOADING VIDED

     To produce a DEBUG version of VIDED, just type "LOAD MIDEDB".

     To  produce  a production version of VIDED (with all reentrant code
     in the high segment), you must use the MIC file VILINK.MIC which is
     available on the VIDED distribution tape.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 57
6. THE VIDED DISTRIBUTION TAPE AND HOW TO MODIFY VIDED

6.5 ADDING A NEW TERMINAL MODEL

6.5.1 ADDING A TERMINAL MODEL WITHOUT RECOMPILING

     When  running  VIDED, you can answer "display" to the question from
     VIDED about terminal type. VIDED will then  ask  you  to  push  the
     cursor  control  keys  on  your terminal. In many cases, VIDED will
     then run, although not using all facilities of your terminal.

     You can also produce a MIC file to do the same thing for you.

6.5.2 REQUIREMENTS ON THE TERMINAL FOR USE WITH VIDED

     Minimum  requirements on a terminal for VIDED to run on it are that
     there are control codes which can be sent from the computer to  the
     terminal to:
   > Move the cursor to a fixed home position on the screen.
   > Move the cursor one step up, down, left and right.
   > The  "Carriage  Return" character moves the cursor to the beginning
     of the line.
   > The  "Line  Feed"  character  moves  the  cursor one line down, and
     scrolls the screen if at the bottom of the screen.

     Also, VIDED requires that all character positions on the screen can
     be individually overwritten.

     In  addition  to the above, it is a great advantage if the terminal
     has the following characteristics:

   > The "Delete" character code (octal 177) has no effect at all on the
     terminal (does not show up as a white rectangle on the screen).
   > The  cursor  control  codes  are  either one character in the range
     octal 0-37, or the "escape" character followed  by  one  additional
     control character.
   > The home position is in the upper left corner of the screen.
   > The  cursor control codes do not use the following character codes:
     ^O, ^T, ^U.

     Also very valuable are the following terminal characteristics:
   > A Direct-Cursor-Addressing facility.
   > Control  codes  for "Insert Character", "Delete Character", "Insert
     Line" and "Delete Line".
   > A facility for two modes of showing text on the screen, e.g. normal
     and inverse video, underlined, or dim mode.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 58
6. THE VIDED DISTRIBUTION TAPE AND HOW TO MODIFY VIDED

6.5.3 ADDING A NEW TERMINAL TYPE NAME

6.5.3.1 MODIFYING TERMTY.SIM

     First  modify  the  file TERMTY.SIM. Add your terminal model to the
     menu output by the procedure "type_menu".

     Increase  the  dimension  of  the array "tr" to accomodate your new
     terminal models.

     Then find the statement "ts:-". Add your terminal model in the text
     constant, immediately before "DISPLAY" at the end of the list.

     Your  terminal model will be given an integer number, corresponding
     to its position in this list. For example, "vista" is number 1, "vt
     100" is number 21. Your terminal will get the next free number.

     Use  this  number  when  modifying  the  procedures  "ldefault" and
     "cdefault" which are to return the number of lines  on  the  screen
     (ldefault)  and  one  less  than  the number of characters per line
     (cdefault).

6.5.3.2 MODIFYING VISTA.SIM

     In the file "VISTA.SIM" there are three integer declarations
     INTEGER fut1, fut2, fut3;
     Exchange one of them for the name of your terminal model, e.g.
     INTEGER myterm, fut2, fut3;

     Find  the  statement  "vt100:= 21" towards the end of VISTA.SIM and
     add a statement "myterm:=  22"  or  whatever  integer  number  your
     terminal got in TERMTY.SIM.

     Find  the statement "IF terminaltype = volkerd414h" and add a simi-
     lar section for your terminal model.

     If  any  of  your  terminal control codes are to be preceded by the
     "escape" character, then set "ADDALTMODE:= TRUE".

     For  any  terminal  control  code  which  is  not to be preceded by
     "escape" even though "addaltmode" is TRUE, make  the  corresponding
     Boolean variable TRUE, e.g. "LEFTSINGLE:= TRUE" if the code to move
     the cursor left one step is not preceded by escape.

     The  text  variables deleteline, insertline, deletechar and insert-
     char are only to be given values if your terminal can  handle  such
     codes.  Add  enough  filler  characters  at the end of these texts,
     since many terminals take some time to perform these actions.

     Thereafter  recompile  TERMTY.SIM, VISTA.SIM and CAT.SIM and see if
     the "CAT" program works on your terminal.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 59
6. THE VIDED DISTRIBUTION TAPE AND HOW TO MODIFY VIDED

     When  CAT works, add direct-cursor-addressing code if your terminal
     can  do  direct-cursor-addressing.  This  code  is  found  in   the
     procedure   "move_the_cursor_to"   in  VISTA.SIM.  Also,  now,  set
     "DIRECT_CURSOR_ADDRESSING:= TRUE" for your terminal type.

     Try  the  CAT  program  again to see if it works with direct cursor
     addressing.

6.5.3.3 MODIFYING VTMCUR.MAC

     If  you  did  modify  the  procedure "move_the_cursor_to", then the
     assembler language version VTMCUR.MAC of  this  procedure  used  by
     VIDED must also be modified in the same way.

6.5.3.4 PRODUCING MMISTA.SIM

     By  running  the  program  COCOS,  you  can  convert "VISTA.SIM" to
     "MMISTA.SIM".  Answer   MACRO=FALSE,   CALLMAC=TRUE,   MVISTA=TRUE,
     SIMULATION=FALSE, SIMSET=FALSE to the questions from COCOS.

     If  you  added  any variable declarations to VISTA, you may have to
     create a new VTMVDA.MAC from VISTA:SIM with COCOS.  In  this  case,
     answer similarly except MACRO=TRUE.

     After   changing   VTMVDA.MAC,   you  must  reassemble  VTMCUR.MAC,
     VTISNG.MAC, VTSYNK.MAC.

     Thereafter  compile MMISTA.SIM, MIDED1.SIM, MIDED2.SIM, MIDED3.SIM,
     MIDEDB.SIM, load and see if VIDED works.

6.5.3.5 IF VIDED DOES NOT WORK

     Possibly,  your  terminal  has some special way of working. You can
     find the places in VISTA.SIM and  MIDED?.SIM  where  terminal  type
     dependencies  crop  up  by searching for "IF terminaltype =" in the
     source files.

6.6. OTHER KINDS OF CODE MODIFICATIONS

     MMISTA.SIM  contains  basic procedures for controlling the terminal
     screen. MIDED3.SIM contains:
   > First  a  section  for  interpreting  the  command  line given when
     starting VIDED, reading SWITCH.INI etc.
   > A   very   important  procedure  "get_command"  which  handles  the
     interpretation of VIDED editing commands.
   > A procedure "edit" to handle characters from the terminal which are
     to become part of the text.

     MIDED1.SIM  and MIDED2.SIM contain procedure to perform the various
     VIDED editing commands. See the procedure "get_command"  in  MIDED3
     to find which procedure does what.


VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 60

7. MORE INFORMATION ABOUT VIDED

     The  following files on the DECUS VIDED distribution tape may be of
     interest to you:

     VIDED.BLB   Short description of VIDED and list of files on the tape
     VIDED.HLP   The help file
     VISTA.MAN   About the handling of terminal screens

     The  DECUS  distribution  tape  also contains full source files for
     VIDED.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 61

8. INDEX

 --- A ---

A command . . . . . . . . . . . . . 2.4
Accent, superimposed on other character . . 5.2
Adding text . . . . . . . . . . . . 2.5
Addres screen command . . . . . . . 2.4
Adjustment of page size, &PS command  . . 2.9
ALTMODE key . . . . . . . . . . . . 2.3
Ampersand '&' command start marker  . . 2.3
/AUTOBACKUP switch  . . . . . . . . 2.1.2
Auxilliary programs . . . . . . . . 5

 --- B ---

Backup file . . . . . . . . . . . . 2.1
Backup of file command, introduction  . . 1.12
Backup of files command . . . . . . 2.11
Backup, automatic . . . . . . . . . 2.1.2
Baude, less than 2400, use of . . . 2.9
Beehive terminal  . . . . . . . . . 4
Beginning an editing session  . . . 2.1
Big text production . . . . . . . . 5.5
Board production  . . . . . . . . . 5.5
Both paper sides, printing on . . . 5.4
Bottom of page command, introduction  . . 1.9
Box copying . . . . . . . . . . . . 2.8

 --- C ---

C command . . . . . . . . . . . . . 2.11
/C switch for number of characters/line . . 2.1.2
Calling other programs from VIDED . 2.1.4
Calling VIDED from other programs . 2.1.4
Carriage Return character . . . . . 2.13
Carriage Return key . . . . . . . . 2.4
CDC 713-10 terminal . . . . . . . . 4
Centering line, &LC command . . . . 2.7
Centering of several lines with one command . . 2.12
Changes marked in left margin . . . 5.1
Character deletion  . . . . . . . . 2.6
Characters, non-printable . . . . . 2.13
Circumflex, superimposed on other character . . 5.2
& command start marker  . . . . . . 2.3
Commands to VIDED, introduction . . 1.3
Commands to VIDED, typing of  . . . 2.3
Commands, short list of . . . . . . 3.1.2
Comparing two versions of the same text . . 5.1

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 62
8. INDEX

CONTROL-C key . . . . . . . . . . . 2.11
CONTROL-D key . . . . . . . . . . . 2.6
CONTROL-F key . . . . . . . . . . . 2.3
CONTROL-L key . . . . . . . . . . . 2.10
CONTROL-U key . . . . . . . . . . . 2.6
CONTROL-W key . . . . . . . . . . . 2.6
Copying files . . . . . . . . . . . 3.2
Copying text  . . . . . . . . . . . 2.8
Copying text, introduction  . . . . 1.8
/COUNT switch to indicate how to number pages . . 2.1.2
CURSOR  . . . . . . . . . . . . . . 1.1
Cursor addressing, direct, /DCA switch  . . 2.1.2
Cursor movement . . . . . . . . . . 2.4
Cursor movement key on DATAMEDIA ELITE 1520 . . 2.4
Cursor movement, introduction . . . 1.2, 1.4
Curve, example  . . . . . . . . . . 1.1

 --- D ---

D command . . . . . . . . . . . . . 2.6
D command, introduction . . . . . . 1.6
DATAMEDIA ELITE 1520 terminal . . . 0, 2.1, 4
DATAMEDIA ELITE 1520 terminal cursor move key . . 2.4
Date on top of first page . . . . . 1.9
/DCA switch for direct cursor addressing  . . 2.1.2
DEC VT52 and VT100 terminals  . . . 2.1
Default values in SWITCH.INI file . 2.1, 2.1.2
DEL key . . . . . . . . . . . . . . 2.6
Delete command  . . . . . . . . . . 2.6
DELETE key  . . . . . . . . . . . . 2.6
DELETE key, introduction  . . . . . 1.6
Deleting files  . . . . . . . . . . 3.2
Deletion of text  . . . . . . . . . 2.6
Deletion of text, introduction  . . 1.6
Diablo terminal . . . . . . . . . . 5.2
Diagram, example  . . . . . . . . . 1.1
Difference between two text versions  . . 5.1
Digital VT52 and VT100 terminal . . 4
Direct cursor addressing  . . . . . 2.4
Direct cursor addressing, /DCA switch . . 2.1.2
Directory of file names . . . . . . 3.2
Divide page command . . . . . . . . 2.9
Divide word command . . . . . . . . 2.7
Dividing lines  . . . . . . . . . . 2.5
DOWN key  . . . . . . . . . . . . . 1.2, 2.4
DOWN key on ELITE 1520 terminal . . 2.4
Duplication of text . . . . . . . . 2.8

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 63
8. INDEX

 --- E ---

E command . . . . . . . . . . . . . 2.11
E command, introduction . . . . . . 1.11
Elite terminals . . . . . . . . . . 0, 2.1, 4
End of file searching, &PF command  . . 1.9, 2.9
End of line command . . . . . . . . 2.4
End of page command . . . . . . . . 2.9
End of page command, introduction . 1.9
End of text searching, &PF command  . . 2.9
Error protection, &FB command . . . 2.11
Errors in screen, not in file . . . 2.10
ESCAPE key  . . . . . . . . . . . . 2.3
Even right margin . . . . . . . . . 2.7
Even right margin, extra neat . . . 5.2
Exiting from VIDED  . . . . . . . . 2.11
Exiting from VIDED, introduction  . 1.11
Extensions to file names  . . . . . 3.2

 --- F ---

F- command  . . . . . . . . . . . . 2.7
Faults in screen, not in file . . . 2.10
FB command, file backup . . . . . . 2.11
FC command, compacting with ragged right margin . . 2.7
FI command, filling with ragged right margin  . . 2.7
Figure production . . . . . . . . . 2.8
FILCOM file comparing program . . . 5.1
File Backup command, introduction . 1.12, 2.11
File backup, automatic  . . . . . . 2.1.2, 2.11
File comparing  . . . . . . . . . . 5.1
File names  . . . . . . . . . . . . 3.2
Filling command . . . . . . . . . . 2.7
Filling of slow terminal screen . . 2.9
Filling pages, &PS command  . . . . 2.9
Find end of file, introduction  . . 1.9
Flow diagram  . . . . . . . . . . . 2.8
Flow diagram, example . . . . . . . 1.1
Form feed . . . . . . . . . . . . . 2.12
FORMFEED key  . . . . . . . . . . . 2.10
Formula handling  . . . . . . . . . 2.12
Formulas with subscripts and superscripts . . 2.12, 5.2
Full description of the VIDED commands  . . 2

 --- G ---

G command . . . . . . . . . . . . . 2.8
G command, introduction . . . . . . 1.8
Get from Q-register commands  . . . 2.8

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 64
8. INDEX

 --- H ---

H command . . . . . . . . . . . . . 2.10
H command, introduction . . . . . . 1.10
Half step line feeds  . . . . . . . 5.2
Header  . . . . . . . . . . . . . . 2.9
Header on top of pages  . . . . . . 1.9
Help command  . . . . . . . . . . . 2.10
HOME key  . . . . . . . . . . . . . 1.2, 2.4

 --- I ---

I command . . . . . . . . . . . . . 2.5
I command, introduction . . . . . . 1.5
Index . . . . . . . . . . . . . . . 5.3, 6.
Index letters, half step above and below main line  . .
                                    5.2
Index like the one you are reading just now . . 5.3
INFOTON terminals . . . . . . . . . 0, 2.1
Initial values in SWITCH.INI file . 2.1
Input file  . . . . . . . . . . . . 2.1
Inputting text  . . . . . . . . . . 2.2
Insert space command  . . . . . . . 2.5
Insertion and justification, combining  . . 2.7
Insertion and justification, introduction . . 1.7
Insertion of text . . . . . . . . . 2.5
Insertion of text, introduction . . 1.5
Introduction to VIDED . . . . . . . 1.

 --- J ---

/JE switch to indicate how paragraph ends . . 2.1.2
JU command  . . . . . . . . . . . . 2.7
JU command, introduction  . . . . . 1.7
Jumbled screen, restoration of  . . 2.10
Justification of paragraphs . . . . 2.7
Justification of paragraphs, introduction . . 1.7
Justification, where to end, /JE switch . . 2.1.2

 --- K ---

K command . . . . . . . . . . . . . 2.6
K command, introduction . . . . . . 1.6

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 65
8. INDEX

 --- L ---

L and JU commands combined, introduction  . . 1.7
L command, introduction . . . . . . 1.5
/L switch for number of lines on screen . . 2.1.2
Large text production . . . . . . . 5.5
Last page finding, &PF command  . . 2.9
Last word deletion  . . . . . . . . 2.6
LC command, centering line  . . . . 2.7
LEFT key  . . . . . . . . . . . . . 1.2, 2.4
LEFT key on ELITE 1520 terminal . . 2.4
Left margin . . . . . . . . . . . . 2.1, 2.7
Left-right pagination for both side printing  . . 5.4
Length of lines . . . . . . . . . . 2.12
Line deletion . . . . . . . . . . . 2.6
Line divide command . . . . . . . . 2.5
Line feed . . . . . . . . . . . . . 2.12
Line feed, half stepped . . . . . . 5.2
Line insertion command  . . . . . . 2.5
Line length . . . . . . . . . . . . 2.12
Line-numbered file, creation of . . 2.1
Line-numbers, deletion of . . . . . 2.1
Lines per page, number of . . . . . 2.1
Listing file names  . . . . . . . . 3.2
LL command, line lowcase  . . . . . 2.7
Logging in  . . . . . . . . . . . . 3.2
Logging out . . . . . . . . . . . . 3.2
Loop command  . . . . . . . . . . . 2.12
Lowcasing line, &LL command . . . . 2.7
LU command, line upcase . . . . . . 2.7

 --- M ---

Machine error protection, &FB command . . 2.11
Many lines affected by one command  . . 2.12
Margin, left and right  . . . . . . 2.1, 2.7
Margin, right, even, extra neat . . 5.2
Minibee terminal  . . . . . . . . . 4
MINITEC terminals . . . . . . . . . 0, 2.1
ML command  . . . . . . . . . . . . 2.7
/ML switch for left margin  . . . . 2.1.2
Moving several lines left or right on the screen  . . 2.12
Moving text . . . . . . . . . . . . 2.8
Moving text, introduction . . . . . 1.8
Moving the cursor on the screen . . 2.4
Moving to a certain page number, &PT command  . . 2.9
MR command  . . . . . . . . . . . . 2.7
/MR switch for right margin . . . . 2.1.2
Multi-line application of command . 2.12
Multiwriting on same character position . . 5.2

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 66
8. INDEX

 --- N ---

N command . . . . . . . . . . . . . 2.4, 2.9
N command, introduction . . . . . . 1.4
/N switch for line numbered file creation . . 2.1.2
New and old version of the same text, comparing . . 5.1
New text insertion  . . . . . . . . 2.5
Next page, &P command . . . . . . . 2.9
Number of lines per page  . . . . . 2.1
Number of page, left/right adjustment of  . . 5.4
Numbering of lines  . . . . . . . . 2.1

 --- O ---

O command . . . . . . . . . . . . . 2.10
O command, introduction . . . . . . 1.10
Old and new version of the same text  . . 5.1
One-page summary of commands  . . . 3.
/OPTION to read selected SWITCH.INI lines . . 2.1.2
Output file . . . . . . . . . . . . 2.1
Overhead picture production . . . . 5.5

 --- P ---

P command . . . . . . . . . . . . . 2.9
P command, introduction . . . . . . 1.9
/P switch for title, page number on page tops . . 2.1.2
Page choice command &PT, &PE  . . . 1.9
Page choice commands, &PT and &PE . 2.9
Page handling . . . . . . . . . . . 2.9
Page handling, introduction . . . . 1.9
Page number, left/right adjustment of . . 5.4
Page size adjustment, &PS command . 2.9
Page size, number of lines  . . . . 2.1
Paper sides, printing on both . . . 5.4
Paragraph justification . . . . . . 2.7
Paragraph justification, introduction . . 1.7
Paragraph, how it ends, /JE switch  . . 2.1.2
Password at logging in  . . . . . . 3.2
PF command, end of file finding . . 2.9
PI command  . . . . . . . . . . . . 2.9
Picture production, examples  . . . 1.1
Plotting of big text  . . . . . . . 5.5
Position to type = CURSOR . . . . . 1.1
Printing on both paper sides  . . . 5.4
Protection against machine error, &FB command . . 2.1.2,
                                    2.11
Protection code . . . . . . . . . . 2.12

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 67
8. INDEX

 --- Q ---

Q command . . . . . . . . . . . . . 2.8
Q command, introduction . . . . . . 1.8
Q-register store and get commands . 2.8

 --- R ---

R command . . . . . . . . . . . . . 2.10
R command, introduction . . . . . . 1.10
Ragged right margin . . . . . . . . 2.7
Rectangle copying . . . . . . . . . 2.8
Renaming files  . . . . . . . . . . 3.2
Reordering text . . . . . . . . . . 2.8
Restoring of jumbled screen . . . . 2.10
Restrictions  . . . . . . . . . . . 2.12
Restrictions in VIDED . . . . . . . 2.13
RETURN key  . . . . . . . . . . . . 2.4
RETURN key, introduction  . . . . . 1.2
RETURN key, used for scrolling  . . 1.1
RIGHT key . . . . . . . . . . . . . 1.2, 2.4
RIGHT key on ELITE 1520 terminal  . 2.4
Right margin  . . . . . . . . . . . 2.1, 2.7
Right margin, even or ragged  . . . 2.7
Right margin, even, extra neat  . . 5.2
RUB OUT key . . . . . . . . . . . . 2.6
RUB OUT key, introduction . . . . . 1.6
/RUN switch to indicate what to call when exiting . .
                                    2.1.2
Running other programs from VIDED . 2.1.4
Running program after VIDED, /RUN switch  . . 2.1.2
Running programs  . . . . . . . . . 3.2
Running VIDED . . . . . . . . . . . 2.1
Running VIDED from other programs . 2.1.4

 --- S ---

S command . . . . . . . . . . . . . 2.4
S command, introduction . . . . . . 1.4
/S switch limits no of lines shown at slow speed  . .
                                    2.1.2
Saving file, automatic  . . . . . . 2.1.2
Scrolling . . . . . . . . . . . . . 1.1
Scrolling, &Z command . . . . . . . 1.9, 2.7, 2.9
Search command  . . . . . . . . . . 2.4
Search command, across page boundaries  . . 2.9
Search command, introduction  . . . 1.4
Security against machine error command &FB  . . 2.11
Security against machine error, automatic . . 2.1.2
Selecting lines from SWITCH.INI file  . . 2.1.3
Selecting lines from SWITCH.INI, /OPTION  . . 2.1.2
Selecting page commands, &PT and &PE  . . 2.9

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 68
8. INDEX

Set tab settings  . . . . . . . . . 2.4
Several lines affected by one command . . 2.12
Shifting several lines left or right on the screen  . .
                                    2.12
Shifting text left and rightwards &V and &D . . 2.5, 2.12
Short listing of commands . . . . . 3.
Size of pages, adjustment, &PS command  . . 2.9
Size of pages, in number of lines . 2.1
Skip to end of line command . . . . 2.4
Slow terminal connctions, /S switch . . 2.1.2
Slow terminals  . . . . . . . . . . 2.9
Starting an editing session . . . . 2.1
Status type command . . . . . . . . 2.10
Store in Q-register commands  . . . 2.8
Subheader on top of pages . . . . . 1.9
Subscripts  . . . . . . . . . . . . 5.2
Summary of commands . . . . . . . . 3.
Superimposing two characters on top of each other . . 5.2
Superscripts  . . . . . . . . . . . 5.2
/SWEDISH switch for swedish language text . . 2.1.2
SWITCH.INI file, reading of . . . . 2.1, 2.1.3
SWITCH.INI file, selecting lines from . . 2.1.3
SWITCH.INI file, switches which can be given in . . 2.1.2
SWITCH.INI, selecting lines from, /OPTION . . 2.1.2
Switches, default, to be given in SWITCH.INI file . .
                                    2.1.2

 --- T ---

T command . . . . . . . . . . . . . 2.4
/T switch for terminal type . . . . 2.1.2
Tab characters in the file  . . . . 2.12
TAB key . . . . . . . . . . . . . . 2.4
TAB key, introduction . . . . . . . 1.2
Tab settings, default values  . . . 2.4
Tab settings, making  . . . . . . . 2.4
Tab settings, restoring . . . . . . 2.4
Tab settings, zeroing of  . . . . . 2.4
Table handling  . . . . . . . . . . 2.12
Table production  . . . . . . . . . 2.8
Table, example  . . . . . . . . . . 1.1
Tandberg TDV 2000 terminal  . . . . 4
TEC terminals . . . . . . . . . . . 0, 2.1, 4
TELETEC terminals . . . . . . . . . 0, 2.1, 4
Terminal type dependencies  . . . . 4
Terminal types  . . . . . . . . . . 0, 2.1
Terminal, slow  . . . . . . . . . . 2.9
Text comparing program  . . . . . . 5.1
Text deletion . . . . . . . . . . . 2.6
Text deletion, introduction . . . . 1.6
Text input  . . . . . . . . . . . . 2.2

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                             PAGE 69
8. INDEX

Text insertion  . . . . . . . . . . 2.5
Text insertion, introduction  . . . 1.5
Todays date on top of first page  . 1.9
Top of page command . . . . . . . . 2.9
Top of page command, introduction . 1.9
Transfer from other programs to VIDED . . 2.1.4
Transfer from VIDED to other programs . . 2.1.4
Transferring text . . . . . . . . . 2.8
Typing text . . . . . . . . . . . . 2.2
TZ command  . . . . . . . . . . . . 2.4

 --- U ---

U command . . . . . . . . . . . . . 2.6
U command, introduction . . . . . . 1.6
Underlining . . . . . . . . . . . . 5.2
UP key  . . . . . . . . . . . . . . 1.2, 2.4
UP key on ELITE 1520 terminal . . . 2.4
Upcasing line, &LU command  . . . . 2.7
Updated version of file, comparing with old . . 5.1
Upper casing of several lines with one command  . . 2.12

 --- V ---

V command . . . . . . . . . . . . . 2.5
Versions of the same text, comparing them . . 5.1
VIDED commands, typing of . . . . . 2.3
VIDEDP program for even right margin, extra neat  . . 5.2
VIDEDP program for underlining, subscripts  . . 5.2
Vista terminals . . . . . . . . . . 2.1
VT52 and VT100 terminal . . . . . . 4

 --- W ---

W command . . . . . . . . . . . . . 2.6
W command, introduction . . . . . . 1.6
Word deletion command . . . . . . . 2.6

 --- X ---

X command . . . . . . . . . . . . . 2.4
X command, introduction . . . . . . 1.4

 --- Z ---

Z command, scrolling text . . . . . 2.9
Zero tab settings . . . . . . . . . 2.4
   
