	SUBROUTINE LLPHIT(DISNUM, X, Y)
C************************************************************
C
C  THIS ROUTINE IS USED TO RETURN THE DISPLAY NUMBER
C  AND THE USER (X, Y) OF THE PREVIOUS LIGHT PEN HIT.
C
C  POSSIBLE ERRORS:
C	?INVALID REPLY TO LLPHIT (RETURNS DISNUM = 0)
C
C  ROUTINES CALLED:
C	SEND   - SENDS A COMMAND TO THE GT40
C	GET    - RECEIVES A STATUS TRANSMISSION FROM THE GT40
C	USERX  - RETURNS USER X FROM RASTER IX
C	USERY  - RETURNS USER Y FROM RASTER IY
C	ERROR  - ERROR LOGGING ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - W, Z)
	REAL USERX, USERY

100	CALL SEND(8, 0, 0, 0)
	CALL GET(STATUS, IX, IY, DISNUM)
	IF(STATUS .EQ. "66) GO TO 100
	IF(STATUS .NE. 0) GO TO 200
	X = USERX(IX)
	Y = USERY(IY)
	RETURN

200	CALL ERROR('?INVALID REPLY TO LLPHIT, STATUS =',STATUS)
	DISNUM = 0
	X = 0.
	Y = 0.
	RETURN
	END
