      SUBROUTINE  PLTKC (Z1,ZE,Z2,NZ,KX,NX,KY,NY,PL)

C     [CONTOUR A COMPLEX FUNCTION]
C     ZE(NX,NY)  ARRAY OF FUNCTION VALUES
C     Z1,Z2      RANGE OF ABSOLUTE VALUES
C     NZ         NUMBER OF CONTOURS OF ABSOLUTE VALUE
C     (THE ARGUMENT IS CONTOURED AT 30 DEGREE INTERVALS
C                FROM -180 DEGREES TO 180 DEGREES)
C     KX,KY      NUMBER OF BLOCKS IN X AND Y DIRECTIONS
C     PL         PEN MOVEMENT SUBROUTINE
C     [05-MAR-74]

      EXTERNAL    CABS,CARG,PL
      COMPLEX     ZE(1)
      DATA        PI,NA/3.14159,13/

      I0=MAX0(NX/(2*KX),1)
      J0=MAX0(NY/(2*KY),1)
      IX=2*I0
      IY=2*J0
      DZ=(Z2-Z1)/FLOAT(NZ-1)
      DA=PI/6.0

      II=I0+1
      JJ=J0+1
   10 JA=MAX0(JJ-J0,1)
      JB=MIN0(JJ+J0,NY)
   20 IA=MAX0(II-I0,1)
      IB=MIN0(II+I0,NX)
      Z=Z1
      DO 30 K=1,NZ
      CALL KONSK (Z,IA,IB,JA,JB,ZE,NX,NY,CABS,PL)
   30 Z=Z+DZ
      A=-PI
      DO 40 K=1,NA
      CALL KONSK (A,IA,IB,JA,JB,ZE,NX,NY,CARG,PL)
   40 A=A+DA
      II=II+IX
      IF ((II-I0.LT.NX).AND.(II+I0.GT.1)) GO TO 20
      IX=-IX
      II=II+IX
      JJ=JJ+IY
      IF (JJ-J0.LT.NY) GO TO 10
      RETURN
      END
      SUBROUTINE  PLTKP (Z1,ZE,Z2,NZ,KX,NX,KY,NY,PL)

C     [CONTOUR PLOT]
C     FUNCTION VALUES TAKEN FROM AN ARRAY
C     ZE(NX,NY)  ARRAY TO BE CONTOURED
C     (Z1,Z2)    CONTOURING INTERVAL
C     (KX,KY)    NUMBER OF X- AND Y-SUBDIVISIONS
C     NZ         NUMBER OF CONTOUR LEVELS
C     PL         PEN MOVEMENT SUBROUTINE, PERHAPS PLTCA
C     [16-FEB-74]

      EXTERNAL    PL
      DIMENSION   ZE(1)

      I0=MAX0(NX/(2*KX),1)
      J0=MAX0(NY/(2*KY),1)
      IX=2*I0
      IY=2*J0
      DZ=(Z2-Z1)/FLOAT(NZ-1)

      II=I0+1
      JJ=J0+1
   10 JA=MAX0(JJ-J0,1)
      JB=MIN0(JJ+J0,NY)
   20 IA=MAX0(II-I0,1)
      IB=MIN0(II+I0,NX)
      Z=Z1
      DO 30 K=1,NZ
      CALL KONSC (Z,0.0,0.0,IA,IB,JA,JB,ZE,NX,NY,PL)
   30 Z=Z+DZ
      II=II+IX
      IF ((II-I0.LT.NX).AND.(II+I0.GT.1)) GO TO 20
      IX=-IX
      II=II+IX
      JJ=JJ+IY
      IF (JJ-J0.LT.NY) GO TO 10
      RETURN
      END
      SUBROUTINE  PLTKX (Z1,ZE,Z2,NX,NY,PL)

C     [X-CROSSHATCHING]
C     MARK OFF THE REGION OF A PLANE IN WHICH AN ARRAY STORED FUNCTION
C     LIES WITHIN A SELECTED INTERVAL. HORIZONTAL LINES ARE DRAWN WHOSE
C     POSITION CORRESPONDS TO THE ARRAY POINTS, AND WHOSE EXTENT IS
C     DETERMINED BY LINEAR INTERPOLATION.
C     ZE(NX,NY)   DATA ARRAY
C     (Z1,Z2)     INTERVAL TO BE MARKED
C     PL          PEN MOVEMENT SUBROUTINE, PERHAPS PLTCA
C     [05-JAN-75]

      EXTERNAL    PL
      DIMENSION   ZE(1)

      IX(I,J)=I+NX*(J-1)
      VI(Z)=(Z-Z1)*(Z2-Z)

      X=0.0
      Y=0.0
      DX=1.0/FLOAT(NX-1)
      DY=1.0/FLOAT(NY-1)
      DO 30 J=1,NY,2
      CALL PL (X,Y,.FALSE.)
      DO 10 I=2,NX
      I1=IX(I-1,J)
      I2=IX(I,J)
      CALL PLTIL (X,Y,VI(ZE(I1)),X+DX,Y,VI(ZE(I2)),PL)
   10 X=X+DX
      DX=-DX
      Y=Y+DY
      IF (J.GE.NY) RETURN
      CALL PL (X,Y,.FALSE.)
      DO 20 I=2,NX
      I1=IX(NX-I+2,J+1)
      I2=IX(NX-I+1,J+1)
      CALL PLTIL (X,Y,VI(ZE(I1)),X+DX,Y,VI(ZE(I2)),PL)
   20 X=X+DX
      DX=-DX
   30 Y=Y+DY
      RETURN
      END
      SUBROUTINE  PLTKY (Z1,ZE,Z2,NX,NY,PL)

C     [Y CROSSHATCHING]
C     ZE(NX,NY)   DATA ARRAY
C     (Z1,Z2)     INTERVAL TO BE MARKED
C     PL          PEN MOVEMENT SUBROUTINE, PERHAPS PLTCA
C     [05-JAN-75]

      EXTERNAL    PL
      DIMENSION   ZE(1)

      IX(I,J)=I+NX*(J-1)
      VI(Z)=(Z-Z1)*(Z2-Z)

      X=1.0
      Y=1.0
      DX=-1.0/FLOAT(NX-1)
      DY=-1.0/FLOAT(NY-1)
      DO 30 I=1,NX,2
      CALL PL (X,Y,.FALSE.)
      DO 10 J=2,NY
      I1=IX(NX-I+1,NY-J+2)
      I2=IX(NX-I+1,NY-J+1)
      CALL PLTIL (X,Y,VI(ZE(I1)),X,Y+DY,VI(ZE(I2)),PL)
   10 Y=Y+DY
      DY=-DY
      X=X+DX
      IF (I.GE.NX) RETURN
      CALL PL (X,Y,.FALSE.)
      DO 20 J=2,NY
      I1=IX(NX-I,J-1)
      I2=IX(NX-I,J)
      CALL PLTIL (X,Y,VI(ZE(I1)),X,Y+DY,VI(ZE(I2)),PL)
   20 Y=Y+DY
      DY=-DY
   30 X=X+DX
      RETURN
      END
      SUBROUTINE  PLTLA (I)

C     [LABEL]
C     SOMETIMES IT IS CONVENIENT TO IDENTIFY PLOTTER SHEETS WITH
C     A SHORT LABEL IN THE LOWER MARGIN (MAXIMUM OF 5 LETTERS).
C     PLOTTER ORIGIN IS TAKEN AS PAGE CENTER, SO PLTLA MUST BE
C     CALLED AFTER CALLING PLTFR OR PLTBO, AND BEFORE CALLING
C     PLTEJ.
C     [21-MAR-74]

      CALL SYMBOL (-3.85,4.30,0.2,I,-90.0,5)
      RETURN
      END

C     ------------------------------------------------------------------

      SUBROUTINE  PLTLH (X,Y,P)

C     [LEFT HALF]
C     SCALE THE CARTESIAN COORDINATES (X,Y) SO AS TO POSITION A GRAPH
C     IN THE LEFT HALF OF A PLOTTER PAGE.
C     [20-APR-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/

      CALL PLTMS (HX*(X-1.0),HY*(Y-0.5),P)
      RETURN
      END

C     ------------------------------------------------------------------

      SUBROUTINE  PLTMA (X,Y,X0,Y0)

C     [MARGIN ADJUSTER]
C     PLTMA ADJUSTS THE COORDINATES (X0,Y0) TO PROVIDE A HYPERBOLIC
C     TANGENTIAL DISTORTION (X,Y) OF THE OUTER ONE INCH MARGIN OF A
C     GRAPH, SO THE PEN WILL NEVER RUN OVER THE EDGE OF THE PAGE.
C     [02-NOV-73]

      DATA       HX,HY/4.50,3.25/

      X=X0
      IF (X.GT. HX) X= HX+TANH(X-HX)
      IF (X.LT.-HX) X=-HX+TANH(X+HX)
      Y=Y0
      IF (Y.GT. HY) Y= HY+TANH(Y-HY)
      IF (Y.LT.-HY) Y=-HY+TANH(Y+HY)
      RETURN
      END
      SUBROUTINE  PLTMC (X,Y,S)

C     [MARGIN COMPRESSED]
C     PLTMC (X,Y,S) MOVES THE PEN TO THE POINT (X,Y) ON AN 8-1/2" X 11"
C     SHEET.  HOWEVER, A BORDER IS MAINTAINED 1" FROM THE EDGE, BEYOND
C     WHICH NO PEN MOVEMENT IS PERMITTED.  LINEAR INTERPOLATION IS USED
C     TO OBTAIN AN ACCURATE INTERSECTION OF ANY LINE SEGMENT WHITH THIS
C     MARGIN. IF S=.TRUE. THE PEN IS LOWERED, OTHERWISE THE NEW PEN
C     POSITION IS ONLY NOTED AS (X0,Y0). THE PEN IS ALLOWED TO WRITE IN
C     THIS MARGIN, WHICH IS SUBJECT TO A HYPERBOLIC TANGENT DISTORTION.
C     [02-NOV-73]

      LOGICAL    S,S0,P1,P2,Q

      IF (.NOT.S) GO TO 30
      X1=X0
      Y1=Y0
      X2=X
      Y2=Y
      CALL PLTMT (X1,Y1,P1,X2,Y2,P2,Q)
      IF (S0) GO TO 10
      CALL PLTMA (EX,WY,X0,Y0)
      CALL PLOT  (WY,-EX,3)
   10 IF (Q) GO TO 20
      CALL PLTME (X0,Y0,X,Y)
      GO TO 30
   20 IF (P1) CALL PLTME (X0,Y0,X1,Y1)
      CALL PLOT  (Y2,-X2,2)
      IF (P2) CALL PLTME (X2,Y2,X,Y)
   30 S0=S
      X0=X
      Y0=Y
      RETURN
      END


C     ------------------------------------------------------------------


      SUBROUTINE  PLTME (X1,Y1,X2,Y2)

C     [MARGINAL EXCURSION]
C     N POINTS OF A DISTORTED LINE IN THE MARGIN, AS REQUIRED BY PLTMC.
C     [03-NOV-73]

      N=11
      EN=FLOAT(N-1)
      DX=(X2-X1)/EN
      DY=(Y2-Y1)/EN
      EX=X1
      WY=Y1
      DO 10 I=1,N
      CALL PLTMA (XX,YY,EX,WY)
      CALL PLOT  (YY,-XX,2)
      EX=EX+DX
   10 WY=WY+DY
      RETURN
      END
      SUBROUTINE  PLTMS (X,Y,S)

C     [MARGIN SUPPRESSED]
C     PLTMS (X,Y,S) MOVES THE PEN TO THE POINT (X,Y) ON AN 8-1/2" X 11"
C     SHEET.  HOWEVER, A BORDER IS MAINTAINED 1" FROM THE EDGE, BEYOND
C     WHICH NO PEN MOVEMENT IS PERMITTED. LINEAR INTERPOLATION IS USED
C     TO OBTAIN AN ACCURATE INTERSECTION OF ANY LINE SEGMENT WHITH THIS
C     MARGIN. IF S=.TRUE. THE PEN IS MOVED IN THE LOWERED POSITION,
C     OTHERWISE THE NEW PEN POSITION IS MERELY NOTED AS (X0,Y0). NULL
C     INTERVALS ARE INVISIBLE, SO THE PEN IS NOT RAISED OR LOWERED EVEN
C     THOUGH THIS MOVEMENT HAS BEEN CALLED FOR.
C     [15-MAY-74]

      LOGICAL    S,S0,P0,P1,Q,EQ

      EQ(X,Y)=ABS(X-Y).LE.(1.0E-5)

      IF (S) GO TO 20
   10 S0=.TRUE.
   11 X0=X
      Y0=Y
      RETURN
   20 IF (EQ(X,X0).AND.EQ(Y,Y0)) GO TO 10
      X1=X
      Y1=Y
      CALL PLTMT (X0,Y0,P0,X1,Y1,P1,Q)
      IF (.NOT.Q) GO TO 10
      IF (S0.OR.P0) CALL PLOT (Y0,-X0,3)
      CALL PLOT  (Y1,-X1,2)
      S0=P1
      GO TO 11

      END
      SUBROUTINE  PLTMT (X1,Y1,P1,X2,Y2,P2,Q)

C     [MARGIN TRIMMER]
C     THE POINTS Z1=(X1,Y1) AND Z2=(X2,Y2) ARE ADJUSTED TO ENCOMPASS
C     ONLY THAT PART OF THE LINE JOINING THEM WHICH LIES WITHIN A
C     PLOTTER PAGE WHOSE HALFWIDTHS ARE HX AND HY.
C     P1=.TRUE.  Z1 WAS MOVED
C     P2=.TRUE.  Z2 WAS MOVED
C     Q=.TRUE.   SOME PORTION OF THE LINE IS VISIBLE
C     [02-NOV-73]

      LOGICAL     P1,P2,Q
      DATA        HX,HY/4.50,3.25/

      EX(Y)=X1+(Y-Y1)*((X2-X1)/(Y2-Y1))
      WY(X)=Y1+(X-X1)*((Y2-Y1)/(X2-X1))

      P1=.FALSE.
      IF (ABS(X1).LE.HX) GO TO 5
      IF (X1.EQ.X2) GO TO 20
      X0=SIGN(HX,X1)
      Y1=WY(X0)
      X1=X0
      P1=.TRUE.
    5 IF (ABS(Y1).LE.HY) GO TO 10
      IF (Y1.EQ.Y2) GO TO 20
      Y0=SIGN(HY,Y1)
      X1=EX(Y0)
      Y1=Y0
      P1=.TRUE.
   10 P2=.FALSE.
      IF (ABS(X2).LE.HX) GO TO 15
      IF (X1.EQ.X2) GO TO 20
      X0=SIGN(HX,X2)
      Y2=WY(X0)
      X2=X0
      P2=.TRUE.
   15 IF (ABS(Y2).LE.HY) GO TO 20
      IF (Y1.EQ.Y2) GO TO 20
      Y0=SIGN(HY,Y2)
      X2=EX(Y0)
      Y2=Y0
      P2=.TRUE.
   20 X0=0.5*(X1+X2)
      Y0=0.5*(Y1+Y2)
      Q=(ABS(X0).LT.HX).AND.(ABS(Y0).LT.HY)
      RETURN
      END
      SUBROUTINE  PLTOR (Z1,ZE,Z2,NZ,KX,NX,KY,NY,PL)

C     [ORTHOGONAL RELIEF]
C     ZE(NX,NY)  ARRAY TO BE CONTOURED
C     (KX,KY)    NUMBER OF X- AND Y-SUBDIVISIONS
C     (Z1,Z2)    CONTOURING INTERVAL
C     NZ         NUMBER OF CONTOUR LEVELS
C     PL         COORDINATE CONVERSION SUBROUTINE
C     [20-NOV-74]

      EXTERNAL    PL
      DIMENSION   ZE(1)

      I0=MAX0(NX/(2*KX),1)
      J0=MAX0(NY/(2*KY),1)
      IX=2*I0
      IY=2*J0
      ZZ=Z2-Z1
      XF=ZZ/FLOAT(NX-1)
      YF=ZZ/FLOAT(NY-1)
      DZ=(3.0*ZZ)/FLOAT(NZ-1)

      II=I0+1
      JJ=J0+1
   10 JA=MAX0(JJ-J0,1)
      JB=MIN0(JJ+J0,NY)
   20 IA=MAX0(II-I0,1)
      IB=MIN0(II+I0,NX)
      Z=Z1-ZZ
      DO 30 K=1,NZ
      CALL KONSC (Z,-XF,YF,IA,IB,JA,JB,ZE,NX,NY,PL)
   30 Z=Z+DZ
      II=II+IX
      IF ((II-I0.LT.NX).AND.(II+I0.GT.1)) GO TO 20
      IX=-IX
      II=II+IX
      JJ=JJ+IY
      IF (JJ-J0.LT.NY) GO TO 10
      RETURN
      END
      SUBROUTINE  PLTPO (T,R,P)

C     [POLAR]
C     CHANGE (T,R) TO (X,Y) PERMITTING PEN MOVEMENTS TO BE DEFINED
C     DIRECTLY IN POLAR COORDINATES.
C     0.0.LE.T.LE.1.0 FILLS THE PAGE
C     0.0.LE.R.LE.1.0 FILLS THE PAGE
C     [19-MAY-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/

      S=HY*R
      U=6.28318*T
      CALL PLTMS (S*COS(U),S*SIN(U),P)
      RETURN
      END


C     ------------------------------------------------------------------

      SUBROUTINE  PLTPV (Z1,ZE,Z2,NR,NP,PL)

C     [POLAR VIEW]
C     PROGRAM TO PRODUCE A PERSPECTIVE DRAWING OF A SINGLE VALUED
C     FUNCTION DEFINED IN POLAR COORDINATES, IN SUCH A WAY AS TO
C     EXHIBIT THE RADIAL AND CIRCUMFERENTIAL ARCS.
C     (Z1,Z2)   RANGE OF FUNCTION VALUES
C     ZE(NR,NP) ARRAY OF FUNCTION VALUES
C     NR        NUMBER OF POINTS ON ONE RADIUS
C     NP        NUMBER (=4*N+1) OF ANGLES
C     PL        PEN MOVEMENT SUBROUTINE, NORMALLY PLTCA
C     [17-MAY-75]

      EXTERNAL    PL
      DIMENSION   ZE(1)
      DATA        Q0,Q1,Q2,Q3,Q4/0.000,1.571,3.142,4.713,6.283/
      DATA        S1,S3/1.570,4.712/

      NQ=1+(NP-1)/4
      NN=NR*(NQ-1)
      R1=0.02
      R2=1.00
      CALL VISNH
      CALL VISPS (Z1,ZE(3*NN+1),Z2,R1,R2,NR,Q3,Q4,NQ,-1, 1,PL)
      CALL VISPS (Z1,ZE        ,Z2,R1,R2,NR,Q0,S1,NQ, 1, 1,PL)
      CALL VISNH
      CALL VISPS (Z1,ZE(2*NN+1),Z2,R1,R2,NR,Q2,S3,NQ,-1,-1,PL)
      CALL VISPS (Z1,ZE(  NN+1),Z2,R1,R2,NR,Q1,Q2,NQ, 1,-1,PL)
      RETURN
      END
      SUBROUTINE  PLTQ1 (X,Y,P)

C     [QUADRANT #1]
C     SCALE X,Y TO FIT INTO THE FIRST QUADRANT ASSUMING THAT THEY
C     ALREADY LIE IN THE RANGE (0.0 .LE. X,Y .LE. 1.0).
C     [15-FEB-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/
      CALL PLTMS (HX*X,HY*Y,P)
      RETURN
      END

C     ------------------------------------------------------------------

      SUBROUTINE  PLTQ2 (X,Y,P)

C     [QUADRANT #2]
C     SCALE X,Y TO FIT INTO THE SECOND QUADRANT ASSUMING THAT THEY
C     ALREADY LIE IN THE RANGE (0.0 .LE. X,Y .LE. 1.0).
C     [15-FEB-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/
      CALL PLTMS (HX*(X-1.0),HY*Y,P)
      RETURN
      END

C     ------------------------------------------------------------------

      SUBROUTINE  PLTQ3 (X,Y,P)

C     [QUADRANT #3]
C     SCALE X,Y TO FIT INTO THE THIRD QUADRANT ASSUMING THAT THEY
C     ALREADY LIE IN THE RANGE (0.0 .LE. X,Y .LE. 1.0).
C     [15-FEB-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/
      CALL PLTMS (HX*(X-1.0),HY*(Y-1.0),P)
      RETURN
      END

C     ------------------------------------------------------------------

      SUBROUTINE  PLTQ4 (X,Y,P)

C     [QUADRANT #4]
C     SCALE X,Y TO FIT INTO THE FOURTH QUADRANT ASSUMING THAT THEY
C     ALREADY LIE IN THE RANGE (0.0 .LE. X,Y .LE. 1.0).
C     [15-FEB-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/
      CALL PLTMS (HX*X,HY*(Y-1.0),P)
      RETURN
      END
      SUBROUTINE  PLTRG (X1,X,X2,Y1,Y,Y2,N)

C     [RECTANGULAR GRAPH]
C     PLOT A GRAPH IN RECTANGULAR COORDINATES, BY CONNECTING SUCCESSIVE
C     DATA POINTS BY STRAIGHT LINES. THE POINTS DEFINING THE GRAPH ARE
C     TAKEN FROM TWO ARRAYS, ONE CONTAINING THE X-VALUES AND THE OTHER
C     CONTAINING THE Y-VALUES.  THE RESPECTIVE SCALES ARE INDICATED BY
C     THE VALUES TO BE ASSIGNED TO THE MARGINS OF THE GRAPH. ORDINARILY
C     THE MARGINS WOULD BE GIVEN ROUNDED VALUES SLIGHTLY LARGER THAN
C     THE EXTREME DATA VALUES.  HOWEVER, THE GRAPH MAY BE CENTERED IN
C     VARIOUS WAYS BY ASSIGNING ONE OR MORE MARGINS CONSIDERABLY LARGER
C     VALUES.  LIKEWISE EXCERPTS FROM THE GRAPH MAY BE CHOSEN BY GIVING
C     THE MARGINS LESSER VALUES THAN THE EXTREMES.
C     X1     X LOWER LIMIT
C     X(N)   ARRAY OF X VALUES
C     X2     X UPPER LIMIT
C     Y1     Y LOWER LIMIT
C     Y(N)   ARRAY OF Y VALUES
C     Y2     Y UPPER LIMIT
C     N      NUMBER OF POINTS
C     [12-OCT-74]

      DIMENSION   X(1),Y(1)
      DATA        HX,HY/4.50,3.25/

      EX(X)=(X-X1)*SCX-HX
      WY(Y)=(Y-Y1)*SCY-HY

      IF (N.LT.2) RETURN
      SCX=(2.0*HX)/(X2-X1)
      SCY=(2.0*HY)/(Y2-Y1)
      CALL PLTMS (EX(X(1)),WY(Y(1)),.FALSE.)
      DO 10 I=2,N
   10 CALL PLTMS (EX(X(I)),WY(Y(I)),.TRUE.)
      RETURN
      END


C     ------------------------------------------------------------------


      SUBROUTINE  PLTRH (X,Y,P)

C     [RIGHT HALF]
C     SCALE THE CARTESIAN COORDINATES (X,Y) SO AS TO POSITION A
C     GRAPH IN THE RIGHT HALF OF A PLOTTER PAGE.
C     [20-APR-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/

      CALL PLTMS (HX*X,HY*(Y-0.5),P)
      RETURN
      END
      SUBROUTINE  PLTRV (Z1,ZE,Z2,NX,NY,TH,PL)

C     [ROTATED VIEW]
C     PROGRAM TO PRODUCE A PERSPECTIVE DRAWING OF A SINGLE VALUED
C     FUNCTION DEFINED IN CARTESIAN COORDINATES, EXHIBITING ARCS
C     ON THE SURFACE PARALLEL TO THE COORDINATE AXES. FOR GREATER
C     VARIETY IN PRESENTATION, THE ENTIRE FIGURE MAY BE ROTATED
C     THROUGH AN ANGLE, WHICH SHOULD BE SPECIFIED IN DEGREES.
C     ZE(NX,NY) ARRAY OF FUNCTION VALUES
C     Z1,Z2     RANGE OF FUNCTION VALUES
C     TH        ANGLE OF ROTATION (-90.0.LT.TH.LT.90.0) IN DEGREES
C     PL        PEN MOVEMENT SUBROUTINE, USUALLY PLTCA
C     [08-MAY-75]

      EXTERNAL    PL
      DIMENSION   ZE(1)

      IF ((TH.LE.-90.0).OR.(TH.GE.90.0)) RETURN
      CALL VISNH
      CALL VISRS (Z1,ZE,Z2,NX,NX,NY,NY,TH,PL)
      RETURN
      END


C     ------------------------------------------------------------------


      SUBROUTINE  PLTSE (Z1,ZE,Z2,NX,NY,PL)

C     [SOUTHEAST VIEW]
C     PROGRAM TO PRODUCE A PERSPECTIVE DRAWING OF A SINGLE VALUED
C     FUNCTION DEFINED IN CARTESIAN COORDINATES, IN SUCH A WAY AS
C     TO EXHIBIT ARCS ON THE SURFACE PARALLEL TO THE COORDINATE
C     AXES. FOR GREATER CLARITY IN PRESENTATION, THE ENTIRE FIGURE
C     MAY BE SHEARED, HORIZONTALLY WHICH WILL GIVE THE ILLUSION OF
C     A SIDEWISE PERSPECTIVE, AND VERTICALLY TO GIVE THE ILLUSION OF
C     DEPTH AND TO EXPOSE THE REMOTER DETAILS WHICH WOULD OTHERWISE
C     BE HIDDEN.  SHEARING IS PREFERABLE TO ROTATION WHENEVER IT IS
C     DESIRED TO MAINTAIN HORIZONTAL LINES HORIZONTAL.
C     ZE(NX,NY) ARRAY OF FUNCTION VALUES
C     Z1,Z2     RANGE OF FUNCTION VALUES
C     PL        PEN MOVEMENT SUBROUTINE, PERHAPS PLTCA
C     [10-MAY-75]

      EXTERNAL    PL
      DIMENSION   ZE(1)

      CALL VISNH
      CALL VISDS (Z1,ZE,Z2,1,NX,NX,1,NY,NY,0.2,0.2,-1,1,PL)
      RETURN
      END
      SUBROUTINE  PLTSP (PH,TH,P)

C     [SPHERICAL POLAR]
C     CHANGE THE ANGULAR VARIABLES PH,TH TO THE CARTESIAN COORDINATES
C     X,Z SO AS TO DEFINE DIRECTLY IN SPHERICAL POLAR COORDINATES POINTS
C     WHICH LIE UPON THE SURFACE OF A CONSTANT SPHERE AND GRAPH THEIR
C     PROJECTION ON THE X-Z PLANE. PH,TH ARE BOTH SUPPOSED TO LIE IN
C     THE RANGE 0.0 .LE. PH,TH .LE. 1.0, SINCE THIS IS THE RANGE ASSUMED
C     BY SUCH SUBROUTINES AS THE CONTOURING PROGRAMS.
C     [16-NOV-74]

      LOGICAL     P
      DATA        HX,HY/4.50,3.25/

      R=HY
      THE=3.14159*TH
      PHI=6.28318*PH
      X=R*SIN(THE)*COS(PHI)
      Y=R*SIN(THE)*SIN(PHI)
      Z=R*COS(THE)
      CALL PLTMS (X,Z,(P.AND.(Y.GE.0.0)))
      RETURN
      END


C     ------------------------------------------------------------------


   
