      SUBROUTINE TBLNXT
C
C     TBLTRN ROOUTINE TO SEARCH FOR NEXT SYMBOL IN
C     LINE OF INPUT TEXT
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERSITY
C
C     KODE   = 0, FIND SYMBOL IN TEXT AND IDENTIFY
C            = 1, IDENTIFY PREVIOUSLY FOUND SYMBOL
C            = 2, ADD SYMBOL TO DICTIONARY
C            = 3, SIMILAR TO 4 EXCEPT DEFERRED INSERTION
C                 IS IN EFFECT.
C            = 4, INSERT BUFFER AT START OF INPUT TEXT
C
C     THE FOLLOWING INFORMATION IS RETURNED
C
C     KIND   = CHARACTER CLASS OF SYMBOL
C     KIND   = 0, BLANK
C            = 1, RADIX VIOLATION
C            = 2, DIGITS
C            = 3, DIGITS FOLLOWED BY LETTERS
C            = 4, LETTERS, DIGITS ETC.
C            = 5 AND GREATER, PUNCTUATION
C     ILEFT  = SUBSCRIPT OF FIRST CHARACTER IN SYMBOL
C     IRIGHT = SUBSCRIPT OF FINAL CHARACTER IN SYMBOL
C     NUMBER = VALUE OF INTEGER UNDER CURRENT RADIX
C     ITEN   = VALUE OF INTEGER WITH RADIX 10
C
      COMMON/TBLTRN/I,IADDRS,IADJST,IBASE,IBLANK,IDGT(16),
     1IERR,IFILL,IFKNT,IKODE,ILEFT,ILINE,ILPT,ILTR,IBYTE,
     2IMASK,LMAX,NMORE,IMOST,INSERT,IOCT(13),IOPRTR,IOUT,
     3IPAREN,IPNCTN(11),IPRCN,IRADIX,IREAD,IREPT,IRIGHT,
     4ISHIFT,ISIGN,ISTAR,ISTORE(478),ITEN,ITEST,ITITLE(6),
     5ITTY,IWIDE,IWRITE,J,JADJST,JBASE,JBLANK,JERR,KPAREN,
     6JFKNT,JKODE(37),JLEFT,JMASK,JMORE,JPAREN,JRADIX,LOOP,
     7JRIGHT,JSHIFT,JSIGN,K,KADJST,KBASE,KERR,KIND,KLINE,
     8KLM,KLTR,KMASK,KNT,KNTLTR,KNTWRD,KODE,KRADIX,IDBG,
     9KREAD,KSHIFT,L,LEAST,LETTER(160),LMASK,LOCK,LSTNEW,
     1LTTR(160),M,MASK,MASTER(5000),MAX,MLEFT,MORE,MOST,
     2MRIGHT,MULT,N,NEW,NEXT,NSIGN,NTITLE(6),NUMBER,LRADIX,
     3KMAX,INLINE,JPNCTN(50),KPNCTN(50),LPNCTN,JOPRTR,NLTR,
     4JBYTE,ILOOP,ISKIP,IVALUE,INSN(6),JNSN,IMAX,JMAX,
     5KNSN,MLTR,JLTR,JLOOP,IPFX,JPFX,LSIGN,IIARG,JJARG,
     6KKARG,LLARG,JVALUE,MIN,IAC,IARG,JARG,KARG,LARG,JSTFY,
     7LENGTH(20),LNGMIN,IORDER,IRMV,KSIGN
      IF(KODE.NE.0)GO TO 41
C
C     **************************************
C     *  FIND SYMBOL IN INPUT TEXT BUFFER  *
C     **************************************
C
    1 IF(IRIGHT.GE.MLTR)IRIGHT=MLTR
      JRIGHT=IRIGHT
    2 IF(IARG.EQ.0)GO TO 3
      IF(JARG.NE.0)GO TO 3
      IF(IRIGHT.GE.LARG)GO TO 59
    3 NUMBER=0
      ITEN=0
      K=0
      L=0
      KIND=0
      ILEFT=IRIGHT+1
      IF(ILEFT.LE.MLTR)GO TO 5
      IF(ILEFT.GT.ILTR)GO TO 113
      GO TO 114
    4 IF(K.EQ.0)GO TO 20
      IF(L.NE.0)GO TO 10
      KIND=1
    5 IRIGHT=IRIGHT+1
      IF(IRIGHT.GT.MLTR)GO TO 21
      J=LETTER(IRIGHT)
      DO 7 I=1,LPNCTN
      IF(J.NE.JPNCTN(I))GO TO 7
      IF(KPNCTN(I).EQ.7)GO TO 11
      IF(KIND.EQ.0)GO TO 6
      IF(KIND.NE.KPNCTN(I))GO TO 21
      GO TO 5
    6 KIND=KPNCTN(I)
      GO TO 5
    7 CONTINUE
    8 IF(KIND.GE.5)GO TO 21
      IF(KIND.GE.3)GO TO 5
      I=0
    9 I=I+1
      IF(J.EQ.IDGT(I))GO TO 12
      IF(I.LT.10)GO TO 9
      IF(I.LT.IRADIX)GO TO 9
      IF(K.EQ.0)GO TO 20
   10 KIND=3
      NUMBER=ILEFT+K
      GO TO 5
   11 IF(K.EQ.0)GO TO 8
      IF((ILEFT+K).NE.IRIGHT)GO TO 8
      IF(ITEN.GE.1001)GO TO 117
      IF(ITEN.EQ.66)GO TO 117
      IF(ITEN.LE.2)GO TO 117
      GO TO 116
   12 IF(L.NE.0)GO TO 14
      IF(I.LE.10)GO TO 13
      IF(KIND.EQ.1)GO TO 10
      L=1
      GO TO 14
   13 IF(ITEN.GT.10000)GO TO 14
      K=K+1
      ITEN=I-1+(ITEN*10)
      IF(KIND.EQ.1)GO TO 5
   14 IF(I.GT.IRADIX)GO TO 4
      KIND=2
      IF(IRADIX.EQ.10)GO TO 19
      IF(IRADIX.EQ.8)GO TO 17
      IF(IRADIX.EQ.2)GO TO 16
      IF(IRADIX.EQ.16)GO TO 15
      IF(IRADIX.NE.4)GO TO 19
      M=2
      GO TO 18
   15 M=4
      GO TO 18
   16 M=1
      GO TO 18
   17 M=3
   18 NUMBER=ITBMOV(NUMBER,M)
      NUMBER=ITBOR(NUMBER,I-1)
      GO TO 5
   19 NUMBER=(IRADIX*NUMBER)+I-1
      GO TO 5
   20 KIND=4
      GO TO 5
   21 IRIGHT=IRIGHT-1
      IF(KIND.EQ.1)GO TO 117
      IF(KIND.EQ.2)GO TO 115
      IF(KIND.EQ.5)GO TO 39
      IF(KIND.NE.6)GO TO 42
C
C     ***************************************
C     *  BREAK CHARACTER DIAGNOSTIC OUTPUT  *
C     ***************************************
C
      IDBG=ITTY
      IF(JBLANK.NE.0)WRITE(IDBG,22)
   22 FORMAT(1X,1I5,1X,60A1/7X,60A1/7X,60A1)
      JBLANK=1
      WRITE(IDBG,22)ILINE,(LETTER(I),I=JLEFT,IRIGHT)
      IF((ILEFT+1).EQ.IRIGHT)GO TO 25
      IF((ILEFT+2).EQ.IRIGHT)GO TO 32
C
C     PRINT ENTRIES ASSEMBLED BY PRESENT STATEMENT
      IF(IOPRTR.EQ.15)GO TO 23
      IF(IOPRTR.EQ.37)GO TO 23
      IF(INSERT.EQ.0)GO TO 39
      KODE=20
      GO TO 24
C
C     PRINT DEFINITION SPECIFIED BY PRESENT STATEMENT
   23 KODE=-IADDRS
   24 CALL TBLDBG
      GO TO 39
C
C     WRITE EXTRA INFO IF MORE THAN 1 DOLLAR SIGN
   25 I=ISHIFT+1
      IF(IMASK.NE.0)GO TO 28
      IF(MASK.EQ.0)GO TO 31
C     SEARCH FOR MASK IF NOT SELECTED BY TON
      M=MAX
      GO TO 27
   26 M=MASTER(M)
   27 IF(MASTER(M).EQ.0)GO TO 31
      IF(MASTER(M-1).NE.29)GO TO 26
      L=-MASTER(M-2)
      IF(MASTER(L+1).NE.LMASK)GO TO 26
      L=MASTER(M)+1
      M=M-3
      GO TO 29
   28 M=-MASTER(IMASK)-1
      L=MASTER(M+3)+1
C     PRINT INFO AND NAME OF MASK SELECTED
   29 WRITE(IDBG,30)ISIGN,I,IBASE,MOST,MORE,NEXT,IBLANK,
     1(MASTER(N),N=L,M)
   30 FORMAT(1X,5HSIGN=,1I2,7H, BYTE=,1I3,9H OF SIZE=,
     11I3,8H, ENTRY=,1I5,1H+,1I3,3H OF,1I3,81A1)
      GO TO 102
C     PRINT INFO WHEN MASK NOT SELECTED
   31 WRITE(IDBG,30)ISIGN,I,IBASE,MOST,MORE,NEXT
      GO TO 102
C
C     PRINT CHARACTER CLASSES
   32 WRITE(IDBG,33)
   33 FORMAT(1X,17HCHARACTER CLASSES)
      K=0
      I=4
   34 I=I+1
      L=0
      DO 38 J=1,LPNCTN
      IF(KPNCTN(J).NE.I)GO TO 38
      K=K+1
      IF(L.NE.0)GO TO 36
      L=1
      WRITE(IDBG,35)I,JPNCTN(J)
   35 FORMAT(1X,1I3,1X,1A1)
      GO TO 38
   36 WRITE(IDBG,37)JPNCTN(J)
   37 FORMAT(5X,1A1)
   38 CONTINUE
      IF(K.NE.LPNCTN)GO TO 34
C
C     CONVERT INTO BLANKS CHARACTERS EQUIVALENT TO BLANKS
   39 DO 40 I=ILEFT,IRIGHT
   40 LETTER(I)=IBLANK
      GO TO 2
C
C     **************************************
C     *  FIND SYMBOL IN SYMBOL DICTIONARY  *
C     **************************************
C
   41 GO TO(43,56,60,63),KODE
   42 KODE=1
   43 INDEX=IRIGHT-ILEFT+1
      I=INDEX
      IF(I.GT.20)I=20
      LIMIT=LENGTH(I)
      IF(LIMIT.EQ.0)LIMIT=LNGMIN
      I=0
   44 KOUNT=IRIGHT
   45 NEW=LIMIT-3
      LIMIT=MASTER(LIMIT)
      IF(LIMIT.LE.0)GO TO 52
      IF(MASTER(NEW+2).LT.0)GO TO 45
      IF((LIMIT+INDEX).EQ.NEW)GO TO 46
      IF(NEW.LT.LNGMIN)GO TO 45
      IF(INDEX.LT.20)LIMIT=LNGMIN
      GO TO 45
   46 IF(MASTER(NEW).NE.LETTER(KOUNT))GO TO 44
      NEW=NEW-1
      KOUNT=KOUNT-1
      IF(KOUNT.GE.ILEFT)GO TO 46
C
C     IF MATCH IS FOUND, CHECK TO SEE IF IT IS LEGAL
      NEW=NEW+INDEX+2
      J=MASTER(NEW)
      IF(J.EQ.4)GO TO 119
      IF(J.EQ.5)GO TO 119
      IF(J.EQ.6)GO TO 119
      IF(J.EQ.7)GO TO 119
      IF(J.EQ.8)GO TO 119
      IF(J.EQ.26)GO TO 119
      IF(J.EQ.36)GO TO 119
      IF(J.EQ.69)GO TO 119
      IF(J.EQ.121)GO TO 119
      IF(I.NE.0)GO TO 49
C     FOUND FIRST MATCH
      IF(IOPRTR.EQ.0)GO TO 47
      IF(IOPRTR.EQ.24)GO TO 119
      IF(IOPRTR.EQ.81)GO TO 48
      IF(IOPRTR.EQ.86)GO TO 48
      IF(IOPRTR.EQ.105)GO TO 48
      IF(IOPRTR.EQ.68)GO TO 48
      IF(IOPRTR.EQ.70)GO TO 48
      IF(IOPRTR.EQ.71)GO TO 48
      IF(IOPRTR.EQ.77)GO TO 48
      IF(IOPRTR.EQ.101)GO TO 48
      IF(IOPRTR.EQ.41)GO TO 48
      IF(IOPRTR.EQ.13)GO TO 48
   47 IF(J.GT.2)GO TO 119
      IF(J.EQ.0)GO TO 119
   48 I=NEW
      GO TO 44
C     FOUND SECOND MATCH
   49 IF(IOPRTR.EQ.0)GO TO 119
      IF(IOPRTR.EQ.81)GO TO 51
      IF(IOPRTR.EQ.86)GO TO 51
      IF(IOPRTR.EQ.105)GO TO 51
      IF(IOPRTR.EQ.68)GO TO 51
      IF(IOPRTR.EQ.70)GO TO 51
      IF(IOPRTR.EQ.71)GO TO 51
      IF(IOPRTR.EQ.77)GO TO 51
      IF(IOPRTR.EQ.101)GO TO 51
      IF(IOPRTR.EQ.41)GO TO 50
      IF(IOPRTR.NE.13)GO TO 119
   50 IF(MASTER(I).EQ.16)GO TO 55
      IF(J.EQ.16)GO TO 119
   51 IF(MASTER(I).LE.2)GO TO 55
      IF(J.LE.2)GO TO 119
      GO TO 55
C     FOUND LESS THAN 2 MATCHES
   52 IF(I.EQ.0)GO TO 57
      IF(IOPRTR.EQ.0)GO TO 55
      IF(IOPRTR.EQ.81)GO TO 54
      IF(IOPRTR.EQ.86)GO TO 54
      IF(IOPRTR.EQ.105)GO TO 54
      IF(IOPRTR.EQ.68)GO TO 54
      IF(IOPRTR.EQ.70)GO TO 54
      IF(IOPRTR.EQ.71)GO TO 54
      IF(IOPRTR.EQ.77)GO TO 54
      IF(IOPRTR.EQ.101)GO TO 54
      IF(IOPRTR.EQ.41)GO TO 53
      IF(IOPRTR.NE.13)GO TO 55
   53 IF(MASTER(I).EQ.16)GO TO 55
   54 IF(MASTER(I).GT.2)GO TO 57
   55 NEW=I
      GO TO 119
C
C     ADD SYMBOL IF NOT IN SYMBOL TABLE
C     REPLACE PREVIOUS SYMBOL IF STILL UNDEFINED
   56 INDEX=IRIGHT-ILEFT+1
   57 IF(MASTER(LSTNEW).EQ.0)NEW=LSTNEW-2
      IF((NEW-INDEX).LE.(MOST+NEXT))GO TO 118
      LSTNEW=NEW+2
      MASTER(NEW+3)=NEW-INDEX
      MASTER(NEW+2)=0
      MASTER(NEW+1)=0
      KOUNT=IRIGHT
   58 MASTER(NEW)=LETTER(KOUNT)
      NEW=NEW-1
      KOUNT=KOUNT-1
      IF(KOUNT.GE.ILEFT)GO TO 58
      LEAST=NEW
      NEW=NEW+INDEX+2
      MASTER(LEAST)=0
      GO TO 119
C
C     ********************************************
C     *  INSERT BUFFER INTO START OF INPUT TEXT  *
C     ********************************************
C
C     CALCULATE NEXT DEFERRED TEXT INSERTION IN
C     USER DEFINED FUNCTION (WON'T ENTER AT THIS
C     POINT UNLESS ONE IS IN EFFECT).
   59 ITEN=0
   60 LARG=IRIGHT
      NUMBER=IARG-KARG
      IF(MASTER(IARG+1).GE.NUMBER)GO TO 62
      NEW=-MASTER(IARG)+1
      J=KARG
      KARG=KARG+MASTER(NUMBER)+2
      I=NUMBER-MASTER(NUMBER)-1
      IF(MASTER(IARG+1).GE.I)GO TO 61
      JARG=MASTER(I)
      IF(INLINE.NE.0)GO TO 64
      IF(JARG.EQ.0)GO TO 64
      KARG=J
      JARG=0
      ITEN=5
      GO TO 116
   61 IARG=0
      GO TO 64
C
C     TURN OFF THE USER DEFINED FUNCTION IF THERE IS
C     NO MORE TEXT TO BE INSERTED.
   62 IARG=0
      LARG=0
      GO TO 1
C
C     LIST THE PROCESSED TEXT (THIS IS THE NORMAL
C     ENTRY POINT FOR TEXT REPLACEMENT SYMBOLS WHICH
C     DON'T HAVE DEFERRED SECTIONS).
   63 ITEN=0
      NEW=0
   64 LOOP=LOOP+1
      IF(ILOOP.GE.0)GO TO 71
      IDBG=ILPT
      IF(IDBG.EQ.ITTY)JBLANK=1
      WRITE(IDBG,65)ILINE,LOOP
   65 FORMAT(1X/5H LINE,1I8,10H INSERTION,1I6)
      I=1
      J=NLTR
      GO TO 67
   66 K=LETTER(J+1)
      IF(K.LT.0)K=-K
      I=J+2
      J=J+K
   67 IF(J.GT.IRIGHT)J=IRIGHT
      K=J-I+1
      IF(K.GT.0)WRITE(IDBG,68)K,(LETTER(L),L=I,J)
   68 FORMAT(1X,1I3,10H OLD TEXT ,40A1/
     114X,40A1/14X,40A1/14X,40A1)
      IF(J.LT.IRIGHT)GO TO 66
      IF(NEW.EQ.0)GO TO 70
      IF(MASTER(NEW-1).EQ.(-NUMBER-1))GO TO 70
      I=NEW-2
      J=MASTER(NEW+1)+1
      WRITE(IDBG,69)(MASTER(K),K=J,I)
   69 FORMAT(5X,9HFUNCTION ,40A1/14X,40A1)
C
C     TEST IF HAVE EXECUTED MORE TEXT REPLACEMENTS
C     ON THIS LINE THAN PERMITTED BY VALUE OF ILOOP
   70 IF(LOOP.LE.(-ILOOP))GO TO 73
   71 IF(LOOP.LE.ILOOP)GO TO 73
      WRITE(ITTY,72)ILINE
   72 FORMAT(25H REPLACEMENT LOOP IN LINE,1I6,
     111H TERMINATED)
      JBLANK=1
      GO TO 113
C
C     LIST PROCESSED TEXT IF STATEMENT IS IN ERROR
   73 IF(IERR.LE.0)GO TO 76
      IF(IERR.EQ.1)WRITE(ITTY,74)ILINE,(IBLANK,
     1  I=JLEFT,MLEFT),(ISTAR,I=MLEFT,MRIGHT)
   74 FORMAT(11H ERROR LINE,1I5/160A1)
      IF(JRIGHT.GE.JLEFT)WRITE(ITTY,75)IBLANK,
     1 (LETTER(I),I=JLEFT,JRIGHT)
   75 FORMAT(150A1)
      JBLANK=1
      IERR=2
      LOOP=LOOP+99
C
C     INSERT BLANK IF RIGHT LETTER OF INSERTED TEXT
C     IS OF SAME CHARACTER CLASS AS LEFT NON-BLANK
C     LETTER OF UNPROCESSED TEXT.
   76 I=MLTR
      K=IRIGHT
      IF(ITEN.LT.0)I=I-ITEN+1
      IF(ITEN.GT.0)I=I+ITEN-1
   77 IF(IRIGHT.EQ.I)GO TO 78
      IRIGHT=IRIGHT+1
      IF(LETTER(IRIGHT).EQ.IBLANK)GO TO 77
      J=LETTER(IRIGHT)
      IRIGHT=IRIGHT-1
      IF(K.EQ.LARG)LARG=IRIGHT
   78 IF(ITEN.EQ.0)GO TO 79
      K=IRIGHT-K
      IF(ITEN.LT.0)ITEN=ITEN+K
      IF(ITEN.GT.0)ITEN=ITEN-K
      GO TO 84
   79 IF(IRIGHT.EQ.MLTR)GO TO 84
      IF(MASTER(NUMBER).EQ.0)GO TO 84
      I=0
      DO 80 K=1,LPNCTN
      IF(J.NE.JPNCTN(K))GO TO 80
      IF(KPNCTN(K).NE.7)I=KPNCTN(K)
      GO TO 81
   80 CONTINUE
   81 J=MASTER(NUMBER-1)
      L=0
      DO 82 K=1,LPNCTN
      IF(J.NE.JPNCTN(K))GO TO 82
      IF(KPNCTN(K).NE.7)L=KPNCTN(K)
      GO TO 83
   82 CONTINUE
   83 IF(I.NE.L)GO TO 84
      LETTER(IRIGHT)=IBLANK
      IRIGHT=IRIGHT-1
C
C     CALCULATE THE NEW POINTERS
   84 I=MASTER(NUMBER)-IRIGHT
      IF(ITEN.NE.0)I=I+1
      K=ILTR
      ILTR=ILTR+I
      IF(IRIGHT.LT.MLTR)GO TO 85
      MLTR=MASTER(NUMBER)
      GO TO 86
   85 MLTR=MLTR+I
   86 IF(IRIGHT.LE.LARG)GO TO 87
      LARG=0
      GO TO 88
   87 LARG=LARG+MASTER(NUMBER)-IRIGHT
   88 IF(IRIGHT.EQ.K)GO TO 98
      IF(ILTR.EQ.K)GO TO 98
      IF(ILTR.LT.K)GO TO 96
C
C     RESET POINTERS IF WOULD CAUSE OVERFLOW OF BUFFER
      IF(ILTR.LE.KMAX)GO TO 94
      J=K
      K=K+KMAX-ILTR
      ILTR=KMAX
      IF(MLTR.GT.KMAX)MLTR=KMAX
      IF(LARG.GT.KMAX)LARG=KMAX
      IF(JERR.NE.ILINE)WRITE(ITTY,89)ILINE,KMAX
   89 FORMAT(21H TEXT DELETED ON LINE,1I6,6H AFTER,
     11I4,11H CHARACTERS)
      JERR=ILINE
      JBLANK=1
      IF(ILOOP.GT.0)GO TO 94
      L=K+1
   90 IF(NLTR.GE.K)GO TO 92
   91 I=LETTER(NLTR+1)
      IF(I.LT.0)I=-I
      NLTR=NLTR+I
      GO TO 90
   92 IF(NLTR.GT.J)NLTR=J
      N=NLTR-L+1
      IF(N.GT.0)WRITE(IDBG,93)N,(LETTER(I),I=L,NLTR)
   93 FORMAT(1X,1I3,10H OVERFLOW ,40A1/
     114X,40A1/14X,40A1/14X,40A1)
      L=NLTR+2
      IF(NLTR.LT.J)GO TO 91
C
C     SHIFT UNPROCESSED LETTERS TO RIGHT
C     LETTER(OLD RIGHT) SHIFTS INTO LETTER(NEW RIGHT)
C     THEN POINTERS ARE DECREMENTED
   94 J=ILTR
   95 LETTER(J)=LETTER(K)
      J=J-1
      K=K-1
      IF(K.GT.IRIGHT)GO TO 95
      GO TO 98
C
C     SHIFT UNPROCESSED LETTERS TO LEFT
C     LETTER(OLD LEFT) SHIFTS INTO LETTER(NEW LEFT)
C     THEN POINTERS ARE INCREMENTED
   96 K=MASTER(NUMBER)
      IF(ITEN.NE.0)K=K+1
   97 K=K+1
      IRIGHT=IRIGHT+1
      LETTER(K)=LETTER(IRIGHT)
      IF(K.LT.ILTR)GO TO 97
C
C     SHIFT IN NEW TEXT
   98 J=1
      IRIGHT=0
      JLEFT=1
      NLTR=MLTR
      I=NUMBER-MASTER(NUMBER)
   99 IF(I.EQ.NUMBER)GO TO 100
      LETTER(J)=MASTER(I)
      I=I+1
      J=J+1
      GO TO 99
C
C     LIST NEW TEXT BY EMBEDDED STATEMENTS
  100 IF(ITEN.EQ.0)GO TO 101
      IF(J.LE.KMAX)LETTER(J)=ITEN
  101 IF(ILOOP.GT.0)GO TO 1
  102 J=1
      K=NLTR
  103 IF(K.GT.ILTR)K=ILTR
      L=K-J+1
      IF(L.GT.0)WRITE(IDBG,104)L,(LETTER(I),I=J,K)
  104 FORMAT(1H ,1I3,10H NEW TEXT ,
     140A1/14X,40A1/14X,40A1/14X,40A1)
      IF(IARG.EQ.0)GO TO 110
      IF(LARG.GT.K)GO TO 110
      IF(LARG.GT.0)GO TO 105
      IF(J.NE.1)GO TO 110
      L=0
      GO TO 106
  105 IF(LARG.LT.J)GO TO 110
      L=LARG-J+1
  106 I=-JARG
      IF(JARG.GE.0)WRITE(IDBG,107)L,JARG
  107 FORMAT(4X,6H(UNTIL,1I3,13H LETTERS THEN,
     11I3,9H SYMBOLS))
      IF(JARG.LT.0)WRITE(IDBG,108)L,I
  108 FORMAT(4X,6H(UNTIL,1I3,13H LETTERS THEN,
     11I3,12H STATEMENTS))
      I=IARG-1-KARG
      J=MASTER(I+1)
      M=I-J+1
      IF(J.GT.0)WRITE(IDBG,109)J,(MASTER(N),N=M,I)
  109 FORMAT(1X,1I3,10H DEFERRED ,40A1/
     114X,40A1/14X,40A1/14X,40A1)
  110 IF(K.EQ.ILTR)GO TO 112
      J=K+2
      L=LETTER(K+1)
      IF(L.LT.0)WRITE(IDBG,111)
  111 FORMAT(4X,33H(RANGE OF IF CLASS OPERATOR ENDS))
      IF(L.LT.0)L=-L
      K=K+L
      GO TO 103
  112 IF(IRIGHT.EQ.0)GO TO 1
      GO TO 39
C
C     *******************************
C     *  RETURN TO CALLING PROGRAM  *
C     *******************************
C
  113 KODE=3
      GO TO 119
  114 KODE=4
      GO TO 119
  115 KODE=5
      GO TO 119
  116 KODE=6
      GO TO 119
  117 KODE=7
      GO TO 119
  118 KODE=8
  119 RETURN
      END
