      SUBROUTINE  GENPLT  (MODE1 ,MODE2 ,MODE3 ,XPOINT,YPOINT,KRDBGN,
     1KRDEND,XFIRST,YFIRST,XFINAL,YFINAL,FIRSTX,FIRSTY,FINALX,FINALY,
     2XWIDTH,YWIDTH,XCORNR,YCORNR,RELHIT,LETTER,LASTX ,LASTY )
C                                                               09/18/67
C     BASIC DATA ARRAY PLOTTING SUBROUTINE FOR THE GENPLT-II PACKAGE
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE GENPLT ARGUMENT LIST DEFINITIONS.
C
C     MODE1  = 1 DOES NOT CHECK IF POINTS ARE IN REQUESTED PLOT AREA.
C     MODE1  = 2 SETS SCALES TO FIT COORDINATES OF PLOTTED POINTS.
C     MODE1  = 3 DOES NOT PLOT POINT COORDINATES EXCEEDING LIMITS.
C
C     MODE2  = 1 REQUIRES BOTH INPUT X AND Y COORDINATE ARRAYS.
C     MODE2  = 2 SIMULATES X ARRAY LEFT TO RIGHT AT EQUAL INTERVALS.
C
C     MODE3  = 1 GIVES PLOT WITH LINES CONNECTING AREAS AROUND POINTS.
C     MODE3  = 2 GIVES PLOT WITH LINE CONNECTING POINTS.
C     MODE3  = 3 GIVES PLOT WITH DOT AT EACH POINT.
C     MODE3  = 4 GIVES PLOT WITH ALPHANUMERIC CHARACTER AT EACH POINT.
C     MODE3  = 5 GIVES PLOT WITH SPECIAL SYMBOL AT EACH POINT.
C
C     XPOINT = ARRAY OF X COORDINATES OF POINTS TO BE PLOTTED.
C     YPOINT = ARRAY OF Y COORDINATES OF POINTS TO BE PLOTTED.
C     KRDBGN = SUBSCRIPT OF FIRST POINT TO BE PLOTTED.
C     KRDEND = SUBSCRIPT OF FINAL POINT TO BE PLOTTED.
C
C     XFIRST = X COORDINATE TO BE PLACED AT LEFT BORDER OF PLOT AREA.
C     YFIRST = Y COORDINATE TO BE PLACED AT LOWER BORDER OF PLOT AREA.
C     XFINAL = X COORDINATE TO BE PLACED AT RIGHT BORDER OF PLOT AREA.
C     YFINAL = Y COORDINATE TO BE PLACED AT UPPER BORDER OF PLOT AREA.
C
C     SCALES MAY EITHER INCREASE OR DECREASE IF MODE1 = 1 OR 3.
C     SCALES ARE SELECTED TO INCREASE TOWARD RIGHT AND TOP IF MODE1 = 2.
C     INPUT LIMITS XFIRST,YFIRST,XFINAL,YFINAL ARE IGNORED IF MODE1 = 2.
C
C     FIRSTX = X COORDINATE PLACED AT LEFT BORDER OF PLOT AREA.
C     FIRSTY = Y COORDINATE PLACED AT LOWER BORDER OF PLOT AREA.
C     FINALX = X COORDINATE PLACED AT RIGHT BORDER OF PLOT AREA.
C     FINALY = Y COORDINATE PLACED AT UPPER BORDER OF PLOT AREA.
C     FIRSTX, FIRSTY, FINALX AND FINALY ARE OUTPUT ARGUMENTS.
C     THESE VARIABLES MAY BE USED AS LIMITING COORDINATES FOR SCLPLT.
C     THESE WILL VARY FROM THE INPUT VARIABLES ONLY IF MODE1 = 2.
C
C     XWIDTH = HORIZONTAL WIDTH OF PLOT AREA.
C     YWIDTH = VERTICAL WIDTH OF PLOT AREA.
C     XCORNR = X DISTANCE FROM PLOTTING TABLE ORIGIN TO LEFT PLOT EDGE.
C     YCORNR = Y DISTANCE FROM PLOTTING TABLE ORIGIN TO LOWER PLOT EDGE.
C
C     RELHIT = HEIGHT IN UNITS OF 0.02*YWIDTH OF THE LETTERS, SYMBOLS,
C              OR BLANK AREAS CENTERED AT EACH POINT FOR MODE3=1, 4 OR 5
C     RELHIT = 1.0 GIVES LETTERS YWIDTH/50 HIGH.
C
C     LETTER = ALPHANUMERIC CHARACTER CENTERED AT POINTS IF MODE3 = 4.
C     THIS IS FIRST LETTER READ BY AN A FORMAT OR IN HOLLERITH FIELD.
C     LETTER = INTEGER SELECTING SPECIAL SYMBOL IF MODE3 = 5.
C     SYMBOLS ARE SPECIFIED BY LETTER VALUES   1,2=TRIANGLE   3,4=SQUARE
C     5,6=PENTAGON   7,8=HEXAGON   9,10=OCTAGON   AND   11,12=CROSS.
C
C     LASTX = LAST X GRID COORDINATE PLOTTED.
C     LASTY = LAST Y GRID COORDINATE PLOTTED.
C
      DIMENSION XPOINT(1000),YPOINT(1000),LCT(12),KRD(76),KRDX(12),
     1KRDY(12)
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      DATA (LCT(I),I=1,12)/0103,0403,0704,1104,1505,2005,2506,3106,3708,
     1 4508,5312,6512/
      DATA (KRD(I),I=1,76)/00,36,60,06,66,30,00,06,66,60,03,36,63,30,04,
     136,64,50,10,16,56,62,30,02,03,26,46,63,40,20,04,36,64,62,30,02,04,
     226,46,64,62,40,20,02,03,15,36,55,63,51,30,11,04,24,26,46,44,64,62,
     342,40,20,22,02,05,16,34,56,65,43,61,50,32,10,01,23/
C
C     ************CHECK FOR LIMITS OF INPUT COORDINATE DATA*************
      IF(MODE1-2)11,1,11
    1 YLOWER=YPOINT(KRDBGN)
      YUPPER=YPOINT(KRDBGN)
      DO 5 I=KRDBGN,KRDEND
      IF(YLOWER-YPOINT(I))3,3,2
    2 YLOWER=YPOINT(I)
    3 IF(YUPPER-YPOINT(I))4,5,5
    4 YUPPER=YPOINT(I)
    5 CONTINUE
      IF(MODE2-2)6,12,91
    6 XLEFT=XPOINT(KRDBGN)
      XRIGHT=XPOINT(KRDBGN)
      DO 10 I=KRDBGN,KRDEND
      IF(XLEFT-XPOINT(I))8,8,7
    7 XLEFT=XPOINT(I)
    8 IF(XRIGHT-XPOINT(I))9,10,10
    9 XRIGHT=XPOINT(I)
   10 CONTINUE
      GO TO 13
   11 YLOWER=YFIRST
      YUPPER=YFINAL
   12 XLEFT=XFIRST
      XRIGHT=XFINAL
   13 FIRSTX=XLEFT
      FINALX=XRIGHT
      FIRSTY=YLOWER
      FINALY=YUPPER
C
C     **************CALCULATE SCALING FACTORS AND OFFSETS***************
      XSCALE=FACTOR*XWIDTH/(XRIGHT-XLEFT)
      YSCALE=FACTOR*YWIDTH/(YUPPER-YLOWER)
      XMIN=XCORNR*FACTOR+OFSETX
      YMIN=YCORNR*FACTOR+OFSETY
      XMAX=XMIN+(FACTOR*XWIDTH)
      YMAX=YMIN+(FACTOR*YWIDTH)
      DIF=FACTOR*XWIDTH/(FLOAT(KRDEND-KRDBGN))
      IF(MODE3-2)14,15,70
C
C     ****************************LINE PLOT*****************************
   14 HALF=RELHIT*FACTOR*YWIDTH/100.0
      WIDTH=1.0+(2.0*HALF)
   15 LINE=-1
      MODE=IFREER
      IF(MODE2-2)17,16,91
   16 THISX=XMIN
      GO TO 18
   17 THISX=XMIN+(XSCALE*(XPOINT(KRDBGN)-XLEFT))
   18 THISY=YMIN+(YSCALE*(YPOINT(KRDBGN)-YLOWER))
      INDEX=KRDBGN
   19 INDEX=INDEX+1
      IF(INDEX-KRDEND)20,20,91
   20 THATX=THISX
      THATY=THISY
      IF(MODE2-2)22,21,91
   21 THISX=XMIN+(DIF*(FLOAT(INDEX-KRDBGN)))
      GO TO 23
   22 THISX=XMIN+(XSCALE*(XPOINT(INDEX)-XLEFT))
   23 THISY=YMIN+(YSCALE*(YPOINT(INDEX)-YLOWER))
      DISTX=THISX-THATX
      DISTY=THISY-THATY
C
C     ********DETERMINE COORDINATES IF LINES CONNECT BLANK AREAS********
      IF(MODE3-1)91,25,24
   24 STARTX=THATX
      STARTY=THATY
      HALTX=THISX
      HALTY=THISY
      IF(MODE1-3)43,46,91
   25 IF(DISTX)27,26,26
   26 IF(DISTY)31,28,28
   27 IF(DISTY)29,30,30
   28 IF(DISTX-DISTY)33,32,32
   29 IF(DISTX-DISTY)34,35,35
   30 IF(DISTX+DISTY)34,33,33
   31 IF(DISTX+DISTY)35,32,32
   32 IF(DISTX-WIDTH)19,36,36
   33 IF(DISTY-WIDTH)19,39,39
   34 IF(DISTX+WIDTH)37,37,19
   35 IF(DISTY+WIDTH)40,40,19
   36 STARTX=THATX+HALF
      HALTX=THISX-HALF
      GO TO 38
   37 STARTX=THATX-HALF
      HALTX=THISX+HALF
   38 STARTY=THATY+((DISTY*(STARTX-THATX))/DISTX)
      HALTY=THISY+((DISTY*(HALTX-THISX))/DISTX)
      GO TO 42
   39 STARTY=THATY+HALF
      HALTY=THISY-HALF
      GO TO 41
   40 STARTY=THATY-HALF
      HALTY=THISY+HALF
   41 STARTX=THATX+((DISTX*(STARTY-THATY))/DISTY)
      HALTX=THISX+((DISTX*(HALTY-THISY))/DISTY)
   42 LINE=-1
      IF(MODE1-3)43,46,91
C
C     *******************PLOT THE LINE WITHOUT TESTS********************
   43 IF(LINE)44,44,45
   44 LINE=1
      NEWX=STARTX
      NEWY=STARTY
      CALL PENUP (LASTX,LASTY,NEWX,NEWY)
   45 NEWX=HALTX
      NEWY=HALTY
      CALL PENDWN(LASTX,LASTY,NEWX,NEWY)
      GO TO 19
C
C     ***************TEST HORIZONTAL COORDINATES OF LINE****************
   46 IF(MODE2-2)47,57,91
   47 IF(STARTX-XMIN)48,49,49
   48 STARTX=XMIN
      LINE=-1
      IF(HALTX-XMIN)19,53,53
   49 IF(STARTX-XMAX)51,51,50
   50 STARTX=XMAX
      LINE=-1
      IF(HALTX-XMAX)51,51,19
   51 IF(HALTX-XMIN)52,53,53
   52 HALTX=XMIN
      GO TO 55
   53 IF(HALTX-XMAX)55,55,54
   54 HALTX=XMAX
   55 IF(ABS(DISTX)-0.1)57,56,56
   56 STARTY=THATY+((DISTY*(STARTX-THATX))/DISTX)
      HALTY=THISY-((DISTY*(THISX-HALTX))/DISTX)
C
C     ****************TEST VERTICAL COORDINATES OF LINE*****************
   57 IF(STARTY-YMIN)58,59,59
   58 STARTY=YMIN
      LINE=-1
      IF(HALTY-YMIN)19,63,63
   59 IF(STARTY-YMAX)61,61,60
   60 STARTY=YMAX
      LINE=-1
      IF(HALTY-YMAX)61,61,19
   61 IF(HALTY-YMIN)62,63,63
   62 HALTY=YMIN
      GO TO 65
   63 IF(HALTY-YMAX)65,65,64
   64 HALTY=YMAX
   65 IF(ABS(DISTY)-0.1)67,66,66
   66 STARTX=THATX+((DISTX*(STARTY-THATY))/DISTY)
      HALTX=THISX-((DISTX*(THISY-HALTY))/DISTY)
C
C     *******************PLOT THE TESTED LINE SEGMENT*******************
   67 IF(LINE)68,68,69
   68 LINE=1
      NEWX=STARTX
      NEWY=STARTY
      CALL PENUP (LASTX,LASTY,NEWX,NEWY)
   69 NEWX=HALTX
      NEWY=HALTY
      CALL PENDWN(LASTX,LASTY,NEWX,NEWY)
      GO TO 19
C
C     ************PREPARE FOR POINT, LETTER OR SYMBOL PLOT**************
   70 KSCALE=RELHIT*FACTOR*YWIDTH/300.0
      MINX=XMIN
      MAXX=XMAX
      MINY=YMIN
      MAXY=YMAX
      IF(MODE3-4)71,72,73
   71 MODE=IPOINT
      GO TO 77
   72 NEWX=0
      CALL LTRPLT (LETTER,1,1,0,KSCALE,LASTX,LASTY,NEWX,NEWY)
      NEWX=(NEWX-2*KSCALE)/2
      XMIN=XMIN-FLOAT(NEWX)
      YMIN=YMIN-FLOAT(3*KSCALE)
      MINX=XMIN
      MINY=YMIN
      MAXX=MAXX-NEWX
      MAXY=MAXY-3*KSCALE
      MODE=ILINE
      GO TO 77
   73 IF(LETTER)91,91,74
   74 IF(LETTER-12)75,75,91
   75 INDEX=LCT(LETTER)/100
      NUM=LCT(LETTER)-100*INDEX
      DO 76 I=1,NUM
      KRDX(I)=KRD(INDEX)/10
      KRDY(I)=KRD(INDEX)-10*KRDX(I)
      KRDX(I)=KSCALE*KRDX(I)
      KRDY(I)=KSCALE*KRDY(I)
   76 INDEX=INDEX+1
      XMIN=XMIN-FLOAT(3*KSCALE)
      YMIN=YMIN-FLOAT(3*KSCALE)
      MINX=XMIN
      MINY=YMIN
      MAXX=MAXX-3*KSCALE
      MAXY=MAXY-3*KSCALE
      MODE=ILINE
C
C     **************FORM THE POINT, LETTER OR SYMBOL PLOT***************
   77 INDEX=KRDBGN-1
   78 INDEX=INDEX+1
      IF(INDEX-KRDEND)79,79,91
   79 IF(MODE2-2)80,81,91
   80 NEWX=XMIN+(XSCALE*(XPOINT(INDEX)-XLEFT))
      NEWY=YMIN+(YSCALE*(YPOINT(INDEX)-YLOWER))
      IF(MODE1-3)86,82,91
   81 NEWX=XMIN+(DIF*(FLOAT(INDEX-KRDBGN)))
      NEWY=YMIN+(YSCALE*(YPOINT(INDEX)-YLOWER))
      IF(MODE1-3)86,84,91
   82 IF(NEWX-MINX)78,84,83
   83 IF(NEWX-MAXX)84,84,78
   84 IF(NEWY-MINY)78,86,85
   85 IF(NEWY-MAXY)86,86,78
   86 IF(MODE3-4)87,88,89
   87 CALL PENUP (LASTX,LASTY,NEWX,NEWY)
      GO TO 78
   88 CALL LTRPLT (LETTER,1,1,1,KSCALE,LASTX,LASTY,NEWX,NEWY)
      GO TO 78
   89 NOWX=NEWX+KRDX(NUM)
      NOWY=NEWY+KRDY(NUM)
      CALL PENUP (LASTX,LASTY,NOWX,NOWY)
      DO 90 I=1,NUM
      NOWX=NEWX+KRDX(I)
      NOWY=NEWY+KRDY(I)
   90 CALL PENDWN(LASTX,LASTY,NOWX,NOWY)
      GO TO 78
   91 RETURN
      END
