@Make(tekrpt)
@string(reportdate="January 4, 1986")
@string(number="114")

@begin(titlepage)
@mast1()
@ReportTitle(@Majorheading(XMIT Installation Guide))
@Begin(Credit)
@>@P(Report No.:  )@\@Value(number)
@>@P(Author:	  )@\Douglas Bigelow
@>@p(Date:	  )@\@value(reportdate)
@End(Credit)
@copyrite()
@mast2()
@end(titlepage)

@Heading(XMIT Installation)


	The XMIT file transfer system was designed to provide automatic
two-way file transfers via an RS-232 connection between two DEC-20's, two
VAXen, or one of each.	In addition, the transfer system is being expanded to
handle connections to personal computer networks.  This file provides a brief
overview of what's involved in setting up the system.

	Each system in an XMIT link requires an "inbox" and an "outbox".
Copying or renaming a file into the "outbox" means that it will soon disappear
and reappear in the "inbox" on the system on the other end of the link.  Files
placed in "outbox" on the other system appear in "inbox" on your system.
Average trip time for small files is about two minutes or less.  Although you
can transfer files that are 200 - 300 pages or more, you probably want to
limit daytime file transfers to 30 pages or less to avoid blocking the
transfer queue for too long.  XMIT has no provision for interrupting large
file transfers to handle small files, although this type of feature could be
implemented.

	The two systems are connected via a straight RS-232 cable with only
four pins needed.  The ports are defined as local lines, so you need only pins
1, 2, 3 and 7 with 2 and 3 reversed.  On a DEC-20, the lines used for XMIT
should be 9600 baud if possible and defined as NOBELL, so that random line
interference won't start up spurious jobs on the line before an XMIT process
can assign it.

@Example{
       1 ]------------------------------[ 1
       2 ]------------. ,---------------[ 2
	 ]	       x		[
       3 ]------------' `---------------[ 3
       7 ]------------------------------[ 7
}

	One system can be connected to many others, with each two-way link
receiving a different logical name assignment for its outbox directory and a
different port name.  At Wesleyan, we have the following arrangement:

@Example{
 System:  KLA (DEC-20)		KLB (DEC-20)
	  ------------		------------
   Port:    TTY40: <======>	 TTY22:
 Outbox:   Outbox:		Outbox:
Logfile:   System:klbmit.log	System:klamit.log

				VAX (11/750)
				------------
   Port:    TTY36: <======>	  TTA4:
 Outbox:   Vaxbox:		Outbox:
Logfile:   System:vaxmit.log	DUA0:<SYS0.GCS>Kla.log
}

	You need a different outbox logical name and program assignment for
each link in order to direct a file transfer to where you want it.  However,
we use only one INBOX: for each system, and incoming files from all XMIT links
are deposited there.  If it is necessary to distinguish the source of incoming
files, assigning unique inboxes for each link would be a trivial task.

	We have set the file protections such that anyone can create a file in
an OUTBOX directory, but cannot otherwise access the directory.  There is no
public access to INBOX except to whopers or those given access via directory
groups.  This has served us fairly well, since most people with accounts on
multiple systems here are high-level staff members with enhanced file access
privileges.  Other sites can set their own parameters as appropriate.  Our
setting are:

@Example{

INBOX: PS:<NETWORK.INBOX>      OUTBOX: PS:<NETWORK.KLB>

Status		 Files-Only    Status		Files-Only
Permanent Quota  Infinite      Permanent Quota	Infinite
Working Quota	 Infinite      Working Quota	Infinite
Dir Protection	 777700        Dir Protection	777744
File Protection  777700        File Protection	777700
Capabilities	 None	       Capabilities	None
User Groups	 None	       User Groups	None
Dir Groups	 1000	       Dir Groups	1000
}


	To build an XMIT on a DEC-20, you must assemble a header file which
describes which system it will be linked to.  Please see the file XMIT.CTL for
examples.  To create an XMIT to talk to system KLB, we would do the following:

@Example{
	@@Load/macro KLBMIT.MAX+XMIT.MAC
	@@Save KLBMIT
}

The file KLBMIT.MAC assigns TTY40: for the link to KLB and writes to the
KLBMIT.LOG log file in SYSTEM:.  Now, you must insert KLBMIT into a system
startup file so that this program starts automatically when the system comes
up.  Wesleyan has an additional sysjob fork which we use for KLBMIT and
VAXMIT, which is just like sysjob running under job 0 except these subforks
don't run with enhanced priority.  You can run an XMIT fork just about any
place you want, as a fork, as a subjob, or as a detached job.  It uses only
one process and very few resources.

	The file XMIT.MSS (distributed with XMIT sources) is a Scribe file
describing the XMIT protocol, used
for implementing new versions.	It is a very raw document and hard to read
unless you're familiar with the code.  I suggest you avoid it and the output
version XMIT.DOC unless you're really serious about this stuff and want to
expand the range of systems that can communicate.

	This document has been quickly created in order to make the deadline
for the Fall '85 TOPS-20 SIG tape, and I don't consider it to be very
comprehensive documentation.  If you decide to use XMIT and need any help,
please feel free to call for further information:

@Format{

	Douglas Bigelow       1-203-347-9411
	Associate Director	   Ext. 2618
	Computing Center
	Wesleyan University
	Middletown, CT	06457
}

If your questions pertain mainly to the VAX end of things, try calling this
person instead:

@format{

	Joseph Deck	      1-203-347-9411
	Systems Programmer	   Ext. 2773
	Computing Center
	Wesleyan University
	Middletown, CT	06457
}
