.PS 58,70
.LITERAL
		PANTT - The PERT and Gantt Program
		
		Peter M. Hurley	     June 1, 1978

	Help file for version 4.3(252) May 9, 1981
.END LITERAL


PANTT is a program written for project managers to aid them in both 
scheduling and daily tracking of their projects.  PANTT is an 
interactive data base management program that allows the project 
manager to enter and update project information and status as each 
project progresses.  Whenever needed, PANTT can output an updated
PERT chart of the project, an overall Gantt chart of the project,
and a Gantt chart for each of the developers 
on the project.

Unlike most other computerized PERT systems, PANTT is designed to 
produce the optimum schedule for more than one interdependent 
projects being staffed by a common set of developers.  As work 
assignments are made, the project manager can direct PANTT to 
associate each developer with his or her assigned projects.  The 
remainder of the projects are scheduled to be completed in the 
shortest time by optimally allocating available developers and by 
reassigning developers as projects are completed.

PANTT also makes it possible for the project manager to set up 
dependencies of some projects on other projects.  The scheduling 
routine determines the critical path and allocates developers to the 
projects on the critical path in a manner that minimizes the length 
of the critical path.  While doing this, the scheduling routine 
acknowledges the dependencies specified by the project manager and 
does not schedule any project until all projects that are blocking 
this project have been completed.

PANTT understands about the common problems of weekends, vacations, 
new employees, outside dependencies, background activities, and 
differing levels of developer productivity that plague all PERT 
systems.  There are facilities integrated into the PANTT system to 
handle each of these problem areas.

Each project being entered into the PANTT data base must be broken 
up into a set of tasks. For example, the XYZ project might have the 
following tasks: functional specification, design specification, 
coding, debugging, and integration.  In this example none of the 
tasks can be started until the previous task has been completed.  
The project manager would set this project up with each task being 
dependent on the task immediately preceding it.  If more detail is 
desired, these tasks could be divided into smaller units.  For 
example, the coding task might be broken up into monitor code, utility
code, and application code.  Both the utility code and the application 
code are dependent on the monitor code being finished and could be 
specified as being dependent on the monitor code task.  But since 
the utility code and the application code tasks are not dependent on 
each other, these tasks can be done in parallel.  The PANTT 
scheduler routine would allocate developers to these tasks in the 
optimum fashion to minimize the overall length of the project.

			PANTT Commands

1.	Top level commands


ADD DEVELOPER user_name (RATE) x (HANDICAP) y

	Add a developer to the overall developer list.  This new 
	developer can spend up to x (0 to 1.0) amount of his or her 
	time working on projects.  The handicap rating, y,
	is the indication of the performance of this developer 
	relative to the other members on the project (1.0 is the 
	norm).

ADD PROJECT (PROJECT NAME) project_name

	Add a project to the data base.  

ADD TASK (TASK NAME) task_name (TO PROJECT) project_name

	Add a task to the specified project.


DELETE DEVELOPER user_name

	Delete the specified user name from the overall developer 
	list.

DELETE PROJECT (PROJECT NAME) project_name

	Delete the specified project and all of its tasks from the 
	data base.

DELETE TASK (FROM PROJECT) project-name (TASK NAME) task_name

	Delete the specified task from the specified project.


EXIT

	Exit from PANTT.


LIST (PROJECT) project_name (TASK) task_name

	Type out all information about a given task. If task_name
	is omitted then all tasks in the project will be listed.

OUTPUT CHANGES-IN-ESTIMATED-DATES (TO FILE) file_specification

	Outputs a list of all estimated dates which changed since the
	last REMEMBER command. 

OUTPUT CONTROL-FILE (TO FILE) file_specification

	Writes a control file for a batch job to rebuild the PANTT
	data-base. This lets one rename projects and make other
	systematic changes with a text editor.

	This process also flushes all dates stored by the last
	REMEMBER command.

OUTPUT DEVELOPER-LIST (TO FILE) file_specification

	Output the overall list of developers, their rates, and 
	their handicaps.


OUTPUT PATH-CHARACTER-LIST (TO FILE) file_specification

	Outputs an alphabetical listing of each task with a given 
	path-character.

OUTPUT PERT-CHART (TO FILE) file_specification

	Output a PERT chart of all tasks in the data base to the 
	specified file specification.

OUTPUT SCHEDULE (TO FILE) file_specification

	Outputs a listing of all tasks sorted by earliest start date, with
	the following information.

	Estimated start and completion dates
.br
	Name of project and task
.br
	Project description
.br
	Task description

OUTPUT SELECTED-PERT-BOXES (TO FILE) file_spec

	Same idea as OUTPUT PERT-CHART except one can select which projects
	get included. See SELECT mode.


OUTPUT TASK-LIST (SORTED BY) EARLIEST-START-DATE (TO FILE) file_spec

	Output a list of the tasks in the data base sorted by the
	earliest start date.  This list contains the task 
	length, the start date, the finish date, the developers 
	available to work on the task, the tasks blocking this task, 
	and the tasks being blocked by this task.

OUTPUT TASK-LIST (SORTED BY) PROJECT (TO FILE) file_spec

	Output a description of each task of each project in the 
	data base.  This report lists all available data about each 
	task.  The list is arranged alphabetically by project and by 
	tasks within each project.

OUTPUT GANTT-CHART (OF) DEVELOPERS (TO FILE) file_spec

	Output a Gantt chart for each developer scheduled to work on 
	some part of this set of projects and tasks.  The Gantt 
	chart includes the dates that the developer is working on a 
	task and the amount of that developers time is being spent 
	on that task.  The Gantt chart pictorially shows the start 
	and end dates for each task that this developer is working 
	on.  The chart also indicates which tasks have been 
	completed and which tasks are in progress.

OUTPUT GANTT-CHART (OF) MILESTONES (TO FILE) file_spec

	Output a chart show the dates of all milestones.

OUTPUT GANTT-CHART (OF) ONLY-DEVELOPER developer (TO FILE) file-spec

	Output a gantt-chart for only one developer. This mode figures
	out a good starting date for the chart.

OUTPUT GANTT-CHART (OF) TASKS (TO FILE) file_spec

	Output a chart showing the start and finish of all tasks.  
	This chart also shows those tasks that have been completed, 
	those tasks that are in progress, and the number of people 
	allocated to each task at any point in time.
.TEST PAGE 36
.LITERAL
PLOT GANTT-CHART (OF) DEVELOPERS (TO FILE) file_spec
PLOT GANTT-CHART (OF) MILESTONES (TO FILE) file_spec
PLOT GANTT-CHART (OF) ONLY-DEVELOPER developer (TO FILE) file_spec
PLOT GANTT-CHART (OF) TASKS (TO FILE) file_spec
PLOT PERT-CHART (TO FILE) file_spec
PLOT SELECTED-PERT-BOXES (TO FILE) file_spec
.END LITERAL

	These commands are identical to the corresponding OUTPUT
	commands except data is written in TXT2P format so that 
	it may be plotted on the VERSATEC plotter. Here is a brief
	example of generating a PERT plot:
.literal
	PANTT>PLOT PERT-CHART (TO FILE) PERT.T2P
	PANTT>EXIT
	@TXT2P
	*PERT.DPL=PERT.T2P
	NO ERRORS DETECTED
	*^C
	@R P
	MODE(S)? 1
	INPUT FILENAME(.DPL): PERT.DPL
	@DO SYS:NETPLO PERT.PLO
	now go over the LA36 next to the PDP-11 and type:
	RUN MAPVP
	INPUT FILENAME: PERT.PLO/E
.end literal
	The above procedure worked on system 1031 on 26 June 80. Things
	may have changed since that date.

	NOTE: The VERSATEC system is now located in CIRCUIT DESIGN DRAFTING
	on MR1-2. 

REMEMBER (ESTIMATED DATES FOR FUTURE COMPARISON)

	Remembers the estimated dates for each task. These may be 
	compared with the latest estimates with the OUTPUT CHANGES
	command.

SCHEDULE

	Perform a scheduling pass over all tasks in the data base.  
	This command requests the "Scheduler Look Ahead Value".  
	This is the searching depth to which the scheduler will go 
	when trying to resolve scheduling conflicts.  A conflict 
	arises when there are more than one tasks that are not being 
	blocked by any other tasks and the set of developers 
	available to work on these tasks overlap.  These conflicts 
	are resolved by an exhaustive check of all combinations and
	permutations of developers and tasks.  The scheduler choses 
	the order that minimizes the end date of the critical path.

	Since the length of time to perform a scheduling pass 
	increases exponentially as the number of conflicts goes up, 
	PANTT allows the project manager to specify the depth of the 
	search.  If 
	the scheduler look ahead value is set to 0, PANTT will do a 
	complete scheduling pass in the shortest possible time.  
	[[Values other than zero have not been well tested]]

SET HOLIDAY (DATE) date

	Prevents work from being scheduled on specified date.

SET PERT-PLACEMENT-ALGORITHM (TO THE) DEFAULT (PLACEMENT ALGORITHM)

	Places the PERT boxes using minimum cpu time.

SET PERT-PLACEMENT-ALGORITHM (TO THE) HIGH-DENSITY (PLACEMENT ALGORITHM)

	Reduces the amount of white-space on the pert chart. If your
	pert chart is larger than the plotter or line-printer page,
	this command may help it fit.

	This mode may also produce better looking pert charts. [Depends
	on your definition of "good looking"]

SET SCHEDULE-DATE (TO) date

	Pretend today is "date". Useful if a project will not start for
	a while.

UPDATE (PROJECT) project_name

	Enter update mode for the specified project.  This command
	allows the project manager to go change project related 
	data.  See the section on project commands for more detailed 
	information.

UPDATE (PROJECT) project_name (TASK) task_name

	Enter update mode for the specified task.  This command 
	allows the project manager to update task data for the 
	specified task.  See the section on task commands for 
	further details.

2.	Project Commands

DELETE DEVELOPER user_name

	Delete a developer from the list of developers assigned to 
	this specific project.


DEVELOPER user_name (RATE) x (HANDICAP) y

	Add the specified user to the list of developers available 
	to work on this project.  The maximum amount of time that 
	this developer can spend on this project is x (0 to 1.0).  
	The relationship of this developer to the other developers 
	on the project is y (1.0 is the norm).


FINISHED (UPDATING PROJECT DATA)

	This command returns to the top command level.


LIST

	This command lists all the available data about this 
	project.  


PREFERENCE-VALUE (FOR FREE CHOICE) x

	This command sets the free choice preference value for this 
	project.  Whenever the scheduling routine makes a free 
	choice of the next task to be scheduled, this preference 
	value will bias its choice.  The higher the value, the 
	sooner the scheduler will chose tasks of this project to be 
	done.


PROJECT-DESCRIPTION

	This command lets the project administrator rewrite the 
	description of this project.  This description can be more 
	than one line in length, and it is terminated with an 
	ALTMODE or a CTRL/Z.

3.	Task Commands

ALL-DEVELOPERS-REQUIRED

	This sets a bit which forces all listed developers to work on this task
	for an equal amount of time. This is useful for design reviews, group 
	meetings and other tasks where all developers are required.

	This command will be replaced (or augmented) in a future version by
		NUMBER-OF-DEVELOPERS-REQUIRED (IS EXACTLY) n
	which will schedule n of the available developers to work together on
	this task.

ATTRIBUTE (NAME IS) name (VALUE) value

	This allows the user to add additional description to a given
	task. Attributes are remembered in the database and printed 
	when the task is listed. For example, the command:
.nf
		ATTRIBUTE (NAME IS) BUDGET (VALUE) 35K
	will generate a line containing:
	        BUDGET: 35K
	whenever the task is listed.
.f

COMPLETION-DATE date

	This command specifies the actual completion date of the 
	task.  If a task has a completion date specified, then the 
	scheduler assumes that this project must be scheduled 
	according to this date.  The completion date can be 
	specified as a date in the future.  An example of this is 
	when a project manager adds a task to indicate that a 
	developer is going to be on vacation on a particular date.


DELETE COMPLETION-DATE

	This command deletes the actual finishing date for this
	task.


DELETE DEPENDENCY (ON PROJECT) project_name (TASK NAME) task_name

	This command removes the dependency of the task being 
	updated on the task specified in this command.

DELETE DEVELOPER user_name

	This command deletes the specified user from the list of 
	developers that are available to work on this task.


DELETE ESTIMATED-PROJECT-LENGTH

	This command deletes the specified task length.


DELETE EXPECTED COMPLETION-DATE

	This command deletes the expected completion date of the
	task.


DELETE EXPECTED STARTING-DATE

	This command deletes the expected start date of the
	task.

DELETE MINIMUM-STARTING-DATE

	This command deletes the minimum starting date specification
	for this task.

DELETE PATH-CHARACTER

	Remove the critical path character from this task

DELETE PREFERENCE-VALUE

	This command deletes the preference value for this 
	task.

DELETE STARTING-DATE

	This command deletes the starting date of the task.


DEPENDENCY (ON PROJECT) project_name (TASK NAME) task_name

	This command indicates that this task cannot be started 
	until the specified task has been completed.


DEVELOPER user_name (RATE) x (HANDICAP) y

	Add the specified user to the list of developers that can be 
	assigned to work on this task.  The rate and handicap values 
	for this developer are x and y.


ESTIMATED-PROJECT-LENGTH (IN DAYS) n

	This command specifies the estimated length of the project.  
	The task length is specified in work days (5 work days per 
	week).  This is an integer value; fractional days are not 
	accepted.


EXPECTED COMPLETION-DATE (IS) date

	This command is used to set the expected completion date of 
	a project.  This differs from the actual completion date 
	only in the fact that this date is not guaranteed.  However, 
	the scheduling routine treats this date as if it is a firm 
	date for scheduling purposes.

EXPECTED STARTING-DATE (IS) date

	Set the expected starting date.  The scheduling routine will 
	cause this task to be scheduled on the specified date.


FINISHED (UPDATING TASK DATA)

	This command returns to the top command level.


LIST

	This command lists all available data about the task.

LONG-ATTRIBUTE name

	This is the same as ATTRIBUTE except it takes a long string
	terminated with an escape. Example:
.nf
		LONG-ATTRIBUTE (NAME IS) COMPLETION-CRITERIA
		VALUE OF ATTRIBUTE (<ESC> WHEN DONE)
                	ALL DEMO INFORMATION IS IN FILE.
		$
	will produce:
	        COMPLETION-CRITERIA:
	                ALL DEMO INFORMATION IS IN FILE.
	whenever, the task is listed.
.f

MILESTONE

	This command marks this task as being a milestone. 


MINIMUM-STARTING-DATE date

	This command specifies the earliest date that the this task 
	can be scheduled.  The scheduling routines will 
	schedule this task at the optimal time after this date.


PATH-CHARACTER (IS) x

	This command assigns a "critical-path character" to a task. 
	All tasks on the critical path blocking this task are flagged
	with this path character. This allows several critical paths
	to be monitored.

PREFERENCE-VALUE (FOR FREE CHOICE) x

	This command sets the free choice preference value for this 
	task.  Whenever the scheduler has a free choice between two 
	tasks belonging to the same project, it will chose the task 
	with the higher preference value.  If both tasks have the 
	same preference value, then it will chose the task that will 
	finish in the longest time.


STARTING-DATE date

	This command sets the actual starting date of the task.  The 
	scheduling routines chose tasks that have starting dates 
	specified before any other tasks are chosen.  In this way, 
	these tasks will be completed without interruption.


TASK-DESCRIPTION

	This command allows the project manager to enter a new 
	description of the task.


TIME-TO-DATE (IN DAYS) n (AT DATE) date

	This command specifies that n work days had been spent on this 
	project at the specified date.  This command is used to give 
	updated information about the progress of a task after the 
	start date but before the completion date.

4.	SELECT MODE


There is a new option in the OUTPUT and PERT commands called
SELECTED-PERT-BOXES. The format of the command is exactly the same as
the normal PERT option except it leaves you in SELECT: mode when you
are done. SELECT: mode currently has 2 possible commands, FINISHED and
INCLUDE. 

INCLUDE PROJECT project-name (NAME) task

	If TASK is omitted the entire project is pert'ed. If TASK is given,
	only that box is pert'ed. There may be any number of INCLUDE commands.

FINISHED
	gets you out of select mode and writes out the pert.

	example:
.LITERAL
	PANTT> PLOT SELECTED-PERT-BOXES (TO FILE) KL10.T2P
	SELECT: INCLUDE PROJECT CPU
	SELECT: INCLUDE PROJECT EBOX
	SELECT: INCLUDE PROJECT MBOX
	SELECT: INCLUDE PROJECT DEBUG CPU-POWERON
	SELECT: FINISHED
.END LITERAL

	This will produce a PERT chart of the CPU design up to CPU poweron. 

	The selection happens prior to placing the boxes on the plot
	and the plot looks as good as any full PANTT chart.
	Selection only changes what gets plotted. All tasks are scheduled,
	slacks set, and critical paths determined based on the full network.

	If the PERT is plotted (as opposed to printed on the line printer)
	dependencies on boxes not plotted are indicated by arrows. An arrow
	pointing up indicates that this task depends on one or more tasks
	which are not in this PERT. An arrow pointing down indicates that one
	or more tasks which are not in this plot depend on this task.
