;		WESLEYAN UNIVERSITY MONTHLY ACCOUNTING 
;
;	This batch control file generates the monthly accounting 
;	reports for the Wesleyan University DECSYSTEM-2060.
;	The system accounting files are assumed to be named 
;	<ACCOUNTS>nnMONYY.BIN, where 'nn' takes values from 01 to
;	the last day of the month.  ACCT20 uses the NAME command to
;	identify the month for which the data are to be processed,
;	then uses 'MONYY' as a prefix for the reports it generates.
;
;	In many of the commands, the filename which the command may
;	specifiy as the source of input information is defaulted to
;	the ACCT20 default name.  For example, the CHARGE command
;	assumes a default name of ACCT20.CHG.  These files must
;	be present in the directory to which the user is connected
;	when ACCT20 is being run.

;	Note that this batch file does not generate bills for external
;	customers.  This must be done as a separate procedure, using
;	ACCT20, with the names of billable users which are listed in
;	file 'MONYY-BILLED-USERS.TMP'.  Batch file 'BILLER.CTL' serves
;	as a prototype for the billing procedure.
;
;
;TO USE:
;
;	Use the sequence
;		@ED MONTHLY.CTL monyy.CTL
;		*S%$monyy$4000:*
;		*e
;	to change the string '%' to 'monyy', where the lowercase
;	string is the actual month and year of the <ACCOUNTS>
;	system-data binary file sequence you want to process (JUN81,
;	for example).
;	
;	Then, from a privileged directory,
;		@SUBMIT monyy/TIME:10 [/TAG:RERUN]
;
;	(see comments below for reasons to use the TAG)
;
;____________________________________________________________________
;
;	This section enters disk-usage statistics into the system
;	data files for use in NEXT month's accounting.
;
;	To avoid duplicate entries if this batch control file must
;	be run a second time in a month, use the /TAG:RERUN switch
;	on the submit command for second and subsequent runs of
;	the control file.
@ena
@DEF DSK: DSK:,<ACCOUNTS>
@MOUNT STR ADM:
@SYS:chkpnt
*disk PS:
*disk ADM:
*exit
;____________________________________________________________________

RERUN::
@ENA
@DEF DSK: DSK:,<ACCOUNTS>
@RUN ACCT20
*NAME %
*CHARGE
*CAT
*PRI
*FORMS
*DUMP
*WRITE
*STA
*SUM SYS
*LIST-C
*LIST-S
*PRO
*EXIT
@copy %-categories.lst %.sum
@PRI %-CATEGORIES.LST/COP:4/HEADER
@PRI %-SUMMARY.LST/COP:4/HEADER
@COPY %-FORMS.DMI TFORMS.DMI
@1022
*LOAD FORMS DATA TFORMS.DMI
*O FORMS YTDFRM
*DBSET 1
*F FORM NE 'NORMAL'
*DBSET 2
*APPEND SET 1
*O FORMS
*USE FORMTY
*USE FORMUS
*EXI
@DEL FORMS.DMS
@PRI /copies:3 /header FORMUS.LST,FORMTY.LST
@mount tape mta-dumper:/write/density:6250/vol:ACC011,ACC012,ACC013
@dumper
*files
*rew
*eot
*save <accounts>*%.BIN,%-*.*
*rew
*pri /headers lpt:ACCT20.DIR
*exi
@dism mta-dumper:
@DEL %-FORMS.DMI,TFORMS.DMI
@TYPE %-BILLED-USERS.TMP
@DEL %-BILLED-USERS.TMP
@DEL <ACCOUNTS>*%.BIN
@EXP <ACCOUNTS>
