      SUBROUTINE FMTASK(MASTER,ITTY,JTTY,IDISK,JDISK,KDISK)
C     RENBR(/USER INTERACTION, DECSYSTEM 10 VERSION)
C
C     DONALD E. BARTH, HARVARD BUSINESS SCHOOL
C
C     THIS ROUTINE IS CALLED BY  FORMAT STATEMENT GENERATOR
C     TO ASK USER FOR NAMES OF  INPUT AND OUTPUT FILES, AND
C     THEN TO OPEN THESE FILES.
C
C     MASTER = 0 ON INPUT, FIRST  TIME  THAT  THE  USER  IS
C              BEING  ASKED  TO  SPECIFY  FILES.   USER  IS
C              REQUIRED TO SPECIFY INPUT FILE.   MASTER  IS
C              RETURNED UNCHANGED BY THIS PROGRAM.
C            = 1 ON INPUT,  SECOND OR SUBSEQUENT TIME  THAT
C              USER IS BEING ASKED TO SPECIFY FILES.  IF NO
C              INPUT FILE  IS  SPECIFIED,  THEN  MASTER  IS
C              RETURNED  UNCHANGED  AND  EXIT IS ASSUMED BY
C              MAIN PROGRAM.  IF INPUT FILE  IS  SPECIFIED,
C              THEN MASTER IS RETURNED SET TO -1.
C     ITTY   = UNIT NUMBER FOR MESSAGES TO BE SEEN BY USER
C     JTTY   = UNIT NUMBER FROM WHICH USER RESPONSE IS READ
C     IDISK  = UNIT NUMBER FROM WHICH INPUT SOURCE FILE  IS
C              TO BE READ
C     JDISK  = UNIT NUMBER TO WHICH OUTPUT FORTRAN FILE  IS
C              TO BE WRITTEN
C     KDISK  = UNIT NUMBER TO WHICH OUTPUT PROOF FILE IS TO
C              BE WRITTEN
C
      DOUBLE PRECISION NAMSRC,NAMPRF,NAMFMT,NAMNON
      DATA NAMNON/10H          /
C
C     TELL USER THAT ARE DONE WITH PREVIOUS INPUT
      IF(MASTER.EQ.0)WRITE(ITTY,1)
    1 FORMAT(15H FORMAT (08/83)/
     137H CONSTRUCTS FORTRAN FORMAT STATEMENTS/1X)
      IF(MASTER.NE.0)WRITE(ITTY,2)
    2 FORMAT(1X/24H TYPE EMPTY LINE TO EXIT/1X)
C
C     OPEN INPUT FILE
    3 WRITE(ITTY,4)
    4 FORMAT(20H INPUT SOURCE FILE: ,$)
      READ(JTTY,5)NAMSRC
    5 FORMAT(1A10)
      IF(MASTER.EQ.0)GO TO 6
      IF(NAMSRC.EQ.NAMNON)GO TO 13
    6 OPEN(UNIT=IDISK,FILE=NAMSRC,ACCESS='SEQIN',ERR=7)
      GO TO 9
    7 WRITE(ITTY,8)
    8 FORMAT(17H CANNOT OPEN FILE)
      GO TO 3
C
C     OPEN OUTPUT FORMAT STATEMENT FILE
    9 WRITE(ITTY,10)
   10 FORMAT(22H OUTPUT FORTRAN FILE: ,$)
      READ(JTTY,5)NAMFMT
      OPEN(UNIT=JDISK,FILE=NAMFMT,ACCESS='SEQOUT',ERR=9)
C
C     OPEN OUTPUT PROOF FILE
   11 WRITE(ITTY,12)
   12 FORMAT(20H OUTPUT PROOF FILE: ,$)
      READ(JTTY,5)NAMPRF
      OPEN(UNIT=KDISK,FILE=NAMPRF,ACCESS='SEQOUT',ERR=11)
C
C     INFORM CALLING PROGRAM THAT FILES OPENED SUCCESSFULLY
      MASTER=-MASTER
   13 RETURN
      END
      SUBROUTINE FMTEND(JDISK,KDISK)
C     RENBR(/CLOSE FILES, DECSYSTEM 10 VERSION)
C
C     DONALD E. BARTH, HARVARD BUSINESS SCHOOL
C
C     THIS ROUTINE IS CALLED BY  FORMAT STATEMENT GENERATOR
C     TO CLOSE THE OUTPUT FILES.
C
C     JDISK  = UNIT NUMBER TO WHICH OUTPUT FORTRAN FILE WAS
C              WRITTEN
C     KDISK  = UNIT NUMBER TO WHICH OUTPUT PROOF FILE WAS
C              WRITTEN
C
      CLOSE(UNIT=JDISK)
      CLOSE(UNIT=KDISK)
      RETURN
      END
