        .MACRO GRAPHIC
	;
	; GROUP 1 (GENERAL)
	;
DPC=^O172000		; DISPLAY PROGRAM COUNTER
DSR=^O172002		; DISPLAY STATUS REGISTER
XSTAT=^O172004		; X STATUS REGISTER
YSTAT=^O172006		; Y STATUS REGISTER
CHAR=^O100000		; CHARACTER MODE
SHORTV=^O104000		; SHORT VECTOR MODE
LONGV=^O110000		; LONG VECTOR MODE
POINT=^O114000		; POINT MODE
RELATV=^O130000		; RELATIVE POINT MODE
GRAPHX=^O120000		; GRAPHPLOT X MODE
GRAPHY=^O124000		; GRAPHPLOT Y MODE
	;
INT0=^O2000		; INTENSITY 0 (DIMMEST)
INT1=^O2200		;
INT2=^O2400		;
INT3=^O2600		;
INT4=^O3000		; INTENSITY LEVELS
INT5=^O3200		;
INT6=^O3400		;
INT7=^O3600		; INTENSITY 7 (BRIGHTEST)
	;
LPOFF=^O100		; LIGHT PEN OFF
LPON=^O140		; LIGHT PEN ON
	;
BLKOFF=^O20		; BLINK OFF
BLKON=^O30		; BLINK ON
	;
LINE0=^O4		; SOLID LINE
LINE1=^O5		; LONG DASH
LINE2=^O6		; SHORT DASH
LINE3=^O7		; DOT DASH
	;
	; GROUP 2 (DISPLAY JUMP)
	;
DJMP=^O160000		; DISPLAY JUMP
	;
	; GROUP 3 (DISPLAY NO-OP)
	;
DNOP=^O164000		; DISPLAY NO OPERATION
	;
	; GROUP 4 (LOAD STATUS REGISTER A)
	;
STATSA=^O170000		; LOAD STATUS REGISTER A INSTRUCTION
DSTOP=^O173400		; DISPLAY STOP AND INTERRUPT
SINON=^O1400		; STOP INTERRUPT ON
SINOF=^O1000		; STOP INTERRUPT OFF
LPLITE=^O200		; LIGHT PEN HIT ON
LPDARK=^O300		; LIGHT PEN HIT OFF
ITAL0=^O40		; ITALICS OFF (NORMAL FONT)
ITAL1=^O60		; ITALICS ON (ITALICS FONT)
SYNC=^O4		; HALT AND RESUME IN SYNC
	;
	; GROUP 5 (LOAD STATUS REGISTER B)
	;
STATSB=^O174000		; LOAD STATUS REGISTER B INSTRUCTION
INCR=^O100		; ENABLE GRAPHPLOT INCREMENT
	;
	; GROUP 6 (VECTOR/POINT MODES)
	;
INTX=^O40000		; INTENSIFY VECTOR OR POINT
MAXX=^O1777		; MAXIMUM DELTA X COMPONENT
MAXY=^O1377		; MAXIMUM DELTA Y COMPONENT
MINUSX=^O20000		; NEGATIVE DELTA X COMPONENT
MINUSY=^O20000		; NEGATIVE DELTA Y COMPONENT
	;
	; GROUP 7 (SHORT VECTOR MODE)
	;
MAXSX=^O17600		; MAXIMUM DELTA X COMPONENT
MAXSY=^O77		; MAXIMUM DELTA Y COMPONENT
MISVX=^O20000		; NEGATIVE DELTA X COMPONENT
MISVY=^O100		; NEGATIVE DELTA Y COMPONENT
        .MCALL SGM,SV,JUMP,LV,PT,GRF,RPT,LDA,LDB
        .ENDM
	;
	; THE FOLLOWING MACRO GRAPHIC INSTRUCTIONS
	; WERE WRITTEN BY DAVE MASON ('73 - '74)
	;
	; THEY ARE NOT COMPATIBLE WITH THE STANDARD
	; GT40 DEFINITIONS ABOVE
	;
	; SET GRAPHIC MODE INSTRUCTION
	;
        .MACRO SGM MODE,LINE,INT,LP,BL
..=^O7&MODE+^O20*^O4000
        .IF    NB,LINE
..=LINE&^O3+^O4+..
        .ENDC
        .IF    NB,INT
..=INT&^O7+^O10*^O200+..
        .ENDC
        .IF    NB,LP
..=LP&1+^O2*^O40+..
        .ENDC
        .IF    NB,BL
..=BL&1+^O2*^O10+..
        .ENDC
	.WORD	..
        .ENDM
	;
	; SHORT VECTOR DATA
	;
        .MACRO SV X,Y,I
        .IF    LT,X
..=-X&^O77+^O100*^O200
        .IFF
..=X&^O77*^O200
        .ENDC
        .IF    LT,Y
..=-Y&^O77+^O100+..
        .IFF
..=Y&^O77+..
        .ENDC
        .IF    NB,I
..=..+^O40000
        .ENDC
	.WORD	..
        .ENDM
	;
	; LONG VECTOR DATA
	;
        .MACRO LV X,Y,I
        .IF    LT,X
..=-X&^O1777+^O20000
        .IFF
..=X&^O1777
        .ENDC
        .IF    NB,I
..=..+^O40000
        .ENDC
	.WORD	..
        .IF    LT,Y
..=-Y&^O1777+^O20000
        .IFF
..=Y&^O1777
        .ENDC
	.WORD	..
        .ENDM
	;
	; POINT DATA
	;
        .MACRO PT X,Y,I
        .IF    NB,I
        X&^O1777+^O40000
        .IFF
        X&^O1777
        .ENDC
        Y&^O1777
        .ENDM
	;
	; GRAPH X DATA
	;
        .MACRO GRF X
        X&^O1777
        .ENDM
	;
	; RELATIVE POINT DATA
	;
        .MACRO RPT X,Y,I
        SV     X,Y,I
        .ENDM
	;
	; LOAD STATUS REGISTER A INSTRUCTION
	;
        .MACRO LDA ST,INT,LPI,IT,SY
..=^O170000
        .IF    NB,INT
..=INT&1+^O2*^O400+..
        .ENDC
        .IF    NB,LPI
..=LPI&1+^O2*^O100+..
        .ENDC
        .IF    NB,IT
..=IT&1+^O2*^O20+..
        .ENDC
        .IF    NB,ST
..=ST&1*^O2000+..
        .ENDC
        .IF    NB,SY
..=SY&1*^O2+..
        .ENDC
	.WORD	..
        .ENDM
	;
	; LOAD STATUS REGISTER B INSTRUCTION
	;
        .MACRO LDB GP
        GP&^O77+^O174100
        .ENDM
	;
	; DISPLAY JUMP INSTRUCTION
	;
        .MACRO JUMP X
        ^O160000,X
        .ENDM
	;
	; DISPLAY NO-OP WITH DATA
	;
        .MACRO NOPD X
        .IF    NB,X
        X&^O3777+^O164000
        .IFF
        ^O164000
        .ENDC
        .ENDM
	;
	; THE FOLLOWING MACROS WERE WRITTEN BY
	; LEIGH CLAYTON ('73 - '74) NOTE
	; THAT THE APPROPRIATE FP40 ROUTINES MUST BE
	; ASSEMBLED ALONG WITH THE CURRENT PROGRAM
	; NO FLOATING POINT ROUTINES ARE USED IN THE
	; GIDUS PROGRAM
	;
        .MACRO FP40
        .MCALL F.ADD,F.SUB,F.MUL,F.DIV,F.ABS,F.NEG,F.FIX,F.FLT,F.FXR
        .MCALL F.TST,F.MOV,F.CMP,F.CLR
        .MCALL F.SIN,F.COS,F.SQR,F.LDX,F.STX
        .MCALL F.SEOF,F.SEUF,F.SDBZ,F.SICE
        .ENDM
	;
        .MACRO F.ADD A,B,C
        JSR    %0,.F$ADD
        .WORD  A,B,C              ;C <-- A+B
        .ENDM
	;
        .MACRO F.SUB A,B,C
        JSR    %0,.F$SUB
        .WORD  A,B,C              ; C <-- A-B
        .ENDM
	;
        .MACRO F.MUL A,B,C
        JSR    %0,.F$MUL
        .WORD  A,B,C              ; C <-- A <MULTIPLIED.BY> B
        .ENDM
	;
        .MACRO F.DIV A,B,C
        JSR    %0,.F$DIV
        .WORD  A,B,C              ; C <-- A <DIVIDED.BY> B
        .ENDM
	;
        .MACRO F.ABS A,B
        JSR    %0,.F$ABS
        .WORD  A,B                ; B <-- <ABSOLUTE.VALUE.OF> A
        .ENDM
	;
        .MACRO F.NEG A,B
        JSR    %0,.F$NEG
        .WORD  A,B                ; B <-- <NEGATIVE.OF> A
        .ENDM
	;
        .MACRO F.FIX A,I
        JSR    %0,.F$FIX
        .WORD  A,I                ; I <-- <INTEGER.PART.OF> A
        .ENDM
	;
        .MACRO F.FLT I,A
        JSR    %0,.F$FLT
        .WORD  I,A                ; A <-- <FLOATING.REPRESENTATION.OF> I
        .ENDM
	;
        .MACRO F.FXR A,I,B
        JSR    %0,.F$FXR
        .WORD  A,I,B              ; FIX A INTO I, FRACTION GOES INTO B
        .ENDM
	;
        .MACRO F.TST A
        BIT    #^O077600,A        ; SETT CC BY F.P. NUMBER
        BEQ    .+6
        TST    A
        .ENDM
	;
        .MACRO F.MOV A,B
        MOV    A,B                ; MOVE F.P. NUMBER
        MOV    A'+2,B'+2
        .ENDM
	;
        .MACRO F.CMP A,B
        JSR    %0,.F$CMP
        .WORD  A,B                ; COMPARE A AND B
        .ENDM
	;
        .MACRO F.SIN A,B
        JSR    %0,.F$SIN
        .WORD  A,B                ; B <-- SIN (A)  // A IS IN RADIANS
        .ENDM
	;
        .MACRO F.COS A,B
        JSR    %0,.F$COS
        .WORD  A,B                ; B<-- COS(A)  /A IS IN RADIANS
        .ENDM
	;
        .MACRO F.SQR A,B
        JSR    %0,.F$SQR
        .WORD  A,B                ; B <-- SQRT(A)
        .ENDM
	;
        .MACRO F.LDX I,A,B
        JSR    %0,.F$LDX
        .WORD  I,A,B              ; FORM EXCESS 200 EXP FROM I, AND TAKE
;                                 ; CHARACTERISTIC FROM A, TO FORM B
        .ENDM
	;
        .MACRO F.STX A,I
        JSR    %0,.F$STX
        .WORD  A,I                ; I GETS EXPONENT FROM A
;                                 ; ( *NOT* IN EXCESS 200 FORM  )
        .ENDM
	;
        .MACRO F.SEOF  ADDR
        JSR    %0,.F$XOF          ; SET/RESET EXP.OVRF ERROR ADDRESS
        .IIF   B,ADDR,.WORD 0     ; RESET TO NULL IF BLANK PARAM
        .IIF   NB,ADDR,.WORD ADDR ; NEW ADDRESS IF SPECIFIED
        .ENDM
	;
        .MACRO F.SEUF ADDR
        JSR    %0,.F$XUF          ; EXP. UNDERFLOW ERROR
        .IIF   B,ADDR,.WORD 0
        .IIF   NB,ADDR,.WORD ADDR
        .ENDM
	;
        .MACRO F.SDBZ ADDR
        JSR    %0,.F$DV0          ; DIVISION BY ZERO
        .IIF   B,ADDR,.WORD 0
        .IIF   NB,ADDR,.WORD ADDR
        .ENDM
	;
        .MACRO F.SICE ADDR
        JSR    %0,.F$ICN          ; INTEGER CONVERSION (FIX)
        .IIF   B,ADDR,.WORD 0
        .IIF   NB,ADDR,.WORD ADDR
        .ENDM
	;
        .MACRO F.CLR A
        CLR    A                  ; SET F.P. VALUE TO ZERO
        CLR    A+2
        .ENDM
