IDENTIFICATION DIVISION.
PROGRAM-ID. VTTEST.
AUTHOR. T. LAUCK.
DATE-WRITTEN.	21 MAY 71.
DATE-COMPILED.
SECURITY.  COPYRIGHT 1971 BY DIGITAL EQUIPMENT CORPORATION.
REMARKS.
	THIS PROGRAM CONTAINS A NUMBER OF TESTS OF THE VTTAM SYSTEM.
	THIS PROGRAM WAS MODIFIED BY G. KEELER TO USE VT05'S.
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SOURCE-COMPUTER. PDP-10.
OBJECT-COMPUTER. PDP-10.
DATA DIVISION.
WORKING-STORAGE SECTION.
77	CTR1	PIC 9(6) COMP.
77	HOLD-NO	PIC 99.
77	CTR	PIC 9(6) COMP.
77	TST-NO	PIC S9(10) COMP.
77	TERM-NO	PIC S9(10) COMP.
77	LINE-NO	PIC S9(10) COMP.
77	ANS	PIC 9(6) COMP.
77	ANS1	PIC X(3).
	88	YES-ANS VALUES ARE "Y","YE","YES".

01	UNSYNCH	USAGE DISPLAY-6.
	02	FILLER PIC X.
	02	UNSYN-SCREEN PIC X(1440).
	02	UNSYN-SCREEN-END PIC X.

01	LINE-IMAGE USAGE DISPLAY-6.
	02	FILLER	PIC X(7).
	02	CTR-LIN PIC ZZZZZ9.
	02	FILLER PIC X(19) VALUE "THE QUICK BROWN FOX".
	02	LINE-IMAGE-END PIC X.

01	SCREEN-BUFFER USAGE DISPLAY-6.
	02	SCREEN PIC X(1440).
	02	CONTROL-BUF REDEFINES SCREEN.
		03	DEST-TERM PIC 99.
		03	FILLER PIC X(1438).
	02	SCREEN-END PIC X.


01	ERROR-MSG	USAGE DISPLAY-6.
	02	ILL-TERM	PIC X(17) VALUE "ILLEGAL DEST-TERM".
	02	ILL-TERM-END	PIC X.
PROCEDURE DIVISION.
START.
	DISPLAY "TEST ILLEGAL CALLS?".
	ACCEPT ANS1.
	IF NOT YES-ANS GO TO NORMAL-TEST.

GET-TEST-NO.
	DISPLAY "TEST NUMBER?".
	ACCEPT TST-NO.
	GO TO T1,T2, T3, T4, T5, T6, T7, T8, T9
		DEPENDING ON TST-NO.
	DISPLAY "ILLEGAL TEST NUMBER!".
	GO TO GET-TEST-NO.

T1.
	ENTER MACRO VTWAIT USING TERM-NO,SCREEN,SCREEN-END.
	GO TO TEST-SHOULD-NOT-HAVE-PASSED.

T2.
	MOVE 1 TO TERM-NO.
	ENTER MACRO ERSCR USING TERM-NO.
	GO TO TEST-SHOULD-NOT-HAVE-PASSED.
T3.
	MOVE -1 TO TERM-NO.
	GO TO T345.

T4.
	MOVE 0 TO TERM-NO.
	GO TO T345.

T5.
	MOVE 64 TO TERM-NO.

T345.
	ENTER MACRO VTOPEN.
	ENTER MACRO ERSCR USING TERM-NO.
	GO TO TEST-SHOULD-NOT-HAVE-PASSED.

T6.
	MOVE -1 TO LINE-NO.
	GO TO T678.

T7.
	MOVE 0 TO LINE-NO.
	GO TO T678.

T8.
	MOVE 26 TO LINE-NO.

T678.
	MOVE 1 TO TERM-NO.
	ENTER MACRO VTOPEN.
	ENTER MACRO ERLIN USING TERM-NO,LINE-NO.
	GO TO TEST-SHOULD-NOT-HAVE-PASSED.

T9.
	ENTER MACRO VTOPEN.
	MOVE 1 TO TERM-NO.
	ENTER MACRO WRSCR USING TERM-NO,UNSYN-SCREEN,UNSYN-SCREEN-END.
	GO TO TEST-SHOULD-NOT-HAVE-PASSED.

TEST-SHOULD-NOT-HAVE-PASSED.
	DISPLAY "TEST " TST-NO " PASSED. SHOULD HAVE FAILED!".
	GO TO START.
NORMAL-TEST.
	DISPLAY "NORMAL TEST NUMBER?".
	ACCEPT TST-NO.
	GO TO NT1, NT2, NT3, NT4, NT5, NT6, NT7, NT8,NT9
		DEPENDING ON TST-NO.
	DISPLAY "ILLEGAL TEST NUMBER!".
	GO TO NORMAL-TEST.

NT1.
	DISPLAY "OPEN, WRITE LINE, CLOSE TEST".
	DISPLAY " ENTER NUMBER OF WRITES DESIRED".
	DISPLAY "*".
	ACCEPT ANS.
	PERFORM NT1-X VARYING CTR FROM 1 BY 1 UNTIL CTR > ANS.
	GO TO NORMAL-TEST.

NT1-X.
	DISPLAY "&".
	ENTER MACRO VTOPEN.
	MOVE CTR TO CTR-LIN.
	MOVE 1 TO TERM-NO.
	MOVE 7 TO LINE-NO.
	ENTER MACRO WRLIN USING
		TERM-NO, LINE-NO, LINE-IMAGE, LINE-IMAGE-END.
	ENTER MACRO VTCLSE.
	DISPLAY CTR.
NT2.
	DISPLAY "WRSCR TEST".
	ENTER MACRO VTOPEN.
	DISPLAY " ON EACH '*', ENTER NUMBER OF WRITES DESIRED".

NT2-L.
	DISPLAY "*".
	ACCEPT ANS.
	MOVE ANS TO CTR.
	PERFORM FILL-SCREEN CTR TIMES.
	GO TO NORMAL-TEST.

FILL-SCREEN.
	MOVE 1 TO TERM-NO.
	MOVE ALL "ABCDEFGHIJKLMNOPQRSTUVWXYZ" TO SCREEN.
	ENTER MACRO WRSCR USING TERM-NO, SCREEN, SCREEN-END.
NT3.
	DISPLAY "ERASE SCREEN TEST".
	DISPLAY " ON EACH '*' TYPE '0' TO ERASE SCREEN, '1' TO END TEST.".
	MOVE 1 TO TERM-NO.
	ENTER MACRO VTOPEN.

NT3-L.
	DISPLAY "*".
	ACCEPT ANS.
	IF ANS NOT EQUAL TO 0
		GO TO NORMAL-TEST.
	ENTER MACRO ERSCR USING TERM-NO.
	GO TO NT3-L.

NT4.
	DISPLAY "ERASE LINE TEST".
	DISPLAY "ON EACH '*' ENTER NUMBER OF THE LINE TO BE ERASED".
	DISPLAY " 0 REFILLES SCREEN.".
	ENTER MACRO VTOPEN.

NT4-L.
	DISPLAY "*".
	ACCEPT ANS.
	IF ANS = 0 GO TO NT4-F.
	MOVE ANS TO LINE-NO.
	IF LINE-NO  >20 GO TO NORMAL-TEST.
	MOVE 1 TO TERM-NO.
	ENTER MACRO ERLIN USING TERM-NO, LINE-NO.
	GO TO NT4-L.

NT4-F.
	PERFORM FILL-SCREEN.
	GO TO NT4-L.
NT5.
	DISPLAY "WRLIN TEST".
	DISPLAY " ON EACH '*' ENTER LINE-NO".
	DISPLAY " 0 ERASES SCREEN".
	ENTER MACRO VTOPEN.
	MOVE 1 TO TERM-NO.

NT5-L.
	DISPLAY "*".
	ACCEPT ANS.
	IF ANS = 0 GO TO NT5-E.
	MOVE ANS TO LINE-NO.
	IF LINE-NO  >20 GO TO NORMAL-TEST.
	MOVE ALL "0123456789" TO SCREEN.
	ENTER MACRO WRLIN USING TERM-NO, LINE-NO, SCREEN, SCREEN-END.
	GO TO NT5-L.

NT5-E.
	ENTER MACRO ERSCR USING TERM-NO.
	GO TO NT5-L.
NT6.
	DISPLAY "VTWAIT TEST".
	DISPLAY " TYPES TERM-NO AND SCREEN ON EACH TRANS RECEIVED".
	DISPLAY " THEN ERASES SCREEN".
	DISPLAY "ENTER NUMBER OF TRANSACTIONS ALLOWED".
	DISPLAY "*".
	ACCEPT ANS.
	ENTER MACRO VTOPEN.
	PERFORM VT6-L VARYING CTR FROM 1 BY 1 UNTIL CTR > ANS.
	ENTER MACRO VTCLSE.
	GO TO NORMAL-TEST.

VT6-L.
	ENTER MACRO VTWAIT USING TERM-NO, SCREEN, SCREEN-END.
	DISPLAY SPACE.
	DISPLAY "TERM-NO = " TERM-NO.
	DISPLAY SCREEN.
	ENTER MACRO ERSCR USING TERM-NO.


NT7.
	DISPLAY "MULTIPLE OUTPUT TEST".
	DISPLAY "REPETITIVE OUTPUT TO ALL TERMINALS".
	DISPLAY "NUMBER OF TERMINALS?".
	DISPLAY "*".
	ACCEPT ANS.
	MOVE ANS TO CTR.
	DISPLAY "NUMBER OF TIMES?".
	DISPLAY "*".
	ACCEPT ANS.
	MOVE ALL "0123456" TO SCREEN.
	ENTER MACRO VTOPEN.
	PERFORM NT7-X VARYING LINE-NO FROM 1 BY 1 UNTIL LINE-NO > ANS
		AFTER VARYING TERM-NO FROM 1 BY 1 UNTIL TERM-NO > CTR.
	GO TO NORMAL-TEST.

NT7-X.
	ENTER MACRO WRSCR USING TERM-NO, SCREEN, SCREEN-END.
NT8.
	DISPLAY "TRANSACTION TEST".
	DISPLAY "EACH TERMINAL CAN SEND SCREEN TO ANY OTHER".
	DISPLAY "USING FIRST TWO DIGITS AS A ROUTE".
	DISPLAY "WHAT IS NUMBER OF TERMINALS?".
	DISPLAY "*".
	ACCEPT ANS.
	MOVE ANS TO CTR.
	DISPLAY "NUMBER OF TRANSACTIONS ALLOWED.".
	DISPLAY "*".
	ACCEPT ANS.
	ENTER MACRO VTOPEN.
	MOVE 0 TO CTR1.

NT8-L.
	IF CTR1 > ANS GO TO NORMAL-TEST.
	ENTER MACRO VTWAIT USING TERM-NO, SCREEN, SCREEN-END.
	IF DEST-TERM IS NOT NUMERIC GO TO NT8-E.
	IF DEST-TERM < 1 OR > CTR GO TO NT8-E.
	MOVE TERM-NO TO HOLD-NO.
	MOVE DEST-TERM TO TERM-NO.
	MOVE HOLD-NO TO DEST-TERM.
	ENTER MACRO WRSCR USING TERM-NO, SCREEN, SCREEN-END.
	ADD 1 TO CTR1.
	GO TO NT8-L.

NT8-E.
	MOVE 1 TO LINE-NO.
	ENTER MACRO WRLIN USING
		TERM-NO, LINE-NO, ILL-TERM, ILL-TERM-END.
	GO TO NT8-L.
NT9.
	DISPLAY "TEST PROCEDURE COMPLETED".
	STOP RUN.
