IDENTIFICATION DIVISION.
*	
*	WRITTEN BY STEPHAN OLDGREN, ENEA, JULY 1973
*
*	THIS PROGRAM EDITS THE FILE NNNDEB.TMP. THE EDITING IS
*	CONTROLLED BY A CONTROL HALF WORD IN THE BEGINNING OF
*	EACH RECORD IN THE FILE.
*
*	REVISION HISTORY
*	----------------
*
*
PROGRAM-ID.SUTEDB.
ENVIRONMENT DIVISION.
CONFIGURATION SECTION.
SPECIAL-NAMES.
	CHANNEL (1) IS NEW-PAGE.
INPUT-OUTPUT SECTION.
FILE-CONTROL.
	SELECT DB-FILE ASSIGN TO DSK
	RECORDING MODE IS BINARY.
	SELECT LISTFILE ASSIGN TO DSK.
	SELECT SOURCE-FILE ASSIGN TO DSK.
	SELECT OPTIONAL COMPILER-FILE ASSIGN TO DSK.
DATA DIVISION.
FILE SECTION.
FD	DB-FILE VALUE OF IDENTIFICATION IS FILENAME
	USER-NUMBER IS OCTAL-PPN.
01	DB-RECORD USAGE COMP.
	02 DB-WORD PIC S9(10) OCCURS 128 INDEXED BY I1.
FD	COMPILER-FILE VALUE OF ID COMPNAME USER-NUMBER IS OCTAL-PPN.
01	COMP-RECORD PIC X(128) DISPLAY-7.
FD	SOURCE-FILE VALUE OF ID SOURCE-FILE-NAME USER-NUMBER IS SOURCE-PPN.
01	SOURCE-RECORD PIC X(128) DISPLAY-7.
FD	LISTFILE VALUE OF IDENTIFICATION IS "DBLISTLST".
01	L-RECORD	PIC X(120).

WORKING-STORAGE SECTION.
77	G1		PIC S9(10) USAGE COMP.
77	R1		PIC S9(10) USAGE COMP.
77	R2		PIC S9(10) USAGE COMP.
77	R3		PIC S9(10) USAGE COMP.
77	HALF-NUM	PIC S9(7) USAGE COMP.
77	OCTAL-PPN	PIC S9(10) USAGE COMP VALUE ZERO.
77	SOURCE-PPN 	PIC S9(10) COMP.
77	SID-SWITCH	PIC 9 VALUE 0.
	   88 FIRST-TIME VALUE 0.

01	IN-WORD		PIC S9(10) USAGE COMP.

01	SIX-WORD REDEFINES IN-WORD.
	02 S-1		PIC XXX.
	02 S-2		PIC XXX.

01	IN-NUM		USAGE DISPLAY-7.
	02 IN1		PIC X OCCURS 18 INDEXED BY I16.

01	IN-JOB.
	02 IN-J		PIC X OCCURS 3 INDEXED BY I17.

01	IN-JOB2 REDEFINES IN-JOB.
	02 IN-J2	PIC 999.

01	IN-PJ.
	02 PJ		PIC X OCCURS 6 INDEXED BY I18.

01	IN-PJ2 REDEFINES IN-PJ.
	02 PROJ-NUM	PIC 9(6).

01	IN-PG.
	02 PG		PIC X OCCURS 6 INDEXED BY I19.

01	IN-PG2 REDEFINES IN-PG.
	02 PROG-NUM	PIC 9(6).

01	P-NUM.
	02 PP-NUM	PIC 9(6).
	02 X REDEFINES PP-NUM.
	 03 PP-DIGIT	PIC 9 OCCURS 6 INDEXED BY I14.
01	FILENAME.
	02 JOB-NO	PIC 999.
	02 NAME-TEXT	PIC X(6) VALUE "DEBTMP".
	
01	COMPNAME.
	02  COMP-JOB PIC 999.
	02  FILLER PIC X(6) VALUE 'DEBLST'.

01	SOURCE-FILE-NAME.
	02  FILE-NAME PIC X OCCURS 9 INDEXED BY FILE-IND.

01	SOURCE-NAME-X DISPLAY-7.
	02  SNCHAR PIC X OCCURS 50 INDEXED BY SNIND.

01	ID-TABLE.
	02 ID-RECORD OCCURS 3072 INDEXED BY I3.
	 03 ID1		PIC XXX.
	 03 ID2		PIC XXX.
	 03 ID3		PIC XXX.
	 03 ID4		PIC XXX.

01	TEXT-TABLE.
	02 T1		PIC X(52) VALUE "THIS IS A TEST".
	02 T2		PIC X(52).
	02 T3		PIC X(52).
	02 T4		PIC X(52).
	02 T5		PIC X(52).
	02 T6 		PIC X(52).
	02 T7		PIC X(52).
	02 T8		PIC X(52).
	02 T9		PIC X(52).
	02 T10		PIC X(52).
	02 T11		PIC X(52).
	02 T12		PIC X(52).
	02 T13		PIC X(52).
	02 T14		PIC X(52).
	02 T15		PIC X(52).

01	T-TABLE REDEFINES TEXT-TABLE.
	02 T-AREA OCCURS 15 INDEXED BY I4.
	 03 CH-NO	PIC 99.
	 03 T-LINE.
	  04 T-CH	PIC X OCCURS 50 INDEXED BY I41.

01	SOURCE-RUBRIK DISPLAY-7.
	02  FILLER 	PIC X(8) VALUE "SOURCE: ".
	02  S-NAME	PIC X(9).
	02  FILLER	PIC XX VALUE " [".
	02  PJ-UT	PIC XXX.
	02  FILLER 	PIC X VALUE ",".
	02  PG-UT	PIC XXX.
	02  FILLER	PIC X VALUE "]".

01	EDITLINE.
	02 E-CH		PIC X OCCURS 120 INDEXED BY I5.

01	CONTROL-WORD.
	02 C-DIGIT	PIC 9 OCCURS 6 INDEXED BY I6.

01 	ER-TEXT.
	02 ER-CH	PIC X OCCURS 13 INDEXED BY I7.
01	O-DIGIT.
	02 O1		PIC 9.
	02 O2		PIC 9.
	02 O3		PIC 9.
	02 O4		PIC 9.
	02 O5		PIC 9.
	02 O6		PIC 9.

01	TEXT.
	02 T		PIC X OCCURS 6 INDEXED BY I8.

01	SYMBOL USAGE DISPLAY-7.
	02 S1		PIC X.
	02 S2 		PIC X.
	02 S3		PIC X.
	02 S4		PIC X.
	02 S5 		PIC X.

01	HEADLINE.
	02 H1		PIC X(35)
	VALUE "DEBUG OUTPUT SIMULA-67        PAGE".
	02 H2		PIC 99.
PROCEDURE DIVISION.
MAIN SECTION.
BEGIN.
	OPEN OUTPUT LISTFILE.
	DISPLAY "SOURCE:" WITH NO ADVANCING.
	ACCEPT SOURCE-NAME-X.
	IF SOURCE-NAME-X = SPACE GO TO READ-EXIT1.
	MOVE SPACE TO SOURCE-FILE-NAME.
	MOVE 'S' TO FILE-NAME (7).
	MOVE 'I' TO FILE-NAME (8).
	MOVE 'M' TO FILE-NAME (9).
	PERFORM FILESCAN.
	OPEN INPUT SOURCE-FILE.
	MOVE SOURCE-FILE-NAME TO S-NAME.
	MOVE IN-PJ TO PJ-UT.
	MOVE IN-PG TO PG-UT.
	WRITE L-RECORD FROM SOURCE-RUBRIK AFTER NEW-PAGE.
	MOVE SPACE TO L-RECORD WRITE L-RECORD AFTER 1.
READ1.
	READ SOURCE-FILE AT END CLOSE SOURCE-FILE GO TO READ-EXIT1.
	WRITE L-RECORD FROM SOURCE-RECORD AFTER 1.
	GO TO READ1.
READ-EXIT1.
	MOVE  SPACE TO EDITLINE.
	MOVE ZERO TO CONTROL-WORD.
	DISPLAY "JOB NO ? " WITH NO ADVANCING.
	SET I5,I6,I14,I16,I17,I18,I19 TO 1.
	ACCEPT IN-NUM.
	PERFORM BREAKUP THRU EX-B.
	MOVE JOB-NO TO COMP-JOB.
	OPEN INPUT COMPILER-FILE.
READ2.
	READ COMPILER-FILE AT END CLOSE COMPILER-FILE GO TO READ-EXIT2.
	IF FIRST-TIME	MOVE SPACE TO L-RECORD
			WRITE L-RECORD AFTER NEW-PAGE
			MOVE 1 TO SID-SWITCH.
	WRITE L-RECORD FROM COMP-RECORD AFTER 1.
	GO TO READ2.
READ-EXIT2.
	OPEN INPUT DB-FILE.
	MOVE 0 TO H2.
	MOVE 50 TO R2.
	GO TO READ-FILE.
BREAKUP.
*	THE PARAGRAPHS BREAKUP THRU EX-B CONVERT THE USERS 
*	SPECIFICATIONS OF JOB NUMBER AND PROJ.PROG.NUMBER
*	TO DECIMAL FORM AND INITIALIZE THE LOGICAL FILE
*	NAME AND PROJ.PROG.NUMBER.
	MOVE IN1 (I16) TO IN-J (I17).
	SET I16,I17 UP BY 1.
	MOVE IN1 (I16) TO IN-J (I17).
	SET I16,I17 UP BY 1.
	MOVE IN1 (I16) TO IN-J (I17).
	MOVE IN-J2 TO JOB-NO.
	SET I16 UP BY 1.
	IF IN1 (I16) NOT = "[" GO TO EX-B.
	SET I16 UP BY 1.
B-PROJ.
	IF IN1 (I16) = "," SET I16 UP BY 1 GO TO B-PROG.
	MOVE IN1 (I16) TO PJ (I18).
	SET I16,I18 UP BY 1.
	GO TO B-PROJ.
B-PROG.
	IF IN1 (I16) = "]" GO TO OCT-C.
	MOVE IN1 (I16) TO PG (I19).
	SET I16,I19 UP BY 1.
	GO TO B-PROG.
OCT-C.
	MOVE PROJ-NUM TO PP-NUM.
	MOVE 0 TO HALF-NUM.
	PERFORM CONVERT VARYING I14 FROM 1 BY 1 UNTIL I14 > 6.
	COMPUTE OCTAL-PPN = HALF-NUM * 262144.
	MOVE PROG-NUM TO PP-NUM.
	MOVE 0 TO HALF-NUM.
	PERFORM CONVERT VARYING I14 FROM 1 BY 1 UNTIL I14 > 6.
	COMPUTE OCTAL-PPN = OCTAL-PPN + HALF-NUM.
OCTC-EXIT.
	GO TO EX-B.
CONVERT.
	COMPUTE HALF-NUM = 8 * HALF-NUM + PP-DIGIT (I14).
EX-B.
	EXIT.
READ-FILE.
	READ DB-FILE AT END CLOSE DB-FILE,LISTFILE STOP RUN.
	SET I1 TO 1.
	MOVE 4 TO R3.
EDIT-START.
	PERFORM MOVE-CONTROL THRU EXIT-CH UNTIL I1 > 128.
	GO TO READ-FILE.
MOVE-CONTROL.
*	MOVE FIRST HALF WORD TO CONTROL-WORD.
	IF R3 = 4 PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	DIVIDE 8 INTO G1 REMAINDER C-DIGIT (6).
	DIVIDE 8 INTO G1 REMAINDER C-DIGIT (5).
	DIVIDE 8 INTO G1 REMAINDER C-DIGIT (4).
	DIVIDE 8 INTO G1 REMAINDER C-DIGIT (3).
	DIVIDE 8 INTO G1 GIVING C-DIGIT (1) REMAINDER C-DIGIT (2).
	MOVE 0 TO HALF-NUM.
	PERFORM CHECK-LINE VARYING I6 FROM 1 BY 1 UNTIL I6 > 6.
	IF I5 > 114 - HALF-NUM PERFORM NEXT-LINE.
	SET I6 TO 1.
	PERFORM CHECK-C THRU EXIT-C UNTIL I6 > 6
	OR I1 > 128.
	PERFORM EDIT-CHECK THRU EXIT-ED.
EXIT-CH.
	EXIT.
CHECK-C.
*	CHECK FIELDS IN CONTROL-WORD.
	IF C-DIGIT (I6) = 0 GO TO CHECK-O.
	IF C-DIGIT (I6) = 1 GO TO OCT-MOVE.
	IF C-DIGIT (I6) = 2 GO TO DEC-MOVE.
	IF C-DIGIT (I6) = 3 GO TO SYM-MOVE.
	IF C-DIGIT (I6) = 4 GO TO SIX-MOVE2.
	IF C-DIGIT (I6) = 5 GO TO TEX-MOVE.
	IF C-DIGIT (I6) = 6 GO TO SIX-MOVE.
	GO TO ER-MOVE.
EXIT-C.
	EXIT.
CHECK-O.
*	END OF RECORD ?
	IF I6 = 1 GO TO CONTROL-ACTION.
	SET I6 TO 7 GO TO EXIT-C.

CHECK-LINE.
	IF C-DIGIT (I6) = 1 ADD 7 TO HALF-NUM.
	IF C-DIGIT (I6) = 2 ADD 7 TO HALF-NUM.
	IF C-DIGIT (I6) = 3 ADD 13 TO HALF-NUM.
	IF C-DIGIT (I6) = 4 ADD 7 TO HALF-NUM.
	IF C-DIGIT (I6) = 5 ADD 10 TO HALF-NUM.
	IF C-DIGIT (I6) = 6 ADD 4 TO HALF-NUM.
CONTROL-ACTION.
*	THIS PROCEDURE TAKES CARE OF CONTROL HALF WORDS TYPE 1.
	SET I6 TO 7.
	IF C-DIGIT (2) = 1
	WRITE L-RECORD FROM EDITLINE BEFORE NEW-PAGE
	MOVE SPACE TO EDITLINE
	SET I5 TO 1
	ADD 1 TO H2
	WRITE L-RECORD FROM HEADLINE BEFORE 3
	GO TO EXIT-C.
	IF C-DIGIT (2) = 2 PERFORM NEXT-LINE
	GO TO EXIT-C.
	IF C-DIGIT (2) = 3 GO TO READ-IN.
	IF C-DIGIT (2) = 0 PERFORM NEXT-LINE
	CLOSE DB-FILE,LISTFILE STOP RUN.
	DISPLAY "ILL CONTROL WORD".
	SET I6 UP BY 2.
	GO TO EXIT-C.
READ-IN.
*	THIS PROCEDURE DEFINES A NEW IDENTIFIER WHICH BEGINS IN THE
*	LEFT HALF OF AN INPUT WORD.
	IF R3 = 4 GO TO READ-IN2.
	SUBTRACT 1023 FROM R1.
	SET I3 TO R1.
	MOVE DB-WORD (I1) TO IN-WORD.
	SET I1 UP BY 1.
	MOVE S-1 TO ID1 (I3).
	MOVE S-2 TO ID2 (I3).
	IF I1 > 128 PERFORM READ-FILE.
	MOVE DB-WORD (I1) TO IN-WORD SET I1 UP BY 1.
	MOVE S-1 TO ID3 (I3).
	MOVE S-2 TO ID4 (I3).
	MOVE 4 TO R3.
	GO TO EXIT-C.
READ-IN2.
*	THIS PROCEDURE DEFINES A NEW IDENTIFIER WHICH BEGINS IN THE
*	RIGHT HALF OF AN INPUT WORD.
	PERFORM WORD-IN.
	SUBTRACT 1023 FROM G1.
	SET I3 TO G1.
	SET I1 DOWN BY 1.
	MOVE DB-WORD (I1) TO IN-WORD SET I1 UP BY 1.
	MOVE S-2 TO ID1 (I3).
	IF I1 >128 PERFORM READ-FILE.
	MOVE DB-WORD (I1) TO IN-WORD SET I1 UP BY 1.
	MOVE S-1 TO ID2 (I3).
	MOVE S-2 TO ID3 (I3).
	IF I1 > 128 PERFORM READ-FILE.
	MOVE DB-WORD (I1) TO IN-WORD.
	MOVE S-1 TO ID4 (I3).
	PERFORM WORD-IN.
	GO TO EXIT-C.
OCT-MOVE.
*	THIS PROCEDURE CONVERT A DECIMAL NUMBER TO AN OCTAL NUMBER.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE
	PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	DIVIDE 8 INTO G1 REMAINDER O6.
	DIVIDE 8 INTO G1 REMAINDER O5.
	DIVIDE 8 INTO G1 REMAINDER O4.
	DIVIDE 8 INTO G1 REMAINDER O3.
	DIVIDE 8 INTO G1 GIVING O1 REMAINDER O2.
MOVE-OCT.
	MOVE O1 TO E-CH (I5) SET I5 UP BY 1.
	MOVE O2 TO E-CH (I5) SET I5 UP BY 1.
	MOVE O3 TO E-CH (I5) SET I5 UP BY 1.
	MOVE O4 TO E-CH (I5) SET I5 UP BY 1.
	MOVE O5 TO E-CH (I5) SET I5 UP BY 1.
	MOVE O6 TO E-CH (I5) SET I5 UP BY 1.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
DEC-MOVE.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	MOVE G1 TO O-DIGIT.
	GO TO MOVE-OCT.
SYM-MOVE.
*	THIS PROCEDURE TRANSLATE A HALF WORD TO AN ASCII SYMBOL.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	IF G1 > 1023 AND G1 < 4096 GO TO ID-MOVE.
	ENTER MACRO DBSYMB USING G1,SYMBOL.
	IF I5 > 108 PERFORM NEXT-LINE.
	MOVE "=" TO E-CH (I5) SET I5 UP BY 1.
	MOVE S1 TO E-CH (I5) SET I5 UP BY 1.
	MOVE S2 TO E-CH (I5) SET I5 UP BY 1.
	MOVE S3 TO E-CH (I5) SET I5 UP BY 1.
	MOVE S4 TO E-CH (I5) SET I5 UP BY 1.
	MOVE S5 TO E-CH (I5) SET I5 UP BY 1.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
ID-MOVE.
*	THIS PROCEDURE WRITES AN IDENTIFIER FROM A TABLE.
	SUBTRACT 1023 FROM G1.
	SET I3 TO G1.
	IF I5 > 101 PERFORM NEXT-LINE.
	MOVE ID1 (I3) TO S-1.
	MOVE ID2 (I3) TO S-2.
	MOVE SIX-WORD TO TEXT.
	PERFORM TEXT-MOVE VARYING I8 FROM 1 BY 1 UNTIL I8 > 6.
	MOVE ID3 (I3) TO S-1.
	MOVE ID4 (I3) TO S-2.
	MOVE SIX-WORD TO TEXT.
	PERFORM TEXT-MOVE VARYING I8 FROM 1 BY 1 UNTIL I8 > 6.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
TEXT-MOVE.
	MOVE T (I8) TO E-CH (I5).
	SET I5 UP BY 1.
TEX-MOVE.
*	THIS PROCEDURE WRITES A TEXT CONSTANT FROM A TABLE.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	ADD 1 TO G1.
	SET I4 TO G1.
	IF I5 > (114 - CH-NO (I4)) PERFORM NEXT-LINE.
	PERFORM T-MOVE VARYING I41 FROM 1 BY 1
	UNTIL I41 > CH-NO (I4) + 1.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
T-MOVE.
	MOVE T-CH (I4,I41) TO E-CH (I5).
	SET I5 UP BY 1.
SIX-MOVE.
*	THIS PROCEDURE WRITES THREE SIXBIT CHARACTERS FROM ONE
*	INPUT HALF WORD.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	MOVE G1 TO IN-WORD.
	MOVE SIX-WORD TO TEXT.
	IF I5 > 111 PERFORM NEXT-LINE.
	PERFORM TEXT-MOVE VARYING I8 FROM 4 BY 1 UNTIL I8 > 6.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
ER-MOVE.
*	THIS PROCEDURE WRITES AN ERROR MESSAGE.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	MOVE "UNIMPLEMENTED" TO ER-TEXT.
	IF I5 > 101 PERFORM NEXT-LINE.
	PERFORM E-MOVE VARYING I7 FROM 1 BY 1 UNTIL I7 = 14.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
E-MOVE.
	MOVE ER-CH (I7) TO E-CH (I5).
	SET I5 UP BY 1.
SIX-MOVE2.
*	THIS PROCEDURE WRITES SIX SIXBIT CHARACTERS FROM ONE
*	INPUT WORD.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	MOVE G1 TO IN-WORD.
	MOVE SIX-WORD TO TEXT.
	IF I5 > 108 PERFORM NEXT-LINE.
	PERFORM TEXT-MOVE VARYING I8 FROM 4 BY 1 UNTIL I8 = 7.
	IF R3 = 4 IF I1 > 128 PERFORM READ-FILE PERFORM WORD-IN
	ELSE PERFORM WORD-IN
	ELSE MOVE R1 TO G1 MOVE 4 TO R3.
	MOVE G1 TO IN-WORD.
	MOVE SIX-WORD TO TEXT.
	PERFORM TEXT-MOVE VARYING I8 FROM 4 BY 1 UNTIL I8 = 7.
	SET I5,I6 UP BY 1.
	GO TO EXIT-C.
WORD-IN.
*	THIS PROCEDURE INITILIAZE A NEW INPUT WORD.
	IF I1 > 128 PERFORM READ-FILE.
	MOVE DB-WORD (I1) TO IN-WORD.
	MOVE SPACE TO S-1.
	MOVE IN-WORD TO R1.
	MOVE DB-WORD (I1) TO IN-WORD.
	MOVE S-1 TO S-2.
	MOVE SPACE TO S-1.
	MOVE IN-WORD TO G1.
	SET I1 UP BY 1.
	IF I1 > 128 PERFORM READ-FILE.
	MOVE 1 TO R3.
NEXT-LINE.
	IF R2 > 49 ADD 1 TO H2
	WRITE L-RECORD FROM HEADLINE AFTER NEW-PAGE
	MOVE SPACE TO L-RECORD
	WRITE L-RECORD BEFORE 2
	MOVE 0 TO R2.
	WRITE L-RECORD FROM EDITLINE.
	MOVE SPACE TO EDITLINE.
	SET I5 TO 1.
	ADD 1 TO R2.
EDIT-CHECK.
	IF I5 = 1 GO TO EXIT-ED.
	IF I5 < 21 SET I5 TO 20 GO TO EXIT-ED.
	IF I5 < 41 SET I5 TO 40 GO TO EXIT-ED.
	IF I5 < 61 SET I5 TO 60 GO TO EXIT-ED.
	IF I5 < 81 SET I5 TO 80 GO TO EXIT-ED.
	IF I5 < 101 SET I5 TO 100.
EXIT-ED.
	EXIT.


FILESCAN SECTION.
BEGIN.
	SET FILE-IND, SNIND TO 1.
	MOVE 0 TO SOURCE-PPN.
LOOP1.
	IF SNCHAR (SNIND) = SPACE GO TO FILESCAN-EXIT.
	IF SNCHAR (SNIND) = "." GO TO FILE-EXT.
	IF SNCHAR (SNIND) = "[" GO TO FILE-PPN.
	IF FILE-IND < 7 MOVE SNCHAR (SNIND) TO FILE-NAME (FILE-IND).
	SET FILE-IND SNIND UP BY 1.
	GO TO LOOP1.
FILE-EXT.
	SET FILE-IND TO 7.
	SET SNIND UP BY 1.
LOOP2.
	IF SNCHAR (SNIND) = SPACE GO TO FILESCAN-EXIT.
	IF SNCHAR (SNIND) = "[" GO TO FILE-PPN.
	IF FILE-IND < 10 MOVE SNCHAR (SNIND) TO FILE-NAME (FILE-IND).
	SET FILE-IND SNIND UP BY 1.
	GO TO LOOP2.
FILE-PPN.
	SET SNIND UP BY 1.
	SET I18 I19 TO 1.
FILE-PROJ.
	IF SNCHAR (SNIND) = "," SET SNIND UP BY 1 GO TO FILE-PROG.
	IF SNCHAR (SNIND) = SPACE GO TO FILE-PPN-EXIT.
	IF I18 < 7 MOVE SNCHAR (SNIND) TO PJ (I18).
	SET SNIND I18 UP BY 1.
	GO TO FILE-PROJ.
FILE-PROG.
	IF SNCHAR (SNIND) = "]" OR SPACE GO TO FILE-PPN-EXIT.
	IF I19 < 7 MOVE SNCHAR (SNIND) TO PG (I19).
	SET SNIND I19 UP BY 1.
	GO TO FILE-PROG.
FILE-PPN-EXIT.
	PERFORM OCT-C
	MOVE OCTAL-PPN TO SOURCE-PPN.
	MOVE 0 TO OCTAL-PPN.
FILESCAN-EXIT.
	EXIT.
