00100	.;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  00200	.;;;;  Build SIMULA system      ;;;
  00300	.;;;;  Lars Enderin 19-Jan-1977 ;;;
  00400	.;;;;  (modif. Nov-1977)        ;;;
  00500	.;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
  00600	.;;; This CTL file, primarily written for TOPS-10, shows how to
    00700	.;;; build a SIMULA system from files supplied on the SIMULA
  00800	.;;; distribution tape. You will have to make changes and adaptions
00900	.;;; of this file to make it work, but it should show you how
 01000	.;;; to proceed.
 01100	.;;;;;;;;;;;;;;;;;;;;;;;;;;
01200	.;;;			;;;
  01300	.;;;	UNV files  	;;;
  01400	.;;;			;;;
  01500	.;;;;;;;;;;;;;;;;;;;;;;;;;;
01600	.;
01700	.;
01800	.COMPILE/MACRO/CREF SIMPRM+SIMMAC,SIMMC1,SIMMC2,SIMMC3,SIMMCR,SIMRPA,MACSIM
  01900	.;; SIMP20 should prefix SIMMAC for TOPS-20 version.
02000	.CREF
  02100	.PRINT *.LPT/NOHEAD
   02200	.;; You  should  now  have  the  relevant .UNV files.  Note that only
   02300	.;; SIMMAC.UNV is  different  for  TOPS-10,  TOPS-20,  DEBUG  or  SYS
   02400	.;; versions. UUOSYM.UNV is needed also in TOPS-20.
 02500	.;;
    02600	.;;
    02700	.;;;;;;;;;;;;;;;;;;;;;;
    02800	.;;; COMPILER FILES ;;;
    02900	.;;;;;;;;;;;;;;;;;;;;;;
    03000	.;
03100	.;
03200	.COMPILE/MACRO/CREF DM,LOWSEG	;Used in all passes
   03300	.;.COMPILE/MACRO/CREF V1B	;Only for TOPS-20
    03400	.;.COMPILE/MACRO/CREF TRACE	;Trace version only
03500	.CREF
  03600	.PRINT *.LPT/NOHEAD
   03700	.;
03800	.;;; PASS 1 ;;;
  03900	.;
04000	.R MACRO
    04100	*D1,D1/P/C=D1.MAC
04200	*P1DUMP,P1DUMP/P/C=P1DUMP  ;For debug only
04300	*SR,SR/P/C=SR	;Note that this takes a lot of time (ca 3 min KL-20B)
04400	.R CREF
04500	*D1
    04600	*P1DUMP
04700	*SR
    04800	.COMPILE/MACRO/CREF I1,DP,LC,LS,O1,SD,SH,SM,SP,SYS1,T1,DM
04900	.;.COMPILE/MACRO/CREF TRACEI	;Trace version only
    05000	.CREF
  05100	.PRINT *.LPT/NOHEAD
   05200	.;
05300	.;
05400	.;;;; PASS 2 ;;;;
05500	.;
05600	.;
05700	.COMPILE/MACRO/CREF I2,CA,CARL,CGCW,CGIW,CGOB,CGPA,CGRK,CGSA
  05800	.;.COMPILE/MACRO/CREF CADB,DBDT	;Only debug version
 05900	.COMPILE/MACRO/CREF EX,M2,O2,O2RK,O2SA,OD,OR,OREA,ORRK
   06000	.CREF
  06100	.PRINT/NOHEAD *.LPT
   06200	.;
06300	.;
06400	.;;;; PASS 3 ;;;;
06500	.;
06600	.;
06700	.COMPILE/MACRO/CREF I3,E3,M3,O3,SIMXRF,T3
 06800	.;.COMPILE/MACRO/CREF TRACEB	;Trace version only
    06900	.;; TRACEB only in trace version
07000	.CREF
  07100	.PRINT/NOHEAD *.LPT
   07200	.;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   07300	.;;; LOADING THE COMPILER ;;;
   07400	.;;;;;;;;;;;;;;;;;;;;;;;;;;;;
   07500	.;
07600	.;; Can be used to load one-segment version
    07700	.;; as it stands
 07800	.;
07900	.R LINK
08000	*SIMULA.MAP/MAP	;For one-segment compiler only
 08100	*;Pass 1
    08200	*;*SIMP1.MAP/MAP
 08300	*/RUNAME:SIMULA	;In any case
    08400	*/SYMSEG:NONE	;HIGH for debug
   08500	*I1,DM	;I1  M U S T  be loaded first!!!
   08600	*D1,DP,LC,LS,O1,SD,SH,SM,SP,SR,SYS1,T1
    08700	*REL:HELPER.REL	;Possibly on SYS:
    08800	*;*P1DUMP		;Debug only
08900	*;LOWSEG		;In each pass once only, last before any TRACE
 09000	*;*TRACE,TRACEI		;Trace only
    09100	.;
     09200	.;Pass 2
    09300	.;
09400	*;*/RUNAME:SIMP2,SIMP2.MAP/MAP/SYMSEG:NONE ;(or HIGH)
    09500	*I2,CA,CARL,CGCW,CGIW,CGOB,CGPA,CGRK,CGSA	;I2 first!!
    09600	*;*CADB,DBDT	;Only debug version
09700	*EX,M2,O2,O2RK,O2SA,OD,OREA,ORRK
09800	*;*DM,LOWSEG
09900	*;*TRACE
    10000	.;Pass 3
    10100	*;*/RUNAME:SIMP3,SIMP3.MAP/MAP/SYMSEG:NONE ;(or HIGH)
    10200	.;
10300	*I3,E3,M3,O3,SIMXRF,T3	;I3 first!!
   10400	*;*DM
  10500	*V1B,HIEND	;TOPS-20 only
   10600	*LOWSEG
10700	*;*TRACE,TRACEB
  10800	*/G
    10900	.SSAVE
 11000	.;;
    11100	.;;
    11200	.;;;;;;;;;;;;;;;;;;;;;;;;;;;
    11300	.;;;			;;;
  11400	.;;;   RUNTIME           ;;;
    11500	.;;;			;;;
  11600	.;;;;;;;;;;;;;;;;;;;;;;;;;;;
    11700	.;
11800	.;;; HIGH SEGMENT(S)	     ;;;
   11900	.;   usually two with TOPS-10  ;
12000	.;
12100	.R MACRO	;Only for TOPS-10 twoseg version
 12200	*SIMRT1,SIMRT1/C=SIMRT1.PRE,SIMRTS.MAC
    12300	*SIMRT2,SIMRT2/C=SIMRT2.PRE,SIMRTS.MAC
    12400	.R CREF
12500	*SIMRT1
12600	*SIMRT2
12700	.COMPILE/MACRO/CREF CSSADM	;Only twoseg version
12800	.CREF
  12900	.PRINT/NOHEAD *.LPT
   13000	.COMPILE/MACRO/CREF SIMR40	;Single seg version
 13100	.CREF
  13200	.PRINT/NOHEAD *.LPT
   13300	.COMPILE/MACRO/CREF CP,CS,IO,IOED,IONF,OCEP,OCIN,OCIO,PH,SA
   13400	.COMPILE/MACRO/CREF TX,TXBL
13500	.CREF
  13600	.PRINT/NOHEAD *.LPT
   13700	.R LINK
13800	*/SYMSEG:NONE	;or HIGH for debug
13900	*SIMRTS.MAP/MAP/RUNAME:SIMRTS	;Single high segment only
  14000	*;*SIMR41.MAP/MAP/RUNAME:SIMR41	;TOPS-10 normal version, segm 1
    14100	*;*SIMRT1	;Segm 1 only
14200	*CP,CS,IO,IOED,PH,TX,OCEP
  14300	*OCIO,SA,TXBL	;In both high segments
 14400	*;*SIMR42.MAP/MAP/RUNAME:SIMR42	;TOPS-10 normal version, segm 2
    14500	*;SIMRT2,CSSADM	;Segm 2 only
    14600	*IONF,OCIN,REL:HELPER	;or SYS:HELPER
 14700	*;*OCIO,SA,TXBL
  14800	*;V1B		;TOPS-20 only
  14900	*/G
    15000	.SAVE	;NSAVE, SSAVE, NSSAVE
15100	.;;
    15200	.;;
    15300	.;;;  SIMLIB   ;;;
    15400	.;;
    15500	.COMPILE/MACRO/CREF MA,MAT,OCSP,PHFO,RD,SANE,SS,SU
  15600	.CREF
  15700	.PRINT/NOHEAD *.LPT
   15800	.COMPILE/MACRO/CREF OCSP0=OCSP0.PRE+OCSP.MAC	;TOPS-10 one-seg version only
   15900	.R FUDGE2	;or MAKLIB
  16000	*SIMLIB=OCSP(A)^[
16100	*;*SIMLIB=OCSP0(A)^[	;TOPS-10 one-seg version
  16200	*SIMLIB=SIMLIB,PHPT,MA,MAT,SU,SS,SANE,PHFO(A)^[
16300	*SIMLIB=SIMLIB,SYS:FORLIB<ACOS.,ASIN.,SQRT.,SINH.,COSH.,TANH.,
16400	*.EXP1,.EXP2,EXP.,.ALOG,.SIN,DEXP.2,DEXP.3,DEXP.,DLOG.,DSQRT.,
16500	*DATAN.,FORXIT,EXIDOT>(A)^[
16600	*SIMLIB/X=SIMLIB^[
    16700	*SIMLIB=SIMLIB(L)^[
   16800	*SIMLIB.L=SIMLIB(S)^[
 16900	.PROTECT <155>SIMLIB.REL
   17000	.TYPE SIMLIB.LST,SIMLIB.L
  17100	.DELETE SIMLIB.L,SIMLIB.LST
17200	.;;
    17300	.;; Obviously, the distributed SIMLIB can be used as basis
    17400	.;;
    17500	.;;
    17600	.;;;;;;;;;;;;;;;;;;;
  17700	.;;; SIMDDT	 ;;;
 17800	.;;;;;;;;;;;;;;;;;;;
  17900	.;
18000	.;
18100	.; SIMULA debug system (SIMDDT) compilation
    18200	.; and creation of a new SIMDDT.ABS using SUTABS
    18300	.; SIMEDS is created by SUTEDS from the handbook messages
18400	.; SIMMAC.UNV,SIMMCR.UNV and SIMRPA.UNV must be available
18500	.; Also SUTABS.REL or .MAC
 18600	.R MACRO
    18700	*SIMDDT,SIMDDT/P/C=SIMDS1.MAC,SIMDS2.MAC,SIMDS3.MAC,SIMDS8.MAC,SIMEDS.MAC,SIMDS9.MAC,SIMDS7.MAC
  18800	.R CREF
18900	*SIMDDT
19000	.PRINT/NOHEAD *.LPT
   19100	.EXEC SIMDDT.REL,SUTABS.REL
19200	.;;;
   19300	.;;;
   19400	.;;; GLOB files have been omitted in this CTL file ;;;
   19500	.;;; Use other command strings as basis for GLOB commands.
    19600	.;;;
   19700	.;;; Copy to SYS:, DOC:, HLP: the relevant files.
   19800	.;;;
   19900	.;;; You may need to save old files on OLD.
    20000	.;;; Make sure the files get at most execute protection
  20100	.;;; for the users.
   20200	.;;; See SIMIMP.MAN for files to copy ;;;;
