


This manual describes the SAFEIO system for  programming  of
safe  dialogues in a SIMULA program.  SAFEIO is an interface
between the  user  and  a  SIMULA  program.   This  document
reflects version 4.0 of the SAFEIO system.
                                                      Page 2
Declaration examples


1.  DECLARATION EXAMPLES


There is another CLASS SAFEI which is a reduced  version  of
SAFEIO.   It  has  only  one formal parameter - the language
parameter.  CLASS SAFEI performs  the  operations  of  CLASS
SAFEIO  minus  the  file  handling  facilities.   Thus it is
possible  to  use  SAFEIO  during  program  development  and
testing and then recompile with SAFEI.

A further reduced version is SAFMIN, see SAFMIN.HLP.

Thera are  also  three  classes  SIMMIN,  SIMEI  and  SIMEIO
identical  to  SAFMIN,  SAFEI and SAFEIO respectively in all
respects but prefixed by SIMULATION.

The SAFEIO CLASS has two formal parameters :


     1.  File specification for log file saving all accepted
         input  from the start of execution - TEXT by VALUE.
         If actual value is NOTEXT,  no  log  file  will  be
         generated from start.

     2.  Message file parameter (language parm.) -  TEXT  by
         VALUE.   IF  the  value  is NOTEXT ("") the message
         file SAFEIO.ENG will be  used.   If  no  such  file
         exists  on  the user's disk area, the SYS:  version
         is used.   Otherwise  the  following  procedure  is
         followed:

         	A.  If parm.  contains no dot ('.'), add "SAFEIO."
         	    - possibly after device colon (':').
         	B.  Search file on specified area.
         	C.  If found, use it.  Else
         	D.  Try to find it on the SYS:  area.
         	E.  If found there, use it.  Else
         	F.  Print message and use SYS:SAFEIO.ENG.

         In order to create  an  own  message  file  (almost
         every  message  produced  by SAFEI(O) is taken from
         the message file) it is recommended to start from a
         copy  of SYS:SAFEIO.ENG (or SYS:SAFEIO.SWE).  Class
         SAFEI uses  the  same  message  file(s)  as  SAFEIO
         (though only partly).



Example 1 - prefixing with SAFEIO.

BEGIN
        EXTERNAL REF (Infile) PROCEDURE findinfile;
        EXTERNAL REF (Outfile) PROCEDURE findoutfile;
        EXTERNAL TEXT PROCEDURE conc,upcase,
                                                      Page 3
Declaration examples


                frontstrip,rest,checkextension;
        EXTERNAL CHARACTER PROCEDURE fetchar,findtrigger;
        EXTERNAL LONG REAL PROCEDURE scanreal;
        EXTERNAL INTEGER PROCEDURE checkreal,checkint,
                scanint,ilog;
        EXTERNAL BOOLEAN PROCEDURE menu;
        EXTERNAL CLASS safeio;
        SAFEIO("input.log","ENG") BEGIN

        .....using safeio procedures....

        END of prefixed block;

        ....calculations not requiring safeio....

END of program


Example 2 - prefixing with SAFEI.
BEGIN
        EXTERNAL declarations ...;
        EXTERNAL CLASS safei;
        SAFEI("SAFEIO.ENG[123,456]") BEGIN

        ..... using safei procedures ....

        END of prefixed block;

        ....calculations not requiring safei....

END of program


Example 3 - Inspecting SAFEIO.

BEGIN
        EXTERNAL declarations ...;

        ....
        INSPECT NEW safeio(NOTEXT,NOTEXT) DO
        BEGIN
                ....using safeio....
                ! Closing possible open files:   ;
                closefiles;
        END inspection;

        ....

END of program


Example 4 - creating your own subclass to SAFEIO.

safeio CLASS myclass;
                                                      Page 4
Declaration examples


BEGIN   ....   END of myclass;

Create your main program:

BEGIN

        EXTERNAL declarations ...;

        myclass("log","MYMESS.TXT") BEGIN
        ! The log file "log.saf" will be opened.;
        ! The message file MYMESS.TXT[123,456] will be
used.;

                ....

        END prefixed block

END of program
                                                      Page 5
3. SAFEIO REQUEST AND INPUTCHECKING PROCEDURES


2.  SAFEIO REQUEST AND INPUTCHECKING PROCEDURES


2.1 REQUEST PROCEDURE



The main procedure when programming with SAFEIO is REQUEST :

request
(promptingquestion,defaultvalue,inputok,errormessage,help);

The parameters are :


     1.  Promptingquestion - TEXT by VALUE -    The
         prompting  question  preferably  ending  with  some
         prompting character as  ':'.   This  text  will  be
         printed  on  the user's terminal followed by a call
         to Breakoutimage.

     2.  Defaultvalue - TEXT by NAME -  The   value    which
         should  be  accepted  if the user answers with just
         Carriage  Return  (i.e.   an  empty  answer).   The
         default  value will be presented to the user in the
         following manner :

         Enter input:/55/:

         assuming the  the  prompting  question  was  "Enter
         input:" and the default value was "55".  The '/' is
         the  value  of   a   SAFEIO   attribute   character
         DEFAULTQUOTE  and may be changed by the programmer.
         Likewise the final ':'  is  the  initial  value  of
         character  attibute  PROMPTINGCHAR.   If no default
         answer  should  be  allowed  the  SAFEIO  attribute
         NODEFAULT   may   be   used   (in  which  case  the
         defaultquotes and the  promptingchar  will  not  be
         displayed).

     3.  Inputok - BOOLEAN by NAME -    This parameter shall
         be  true if the input is to be accepted else false.
         Usually the actual parameter consists of a call  to
         a  syntax  and  validity  checking  procedure  (see
         Inputchecking Procedures).

     4.  Errormessage - TEXT by NAME -  The  text  will   be
         printed  on  the  user's  terminal  if  inputok  is
         evaluated to be false  and  the  SYNTAXOK  flag  (a
         SAFEIO boolean attribute) is true.
                                                      Page 6
3. SAFEIO REQUEST AND INPUTCHECKING PROCEDURES


     5.  Help - BOOLEAN by NAME -       This parameter  will
         be  evaluated each time the user types in an answer
         starting with a questionmark '?'.

                                                      Page 7
3. SAFEIO REQUEST AND INPUTCHECKING PROCEDURES


2.2 INPUTCHECKING PROCEDURES


The syntax and validity checking procedures are :

     1.  Intinput

     2.  Realinput

     3.  Longrealinput

     4.  Textinput

     5.  Boolinput

The general structure of  a  syntax  and  validity  checking
procedure is :

BOOLEAN PROCEDURE ***input(result,validity);
NAME result,validity;   *** result;   BOOLEAN validity;
BEGIN
        COMMENT The input line is stored in
currentfile.Image;

        IF ...syntax is OK... THEN
        BEGIN
                COMMENT Get value from currentfile.Image: ;
                result:= ...;
                syntaxok:= TRUE;
                COMMENT syntaxok is a global SAFEIO
attribute. ;
                COMMENT Since the parameter transmission
mode
                is by NAME the actual validity parameter may
be
                (and often is) an expression containing the
                result variable. ;
                check:= IF checkvalidity THEN validity
                        ELSE TRUE
        END ELSE
        BEGIN   Outtext( for example: ? Illegal *** input:
);
                Outtext( the rest of the stripped
                        currentfile.Image );
                Outimage;
                syntaxok:= FALSE
        END error

END of check;

The type of result (***) depends  on  the  procedure  in  an
obvious manner.

The programmer may  use  the  procedure  skeleton  presented
                                                      Page 8
3. SAFEIO REQUEST AND INPUTCHECKING PROCEDURES


above in order to design his own checking procedures.

The predefined SAFEIO  procedures  will  only  accept  input
lines  containing a legal item of the corresponding type and
nothing else.

If, however the programmer codes CHECKVALIDITY:= FALSE  then
no  validity  checking will be done.  Though saving (may be)
lots of execution time this should be used with care,  since
the security enabled through validity checking will be lost!

The textinput procedure will accept any  character  sequence
as a syntactically correct input.

The boolinput procedure, however, has  just  one  parameter;
result.   There  is no use putting the prompting question if
just one of the yes/no (true/false) alternatives is valid!

The intinput, realinput and  longrealinput  procedures  will
reject  not only items not conforming to the correct syntax,
but also such numeric input that otherwise would have caused
a run time arithmetic overflow error.

For convenient simple command validity checking  the  LIBSIM
boolean  procedure  MENU may be used as the actual parameter
to  an  ***input  procedure.   (For  texts   with   national
characters - }{` $#@ - use procedure MENY instead.)

The  MENU  procedure  will  return  the  value  TRUE  if   a
nonambiguous match is found (though an exact match is always
accepted - even if  it  is  a  substring  of  another  table
element).  The index parameter will indicate the table index
for which the match was found.  If no match is found it will
return zero.  If t is ambiguous the index will be set to -1.
The contents of t will be converted to upper case letters.

Note that the table must contain upper case letters only and
no blanks at the end of the text.

An example of the use of MENU :

...
SAFEIO("","") BEGIN   TEXT t;   TEXT ARRAY table[1:5];
        INTEGER index;
        SWITCH action:= start,stop,delete,delayed,delay;

        table[1]:- Copy("START");
        table[2]:- Copy("STOP");
        table[3]:- Copy("DELETE");
        table[4]:- Copy("DELAYED");
        table[5]:- Copy("DELAY");

        request("*",nodefault,
        textinput(t,menu(t,index,table,5)),
                                                      Page 9
3. SAFEIO REQUEST AND INPUTCHECKING PROCEDURES


        commandmessage(index),          ! SAFEIO PROC.
attribute
                                        ! answering with
proper
                                        ! error message.;
        commandhelp(table,5));          ! SAFEIO PROC.
attribute
                                        ! displaying
available
                                        ! commands in
TABLE.;

        GO TO action[index];

        start: ...
        stop: ...
        delete: ...
        delayed: ...
        delay: ...
...

The following input strings will be accepted :
START
start
Start
sta
dele
delaye

while the following will be rejected :

S
st
del
dela
xxx


2.3 HELP PROCEDURES

There is  two  SAFEIO  boolean  help  procedures,  HELP  and
NOHELP.   Procedure HELP takes one text parameter (by NAME).
If the text is longer than Sysout.Length then the text  will
be copied and displayed with Carriage Return substituted for
relevant blanks.  Procedure NOHELP will  simply  inform  the
user  than  the  programmer was too lazy to provide any help
information.
                                                     Page 10
4. SAFEIO COMMANDS


3.  SAFEIO COMMANDS


The following facilities are included in the SAFEIO class.


     1.  Substituting terminal input for disk file input.

     2.  Creating log files saving all accepted input.


A SAFEIO command may be typed in at any  question  (call  of
request) during the conversation.


3.1 CLASS SAFEI


There exists another class - SAFEI which should be  used  if
these  facilities  are not wanted.  The SAFEI class has just
one formal parameter - the language parameter.

The following code could be used if a  log  file  should  be
generated when using SAFEI :


BEGIN
    EXTERNAL declarations ...;

    safei("eng") BEGIN


        REF (Outfile) recordfile;   TEXT recordname;

        PROCEDURE
        askfor(prompt,default,inputok,errormessage,help);
        NAME prompt,default,inputok,errormessage,help;
        TEXT prompt,default,errormessage;
        BOOLEAN inputok,help;
        BEGIN
           
request(prompt,default,inputok,errormessage,help);
            INSPECT recordfile DO Outimage

        END of askfor;


        request("Log file:",nodefault,
        textinput(recordname,TRUE),"",nohelp);

        IF recordname =/= NOTEXT THEN
        BEGIN
            recordfile:- NEW Outfile(recordname);
            recordfile.Open(Sysin.Image)
                                                     Page 11
4. SAFEIO COMMANDS


        END name given;

        ! for example: ;
        askfor("i:","2",intinput(i,i>0),"? Must be >
0.",nohelp);

        ... etc. using askfor instead of request ...

        INSPECT recordfile DO Close;

    END safei

END of program


3.2 CONTROLLING LOG FILES

The following commands may be used in order to control a log
file :

!>      By typing "!>filespec" (where  filespec  is  a  file
        specification)  the  user  will open a new log file.
        If another log file already is  active  he  will  be
        told so and no new file will be created.

        By typing  "!>"  (with  nothing  after  the  >)  the
        current  log file will be closed.  If no log file is
        active the user will be told so.  When the log  file
        has  been  closed a subsqeuent "!>filespec" with the
        same file name will destroy the old contents of  the
        file (when the new log file is closed).

!+      By typing "!+" the current log file will  be  closed
        and  then  immediately opened again in such way that
        the following log information will be added  to  the
        file  (so  called  append  mode).  If no log file is
        active the user will be told so.


The created log file(s) will contain the prompting questions
as well as the submitted and accepted answers.


3.3 CONTROLLING INPUT FILES

The user may at any question demand  that  input  should  be
read  from  a  disk  file.   The  input  file  can be of two
formats :


     1.  Containing just the answers - with  one  answer  on
         each   line.    No   line   may   be   longer  than
         Max(80,Sysout.Length) characters (could  be  easily
         changed in the SAFEIO code).
                                                     Page 12
4. SAFEIO COMMANDS


     2.  SAFEIO log file format.

If Sysin.Endfile becomes TRUE, a jump to VIRTUAL  LABEL  EOF
will  occur.   If  the user block has such a label, then the
program exexcution will continue there.  Otherwise the block
will terminate through an internal safeio jump.  NOTE!  Once
Sysin.Endfile becomes TRUE - which happens if the user types
^Z - no more input on Sysin is possible.

The following commands are available :

!_      By typing "!_filespec" the user may request that the
        answer  for the current question and those following
        should be read from a disk file.  The SAFEIO  system
        will  print  on the terminal the activated questions
        and the read-in  answers  (could  be  suppressed  by
        typing != or starting and ending the input file with
        !=).  There is no (soft) way to interfere  with  the
        reading  process  which will continue until the file
        is exhausted.  The user will be informed when end of
        file has been encountered.

!<      By typing "!<filespec", however, the  user  requests
        the  disk  file  to  be  read  in  a stepwise manner
        demanding acknowledgement from the  user's  terminal
        for  each  question.  The user may either accept the
        file input by pressing the return key  or  supersede
        the input by typing in a new input value.

        By typing "!_" (with  nothing  after  the  underline
        symbol)  reading  will  continue without waiting for
        acknowledgements (in the manner of the  "!_filespec"
        case).

        By typing  "!<"  the  current  input  file  will  be
        closed.   If  another input file had started the one
        just closed  -  the  original  input  file  will  be
        resumed.

!^      By typing  "!^"  all  active  input  files  will  be
        immediately closed.

An input file may contain  SAFEIO  commands  -  for  example
switching  to  other  input files.  Mixing "!_.." and "!<.."
modes during the nested  input  switching  is  allowed.   In
order to avoid run time error if the number of simulataneous
open files exceeds SIMULA system limit (total  of  16),  the
MAXFILES  integer attribute of SAFEIO is set to 10.  If this
limit is exceeded a message will be displayed  and  no  more
files will be opened unless some files are closed first.

Comments may be inserted in an input file  by  starting  the
line with "!C....  or "!;.....  In the latter case the input
line will be displayed on the user's terminal when read in.
                                                     Page 13
4. SAFEIO COMMANDS


If the input file is a SAFEIO log file (created earlier  but
optionally  during the same run) the prompting question must
be equal to the question field in the file.  (This check may
be switched off by coding CHECKPROMPT:= FALSE;.)



The SAFEIO command facilities may  temporarily  be  switched
off by the programmer by coding :

SWITCHCHAR:= ' ';

They could be switched on again by coding :

SWITCHCHAR:= '!';

or any other suitable character (don't use digit, sign, dot,
questionmark or letter).

(In a similar way  all  the  triggering  characters  may  be
changed - see the end of the source code of SAFEIO.)


3.4 ADDITIONAL SAFEIO COMMANDS

!%      By typing "!%"  the  user  will  indirectly  call  a
        SAFEIO    virtual   procedure   SPECIAL   (with   no
        parameters).  Since it is virtual the programmer may
        define his own procedure SPECIAL.  The current input
        state will be :
        the reference to current image is  CURRENTFILE.IMAGE
        and
        the position equals three.

        The programmer may decode the rest of the input line
        in his own way.

!&xx    By  preceding  an  answer  with  "!&"  the  validity
        checking   for   the   current   question   will  be
        overridden.  The programmer may  short-circuit  this
        facility  by  calling the procedure NOOVERRIDE.  (It
        could be reset by coding OVERRIDECHAR:= '&'.)

The  following  commands  will  change  the  value  of   the
presented switches in the manner switchx:= NOT switchx.

!*      By typing "!*"  the  user  will  change  the  switch
        controlling  the  function  displaying the prompting
        question (attribute DISPLAYPROMPT).

!/      By typing "!/"  the  user  will  change  the  switch
        controlling  the  function  displaying  the  default
        value (attribute DISPLAYDEFAULT).
                                                     Page 14
4. SAFEIO COMMANDS


!=      By typing "!="  the  user  will  change  the  switch
        controlling   the   function   displaying  prompting
        question, default value  and  the  disk  file  input
        value.   The  *-  and  /-switches will be set to the
        resulting   value   of   the   =-switch   (attribute
        DISPLAYINPUT).

![      By typing "!["  the  user  will  change  the  switch
        controlling  the function displaying the file status
        messages (attribute TRACE).

!?      By typing "!?" the user will be presented a list  of
        the available SAFEIO commands.


Anything else will  just  display  the  prompting  question.
However,  input  starting with !!xxx where xxx is an integer
in the interval 7 - sysin.length will be read as a line with
its contents equal to the rest of the original line starting
at pos xxx.  This  facility  is  mainly  used  when  reading
earlier generated log files.
                                                     Page 15
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


4.  SUMMARY OF CLASS SAFEIO ATTRIBUTES


CLASS safeio(savefilename,language);   VALUE
savefilename,language;
TEXT savefilename,language;
VIRTUAL: PROCEDURE special;   LABEL eof;
BEGIN

    PROCEDURE printint(i);   INTEGER i;
    ! Printint prints the integer i without leading
    ! spaces in Putfrac(i,0) format. ;
    ....;

    PROCEDURE printreal(x);   REAL x;
    ! Printreal prints the value of x without leading zeros
    ! using Putfix format if eight significant
    ! digits could be display that way, else Putreal. ;
    ....;

    TEXT PROCEDURE fracput(i);   INTEGER i;
    ! Returns a text reference (NOT an new text!) with a
value
    ! of i without leading spaces in Putfrac(i,0) format.;
    ....;

    TEXT PROCEDURE intput(i);    INTEGER i;
    ! Ditto Putint format.;
    ....;

    TEXT PROCEDURE realput(x);   REAL x;
    ! Ditto Putfix/Putreal format.;
    ....;

    PROCEDURE outline(t);   VALUE t;   TEXT t;
    ! Prints the text T on Sysout without error even if
    ! T.Length > Sysout.Length. Also calling Outimage.;
    ....;

    BOOLEAN PROCEDURE irange(test,low,high);
    INTEGER test,low,high;
    ! Returns TRUE if low <= test <= high.;
    ....;

    BOOLEAN PROCEDURE range(test,low,high);
    REAL test,low,high;
    ! Ditto for REAL variables.;
    ....;

    TEXT PROCEDURE outofirange(low,high);
    INTEGER low,high;
    ! Returns a text reference containing a complete
    ! errormessage with upper and lower limits indicated.;
    ....;
                                                     Page 16
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


    TEXT PROCEDURE outofrange(low,high);
    REAL low,high;
    ! Ditto for REAL variables.;
    ....;
    BOOLEAN PROCEDURE commandhelp(table,n);
    TEXT ARRAY table;    INTEGER n;
    ! Displays the contents of TABLE[1:N] on the user's
terminal.;
    ....;

    TEXT PROCEDURE commandmessage(index);   INTEGER index;
    ! Returns a text reference indicating that the user's
    ! answer was "UNKNOWN" (index=0) or "AMBIGIOUS" (index
NE 0).
    ....;

    PROCEDURE special;
    ! The programmer may specify his own procedure special
    ! (with exactly that name and no parameter). Since it
    ! is virtual the local procedure will be called when the
    ! user types in '!%'.
    ! Note that the programmer may implement code for
analysing
    ! the rest of the currentfile.image following the '!%'.
    ! Note also that the special procedure may call other
    ! procedures which in turn may have parameters.
    ! This declaration has the sole purpose of avoiding run
time
    ! error ("No virtual match") if the programmer has not
    ! declared his own special procedure. ;
    ....;

    PROCEDURE cmdclose;
    ! This procedure closes all open input SAFEIO files.
    ! If no input file is used a message is printed. ;
    ....;

    PROCEDURE recordclose;
    ! This procedure will close the recording (log) file.
    ! If no recordfile is open no action is taken. ;
    ....;

    PROCEDURE recordappend;
    ! This procedure closes the current recording file and
opens
    ! it again in append mode. The programmer may insert
calls to
    ! recordappend whenever he wants this kind of
checkpoint.
    ! The user may call the procedure by typing in '!+'. ;
    ....;

    CLASS fileitem(file,filename,wait);
    VALUE filename;   TEXT filename;
                                                     Page 17
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


    ! Class fileitem describes the elements in the input
    ! file stack.
    ! Since input file calls ('!<' and '!') may be nested we
    ! need this class. The currentitem (REF (fileitem) )
    ! always points at the top of the stack. Usually the
    ! currentfile (REF (Infile) ) points at
currentitem.file.
    ! However when an illegal or invalid input has been
    ! read, currentfile will temporarly be switched to
Sysin.
    ! The filename is used to remember the filenames of the
input
    ! files.
    ! The wait attribute flags the wait/nowait state of the
input
    ! operations. ;
    REF (Infile) file;   BOOLEAN wait;
    BEGIN   REF (fileitem) p,s;

        PROCEDURE up(x);   REF (fileitem) x;
        ! The procedure up will add a new input file to
        ! the stack.
        ! The new file will be opened. ;
        ....;

        PROCEDURE down;
        ! This procedure removes the top element of the
        ! stack if not equal to Sysin (when a message will
        ! be issued). ;
        ....;

    END OF FILEITEM;

    BOOLEAN PROCEDURE nohelp;
    ! The nohelp procedure issues a message that no special
help
    ! information is available. The programmer is however
    ! encouraged to define his specific help procedures
    ! when using the request procedure. ;
    ....;

    BOOLEAN PROCEDURE help(message);
    NAME message;   TEXT message;
    ! This procedure will display the contents of message on
the
    ! user's terminal. If the message is longer than
Sysout.Length
    ! it will be typed out with a new line at the first
blank
    ! found after scanning the (rest of the) text from the
right
    ! starting at Sysout.Length positions from start.
    ....;
                                                     Page 18
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


    BOOLEAN PROCEDURE intinput(result,valid);
    ! This procedure checks that the rest of the
    ! currentfile.image contain exactly one integer item
    ! (and nothing more).
    ! If so syntaxok will be flagged true (so that the
    ! errormessage in the request may be printed) and the
intinput
    ! will return the value of the dynamically evaluated
    ! parameter valid (which usually is a boolean
expression).
    ! Otherwise a message will be issued and syntaxok will
    ! be flagged false. ;
    NAME result,valid;   INTEGER result;   BOOLEAN valid;
    ....;

    BOOLEAN PROCEDURE realinput(result,valid);
    ! This procedure checks a real item. Otherwise as
intinput. ;
    NAME result,valid;   REAL result;   BOOLEAN valid;
    ....;

    BOOLEAN PROCEDURE longrealinput(result,valid);
    ! This procedure checks a real item in double
    ! precision. The syntax checking does not differ from
that
    ! in realinput, but the result parameter is long real so
    ! that long results may be returned. ;
    NAME result,valid;   LONG REAL result;   BOOLEAN valid;
    ....;

    BOOLEAN PROCEDURE boolinput(result);
    NAME result;   BOOLEAN result;
    ! The boolinput procedure has one parameter only. The
    ! validity check is of course unnecessary for boolean
    ! parameters. Accepted input depends on the contents
    ! of the SAFEIO.language file.
    ! The input line may contain lower case letters.
    ! In the English case it is YES, NO, TRUE OR FALSE.
    ! P} svenska g{ller JA, NEJ, SANN eller FALSK.;
    ....;

    BOOLEAN PROCEDURE textinput(result,valid);
    ! This procedure returns a copy of the stripped
    ! rest of the input line.
    ! The syntax is always considered correct.;
    NAME result,valid;   TEXT result;   BOOLEAN valid;
    ....;

    PROCEDURE
request(prompt,default,inputok,errormessage,help);
    ! The request procedure has the following parameters:
    ! Prompt    is the prompting question, often ending with
a
    !           prompting character as ':'.
                                                     Page 19
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


    ! Default   is the default text value. If default action
is
    !           to be prohibited, the nodefault variable
should
    !           be used.
    ! Inputok   shall become true if the input is to be
accepted,
    !           else false. Usually the actual parameter is
a
    !           call to an ***input procedure.;
    ! Errormessage is a text that will be printed if inputok
is
    !           is false and syntaxok is true (c.f. comment
    !           for intinput).
    ! Help      is a boolean parameter which will be
    !           evaluated each time the user starts his
answer
    !           with a questionmark '?'.
    !;
    VALUE prompt;   NAME default,errormessage,inputok,help;
    TEXT prompt,default,errormessage;   BOOLEAN
inputok,help;
    ....;

    PROCEDURE nooverride;
    ! A call of nooverride shortcircuits the '!&' override
    ! validity test facility. See procedure switchtest. ;
    ....;

    PROCEDURE switchtest(mustprompt,continue,help); 
    ! This procedure takes care of all input lines starting
with
    ! '!' or '?'. ;
    LABEL mustprompt,continue;    PROCEDURE help;
    ....;

    PROCEDURE switchhelp;
    ! This procedure prints information on the SAFEIO
commands. ;
    ....;

    PROCEDURE cmdswitch(c,continue);   CHARACTER c;
    LABEL continue;
    ! This procedure takes care of !< and !_ commands. ;
    ....;

    PROCEDURE recordswitch;
    ! This procedure takes care of the !> command. ;
    ....;

    PROCEDURE closefiles;
    ! Close all open input and recording SAFEIO files. ;
    ....;
                                                     Page 20
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


    REF (Infile) currentfile;   REF (fileitem) currentitem;
    TEXT cmdbuffer,mainprompt,recordname,recordbuffer,
    nodefault,defaultextension,posfield,u;
    TEXT ARRAY message[1:91];
    BOOLEAN trace,syntaxok,displayprompt,displayinput,
    displaydefault,inputsaved,checkprompt,overrideflag,
    waitforsysin;
    REF (Outfile) recordfile;
    INTEGER margin,cmdcount,maxcmdfiles,reqcount;
    CHARACTER cmdchar,recordchar,displaychar,tracechar,
    promptswitchchar,switchchar,cmdnowaitchar,helpchar,
    inputchar,promptingchar,defaultquote,closechar,
    commentchar,appendchar,specialchar,overridechar;

    ! Length of images may be increased. ;
    u:- Blanks(20);
    maxcmdfiles:= 10;
    cmdbuffer:- Blanks(IF Length > 80 THEN Length ELSE 80);
    recordbuffer:- Blanks(cmdbuffer.Length);

    readmessages;

    ! Set up initial values. ;

    nodefault:- message[76];    defaultextension:-
message[77];

    checkprompt:=
    syntaxok:= displaydefault:= displayprompt:=
    displayinput:= trace:= TRUE;

    currentfile:- Sysin;
    currentitem:-
    NEW fileitem(currentfile,message[78],waitforsysin);

    ! May be changed to zero if no indentation of answers
    ! is wanted. Could also be increased if very long
questions. ;
    margin:= 35;

    ! All these characters may be changed. However be
    ! carefull for clashes. See procedure switchtest about
the
    ! testing order. Note the possibility to shortcircuit
    ! a facility by setting the corresponding character
    ! to ' '. ;

    cmdchar:= '<';
    recordchar:= '>';
    helpchar:= '?';
    displaychar:= '/';
    tracechar:= '[';
    promptswitchchar:= '*';
    inputchar:= '=';
                                                     Page 21
5. SUMMARY OF CLASS SAFEIO ATTRIBUTES


    switchchar:= '!';
    cmdnowaitchar:= '_';
    defaultquote:= '/';
    promptingchar:= ':';
    specialchar:= '%';
    overridechar:= '&';
    appendchar:= '+';
    commentchar:= ';';
    closechar:= '^';

    ! Initializing recordfile from start. ;
    IF savefilename =/= NOTEXT THEN
    BEGIN   Sysin.Image:= savefilename;   Sysin.Setpos(1);
        recordswitch;   Sysin.Setpos(0);
    END;

    ! Eliminating page skipping on Sysout. ;
    INSPECT Sysout WHEN Printfile DO Linesperpage(-1);

    INNER;

    ! Jump here if Sysin.Endfile is TRUE:;
    eof:

    closefiles; ! NOTE. SAFEI and SIMEI has no such
procedure.;

END of safeio;
                                                     Page 22
6. RESTRICTIONS


5. RESTRICTIONS


The following restrictions are valid for the SAFEIO version
4.0.



     1.  Input texts will be stripped of blanks from the
         right and stripped of blanks and tabs from the
         left.

     2.  The input starting with "?" cannot be transferred
         to a text.

     3.  Texts starting with the current value of switchchar
         (initially '!') cannot be transferred.

     4.  The image length of sysout may not be less than the
         longest text in the message file.

     5.  Length of input lines may not exceed image length
         of sysout.

     6.  Input lines ending with formfeed (FF) or vertical
         tab (VT) will be ignored by SAFEIO.

                                                     Page 23
7. INDEX


6.  INDEX



Additional safeio commands . . 13
Append mode  . . . . . . . . . 11
Appendchar . . . . . . . . . . 20

Boolinput  . . . . . . . . . . 7-8, 18

Checkpoint.  . . . . . . . . . 16
Checkprompt  . . . . . . . . . 13, 20
Checkvalidity  . . . . . . . . 8
Class fileitem . . . . . . . . 17
Class safei  . . . . . . . . . 2
Closechar  . . . . . . . . . . 20
Closefiles . . . . . . . . . . 19-20
Cmd  . . . . . . . . . . . . . 20
Cmdchar  . . . . . . . . . . . 20
Cmdclose . . . . . . . . . . . 16
Cmdname  . . . . . . . . . . . 20
Cmdnowaitchar  . . . . . . . . 20
Cmdswitch  . . . . . . . . . . 19
Commandhelp  . . . . . . . . . 9, 16
Commandmessage . . . . . . . . 8, 16
Commentchar  . . . . . . . . . 20
Comments . . . . . . . . . . . 12
Control-Z  . . . . . . . . . . 12
Controlling input files  . . . 11
Controlling log files. . . . . 11
Currentfile  . . . . . . . . . 20
Currentitem  . . . . . . . . . 20

Default  . . . . . . . . . . . 19
Defaultextension . . . . . . . 20
Defaultquote . . . . . . . . . 5, 20
Defaultvalue . . . . . . . . . 5
Displaychar  . . . . . . . . . 20
Displaydefault . . . . . . . . 20
Displayinput . . . . . . . . . 20
Displayprompt  . . . . . . . . 20
Down . . . . . . . . . . . . . 17

End-of-file on Sysin . . . . . 12
Eof, virtual label . . . . . . 12
Errormessage . . . . . . . . . 5, 18-19

File status messages.  . . . . 14
Fileitem . . . . . . . . . . . 16
Formal parameters  . . . . . . 2
Formats  . . . . . . . . . . . 11
Fracput  . . . . . . . . . . . 15

Help . . . . . . . . . . . . . 6, 19
Help procedure . . . . . . . . 9
Helpchar . . . . . . . . . . . 20

Inputchar  . . . . . . . . . . 20
Inputok  . . . . . . . . . . . 5, 19
Inputsaved . . . . . . . . . . 20
Intinput . . . . . . . . . . . 7-8, 18
Intput . . . . . . . . . . . . 15
Irange . . . . . . . . . . . . 15

Language . . . . . . . . . . . 15
Language parameter . . . . . . 2
Log file . . . . . . . . . . . 2
Log file.  . . . . . . . . . . 11
Longrealinput  . . . . . . . . 7-8, 18

Mainprompt . . . . . . . . . . 20
Margin . . . . . . . . . . . . 20
Menu . . . . . . . . . . . . . 8
Meny . . . . . . . . . . . . . 8
Message  . . . . . . . . . . . 20
Message files  . . . . . . . . 2

Nodefault  . . . . . . . . . . 5, 20
Nohelp . . . . . . . . . . . . 17
Nohelp procedure . . . . . . . 9
Nooverride . . . . . . . . . . 19
Nooverride.  . . . . . . . . . 13

Outline  . . . . . . . . . . . 15
Outofirange  . . . . . . . . . 15
Outofrange . . . . . . . . . . 16
Overridechar . . . . . . . . . 13, 20
Overrideflag . . . . . . . . . 20

Posfield . . . . . . . . . . . 20
Printint . . . . . . . . . . . 15
Printreal  . . . . . . . . . . 15
Procedure special  . . . . . . 16
Prompt . . . . . . . . . . . . 18
Promptingchar  . . . . . . . . 20
Promptingchar. . . . . . . . . 5
Promptingquestion  . . . . . . 5
Promptswitchchar . . . . . . . 20

Range  . . . . . . . . . . . . 15
Read in a stepwise manner  . . 12
Realinput  . . . . . . . . . . 7-8, 18
Realput  . . . . . . . . . . . 15
Record . . . . . . . . . . . . 20
Recordappend . . . . . . . . . 16
Recordchar . . . . . . . . . . 20
Recordclose  . . . . . . . . . 16
Recordfile . . . . . . . . . . 20
Recordname . . . . . . . . . . 20
Recordswitch . . . . . . . . . 19-20
Request  . . . . . . . . . . . 5, 18
Restrictions . . . . . . . . . 22
Safei class  . . . . . . . . . 10
Safeio command . . . . . . . . 10
Safmin . . . . . . . . . . . . 2
Savefilename . . . . . . . . . 15
Sime . . . . . . . . . . . . . 2
Simeio . . . . . . . . . . . . 2
Simmin . . . . . . . . . . . . 2
Simulation, using SAFEIO . . . 2
Special  . . . . . . . . . . . 13, 16
Specialchar  . . . . . . . . . 20
Superseed the input  . . . . . 12
Switchchar . . . . . . . . . . 13, 20
Switches . . . . . . . . . . . 13
Switchhelp . . . . . . . . . . 19
Switchtest . . . . . . . . . . 19
Syntax and validity checking . 5
Syntaxok . . . . . . . . . . . 18, 20
Syntaxok flag  . . . . . . . . 5

Textinput  . . . . . . . . . . 7-8, 18
Trace  . . . . . . . . . . . . 20
Tracechar  . . . . . . . . . . 20
Triggering characters  . . . . 13

Up . . . . . . . . . . . . . . 17

Wait . . . . . . . . . . . . . 17
Wait attribute . . . . . . . . 17
Waitforsysin . . . . . . . . . 20

^z . . . . . . . . . . . . . . 12


