


                 




















                    GGG   PPPP    SSS    SSS    SSS
                   G   G  P   P  S   S  S   S  S   S
                   G      P   P  S      S      S
                   G      PPPP    SSS    SSS    SSS
                   G GGG  P          S      S      S
                   G  G   P      S   S  S   S  S   S
                   GGGG   P       SSS    SSS    SSS 
Inledning                                                    Page 2


1. Inledning


          GPSSS {r en simulaklass f`r fl`den av objekt mellan k`er,
     lager  och  behandlingsstationer.   Klassen,  som har prefixet
     SIMULATION, ger SIMULA n}gra av de anv{ndbara  procedurerna  i
     Gordons   GPSS.   Det  inkluderar  deklarationer  av  f`ljande
     klasser :

              1. TRANSACTION, som definierar objekten
              2. FACILITY   ,    - " -       stationer
              3. STORAGE    ,    - " -       lagerutrymmen
              4. QUEUE      ,    - " -       k`er


          Procedurerna m`jligg`r f`r objekten att g} in i och l{mna
     resurserna.     Statistik    p}   resurs-utnyttjandet   samlas
     automatiskt och skrivs ut i slutet av simuleringen

          De avancerade satserna i  GPSS  har  ersatts  av  de  mer
     flexibla  SIMULA  satserna  som  HOLD(  -  -  ),  ACTIVATE och
     REACTIVATE.  Men det finns en procedur WAIT_UNTIL som till}ter
     villkorliga inplaneringar av h{ndelser f`r objekten.  Objekten
     kan tilldelas prioritet f`r att }stadkomma  f`rst-in-f`rst-ut,
     sist-in-f`rst-ut och andra ordningar.

          Med andra procedurer kan man fr}ga efter det  tillf{lliga
     utnyttjandet av en resurs.  Man kan ocks} fr}ga efter utskrift
     av statistik under en simulering, och modellen kan }terst{llas
     s}  att  en  ny  simulering med andra indata kan g`ras i samma
     k`rning.  #ven helt olika simulerings-modeller  kan  simuleras
     under en k`rning.

          Med GPSSS kan simuleringsprogram skrivas p}  samma  enkla
     och  korta  s{tt  som  med  GPSS.   Anv{ndningen av SIMULA som
     basspr}k bibeh}ller den h`ga standarden p}  programstrukturen,
     s}som  blockstrukturen, procedurer, aritmetik, str{nghantering
     och in och utmatning.


2. Resurserna

K`er

          K`erna kan utnyttjas av  objekten  n{r  som  helst.   Det
     finns  ingen  begr{nsning  p}  storleken  av dem.  Statistiken
     inneh}ller :

Resurserna                                                   Page 3


        1. hur m}nga objekt som totalt befunnit sig i k`n
        2. st`rsta antal objekt i k`n
        3. aktuella inneh}llet i k`n
        4. genomsnittliga inneh}llet i k`n
        5. genomsnittliga tiden objekten befunnit sig i k`n.

Behandlingsstationer

          Stationerna kan bara utnyttjas av ett objekt i taget.  De
     objekt  som  vill  g}  in  i  en  upptagen  behandlingsstation
     placeras i en ink` knuten till stationen ifr}ga.  D{rifr}n tas
     sedan  objekten  i  prioritetsordning in i stationen d} den {r
     ledig.  Den statistik som ges {r :

           1. genomsnittliga utnyttjandet av stationen
           2. antal objekt som anv{nt stationen
           3. den genomsnittliga tid objekten till-
              bringat i stationen.
           4. aktuella inneh}llet i stationen

Lager


          Ett   lager   kan   ha   ett   visst   maximalt   utrymme
     f`r-definierat.    Det   ges   med   satsen   SET_STORAGE(  N,
     <max_utrymme>);  Ett objekt, som inte f}r plats i  ett  lager,
     placeras  i  v{ntan  p} plats i en k`.  Ordningen ut ur k`n d}
     den inneh}ller flera objekt {r {ven h{r efter prioritet.   Det
     utrymme  ett  objekt  tar anges som andra parameter i utrycket
     enter_storage( N, <erfoderligt_utrymme>);  Objektet kan d} den
     l{mnar  lagerutrymmet frig`ra utrymme som skiljer sig fr}n det
     utrrymme som  kr{vdes  d}  den  kom  dit.   Det  anges  med  :
     leave_storage( N, <frigjort_utrymme>) Statistiken inneh}ller :

          1. maximala lagerutrymmet
          2. genomsnittliga inneh}llet
          3. genomsnittliga utnyttjandet
          4. totala antalet objekt i lagerutrymmet
          5. tiden i lagerutrymmet per enhet som
             utnyttjat lagerutrymmet
          6. st`rsta  antalet objekt i lagerutrymmet
          7. aktuella antalet objekt i lagerutrymmet


Programstrukturen                                            Page 4


3. Programstrukturen

          GPSSS kan anv{ndas som prefix till ett  block  eller  som
     prefix  till  en  klass.  Den ska anv{ndas precis som standard
     system klasserna SIMSET och SIMULATION.
     Anv{ndarprogrammet kan ses som uppdelat i tv} delar.  

        1. definition av objektens attribut och aktiviteter.

        2. huvudprogrammet som initierar och kontrollerar
           simuleringen. Huvudprogrammet m}ste speciellt
           skapa det f`rsta objektet.


          F`ljande triviala exempel  visar  en  modell  d{r  kunder
     anl{nder  slumpm{ssigt  i  tiden  till  ett  system och l{mnar
     densamma efter 10 minuter.  

          OPTIONS(/search "libsim[106,306])
          BEGIN

            EXTERNAL CLASS gpsss ;
            gpsss(1,1,1) BEGIN

              transaction CLASS kund ;
              BEGIN
                ACTIVATE NEW kund
                DELAY Uniform(0,15,u);
                hold( 10 ) ;
              END ;

              COMMENT  *  HUVUDPROGRAMMET *  ;
              ACTIVATE NEW kund DELAY 0 ;
              hold( 100 ) ;

            END GPSSS exempel ;

          END program

          Huvudprogrammet startar simuleringen med att aktivera den
     f`rsta  kunden  och v{ntar sedan 100 tidsenheter, som {r tiden
     f`r simuleringen.

          Objekten i anv{ndarprogrammet {r definierade som  klasser
     med  prefixet  TRANSACTION.   Klassen TRANSACTION definierad i
     GPSSS  har  prefixet  PROCESS  s}   h{ndelser   f`r   objekten
     inplaneras  med  dom  vanliga  SIMULA  satserna.  I programmet
     genererar varje kund  sin  efterf`ljare  och  l{mnar  systemet
     efter 10 minuter.
Programstrukturen                                            Page 5


          H{r f`ljer en lista av de procedurer som beh`vs  f`r  att
     anv{nda resurserna tillsammans med n}gra andra procedurer :


          A) Procedurer f`r objekten
             -----------------------

          - enter_station  ( n )
          - leave_station  ( n )
          - enter_storage  ( n )
          - leave_storage  ( n )
          - enter_queue    ( n )
          - leave_queue    ( n )


          B) Procedurer i huvudprogrammet
             ----------------------------

          - set_storage  ( n , max_contents )
          - restart


          C) Objektens attribut
             ------------------

          - priority
          - time_mark
          - id


          D) Anv{ndar-procedurer
             -------------------

          - gpsss_time
          - wait_until  ( Boolskt uttryck )
          - standard_report
          - contents_station  ( n )
          - contents_storage  ( n )
          - contents_queue    ( n )
          - waiting_station   ( n )
          - waiting_storage   ( n )
          - waiting_queue     ( n )


          E) Global variabel
             ---------------

          - U

Programstrukturen                                            Page 6


          F)  Procedurer i version GPSSST
              ---------------------------

          - trace_objects
          - station_name      (n,new_name)
          - storage_name      (n,new_name)
          - queue_name        (n,new_name)
          - trans_name        ( new_name )
          - hold_until_ready
          - outtime           ( time )
          - begin_time        ( time )



4. Transaktionerna

          Varje objekt har tre attribut f`r-definierade :

                    integer   ID ;
                    real      TIME_MARK, PRIORITY ;


          N{r ett objekt skapas s} s{tts  PRIORITY  till  noll  och
     TIME_MARK till aktuella tiden.  ID ges det v{rde som motsvarar
     objektets ordning i simuleringen.

          PRIORITY anv{nds av systemprocedurerna n{r ett objekt ska
     placeras  i  en  ink`  eller n{r ett objekt g`r en WAIT_UNTIL.
     Ink`erna {r de k`er objekten placeras i innan de  ska  anv{nda
     en station eller ett lager.  Objekt vars PRIORITY {r minst g}r
     ur k`n f`rst.  N{r  PRIORITY  {r  lika  f`r  flera  objekt  {r
     ordningen  f`rst-in-f`rst-ut  om PRIORITY {r st`rre eller lika
     med noll och sist-in-f`rst-ut om PRIORITY {r mindre  {n  noll.
     Anv{ndaren  kan  allts}  definiera  olika  ordningar genom att
     {ndra p} PRIORITY under  simuleringen.   Simulasatserna  HOLD,
     ACTIVATE och REACTIVATE anv{nder inte PRIORITY.

          TIME_MARK  anv{nds  inte  av  GPSSS  men  anv{ndaren  kan
     utnyttja  TIME_MARK  f`r  att  f}  ut tiden som ett objekt har
     tillbringat i en resurs.

          Procedurerna som definierar h{ndelser  f`r  objekten  och
     deras motsvarighet i GPSS visas nedan.

Transaktionerna                                              Page 7


                     GPSSS                   GPSS
                     -----                   ----
                                        
                 ENTER_STATION (N)        SEIZE    N
                 LEAVE_STATION (N)        RELEASE  N
                 ENTER_STORAGE (N, SIZE)  ENTER    N, SIZE
                 LEAVE_STORAGE (N, SIZE)  LEAVE    N, SIZE
                 ENTER_QUEUE   (N)        QUEUE    N
                 LEAVE_QUEUE   (N)        DEPART   N

          Parametern N {r ett heltal som  identifierar  en  resurs.
     Hur  m}nga  behandlingsstationer,  lager  och  k`er anv{ndaren
     t{nker  utnyttja  anges  som  parametrar  till  GPSSS,  enligt
     f`ljande :

          GPSSS( max_queues, max_stations, max_storages)
                  [ k`er ] [ behandlings-] [ lager ]
                           [ stationer   ]

          Numreringen av resurserna beh`ver inte  vara  konsekutiv,
     bara  N  h}ller  sig  fr}n 1 till max_queues, max_stations och
     max_storages respektive.


5. Huvudprogrammet

          Huvudprogrammet    initierar    simuleringen,     anropar
     proceduren  STANDARD_REPORT  om  statistik  ska skrivas ut och
     avslutar  simuleringen.   Den  kan  dessutom   anv{nda   vissa
     procedurer  som  beskrivs senare.  H{r n{mns de tv} procedurer
     som {r speciella f`r huvudprogrammet.  De {r :

                     - RESTART          och
                     - SET_STORAGE( N, <maximalt utrymme> )

          RESTART "nollst{ller" GPSSS s} att en ny  simulering  kan
     g`ras.   Den  nya simuleringen kan vara samma modell med andra
     indata,  eller  en  helt  ny   modell.    Proceduren   anropar
     STANDARD_REPORT,  tar  bort  alla  objekt och resurser, s{tter
     GPSSS_TIME  till  noll  och  den  globala  variabeln   U   f`r
     slumpdragningar till 987654321.

          SET_STORAGE skapar ett lager med dess  maximala  utrymme.
     Om  lager  anv{nds  innan  de har skapats p} detta s{tt kommer
     dess utrymme s{ttas till 1 000 000.


Globala procedurer                                           Page 8


6. Globala procedurer

          Anv{ndarprocedurerna, se sid.  5, ber`r  simuleringstiden
     och hur resurserna har utnyttjas.

          REAL PROCEDURE GPSSS_TIME;  <- - - -> ;   ger  tiden  f`r
     simuleringen   sedan   simuleringen   startade   eller   sedan
     proceduren RESTART anv{ndes sista g}ngen.  Proceduren ers{tter
     SIMULA proceduren TIME som inte ska utnyttjas.

          De sex sista procedurerna, se anv{ndarprocedurer sid.   5
     ger ett heltal som motsvarar :  

     antalet objekt som v{ntar p} att f} utnyttja en resurs (
     WAITING_ ) eller

     det aktuella inneh}llet i en resurs ( CONTENTS_ ).


          STANDARD_REPORT skriver ut statistik p}  utnyttjandet  av
     resurserna.  Tidsintervallet f`r vilken statistiken g{ller, {r
     tiden mellan tv} konsekutiva anrop av proceduren, eller d} den
     anropas  f`r f`rsta g}ngen tiden fram till dess.  Som f`rebild
     till utformningen av statistiken har dess motsvarighet i  GPSS
     anv{nts.   Proceduren  anropas  automatiskt  av  GPSSS d} hela
     simuleringen {r klar.

          WAIT_UNTIL( <boolskt uttryck> ) {r en kraftfull procedur.
     Den  kan anv{ndas av ett objekt eller av huvudprogrammet.  Den
     passiverar f`rst, och  aktiverar  igen  n{r  uttrycket  blivit
     TRUE.   Uttrycket  testas efter varje h{ndelse i simuleringen.
     Objekten passiverade av WAIT_UNTIL  placeras  i  en  v{ntk`  i
     prioritetsordning.   Huvudprogrammet  som  inte  har  PRIORITY
     attributet testas alltid sist av proceduren.


7. Version GPSSST

          I  version  GPSSST  har  anv{ndaren  m`jligheter  att  f}
     utskrifter   av   varje  objekts  v{g  genom  systemet.   #ven
     tidpunkterna f`r h{ndelserna skrivs ut.

          Det finns tv} typer av  utskrifter.   Den  f`rsta  ordnar
     proceduren TRACE(n) och den andra TRACE_OBJECTS.

          TRACE(n) ger utskrift efter hand  ett  objekt  g}r  in  i
     eller l{mnar en resurs.  TRACE(n) anropas automatiskt i GPSSST
     om TRACE_ON s{tts TRUE i b`rjan av anv{ndarprogrammet.

     utskriftsexempel :

        .. 
Version GPSSST                                               Page 9


        .. 
        ..
     object   5   entering   station   2 at time     12:03
     object   4   leaving    storage   1 at time     12:39
        ..
        ..
        ..

          TRACE_OBJECTS kan anropas n{r  en  (del-)  simulation  {r
     klar.   F`rst  skrivs  de  objekt  som l{mnat simuleringen ut.
     Sedan  kommer  de  objekt   som   v{ntar   p}   plats   i   en
     behandlingsstation, eller ett lagerutrymme, och sist de objekt
     som fortfarande {r passiverade  av  WAIT_UNTIL.   Objekten  {r
     ordnade efter deras attribut ID.  

          Varje objekt f`ljs av dess h{ndelser och sedan  objektets
     tid i respektive resurs.  Om anv{ndaren endast `nskar utskrift
     p} objektens tid i resurserna s{tts TIME_SPENT_ONLY := TRUE.

     utskriftsexempel :

                 object   4
                 ----------


          Entered  storage   1 at time       10:51
          Entered  queue     1 at time       10:51
          Leaved   queue     1 at time       11:41
          Entered  station   1 at time       11:41
          Leaved   station   1 at time       12:39
          Entered  queue     3 at time       12:39
          Leaved   queue     3 at time       12:54
          Entered  station   4 at time       12:54
          Leaved   station   4 at time       13:53
          Leaved   storage   1 at time       13:53


          Time spent in  storage   1 :       03:02
          Time spent in  queue     1 :       00:49
          Time spent in  station   1 :       00:58
          Time spent in  queue     3 :       00:16
          Time spent in  station   4 :       00:59


          Statistik f`r proceduren TRACE_OBJECTS samlas  endast  om
     OBJECT_TRACE_ON  s{tts  TRUE.   Detta m}ste allts} g`ras innan
     simuleringen s{tter ig}ng.
Version GPSSST                                              Page 10


          F`r  att  f}  en  mer  l{ttl{st  text  i  de   utskrifter
     trace-procedurerna   ger   kan   man   tilldela  objekten  och
     resurserna andra namn med procedurerna :

     TRANS_NAME  ( <namn> ),      QUEUE_NAME  ( N, <namn>)
     STATION_NAME( N, <namn>) och STORAGE_NAME( N, <namn>)


          I  denna  version  anges  tidsenheten  simuleringen   ska
     utnyttja  med  en  fj{rde parameter till GPSSST.  #ven antalet
     decimaler p} sekunderna ska anges ( femte parametern ).

     GPSSST(  , , , <tidsenheten> , secdec) BEGIN/CLASS


               De tidsenheter som kan anv{ndas {r :

                        's'  f`r  sekunder
                        'm'  f`r  minuter
                        'h'  f`r  timmar
                 och    'd'  f`r  dagar

          Om anv{ndaren inte vill ha sekunder utmatade s{tts secdec
     till -1.


8. Programexempel


          Program-exempel 1, sid.  14, visar en  simulering  av  en
     dator.   Job  inkommer  slumpm{ssigt i tiden och placeras i en
     in-k`.  N{r minnesutrymme {r tillg{ngligt  h{mtas  jobet,  och
     g}r  alternerande mellan CPU-tid och I/O-tid.  Efter 10 s}dana
     looper l{mnar jobet systemet.

          Storage 1 representerar minnet, station 1 CPU'n och queue
     1  och  4  ger  statistik  p}  tider genom systemet respektive
     v{ntetider p} CPU'n.

          Huvudprogrammet anv{nder RESTART  f`r  att  simulera  tv}
     pass med olika minnesstorlekar.

          Sid.  15 visar en l{karmottagning som ska simuleras.  D{r
     finns  tv}  provtagningsrum  och  tv} l{kare.  Patienterna som
     anl{nder   slumpm{ssigt   i   tiden   ska   f`rst   till   ett
     provtagningsrum och sedan till en l{kare.  Fr}n v{ntrummen g}r
     patienterna till det rum som f`rst blir ledigt.
Programexempel                                              Page 11


          V{ntrummen f}r representera k`er, QUEUE 1  och  QUEUE  2,
     och  provtagningsrummen  behandlingsstationer,  STATION  1 och
     STATION  2.   L{karna  f}r  ocks}  bli   behandlingsstationer,
     STATION 3 och STATION 4.  F`r att f} statistik p} utnyttjandet
     av hela l{karstationen f}r den representera ett lager, STORAGE
     1, med ett maximal utrymme av exempelvis 25 patienter.  

                                                            Page 12


            GPSSS  @VERSIKT
            ---------------










     Simulation CLASS gpsss( max_queues,
     max_stations, max_storages )  ;
     BEGIN
       CLASS queue;     < - - - - - - - - >;
       CLASS facility;  < - - - - - - - - >;
       CLASS storage;   < - - - - - - - - >;
       Process CLASS transaction ;
       BEGIN
         PROCEDURE enter_queue(n);  < - - >;
         PROCEDURE leave_queue(n);  < - - >;
         PROCEDURE enter_station(n);  < - >;
         PROCEDURE leave_station(n);  < - >;
         PROCEDURE enter_storage(n);  < - >;
         PROCEDURE leave_storage(n);  < - >;
         PROCEDURE priority_into(queue); <>;
        < - - - - - - - - - - - - - - - - >;
       END of class transaction ;
       PROCEDURE wait_until ;   < - - - - >;
       PROCEDURE  waiting-   -queue   ; < >;
                 contents-   -station ; < >;
                             -storage ; < >;
       PROCEDURE standard_report ;  < - - >;
       PROCEDURE restart ;  < - - - - - - >;
      < - - - - - - - - - - - - - - - - - >;
     END
                                                            Page 13


            KLASSEN  TRANSACTION
            --------------------










     process CLASS transaction ;

     BEGIN 
        REAL time_mark, priority;
        INTEGER id ;
        REF(head) occurrences;

        PROCEDURE trace(n);

        PROCEDURE enter_station (n);
        PROCEDURE leave_station (n) ;
        PROCEDURE enter_storage (n, units_required) ;
        PROCEDURE leave_storage (n,units_released);
        PROCEDURE enter_queue (n);
        PROCEDURE leave_queue (n) ;

        time_mark := gpsss_time ;
        transid := transid + 1 ; id := transid ;

        IF object_trace_on THEN occurrences:-NEW head;
        INNER;
        IF object_trace_on THEN 
        final_wait (finished_objects);
        IF nextev==NONE THEN ACTIVATE Main DELAY 0;

     END CLASS TRANSACTION ;
                                                            Page 14


           PROGRAM-EXEMPEL 1
           -----------------

     OPTIONS(/search:"libsim[106,346]");
     BEGIN EXTERNAL CLASS gpsss;
      gpsss(4,1,1) BEGIN

      transaction CLASS job;
      BEGIN INTEGER i,size,u1;
      ACTIVATE NEW job DELAY Negexp(1/20,u);
      size := Randint(1,10,u);u1 := u;
      enter_queue(1);enter_storage (1,size);

      FOR i := 1 STEP 1 UNTIL 10 DO BEGIN
      enter_queue (4);enter_station (1);
      leave_queue(4);hold(Negexp(1,u1));
      leave_station(1);hold(Uniform(0,5,u1));
      END;

      leave_storage(1,size);leave_queue(1);
      END;
      set_storage(1,10);
      ACTIVATE NEW job;
      hold(300);        standard_report;
      hold(300);        restart;
      set_storage(1,15);ACTIVATE NEW job;
      hold(300);
      END
     END
                                                            Page 15


           L#KARMOTTAGNINGEN
           -----------------










                 L#KARHUSET 


     ===============  IN  ===============
     !                                  !
     !                                  !
     !  V#NTRUM  till  PROVTAGNINGAR    !
     !                                  !
     !                                  !
     !======  IN  ============  IN  =====
     !                 !                !
     !                 !                !
     ! PROVT  RUM  1   ! PROVT  RUM  2  !
     !                 !                !
     !                 !                !
     !=====  UT  =============  UT  =====
     !                                  !
     !                                  !
     !     V#NTRUM  till  L#KARNA       !
     !                                  !
     !                                  !
     !=====  IN  =============  IN  =====
     !                 !                !
     !                 !                !
     !   L#KARE   1    ! L#KARE   2     !
     !                 !                !
     !                 !                !
     ======  UT  =============  UT  =====
                                                            Page 16


           PROGRAM-EXEMPEL 2
           -----------------










     BEGIN COMMENT l{karmot. med provt.;
       EXTERNAL CLASS gpssst,gpssso;
       gpssso(3,4,1,'m',-1) BEGIN

         transaction CLASS patient(t1,t2);
         REAL t1,t2;

         BEGIN PROCEDURE till_station(n);
           INTEGER n;
           BEGIN enter_queue(n);wait_until(
                contents_station(n)=0 OR
                contents_station(n+1)=0);
                leave_queue(n);
                IF contents_station(n)=0 THEN
                enter_station(n) ELSE
                enter_station(n+1);
                hold(IF n=1 THEN t1 ELSE t2 );
                IF station(n).occupier==THIS
                transaction THEN leave_station(n)
                ELSE leave_station(n+1);
           END of till_station ;

           IF id<10 THEN ACTIVATE NEW patient(
           Normal(60,20,u1),Uniform(20,120,u2))
           DELAY Negexp(2/60,u);
           enter_storage(1,1);FOR i:=1,3 DO
           till_station(i);leave_storage(1,1);
         END patient ;

         INTEGER i,u1,u2;u1:=123987;
         u2:=789123;  outfit;
         ACTIVATE NEW patient(Normal(60,20,u1),
         Uniform(20,120,u2)) ;
         hold_until_ready;trace_objects;
       END;
     END
                                                            Page 17


            DEFINITIONER
            ------------










        OPTIONS(/e/search:"libsim[106,346]");
        EXTERNAL CLASS gpssst ;
        gpssst CLASS gpssso ;
        BEGIN
          PROCEDURE outfit ;
          BEGIN
            object_trace_on := TRUE ;
            time_spent_only := TRUE ;
            trans_name("Patient");
            queue_name( 1,"provt. k`n" ) ;
            queue_name( 3,"""l{kark`n""" ) ;
            storage_name( 1 ,"L#KARHUSET" ) ;
            station_name( 1 ,"provrum 1 " ) ;
            station_name( 2 ,"provrum 2 " ) ;
            station_name( 3,"""l{kare 1""") ;
            station_name( 4,"""l{kare 2""") ;
            begin_time(9.00);
          END;
        END  OF  GPSSSO
                                                               Page 18


***************************    -VERSION 4.1-
***   MONTREAL  GPSSS   ***
***  SIMULATION REPORT  ***
***************************


PASSE  =  1


START  TIME=       09:00
END    TIME=       17:14


* STATIONS *
************

              AVERAGE                AVERAGE
   STATION   UTILISATION  ENTRIES   TRANSIT TIME   STATUS

      1         0.73         6        01:00        FREE
      2         0.57         4        01:11        FREE
      3         0.68         5        01:07        FREE
      4         0.49         5        00:48        FREE



* STORAGES *
************

                  AVG.     AVG.               THRU  TIME      CONTENTS
STORAGE  CAPACITY CONTENTS  UTIL. ENTRIES      / UNIT       MAX    NOW

   1       25       2.93  0.1170     10        02:25          6      0



* QUEUES *
**********

                  MAX.     CURRENT     AVG.         AVG.
QUEUE   ENTRIES  CONTENTS  CONTENTS  CONTENTS     TIME/TRANS

   1      10         2         0       0.39         00:19
   3      10         1         0       0.07         00:03
