      SUBROUTINE  SCLPLT  (INDEX0,INDEX1,INDEX2,INDEX3,INDEX4,INDEX5,
     1INDEX6,INDEX7,INDEX8,INDEX9,XFIRST,YFIRST,XFINAL,YFINAL,XCROSS,
     2YCROSS,XWIDTH,YWIDTH,XCORNR,YCORNR,RELHIT,NAMELX,NAMELY,NAMEUX,
     3NAMERY,NAME  ,LASTX ,LASTY )
C     SCLPLT                                                    09/20/67
C     SCALE PLOTTING SUBROUTINE FOR GENERAL PLOTTING PACKAGE GENPLT-II
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE SCLPLT ARGUMENT LIST DEFINITIONS.
C
C     INDEX0 = 1 GIVES IMMEDIATE RETURN FROM SCLPLT SUBROUTINE.
C     INDEX0 = 2-4 DEFINES FORMAT OF SCALES TO BE PLOTTED.
C     INDEX0 = 2-3 DOES NOT CAUSE ANY ACTUAL PLOTTING TO BE UNDERTAKEN.
C     INDEX0 = 2 DEFINES FORMAT FOR EXTERNAL (RECTANGULAR) SCALES.
C     INDEX0 = 3 DEFINES FORMAT FOR INTERNAL (CROSSED) SCALES.
C     INDEX0 = 4 CAUSES ACTUAL PLOTTING OF PLOTTING AREA CORNERS.
C     INDEX0 = 4 MARKS CORNERS OF PLOTTING AREA WITH LARGE CROSSES.
C     INDEX0 = 4 VOIDS ALL OTHER OPTIONS EXCEPT CAPTION OPTIONS.
C     INDEX0 = 4 MIGHT BE USED FOR PAPER ALIGNMENT OR TRIMMING OF PLOTS.
C
C     INDEX1 = 1 GIVES NO HORIZONTAL (X) SCALE LINES.
C     INDEX1 = 2-4 PLOTS HORIZONTAL (X) SCALE LINES.
C     INDEX1 = 2 PLOTS ONLY LOWER HORIZONTAL (X) SCALE LINE.
C     INDEX1 = 3 PLOTS BOTH UPPER AND LOWER HORIZONTAL (X) SCALE LINES.
C     INDEX1 = 4 PLOTS ONLY UPPER HORIZONTAL (X) SCALE LINE.
C
C     INDEX2 = 1 GIVES NO VERTICAL (Y) SCALE LINES.
C     INDEX2 = 2-4 PLOTS VERTICAL (Y) SCALE LINES.
C     INDEX2 = 2 PLOTS ONLY LEFT VERTICAL (Y) SCALE LINE.
C     INDEX2 = 3 PLOTS BOTH LEFT AND RIGHT VERTICAL (Y) SCALE LINES.
C     INDEX2 = 4 PLOTS ONLY RIGHT VERTICAL (Y) SCALE LINE.
C
C     INDEX3 = 1 GIVES NO TICK MARKS ALONG HORIZONTAL (X) SCALES.
C     INDEX3 = 2-4 PLOTS TICK MARKS ALONG HORIZONTAL (X) SCALES.
C     INDEX3 = 2 PLOTS ONLY LOWER HORIZONTAL (X) SCALE TICK MARKS.
C     INDEX3 = 3 PLOTS UPPER AND LOWER HORIZONTAL (X) SCALE TICK MARKS.
C     INDEX3 = 4 PLOTS ONLY UPPER HORIZONTAL (X) SCALE TICK MARKS.
C
C     INDEX4 = 1 GIVES NO TICK MARKS ALONG VERTICAL (Y) SCALES.
C     INDEX4 = 2-4 PLOTS TICK MARKS ALONG VERTICAL (Y) SCALES.
C     INDEX4 = 2 PLOTS ONLY LEFT VERTICAL (Y) SCALE TICK MARKS.
C     INDEX4 = 3 PLOTS LEFT AND RIGHT VERTICAL (Y) SCALE TICK MARKS.
C     INDEX4 = 4 PLOTS ONLY RIGHT VERTICAL (Y) SCALE TICK MARKS.
C
C     INDEX5 = 1 GIVES NO SCALE NUMBERS ALONG HORIZONTAL (X) SCALES.
C     INDEX5 = 2-4 PLOTS SCALE NUMBERS ALONG HORIZONTAL (X) SCALES.
C     INDEX5 = 2 PLOTS ONLY LOWER HORIZONTAL (X) SCALE NUMBERS.
C     INDEX5 = 3 PLOTS UPPER AND LOWER HORIZONTAL (X) SCALE NUMBERS.
C     INDEX5 = 4 PLOTS ONLY UPPER HORIZONTAL (X) SCALE NUMBERS.
C
C     INDEX6 = 1 GIVES NO SCALE NUMBERS ALONG VERTICAL (Y) SCALES.
C     INDEX6 = 2-4 PLOTS SCALE NUMBERS ALONG VERTICAL (Y) SCALES.
C     INDEX6 = 2 PLOTS ONLY LEFT VERTICAL (Y) SCALES NUMBERS.
C     INDEX6 = 3 PLOTS LEFT AND RIGHT VERTICAL (Y) SCALE NUMBERS.
C     INDEX6 = 4 PLOTS ONLY RIGHT VERTICAL (Y) SCALE NUMBERS.
C
C     INDEX7 = 1 GIVES NO HORIZONTAL (X) SCALE CAPTIONS.
C     INDEX7 = 2-4 PLOTS CAPTIONS ALONG HORIZONTAL (X) SCALES.
C     INDEX7 = 2 PLOTS ONLY LOWER HORIZONTAL (X) SCALE CAPTION.
C     INDEX7 = 3 PLOTS UPPER AND LOWER HORIZONTAL (X) SCALE CAPTIONS.
C     INDEX7 = 4 PLOTS ONLY UPPER HORIZONTAL (X) SCALE CAPTION.
C
C     INDEX8 = 0,1 GIVES NO VERTICAL (Y) SCALE CAPTIONS.
C     INDEX8 = 2-4 PLOTS CAPTIONS ALONG VERTICAL (Y) SCALES.
C     INDEX8 = 2 PLOTS ONLY LEFT VERTICAL (Y) SCALE CAPTION.
C     INDEX8 = 3 PLOTS LEFT AND RIGHT VERTICAL (Y) SCALE CAPTIONS.
C     INDEX8 = 4 PLOTS ONLY RIGHT VERTICAL (Y) SCALE CAPTION.
C     INDEX8 = ALSO CONTROLS DIRECTION OF INDEX6 SELECTED SCALE NUMBERS.
C     INDEX8 = 0 PLOTS HORIZONTALLY ANY SCALE NUMBERS ON VERTICAL SCALE.
C     INDEX8 = 0 PREVENTS OVERLAP OF SCALE NUMBERS ON X AND Y SCALES.
C     INDEX8 = 1-4 PLOTS VERTICALLY ANY SCALE NUMBERS ON Y SCALE.
C     INDEX8 = 1-4 PREVENTS OVERLAP OF Y SCALE CAPTIONS AND NUMBERS.
C
C     INDEX9 = 1 GIVES NO MAIN CAPTION.
C     INDEX9 = 2-4 PLOTS MAIN CAPTION.
C     INDEX9 = 2 PLOTS MAIN CAPTION BELOW LOWER HORIZONTAL (X) SCALE.
C     INDEX9 = 3 PLOTS MAIN CAPTION ABOVE LOWER HORIZONTAL (X) SCALE.
C     INDEX9 = 4 PLOTS MAIN CAPTION BELOW UPPER HORIZONTAL (X) SCALE.
C
C     XFIRST = LEFT LIMITING COORDINATE OF HORIZONTAL (X) SCALE.
C     YFIRST = LOWER LIMITING COORDINATE OF VERTICAL (Y) SCALE.
C     XFINAL = RIGHT LIMITING COORDINATE OF HORIZONTAL (X) SCALE.
C     YFINAL = UPPER LIMITING COORDINATE OF VERTICAL (Y) SCALE.
C
C     XCROSS = CROSSED SCALE HORIZONTAL SCALE INTERSECTION COORDINATE.
C     XCROSS = IS IGNORED UNLESS INDEX0 = 3.
C     YCROSS = CROSSED SCALE VERTICAL SCALE INTERSECTION COORDINATE.
C     YCROSS = IS IGNORED UNLESS INDEX0 = 3.
C
C     XWIDTH = HORIZONTAL PLOT WIDTH.
C     YWIDTH = VERTICAL PLOT WIDTH.
C     XCORNR = DISTANCE FROM PLOTTING TABLE ORIGIN TO LEFT PLOT EDGE.
C     YCORNR = DISTANCE FROM PLOTTING TABLE ORIGIN TO LOWER PLOT EDGE.
C
C     RELHIT = HEIGHT OF SCALE NUMBERS/(0.02*YWIDTH).
C     RELHIT = PROPORTIONS HEIGHT OF TICK MARKS, NUMBERS, AND CAPTIONS.
C     RELHIT = 1.0 GIVES NUMBERS YWIDTH/50 HIGH, BEST FOR LARGE PLOTS.
C     RELHIT = 2.0 GIVES NUMBERS YWIDTH/25 HIGH, BEST FOR SMALL PLOTS.
C
C     NAMELX = LOWER HORIZONTAL SCALE CAPTION, SAME HEIGHT AS NUMBERS.
C     NAMELX = READ BY 12A6 FORMAT.
C     NAMELY = LEFT VERTICAL SCALE CAPTION, SAME HEIGHT AS NUMBERS.
C     NAMELY = READ BY 12A6 FORMAT.
C     NAMEUX = UPPER HORIZONTAL SCALE CAPTION, SAME HEIGHT AS NUMBERS.
C     NAMEUX = READ BY 12A6 FORMAT.
C     NAMERY = RIGHT VERTICAL SCALE CAPTION, SAME HEIGHT AS NUMBERS.
C     NAMERY = READ BY 12A6 FORMAT.
C     NAME   = MAIN CAPTION, HEIGHT IS 1.5 TIMES THAT OF SCALE NUMBERS.
C     NAME   = READ BY 12A6 FORMAT.
C
C     LASTX  = HORIZONTAL (X) GRID COORDINATE OF LAST POINT PLOTTED.
C     LASTY  = VERTICAL (Y) GRID COORDINATE OF LAST POINT PLOTTED.
C
      DIMENSION NUM(12),NAMELX(12),NAMEUX(12),NAMELY(12),NAMERY(12),
     1NAME(12),ADJUST(10),NUMERL(12)
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      DATA (ADJUST(I),I=1,10)/1.,2.,2.,2.,4.,4.,4.,4.,4.,10./
      DATA (NUMERL(I),I= 1,10) /1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
      DATA (NUMERL(I),I=11,12) /1H.,1H-/
C
C     ************************INITIAL OPERATIONS************************
      MODE = ILINE
      KSCALE=RELHIT*FACTOR*YWIDTH/300.0
      XSCALE=FACTOR*XWIDTH/(XFINAL-XFIRST)
      YSCALE=FACTOR*YWIDTH/(YFINAL-YFIRST)
      IF(INDEX0-2)118,3,1
    1 IF(INDEX0-3)2,2,3
    2 MOVELX=FACTOR*XWIDTH*(XCROSS-XFIRST)/(XFINAL-XFIRST)
      MOVERX=FACTOR*XWIDTH*(XFINAL-XCROSS)/(XFINAL-XFIRST)
      MOVELY=FACTOR*YWIDTH*(YCROSS-YFIRST)/(YFINAL-YFIRST)
      MOVEUY=FACTOR*YWIDTH*(YFINAL-YCROSS)/(YFINAL-YFIRST)
      GO TO 4
    3 MOVELX=0
      MOVERX=0
      MOVELY=0
      MOVEUY=0
    4 MINX=XCORNR*FACTOR+OFSETX
      MAXX=(XWIDTH+XCORNR)*FACTOR+OFSETX
      MINY = YCORNR*FACTOR+OFSETY
      MAXY=(YWIDTH+YCORNR)*FACTOR+OFSETY
      LMINX=MINX+MOVELX
      LMAXX=MAXX-MOVERX
      LMINY=MINY+MOVELY
      LMAXY=MAXY-MOVEUY
      IF(XFIRST-XFINAL)5,5,6
    5 SMALLX=MINX
      FIRSTX=XFIRST
      FINALX=XFINAL
      GO TO 7
    6 SMALLX=MAXX
      FIRSTX=XFINAL
      FINALX=XFIRST
    7 IF(YFIRST-YFINAL)8,8,9
    8 SMALLY=MINY
      FIRSTY=YFIRST
      FINALY=YFINAL
      GO TO 10
    9 SMALLY=MAXY
      FIRSTY=YFINAL
      FINALY=YFIRST
C
C     ********************MARK CORNERS OF PLOT AREA*********************
   10 IF(INDEX0-4)12,11,11
   11 LX=MINX+6*KSCALE
      LY=MINY+6*KSCALE
      CALL PENUP (LASTX,LASTY,MINX,LY)
      CALL PENDWN(LASTX,LASTY,MINX,MINY)
      CALL PENDWN(LASTX,LASTY,LX,MINY)
      LX=MAXX-6*KSCALE
      CALL PENUP (LASTX,LASTY,LX,MINY)
      CALL PENDWN(LASTX,LASTY,MAXX,MINY)
      CALL PENDWN(LASTX,LASTY,MAXX,LY)
      LY=MAXY-6*KSCALE
      CALL PENUP (LASTX,LASTY,MAXX,LY)
      CALL PENDWN(LASTX,LASTY,MAXX,MAXY)
      CALL PENDWN(LASTX,LASTY,LX,MAXY)
      LX=MINX+6*KSCALE
      CALL PENUP (LASTX,LASTY,LX,MAXY)
      CALL PENDWN(LASTX,LASTY,MINX,MAXY)
      CALL PENDWN(LASTX,LASTY,MINX,LY)
      GO TO 104
C
C     *************************PLOT SCALE LINES*************************
   12 IF((INDEX1/2)-1)14,13,14
   13 CALL PENUP (LASTX,LASTY,MINX,LMINY)
      MODE = IFREER
      CALL PENDWN(LASTX,LASTY,MAXX,LMINY)
   14 IF(INDEX2-3)16,15,15
   15 CALL PENUP (LASTX,LASTY,LMAXX,MINY)
      CALL PENDWN(LASTX,LASTY,LMAXX,MAXY)
   16 IF(INDEX1-3)18,17,17
   17 CALL PENUP (LASTX,LASTY,MAXX,LMAXY)
      CALL PENDWN(LASTX,LASTY,MINX,LMAXY)
   18 IF((INDEX2/2)-1)20,19,20
   19 CALL PENUP (LASTX,LASTY,LMINX,MAXY)
      CALL PENDWN(LASTX,LASTY,LMINX,MINY)
C
C     ***********TICK MARK AND SCALE NUMBER HORIZONTAL SCALES***********
   20 KODE=1
      MODE = ILINE
      IF(INDEX3-1)52,52,21
   21 IF(FINALX-FIRSTX-2.0)23,22,22
   22 KDECML=0
      GO TO 27
   23 DO 25 J=1,10
      IF((10.0**J)*(FINALX-FIRSTX)- 2.0)25,24,24
   24 KDECML=J
      GO TO 26
   25 CONTINUE
      GO TO 52
   26 FIRSTX=FIRSTX*(10.0**KDECML)
      FINALX=FINALX*(10.0**KDECML)
      XSCALE=XSCALE/(10.0**KDECML)
   27 CROSSX=XCROSS*(10.0**KDECML)
      TENEXP=10.0**(AINT(ALOG10(FINALX-FIRSTX)))
      LFTDIG=(FINALX-FIRSTX)/TENEXP
      IF(LFTDIG)28,28,29
   28 LFTDIG=1
   29 STEP=0.05*TENEXP*ADJUST(LFTDIG)
      JUMP=10.0*STEP+0.5
      LFIRST=FIRSTX-1.0
      LFMULT=LFIRST/JUMP
      IF(LFIRST)31,31,30
   30 KSTART=JUMP*LFMULT
      GO TO 32
   31 KSTART=JUMP*LFMULT-JUMP
   32 IF(INDEX3-3)33,33,36
   33 L1=LMINY+(8*KSCALE)
      L2=LMINY-(3*KSCALE)
      L3=LMINY+(3*KSCALE)
      L4=LMINY
      L5=LMINY+(5*KSCALE)
      L6=LMINY
      LY=LMINY-(11*KSCALE)
      KONTRL=1
      GO TO 37
   34 IF(INDEX3-3)52,35,35
   35 IF(KONTRL-2)36,52,52
   36 L1=LMAXY-(8*KSCALE)
      L2=LMAXY+(3*KSCALE)
      L3=LMAXY-(3*KSCALE)
      L4=LMAXY
      L5=LMAXY-(5*KSCALE)
      L6=LMAXY
      LY=LMAXY+(5*KSCALE)
      KONTRL=2
   37 MULT=0
      KOUNT=10
      XPOSN=KSTART
   38 IF(XPOSN-(FIRSTX-0.01*STEP))39,41,40
   39 IF(KOUNT-10)51,48,48
   40 IF(XPOSN-(FINALX+0.01*STEP))41,41,34
   41 LX=SMALLX+((XPOSN-FIRSTX)*XSCALE)
      IF(KOUNT-5)49,50,42
   42 IF(KOUNT-10)49,43,43
C     RULE LONG TICK MARK
   43 CALL PENUP (LASTX,LASTY,LX,L1)
      CALL PENDWN(LASTX,LASTY,LX,L2)
      IF((KONTRL*2)-INDEX5)44,45,44
   44 IF(INDEX5-3)48,45,48
   45 IF(INDEX0-2)84,84,46
   46 IF(XPOSN+STEP-CROSSX)84,84,47
   47 IF(XPOSN-STEP-CROSSX)48,84,84
   48 KOUNT=0
      GO TO 51
C     RULE SHORT TICK MARK
   49 CALL PENUP (LASTX,LASTY,LX,L3)
      CALL PENDWN(LASTX,LASTY,LX,L4)
      GO TO 51
C     RULE MEDIUM TICK MARK
   50 CALL PENUP (LASTX,LASTY,LX,L5)
      CALL PENDWN(LASTX,LASTY,LX,L6)
   51 MULT=MULT+1
      KOUNT=KOUNT+1
      XPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(MULT-100)38,38,52
C
C     ************TICK MARK AND SCALE NUMBER VERTICAL SCALES************
   52 KODE=2
      IF(INDEX4-1)104,104,53
   53 IF(FINALY-FIRSTY-2.0)55,54,54
   54 KDECML=0
      GO TO 59
   55 DO 57 J=1,10
      IF((10.0**J)*(FINALY-FIRSTY)- 2.0)57,56,56
   56 KDECML=J
      GO TO 58
   57 CONTINUE
      GO TO 104
   58 FIRSTY=FIRSTY*(10.0**KDECML)
      FINALY=FINALY*(10.0**KDECML)
      YSCALE=YSCALE/(10.0**KDECML)
   59 CROSSY=YCROSS*(10.0**KDECML)
      TENEXP=10.0**(AINT(ALOG10(FINALY-FIRSTY)))
      LFTDIG=(FINALY-FIRSTY)/TENEXP
      IF(LFTDIG)60,60,61
   60 LFTDIG=1
   61 STEP=0.05*TENEXP*ADJUST(LFTDIG)
      JUMP=10.0*STEP+0.5
      LFIRST=FIRSTY-1.0
      LFMULT=LFIRST/JUMP
      IF(LFIRST)63,63,62
   62 KSTART=JUMP*LFMULT
      GO TO 64
   63 KSTART=JUMP*LFMULT-JUMP
   64 IF(INDEX4-3)65,65,68
   65 L1=LMINX+(8*KSCALE)
      L2=LMINX-(3*KSCALE)
      L3=LMINX+(3*KSCALE)
      L4=LMINX
      L5=LMINX+(5*KSCALE)
      L6=LMINX
      LX=LMINX-(5*KSCALE)
      KONTRL=3
      GO TO 69
   66 IF(INDEX4-3)104,67,67
   67 IF(KONTRL-4)68,104,104
   68 L1=LMAXX-(8*KSCALE)
      L2=LMAXX+(3*KSCALE)
      L3=LMAXX-(3*KSCALE)
      L4=LMAXX
      L5=LMAXX-(5*KSCALE)
      L6=LMAXX
      LX=LMAXX+(11*KSCALE)
      KONTRL=4
   69 MULT=0
      KOUNT=10
      YPOSN=KSTART
   70 IF(YPOSN-(FIRSTY-0.01*STEP))71,73,72
   71 IF(KOUNT-10)83,80,80
   72 IF(YPOSN-(FINALY+0.01*STEP))73,73,66
   73 LY=SMALLY+((YPOSN-FIRSTY)*YSCALE)
      IF(KOUNT-5)81,82,74
   74 IF(KOUNT-10)81,75,75
C     RULE LONG TICK MARK
   75 CALL PENUP (LASTX,LASTY,L1,LY)
      CALL PENDWN(LASTX,LASTY,L2,LY)
      IF((KONTRL*2)-(INDEX6+4))76,77,76
   76 IF(INDEX6-3)80,77,80
   77 IF(INDEX0-2)84,84,78
   78 IF(YPOSN+STEP-CROSSY)84,84,79
   79 IF(YPOSN-STEP-CROSSY)80,84,84
   80 KOUNT=0
      GO TO 83
C     RULE SHORT TICK MARK
   81 CALL PENUP (LASTX,LASTY,L3,LY)
      CALL PENDWN(LASTX,LASTY,L4,LY)
      GO TO 83
C     RULE MEDIUM TICK MARK
   82 CALL PENUP (LASTX,LASTY,L5,LY)
      CALL PENDWN(LASTX,LASTY,L6,LY)
   83 MULT=MULT+1
      KOUNT=KOUNT+1
      YPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(MULT-100)70,70,104
C
C     ************************PLOT SCALE NUMBERS************************
   84 LPOSN=IABS(KSTART+((MULT*JUMP)/10))
      IF(LPOSN-10)86,85,85
   85 KLOG=ALOG10((FLOAT(LPOSN))+0.5)
      IF(KLOG-KDECML)86,86,87
   86 KOUNT=KDECML+1
      GO TO 88
   87 KOUNT=KLOG+1
   88 DO 89 J=1,KOUNT
   89 NUM(J)=(LPOSN/(10**(KOUNT-J)))-((LPOSN/(10**(KOUNT-J+1)))*10)+1
C     PLACE MINUS SIGN INTO ARRAY FOR NEGATIVE NUMBER
      IF(KSTART+((MULT*JUMP)/10))90,92,92
   90 DO 91 J=1,KOUNT
      N=KOUNT-J+1
   91 NUM(N+1)=NUM(N)
      KOUNT=KOUNT+1
      NUM(1)=12
C     PLACE DECIMAL POINT INTO ARRAY
   92 IF(KDECML)95,95,93
   93 KOUNT=KOUNT+1
      DO 94 J=1,KDECML
      N=KOUNT-J
   94 NUM(N+1)=NUM(N)
      NUM(N)=11
C     SHIFT COORDINATES TO CENTER PLOTTED NUMBER
   95 IF(INDEX8)96,96,99
   96 KODE=1
      IF(KONTRL-3)100,97,98
   97 LX=LMINX-(((6*KOUNT)+3)*KSCALE)
      LY=LY-(3*KSCALE)
      GO TO 102
   98 LX=LMAXX+(5*KSCALE)
      LY=LY-(3*KSCALE)
      GO TO 102
   99 IF(KONTRL-3)100,101,101
  100 LX=LX-(KOUNT*3*KSCALE)+KSCALE
      GO TO 102
  101 LY=LY-(KOUNT*3*KSCALE)+KSCALE
C     PLOT SCALE NUMBER ARRAY.
  102 DO 103 J=1,KOUNT
      N=NUM(J)
      NUM(1)=NUMERL(N)
  103 CALL LTRPLT (NUM,1,1,KODE  ,KSCALE,LASTX,LASTY,LX,LY)
      IF(KONTRL-3)48,80,80
C
C     ***************************PLOT CAPTIONS**************************
  104 IF((INDEX7/2)-1)108,105,106
  105 LX=MINX
      LY=LMINY-(19*KSCALE)
      CALL LTRPLT (NAMELX,1,72,1,KSCALE,LASTX,LASTY,LX,LY)
  106 IF(INDEX7-3)108,107,107
  107 LX=MINX
      LY=LMAXY+(13*KSCALE)
      CALL LTRPLT (NAMEUX,1,72,1,KSCALE,LASTX,LASTY,LX,LY)
  108 IF((INDEX8/2)-1)112,109,110
  109 LX=LMINX-(13*KSCALE)
      LY=MINY
      CALL LTRPLT (NAMELY,1,72,2,KSCALE,LASTX,LASTY,LX,LY)
  110 IF(INDEX8-3)112,111,111
  111 LX=LMAXX+(19*KSCALE)
      LY=MINY
      CALL LTRPLT (NAMERY,1,72,2,KSCALE,LASTX,LASTY,LX,LY)
  112 IF(INDEX9-2)118,114,113
  113 IF(INDEX9-4)115,116,118
  114 LY=MINY-(32*KSCALE)
      GO TO 117
  115 LY=MINY+(12*KSCALE)
      GO TO 117
  116 LY=MAXY-(21*KSCALE)
  117 LX=MINX
      KSCALE=(3*KSCALE)/2
      CALL LTRPLT (NAME  ,1,72,1,KSCALE,LASTX,LASTY,LX,LY)
C
C     **************************SCALES COMPLETED************************
  118 RETURN
      END
