      SUBROUTINE PLTLIN(MULT,IDASH,IWEDGE,IHIGH,JHIGH,
     1IDSPLY,IX,IY,JDSPLY,JX,JY)
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERSITY
C
C     SUBROUTINE TO PLOT PARALLEL LINES BETWEEN
C     BLANK RECTANGLES OF DIFFERENT WIDTHS
C
C     MULT   = NUMBER OF PARALLEL LINES TO BE DRAWN
C            = 1 OR GREATER, THIS NUMBER OF LINES IS DRAWN
C              CENTERED BETWEEN POINT IX IY AND POINT JX JY.
C     IDASH  = 0, CONTINUOUS LINE IS DRAWN
C            = 1 OR GREATER, DASHED LINE IS DRAWN
C     IWEDGE = -1 OR LESS, EACH LINE IS WEDGE POINTING
C              FROM POINT IX, IY TO POINT JX, JY.
C            = 0, NORMAL (NON-WEDGE) LINE REPRESENTATION.
C            = 1 OR GREATER, EACH LINE IS WEDGE POINTING
C              FROM POINT JX, JY TO POINT IX, IY.
C     IHIGH  = SEPARATION BETWEEN LINES IF MULT IS NOT 1
C              AND/OR BETWEEN DASHES IF IDASH IS NOT ZERO.
C              IHIGH IS SIMILARLY THE MINIMUM DASH LENGTH
C              AND THE MINIMUM WIDTH OF THE BROADEST WEDGE
C              END WHICH ARE PROPORTIONAL TO IDASH AND THE
C              ABSOLUTE VALUE OF IWEDGE RESPECTIVELY.
C     JHIGH  = HALF OF HEIGHT OF RECTANGLES 1 AND 2.
C     IDSPLY = 0, LINE IS DRAWN TO COORDINATES IX AND IY
C            = 1 OR GREATER, IS WIDTH OF BLANK RECTANGLE 1
C     IX     = HORIZONTAL COORDINATE OF RECTANGLE 1
C     IY     = VERTICAL COORDINATE OF RECTANGLE 1
C     JDSPLY = 0, LINE IS DRAWN TO COORDINATES JX AND JY
C            = 1 OR GREATER, IS WIDTH OF BLANK RECTANGLE 2
C     JX     = HORIZONTAL COORDINATE OF RECTANGLE 2
C     JY     = VERTICAL COORDINATE OF RECTANGLE 2
C
      MINUS=MULT-1
      IF(IDSPLY)1,1,7
    1 IF(JDSPLY)2,2,16
    2 IF(IDASH)3,3,30
    3 IF(IWEDGE)30,4,30
    4 IF(MINUS)30,5,30
C
C     PLOT LINE CONNECTING POINTS
    5 CALL CRTOFF(IX,IY)
      CALL CRTON (JX,JY)
    6 RETURN
C
C     CALCULATE INTERCEPT WITH RECTANGLE 1
    7 IDSTX=JX-IX
      IDSTY=JY-IY
      JJX=JHIGH*IDSTX
      JJY=IDSPLY*IDSTY
      IF(JJX-JJY)8,9,10
    8 IF(JJX+JJY)14,11,11
    9 IF(JJX+JJY)13,6,12
   10 IF(JJX+JJY)13,12,12
   11 IIX=IX+JJX/IDSTY
      IIY=IY+JHIGH
      IF(JY-IIY)6,6,15
   12 IIX=IX+IDSPLY
      IIY=IY+JJY/IDSTX
      IF(JX-IIX)6,6,15
   13 IIX=IX-JJX/IDSTY
      IIY=IY-JHIGH
      IF(JY-IIY)15,6,6
   14 IIX=IX-IDSPLY
      IIY=IY-JJY/IDSTX
      IF(JX-IIX)15,6,6
C
C     CALCULATE INTERCEPT WITH RECTANGLE 2
   15 IF(JDSPLY)25,25,17
   16 IDSTX=JX-IX
      IDSTY=JY-IY
      IIX=IX
      IIY=IY
      JJX=JHIGH*IDSTX
   17 JJY=JDSPLY*IDSTY
      IF(JJX-JJY)18,19,20
   18 IF(JJX+JJY)22,23,23
   19 IF(JJX+JJY)21,6,24
   20 IF(JJX+JJY)21,24,24
   21 JJX=JX+JJX/IDSTY
      JJY=JY+JHIGH
      IF(JJY-IIY)26,6,6
   22 JJX=JX+JDSPLY
      JJY=JY+JJY/IDSTX
      IF(JJX-IIX)26,6,6
   23 JJX=JX-JJX/IDSTY
      JJY=JY-JHIGH
      IF(JJY-IIY)6,6,26
   24 JJX=JX-JDSPLY
      JJY=JY-JJY/IDSTX
      IF(JJX-IIX)6,6,26
   25 JJX=JX
      JJY=JY
C
C     PLOT LINE BETWEEN BLANK RECTANGLES
   26 IF(IWEDGE)31,27,32
   27 IF(MINUS)33,28,33
   28 IF(IDASH)29,29,33
   29 CALL CRTOFF(IIX,IIY)
      CALL CRTON (JJX,JJY)
      RETURN
C
C     CALCULATE OFFSETS FOR DASHES AND MULTIPLE LINES
   30 IDSTX=JX-IX
      IDSTY=JY-IY
      IIX=IX
      IIY=IY
      JJX=JX
      JJY=JY
      IF(IWEDGE)31,33,32
   31 LX=-IWEDGE*MULT
      IDSTX=-IDSTX
      IDSTY=-IDSTY
      INDEX=IIX
      IIX=JJX
      JJX=INDEX
      INDEX=IIY
      IIY=JJY
      JJY=INDEX
      KX=JX
      KY=JY
      GO TO 33
   32 LX=IWEDGE*MULT
      KX=IX
      KY=IY
   33 IF(IDSTX-IDSTY)34,35,36
   34 IF(IDSTX+IDSTY)45,37,37
   35 IF(IDSTX+IDSTY)38,6,44
   36 IF(IDSTX+IDSTY)38,44,44
   37 MOVEX=(IDSTX*IHIGH)/IDSTY
      MOVEY=IHIGH
      IF(IDSTX)39,40,40
   38 MOVEX=-(IDSTX*IHIGH)/IDSTY
      MOVEY=-IHIGH
      IF(IDSTX)39,40,40
   39 MOST=IHIGH+(MOVEX/4)
      GO TO 41
   40 MOST=IHIGH-(MOVEX/4)
   41 MOVEX=(MOST*MOVEX)/IHIGH
      MOVEY=(MOST*MOVEY)/IHIGH
      IF(IWEDGE)43,42,43
   42 IF(IDASH)54,54,52
   43 IF(IDASH)68,68,67
   44 MOVEX=IHIGH
      MOVEY=(IDSTY*IHIGH)/IDSTX
      IF(IDSTY)46,47,47
   45 MOVEX=-IHIGH
      MOVEY=-(IDSTY*IHIGH)/IDSTX
      IF(IDSTY)46,47,47
   46 MOST=IHIGH+(MOVEY/4)
      GO TO 48
   47 MOST=IHIGH-(MOVEY/4)
   48 MOVEX=(MOST*MOVEX)/IHIGH
      MOVEY=(MOST*MOVEY)/IHIGH
      IF(IWEDGE)50,49,50
   49 IF(IDASH)54,54,51
   50 IF(IDASH)65,65,64
C
C     PLOT DASHED LINE
   51 LEAST=(IIX-IX)/MOVEX
      MOST=(JJX-IX)/MOVEX
      IDSTY=(MOST*MOVEX*IDSTY)/IDSTX
      IDSTX=MOST*MOVEX
      GO TO 53
   52 LEAST=(IIY-IY)/MOVEY
      MOST=(JJY-IY)/MOVEY
      IDSTX=(MOST*MOVEY*IDSTX)/IDSTY
      IDSTY=MOST*MOVEY
   53 KX=IX-((MOVEY*MINUS)/2)
      KY=IY+((MOVEX*MINUS)/2)
      KOUNT=IDASH+((IDASH+1)*(LEAST/(IDASH+1)))
      IF(KOUNT-LEAST)56,56,55
   54 KOUNT=1
      MOST=0
   55 IIX=IIX-((MOVEY*MINUS)/2)
      IIY=IIY+((MOVEX*MINUS)/2)
      GO TO 58
   56 KOUNT=KOUNT+1
      IF(KOUNT-MOST)57,57,6
   57 IIX=KX+(KOUNT*IDSTX)/MOST
       IIY=KY+(KOUNT*IDSTY)/MOST
      KOUNT=KOUNT+IDASH
   58 IF(KOUNT-MOST)60,60,59
   59 LX=JJX-((MOVEY*MINUS)/2)
      LY=JJY+((MOVEX*MINUS)/2)
      GO TO 61
   60 LX=KX+(KOUNT*IDSTX)/MOST
      LY=KY+(KOUNT*IDSTY)/MOST
   61 INDEX=1
   62 CALL CRTOFF(IIX,IIY)
      CALL CRTON (LX,LY)
      IF(INDEX-MULT)63,56,56
   63 INDEX=INDEX+1
      IIX=IIX+MOVEY
      IIY=IIY-MOVEX
      LX=LX+MOVEY
      LY=LY-MOVEX
      GO TO 62
C
C     DISPLAY WEDGE SHAPED LINE
   64 LEAST=(IIX-KX)/MOVEX
      MOST=(JJX-KX)/MOVEX
      ISEPX=(LX*MOST*MOVEX*MOVEX)/IDSTX
      ISEPY=(LX*MOST*MOVEX*MOVEY)/IDSTX
   65 KSEPX=(LX*MOVEX*(IIX-KX))/IDSTX
      KSEPY=(LX*MOVEY*(IIX-KX))/IDSTX
      IENDX=(LX*MOVEX*(JJX-KX))/IDSTX
      IENDY=(LX*MOVEY*(JJX-KX))/IDSTX
      IF(IDASH)71,71,66
   66 IDSTY=((MOST*MOVEX*IDSTY)/IDSTX)+(ISEPX/2)
      IDSTX=(MOST*MOVEX)-(ISEPY/2)
      GO TO 70
   67 LEAST=(IIY-KY)/MOVEY
      MOST=(JJY-KY)/MOVEY
      ISEPX=(LX*MOST*MOVEY*MOVEX)/IDSTY
      ISEPY=(LX*MOST*MOVEY*MOVEY)/IDSTY
   68 KSEPX=(LX*MOVEX*(IIY-KY))/IDSTY
      KSEPY=(LX*MOVEY*(IIY-KY))/IDSTY
      IENDX=(LX*MOVEX*(JJY-KY))/IDSTY
      IENDY=(LX*MOVEY*(JJY-KY))/IDSTY
      IF(IDASH)71,71,69
   69 IDSTX=((MOST*MOVEY*IDSTX)/IDSTY)-(ISEPY/2)
      IDSTY=(MOST*MOVEY)+(ISEPX/2)
   70 KX=KX-((MOVEY*MINUS)/2)
      KY=KY+((MOVEX*MINUS)/2)
      KOUNT=IDASH+((IDASH+1)*(LEAST/(IDASH+1)))
      IF(KOUNT-LEAST)73,73,72
   71 KOUNT=1
      MOST=0
   72 IIX=IIX-((MOVEY*MINUS)/2)-(KSEPY/2)
      IIY=IIY+((MOVEX*MINUS)/2)+(KSEPX/2)
      GO TO 75
   73 KOUNT=KOUNT+1
      IF(KOUNT-MOST)74,74,6
   74 KSEPX=(KOUNT*ISEPX)/MOST
      KSEPY=(KOUNT*ISEPY)/MOST
      IIX=KX+((KOUNT*IDSTX)/MOST)
      IIY=KY+((KOUNT*IDSTY)/MOST)
      KOUNT=KOUNT+IDASH
   75 IF(KOUNT-MOST)77,77,76
   76 LX=JJX-((MOVEY*MINUS)/2)-(IENDY/2)
      LY=JJY+((MOVEX*MINUS)/2)+(IENDX/2)
      LSEPX=IENDX
      LSEPY=IENDY
      GO TO 78
   77 LSEPX=(KOUNT*ISEPX)/MOST
      LSEPY=(KOUNT*ISEPY)/MOST
      LX=KX+((KOUNT*IDSTX)/MOST)
      LY=KY+((KOUNT*IDSTY)/MOST)
   78 INDEX=1
   79 CALL CRTOFF(IIX+((KSEPY*INDEX)/MULT),
     1            IIY-((KSEPX*INDEX)/MULT))
      CALL CRTON ( LX+((LSEPY*INDEX)/MULT),
     1             LY-((LSEPX*INDEX)/MULT))
      CALL CRTON (LX+((LSEPY*(INDEX-1))/MULT),
     1            LY-((LSEPX*(INDEX-1))/MULT))
      CALL CRTON (IIX+((KSEPY*(INDEX-1))/MULT),
     1            IIY-((KSEPX*(INDEX-1))/MULT))
      CALL CRTON (IIX+((KSEPY*INDEX)/MULT),
     1            IIY-((KSEPX*INDEX)/MULT))
      IF(INDEX-MULT)80,73,73
   80 INDEX=INDEX+1
      IIX=IIX+MOVEY
      IIY=IIY-MOVEX
      LX=LX+MOVEY
      LY=LY-MOVEX
      GO TO 79
      END
