      SUBROUTINE DSHPLT(XPOINT,YPOINT,KRDBGN,KRDEND,XFIRST,YFIRST,
     1    XFINAL,YFINAL,XWIDTH,YWIDTH,XCORNR,YCORNR,RELHIT,RELSPC,
     2    LASTX,LASTY)
C                                                               09/18/67
C     DASHED LINE DATA PLOTTING SUBROUTINE FOR GENPLT-II PLOT PACKAGE
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE DSHPLT ARGUMENT LIST DEFINITIONS.
C
C     XPOINT = ARRAY OF X COORDINATES OF POINTS TO BE PLOTTED.
C     YPOINT = ARRAY OF Y COORDINATES OF POINTS TO BE PLOTTED.
C     KRDBGN = SUBSCRIPT OF FIRST POINT TO BE PLOTTED.
C     KRDEND = SUBSCRIPT OF FINAL POINT TO BE PLOTTED.
C     XFIRST = X COORDINATE TO BE PLACED AT LEFT BORDER OF PLOT AREA.
C     YFIRST = Y COORDINATE TO BE PLACED AT LOWER BORDER OF PLOT AREA.
C     XFINAL = Y COORDINATE TO BE PLACED AT RIGHT BORDER OF PLOT AREA.
C     YFINAL = Y COORDINATE TO BE PLACED AT UPPER BORDER OF PLOT AREA.
C     XWIDTH = HORIZONTAL WIDTH OF PLOT AREA.
C     YWIDTH = VERTICAL HEIGHT OF PLOT AREA.
C     XCORNR = X DISTANCE FROM PLOTTING TABLE ORIGIN TO LEFT PLOT EDGE.
C     YCORNR = Y DISTANCE FROM PLOTTING TABLE ORIGIN TO LOWER PLOT EDGE.
C     RELHIT = LENGTH OF DASHES IN UNITS OF MAGNITUDE 0.02*YWIDTH.
C     RELSPC = LENGTH OF SPACES IN UNITS OF MAGNITUDE 0.02*YWIDTH.
C     LASTX  = LAST X GRID COORDINATE PLOTTED.
C     LASTY  = LAST Y GRID COORDINATE PLOTTED.
C
      DIMENSION XPOINT(1000),YPOINT(1000)
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      MODE = IFREER
      XSCALE=FACTOR*XWIDTH/(XFINAL-XFIRST)
      YSCALE=FACTOR*YWIDTH/(YFINAL-YFIRST)
      XMIN=FACTOR*XCORNR + OFSETX
      YMIN=FACTOR*YCORNR + OFSETY
      XMAX=XMIN+(FACTOR*XWIDTH)
      YMAX=YMIN+(FACTOR*YWIDTH)
      DASH=RELHIT*FACTOR*YWIDTH/50.0
      SPACE=RELSPC*FACTOR*YWIDTH/50.0
      LINE=-1
      THISX=XMIN+(XSCALE*(XPOINT(KRDBGN)-XFIRST))
      THISY=YMIN+(YSCALE*(YPOINT(KRDBGN)-YFIRST))
      KRD=KRDBGN
C
C     ***********************ENTER PLOTTING LOOP************************
    1 KRD=KRD+1
      IF(KRD-KRDEND)2,2,32
    2 THATX=THISX
      THATY=THISY
      THISX=XMIN+(XSCALE*(XPOINT(KRD)-XFIRST))
      THISY=YMIN+(YSCALE*(YPOINT(KRD)-YFIRST))
      STARTX=THATX
      HALTX=THISX
      DISTX=THISX-THATX
      DISTY=THISY-THATY
C
C     *******************TEST HORIZONTAL COORDINATES********************
      IF(STARTX-XMIN)3,4,4
    3 STARTX=XMIN
      LINE=-1
      IF(HALTX-XMIN)1,8,8
    4 IF(STARTX-XMAX)6,6,5
    5 STARTX=XMAX
      LINE=-1
      IF(HALTX-XMAX)6,6,1
    6 IF(HALTX-XMIN)7,8,8
    7 HALTX=XMIN
      GO TO 10
    8 IF(HALTX-XMAX)10,10,9
    9 HALTX=XMAX
   10 IF(ABS(DISTX)-0.1)11,12,12
   11 STARTY=THATY
      HALTY=THISY
      GO TO 13
   12 STARTY=THATY+((DISTY*(STARTX-THATX))/DISTX)
      HALTY=THISY-((DISTY*(THISX-HALTX))/DISTX)
C
C     ********************TEST VERTICAL COORDINATES*********************
   13 IF(STARTY-YMIN)14,15,15
   14 STARTY=YMIN
      LINE=-1
      IF(HALTY-YMIN)1,19,19
   15 IF(STARTY-YMAX)17,17,16
   16 STARTY=YMAX
      LINE=-1
      IF(HALTY-YMAX)17,17,1
   17 IF(HALTY-YMIN)18,19,19
   18 HALTY=YMIN
      GO TO 21
   19 IF(HALTY-YMAX)21,21,20
   20 HALTY=YMAX
   21 IF(ABS(DISTY)-0.1)23,22,22
   22 STARTX=THATX+((DISTX*(STARTY-THATY))/DISTY)
      HALTX=THISX-((DISTX*(THISY-HALTY))/DISTY)
C
C     **************************PROVIDE SPACE***************************
   23 IF(LINE)27,24,28
   24 DISTX=HALTX-STARTX
      DISTY=HALTY-STARTY
      DIST=SQRT((DISTX*DISTX)+(DISTY*DISTY))
      IF(DIST-0.01)1,1,25
   25 REMAIN=REMAIN-DIST
      IF(REMAIN)26,26,1
   26 STARTX=HALTX+(REMAIN*DISTX/DIST)
      STARTY=HALTY+(REMAIN*DISTY/DIST)
   27 NEWX=STARTX
      NEWY=STARTY
      REMAIN=DASH
      LINE=1
      CALL PENUP (LASTX,LASTY,NEWX,NEWY)
C
C     ****************************PLOT DASH*****************************
   28 DISTX=HALTX-STARTX
      DISTY=HALTY-STARTY
      DIST=SQRT((DISTX*DISTX)+(DISTY*DISTY))
      IF(DIST-0.01)1,1,29
   29 REMAIN=REMAIN-DIST
      IF(REMAIN)30,30,31
   30 STARTX=HALTX+(REMAIN*DISTX/DIST)
      STARTY=HALTY+(REMAIN*DISTY/DIST)
      NEWX=STARTX
      NEWY=STARTY
      REMAIN=SPACE
      LINE=0
      CALL PENDWN(LASTX,LASTY,NEWX,NEWY)
      GO TO 24
   31 NEWX=HALTX
      NEWY=HALTY
      CALL PENDWN(LASTX,LASTY,NEWX,NEWY)
      GO TO 1
   32 RETURN
      END
