      SUBROUTINE PLOT(XPAGE,YPAGE,KODE)
C
C     ROUTINE TO SIMULATE STANDARD CALCOMP ENTRY FOR
C     USE WITH HARVARDS PDP-10 TO PDP-1 LINK
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERSITY
C
      DIMENSION KOMAND(12)
      DATA KOMAND/10,2,6,8,0,4,9,1,5,32,16,63/
C
C     THE CALCOMP PLOTTER IS CAPABLE OF MOTIONS IN THE
C     LEFT, RIGHT, UP OR DOWN DIRECTIONS OR COMBINATIONS
C     OF THESE ONLY.
C
C     UNIT MOTIONS ARE TRANSLATED TO UNIQUE NUMBERS
C     FOR USE IN THE LOOK-UP ARRAY KOMAND BY THE FORMULA
C     SUBSCRIPT=3*(1-Y)+X+2
C
C     THIS GIVES THE VALUES AT LEFT WHICH ARE TRANSLATED
C     BY THE KOMAND LOOK-UP ARRAY TO THOSE AT RIGHT.
C
C             2                          2
C       1     .     3             10     .     6
C         .   .   .                  .   .   .
C           . . .                      . . .
C     4 . . . 5 . . . 6          8 . . . 0 . . . 4
C           . . .                      . . .
C         .   .   .                  .   .   .
C       7     .     9              9     .     5
C             8                          1
C
C     LOCATIONS KOMAND(10) THROUGH KOMAND(12) ALSO
C     CONTAIN THE HARVARD REQUIRED CODES FOR RAISING PEN,
C     LOWERING PEN, AND DUMPING BUFFER RESPECTIVELY.
C
C     FORCE PEN TO START AT ORIGIN
      DATA LASTX,LASTY,IKODE/0,0,0/
C
C     INITIATE PLOT IF THIS IS FIRST POINT
      IF(IKODE.GT.3)RETURN
      IF(IKODE.NE.0)GO TO 2
      CALL PLOTP(KOMAND(12))
      CALL PLOTP(KOMAND(10))
      DO 1 I=1,1024
    1 CALL PLOTP(KOMAND(8))
      IKODE=3
C
C     TEST IF PEN MUST BE RAISED OR LOWERED
    2 IF(KODE.GE.0)GO TO 3
      IF(IKODE.GT.0)LASTX=LASTX-1023
      IKODE=-3
      RETURN
    3 IF(KODE.EQ.IKODE)GO TO 7
      IF(KODE.NE.2)GO TO 4
      CALL PLOTP(KOMAND(11))
      GO TO 7
    4 IF(KODE.NE.3)GO TO 5
      CALL PLOTP(KOMAND(10))
      GO TO 7
    5 CALL PLOTP(KOMAND(10))
      MOVEY=-LASTY
      IF(IKODE.LT.0)GO TO 6
      MOVEX=1023-LASTX
      GO TO 8
    6 MOVEX=-LASTX
      GO TO 8
C
C     CHANGE FLOATING COORDINATES TO INTEGER VECTOR
    7 NOWX=100.0*XPAGE
      NOWY=100.0*YPAGE
      MOVEX=NOWX-LASTX
      MOVEY=NOWY-LASTY
    8 IKODE=KODE
C
C     DETERMINE DIRECTION OF VECTOR
      JUMPX=MOVEX
      JUMPY=MOVEY
      MODX=1
      MODY=1
      IF(MOVEX)9,13,10
    9 JUMPX=-MOVEX
      MODX=-1
   10 IF(MOVEY)11,16,12
   11 JUMPY=-MOVEY
      MODY=-1
   12 IF(JUMPX-JUMPY)19,17,22
C
C     VECTORS MADE UP OF SINGLE UNIT VECTOR TYPE
   13 MODX=0
      IF(MOVEY)14,25,15
   14 JUMPX=-JUMPY
      MODY=-1
      GO TO 17
   15 JUMPX=JUMPY
      GO TO 17
   16 MODY=0
   17 INDEX=3*(1-MODY)+MODX+2
      INDEX=KOMAND(INDEX)
      DO 18 J=1,JUMPX
   18 CALL PLOTP(INDEX)
      GO TO 25
C
C     VECTOR LONGEST IN VERTICAL DIRECTION
   19 LAG=(MODX*JUMPY)/2
   20 LST=0
      DO 21 J=1,JUMPY
      MODX=((J*MOVEX)+LAG)/JUMPY
      INDEX=(3*(1-MODY))+MODX-LST+2
      CALL PLOTP(KOMAND(INDEX))
   21 LST=MODX
      GO TO 25
C
C     VECTOR LONGEST IN HORIZONTAL DIRECTION
   22 LAG=(MODY*JUMPX)/2
   23 LST=0
      DO 24 J=1,JUMPX
      MODY=((J*MOVEY)+LAG)/JUMPX
      INDEX=(3*(1-MODY+LST))+MODX+2
      CALL PLOTP(KOMAND(INDEX))
   24 LST=MODY
   25 LASTX=NOWX
      LASTY=NOWY
      IF(IKODE.GT.3)CALL PLOTP(KOMAND(12))
      RETURN
      END
