      SUBROUTINE AROPLT(X1,Y1,X2,Y2,XFIRST,YFIRST,XFINAL,YFINAL,
     1XWIDTH,YWIDTH,XCORNR,YCORNR,ITAIL,IHEAD,RELHIT,RELSPC,
     2RELARO,LASTX,LASTY)
C
C     DONALD E. BARTH, CHEMISTRY DEPT., HARVARD UNIVERSITY
C
C     GENPLT ROUTINE TO PLOT POSSIBLY DASHED ARROW WITH TAIL
C     AT POINT X1,Y1 AND WITH HEAD AT POINT X2,Y2.
C
C     THE ROUTINES DSHPLT, WRDPLT, AND THE ADVANCED VERSION
C     OF LTRPLT ARE REQUIRED.
C
C     ARROW CAN HAVE ONE OR MORE LETTERS CENTERED AT HEAD
C     AND TAIL.  THESE ARE SPECIFIED AS THE STRINGS IHEAD
C     AND ITAIL.  V'S AT BOTH ENDS WOULD GIVE A DOUBLE HEADED
C     ARROW.  EACH STRING MUST BE TERMINATED BY A DOLLAR SIGN
C     BLANK COMBINATION OR BY SOME OTHER DOLLAR SIGN COMMAND
C     WHICH WOULD SPECIFY THE END OF THE STRING TO BE PLOTTED.
C     IF NO TERMINATION COMMAND IS PRESENT WITHIN THE STRING,
C     A MAXIMUM OF 72 LETTERS WILL BE PLOTTED.
C
C     A BAR CAN BE PLOTTED AT ENDS OF ARROW AS A SUBSCRIPT
C     MINUS SIGN.  IT MUST BE REMEMBERED THAT THE WIDTH OF
C     A CHARACTER IS USUALLY 2/3RDS OF ITS HEIGHT.  TO
C     GET BARS WITH WIDTH EQUAL TO HEIGHT OF OTHER LETTERS,
C     THE STRING '$)$--$ ' WOULD BE USED.
C
C     SUBROUTINE AROPLT ARGUMENT LIST DEFINITIONS.
C
C     X1     = HORIZONTAL DATA COORDINATE OF TAIL OF ARROW
C     Y1     = VERTICAL DATA COORDINATE OF TAIL OF ARROW
C     X2     = HORIZONTAL DATA COORDINATE OF HEAD OF ARROW
C     Y2     = VERTICAL DATA COORDINATE OF HEAD OF ARROW
C     XFIRST = HORIZONTAL DATA COORDINATE TO BE PLACED
C              AT LEFT BORDER OF PLOT AREA.
C     YFIRST = VERTICAL DATA COORDINATE TO BE PLACED
C              AT LOWER BORDER OF PLOT AREA.
C     XFINAL = HORIZONTAL DATA COORDINATE TO BE PLACED
C              AT RIGHT BORDER OF PLOT AREA.
C     YFINAL = VERTICAL DATA COORDINATE TO BE PLACED
C              AT UPPER BORDER OF PLOT AREA.
C     XWIDTH = HORIZONTAL WIDTH OF PLOT AREA.
C     YWIDTH = VERTICAL HEIGHT OF PLOT AREA.
C     XCORNR = HORIZONTAL DISTANCE FROM PLOTTING TABLE
C              ORIGIN TO LEFT PLOT EDGE.
C     YCORNR = VERTICAL DISTANCE FROM PLOTTING TABLE
C              ORIGIN TO LOWER PLOT EDGE.
C     IHEAD  = ARRAY CONTAINING LETTER OR LETTERS TO
C              BE PLOTTED AT ARROW HEAD.
C     RELHIT = LENGTH OF DASHES ALONG STEM OF ARROW
C              IN UNITS OF MAGNITUDE 0.02*YWIDTH.
C     ITAIL  = ARRAY CONTAINING LETTER OR LETTERS TO
C              BE PLOTTED AT ARROW TAIL.
C     RELSPC = LENGTH OF SPACES ALONG STEM OF ARROW
C              IN UNITS OF MAGNITUDE 0.02*YWIDTH.
C     RELARO = HEIGHT OF LETTER AT END OF ARROW
C              IN UNITS OF MAGNITUDE 0.02*YWIDTH.
C     LASTX  = LAST X GRID COORDINATE PLOTTED.
C     LASTY  = LAST Y GRID COORDINATE PLOTTED.
C
      DIMENSION XDMY(2),YDMY(2),IHEAD(1),ITAIL(1)
C
C     CALCULATE ANGLE OF ENDS OF ARROW
      HEIGHT=0.02*YWIDTH*RELARO
      AX1=XCORNR+((XWIDTH*(X1-XFIRST))/(XFINAL-XFIRST))
      AY1=YCORNR+((YWIDTH*(Y1-YFIRST))/(YFINAL-YFIRST))
      AX2=XCORNR+((XWIDTH*(X2-XFIRST))/(XFINAL-XFIRST))
      AY2=YCORNR+((YWIDTH*(Y2-YFIRST))/(YFINAL-YFIRST))
      AX=AX2-AX1
      AY=AY2-AY1
      IF(AX.GT.AY)GO TO 1
      IF(AX.LT.(-AY))GO TO 3
      GO TO 2
    1 IF(AX.LT.(-AY))GO TO 4
C
C         *
C        **
C       ***   (RIGHT QUADRANT)
C        **
C         *
C
      IF(0.00001.GT.AX)GO TO 5
      INDIC=270.0+(ATAN(AY/AX)/0.0174532925)
      GO TO 6
C
C     *****
C      ***    (UPPER QUADRANT)
C       *
C
    2 IF(0.00001.GT.AY)GO TO 5
      INDIC=-(ATAN(AX/AY)/0.0174532925)
      IF(INDIC.LT.0)INDIC=INDIC+360
      GO TO 6
C
C     *
C     **
C     ***     (LEFT QUARDRANT)
C     **
C     *
C
    3 IF(-0.00001.LT.AX)GO TO 5
      INDIC=90.0+(ATAN(AY/AX)/0.0174532925)
      GO TO 6
C
C       *
C      ***    (LOWER QUADRANT)
C     *****
C
    4 IF(-0.00001.LT.AY)GO TO 5
      INDIC=180.0-(ATAN(AX/AY)/0.0174532925)
      GO TO 6
C
C       *     (ZERO LENGTH ARROW)
C
    5 INDIC=0
C
C     PLOT TAIL OF ARROW AT AX1, AY1
    6 CALL WRDPLT(INDIC,1,1,ITAIL,1,72,HEIGHT,AX1,AY1,
     1LASTX,LASTY)
C
C     PLOT THE STEM OF THE ARROW
      XDMY(1)=AX1
      YDMY(1)=AY1
      XDMY(2)=AX2
      YDMY(2)=AY2
      AX=RELHIT*YWIDTH
      AY=RELSPC*YWIDTH
      CALL DSHPLT(XDMY,YDMY,1,2,0.0,0.0,1.0,1.0,
     11.0,1.0,0.0,0.0,AX,AY,LASTX,LASTY)
C
C     PLOT HEAD OF ARROW AT AX2, AY2
      INDIC=INDIC-180
      IF(INDIC.LT.0)INDIC=INDIC+360
      CALL WRDPLT(INDIC,1,1,IHEAD,1,72,HEIGHT,AX2,AY2,
     1LASTX,LASTY)
      RETURN
      END
