C	****PROGRAM: TALK8F.F4, APRIL 1969 ****
C
C
C	BY PETER LEMKIN AND ALAN CHAUVENET* 
C	NATIONAL INSTITUTES OF HEALTH
C	BETHESDA, MD. 20014
C
C
C	*(NOW AT DUKE UNIV, DURHAM, N.C.)
C
C
C
C INTRODUCTION:
C -------------
C THE ASSEMBLY OF LARGE PROGRAMS FOR SMALL MACHINES SUCH AS
C THE PDP8 IS APT TO BE LABORIOUS, TIME CONSUMING AND ALMOST
C IMPOSSIBLE IS DONE ON THE SMALL MACHINE ITSELF. IN ADDITION,
C THE ABILITY FOR MANY USERS TO ASSEMBLE PDP8 PROGRAMS ON A PDP10
C COMPUTER USING PAL10 OR PAL12 LIGHTENS THE LOAD OF SOFTWARE
C DEVELOPMENT ON THE SMALLER MACHINE. TALK8F IS A PDP10
C UTILITY PROGRAM WHICH TRANSFORMS THE OUTPUT OF ASSEMBLERS
C SUCH AS PAL10 OR PAL12 INTO A FORM AMENABLE TO DATAPHONE
C COMMUNICATION.
C
C
C
C HARDWARE REQUIRED:
C --------------------
C PDP10 WITH DATAPHONE OR HARDWARE INTERFACE
C TO A PDP8 WITH A PT08 SERIAL/PARALLEL INTERFACE.
C
C
C
C DESCRIPTION:
C -----------
C THIS PROGRAM READS A PAL10 ".BIN"  OUTPUT FILE FROM THE DISK
C AND CONVERTS IT TO A FORM OF ASCII CHARACTERS CODE.
C THIS CODE CAN BE SENT OVER THE TELEPHONE LINES AND
C INTERPRETED BY THE PDP8 "TALK10" PROGRAM RUNNING ON THE
C PDP-8.(A PUNCHED PAPER TAPE MAY BE READ INTO THE PDP8 THROUGH
C "OCTMON", A PDP8 OCTAL DEBUGGER PROGRAM, DECUS 8-298, WHICH
C ACCEPTS THIS SPECIAL CODE FORMAT.)
C THE PAL10 BINARY OUTPUT FILE MUST BE  ON THE USER'S DSK AREA.
C A  ".DAT" FILE, NAMED BY THE USER, WILL BE GENERATED AND WRITTEN
C IN THE USER'S DISK AREA . HE MAY THEN PIP IT TO HIS TELETYPE (TTY).
C (I.E. TO HIS BUFFERED PDP8 TTY THROUGH THE PDP8 TALK10 PROGRAM WHICH
C IS INTERFACED TO THE PDP10 THROUGH THE PT08.).
C THE BEGINNING AND END OF THE ".DAT" FILE CONTAIN STRINGS OF A'S
C WHICH ARE USED TO ENTER AND LEAVE THE TALK10 "OCTLDR" MODE.
C IF THE USER IS TALKING TO THE PDP10 VIA TALK10, SENDING THE ".DAT"
C FILE WILL LOAD IT INTO THE PDP8 MEMORY.
C
C
C
C
C
C
C CODING OF THE PAL10 BINARY OUTPUT FILE:
C ---------------------------------------
C THE "FIELD" CODE IS CONVERTED TO A 4 DIGIT NUMBER FOLLOWED BY "F".
C THE "MEMORY LOCATION" CODE IS CONVERTED TO A 4 DIGIT OCTAL NUMBER
C FOLLOWED BY A "Z". THIS IS THE LOCATION WHERE THE NEXT DATUM WILL
C BE PUT. THE "DATA" CODE IS CONVERTED TO A 4 DIGIT OCTAL NUMBER
C FOLLOWED BY A CARRIAGE RETURN. THE LEADER TRAILER CODE IS USED TO
C SIGNAL TALK8F THAT THE BEGINNING AND END OF THE FILE IS REACHED.
C
C
C
C
C
C COMPILING THE SOURCES:
C -------------------------
C NOTE: (1) TO COMPILE TALK8F,  COMPILE TALK8F.F4 AND READPL.MAC .
C       (2) LOAD TALK8F.REL AND READPL.MAC TOGETHER.
C	(3) DO A SAVE DSK:TALK8F.SAV TO GET THE ".SAV" FILE .
C
C
C
C
C
C EXAMPLE OF TALK8F/TALK10 OPERATION
C ------------------------------------
C EXAMPLE: (IT IS ASSUMED THAT THE USER IS TALKING TO THE PDP10
C FROM THE PDP8 TTY <==> (PDP8 PROGRAM "TALK10") <==> PT08 <==> PDP10.
C	EXAMPLE:
C	--------
C	 (1) ASSEMBLE THE PDP8 SOURCE FILE PDP8.SRC USING PAL10
C	    .R PAL10
C	    *PDP8.BIN,PDP8.LST_PDP8.SRC
C	   *^C
C	   .
C	   (2) NOW CONVERT THE PDP8.BIN FILE TO THE ASCII CODE FILE.
C	   .RUN DSK:TALK8F.SAV
C	   INPUT FILE:PDP8
C	   EXTENSION?:BIN
C	   OUTPUT FILE:PDP8
C
C	   YOU MAY NOW PIP PDP8.DAT FROM YOUR DISK AREA.
C	   EXIT
C	   .
C
C	 (3) NOW TRANSMIT THE ASCII "PDP8.DAT" FILE TO THE PDP8 TO BE
C	    LOADED INTO THE PDP8 MEMORY BY THE TALK10 PROGRAM.
C	  .R PIP
C	  *TTY:_DSK:PDP8.DAT
C	  *
C	 (4) THE ".DAT" FILE CONTAINS A STRING OF A'S  IN THE BEGINNING
C	   AND END OF THE FILE. THESE ARE USED TO TURN ON AND OFF THE
C	   PDP8'S TALK10 PROGRAM LOADER SUBPROGRAM CALLED  "OCTLDR".
C	   AFTER THE REST OF THE   A'S HAVE BEEN TYPED OUT, THE PROGRAM
C	   IS NOW LOADED INTO THE   PDP8 MEMORY AND TALK10 IS
C	   IN BUFFERED TELETYPE MODE AGAIN.

C          NOTE: A PROGRAM MAY BE LOADED INTO ANY PDP8 FIELD AS TALK8F
C	   WILL DO FIELD CONVERSIONS FOR ANY FIELD AND TALK10 WILL LOAD
C	   INTO ANY FIELD. TALK10 DOES NOT PREVENT DESTROYING ITSELF
C	   BY LOADING INTO ITS OWN CORE IMAGE.

C
C
C
C
C
C
C

C
C
C	**************************************************************
C
C
	IMPLICIT INTEGER(A-Z)
	COMMON /ZEEP/  HOLDA(129),SAVE(2)
       COMMON /S8BUF/ D1,D2,D3,HOLD(128)
       DATA CHECK,SUB,SUBF/"77,"100,"300/
C SETUP OUTPUT TO DISK FILE
C	SETUP THE INPUT FILE NAME IN READPL
	TYPE 1065
1065	FORMAT(' INPUT FILE:'$)
	ACCEPT 1001,FNME
1001	FORMAT(1A5)
	TYPE 1002
1002	FORMAT(' EXTENSION?:'$)
	ACCEPT 1001,EXT
	CALL CONVER(FNME)
	CALL CONVER(EXT)
C	SET UP THE OUTPUT FILE...
	TYPE 101
101	FORMAT(' OUTPUT FILE:'$)
	ACCEPT 102,PETER
102	FORMAT(1A5)
       CALL OFILE(1,PETER)
       LEAD=0
       ORIG=0
       FLD=0
       D3=50
       D1=0
       DO 5 I=1,128
5      HOLD(I)=-1
12     FORMAT(I1)
C SPECIAL INITIALIZATION FOR FIRST RECORD (SKIP LEADER)
       SAVE(1)=-1
       SAVE(2)=-1
      KEY=85+1
       J=0
C NOW GET THE NEXT RECORD FROM THE DSK:FILE WITH READPL
	ARG=0
C ROUTINE READPL--THIS WILL FILL HOLD WITH 128 WORDS (ONE DISC RECORD)
200    CALL READPL(FNME,EXT,ARG)
	PFLG=0
	IF(ARG.EQ.3) GOTO 4400
	ARG=1
       HOLDA(2)=SAVE(1)
       HOLDA(3)=SAVE(2)
       DO 225 I=1,126
225    HOLDA(I+3)=HOLD(I)
       SAVE(1)=HOLD(127)
       SAVE(2)=HOLD(128)
       SWITCH=0
C ALL THE ABOVE JUNK IS TO ENABLE ME TO MAKE SURE THAT THE
C CHECKSUM INFO DOES NOT GET SENT TO THE OUTPUT FILE.
C  NOW WE BEGIN PROCESSING THE RECORD
       DO 600 I=KEY,129,1
C NOW IF WE ARE LOOKI5G AT SECOND OF A PAIR WE WANT TO JUMP AND
C BUMP THE INDEX BECAUSE WE'VE ALREADY PROCESSED THE PAIR
       IF (SWITCH .EQ. 1) GO TO 598
C IF WE SEE TRAILER IN OUR IMMEDIATE FUTURE, WE ARE NOW LOOKING
C AT THE CHECKSUM, SO WE'RE DONE--JUMP OUT OF LOOP AND WRITE THE
C TRAILER AND CLOSE THE FILE
       IF ((I.NE.1).AND. (HOLD (I-1) .EQ. 128)) GO TO 800
C IF WE ARE LOOKING AT ORIGIN OR FIELD, JUMP. OTHERWISE WE HAVE A PAIR
C WHICH CONSTITUTE THE NEXT PDP-8 INSTRUCTION
       IF (HOLDA(I) .GT. CHECK ) GO TO 300
C NOW PROCESS THE INSTRUCTION PAIR
       OUTP= HOLDA(I)*64 + HOLDA(I+1)
C AND WRITE IT OUT
227       IF (LEAD .EQ. 0) GO TO 250
       IF ((ORIG .EQ. 1) .AND. (FLD .EQ. 0)) GO TO 280
       IF ((ORIG .EQ. 1) .AND. (FLD .EQ. 2)) GO TO 285
       IF ((ORIG .EQ. 0) .AND. (FLD .EQ. 1)) GO TO 290
       IF ((ORIG .EQ. 2) .AND. (FLD .EQ. 1)) GO TO 295
230   WRITE(1,2000)OUTP
2000   FORMAT (O4)
       GO TO 597
250    LEAD=1
      IF((ORIG.EQ.1).AND.(FLD.EQ.0))WRITE(1,2001)OUTOR,OUTP
2001  FORMAT (40HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA,O4,1HZ,O4)
      IF((ORIG.EQ.1).AND.(FLD.EQ.2))WRITE(1,2002)OUTOR,OUTFL,OUTP
2002  FORMAT (40HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA,O4,1HZ,O4,1HF,
     1O4)
      IF((ORIG.EQ.0).AND.(FLD.EQ.1))WRITE(1,2003)OUTFL,OUTP
2003  FORMAT (40HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA,O4,1HF,O4)
      IF((ORIG.EQ.2).AND.(FLD.EQ.1))WRITE(1,2004)OUTFL,OUTOR,OUTP
2004  FORMAT (40HAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA,O4,1HF,O4,1HZ,
     1O4)
      IF((ORIG.EQ.0).AND.(FLD.EQ.0)) GO TO 230
      ORIG=0
      FLD=0
      GO TO 597
280    WRITE (1,2005)OUTOR,OUTP
2005   FORMAT (O4,1HZ,O4)
       ORIG=0
       GO TO 597
285    WRITE (1,2006)OUTOR,OUTFL,OUTP
2006   FORMAT (O4,1HZ,O4,1HF,O4)
       ORIG=0
       FLD=0
       GO TO 597
290    WRITE (1,2007)OUTFL,OUTP
2007   FORMAT (O4,1HF,O4)
       FLD=0
       GO TO 597
295    WRITE (1,2008)OUTFL,OUTOR,OUTP
2008   FORMAT (O4,1HF,O4,1HZ,O4)
       FLD=0
       ORIG=0
       GO TO 597
C COME HERE TO SEE WHETHER FIELD OR ORIGIN
300    TEST=HOLDA(I)/64
C IF ORIGIN GO TO 301, IF FIELD GO TO 500. IF 200--LEADER-TRAILER
C SHOULD HAVE BEEN CAUGHT ABOVE AND THERE IS AN ERROR
       IF (TEST-2) 301,400,500
C COME HERE IF ORIGIN
301    OUTOR= HOLDA(I) -SUB
       OUTOR = 64*OUTOR + HOLDA (I+1)
       ORIG=FLD+1
       GO TO 597
400    WRITE (5,4000)
4000   FORMAT (' ERROR IN PAL10 READ--UNDETECTED LEADER-TRAILER')
       GO TO 900
C  COME HERE FOR FIELD DEFN
500    OUTFL = HOLDA(I) -SUBF
       OUTFL = OUTFL/8
       FLD=ORIG+1
       GO TO 599
597    SWITCH=1
	IF(I.NE.127) GOTO 599
	PFLG=1
	GOTO 601
598    SWITCH=0
599    CONTINUE
600    CONTINUE
C NOW GO BACK AND READ THE NEXT RECORD
601    KEY=2
	IF(PFLG.EQ.0) GOTO 200
	HOLDA(1)=HOLDA(129)
	KEY=1
	GOTO 200
C NOW WRITE OUT TRAILER AND CLOSE THE FILE
800    WRITE (1,1000)
1000   FORMAT ('AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA')
801    WRITE (5,8000) PETER
8000   FORMAT (' YOU MAY NOW PIP ',1A5,'.DAT FROM YOUR DISK AREA.')
C COME DIRECTLY HERE WHEN L-T ERROR FOUND AT 400
900    END FILE 1
       STOP
4400	TYPE 4401
4401	FORMAT(' ERROR IN DSK READ OF INPUT FILE (READPL) '//)
	CALL EXIT
       END
                                                                                                                                                                                  
