program uptime;
{this program prints data for Crash and Uptime reports}

const
  week = 10080;  {number of min. in a week that you are open}
  contract = 4800;  {number of contract min. in a week}
var
  down_out,  {time down out of contract, min}
  down_in,  {time down in contract, min}
  system,  {system test time, min}
  pm,   {PM time, min}
  new
	:integer;

{reads a number, with MM being min, or HH:MM hours and min}
{returns -1 for a blank line}
function gettime:integer; (* time in minutes *)
 var hr,min:integer;
 begin
1:
 hr := 0; min := 0;
 readln(tty);
 if eoln(tty)
   then gettime := -1
   else begin
   if not (tty^ in ['0'..'9'])
     then begin
     writeln(tty,'Please type an amount of time, as MM or HH:MM');
     goto 1
     end;
   read(tty,min);
   if tty^ = ':'
     then begin 
     get(tty);
     hr := min;
     if not (tty^ in ['0'..'9'])
       then begin
       writeln(tty,'Please type an amount of time, as MM or HH:MM');
       goto 1
       end;
     read(tty,min);
     if min > 59
       then begin
       writeln(tty,'Minutes can''t be > 59');
       goto 1
       end
     end;
   if not eoln(tty)
     then writeln(tty,'Junk at end of line, ignored');
   gettime := 60*hr + min
   end
 end;

{getlist gets a list of times and returns the sum}
procedure getlist(var v:integer);
 var new:integer;
 begin
 v := 0;
  loop
  new := gettime;
  exit if new < 0;
  v := v + new
  end
 end;

{puttime writes minutes in the format HH:MM}
procedure puttime(min:integer);
 var hr:integer;
 begin
 hr := min div 60;
 min := min mod 60;
 write(tty,hr:1,':');
 if min < 10 then write(tty,'0');
 writeln(tty,min:1)
 end;

begin
writeln(tty,'Terminate lists with <CR>; numbers are min or hr:min');
writeln(tty,'PM time:'); getlist(pm);
writeln(tty,'System time:'); getlist(system);
writeln(tty,'Down in contract:'); getlist(down_in);
writeln(tty,'Down out of contract:'); getlist(down_out);
write(tty,'Uptime:  '); puttime(week - pm - system - down_in - down_out);
write(tty,'Downtime:  '); puttime(down_in + down_out);
write(tty,'System:  '); puttime(system);
write(tty,'PM:  '); puttime(pm);
writeln(tty,'% down:  ',(down_in + down_out)*100/week:0:2);
writeln(tty,'% uptime:  ',(week  - pm - system - down_in - down_out)*100/(week  - pm - system):0:2);
writeln(tty,'% contract uptime:  ',(contract  - pm - system - down_in)*100/(contract  - pm - system):0:2);
end.

