;This file creates the pascal compiler.  the runtimes are never
;created from scratch - when a module changes, MAKLIB is used to
;put in the new version.

;*******************************************************************
;*   This part of the file generates the version of the compiler   *
;*   used if the EXEC knows about PASCAL. It is PASCAL.EXE in the  *
;*   distributed version.					   *
;*******************************************************************

;We assume pascal is known to your EXEC in the following line.  If
;not, you will have to run it explicitly, or use PAS, and decide
;for yourself when to recompile.

;Compile all source files except ones supplied by DEC in .REL form

COMPILE PASCMP.PAS,PASSCN.MAC,PASLNK.MAC

;LINK the program using PASCAL.CCL.  Note that this assumes PASLIB.REL
;is in SYS:.  If it isn't, or if you want to use a different version,
;you should load it explicitly.

LINK
 @PASCAL
;PASLIB/SEA	;example of loading from your own PASLIB instead of SYS:
/G

;In some cases it is necessary to create some working storage for
;the emulator.  If this were necessary, the command would be
;D 44 164777	
;Try that if you get an ill mem ref.  With the current source it
;should not be needed.

;Save the results with whatever name you want.  We use PASCAL.EXE.

SAVE PASCAL

;*******************************************************************
;*   The following generates the version of the PASCAL compiler    *
;*   that RESCAN's the command line, for systems that do not 	   *
;*   install PASCAL in their EXEC.  This is PAS.EXE in the         *
;*   distributed version.					   *
;*******************************************************************

;Be sure all the files are compiled.  PASCMP.PAS is listed again to make
;this part of the file self-contained.  Both versions of the compiler
;use the same PASCMP.  If your EXEC doesn't know about PASCAL, you will
;have to compile PASLNX and PASCMP by running the compiler explicitly.

COMPILE PASLNX.PAS,PASCMD.MAC,PASCMP.PAS,PASLNY.MAC,STRING.MAC

;Now link them, using PAS.CCL.  This assumes that PASLIB.REL is on SYS:.
;If not, or you want to use your own version, you will have to mention
;it explicitly.

LINK
 @PAS
;PASLIB/SEA	;example of loading from PASLIB explicitly
/G

;Save it with your favorite name.  We use PAS in the distribution.

SAVE PAS

