      SUBROUTINE RSMHLP(ITTY,KNDMSG,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
C     RENBR(/RESUME, ISSUE INSTRUCTIONS)/M:99999
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS ROUTINE IS PART OF THE STUDENT RESUME SYSTEM
C
C     THIS VERSION USES ' RATHER THAN H NOTATION FOR THE
C     CHARATERS WHICH ARE TO BE TYPED USING THE FORMAT
C     STATEMENTS.  IT WAS PRODUCED BY INSERTING A .USE'
C     COMMAND INTO THE START OF THE FILE PROCESSED BY THE
C     FORMAT PROGRAM.
C
C     ITTY   = UNIT NUMBER FOR READING AND WRITING TO TERMINAL
C     KNDMSG = SELECTS WHICH MESSAGE IS TO BE ISSUED
C     LTRBFR = RETURNED WITH COMMAND TYPED BY USER IF THE
C              MESSAGE IS LONGER THAN 1 SCREEN.
C     LMTBFR = MAXIMUM NUMBER OF CHARACTERS IN COMMAND TYPED
C              BY THE USER
C     MAXBFR = RETURNED WITH NUMBER OF CHARACTERS TYPED BY THE
C              USER IF MESSAGE IS LONGER THAN 1 SCREEN
C     IVIDEO = SELECTS WHETHER SCREEN IS CLEARED
C            = -1, PAPER OUTPUT, DO NOT ISSUE FORM FEEDS
C            = 0, SCROLLING VIDEO, DO NOT ISSUE FORM FEEDS
C            = 1, CLEAR SCREEN AT START AND IN MIDDLE OF LONG
C              MESSAGES.
C            = 2, DO NOT CLEAR SCREEN AT START, BUT DO CLEAR
C              SCREEN IN MIDDLE OF LONG MESSAGES.
C
      DIMENSION LTRBFR(LMTBFR)
    1 FORMAT(1X/' (press RETURN to continue)',$)
    2 FORMAT(1A1)
    3 FORMAT(1X)
      MAXBFR=0
C
C     INDICATE IF ISSUE FORM FEEDS AFTER FULL SCREENS
      IF(IVIDEO.LE.0)GO TO 8
C
C     IF ON VIDEO TERMINAL AND ARE GOING TO ISSUE MULTIPLE
C     PAGES, THEN ISSUE FORM FEED THAT PUTS NEXT TYPING ON
C     TOP LINE OF THE SCREEN.
      IF(IVIDEO.EQ.1)CALL RSMWIP(ITTY)
    8 CONTINUE
C
C     TRANSFER TO WRITE STATEMENT FOR DESIRED MESSAGE
      GO TO(
     1  100, 200, 300, 400, 500, 600, 700, 800, 900,   6,
     2 1100,1200,1300,   6,   6,   6,1700,   6,   6,   6,
     3 2100,2200,2300,2400,2500,2600,2700,2800,2900,3000,
     4 3100,3200,3300,3400,3500,3600,3700,3800,3900,4000,
     5 4100,4200,4300,4400,4500,4600,4700,4800,4900,5000,
     6 5100,5200,5300,5400,5500,5600,5700,5800,5900,6000,
     7 6100,6200,6300,6400,6500,6600,6700,6800,6900,7000,
     8 7100,7200,7300),KNDMSG
      GO TO 6
C
C     ***********************
C     *                     *
C     *  THE HELP MESSAGES  *
C     *                     *
C     ***********************
C
C     COMPLETE DESCRIPTION
      GO TO 5
  100 CONTINUE
      WRITE(ITTY,101)
  101 FORMAT(' This program is a very simple editor for r',
     1'esumes.  You can run  the  program  as'/' many  ti',
     2'mes  as  are necessary to type in and revise the c',
     3'ontents of the resume.'/' The program is meant to ',
     4'be usable even if you do not have any previous  co',
     5'mputer'/' experience.  If you do not know what to ',
     6'do at any point, the program will supply'/' instru',
     7'ctions if you will press the ? key without typing ',
     8'anything else, and  then'/' press the RETURN key.'/)
      WRITE(ITTY,102)
  102 FORMAT(' The resume is divided into sections, with ',
     1'lines being ruled between these.   You'/' will  fi',
     2'rst  be  asked  to specify the information to be i',
     3'n the name and address'/' sections and in the educ',
     4'ation section.  In the name and  address  sections',
     5',  you'/' will  be  asked  to  specify  specific  ',
     6'information.   The  initial lines of the'/' educat',
     7'ion section are standardized, although you will be',
     8'  able  to  change  them')
      WRITE(ITTY,103)
  103 FORMAT(' later.   After showing the standardized po',
     1'rtion to you, the program will ask for'/' you to s',
     2'upply any additional information which you want to',
     3' have in the education'/' section.   You  will  no',
     4't be asked for any specific information in the edu',
     5'cation'/' section or in any later sections, the in',
     6'formation which you supply is up to you.'//' After',
     7' you have finished with the education section,  yo',
     8'u  will  be  asked  "What')
      WRITE(ITTY,104)
  104 FORMAT(' next?" You will repeated return to this qu',
     1'estion when you have finished entering'/' or modif',
     2'ying portions of your resume.  You can enter the t',
     3'ext of a  new  section'/' by  typing  the  word  C',
     4'REATE  in response to the "What next?" request, an',
     5'd then'/' naming the new section when asked to do ',
     6'so.  You can name  the  section  in  any')
      IF(IVIDEO.LT.0)GO TO 105
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  105 CONTINUE
      WRITE(ITTY,106)
  106 FORMAT(' manner  you choose.  The program will then',
     1' ask you to type the text to be in the'/' new sect',
     2'ion.  The text within each section will be shifted',
     3' to the right  of  the'/' left  edge  of  the page',
     4'.  The name of the section will appear at the uppe',
     5'r left'/' corner of the section exactly as you typ',
     6'ed it.'//' In the education section, and in the se',
     7'ctions which you name yourself,  you  can'/' type ',
     8'as little or as much as you want on a line, the pr',
     9'ogram will accumulate the')
      WRITE(ITTY,107)
  107 FORMAT(' words into lines of approximately equal le',
     1'ngth.  If you type more than will  fit'/' across  ',
     2'the width of the screen, ignore the automatic retu',
     3'rn to the left edge of'/' the screen and just keep',
     4' on typing.  You must, however,  press  the  RETUR',
     5'N  key'/' when  you  have  finished  typing  whate',
     6'ver you want to be on the line.  You can'/' termin',
     7'ate entering text into the  section  by  pressing ',
     8' the  RETURN  key  again'/' without having typed a',
     9'nything else before it.'/)
      WRITE(ITTY,108)
  108 FORMAT(' You can erase errors immediately after you',
     1' have typed them by using the  DEL  or'/' RUBOUT  ',
     2'keys,  but  you  CANNOT  correct  errors by using ',
     3'the cursor keys (those'/' marked with arrows) or t',
     4'he BACKSPACE key.   If  you  have  already  presse',
     5'd  the'/' RETURN key, or if you have typed more th',
     6'an will fit onto one line of the screen,'/' then y',
     7'ou will have to wait until you have finished  ente',
     8'ring  the  text  in  the')
      WRITE(ITTY,109)
  109 FORMAT(' section before you can return to correct t',
     1'he errors.  At that time you can issue'/' a DRAFT ',
     2'command in response to the "What next?" request to',
     3' discover  the  number'/' of  the  line  in  error',
     4',  and then you can issue an EDIT command to corre',
     5'ct the')
      IF(IVIDEO.LT.0)GO TO 110
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  110 CONTINUE
      WRITE(ITTY,111)
  111 FORMAT(' error.'//' The following conventions are a',
     1'llowed by this program.'//' A line containing only',
     2' a * (the asterisk) produces a blank line in the r',
     3'esume.'/' A line starting with a * will be separat',
     4'e from the previous line.'/' A line starting with ',
     5'a - (the minus sign) will bear a bullet at its lef',
     6't end.'/' A line starting with a word, phrase or d',
     7'ate followed by a * and then  more  text'/' will h',
     8'ave the word, phrase or date to the left of the ma',
     9'rgin.')
      WRITE(ITTY,112)
  112 FORMAT(' A ^ character (the circumflex) in front of',
     1' a word darkens that word.'/' A _ character (the u',
     2'nderscore) in front of a word underlines that word',
     3'.'//' A single * in a line marks the location in t',
     4'he line which is to be lined up with'/' the left m',
     5'argin.  You will see the * if you issue a DRAFT co',
     6'mmand in response to'/' the "What next?" request a',
     7'fter you  have  finished  entering  the  text  in ',
     8' the'/' section, but the * will not appear in the ',
     9'final version of the resume.  The name')
      WRITE(ITTY,113)
  113 FORMAT(' of the section will appear on the same lin',
     1'e as the first line of the text in the'/' section ',
     2'unless this text also starts with a *.'//' When yo',
     3'u are viewing a lengthy batch of instructions, or ',
     4' a  rough  draft  or  a'/' proof of your resume, t',
     5'he program will pause each time the screen has fil',
     6'led and'/' instruct you to "press RETURN to contin',
     7'ue".  Typing of the  instructions  or  of')
      IF(IVIDEO.LT.0)GO TO 114
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  114 CONTINUE
      WRITE(ITTY,115)
  115 FORMAT(' the  resume will continue when you press t',
     1'he RETURN key located at the right end'/' of the k',
     2'eyboard.  If  you  want  to  cancel  the  typing  ',
     3'of  the  rest  of  the'/' instructions or of the r',
     4'est of the resume, then you can instead type the c',
     5'ommand'/' which you want to have be processed next',
     6' before pressing the RETURN key.'//' You can save ',
     7'an unfinished version of your resume by issuing an',
     8' EXIT command  in')
      WRITE(ITTY,116)
  116 FORMAT(' response  to  the  "What next?" request.  ',
     1'You can then run this program later to'/' revise o',
     2'r to add to the resume.  When you  have  produced ',
     3' the  version  of  the'/' resume  which  you  want',
     4' to have included in the collection of resumes, th',
     5'en you'/' must issue the SUBMIT command in respons',
     6'e to the  "What  next?"  request.   Your'/' resume',
     7'  will  not  be included in the collection if you ',
     8'do not select the SUBMIT'/' option.')
C
C     SHORT LIST OF WHAT NEXT OPTIONS
      GO TO 5
  200 CONTINUE
      WRITE(ITTY,201)
  201 FORMAT(' The following is a summary of the availabl',
     1'e options'//' AFTER    to insert line after anothe',
     2'r   PAPER    to get a paper copy of resume'/' ALL',
     36X,'so all sections show',11X,'PROOF    to show for',
     4'matted resume'/' APPEND   to append to a section',
     59X,'RENAME   to rename a section'/' BEFORE   to ins',
     6'ert line before another  REPLACE  to replace line'/
     7' BREAK    to break before a line',9X,'RULE     to ',
     8'break 1 section into 2')
      WRITE(ITTY,202)
  202 FORMAT(' BULLET   to begin line with bullet',6X,'SA',
     1'VE     to save resume but not exit'/' CANCEL   to ',
     2'start over',18X,'SKIP     to skip blank line befor',
     3'e line'/' CREATE   to create a new section',8X,'SU',
     4'BMIT   to submit resume when all done'/' DELETE   ',
     5'to delete a line',15X,'SWITCH   to move lines with',
     6'in a section'/' DRAFT    to show resume as you typ',
     7'ed it TYPE     to type a line'/' EDIT     to chang',
     8'e part of a line',7X,'UNRULE   to merge 2 sections',
     9' into 1'/' EXIT     to save resume and exit')
      WRITE(ITTY,203)
  203 FORMAT(' JOIN     to remove break before line    fo',
     1'llowing select terminal type'/' LENGTH   to calcul',
     2'ate length of resume  SLOW     for paper output te',
     3'rminal'/' MOVE     to move a section',14X,'FAST   ',
     4'  for video without screen clear'/' ONLY     so on',
     5'ly one section shows',6X,'PAGING   for video with ',
     6'screen clear'///' Now you can either press the ret',
     7'urn key to get a more detailed explanation,'/' or ',
     8'you can type a word in this list to perform the co',
     9'rresponding option.')
      IF(IVIDEO.LT.0)GO TO 204
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  204 CONTINUE
C
C     LONG LIST OF WHAT NEXT OPTIONS
      WRITE(ITTY,205)
  205 FORMAT(' The following is a more complete descripti',
     1'on of the available options'//' AFTER   and line n',
     2'umber to insert new line after that line'/' ALL   ',
     3'  so DRAFT and PROOF options show all sections'/' ',
     4'APPEND  and section name to append new lines to th',
     5'e end of that section'/' BEFORE  and line number t',
     6'o insert new line before that line'/' BREAK   and ',
     7'line number to cause that line not to continue pre',
     8'vious line'/' BULLET  and line number to cause tha',
     9't line to begin with bullet')
      WRITE(ITTY,206)
  206 FORMAT(' CANCEL  to cancel current resume and start',
     1' over.  This command cannot be'/9X,'abbreviated.'/
     2' CREATE  and section name to create a new section'/
     3' DELETE  and line number to delete that line'/' DR',
     4'AFT   to list current section or entire resume as ',
     5'you typed it.  PROOF option'/9X,'would show reform',
     6'atted lines.'/' EDIT    and line number to change ',
     7'part of that line.  You can insert, remove,'/9X,'c',
     8'apitalize, darken or underline words and phrases.')
      WRITE(ITTY,207)
  207 FORMAT(' EXIT    to save resume, then exit.  You ca',
     1'n revise resume later.  Use SUBMIT'/9X,'option lat',
     2'er when resume is finished.'/' JOIN    and line nu',
     3'mber to cause that line to continue previous line'/
     4' LENGTH  to calculate number of lines in resume wh',
     5'en typeset.'/' MOVE    and section name to move th',
     6'at section before another section'/)
      IF(IVIDEO.LT.0)GO TO 208
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  208 CONTINUE
      WRITE(ITTY,209)
  209 FORMAT(' ONLY    and section name so that DRAFT and',
     1' PROOF options show only that section.'/9X,'Opposi',
     2'te of ALL option.'/' PAPER   to write resume to fi',
     3'le which you can type or print later.  You will be'/
     49X,'asked which printer and type of resume you want',
     5'.'/' PROOF   to list formatted version of current ',
     6'section or entire resume.  DRAFT'/9X,'options woul',
     7'd show lines as you typed them.'/' RENAME  and sec',
     8'tion name to rename that section.  Type capitals a',
     9'nd small')
      WRITE(ITTY,210)
  210 FORMAT(9X,'letters exactly as you want them to appe',
     1'ar.'/' REPLACE and line number to replace that ent',
     2'ire line'/' RULE    and section name to create a s',
     3'ection having this name from the lower'/9X,'portio',
     4'n of an existing section.  You will be asked to id',
     5'entify the first'/9X,'line which is to be in the n',
     6'ew section.'/' SAVE    to save resume but not exit',
     7'.  You can continue to make revisions.'/' SKIP    ',
     8'and line number to skip a line before that line.')
      WRITE(ITTY,211)
  211 FORMAT(' SUBMIT  if you have completed resume.  Thi',
     1's command cannot be abbreviated.'/9X,'After issuin',
     2'g this command, the resume cannot be changed later',
     3'.'/' SWITCH  and 3 line numbers to move several li',
     4'nes within a section.  Only the'/9X,'first line nu',
     5'mber can appear to the right of the SWITCH command',
     6'.  The'/9X,'others must be typed separately.  The ',
     7'lines identified by the first and'/9X,'second numb',
     8'ers are moved to just above the line identified by',
     9' the third')
      WRITE(ITTY,212)
  212 FORMAT(9X,'number.  The first number identifies the',
     1' top line to be moved.  The'/9X,'second number ide',
     2'ntifies the bottom line to be moved.  The first an',
     3'd')
      IF(IVIDEO.LT.0)GO TO 213
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  213 CONTINUE
      WRITE(ITTY,214)
  214 FORMAT(9X,'second number would be the same if only ',
     1'1 line is to be moved.'/' TYPE    and line number ',
     2'to type that line'/' UNRULE  and section name to m',
     3'erge this section with the preceding section.'//' ',
     4'Following commands change how terminal you are usi',
     5'ng is handled by this program'//' SLOW    if runni',
     6'ng this program from a slow or hardcopy terminal'/
     7' FAST    if running this program from a fast video',
     8' terminal which cannot clear'/9X,'the screen betwe',
     9'en pages')
      WRITE(ITTY,215)
  215 FORMAT(' PAGING  if running this program from a fas',
     1't video terminal which can clear the'/9X,'screen w',
     2'hen instructed to do so by the program')
C
C     TELL USER ABOUT INITIAL CONTENTS OF RESUME
      GO TO 5
  300 CONTINUE
      WRITE(ITTY,301)
  301 FORMAT(' The first section in your resume will list',
     1' your  educational  background.   This'/' section ',
     2'is assumed to start with the following information',
     3':')
      GO TO 5
C     AT THIS POINT, THE CALLING PROGRAM WILL LIST
C     THE INITIAL CONTENTS OF THE EDUCATION SECTION.
C     THE .PAGE POSITION COMMAND BELOW MUST AGREE WITH
C     THE NUMBER OF LINES IN THE DISPLAY OF THIS SECTION.
  400 CONTINUE
      WRITE(ITTY,401)
  401 FORMAT(' The lines in the final resumes will be wid',
     1'er than  shown  here,  so  that  fewer'/' lines  m',
     2'ay  be  needed  for  this  information.  If the da',
     3'tes are wrong, you can'/' change these later using',
     4' the EDIT option.  The words which are shown  unde',
     5'rlined'/' by  circumflexs or up-arrows will be dar',
     6'ker in the final resume than the rest of'/' the te',
     7'xt.'//' Now, in response to the question mark prom',
     8'pt which  will  appear  below,  please')
      WRITE(ITTY,402)
  402 FORMAT(' type  any  additional  information  which ',
     1' is  to  be  included in the education'/' section.',
     2'  If you begin the first or any line which you typ',
     3'e with a *  (asterisk)'/' then  this  line will st',
     4'art on a new line in the resume.  If you begin the',
     5' first'/' or any line which you type with a - (min',
     6'us sign) then this line will start  with')
      IF(IVIDEO.LT.0)GO TO 403
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  403 CONTINUE
      WRITE(ITTY,404)
  404 FORMAT(' a  bullet in the resume.  If you do not be',
     1'gin the first line which you type with'/' either a',
     2' * or a -, then what you type will  be  merged  in',
     3'to  the  automatically'/' supplied  start of the e',
     4'ducation section.  If you want to continue the edu',
     5'cation'/' section by describing your areas of emph',
     6'asis, then the first line which you type'/' should',
     7' begin with a *.  If you forget to type the *, you',
     8' can later use the BREAK'/' option to insert the a',
     9'sterisk.'/)
      WRITE(ITTY,405)
  405 FORMAT(' Press the RETURN key an extra time when yo',
     1'u have typed all  of  the  information'/' which is',
     2' to be in this section.'//' You can obtain detaile',
     3'd instructions about the  conventions  used  for  ',
     4'entering'/' text  by  typing  the ? key now.  If y',
     5'ou can also review these same instructions'/' late',
     6'r, whenever you are creating or appending to a sec',
     7'tion.')
C
C     DESCRIBE ENTRY OF SECTION (KNDMSG=5)
      GO TO 5
  500 CONTINUE
      WRITE(ITTY,501)
  501 FORMAT(' The special conventions recognized by this',
     1' program are summarized below'//' *',21X,'produces',
     2' completely blank line'/' text',18X,'continues pre',
     3'vious line unless this contained only *'/' *text',
     417X,'starts new line'/' -text',17X,'starts new line',
     5' with bullet to left'/' --text',16X,'starts new li',
     6'ne indented same as if marked with bullet'/' ---te',
     7'xt',15X,'starts new line in 2nd level list with bu',
     8'llet to left'/' ----text',14X,'starts new line in ',
     9'2nd level list but without bullet'/)
      WRITE(ITTY,502)
  502 FORMAT(' Date*text',13X,'starts new line with date ',
     1'to left'/' Date*-text',12X,'starts new line with d',
     2'ate and bullet to left'/' Date*--text',11X,'starts',
     3' new line with date and indented as if with bullet'/
     4' text**right text',6X,'forces text after ** to rig',
     5'ht edge, doesn''t start new line'/' *text**right t',
     6'ext     starts new line, text after ** is forced t',
     7'o right edge'/' date*text**right text new line wit',
     8'h date to left, text after ** forced to right')
      WRITE(ITTY,503)
  503 FORMAT(' date*-text**right text new line with date ',
     1'and bullet, text after ** at right'//' ^words ^in ',
     2'^a ^phrase would darken (boldface) the words in th',
     3'e phrase'/' ^multi^national',7X,'would darken mult',
     4'i but not national'/' _words _in _a _phrase would ',
     5'underline the words in the phrase'/' _multi_nation',
     6'al',7X,'would underline multi but not national')
      IF(IVIDEO.LT.0)GO TO 504
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  504 CONTINUE
      WRITE(ITTY,505)
  505 FORMAT(/' You can type as many lines of text as nec',
     1'essary  in  this  section.   Press  the'/' RETURN ',
     2' key an extra time when you have typed all of the ',
     3'information which is to'/' be in this section.  Th',
     4'e words which you type will be  wrapped  around  t',
     5'o  form'/' lines  of approximately equal length.  ',
     6'Type an asterisk (the * character) at the'/' start',
     7' of each line which is not to be run-in with the p',
     8'revious  lines.   Type  a')
      WRITE(ITTY,506)
  506 FORMAT(' minus  sign (the - character), rather than',
     1' an asterisk, if the line is to have a'/' bullet t',
     2'o its left.  To have a blank line appear in  the  ',
     3'resume,  type  a  line'/' containing only an aster',
     4'isk.'//' If something, such as a word or words or ',
     5'a date, is to appear to the left of the'/' margin,',
     6'  first  type  the  word  or words which are to ap',
     7'pear to the left of the'/' margin, and then on the',
     8' same line type an  asterisk  followed  in  turn  ',
     9'by  the')
      WRITE(ITTY,507)
  507 FORMAT(' ordinary  text  to  be  in the body of the',
     1' document.  Follow the asterisk with a'/' minus si',
     2'gn if the text which has the word or words or date',
     3' to its left  is  also'/' to  bear  a  bullet.  Th',
     4'e first line in a section will start on the same l',
     5'ine as'/' the section name unless this first line ',
     6'starts with or contains an asterisk.'//' Insert 2 ',
     7'minus signs at the start of (or after the asterisk',
     8' in) a line which  is'/' to be aligned with the it',
     9'ems in a list but which is not to bear a bullet.')
      WRITE(ITTY,508)
  508 FORMAT(' Insert 3 minus signs at the start of a lin',
     1'e which is to be in an inner list  and'/' which is',
     2' to bear a bullet.')
      IF(IVIDEO.LT.0)GO TO 509
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  509 CONTINUE
      WRITE(ITTY,510)
  510 FORMAT(' Insert 4 minus signs at the start of a lin',
     1'e which is  to  be  aligned  with  the'/' items in',
     2' an inner list but which is not to bear a bullet.'//
     3' Your name and the names which are typed at the up',
     4'per left corners of the various'/' sections will b',
     5'e typed darker than normal.  To force any other wo',
     6'rd or phrase to'/' be typed darker than normal, pr',
     7'ecede the word or each word of the  phrase  by  a'/
     8' circumflex  or  an  up-arrow  character  (the  ^ ',
     9'character).  The circumflex and')
      WRITE(ITTY,511)
  511 FORMAT(' up-arrow are markings which identify the s',
     1'ame character on  different  types  of'/' keyboard',
     2's.   Similarly,  to force a word or a phrase to be',
     3' underlined when it is'/' typed, precede the word ',
     4'or each word in the phrase with an  underscore  or',
     5'  left'/' arrow  (the _ character).  The underscor',
     6'e and left arrow are also markings which'/' identi',
     7'fy a single character on different types of keyboa',
     8'rds.  Use  the  keys  on')
      WRITE(ITTY,512)
  512 FORMAT(' the  main  keyboard,  do  not use the left',
     1' pointing arrow key or the up pointing'/' arrow ke',
     2'y on the small keyboard  to  right  of  the  main ',
     3' keyboard.   A  second'/' appearance  of  the  cir',
     4'cumflex or of the underscore can appear within a w',
     5'ord to'/' cause the remainder of the word to be ty',
     6'ped in  the  normal  fashion  after  the'/' preced',
     7'ing  portion  of  the  word  has  been  typed eith',
     8'er darker than normal or'/' underlined respectivel',
     9'y.'/)
      WRITE(ITTY,513)
  513 FORMAT(' As an example of the use of these special ',
     1'characters,  the  following  lines  of'/' text'/)
      IF(IVIDEO.LT.0)GO TO 514
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  514 CONTINUE
      WRITE(ITTY,515)
  515 FORMAT(' 1975-1976*^Sixth ^Universal ^Bank New York',
     1', New York'/' *Promoted from _Janitor to _Vice _Pr',
     2'esident'//' would type the year range at the left ',
     3'edge of the page, cause the bank  name  to'/' be t',
     4'yped darker than normal and underline the position',
     5' titles on the next line.'//' To right justify a p',
     6'hrase in a line which is to be typed on the  lette',
     7'r  quality'/' typewriter,  insert  2 asterisks (**',
     8') between the text which is to be flush with')
      WRITE(ITTY,516)
  516 FORMAT(' the left margin and that which is to be fl',
     1'ush with the  right  margin.   The  **'/' does not',
     2' itself cause a new line in the output.  If you wa',
     3'nt the line containing'/' the ** to start a new li',
     4'ne, then either a single * must appear somewhere t',
     5'o  the'/' left  of  the  **  or a - must appear at',
     6' the start of the line.  If you want the'/' next l',
     7'ine to start a new line, then either a * or a - mu',
     8'st appear at  the  start')
      WRITE(ITTY,517)
  517 FORMAT(' of  the  next  line.   The  **  is  taken ',
     1' to be a single space if the resume is'/' typeset.'/
     2/' For example, the following lines of text'//' Sum',
     3'mer 1978*^Little ^Bank ^and ^Trust ^Company**New Y',
     4'ork, New York'/' *_Teller'/' *Responsible for the ',
     5'handling of many cents each day'/)
      IF(IVIDEO.LT.0)GO TO 518
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  518 CONTINUE
      WRITE(ITTY,519)
  519 FORMAT(' would produce the following lines in the r',
     1'esume.'//' Summer 1978',9X,'Little Bank and Trust ',
     2'Company',13X,'New York, New York'/21X,'Teller'/21X,
     3'Responsible for the handling of many cents each da',
     4'y'//' in which the company name would be darkened ',
     5'and the job title underlined.  Since'/' the  termi',
     6'nal  which you are using to input the contents of ',
     7'your resume probably'/' cannot itself display dark',
     8'ened or underlined characters, such specially modi',
     9'fied')
      WRITE(ITTY,520)
  520 FORMAT(' characters  are instead indicated when you',
     1' display a proof of your resume on the'/' terminal',
     2'  by  their  being   underlined   with   circumfle',
     3'xs   or   underscores,'/' respectively,  on  the  ',
     4'next line.  Each of the specially modified charact',
     5'ers is'/' underlined although you only had to mark',
     6' each word once when  you  typed  it  in'/' origin',
     7'ally.  Don''t worry about the extra, otherwise bla',
     8'nk line which is shown on')
      WRITE(ITTY,521)
  521 FORMAT(' your terminal since the characters underli',
     1'ned by the circumflexs or  underscores'/' will  ap',
     2'pear properly darkened or underlined when the resu',
     3'me is finally typed or'/' typeset.'//' The example',
     4' shown earlier would be displayed on the terminal ',
     5' in  the  following'/' manner:'//)
      IF(IVIDEO.LT.0)GO TO 522
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  522 CONTINUE
      WRITE(ITTY,523)
  523 FORMAT(' Summer 1978',9X,'Little Bank and Trust Com',
     1'pany',13X,'New York, New York'/21X,'^^^^^^ ^^^^ ^^',
     2'^ ^^^^^ ^^^^^^^'/21X,'Teller'/21X,'______'/21X,'Re',
     3'sponsible for the handling of many cents each day'//
     4' Now type the next line which is to be in this sec',
     5'tion.  Merely press the  RETURN'/' key  without  t',
     6'yping  anything else before it if you have complet',
     7'ed the entry of'/' the text in this section.')
C
C     SHORT LIST OF EDIT OPTIONS
      GO TO 5
  600 CONTINUE
      WRITE(ITTY,601)
  601 FORMAT(' The following is a summary of the availabl',
     1'e edit options'//' AFTER   to insert to right of i',
     2'tem'/' BEFORE  to insert at left of item'/' BOLD  ',
     3'  to make item darker'/' DELETE  to delete item'/
     4' BREAK   to break line before item'/' BULLET  to b',
     5'reak line and insert bullet'/' LOWER   to convert ',
     6'item to lower case'/' MIXED   to capitalize starts',
     7' of words'/' NEXT    to find next appearance of it',
     8'em'/' NORMAL  to remove underlining and bolding'/
     9' REPLACE to replace item')
      WRITE(ITTY,602)
  602 FORMAT(' SPACE   to insert space to left of item'/
     1' UNDERLINE to underline item'/' UPPER   to convert',
     2' item to upper case'/////' Now you can either pres',
     3's the return key to get a more detailed explanatio',
     4'n,'/' or you can type a word in this list to perfo',
     5'rm the corresponding option.')
      IF(IVIDEO.LT.0)GO TO 603
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  603 CONTINUE
C
C     LONG LIST OF EDIT OPTIONS
      WRITE(ITTY,604)
  604 FORMAT(' The following is a more complete descripti',
     1'on of the edit options'//' AFTER   to insert a wor',
     2'd or a phrase to the right of the item just found.'/
     3' BEFORE  to insert a word or a phrase to the left ',
     4'of the item just found.'/' BOLD    to insert a cir',
     5'cumflex at the start of a word or at the start of ',
     6'each'/9X,'word of a phrase to cause the word or th',
     7'e phrase to be darker than'/9X,'normal.'/' DELETE ',
     8' to delete the item just found')
      WRITE(ITTY,605)
  605 FORMAT(' BREAK   to cause the item just found to ap',
     1'pear at the start of a new line in the'/9X,'resume',
     2'.  (The line is split and * is inserted.)'/' BULLE',
     3'T  to cause the item just found to appear at the s',
     4'tart of a new line which'/9X,'bears a bullet in th',
     5'e resume.  (The line is split and - is inserted.)'/
     6' LOWER   to convert the alphabetic letters in the ',
     7'word or phrase all to lower'/9X,'case (small lette',
     8'rs).'/' MIXED   to convert the first letter of the',
     9' word or of each of the words in a')
      WRITE(ITTY,606)
  606 FORMAT(9X,'phrase to upper case (capital letters) a',
     1'nd the second and subsequent'/9X,'letters to lower',
     2' case (small letters).  "the job" or "THE JOB" wou',
     3'ld be'/9X,'converted to "The Job"'/' NEXT    to se',
     4'arch for the next appearance of the same item furt',
     5'her to the right'/' NORMAL  to remove the undersco',
     6're and/or the circumflex at the start of a word or'/
     79X,'at the start of each word of a phrase to keep t',
     8'he word or the phrase'/9X,'from being underlined a',
     9'nd from being darker than normal.')
      IF(IVIDEO.LT.0)GO TO 607
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  607 CONTINUE
      WRITE(ITTY,608)
  608 FORMAT(' REPLACE to replace the item just found by ',
     1'something else.  To remove a space'/9X,'incorrectl',
     2'y typed within a word or between a word and a foll',
     3'owing'/9X,'punctuation mark, it is necessary to se',
     4'arch for the two parts, issue a'/9X,'REPLACE comma',
     5'nd, and type in the two parts without the space.  ',
     6'To'/9X,'convert "jo b" to "job", search for jo b i',
     7'ncluding the space, issue the'/9X,'REPLACE command',
     8', and replace by job without the space.')
      WRITE(ITTY,609)
  609 FORMAT(' SPACE   to insert a space to the left of t',
     1'he item just found.  Use this if you'/9X,'forgot t',
     2'o separate 2 words.  To convert "thejob" to "the j',
     3'ob", search'/9X,'for the word job, then select SPA',
     4'CE.'/' UNDERLINE to insert an underscore at the st',
     5'art of a word or at the start of each'/9X,'word of',
     6' a phrase to cause the word or the phrase to be un',
     7'derlined.'/' UPPER   to convert the alphabetic let',
     8'ters in the word or phrase all to upper'/9X,'case ',
     9'(capital letters).'/)
      WRITE(ITTY,610)
  610 FORMAT(' or merely press the RETURN key to select a',
     1'nother option')
C
C     DESCRIBE SEARCH IN EDIT FUNCTION (KNDMSG=7)
      GO TO 5
  700 CONTINUE
      WRITE(ITTY,701)
  701 FORMAT(' Type a character, a sequence of characters',
     1', a word or a phrase which appears in'/' the line.',
     2'  Alphabetic letters which you type will match eit',
     3'her the upper or'/' lower case versions of the sam',
     4'e letters in the line regardless of which cases'/
     5' which you type.  You do not need to type undersco',
     6'res and circumflexs.  You will'/' be able to do an',
     7'y of the following if the item is found in the lin',
     8'e.'//'  1 delete the item'/'  2 replace the item b',
     9'y something else')
      WRITE(ITTY,702)
  702 FORMAT('  3 Convert the item to upper case, lower c',
     1'ase or capitalize the first letter in'/4X,'each wo',
     2'rd in the item.'/'  4 Cause the item to be darker ',
     3'than normal, to be underlined or to cause the'/4X,
     4'item to be typed normally without darkening and wi',
     5'thout underlining.'/'  5 insert a word or a phrase',
     6' either at the left or at the right of the item'/
     7'  6 attach a letter or a sequence of letters eithe',
     8'r to the left end or to the'/4X,'right end of the ',
     9'item')
      WRITE(ITTY,703)
  703 FORMAT('  7 insert a space to the left of the item,',
     1' but not to its right (to insert a'/4X,'space in "',
     2'thejob", search for the word job)'/'  8 cause the ',
     3'item to begin a new line in the resulting document',
     4' and optionally'/4X,'to cause the new line to begi',
     5'n with a bullet'/'  9 search for the next occurren',
     6'ce of the item on the same line'//' or press the R',
     7'ETURN key to select another option.')
      IF(IVIDEO.LT.0)GO TO 704
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
  704 CONTINUE
C
C     DESCRIBE REPLACEMENT TEXT IN EDIT FUNCTION (KNDMSG=8 THROUGH 13
      GO TO 5
  800 CONTINUE
      WRITE(ITTY,801)
  801 FORMAT(' Type a word or a phrase which is to be ins',
     1'erted to the left of the item just'/' found, but s',
     2'eparated from it.')
      GO TO 5
  900 CONTINUE
      WRITE(ITTY,901)
  901 FORMAT(' Type a word or a phrase which is to be ins',
     1'erted to the right of the item just'/' found, but ',
     2'separated from it.')
      GO TO 5
 1100 CONTINUE
      WRITE(ITTY,1101)
 1101 FORMAT(' Type the letter or letters which are to re',
     1'place the item just found.')
      GO TO 5
 1200 CONTINUE
      WRITE(ITTY,1201)
 1201 FORMAT(' Type the characters which are to be attach',
     1'ed to the left end of the item just'/' found.')
      GO TO 5
 1300 CONTINUE
      WRITE(ITTY,1301)
 1301 FORMAT(' Type the characters which are to be attach',
     1'ed to the right end of the item just'/' found.')
      GO TO 5
 1700 CONTINUE
      WRITE(ITTY,1701)
 1701 FORMAT(' Type the letter or letters which are to re',
     1'place the item just found.')
C
C     VARIOUS EXIT MESSAGES
      GO TO 5
 2200 CONTINUE
      WRITE(ITTY,2201)
 2201 FORMAT(' The current version of your resume has bee',
     1'n saved.  You  can  run  this  program'/' later  t',
     2'o  revise  your  resume.   When you have completed',
     3' your resume, you must'/' select the SUBMIT option',
     4' in this program to submit the final version.')
      GO TO 5
 2300 CONTINUE
      WRITE(ITTY,2301)
 2301 FORMAT(' The final version of your resume has been ',
     1'submitted.  You will not  be  able  to'/' revise y',
     2'our resume further unless you contact the RESUME p',
     3'rogram administrator.')
      GO TO 5
 2400 CONTINUE
      WRITE(ITTY,2401)
 2401 FORMAT(' Follow the instructions given in the RESUM',
     1'E Program Users Guide for typing  this'/' file on ',
     2'the letter quality printer.')
      GO TO 5
 3800 CONTINUE
      WRITE(ITTY,3801)
 3801 FORMAT(' This file can be printed on narrow paper a',
     1't either 10 or 12 characters per inch.')
      GO TO 5
 4200 CONTINUE
      WRITE(ITTY,4201)
 4201 FORMAT(' This file should be printed on wide paper.')
      GO TO 5
 4300 CONTINUE
      WRITE(ITTY,4301)
 4301 FORMAT(' This file can be printed on narrow paper a',
     1't 12 characters per inch'/' or on wide paper at 10',
     2' characters per inch.')
      GO TO 5
 7000 CONTINUE
      WRITE(ITTY,7001)
 7001 FORMAT(' You would type the following to print the ',
     1'file'/'  PRINT RESUME.DOC')
      GO TO 5
 7100 CONTINUE
      WRITE(ITTY,7101)
 7101 FORMAT(' You would type the following on the letter',
     1' quality printer'/' HC'/' RESUME.DOC'/' G')
      GO TO 5
 2500 CONTINUE
      WRITE(ITTY,2501)
 2501 FORMAT(' You submitted the final version of your re',
     1'sume earlier.  You will not be able to'/' revise  ',
     2'your resume further unless you contact the RESUME ',
     3'program administrator.'/' You can, however, produc',
     4'e a copy of your  resume  to  be  typed  on  the  ',
     5'Diablo'/' terminal or to be listed on the line pri',
     6'nter.')
C
C     INSERT COMMAND MESSAGE
      GO TO 5
 2600 CONTINUE
      WRITE(ITTY,2601)
 2601 FORMAT(' Type the line of text which you want to in',
     1'sert into the document.  If  you  type'/' more  th',
     2'an  will fit across the width of the screen, ignor',
     3'e the automatic return'/' to the left edge of the ',
     4'screen and just keep  on  typing.   You  must,  ho',
     5'wever,'/' press  the  RETURN  key when you have fi',
     6'nished typing whatever you want to be on'/' the li',
     7'ne.'/' Press only the RETURN key if you got to thi',
     8's question by accident.')
C
C     WARNING ABOUT SUBMIT COMMAND
      GO TO 5
 2700 CONTINUE
      WRITE(ITTY,2701)
 2701 FORMAT(' NOTE:  if you answer YES to the following ',
     1'question, then you CANNOT revise  your'/' resume f',
     2'urther unless you contact the RESUME program admin',
     3'istrator.')
C
C     TYPE OF LOCAL FILE IF ULTIMATE RESUME IS TYPESET
      GO TO 5
 2800 CONTINUE
      WRITE(ITTY,2801)
 2801 FORMAT(' Type one of the following commands:'/' NAR',
     1'ROW    if using the fast printer to proof the cont',
     2'ents but not the line'/11X,'lengths of a resume.  ',
     3'The resulting file can be printed on narrow'/11X,
     4'paper.'/' PRINTED   if using the fast printer to p',
     5'roof the contents and the line lengths'/11X,'of a ',
     6'resume for which the final copy will be typed on t',
     7'he letter'/11X,'quality typewriter.  The resulting',
     8' file can be printed on narrow paper')
      WRITE(ITTY,2802)
 2802 FORMAT(11X,'at 12 characters per inch or on wide pa',
     1'per at 10 characters per inch.'/' TYPED     if usi',
     2'ng the letter quality typewriter to produce the fi',
     3'nal version of'/11X,'a resume.  The file cannot be',
     4' printed on the fast printer since it'/11X,'contai',
     5'ns instructions for boldfacing which can only be p',
     6'roperly'/11X,'handled by the letter quality typewr',
     7'iter.'/' TYPESET   if using the fast printer to ch',
     8'eck the appearance of the resume when')
      WRITE(ITTY,2803)
 2803 FORMAT(11X,'it is typeset.  The resulting file must',
     1' be printed on wide paper.'/' or merely press the ',
     2'RETURN key if you do not want a paper copy of your',
     3' resume'/' now.')
C
C     TYPE OF LOCAL FILE IF ULTIMATE RESUME IS NOT TYPESET
      GO TO 5
 4100 CONTINUE
      WRITE(ITTY,4101)
 4101 FORMAT(' Type one of the following commands:'/' NAR',
     1'ROW    if using the fast printer to proof the cont',
     2'ents but not the line'/11X,'lengths of a resume.  ',
     3'The resulting file can be printed on narrow'/11X,
     4'paper.'/' PRINTED   if using the fast printer to p',
     5'roof the contents and the line lengths'/11X,'of a ',
     6'resume for which the final copy will be typed on t',
     7'he letter'/11X,'quality typewriter.  The resulting',
     8' file can be printed on narrow paper')
      WRITE(ITTY,4102)
 4102 FORMAT(11X,'at 12 characters per inch or on wide pa',
     1'per at 10 characters per inch.'/' TYPED     if usi',
     2'ng the letter quality typewriter to produce the fi',
     3'nal version of'/11X,'a resume.  The file cannot be',
     4' printed on the fast printer since it'/11X,'contai',
     5'ns instructions for boldfacing which can only be p',
     6'roperly'/11X,'handled by the letter quality typewr',
     7'iter.'/' or merely press the RETURN key if you do ',
     8'not want a paper copy of your resume'/' now.')
C
C     WARNING ABOUT CANCEL COMMAND
      GO TO 5
 2900 CONTINUE
      WRITE(ITTY,2901)
 2901 FORMAT(' NOTE:  if you answer YES to the following ',
     1'question, then the current version  of'/' your res',
     2'ume will be cancelled, and you will have to start ',
     3'over.')
      GO TO 5
 2100 CONTINUE
      WRITE(ITTY,2101)
 2101 FORMAT(' NOTE:  if you answer YES to the following ',
     1'question, then all of the changes  you'/' have mad',
     2'e to this resume will be discarded.')
C
C     VARIOUS MESSAGES ABOUT ADDRESSES AND PHONES
      GO TO 5
 3000 CONTINUE
      WRITE(ITTY,3001)
 3001 FORMAT(' Type the first line of address.'/' Press o',
     1'nly the RETURN key if no address is desired.')
      GO TO 5
 3100 CONTINUE
      WRITE(ITTY,3101)
 3101 FORMAT(' Type the first phone number to be included',
     1' with address.'/' Press only the RETURN key if no ',
     2'phone number is to be included.')
      GO TO 5
 3200 CONTINUE
      WRITE(ITTY,3201)
 3201 FORMAT(' Type the first line of second address.'/' ',
     1'Press only the RETURN key if no second address is ',
     2'desired.')
      GO TO 5
 3300 CONTINUE
      WRITE(ITTY,3301)
 3301 FORMAT(' Type the first phone number to be included',
     1' with second address.'/' Press only the RETURN key',
     2' if no phone number  is  to  be  included  with  s',
     3'econd'/' address.')
      GO TO 5
 3400 CONTINUE
      WRITE(ITTY,3401)
 3401 FORMAT(' Type the next line of address.'/' Press on',
     1'ly the RETURN key if address is complete.')
      GO TO 5
 3500 CONTINUE
      WRITE(ITTY,3501)
 3501 FORMAT(' Type the next phone number to be included ',
     1'with address.'/' Press only the RETURN key if list',
     2' of phone numbers is complete.')
      GO TO 5
 3600 CONTINUE
      WRITE(ITTY,3601)
 3601 FORMAT(' Type the next line of second address.'/' P',
     1'ress only the RETURN key if second address is comp',
     2'lete.')
      GO TO 5
 3700 CONTINUE
      WRITE(ITTY,3701)
 3701 FORMAT(' Type the next phone number to be included ',
     1'with second address.'/' Press only the RETURN key ',
     2'if list  of  phone  numbers  with  second  address',
     3'  is'/' complete.')
C
C     TELL USER WHAT PROGRAM THIS IS
      GO TO 5
 3900 CONTINUE
      WRITE(ITTY,3901)
 3901 FORMAT(' RESUME'/' Accepts resumes for the student ',
     1'resume collection.')
C
C     PASSWORD ASSIGNED TO USER
      GO TO 5
 4000 CONTINUE
      WRITE(ITTY,4001)
 4001 FORMAT(' You must prove that you know  both  the  n',
     1'umber  and  the  password  which  were'/' assigned',
     2'  to  you  in  order  to  gain  access to this pro',
     3'gram.  Please type the'/' password now.  This pass',
     4'word is not related to and  does  not  depend  upo',
     5'n  the'/' password  through which you may have gai',
     6'ned access to the account from which you'/' are ru',
     7'nning  this  program.   You  will  have  to  conta',
     8'ct  the  RESUME  program'/' administrator if you h',
     9'ave forgotten either your number or your password.')
C
C     ASK NUMBER ASSOCIATED WITH THE PASSWORD
      GO TO 5
 4400 CONTINUE
      WRITE(ITTY,4401)
 4401 FORMAT(' You must prove that you know  both  the  n',
     1'umber  and  the  password  which  were'/' assigned',
     2' to you in order to gain access to this program.  ',
     3'Please type the number'/' now.  You can type the p',
     4'assword to the right of the number or on the next ',
     5' line.'/' You  will have to contact the RESUME pro',
     6'gram administrator if you have forgotten'/' either',
     7' your number or your password.')
C
C     INSTRUCTIONS FOR ENTERING NAME SECTION
      GO TO 5
 4500 CONTINUE
      WRITE(ITTY,4501)
 4501 FORMAT(' Ready to start a new resume.'//' You will ',
     1'now supply your name, address and phone number.  Y',
     2'our name and  address'/' will appear exactly as yo',
     3'u type them.  If you type your name in upper case,',
     4' then'/' it will be in upper case on the  top  lin',
     5'e  of  your  resume.   Your  name  will'/' automat',
     6'ically  be  darkened.   You will be able to supply',
     7' 2 addresses.  The left'/' address will be lined u',
     8'p with the left edge of the paper if you  later  l',
     9'ook  at')
      WRITE(ITTY,4502)
 4502 FORMAT(' this  information on the terminal or print',
     1' this information on the line-printer.'/' However,',
     2' the left address will line up with the left  edge',
     3'  of  the  descriptive'/' text of the resume when ',
     4'it is printed on the letter quality typewriter.'//
     5' The lines of the name and address are stored in  ',
     6'sections  named  NAME  for  the'/' name,  LOCAL  f',
     7'or  the  local or main address and PERMANENT for t',
     8'he permanent or'/' secondary address.   The  phone',
     9'  numbers  are  considered  to  be  part  of  the')
      WRITE(ITTY,4503)
 4503 FORMAT(' addresses, although you will be asked sepa',
     1'rately for them.  If you do not supply'/' a perman',
     2'ent address now, but later decide that you want  o',
     3'ne,  merely  create  a'/' section  named  PERMANEN',
     4'T  by  typing  CREATE PERMANENT in response to the',
     5' "What'/' next?" question.  The text which you wou',
     6'ld put into such a new section is copied'/' into  ',
     7'the  resume  broken into lines exactly as you type',
     8'd them.  The NAME, LOCAL')
      WRITE(ITTY,4504)
 4504 FORMAT(' and PERMANENT sections do not need to be l',
     1'ocated before the other sections, they'/' will be ',
     2'sorted out and printed first regardless of where t',
     3'hey are located.')
C
C     INITIAL REQUEST FOR WHETHER INSTRUCTIONS ARE WANTED
      GO TO 5
 6400 CONTINUE
      WRITE(ITTY,6401)
 6401 FORMAT(' Type one of the following commands:'//' YE',
     1'S',6X,'if you want a list of instructions now'/' N',
     2'O',7X,'if you already know how to run this program')
      GO TO 5
 6500 CONTINUE
      WRITE(ITTY,6501)
 6501 FORMAT(' You are assumed to be using a slow hardcop',
     1'y terminal which types directly onto'/' paper.')
      GO TO 5
 6600 CONTINUE
      WRITE(ITTY,6601)
 6601 FORMAT(' You are assumed to be using a fast video t',
     1'erminal on which the last line'/' displayed appear',
     2's at the bottom of the screen forcing the previous',
     3' lines to'/' scroll upward.')
      GO TO 5
 6700 CONTINUE
      WRITE(ITTY,6701)
 6701 FORMAT(' You are assumed to be using a video termin',
     1'al on which this program can erase the'/' screen w',
     2'hen the screen fills.')
      GO TO 5
 6800 CONTINUE
      WRITE(ITTY,6801)
 6801 FORMAT(' If this assumption about the type of termi',
     1'nal which you are using is wrong, then'/' you shou',
     2'ld select the proper type of terminal by typing on',
     3'e of the following'/' instead of YES or NO.  You w',
     4'ill again be asked whether you want instructions.'//
     5' SLOW     if you are using a hardcopy terminal whi',
     6'ch types directly onto paper.'/' FAST     if you a',
     7're using a video terminal on which the last line d',
     8'isplayed'/10X,'appears at the bottom of the screen',
     9' forcing the previous lines to')
      WRITE(ITTY,6802)
 6802 FORMAT(10X,'scroll upward.'/' PAGING   if you are u',
     1'sing a video terminal on which this program can er',
     2'ase the'/10X,'screen when the screen fills.')
C
C     VARIOUS SHORT HELP MESSAGES
      GO TO 5
 4600 CONTINUE
      WRITE(ITTY,4601)
 4601 FORMAT(' Type one of the following'/' the number wh',
     1'ich identifies the resume which is to be edited'/
     2' -1 to exit'/' -2 to select a resume by the passwo',
     3'rd chosen by the student'/' or merely press the RE',
     4'TURN key to select another class.')
      GO TO 5
 4700 CONTINUE
      WRITE(ITTY,4701)
 4701 FORMAT(' Type the name of the new section.  This na',
     1'me will darkened and appear to the'/' upper left o',
     2'f the text in the section.  The name will appear 1',
     3' line above the'/' text if the first line in the s',
     4'ection starts with a single asterisk.  The name'/
     5' will be capitalized only where you type capital l',
     6'etters.  Do not include either'/' circumflexes or ',
     7'underscores.')
      GO TO 5
 4800 CONTINUE
      WRITE(ITTY,4801)
 4801 FORMAT(' Type one of the following commands:'/' YES',
     1' if you want to edit this resume'/'  NO if this is',
     2' not the resume you mean to edit')
      GO TO 5
 4900 CONTINUE
      WRITE(ITTY,4901)
 4901 FORMAT(' The line number is the number which is dis',
     1'played to the left of the line when'/' you issue a',
     2' DRAFT command.  If you do not know the line numbe',
     3'r, merely press the'/' return key here, then type ',
     4'DRAFT in response to the "WHAT NEXT?" question.  I',
     5'f'/' the DRAFT command does not show the line you ',
     6'want, then type the ALL command so'/' that the DRA',
     7'FT command will show all sections.')
      GO TO 5
 5000 CONTINUE
      WRITE(ITTY,5001)
 5001 FORMAT(' Type one of the following commands:'/' YES',
     1' if this is the correct line'/'  NO if you typed t',
     2'he wrong line number')
      GO TO 5
 5100 CONTINUE
      WRITE(ITTY,5101)
 5101 FORMAT(' Type one of the following commands:'/' YES',
     1' if you want to cancel the current contents of you',
     2'r resume'/'  NO if you got to this question by acc',
     3'ident')
      GO TO 5
 7200 CONTINUE
      WRITE(ITTY,7201)
 7201 FORMAT(' Type one of the following commands:'/' YES',
     1' if you want to cancel all the changes you have ma',
     2'de to this resume'/'  NO if you got to this questi',
     3'on by accident')
      GO TO 5
 5200 CONTINUE
      WRITE(ITTY,5201)
 5201 FORMAT(' Type one of the following commands:'/' YES',
     1' if you do not want to add more lines to this sect',
     2'ion'/'  NO if you got to this question by accident')
      GO TO 5
 5300 CONTINUE
      WRITE(ITTY,5301)
 5301 FORMAT(' Type one of the following commands:'/' YES',
     1' if you do not want to make any more changes ever'/
     2'  NO if you got to this question by accident')
      GO TO 5
 5400 CONTINUE
      WRITE(ITTY,5401)
 5401 FORMAT(' Type one of the following commands:'/' YES',
     1' if you want to type resume on Diablo or list on p',
     2'rinter'/'  NO if you do not want a copy of your re',
     3'sume')
      GO TO 5
 5500 CONTINUE
      WRITE(ITTY,5501)
 5501 FORMAT(' Type one of the following commands:'/' Yes',
     1' if you really mean to create a new section by spl',
     2'itting off the lower'/5X,'portion of an existing s',
     3'ection.'/'  NO if you want to select some other op',
     4'tion instead')
      GO TO 5
 5600 CONTINUE
      WRITE(ITTY,5601)
 5601 FORMAT(' Type one of the following commands:'/' YES',
     1' if you really mean to remove the ruling and secti',
     2'on name at the start of'/5X,'this section so that ',
     3'this section is merged with the preceding section'/
     4'  NO if you want to select some other option inste',
     5'ad')
      GO TO 5
 5700 CONTINUE
      WRITE(ITTY,5701)
 5701 FORMAT(' Identify the group of students for whom re',
     1'sumes are to be modified by typing the'/' right 2 ',
     2'digits of the year in which these students are exp',
     3'ected to graduate.'/' You would type 84 for studen',
     4'ts in the graduating class of 1984.')
C
C     USER SELECTED PASSWORD
      GO TO 5
 5800 CONTINUE
      WRITE(ITTY,5801)
 5801 FORMAT(' If this is the first time that you have us',
     1'ed this program, then you should  type'/' a  word ',
     2'or a short phrase which you do not believe can be ',
     3'guessed by anyone else'/' who will be running this',
     4' program.  This word or phrase will be used  to  p',
     5'revent'/' anyone  else  gaining  access to your re',
     6'sume through this program.  This word or'/' phrase',
     7' is not related to and does not depend upon the pa',
     8'ssword through which you')
      WRITE(ITTY,5802)
 5802 FORMAT(' may  have  gained access to the account fr',
     1'om which you are running this program.'/' The word',
     2' or the words of a phrase must be formed from the ',
     3'alphabetic  letters  A'/' through  Z  and  the  di',
     4'gits 0 through 9.  No other characters are allowed',
     5'.  The'/' word or phrase, counting the separations',
     6' between the words  of  a  phrase  as  1'/' charac',
     7'ter each, can contain up to 20 characters.'//' If ',
     8'you have used this program before, and merely wish',
     9' to review or  modify  your')
      WRITE(ITTY,5803)
 5803 FORMAT(' resume,  then  you must type the word or t',
     1'he phrase which you specified when you'/' first ra',
     2'n this program, but you do not need to match the c',
     3'ases  of  any  of  the'/' alphabetic  letters  A  ',
     4'through  Z  in the word or phrase.  You can type c',
     5'apital'/' alphabetic letters where you originally ',
     6'specified lower case letters,  and  vice'/' versa.',
     73X,'You  will  have to contact the RESUME program a',
     8'dministrator if you have'/' forgotten your passwor',
     9'd.')
      GO TO 5
 6900 CONTINUE
      WRITE(ITTY,6901)
 6901 FORMAT(' Through an administrative error, the numbe',
     1'r which you have been assigned has'/' also been as',
     2'signed to someone else.  Please contact the RESUME',
     3' program'/' administrator to have this problem cor',
     4'rected.  You cannot run this program until'/' then',
     5'.')
      GO TO 5
 5900 CONTINUE
      WRITE(ITTY,5901)
 5901 FORMAT(' The password which you have specified cann',
     1'ot be used because it is'/' computationally simila',
     2'r to a password already in use.  This does not mea',
     3'n that'/' these passwords are visually similar.'/
     4' Please select another password.')
      GO TO 5
 7300 CONTINUE
      WRITE(ITTY,7301)
 7301 FORMAT(' Your password can be 1 or more words and u',
     1'p to 20 letters and digits.  If you'/' have not us',
     2'ed this program before, select a password unlikely',
     3' to be chosen by'/' others.  If you started your r',
     4'esume earlier, type the password you chose then.'//
     5' If this is the first time you have used this prog',
     6'ram, but this program says that'/' it is continuin',
     7'g a resume begun previously, then please type EXIT',
     8' when this'/' program asks "WHAT NEXT?" and run th',
     9'is program again to select another password.')
      GO TO 5
 6000 CONTINUE
      WRITE(ITTY,6001)
 6001 FORMAT(' You will now be asked what you want the pr',
     1'ogram to do.  You are asked this  each'/' time  th',
     2'e  program  completes  what you last asked it to d',
     3'o.  If you do not know'/' what options are availab',
     4'le, then you should press the ? key and the RETURN',
     5' key.'//' You will probably want to start by speci',
     6'fying some  of  the  text  which  is  to'/' appear',
     7'  in  the  resume.   To  do so, you respond to the',
     8' "What next?" request by')
      WRITE(ITTY,6002)
 6002 FORMAT(' typing the word CREATE.  You will then be ',
     1'asked  to  specify  the  name  of  the'/' section.',
     23X,'A typical section name would be EDUCATION or WO',
     3'RK EXPERIENCE, but you'/' can choose any you want.',
     4'  Use capital  letters  only  where  you  want  th',
     5'em  to'/' appear.  The section name will appear at',
     6' the upper left corner of the section in'/' dark l',
     7'ettering and will also be the name by which you su',
     8'bsequently refer to  the'/' section if you want to',
     9' modify the name or contents of the section.'/)
      WRITE(ITTY,6003)
 6003 FORMAT(' After you have selected the CREATE option ',
     1'and named  the  section,  the  program'/' will  di',
     2'splay a ? to indicate that you should type a line ',
     3'of text which is to be'/' inserted into the sectio',
     4'n.  If you do not know how the program  expects  y',
     5'ou  to'/' indicate  sub-section  names, or the sta',
     6'rts of lines which are not to be wrapped'/' around',
     7', or words which are to be either darkened or unde',
     8'rlined, then you  should')
      WRITE(ITTY,6004)
 6004 FORMAT(' here  also  press the ? key and the RETURN',
     1' key.  The program will accept as many'/' lines as',
     2' you want to place into the section.  When you  ha',
     3've  finished  entering'/' text  into  the  section',
     4', merely press the RETURN key again without having',
     5' typed'/' anything else before it to return to the',
     6' "What next?" request.')
      IF(IVIDEO.LT.0)GO TO 6005
      WRITE(ITTY,1)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.GT.0)GO TO 6
      IF(IVIDEO.GT.0)CALL RSMWIP(ITTY)
 6005 CONTINUE
      GO TO 5
 6100 CONTINUE
      WRITE(ITTY,6101)
 6101 FORMAT(' Type one of the following commands:'/' YES',
     1' if you specified the correct password and you rea',
     2'lly do want to start a new'/5X,'resume'/'  NO if y',
     3'ou started your resume earlier but you specified t',
     4'he wrong password now')
      GO TO 5
 6200 CONTINUE
      WRITE(ITTY,6201)
 6201 FORMAT(' Type the number of the class containing th',
     1'e students whose resumes are to be'/' edited'/' or',
     2' type -1 to exit.')
      GO TO 5
 6300 CONTINUE
      WRITE(ITTY,6301)
 6301 FORMAT(' Type one of the following commands:'/' ATT',
     1'ACHED  If the text which has just been found and t',
     2'he text which is to be'/11X,'inserted are to be at',
     3'tached together rather than separated by a space.'/
     4' SEPARATED If the text which has just been found a',
     5'nd the text which is to be'/11X,'inserted are to b',
     6'e separated by a space rather than attached togeth',
     7'er.')
      GO TO 5
C
C     RETURN TO CALLING PROGRAM
    5 WRITE(ITTY,3)
    6 RETURN
      END
