C     RENBR(RESUME/GROUP RESUME COLLECTION PROGRAM)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS IS THE MAIN PROGRAM OF THE STUDENT RESUME SYSTEM
C
C     THE MAIN MENU
      DIMENSION LTRCMD(166),LNGCMD(34),KMDARG(34)
C
C     ARRAY CONTAINING SECOND ARGUMENT TYPES OF SOME COMMANDS
      DIMENSION KMD100(3)
C
C     MENUS CONTAINING TERMINAL TYPES
      DIMENSION LTRYNT(19),LNGYNT(5)
C
C     ARRAYS USED TO STORE THE RESUME
      DIMENSION KNTTTL(100),LNGSEC(100),LNGLIN(300),
     1MARKER(300),LTRTTL(2000),LTRTXT(10000)
C
C     SECOND MENU USED TO DETERMINE TYPE OF PAPER OUTPUT
      DIMENSION LTRLPT(33),LNGLPT(6)
C
C     ARRAYS USED TO STORE ACCOUNT NAME USED TO RUN PROGRAM
      DIMENSION LTRWHO(40),LWRWHO(40)
C
C     ARRAY USED TO STORE CAPITALIZED PASSWORD TYPE BY A
C     USER RUNNING FROM AN ACCOUNT WHICH CANNOT BE MAPPED
C     DIRECTLY TO THE FILE NAME OF THE RESUME.
      DIMENSION LTRPSW(20),LTRCHK(20)
C
C     VARIOUS INPUT AND OUTPUT CHARACTER BUFFERS
      DIMENSION LTRBFR(80),LWRBFR(80),LTRWID(2500)
C
C     DIMENSION INFORMATION FOR THE VARIOUS ARRAYS.
C
C     LMTLTT = DIMENSION OF LTRTTL ARRAY. MAXIMUM NUMBER OF
C              CHARACTERS IN ALL SECTION NAMES.
C     LMTSEC = DIMENSION OF KNTTTL AND LNGSEC ARRAYS.
C              MAXIMUM NUMBER OF SECTION NAMES.
C     LMTWID = DIMENSION OF LTRWID ARRAY.  MAXIMUM WIDTH OF
C              OF A LINE WHICH IS READ TO BE INSERTED INTO
C              RESUME.  THIS LINE CAN BE SPLIT INTO SHORTER LINES.
C     LMTBFR = DIMENSION OF LTRBFR AND LWRBFR ARRAYS.  MAXIMUM NUMBER
C              OF CHARACTERS IN MOST INPUT EXCEPT LINES WHICH ARE
C              TO BE INSERTED DIRECTLY INTO RESUME.
C     LMTTXT = DIMENSION OF LTRTXT ARRAY.  MAXIMUM NUMBER OF
C              CHARACTERS IN ENTIRE RESUME.
C     LMTLIN = DIMENSION OF LNGLIN AND MARKER ARRAYS.  MAXIMUM
C              NUMBER OF LINES PLUS SECTIONS IN A RESUME.
C     LMTPSW = DIMENSION OF LTRPSW AND LTRCHK ARRAYS.  MAXIMUM NUMBER
C              OF CHARACTERS IN A PASSWORD.
C     LMTWHO = DIMENSION OF LMTWHO ARRAY.  MAXIMUM NUMBER OF
C              CHARACTERS IN AN ACCOUNT NAME.
C
      DATA LMTLTT,LMTSEC,LMTWID,LMTBFR,LMTTXT,LMTLIN,LMTPSW,LMTWHO/
     1 2000,100,2500,80,10000,300,20,40/
C
C     LMTTYP = MAXIMUM NUMBER OF LINES ON A TYPED PAGE
C     LMTPRI = MAXIMUM NUMBER OF LINES ON A TYPESET PAGE
      DATA LMTTYP,LMTPRI/60,66/
C
C     LMTATO = RESUME IS AUTOMATICALLY SAVED WHEN KNTATO
C              REACHES THIS VALUE.  KNTATO IS INCREATED
C              BY 1 FOR EDIT OF CONTENTS OF A LINE
C              BY INCATO FOR EACH MAJOR CHANGE
C     KNTATO = SUM OF NUMBER OF CHANGES MADE TO RESUME
C     INCATO = AMOUNT BY WHICH ADJUST KNTATO WHENEVER
C              INSERT OR APPEND OR CREATE A LINE
C              RENAME OR MOVE A SECTION
C              SWITCH LINES
C              REPLACE OR DELETE LINES
C
      DATA INCATO,LMTATO/3,100/
C
C     LNGCRT = 2 LESS THAN NUMBER OF LINES ON A VIDEO SCREEN
      DATA LNGCRT/22/
C
C     UNIT NUMBERS
      DATA IDISK,ITTY/1,5/
C
C     KMDARG = 1, NO ARGUMENT ALLOWED
C            = 2, NUMERIC ARGUMENT
C            = 3, OLD SECTION NAME
C            = 4, NEW SECTION NAME
C            = -1 OR LESS, TREAT AS THIS COMMAND WITHOUT MINUS
      DATA LTRCMD/
     11HR,1HE,1HP,1HL,1HA,1HC,1HE, 1HD,1HE,1HL,1HE,1HT,1HE,
     21HB,1HE,1HF,1HO,1HR,1HE,     1HA,1HF,1HT,1HE,1HR,
     31HD,1HR,1HA,1HF,1HT,         1HS,1HA,1HV,1HE,
     41HB,1HR,1HE,1HA,1HK,         1HL,1HE,1HN,1HG,1HT,1HH,
     51HE,1HX,1HI,1HT,             1HJ,1HO,1HI,1HN,
     61HC,1HR,1HE,1HA,1HT,1HE,     1HR,1HE,1HN,1HA,1HM,1HE,
     71HO,1HN,1HL,1HY,             1HA,1HL,1HL,
     81HP,1HR,1HO,1HO,1HF,         1HB,1HU,1HL,1HL,1HE,1HT,
     91HE,1HD,1HI,1HT,             1HS,1HU,1HB,1HM,1HI,1HT,
     11HA,1HP,1HP,1HE,1HN,1HD,     1HT,1HY,1HP,1HE,
     21HC,1HA,1HN,1HC,1HE,1HL,     1HP,1HA,1HP,1HE,1HR,
     31HS,1HK,1HI,1HP,             1HM,1HO,1HV,1HE,
     41HR,1HU,1HL,1HE,             1HU,1HN,1HR,1HU,1HL,1HE,
     51HD,1HE,1HB,1HU,1HG,         1HF,1HA,1HS,1HT,
     61HP,1HA,1HG,1HI,1HN,1HG,     1HF,1HI,1HL,1HE,
     71HN,1HE,1HW,                 1HO,1HL,1HD,
     81HS,1HL,1HO,1HW,             1HS,1HW,1HI,1HT,1HC,1HH/
C
C          (REP DEL BEF AFT DRA SAV BRE LEN EXI JOI
C    1      CRE REN ONL ALL PRO BUL EDI SUB APP TYP
C    2      CAN PAP SKI MOV RUL UNR DEB FAS PAG FIL
C    3      NEW OLD SLO
      DATA LNGCMD/
     1        7,  6,  6,  5,  5,  4,  5,  6,  4,  4,
     2        6,  6,  4,  3,  5,  6,  4,  6,  6,  4,
     3        6,  5,  4,  4,  4,  6,  5,  4,  6,  4,
     4        3,  3,  4,  6/
      DATA KMDARG/
     1        2,  2,  2,  2,  1,  1,  2,  1,  1,  2,
     2        4,  3,  3,  1,  1,  2,  2,  1,  3,  2,
     3        1,  1,  2,  3,  4,  3,  1,  1,  1,-22,
     4      -11,-13,  1,  2/
      DATA KNTSPL/166/
      DATA KNTCMD/34/
C
C     KMD100 = SIMILAR TO KMDARG FOR COMMANDS TAKING 2 ARGUMENTS
      DATA KMD100/  2,  2,  2/
C
C     LTRLPT = MENU FOR SELECTING TYPE OF PAPER OUTPUT
      DATA LTRLPT/
     11HN,1HA,1HR,1HR,1HO,1HW,
     21HP,1HR,1HI,1HN,1HT,1HE,1HD,
     31HT,1HY,1HP,1HE,1HD,
     41HT,1HY,1HP,1HE,1HS,1HE,1HT,
     51HW,1HI,1HD,1HE,
     61HF,1HA,1HS,1HT/
      DATA LNGLPT/6,7,5,7,4,4/
C
C     LTRYNT = MENU CONTAINING YES, NO AND TERMINAL TYPES
      DATA LTRYNT/
     11HY,1HE,1HS,
     21HN,1HO,
     31HS,1HL,1HO,1HW,
     41HF,1HA,1HS,1HT,
     51HP,1HA,1HG,1HI,1HN,1HG/
      DATA LNGYNT/3,2,4,4,6/
      DATA LMTYNT,KNTYNT/19,5/
C
C     OTHER CHARACTER INFORMATION
      DATA LTRSPA,LTRZER,LTRSTA,LTRMIN,LTREQU,LTRNUM/
     11H ,1H0,1H*,1H-,1H=,1H#/
C
C     INDICATE THAT VIDEO TERMINAL IS BEING USED
      JVIDEO=1
      IVIDEO=0
C
C     TURN OFF STOPPING EVERY 24 LINES OF SCREEN DISPLAY
      CALL TTYSET
C
C     IDENTIFY CURRENT USER
      CALL RSMWHO(LTRWHO,IPRJCT,IPRGRM,NUMWHO)
C
C     DETERMINE IF CURRENT USER IS ENABLED AS ADMINISTRATOR
      CALL RSMCHK(LTRWHO,LWRWHO,LMTWHO,IPRJCT,IPRGRM, IDISK,
     1 IYEAR,ICHECK,IPRINT,JVIDEO,LTRBFR,LMTBFR,ITTY,NUMWHO)
C
C     CONVERT JVIDEO VALUES 0, 1, 2 TO -1, 0, 1
      JVIDEO=JVIDEO-1
      IF(JVIDEO.LT.0)JVIDEO=-1
      IF(JVIDEO.GT.0)JVIDEO=1
C
C     TELL USER WHAT PROGRAM THIS IS
      CALL RSMHLP(ITTY,39,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
C
C     BRANCH FOR ADMINISTRATOR OR NORMAL USER
      IF(IYEAR.GT.999)GO TO 380
      IF(IYEAR.GE.0)GO TO 48
      IF(IYEAR.EQ.-2)GO TO 380
      IXYZZY=1
      MINCLS=ICHECK
      MAXCLS=IPRINT
C
C     **************************
C     *                        *
C     *  ADMINISTRATOR DIALOG  *
C     *                        *
C     **************************
C
      WRITE(ITTY,1)
    1 FORMAT(' Administrator privileges are enabled.')
      IF(MINCLS.NE.MAXCLS)GO TO 4
      IYEAR=MINCLS
      WRITE(ITTY,2)IYEAR
    2 FORMAT(' You can modify any submitted resume in class',1I4/1X)
      GO TO 19
    3 IF(MINCLS.NE.MAXCLS)GO TO 6
      GO TO 19
    4 WRITE(ITTY,5)MINCLS,MAXCLS
    5 FORMAT(' You can modify any submitted resumes in classes',
     1 1I4,' through',1I4/1X)
C
C     ASK ADMINISTRATOR WHICH CLASS IS TO BE EDITED
    6 WRITE(ITTY,7)
    7 FORMAT(' Modify resumes in which class (-1 to exit)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 13
      IF(MAXBFR.LE.0)GO TO 14
      LOWBFR=1
    8 CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(14,9,12),KIND
    9 IF(LTRBFR(LOWBFR).NE.1H?)GO TO 14
      GO TO 11
   10 IF(LOWBFR.GT.MAXBFR)GO TO 13
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 14
   11 LOWBFR=LOWBFR+1
      GO TO 10
   12 IF(LOWBFR.GT.MAXBFR)GO TO 16
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 14
      LOWBFR=LOWBFR+1
      GO TO 12
   13 CALL RSMHLP(ITTY,62,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 6
   14 WRITE(ITTY,15)
   15 FORMAT(' Type ? for help')
      GO TO 6
   16 IF(IVALUE.LT.0)GO TO 383
      IF(IVALUE.GT.999)GO TO 14
      IF(IVALUE.LT.MINCLS)GO TO 17
      IF(IVALUE.GT.MAXCLS)GO TO 17
      IYEAR=IVALUE
      GO TO 19
   17 WRITE(ITTY,18)
   18 FORMAT(' You are not allowed to modify this class')
      GO TO 6
C
C     ASK ADMINISTRATOR WHAT RESUME IS TO BE EDITED
   19 WRITE(ITTY,20)
   20 FORMAT(' Number identifying resume (-2 by password',
     1', -1 to exit)? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 26
      IF(MAXBFR.LE.0)GO TO 3
      LOWBFR=1
   21 CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(383,22,25),KIND
   22 IF(LTRBFR(LOWBFR).NE.1H?)GO TO 27
      GO TO 24
   23 IF(LOWBFR.GT.MAXBFR)GO TO 26
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 27
   24 LOWBFR=LOWBFR+1
      GO TO 23
   25 IF(LOWBFR.GT.MAXBFR)GO TO 29
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 27
      LOWBFR=LOWBFR+1
      GO TO 25
   26 CALL RSMHLP(ITTY,46,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 19
   27 WRITE(ITTY,28)
   28 FORMAT(' Type ? for help')
      GO TO 19
   29 IF(IVALUE.EQ.-2)GO TO 30
      IF(IVALUE.EQ.-1)GO TO 383
      IF(IVALUE.LT.0)GO TO 27
      NUMWHO=IVALUE
      GO TO 34
C
C     CONVERT PASSWORD INTO NUMBER
   30 CALL PASWRD(LTRPSW,LMTPSW,ITTY,LNGPSW,NUMWHO,
     1LTRBFR,LMTBFR)
      IF(NUMWHO.GE.0)GO TO 32
      WRITE(ITTY,31)
   31 FORMAT(' Type the password which was selected by the student')
      GO TO 30
   32 WRITE(ITTY,33)NUMWHO
   33 FORMAT(' This password translates to number',1I7)
   34 IF(NUMWHO.LE.999999)GO TO 65
      WRITE(ITTY,35)
   35 FORMAT(' Number must be in range 0 through 999999')
      GO TO 19
C
C     ADMINISTRATOR MESSAGES
   36 WRITE(ITTY,37)
   37 FORMAT(' File does not exist')
      GO TO 19
   38 WRITE(ITTY,39)
   39 FORMAT(' Resume has not been submitted')
      GO TO 19
   40 WRITE(ITTY,41)
   41 FORMAT(' Resume has been replaced')
      GO TO 19
   42 WRITE(ITTY,43)
   43 FORMAT(' Resume has been blocked')
      GO TO 19
   44 WRITE(ITTY,45)
   45 FORMAT(' Cancelling this request, please specify another resume')
      GO TO 19
   46 WRITE(ITTY,47)
   47 FORMAT(' Modified resume has been saved')
      GO TO 19
C
C     ***************************************
C     *                                     *
C     *  START OF NON-ADMINISTRATOR DIALOG  *
C     *                                     *
C     ***************************************
C
C     MARK THAT ARE NOT THE ADMINISTRATOR
   48 IXYZZY=0
C
C     MESSAGES TO BE SEEN BY MEMBERS OF CURRENT CLASS
      CALL RSMMSG(LTRBFR,LWRBFR,LMTBFR,LNGCRT,
     1 NUMWHO, IYEAR,  ITTY, IDISK)
      IF(ICHECK.LT.0)GO TO 383
C
C     IF RUNNING FROM AN ACCOUNT WHICH CAN BE USED BY SEVERAL
C     OBTAIN THE PASSWORD AND MAP THIS TO A PROBABLY
C     UNIQUE NUMBER
      KANCEL=-1
      IF(ICHECK.NE.1)GO TO 51
   49 CALL RSMHLP(ITTY,73,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 51
   50 IF(ICHECK.EQ.2)GO TO 382
      CALL RSMHLP(ITTY,59,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
   51 IF(ICHECK.EQ.0)GO TO 53
      IF(ICHECK.EQ.2)GO TO 52
      CALL PASWRD(LTRPSW,LMTPSW,ITTY,LNGPSW,NUMWHO,
     1LTRBFR,LMTBFR)
      IF(NUMWHO.GE.0)GO TO 55
      CALL RSMHLP(ITTY,58,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 51
   52 CALL PASLST(IVIDEO,JVIDEO,IYEAR,IDISK,ITTY,
     1LMTPSW,LTRPSW,LTRCHK,LNGPSW,NUMWHO,LTRBFR,LMTBFR)
      IF(LNGPSW.EQ.0)GO TO 383
      GO TO 55
   53 DO 54 I=1,LMTPSW
      LTRPSW(I)=LTRSPA
   54 CONTINUE
   55 CONTINUE
C
C     ASK USER IF INSTRUCTION ARE WANTED OR TERMINAL TYPE
      IF(KANCEL.GE.0)GO TO 64
   56 WRITE(ITTY,57)
   57 FORMAT(' Do you want general instructions? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 58
      IF(MAXBFR.EQ.0)GO TO 59
      LOWBFR=1
      CALL DAVERB(1,LMTYNT,LTRYNT,1,KNTYNT,
     1LNGYNT,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(59,59,61,61,59),KIND
   58 CALL RSMHLP(ITTY,64,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      KNDMSG=66+JVIDEO
      CALL RSMHLP(ITTY,KNDMSG,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      CALL RSMHLP(ITTY,68,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 56
   59 WRITE(ITTY,60)
   60 FORMAT(' Type ? for instructions')
      GO TO 56
   61 IF(LOWBFR.GT.MAXBFR)GO TO 62
      IF(LTRBFR(LOWBFR).NE.1H )GO TO 59
   62 IF(MATCH.EQ.1)GO TO 63
      IF(MATCH.EQ.2)GO TO 64
      IF(MATCH.EQ.3)JVIDEO=-1
      IF(MATCH.EQ.4)JVIDEO=0
      IF(MATCH.EQ.5)JVIDEO=1
      IF(JVIDEO.LT.0)WRITE(ITTY,205)
      IF(JVIDEO.EQ.0)WRITE(ITTY,207)
      IF(JVIDEO.GT.0)WRITE(ITTY,209)
      GO TO 56
   63 IVIDEO=JVIDEO
      CALL RSMHLP(ITTY,1,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
   64 CONTINUE
C
C     *******************************************
C     *                                         *
C     *  RESTORE THE CONTENTS OF AN OLD RESUME  *
C     *                                         *
C     *******************************************
C
C     INITIALIZE STORAGE
   65 KANCEL=0
   66 MAXLTT=0
      MAXSEC=0
      KNTLIN=0
      KNTTXT=0
      MAXSEC=MAXSEC+1
      KNTTTL(MAXSEC)=0
      LNGSEC(MAXSEC)=1
      KNTLIN=KNTLIN+1
      LNGLIN(KNTLIN)=0
      MARKER(KNTLIN)=0
C
C     OTHER COUNTS NOT ASSOCIATED WITH STORAGE OF RESUME
      KNTATO=0
C
C     OPEN OLD RESUME FILE
      IF(KANCEL.NE.0)GO TO 87
      CALL RSMOPN(3,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 76
      GO TO 67
C
C     GET VERSION NUMBER AND STATE OF AN OLD RESUME
   67 READ(IDISK,68)ISTATE,JPRINT,IVERSN,JDAY,JMONTH,JYEAR,
     1LTRWHO,LTRCHK
   68 FORMAT(2I1,1I3,3X,3I2,6X,40A1,20A1)
      IF(ISTATE.EQ.0)GO TO 75
      IF(ISTATE.EQ.7)GO TO 75
      IF(ICHECK.EQ.0)GO TO 70
      IF(IXYZZY.NE.0)GO TO 70
      DO 69 I=1,LMTPSW
      IF(LTRPSW(I).NE.LTRCHK(I))GO TO 74
   69 CONTINUE
      GO TO 72
   70 DO 71 I=1,LMTPSW
      LTRPSW(I)=LTRCHK(I)
   71 CONTINUE
      IF(IXYZZY.NE.0)GO TO 73
   72 IF(ISTATE.GE.2)GO TO 92
      IVERSN=IVERSN+1
      GO TO 88
   73 IPRINT=JPRINT
      IF(ISTATE.GE.2)GO TO 92
C
C     CLOSE FILE IF ADMINISTRATOR REQUESTS UNSUBMITTED RESUME
      CALL RSMCLS(3,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      GO TO 38
C
C     CLOSE FILE IF WRONG PASSWORD STORED IN FILE
   74 CALL RSMCLS(3,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      GO TO 50
C
C     CLOSE A BLOCKED OR REPLACED RESUME
   75 CALL RSMCLS(3,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      IF(ISTATE.EQ.7)GO TO 83
      IF(IXYZZY.NE.0)GO TO 40
C
C     NO RESUME EXISTS SO FAR FOR THIS NUMBER
   76 IF(IXYZZY.NE.0)GO TO 36
      IF(ICHECK.EQ.0)GO TO 87
C
C     ASK IF USER WANTS TO START A NEW RESUME
   77 IF(ICHECK.EQ.2)GO TO 87
      WRITE(ITTY,78)
   78 FORMAT(' No resume has been created using this password.')
   79 WRITE(ITTY,80)
   80 FORMAT(' Do you want to start a new resume? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(79,79,82,51,81),KNDYES
   81 CALL RSMHLP(ITTY,61,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 79
   82 GO TO 87
C
C     USE OF RESUME IS BLOCKED
   83 IF(IXYZZY.NE.0)GO TO 42
      IF(ICHECK.NE.1)GO TO 85
      WRITE(ITTY,84)
   84 FORMAT(' The password you selected is not meant to',
     1' be used at this point'/
     2' Please select another password'/1X)
      GO TO 49
   85 WRITE(ITTY,86)
   86 FORMAT(' Your resume has been blocked'/
     1' Please contact the RESUME program administrator')
      GO TO 383
C
C     START A NEW RESUME
   87 IVERSN=0
      ISTATE=1
      GO TO 88
C
C     ***************************************************
C     *                                                 *
C     *  ESTABLISH NAME AND ANY FIXED STUFF THEREAFTER  *
C     *                                                 *
C     ***************************************************
C
C     BRANCH AROUND THIS SECTION IF NOT STARTING NEW RESUME
   88 IF(IVERSN.NE.0)GO TO 89
C
C     ASK USER FOR NAME AND ADDRESS FOR A NEW RESUME
      CALL RSMNAM(LTRBFR,LMTBFR,LINE,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MAXSEC,LMTSEC,MARKER,ITTY,
     2IVIDEO,JVIDEO,LTRTTL,LMTLTT,MAXLTT,KNTTTL)
C
C     OPEN THE FILE CONTAINING FIXED PORTION OF RESUME
      CALL RSMOPN(4,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 104
      GO TO 91
C
C     TELL USER THAT ARE CONTINUING PREVIOUS RESUME
   89 WRITE(ITTY,90)
   90 FORMAT(' Continuing resume begun previously'/1X)
   91 GO TO 92
C
C     RESTORE OLD RESUME OR START EDUCATION SECTION OF NEW RESUME
   92 KONTNU=MAXSEC
      CALL RSMOLD(IVERSN,NOWSEC,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      IF(IVERSN.EQ.0)CALL RSMCLS(4,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      IF(IVERSN.NE.0)CALL RSMCLS(3,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      IF(IXYZZY.NE.0)GO TO 93
      IF(ISTATE.GE.2)GO TO 328
      GO TO 105
C
C     TELL ADMINISTRATOR WHAT RESUME HAS JUST BEEN READ
   93 CONTINUE
      WRITE(ITTY,94)LTRWHO
   94 FORMAT(' Account: ',40A1)
      IF(KNTLIN.LE.0)GO TO 98
      DO 95 I=1,KNTLIN
      IF(MARKER(I).NE.1)GO TO 95
      K=I
      GO TO 96
   95 CONTINUE
      GO TO 98
   96 J=LNGLIN(K)
      IF(J.LE.0)GO TO 98
      IF(LTRTXT(J).EQ.1H*)J=J-1
      IF(J.LE.0)GO TO 98
      WRITE(ITTY,97)(LTRTXT(I),I=1,J)
   97 FORMAT('    Name: ',100A1)
   98 CONTINUE
C
C     CONFIRM THAT THIS IS THE CORRECT RESUME
   99 WRITE(ITTY,100)
  100 FORMAT(' Is this the resume you wish to edit? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(99,99,102,44,101),KNDYES
  101 CALL RSMHLP(ITTY,48,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 99
  102 WRITE(ITTY,103)
  103 FORMAT(' Issue SAVE command when done')
      GO TO 107
C
C     INSTRUCTIONS IF A BOILER PLATE SECTION IS NOT SUPPLIED
  104 CALL RSMHLP(ITTY,60,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 107
C
C     **********************************************
C     *                                            *
C     *  ALLOW USER TO SPECIFY CONTENTS OF RESUME  *
C     *                                            *
C     **********************************************
C
C     PREPARE TO DISPLAY BOILERPLATE
  105 IF(IVERSN.NE.0)GO TO 107
      IF(MAXSEC.EQ.KONTNU)GO TO 107
      IVIDEO=JVIDEO
      CALL RSMHLP(ITTY,3,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
      GO TO 266
C
C     PREPARE TO CONTINUE BOILERPLATE
  106 IVERSN=1
      IVIDEO=JVIDEO
      IF(IVIDEO.EQ.1)IVIDEO=2
      CALL RSMHLP(ITTY,4,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
      GO TO 257
C
C     ASK USER WHAT TO DO IF NOT CONTINUING BOILERPLATE
  107 NOWSEC=0
      IF(IVERSN.EQ.0)IVERSN=1
      GO TO 111
C
C     TELL USER IF COMMAND WILL NOT BE PERFORMED
  108 WRITE(ITTY,109)
  109 FORMAT(' This request will not be acted upon')
      GO TO 111
C
C     GET NEXT OPTION
  110 IF(MAXBFR.GT.0)GO TO 114
  111 IF(IXYZZY.NE.0)GO TO 112
      IF(KNTATO.GE.LMTATO)GO TO 349
  112 WRITE(ITTY,113)
  113 FORMAT(' What next? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
  114 IF(MAXBFR.LT.0)GO TO 309
      LOWBFR=1
      CALL DAVERB(1,KNTSPL,LTRCMD,1,KNTCMD,
     1LNGCMD,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(310,310,115,115,310),KIND
  115 KOMAND=MATCH
  116 I=KMDARG(KOMAND)
      IF(I.GT.0)GO TO 117
      KOMAND=-I
      GO TO 116
C
C     REQUIRE THAT CANCEL AND SUBMIT BE SPELLED OUT COMPLETELY
C     REQUIRE THAT DEBUG COMMAND BE SPELLED OUT COMPLETELY
  117 IF(KIND.EQ.3)GO TO 122
      IF(KOMAND.EQ.18)GO TO 118
      IF(KOMAND.EQ.21)GO TO 118
      IF(KOMAND.EQ.27)GO TO 310
      GO TO 122
  118 IF(LOWBFR.GT.MAXBFR)GO TO 119
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 310
      LOWBFR=LOWBFR+1
      GO TO 118
  119 IF(KOMAND.EQ.18)WRITE(ITTY,120)
      IF(KOMAND.EQ.21)WRITE(ITTY,121)
  120 FORMAT(' The SUBMIT option cannot be abbreviated')
  121 FORMAT(' The CANCEL option cannot be abbreviated')
      GO TO 111
C
C     DETERMINE TYPE OF ARGUMENT ACCEPTED BY COMMAND
  122 I=KMDARG(KOMAND)
      GO TO 124
  123 LOWBFR=LMTBFR+1
      I=KMD100(KOMAND-100)
  124 GO TO(187,144,125,125),I
C
C     IDENTIFY SECTION NAME
  125 IF(LOWBFR.GT.MAXBFR)GO TO 126
      IF(LTRBFR(LOWBFR).EQ.1H?)GO TO 126
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 310
  126 IF(KOMAND.LE.100)KREATE=KMDARG(KOMAND)-3
      IF(KOMAND.GT.100)KREATE=KMD100(KOMAND-100)-3
      CALL RSMTTL(KREATE,KNDTTL,NOWSEC,LMTLTT,MAXLTT,LTRTTL,
     1LMTSEC,MAXSEC,KNTTTL,IDISK,ITTY,LMTBFR,LTRBFR,LWRBFR,LOWBFR,
     2MAXBFR,LNGSEC,MARKER,LNGLIN,LMTLIN,KNTLIN,KNTTXT,IVIDEO)
      GO TO(127,137,137,127,127,127),KNDTTL
  127 IF(KOMAND.EQ.11)WRITE(ITTY,128)
      IF(KOMAND.EQ.12)WRITE(ITTY,129)
      IF(KOMAND.EQ.13)WRITE(ITTY,130)
      IF(KOMAND.EQ.19)WRITE(ITTY,131)
      IF(KOMAND.EQ.24)WRITE(ITTY,132)
      IF(KOMAND.EQ.25)WRITE(ITTY,133)
      IF(KOMAND.EQ.26)WRITE(ITTY,134)
  128 FORMAT(' Name of section to be created? ',$)
  129 FORMAT(' Current name of section to be renamed? ',$)
  130 FORMAT(' Name of section to be shown by DRAFT and PROOF? ',$)
  131 FORMAT(' Name of section to which lines are to be added? ',$)
  132 FORMAT(' Name of section to be moved? ',$)
  133 FORMAT(' Name of section to be created from existing lines? ',$)
  134 FORMAT(
     1' Name of section to be merged with preceding section? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.EQ.0)GO TO 108
      IF(MAXBFR.GT.0)GO TO 136
  135 MAXBFR=1
      LTRBFR(MAXBFR)=1H?
  136 LOWBFR=1
      GO TO 126
C
C     ASK USER FOR CONFIRMATION OF THIS TREATMENT OF SECTION
  137 IF(KOMAND.EQ.25)GO TO 138
      IF(KOMAND.EQ.26)GO TO 138
      GO TO 188
  138 IF(KOMAND.EQ.25)WRITE(ITTY,139)
  139 FORMAT(
     1' Do you really want to split an existing section? ',$)
      IF(KOMAND.EQ.26)WRITE(ITTY,140)
  140 FORMAT(
     1' Do you really want to merge 2 sections? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(138,138,143,142,141),KNDYES
  141 IF(KOMAND.EQ.25)CALL RSMHLP(ITTY,55,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IF(KOMAND.EQ.26)CALL RSMHLP(ITTY,56,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 138
  142 NOWSEC=0
      GO TO 108
  143 GO TO 188
C
C     EVALUATE NUMERIC ARGUMENT
  144 CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(149,145,148),KIND
  145 IF(LTRBFR(LOWBFR).NE.1H?)GO TO 310
      GO TO 147
  146 IF(LOWBFR.GT.MAXBFR)GO TO 166
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 310
  147 LOWBFR=LOWBFR+1
      GO TO 146
  148 IF(LOWBFR.GT.MAXBFR)GO TO 167
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 310
      LOWBFR=LOWBFR+1
      GO TO 148
  149 IF(KNTLIN.LE.0)GO TO 314
      DO 150 I=1,KNTLIN
      IF(MARKER(I).NE.0)GO TO 151
  150 CONTINUE
      GO TO 314
  151 IF(KOMAND.EQ.1)WRITE(ITTY,152)
      IF(KOMAND.EQ.2)WRITE(ITTY,153)
      IF(KOMAND.EQ.3)WRITE(ITTY,154)
      IF(KOMAND.EQ.4)WRITE(ITTY,155)
      IF(KOMAND.EQ.7)WRITE(ITTY,156)
      IF(KOMAND.EQ.10)WRITE(ITTY,157)
      IF(KOMAND.EQ.16)WRITE(ITTY,158)
      IF(KOMAND.EQ.17)WRITE(ITTY,159)
      IF(KOMAND.EQ.20)WRITE(ITTY,160)
      IF(KOMAND.EQ.23)WRITE(ITTY,161)
      IF(KOMAND.EQ.101)WRITE(ITTY,162)
      IF(KOMAND.EQ.34)WRITE(ITTY,163)
      IF(KOMAND.EQ.102)WRITE(ITTY,164)
      IF(KOMAND.EQ.103)WRITE(ITTY,165)
  152 FORMAT(' Number of line to be replaced? ',$)
  153 FORMAT(' Number of line to be deleted? ',$)
  154 FORMAT(
     1' Number of line before which new line is to be inserted? ',$)
  155 FORMAT(
     1' Number of line after which new line is to be inserted? ',$)
  156 FORMAT(' Number of line to start new line in output? ',$)
  157 FORMAT(' Number of line to be merged with previous line? ',$)
  158 FORMAT(' Number of line to bear bullet? ',$)
  159 FORMAT(' Number of line to be edited? ',$)
  160 FORMAT(' Number of line to be displayed? ',$)
  161 FORMAT(
     1' Number of line before which blank line is to be inserted? ',$)
  162 FORMAT(' Number of line to be at start of new section? ',$)
  163 FORMAT(' Number of top line to be shifted? ',$)
  164 FORMAT(' Number of bottom line to be shifted? ',$)
  165 FORMAT(
     1' Number of line before which above lines will be placed? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 166
      IF(MAXBFR.LE.0)GO TO 108
      LOWBFR=1
      GO TO 144
  166 CALL RSMHLP(ITTY,49,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 149
  167 IF(IVALUE.LE.0)GO TO 312
      DO 168 I=1,KNTLIN
      IF(IVALUE.NE.MARKER(I))GO TO 168
      JVALUE=I
      GO TO 169
  168 CONTINUE
      GO TO 312
C
C     DISPLAY THE SELECTED LINE
  169 LINE=JVALUE
      IFINAL=0
      I=1
  170 IF(I.GT.LINE)GO TO 171
      IFIRST=IFINAL+1
      IFINAL=IFINAL+LNGLIN(I)
      I=I+1
      GO TO 170
  171 CALL RSMTYP(ITTY,LMTTXT,LTRTXT,LMTLIN,LNGLIN,
     1IFIRST,IFINAL,0,JFIRST,JFINAL)
C
C     ASK IF THIS IS THE CORRECT LINE
  172 IF(KOMAND.EQ.1)WRITE(ITTY,173)
      IF(KOMAND.EQ.2)WRITE(ITTY,174)
      IF(KOMAND.EQ.3)WRITE(ITTY,175)
      IF(KOMAND.EQ.4)WRITE(ITTY,176)
      IF(KOMAND.EQ.7)WRITE(ITTY,177)
      IF(KOMAND.EQ.10)WRITE(ITTY,178)
      IF(KOMAND.EQ.16)WRITE(ITTY,179)
      IF(KOMAND.EQ.17)GO TO 186
      IF(KOMAND.EQ.20)GO TO 186
      IF(KOMAND.EQ.23)WRITE(ITTY,183)
      IF(KOMAND.EQ.101)WRITE(ITTY,184)
      IF(KOMAND.EQ.34)WRITE(ITTY,180)
      IF(KOMAND.EQ.102)WRITE(ITTY,181)
      IF(KOMAND.EQ.103)WRITE(ITTY,182)
  173 FORMAT(' Is this the line to be replaced? ',$)
  174 FORMAT(' Is this the line to be deleted? ',$)
  175 FORMAT(
     1' Is this the line before which new line is to be inserted? ',$)
  176 FORMAT(
     1' Is this the line after which new line is to be inserted? ',$)
  177 FORMAT(' Is this the line to start new line in output? ',$)
  178 FORMAT(' Is this the line to be merged with previous line? ',$)
  179 FORMAT(' Is this the line which is to bear bullet? ',$)
  180 FORMAT(' Is this top line to be shifted? ',$)
  181 FORMAT(' Is this bottom line to be shifted? ',$)
  182 FORMAT(
     1' Is this the line before which above lines are to be placed? ',$)
C     KOMAND = 17, EDIT
C     KOMAND = 20, TYPE
  183 FORMAT(
     1' Is this the line before which blank line is to be inserted? ',$)
  184 FORMAT(' Is this the line which is to start new section? ',$)
C
C     DETERMINE IF USER VERIFIES THAT THIS IS CORRECT LINE
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(172,172,186,108,185),KNDYES
  185 CALL RSMHLP(ITTY,50,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 172
  186 GO TO 188
C
C     REJECT SOME COMMANDS IF ARGUMENT FOLLOWS THEM
  187 IF(LOWBFR.GT.LMTBFR)GO TO 188
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 310
      LOWBFR=LOWBFR+1
      GO TO 187
C
C     TRANSFER TO CODE TO HANDLE EACH COMMAND
  188 IF(KOMAND.GT.100)GO TO 189
C
C     TRANSFER TO CODE TO PROCESS THE COMMAND
C     GO TO(REP DEL BEF AFT DRA SAV BRE LEN EXI JOI
C    1      CRE REN ONL ALL PRO BUL EDI SUB APP TYP
C    2      CAN PAP SKI MOV RUL UNR DEB FAS PAG FIL
C    3      NEW OLD SLO SWI
      GO TO(275,296,285,287,264,351,299,232,352,306,
     1      254,272,252,270,267,298,251,316,252, 111,
     2      240,333,284,221,190,211,210,206,208, 111,
     3       111, 111,204,191),KOMAND
  189 I=KOMAND-100
C
C     SECOND ARGUMENT OF SOME COMMANDS
C     GO TO(RUL,SW2,SW3),KOMAND-100
      GO TO(213,192,194),I
C
C     GET SECOND ARGUMENT OF RULE COMMAND
  190 KOMAND=101
      GO TO 123
C
C     GET SECOND ARGUMENT OF SWAP COMMAND
  191 ISWAP=JVALUE
      JSWAP=IFIRST
      KOMAND=102
      GO TO 123
C
C     GET THIRD ARGUMENT OF SWAP COMMAND
  192 KSWAP=JVALUE
      LSWAP=IFINAL
      KOMAND=103
      IF(ISWAP.LE.KSWAP)GO TO 123
      WRITE(ITTY,193)
  193 FORMAT(' First line must be above last line')
      GO TO 111
C
C     SWAP THE SECTIONS
  194 MSWAP=JVALUE
      IF(MSWAP.LT.ISWAP)GO TO 196
      IF(MSWAP.GT.KSWAP)GO TO 196
      WRITE(ITTY,195)
  195 FORMAT(' Destination line cannot be in region to be moved')
      GO TO 111
  196 J=0
      DO 197 I=1,MAXSEC
      K=J+1
      J=J+LNGSEC(I)
      IF(ISWAP.GT.J)GO TO 197
      IF(KSWAP.LT.K)GO TO 198
      IF(KSWAP.GT.J)GO TO 198
      IF(MSWAP.LT.K)GO TO 198
      IF(MSWAP.GT.J)GO TO 198
      NOWSEC=I
      GO TO 200
  197 CONTINUE
      GO TO 200
  198 WRITE(ITTY,199)
  199 FORMAT(' Lines must be in same section')
      GO TO 111
  200 CONTINUE
      IF(MSWAP.GT.ISWAP)GO TO 201
C     MOVE TO EARLIER LOCATION IN RESUME
      ISWAP=ISWAP-1
      CALL DASWAP(LNGLIN,MSWAP,ISWAP,KSWAP)
      CALL DASWAP(MARKER,MSWAP,ISWAP,KSWAP)
      JSWAP=JSWAP-1
      CALL DASWAP(LTRTXT,IFIRST,JSWAP,LSWAP)
      GO TO 202
C     MOVE TO LATER POSITION IN RESUME
  201 IFINAL=IFINAL-LNGLIN(MSWAP)
      MSWAP=MSWAP-1
      CALL DASWAP(LNGLIN,ISWAP,KSWAP,MSWAP)
      CALL DASWAP(MARKER,ISWAP,KSWAP,MSWAP)
      CALL DASWAP(LTRTXT,JSWAP,LSWAP,IFINAL)
  202 WRITE(ITTY,203)
  203 FORMAT(' Lines switched')
      KNTATO=KNTATO+INCATO
      GO TO 252
C
C     HARDCOPY TERMINAL ON WHICH FORM FEEDS ARE NOT WANTED
  204 IF(JVIDEO.NE.-1)WRITE(ITTY,205)
  205 FORMAT(' Ouput will be formatted for a slow terminal')
      JVIDEO=-1
      GO TO 111
C
C     SCROLLING TERMINAL ON WHICH FORM FEEDS ARE NOT WANTED
  206 IF(JVIDEO.NE.0)WRITE(ITTY,207)
  207 FORMAT(' Ouput will be formatted for fast video ',
     1'terminal which cannot clear screen')
      JVIDEO=0
      GO TO 111
C
C     VIDEO TERMINAL ON WHICH FORM FEEDS CLEAR SCREEN
  208 IF(JVIDEO.NE.1)WRITE(ITTY,209)
  209 FORMAT(' Output will be formatted for video ',
     1'terminal which can clear screen')
      JVIDEO=1
      GO TO 111
C
C     DIAGNOSTIC OUTPUT
  210 CALL RSMDBG(LMTBFR,LNGLIN,LNGSEC,LTRTXT,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,ITTY,
     3NUMWHO,IYEAR)
      GO TO 111
C
C     REMOVE A SECOND NAME
  211 CONTINUE
      CALL RSMMRG(LTRBFR,LMTBFR,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,NOWSEC)
      WRITE(ITTY,212)
  212 FORMAT(' The rule and section name have been removed')
      GO TO 111
C
C     SPLIT SECTION INTO TWO SECTION BEFORE SPECIFIED LINE
  213 IF(KNTLIN.GE.LMTLIN)GO TO 218
      IF(MAXSEC.GE.LMTSEC)GO TO 218
      LINE=JVALUE
C     MAKE SURE LINE ISN'T ALREADY AT START OF SECTION
      I=0
      J=0
  214 IF(LINE.EQ.(J+2))GO TO 216
      I=I+1
      J=J+LNGSEC(I)
      IF(LINE.GT.J)GO TO 214
      KNTLIN=KNTLIN-1
      CALL RSMRUL(LTRBFR,LMTBFR,LINE,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      WRITE(ITTY,215)
  215 FORMAT(' Section has been split')
      GO TO 220
  216 WRITE(ITTY,217)
  217 FORMAT(' Line is already at start of a section')
      GO TO 220
  218 WRITE(ITTY,219)
  219 FORMAT(' Insufficient storage to split section')
      GO TO 220
  220 NOWSEC=0
      GO TO 111
C
C     MOVE SECTION
  221 MOVSEC=NOWSEC
  222 WRITE(ITTY,223)
  223 FORMAT(' Place before which section? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.EQ.0)GO TO 229
      IF(MAXBFR.GT.0)GO TO 225
  224 MAXBFR=1
      LTRBFR(MAXBFR)=1H?
  225 LOWBFR=1
  226 KREATE=0
      CALL RSMTTL(KREATE,KNDTTL,NOWSEC,LMTLTT,MAXLTT,LTRTTL,
     1LMTSEC,MAXSEC,KNTTTL,IDISK,ITTY,LMTBFR,LTRBFR,LWRBFR,LOWBFR,
     2MAXBFR,LNGSEC,MARKER,LNGLIN,LMTLIN,KNTLIN,KNTTXT,IVIDEO)
      GO TO(222,227,227,222,222,222),KNDTTL
  227 CONTINUE
      CALL RSMMOV(NOWSEC,MOVSEC,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      KNTATO=KNTATO+INCATO
      WRITE(ITTY,228)
  228 FORMAT(' Section has been moved')
      GO TO 231
  229 WRITE(ITTY,230)
  230 FORMAT(' Section has not been moved')
  231 NOWSEC=0
      GO TO 111
C
C     CHECK FOR UNEXPECTED CHARACTERS IN RESUME
  232 IF(IPRINT.EQ.0)GO TO 237
      NOWSEC=0
      CALL RSMCUL(NOWSEC,ITTY,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,IERROR)
C
C     COUNT NUMBER OF LINES IN RESUME
      ILOCAL=-1
      NOWSEC=0
      IVIDEO=JVIDEO
      IVARY=0
      IF(IPRINT.GT.1)IVARY=LMTTYP
      JVARY=1
      KVARY=2
      LVARY=1
      MVARY=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      IVIDEO=0
      IF(IPRINT.GT.1)GO TO 234
      WRITE(ITTY,233)KNTOUT,LMTTYP
  233 FORMAT(
     1' Your resume will require',1I4,' lines if it is typed.'/
     2' The maximum length of a typed resume is',1I3,' lines.')
      GO TO 239
  234 IF(IONPAG.GT.LMTTYP)IONPAG=LMTTYP
      IF(KNTPAG.EQ.1)WRITE(ITTY,235)IONPAG,IPRINT,LMTTYP
  235 FORMAT(
     1' The length of your resume will be 1 typed page of',
     21I3,' lines.'/
     3' The maximum length of a typed resume is',1I3,
     4' pages, each of',1I3,' lines.')
      IF(KNTPAG.GT.1)WRITE(ITTY,236)KNTPAG,IONPAG,IPRINT,LMTTYP
  236 FORMAT(
     1' The length of your resume will be',1I3,' typed pages.'/
     2' The last page will contain',1I4,
     3' lines, counting the 3 header lines.'/
     4' The maximum length of a typed resume is',1I3,
     5' pages, each of',1I3,' lines.')
      GO TO 239
  237 ILOCAL=-1
      NOWSEC=0
      IVIDEO=JVIDEO
      IVARY=0
      JVARY=1
      KVARY=3
      LVARY=2
      MVARY=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      IVIDEO=0
      WRITE(ITTY,238)KNTOUT,LMTPRI
  238 FORMAT(1X/
     1' Your resume will require',1I4,' lines if it is typeset.'/
     2' The maximum length of a typeset resume is',1I3,' lines.')
  239 GO TO 111
C
C     CANCEL CURRENT RESUME
C
C     ASK IF USER WANTS TO CANCEL RESUME
  240 IF(IXYZZY.NE.0)GO TO 245
      CALL RSMHLP(ITTY,29,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
  241 WRITE(ITTY,242)
  242 FORMAT(' Do you really want to start over? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(241,241,244,111,243),KNDYES
  243 CALL RSMHLP(ITTY,51,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 241
  244 KANCEL=1
      GO TO 66
C
C     ASK IF ADMINSTRATOR WANTS TO CANCEL CHANGES
  245 CALL RSMHLP(ITTY,21,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
  246 WRITE(ITTY,247)
  247 FORMAT(' Do you really want to discard all changes? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(246,246,249,111,248),KNDYES
  248 CALL RSMHLP(ITTY,72,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 246
  249 WRITE(ITTY,250)
  250 FORMAT(' Cancelling all changes you have made to this resume')
      GO TO 19
C
C     EDIT LINE
  251 LINE=JVALUE
      CALL RSMEDT(LINE,LTRTXT,LNGLIN,LNGSEC,LMTSEC,MAXSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,ITTY,IERROR,LTRWID,LMTWID,MARKER,
     2IXYZZY,IVIDEO,JVIDEO,KNTATO)
      IF(IERROR.EQ.1)GO TO 296
      KOMAND=0
      GO TO 111
C
C     SELECT OLD SECTION
  252 CALL RSMRNG(NOWSEC,IFIRST,IFINAL,LNGSEC,LMTSEC)
      IF(KOMAND.EQ.103)GO TO 111
      IF(KOMAND.EQ.19)GO TO 255
      IF(IFIRST.GE.IFINAL)GO TO 255
      WRITE(ITTY,253)
  253 FORMAT(
     1' DRAFT and PROOF commands will display only this section')
      GO TO 111
C
C     INITIALIZE NEW SECTION
  254 CONTINUE
C
C     INITIAL INPUT OF LINE ITEMS
  255 CONTINUE
      WRITE(ITTY,256)
  256 FORMAT(' Type the text to be in this section.'/
     1' Type the ? key followed by the RETURN key to get',
     2' complete instructions.'/
     3' Press the RETURN key an extra time when you have',
     4' completed this section'/
     51X)
  257 WRITE(ITTY,258)
  258 FORMAT('+?',$)
      CALL GETLIN(ITTY,LTRWID,LMTWID,MAXBFR)
      IF(MAXBFR.EQ.0)GO TO 260
      IF(MAXBFR.GT.0)GO TO 259
      IVIDEO=JVIDEO
      CALL RSMHLP(ITTY,5,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
      GO TO 257
  259 CALL RSMRNG(NOWSEC,IFIRST,IFINAL,LNGSEC,LMTSEC)
      LINE=IFINAL
      CALL RSMPUT(LTRWID,MAXBFR,LINE,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MAXSEC,LMTSEC,MARKER,ITTY,0)
      KNTATO=KNTATO+INCATO
      GO TO 257
C
C     ASK IF USER REALLY MEANS TO EXIT FROM THIS SECTION
  260 WRITE(ITTY,261)
  261 FORMAT(' Have you finished this section? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(260,260,263,257,262),KNDYES
  262 CALL RSMHLP(ITTY,52,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 260
  263 CONTINUE
      GO TO 111
C
C     DRAFT OF RESUME
  264 IF(NOWSEC.EQ.0)GO TO 265
      IF(LNGSEC(NOWSEC).EQ.1)NOWSEC=0
  265 IVIDEO=JVIDEO
      CALL RSMRAW(NOWSEC,ITTY,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,
     3MAXBFR,LMTBFR,LTRBFR,IVIDEO,LNGCRT)
      IVIDEO=0
      GO TO 110
C
C     PROOF OF BOILERPLATE EDUCATION SECTION
  266 IVIDEO=0
      NOWSEC=MAXSEC
      GO TO 269
C
C     PROOF OF RESUME
  267 IF(NOWSEC.EQ.0)GO TO 268
      IF(LNGSEC(NOWSEC).EQ.1)NOWSEC=0
  268 IVIDEO=JVIDEO
  269 ILOCAL=1
      IVARY=0
      JVARY=1
      KVARY=1
      LVARY=2
      MVARY=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,IDISK,LTRTXT,LNGLIN,
     1LNGSEC,LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      IVIDEO=0
      IF(IVERSN.EQ.0)GO TO 106
      GO TO 110
C
C     SELECT ALL SECTIONS
  270 NOWSEC=0
      WRITE(ITTY,271)
  271 FORMAT(' DRAFT and PROOF commands will display all sections')
      GO TO 111
C
C     RENAME SECTION
  272 IF(NOWSEC.EQ.0)GO TO 273
      CALL RSMRNM(ITTY,NOWSEC,LMTLTT,MAXLTT,LTRTTL,
     1LMTSEC,MAXSEC,KNTTTL,LMTBFR,LTRBFR,LWRBFR)
      KNTATO=KNTATO+INCATO
      GO TO 111
  273 WRITE(ITTY,274)
  274 FORMAT(' No section has been selected')
      GO TO 111
C
C     CHANGE LINE
  275 LINE=JVALUE
      IF(LINE.EQ.0)GO TO 312
      WRITE(ITTY,276)
  276 FORMAT(' Type the new contents of the line')
  277 WRITE(ITTY,278)
  278 FORMAT(' ?',$)
      CALL GETLIN(ITTY,LTRWID,LMTWID,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 281
      IF(MAXBFR.EQ.0)GO TO 282
      IF(MAXBFR.GT.1)GO TO 279
  279 CALL RSMKIL(LINE,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,LMTSEC,MARKER)
      LINE=JVALUE-1
      CALL RSMPUT(LTRWID,MAXBFR,LINE,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MAXSEC,LMTSEC,MARKER,ITTY,0)
      MARKER(JVALUE)=IVALUE
      KNTATO=KNTATO+INCATO
      WRITE(ITTY,280)
  280 FORMAT(' The previous contents of the line have been replaced')
      GO TO 111
  281 CALL RSMHLP(ITTY,26,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 277
  282 WRITE(ITTY,283)
  283 FORMAT(' The previous contents of the line are being kept')
      GO TO 111
C
C     SKIP LINE
  284 MAXBFR=1
      LTRWID(1)='*'
      LINE=JVALUE-1
      GO TO 292
C
C     INSERT LINE
  285 LINE=JVALUE
      IF(LINE.EQ.0)GO TO 312
      LINE=LINE-1
      WRITE(ITTY,286)IVALUE
  286 FORMAT(
     1' Type the line of text to be inserted before line',1I5)
      GO TO 289
  287 LINE=JVALUE
      IF(LINE.EQ.0)GO TO 312
      WRITE(ITTY,288)IVALUE
  288 FORMAT(
     1' Type the line of text to be inserted after line',1I5)
  289 WRITE(ITTY,290)
  290 FORMAT(' ?',$)
  291 CALL GETLIN(ITTY,LTRWID,LMTWID,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 293
      IF(MAXBFR.EQ.0)GO TO 294
  292 CALL RSMPUT(LTRWID,MAXBFR,LINE,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MAXSEC,LMTSEC,MARKER,ITTY,1)
      KNTATO=KNTATO+INCATO
      GO TO 111
  293 CALL RSMHLP(ITTY,26,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 289
  294 WRITE(ITTY,295)
  295 FORMAT(' A new line has not been inserted')
      GO TO 111
C
C     DELETE LINE
  296 LINE=JVALUE
      IF(LINE.EQ.0)GO TO 312
      CALL RSMKIL(LINE,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,LMTSEC,MARKER)
      KNTATO=KNTATO+INCATO
      WRITE(ITTY,297)
  297 FORMAT(' The line has been deleted')
      GO TO 111
C
C     MARK LINE AS STARTING NEW PARAGRAPH
  298 IBULLT=1
      GO TO 300
  299 IBULLT=0
  300 LINE=JVALUE
      IF(LINE.EQ.0)GO TO 312
      CALL RSMGLU(LINE,LTRTXT,LNGLIN,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,IERROR)
      CALL RSMCUT(LINE,LTRTXT,LNGLIN,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,IERROR,IBULLT)
      IF(IERROR.NE.0)GO TO 303
      IF(IBULLT.EQ.0)WRITE(ITTY,301)
  301 FORMAT(' Inserting * at start of line')
      IF(IBULLT.EQ.1)WRITE(ITTY,302)
  302 FORMAT(' Inserting - at start of line')
  303 IF(IERROR.EQ.1)WRITE(ITTY,304)
  304 FORMAT(' Line already contains *')
      IF(IERROR.EQ.2)WRITE(ITTY,305)
  305 FORMAT(' Character storage full, cannot insert *')
      GO TO 111
C
C     JOIN LINE TO PREVIOUS LINE
  306 LINE=JVALUE
      IF(LINE.EQ.0)GO TO 312
      CALL RSMGLU(LINE,LTRTXT,LNGLIN,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,IERROR)
      IF(IERROR.EQ.0)WRITE(ITTY,307)
  307 FORMAT(' * or - removed from start of line')
      IF(IERROR.EQ.1)WRITE(ITTY,308)
  308 FORMAT(' * or - does not appear at start of line')
      IF(IERROR.EQ.2)GO TO 296
      GO TO 111
C
C     WRITE HELP MESSAGE
  309 IVIDEO=JVIDEO
      CALL RSMHLP(ITTY,2,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
      GO TO 110
C
C     ERROR MESSAGES
  310 WRITE(ITTY,311)
  311 FORMAT(' Type ? for instructions')
      GO TO 111
  312 WRITE(ITTY,313)IVALUE
  313 FORMAT(' ',1I5,' is not currently a line number')
      GO TO 111
  314 WRITE(ITTY,315)
  315 FORMAT(' No lines have been defined')
      GO TO 111
C
C     ASK USER IF RESUME IS REALLY FINISHED
  316 IF(IPRINT.EQ.0)GO TO 320
      NOWSEC=0
      CALL RSMCUL(NOWSEC,ITTY,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,IERROR)
      IF(IERROR.EQ.0)GO TO 318
      WRITE(ITTY,317)
  317 FORMAT(' You must remove these characters before',
     1' your resume can be submitted.')
      GO TO 111
  318 ILOCAL=-1
      NOWSEC=0
      IVIDEO=JVIDEO
      IVARY=0
      IF(IPRINT.GT.1)IVARY=LMTTYP
      JVARY=1
      KVARY=2
      LVARY=1
      MVARY=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      IVIDEO=0
      IF(IPRINT.EQ.1)GO TO 319
      IF(KNTPAG.LE.IPRINT)GO TO 322
      WRITE(ITTY,236)KNTPAG,IPRINT
      WRITE(ITTY,321)
      GO TO 111
  319 IF(KNTOUT.LE.LMTTYP)GO TO 322
      WRITE(ITTY,233)KNTOUT,LMTTYP
      WRITE(ITTY,321)
      GO TO 111
  320 ILOCAL=-1
      NOWSEC=0
      IVIDEO=JVIDEO
      IVARY=0
      JVARY=1
      KVARY=3
      LVARY=2
      MVARY=0
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      IVIDEO=0
      IF(KNTOUT.LE.LMTPRI)GO TO 322
      WRITE(ITTY,238)KNTOUT,LMTPRI
      WRITE(ITTY,321)
  321 FORMAT(' Your resume must be shortened before it c',
     1'an be submitted.'/1X)
      GO TO 111
  322 IF(IXYZZY.NE.0)GO TO 327
  323 CALL RSMHLP(ITTY,27,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
  324 WRITE(ITTY,325)
  325 FORMAT(
     1' Is your resume really ready to be submitted for printing? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(324,324,327,111,326),KNDYES
  326 CALL RSMHLP(ITTY,53,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 324
  327 ISTATE=2
      IFDONE=4
      GO TO 353
C
C     ************************
C     *                      *
C     *  WRITE OUTPUT FILES  *
C     *                      *
C     ************************
C
C     ALLOW PAPER COPY OF A PREVIOUSLY SUBMITTED RESUME
  328 CALL RSMHLP(ITTY,25,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
  329 WRITE(ITTY,330)
  330 FORMAT(
     1' Do you want a copy of your resume? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(329,329,332,383,331),KNDYES
  331 CALL RSMHLP(ITTY,54,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 329
  332 IFDONE=6
      GO TO 334
C
C     USER REQUESTED FILE FOR PAPER COPY
  333 IFDONE=1
      GO TO 334
C
C     ASK USER WHAT TYPE OF PAPER COPY IS WANTED
  334 IF(IPRINT.NE.0)WRITE(ITTY,335)
  335 FORMAT(' PRINTED or TYPED output? ',$)
      IF(IPRINT.EQ.0)WRITE(ITTY,336)
  336 FORMAT(' PRINTED, TYPED or TYPESET output? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 337
      IF(MAXBFR.EQ.0)GO TO 348
      LOWBFR=1
      CALL DAVERB(1,33,LTRLPT,1,6,
     1LNGLPT,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(339,339,341,341,338),KIND
  337 IVIDEO=JVIDEO
      IF(IPRINT.NE.0)CALL RSMHLP(ITTY,41,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IF(IPRINT.EQ.0)CALL RSMHLP(ITTY,28,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
      GO TO 334
  338 IF(MATCH.EQ.3)GO TO 341
  339 WRITE(ITTY,340)
  340 FORMAT(' Type ? for instructions')
      GO TO 334
  341 IF(LOWBFR.GT.MAXBFR)GO TO 342
      IF(LTRBFR(LOWBFR).NE.1H )GO TO 339
  342 GO TO(343,344,345,346,344,344),MATCH
C     NARROW
  343 IVARY=LMTTYP
      JVARY=2
      KVARY=1
      LVARY=1
      MVARY=-1
      NVARY=1
      GO TO 347
C     PRINTED
  344 IVARY=LMTTYP
      JVARY=2
      KVARY=2
      LVARY=1
      MVARY=-1
      NVARY=2
      GO TO 347
C     TYPED
  345 IVARY=LMTTYP
      JVARY=3
      KVARY=2
      LVARY=1
      MVARY=-1
      NVARY=3
      GO TO 347
C     TYPESET
  346 IVARY=0
      JVARY=2
      KVARY=3
      LVARY=2
      MVARY=-1
      NVARY=4
  347 IF(IFDONE.EQ.6)GO TO 363
      GO TO 353
  348 IF(IFDONE.EQ.6)GO TO 329
      GO TO 108
C
C     AUTOMATIC SAVE
  349 WRITE(ITTY,350)
  350 FORMAT(' What next? SAVE')
      IFDONE=5
      GO TO 353
C
C     SAVE COMMAND
  351 IFDONE=2
      GO TO 353
C
C     COMMANDS WHICH IMPLY SAVE COMMAND
  352 IFDONE=3
  353 KNTATO=0
      CALL RSMOPN(5,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
      IF(IVERSN.GT.999)IVERSN=999
      IF(IXYZZY.NE.0)GO TO 354
      CALL NEWDAT(JDAY,JMONTH,JYEAR)
      JYEAR=JYEAR-(100*(JYEAR/100))
      GO TO 355
  354 ISTATE=4
  355 IF(IPRINT.GT.9)IPRINT=9
      WRITE(IDISK,356)ISTATE,IPRINT,IVERSN,IYEAR,
     1JDAY,JMONTH,JYEAR,NUMWHO,LTRWHO,LTRPSW
  356 FORMAT(2I1,2I3,3I2,1I6,40A1,20A1)
      CALL RSMSAV(NOWSEC,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL)
      CALL RSMCLS(5,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      GO TO(363,359,361,362,357),IFDONE
  357 WRITE(ITTY,358)
  358 FORMAT(' The current version of your resume has be',
     1'en automatically saved.')
      GO TO 111
  359 IF(IXYZZY.NE.0)GO TO 46
      WRITE(ITTY,360)
  360 FORMAT(' The current version of your resume has been saved.')
      GO TO 111
  361 IF(IXYZZY.NE.0)GO TO 46
      CALL RSMHLP(ITTY,22,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 383
  362 IF(IXYZZY.NE.0)GO TO 46
      CALL RSMHLP(ITTY,23,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 329
C
C     CLEAR SCREEN IF VIDEO TERMINAL
  363 CONTINUE
C     IVIDEO=JVIDEO
C     CALL RSMHLP(ITTY,0,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
C     IVIDEO=0
      IF(ISTATE.LT.2)WRITE(ITTY,364)
  364 FORMAT(' The current version of your resume has been saved.')
C
C     OPEN THE PROOF FILE
      IF(IXYZZY.NE.0)GO TO 365
      IF(ICHECK.EQ.0)GO TO 365
      CALL TTYSIM(IDISK)
      CALL RSMOPN(7,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
      GO TO 366
  365 CALL TTYSIM(IDISK)
      CALL RSMOPN(6,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
  366 CONTINUE
C
C     WRITE THE PROOF FILE
      ILOCAL=0
      NOWSEC=0
      IVIDEO=JVIDEO
      CALL RSMPRF(NOWSEC,ILOCAL,ITTY,IDISK,LTRTXT,LNGLIN,LNGSEC,
     1LMTTXT,LMTLIN,KNTTXT,KNTLIN,MARKER,
     2LMTLTT,MAXLTT,LTRTTL,LMTSEC,MAXSEC,KNTTTL,KNTOUT,IVARY,JVARY,
     3KVARY,LVARY,MVARY,LTRWID,LMTWID,MAXBFR,LMTBFR,LTRBFR,IVIDEO,
     4LNGCRT,KNTPAG,IONPAG)
      IVIDEO=0
      IF(JVARY.EQ.3)GO TO 368
      IF(ISTATE.GE.2)GO TO 368
      CALL NEWDAT(JDAY,JMONTH,JYEAR)
      JYEAR=JYEAR-(100*(JYEAR/100))
      WRITE(IDISK,367)IVERSN,JMONTH,JDAY,JYEAR,LTRWHO
  367 FORMAT(1X/' Version:',1I4,1X,1I2,'/',1I2,'/',1I2,1X,40A1)
  368 CONTINUE
      IF(IXYZZY.NE.0)GO TO 369
      IF(ICHECK.EQ.0)GO TO 369
      CALL RSMCLS(7,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
      GO TO 370
  369 CALL RSMCLS(6,NUMWHO,IYEAR,ITTY,IDISK,IFCLOS)
  370 CONTINUE
C
C     TELL USER HOW TO HANDLE THE OUTPUT FILE
      GO TO(371,372,373,374),NVARY
C
C     TELL USER HOW TO HANDLE NARROW OUTPUT
  371 CALL RSMHLP(ITTY,38,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 375
C
C     TELL USER HOW TO HANDLE WIDE OUTPUT
  372 CALL RSMHLP(ITTY,43,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 375
C
C     TELL USER HOW TO HANDLE TYPED OUTPUT
  373 CALL RSMHLP(ITTY,24,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 375
C
C     TELL USER HOW TO HANDLE PRINTED OUTPUT
  374 CALL RSMHLP(ITTY,42,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
C
C     TELL USER HOW TO USE LINE PRINTER
  375 IF(IXYZZY.NE.0)GO TO 379
      IF(NVARY.EQ.3)GO TO 377
      IF(ICHECK.NE.0)GO TO 376
      CALL RSMHLP(ITTY,70,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 379
  376 CALL RSMOPN(16,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
      GO TO 379
C
C     TELL USER HOW TO USE LETTER QUALITY PRINTER
  377 IF(ICHECK.NE.0)GO TO 378
      CALL RSMHLP(ITTY,71,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 379
  378 CALL RSMOPN(17,NUMWHO,IYEAR,ITTY,IDISK,IFOPEN)
  379 GO TO 383
C
C     TELL USER THAT HE/SHE IS NOT ALLOWED TO RUN PROGRAM
  380 WRITE(ITTY,381)
  381 FORMAT(' You are not allowed to run this program.')
      GO TO 383
C
C     NUMBER ASSOCIATED WITH MORE THAN 1 PASSWORD
  382 CALL RSMHLP(ITTY,69,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 383
C
C     EXIT WITHOUT THE TIME STAMP USUALLY GIVEN BY FORTRAN
  383 CALL LEAVE
      STOP
      END
