National Defense Research Institute    1977-03-05  Revised: 1977-11-30
S-104 50 Stockholm 80
SWEDEN




VIDED - A DISPLAY-ORIENTED TEXT EDITOR

     By Jacob Palme


     ABSTRACT: VIDED is a text editor, that is a computer program
     used to produce, correct and modify texts stored in the
     computer. VIDED uses display terminals, and is based on the
     idea that the screen of the terminal should always show a
     section of text from the text file being edited.

     After an editing operation, both the text in the computer and
     the image on the screen are immediately changed to represent
     the new text. The user can directly and immediately see the
     effect of his editing.

     VIDED can thus not be used on printing terminals.

     VIDED contains facilities for reformatting sections of text to
     get lines and pages of desired size after additions and
     deletions, including renumbering of pages. VIDED will thus not
     only replace conventional text editors, but also postprocessors
     like RUNOFF.

     VIDED is intended for use on many different kinds of display
     terminals, but the first version will only work on:

  A) INFOTON VISTA terminals with 20 lines of 80 characters
     per line.

  B) INFOTON VISTAR SATTELITE terminals with 24 lines of 80
     characters per line.

  B) MINITEC terminals with 24 lines of 80 characters per line.

  C) DATAMEDIA ELITE 1520 terminals without the auto-lf feature.

  D) TELETEC terminals with 24 times 80 characters.

  E) TANDBERG TDV 2000 terminal (See chapter 4.1).

  F) MINIBEE and BEEHIVE B 100 terminal (See chapter 4.3).

  G) CDC 713-10 terminal (See chapter 4.4).

     The manual you are now reading has been produced with VIDED.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 2


TABLE OF CONTENTS:

     0. TABLE OF CONTENTS

     1. INTRODUCTION TO THE USE OF VIDED

          1.1  WHAT IS VIDED?
          1.2  CURSOR MOVEMENT, PART I
          1.3  INPUTTING COMMANDS WITHOUT SPECIAL KEYS
          1.4  CURSOR MOVEMENT, PART II
          1.5  TEXT INSERTION
          1.6  TEXT DELETION
          1.7  PARAGRAPH JUSTIFICATION
          1.8  MOVING AND COPYING
          1.9  PAGE HANDLING
          1.10 STATUS, HELP AND RESTORATION
          1.11 EXITING FROM VIDED

     2. FULL DESCRIPTION OF THE VIDED COMMANDS

          2.1  STARTING AN EDITING SESSION
          2.2  TYPING TEXT
          2.3  TYPING COMMANDS TO VIDED
          2.4  CURSOR MOVEMENT
          2.5  TEXT INSERTION COMMANDS
          2.6  TEXT DELETION COMMANDS
          2.7  PARAGRAPH JUSTIFICATION COMMANDS
          2.8  MOVING AND COPYING
          2.9  PAGE HANDLING
          2.10 STATUS, HELP and RESTORATION COMMANDS
          2.11 EXITING FROM VIDED
          2.12 RESTRICTIONS IN VIDED

     3. ONE-PAGE SUMMARIES

          3.1  ONE-PAGE SUMMARY OF VIDED COMMANDS
          3.2  ONE-PAGE SUMMARY OF DEC 10 TEXT HANDLING COMMANDS

     4. INFORMATION FOR VARIOUS TERMINALS

          4.1  TANDBERG TDV 2000
          4.2  ELITE 1520
          4.3  MINIBEE, BEEHIVE B 100 AND DEC VT52
          4.4  CDC 713-10

     5. INDEX
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 3


1. INTRODUCTION TO THE USE OF VIDED.

1.1 WHAT IS VIDED?

     VIDED is a computer program to handle long and short texts
     which are stored in a computer.

     VIDED can only be used on display terminals. The screen of the
     terminal shows a window of the text you are editing.

     You can type on the terminal just as you type on a typewriter.
     There is a special marker called "cursor" which shows where the
     next character typed by you will appear on the screen.

     The RETURN key on your terminal is used to get to the beginning
     of the next line. If you use the RETURN key at the bottom of
     the screen, the whole screen will "scroll", that is roll up one
     line. The top line will then disappear from the screen, but it
     is saved by the computer. A new blank line will appear at the
     bottom of the screen.

     If you want to correct an error or modify what you have already
     written, there are a number of commands which you can give to
     the computer. These commands allow you to insert, delete and
     move portions of the text without rewriting anything already
     written.

     After each such command, the screen will immediately show the
     text after the change.

     When you have finished with VIDED, the text is saved by the
     computer and you can type it out on a printing terminal.

     You can also use VIDED on a saved text, if you want to add to,
     delete from or change the text.

     When you enter VIDED to work on an already existing text, there
     are commands to move to the portion of the text where you want
     to make your modification.

     When you push the RETURN key at the bottom of the screen during
     the editing of an already existing text, the screen will scroll
     and show one more line from the input text.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 4
1.1 WHAT IS VIDED?

     VIDED is suitable also for putting simple pictures, flow
     diagrams and tables into your text. Here are some examples:

       ------------------------------------------------------------
       !  How to answer ! Fact --> ! Yes  ! No       ! Neither    !
       !                -------------------------------------------
       !  questions and ! Question ! Yes  ! No       ! Don't know !
       !                -------------------------------------------
       !  statements:   ! State-   ! I    ! Not      ! Accepted   !
       !                ! ment     ! know ! possible !            !
       ------------------------------------------------------------


----------------------------------------------------------------------
!                                                                    !
!       ^                                 __________                 !
!      / \                                !        !                 !
!     / o \            --------<---NO-<---! READY? !--->-YES---      !
!    / o o \           !                  !________!          !      !
!   / o o o \          V                      !               V      !
!  /_________\    _________      ________     !           ________   !
!  ! O O O O !    !       !      !      !     !           !      !   !
!  ! O O O O !    ! START !----->! EDIT !-->---           ! STOP !   !
!  ! O O O O !    !_______!      !______!                 !______!   !
!  ! O O O O !        ^                                       !      !
!  ! O O O O !        !                                       V      !
----------------------------------------------------------------------


             !
       1.00 -!- - - - - - oooooo  - - - - - - - - - - - - - - - - - -
             !          oo      oo
             !        oo          oo
             !       o              o
             !     oo                oo
             !    o                    o
             !   o                      o
       0.00  !--o------------------------o------------------------o---
             !                           ^o                      o
             !  The curve intersects     ! o                    o
             !  zero at this point ---->--  oo                oo
             !                                o              o
             !                                 oo          oo
             !                                   oo      oo
      -1.00 -!- - - - - - - - - - - - - - - - - -  oooooo - - - - - -
             !
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 5
1.1 WHAT IS VIDED?


                          \ ! /
                     ------(*)------     ____________________
                          / ! \         /                    \                /
                            !          /                      \    \___/     /
  ((               ))                 /                        \  _(o.o)    /
  ! \_____________/ !                /                          \/___,,!___/___
  !  \           /  !_______________/________________            \
  !   (0) \ / (0)   !===    ===   ==  =  ==          \            \       _____
__!_______ ! _______!__       ===   ===  = /    //    \            \     /
----------.!.----------            ===  = / //         \            \   /
  /\   \__/ \__/   /         \  ==   ==  !     !!     \\\            \ /
 !   \___________/           /           ! !!            \            /
 !                          /         ___!___        /\\  \ _________/
 \________!     !________  /_________/              /  \   !         \_______tm
 /        \_____/        \/         (_(_(_(__/_____/    \\\\
(_(__(__(__)   (_)__)__)__)

(This beautiful wolf was created by Tomas Moll.)

1.2 CURSOR MOVEMENT, PART I

     There are a number of special keys and commands which you can
     use to move the cursor on the screen. After moving the cursor,
     you can type new text which will replace the previous text.

     There are four special keys on your terminal with arrows
     pointing up, down, left and right. Pushing one of these keys
     will move the cursor one step in each direction.

     (If your terminal does not have these special keys, see section
     2.4.)

     The key labelled HOME on your terminal will move the cursor to
     the upper left corner of the screen.

     The key labelled RETURN will move the cursor to the beginning
     of the next line.

     The key labelled TAB will move the cursor to the next TAB
     position.

1.3 INPUTTING COMMANDS WITHOUT SPECIAL KEYS

     There are not enough special keys on your terminal for all
     commands you can give to VIDED. The printing keys must
     therefore be used. To tell VIDED that what you are typing is a
     command to VIDED, and not something to be inserted on the
     screen, you start such commands by pushing a special command
     starting key.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 6
1.1 WHAT IS VIDED?

     This key is labelled ESC on INFOTON and MINITEC terminals. On
     other terminals the key may be labelled ESCAPE or ALTMODE.

     When you push this key, the character & will appear on the
     screen. You can then type the command. When the command is
     ready, it will disappear from the screen and the text which was
     overwritten by the command will be restored.

     Some of the special commands have to be finished by pushing the
     RETURN key on your terminal.

1.4 CURSOR MOVEMENT, PART II

     The "&X" command will move the cursor past all text on the
     current line.

     Example:

     Mary had a little lamb.
     ^
     You type the "&X" command:

     &Xry had a little lamb.
       ^
     And the computer moves the cursor:

     Mary had a little lamb.
                            ^
     The "&S" command can be used to search for a certain part of
     the text.

     Example:

     Mary had a little lamb.
     ^
     "&Slittle" will move the cursor to:

     Mary had a little lamb.
                      ^
     The "&N" command is similar to the "&S" command, but will
     search past the end of the screen into unread parts of the text
     you are editing.

1.5 TEXT INSERTION

     When you type text at the position of the cursor, existing text
     will be overwritten. There are special commands to insert
     text without overwriting.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 7
1.1 WHAT IS VIDED?


     The "&I" command is used to insert new text. Example:

     Mary had a little lamb.
                       ^
     The "&Iblack " command will change this to:

     Mary had a little black lamb.

     The "&nL" command inserts blank lines. If you, for example,
     want to insert five blank lines, type "&5L". "&L" is equivalent
     to "&1L".

     A simple way to delete text is to overwrite it with blanks or
     with other text.

     The key labelled DEL or DELETE or RUBOUT on your terminal will
     remove the last character and move the cursor back, so that you
     can correct it.

     Example:

     Mary had a littlr
                      ^
     Here, RUBOUT will give you:

     Mary had a littl
                     ^
     So that you can type in the correct character "e".

     The "&W" command removes the last line.
     The "&U" command removes the whole previous line.

     The "&K" command removes lines after the cursor.
     "&K" removes one line, "&5K" removes five lines.

     The "&nD" command will delete n characters and move the rest of
     the line back. Example:

     Mary had a littler lamb.
                      ^
     Here, "&D" will remove the "r" in "littler" and move " lamb."
     back to give you:

     Mary had a little lamb.
                      ^
     By typing "&5D" you can delete 5 characters in the same way.

1.7 PARAGRAPH JUSTIFICATION

     When you have added and deleted words in a paragraph, the lines
     are often uneven. The "&J" command will move words from line to
     line to make the paragraph more even.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 8
1.7 PARAGRAPH JUSTIFICATION

     Example:

     Jack and Jill went up the hill. Jill came tumbling after.
                                    ^
     To insert "Jack fell down." after "hill." you can first type
     "&L" to get blank space for the insertion:

     Jack and Jill went up the hill.
                                     Jill came tumbling after.

     You can then add the new sentence:

     Jack and Jill went up the hill. Jack fell down.
                                     Jill came tumbling after.

     Then move the cursor to the beginning of the paragraph and type
     "&J" to justify the paragraph, and you will get:

     Jack and Jill went up the hill. Jack fell down. Jill came
     tumbling after.

1.8 MOVING AND COPYING

     By typing "&Qreg 5" you will store a copy of the next five
     lines in a storage area under the name "reg". You can later get
     back this stored text with the command "&Greg".

1.9 PAGE HANDLING

     The command "&Z" will scroll the screen and at the same time
     take in lines from the input file. For example, "&5Z" will
     output the top five lines of the screen and instead take in
     five lines from the input file at the bottom of the screen.

     The command "&P" will move the screen to the top of the next
     page. By typing "&4P" you can move directly four pages forward
     in the text.

     By typing "&0P" you can get back to the top of the current
     page, and by typing "&P0E" you can get to the bottom of the
     current page.

     The "&PI" command divides a page into two pages at the
     cursor position.

     New pages inserted with the "&PI" command get the same header
     and subheader as the previous page, except that the page number
     in the header is increased by 1.

     Every time you modify a text, the date of this revision will be
     put into the first line of the first page of the text.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 9

1.10 STATUS, HELP AND RESTORATION

     The "&O" gives information on which file you are editing, where
     you are in the file etc.

     The "&H" command prints a summary of the VIDED commands.

     The "&R" command restores a jumbled screen.

1.11 EXITING FROM VIDED

     The "&E" command finishes the current VIDED session.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 10

2. FULL DESCRIPTION OF THE VIDED COMMANDS

2.1 STARTING AN EDITING SESSION

     Type the command "RUN VIDED[106,346]" to the DEC-10 monitor.
     VIDED will then respond with a prompter:
     *

     Type the name of the file you want to edit or create.
     Example:
     *FIL.EXT

     You can also type the monitor command
     "RUN VIDED[106,346]-FIL.EXT" to get directly into the file you
     want to edit.

     If you use VIDED several times during a terminal session on the
     same file, you need only give the file name the first time. The
     next time, just type "RUN VIDED[106,346]-".

     If no file called FIL.EXT exists, VIDED will produce a new
     file.

     IF a file called FIL.EXT does exist, VIDED will produce a
     modified version of this file. The previous version of the file
     will be kept, but renamed to FIL.QXT, the same filename but
     with the first letter of the extension changed to Q.

     IF you want VIDED to edit an input file and produce an edited
     copy with another name, write the new name, =, and the old
     name. Example:
     *NEW.EXT=OLD.EXT

     You can also give other information on this initial line of
     data to VIDED by giving switches. Switches are preceded by "/".
     The following switches exist:

  >  The switch /T tells VIDED what kind of display terminal you are
     using. For example:
     *NEW.FIL=OLD.FIL/T:1
     will tell VIDED that you are using a terminal of type 1, that
     is an INFOTON VISTA terminal.

     Here is a list of the numbers for different kinds of terminals:
     1  INFOTON VISTA WITH 20 LINES
     2  DEC VT52 (Not yet working)
     3  MINITEC
     4  ELITE 2500 WITH AUTO-LF FUNCTION (Not yet working)
     5  ELITE 2500 WITHOUT AUTO-LF FUNCTION (Not yet working)
     6  ELITE 1520 WITH AUTO-LF FUNCTION (Not yet working)
     7  ELITE 1520 WITHOUT AUTO-LF FUNCTION
     8  TELETEC
     9  INFOTON VISTAR SATTELITE
     10 TANDBERG TDV 2000
     11 BEEHIVE B 100
     12 CDC 713-10
     99 INFOTON VISTA WITH 24 LINES SCREEN
     0  Other kind of terminal (probably not working)
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 11
2.1 STARTING AN EDITING SESSION

  >  /N:n if you want VIDED to produce a line-numbered file with the
     increment n between successive line numbers. This switch is not
     necessary if the input file is already line-numbered.

  >  /-N if you want VIDED to remove line numbers from a line-
     numbered input file.

  >  /MP:n to indicate maximum number of lines per page. The default
     value is 56.

  >  /ML:n to indicate left margin. Default is 5.

  >  /MR:n to indicate right margin. Default is 68.

  >  /L:n to tell VIDED the number of lines on the screen of your
     terminal.

  >  /P to indicate that you want titles and page numbers at the top
     of each page, and date on the first line of the first page.

  >  /-P to indicate that you do not want titles, page numbers and
     date.

     If you give neither /P nor /-P then VIDED will assume /-P for
     files with extensions typical for RUNOFF files and source
     program files (e.g. ".FOR") and /P for all other files.

     You can change the default values assumed by VIDED for these
     switches by a line in your SWITCH.INI file. For example, if
     your SWITCH.INI file includes the line
     "VIDED /MP:100/ML:0/-P"
     then VIDED will assume these default values for you.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 12

2.2 TYPING TEXT

     The display screen will always show a part of the text being
     edited. This means that when you are editing a new file, the
     screen will initially be blank.

     Any printable character you type will immediately be placed on
     the screen and in the text file at the position of the cursor
     on the screen. You can thus just begin to type the text of your
     file, it will be shown on the screen and put into the file in
     the computer.

2.3 TYPING COMMANDS TO VIDED

     There are a number of commands which you can give to VIDED to
     insert text, delete text, stop editing etc. To indicate to the
     computer that you are typing a command to VIDED and not text to
     be inserted into the file, you start by typing a special key
     which indicates "start of a command".

     This special key is not the same on all display terminals,
     on the INFOTON VISTA terminal you can use the ESCAPE key.
     (On some other terminals you have to type ESCAPE(ALTMODE)
     twice or use the CONTROL-F key.)

     The character "&" will show on your screen to indicate that the
     computer has received this special key input and is waiting for
     a command to VIDED. In the examples below, the character "&"
     means this special command key and not the actual character
     "&".

     Do not be afraid to type a VIDED command on top of other
     text on the screen. The command will be wiped out and the
     text below it restored as soon as you have typed in the full
     command.

     As an example of a VIDED command, the H (Help) command will
     give a list of the VIDED commands. Thus, to get a list of
     the VIDED commands, you just type ESCAPE(ALTMODE) (twice on
     some terminals) or CONTROL-F followed by the letter "H" or
     "h". This command is called the "&H" command.

2.4 CURSOR MOVEMENT

     The cursor on the screen indicates where text which you type
     in will be put. There are several commands to move the
     cursor to a desired position on the screen.

     The CARRIAGE RETURN key will move the cursor to the beginning
     of the next line. If you are on the last line, the CARRIAGE
     RETURN will cause the screen to scroll, that is move up one
     line and bring in a new blank line.

VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 13
2.4 CURSOR MOVEMENT

     There are four special keys on your terminal with arrows
     pointing LEFT, RIGHT, UP and DOWN. These keys can be used to
     move the cursor in the desired direction. The key labelled
     "HOME" can be used to move the cursor to the upper left
     corner of the screen.

     (NOTE: If you have a DATAMEDIA ELITE 1520 terminal without the
     optional "numeric" keyboard, your terminal lacks these four
     keys. See chapter 4.2 about how to handle such terminals.)

  &X (END OF LINE) COMMAND:
     The "&X" command will move the cursor past all non-blank
     characters on the current line. For example, assume that the
     current line is:

     Mary had a little lamb.

     The "&X" command will then move the cursor to the blank
     position immediately after "lamb.".


  &Ah v (ADRESS SCREEN) COMMAND:
     The "&Ah v" command will move the cursor to the given position
     on the screen, counted from the upper left corner. Finish with
     RETURN or SPACE. For example "&A30 5" will move the cursor to
     position 30 of line 5 on the screen.

  &S (SEARCH) COMMAND:
     The "&S<search string>" command will search the screen for the
     search string immediately following "&S", beginning the search
     at the current screen position. If this string is found, then
     the cursor is placed after it. If the string cannot be found on
     the screen, the cursor is not moved.

     Assume for example that the screen contains the line:

     Jack and Jill went up the hill.
     ^
     If the cursor is at the beginning of the line, then the command
     "&Sill" will move the cursor to the position after "Jack and
     Jill". If the command "&Sill" is given once more, the cursor is
     moved to the dot after "hill".

     If you want to search for the same string as in the last
     search, you need not give any search string at all. Thus, in
     the example above, you could give just the command "&S" instead
     of "&Sill" the second time.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 14
2.4 CURSOR MOVEMENT


     The end of the search string can be indicated either by pushing
     the RETURN key, or by pushing the command indicating key
     (ALTMODE(ESCAPE) or CONTROL-F).

     The "&N" command is similar to the "&S" command but will
     continue to search past the end of the text shown on the screen
     when the command is given.

  &T (TAB) COMMAND:
     The TAB key and the &T command moves the cursor to the next TAB
     setting on the current line. The TAB settings are initially
     5, 8, 16, 24, 32, 40, 48, 56, 64 and 72.

  &nT COMMAND:
     The "&nT" command will move the cursor to position n on the
     current line. Assume for example that the current line is:

     Mary had a little lamb.

     Then the "&10T" command will move the cursor to the "h" in
     "had".

  &TZ (TAB ZERO) COMMAND:
     This command will remove all the TAB settings.

  &TR (TAB RESTORE) COMMAND:
     This command will restore the TAB settings to the initial
     5, 8, 16, 24, 32, 40, 48, 56, 64 and 72.

  &TS (TAB SET) COMMAND:
     This command will make a TAB setting at the current horizontal
     position.

     Example: If you want only one TAB setting at the horizontal
     position 40, you can write the following series of commands:
     "&TZ &40T &TS ".

  &TnS (TAB SET) COMMAND:
     This command will set a horizontal tab at position n.
     Example: "&T40S" will set the same tab as in the above example.

2.5 TEXT INSERTION COMMANDS

     If you want to insert new text, you just move the cursor to
     where you want the text and type it. The new text will then
     overwrite previous text.

     The "&I", "&L" and "&V" commands can be used to insert text
     without overwriting previous text.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 15
2.5 TEXT INSERTION COMMANDS

  &I (INSERT) COMMAND:
     The "&I<insertion text>" command will insert new text, shifting
     the rest of the text to make room for the addition. Finish the
     insertion text with RETURN or with the command starting key
     (ALTMODE or CONTROL-F). Assume for example that the screen
     contains the text:

     Mary had a little lamb.
                       ^
     To change this to "Mary had a little black lamb.", you can move
     the cursor to the "l" in lamb and make the command "&Iblack ".

  &nV (INSERT BLANK) COMMAND:
     This command is a short form for the "&I<n spaces>&" command to
     insert n spaces. On most terminals, you can type CONTROL-V
     instead of "&V" to insert a single space.

  &nL (LINE INSERTION) COMMAND
     The "&nL" command will insert n blank lines, displacing the
     rest of the text downwards. To insert one blank line, the short
     form "&L" can be used.

     Assume for example that the screen contains the two lines:

     Jack and Jill went up the hill.
^    Jack fell down, and Jill came tumbling after.

     Then the "&L" command at the beginning of the second line will
     change this to:

     Jack and Jill went up the hill.

     Jack fell down, and Jill came tumbling after.

     If the "&nL" command is used in the middle of a line, then that
     line will be split. Assume for example that the screen contains
     the line:

     Jack and Jill went up the hill.
                   ^
     If the cursor is at the "w" in "went", then the "&L" command
     will change this line to:

     Jack and Jill
                   went up the hill.

     If you want to insert many words, then it is usually better to
     use the "&nL" command and type the new words into the blank
     lines than to use the "&I" command.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 16
2.5 TEXT INSERTION COMMANDS

  &LD (LINE DIVIDE) COMMAND
     The "&LD" command is similar to the "&L" command, but the
     second part of the line is left justified. In the example
     above, you will thus get:

     Jack and Jill
     went up the hill.

     If you want to insert blank lines between the parts, write
     "&LnD" where n is one more than the number of blank lines
     wanted.

2.6 TEXT DELETION COMMANDS

     One way to delete text on the screen is to move the cursor to
     the text to be deleted and overwrite it with other text, for
     example with blanks.

     The key on your terminal labelled RUBOUT, DELETE or DEL can be
     used to make the character immediately to the left of the
     cursor blank.

     Assume for example that the screen contains:

     Jack and Jill wemt
                       ^
     To change the last word to "went" you can first push the RUB
     OUT key twice, which gives you:

     Jack and Jill we
                     ^
     Then you type "nt" to get:

     Jack and Jill went
                       ^

     RUBOUT at the beginning of a line will move the cursor to the
     end of the previous line. Example:

     Jack and Jill wemt
up
  ^
     Five succesive RUB OUTs will give:

     Jack and Jill we
                     ^
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 17
2.6 TEXT DELETION COMMANDS

  &nD (DELETE) COMMAND
     The "&nD" command can be used to delete characters and move the
     succeeding text back so that there will be no blank space.
     Assume for example that you have:

     Jack and Jill went uppety the hill.
                          ^
     To change "uppety" to "up" you type the command "&4D".

     If you want to delete just one character, you can use the short
     form "&D". On most terminals, you can also delete one character
     with CONTROL-D.

     Suppose that the screen contains:

     Jack and Jill went up the hill.
^
     "&D" or CONTROL-D will move the text one step left:
    Jack and Jill went up the hill.
^
     "&V" or CONTROL-V will move the text one step right:
      Jack and Jill went up the hill.
^
  &W (WORD DELETE) COMMAND
     The "&W" command will delete the last word preceding the
     cursor. On most terminals, CONTROL-W can also be used. Assume
     the following text:

     Jack and Jill went uppety
                              ^
     "&W" will give:

     Jack and Jill went
                        ^
  &U (UPTO DELETE) COMMAND
     The "&U" command will make the line blank up to the cursor.
     CONTROL-U can also be used on most terminals.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 18
2.6 TEXT DELETION COMMANDS

  &nK (DELETE LINES) COMMAND
     The "&nK" command will delete n lines and move the succeeding
     lines up to cover the blank lines. "&K" is short for "&1K".

     Example:

     Jack and Jill went up the hill.
     Jack fell down,
^    and Jill came tumbling after.

     The "&K" command will remove the entire second line:

     Jack and Jill went up the hill.
     and Jill came tumbling after.

     If the "&nK" command is used with the cursor in the middle of a
     line, then only the text after the cursor will be deleted on
     the first line.

     Example:

     Jack and Jill went up the hill.
                  ^
     "&K" will change this to:

     Jack and Jill
                  ^
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 19

2.7 PARAGRAPH JUSTIFICATION COMMANDS.

  &nJ (JUSTIFY) COMMAND
     If you have inserted new words into a paragraph, then the lines
     may be of uneven lengthes. By moving the cursor to the first
     line of the paragraph and typing the "&J" command the paragraph
     is justified. Example:

^    Jack went up the hill.
     Jill went up the hill.
     Jack fell down, and Jill came tumbling after.

     "&J" will change this to:

     Jack went up the hill. Jill went up the hill. Jack fell down,
     and Jill came tumbling after.
^
     When you type in a new paragraph, you can just type on without
     using the RETURN key at all, like this:

Jack went up the hill. Jill went up the hill. Jack fell down, and Jill came tum
bling after.

     Then move the cursor to the start of the paragraph and use the
     "&J" command and you will get:

     Jack went up the hill. Jill went up the hill. Jack fell down,
     and Jill came tumbling after.
^

     WARNING: The "&J" command will regard succeeding lines upto an
     entirely blank line, or upto a line beginning with a dot, as
     part of the same paragraph. If you want to justify only n
     lines, type "&nJ".

     If you want the first line of the paragraph to start or end at
     a horizontal position different from the rest of the lines,
     then move the cursor past this irregular start before making
     the "&J" command. Example 1:

          Jack and Jill went up the hill.
     The man fell down, and the woman came tumbling after.

     Move the cursor to the "J" in Jack before making the "&J"
     command to get:

          Jack and Jill went up the hill. The man fell down, and the
     woman came tumbling after.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 20
2.7 PARAGRAPH JUSTIFICATION COMMANDS.

     Example 2:

  1) Jack and Jill went up the hill.
     The man fell down, and the woman came tumbling after.

     Move the cursor to the "J" in "Jack" before making the
     "&J" command to get:

  1) Jack and Jill went up the hill. The man fell down, and the
     woman came tumbling after.


     A COMBINED EXAMPLE OF INSERTION AND JUSTIFICATION:

     Suppose you have the text:

     Jack and Jill went up the hill. Jill came tumbling after.

     You want to insert "Jack fell down." between the two sentences.
     One way to do this can be the following:

     1) Move the cursor to the insertion point with the "&S."
     command.

     Jack and Jill went up the hill. Jill came tumbling after.
                                    ^

     2) Use the "&L" command to get blank space for the insertion.

     Jack and Jill went up the hill.
                                    ^Jill came tumbling after.

     3) Insert the new sentence:

     Jack and Jill went up the hill. Jack fell down.
                                     Jill came tumbling after.

     4) Move the cursor to the start of the paragraph and use the
     &J" command to justify it:

     Jack and Jill went up the hill. Jack fell down. Jill came
     tumbling after.

  &nML AND &nMR (LEFT AND RIGHT MARGIN SET) COMMANDS
     The "&J" command will justify the paragraph within a left and a
     right margin. The initial (default) values of these margins are
     the horizontal positions 5 and 68, unless you have given your
     own defaults in your SWITCH.INI file.

     These margins can be changed with the "&nML" and "&nMR"
     commands, to change respectively the left and right margin.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 21
2.7 PARAGRAPH JUSTIFICATION COMMANDS.

     Example: After "&ML10 &MR40" the "&J" command will produce:

          Jack and Jill went up the
          hill. Jack fell down. Jill
          came tumbling after.

     You can give the &ML and &MR commands without any numerical
     arguments. The margins will then be set to the cursor position
     of the & in the &ML or &MR command.

  &- (DIVIDE WORD) COMMAND
     Sometimes, some lines in a paragraph will be too short due to
     very long words. You can then use the "&-" command to divide
     the long word. Example:

     Eine Arbeitsgruppe des Kurses befasse sich mit der
     prozessrechnergefuehrten Ueberwachung.
            ^
     Move the cursor to the point where the word is to be divided
     and use the "&-" command to get:

     Eine Arbeitsgruppe des Kurses befasse sich mit der prozess-
     rechnergefuehrten Ueberwachung.

     Always use the "&J" command first, before using the "&-"
     command.

     The "&-" command is just a shorter way to do the following:

     1) Do the "&I- " command.

     2) Move the cursor to the beginning of the previous line.

     3) Do the "&J" command.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 22

2.8 MOVING AND COPYING.

  &Q<name> n (Q-REGISTER STORE) COMMAND
     The "&Q<name> n" command will store n lines in a Q-register (a
     nonvisible storage area). The contents of the Q-register can
     then be restored on another line.

     Just "&Q<name>" will store one line, "Q<name> 0" will store the
     rest of the screen. Only text visible on the screen can be
     stored in a Q-register.

  &G<name> (Q-REGISTER GET) COMMAND
     The "&G<name>" will copy the contents of a Q-register onto the
     screen.

     NOTE: Copying will overwrite other text on the screen, but
     parts of the Q-register which do not fit in the screen area
     will not be copied.

     Example: You want to exchange these two lines:

     Jack fell down, and Jill came tumbling after.
     Jack and Jill went up the hill.

     Then move the cursor to the first line, and make the command
     "&Qfirst 1". Then delete the first line with "&K" and insert a
     blank line after the second line with "&L" and finally copy the
     Q-register content onto the new blank line with the "&Gfirst"
     command. You now have:

     Jack and Jill went up the hill.
     Jack fell down, and Jill came tumbling after.

     If you just write "&Q<name>" then everything below and to the
     right of the cursor will be put into the q-register.

  &Q<name> n m (Q-REGISTER STORE BOX) COMMAND
     The "&Q<name> n m" command can be used to store any rectangular
     box on the screen into a q-register. The width of the box is n
     characters and the height is m lines. This is very useful when
     producing tables, flow diagrams etc.

     If n or m is given as 0, the rest of the screen is put into the
     Q-register. Only text visible on the screen can be put into a
     q-register.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 23
2.8 MOVING AND COPYING

     You can for example first type this text:

     !---------!
     !         !
     !         !
     !---------!

     Then move the cursor to the upper left corner of the box and
     type the command "&Qbox 11 4".

     You can now move the cursor to another position:

     !---------!
     !         !    ^
     !         !
     !---------!

     And get a copy of the box with "&Gbox".

     !---------!    !---------!
     !         !    !         !
     !         !    !         !
     !---------!    !---------!
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 24
2.8 MOVING AND COPYING

     To produce a table, you can first produce one vertical line:

        !   Then store the line into a q-register with the
        !   "&Qline 1 0" command.
        !   (0 signifies the rest of the visible screen.)
        !
        !
        !
        !
        !
        !

     Then you can get more vertical lines into your table by moving
     the cursor to the top of each line and typing the "&Gline"
     command.

        !       !       !       !       !       &Gline
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !
        !       !       !       !       !

     You can insert horizontal lines in the same way, by storing one
     horizontal line in a Q-register and then inserting it several
     times with the "&G" command, to get:

        ---------------------------------------------------------
        !       !       !       !       !       !       !       !
        !       !       !       !       !       !       !       !
        ---------------------------------------------------------
        !       !       !       !       !       !       !       !
        !       !       !       !       !       !       !       !
        ---------------------------------------------------------
        !       !       !       !       !       !       !       !
        !       !       !       !       !       !       !       !
        ---------------------------------------------------------
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 25

2.9 PAGE HANDLING

&nZ (SCROLL) COMMAND

     The "&nZ" command will scroll the screen up n lines, that is
     take in n new lines from the input file at the bottom of the
     screen and output the same number of lines at the top. If you
     regard the screen as a frame showing part of the text, the
     "&nZ" will move this frame down on the text.

TITLE AND SUBTITLE

     VIDED will put title, subtitle and page number on all pages and
     todays date on the first line of the first page, unless you
     disallow this with the "/-P" switch when starting VIDED or
     unless the file has an extension typical for a source language
     file.

  &nP (PAGE TOP) COMMAND

     The "&nP" command will move the screen to the top of the n-th
     next page. The short form "&P" is equal to "&1P" which moves
     the screen to the top of the next page. "&0P" can be used to
     move the screen back to the top of the current page. Negative
     values to move back to previous pages are however not possible.

  &PnN (PAGE NUMBER) COMMAND

     The "&PnN" command will move the screen to the top of page
     number n (counted from the beginning of the input file). The
     number n given must be larger than the current input page
     number. Note that uses of the &PI and &PA command may cause the
     output page number (sometimes inserted into the top line of
     each page) to be different from the input page number.

  &PnE (PAGE END) COMMAND

     The "&PnE" command is similar to the "&nP" command but moves to
     the end of the indicated page. Thus "&P0E" moves to the end of
     the current page and "&PE" (= "&P1E") moves to the end of the
     next page.

  &PI (PAGE DIVISION INSERT) COMMAND

     The "&PI" command will divide a page into two pages. The
     division will be done at the cursor position. This should be
     used if a page becomes larger than the desired maximum page
     height.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 26


     When you get to the end of page, you will be warned with the
     following warning text:

     ***??? END OF PAGE *** USE &PI COMMAND ***???


     When you get this warning text, find a suitable place above the
     warning line and make the "&PI" command there.

     You may but need not remove the warning text, it will not be
     output.

  &PA (PAGE APPEND) COMMAND

     The "&PA" command will append the next page to the current
     page. Blank lines at the end of the current page and the title
     and subtitle of the next page are deleted.

  &PS (PAGE SIZE) COMMAND

     After using the "&PA" command, the current page will often be
     too long. You can then use the command "&PS" to find the next
     page which is longer than the maximum page height.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 27
2.9 PAGE HANDLING

     Here is the normal sequence of activities for you when
     appending and dividing pages:

     -----------------------
     ! Is the current page !
  -->! too long?           !---> NO ---> You are ready
  !  -----------------------
  !          YES
  !  ---------------------------------
  !  ! Use the "PI" command to split !
  !  ! the current page.             !
  !  ---------------------------------
  ^          !
  !  --------------------------------
  !  ! Is the current (second) page !
  !  ! too short?                   !---> NO ---> You are ready
  !  --------------------------------
  ^         YES
  !  --------------------------------------
  !  ! Use the "PA" command to append the !
  !  ! next page, and then use the        !
  !  ! "PS" command to find out if the    !
  !--! combined page is too long.         !
     --------------------------------------

  &N (LONG SEARCH) COMMAND

     The "&N<search string>" command is similar to the "&S" command
     (see section 2.4 above) but continues searching forward in the
     file past the end of the screen and the page.

     When no match occurs, "&N" stops at the end of the entire file.

  CONTROL-O COMMAND FOR SLOW TERMINALS

     If you have a slow terminal (less than 2400 baude) then you may
     find it irritating to wait for the whole screen to be filled
     after a "&P" och "&N" command, especially if you did not find
     the place in the text you were really looking for. In such a
     case, you can use to CONTROL-O command to interrupt the filling
     of the screen.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 28

2.10 STATUS, HELP AND RESTORATION COMMANDS

  &O (GET STATUS) COMMAND
     The "&O" command will give you a report on the status of your
     editing. You will be told the names of the input and output
     files, where you are on the current page, the contents of
     Q-registers etc.

  &H (HELP) COMMAND
     The "&H" command can be used if you do not have this handbook
     available and want to get a short summary of the VIDED
     commands.

  &R (RESTORE SCREEN) COMMAND
     In certain cases, the text on the screen may be jumbled, even
     though the computer still has the correct text in its files.
     The "&R" command will then restore the screen to the correct
     text. The FORMFEED (CONTROL-L) key can also be used.

     Examples of causes of jumbled text:

  >  Terminal faults, electricity supply faults.

  >  Messages sent to your terminal from the operator or from other
     users.

  >  You have been using the type ahead feature of the DEC-10
     (inputting data before the computer has handled your previous
     data.) Two common cases of this:

  >  You did not wait for the ALTMODE (ESCAPE) or CONTROL-F to be
     echoed as "&" on the screen before typing the rest of the
     command.

  >  You typed CARRIAGE RETURN at the end of screen, and continued
     typing before the new line had been scrolled onto the screen.

     Always use the "&R" command if you are not sure that the screen
     shows the correct text.

     (QUESTION: Why was VIDED designed in such a way that type ahead
     can cause screen jumbling? ANSWER: Because otherwise your
     ordinary input text would not be echoed fast enough on a
     heavily loaded computer.)
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 29

2.11 EXITING FROM VIDED

     There are two commands for leaving VIDED, the "&E" and then
     "&C" command.

  &E (EXIT) COMMAND
     The "&E" command finishes the editing operation, copies the
     rest of the input file to the output file, closes the output
     file. This is the normal exit command.

     If you want to carry over the q-register contents and file
     opening switches from one edit to the next edit, you can start
     the next edit with the monitor command "CONTINUE" after the end
     of the previous edit.

  &C (CANCEL EXIT) COMMAND
     The "&C" command exits immediately from VIDED without closing
     the output file. This command should be used if you want to
     cancel the effect of the whole current session with VIDED. The
     input file will remain as it was before the current editing
     session.

     NOTE: You are advised to use the "&C" command instead of
     CONTROL-C to exit immediately from VIDED.

2.12 RESTRICTIONS IN VIDED

     The input text to be edited by VIDED should not contain any
     other non-printable characters than space, tab,
     carriage return-linefeed and formfeed.

     VIDED will convert tabs into multiple spaces (except the TAB
     after line-numbers for line-numbered files).

     VIDED will insert a carriage return in front of any line feed
     not preceded by a carriage return.

     VIDED will insert carriage return-line feed in front of any
     form feed not preceded by carriage return-line feed.

     The lines in the input file may not be longer than 140
     characters.

     If the lines in the input file are longer than the width of the
     terminal screen, then they will permanently be split into two
     lines by VIDED.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 30


3. ONE-PAGE SUMMARIES   3.1 OF VIDED COMMANDS.

VIDED is a text editor specially suitable for display terminals.
The screen will always show the new text after each edit operation.

OUTFIL.EXT=INFIL.EXT/T:n/N:m
IF no input file, or same input and output file, omit "=INFIL.EXT".
"/T:n" gives terminal model number. Can be omitted if unknown.
/N:m produces a line numbered file with increment m (default:10).
/-N removes line numbers.
/MP:n sets number of lines per page (default:56),
/MP:100 suppresses headers and page numbers.
/ML:n sets left margin (default:5).
/MR:n sets right margin (default:68).
/L:n sets number of lines per page (default terminal dependent).
/P or /-P to govern page headers with page numbers.

VIDED EDITING COMMANDS:

The character printed as & below is actually ALTMODE (once or twice)
or CONTROL-F.

CURSOR MOVEMENT                   TEXT INSERTION
&X      Skip to end of line       &I      Insert text
&Ah v   Address screen            &nV or CONTROL-V Insert blanks
&S      Search within screen      &nL     Insert n blank lines
&N      Search beyond screen      &LnD    Divide line
&T or <TAB> To next tab position
&nT     To horizontal pos n       TEXT DELETION
&TZ     Zero tab settings         &nD     Delete n characters
&TR     Restore tab settings      CONTROL-D Delete one character
&TS,&TnS Make one tab setting     &W      Delete last word
                                  &U or CONTROL-U Delete line
PARAGRAPH JUSTIFICATION                   up to cursor
&J      Justify paragraph         &nK     Delete n lines
&nJ     Justify n lines
&ML[n]  Set left margin           MOVING AND COPYING
&MR[n]  Set right margin          &Qreg n Store n lines in
&-      Divide word                       Q-register
                                  &Qreg m n Store box of width m,
PAGE HANDLING                             height n in Q-register
&nZ     Scroll screen             &Greg   Get Q-register
&nP     Find top of page +n
&PnE    Find end of page +n       STATUS, HELP, RESTORATION
&PnN    Find top of input page n  &O      Get status
&0P     To top of current page    &H      Type command summary
&P0E    To bottom of current page &R      Restore jumbled screen
&PI     Insert page division
&PA     Append next page          EXITING
&PS     Find too large page       &E      Normal exit
                                  &C      Cancel exit

WARNING: Always do the &R command after receiving messages
from the system, operator or from other users, like
"OPR:- Timesharing ends in 30 minutes"
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 31

3.2  ONE-PAGE SUMMARY OF DEC 10 TEXT HANDLING COMMANDS

(Capital letters indicate what you write.)

Starting to use the computer:
     .LOGIN NNN,NNN     ; Give your project number and programmer number
     password: YYY      ; Give your password

     .ATTACH NN[NNN,NNN]        ; Attach to detached job

Stopping the use of the computer:
     .K/F               ; Good-bye to the computer
     .K/U               ; Good-bye with file deletion
     fil1.txt  <057>  5. Blks   : K    ; Delete this file
     fil2.txt  <057> 25. Blks   : P    ; Save to keep
     fil3.txt  <057> 35. Blks   : S    ; Save temporarilly

File names: 1-6 letters or digits, a dot, 1-3 letters or digits. The
     letters and digits after the dot are called "extensions". Some
     typical extensions:                        Backup extension:
     .TXT  = Text file with page numbers        .QXT
     .BAS  = Text file without page numbers     .QAS
     .LPT  = To be listed and deleted           .QPT
     .MIC  = Command file                       .QIC
     .INI  = Initialization file

     Example: LETTER.TXT

Listing your file names:
     .DIR               ; List names of all your files
     .DIR *.TXT         ; List all file names ending with ".TXT"
     .DIR *.Q??         ; List names of all backup files
     .DIR LET???.*      ; List all file names beginning with "LET"
     .DIR/F/W:80        ; Short, compact listing
     .DIR/SLOW          ; Listing with creation hour

Deleting files:
     .DEL FIL.EXT       ; Delete file "FIL.EXT"
     .DEL *.Q??         ; Delete all backup files

Renaming files:
     .RENAME NEW.EXT=OLD.EXT    ; File "OLD.EXT" is renamed "NEW.EXT"

Copying files:
     .COPY NEW.EXT=OLD.EXT      ; File "NEW.EXT" becomes a copy of "OLD.EXT"

Running programs:
     .RUN PROG          ; Run your program "PROG"
     .R PROG            ; Run system program "PROG"
     .R PUB:PROG        ; Run public program "PROG"

Printing files:
     .TYPE FIL.EXT      ; Type on your terminal
     .PRINT FIL.EXT     ; Print on the line printer
     .DO P4 FIL.EXT     ; Print on the local printer
     .DO P4B 3,FIL.EXT  ; Print on the local printer, bold face

Control commands:
     CONTROL-C          ; Interrupt execution immediately (push twice)
     CONTROL-O          ; Skip typing, but continue
     CONTROL-S          ; Pause in typing
     CONTROL-Q          ; Continue to type after CONTROL-S
     CONTROL-T          ; What is the computer doing?
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 32

4. SPECIAL INFORMATION FOR VARIOUS TERMINALS

4.1 TANDBERG TDV 2000

     On this terminal, use the key labelled "UNDERLINE" on the
     terminal instead of ALTMODE or CONTROL-F to start a command to
     VIDED.

     Use the key labelled "BLINK" to get the effect which the TAB
     key gives on other terminals.

     WARNING: The CR key will blank the next line, the LF key part
     of the next line, and should only be used if you want this
     blanking or if the next line already is blank.

4.2 DATAMEDIA ELITE 1520

     NOTE: If you have a DATAMEDIA ELITE 1520 terminal without the
     optional "numeric" keyboard, your terminal lacks these four
     keys. You can then instead use:

                UP    CONTROL-_
                DOWN  LINE FEED
                LEFT  BACKSPACE
                RIGHT CONTROL-@ or CONTROL-\
                HOME  CONTROL-Y

4.3 MINIBEE, BEEHIVE B 100 AND DEC VT52

     A single altmode cannot be used to indicate the start of a
     command to VIDED. Use CONTROL-F or two successive altmodes
     instead.

4.4 CDC 713-10

     This terminal has a key labelled "SCROLL DISABLE". This key
     should NOT be set!

     The "home" key is labelled "reset" on the CDC 713-10, and it
     moves the cursor not to the upper left, but to the lower left
     corner. You can reach the upper left corner by the command
     "&A 0 0".

     CONTROL-U cannot be used on the CDC 713-10. Use ALTMODE-U
     instead.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 33

5. INDEX

 --- A ---

A command . . . . . . . . . . . . . 2.4
Adding text . . . . . . . . . . . . 2.5
Address screen command  . . . . . . 2.4
ALTMODE key . . . . . . . . . . . . 2.3
Ampersand '&' command start marker  . . 2.3

 --- B ---

Backup file . . . . . . . . . . . . 2.1
Beginning an editing session  . . . 2.1
Box copying . . . . . . . . . . . . 2.8

 --- C ---

C command . . . . . . . . . . . . . 2.11
CARRIAGE RETURN key . . . . . . . . 2.4
Character deletion  . . . . . . . . 2.6
- command . . . . . . . . . . . . . 2.7
& command start marker  . . . . . . 2.3
Commands to VIDED, introduction . . 1.3
Commands to VIDED, typing of  . . . 2.3
Commands, short list of . . . . . . 3.
CONTROL-C key . . . . . . . . . . . 2.11
CONTROL-D key . . . . . . . . . . . 2.6
CONTROL-F key . . . . . . . . . . . 2.3
CONTROL-L key . . . . . . . . . . . 2.10
CONTROL-U key . . . . . . . . . . . 2.6
CONTROL-W key . . . . . . . . . . . 2.6
Copying text  . . . . . . . . . . . 2.8
Copying text, introduction  . . . . 1.8
CURSOR  . . . . . . . . . . . . . . 1.1
Cursor movement . . . . . . . . . . 2.4
Cursor movement, introduction . . . 1.2, 1.4
Curve, example  . . . . . . . . . . 1.1

 --- D ---

D command . . . . . . . . . . . . . 2.6
D command, introduction . . . . . . 1.6
Date on top of first page . . . . . 1.9
DEC VT52 terminals  . . . . . . . . 2.1
Default values in SWITCH.INI file . 2.1
DEL key . . . . . . . . . . . . . . 2.6
Delete command  . . . . . . . . . . 2.6
DELETE key  . . . . . . . . . . . . 2.6
DELETE key, introduction  . . . . . 1.6
Deletion of text  . . . . . . . . . 2.6
Deletion of text, introduction  . . 1.6
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 34
4. INDEX

Diagram, example  . . . . . . . . . 1.1
Direct cursor addressing  . . . . . 2.4
Divide page command . . . . . . . . 2.9
Divide word command . . . . . . . . 2.7
Dividing lines  . . . . . . . . . . 2.5
DOWN key  . . . . . . . . . . . . . 1.2, 2.4
Duplication of text . . . . . . . . 2.8

 --- E ---

E command . . . . . . . . . . . . . 2.11
E command, introduction . . . . . . 1.11
Elite terminals . . . . . . . . . . 2.1
End of line command . . . . . . . . 2.4
End of page command . . . . . . . . 2.9
Errors in screen, not in file . . . 2.10
ESCAPE key  . . . . . . . . . . . . 2.3
Exiting from VIDED  . . . . . . . . 2.11
Exiting from VIDED, introduction  . 1.11

 --- F ---

Faults in screen, not in file . . . 2.10
Figure production . . . . . . . . . 2.8
Flow diagram  . . . . . . . . . . . 2.8
Flow diagram, example . . . . . . . 1.1
FORMFEED key  . . . . . . . . . . . 2.10
Full description of the VIDED commands  . . 2

 --- G ---

G command . . . . . . . . . . . . . 2.8
G command, introduction . . . . . . 1.8
Get from Q-register commands  . . . 2.8

 --- H ---

H command . . . . . . . . . . . . . 2.10
H command, introduction . . . . . . 1.10
Header  . . . . . . . . . . . . . . 2.9
Header on top of pages  . . . . . . 1.9
Help command  . . . . . . . . . . . 2.10
HOME key  . . . . . . . . . . . . . 1.2, 2.4

 --- I ---

I command . . . . . . . . . . . . . 2.5
I command, introduction . . . . . . 1.5
Index . . . . . . . . . . . . . . . 4.
INFOTON terminals . . . . . . . . . 0, 2.1
Initial values in SWITCH.INI file . 2.1
Input file  . . . . . . . . . . . . 2.1


Inputting text  . . . . . . . . . . 2.2
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 35
4. INDEX

Insert space command  . . . . . . . 2.5
Insertion and justification, combining  . . 2.7
Insertion and justification, introduction . . 1.7
Insertion of text . . . . . . . . . 2.5
Insertion of text, introduction . . 1.5
Introduction to VIDED . . . . . . . 1.

 --- J ---

J command . . . . . . . . . . . . . 2.7
J command, introduction . . . . . . 1.7
Jumbled screen, restoration of  . . 2.10
Justification of paragraphs . . . . 2.7
Justification of paragraphs, introduction . . 1.7

 --- K ---

K command . . . . . . . . . . . . . 2.6
K command, introduction . . . . . . 1.6

 --- L ---

L and J commands combined, introduction . . 1.7
L command, introduction . . . . . . 1.5
Last word deletion  . . . . . . . . 2.6
LEFT key  . . . . . . . . . . . . . 1.2, 2.4
Left margin . . . . . . . . . . . . 2.1, 2.7
Line deletion . . . . . . . . . . . 2.6
Line divide command . . . . . . . . 2.5
Line insertion command  . . . . . . 2.5
Line-numbered file, creation of . . 2.1
Line-numbers, deletion of . . . . . 2.1
Lines per page, number of . . . . . 2.1

 --- M ---

Margin, left and right  . . . . . . 2.1, 2.7
MINITEC terminals . . . . . . . . . 0, 2.1
ML command  . . . . . . . . . . . . 2.7
Moving text . . . . . . . . . . . . 2.8
Moving text, introduction . . . . . 1.8
Moving the cursor on the screen . . 2.4
MR command  . . . . . . . . . . . . 2.7

 --- N ---

N command . . . . . . . . . . . . . 2.4, 2.9
N command, introduction . . . . . . 1.4
New text insertion  . . . . . . . . 2.5
Number of lines per page  . . . . . 2.1
Numbering of lines  . . . . . . . . 2.1
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 36
4. INDEX

 --- O ---

O command . . . . . . . . . . . . . 2.10
O command, introduction . . . . . . 1.10
One-page summary of commands  . . . 3.
Output file . . . . . . . . . . . . 2.1

 --- P ---

P command . . . . . . . . . . . . . 2.9
P command, introduction . . . . . . 1.9
Page handling . . . . . . . . . . . 2.9
Page handling, introduction . . . . 1.9
Page size, number of lines  . . . . 2.1
Paragraph justification . . . . . . 2.7
Paragraph justification, introduction . . 1.7
PI command  . . . . . . . . . . . . 2.9
Picture production, examples  . . . 1.1
Position to type = CURSOR . . . . . 1.1

 --- Q ---

Q command . . . . . . . . . . . . . 2.8
Q command, introduction . . . . . . 1.8
Q-register store and get commands . 2.8

 --- R ---

R command . . . . . . . . . . . . . 2.10
R command, introduction . . . . . . 1.10
Rectangle copying . . . . . . . . . 2.8
Reordering text . . . . . . . . . . 2.8
Restoring of jumbled screen . . . . 2.10
RETURN key  . . . . . . . . . . . . 2.4
RETURN key, introduction  . . . . . 1.2
RETURN key, used for scrolling  . . 1.1
RIGHT key . . . . . . . . . . . . . 1.2, 2.4
Right margin  . . . . . . . . . . . 2.1, 2.7
RUB OUT key . . . . . . . . . . . . 2.6
RUB OUT key, introduction . . . . . 1.6
Running VIDED . . . . . . . . . . . 2.1

 --- S ---

S command . . . . . . . . . . . . . 2.4
S command, introduction . . . . . . 1.4
Scrolling . . . . . . . . . . . . . 1.1
Search command  . . . . . . . . . . 2.4
Search command, across page boundaries  . . 2.9
Search command, introduction  . . . 1.4
Set tab settings  . . . . . . . . . 2.4
Shifting text left and rightwards (^V and ^D) . . 2.5
Short listing of commands . . . . . 3.
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 37
4. INDEX

Size of pages, in number of lines . 2.1
Skip to end of line command . . . . 2.4
Starting an editing session . . . . 2.1
Status type command . . . . . . . . 2.10
Store in Q-register commands  . . . 2.8
Subheader on top of pages . . . . . 1.9
Summary of commands . . . . . . . . 3.
SWITCH.INI file . . . . . . . . . . 2.1

 --- T ---

T command . . . . . . . . . . . . . 2.4
TAB key . . . . . . . . . . . . . . 2.4
TAB key, introduction . . . . . . . 1.2
Tab settings, default values  . . . 2.4
Tab settings, making  . . . . . . . 2.4
Tab settings, restoring . . . . . . 2.4
Tab settings, zeroing of  . . . . . 2.4
Table production  . . . . . . . . . 2.8
Table, example  . . . . . . . . . . 1.1
TEC terminals . . . . . . . . . . . 0, 2.1
TELETEC terminals . . . . . . . . . 0, 2.1
Terminal types  . . . . . . . . . . 0, 2.1
Text deletion . . . . . . . . . . . 2.6
Text deletion, introduction . . . . 1.6
Text input  . . . . . . . . . . . . 2.2
Text insertion  . . . . . . . . . . 2.5
Text insertion, introduction  . . . 1.5
Tn command  . . . . . . . . . . . . 2.4
Todays date on top of first page  . 1.9
Top of page command . . . . . . . . 2.9
Transferring text . . . . . . . . . 2.8
Typing text . . . . . . . . . . . . 2.2
TZ command  . . . . . . . . . . . . 2.4

 --- U ---

U command . . . . . . . . . . . . . 2.6
U command, introduction . . . . . . 1.6
UP key  . . . . . . . . . . . . . . 1.2, 2.4

 --- V ---

V command . . . . . . . . . . . . . 2.5
VIDED commands, typing of . . . . . 2.3
Vista terminals . . . . . . . . . . 2.1

 --- W ---

W command . . . . . . . . . . . . . 2.6
W command, introduction . . . . . . 1.6
Word deletion command . . . . . . . 2.6
VIDED - A DISPLAY-ORIENTED TEXT EDITOR                       PAGE 38
4. INDEX

 --- X ---

X command . . . . . . . . . . . . . 2.4
X command, introduction . . . . . . 1.4

 --- Z ---

Zero tab settings . . . . . . . . . 2.4
 
