COCOS.HLP            COCOS.MAN   1977-07-19  Revised: 1978-07-30

        COCOS - Conditional Compilation in SIMULA
        =========================================

     COCOS is a program to allow one SIMULA source program to
     compile into several differing programs. A preprocessor selects
     statements from the initial source program according to
     selection statements. The initial source program can also be
     compiled directly as one of the versions.

     In the future, some SIMULA compilers may include the interpre-
     tation of the COCOS commands, or some other similar scheme, so
     that no preprocessing is necessary.

     COCOS commands all begin with % in the first character position
     of a source program line. Such lines are ignored by the
     DECsystem-10 SIMULA compiler release 4. (COCOS also accepts
     command lines beginning with COMMENT% as the first non-blank
     text on a source program line. The source program should not
     contain any lines beginning COMMENT% except COCOS command
     lines.)

     The four COCOS commands are:

     %COCOS <variable> = <value>
     %IF <variable>
     %IFNOT <variable>
     %IFEND <variable>                  (%ENDIF is equivalent)

     The commands may, but must not end with semicolon (;).
     There should be no other text on these command lines.

     <variable> can be any valid SIMULA identifier. COCOS variables
     are however always global throughout the whole program and can
     have the same name as other identifiers in the program.

     <value> can only take the values TRUE or FALSE.

     Example:                            Output:
     BEGIN                               BEGIN
     %COCOS GERMAN = FALSE;                outtext("I am.");
     %IF GERMAN;                           outimage;
       outtext("Ich bin.");              END;
     %IFNOT GERMAN;
       outtext("I am.");
     %IFEND GERMAN;
       outimage;
     END;

     With %COCOS GERMAN = TRUE, the output file will include
     "Ich bin." instead of "I am.".



 COCOS - CONDITIONAL COMPILATION IN SIMULA, HELP TEXT           PAGE 2

     With each switch is associated three values, the variable name
     (<variable>), the value (<value>) and the condition.

     %IF gives the condition the value YES.
     %IFEND gives the condition the value NEUTRAL.
     %IFNOT gives the condition the value NO.

     No COCOS command lines are copied to the compilable program.
     Other lines are copied only if for all TRUE switches, the
     condition is yes or neutral, and for all FALSE switches, the
     conditiion is no or neutral.

     There can be more than one %COCOS commands for the same
     variable in a processed program. The last command is valid.

     If a %IF... command is encountered with no known value
     for the switch, then COCOS will ask the conversational
     terminal for a value.
 COCOS - CONDITIONAL COMPILATION IN SIMULA, DEFINITION          PAGE 3

     A COCOS command always begins with the character % in the first
     position of a source program line (except for a line number).
     (COCOS also accepts command lines beginning with COMMENT% as
     the the first non-blank text on a line. The COCOS input file
     may not contain any line beginning with "COMMENT%" except COCOS
     command lines.)

     The COCOS commands are:

     %COCOS <variablename> = <true-or-false>

     <variablename> can be any valid SIMULA identifier. Variablenames
     are global throughout the source file and name clashes with
     other SIMULA identifiers are allowed. The COCOS command
     %COCOS defines a value, TRUE or FALSE, for a named
     compile time variable. The value can be redefined by later
     %COCOS commands with the same variablename.

     %IF <variablename>

     This command sets the condition for the named variable to "yes".

     %IFNOT <variablename>

     This command sets the condition for the named variable to "no".

     %IFEND <variablename>              (%ENDIF is equivalent)

     This command sets the condition for the named variable to
     "neutral". The condition for a variable is also "neutral" before
     the occurence of the first %IF command.

     COCOS commands may, but need not end with semicolon (;).

     The COCOS preprocessor will produce an output file in which it
     will:

     1) Remove all lines containing COCOS commands.

     2) Remove all lines where any COCOS variable either:
        a) Has the value TRUE and the condition "no", or
        b) has the value FALSE and the condition "yes".

     3) If a %IF command is encountered for a variable which
     has not been given any value in a %COCOS command, and
     the program is run from a conversational terminal, then COCOS
     will ask the terminal for a value (TRUE or FALSE) for this
     variable.

     NOTE: This means that all the compile time variables are
     independent, and that all text is excluded which is excluded by
     the setting and conditions on any of the compile time
     variables.

     When COCOS is executed, you can give the following command
     string:
     <outfile>=<infile>/<variable1>:<value1>/variable2>:<value2> ...
