	SUBROUTINE APOPEN
C
C  La Trobe APOPEN merely calls the PLOTS routine specifying the
C  maximum size of the plot in mm, and calls FACTOR with the X,Y
C  magnifications.
C
	REAL	XPLTSZ, YPLTSZ, XFACTR, YFACTR
C
	COMMON	/APPRM/APPARM(45), APLO, APHI
C
	EQUIVALENCE (XPLTSZ,APPARM(1))
	EQUIVALENCE (YPLTSZ,APPARM(2))
	EQUIVALENCE (XFACTR,APPARM(28))
	EQUIVALENCE (YFACTR,APPARM(29))
C
C
	CALL PLOTS(XPLTSZ,YPLTSZ,0)
	CALL FACTOR(XFACTR,YFACTR)
	END
	SUBROUTINE APNUMB(XPOS,YPOS,SYMSIZ,NUMB,ANGLE,DIGITS)
	INTEGER	DIGITS
	REAL	XPOS, YPOS, SYMSIZ, NUMB, ANGLE
C
C  Call an installation dependant routine to plot a number
C  in symbols of a given size at a given angle
C
C  XPOS, YPOS	X,Y position of lower left corner of first digit
C  SYMSIZ	size of each digit
C  NUMB		number to be plotted
C  ANGLE	angle in degrees to horizontal
C  DIGITS	digits to right of decimal point. If negative, just
C		plot the integer part
C
C
	CALL NUMBER(XPOS,YPOS,SYMSIZ,NUMB,ANGLE,DIGITS)
	END
	SUBROUTINE APSYMB(XPOS,YPOS,SYMSIZ,TEXT,ANGLE,CHARS)
	INTEGER	CHARS
	REAL	XPOS, YPOS, SYMSIZ, TEXT(1), ANGLE
C
C  Plot text or a special symbol.
C
C  XPOS,YPOS	X,Y position of lower left corner of text character
C		or centre of special symbol
C  SYMSIZ	size of each symbol
C  TEXT		array containing A5 text or an integer special symbol
C		indicator (-14 to -1 and 1 to 14)
C  ANGLE	angle in degrees from horizontal
C  CHARS	>= 0 shows number of text characters
C		  -2 special symbol: move with pen down
C		  -3 special symbol: move with pen up
C
C
	CALL SYMBOL(XPOS,YPOS,SYMSIZ,TEXT,ANGLE,CHARS)
	END
	SUBROUTINE APWHER(XPOS,YPOS)
	REAL	XPOS, YPOS
C
C  Find current pen position
C
	REAL	FAC
C
C
	CALL WHERE(XPOS,YPOS,FAC)
	END
	SUBROUTINE APSHAD(CODE)
	INTEGER	CODE
C
C  Alter the shade of the colour of the ink on the plot.  This is
C  usually highly plotter dependant but often means changing the
C  pen colour.
C  At LaTrobe we use dotted lines on our Gould plotter.
C
C  CODE		line density, where 1 is normal, 2 is half dense, 3 is
C		a third etc.
C
C
	CALL	LINEWT(CODE)
	END
	SUBROUTINE APPLOT(XPOS,YPOS,PEN)
	INTEGER	PEN
	REAL	XPOS, YPOS
C
C  Move the pen to a point, up or down
C
C  XPOS,YPOS	X,Y destination of pen
C  PEN		2 pen down
C		3 pen up
C
C
	CALL PLOT(XPOS,YPOS,PEN)
	END
	SUBROUTINE APCLOS
C
C  Close down the plot
C
	REAL	CLSPLT
	COMMON	/APPRM/APPARM(45), APLO, APHI
	EQUIVALENCE (CLSPLT,APPARM(30))
C
C
	IF(CLSPLT.NE.1.0) CALL PLOT(0.0,0.0,999)
	END
