	INTEGER FUNCTION SETGM(MODE, INT, LP, BLINK, LINE)
C************************************************************
C
C  THIS FUNCTION RETURNS AN S.G.M. INSTRUCTION:
C
C	MODE - 0	CHARACTER
C	     - 1	SHORT VECTOR
C	     - 2	LONG VECTOR
C	     - 3	POINT
C	     - 4	GRAPH-X (NOT YET SUPPORTED)
C	     - 5	GRAPH-Y (NOT YET SUPPORTED)
C	     - 6	RELATIVE POINT
C
C	FOR A DESCRIPTION OF THE REMAINING PARAMETERS SEE
C	SUBROUTINE "SETMOD.F4"
C
C  POSSIBLE ERRORS:
C	%ILLEGAL MODE FOR SETGM (RETURNS SETGM = 0)
C	%ILLEGAL INTENSITY (LOW ORDER 3 BITS USED)
C	%ILLEGAL LINE TYPE (LOW ORDER 2 BITS USED)
C
C  ROUTINES CALLED:
C	ERROR  - ERROR LOGGING ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - Z)
	LOGICAL LP, BLINK

	IF(MODE.GE.0 .AND. MODE.LE.6) GO TO 100
	CALL ERROR('?ILLEGAL MODE FOR SETGM, MODE =',MODE)
	SETGM = 0
	RETURN

100	IF(INT.GE.0 .AND. INT.LE.7) GO TO 200
	CALL ERROR('%ILLEGAL INTENSITY IN SETGM, INT =',INT)

200	IF(LINE.GE.0 .AND. LINE.LE.3) GO TO 300
	CALL ERROR('%ILLEGAL LINE TYPE IN SETGM, LINE =',LINE)

300	SGM = ("20 .OR. MODE) * 2 ** 11
	SGM = SGM .OR. (("10 .OR. (INT .AND. "7)) * 2 ** 7)
	SGM = SGM .OR. ("4 .OR. (LINE .AND. "3))
	SGM = SGM .OR. "120
	IF(LP) SGM = SGM .OR. "40
	IF(BLINK) SGM = SGM .OR. "10
	SETGM = SGM
	RETURN
	END
