C  THIS PROGRAM IS USED TO PERFORM A DOWN LINE
C  LOAD (EIGHT BIT) TO THE GT40. THE FIRST STEP
C  IS TO LOAD A SMALL HANDLER FOR THE GT40 IN
C  ORDER TO FACILITATE THE EIGHT BIT LOAD. THIS
C  HANDLER IS SENT TO THE GT40 BOOTSTRAP BY
C  SUBROUTINE INIT

C	SUBPROGRAMS

C	INIT	INITIALIZES THE GT40
C	GETBLK	GETS A BLOCK FROM DISK
C	GETBYT	GETS A BYTE FROM DISK
C	SNDBLK	SENDS A BLOCK TO THE GT40
C	LISTEN	LISTENS TO THE GT40 AFTER EACH TRANSFER
C	GFIELD	BYTE RETRIEVAL ROUTINE
C	SFIELD	BYTE STORAGE ROUTINE
C		N.B. GFIELD & SFIELD AS DOCUMENTED PDP/10 ALGOL
C	GETCHR	GETS AN ASCII BYTE FROM THE GT40
C	SNDCHR	SENDS AN IMAGE BYTE TO THE GT40

	IMPLICIT INTEGER (A - Z)
	DIMENSION BLOCK (500)
	DATA DSK, LOG, BLKCT /20, 21, 0/
	DATA READY, ERROR, HALT, START /"122, "105, "110, "123/
	DATA LEFT, RIGHT /"133000000000, "135000000000/

1	FORMAT(' FILENAME DIALOGUE:')
2	FORMAT(1X,A1,'START OF GT40 LOADER LOG FILE (EIGHT BIT)',A1)
3	FORMAT(' ? GT40 NOT INITIALIZED OR HANDLER TRANSFER FAILED')
4	FORMAT(' %ATTEMPT #',I1,' CHECKSUM ERROR FOR BLOCK #',I2)
5	FORMAT(' ? LOAD FAILS')
6	FORMAT(1X,A1,'LOAD SUCCESSFUL, NO SELF START',A1)
7	FORMAT(1X,A1,'LOAD SUCCESSFUL, PROGRAM STARTED',A1)
8	FORMAT(' ? INVALID REPLY FROM GT40, LOADER IS HUNG')

	TYPE 1
	OPEN(UNIT=DSK, FILE='GIDUS.BIN', ACCESS='SEQIN',
	1    MODE='IMAGE', DIALOG)
	OPEN(UNIT=LOG, FILE='LOADER.LOG', ACCESS='SEQOUT')
	WRITE(LOG, 2) LEFT, RIGHT
	CALL INIT
	CALL LISTEN(STATUS)
	IF(STATUS .EQ. READY) GO TO 10
	WRITE(LOG, 3)
	CLOSE(UNIT=LOG)
	STOP
10	BLKCT = BLKCT + 1
	ERRCT = 1
	CALL GETBLK(BLOCK, COUNT, BLKCT)
20	CALL SDBLK8(BLOCK, COUNT)
	CALL LISTEN(STATUS)
	IF(STATUS .EQ. READY) GO TO 10
	IF(STATUS .NE. ERROR) GO TO 30
	WRITE(LOG, 4) ERRCT, BLKCT
	ERRCT = ERRCT + 1
	IF(ERRCT .LT. 10) GO TO 20
	WRITE(LOG, 5)
	CLOSE(UNIT=LOG)
	STOP
30	IF(STATUS .EQ. HALT) WRITE(LOG,6) LEFT, RIGHT
	IF(STATUS .EQ. START) WRITE(LOG, 7) LEFT, RIGHT
	IF(STATUS .NE. HALT .AND. STATUS .NE. START) WRITE(LOG,8)
	CLOSE(UNIT=LOG)
	STOP
	END
    
