	SUBROUTINE ADLINE(N, FILE, X, Y, VISIBL)
C************************************************************
C
C  THIS ROUTINE IS USED TO INSERT A VECTOR INTO THE
C  DISPLAY FILE CURRENTLY BEING BUILT. THE VECTOR WILL
C  BE (VISIBLE / INVISIBLE) DEPENDING ON THE FIFTH
C  PARAMETER. NORMALLY USERS WOULD USE THE SUBROUTINES
C  "MOVE" AND "VECTOR" INSTEAD OF "ADLINE"
C
C  IF POSSIBLE THE VECTOR WILL BE INSERTED AS A SHORT
C  VECTOR. IF THERE ARE MANY SHORT VECTORS TOGETHER THIS
C  WILL SAVE ON DISPLAY FILE SIZE.
C
C  POSSIBLE ERRORS:
C	NONE
C
C  ROUTINES CALLED:
C	SETSTA - RETURNS A STATUS-A INSTRUCTION
C	ADWORD - ADDS A WORD TO THE DISPLAY FILE
C	IPHYSX - RETURNS RASTER IX OF USER X
C	IPHYSY - RETURNS RASTER IY OF USER Y
C	SETGM  - RETURNS AN S.G.M. INSTRUCTION
C
C************************************************************
	IMPLICIT INTEGER (A - W, Z)
	INTEGER FILE(N)
	LOGICAL LP, BLINK, VISIBL, ITALA, LPA
	COMMON /SCLBLK/ XMIN, YMIN, XMAX, YMAX, BEAMX, BEAMY
	COMMON /MODBLK/ MODE, INT, LP, BLINK, LINE, OLDSGM
	COMMON /STABLK/ ITALA, LPA, OLDSTA

	BEAMX = FILE(2)
	BEAMY = FILE(3)
	OLDSGM = FILE(4)
	OLDSTA = FILE(5)
	NEWSTA = SETSTA(ITALA, LPA)
	IF(NEWSTA .EQ. OLDSTA) GO TO 100
	OLDSTA = NEWSTA
	CALL ADWORD(N, FILE, OLDSTA)

100	NEWX = IPHYSX(X)
	NEWY = IPHYSY(Y)
	RELX = NEWX - BEAMX
	RELY = NEWY - BEAMY
	IF(IABS(RELX).LT.64 .AND. IABS(RELY).LT.64) GO TO 300

	MODE = "2
	NEWSGM = SETGM(MODE, INT, LP, BLINK, LINE)
	IF(NEWSGM .EQ. OLDSGM) GO TO 200
	OLDSGM = NEWSGM
	CALL ADWORD(N, FILE, OLDSGM)
200	BEAMX = NEWX
	BEAMY = NEWY
	DELTAX = IABS(RELX)
	IF(DELTAX .GT. "1777) DELTAX = "1777
	DELTAY = IABS(RELY)
	IF(DELTAY .GT. "1377) DELTAY = "1377
	IF(RELX .LT. 0) DELTAX = DELTAX .OR. "20000
	IF(RELY .LT. 0) DELTAY = DELTAY .OR. "20000
	IF(VISIBL) DELTAX = DELTAX .OR. "40000
	CALL ADWORD(N, FILE, DELTAX)
	CALL ADWORD(N, FILE, DELTAY)
	GO TO 500

300	MODE = "1
	NEWSGM = SETGM(MODE, INT, LP, BLINK, LINE)
	IF(NEWSGM .EQ. OLDSGM) GO TO 400
	OLDSGM = NEWSGM
	CALL ADWORD(N, FILE, OLDSGM)

400	BEAMX = NEWX
	BEAMY = NEWY
	DELTAX = IABS(RELX)
	IF(DELTAX .GT. "77) DELTAX = "77
	DELTAY = IABS(RELY)
	IF(DELTAY .GT. "77) DELTAY = "77
	IF(RELX .LT. 0) DELTAX = DELTAX .OR. "100
	IF(RELY .LT. 0) DELTAY = DELTAY .OR. "100
	IF(VISIBL) DELTAX = DELTAX .OR. "200
	DELTA = DELTAX * 2 ** 7 .OR. DELTAY
	CALL ADWORD(N, FILE, DELTA)
500	FILE(2) = BEAMX
	FILE(3) = BEAMY
	FILE(4) = OLDSGM
	FILE(5) = OLDSTA
	RETURN
	END
