


Swedish National Defense Research Institute     FOA 1 Report
Department of Planning and Operations Research  C8399-M3(E5)
S-10450 Stockholm 80                            December 1974
                                                Revised edition:
                                                Dec 1977

DECsystem-10 SIMULA Language Handbook Part II
=============================================

     (Programmer's Guide)

BY   Stefan Arnborg, Olof Bjorner, Lars Enderin, Elisabeth
     Engstrom, Reidar Karlsson, Mats Ohlin, Jacob Palme, Ingrid
     Wennerstrom and Claes Wihlborg.


ABSTRACT:

     The DECsystem-10 SIMULA Language Handbook contains the
     information necessary for an applications programmer who
     intends to use SIMULA on a DECsystem-10 computer.

     Part I contains a description of the SIMULA programming
     language.  The contents of Part I are mostly
     machine-independent.

     Part II (this part) contains special information for
     DECsystem-10.  Part II will tell you:
   > How to run the compiler on a DECsystem-10,
   > What might differ between SIMULA on the DEC 10 and other
     computers,
   > How to write separately compiled classes in SIMULA and
     procedures in SIMULA, MACRO 10 or FORTRAN,
   > How to use the SIMULA Debugging System (SIMDDT),
   > How to produce efficient and portable programs,
   > How to interpret error messages,

     Part III will tell you about useful utility programs in
     SIMULA and/or for SIMULA users.

     This document reflects the software as of version 4 of the
     DECsystem-10 SIMULA system.

     Last update 1977-12-25.


NTIS NUMBER:  PB-243 065.

SEARCH KEY

     Computer, Programming, Programming Language, SIMULA,
     DECsystem-10, Digital Equipment, Algol 60, Fortran, Separate
     compilation, Part-compilation, Debugging, On-line debugging,
     DDT, Dynamic Debugging Technique, Compiler, Compiling
     techniques, Data structures, Diagnostic messages, Error
     messages, Program measurement, Prettyprint, Program library.
DECsystem-10 SIMULA Language Handbook, part II             Page 2


CONDITIONS OF RELEASE

     The information in this document is subject to change
     without notice.  The Swedish National Defense Research
     Institute assumes no responsibility for any errors that may
     appear in this manual (or in the SIMULA-10 system).

     The software described in this document is furnished to the
     user for use on a DECsystem-10 computer system and may be
     copied only for use on DECsystem-10 and DECsystem-20
     systems, except as may otherwise be provided in writing by
     the Swedish National Defense Research Institute.

     Copyright 1974, 1975, 1976, 1977 by The Swedish National
     Defense Research Institute.  Copying is allowed.



DECsystem-10 SIMULA Language Handbook, part II             Page 3
CHAPTER 0 CONTENTS


0    CONTENTS
     ========



        1  INTRODUCTION

        2  DEC SYSTEM-10 SIMULA SYSTEM

        3  OPERATING PROCEDURES

           3.1 INTRODUCTION
           3.2 THE R COMMAND
           3.3 COMPIL-CLASS COMMANDS
           3.4 BATCH
           3.5 SWITCHES


         4  IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE

           4.1 SYSTEM PREFIXES
           4.2 VIRTUAL MATCHES
           4.3 EDITING AND DE-EDITING PROCEDURES
           4.4 MATHEMATICAL LIBRARY FUNCTIONS
           4.5 COLLATING SEQUENCE, LETTER
           4.6 INITIALIZATION OF CHARACTER VARIABLES
           4.7 SUBSCRIPT CHECKING
           4.8 RANDOM DRAWING
           4.9 QUALIFICATION CHECKING
           4.10 SIMULATION PROCEDURE TIME


         5  LANGUAGE EXTENSIONS

         6  RESTRICTIONS

           6.1 CAPACITY RESTRICTIONS
           6.2 PARAMETER CORRESPONDENCE
           6.3 FOR STATEMENTS
           6.4 MISCELLANEOUS RESTRICTIONS
           6.5 RESTRICTIONS IN SIMULA WITH RESPECT TO ALGOL 60


        7  SEPARATE COMPILATION

           7.1 THE EXTERNAL DECLARATION
           7.2 THE EXTERNAL SWITCH
           7.3 RESTRICTIONS ON SEPARATE COMPILATION
           7.4 SIMDIR UTILITY PROGRAM
DECsystem-10 SIMULA Language Handbook, part II             Page 4
CHAPTER 0 CONTENTS


        8  OBJECT PROGRAM I/O

           8.1 INTRODUCTION
           8.2 HOW TO DEFINE A FILE
           8.3 RUN-TIME SWITCHES
           8.4 CLASS INFILE
           8.5 CLASS OUTFILE
           8.6 CLASS PRINTFILE
           8.7 CLASS DIRECTFILE
           8.8 CLASS BASICIO
           8.9 DEVICE CONTROL CHARACTERS


        9  DEBUGGING SIMULA PROGRAMS WITH SIMDDT

           9.1 LOADING AND STARTING SIMDDT
           9.2 SIMDDT INPUT AND OUTPUT
           9.3 SIMDDT COMMANDS



       10  PROGRAMMING CONSIDERATIONS

           10.1 WRITING EFFICIENT PROGRAMS
           10.2 WRITING PORTABLE PROGRAMS
           10.3 WRITING VERY LARGE PROGRAMS
           10.4 MISCELLANEOUS ADVICE
DECsystem-10 SIMULA Language Handbook, part II             Page 5
CHAPTER 0 CONTENTS


        APPENDICES

        A  HARDWARE REPRESENTATION

           A.1 SIMULA COMPILER INPUT
           A.2 SIMULA PROGRAMS ON CARDS
           A.3 STANDARD LINE SEQUENCE NUMBERS
           A.4 BASIC SYMBOLS
           A.5 IDENTIFIERS
           A.6 CONSTANTS
           A.7 COMMENTS
           A.8 USE OF SPACES AND LINE EDITING CHARACTERS


        B  INTERNAL REPRESENTATION

           B.1 REPRESENTATION OF VARIABLES
           B.2 REPRESENTATION OF DYNAMIC ADDRESSES
           B.3 REPRESENTATION OF PARAMETERS
           B.4 DYNAMIC RECORDS


        C  COMPILER DIAGNOSTICS

           C.1 COMMAND AND SWITCH MESSAGES
           C.2 SOURCE CODE DIAGNOSTICS


         D  RUN-TIME AND DEBUG DIAGNOSTICS

           D.1 DIALOGUE MESSAGES
           D.2 RUN-TIME ERROR MESSAGES


        E  HOW TO WRITE AN EXTERNAL MACRO OR 
           FORTRAN PROCEDURE

           E.1 EXTERNAL FORTRAN PROCEDURES
           E.2 FORTRAN PROGRAMMING EXAMPLE
           E.3 EXTERNAL MACRO-10 PROCEDURES
           E.4 MACRO-10 CALLING STANDARD
           E.5 STANDARD MACROS
           E.6 MACRO-10 PROGRAMMING EXAMPLES


        F  RUN-TIME SYSTEM COMPONENTS

        G  RESERVED SIMULA WORDS AND STANDARD IDENTIFIERS

DECsystem-10 SIMULA Language Handbook, part II             Page 6
CHAPTER 0 CONTENTS


        H  SAMPLE JOB LISTINGS

           H.1 THE R COMMAND
           H.2 THE COMPILE COMMAND
           H.3 THE LOAD COMMAND
           H.4 THE EXECUTE COMMAND
           H.5 THE DEBUG COMMAND
           H.6 CONTROL CARDS IN BATCH
           H.7 EXAMPLE OF CTL FILE IN BATCH
           H.8 SOURCE CODE LISTING WITH ERRORS AND
               CROSS REFERENCE TABLE
           H.9 SIMDDT EXAMPLES


        I  ERROR REPORT

        J  PROGRAM MEASUREMENT SYSTEM

        K  TECO, SOS OR EDITS ON SIMULA PROGRAMS

           K.1 WHY LINE NUMBERED FILES?
           K.2 WHICH TEXT EDITOR SHOULD YOU USE?
           K.3 HOW TO USE SOS OR EDITS ON SIMULA SOURCE PROGRAMS
           K.4 HOW TO GIVE A FILE A NEW LINE NUMBER WITH TECO
           K.5 EDITING A LINE NUMBERED FILE WITH TECO


        L  AUTOMATIC EDITING OF SIMULA PROGRAMS

        M  CONVERSION OF SIMULA PROGRAMS
           BETWEEN DEC, IBM AND CDC COMPUTERS

           M.1 CONVERSION FROM IBM 360/370 SIMULA
               TO DEC SYSTEM-10 SIMULA
           M.2 CONVERSION FROM DEC SYSTEM-10 SIMULA
               TO IBM 360/370 SIMULA
           M.3 CONVERSION FROM CDC SIMULA
               TO DEC SYSTEM-10 SIMULA


        N  (Moved to part III of the handbook)

        O  DUMP OF CODE GENERATED BY THE SIMULA COMPILER


        P  CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA

           P.1 WHY TRANSLATE FROM ALGOL TO SIMULA?
           P.2 WHY IS SIMULA NOT COMPATIBLE WITH ALGOL?
           P.3 TEXT STRING HANDLING
           P.4 INPUT/OUTPUT
DECsystem-10 SIMULA Language Handbook, part II             Page 7
CHAPTER 0 CONTENTS


           P.5 MISCELLANEOUS
DECsystem-10 SIMULA Language Handbook, part II             Page 8
Chapter 1 INTRODUCTION


1    INTRODUCTION
     ============


     SIMULA is a general purpose language which contains Algol 60
     as a subset.  Its defining documents are the Common Base
     Language [1] and the Revised Algol 60 Report [2].  In
     addition to the facilities offered by Algol, SIMULA is
     especially suited for list processing, text handling and
     simulation, through the class concept.  The SIMULA language
     is described in detail in the first part of the DECsystem-10
     SIMULA Language Handbook [3].

     The full SIMULA language, including recommended extensions,
     is implemented as defined in Common Base Language.  In
     addition a powerful interactive debugging system called
     SIMDDT is provided.  Special care has been taken to make
     this SIMULA implementation compatible with IBM 360/370
     SIMULA in as many respects as possible.  Conversion programs
     exist which transform IBM 360/370 programs to DECsystem-10
     SIMULA and vice versa (see appendix M).  Compatibility with
     other SIMULA systems is also high and a conversion program
     from CDC SIMULA to DECsystem-10 SIMULA is also available
     (see appendix M).

     This part of the SIMULA Language Handbook contains
     information on all implementation defined parts of the
     SIMULA language, such as object program I/O and various
     restrictions.  It also contains descriptions of features
     unique to the DECsystem-10 implementation, e.g.  commands
     and switches, SIMDDT debugging package and utility programs.

     The reader of this manual is supposed to be familiar with
     the SIMULA language and the time-sharing environment of
     DECsystem-10 [4].

     The development of the SIMULA system was undertaken as a
     joint project between the software house Engmans Elektronik
     AB (ENEA) and the Swedish National Defense Research
     Institute (FOA).  This document was compiled by Olof
     Bjorner, Elisabeth Engstrom, Reidar Karlsson, Ingrid
     Wennerstrom and Claes Wihlborg from ENEA and by Lars
     Enderin, Mats Ohlin, Jacob Palme and Stefan Arnborg from
     FOA.
DECsystem-10 SIMULA Language Handbook, part II             Page 9
Chapter 1 INTRODUCTION


     If you want a copy of the SIMULA system (not for the KA10
     CPU), you should get it either from the Swedish National
     Defence Research Institute or from the DECUS library.  In
     that way you will get the best and latest version.
     Therefore do not privately redistribute the SIMULA system to
     other installations.

     Copies of DECsystem-10 SIMULA for the KA10 CPU can be
     obtained from the Computing Center at the University of
     Western Ontario, London, Canada.

     Reference documents:


     1.  Dahl, Myhrhaug and Nygaard:
         Common Base Language
         Norwegian Computing Center, October 1970.
         Publication No S-22.

     2.  Revised Report on the Algorithmic Language Algol 60
         CACM Vol 6, No 1 1963.

     3.  DECsystem-10 SIMULA Language Handbook, part I
         FOA P Report No C8398-M3(E5), October 1974.

     4.  DECsystem-10 Users Handbook, 2nd Edition
         Digital Equipment Corporation, 1972

     5.  Birtwistle, Myhrhaug, Nygaard:
         SIMULA begin
         Studentlitteratur, Lund, Sweden 1973

     6.  DECsystem-10 SIMULA Technical documentation.  
DECsystem-10 SIMULA Language Handbook, part II            Page 10
Chapter 2 THE DECsystem-10 SIMULA SYSTEM


2.   THE DECsystem-10 SIMULA SYSTEM
     ==============================


     The SIMULA system consists of the following subsystems:

     *  a three pass compiler
     *  a run-time system
     *  an interactive debug system
     *  utility programs and help files.

     The SIMULA system will run under DEC monitors series 5 and 6
     and can be used in the same way as other language
     processors, e.g FORTRAN or COBOL.  The operating procedures
     are described in chapter 3.

     The compiler takes as input a source module specified in the
     command string.  If there are references to external modules
     in the program the compiler also reads attribute files for
     these modules (for further information about external
     modules see chapter 7).  The source program is translated
     into an equivalent object program.  This object program
     together with control information to the run-time system and
     symbol tables are output to a REL file.  If compile-time
     errors or warning conditions were detected, diagnostic
     messages are output to the terminal.  If the compiled module
     was itself an external class or procedure definition, an
     attribute file with extension ATR is output as well.  The
     compiler also produces a program listing with an optional
     cross reference table if requested.

     The object program, i.e.  the REL file produced from the
     main program and all REL files for external modules referred
     to by it, are loaded into core by LINK-10.  LINK-10 also
     searches the SIMULA library SIMLIB and fetches subroutines
     referred to by the object programs.  The output from LINK-10
     is an executable SIMULA program in core which can be saved
     on disk with the SAVE command.

     Before the execution starts, the user may request the
     interactive debug package SIMDDT by issuing the command
     REENTER instead of START.  This loads the self-relocating
     debug system into core.  Otherwise the debug system is
     automatically loaded after execution start when needed.

DECsystem-10 SIMULA Language Handbook, part II            Page 11
Chapter 2 THE DECsystem-10 SIMULA SYSTEM


     When the SIMULA program starts, a reentrant high segment
     (usually called operating system, object-time system or
     run-time system(1)) containing additional support routines
     is fetched from the system area.  The execution of the
     SIMULA program then proceeds.  The high segment is called
     SIMRTS.  For reasons of storage economy, SIMRTS is usually
     split into two separate segments of which one is loaded
     initially and is replaced with the other once initialization
     is ready.  The initial high segment may be needed by some
     programs when creating and opening new files in the course
     of execution, but the other high segment is the one normally
     active.

     If an illegal condition is detected during execution, SIMDDT
     is loaded and an appropriate diagnostic message is printed
     on the user's TTY.  SIMDDT then waits for commands issued by
     the user to find out the cause of the error, but program
     execution can usually not be continued.

     The debug package, SIMDDT, is similar in capacity to DDT but
     is entirely source language oriented.  The user may specify
     breakpoints and conditions to stop at defined statements.
     SIMDDT is described in chapter 9.

     Utility programs exist for conversion of SIMULA source
     programs between CDC SIMULA, IBM 360/370 SIMULA and
     DECsystem-10 SIMULA and for measuring program efficiency.
     These utility programs are described in appendix M.  A
     special program, SIMDIR, can be used to obtain information
     from the directory about the files compiled with the SIMULA
     compiler.  The SIMDIR program is described in chapter 7.

     The ability of TOPS-10 to share reentrant code in high
     segments has been utilized in the compiler and SIMRTS.  The
     compiler generates code in the low segment.  This code is
     also reentrant as long as no breakpoints are set.  Library
     routines in SIMLIB are also kept in low segment and are not
     reentrant.

     The compiler will run in a minimum of 23K words for very
     small programs and in 30K words for large programs.  The
     reentrant parts of RTS will occupy either 4.5K or 5.5K words
     of core.


-----------------

(1) The routines in SIMLIB and SIMRTS are called run-time  system
(RTS) throughout this manual.
DECsystem-10 SIMULA Language Handbook, part II            Page 12
Chapter 2 THE DECsystem-10 SIMULA SYSTEM


     The following help files exist:

     SIMULA.HLP
     contains information about the SIMULA system and references
     to other help files and documentation files.

     SIMCOM.HLP
     contains information about command string format and
     compile-time switches.  This file is also printed as a
     result of the compiler switch HELP.

     SIMRTS.HLP
     contains information about run-time switches and file
     definitions in a specification file.  This file is also
     printed as a result of the run-time switch HELP.

     SIMDDT.HLP
     contains information about available SIMDDT commands.  An
     abbreviated version of this file is printed on the user's
     TTY as a result of the SIMDDT command HELP.  
DECsystem-10 SIMULA Language Handbook, part II            Page 13
Chapter 3 OPERATING PROCEDURES


3.   OPERATING PROCEDURES
     ====================



3.1  INTRODUCTION

     The DECsystem-10 monitor supports both time-sharing and
     multiprogramming batch mode of operation.  The SIMULA
     programmer can use either or both of these operating
     environments to develop his applications.  In the
     time-sharing environment he can run the SIMULA compiler
     either directly using the R command or indirectly using the
     commands COMPILE, LOAD, DEBUG and EXECUTE.  In a batch
     environment he can also use a special batch card $SIMULA.
DECsystem-10 SIMULA Language Handbook, part II            Page 14
Chapter 3.2 OPERATING PROCEDURES, THE R COMMAND


3.2  THE R COMMAND

     This command can be used if your installation has not yet
     implemented SIMULA into the COMPIL cusp, which interprets
     commands like COMPILE and EXECUTE.

     The compiler is invoked with the following command:

     R SIMULA

     The compiler outputs an asterisk (*) on the terminal and is
     now ready to accept the first command.  A command should
     have the following format:

     relfil,lstfil=source1,source2,...

     Syntax:

     1. Each file descriptor has the format:

     dev:filename.ext[path]/switch/switch...

     Default for device (dev) is DSK.  If no path (directory) is
     given, your own default path, which may be different from
     your logged-in ppn (UFD), is used.  The default path can be
     changed by the SETSRC program.  See the SETSRC program in
     the Monitor Commands manual and the PATH. UUO in the Monitor
     Calls manual for further information about default paths.
     Subfile directories may be used.

     2. relfil receives the object code generated by the
     compiler.  If a file specification for relfil is given
     explicitly or by default, it is normally created unless
     severe errors were detected during compilation.  Exception:
     No rel file is produced when compiling the procedure heading
     for a procedure with OPTIONS /E:CODE, QUICK, FORTRAN or F40.
     See chapter 7 and app. E.  Default filename is the name of
     the first source.  Default extension (ext) is REL.

     3. lstfil receives the program listing generated by the
     compiler and is produced if one of the switches L or C is
     set (see below).  Default filename is the name of the last
     source file.  Default extension (ext) is LST.

     4. source1, source2, ...  are the source files which,
     combined, make up one SIMULA source program.  Default
     extension is SIM.  If no extension is given with the source
     file specification, .SIM is tried first, then the null
     extension.  (x.SIM, then x.).  Device must be disk or a
     logical name assigned to a disk device with the monitor
     command ASSIGN.
DECsystem-10 SIMULA Language Handbook, part II            Page 15
Chapter 3.2 OPERATING PROCEDURES, THE R COMMAND


     5. Underline (left arrow) (_) may be used instead of equal
     sign (=).

     6. If only one source file is used as input and default
     names of rel and lst files are desired the equal sign or
     underline (left arrow) may be omitted.
     Example:
       .R SIMULA
       *DSKD:X.SIM[123,456]
     is equivalent to
       .R SIMULA
       *DSK:X.REL,DSK:X.LST=DSKD:X.SIM[123,456]

     7.  A number of switches may follow any of the file
     descriptors.  A switch applies from the beginning of the
     preceding source file until the switch is changed.  Note
     however that certain switches must appear before the start
     of the program, i.e.  must follow the first source
     specification.  Switches following relfil or lstfil apply to
     the first source.  The switches are described in section
     3.5.

     8.  Leading and trailing spaces or tabs are ignored in a
     file descriptor.  The following characters delimit a file
     descriptor:
     carriage return (<CR>)
     comma (,)
     equal sign (=)
     left arrow (_)
     All other delimiting characters will be treated as illegal
     and cause an error message to appear on the terminal.

     9.  Legal characters in a device name, file name or
     extension are letters (lower case are converted to upper
     case), digits (0-9), dollar ($) and percent (%).

     10.  A project or programmer number must not exceed 6 digits
     and must contain only octal digits (i e not 8 or 9).
     Alternatively, the project or programmer number, or both,
     may be empty, normally implying that the missing number(s)
     should be taken from the UFD (logged-in ppn).  Specifically,
     [,] means your own ppn.  If the device has an implied ppn
     (SYS, HLP, NEW, LIB etc), that ppn is used as default
     instead of the UFD, however.  The default path, which is
     assumed when no path is given, can also be designated by
     [-].  The path definition must be surrounded by square
     brackets.  Sub-file directories are allowed.
DECsystem-10 SIMULA Language Handbook, part II            Page 16
Chapter 3.2 OPERATING PROCEDURES, THE R COMMAND


     When the program is compiled without errors the following
     text is printed on the terminal:

     NO ERRORS DETECTED

     If errors were detected during the compilation the typed
     text consists of the diagnostic messages together with the
     relevant source lines and the message:

     ERRORS DETECTED:

        ww TYPE W
        ee TYPE E

     where ww is number of warnings and ee is number of errors.

     Then a new asterisk is output and a new command may be
     entered.  The compilation is terminated with control-C.

DECsystem-10 SIMULA Language Handbook, part II            Page 17
Chapter 3.3 OPERATING PROCEDURES, COMPIL-CLASS COMMANDS


3.3  COMPIL-CLASS COMMANDS


     Any of the commands COMPILE, LOAD, EXECUTE and DEBUG may be
     used with all the standard features of the COMPIL CUSP such
     as concatenation with +, processor switches in parentheses
     etc.  The switch SIMULA and the extension SIM are recognized
     by the COMPIL class commands.  The file will be compiled
     with the SIMULA compiler if the source file extension is SIM
     or if the SIMULA switch is used in the command and the
     source file extension is not found or not recognized as
     belonging to another language processor.  The COMPIL switch
     CREF will give a listfile with extension LST and the LIST
     switch will give a spooled LPT file.
     If an external class or procedure is missing in a LOAD
     command the LINK-10 program will give the message:
     ?LNKUGS undefined global symbols
        name   location
     where the second character in the name is %.
     This name is unique and created by the SIMULA compiler to
     force an automatic check at load time that the external
     module has not been changed since the main program was
     compiled.  You can use the SIMDIR program to find out the
     names of all the external classes and procedures that are
     required by the main program.

     Examples:

      .COMPILE SIMPRO(-WR),SIMPR5/LIST
      SIMULA:  SIMPRO
      SIMULA:  SIMPR5

      EXIT

     The line NO ERRORS DETECTED is suppressed.

      .LOAD SIMPR1+SIMPR2
      SIMULA:  SIMPR1
      LINK:  Loading

      EXIT

      .EXECUTE SIMPRO
      SIMULA:  SIMPRO
      LINK:  Loading
      [LNKXCT SIMPRO Execution]

      .DEBUG SIMPRO
      SIMULA:  SIMPRO
      Link:  Loading
      [LNKXCT SIMPRO Execution]
DECsystem-10 SIMULA Language Handbook, part II            Page 18
Chapter 3.3 OPERATING PROCEDURES, COMPIL-CLASS COMMANDS


      SIMDDT STARTED
      *

     Chapter 9 describes how to use SIMDDT.  More elaborate
     examples are found in Appendix H.

     INSTALLATIONS WITHOUT SIMULA MODIFICATIONS TO COMPIL AND
     LINK

     If your installation has not implemented the special SIMULA
     modifications to the COMPIL and LINK cusps, then SIMULA
     source programs must be compiled using the "R SIMULA"
     command (chapter 3.2).  They may then be loaded by the
     following command:

     .LOAD/REL xxxx,SYS:SIMLIB/SEARCH

     where "xxxx" is the name of the SIMULA program to be loaded.
     (To execute write "EXECUTE" instead of "LOAD" in the above
     command string.)

     AVOIDING LINK-10 ERROR MESSAGES

     When a SIMULA program is loaded, you will sometimes get
     error messages from LINK-10.  The following description may
     help you to interpret those messages.

     The most common error message is
     ?LNKUGS undefined global symbols

     Here are some possible causes of this error message:

   > You have changed the attributes of a separately compiled
     SIMULA class, but not recompiled dependent modules.
     Recompile them with the ".COMP/COMP" command.

   > If the undefined global symbols are ".SIMVL" and ".SIMLV"
     then you have probably forgotten the switch /SEARCH on
     SIMLIB in your LOAD command.  These symbols are defined by
     programs using SIMSET and/or SIMULATION.

   > [For release 1B or 1C of DECsystem-10 SIMULA]:
          You have actually forgotten to list some separately
          compiled modules which your program needs.
     [From release 2 of DECsystem-10 SIMULA]:
          Separately compiled module names need no longer be
          listed in the LOAD command from release 2.  Instead,
          there must be .REL files corresponding to each .ATR
          file for separately compiled modules.  If the .ATR
          files are combined in a library, then the .REL files
          must be combined in a corresponding library.
DECsystem-10 SIMULA Language Handbook, part II            Page 19
Chapter 3.3 OPERATING PROCEDURES, COMPIL-CLASS COMMANDS


          Corresponding .ATR and .REL files should have the same
          filename before the extension and should be stored in
          the same directory path.

     You can find out which separately compiled modules are used
     by locating the EXTERNAL declarations in the main program.
     Alternatively, you can use the SIMDIR utility program.
     Write:
      .R SIMDIR
      DIRECTORY [1,4]
      SEARCH mainp USING
     where "mainp" should be the name of the main SIMULA program.
DECsystem-10 SIMULA Language Handbook, part II            Page 20
Chapter 3.4 OPERATING PROCEDURES, BATCH


3.4  BATCH

     The $SIMULA card is defined as a language card in SPRINT
     (Spooling PRocessor for INpuT).  The $SIMULA card precedes a
     SIMULA source program and causes SPRINT to copy the program
     onto disk and to insert a COMPILE monitor command into the
     control file.  The source program is ended by any SPRINT
     control card other than $MODE.

     When the job is run, the specified program is compiled and
     temporary relocatable binary and listing files are created.
     The listing file is printed as part of the job's output.

     The $SIMULA card does not cause execution of the program.
     Execution is initiated by an EXECUTE monitor command or by a
     $DATA or a $EXECUTE card.

     If execution is initiated by the $DATA card and no file name
     is specified on this card, then a "funny named" spooled card
     reader file containing the data following the $DATA card is
     created.  This file can be read by a SIMULA program if a
     logical file name is assigned to CDR.  The assignment can be
     done either with the ASSIGN monitor command or with a file
     specification in the SIMULA program.
     E.g.  ...NEW infile ("INFILE CDR:");

     Processor switches can be passed to the SIMULA compiler by
     including them in the command string.  Refer to Paragraph
     3.5 for a description of the SIMULA processor switches.

     If the processor switch (C) is given on the $SIMULA card a
     spooled LPT file containing program listing and cross
     reference listing will be created since the $SIMULA card
     generates a COMPILE command with /LIST as default.


     Card format:

     $SIMULA dev:name.ext [directory] (SS...)/S1/S2.../Sn

     dev:          = a file structure name.  If omitted, DSK is
                     assumed.

     name.ext      = the name of the file to be created on disk.
                     If omitted, SPRINT assigns the filename
                     LN????  (where ?  represents a character
                     arbitrarily chosen by SPRINT to produce a
                     unique filename) with the extension .SIM.
                     However, when the user specifies only a
                     filename (with no extension), SPRINT will
                     not append any extension.  The source and
DECsystem-10 SIMULA Language Handbook, part II            Page 21
Chapter 3.4 OPERATING PROCEDURES, BATCH


                     relocatable binary files will be explicitly
                     deleted at the end of the job if no filename
                     was specified.  However, if an attribute
                     file was created during the compilation it
                     will not be explicitly deleted.  Where the
                     user has specified a filename, the
                     disposition of the files depends on the
                     protection the user has given to them.

     [directory]   = a directory path other than that specified
                     on the $JOB card.  If omitted, the
                     project-programmer number on the $JOB card
                     is used.

     (SS...)       = processor switches to be passed to the
                     SIMULA compiler.  They must be enclosed in
                     parentheses without any commas or slashes.
                     However, a minus sign may precede any
                     switch.

     /S1/S2.../Sn  = the switches that control the mode of input
                     interpretation and the listing of the
                     compiled program.

       Switch        Meaning

     /ASCII          The input is read in ASCII mode.  If no
                     other card format switch is specified, then
                     the default is the mode indicated on the
                     /HOLLERITH switch on the $JOB card.

     /NOLIST         No listing file of the program is created.
                     If this switch is not specified, a listing
                     file will be created.

     /NOSUPPRESS     Trailing blanks are not suppressed.  The
                     default is no suppression.

     /SUPPRESS       Trailing blanks are suppressed.  The default
                     is no suppression.

     /WIDTH:nn       Columns 1 through nn (inclusive) are read.
                     Any remaining columns are treated as if they
                     contained blanks.  If this switch is not
                     specified or if no argument is specified,
                     then SPRINT will assume a value of 80.

     /026            The card deck is read in 026 card code.  If
                     no other card format switch is specified,
                     then the default is the mode indicated on
                     the /HOLLERITH switch on the $JOB card.
DECsystem-10 SIMULA Language Handbook, part II            Page 22
Chapter 3.4 OPERATING PROCEDURES, BATCH


                     This switch applies only to card-reader
                     input.  Input from other devices must be
                     read in ASCII code;  otherwise, an error
                     message is written in the log file and the
                     job is terminated.


     For a description of other SPRINT control cards that can be
     used in batch mode refer to DECsystem 10 OPERATING SYSTEM
     COMMANDS Chapter 3 Batch System Commands.

     An example of a SIMULA batch is given in Appendix H.6
     CONTROL CARDS IN BATCH.
DECsystem-10 SIMULA Language Handbook, part II            Page 23
Chapter 3.5 OPERATING PROCEDURES, SWITCHES


3.5  SWITCHES

     The compiler switches are passed to the compiler in three
     ways:

     i) via a COMPIL-class command or a $SIMULA card in batch.
     In this case only the short one letter forms of the switches
     are accepted, possibly preceded by a minus sign or an
     unsigned decimal number e.g.  20P.  The switches must be
     placed inside parentheses without slashes.  Note that the
     switches LIST, NOLIST and CREF exist as switches directly in
     the command.  If used this way, however, these switches
     cause an LPT-file to be produced instead of an LST-file.

     ii) via the R SIMULA command.  A switch may be placed after
     any file descriptor.  Each switch begins with a unique
     letter, which means that the switch may be denoted with one
     or more letters.  Each switch must be preceded by a slash.

     iii) in the OPTIONS statement in the SIMULA source code.
     See below for format of the OPTIONS statement.

     The meaning of a switch is reversed if it is preceded by a
     minus sign.  The lower case letters can always be used
     instead of the corresponding upper case letter.

3.5.1 SWITCHES IN COMPILER COMMAND STRING

     Name       Format  Default/Meaning

     ARRAY      /A      /A
                        Generate code to check array boundaries.

     CREF       /C      /-C
                        Generate a cross reference listing on the
                        list file.  This switch also sets the
                        L-switch.

     DEBUGS     /D      /D
                        Generate a symbol table for SIMDDT.  

     EXTERNAL   /nE     /-E
                        Treat the source program as an external
                        class or procedure.  n is a decimal
                        unsigned number specifying the block
                        level at which the external program will
                        be compiled.  Default for n is 1.  /-E
                        indicates main program.  See below for
                        format in OPTIONS statement.

DECsystem-10 SIMULA Language Handbook, part II            Page 24
Chapter 3.5.1 SWITCHES IN COMPILER COMMAND STRING


     HELP       /H      /-H
                        Type this information at the user
                        terminal.  HELP can be placed anywhere
                        before the second source file descriptor.
                        HELP is only valid in connection with the
                        R command.

     IDENTIFICATION /I  /I
                        Generate a line number table to be used
                        for debugging with SIMDDT and for
                        run-time diagnostic messages.

     LIST       /L      /-L
                        Generate a listing of the source program.
                        If this switch is present before the
                        first source file specification then all
                        source files are listed.  If it is
                        present after say, the second source
                        specification, then the first will not be
                        listed.

     NOERR      /N      /-N
                        Suppress output of error messages on the
                        user's terminal.

     PAGE       /nP     /55P
                        Specify the number (n) of lines per page
                        in the source file listing.  If n > 55
                        then the default vale 55 is used.  See
                        below for extended format.

     QUALIFICATION /Q   /Q
                        Generate code to check that a class
                        instance has a certain qualification.

     RUNSWITCHES /R     /-R
                        File specifications will be read from TTY
                        at the start of the object program
                        execution.  See below for extended
                        format.

     SEARCH     /S      /S
                        Enables automatic search of ATR
                        libraries.  Libraries on the default
                        search list (see below) are searched if
                        an ATR file corresponding to an external
                        procedure or class cannot be found.  See
                        below for extended format.

     WARNING    /W      /W
                        Warning messages are listed on the source
DECsystem-10 SIMULA Language Handbook, part II            Page 25
Chapter 3.5.1 SWITCHES IN COMPILER COMMAND STRING


                        listing (if any) and on the user's TTY.

     Y          /Y      /-Y
                        Write the line number table after the
                        source listing.  The IDENTIFICATION and
                        the LIST switches must be set.

     If the default setting (except for the LIST switch) is used
     throughout the compilation the message DEFAULT SWITCHES USED
     is printed after the source code on the listfile.  If any of
     the switches A, D, E, I, Q, R, S or W has been changed the
     message SWITCHES CHANGED FROM DEFAULT:  followed by a list
     of changed switches is printed.

3.5.2 SWITCHES IN THE OPTIONS STATEMENT

     All switches except HELP may occur in an OPTIONS statement.
     The OPTIONS statement is part of the source program and may
     be placed everywhere a comment is allowed.  The format of
     the switch is the same as for case ii) above.

     Format:

     OPTIONS(/switch/switch...);

     If the LIST switch is used in the OPTIONS statement then all
     lines including the OPTIONS statement itself are listed on
     the list file.  If -LIST is used then all following lines
     starting with the first line after the OPTIONS statement are
     suppressed up to the next LIST switch (if any).

3.5.2.1 Extended formats for switches E, P, R and S

     Note that extended formats for switches E, P, R and S are
     available.  The extended format for the E switch can only be
     used in the OPTIONS statement, whereas the longer forms of
     the P, R and S switches can also be used with the R SIMULA
     command (explicit execution of the compiler).

3.5.2.1.1 E switch

     See Appendix E for further details.

3.5.2.1.2 P SWITCH

     /P:"text"
     The text enclosed in quotes will be placed in the list file
     page heading.  The first line after the OPTIONS statement is
     printed on a new page.  This is also done for /P without
     argument.
DECsystem-10 SIMULA Language Handbook, part II            Page 26
Chapter 3.5.2.1.3 R SWITCH


3.5.2.1.3 R SWITCH

     /R:"file spec"
     The file specification has the same syntax as file
     specifications in a command.  File specifications will be
     read from that file at run time.  (See Chapter 8).

     Examples:

     /R:"SYSIN"
     /R:"TTY:"        (equivalent to /R)
     /R:"DSKC:FILES.SPC[130,131]"

3.5.2.1.4 S SWITCH
     See 7.1.1.


3.5.3 CHANGING SWITCHES DURING COMPILATION

     At start of compilation the switches are set to their
     default values which may be changed via switches passed in
     the invoking commands.  The switches retain their values
     until they are changed in an OPTIONS statement.  All
     switches can be set (change value) or reset by the OPTIONS
     statement (except HELP).  This can for example be used to
     list only parts of the source program:
     OPTIONS (/LIST);....  OPTIONS(/-LIST);

3.5.3.1 SWITCHES THAT MAY BE CHANGED ANYWHERE IN THE SOURCE FILE

     The switches A, L, N, P, Q, S and W can be set and reset in
     OPTIONS statements placed troughout the SIMULA program.  The
     effect of several S switches, however, is dependent only on
     the order in which they are listed, not on the location in
     the program.  Thus all S switches may be gathered together
     at the start of the program with the same effect, as long as
     the order is the same.  Note that the libraries mentioned
     last will be searched first!

3.5.3.2 SWITCHES THAT MUST BE DEFINED AT THE START OF THE SOURCE
     FILE

     The switches C, D, E, I, R and Y must either be passed to
     the compiler in the invoking command and/or they must appear
     in OPTIONS statements which are placed before the proper
     start of the SIMULA program (main program, class or
     procedure).
DECsystem-10 SIMULA Language Handbook, part II            Page 27
Chapter 4 IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE


4.   IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE.
     ===================================================

     This chapter covers those parts of the language which are
     implementation defined, which means that a program using
     them may execute differently on different systems.  A
     programmer should normally avoid using implementation
     defined parts of SIMULA, but the information in this chapter
     should be helpful when programs are moved between different
     SIMULA systems and when unexpected diagnostics or results
     have been obtained.  This chapter does not cover
     input/output (chapter 8), language extensions (chapter 5),
     capacity restrictions (chapter 6) or separate compilation
     (chapter 7).


4.1  SYSTEM PREFIXES.

     The use of system classes as prefixes is restricted.  For
     efficiency reasons no subclass of FILE may be used as block
     or class prefix.

     Since the body of LINKAGE contains a local object, the
     prefix chain of a prefixed block may not contain this class
     or its subclasses LINK, HEAD and PROCESS.  The definition of
     MAIN PROGRAM in SIMULATION implies that SIMULATION must not
     occur as a prefix in a class instance, and the same
     restriction has been enforced for SIMSET.  It is however
     permitted to define subclasses of SIMSET and SIMULATION as
     long as these subclasses do not occur in object generators
     (i.e.  after NEW).

     According to the SIMULA definition, a class can be used as a
     prefix only at the block level at which it is declared.  The
     system classes SIMSET and SIMULATION should be considered to
     be declared at the level where one of them first occurs, and
     their attribute classes at a level one greater.  There may
     be several occurrences of the prefixes SIMULATION and/or
     SIMSET at this level (even concurrently active) although
     this would normally not be considered good programming
     practice.


4.2  VIRTUAL MATCHES.

     DEC-10 SIMULA only accepts the virtual matches listed in the
     Common Base [1] (LABEL, SWITCH, PROCEDURE and <type>
     PROCEDURE), which is a restriction compared to IBM 360/370
     SIMULA.  When a match is detected, it is compared with the
     previous match or, if it is the first match, with the
     virtual specification.  The kinds (LABEL, SWITCH or
DECsystem-10 SIMULA Language Handbook, part II            Page 28
Chapter 4.2 IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE


     PROCEDURE) must be equal.  If the types are not equal, it
     must either be a function procedure matched to a pure (no
     type) procedure, or it must be two REF type function
     procedures where the new match is qualified by a subclass of
     the qualification of the old match.  If a no type
     specification has been matched by a function procedure the
     result of the function is accessible only where the match
     can be seen at compile time.


4.3  EDITING AND DE-EDITING PROCEDURES.

     The character used to represent the power-of-ten symbol in
     input data is initially E, as in FORTRAN.  It may be changed
     to any other printable character except a digit, ., +, -,
     TAB or blank by a call to the procedure LOWTEN.

     The exponent created by PUTREAL and OUTREAL has two digits
     (possibly both 0) and is preceded by + or -.

     INFRAC and GETFRAC read a sequence of digits where two
     consecutive digits may be separated by a blank or a decimal
     point.  There can only be one decimal point in one number.

     An edit overflow causes the text field to be filled with
     asterisks and a message to be typed after program
     completion.


4.4  MATHEMATICAL SYSTEM FUNCTIONS.

     If a mathematical function exists in both single and double
     precision, the double precision routine is chosen if the
     argument type is LONG REAL, otherwise both argument and
     function value are considered to be REAL.  Since the Algol
     Report [2] does not require a particular set of mathematical
     functions, the functions available in DEC-10 SIMULA are
     listed in table 4.1.  An asterisk (*) marks functions
     recommended in [2].  Argument types are:  I-INTEGER, R-REAL,
     L-LONG REAL.

     In addition to the functions listed below, further functions
     are available in the DECsystem-10 SIMULA Program Library.
     See LIBSIM.HLP for a listing of these, and the DECsystem-10
     SIMULA Language Handbook part III for a full description.
DECsystem-10 SIMULA Language Handbook, part II            Page 29
Chapter 4.4 IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE


     RECOMM. NAME    ARG     2ND ARG EXPLANATION

     *       ABS     R/L             modulus
             ARCCOS  R               inverse cosine
             ARCSIN  R               inverse sine
     *       ARCTAN  R/L             inverse tangent
     *       COS     R/L             cosine
             COSH    R               hyperbolic cosine
     *       EXP     R/L             exponential
     *       LN      R/L             natural logarithm
     *       SIN     R/L             sine
             SINH    R               hyperbolic sine
     *       SQRT    R/L             square root
             TAN     R               tangent
             TANH    R               hyperbolic tangent
     *       ENTIER  R/L             integer part
             MOD     I       I       remainder of first arg
                                     divided by second
     *       SIGN    I/R/L           Euler sign function


     Table 4.1: Mathematical functions.


4.5  COLLATING SEQUENCE, LETTER.

     The internal representation of CHARACTER variables is the 7
     bit ASCII representation which defines the collating
     sequence and the type conversion functions RANK and CHAR.
     The range of the former and the domain of the latter is thus
     the integers from 0 to 127, inclusive.  In the collating
     sequence, digits 0-9 are first, then upper case letters
     (A-Z) and lower case letters (a-z) (for details concerning
     special and national characters see appendix A).  A portable
     program should not use lower case letters or assume that
     digits precede letters, nor that letters are consecutive
     (letters A-Z can however safely be assumed to rank in
     alphabetic sequence).

     The Boolean function LETTER is TRUE for upper and lower case
     letters A-Z, but is FALSE for national letters $, # and @.


4.6  INITIALIZATION OF CHARACTER VARIABLES.

     A character variable in DEC-10 SIMULA is initialized to the
     null character with rank zero.  It will usually not be
     visible on the output medium when output.  In other SIMULA
     systems the initial value may often be output as a space
     (blank).
DECsystem-10 SIMULA Language Handbook, part II            Page 30
Chapter 4.7 IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE


4.7  SUBSCRIPT CHECKING.

     If subscript checking is enabled (switch /A is set), each
     subscript of a subscripted variable is checked individually.
     This is not done on all other systems.


4.8  RANDOM DRAWING.

     The random drawing procedures in DEC-10 SIMULA are based on
     Lehmers congruence method for pseudo random number
     generation.  The generator G is 5**15 and the modulus P is
     2**35:


                     U  = G U    (mod P)
                      i      i-1


                     X  = U /P
                      i    i


     If the initial value of a sequence of pseudo random numbers
     is negated, the antithetic variables are obtained.  The
     procedures always make the variables odd, so no
     initialization is necessary.  However, if initialization is
     omitted in a program it may loop indefinitely on other
     systems.

     Where the definition of a random drawing procedure assumes a
     parameter array to be monotonic, this is not checked for
     efficiency reasons.  However, no matter what the array
     contains, a reference outside the array will never occur.


4.9  QUALIFICATION CHECKING.

     If a class has become accessible by means of an INSPECT
     statement the qualification of the connected class is
     considered identical to that of the original class.
     However, a connected class can not be used as block or class
     prefix.
DECsystem-10 SIMULA Language Handbook, part II            Page 31
Chapter 4.10 IMPLEMENTATION DEFINED PARTS OF THE SIMULA LANGUAGE


4.10 SIMULATION PROCEDURE TIME


     Unlike some other systems the SIMULATION real procedure TIME
     returns the current simulation time in single precision.
     This may possibly imply that a simulation program will
     behave differently on DECsystem-10 SIMULA than on other
     systems.  
DECsystem-10 SIMULA Language Handbook, part II            Page 32
Chapter 5 LANGUAGE EXTENSIONS


5.   LANGUAGE EXTENSIONS.
     ===================

Comments

     Extensions in the source language representation are that !
     (exclamation mark) is equivalent to the keyword COMMENT, and
     that comments may occur anywhere between two basic symbols.

Constants in other radices than 10

     Integer constants can be given in the radix representation
     bRa where b is the radix (in decimal) and a is the radix b
     representation of the number.  This is allowed for radices
     2, 4, 8 and 16.  As an example, 31 can be written 16R1F.

National characters

     National characters $, # and @ can be used as letters in
     identifiers.

WHILE statement

     The WHILE statement permits a programmer to write

     WHILE b DO s1

     which is equivalent to

     L:IF b THEN BEGIN s1;  GOTO L END

     Here b is a Boolean expression and s1 is a statement (even a
     compound statement, a block or a prefixed block).  L is a
     label not occurring elsewhere in the program.  It is allowed
     to jump into s1 if it is a compound statement.

TEXT value constants in conditional expressions

     Text value constants may occure in conditional text
     expressions.  However, such expressions must not be used as
     actual parameter when the corresponding formal parameter is
     called by NAME.  TEXT constants are allowed in conditional
     expressions in the following four cases:

     a) As right-hand-side in a TEXT-VALUE-RELATION:
        Example: t:= IF bool THEN "yes" ELSE "no";

     b) As actual parameter in a procedure called by VALUE:
        Example: PROCEDURE p(t);  TEXT t;  VALUE t;  ...
                 p(IF bool THEN "yes" ELSE "no");
DECsystem-10 SIMULA Language Handbook, part II            Page 33
Chapter 5 LANGUAGE EXTENSIONS


     c) As actual parameter to certain system procedures,
        OUTTEXT, COPY and NEW ...  FILE.
        Example:  t:= COPY(IF bool THEN "yes" ELSE "no");

     d) In a TEXT-value-relation:
        Example:  IF x = (IF uc THEN "C" else "c") THEN

Precision

     The additional types LONG REAL and SHORT INTEGER are allowed
     in DEC 10 SIMULA.  LONG REAL is used for double precision
     floating point numbers, but SHORT INTEGER is equivalent to
     INTEGER and has been introduced only to get better
     compatibility with IBM 360/370 SIMULA.  All arithmetic types
     can be mixed in any way in expressions except as stated in
     chapter 6.2.

CALL system procedure

     The system procedure CALL has the following effect:
     The execution of CALL(Y) resumes execution of the detached
     instance Y at its reactivation point.  Further operations
     are as if an object generator (NEW) had been used, i.e.  if
     Y detaches or terminates control returns to after the CALL
     statement.  Y must be detached and not operating when
     CALL(Y) is executed.

PREV system function

     The new system function PREV which is an attribute of
     LINKAGE gives as result the same value as LAST for a HEAD of
     a non-empty list, the same as PRED for a LINK which is not
     first in a list and the HEAD for the first LINK in a list
     (Common Base 17.2).

BREAKOUTIMAGE system procedure

     The new system procedure BREAKOUTIMAGE is an attribute of
     OUTFILE.  It is identical in effect to OUTIMAGE except that
     the trailing <CR><LF> of the image is not output (used
     mainly when writing to a terminal).

OPTIONS statement

     The OPTIONS statement is not a language extension but a
     communication channel to the programming system, see Chapter
     3.  OPTIONS is however made a reserved word in DEC-10
     SIMULA.

EXTERNAL procedures and classes
DECsystem-10 SIMULA Language Handbook, part II            Page 34
Chapter 5 LANGUAGE EXTENSIONS


     Language extensions related to separate module compilation
     are described in Chapter 7 of this handbook and in chapter 4
     of part I of the DECsystem-10 SIMULA Language Handbook.

HIDDEN specification

     The HIDDEN and PROTECTED specifications described in the
     DECsystem-10 Simula Language Handbook part I chapter 2.5.7
     are accepted by the system.
DECsystem-10 SIMULA Language Handbook, part II            Page 35
Chapter 6 RESTRICTIONS


6.   RESTRICTIONS.
     =============


6.1  CAPACITY RESTRICTIONS.

     Capacity restrictions are a consequence of the internal
     design of DEC-10 SIMULA, such as the number of bits used
     internally to hold a particular quantity.  The significance
     of such restrictions at source language level is often
     difficult to explain, and the normal course of action taken
     by a programmer should be to rewrite a program when a
     violation has been diagnosed.  Some of the capacity limits
     are so high that a violation is very unlikely to occur
     whereas others are not.  The limitations are also dependent
     on the amount of core and disk space available.  The
     following limits must not be exceeded:

     LIMIT   QUANTITY

     128K    largest low segment area(object code+data)
     10      number of subscripts in array
     64      block level
     255     formal parameters to procedure or
             (concatenated) class
     255     virtual quantities in (concatenated) class
     511     BLOCK STATE NUMBER
     65535   maximum line number in source module
     3072    number of differently spelled identifiers
             in source module
     32      DISPLAY LEVEL
     20      CONCURRENT single precision intermediate
             quantities
     4096    FIXUPS
     200     SUBEXPRESSIONS IN A SIMPLE STATEMENT
     1023    words in BLOCK INSTANCE RECORD


     The meaning of some of these quantities can only be
     explained by reference to the syntax tree for a program as
     defined in the Algol Report [2] and the Common Base [1].

     [The maximum BLOCK STATE NUMBER is the size of the maximal
     set of <unlabelled block>:s in the syntax tree which is not
     cut by an instance of <prefixed block>, <class body>,
     <procedure body>, <connection> or <for statement>, except an
     instance of <prefixed block> or <procedure body> which is
     the root of the minimal subtree containing all the subblocks
     in the set.  In this definition a prefixed block or a
     procedure or class body should not be regarded as an
     unlabelled block.]
DECsystem-10 SIMULA Language Handbook, part II            Page 36
Chapter 6 RESTRICTIONS


     The maximum DISPLAY LEVEL is computed for a hypothetical
     program obtained by replacing all external declarations by
     their defining declarations.  In this program take the
     number of instances of <prefixed block>, <class
     declaration>, <procedure declaration>, <for statement>,
     <connection> and <actual parameter> corresponding to a
     formal parameter which is not known not to be by name in a
     path of the syntax tree.  Also add all occurrences along the
     path of <unlabelled block> which are separated from the
     enclosing scope by an instance of <for statement>,
     <connection> or <class body>.  The maximum DISPLAY LEVEL is
     the maximal such value plus one or, if the outermost scope
     is a <prefixed block>, two.

     The number of FIXUPS is obtained by adding weights of syntax
     entities in a single module:

     2       <conditional statement>
     4       <connection>
     1       <label definition>
     2       <unlabelled block>
     4       <procedure declaration>
     6       <class declaration>
     5       <prefixed block>
     2       <while statement>

     The number of CONCURRENT INTERMEDIATE QUANTITIES is
     minimized by reordering operands to commuting operators like
     +, *, :=, etc.  As an example, the expression 

     A:=A+(A+(A+(A+A)))

     has 6 INTERMEDIATE QUANTITIES if A is a formal parameter
     called by name, but only one if A is a declared REAL
     variable.

     The number of SUBEXPRESSIONS IN A SIMPLE STATEMENT is well
     approximated by the number of basic symbols in it, with the
     following corrections:

     -1      <conditional expression>
     -1      parenthesis delimiting subexpression
     -1      left parenthesis delimiting parameters, switch
             index or array subscripts
     +1      long real constant
     +1      implicit arithmetic conversion or qualification
             check
     +1      actual parameter to class, prefixed block or
             declared procedure

     The size of a BLOCK INSTANCE RECORD is two plus the size of
DECsystem-10 SIMULA Language Handbook, part II            Page 37
Chapter 6 RESTRICTIONS


     all its parameters and variables.  All name parameters
     require two words.  Otherwise, an ARRAY requires one word
     regardless of type.  LABEL and PROCEDURE parameters called
     by reference require two words, SWITCH by reference one
     word.  Simple quantities require two words if their type is
     LONG REAL or TEXT, otherwise one word.  In addition, the
     value of a function requires one or two words depending on
     the type.


6.2  PARAMETER CORRESPONDENCE.

6.2.1 Call by value.

     For an arithmetic array passed by value the actual type must
     be identical to the formal type.

6.2.2 Call by reference.

     A string is not a legal actual parameter for a text
     parameter called by reference.  This is a restriction
     compared to IBM 360/370 SIMULA.  An actual array parameter
     of type REF must have the same qualification as the formal
     array.

6.2.3 Parameters to system procedures and functions.

     Where an array is passed to a system procedure or function
     (DISCRETE, HISTD, LINEAR, HISTO) the type of the array must
     be REAL.  The last parameter to random drawing functions
     must be an INTEGER (declared, subscripted or remote)
     variable or an INTEGER parameter which was passed by value.
     The first three parameters to ACCUM must be REAL (declared,
     subscripted or remote) variables or REAL value parameters.


6.3  FOR STATEMENTS.

     The controlling variable of a for statement must not be of
     type TEXT.  Neither may it be a subscripted or remote
     variable, a name parameter or a function identifier.

     These restrictions to Algol 60 are recommended in SIMULA,
     but they have not been enforced in all implementations.
DECsystem-10 SIMULA Language Handbook, part II            Page 38
Chapter 6 RESTRICTIONS


6.4   MISCELLANEOUS RESTRICTIONS.

     A subclass must be declared after its prefix class.

     A switch which is an attribute of a terminated class
     instance can not be accessed.


6.5  RESTRICTIONS IN SIMULA WITH RESPECT TO ALGOL 60.

     In this section we list all differences between SIMULA and
     pure Algol 60 which may cause a pure Algol 60 program to
     behave differently when running as a SIMULA program.  All
     subsections are preceded by the number of a paragraph in the
     Algol Report [2] which is not valid for SIMULA.

     (2.6) The entities <proper string>, <open string> and
     <string> do not exist in SIMULA.  They are replaced by TEXT
     variables and constants.

     (3.2) A <parameter delimiter> in SIMULA is a comma (,).
     Parameter comments ("fat comma") are not permitted.
     Ordinary comments may be used instead.

     (3.5.1) Integer labels are not permitted.

     (4.3.5) A transfer to a switch designator whose value is
     undefined is equivalent to a dummy statement except that
     side effects caused during the evaluation will remain.

     (4.6.1) FOR statements, see also 6.3.  The increment of a
     STEP-UNTIL element is evaluated once after the initial
     assignment to the control variable, once for every new
     repetition and once after the last repetition.  This may
     cause different behaviour if the increment is an expression
     which causes side effects or is dependent on the value of
     the control variable.

     (4.7.3.1), (4.7.3.2) The default parameter transmission mode
     for simple parameters is by value, not by name.

     (4.7.5.5) All formal parameters must be completely specified
     with respect to type and kind.  A standard (system)
     procedure or function can not be passed as an actual
     parameter to a formal parameter specified PROCEDURE or
     <type> PROCEDURE.  For actual to formal parameter
     correspondence, see also 6.2.1.

     (5.1) OWN variables are not permitted in SIMULA.  
DECsystem-10 SIMULA Language Handbook, part II            Page 39
CHAPTER 7  SEPARATE COMPILATION





7.   SEPARATE COMPILATION
     ====================


     A user-oriented description of separate compilation in
     SIMULA is given in chapter 4 of the DECsystem-10 SIMULA
     Language Handbook Part 1.  If you are not thoroughly
     familiar with the principles of separate compilation in
     SIMULA, you should read that chapter before continuing with
     this text.

     To implement the error checking during compile time, the
     compiler, when compiling an external module, generates an
     attribute file (extension ATR) which describes all
     accessible attributes of the object.

     When compiling a program which uses a previously compiled
     external module, the compiler must be told where to find the
     ATR-file of the used module.  This can be done in the
     EXTERNAL declaration or by using the SEARCH switch in the
     OPTIONS statement.


7.1  THE EXTERNAL DECLARATION


     The syntax of the <external declaration> is (!  stands for
     choice):

        <octal digit>::=0!1!2!3!4!5!6!7

        <octal number>::=<octal digit>!
                         <octal number><octal digit>

        <ppn>::=!<octal number>,<octal number>!
                 <octal number>,!,<octal number>

        <sfd list>::=<identifier>!<sfd list>,<identifier>

        <path>::=![<ppn>]![-]![<ppn>,<sfd list>]

        <device>::=!<identifier>:

        <external identifier>::=<device><identifier><path>

        <external item>::=<external identifier>!
                          <identifier>=<external identifier>
DECsystem-10 SIMULA Language Handbook, part II            Page 40
CHAPTER 7.1  SEPARATE COMPILATION. THE EXTERNAL DECLARATION.


        <external list>::=<external item>!
                          <external list>,<external item>

        <external declaration>::=
                  EXTERNAL PROCEDURE <external list>!
                  EXTERNAL <type> PROCEDURE <external list>!
                  EXTERNAL CLASS <external list>

        <separately compiled procedure>::=<procedure declaration>
           !<external declaration><separately compiled procedure>

        <separately compiled class>::=<class declaration>!
            <external declaration><separately compiled class>

        <separately compiled main program>::=<program>

        <singly compiled main program>::=<program>


     The difference between <separately compiled main program>
     and <singly compiled main program> is that <separately
     compiled main program> contains at least one <external
     declaration> and <singly compiled main program> contains no
     <external declaration>.


     The external identifier is a file specification which may be
     used to retrieve the attribute file (after completing the
     specification by the extension ATR).  DSK:  is used for
     <device> if omitted.  The user's default path is used if
     <path> is omitted.  If project or programmer number is
     omitted, the user's logged-in ppn (his UFD) is used to
     supply the missing information.  The specification [-] is an
     alternative way of specifying the default path (same as
     missing <path>).

     <device> must be a disk-like device.


     A separately compiled class or procedure may only refer to
     the following entities in the local environment of the
     external statement:

     - Formal parameters of the separately compiled class or
     procedure.

     - Other separately compiled classes with their externally
     accessible attributes.

     - Other separately compiled procedures.
DECsystem-10 SIMULA Language Handbook, part II            Page 41
CHAPTER 7.1  SEPARATE COMPILATION. THE EXTERNAL DECLARATION.


     These other separately compiled classes and procedures are
     declared by external declarations in the source program of
     the separately compiled module.  Their declarations precede
     the proper start of the source code of the separately
     compiled class or procedure.


     Example of full source text of a separately compiled class
     using these conventions:

       OPTIONS(/E);
       EXTERNAL PROCEDURE a;
       EXTERNAL CLASS b,c,d;
       b CLASS e(f);REF (c) f;
         BEGIN REF (d) g;
           g :- NEW d;
           a(g);
         END


     External declarations preceding the beginning of a
     separately compiled class or procedure do not cause any
     copying of the declared external modules into the combined
     program.
     They simply inform the compiler that these external
     declarations will occur in the environment of an external
     statement introducing the module into another program, class
     or procedure.
     Thus, a, b, c and d in the example must be declared by
     external declarations in the environment of an external
     statement referring to e.

     According to SIMULA rules, separately compiled prefix
     classes must be copied into a program in the same block as
     their subclasses.

     Example;  "- - - -" indicates separate compilation:

     CLASS a; BEGIN ... END
     - - - -
     EXTERNAL CLASS a; a CLASS b; BEGIN ... END
     - - - -
     BEGIN COMMENT main program;
       EXTERNAL CLASS a,b;
       ...
     END
DECsystem-10 SIMULA Language Handbook, part II            Page 42
CHAPTER 7.1  SEPARATE COMPILATION. THE EXTERNAL DECLARATION.


7.1.1 TELLING THE COMPILER WHERE TO FIND EXTERNAL MODULES

     When an external module is compiled, two output files are
     usually produced, one with extension ATR and one with
     extension REL.  (If the actual code is in another language,
     another compiler produces the REL file, see appendix E.) For
     example, the separately compiled module X.SIM will yield the
     two output files X.ATR and X.REL.

     The ATR file is read by the compiler each time a module
     which uses X is compiled.  The REL file is used by the
     loader (LINK-10) to produce an executable program from
     several separately compiled modules.

7.1.1.1 SEARCH LIST


     When the compiler has encountered an external declaration,
     e.g.
          EXTERNAL CLASS X;
     and does not find the file <external identifier>.ATR (X.ATR
     in this case) in the user DSK area, it scans an (implied)
     SEARCH LIST consisting of file definitions (device name,
     file name, path).  The search list is also used when a class
     or procedure is compiled separately, to find a possible
     matching ATR module which is compared to the attribute
     information of the module being compiled.  If no attributes
     have changed, no new information need be created, but if the
     matching module was found in a library, a copy of the module
     is output as a separate ATR file matching the REL file being
     produced, if any.  In this way the ATR and REL files will
     nearly always be found on the same disk area (possibly in
     matching libraries).

7.1.1.1.1 DEFAULT SEARCH LIST

     If no SEARCH switch is given in the source file or via the R
     or COMPILE command, the default search list contains
     DSK:LIBSIM[user default path] and SYS:LIBSIM.  The extension
     ATR is assumed throughout.

     LIBSIM and any other file on the search list must be
     recognized as a library.  In the library, the SIMULA name of
     the external module is used as a search key to find the
     corresponding ATR module.  FUDGE2 or MAKLIB can be used to
     create an ATR library.  See 7.1.1.5.

     The SEARCH switch can be used to modify the search list by
     adding or deleting files.  If an explicit file definition
     (see 7.1.1.2) is given in the external declaration, the
     search list is not used.
DECsystem-10 SIMULA Language Handbook, part II            Page 43
CHAPTER 7.1  SEPARATE COMPILATION. THE EXTERNAL DECLARATION.


7.1.1.2 EXPLICIT SPECIFICATION OF THE ATR FILE

     In the EXTERNAL declaration, you can write e.g.
          EXTERNAL CLASS x=x1[100,200];
     This tells the compiler that the CLASS x is described in the
     ATR file x1.ATR on the disk area for ppn [100,200].  The
     compiler will not look for other ATR files if you give the
     file name in this way.  If x1.ATR is not found, an error
     message will be given.  If x1.ATR is a library (see
     7.1.1.5), the name x will be looked up, otherwise x1.ATR
     will be used directly.  When compiling a class or procedure
     separately, the corresponding effect is achieved by having a
     name on the REL file which is different from the SIMULA name
     of the class or procedure (first 6 letters) and/or by
     specifying a path different from the default path for the
     REL file.  Note that the REL file specification is used also
     for the ATR file, with the extension changed to ATR.


7.1.1.3 THE SEARCH SWITCH

     The SEARCH switch can be used to modify the library search
     which is performed when X.ATR is not found.  You can tell
     the compiler to search other libraries than LIBSIM and on
     directories (paths) other than your own default path or the
     SYS default path.  The possible variants are:

     a) /S with no argument.  This means that the default search
     list (see 7.1.1.1.1) is (re)established.  Any additional
     libraries are left on the list in their original places.

     b) /S:"file spec", puts the library mentioned on the search
     list.  The same library will only appear once on the search
     list.

     c) /-S with no argument.  No libraries will be searched.  /S
     will reestablish the standard search list, leaving other
     libraries off the list.

     d) /-S:"file spec" removes the specified library from the
     search list.

     Example:  OPTIONS(/-S/S:"LIBSIM[101,101]") removes
     LIBSIM.ATR and SYS:LIBSIM.ATR from the search list, leaving
     only LIBSIM.ATR[101,101].  OPTIONS(/S), if given later,
     reestablishes the standard list, but LIBSIM.ATR[101,101]
     will still be searched before LIBSIM.ATR[-].  [-] means the
     default path for DSK.  Note that the SEARCH switch can also
     be given via R SIMULA in the command string!  Note also that
     ALL search switches apply to ALL external declarations in
     the currently compiled module, since action is taken after
DECsystem-10 SIMULA Language Handbook, part II            Page 44
CHAPTER 7.1  SEPARATE COMPILATION. THE EXTERNAL DECLARATION.


     scanning the whole module.

7.1.1.4 LOADING AND EXECUTING PROGRAMS WITH EXTERNAL MODULES

     Loading and execution commands are greatly simplified if the
     REL file corresponding to a given ATR file is found by
     simply substituting the extension REL for the extension ATR.
     If the ATR file is X.ATR, the REL file should be X.REL, and
     if the attributes of X are found in the library L.ATR, the
     code of X should be found in the library L.REL.  To simplify
     the load command, the compiler will tell LINK-10 to look for
     object code in REL files corresponding to the ATR files
     used.

     A program can thus be (compiled and loaded and) executed
     simply by the command
          EXECUTE mainprogramname
     providing the external modules have been compiled in
     advance.

     Note that since the REL files are loaded in library search
     mode, explicit inclusion of files in the command string may
     be used to bypass the search for certain entry points.


7.1.1.5 Producing ATR and REL file libraries

     Libraries of ATR or REL files can be produced by copying
     together several ATR or REL files using the FUDGE2 or MAKLIB
     program, which are described in the DECsystem-10 monitor
     commands handbook.

     IMPORTANT!!!  The /X (/INDEX) switch must be used to produce
     an index, otherwise the SIMULA compiler cannot find the ATR
     modules.  Be careful to mention the extension ATR, since REL
     is assumed if no extension is given!

     Example:  Add proc to LIBSIM.ATR and LIBSIM.REL -
       .R FUDGE2
       *LIBSIM.REL=LIBSIM.REL,proc.REL/A$
       *LIBSIM.ATR=LIBSIM.ATR,proc.ATR/A$
       *LIBSIM.REL=LIBSIM.REL/X$
       *LIBSIM.ATR=LIBSIM.ATR/X$

     $ stands for <ALTMODE> (octal 33).
DECsystem-10 SIMULA Language Handbook, part II            Page 45
CHAPTER 7.2  SEPARATE COMPILATION.  THE EXTERNAL SWITCH.


7.2  THE EXTERNAL SWITCH


     Short form: nE:<list>
     Long form:  nEXTERNAL:<list>
     Default:    -E


     Treat the source program as an EXTERNAL CLASS or PROCEDURE.
     -E indicates main program.  When /E or /-E appears in an
     OPTIONS statement it has no effect unless it appears before
     the proper start of the SIMULA program.

     n is an unsigned decimal number specifying the block level
     at which the external module is going to be declared in the
     main program.  n is optional and has the default value 1
     (the outermost block).

     :<list> can only be used in an OPTIONS statement placed at
     the start of the SIMULA specification program for an
     external procedure written in MACRO-10 or FORTRAN (detailed
     explanation in appendix E).




7.3  RESTRICTIONS ON SEPARATE COMPILATION


     A separately compiled class or procedure must not be
     declared as attribute to another class.

     A separately compiled class or procedure must not be copied
     indirectly, i.e. in a separately compiled class or procedure
     all external declarations must precede the proper start of
     the class or procedure declaration.

     In an EXECUTE, LOAD or DEBUG monitor command, source files
     should be listed in compilation order, with the main program
     last.  The compilation order must be such that attribute
     files are available when referred to.

     Error messages from LINK-10 because of missing REL files are
     explained at the end of section 3.3 in this handbook.

     7.4  SIMDIR UTILITY PROGRAM
DECsystem-10 SIMULA Language Handbook, part II            Page 46
CHAPTER 7.4  SEPARATE COMPILATION.  SIMDIR UTILITY PROGRAM.


With the SIMDIR program you can easily find out:
     > Which separately compiled modules are required by one or
     several main programs.
     > Which program modules require a certain separately
     compiled procedure or class.
     To start the program type:
     .R SIMDIR
     SIMDIR responds with a "*" , signalling that it is ready for
     a command.

     In the simplest case, you can now write:

        SEARCH /ALL REQUIRED BY main

     This will list all modules on your PPN which are used by the
     module main.  main is usually a SIMULA main program, but can
     be a separately compiled module.

        SEARCH /ALL USING proc

     This will list all modules on your PPN which use the
     separately compiled module proc.

     You can precede the SEARCH command with a DIRECTORY command
     to tell the system to include other PPN:s in the search.
     For example, you can write:

        DIRECTORY [*,*]
        SEARCH /ALL USING proc

     This will give a listing of all SIMULA programs on all PPN:s
     which require your separately compiled procedure proc.

     As input SIMDIR requires ATR-files from separately compiled
     classes and procedures and REL-files from main programs.
     This means that SIMDIR only works when such ATR and REL
     files are present for the programs to be listed.

     The syntax of SIMDIR commands follows:

     <SEARCH-command>::= SEARCH <pattern> [<relation>[<pattern>]]
        <relation>::= USING ! REQUIRED BY
        <pattern>::= [<device>][<filename>][<ppn>][<switches>]
        <ppn>::= <left bracket><ppn1><right bracket>
        <ppn1>::= SELF ! OTHERS ! <pnr>,<pnr>
        <pnr>::= ! * ! <octal number>
        <switches>::= <switch> ! <switches><switch>
        <switch>::= /<switchname>
        <switchname>::= ALL ! MAIN ! CLASSES ! PROCEDURES !
                FPROCEDURES ! SPROCEDURES ! MPROCEDURES !
                FAST ! TTY
DECsystem-10 SIMULA Language Handbook, part II            Page 47
CHAPTER 7.4  SEPARATE COMPILATION.  SIMDIR UTILITY PROGRAM.


        <device>::= <name>:
        <filename>::= <name>

        SEARCH <pattern> means that all modules matching the
        pattern will be searched for and listed.

        SEARCH <pattern> <relation> means that all modules
        matching the pattern will be searched for and listed
        together with the modules which have the given relation
        to the modules.

        SEARCH <pattern> <relation> <pattern> means that all
        modules matching the first pattern and having the given
        relation to any module matching the second pattern are
        listed.

        A module matches a pattern when it matches all components
        of that pattern.  If any component is missing in a
        pattern, then all modules match that component.  The
        pattern may not be empty, however.

        There are two special PPN:s that you may use in a
        pattern:  [SELF] is the LOGIN PPN.  [OTHERS] stands for
        all PPN's except [SELF] which have been given in
        DIRECTORY commands.

        Explanation of switches:
                ALL             All modules match
                MAIN            Main programs match
                CLASSES         Classes match
                PROCEDURES      Procedures match
                FPROCEDURES     FORTRAN procedures match
                MPROCEDURES     MACRO-10 procedures match
                SPROCEDURES     SIMULA procedures match
                FAST            Do not output PPN
                TTY             Change output device
                                temporarily to TTY.


     <DIRECTORY-command>::= DIRECTORY <directories>
        <directories>::= <directory> ! <directory>,<directories>
        <directory>::= [<switch>] <ppn> [<switch>]
        <switch>   ::= /MAIN ! /-MAIN

        Include the given directories when searching.
        /MAIN means that all modules are fetched from this
        directory, /-MAIN that only external classes and
        procedures are fetched.  Default is /-MAIN.


     <LIST-command>::= LIST <file specification>
DECsystem-10 SIMULA Language Handbook, part II            Page 48
CHAPTER 7.4  SEPARATE COMPILATION.  SIMDIR UTILITY PROGRAM.


        Program output - as generated by subsequent search
        commands - is written on the specified file.  Default is
        DSK:SIMDIR.LST


     <CLOSE-command>::= CLOSE

        The current list file is closed.


     <EXIT-command>::= EXIT

        Close current list file (if any) and return to monitor.


     <HELP-command>::= HELP [ /TTY ]

        Output help-text.


     All "reserved words" (upper case letters above) can be
     abbreviated arbitrarily.  Any conflicts are resolved as
     follows :
        /M means /MAIN
        /F means /FAST


     When SIMDIR is started a *D[S]/M command is automatically
     performed.


     EXAMPLES:

     List all SIMULA modules on your own PPN
      .R SIMDIR
      *S/ALL
        .
        .
        .

     List those of your own modules which are used by others in
     the same project.
      .R SIMDIR
      *DIR [,*]/M
      *SEARCH [SELF] REQ BY [OTHERS]
        .
        .
        .
DECsystem-10 SIMULA Language Handbook, part II            Page 49
CHAPTER 8 OBJECT PROGRAM I/O


8    OBJECT PROGRAM INPUT-OUTPUT
     ===========================


8.1  INTRODUCTION


     The SIMULA run-time system (RTS) supports input from and
     output to files on auxiliary memory like disk storage,
     DECtape and magnetic tape and standard peripherals like line
     printer, card reader and punch, paper tape reader and punch.
     These peripherals will normally be spooled in a time-sharing
     environment but RTS will not distinguish between spooled and
     unspooled devices.

     Only ASCII (=ISO-7) mode input and output is supported.
     Binary I/O can be performed only with external assembly
     procedures (see chapter 7 and appendix E).

     Files can be accessed sequentially using class INFILE.
     Class DIRECTFILE allows random access in addition to
     sequential access.  Class DIRECTFILE can only be used with
     files on disk, however.

     The I/O subsystem of RTS works interactively with the user
     as described in later sections.  When an error condition
     occurs the user is consulted for corrective action if
     recovery is possible, otherwise a run-time error occurs.

     To escape from the dialogue the user can use altmode as
     answer.  SIMDDT is then entered and the user can later
     resume the dialogue with the PROCEED command (refer to
     chapter 9).  Note however, that it is not possible to use
     SIMDDT when the escape facility is used in dialogue before
     start of the SIMULA program execution, i.e.  when the
     specification file is read.

     The various dialogue messages are described in appendix D.
     The rest of this chapter is concerned with how to define
     files, run-time switches and various aspects of the
     different input-output classes of SIMULA.
     8.2  HOW TO DEFINE A FILE


     A new file is created with the object generator NEW.  File
     objects can be of four different classes:

     infile
     outfile
     printfile
     directfile
DECsystem-10 SIMULA Language Handbook, part II            Page 50
Chapter 8.2 OBJECT PROGRAM I/O, HOW TO DEFINE A FILE


     Printfile is a subclass of outfile.  The argument to these
     file classes should be a text variable or a text constant
     containing a file definition.  The file definition binds the
     file object to a device and a physical file.
     File definition format:

     logicalname file-descriptor

     The logical name must consist of one to six alphanumeric
     characters.  The characters percent (%) and dollar ($) will
     also be accepted.  The logical name is used in all run-time
     error messages concerning I/O.  The following text will
     precede all such errors:
     ERROR FOR FILE:  logicalname
     The logical name need not be unique, but the user is advised
     to have unique names for ease of identification.  The
     logical name is also used to link file class arguments to
     file definitions from the specification file as described
     below.

     Examples:

     FILE1:-NEW infile ("FILE1 MYFILE.DAT");
     x:-NEW outfile("FILE2 RESULT.LST<077>");
     INSPECT NEW directfile ("dir random") DO ...

     The logical name may be omitted from the file definition.
     In this case the file name will be used as logical name or
     if the file name is missing, the device name is used.

     Examples:

     Y:-NEW outfile("LPT:");                 Logical name is LPT
     Z:-NEW infile("TEXT.ASC");              Logical name is TEXT
     W:-NEW infile("W");                     Logical name is W

     The logical name must be delimited by at least one space or
     tab.

     The complete format of a file descriptor is:

     device:filename.extension[path]<protection>/switch/switch
     ...
        or
     str:<directory>filename.type;protection/switch/switch ...
     (TOPS-20)

     Default for device or str is DSK.  Device may be any
     physical device name or logical device name (structure name)
     previously defined (via the ASSIGN command or equivalent).
     Default for file name is logical name.  No default for
DECsystem-10 SIMULA Language Handbook, part II            Page 51
Chapter 8.2 OBJECT PROGRAM I/O, HOW TO DEFINE A FILE


     extension (type).  may contain letters (lower case are
     converted to upper case), digits, percent and dollar sign.
     Part or all of the filename can also be specified in octal
     code.  The character "#" (number sign) starts a string of
     octal digits (values 0-7).  Two octal digits represent one
     character in sixbit (DEC-10 64 character subset).  An odd
     number of digits is augmented by a final zero.  The string
     is converted to 6-bit bytes and inserted in the file name
     (left justified) at the position of the number sign.  The
     string of digits is finished when a non-octal character is
     encountered.  Example:  "DSKD:#000123000456.UFD[1,1]" is the
     specification of the UFD (user file directory) of path
     [123,456] on structure DSKD.

     Default for path is user's default path.  The format is:

     [projectnumber,programmernumber,sfd1,sfd2,...]

     The path must always end with a right square bracket.
     Default TOPS-20 directory is the connected directory.
     Default for protection is the installation defined standard
     protection.  Switches are covered in section 8.3.  Trailing
     or leading spaces and tabs are ignored in the file
     descriptor.

     A file descriptor may contain an asterisk in any of the
     fields except protection.  This will cause a dialogue at
     run-time.  The following message is typed on the terminal:

     %PLEASE SPECIFY ADDITIONAL INFORMATION FOR FILE:
     logicalname
     *

     The user can now enter missing parts of the file descriptor
     and also override previously defined parts.

     Example:

        ...  NEW infile ("FILE1 *");

     RTS types:

     %PLEASE SPECIFY ADDITIONAL INFORMATION FOR FILE:  FILE1
     *INFIL.DAT

     The system will repeat this request until all fields
     containing asterisks are defined.

     The source contains:  ...  NEW infile("file2 *:*");

DECsystem-10 SIMULA Language Handbook, part II            Page 52
Chapter 8.2 OBJECT PROGRAM I/O, HOW TO DEFINE A FILE


     The following dialoque might take place:

     %PLEASE SPECIFY ADDITIONAL INFORMATION FOR FILE:  file2
     *INFIL.DAT
     %PLEASE SPECIFY ADDITIONAL INFORMATION FOR FILE:  file2
     *DSK:

     This is one way in which the user can defer the binding
     between file and file object until run-time.

     A similar dialogue is entered when an error occurs such that
     the file specification given by the program cannot be
     opened.  In such a case, you can transfer to SIMDDT from
     this dialogue by pushing the ALTMODE (ESCAPE) button on your
     terminal.

     Another way is to let the SIMULA program use data from the
     TTY or a file on any other device to create parameter
     strings to NEW file creations.

     A third way to achieve this is the specification file
     facility.  This gives the user the ability to specify all
     his file definitions in a special file that is read by RTS
     before start of execution.  This file may also contain
     run-time switches.  The compile switch RUNSWITCHES must be
     used at compilation.  This switch defines the specification
     file which can be TTY or a DSK file.  /R without argument
     denotes TTY.  In that case the RTS will type ENTER FILE
     DEFINITIONS before execution start and the user may supply
     file definitions and switches.  The TTY input is terminated
     with a carriage return.

     Example:

      .EXECUTE SIMPRO(R)
      SIMULA:  SIMPRO
      LINK:  Loading
      [LNKXCT  SIMPRO Execution]
      ENTER FILE DEFINITIONS:
      *FILE1 INFILE.DAT[130,133]
      *FILE2 OUTFIL.DAT
      *SCRATCH DUMMY
      *
      EXECUTION STARTED

     The file definitions have the same format as in the argument
     to the file classes.  The logical name must be unique, since
     RTS uses this name to link the file definitions in the
     specification file to the file class arguments.  RTS will
     build a table from the specification file.  When a new file
     object is created this table is searched to see if the file
DECsystem-10 SIMULA Language Handbook, part II            Page 53
Chapter 8.2 OBJECT PROGRAM I/O, HOW TO DEFINE A FILE


     was defined prior to execution.  Information in the
     specification file overrides the information in the file
     class argument.

     The file definitions may also be a part of SYSIN.  This is
     accomplished with /R:"SYSIN" in the OPTIONS statement in the
     source code.  If SYSIN is read from TTY the dialogue
     described above will take place.  If SYSIN is a disk file,
     the file definitions are read from SYSIN.  They must then be
     terminated with an empty line to separate them from the rest
     of the SYSIN input to be read by the program.

     It is also possible to use indirect specification files.
     This is denoted with the normal indirect delimiter:

     @file-descriptor

     Indirect files can only be read from disk and must not
     contain any definitions of indirect files.  They must not be
     stored in sub-file directories.

     Example:

      .EXECUTE SIMPRO(R)
      SIMULA:  SIMPRO
      LINK:  Loading
      [LNKXCT  SIMPRO Execution]
      ENTER FILE DEFINITIONS:
      *@FILES.SPC
      *
      EXECUTION STARTED

     Specification files on disk need not be terminated with an
     empty line.  It is possible to have more than one indirect
     specification file, but they can not be nested.  SYSIN may
     also be used as an indirect specification file.
DECsystem-10 SIMULA Language Handbook, part II            Page 54
Chapter 8.3 OBJECT PROGRAM I/O, RUN-TIME SWITCHES


8.3  RUN-TIME SWITCHES


     Switches that appear before the file definition or, in a
     specification file, alone on a line are called GLOBAL
     switches.  Other switches are termed LOCAL.  The same switch
     may be either local or global as defined below.  All
     switches can be designated with their first letter or with
     as many letters as desired.  The full names are given below.

     ACCESS:APPEND
     This switch can only be local and is applicable to outfiles
     and printfiles only.  It means that the file will be written
     in append mode, i.e.  the output will be appended to the
     file if it already exists.

     ACCESS:RONLY
     This local switch is applicable to directfiles only.  It
     means that the directfile can only be read, not modified.

     BUFFER:n

     type     n       meaning

     global   =<32    
                      n is the number of buffers in the buffer
                      ring for all subsequent files, unless they
                      have a local BUFFER switch or a new global
                      BUFFER switch appears
     global   >32     
                      n defines the area in words to be allocated
                      for buffers (necessary space for all files
                      defined in the specification file will
                      however always be allocated regardless of
                      this value)
     local    =<32    
                      n is the number of buffers in the buffer
                      ring for this file
     local    >32     
                      n defines the size of one buffer in a
                      two-buffer ring (applicable to mag-tape
                      only)

     FILES:n
     This switch defines the number of files to be handled
     simultaneously during execution and helps the run-time
     system to allocate an appropriate buffer area before start
     of execution.  Since garbage collection will be invoked when
     the buffer area overflows, FILES can be used to avoid this.
     FILES is a global switch only.  Default for n is 0.
DECsystem-10 SIMULA Language Handbook, part II            Page 55
Chapter 8.3 OBJECT PROGRAM I/O, RUN-TIME SWITCHES


     IMAGESIZE:n
     A local switch applicable to directfiles only.  It defines
     the record size which will be n+2 to allow for carriage
     return and line feed.  If this switch is not given, the
     image size specified via the parameter to OPEN will be used
     to define n.

     HELP
     Prints the contents of the help file SIMRTS.HLP on the
     user's terminal.

     LIMIT:n
     LIMIT specifies the number of blocks that may be written on
     an outfile or printfile.  Default is no limit.  A run-time
     error occurs if this limit is exceeded.  LIMIT may only be
     used as a local switch.

     NUMBERED
     This switch can be applied only as a local switch in the
     specification of an outfile, printfile or directfile.  On a
     call to outimage, the last bit of the first word of the
     image is set to 1.  The actual line number must be supplied
     by the SIMULA program in the five first characters of the
     image.
     NOTE!!  The image must start on a word boundary!
     If the image is a main text or starts a main text, this is
     always the case.  According to DEC standard, the sixth
     character should be a tab (char(9)).  NUMBERED implies
     WORDALIGNED.  See below.

     SIZE:n
     This switch defines the initial number of blocks (n) to be
     allocated to an outfile or directfile.  Default for n is 5.
     At least n blocks will always be allocated but the file can
     however become larger than this size.  The switch will
     improve the efficiency when the file is large.  SIZE may
     only be used as a local switch.

     A numeric switch value must be given in the form of a
     decimal integer optionally followed immediately by the
     letter K or P, signifying multiplication with 1024 and 512
     respectively.

     WORDALIGNED
     This switch is local and applies to outfiles and printfiles.
     Directfiles are always word-aligned.  The WORDALIGNED switch
     forces each image in the buffer to start on a word boundary.
     If in addition the internal image is word-aligned, the image
     can be copied more efficiently to the buffer.  Main texts
     are always word-aligned.
DECsystem-10 SIMULA Language Handbook, part II            Page 56
Chapter 8.3 OBJECT PROGRAM I/O, RUN-TIME SWITCHES


     All switches except FILES and HELP may appear in the text
     argument to a file object.

     Example:

     INSPECT NEW outfile("RES.DAT/A:APPEND/LIMIT:100") DO ...







8.4  CLASS INFILE


     An infile is always read sequentially.  Each inimage will
     return the next record in the image defined for the file,
     which is the text variable specified in the OPEN call.  A
     record is terminated with either of line feed, altmode, form
     feed or vertical tab.  Carriage returns and nulls are
     ignored on input.  Form feed, altmode and vertical tab are
     transferred to the image, while the line feed is not moved.
     This means that if a file which contains, say, form feeds,
     is copied with a very simple SIMULA program, the new copy of
     the file will have an extra carriage return+line feed
     sequence appended after each form feed, since OUTIMAGE
     appends these two characters after each image.  (Unless the
     copying SIMULA program explicitly checks for form feeds in
     the copied text).

     If the external image is longer than the image size then a
     run-time error occurs.  If the external length is shorter
     than the image size, the rest of the image is padded with
     blanks.

     The procedure ENDFILE will return TRUE when the end of file
     has been passed.  The image will contain a special end of
     file record consisting of the two characters /* followed by
     spaces when INIMAGE is called and end of file is
     encountered.

     The following scheme may be used to process an infile:

             REF(INFILE)F;
             F:-NEW infile("...");
             F.OPEN(...);
             .
             .
             .
             F.INIMAGE;
DECsystem-10 SIMULA Language Handbook, part II            Page 57
Chapter 8.4 OBJECT PROGRAM I/O, CLASS INFILE


             WHILE NOT F.ENDFILE DO
             BEGIN
                     process one record;...;
                     F.INIMAGE
             END;
             .
             .
             F.CLOSE;

     If ENDFILE returns TRUE when INIMAGE is called a run-time
     error occurs.

     The following devices can be used for infile:
     TTY, disk, DECtape, magnetic tape, card reader and paper
     tape reader.







8.5  CLASS OUTFILE


     Outfiles are written sequentially.  The user may allocate as
     many blocks as appropriate with the SIZE switch.  If SIZE is
     omitted at least 5 blocks will be allocated.  If the initial
     allocation is used up, the operating system will
     automatically allocate as much as needed.

     The LIMIT switch may be used to stop unintentional endless
     loops with output.  The argument to LIMIT defines how many
     blocks will be written on a file.  A run-time error is
     invoked if this limit is exceeded.

     On OUTIMAGE, IMAGE.STRIP is output with carriage return and
     line feed appended.  A special procedure BREAKOUTIMAGE
     exists to allow output on TTY without carriage return and
     line feed.  This procedure can be used on any device.
     BREAKOUTIMAGE strips away only spaces after POS before
     outputting the line.

     Outfiles can also be written in append mode with the switch
     ACCESS:APPEND.  If the file already exists, the new output
     is appended to the existing file.  The minimum allocation of
     (usually) 5 blocks does not apply to files written in append
     mode.  All unused space will be released at CLOSE.

     Outfiles can be written on the following devices:
     TTY, disk, DECtape, magnetic tape, line printer, card and
DECsystem-10 SIMULA Language Handbook, part II            Page 58
Chapter 8.6 OBJECT PROGRAM I/O, CLASS PRINTFILE


     paper tape punch.







8.6  CLASS PRINTFILE


     This file class is a subclass of outfile.  The following
     differences exist compared to outfile:

     - SIZE does not apply to printfile, i.e.  the user can not
     allocate a specific amount of blocks, all unused space will
     be released when the file is closed.

     - a form feed is output when the file is opened on a device
     other than TTY.

     - a form feed is output after n lines, where n is the
     current value of the internal variable linesperpage (set by
     the user with the procedure LINESPERPAGE or defaulted to
     60).

     - the following special procedures exist for printfile to
     control the layout of the printed file:
     SPACING, LINESPERPAGE, EJECT.  These procedures are
     described in the SIMULA Language Handbook Part I.

     It is often inconvenient to get a form feed on TTY after n
     lines of output, especially in conversational applications.
     This can be circumvented with the following statement:
     SYSOUT.LINESPERPAGE(-1) which will set n to 2**18-1, which
     will be the same as no form feeds in most practical cases.

     Printfiles can be written on the same devices as outfiles.
DECsystem-10 SIMULA Language Handbook, part II            Page 59
Chapter 8.7 OBJECT PROGRAM I/O, CLASS DIRECTFILE


8.7  CLASS DIRECTFILE


     A SIMULA directfile is a file that can be accessed randomly
     by specifying the desired record's relative number in the
     file.  This is done with the LOCATE procedure.  The records
     are numbered sequentially from 1 upwards.

     The operating system permits the user to create directfiles
     randomly.  It is e.g.  possible to start from scratch and
     write, say, record 100.  The operating system will then
     write blocks 1 to 99 and fill them with nulls and then write
     block 100.  The file can then be expanded randomly, the
     operating system will allocate needed space and fill
     unwritten blocks with nulls.

     Definitions:

     Image size is the length of the text variable used at OPEN.

     Record size is the length of each external record in the
     file, this length is fixed for directfile.

     Actual record size is the number of characters preceding
     line feed, not counting carriage return, or number of
     characters preceding and including vertical tab, altmode or
     form feed.

     Physical record size is the number of words needed to store
     one record in the file;  all records start on a word
     boundary.

     A disk block consists of 128 words, 640 characters, which
     gives an image size of 638 characters not counting carriage
     return and line feed.  The record size for a directfile is
     fixed and is defined with the IMAGESIZE switch or, if the
     switch is not given, by the length of the text variable
     given on the first call of OPEN for the file.  For each
     following inimage or outimage call, the current image of the
     file  m u s t  have the size used at open.

     A directfile record, the external image, is thus n+2
     characters long, where n is the value of the IMAGESIZE
     switch argument.  The record size may be smaller, greater
     than or equal to the physical block size.  RTS will compute
     the relative block number from the record number and the
     physical record size.

     On output, CR-LF is appended after the end of the image in
     the buffer.  Both on input and output, the  w h o l e  image
     is always transferred to or from the buffer, regardless of
DECsystem-10 SIMULA Language Handbook, part II            Page 60
Chapter 8.7 OBJECT PROGRAM I/O, CLASS DIRECTFILE


     any special characters.  It is thus possible to embed
     control characters, e.g.  line feed, carriage return, form
     feed, in the image.

     The ENDFILE procedure returns TRUE when both of the
     following two conditions are true:

     a) LOCATION identifies a record outside the file range,
     i. e. LOCATION < 1 or LOCATION > limit, where limit is an
     internal variable containing the highest record number in
     the file.  This variable is computed from record size and
     file length at OPEN and is updated by OUTIMAGE when the file
     is expanded.

     b) INIMAGE has been called at least once, and the last call
     was made after the last call for OUTIMAGE, and the last call
     for INIMAGE was made with a location identifying a record
     outside the file range as defined above.

     ENDFILE also returns TRUE when the file is not open.

     If LOCATE identifies a not yet written record, a subsequent
     call on ENDFILE will return FALSE.  INIMAGE will return the
     end of file record (see section 8.4) when an unwritten
     record is read.

     Example:

        D:-NEW directfile(...);
        .
        .
        .
        D.LOCATE(I);
        D.INIMAGE;
        IF D.ENDFILE THEN action for end of file;
        IF D.IMAGE.STRIP="/*" THEN action for not written record;
        .
        .

     This will also work for empty files.

     Directfiles can only be stored on disk.


     If you intend to read a directfile sequentially from start
     to end, you can save about 30% of the CPU time by declaring
     it as an INFILE in your SIMULA program.
DECsystem-10 SIMULA Language Handbook, part II            Page 61
Chapter 8.8 OBJECT PROGRAM I/O, BASICIO


8.8  CLASS BASICIO


     This class contains actions to generate a standard infile
     called SYSIN and a standard printfile called SYSOUT.  These
     files are generated and opened at start of execution.  They
     will be automatically closed at end of execution, but the
     user may close and reopen them as he wishes.  SYSIN and
     SYSOUT will normally be assigned to TTY by RTS, but the user
     may prevent this through definitions in the specification
     file, e.g.:

     SYSIN INDAT.DAT
     SYSOUT RESULT.LST/ACCESS:APPEND

     The user can also use the ASSIGN command before the
     execution and assign SYSIN and SYSOUT to, say, DSK.  SYSIN
     will then be read from a file called SYSIN without extension
     and SYSOUT will be written on a file called SYSOUT also
     without extension.

     If TTY is used as device for SYSIN or SYSOUT, the image size
     will initially be set to the carriage width of that
     terminal.  In other cases the image size of SYSIN will be 80
     characters and the image size of SYSOUT will be 132
     characters.



8.9  DEVICE CONTROL CHARACTERS

     Most ASCII(ISO) device control characters are illegal in
     SIMULA source program TEXT and CHARACTER constants.  They
     can however be entered into TEXT and CHARACTER variables by
     using the built-in function CHAR.

     For outfiles and printfiles all 128 ASCII(ISO) characters
     are output just as they appear in the image of the outfile.
     However, outimage will skip trailing blanks and
     breakoutimage will skip trailing blanks after pos.

     For directfiles, all 128 ASCII(ISO) characters are input and
     output unchanged.  Trailing blanks are not skipped.

     On input for infiles, the following special handling of
     certain device control characters will occur:
DECsystem-10 SIMULA Language Handbook, part II            Page 62
Chapter 8.9 DEVICE CONTROL CHARACTERS


      Octal Decimal Name         Action

      000    0      Null         Ignored in input.
      011   10      Line Feed    The character is not input, but
                                 will finish a line, so that the
                                 next INIMAGE will continue with
                                 the character following the line
                                 feed.
      013   11      Vertical Tab The character will be input as
                                 the last character of a line,
                                 and the next INIMAGE will
                                 continue with the following
                                 character.
      014   12      Form Feed    Same as vertical tab.
      015   13      Carr. Return Ignored in input.
      032   26      Control-Z    Signifies end-of-file in input
                                 from a terminal.  Otherwise
                                 copied directly.
      033   27      Escape       Same as vertical tab.  
DECsystem-10 SIMULA Language Handbook, part II            Page 63
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


9.   DEBUGGING SIMULA PROGRAMS WITH SIMDDT
     =====================================


     SIMDDT is an interactive program that is used to debug
     SIMULA programs.  SIMDDT allows the user to:

     a) set up to 20 breakpoints (1)               [STOP] AT n...
        in the program
     b) continue from a breakpoint                 PROCEED
     c) display the current breakpoint settings    [STOP] BREAKS
     d) remove a breakpoint setting                REMOVE [AT n]
     e) change the contents of a variable          INPUT x:= ...
     f) display the contents of a variable         OUTPUT x, ...
     g) display all variables in the storage pool  VARIABLES 
     h) display the dynamic operating chain        CHAIN
     i) display all scheduled processes            SCHEDULED
     k) switch output to a disk file e.g.  a.bug   USE a.bug
     l) display the source code                    DISPLAY m[:n]
     m) move SIMDDT viewpoint :  to object x       INSPECT x
           to SIMDDT interrupt point               INSPECT/START
           to CLASS or PROCEDURE generation point  INSPECT/RETURN
           to viewpoint before last RETURN         INSPECT/RESET
           to statically enclosing block           INSPECT/UP
     n) close open files                           [STOP] CLOSE
     o) read SIMDDT control file e.g.  x.cmd       @x.cmd
     p) terminate execution                        EXIT


















-----------------

(1) At a breakpoint the normal program execution  is  interrupted
and  the  debugging  program  SIMDDT  gets  control.  SIMDDT will
perform the tasks that were specified  when  the  breakpoint  was
set.
DECsystem-10 SIMULA Language Handbook, part II            Page 64
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


9.1  LOADING AND STARTING SIMDDT


     The SIMDDT program is self-relocating and it is read from
     disk by a SIMRTS routine when requested.  The SIMULA
     compiler switches I (IDENTIFICATION, produces a line number
     table) and D (DEBUGS, produces a symbol table) must have
     been set during compilation if the program is to be debugged
     with SIMDDT.  The switches are set by default but if they
     were set off, SIMDDT will give incomplete information to the
     user.

9.1.1 DEBUG

     If the source file has extension SIM or the /SIMULA switch
     is used, the DEBUG monitor command will ensure that SIMDDT
     is read into low segment core and started before the SIMULA
     program execution starts.  Note that this will not work if
     the first file in the DEBUG command is placed on another
     directory path.  You will get DDT instead of SIMDDT.  In
     that case you can use LOAD followed by REENTER to get
     SIMDDT.
     Command example:

     .DEBUG MYPROG.SIM


9.1.2 LOAD, SAVE, GET, REENTER

     The monitor commands LOAD plus SAVE will save the user
     program not including SIMDDT on disk.  If issued directly
     after LOAD (+SAVE) or GET, the REENTER command will cause
     SIMDDT to be read into low segment core and started.  The
     START monitor command will start user program execution
     directly.
     Command example:

     .LOAD MYPROG.SIM
     .SAVE
     .REENTER


9.1.3 ^C - REENTER

     After the SIMULA program has started to execute without the
     debugging system it is usually possible to invoke SIMDDT.
     One or two ^C commands will stop execution and return the
     terminal to monitor mode.  The REENTER monitor command will
     load and start SIMDDT, which will give the number of the
     source program line which corresponds to the statement which
     was interrupted by ^C.  This is very useful when the program
DECsystem-10 SIMULA Language Handbook, part II            Page 65
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


     is looping.  ^C can also be used if SIMDDT is already
     loaded.  If the user program was expecting input from the
     user terminal when the ^C was given (i.e.  if one ^C is
     sufficient), then SIMDDT will not start until the input has
     been typed.
     Note that SIMDDT will be started when the execution has
     reached the user source program level, i.e.  an I/O
     operation must be completed.  In some cases it will not be
     possible to break the execution and the user will be advised
     to try again.
     Command example:

     .EXECUTE MYPROG.SIM
     ^C
     ^C
     .REENTER


9.1.4 Program errors

     After a run time error has been detected, the SIMDDT program
     will be called to write the error message and the source
     program line number which holds the statement that caused
     the error.  Appendix H contains an example on how to handle
     program errors in a batch run.


9.1.5 CONTINUE after program exit

     The CONTINUE monitor command can be used to start SIMDDT
     after a normal program exit.  The variables in the storage
     pool can be displayed with the VARIABLES command.


9.1.6 REENTER after program exit

     The REENTER command should be used to restart the program
     and SIMDDT after program exit.  Note that all breakpoint
     settings will be lost, since the data area is reinitialized.
     If SIMDDT was not loaded at execution start, the START
     command will restart the program without invoking SIMDDT.
DECsystem-10 SIMULA Language Handbook, part II            Page 66
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


9.2  SIMDDT INPUT AND OUTPUT


     The user TTY is normally used for input to SIMDDT.  An "*"
     on the terminal signals that SIMDDT is expecting a user
     command.  The @ command will cause SIMDDT to read its input
     from the indicated file.

     A maximum of 135 characters are allowed in the input command
     which is terminated by a break character (e.g.  carriage
     return, line feed).


     At entry to SIMDDT one of the following messages will be
     given:

     SIMDDT STARTED
     *
              SIMDDT and SIMRTS have been initialized but
              user program execution has not started.
              Breakpoints can be set before starting the
              program with the PROCEED command.


     AT <LINE> .....
              Breakpoint instruction executed, no STOP specified.


     STOP AT <LINE> .....
     *
              Breakpoint instruction executed and STOP specified.


     SIMDDT ENTERED , PROGRAM INTERRUPTED AT <LINE>
     *
              Program was probably interrupted via ^C and
              REENTERed or the CONTINUE command was issued after
              program exit.


     ?ERROR IN JOB <N> AT <LINE>
     ZYQnnn ......
     *
              The error ZYQnnn was found.  


     <LINE> is a reference to a line number in the source program
     or an octal address, see below.
DECsystem-10 SIMULA Language Handbook, part II            Page 67
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


     The user TTY is used for output from SIMDDT when it is in
     debug mode and no USE command has been given.

     Both the user TTY and the SYSOUT file are used for output
     from SIMDDT when it is in error mode and continuation after
     the error is not possible.  The output from the ALL command
     is only written to SYSOUT but all other output is written on
     both files.
     If an output file is specified with the USE command it
     replaces the SYSOUT file.

     The ^O monitor command can be used to suppress output from
     SIMDDT.
     The ^C and REENTER monitor commands can be used to end
     processing of the current command.
     The output will be resumed when a new command is expected
     and SIMDDT outputs the "*".

     The format of the output from SIMDDT is briefly described in
     the command descriptions below.  Appendix H contains
     examples of SIMDDT output.
     Every address that points into the generated code for
     statements is output in the line number format
     <MODULE>:<NNNNN>, see below 9.3.1.  The line chosen by
     SIMDDT is the last line on which a statement starts with an
     address less than or equal to the referenced address.  If no
     line number table was generated during compilation (-I
     switch set) or if the address references an external FORTRAN
     procedure the format of the line identification is
     <MODULE>:O <oooooo> , where o is an octal digit.  When the
     address can not be linked to any line number table the
     address is output in octal format O <oooooo> .  This is the
     case for all addresses pointing to the dynamic area, into an
     external Macro 10 procedure, into the simulation routines
     and into the high segment.
DECsystem-10 SIMULA Language Handbook, part II            Page 68
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


9.3  SIMDDT COMMANDS


     SIMDDT operates in two modes, debug and error mode.  SIMDDT
     is in error mode when entered after a program error,
     otherwise it is in debug mode.


9.3.1 Command syntax


     SIMDDT will translate all lower case letters to upper case.
     The reserved words in the commands can be truncated to any
     number of characters as long as they are unique.  The
     keywords INPUT and STOP have also been given short forms
     namely I and ST.  A command may not occupy more than one
     line.

     A line starting with the character ; will be treated as a
     comment and ignored.

     One or more blank and/or TAB characters must be used as
     separator between adjacent identifiers or keywords.

     Meta symbols used in the syntax description below are:

     !     (logical or sign) separates alternative options
     []    (square brackets) enclose a group of options of which
           one or none may be selected
     ...   denotes an arbitrary repetition of the group enclosed
           by the preceding braces or square brackets.

     See also the ALGOL report [2] for an explanation of the meta
     language.


     The user identifies a breakpoint with a source program line
     number.  In the command descriptions below the notation
     <LINE> is used.  <LINE> has the form [<MODULE>:] <NNNNN>.

     <MODULE> is MAIN or the SIMULA name of a separately compiled
     procedure or class.  MAIN indicates the main program.  If
     <MODULE>:  is omitted, the current module is used by SIMDDT,
     that is MAIN at program start and later the module in which
     the current breakpoint is placed.

     <NNNNN> is a line number in the source program.  The line
     should contain the beginning of an executable statement.  If
     not found the first higher numbered line on which a
     statement starts will be chosen.
DECsystem-10 SIMULA Language Handbook, part II            Page 69
CHAPTER 9 DEBUGGING SIMULA PROGRAMS WITH SIMDDT


     In the commands the user references a source variable with
     the notation <IDENTIFICATION> or <IDENTIFICATION2>.

     <IDENTIFICATION> ::= <IDENTIFICATION1> 
                          [QUA <CLASS IDENTIFIER>] !
                          <IDENTIFICATION>.<IDENTIFICATION1>

     <IDENTIFICATION1> ::= <IDENTIFIER> !  
                           THIS <CLASS IDENTIFIER>!
                           <ARRAY IDENTIFIER>(<SUBSCRIPT LIST>)

     <SUBSCRIPT LIST> ::= [-] <INTEGER> !
                          [-] <INTEGER>,<SUBSCRIPT LIST>

     <IDENTIFICATION2> ::= <IDENTIFICATION> !
                          [<IDENTIFICATION>.]<ARRAY IDENTIFIER> !
                          [<IDENTIFICATION>.]*

     The <IDENTIFIER> must be a simple variable of type INTEGER,
     REAL, LONG REAL, BOOLEAN or CHARACTER or a simple object
     reference or TEXT type variable.  When the <IDENTIFIER> is a
     formal parameter called by name it is not handled by SIMDDT.
     A formal parameter with transmission mode by value or by
     reference will be treated like a declared variable.  The
     standard procedures SYSIN, SYSOUT, FIRST, LAST, SUC, PRED,
     PREV, EVTIME, MAIN, TIME and CURRENT are accepted by SIMDDT.
     A type procedure identifier is handled by SIMDDT if the
     current block is the procedure block.  The identifier can
     however not be used in connection with the IFCHANGED and the
     IF features in a breakpoint command or on the right hand
     side in an INPUT command.

     The brackets ( ) around the <SUBSCRIPT LIST> can be replaced
     by a pair of square brackets, e.g.  A[1,2].

     In the commands below the notation <STRING> is used.
     <STRING> is a string of characters enclosed in " .  The
     first 5 characters in the string are part of the message
     that SIMDDT outputs at the breakpoint.
DECsystem-10 SIMULA Language Handbook, part II            Page 70
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


9.3.2 Commands


     [STOP] AT <LINE> [,<N>] [<STRING>]

     SIMDDT ACTION:  Identifies a breakpoint and outputs a
     message every n:th time the referenced statement is
     executed.  If STOP is given execution is halted and new
     SIMDDT commands are accepted.  <N>, the loop counter, is an
     integer number.


     [STOP] AT <LINE> [<STRING>] [IFCHANGED] <IDENTIFICATION2> [,
     <IDENTIFICATION2> ]...

     SIMDDT ACTION:  Identifies a breakpoint.  If IFCHANGED is
     specified SIMDDT will output only changed variable values,
     otherwise the values are always given.  If IFCHANGED is
     specified the first time the breakpoint is reached, the
     value is compared to 0, FALSE, NOTEXT, NONE or CHAR(0),
     depending on its type.  * the complete block indicator and
     <ARRAY IDENTIFIER> are not allowed when IFCHANGED used.

     [STOP] AT <LINE> [<STRING>] IF <IDENTIFICATION> 
     <RELATION OPERATOR> <VALUE>

     SIMDDT ACTION:  Identifies a breakpoint.  SIMDDT will output
     the variable value if the relation is TRUE.
     The <RELATION OPERATOR> can be one of > >= < <= = \= == =/=
     GT GE LT LE EQ NE EQV IS IN.  The <VALUE> can be an
     <IDENTIFICATION>, TRUE, FALSE, NOTEXT, NONE, arithmetic
     constant, character constant, text value constant or CLASS
     identifier.
     The character " can never be part of an input text value
     constant.  Some special control characters can not be part
     of a character or text value constant, see 9.2.
     The arithmetic constant must be in the form of an <INTEGER
     ITEM> when the variable is integer and in the form of a
     <REAL ITEM> when it is a real or long real variable.  The
     de-editing procedures GETINT and GETREAL in the RTS system
     are used to get the value.


     REMOVE [ AT <LINE> ]

     SIMDDT ACTION:  Remove all breakpoint commands for a
     specific line or remove all breakpoints.


     [STOP] BREAKS
DECsystem-10 SIMULA Language Handbook, part II            Page 71
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


     SIMDDT ACTION:  List all breakpoint commands.  The input
     order is not kept.  If STOP is specified, SIMDDT will halt
     after each breakpoint command and allow the user to remove
     it.  When all breakpoint commands for a line are removed the
     breakpoint is removed.  The BREAKS command can be used to
     check if it was possible to set a breakpoint at the line
     given in the user command since SIMDDT will change the line
     number if necessary.

     USER ACTION:  Type REMOVE to remove the last command listed
     or type an empty line (RETURN key) to keep the command.


     OUTPUT <IDENTIFICATION2> [/-TEXT][/-ARRAY]
     [,<IDENTIFICATION2>]...

     SIMDDT ACTION:  Output the values of the variables.  See
     VARIABLES for explanation of the switches.

     For an <ARRAY IDENTIFIER> the following will be output:
     The name and the array bounds
     <SUBSCRIPT LIST> = value of element ( if not initial value)

     If [<IDENTIFICATION>.]* is used then all the variables in
     the referenced block are output.
     The editing procedure PUTINT is used to output an integer
     variable and the PUTREAL procedure is used for real and long
     real variables.  A real variable will be given with 8 and a
     long real variable with 16 significant digits.

     For a text variable the following will be output:
     Octal address of the dynamic area allocated to the text
     variable
     SUBTEXT STARTS AT POSITION= <N>     (only if subtext)
     LENGTH= <N>
     POS= <N>
     " plus all characters in the stripped text
     "       (only if the last character in text is not a blank)
     A character with RANK(character) < 32 will be replaced by ^
     followed by a capital letter (octal 100 is added to the
     internal representation of the character).

     For a REF variable the following will be given:
     QUALIFICATION ERROR     (if error)
     Name of class referenced by variable
     Octal address of dynamic area referenced by variable
     TERMINATED or DETACHED <LINE> or <LINE> (if active class)
     where <LINE> is the reactivation point of the invoking
     block.

     For a character variable the character enclosed in quotes
DECsystem-10 SIMULA Language Handbook, part II            Page 72
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


     will be output if RANK(character) is >= 32, otherwise the
     output will be CHAR <N>, where <N> is RANK(character),
     RANK(' ')=32.






     INPUT <IDENTIFICATION> <ASSIGNMENT OPERATOR> <VALUE>

     SIMDDT ACTION:  Changes the value of the referenced variable
     to the value given in the command.  The operators are := and
     :-.  See above for explanation of <VALUE>.


     DISPLAY [<MODULE>:][<RANGE>]

             <RANGE> ::= <NNNNN> !  [<NNNNN>]:<NNNNN> !
     [<NNNNN>],<NN>

     SIMDDT ACTION:  Output the indicated source program lines.
     If no range is given, 10 lines are displayed starting with
     the next line to be displayed.  The next line can be denoted
     by a dot (.).  The value of "." is 0 when no lines have been
     displayed.  The next existing line number is substituted for
     a non-existent line.  The first line can also be denoted by
     an up-arrow (^).  A colon (:) is used to separate the
     end-points of the range.  A dash (-) can also be used.
     Alternatively, the number of lines to be displayed can be
     given following a comma (,).  <NN> is the number of lines.
     The upper end of the range can be given by an asterisk (*),
     which is interpreted as +infinity.  If the first line of the
     range is not given, "." is assumed.  If the source program
     file is not found the user must enter the correct file
     specification via the I/O dialogue.  The display file is
     closed at exit from SIMDDT.  If <MODULE>:  is not given in
     the command and it is the first DISPLAY command since SIMDDT
     was entered, the current module is assumed otherwise the
     already opened source program file is read again.


     INSPECT <IDENTIFICATION> !  /START !  /RETURN !  /RESET !
     /UP

     SIMDDT ACTION:  The point in the program, from which SIMDDT
     sees the variables, is moved.  This makes it possible to
     input and output variables, which are not visible from the
     block in which the program execution was interrupted.
DECsystem-10 SIMULA Language Handbook, part II            Page 73
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


     INSPECT <IDENTIFICATION>
     SIMDDT will now see inside the CLASS object, to which the
     variable refers.  It must be an object reference (not NONE).

     INSPECT /START
     SIMDDT will again see from the place, where program
     execution was originally interrupted and SIMDDT entered.  If
     SIMDDT was entered via an error or via ^C-REENTER, the
     initial SIMDDT message is repeated, giving the reason for
     entering SIMDDT.  Useful with display terminals.

     INSPECT /RETURN
     SIMDDT should be looking inside a procedure or an active
     CLASS.  /RETURN will make SIMDDT see from the point where
     the procedure was called or where the class was generated or
     called.

     INSPECT /RESET
     Go back to where SIMDDT was looking before the last INSPECT
     /RETURN command.  /RESET is equal to /START if no INSPECT
     /RETURN command has been given since SIMDDT was entered.

     INSPECT /UP
     Look directly at the statically enclosing block.  Not valid
     when SIMDDT is looking at a terminated class instance.




     PROCEED

     SIMDDT ACTION:  SIMDDT will either start program execution
     or continue processing at the point where it was
     interrupted.  PROCEED is not valid after an error from which
     it is not possible to continue or after a NOPROCEED command.


     USE <FILE SPECIFICATION>

     SIMDDT ACTION:  SIMDDT output will be written on the file
     specified in the command.  All output that signals a user
     action is also output on TTY e.g.  the message "STOP AT
     MAIN:17 " will be output both at the TTY and the file at the
     breakpoint stop.  The file is not closed until a new USE
     command is given or at the end of execution.  The format of
     the <FILE SPECIFICATION> is the same as the one used for the
     other user files, see chapter 8.2.  USE TTY:  will reset
     SIMDDT output to the terminal.


     CHAIN
DECsystem-10 SIMULA Language Handbook, part II            Page 74
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


     SIMDDT ACTION:  Writes the dynamic operating chain starting
     with the current block.  Only procedures, class instances
     and inspected class instances are given.  The name of the
     block and its activation line are listed.  Note that no
     operating chain is given when the interruption address was
     not located in any line number table.


     VARIABLES [/-ARRAY][/-TEXT][/-GC][/START:[-]<oooooo>

     SIMDDT ACTION:  The complete storage pool is scanned and all
     variables that are of a type treated by SIMDDT are listed
     together with the name of the dynamic block in which the
     variables are declared.  Unless /-GC was specified or
     garbage collection is not safe, the garbage collector
     routine (G.C.) will be called before the storage pool is
     scanned.  When /-ARRAY is specified all array elements are
     skipped in the output.  When /-TEXT is specified all text
     characters are skipped in the output.  The /START switch can
     be used to output only the top of the pool.  Only blocks at
     addresses greater than the (octal) value of the /START
     switch will be output.  A negative value is added to the top
     of pool address to give a starting address.  G.C.  scans the
     pool and removes all dynamic blocks that are unreferenced
     and inactive.  To reduce output only variables which do not
     have their initial values are given.  The amount of data is
     often very large, and the USE command can be used to direct
     the output to a disk or LPT file.
     For each dynamic block instance the following will be
     output:
     The name of the dynamic block, that is the procedure or
     class name, MAIN if main program, PREFIXED BLOCK plus name
     of prefix class or BLOCK if unreduced block
     Octal address of the dynamic area
     TERMINATED or DETACHED <LINE> or <LINE> (if active)

     The value of a type procedure will also be output.

     The format of the variables is found in the description of
     the OUTPUT command above.  For each array identifier the
     name and the array bounds are always given even if all
     elements have their initial values.


     SCHEDULED

     SIMDDT ACTION:  For each scheduled process the following
     will be output:
     EVTIME= scheduled time
     Class name
     Octal address of dynamic area DETACHED <LINE>
DECsystem-10 SIMULA Language Handbook, part II            Page 75
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


     ALL [/-ARRAY] [/-TEXT] [/-GC] [/START:[-]<oooooo>]

     SIMDDT ACTION:  Produces the same information as if the
     commands CHAIN, VARIABLES and SCHEDULED had been given.  The
     switches apply to the implied VARIABLES command, q.v.


     [STOP] CLOSE

     SIMDDT ACTION:  Lists and closes all open files except SYSIN
     and SYSOUT.  If STOP is specified SIMDDT will halt and allow
     the user to close the file.  Answer CLOSE or carriage
     return.


     NOPROCEED

     SIMDDT ACTION:  Inhibits the use of the PROCEED command.
     After this command it will be possible to use a critical
     command such as USE or DISPLAY.  Not necessary when stopping
     at preset breakpoints.  


     @ <FILE SPECIFICATION>

     SIMDDT ACTION:  SIMDDT input will be read from the file
     specified in the command.  The command will be output on the
     TTY before it is processed.  When end of file found SIMDDT
     will request input from the TTY.


     EXIT

     SIMDDT ACTION:  Returns control to SIMRTS which closes the
     SYSIN and SYSOUT files and then returns to the monitor.  


     HELP

     SIMDDT ACTION:  Lists part of the SIMDDT.HLP file.


DECsystem-10 SIMULA Language Handbook, part II            Page 76
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


9.3.3 Command examples


     STOP AT 55,3

     EXPLANATION:  Set a breakpoint at first statement on line 55
     and stop processing every third time the statement is
     executed so that the user can communicate with SIMDDT.

     AT MAIN:30 "LIST" VINT[1,3], VREF.VBOOL

     EXPLANATION:  Output the values of the variables VINT[1,3]
     and VREF.VBOOL each time the first statement on line 30 in
     the main program is to be executed.  The message will
     contain the letters "LIST".

     AT 10 IFCHANGED VREAL,VTEXT

     EXPLANATION:  Output the variable value if any of the
     variables were changed since the last time the statement at
     line 10 was to be executed.

     STOP AT 80 IF VREAL>=1.5

     EXPLANATION:  Stop execution at the statement on line 80 if
     the variable VREAL>=1.5

     STOP AT 80 IF BOOL EQV TRUE

     EXPLANATION:  SIMDDT does not understand "STOP AT 80 IF
     BOOL" but the above statement works and gives the desired
     effect.  In the same way, write "BOOL EQV FALSE" to give the
     effect of "NOT BOOL".

     OUTPUT VREF.VINTARRAY,VREALA[-1,7,7],VCHAR

     EXPLANATION:  Output all elements of the array
     VREF.VINTARRAY which are not zero, output the array element
     VREALA[-1,7,7] and the variable VCHAR.

     INPUT VTEXT:="TEXT VALUE ASSIGNMENT"

     EXPLANATION:  Change the value of the text variable.  Note
     that only the characters may be changed, but not the length.

     USE DEBFIL.LPT

     EXPLANATION:  SIMDDT output will be written on file
     DEBFIL.LPT.  Output in connection with a breakpoint stop
     will also appear on the user TTY.
DECsystem-10 SIMULA Language Handbook, part II            Page 77
CHAPTER 9 DEBUGGING SIMULA PROGRAMS , SIMDDT COMMANDS


     DISPLAY 1:10

     EXPLANATION:  Output the source program lines 1 to 10.

     DISPLAY ,5

     EXPLANATION:  Output the next 5 lines of the program.

     DISPLAY

     EXPLANATION:  Output the next 10 lines (== DISPLAY .,10).


     Appendix H.9 contains additional SIMDDT examples.
DECsystem-10 SIMULA Language Handbook, part II            Page 78
Chapter 10 PROGRAMMING CONSIDERATIONS


10.  PROGRAMMING CONSIDERATIONS
     ==========================

10.1 WRITING EFFICIENT PROGRAMS


     This section contains some hints on how to write efficient
     programs in SIMULA.  Unless very high efficiency is
     required, however, good structuring and readability should
     always have the highest priority.  If the program is to be
     run at other installations, portability considerations are
     also important.  See 10.2.

     A programmer who writes less well structured programs to
     gain efficiency will often find that he did not gain the
     efficiency he intended.  The initial version may be
     efficient, but due to the bad structure, later changes and
     additions will be harder to make, and as a result the end
     product may be less efficient and probably less reliable
     than if the program had been well structured at the outset.

     If you desire efficiency, your efforts towards this goal
     should be guided by knowledge about which parts of your
     programs are expensive.  Use of performance measurements
     programs such as that described in appendix J may be a good
     aid towards gaining this knowledge.  When you know which
     parts of your programs consume the most cpu time, core or
     other expensive resources, you will know where to apply
     rewriting or MACRO 10 procedures to minimize use of these
     resources.

     The following hints are not ordered by importance:

      -> Do not ignore warning messages issued by the compiler.
     Often, these messages point to possibly inefficient or
     dangerous coding sequences or features.

      -> Avoid unnecessary type conversions by declaring
     variables with appropriate types, and by avoiding mixed type
     expressions.  Note that the precision of certain arithmetic
     functions is governed by the precision of the argument,
     i.e. LONG REAL arguments cause the LONG REAL version to be
     called.  This may be inefficient in some cases where the
     greater precision is not necessary.

      -> In connection with the above, note also that the
     de-editing procedures GETREAL and INREAL always give LONG
     REAL results.  Copy the result to a REAL variable before
     using it in a REAL expression, if you want to avoid
     unnecessary conversions.
DECsystem-10 SIMULA Language Handbook, part II            Page 79
Chapter 10 PROGRAMMING CONSIDERATIONS


      -> In FOR statements, the STEP and UNTIL elements should be
     constants or simple variables.  Usually you do not want
     re-evaluation of these at every loop iteration.  Avoid
     function designators, formal parameters by name, subscripted
     variables, variables of different type from the controlled
     variable, and general expressions.  The fastest loop is one
     with step +1 or -1 and a limit which is a simple constant or
     variable.  Use the WHILE statement where the full generality
     of the FOR statement is not needed.

      -> In most cases, it is best to avoid transmitting
     parameters by name if value or reference mode can be used.
     One case where name parameters may be necessary is when the
     values of some parameters are to be modified by a procedure.
     In this case, it often pays to copy the value on entry and
     copy the modified value back on return.  Access to simple
     variables corresponding to formal parameters by name is
     optimized, but it is still slower than accessing a local or
     global variable.  In this respect, value and reference mode
     parameters count as local variables in the procedure.  What
     is said above does not always apply for text parameters when
     you have to choose between name and value mode.  One reason
     for this is that value transmission of text parameters
     destroys the stack nature of the top of the data area, which
     makes memory allocation slower.  Another reason is that
     copying of long texts should be avoided.  See below about
     "memory allocation for procedures".

      -> Avoid long linear searches through large sets.  If
     possible, use hash coding or binary tree representations to
     reduce the search times.  Note that CARDINAL performs a
     linear search through the whole set on each call!

      -> If many attributes of a class are to be accessed, use
     inspection in order to save some code space and execution
     time.  As a guideline, use INSPECT when you have more than 4
     accesses to attributes of the same class.  However, program
     readability may often motivate deviations from this
     guideline.

      -> Do not repeat the same information in many blocks.
     Suppose for example that you have a large number of
     instances of the same class, and some data is repeated in
     many or all of these instances.

     Instead of copying this information in all the block
     instances, you may put the information in a separate class
     object, with a reference from the partly similar objects to
     the single common object.

     Example:  Suppose that you have 1000 records of people with
DECsystem-10 SIMULA Language Handbook, part II            Page 80
Chapter 10 PROGRAMMING CONSIDERATIONS


     only four different work addresses.  Instead of including
     the work address in each of the 1000 class instances, you
     can have just four instances of a class "address", with
     references from each of the 1000 records to one of the four
     "address" instances.

      -> Avoid creating unnecessary blocks.  If a new temporary
     variable is required, declare it in an existing block rather
     than converting a compound statement into a block.

      -> Use EJECT and SPACING instead of outputting blank images
     on printfiles.  This is faster.

      -> Garbage collection time and the amount of core used is
     reduced if care is taken to avoid maintaining references to
     space-consuming data structures which are no longer needed.

     Examples:

     REF(HEAD) QUEUE;  ....building a large queue...  QUEUE:-
     NONE;  Comment when the set is no longer needed, this may
     save a lot of core and garbage collection time;

     TEXT MANUSCRIPT;  ...building a long text string...
     MANUSCRIPT:- NOTEXT;  Comment saves space when the
     manuscript is no longer needed;

     BEGIN REAL ARRAY MATRIX[100,100];
     ...use of the MATRIX ...
     END;  Comment saves space when the MATRIX is no longer
     needed;

      -> Memory allocation for procedures without VALUE-declared
     TEXT parameters is especially efficient.  However, this
     efficiency is lost if the procedure or any procedure called
     by it directly or indirectly creates new text objects (via
     COPY, BLANKS, INTEXT) or class instances (NEW) or CALLs a
     detached CLASS instance.

      -> Do not use INTEXT unnecessarily.  It creates a new text
     object (see above) and can usually be replaced by a suitable
     subtext of Image, but be careful not to use Inimage directly
     or indirectly before you have handled that subtext
     completely.  You may e.g. use text assignment:
     T:=Sysin.Image.Sub(Sysin.Pos,10) might replace T:-
     Intext(10) if T is preallocated e.g. via Blanks(10).  T can
     be reused.
DECsystem-10 SIMULA Language Handbook, part II            Page 81
Chapter 10 PROGRAMMING CONSIDERATIONS


      -> Use built-in system procedures and classes where these
     suit your needs.  They are often considerably faster than a
     corresponding SIMULA procedure or even corresponding in-line
     code.

     Example I:  "WHILE mytext.more DO" is faster than "n:=
     mytext.length;  FOR i:= 1 STEP 1 UNTIL n DO".

     Example II:  The built-in procedures LETTER and DIGIT
     provide a faster way of checking if a character is a letter
     or digit than using RANK and checking the integer values
     yourself.  Your program will also become less
     machine-dependent if you use LETTER and DIGIT.

      -> If you use DIRECTFILE, try to organize your programs to
     minimize the number of reads and writes.  This can be done
     by using hash-coding, keeping central tables in core, etc.

      -> If you have to choose from a number of alternatives,
     depending on the value of a variable, then a series of IF
     ...  THEN ...  ELSE statements is more efficient than a
     SWITCH, when the number of alternatives is less than 50.
     When the number of alternatives is larger than 50, a nested
     IF ...  THEN BEGIN IF ...  THEN ...  ELSE ...  END ELSE
     structure is still more efficient, though less neat, than
     use of a SWITCH.

      -> If a program has been carefully tested both by the
     programmer and in production work, you may, if you dare,
     consider to set off some of the built-in debugging aids, to
     save core and cpu time.  The following switches can be used
     (should be given in the COMPILE (EXECUTE etc.) command):

     -A  removes array bounds checking for arrays.  May save cpu
     time.
     -Q  removes qualification checking of reference assignments.
     May save cpu time.
     -I  removes the generation of line number tables for SIMDDT.
     Saves core.
     -D  removes the generation of symbol tables for SIMDDT.
     Saves core.


10.2 WRITING PORTABLE PROGRAMS


     Even if you do not now plan to move a program to another
     SIMULA system, such a need may arise in the future.  If
     portability is desirable, deviations from the Common Base
     language [1] should be kept at a minimum, or at least be
     very clearly commented and set aside from the rest of the
DECsystem-10 SIMULA Language Handbook, part II            Page 82
Chapter 10 PROGRAMMING CONSIDERATIONS


     code.  If external assembly or FORTRAN procedures are used,
     a SIMULA version should if possible be available for each of
     these in case of a move to a different installation.

     The following constructs of DECsystem-10 SIMULA should be
     avoided if you want portable programs:


      -> Any input procedure which is dependent on the line
     length of the input file.  Especially avoid input procedures
     requiring input lines longer than 72 or 80 characters.

      -> Changing the length of the image of a file after opening
     the file, especially letting the image be == NOTEXT.

      -> Use of multi-line text constants.

      -> Any output procedure which writes disk files with lines
     longer than 72 or 80 characters (132 characters for
     printfiles).

      -> Any use of the following Swedish characters in source
     program identifiers:  $, #, @, }, {, `.  These characters
     may however occur in TEXT and CHARACTER constants.

      -> Use of non-decimal constants.

      -> Use of lower case letters.

      -> Use of the characters whose decimal value is less than
     32 and the characters:
         !, [, ], ^, ~, | .
     Use alternative representations as follows:  NE for \=, NOT
     for \, COMMENT for !, () for [], ** for ^.

     -> Use of TEXT constants in IF-clauses, e.g.
     "Outtext(IF bool THEN "yes" ELSE "no");"

      -> With DIRECTFILE, use of the procedure ENDFILE, reading
     of unwritten lines, writing past the end of the file.


     Most of the external library procedures in chapters 4 and 7
     of the DECsystem-10 Simula Language Handbook part III will
     give portability problems.

     Some of the incompatibilities mentioned above will be
     removed automatically from your source programs if you
     convert them to IBM SIMULA using the SIMIBM program
     described in appendix M of this handbook.
DECsystem-10 SIMULA Language Handbook, part II            Page 83
Chapter 10 PROGRAMMING CONSIDERATIONS


10.3 WRITING VERY LARGE PROGRAMS


     When you begin writing a program which may in the end be
     larger than 1000 or 2000 lines, you can save much trouble by
     planning the program carefully before starting to program.

     To save compilation time when the program grows large, it is
     advisable to divide the program into separately compiled
     modules.  This division must be planned BEFORE starting to
     write the program.  When a program already has grown large,
     it is often difficult or impossible to find a workable such
     structuring.

     The best way to divide a program into separately compiled
     modules is usually to divide it into a not too large number
     of rather large (about 500 lines) separately compiled
     classes.

     Take advantage of the SIMULA feature that one class may
     extend the concepts defined in a prefixing class, and that
     the main program may combine the facilities of several such
     separately compiled classes or class chains.

     Example:  Your program may be divided into the following
     modules:
     1) Analyzing user input commands
     2) Interpreting formulas input by the user
     3) Handling help requests from the user
     4) Processing of the data base

     If none of these four modules use data or procedures from
     another module, you can write the four modules as four
     independent separately compiled classes, all accessible only
     from the main program:

     Command    Formula           Help request    Data base
     analysis   interpretation    handling        handling
          !            !            !               !
          --------------Main program-----------------

DECsystem-10 SIMULA Language Handbook, part II            Page 84
Chapter 10 PROGRAMMING CONSIDERATIONS


     If, however, the module "Formula interpretation uses
     facilities defined in the module "Command analysis", the
     following structure may be appropriate:

     Command
     analysis
        !
     Formula            Help request     Data base
     interpretation     handling         handling
        !                  !                !
        -------------Main program------------

     This has the disadvantage that changes in the data
     definitions in "command analysis" may force recompilation of
     "Formula interpretation", but the advantage that "Formula
     interpretation" has access to the data structures and
     operations defined in "Command analysis".

     Suppose now that "Data base handling" can be divided into
     two modules, "Reading records" and "Handling records".  Both
     these modules require access to the data structure
     definitions used to represent "records" in core.

     One solution is then to make one of these two a subclass to
     the other:

                                         Defining
                                         records
                                            !
     Command                             Reading
     analysis                            records
        !                                   !
     Formula            Help request     Handling
     interpretation     handling         records
        !                  !                !
        -------------Main program------------

DECsystem-10 SIMULA Language Handbook, part II            Page 85
Chapter 10 PROGRAMMING CONSIDERATIONS


     Another solution is to make "reading records" and "handling
     records" two parallel subclasses to "Defining records":

     Command                              Defining
     analysis                             records
        !                                 !     !
     Formula          Help request   Reading   Handling
     interpretation   handling       records   records
        !                   !          !         !
        --------------------Main program----------

     The latter solution has the advantage that no changes in
     "reading records" can cause recompilation of "handling
     records", but the disadvantage that "defining records"
     becomes more limited.  It works best if "defining records"
     is a class with no internal class definitions in it.

     In some cases, the only solution for you is to structure
     your program as a long chain of separately compiled classes,
     each a subclass to the previous one.  This is the only
     solution for code which has to be inside "SIMSET" or
     "SIMULATION".  The disadvantage with this solution is that a
     change in the data definitions in the outermost class may
     force recompilation of the whole chain.


10.4 MISCELLANEOUS ADVICE


      -> Use BREAKOUTIMAGE when communicating with a
     conversational display terminal.  This permits the prompting
     question and the answer to be written on the same line.
     Example:  outtext("Enter t:");  breakoutimage;  lastitem;
     t:-copy(sysin.image.sub(sysin.pos,...));  sysin.setpos(0).

      -> If the output from a program is directed to a
     conversational terminal (e.g. the user's tty), it may be
     inconvenient, especially with display terminals, to get the
     automatic new page after every 60 lines.  This can be
     circumvented by using an outfile instead of a printfile, or
     by coding LINESPERPAGE(-1) in your program.
     LINESPERPAGE(-1) effectively sets the page size to infinity.

DECsystem-10 SIMULA Language Handbook, part II            Page 86
APPENDIX A   HARDWARE REPRESENTATION


APPENDIX A   HARDWARE REPRESENTATION
====================================


A.1  SIMULA COMPILER INPUT.

     A DECsystem-10 SIMULA program is a sequence of symbols from
     the DECsystem-10 character set (ASCII 7 bit code) placed on
     a disk file (i.e.  an ordered set of data on a disk like
     device).  The data on the file is separated into lines.  A
     line is delimited by a vertical tab (VT), line feed (LF) or
     form feed (FF) character.  The maximum length of a line is
     135 characters.

     A SIMULA program consists of a sequence of basic symbols,
     identifiers, constants, comments and line editing
     characters.  The rules for these are given below.



A.2  SIMULA PROGRAMS ON CARDS.

     Existing SIMULA programs with card characteristics, 80
     characters per card with columns 73-80 for identification or
     sequence numbers can easily be processed by using either (i)
     the batch switch WIDTH or (ii) the PIP command switch E or
     (iii) the IBMSIM or CDCSIM program described in appendix M
     to remove columns 73-80.  The IBMSIM and CDCSIM program will
     also convert the character representation from IBM SIMULA or
     CDC SIMULA to DECsystem 10 SIMULA.



A.3  STANDARD LINE SEQUENCE NUMBERS.

     The rules for standard sequence numbers are specified in the
     LINED reference manual paragraph 7.0.  Those characters that
     belong to the sequence number (i.e.  padding NULL
     characters, the number itself and a trailing tab character)
     are not considered part of the input SIMULA program.
     However they will appear in the program listing and they are
     put in the line number table so that SIMDDT can use them.
     If no line numbers appear in the source code the SIMULA
     compiler will supply its own line numbers.  The handling of
     programs with partly numerical, partly blank line numbers is
     described in appendix K.
DECsystem-10 SIMULA Language Handbook, part II            Page 87
APPENDIX A   HARDWARE REPRESENTATION


Reference  DEC 10 SIMULA  Alternative    ASCII 7 bit   Comments
language   representation representation octal code
-----------------------------------------------------------------
   +           +                         053
   -           -                         055
   x           *                         052
   /           /                         057
"int. div."    //                        057 057
   ^           ^              **         136
   >           >              GT         076
"> or ="       >=             GE         076 075
   <           <              LT         074
"< or ="       <=             LE         074 075
   =           =              EQ         075
"not ="        NE             \=         (134 075)
   ==          ==                        075 075
   =/=         =/=                       075 057 075
   .           .                         056
   ,           ,                         054
   :           :                         072
   ;           ;                         073
"lowered ten"  &              &&         046     Lowered ten
   symbol
                                                 & in real
                                                 constants
                                                 && in long real
   (           (                         050
   )           )                         051
   [           [              (          133
   ]           ]              )          135
   :=          :=                        072 075
   :-          :-                        072 055
   '           '                         047     Character quote
   "           "                         042     Text quote
"not"          NOT            \          (134)
"space"        <space>                   040
"log. OR "     OR
"log. AND"     AND
"log. IMP"     IMP
"log. EQV"     EQV
COMMENT        COMMENT        !          041     ! is comment
                                                 symbol in
                                                 DEC 10 ALGOL
                                                 and FORTRAN but
                                                 not in standard
                                                 SIMULA
-----------------------------------------------------------------

   Table A.1   Special character representation in DEC 10 SIMULA.
               Non-printable reference language symbols
               are enclosed in double quotes.
DECsystem-10 SIMULA Language Handbook, part II            Page 88
APPENDIX A   HARDWARE REPRESENTATION


A.4  BASIC SYMBOLS.

     A basic symbol is represented as a keyword, a special
     character or a sequence of special characters.  The keywords
     are the standard SIMULA words plus GO, LONG, OPTIONS, SHORT,
     TO and the words listed in the table A.1 above (See Appendix
     G.).  A lower case letter can always be used instead of the
     corresponding upper case letter.



A.5  IDENTIFIERS.

     The first character in an identifier must be a letter.  The
     following characters must be letters, digits or underline
     characters.  A lower case letter can always be used instead
     of the corresponding upper case letter.  The first 12
     characters in an identifier are significant.  An identifier
     must not be a keyword (See Appendix G).  The character
     <underline> or <left arrow> (octal code 137) is accepted in
     identifiers but not as the first caracter.  Embedded blanks
     are not accepted.



A.6  CONSTANTS.

A.6.1  Arithmetic constants.

     Integer constants consist of a number of decimal digits.  If
     an integer constant is out of integer range it is regarded
     as a real constant.  The integer range is 1 - 2^35 to 2^35 -
     1.
     ( 2^35 = 34 359 738 368 ).
     An integer constant can be written in a different radix as
     follows:
     nRd
     where n is 2, 4, 8 or 16 and d represents a string of digits
     acceptable in the corresponding radix.  E.g.  octal number
     7711 is written 8R7711 and binary 10 is written 2R10.

     Real constants consist of a decimal number (containing
     either an integral part or a fractional part or both)
     followed by an optional exponent.  The fractional part has a
     range in magnitude of 1/2 to (1 - 2^-27) with a precision of
     approximately 8 decimal digits.  The exponent consists of
     the lowered ten symbol & followed by an optionally signed
     integer.  The exponent range is -128 to 127 inclusive.  E.g.
     0.000000000123 could be written 1.23&-10.  Assuming positive
     numbers, the smallest real number distinct from zero is
     0.146 936 793 852 785 939&&-38, and the greatest number is
DECsystem-10 SIMULA Language Handbook, part II            Page 89
APPENDIX A   HARDWARE REPRESENTATION


     0.170 141 183 460 469 231&&+39.  Since the sign is treated
     separately, these limits are valid for negative numbers if
     the sign is changed.

     Long real constants must contain the exponent part with the
     lowered ten symbol &&.  The exponent range is the same as
     for real constants.  The fractional part has a range in
     magnitude of 1/2 to (1 - 2^-62) with a precision of
     approximately 19 decimal digits.  Long real constants should
     be used only if a precision greater than 8 decimal digits is
     needed.  E.g.  3.1415926535898 is written 3.1415926535898&&0
     to be represented in double precision.



A.6.2  Boolean constants.

     Boolean constants are the SIMULA words TRUE and FALSE.



A.6.3  Character constants.

     A character constant is any single printable character from
     the ASCII set, octal code 040-176, enclosed by the symbol '
     (octal code 047).  Other ASCII character values can be
     entered with the CHAR procedure, e.g.  CHAR(9) for <TAB>.



A.6.4  Text constants.

     A text constant is represented by one or more sequences of
     printable ASCII characters, octal code 040-176, enclosed in
     double quote symbols " (octal code 042).  The sequences may
     be separated by any number of blanks, tabs or line control
     characters (VT, CR, LF, FF).  Together, the sequences form
     one text constant which is the concatenated contents of the
     character sequences.  The double quote symbol in a text
     constant is written as two consecutive double quote symbols.
     The line delimiting characters VT, CR, LF and FF are
     accepted but not treated as part of the text constant.
     Other ASCII character values can be entered with a
     combination of the PUTCHAR and CHAR procedures.



A.7  COMMENTS.

     A comment consists of the basic symbol COMMENT followed by a
     nonalphameric character and the successive characters up to
DECsystem-10 SIMULA Language Handbook, part II            Page 90
APPENDIX A   HARDWARE REPRESENTATION


     and including the next semicolon.  The symbol COMMENT may be
     replaced by the character !  (octal code 041).  All
     printable characters plus the line editing characters are
     allowed in comments.

     An END comment is the string of characters following the
     basic symbol END up to but not including the next semicolon,
     END, ELSE, WHEN or OTHERWISE.

     Comments and END comments are printed in the program
     listing, but they are not further processed by the compiler.

     A warning message is issued if an END comment contains the
     basic symbols ":=" , ":-" , "(" or "GOTO".



A.8  USE OF SPACES AND LINE EDITING CHARACTERS.

     A basic symbol, identifier or constant must not contain line
     editing characters or non-significant spaces.
     Exceptions are:
     1) GOTO can be written with or without spaces and
        line editing characters between GO and TO.
     2) Arithmetic constants may contain spaces.

     Adjacent identifiers or basic symbols represented by
     keywords must be separated by one or more spaces and/or line
     editing characters.  The same rule applies to a keyword
     followed or preceded by a number constant.  Any basic
     symbol, identifier or constant must be contained in one
     line.  A text constant may, however, continue over several
     lines.  This is best achieved by splitting the constant into
     several parts, e g
         t:-copy("first part of text "
                 "second part of text");
DECsystem-10 SIMULA Language Handbook, part II            Page 91
APPENDIX B   INTERNAL REPRESENTATION


APPENDIX B   INTERNAL REPRESENTATION
====================================



     The DECsystem-10 SIMULA Technical Documentation [6] should
     be consulted when the information in this appendix is
     insufficient.



B.1  REPRESENTATION OF VARIABLES


     INTEGER
     -------

     One word.  Twos complement fixed point hardware format.


     SHORT INTEGER
     -------------

     Treated as INTEGER.


     REAL
     ----

     One word.  Single precision floating point hardware format.


     LONG REAL
     ---------

     Two words.  Double precision floating point hardware format.


     CHARACTER
     ---------

     One word.  The rightmost 7 bits contain the character.  The
     rest of the word is zero.


     BOOLEAN
     -------

     One word.  TRUE is represented by -1.  Any other non-zero
     value will also be interpreted as TRUE.  FALSE is
     represented by 0.
DECsystem-10 SIMULA Language Handbook, part II            Page 92
APPENDIX B   INTERNAL REPRESENTATION


     REF
     ---

     One word.  Left halfword is zero.  Right halfword points at
     an object or is NONE.  NONE is represented by octal 676000
     (223K).


     TEXT
     ----

     Two words.              ---------------------
                     0       [   SP    I   ZTE   ]
                             ----------+----------
                     1       [   LNG   I   CP    ]
                             ---------------------

     SP   0<0:17>    The number of characters before this
                     (sub)text within the text object.
     ZTE  0<18:35>   Pointer to the text record.
     LNG  1<0:17>    Length of TEXT.
     CP   1<18:35>   Current position in text (= POS-1)

     Text record:
                             ---------------------
                     0       [     Overhead      ]
                             ----------+----------
                     1       [   CLN   I   LEN   ]
                             ----------+----------
                     2       [    Characters     ]
                             .    of text        .
                             [                   ]
                             ---------------------

     Overhead        One word with information and workspace for
                     the garbage collector.
     CLN  1<0:17>    Number of characters in text as given in
                     parameter to BLANKS or COPY.
     LEN  1<18:35>   The length of the record in words
DECsystem-10 SIMULA Language Handbook, part II            Page 93
APPENDIX B   INTERNAL REPRESENTATION


     ARRAY
     -----

     One word.  Left halfword is zero.  Right halfword points to
     an array record.

     Array record:
                             ---------------------------------
                     0       [           Overhead            ]
                             ----------------+----------------
                     1       [               I      LEN      ]
                             ----------------+----------------
                     2       [              BAD              ]
                             --------+-------+----------------
                     3       [  TYP  I  SUB  I      ZPR      ]
                             --------+-------+----------------
                     4       [             LOW(1)            ]
                             ---------------------------------
                     5       [             UPP(1)            ]
                             .                               .
                     2n+2    [             LOW(n)            ]
                             ---------------------------------
                     2n+3    [             UPP(n)            ]
                             ---------------------------------
                     2n+4    [             DOP(2)            ]
                             .                               .
                     3n+2    [             DOP(n)            ]
                             ---------------------------------
                     3n+3    [                               ]
                             .       Array  elements         .
                             [                               ]
                             ---------------------------------

     Overhead        One word with information and workspace for
                     the garbage collector.
     LEN  1<18:35>   Total length of array record.
     BAD  2<0:35>    Address of the (possibly fictive) array
                     element with all subscripts zero.
     TYP  3<0:8>     Type of the elements in the array.
     SUB  3<9:17>    Number of subscripts.
     ZPR  3<18:35>   Qualification prototype pointer if REF
                     array.
     LOW[1:SUB]      Lower subscript bounds.
     UPP[1:SUB]      Upper subscript bounds.
     DOP[2:SUB]      Dope vector.
DECsystem-10 SIMULA Language Handbook, part II            Page 94
APPENDIX B   INTERNAL REPRESENTATION


B.2  REPRESENTATION OF DYNAMIC ADDRESSES


     DYNAMIC ADDRESS OF VALUE TYPE VARIABLE

                             ----------------+----------------
                             [      OFS      I      ZBI      ]
                             ----------------+----------------

             OFS     Offset of variable in block instance.
             ZBI     Block instance address.


     DYNAMIC ADDRESS OF SWITCH

                             ----------------+----------------
                             [      ZSR      I      ZBI      ]
                             ----------------+----------------

             ZSR     Switch record address.
             ZBI     Block instance address (static environment).


     DYNAMIC ADDRESS OF LABEL

                             ----------------+----------------
                             [      CAD      I      ZBI      ]
                             ----------------+----------------
                             [      EBL      I      BNM      ]
                             ----------------+----------------

             CAD     Code address.
             ZBI     Block instance address.
             EBL     Effective block level.
             BNM     State (block number).


     DYNAMIC ADDRESS OF ARRAY

                             ---------------------------------
                             [              ZAR              ]
                             ---------------------------------

             ZAR     Address of array record.
DECsystem-10 SIMULA Language Handbook, part II            Page 95
APPENDIX B   INTERNAL REPRESENTATION


     DYNAMIC ADDRESS OF REF ARRAY

                             ---------------------------------
                             [              ZAR              ]
                             ---------------------------------
                             [              ZPR              ]
                             ---------------------------------

             ZAR     Address of array record.
             ZPR     Qualification prototype address.


     DYNAMIC ADDRESS OF REF VARIABLE

                             ----------------+----------------
                             [      OFS      I      ZBI      ]
                             ----------------+----------------
                             [              ZPR              ]
                             ---------------------------------

             OFS     Offset in block instance.
             ZBI     Block instance
             ZPR     Qualification prototype address.


     DYNAMIC ADDRESS OF PROCEDURE

                             ----------------+----------------
                             [      ZPR      I      ZBI      ]
                             ----------------+----------------
                             [               I      EBI      ]
                             ----------------+----------------

             ZPR     Procedure prototype address.
             ZBI     Enclosing "complete" block (with display).
             EBI     Innermost enclosing block.
DECsystem-10 SIMULA Language Handbook, part II            Page 96
APPENDIX B   INTERNAL REPRESENTATION


B.3  REPRESENTATION OF PARAMETERS


     VALUE TYPE (integer, (long)real, boolean or character)
     CALLED BY VALUE.
     OBJECT REF CALLED BY REFERENCE.
     TEXT OR ANY TYPE OF ARRAY CALLED BY VALUE OR REFERENCE.

     They have the same representation as the corresponding
     variables.


     LABEL,SWITCH AND PROCEDURE CALLED BY REFERENCE

     They are represented by their dynamic addresses.


     ALL PARAMETERS CALLED BY NAME

     Parameters called by name are represented by a double-word
     descriptor with the following fields:

     NTH  0<0>       This field is =1 if no thunk exists, i.e.
                     if all information about the actual
                     parameter is contained in the descriptor.
     ATP  0<1:5>     Type code for actual parameter.
     DTP  0<6:8>     Type of descriptor and thunk.
                     VALUE   EXPLANATION
                     0   Actual parameter is a simple variable.
                         Its address is obtained by adding ZBI
                         and ADR.
                     1   Not used.
                     2   Not used.
                     3   The thunk will yield a dynamic address.
                     4   ADR is the address of a constant actual
                         parameter.
                     5   Not used.
                     6   Not used.
                     7   The thunk yields the value of an
                         expression.
     AKD  0<9:11>    Gives the kind of the actual parameter.
     CNV  0<13>      Set to 1 if parameter conversion is
                     necessary.  i.e.  the type of the formal
                     parameter and the actual parameter are not
                     the same.
     FTP  0<14;17>   Type code for formal parameter.
DECsystem-10 SIMULA Language Handbook, part II            Page 97
APPENDIX B   INTERNAL REPRESENTATION


     ZBI  0<18:35>   Address of block instance where actual
                     parameter exists or address of nearest block
                     instance (with display) to be used when
                     evaluating the thunk.
     ZQU  1<0:17>    Qualifying prototype for actual parameter of
                     type REF.
     ADR  1<18:35>   If NTH is zero this is the address of the
                     thunk.  Otherwise the interpretation of this
                     field depends on the value of DTP as
                     follows:
                     DTP=0   Offset of variable in its block.
                     DTP=4   Address of a constant.




B.4  DYNAMIC RECORDS


     DISPLAY RECORD

                             ---------------------------------
                             [           Overhead            ]
                             ----------------+----------------
                     -n-2    [      ZAC      I      LEN      ]
                             ---------------------------------
                     -n-1    [            ZPB(n)             ]
                             .                               .
                     -2      [            ZPB(1)             ]
                             ----------------+----------------
                     -1      [      ZBI      I      ARE      ]
                             ----------------+----------------

             Overhead One word with information and workspace for
                     the garbage collector.
             ZAC     Pointer to an accumulator stack record if
                     present.
             LEN     Length of the display record.
             ZPB[1:n] Display vector
             ZBI     Normally the block instance which was active
                     when this display record was created.
             ARE     Reactivation address of the block to which
                     this display belongs.
DECsystem-10 SIMULA Language Handbook, part II            Page 98
APPENDIX B   INTERNAL REPRESENTATION


     BLOCK INSTANCE HEADER

                             ---------------------------------
                     0       [           Overhead            ]
                             ----------------+----------------
                     1       [      BNM      I      ZPR      ]
                             ----------------+----------------

             Overhead One word with information and workspace for
                     the garbage collector.
             BNM     State of block instance (i.e.  the number of
                     the subblock currently active).
             ZPR     Prototype address


     UNREDUCED SUBBLOCK RECORD

                             ---------------------------------
                     0       [                               ]
                             .     block instance header     .
                     1       [                               ]
                             ---------------------------------
                     2       [                               ]
                             .     variables in subblock     .
                             [                               ]
                             ---------------------------------
     PROCEDURE INSTANCE

                             ---------------------------------
                             [                               ]
                             .       display record          .
                     -1      [                               ]
                             ---------------------------------
                     0       [                               ]
                             .     block instance header     .
                     1       [                               ]
                             ---------------------------------
                     2       [                               ]
                             .      formal parameters        .
                             [                               ]
                             ---------------------------------
                             [                               ]
                             .    variables of procedure     .
                             [                               ]
                             ---------------------------------
DECsystem-10 SIMULA Language Handbook, part II            Page 99
APPENDIX B   INTERNAL REPRESENTATION


     FUNCTION DESIGNATOR INSTANCE

                             ---------------------------------
                             [                               ]
                             .        display record         .
                     -1      [                               ]
                             ---------------------------------
                     0       [                               ]
                             .     block instance header     .
                     1       [                               ]
                             ---------------------------------
                     2       [       value of function       ]
                             .                               .
                             [       formal parameters       ]
                             ---------------------------------
                             [                               ]
                             .     variables of function     .
                             [                               ]
                             ---------------------------------


     CLASS INSTANCE

                             ---------------------------------
                             [                               ]
                             .         display record        .
                     -1      [                               ]
                             ---------------------------------
                     0       [                               ]
                             .     block instance header     .
                     1       [                               ]
                             ---------------------------------
                     2       [                               ]
                             .       formal parameters       .
                             [                               ]
                             ---------------------------------
                             [                               ]
                             .          attributes           .
                             [                               ]
                             ---------------------------------
DECsystem-10 SIMULA Language Handbook, part II           Page 100
APPENDIX B   INTERNAL REPRESENTATION


     SUBCLASS INSTANCE

                             ---------------------------------
                             [                               ]
                             .     prefix class instance     .
                             [                               ]
                             ---------------------------------
                             [                               ]
                             .       formal parameters       .
                             [                               ]
                             ---------------------------------
                             [                               ]
                             .           attributes          .
                             [                               ]
                             ---------------------------------


     PREFIX BLOCK INSTANCE

                             ---------------------------------
                             [                               ]
                             .     prefix class instance     .
                             [                               ]
                             ---------------------------------
                             [                               ]
                             .      variables of block       .
                             [                               ]
                             ---------------------------------



     EVENTNOTICE RECORD

                             ---------------------------------
                     0       [           Overhead            ]
                             ----------------+----------------
                     1       [               I       LEN     ]
                             ----------------+----------------
                     2       [       ZEV     I       ZER     ]
                             ----------------+----------------
                             [                               ]
                             .       Eventnotices            .
                             [                               ]
                             ---------------------------------

             Overhead One word with information and workspace for
                     the garbage collector.
             LEN     Length of the eventnotice rcord.
             ZEV     Eventnotice free chain start.
             ZER     Chain of eventnotice records.
DECsystem-10 SIMULA Language Handbook, part II           Page 101
APPENDIX B   INTERNAL REPRESENTATION


     EVENTNOTICE

                             ----------------+----------------
                     0       [       ZBL     I       ZPS     ]
                             ----------------+----------------
                     1       [       ZLL     I       ZRL     ]
                             ----------------+----------------
                     2       [       ZER     I       ZCH     ]
                             ----------------+----------------
                     3       [              TIM              ]
                             ---------------------------------

             ZBL     Backward link.
             ZPS     Process pointer.
             ZLL     Left link.
             ZRL     Right link.
             ZER     Base pointer (enclosing eventnotice record).
             ZCH     Free list pointer.
             TIM     Scheduled time.



     SIMULATION BLOCK

                             ---------------------------------
                     0       [                               ]
                             .       block instance header   .
                     1       [                               ]
                             ----------------+----------------
                     2       [       FT      I       LT      ]
                             ----------------+----------------
                     3       [       LNK     I       ZER     ]
                             ----------------+----------------
                     4       [              ZPS              ]
                             ---------------------------------

             FT      First eventnotice in SQS.
             LT      Last eventnotice in SQS and root of binary
                     tree.
             LNK     Chain of simulation blocks.  Used by garbage
                     collector.
             ZER     Chain of eventnotice records.
             ZPS     Ref(PROCESS) main program.
DECsystem-10 SIMULA Language Handbook, part II           Page 102
APPENDIX B   INTERNAL REPRESENTATION


     LINKAGE

                             ---------------------------------
                     0       [                               ]
                             .       block instance header   .
                     1       [                               ]
                             ----------------+----------------
                     2       [       SUC     I       PRE     ]
                             ----------------+----------------

             SUC     SUC link.
             PRE     PRED link.



     PROCESS

                             ---------------------------------
                     0       [                               ]
                             .            linkage            .
                     2       [                               ]
                             ---------------------------------
                     3       [              ZEV              ]
                             ---------------------------------

             ZEV     Eventnotice pointer.



     ORDER OF PARAMETERS

     The parameters will appear in the same order as they are
     named in the source program.


     ORDER OF ATTRIBUTES AND VARIABLES

     The attributes and variables are divided into three groups.
     In the first group are all which do not belong to another
     group.  In the second group are all of type TEXT and kind
     simple.  In the third group are all of type REF or kind
     ARRAY.  Within each group the attributes and variables have
     the same order as they are declared in the source program.  
DECsystem-10 SIMULA Language Handbook, part II           Page 103
APPENDIX C COMPILER DIAGNOSTICS


APPENDIX C  COMPILER DIAGNOSTICS
================================



     This appendix is divided into two sections.  The first
     section covers the diagnostic messages associated with
     commands and switches.  These messages are unnumbered.

     The second section contains all source code messages
     produced by the compiler.




C.1  COMMAND AND SWITCH MESSAGES




?= OR _ MISSING IN COMMAND

     EXPLANATION:  Equal sign or left arrow (=underline) is
     mandatory in all commands unless the command consists of
     only one source file descriptor.


?CAN'T OPEN DISK

     EXPLANATION:  OPEN failure when trying to open a disk
     device.

     COMPILER ACTION:  The compiler prints an asterisk and waits
     for next command.


?COMMAND LINE EXCEEDS 135 CHARACTERS

     EXPLANATION:  Overflow in the internal command line buffer.

     COMPILER ACTION:  The input buffer is cleared, i.e.  all
     type ahead input is deleted.  The compiler prints an
     asterisk and waits for next command.
DECsystem-10 SIMULA Language Handbook, part II           Page 104
APPENDIX C COMPILER DIAGNOSTICS


COLON AFTER -E OR nE NOT ALLOWED.  LIST IGNORED

     COMPILER ACTION:  Switch is processed as /-E or /nE.


COLON AFTER SWITCH switch NOT SUCCEEDED BY QUOTE.  COLON IGNORED.

     COMPILER ACTION:  The switch is processed as if no colon was
     present.


?COMMA MISSING IN PPN

     USER ACTION:  Retype the command.


EXTERNAL SWITCH ALREADY SPECIFIED.  IGNORED

     EXPLANATION:  EXTERNAL switch can only be specified once for
     each compilation.


FINAL QUOTE IN TEXT CONSTANT MISSING.  QUOTE ASSUMED

     EXPLANATION:  Text constant after colon must be enclosed in
     quotes.


?HELP FILE NOT FOUND

     COMPILER ACTION:  HELP switch ignored.


?ILLEGAL DELIMITER "byte" IN COMMAND

     EXPLANATION:  Legal file specification delimiters are comma,
     equal sign, left arrow, space, tab and carriage return.

     USER ACTION:  Retype command.


INCOMPLETE EXTERNAL LIST

     EXPLANATION:  Not valid EXTERNAL list format.  See Chapter
     3.5.
DECsystem-10 SIMULA Language Handbook, part II           Page 105
APPENDIX C COMPILER DIAGNOSTICS


?INVALID DEVICE.  ONLY DSK ALLOWED

     EXPLANATION:  Device in command can only be disk or a
     logical name assigned to disk.

     USER ACTION:  Retype command.


KEYWORD (NO)CHECK EXPECTED AFTER CODE IN EXTERNAL LIST.  LIST
     IGNORED

     EXPLANATION:  CHECK, NOCHECK or -CHECK is expected after
     CODE in EXTERNAL list.

     COMPILER ACTION:  Switch is processed as /E.


KEYWORD FORTRAN, F40 OR CODE EXPECTED AFTER :  IN EXTERNAL LIST.
     LIST IGNORED

     COMPILER ACTION:  Switch is processed as /E.


?LOOKUP ERROR ON COMMAND FILE

     EXPLANATION:  Command file from COMPILE not found.

     COMPILER ACTION:  The compiler prints an asterisk and waits
     for next command.


MINUS NOT VALID BEFORE switch.  MINUS IGNORED

     EXPLANATION:  Minus is not excepted before HELP and PAGE.


MISSPELLED SWITCH:  switch.  FIRST LETTER USED

     EXPLANATION:  First letter of switch matches existing switch
     name but not rest of switch.

     COMPILER ACTION:  The misspelling is ignored and the switch
     is processed according to the first letter.


?MORE THAN 6 DIGITS IN PPN

     USER ACTION:  Retype the command.
DECsystem-10 SIMULA Language Handbook, part II           Page 106
APPENDIX C COMPILER DIAGNOSTICS


UNRECOGNIZABLE SWITCH:  switch.  SWITCH IGNORED

     EXPLANATION:  First letter of switch name does not match any
     legal switch.


NUMBER BEFORE switch NOT VALID.  NUMBER IGNORED

     EXPLANATION:  Decimal number may only precede EXTERNAL AND
     PAGE.


NUMBER NOT VALID WITH MINUS IN switch.  NUMBER IGNORED

     EXPLANATION:  Number is not valid after minus sign in any
     switch.


?READ ERROR ON COMMAND FILE

     EXPLANATION:  Read error occurred when reading the command
     file from COMPIL.

     COMPILER ACTION:  The compiler types an asterisk and waits
     for next command from the user (see chapter 3.2).


READ ERROR ON HELP FILE

     COMPILER ACTION:  The rest of the help message is lost.  The
     compiler continues command processing.


?RIGHT PARENTHESIS MISSING AFTER SWITCH(ES)

     EXPLANATION:  Switches from the COMPIL CUSP must be enclosed
     in parentheses.

     USER ACTION:  Retype the command.


?RIGHT SQUARE BRACKET MISSING IN PPN

     USER ACTION:  Retype the command.
DECsystem-10 SIMULA Language Handbook, part II           Page 107
APPENDIX C COMPILER DIAGNOSTICS


SWITCH switch NOT VALID AFTER PROGRAM START.  SWITCH IGNORED

     EXPLANATION:  See chapter 3.5.


?SWITCH WITHOUT FILE SPEC.  SWITCH IGNORED.

     EXPLANATION:  All switches except HELP must be preceded by a
     file specification.

     USER ACTION:  Type a new command.


TEXT CONSTANT AFTER -R NOT ALLOWED.  TEXT CONSTANT IGNORED.

     COMPILER ACTION:  Switch processed as /-R.


WARNING:  NO SWITCH NAME

     EXPLANATION:  Slash is not followed by a switch name.

     COMPILER ACTION:  Slash ignored.



C.2  COMPILER SOURCE CODE DIAGNOSTICS


All compiler messages are numbered SIMnnn X, where nnn is an
identification number and X indicates type of error:

E  indicates error, generated code may or may not be executable
W  indicates warning, generated code is executable
T  indicates termination error, no relfil is generated

If a terminating error occurs, the list file may not be
generated.


The message is printed on the user's TTY and in the source
listing after the faulty line.  If the faulty statement covers
more than one line, the message is written after the last line.
The line number given in the message points at the start of the
faulty statement.


COMPILER SOURCE CODE DIAGNOSTICS:


DECsystem-10 SIMULA Language Handbook, part II           Page 108
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM001 W MINUS NOT VALID IN AAAA , MINUS IGNORED

         EXPLANATION:  AAAA is a switch name.  Minus may not
         precede PAGE or HELP.


SIM002 W COLON AFTER AAAA NOT SUCCEEDED BY QUOTE, TEXT CONSTANT
         IGNORED

         EXPLANATION:  AAAA is a switch name.  A text constant
         after colon must be enclosed in quotes.


SIM003 W END QUOTE MISSING IN TEXT CONSTANT, QUOTE ASSUMED

         EXPLANATION:  A text constant argument to a switch must
         be enclosed in quotes.


SIM004 W COLON AFTER AAAA NOT ALLOWED IN COMMAND, CONSTANT
         IGNORED

         EXPLANATION:  AAAA is a switch name.  Colon indicates a
         switch argument and is only allowed for EXTERNAL, PAGE
         and RUNSWITCHES.


SIM005 W HELP NOT VALID IN OPTIONS STATEMENT, IGNORED

         EXPLANATION:  HELP switch is always ignored in OPTIONS.


SIM006 W NUMBER IN AAAA NOT VALID, NUMBER IGNORED

         EXPLANATION:  AAAA is a switch name.  Number is allowed
         only before EXTERNAL and PAGE.


SIM007 W NOT RECOGNIZABLE SWITCH AAAA , SWITCH IGNORED

         EXPLANATION:  AAAA is a switch name.  First letter of
         switch did not match the beginning of any legal switch.


SIM010 W SWITCH:  AAAA MISSPELLED.

         EXPLANATION:  AAAA is a switch name.

         COMPILER ACTION:  Switch is processed according to first
         letter.
DECsystem-10 SIMULA Language Handbook, part II           Page 109
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM011 W SWITCH AAAA NOT VALID AFTER PROGRAM START, SWITCH
         IGNORED

         EXPLANATION:  AAAA is a switch name.  See chapter 3.5.


SIM012 W NUMBER NOT VALID WITH MINUS IN AAAA , NUMBER IGNORED

         EXPLANATION:  AAAA is a switch name.


SIM013 W EXTERNAL SWITCH ALREADY SPECIFIED, IGNORED

         EXPLANATION:  EXTERNAL can only be specified once in
         each compilation.


SIM014 W CHECK EXPECTED AFTER AAAA IN EXTERNAL LIST, LIST IGNORED

         EXPLANATION:  AAAA is a keyword, CODE or FORTRAN.

         COMPILER ACTION:  Switch is processed as /E.


SIM015 W EXTERNAL LIST INCOMPLETE

         EXPLANATION:  Illegal EXTERNAL list format.  See chapter
         3.5.


SIM016 W FORTRAN, F40 OR CODE EXPECTED AFTER :  IN EXTERNAL, LIST
         IGNORED

         COMPILER ACTION:  Switch is processed as /E.


SIM017 W COLON AFTER -E NOT ALLOWED, LIST IGNORED

         COMPILER ACTION:  Switch is processed as /-E or /nE.


SIM020 W TEXT CONSTANT AFTER -R NOT ALLOWED, TEXT CONSTANT
         IGNORED

         COMPILER ACTION:  Switch is processed as /-R.
DECsystem-10 SIMULA Language Handbook, part II           Page 110
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM021 W INVALID DEVICE IN R-SWITCH, ONLY DSK ALLOWED

         EXPLANATION:  File specification in R-switch must have a
         DSK device.

         COMPILER ACTION:  Switch ignored.

         USER ACTION:  Change device to DSK, or, if a logical
         name is used, assign this name to DSK.


SIM022 W COMMA MISSING IN R-SWITCH

         EXPLANATION:  PPN in file specification in R-switch must
         contain comma.

         COMPILER ACTION:  Switch ignored.

         USER ACTION:  Correct PPN and re-compile.


SIM023 W RIGHT SQUARE BRACKET MISSING IN R-SWITCH

         EXPLANATION:  PPN in file specification must always be
         terminated with right square bracket ].

         USER ACTION:  Correct PPN and re-compile.


SIM024 W MORE THAN SIX DIGITS IN PPN

         EXPLANATION:  PPN in file specification in R-switch
         contains more than 6 digits.

         COMPILER ACTION:  Switch ignored.

         USER ACTION:  Correct PPN and re-compile.


SIM031 W COMPILER HAS RENUMBERED LINE AAAA

         EXPLANATION:  AAAA = line number.

         COMPILER ACTION:  The line number is replaced by
         previous line number + 1 in the source code listing.

         USER ACTION:  Resequence the line numbers in the source
         file.  If you are using the SOS text editor, use the NP
         command to get consecutive line numbers throughout the
         file.  See also appendix K.2 (for SOS or EDITS) or K.3
         (for TECO).
DECsystem-10 SIMULA Language Handbook, part II           Page 111
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM032 W LINE NUMBER EXCEEDS 65534

         EXPLANATION:  Line numbers exceeding 65534 will not
         affect the compilation, but later run-time errors will
         not indicate the correct line.  These line numbers
         cannot be used for debugging with SIMDDT.

         USER ACTION:  Alternative 1:  Resequence the source file
         with smaller line number increment.  See appendix K.2 or
         K.3.
         Alternative 2:  Divide large SIMULA source program file
         into separately compiled modules.  See chapter 4 of part
         I of the DECsystem-10 SIMULA Language Handbook.


SIM034 W OVERFLOW, INTEGER CONVERTED TO REAL

         EXPLANATION:  Integer constant larger than 2^35-1.


SIM035 W YOU MAY HAVE FORGOTTEN ;  AFTER END

         EXPLANATION:  One of the basic symbols:
              := :- ( GOTO
         has been found in an end comment.  The comment is
         terminated by:
              ;  END ELSE WHEN or OTHERWISE

         USER ACTION:  If error, correct it, if not, insert
         COMMENT after END.


SIM036 W END OF LINE IN TEXT CONSTANT

         EXPLANATION:  One of the characters LF CR FF or VT has
         been found in a text constant.

         COMPILER ACTION:  The character is skipped and not moved
         to the generated program.


SIM037 W PAGE STRING MISSING AFTER :  IN OPTIONS

         COMPILER ACTION:  The input is skipped until / or ;  is
         found.
DECsystem-10 SIMULA Language Handbook, part II           Page 112
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM040 W PAGE STRING LONGER THAN 60 CHARACTERS

         EXPLANATION:  The maximum number of characters in a page
         switch string is 60.

         COMPILER ACTION:  The input is skipped until the next "
         or until a new line is found.


SIM041 W INVALID CHARACTER, AAAA EXPECTED IN OPTIONS

         EXPLANATION:  The invalid character and the character
         which is expected are edited into the message.  One of
         the characters ( / ) ;  is expected.

         COMPILER ACTION:  The input is skipped until the next /
         ( ) or ;  is found.


SIM042 W SWITCH MISSING IN OPTIONS STATEMENT

         EXPLANATION:  No switch was found in an OPTIONS
         statement.


SIM043 W END OF FILE IN OPTIONS STATEMENT



SIM044 W CHARACTER AFTER TEST NOT VALID

         EXPLANATION:  This message should not occur.  The test
         version of the compiler accepts ^^ as a control
         character which directs debug output.  The characters
         after ^^ are not valid and 0 is assumed.


SIM051 W ILLEGAL END OF PROGRAM

         EXPLANATION:  Program continues after last end.

         USER ACTION:  Check block structure.


SIM052 W ILLEGAL SWITCH SETTING

DECsystem-10 SIMULA Language Handbook, part II           Page 113
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM053 W SHORT NOT FOLLOWED BY INTEGER

         COMPILER ACTION:  Treated as INTEGER.


SIM054 W LONG NOT FOLLOWED BY REAL

         COMPILER ACTION:  Treated as REAL.


SIM055 W LEFT BRACKET IN EXPRESSION



SIM056 W % AT START OF LINE, LINE IGNORED

         EXPLANATION:  Line starting with % may contain compiler
         directives in other SIMULA systems.

         COMPILER ACTION:  Line is treated as a comment.

         USER ACTION:  Delete the line or translate to OPTIONS
         statement.


SIM061 E TOO LONG LINE

         EXPLANATION:  A source code line must not exceed 135
         characters including possible nulls.

         COMPILER ACTION:  The line is truncated to 135
         characters and compiled as if it were terminated with
         carriage return and line feed.


SIM063 E = MUST FOLLOW =/

         COMPILER ACTION:  =/= assumed.


SIM064 E NONPRINTABLE CHARACTER

         COMPILER ACTION:  The character is ignored.

         USER ACTION:  Check the source input program.  
DECsystem-10 SIMULA Language Handbook, part II           Page 114
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM065 E ILLEGAL CHARACTER AAAA

         EXPLANATION:  AAAA is the illegal character.

         COMPILER ACTION:  The character is treated as a blank.


SIM066 E GO NOT FOLLOWED BY TO

         COMPILER ACTION:  The single GO is treated as GO TO.


SIM067 E GO MISSING BEFORE TO

         COMPILER ACTION:  The TO is ignored.


SIM070 E EOF IN COMMENT

         EXPLANATION:  The ;  which closes the comment is not
         found before the end of the input file is found.


SIM071 E EOF IN TEXT CONSTANT

         EXPLANATION:  The " which closes the text constant is
         not found before the end of the input file is found.

         COMPILER ACTION:  Valid program parts are taken as part
         of the text constant if the " was forgotten.


SIM072 E CHARACTER QUOTE MISSING

         COMPILER ACTION:  The incomplete character constant is
         treated as a valid one.


SIM073 E CONTROL CHARACTER IN CHARACTER CONSTANT

         EXPLANATION:  The TAB character (HT) and the line
         control characters LF, FF, VT and CR are not accepted as
         character constants.  Non-printable characters, e.g.
         altmode, are not accepted either, see SIM064.

         COMPILER ACTION:  The character is treated as a blank.

         USER ACTION:  Use the built-in procedure CHAR.
DECsystem-10 SIMULA Language Handbook, part II           Page 115
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM074 E TAB IN TEXT CONSTANT

         EXPLANATION:  The horisontal tab character is not
         accepted in a text constant.

         COMPILER ACTION:  The tab is treated as a blank
         character.

         USER ACTION:  Use PUTCHAR(CHAR(9));.


SIM075 E TEXT CONSTANT LONGER THAN 2**15



SIM076 E MORE THAN ONE DECIMAL POINT

         COMPILER ACTION:  Extra decimal points in the real
         constant are ignored.


SIM077 E DIGIT MISSING AFTER DECIMAL POINT

         COMPILER ACTION:  A zero is assumed to follow the
         decimal point in the real constant.


SIM100 E NO DIGITS IN EXPONENT

         COMPILER ACTION:  The exponent is ignored.


SIM101 E FLOATING OVERFLOW

         COMPILER ACTION:  The maximal real constant,
         approximately 1.7&38, see A.6.1, is used instead.


SIM102 E FLOATING UNDERFLOW

         COMPILER ACTION:  The real constant 0 is used.


SIM103 E INTEGER OVERFLOW IN RADIX CONSTANT

         COMPILER ACTION:  The integer constant 8R377777777777 is
         used.
DECsystem-10 SIMULA Language Handbook, part II           Page 116
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM104 E DIGITS MISSING IN RADIX NUMBER

         EXPLANATION:  There are no digits (0-9 or A-F) after R
         in a radix constant.

         COMPILER ACTION:  The base is used as integer constant.


SIM105 E DIGIT AAAA NOT LESS THAN RADIX BASE

         EXPLANATION:  AAAA is the digit (0-9 or A-F) which is
         greater than the radix base.

         COMPILER ACTION:  The rest of the number is ignored.


SIM110 E ILLEGAL START OF PROGRAM

         COMPILER ACTION:  Scan until program start is found.


SIM111 E XXXX IS MISPLACED

         EXPLANATION:  XXXX = misplaced entity.

         COMPILER ACTION:  Skip rest of statement or declaration.


SIM112 E DECLARATION MUST BE FOLLOWED BY ;

         COMPILER ACTION:  ;  assumed.


SIM113 E MISSING END

         COMPILER ACTION:  An extra END is assumed.


SIM114 E XXXX IS ILLEGAL CLASS PREFIX

         EXPLANATION:  XXXX = prefix.

         COMPILER ACTION:  The class is treated as unprefixed.


SIM115 E XXXX SPECIFICATION MUST PRECEDE TYPE SPECIFICATION

         EXPLANATION:  XXXX = value or name.

         COMPILER ACTION:  Specification ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 117
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


         USER ACTION:  Reorder specifications.


SIM116 E ILLEGAL CLASS SPECIFICATION



SIM117 E VIRTUAL MUST BE FOLLOWED BY :

         COMPILER ACTION:  :  is assumed.


SIM120 E ILLEGAL VIRTUAL SPECIFICATION

         COMPILER ACTION:  Specification ignored.


SIM121 E MISSING ;  AFTER INNER

         COMPILER ACTION:  ;  is assumed.


SIM122 E XXXX IS ILLEGAL CLASS/PROCEDURE NAME

         EXPLANATION:  XXXX = CLASS/PROCEDURE name.

         USER ACTION:  Check that name is not a reserved word.
         (See appendix G).


SIM123 E ILLEGAL VIRTUAL TYPE

         COMPILER ACTION:  Specification ignored.


SIM124 E MISSING IDENTIFIER LIST

         EXPLANATION:  No identifier follows <type>.


SIM125 E ERRONEOUS SWITCH DECLARATION

         COMPILER ACTION:  Declaration ignored.


SIM126 E ILLEGAL REFERENCE TYPE

         EXPLANATION:  Syntax should be:
         REF(<CLASS-identifier>).

         COMPILER ACTION:  Declaration or specification ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 118
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM127 E MORE THAN 10 DIMENSIONS



SIM130 E MISSING XXXX

         EXPLANATION:  XXXX = right parenthesis/bracket.

         COMPILER ACTION:  Missing symbol is assumed.


SIM131 E HOMELESS XXXX PART

         EXPLANATION:  XXXX = ELSE/WHEN/OTHERWISE.

         COMPILER ACTION:  Statement ignored.


SIM132 E STATEMENT BEFORE BEGIN NOT TERMINATED

         COMPILER ACTION:  ;  assumed before BEGIN.


SIM133 E CANNOT FIND THEN IN IF-STATEMENT

         COMPILER ACTION:  statement skipped.


SIM134 E IF-STATEMENT CANNOT BE PLACED DIRECTLY AFTER THEN

         COMPILER ACTION:  Enclose statement by BEGIN-END.

         USER ACTION:  Do the same.


SIM135 E FOR-, INSPECT- or WHILE-STATEMENT CANNOT BE PLACED
         BETWEEN THEN AND ELSE

         COMPILER ACTION:  Enclose statement by BEGIN-END.

         USER ACTION:  Do the same.


SIM136 E INNER ILLEGALLY PLACED

         EXPLANATION:  1) INNER is not placed at the outermost
         block level in a class body.
         2) Several INNER statements occur in the same class
         body.
         3) INNER is preceded by something different from BEGIN
         or semicolon (;).  According to the syntax ([1] Sect
DECsystem-10 SIMULA Language Handbook, part II           Page 119
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


         2.1, [3] Sect 5.5), these are the only symbols which can
         directly precede INNER (except for comments).

         COMPILER ACTION:  This INNER is skipped.


SIM137 E DECLARATION FOUND WHERE STATEMENT WAS EXPECTED

         USER ACTION:  Check that this is not caused by an error
         in a previous declaration.  This error may also be
         caused by a missing END earlier in the program.  (Use
         SIMED - see App.  L - to check the BEGIN-END nesting).


SIM140 E MISSING FOR-LIST



SIM141 E MISSING DO IN FOR-STATEMENT

         COMPILER ACTION:  Statement ignored.


SIM142 E ILLEGAL CONTROLLING VARIABLE

         EXPLANATION:  The controlling variable may not be of
         type TEXT, a remote or subscripted variable, or a
         function identifier.

         COMPILER ACTION:  Statement ignored.


SIM143 E MISSING CONNECTION BLOCK

         COMPILER ACTION:  Statement ignored.


SIM144 E ILLEGAL WHEN-CLAUSE

         EXPLANATION:  The syntax is:  WHEN <CLASS-identifier> DO

         COMPILER ACTION:  Clause is ignored.


SIM145 E MISSING DO IN WHILE-STATEMENT

         COMPILER ACTION:  Statement ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 120
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM146 E CANNOT FIND UNTIL

         COMPILER ACTION:  FOR list element skipped.


SIM147 E XXXX MISSING IN CONDITIONAL EXPRESSION

         EXPLANATION:  XXXX = THEN/ELSE.


SIM150 E NOCHECK PROCEDURES MUST NOT HAVE ANY EXPLICIT FORMAL
         PARAMETERS



SIM151 E MISSING IDENTIFIER AFTER XXXX

         EXPLANATION:  XXXX = NEW/THIS/ . /QUA.


SIM152 E CONDITIONAL EXPRESSION IS NOT ENCLOSED BY PARENTHESES

         COMPILER ACTION:  Parentheses assumed.


SIM153 E MISSING OPERAND



SIM154 E MISSING BINARY OPERATOR

         COMPILER ACTION:  Skip second operand.

         EXPLANATION:  Could be missing ;.


SIM155 E ILLEGAL EXTERNAL ITEM

         EXPLANATION:  Only CLASSes or PROCEDUREs may be
         external.


SIM156 E ERROR IN EXTERNAL ITEM

DECsystem-10 SIMULA Language Handbook, part II           Page 121
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM157 E BLOCK STACK OVERFLOW

         EXPLANATION:  Too deep nesting of blocks, PROCEDUREs,
         CLASSes and connections.

         USER ACTION:  Restructure program, for example by using
         recursive procedures instead of blocks within blocks.


SIM160 E XXXX PREVIOUSLY SPECIFIED

         EXPLANATION:  XXXX = identifier.

         COMPILER ACTION:  Specification ignored.


SIM161 E XXXX SPECIFIED BUT IS NOT FORMAL PARAMETER

         EXPLANATION:  XXXX = identifier.


SIM162 E FORMAL PARAMETER XXXX NOT SPECIFIED

         EXPLANATION:  XXXX = identifier.

         COMPILER ACTION:  Mode of formal is set to default.


SIM163 E FORMAL PARAMETER XXXX ILLEGALLY SPECIFIED

         EXPLANATION:  XXXX = identifier.


SIM164 E XXXX HAS MORE THAN 255 FORMAL PARAMETERS

         EXPLANATION:  XXXX = identifier.


SIM165 E XXXX HAS MORE THAN 255 VIRTUALS

         EXPLANATION:  XXXX = identifier.


SIM166 E TOO LARGE BLOCK LENGTH

         EXPLANATION:  See Chapter 6.1
DECsystem-10 SIMULA Language Handbook, part II           Page 122
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM167 E TOO MANY REDUCED SUBBLOCKS

         EXPLANATION:  See Chapter 6.1

         USER ACTION:  Divide large block at program, CLASS or
         PROCEDURE block level.


SIM170 E EXTERNAL MUST BE COPIED INTO MAIN

         EXPLANATION:  External declarations must not precede a
         main program.


SIM171 E EXTERNAL MUST NOT BE COPIED INDIRECTLY

         EXPLANATION:  This external declaration must precede the
         start of an external CLASS or PROCEDURE.


SIM172 E EXTERNAL MUST NOT BE ATTRIBUTE



SIM173 E XXXX HAS ILLEGAL FORTRAN SPECIFICATION



SIM174 E PPN IN EXTERNAL IDENTIFIER NOT OCTAL DIGIT



SIM175 E PPN IN EXTERNAL IDENTIFIER MORE THAN SIX DIGITS



SIM176 E CONFLICT BETWEEN SPECIFICATIONS

         EXPLANATION:  In the protection part there exists
         specification both with and without NOT.

         USER ACTION:  Change the specifications so that they
         have the same form.

         COMPILER ACTION:  The last specification is skipped.


DECsystem-10 SIMULA Language Handbook, part II           Page 123
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM177 E ENTRY NAME CONFLICT BETWEEN EXTERNALS XXXX AND XXXX

         EXPLANATION:  The externals have unfortunately been
         assigned the same entry point name by the compiler.

         USER ACTION:  Re-compile one of the externals after
         deleting the corresponding ATR-file.


SIM200 E EXTERNAL XXXX DECLARED TWICE

         EXPLANATION:  Externals must only be copied once into a
         main program.


SIM201 E DISPLAY SIZE OVERFLOW, TOO MANY BLOCK LEVELS

         EXPLANATION:  More than 30 block levels including FOR
         loops and inspection blocks.


SIM202 E ATTRBUTE XXXX IN PROTECTION LIST NOT FOUND



SIM240 T ?INVALID DEVICE, ONLY DSK IS ALLOWED

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM241 T ?COMMA MISSING IN PPN

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM242 T ?RIGHT SQUARE BRACKET MISSING IN PPN

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM243 T ?MORE THAN 6 DIGITS IN PPN

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM244 T ?= OR  MISSING IN COMMAND

         EXPLANATION:  See corresponding message in Appendix C.1.
DECsystem-10 SIMULA Language Handbook, part II           Page 124
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM245 T ?RIGHT PARENTHESIS MISSING IN SWITCH EXPRESSION

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM246 T ?LOOKUP ERROR IN COMMAND FILE

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM247 T ?CANNOT OPEN DISK

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM251 T ?SWITCH WITHOUT FILE SPECIFICATION, SWITCH IGNORED

         EXPLANATION:  See corresponding message in Appendix C.1.


SIM252 T ?TOO MANY SOURCE FILES

         EXPLANATION:  This error may occur if the user tries to
         concatenate more than six small source files, the sum of
         which does not exceed 135 characters.

         COMPILER ACTION:  The compilation is terminated after
         the fifth file.


SIM255 T ?IMPROPER ATR LIBRARY FORMAT - FILE AAAA

         EXPLANATION:  The first (possibly a following) block of
         the file is not an index block.

         USER ACTION:  Make an index to the file with FUDGE2 or
         MAKLIB, or substitute another ATR library.


SIM256 T ?FILE NOT FOUND OR DUPLICATE DECLARATION - AAAA

         EXPLANATION:  Source or attribute file not found.  This
         error message is also issued when the same EXTERNAL
         declaration is repeated more than once, so that the
         external module is multiply declared.

         COMPILER ACTION:  This is a terminating error.  No rel
         file is generated and the list file is only generated
         when a source file has been found.

         USER ACTION:  Search for duplicate EXTERNAL declarations
DECsystem-10 SIMULA Language Handbook, part II           Page 125
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


         in your source program.


SIM260 T ?CANNOT ENTER FILE *.TMP



SIM261 T ?INTERNAL I/O ERROR

         EXPLANATION:  Probable reasons are that another job on
         the same ppn has deleted or protected the compiler TMP
         files, or that no space is available on DSK:.  It could
         also be a system software or hardware error.


SIM264 T ?MORE THAN 3072 IDENTIFIERS

         USER ACTION:  Redeclare quantities where possible or
         split the program into separately compiled modules.


SIM265 T ?NO PROGRAM FOUND

         EXPLANATION:  Source file is not a SIMULA program.


SIM266 T ?NOT ENOUGH CORE PASS 1

         EXPLANATION:  Too many declarations found.

         USER ACTION:  Split into separetely compiled modules.


SIM267 T ?TYPE AND/OR KIND OF EXTERNAL XXXX DOES NOT MATCH

         USER ACTION:  Check if the correct ATR-file is used, and
         that the external declaration is correct.


SIM270 T ?NAME OF EXTERNAL XXXX DOES NOT MATCH

         USER ACTION:  Check if the correct ATR-file is used.


SIM271 T ?EXTERNAL XXXX COMPILED AT WRONG LEVEL, LEVEL SHOULD BE
         NNNN

         USER ACTION:  Re-compile EXTERNAL with value of /E
         switch as given in error message, or move declaration to
         another block level.
DECsystem-10 SIMULA Language Handbook, part II           Page 126
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM272 T ?EXTERNAL XXXX NOT FOUND IN ATR LIBRARY XXXX

         USER ACTION:  Make sure the library is correct.


SIM274 T ?FIXUP TABLE OVERFLOW

         EXPLANATION:  Not more than 4096 fixups can be allocated
         in a module.

         USER ACTION:  Split the module into several separately
         compiled modules.


SIM301 W INTERMEDIATE QUANTITIES SAVED IN SLOW MEMORY, EXPRESSION
         SHOULD BE SIMPLIFIED



SIM303 W IMPLICIT ARITHMETIC CONVERSION

         EXPLANATION:  A conversion between types INTEGER and
         LONG REAL is performed by a relatively slow subroutine
         in order not to lose precision.


SIM304 W INTEGER BASE CONVERTED TO REAL BEFORE EXPONENTIATION

         EXPLANATION:  This conversion is made to avoid run-time
         overflow when the result is larger than 2^35.  Integer
         precision may be lost if the base is larger than 134 258
         569.

         USER ACTION:  If you want to retain full integer
         precision then convert the base to LONG REAL before
         exponentiation.


SIM305 W IMPLICIT QUALIFICATION CHECK

         EXPLANATION:  Extra code has been emitted to check the
         qualification in a reference denotes statement or a
         parameter transmission.


SIM307 W EXPRESSION OR CONVERSION AFTER UNTIL

         EXPLANATION:  The quantity after UNTIL must be evaluated
         once for each repetition.
DECsystem-10 SIMULA Language Handbook, part II           Page 127
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM310 W STANDARD FUNCTION XXXX HAS ONLY SINGLE PRECISION

         EXPLANATION:  XXXX = function identifier.


SIM311 W CONNECTED LABEL OR SWITCH XXXX

         EXPLANATION:  The transfer to a connected label may
         cause unexpected effects.


SIM331 E QUALIFICATION XXXX IS NOT A CLASS

         EXPLANATION:  XXXX = identifier.


SIM332 E INVALID 2ND OPERAND KIND OF OPERATOR XXXX

         EXPLANATION:  XXXX = operator.


SIM333 E PREFIX XXXX IS NOT A CLASS

         EXPLANATION:  XXXX = identifier.


SIM334 E PREFIX XXXX IS NOT ON THIS BLOCK LEVEL

         EXPLANATION:  XXXX = identifier.


SIM335 E VIRTUAL MATCH TO XXXX HAS WRONG KIND

         EXPLANATION:  XXXX = identifier.


SIM336 E VIRTUAL MATCH TO XXXX HAS WRONG TYPE OR QUALIFICATION

         EXPLANATION:  XXXX = identifier.


SIM337 E INCORRECT NUMBER OF PARAMETERS TO XXXX

         EXPLANATION:  XXXX = identifier.
DECsystem-10 SIMULA Language Handbook, part II           Page 128
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM340 E DOUBLE DECLARATION OF XXXX

         EXPLANATION:  XXXX = identifier.


SIM341 E INCORRECT NUMBER OF SUBSCRIPTS TO XXXX

         EXPLANATION:  XXXX = identifier.


SIM342 E IDENTIFIER AFTER XXXX IS NOT A CLASS

         EXPLANATION:  XXXX = operator.


SIM343 E OPERAND OF ACTIVATE OR REACTIVATE IS NOT PROCESS



SIM344 E CONTROLLED VARIABLE OF TYPE TEXT IS NOT PERMITTED



SIM345 E INVALID LEFT HAND SIDE EXPRESSION TO OPERATOR XXXX

         EXPLANATION:  XXXX = :- or :=.


SIM346 E CONTROLLED VARIABLE XXXX IS OF NAME MODE

         EXPLANATION:  XXXX = identifier.


SIM347 E STANDARD (OR "QUICK") FUNCTION OR PROCEDURE XXXX CANNOT
         BE PASSED AS AN ACTUAL PARAMETER

         EXPLANATION:  XXXX = procedure name.


SIM350 E NON-ARITHMETIC SUBSCRIPT TO ARRAY XXXX

         EXPLANATION:  XXXX = ARRAY identifier.


SIM351 E PARAMETERS OR SUBSCRIPTS TO XXXX OMITTED

         EXPLANATION:  XXXX = identifier.
DECsystem-10 SIMULA Language Handbook, part II           Page 129
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM352 E THIS XXXX IS NOT A VALID LOCAL OBJECT, CLASS HAS BEEN
         USED AS BLOCK PREFIX

         EXPLANATION:  XXXX = identifier.


SIM353 E THIS XXXX IS NOT A VALID LOCAL OBJECT, NO ENCLOSING
         INSTANCE

         EXPLANATION:  XXXX = identifier.


SIM354 E BRACKETS AFTER XXXX SHOULD BE PARENTHESES

         EXPLANATION:  The identifier XXXX is a function or
         PROCEDURE, not a SWITCH or an ARRAY.


SIM355 E SIMPLE QUANTITY XXXX IS USED AS ARRAY, FUNCTION OR
         SWITCH

         EXPLANATION:  XXXX = identifier.


SIM356 E RESULT OVERFLOW OR DIVISION BY ZERO IN CONSTANT
         EXPRESSION



SIM357 E INCOMPATIBLE OPERAND TYPES OF OPERATOR XXXX

         EXPLANATION:  XXXX = operator.


SIM360 E INVALID OPERAND TYPE OF OPERATOR XXXX

         EXPLANATION:  XXXX = operator.


SIM361 E INVALID REMOTE ACCESS, CLASS XXXX HAS LOCAL CLASS
         ATTRIBUTES

         EXPLANATION:  XXXX = identifier.


SIM362 E IDENTIFIER XXXX IS NOT DECLARED

         EXPLANATION:  XXXX = identifier.
DECsystem-10 SIMULA Language Handbook, part II           Page 130
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM363 E INCOMPATIBLE QUALIFICATIONS XXXX AND XXXX TO OPERATOR
         XXXX

         EXPLANATION:  XXXX = identifier,identifier and operator,
         respectively.


SIM364 E OPERAND OF UNTIL IS NOT SIMPLE



SIM365 E INVALID OPERAND KIND OF OPERATOR XXXX

         EXPLANATION:  XXXX = operator.


SIM366 E TEXT CONSTANT IS NOT A VALID ACTUAL PARAMETER FOR
         REFERENCE MODE FORMAL XXXX OF XXXX

         EXPLANATION:  XXXX = identifier,identifier.

         USER ACTION:  Declare the formal parameter as NAME (if
         only used a few times) or VALUE (if used many times).


SIM367 E INVALID ACTUAL PARAMETER KIND CORRESPONDING TO FORMAL
         PARAMETER XXXX OF XXXX

         EXPLANATION:  XXXX = identifier.


SIM370 E INVALID ACTUAL PARAMETER TYPE CORRESPONDING TO FORMAL
         PARAMETER XXXX OF XXXX

         EXPLANATION:  XXXX = identifier,identifier.

SIM371 E EXPRESSION IS NOT A VALID STATEMENT

         EXPLANATION:  The expression is not a procedure call or
         an object generator, which are the only expressions
         allowed at statement level.


SIM372 E BLOCK TOO LARGE

DECsystem-10 SIMULA Language Handbook, part II           Page 131
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM373 E EXPRESSION TOO COMPLICATED



SIM374 E CANNOT SAVE INTERMEDIATE QUANTITIES, EXPRESSION TOO
         COMPLICATED



SIM375 E DETACH NOT ON OUTERMOST LEVEL IN CLASS



SIM376 E OPERAND SUCCEEDING BEFORE/AFTER NOT QUALIFIED AS PROCESS



SIM377 E CHAR PARAMETER ERROR

         EXPLANATION:  The parameter is a constant outside the
         range [0,127].


SIM400 E PREFIX XXXX TO XXXX IS NOT PREVIOUSLY DECLARED OR IS
         REDEFINED LATER

         EXPLANATION:  A prefix CLASS must be declared before its
         subclass.


SIM401 E INVALID REMOTE ACCESS, XXXX IS NOT AN ATTRIBUTE OF XXXX

         EXPLANATION:  The attribute XXXX does not exist in the
         CLASS qualifying the expression before the dot.


SIM402 E INCOMPATIBLE QUALIFICATION OF PARAMETER CORRESPONDING TO
         FORMAL XXXX OF XXXX

         EXPLANATION:  XXXX = identifier,identifier.


SIM403 E INVALID ACTUAL PARAMETER MODE CORRESPONDING TO FORMAL
         PARAMETER XXXX OF XXXX

         EXPLANATION:  A name mode parameter must not be passed
         to random drawing procedures or ACCUM as a parameter on
         which side effects may occur.
DECsystem-10 SIMULA Language Handbook, part II           Page 132
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM404 E ILLEGAL EXPRESSION AS ACTUAL PARAMETER CORRESPONDING TO
         FORMAL PARAMETER XXXX OF XXXX

         EXPLANATION:  XXXX = identifier,identifier.


SIM405 E PREFIX CLASS HAS LOCAL OBJECT

         EXPLANATION:  A class, say CLASS C, which contains a
         reference like "THIS C" (=local object) cannot be used
         as a prefix, since the prefixed block is NOT a C object,
         implying that "THIS C" would be an error.  To avoid the
         necessity of run-time checks for this, using the class
         as prefix to a block is disallowed.


SIM406 E CONSTANT BEFORE DOT



SIM407 E INVALID ACCESS OF EXTERNAL XXXX FROM XXXX

         EXPLANATION:  Either the first EXTERNAL is invisible,
         not declared or mixed with another EXTERNAL with the
         same name, or the second EXTERNAL needs re-compilation.

         EXAMPLE:  An EXTERNAL can become invisible, if it is
         superseded by a local identifier in your program with
         the same identifier.  This local identifier can also be
         in another separately compiled module which you are also
         using.


SIM410 E CONNECTED PREFIX

         EXPLANATION:  A class which has become visible via
         inspection cannot be used as prefix.  Use block
         prefixing (C BEGIN ...) instead of INSPECT .., if
         possible.


SIM411 E CONNECTED QUANTITY HAS NO QUALIFICATION



SIM412 E DISPLAY SIZE OVERFLOW, TOO MANY LEVELS OR PARAMETER
         NESTINGS

         EXPLANATION:  More than 30 block levels including FOR
         loops, inspection blocks and thunk save areas used for
         certain parameters passed by name.
DECsystem-10 SIMULA Language Handbook, part II           Page 133
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM413 E TEXT STRING AFTER DENOTES



SIM414 E LOCAL QUANTITY IN ARRAY DECLARATION



SIM415 E PROGRAM TOO LARGE, CAPACITY LIMIT EXCEEDED

         EXPLANATION:  At least one of the five code streams
         generated in PASS 2 exceeds 32767 words.

         USER ACTION:  Try separate compilation!


SIM416 E TOO MANY ACCUMULATORS NNNN NEEDED FOR PARAMETERS

         EXPLANATION:  A "QUICK" MACRO-10 procedure requires its
         parameters in consecutive accumulators.  Only 10
         accumulators are available for this purpose.

         USER ACTION:  Do not use name mode unnecessarily.  Two
         ac's are required for each name mode parameter.  Place
         more information in some parameters.


SIM417 E TOO COMPLICATED ACTUAL PARAMETER CORRESPONDING TO FORMAL
         PARAMETER XXXX OF "QUICK" PROCEDURE XXXX

         EXPLANATION:  The actual parameter corresponding to a
         name mode formal parameter of a "QUICK" procedure may
         not have a thunk, which means that expressions,
         procedures, labels and switches are disallowed.  Note
         that this only applies to name mode.

         USER ACTION:  Compute the expression, if possible, to a
         variable and pass this instead.  Otherwise change the
         specifications of the procedure.  Note that "CODE" (not
         "QUICK") procedures permit any valid parameters
         according to the SIMULA definition, at the expense of
         the overhead incurred with a general procedure call.


SIM420 E ACTUAL/FORMAL TYPE MISMATCH FOR PARAMETER XXXX OF
         "QUICK" PROCEDURE XXXX

         EXPLANATION:  In name mode, the type of an actual
         parameter to a "QUICK" procedure must be identical to
         the formal type.
DECsystem-10 SIMULA Language Handbook, part II           Page 134
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


         USER ACTION:  Copy the actual parameter to a variable
         with the correct type and use the variable as parameter.
         If side effects are wanted, copy back the value after
         the call.


SIM421 E ATTRIBUTE XXXX HIDDEN BUT NOT PROTECTED



SIM422 E NO ATTRIBUTE XXXX VISIBLE



SIM423 E NEW XXXX IS AN ILLEGAL OBJECT GENERATOR

         EXPLANATION:  See this handbook section 4.1.  SIMSET,
         SIMULATION and their subclasses cannot occur after NEW,
         only as prefix.


SIM424 E ILLEGAL VIRTUAL SPECIFICATION OF XXXX

         EXPLANATION:  Either there are two virtual
         specifications of the same identifier visible
         simultaneously or a formal parameter is specified
         virtual.


SIM425 E VIRTUAL MATCH XXXX MUST NOT BE PROTECTED

         EXPLANATION:  The virtual match inherits the protection
         mode of the virtual specification.

         USER ACTION:  Remove the illegal protection.


SIM426 E ILLEGAL USE OF TEXT VALUE CONSTANT



SIM461 T ?STACK OVERFLOW, STATEMENT TOO COMPLICATED



SIM462 T ?CORE FAILURE, PROGRAM HAS TOO MANY DECLARATIONS AND
         INSPECTIONS FOR THE AVAILABLE MEMORY

         USER ACTION:  Split the program into separately compiled
         modules.
DECsystem-10 SIMULA Language Handbook, part II           Page 135
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM463 T TOO COMPLICATED PROGRAM STRUCTURE

         EXPLANATION:  The compiler ran out of "fixups".
         Probably too many branches in a conditional expression
         (or statement).

         USER ACTION:  Try splitting conditional expression into
         several conditional statements.


SIM467 T ?STACK UNDERFLOW



SIM530 E INTERNAL ERROR:  NON-EXISTENT ERROR NUMBER

         EXPLANATION:  Error should never occur.  The wrong
         version of SIMDDT may be in use, or SIMDDT needs
         updating.

         USER ACTION:  Call a systems programmer.


SIM560 T ?NOT ENOUGH CORE PASS 3

         EXPLANATION:  Not enough core to create line number
         table for listing, cross reference listing or attribute
         file.


SIM561 T ?UNRECOVERABLE ERRORS

         EXPLANATION:  Too many severe errors of type termination
         have occurred.

         USER ACTION:  Contact a systems programmer.


SIM566 T ?INTERNAL ERROR:  STACK UNDERFLOW PASS AAAA

         EXPLANATION:  Same number in all three passes.  This
         message should never occur.  AAAA is pass number.

         USER ACTION:  Contact a systems programmer.
DECsystem-10 SIMULA Language Handbook, part II           Page 136
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM567 T ?  STACK OVERFLOW PASS AAAA

         EXPLANATION:  AAAA is pass number.  A capacity
         restriction has been violated.  Stack overflow pass 3 is
         often caused by too many BEGINs placed after each other
         without any closing ENDs.  The error may also be an
         internal error.

         USER ACTION:  See SIM157.


SIM570 T ?OPEN ERROR ON FILE AAAA

         EXPLANATION:  This may occur if the file is protected.
         AAAA is the name of the file.  This error may have
         occurred in any of the three passes.  The error may also
         be an internal compiler or system failure.

         USER ACTION:  Check protection and recompile program.


SIM571 T ?LOOKUP ERROR ON FILE AAAA

         EXPLANATION:  This may occur if the file is protected.
         AAAA is the name of the file.  This error may have
         occurred in any of the three passes.  The error may also
         be an internal compiler or system failure.

         USER ACTION:  Check protection and recompile program.


SIM572 T ?ENTER ERROR ON FILE AAAA

         EXPLANATION:  This may occur if the file is protected.
         AAAA is the name of the file.  This error may have
         occurred in any of the three passes.  Another
         explanation may be that no space is available because
         you are exceeding your disk quota.  The error may also
         be an internal compiler or system failure.

         USER ACTION:  Check protection and recompile program.


SIM573 T ?INPUT ERROR ON FILE AAAA

         EXPLANATION:  This may occur if the file is protected.
         AAAA is the name of the file.  This error may have
         occurred in any of the three passes.  The error may also
         be an internal compiler or system failure.

         USER ACTION:  Check protection and recompile program.
DECsystem-10 SIMULA Language Handbook, part II           Page 137
APPENDIX C.2 COMPILER SOURCE CODE DIAGNOSTICS


SIM574 T ?OUTPUT ERROR ON FILE AAAA

         EXPLANATION:  This may occur if the file is protected.
         AAAA is the name of the file.  This error may have
         occurred in any of the three passes.  The error may also
         be an internal compiler or system failure.

         USER ACTION:  Check protection and recompile program.


SIM575 T ?CLOSE ERROR ON FILE AAAA

         EXPLANATION:  This may occur if the file is protected.
         AAAA is the name of the file.  This error may have
         occurred in any of the three passes.  The error may also
         be an internal compiler or system failure.

         USER ACTION:  Check protection and recompile program.
         2,f,g
DECsystem-10 SIMULA Language Handbook, part II           Page 138
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS
=========================================


D.1  DIALOGUE MESSAGES


     These messages are printed by the I/O subsystem of the RTS.
     Some of them start a dialogue with the user and some are
     only warnings.  A few messages also terminate execution.
     The messages are unnumbered.

     You can transfer from the i/o error dialogue to SIMDDT by
     pushing the ALTMODE (ESCAPE) button on your terminal.


?APPEND OR RONLY EXPECTED AFTER ACCESS

     EXPLANATION:  ACCESS switch must be followed by :APPEND or
     :RONLY

     RTS ACTION:  The user is asked in dialoque to enter a new
     file definition.


?CANNOT OPEN:  device

     EXPLANATION:  Device specified for SYSIN or SYSOUT not
     defined.

     USER ACTION:  Retype correct device.


?CANNOT OPEN DSK

     EXPLANATION:  OPEN failed for a disk-like device.

     RTS ACTION:  EXIT to monitor.


CANNOT DO INPUT FROM DEVICE:  devicename
CANNOT DO OUTPUT TO DEVICE:  devicename

     EXPLANATION:  Illegal file class type - device type
     combination.

     USER ACTION:  Retype correct device.
DECsystem-10 SIMULA Language Handbook, part II           Page 139
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


CANNOT SWITCH DEVICE AT THIS STAGE

     EXPLANATION:  This message is printed if the user tries to
     change a directory device (i.e.  DECtape or disk) after a
     LOOKUP or ENTER error.  It is only possible to switch
     between disk devices, e.g.  from DSKB to DSKD, or between
     DECtapes.

     USER ACTION:  Retype correct device.


?CLOSE ERROR ON:  filename

     EXPLANATION:  CLOSE error on specification file.

     RTS ACTION:  EXIT to monitor.


CLOSE ERROR ON SIMRTS.HLP

     RTS ACTION:  HELP switch ignored.


?CORE NOT AVAILABLE

     EXPLANATION:  RTS tried to allocate core according to the
     file definitions and switches in the specification file, but
     this core request could not be met by the monitor.

     RTS ACTION:  EXIT to monitor.


?DEVICE devicename ILLEGAL

     EXPLANATION:  Devicename does not exist.

     USER ACTION:  Retype correct device name.


?FILE filename NOT FOUND

     EXPLANATION:  LOOKUP failure on specification file.

     RTS ACTION:  RTS reads new file descriptor from TTY.

     USER ACTION:  Retype file descriptor.
DECsystem-10 SIMULA Language Handbook, part II           Page 140
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


HELP SWITCH MISPLACED.  IGNORED

     EXPLANATION:  The HELP switch is relevant only when file
     definitions are read from TTY.  HELP is also ignored in file
     parameters.


I SWITCH IGNORED.  FILE:  logicalname IS NOT DIRECTFILE

     EXPLANATION:  This is a warning message.  IMAGESIZE is
     relevant for directfiles only.


ILL DELIM AFTER LAST SWITCH

     EXPLANATION:  Valid delimiter after a run-time switch is
     either space or carriage return.

     RTS ACTION:  This is just a warning message.


?ILL DELIM AFTER LOGICAL NAME

     EXPLANATION:  Delimiter after logical name must be space,
     tab or carriage return.

     USER ACTION:  Retype file definition.


?ILLEGAL DELIMITER:  "byte" IN FILE DESCRIPTOR

     EXPLANATION:  Valid delimiters after a file descriptor are
     carriage return, space, tab or slash.

     USER ACTION:  Retype file definition.


?ILLEGAL PPN

     EXPLANATION:  Right square bracket missing or ppn contains a
     digit > 7.

     USER ACTION:  Retype correct ppn.
DECsystem-10 SIMULA Language Handbook, part II           Page 141
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


?ILLEGAL PROTECTION CODE

     EXPLANATION:  Right angle bracket missing or protection code
     contains a digit > 7.

     USER ACTION:  Retype correct protection code.


?ILL FILE DESC.  ENTER NEW FILE DESC

     EXPLANATION:  Illegal file descriptor was typed after LOOKUP
     or ENTER error.

     USER ACTION:  Retype correct file descriptor.


?ILL FILE DESCRIPTOR IN FILE PARAMETER

     EXPLANATION:  The file descriptor in the parameter to NEW
     ...FILE("...") is illegal.  This message is normally
     preceded by one or more messages specifying the error(s).

     USER ACTION:  Retype file class argument including logical
     name.


IND SPEC FILE NOT FOUND

     EXPLANATION:  LOOKUP error on indirect specification file.

     USER ACTION:  Retype file descriptor for indirect
     specification file.


L SWITCH IGNORED.  FILE:  logical name IS NOT AN OUTFILE OR
     PRINTFILE

     EXPLANATION:  LIMIT is not relevant for infile and
     directfile.


LOCAL SWITCH:  switch USED AS GLOBAL.  IGNORED
DECsystem-10 SIMULA Language Handbook, part II           Page 142
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


LOGICAL NAME:  logical name ALREADY DEFINED

     EXPLANATION:  This message is printed in connection with the
     SIMDDT USE command.  A USE file may not exist when the USE
     command is given.

     RTS ACTION:  Retype the USE command.


LOGICAL NAME:  logical name ALREADY DEFINED.  IGNORED

     EXPLANATION:  Logical names must be unique in the
     specification file.

     RTS ACTION:  The file definition is ignored.


LOOKUP FAILURE ON SIMRTS.HLP

     RTS ACTION:  HELP switch ignored.


?LOOKUP OR ENTER ERROR (nnn) ON FILE:  file specification

     EXPLANATION:  The code nnn indicates the type of error.  The
     following codes are used:
     000  File not found
     010  User file directory does not exist on current file
          structure, usually incorrect ppn.
     020  Protection failure or directory full on DECtape
     003  File being modified
     014  Disk quota exceeded
     015  Write-lock error
     016  Not enough table space in monitor
     017  Partial allocation only.  The requested space
     allocation
          could not be met.
     021  Cannot supersede an existing directory
     023  Sub-directory not found.

     Other error codes usually indicate internal RTS error.

     The file specification contains the information which is
     currently known about the file.  Empty fields indicate
     standard value.

     USER ACTION:  Retype file descriptor (no logical name!)
DECsystem-10 SIMULA Language Handbook, part II           Page 143
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


NESTED IND FILES NOT ALLOWED.  IGNORED

     EXPLANATION:  An indirect specification file contains a
     specification file definition.


?NULL ARG AFTER SWITCH:  switch

     EXPLANATION:  Argument after colon is either 0 or missing.

     USER ACTION:  Retype the entire file definition.


ONLY DSK ALLOWED

     EXPLANATION:  Device can only be disk after retyping the
     definition of a specification file.

     RTS ACTION:  DSK assumed.


?PROJ NO NOT FOLLOWED BY COMMA

     USER ACTION:  Retype file definition.


?PROT CODE EXCEEDS THREE DIGITS

     USER ACTION:  Retype file definition.


?READ ERROR ON:  filename

     EXPLANATION:  Read error occurred on a specification file.

     RTS ACTION:  EXIT to monitor.


?READ ERROR ON SIMRTS.HLP

     RTS ACTION:  HELP switch ignored.


SPEC FILE STILL OPEN AS SYSIN.  LINE IGNORED

     EXPLANATION:  When SYSIN is used as indirect specification
     file, no more indirect files are allowed.
DECsystem-10 SIMULA Language Handbook, part II           Page 144
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


SWITCH:  switch MISSPELLED

     RTS ACTION:  Switch processed according to first letter.


SWITCH:  switch NOT FOLLOWED BY COLON

     EXPLANATION:  All run-time switches except HELP must be
     followed by colon and an argument.

     USER ACTION:  Retype file definition.


SWITCH:  switch NOT FOLLOWED BY DECIMAL NUMBER

     USER ACTION:  Retype file definition.


SWITCH:  switch NOT RECOGNIZED

     EXPLANATION:  First letter of the switch not a legal switch
     name.

     USER ACTION:  Retype file definition.


SYSIN ALREADY READ.  LINE IGNORED

     EXPLANATION:  File definitions can be read from SYSIN only
     once.


?TOO DEEP SFD NESTING

     EXPLANATION:  The maximum number of sub-file directories (an
     installation defined parameter) is exceeded.

     USER ACTION:  Retype the file definition.


?TTY END OF FILE OR TTY INPUT ERROR

     EXPLANATION:  The user has typed a ^Z or an input error was
     detected.

     RTS ACTION:  EXIT to monitor, i.e.  ^Z works as ^C.  A
     CONTINUE command, if given, will cause a final EXIT from the
     program, i e  execution cannot then be continued any more.

     USER ACTION:  Use ^C instead of ^Z.  It is then possible to
     resume execution with the CONTINUE command.
DECsystem-10 SIMULA Language Handbook, part II           Page 145
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


WARNING:  APPEND MODE IGNORED FOR DIRECTFILE
WARNING:  APPEND MODE IGNORED FOR INFILE
WARNING:  APPEND MODE IGNORED FOR NON-DISK DEVICES

     EXPLANATION:  Append mode is valid only for printfiles and
     outfiles on disk.


WARNING:  DEVICE NOT DSK FOR DIRECTFILE.  DSK ASSUMED.

     EXPLANATION:   Device can only be disk for directfile.


WARNING:  DEVICE NOT DSK FOR SPECIFICATION FILE.  DSK ASSUMED.

     EXPLANATION:  Specification files can only be read from disk
     or TTY.

     RTS ACTION:  RTS tries to lookup the file on DSK.


WARNING:  FILES MUST BE A GLOBAL SWITCH.  FILES IGNORED


WARNING:  NO SWITCH NAME FOUND.  IGNORED

     EXPLANATION:  Slash is followed by slash, space, tab or
     carriage return.


WARNING:  PROJ OR PROG NUMBER TRUNCATED

     EXPLANATION:  Project or programmer number exceeds 6 digits.

     RTS ACTION:  Only the first 6 digits are used.


WARNING:  SFD IGNORED

     EXPLANATION:  Sub-file directories cannot be used for
     specification files.


WARNING:  SWITCHES IGNORED

     EXPLANATION:   Switches do not apply to definitions of a
     specification file.
DECsystem-10 SIMULA Language Handbook, part II           Page 146
APPENDIX D RUN-TIME AND DEBUG DIAGNOSTICS


WARNING:  TOO MANY BUFFERS FOR FILE:  logical name.  2 STANDARD
     BUFFERS ASSUMED

     EXPLANATION:  A value greater than 32 of the BUFFER switch
     argument is applicable to magnetic tape only.  
DECsystem-10 SIMULA Language Handbook, part II           Page 147
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


D.2 RUN-TIME AND DEBUG DIAGNOSTICS:


         The messages starting with ZYQ apply to the run time
         system (RTS), except for SIMDDT, which has its own
         messages starting with ZYD.  A few of the ZYQ messages
         may be issued by SIMDDT, with ZYQ changed to ZYD.  The
         RTS action on any of the ZYQ errors is to invoke SIMDDT
         in error mode.  SIMDDT prints the error message and
         indicates where the error occurred.  Commands can be
         entered to SIMDDT to find out more information about
         variables, state of execution etc.  By the EXIT command
         to SIMDDT, files are closed and the SIMULA program is
         terminated.  If you do not want to close files, exit via
         ^C.


         For some of the ZYQ messages it is possible to continue
         execution of the SIMULA program with the SIMDDT command
         "PROCEED".  Note that SIMDDT may be used to investigate
         the cause of the error before the execution is
         continued.


         In addition to the numbered messages, the following
         messages may appear on the TTY or the batch log:

[ZYQCCS Current SIMDDT command suppressed]

         EXPLANATION:  REENTER was issued while SIMDDT was
         active.  This is a way of suppressing lengthy output
         resulting from a SIMDDT command and to return to SIMDDT
         command level as quickly as possible.  Preferred to
         using ^O, which only suppresses the actual output, but
         does not stop the command execution.


[ZYQCSH Cannot stop here]

         EXPLANATION:  REENTER was attempted at a point where
         SIMDDT cannot be called because data may not be
         consistent.

         USER ACTION:  Try again to stop and reenter.


%ZYQCUF CORE UUO failed.  Cannot load SIMDDT

         EXPLANATION:  The program is too big to allow for
         SIMDDT.
DECsystem-10 SIMULA Language Handbook, part II           Page 148
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


%ZYQEDO nn EDIT OVERFLOW(S)

         EXPLANATION:  In nn cases, the field width in an output
         editing operation, e g PUTREAL, was too small to hold
         the number.  Asterisks were edited into the field.

         USER ACTION:  Examine output fields for asterisks.
         Correct the program.


[ZYQEIR Error in routine:  XXXXXX]

         EXPLANATION:  An error has occurred in a subroutine such
         as SQRT taken from the FORTRAN library.  XXXXXX should
         be the name of the entry point of the routine.

         A subsequent ZYQ message issued by SIMDDT gives more
         information.  Some library routines have inline messages
         for errors.  Such a message will be typed following the
         above message.


%ZYQFLE <text>

         EXPLANATION:  An error has occurred in a subroutine such
         as SQRT taken from the FORTRAN library.  <text> is a
         string provided by the subroutine.  This message is
         preceded by a ZYQEIR message.


%ZYQIUF IN UUO failed.  Cannot load SIMDDT

         EXPLANATION:  Probably a DECsystem-10 error.  Consult a
         systems programmer.


%ZYQLUF LOOKUP UUO failed.  Cannot load SIMDDT

         EXPLANATION:  SIMDDT.ABS is not available on the device
         (normally SYS), or a system error has occurred.  Consult
         a systems programmer.


?ZYQNCA No core available - can not proceed

         EXPLANATION:  The program cannot run with too small core
         size.

         USER ACTION:  If possible, allocate more core (virtual
         and/or physical) and try again.
DECsystem-10 SIMULA Language Handbook, part II           Page 149
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


%ZYQNEC Not enough core.  Cannot load SIMDDT

         EXPLANATION:  The program is too big to allow for
         SIMDDT.

         USER ACTION:  See ZYQNCA.

         RTS ACTION:   The program continues without SIMDDT.


%ZYQNIO No free I/O channel.  Cannot load SIMDDT

         EXPLANATION:  Probably a SIMULA system or user error.
         If an external MACRO-10 procedure is doing I/O, check
         it.  Consult a systems programmer if the error cannot be
         located.


[ZYQNYI RTS not yet initialised, continuing ...]

         EXPLANATION:  REENTER was used too early after program
         start.  Try later.


%ZYQOUF OPEN UUO failed.  Cannot load SIMDDT

         EXPLANATION:  Probably a DECsystem-10 error.  Consult a
         systems programmer.


[ZYQPID Please input a line of data so SIMDDT can be entered]

         EXPLANATION:  The program was interrupted by ^C while
         waiting for input from the terminal.  SIMDDT cannot be
         entered until Inimage has returned with a line of data.
         The data given should be valid input to the program.
         Usually, hitting carriage return will do (a blank line).


?ZYQREZ SIMULA RTS Error ZYQnnn

         EXPLANATION:  Since SIMDDT could not be loaded, the
         proper error message could not be issued.  Look up the
         message ZYQnnn in this handbook.


%ZYQSFS STOP statement executed or EXIT called in FORTRAN
         subprogram

         EXPLANATION:  An external FORTRAN subroutine attempted
         to stop execution by a STOP statement or CALL EXIT.
DECsystem-10 SIMULA Language Handbook, part II           Page 150
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         Handled as if control had passed through the final END
         of the SIMULA main program.


%ZYQUFL nn UNDERFLOW(S)

         EXPLANATION:  In nn cases, an arithmetic operation has
         given a result too small to be normalized.  Zero was
         substituted as result.


The following messages are issued by SIMDDT:


ZYQ001   Source program error

         EXPLANATION:  An incorrect part of the source program
         has been compiled as an error UUO.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  The execution continues with the next
         compiled statement.  The effect of continuing execution
         is unpredictable except in very simple cases.


ZYQ002   Array index out of bounds


ZYQ003   QUA error

         EXPLANATION:  In an expression of the form "X QUA C", X
         does not refer to a C object or an object belonging to a
         subclass of C.


ZYQ004   Illegal denotes or wrong parameter qualification

         EXPLANATION:  See explanation for ZYQ003.  ZYQ004
         results from an implicit QUA check generated for a
         denotes (:-) statement or when a REF(...) parameter is
         passed to a class or procedure.
DECsystem-10 SIMULA Language Handbook, part II           Page 151
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ005   No match for virtual quantity

         EXPLANATION:  The quantity (procedure, switch or label)
         was specified virtual, but no matching declaration is
         available at any prefix level of the class object to
         which the quantity should belong, i e the current class,
         prefixed block, inspection block or the class object
         referred to by the quantity before the dot in case of
         remote access.


ZYQ006   CHAR argument out of bounds

         EXPLANATION:  Argument must be >= 0 and <=127.


         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ007   Wrong number of subscripts

         EXPLANATION:  A formal array was used with wrong number
         of subscripts.


ZYQ010   OCERC   0,Too many files

         EXPLANATION:  At most 14 files can be active at the same
         time.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  When the execution is resumed RTS will
DECsystem-10 SIMULA Language Handbook, part II           Page 152
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         again try to assign a free I/O channel.

         USER ACTION:  The user must close one or more files with
         the SIMDDT command CLOSE before the PROCEED command is
         used.


ZYQ011   OCERR   1,Pushdown list underflow

         EXPLANATION:  Should not occur.  Wild jumps may have
         been executed as a result of removing the checking of
         array subscripts (-A) or qualification (-Q), or an
         external MACRO-10 or FORTRAN procedure may have run
         wild.

         USER ACTION:  If none of the above applies, report the
         error.


ZYQ012   OCERC   12,SIMDDT entered after file spec error

         EXPLANATION:  This error occurs when the user escapes
         the dialogue with altmode.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  If the user types PROCEED the dialogue is
         restarted.


ZYQ013   OCERR   3,OPEN failure

         EXPLANATION:  Failure when trying to OPEN the channel
         for SYSIN or SYSOUT.


ZYQ014   OCERR   4,FILE(S) OPEN AT EXIT.  DO [STOP] CLOSE OR EXIT

         EXPLANATION:  At end of execution some files other than
         SYSIN and SYSOUT were open.

         USER ACTION:  Use the [STOP] CLOSE command in SIMDDT to
         close all or some of files.
DECsystem-10 SIMULA Language Handbook, part II           Page 153
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ015   OCERR   5,Object NONE

         EXPLANATION:  An attempt was made to refer to an
         attribute of a non-existent class object (or to a not
         yet allocated array object).


ZYQ016   OCERR   6,Illegal memory reference

         EXPLANATION:  Probably a SIMULA system error or a user
         error in an external MACRO-10 or FORTRAN procedure.  It
         may also be a user error in the SIMULA program or an
         external SIMULA procedure or class, if compile-time
         checking was partially turned off (-A or -Q switches).
         If so, try running with those checks on.  If the error
         persists, check any external MACRO 10 or FORTRAN
         procedure for errors before reporting the trouble.


ZYQ017   OCERC   7,Integer overflow or division by zero

         EXPLANATION:  An arithmetic operation has exceeded the
         valid number range, or attempted to divide by zero.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.  The
         operation will return maxint = 2^35-1.


ZYQ020   OCERC   10,Floating point overflow or division by zero

         EXPLANATION:  A floating point operation gives a result
         outside of the available number range, or division by
         zero is attempted.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.  The
         operation will return maxreal = approx 1.7&38.
DECsystem-10 SIMULA Language Handbook, part II           Page 154
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ021   CPERC   0,RESUME:  object NONE

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.


ZYQ022   CPERC   1,RESUME:  terminated class instance

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.


ZYQ023   CPERC   2,RESUME:  attached class instance

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.


ZYQ024   CPERR   3,RESUME:  operating class instance


ZYQ025   CPERC   4,CALL:  object NONE

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.


ZYQ026   CPERC   5,CALL:  terminated class instance

         SIMDDT ACTION:  The error message is followed by the
         text:
DECsystem-10 SIMULA Language Handbook, part II           Page 155
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.


ZYQ027   CPERC   6,CALL:  attached class instance

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.


ZYQ030   CPERR   7,CALL:  operating class instance


ZYQ036   CSERR   1,Undefined GOTO

         EXPLANATION:  The target of the GOTO statement is not
         operating.


ZYQ037   CSERR   2,Illegal GOTO

         EXPLANATION:  Attempt to leave a detached class instance
         by a GOTO.


ZYQ040   CSERR   3,Too big array

         EXPLANATION:  The size of the array would be > 2^18
         words.


ZYQ041   CSERR   4,Upper bound of array < lower bound



ZYQ042   CSERR   5,Cannot use switch in terminated class

         EXPLANATION:  Cannot use a switch in a terminated class
         instance.
DECsystem-10 SIMULA Language Handbook, part II           Page 156
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ043   CSERR   6,Procedure should have no parameters

         EXPLANATION:  Attempt to call a parameterless formal or
         virtual procedure with an actual parameter list.


ZYQ044   CSERR   7,Parameters missing

         EXPLANATION:  Attempt to call a formal or virtual
         procedure with specified parameters without supplying an
         actual parameter list.


ZYQ051   IOERR   0,File not open

         EXPLANATION:  File not opened when (a) OUTIMAGE, OUTTEXT
         or another output procedure was called.  (b) LOCATE was
         called.


ZYQ052   IOERR   1,OPEN failure

         EXPLANATION:
         a) The requested device is in use and cannot be shared
         b) The requested device does not exist
         c) The device is restricted and has not been assigned
         via a MOUNT command.


ZYQ053   IOERR   2,File already assigned to TTY

         EXPLANATION:  Only one file may be assigned to the
         output or the input side of the TTY.


ZYQ054   IOERR   3,Transfer failure

         EXPLANATION:  A read or write operation failure.


ZYQ055   IOERC   4,File already open

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  The OPEN call is ignored after PROCEED.
DECsystem-10 SIMULA Language Handbook, part II           Page 157
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ056   IOERC   5,File already closed

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  The CLOSE call is ignored after PROCEED.


ZYQ057   IOERC   6,CLOSE failure

         EXPLANATION:  Write operation failure in CLOSE
         procedure.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  The CLOSE call is ignored after PROCEED.


ZYQ060   IOERR   7,EOF in INIMAGE

         EXPLANATION:  ENDFILE procedure returned TRUE when
         INIMAGE was called.


ZYQ061   IOERR   10,External image too long

         EXPLANATION:  The external image (string of characters
         finished by LF, FF, VT, or altmode) cannot fit into the
         image text.


ZYQ062   IOERR   11,Image too large

         EXPLANATION:  The internal image is too long for
         imagesize of a directfile.
DECsystem-10 SIMULA Language Handbook, part II           Page 158
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ063   IOERC   12,EJECT:  argument out of range

         EXPLANATION:  The argument to EJECT is <= 0.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ064   IOERC   13,SPACING:  argument out of range

         EXPLANATION:  The argument to SPACING is < 0 or >
         LINESPERPAGE.


         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ065   IOERC   14,Output field width out of range

         EXPLANATION:  For an output editing procedure, the
         requested field width is negative or zero or does not
         fit into an output image.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED
DECsystem-10 SIMULA Language Handbook, part II           Page 159
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ066   IOERC   15,Output limit exceeded

         EXPLANATION:  The number of blocks written to an outfile
         (printfile) has reached the limit established with a
         LIMIT switch in the file specification.

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  The limit is set to 0, i.e.  no limit if
         the user continues execution.


ZYQ067   IOERR   16,OUTIMAGE (DIRECTFILE):  LOC <= 0

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ070   IOERR   17,OUTIMAGE (DIRECTFILE).  File is read-only
DECsystem-10 SIMULA Language Handbook, part II           Page 160
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ071   IOERR   20,INCHAR:  end of file


ZYQ072   IOERR   21,ININT:  INREAL:  INFRAC:  end of file


ZYQ074   IOERR   23,INTEXT:  end of file


ZYQ075   IOERC   24,INTEXT:  length out of range

         EXPLANATION:  The specified length must be >= 0 and <
         2^18

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ076   IOERC   25,Too long input line

         EXPLANATION:  The input line cannot fit into the image
         text.

         USER ACTION:  A new input line can be given after the
         PROCEED command.


ZYQ100   PHERR   0,Actual parameter is an expression - assignment
         is illegal


ZYQ101   PHERR   1,Function name passed as actual parameter -
         value needed

         EXPLANATION:  The actual parameter is just a procedure
         name, but a value is required.
DECsystem-10 SIMULA Language Handbook, part II           Page 161
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ102   PHERR   2,Invalid actual parameter to "QUICK" procedure
         - incorrect type or too complicated

         EXPLANATION:  This corresponds to either of the
         compile-time errors SIM417 or SIM420.  See these.  The
         error could not be determined at compile time.


ZYQ103   PHERR   3,Assignment to formal parameter - r.h.s.  not
         subclass of l.h.s.


ZYQ104   PHERR   4,Illegal use of a parameter which is a text
         constant

         EXPLANATION:  A text constant, passed as an actual
         parameter which matches a text parameter by name, is
         used in a place where a text constant is not allowed,
         e g on the right or left hand side of an (implied or
         explicit) denotes (:-) statement, on the left hand side
         of an assignment statement or in another context which
         would affect the contents of the text constant or change
         its position indicator.

         USER ACTION:  Specify the formal parameter by value or
         use COPY on the calling side.


ZYQ106   PHERR   6,Wrong number of parameters to formal or
         virtual procedure


ZYQ107   PHERR   7,Wrong actual parameter type


ZYQ110   PHERR   10,Text constant by reference is illegal

         USER ACTION:  See app.  C, message SIM366.


ZYQ111   PHERR   11,Wrong qualification on actual parameter


ZYQ112   PHERR   12, Actual/formal types incompatible


ZYQ113   PHERR   13,Wrong kind of actual parameter
DECsystem-10 SIMULA Language Handbook, part II           Page 162
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ121   RDERR   1,DISCRETE:  wrong number of subscripts


ZYQ122   RDERR   2,ERLANG:  first parameter not positive


ZYQ123   RDERR   3,ERLANG:  second parameter not positive


ZYQ124   RDERR   4,HISTD:  wrong number of subscripts


ZYQ125   RDERR   5,HISTO:  wrong number of subscripts


ZYQ126   RDERR   6,HISTO:  incompatible array parameters


ZYQ127   RDERR   7,LINEAR:  wrong number of subscripts


ZYQ130   RDERR   10,LINEAR:  array bounds do not match


ZYQ131   RDERR   11,NEGEXP:  first argument not positive


ZYQ132   RDERR   12,NORMAL:  standard deviation not positive


ZYQ133   RDERR   13,RANDINT or UNIFORM:  interval negative


ZYQ134   RDERR   14,RANDINT or UNIFORM:  too long interval


ZYQ135   SAERR   0,Garbage collection not possible

         EXPLANATION:  The SIMDDT command USE may invoke the
         Garbage Collector in a state when a garbage collection
         cannot be done.  This can occur after certain run time
         errors.

         USER ACTION:  Do not issue the USE command in this case.


ZYQ136   SAERR   1,Cannot get enough core for object pool

         EXPLANATION:  The requisite data area could not be
         allocated for the SIMULA program to run.  This error
         will sometimes occur when a separately compiled module
DECsystem-10 SIMULA Language Handbook, part II           Page 163
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         used by your program was not loaded.

         USER ACTION:  Obtain more core if possible or try to
         make core requirements smaller.


ZYQ144   SUERR   1,EVTIME:  object NONE


ZYQ145   SUERR   2,EVTIME:  passive process


ZYQ146   SUERR   3,Reactivation of terminated process


ZYQ147   SUERR   4,SQS empty

         EXPLANATION:  The last active process has been taken out
         of the sequencing set, and no process can be resumed.
         This is usually caused by cancelling or passivating the
         main program of SIMULATION.

         USER ACTION:  Activate the main program at some remote
         time.  Do not cancel or passivate main.


ZYQ154   TXERR   0,NOTEXT in editing procedure


ZYQ155   TXERR   1,PUTFRAC or OUTFRAC:  number of digits negative


ZYQ156   TXERC   2,PUTFIX or OUTFIX:  number of digits negative

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.
DECsystem-10 SIMULA Language Handbook, part II           Page 164
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ157   TXERC   3,PUTREAL or OUTREAL:  number of digits negative

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ160   TXERC   4,PUTCHAR:  pos out of range

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ161   TXERC   5,GETCHAR:  pos out of range

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.
DECsystem-10 SIMULA Language Handbook, part II           Page 165
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ162   TXERC   6,SUB:  1st parameter out of range

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ163   TXERC   7,SUB:  2nd parameter out of range

         SIMDDT ACTION:  See above message ZYQ162.


ZYQ164   TXERC   10,Text assignment:  r.h.s.  text too long

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the SIMULA program.

         RTS ACTION:  The text is truncated to the right after
         PROCEED.


ZYQ165   TXERR   11,GETINT:  no digits found or number too large

         EXPLANATION:  The first character that caused the error
         is printed.  If this character is a digit, then the
         number is too large.


ZYQ166   TXERR   12,GETREAL:  did not find digits


ZYQ167   TXERR   13,GETREAL:  item too large
DECsystem-10 SIMULA Language Handbook, part II           Page 166
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ170   TXERR   14,GETFRAC:  no item found or item too large

         EXPLANATION:  The first character that caused the error
         is printed.  If this character is a digit, then the
         number is too large.


ZYQ171   TXERC   15,BLANKS:  parameter out of range

         SIMDDT ACTION:  The error message is followed by the
         text:

         TO CONTINUE TYPE PROCEED

         At exit from SIMDDT the user may give a PROCEED command
         to continue the execution of the simula program.  If
         PROCEED is given the following text is issued:

         GIVE NEW INTEGER ARGUMENT

         after which the user must enter an integer.  The
         execution is then continued.


ZYQ172   TXERR   16,LOWTEN:  Illegal parameter


ZYQ173   TXERC   17,ININT:  no digits found or number too large

         EXPLANATION:  The first character that caused the error
         is printed.  If this character is a digit, then the
         number is too large.

         USER ACTION:  After the PROCEED command the input text
         where the error occurred is displayed and the user can
         give a new input line to replace this text.


ZYQ174   TXERC   20,INREAL:  did not find digits

         USER ACTION:  After the PROCEED command the input text
         where the error occurred is displayed and the user can
         give a new input line to replace this text.


ZYQ175   TXERC   21,INREAL:  item too large

         USER ACTION:  After the PROCEED command the input text
         where the error occurred is displayed and the user can
         give a new input line to replace this text.
DECsystem-10 SIMULA Language Handbook, part II           Page 167
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYQ176   TXERC   22,INFRAC:  no item found or item too large

         EXPLANATION:  The first character that caused the error
         is printed.  If this character is a digit, then the
         number is too large.

         USER ACTION:  After the PROCEED command the input text
         where the error occurred is displayed and the user can
         give a new input line to replace this text.


ZYQ212   Debug mode entered from line

         EXPLANATION:  SIMDDT was entered via the ENTERDEBUG
         procedure.  Execution may continue after issuing any
         SIMDDT commands which may be useful.


ZYQ213   Execution terminated via ABORT procedure

         EXPLANATION:  Invoked via the ABORT utility procedure.
         If a message was given as parameter, ABORT has output
         that message to the terminal and to Sysout if Sysout is
         not the terminal.


ZYQ214   Error in utility procedure

         EXPLANATION:  Reserved error number for errors in
         utility procedures (usually written in MACRO-10)


ZYQ215   Error in FORTRAN library subroutine

         EXPLANATION:  An error occurred in a mathematical
         procedure like SQRT or SIN which SIMULA has taken
         directly from the FORTRAN library.  The procedure name,
         which is usually different from the SIMULA name, was
         given in a preceding message to the TTY.


ZYQ216   Illegal UUO executed

         EXPLANATION:  Either a MACRO-10 or FORTRAN subroutine
         used an UUO which is not recognized by the SIMULA
         system, or a unexpected error occurred such that
         execution got out of control.  See explanation for
         ZYQ016.

         USER ACTION:  Check especially for I/O in external
         FORTRAN procedures.  This is not allowed.  If the error
DECsystem-10 SIMULA Language Handbook, part II           Page 168
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         cannot be traced to subroutines outside the SIMULA
         system, report to the SIMULA maintenance group.


ZYQ217   RTS logic error

         EXPLANATION:  This message indicates that the run time
         system has encountered a situation with which it cannot
         cope, i e the data structures are inconsistent or a
         coding error exists in the RTS.

         USER ACTION:  Report to the SIMULA maintenance group,
         after making the checks suggested for ZYQ016.


         SIMDDT DIAGNOSTICS


         The messages starting with ZYD apply to the SIMDDT
         system.
         Some of the messages ZYD001 to ZYD177 may also appear.
         The description is found in the corresponding ZYQ entry,
         ZYD signals that the error occurred while SIMDDT was
         active.  SIMDDT uses some of the RTS routines, e.g.  the
         GETINT routine which is called when an integer is
         expected in the input command.  If no integer is found
         the message ZYD165 is issued.  Note that SIMDDT
         processing may continue in most cases.


         SIMDDT will output the command followed by an
         appropriate message when an error is detected in an
         input command.  The input command will be reproduced up
         to and including the last character that was analysed by
         SIMDDT.


?ZYD476 ERROR WHILE INITIATING SIMDDT

         EXPLANATION:  It was not possible to initiate SIMDDT and
         processing can not continue.

         USER ACTION:  Report the problem to the SIMULA
         maintenance group.


?ZYD477 ERROR WHILE PROCESSING ERROR

         EXPLANATION:  A new error was detected while SIMDDT was
         processing an error.  It is not possible to continue.
DECsystem-10 SIMULA Language Handbook, part II           Page 169
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         USER ACTION:  Report the problem to the SIMULA
         maintenance group.


         INFORMATION TEXT

         The messages ZYD500 to ZYD547 are used in SIMDDT to
         create information text.  The ZYDnnn number is
         suppressed.


ZYD500   CHAR


ZYD501   =


ZYD502   CURRENT BLOCK POINTER AT LINE

         EXPLANATION:  The approximate line on which the current
         block starts is given after each INSPECT command.  


ZYD503   LENGTH=


ZYD504   POS=


ZYD505   SUBTEXT STARTS AT POSITION=


ZYD506   TERMINATED


ZYD507   INSPECT BLOCK


ZYD510   PREFIXED BLOCK


ZYD511   EVTIME=


ZYD512   TO CONTINUE TYPE PROCEED

         EXPLANATION:  This message is issued after the error
         message for errors where a possibility to continue
         exist.
DECsystem-10 SIMULA Language Handbook, part II           Page 170
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD513   GIVE NEW INPUT LINE TO REPLACE THE LINE GIVEN ABOVE:

         EXPLANATION:  This message is output after PROCEED after
         an error with continuation code = QDSNIM.


ZYD514   GIVE NEW INTEGER ARGUMENT:

         EXPLANATION:  This message is output after PROCEED after
         an error with continuation code =QDSNIN.


ZYD515   FILE:


ZYD516   CLOSED


ZYD517   PROCEDURE VALUE


ZYD540   SIMDDT STARTED

         EXPLANATION:  This message is issued before any user
         program statement has been executed.  SIMDDT and SIMRTS
         are initialized.

         USER ACTION:  Issue a HELP, set breakpoint, USE or
         PROCEED command.

         SIMDDT ACTION:  SIMDDT outputs an asterisk (*) on a new
         line and waits for a command.  User program execution
         will commence when SIMDDT receives a PROCEED command.


ZYD541   ?  ERROR IN JOB

         EXPLANATION:  When an error occurs SIMDDT is invoked and
         an error message is routed both to TTY and SYSOUT.  The
         line on which the error occurred will be given and a
         ZYQnnn message will follow.

         USER ACTION:  To get information on the cause of the
         error the user can issue any of the commands OUTPUT,
         CHAIN, SCHEDULED, USE and ALL.  The EXIT command should
         be issued to terminate the program and close all files.
         ^C can be used to exit without closing any files.
DECsystem-10 SIMULA Language Handbook, part II           Page 171
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD542   DETACHED


ZYD543   NO SCHEDULED PROCESSES


ZYD544   SCHEDULED PROCESSES


ZYD545   OPERATING CHAIN


ZYD547   VARIABLES


ZYD550   LINE OVERFLOW ON INPUT

         EXPLANATION:  A maximum of 135 characters are allowed in
         the input command.

         USER ACTION:  Give new command.

         SIMDDT ACTION:  Command is not processed.


ZYD551   COMMAND NOT RECOGNIZED

         EXPLANATION:  Either the command is misspelled or the
         name given is not unique.  Example:  The INPUT command
         must be given as INP while OUTPUT can be shortened to a
         single O.  SIMDDT has a table of all special keywords
         and IN is one of them.


ZYD552   NOT VALID IN DEBUG MODE


ZYD553   NOT VALID IN ERROR MODE

         EXPLANATION:  It is not possible to continue processing
         after an error with a zero continuation code has
         ocurred.  The set breakpoints, INPUT, REMOVE and PROCEED
         commands cannot be used.


ZYD554   PROCEED NOT ALLOWED AFTER THIS ERROR OR AFTER A
         NOPROCEED COMMAND

         EXPLANATION:  PROCEED in error mode is allowed only for
         errors with a non zero continuation code (i.e.  errors
         starting with xxERC not xxERR in the error message,
DECsystem-10 SIMULA Language Handbook, part II           Page 172
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         where xx is a module name).


ZYD556   ASSIGNMENT TO SYSTEM PROCEDURE IS NOT POSSIBLE

         EXPLANATION:  System procedures are not allowed as left
         hand side operands.  The only exception is text.MAIN.


ZYD557   TEXT ATTRIBUTE IS NOT MAIN

         EXPLANATION:  The only text attribute handled by SIMDDT
         is MAIN.


ZYD560   IDENTIFIER IS A LABEL

         EXPLANATION:  Labels are not handled by SIMDDT.

         SIMDDT ACTION:  Command is ignored.


ZYD561   IDENTIFIER IS A NAME PARAMETER

         EXPLANATION:  Parameters of mode name are not handled by
         SIMDDT.

         SIMDDT ACTION:  Command is ignored.


ZYD562   IDENTIFIER IS A PROCEDURE, NOT HANDLED BY SIMDDT IN THIS
         SITUATION

         EXPLANATION:  Procedures handled by SIMDDT are MAIN,
         SYSIN, SYSOUT, FIRST, LAST, SUC, PRED, PREV, EVTIME,
         NEXTEV, TIME and CURRENT.
         A type procedure identifier is handled by SIMDDT if the
         current block is the procedure block.  The identifier
         can however not be used in connection with the IF and
         the IFCHANGED features in a breakpoint command or on the
         right hand side in an INPUT command.

         SIMDDT ACTION:  Command is ignored.


ZYD563   IDENTIFIER IS A CLASS

         EXPLANATION:  Class identifier can only be handled by
         SIMDDT in connection with the relation operators IS and
         IN or the keywords THIS and QUA.
DECsystem-10 SIMULA Language Handbook, part II           Page 173
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         SIMDDT ACTION:  Command is ignored.


ZYD564   IDENTIFIER IS UNDEFINED

         EXPLANATION:  The identifier is not in the symbol table.

         SIMDDT ACTION:  Command is ignored.


ZYD565   DOT NOTATION ONLY VALID WITH REF OR TEXT

         SIMDDT ACTION:  Command is ignored.


ZYD566   IDENTIFIER EXPECTED IN INPUT

         SIMDDT ACTION:  Command is ignored.


ZYD567   IDENTIFIER NOT VISIBLE IN SYMBOL TABLE

         EXPLANATION:  
         1) The identifier name is misspelled
         2) The identifier is not visible from the current
         program block (CB).  For an INPUT or OUTPUT command CB
         is the block in which program execution was interrupted
         or the block which the CB was moved to with the INSPECT
         command and for a breakpoint command CB is the block
         which contains the statement referenced via the line
         number.  Note that no identifiers can be reached via the
         OUTPUT or INPUT commands before the user program has
         been started.
         3) The generation of linenumber or symbol table was
         suppressed during compilation.

         SIMDDT ACTION:  Command is ignored.


ZYD570   SUBSCRIPTS VALID ONLY WITH ARRAY IDENTIFIER

         SIMDDT ACTION:  Command is ignored.


ZYD571   SUBSCRIPTS MISSING AFTER ARRAY IDENTIFIER

         SIMDDT ACTION:  Command is ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 174
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD572   , OR ) OR ] EXPECTED AFTER SUBSCRIPTS

         SIMDDT ACTION:  Command is ignored.


ZYD573   ATTRIBUTE IDENTIFIER EXPECTED AFTER DOT

         SIMDDT ACTION:  Command is ignored.


ZYD574   WRONG NUMBER OF SUBSCRIPTS IN IDENTIFICATION

         EXPLANATION:  When an array element is referenced in a
         breakpoint command the number of subscripts cannot be
         checked until the breakpoint statement is reached.

         SIMDDT ACTION:  The breakpoint command is removed.  


ZYD575   SUBSCRIPT LESS THAN LOWER BOUND

         SIMDDT ACTION:  See previous message.


ZYD576   SUBSCRIPT GREATER THAN UPPER BOUND

         SIMDDT ACTION:  See previous message.


ZYD577   END OF INPUT OR COMMA EXPECTED

         EXPLANATION:  The COMMA should precede the next
         identification.


ZYD600   NO MORE FREE WORK AREA , REMOVE BREAKPOINTS

         EXPLANATION:  The area in which an internal form of the
         breakpoint commands are saved is full.

         SIMDDT ACTION:  The new command is ignored.

         USER ACTION:  Give a STOP BREAKS command and REMOVE the
         less useful breakpoints.


ZYD601   QUALIFICATION ERROR (NONE?)

         EXPLANATION:  A common error is that a reference type
         variable used via dot notation has the value NONE.
DECsystem-10 SIMULA Language Handbook, part II           Page 175
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         SIMDDT ACTION:  See message ZYD574.


ZYD602   RELATION OPERATOR EXPECTED

         EXPLANATION:  The keyword IF has been found in the
         command and a <RELATION OPERATOR> is expected after the
         identification.

         SIMDDT ACTION:  Command is ignored.


ZYD603   END OF INPUT EXPECTED

         EXPLANATION:  This is often a command syntax error.

         SIMDDT ACTION:  An AT or BREAKS command is ignored.  An
         INPUT command is processed.


ZYD604   MORE THAN ONE LOOP COUNTER

         SIMDDT ACTION:  Command is ignored.


ZYD605   INVALID LOOP COUNTER VALUE

         SIMDDT ACTION:  Command is ignored.


ZYD606   NO MORE FREE BREAKPOINT ENTRIES

         EXPLANATION:  The maximum number of different
         breakpoints that can be set up is 20.

         SIMDDT ACTION:  The new breakpoint command is ignored.

         USER ACTION:  Use STOP BREAKS and remove some of the
         uninteresting breakpoints.


ZYD611   COLON MISSING AFTER MODULE NAME

         SIMDDT ACTION:  Command is ignored.


ZYD612   CHARACTER CONSTANT, CLOSING ' MISSING

         SIMDDT ACTION:  Command is ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 176
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD613   := OR :- EXPECTED

         EXPLANATION:  The INPUT command must contain an
         assignment operator.

         SIMDDT ACTION:  Command is ignored.


ZYD614   DENOTES ONLY VALID AFTER REF OR TEXT VARIABLE

         SIMDDT ACTION:  Command is ignored.


ZYD615   := NOT VALID AFTER REF VARIABLE

         SIMDDT ACTION:  Command is ignored.


ZYD616   TEXT VALUE CONSTANT NOT VALID IN TEXT REFERENCE
         ASSIGNMENT

         SIMDDT ACTION:  Command is ignored.


ZYD617   DIFFERENT TYPES IN INPUT COMMAND

         EXPLANATION:  No conversion between real and integer or
         vice versa is made by SIMDDT.  The types must be equal
         except for LONG REAL and REAL variables which can be
         mixed.

         SIMDDT ACTION:  Command is ignored.


ZYD620   NO BREAKPOINT

         EXPLANATION:  No breakpoint has been set at the
         statement specified via the linenumber.

         SIMDDT ACTION:  Command is ignored.


ZYD621   AT OR END OF INPUT EXPECTED

         SIMDDT ACTION:  Command is ignored.


ZYD622   REMOVE OR END OF INPUT EXPECTED

         EXPLANATION:  The command STOP BREAKS was given.
DECsystem-10 SIMULA Language Handbook, part II           Page 177
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         SIMDDT ACTION:  The last listed breakpoint command is
         kept.


ZYD623   SIMDDT ENTERED, PROGRAM INTERRUPTED AT

         EXPLANATION:  The program was interrupted, probably via
         ^C and then entered via the REENTER monitor command.
         This message also appears when the program was entered
         via the CONTINUE command after program exit.  The SIMRTS
         routine fetched SIMDDT from disk if it was not already
         started and entered SIMDDT.  This feature can be used to
         detect where a program is looping.


ZYD625   FINAL " MISSING IN TEXT CONSTANT

         SIMDDT ACTION:  Command is ignored.


ZYD626   LENGTH OF RIGHT HAND SIDE > LEFT HAND SIDE IN TEXT VALUE
         ASSIGNMENT

         SIMDDT ACTION:  Command is ignored.


ZYD627   ATTRIBUTE IDENTIFIER NOT FOUND IN SYMBOL TABLE

         SIMDDT ACTION:  The input command up to the last
         character which has been processed by SIMDDT is written
         to the TTY to help the user find the invalid attribute
         identifier.  Command is ignored.


ZYD630   IDENTIFICATION OR CONSTANT OF CORRECT TYPE EXPECTED IN
         INPUT

         EXPLANATION:  See message ZYD617.  No type conversion is
         done by SIMDDT.

         SIMDDT ACTION:  Command is ignored.


ZYD631   TYPE ERROR IN DYNAMIC RECORD

         EXPLANATION:  This message should not normally be given.
         One of the dynamic records in the storage pool has a
         type which is not recognized by SIMDDT.  The message may
         appear while processing the VARIABLES or the ALL
         commands.
DECsystem-10 SIMULA Language Handbook, part II           Page 178
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         SIMDDT ACTION:  Command processing is terminated.

         USER ACTION:  If you cannot explain the error, e.g.  use
         of MACRO 10 procedures, use of the switches -A or -Q in
         compilation of the main program or any external
         procedure or class, please report the problem to the
         SIMULA maintenance group.


ZYD632   GARBAGE COLLECTOR NOT CALLED BEFORE VARIABLES TYPED

         EXPLANATION:  SIMDDT will call the garbage collector
         routine unless the /-GC switch, the program was
         interrupted (see ZYD623) or a critical error occurred
         (e.g.  storage allocation error).


ZYD635   SIMDDT IN DEBUG MODE AND USE FILE USED BY USER PROGRAM

         EXPLANATION:  It is only possible to let SIMDDT continue
         to write on an open user file if an error has occurred.

         SIMDDT ACTION:  Command is ignored.


ZYD636   INVALID MODULE NAME

         EXPLANATION:  MAIN or the SIMULA name of a separately
         compiled class or procedure are valid module names.

         SIMDDT ACTION:  Command is ignored.


ZYD637   LINE NUMBER NOT FOUND IN TABLE

         EXPLANATION:  The line is not found in the current line
         number table.  That is the line number table found via
         the module name if any, or found via the module in which
         the current block is placed.  The line number must fall
         within the table but if no exact match is found the
         first larger number is chosen.  One reason may be that
         the source module was compiled with the switch -I.

         SIMDDT ACTION:  Command is ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 179
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD640   NO MORE WORK AREA FOR TEXT OR REF VARIABLE, REMOVE
         BREAKPOINTS 

         EXPLANATION:  The number of text and ref identifiers
         which can be used in the breakpoint commands is limited.

         SIMDDT ACTION:  The command is ignored.

         USER ACTION:  See message ZYD600


ZYD641   IDENTIFIER AND OPERATOR INCOMPATIBLE

         SIMDDT ACTION:  Command is ignored.


ZYD642   VALID CLASS IDENTIFIER EXPECTED

         EXPLANATION:  The class identifier must follow the IS or
         IN operator in the breakpoint command or the keywords
         THIS and QUA.  A class identifier must be declared in
         the same module in which the breakpoint is placed.

         SIMDDT ACTION:  Command is ignored.


ZYD643   REF OR ARRAY VARIABLE NOT INITIALIZED

         EXPLANATION:  An unusual situation has occurred.  The
         user program execution was interrupted while setting up
         a dynamic record.


ZYD644   COMMAND NOT ALLOWED WHEN PROGRAM EXECUTION WAS
         INTERRUPTED

         EXPLANATION:  There are some command restrictions when
         SIMDDT was entered after the user program was
         interrupted.  The restrictions hold only when the
         message ZYD623 was given at entry to SIMDDT.  The USE
         command, the DISPLAY command, the @ command and a set
         breakpoint command which contains a text constant are
         not allowed as they may lead to a garbage collection.

         USER ACTION:  Find a statement in the program which will
         be executed immediately or very soon after the
         interrupted point.  Set a STOP AT breakpoint there and
         PROCEED to it.

         A hint:  INSPECT/START will tell you where your program
         was interrupted.  Try to set a breakpoint on the next
DECsystem-10 SIMULA Language Handbook, part II           Page 180
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


         line!


ZYD645   CURRENT BLOCK IS TERMINATED

         EXPLANATION:  It is an unusual case that the current
         block is terminated.

         SIMDDT ACTION:  The garbage collection is inhibited.


ZYD646   USE FILE IS NOT AN OUTFILE

         EXPLANATION:  The use file is used by the program but it
         is not an outfile.

         SIMDDT ACTION:  Command is ignored.


ZYD647   - OR END OF LINE EXPECTED

         EXPLANATION:  Line or line interval expected in DISPLAY
         command.

         SIMDDT ACTION:  Command is ignored.


ZYD650   LINE INTERVAL ERROR

         EXPLANATION:  Line or line interval is not correct in a
         DISPLAY command.

         SIMDDT ACTION:  Command is ignored.


ZYD651   LINE NOT FOUND IN MODULE

         EXPLANATION:  The line or lines that were requested in a
         DISPLAY command was not found in the source program
         file.  


ZYD652   /RETURN OR /UP NOT ALLOWED

         EXPLANATION:  The command INSPECT /RETURN or /UP is not
         valid if the current block is terminated or /RETURN
         given when the current block is a detached class
         instance.

         SIMDDT ACTION:  The current block is unchanged.
DECsystem-10 SIMULA Language Handbook, part II           Page 181
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD653   KEYWORD EXPECTED AFTER /

         EXPLANATION:  /UP, /RETURN, /START or /RESET expected in
         the INSPECT command.

         SIMDDT action:  Command is ignored.


ZYD654   OBJECT REFERENCE EXPECTED

         EXPLANATION:  Object reference or /keyword expected in
         an INSPECT command.  This message is also given when the
         object reference variable has the value NONE.

         SIMDDT ACTION:  Command is ignored.


ZYD655   VALUE NOT ACCESSIBLE FROM TERMINATED BLOCK

         EXPLANATION:  The only variables that are accessible in
         a terminated class instance are the class attributes.

         SIMDDT ACTION:  Command is ignored.


ZYD656   * NOT VALID

         EXPLANATION:  * not valid after IF or IFCHANGED in a
         breakpoint command.

         SIMDDT ACTION:  Command ignored.


ZYD657   CLOSE OR END OF INPUT EXPECTED

         EXPLANATION:  The command STOP CLOSE was given.

         SIMDDT ACTION:  The file name is given again.

         USER ACTION:  Answer CLOSE or carriage return.


ZYD660   YOU MAY ISSUE THE NOPROCEED COMMAND AND REENTER CURRENT
         COMMAND AGAIN



SIMDDT ACTION:  Command is ignored.
DECsystem-10 SIMULA Language Handbook, part II           Page 182
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD661   INVALID KEYWORD AFTER / IN OUTPUT, VARIABLES OR ALL
         COMMAND

         EXPLANATION:  /-ARRAY, /-TEXT and /-GC are allowed.

         SIMDDDT ACTION:  Rest of command ignored.


ZYD662   SIMDDT EXPECTS INPUT FROM TERMINAL:

         EXPLANATION:  End of input file found.


ZYD663   SIMDDT ENTERED AT A BREAKPOINT

         EXPLANATION:  The program was interrupted via the
         control-C-REENTER monitor commands.


ZYD664   NO TYPE PROCEDURE

         EXPLANATION:  Only type procedure identifiers can be
         handled by SIMDDT.


ZYD674   BREAKPOINT UUO FOUND, BUT BREAKPOINT NOT KNOWN TO SIMDDT

         EXPLANATION:  It is probably a SIMDDT error.


ZYD675   SIMDDT TERMINATION ERROR

         SIMDDT ACTION:  The program is terminated.

         USER ACTION:  Report the problem to the SIMULA
         maintenance group.


ZYD676   INVALID MESSAGE NUMBER

         EXPLANATION:  An message number that is new to the
         SIMDDT program has been detected.  The unknown message
         number is placed at the start of this message, e.g.
         ZYD700 ZYD676 INVALID MESSAGE NUMBER

         USER ACTION:  Report the problem to the SIMULA
         maintenance group.
DECsystem-10 SIMULA Language Handbook, part II           Page 183
APPENDIX D.2 RUN-TIME AND DEBUG DIAGNOSTICS


ZYD677   COMMAND OR FEATURE NOT IMPLEMENTED

         EXPLANATION:  The command is recognized but the
         implementation is not part of this version of SIMDDT.

         SIMDDT ACTION:  The command is ignored.




    END OF RUN-TIME AND DEBUG DIAGNOSTICS
DECsystem-10 SIMULA Language Handbook, part II           Page 184
APPENDIX E HOW TO WRITE AN EXTERNAL FORTRAN OR MACRO-10 PROCEDURE





APPENDIX E HOW TO WRITE AN EXTERNAL FORTRAN OR MACRO-10 PROCEDURE
=================================================================


     The handling of external FORTRAN and MACRO-10 procedures may
     be visualized by the aid of the following figure which shows
     the relation between the processors and files involved:


                             proc.sim            proc.for/mac
                                !                     !
                                v                     v
                        -----------------    ------------------
                        [SIMULA COMPILER]    [FORTRAN/MACRO-10]
                        -----------------    ------------------
                                !                     !
                                v                     !
                             proc.atr                 !
                                !                     !
                                v                     !
                        -----------------             !
             main.sim-->[SIMULA COMPILER]             !
                        -----------------             !
                                !                     !
                                !                     !
                                v       --------      v
                             main.rel-->[LOADER]<--proc.rel
                                        --------
                                           !
                                           v
                                        main.sav


     IMPORTANT:  The .ATR and .REL file names for an external
     FORTRAN or MACRO-10 procedure should be identical except for
     the extension, and should be stored under the same ppn.  If
     they are stored in library files, the libraries should be
     identical except for the extension (.ATR for ATR-file
     libraries and .REL for REL-file libraries) and be stored
     under the same ppn.
DECsystem-10 SIMULA Language Handbook, part II           Page 185
APPENDIX E.1  EXTERNAL FORTRAN PROCEDURES.


E.1  EXTERNAL FORTRAN PROCEDURES


     To create an attribute file, a corresponding procedure
     heading must be compiled by the SIMULA compiler.  Preceding
     the procedure heading there must be an OPTIONS statement of
     the form:

             OPTIONS(/nEXTERNAL:codeword,entry);

     where codeword is FORTRAN or F40.  FORTRAN signals that the
     procedure is compiled with the FORTRAN-10 compiler and F40
     that the procedure is compiled with the old FORTRAN
     compiler.
     The entry point of the procedure is named "entry".  It is
     the same as the name of the SUBROUTINE or FUNCTION in the
     FORTRAN program.

     *****  IMPORTANT:  You are strongly recommended to use the
     same identifier for the following entities:

   > The "entry" in the OPTIONS statement above,
   > The name of the FORTRAN SUBROUTINE or FUNCTION,
   > The name of the FORTRAN source program file,
   > The name of the SIMULA specification file (containing the
     SIMULA heading corresponding to the FORTRAN SUBROUTINE),
   > The SIMULA name for the procedure,
     even though certain combinations where some of these
     identifiers are different will sometimes work.

     Parameter restrictions:
     Only the types ( SHORT ) INTEGER, ( LONG ) REAL, CHARACTER
     and BOOLEAN can be transmitted.  An argument of type
     CHARACTER should be treated as an integer in the FORTRAN
     program.

     Allowed transmission modes:
     Simple types:  VALUE default, NAME optional.
     ARRAYs:  VALUE optional, reference default.

     The effect of a call by NAME is:  before the FORTRAN
     procedure is entered, the actual parameter is evaluated.  If
     it is a variable, a reference to that variable is
     transmitted, otherwise (constant or expression) the value is
     stored in a cell and a reference to that cell is
     transmitted.

     In an external FORTRAN procedure one must not use any
     facilities that demand the FORTRAN high segment (e.g.  I/O).
     However, calls to the FORTRAN high segment in FORTRAN
     subroutines to SIMULA programs can often be intercepted,
DECsystem-10 SIMULA Language Handbook, part II           Page 186
APPENDIX E.1  EXTERNAL FORTRAN PROCEDURES.


     using the programs FORSIM in the libraries LIBSIM.ATR and
     LIBSIM.REL.  You need only insert a call to these procedures
     in your SIMULA program.

     Errors may occur for FORTRAN procedures with more than one
     entry point, if parameters are passed to the procedure using
     one entry point and used by the procedure after a call to
     another entry point.

     The SIMULA compiler will generate an attribute file but no
     rel-file.
     A SIMULA procedure heading has to be compiled before the
     main program and this should be done via the COMPILE or R
     monitor commands since no rel file is generated.  Care must
     be taken when giving an EXECUTE or LOAD command to ensure
     that the correct REL files are loaded.
DECsystem-10 SIMULA Language Handbook, part II           Page 187
APPENDIX E.2  FORTRAN PROGRAMMING EXAMPLE.


E.2  FORTRAN PROGRAMMING EXAMPLE


     In this example we have a FORTRAN procedure which compares
     two real arrays of the same size.

     FORTRAN program:

                     LOGICAL FUNCTION equala(a1,a2,n)
             C
                     DIMENSION a1(n),a2(n)
             C
                     equala=.TRUE.
             C
                     DO 1 i=1,n
                     IF( a1(i) .NE. a2(i) ) GOTO 2
             1       CONTINUE
                     RETURN
             2       equala=.FALSE.
                     RETURN
                     END


     The SIMULA specification program (1):

             OPTIONS(/E:FORTRAN,equala);
             BOOLEAN PROCEDURE equala(a1,a2,n);
             ARRAY a1,a2;
             INTEGER n;;


     If we have a declaration ARRAY a,b[c:d,e:f] then

             equala(a,b,(d-c+1)*(f-e+1))

     is true if and only if the arrays a and b are equal element
     for element.






              ------------------------------------
(1) Note that the SIMULA specification  may  be  built  into  the
FORTRAN code by disguising SIMULA code as comments:
COMMENT;  OPTIONS(/E:  ....);
COMMENT;  ...
and then making the whole FORTRAN code a SIMULA comment:
COMMENT
        <FORTRAN code>
COMMENT;
DECsystem-10 SIMULA Language Handbook, part II           Page 188
APPENDIX E.3  EXTERNAL MACRO-10 PROCEDURES.


E.3  EXTERNAL MACRO-10 PROCEDURES


     To create an attribute file, a corresponding procedure
     heading (1) must be separately compiled by the SIMULA
     compiler.  The procedure heading must be preceded by an
     OPTIONS statement of one of the following forms:

             OPTIONS(/nEXTERNAL:codeword,entry);
             OPTIONS(/nEXTERNAL:codeword,checkoption,entry);

     where codeword is CODE or QUICK, checkoption is CHECK or
     NOCHECK (-CHECK is also a valid form).  Here CODE or QUICK
     signals that the procedure is written in MACRO-10.  The
     entry point is named "entry" in the MACRO-10 module.

     If checkoption is the word CHECK, or checkoption is not
     given, the SIMULA compiler will check all actual parameters.
     The exact meaning of this is:
     All parameters must be specified.  The SIMULA compiler will
     check the actual parameters versus the formal and they must
     correspond in number and have compatible types.  All
     necessary type conversions will be performed by the system.

     If checkoption is NOCHECK (-CHECK), the procedure heading
     must not specify any formal parameters, implying that the
     formal parameters are unknown to the compiler.  The compiler
     can thus not perform any parameter checking.  This implies
     the following:
     All parameters are transmitted by NAME.  The number of
     actual parameters may vary from call to call but may not
     exceed 31 (5 if codeword is QUICK).

     If codeword is CODE, the procedure is called in the same way
     as a procedure coded in SIMULA.  If codeword is QUICK,
     however, a special, very efficient calling sequence is used,
     where all parameters are passed in accumulators, and no
     procedure block is allocated.  The procedure is called
     directly without run time system intervention (see calling
     standard, E.5.1).
     - A maximum of 5 to 10 parameters, depending on the types,
     kinds and modes of actual parameters, is allowed.
     - Parameters specified PROCEDURE, LABEL or SWITCH may not be
     specified by NAME.


                     ----------------------
(1) By judicious use  of  the  comment  conventions,  the  SIMULA
specification  for  an external MACRO-10 procedure can be written
in the same file as the MACRO-10 code.  See E.6 for examples.
DECsystem-10 SIMULA Language Handbook, part II           Page 189
APPENDIX E.3  EXTERNAL MACRO-10 PROCEDURES.


     - The actual parameter corresponding to a formal parameter
     by NAME may not be an expression.  Exact type correspondence
     is required for arithmetic parameters by NAME.

     Note that QUICK,NOCHECK implies that all parameters (at most
     5) are transmitted by name, subject to the special
     restrictions on name mode parameters.

     In all cases, the SIMULA compiler will generate an attribute
     file but no rel-file.
DECsystem-10 SIMULA Language Handbook, part II           Page 190
APPENDIX E.4  MACRO-10 CALLING STANDARD.


E.4  MACRO-10 CALLING STANDARD


E.4.1  Accumulator conventions:

     At entry:

     AC17(XPDP) is a stack pointer.
     AC15(XCB)  points to the procedure instance of this call
     (see appendix B).

     When calling a RTS-routine:

     Three conventions TA1, TA2 and TA3 are used in the run-time
     system.
     For all routines:  The accumulators 0,1,2 and 16 are
     destroyed.  AC15 and AC17 must have the same value as on
     entry.
     For type TA1 routines:  All the other accumulators may also
     be destroyed.
     For type TA2 routines:  All the other accumulators are
     preserved over the call.
     For type TA3 routines:  The accumulators 3 up to N are
     preserved over the call.  N and a map of which accumulators
     point directly at dynamic objects are parameters in the
     call.  No accumulator may point into a dynamic object.


     During execution of the MACRO-10 procedure:

     If correct error diagnostics are desired, AC15 should not be
     touched inside the procedure.  AC17 may be used as push-down
     stack pointer but for no other purpose.  If any action is
     requested from the RTS which may lead to garbage collection,
     any ac's which contain pointers into the dynamic data area
     must be saved in an accumulator stack.  Note that the right
     hand side of such an ac must point to the start of a record
     in the stack.  Any offset should be in the left half or in
     another ac.  Addresses in the left halves of ac's cannot be
     relocated by the garbage collector.

     At exit:

     AC15 and AC17 must have the same value as on entry.  All the
     other ac's may be destroyed.
DECsystem-10 SIMULA Language Handbook, part II           Page 191
APPENDIX E.4  MACRO-10 CALLING STANDARD.


E.4.2  Calling sequence to "QUICK" procedures

     A MACRO-10 procedure corresponding to a specification file
     of the form
        OPTIONS(/EXTERNAL:QUICK,[,NOCHECK],entry);
        [<type>] PROCEDURE <SIMULA-name>[<parameter list>;
        <parameter specifications>;]
     is called very efficiently by a SIMULA program.


     Parameters to QUICK procedures

     All parameters are computed to accumulators, starting with
     the first ac not occupied by temporary results, normally
     XWAC1=AC3.  The representation of parameters is as shown in
     App B.3.  Depending on the specification, a parameter may
     occupy one or two ac's.  Since at most 10 ac's are
     available, this means that the maximum number of parameters
     ranges from 5 to 10.  If NOCHECK is specified, all
     parameters are transmitted by name, and since a parameter
     descriptor for a name parameter occupies two words, at most
     5 parameters may be passed.


     Entering a QUICK procedure

     After computation of parameters, the procedure is called by
     PUSHJ  XPDP,entry, where XPDP=AC17.

     If the procedure has no type (pure procedure), no
     intermediate results will exist in ac's when the procedure
     is called.  Thus the first parameter is always in XWAC1
     (AC3).  Subject to the restrictions in E.4.1, the ac's may
     be used freely within the MACRO-10 procedure.

     If the procedure is a function, i e has a type, it may be
     used in an expression, which means that temporary results
     may exist in accumulators.  Thus the first parameter may be
     in some other ac than XWAC1, and the MACRO-10 procedure must
     be told where to find the first parameter.  This is done via
     AC2 (XTAC), which is loaded with the number of the first
     parameter ac.  XTAC may thus contain the number 3, 4, etc.
     For example, the first parameter may be loaded by
     MOVE   x,(XTAC), the second by MOVE   y,1(XTAC), assuming
     single length parameters.  When only a few parameters are
     involved, they may be loaded to standard ac's (XWAC1, XWAC2,
     etc) by EXCH instructions, at the same time saving the
     standard ac's.  Any extra registers must be saved on the
     stack (XPDP) before use.  On return, unstacking is followed
     by the same EXCH instructions in reverse order.
DECsystem-10 SIMULA Language Handbook, part II           Page 192
APPENDIX E.4  MACRO-10 CALLING STANDARD.


     If NOCHECK was specified, AC2 is used to specify the number
     of actual parameters as follows:
     The left half is -n, where n is the number of actual
     parameters.  The right half contains the number of the top
     ac as explained above.  AC2 is loaded also for pure
     procedures in this case.


     Exit from QUICK procedures

     On exit from a pure procedure, nothing is assumed about the
     contents of ac's except AC15 and AC17, which must be
     preserved.  On exit from a function, however, the following
     conditions must hold:
     - The result must be in the top ac, i e the one pointed to
     by XTAC on entry.  For double length results the next ac is
     also implied.
     - AC0, AC1, AC2 and AC16 may be destroyed.
     - The parameter ac's not used for the result may be
     destroyed.
     - All other ac's must be preserved over the call.


     Restrictions

     Some restrictions are given in E.3.  Since intermediate
     results may exist in ac's, core allocation must be avoided.
     Procedures as parameters should be avoided.  Typical
     applications of QUICK procedures are:
     - Small procedures to give access to monitor information
     related to the current job, such as cpu time used, time of
     day, core available.
     - Additional text handling procedures, etc.
     Any complicated MACRO-10 procedure should be written as a
     CODE procedure.
DECsystem-10 SIMULA Language Handbook, part II           Page 193
APPENDIX E.5  STANDARD MACROS AND CONSTANTS IN MACSIM.


E.5  STANDARD MACROS


     To facilitate communication between SIMULA and MACRO-10
     programs, some macros and assembly-time constants are
     defined in the UNIVERSAL MACSIM.  They are:


             MACRO   SPECIFY(specifications)

     The argument of this macro is a list of specifications of
     the procedure and parameters.  As a result all parameters
     not called by NAME (and the function value) are directly
     accessible through their names.  Parameters called by NAME
     are operated on through the macros GETADD, GETTADD, GETAADD,
     GETVAL, ASSIGN, GETTYPE, GETKIND and SETTYPE.  SPECIFY may
     be used also for QUICK procedures if the macro QUICKPROC is
     invoked or the assembly parameter QUICK is defined > 0.


             MACRO   PROC    name,parameters

     This macro should be the first macro inside the SPECIFY
     argument.  It gives the name of the procedure and of the
     parameters.


             MACRO   VALUE     par1,par2...
             MACRO   NAME      par1,par2...
             MACRO   INTEGER   par1,par2...
             MACRO   REAL      par1,par2...
             MACRO   LONGREAL  par1,par2...
             MACRO   CHARACTER par1,par2...
             MACRO   BOOLEAN   par1,par2...
             MACRO   TEXT      par1,par2...
             MACRO   REF       par1,par2...
             MACRO   ARRAY     par1,par2...
             MACRO   PROCEDURE par1,par2...
             MACRO   LABEL     par1,par2...
             MACRO   SWITCH    par1,par2...

     These macros are valid as arguments to the SPECIFY macro.
     They specify the type, kind and mode of the parameters and
     of the procedure value.
DECsystem-10 SIMULA Language Handbook, part II           Page 194
APPENDIX E.5  STANDARD MACROS AND CONSTANTS IN MACSIM.


             MACRO   RETURN

     This macro returns control to the calling SIMULA program.


             MACRO   GETCHANNEL

     This macro expands into a call to a RTS-routine which
     reserves a free I/O-channel and returns it in AC1.  It is a
     type TA1 routine.


             MACRO   FREECHANNEL chan [,ac<16>]

     This macro returns the channel in location chan to the pool.
     ac is a temporary accumulator used by the macro.


             MACRO   INIMAGE

     This macro expands into a call to a RTS-routine which
     performs INIMAGE on the file object pointed to by AC3.  It
     is a type TA1 routine.


             MACRO   OUTIMAGE

     This macro expands into a call to a RTS-routine which
     performs OUTIMAGE on the file object pointed to by AC3.  It
     is a type TA1 routine.


             MACRO   IFEOF   ac

     This macro causes the next instruction to be skipped if
     ENDFILE=FALSE in the file object pointed to by ac.


             MACRO   IFNEOF  ac

     This macro causes the next instruction to be skipped if
     ENDFILE=TRUE in the file object pointed to by ac.
DECsystem-10 SIMULA Language Handbook, part II           Page 195
APPENDIX E.5  STANDARD MACROS AND CONSTANTS IN MACSIM.


     The following macros define access to name mode parameters.
     They should not be used in QUICK procedures.


             MACRO   GETADD  par [,N,maprh]

     This macro expands into a call to a RTS-routine which loads
     the dynamic address of a parameter called by NAME (not TEXT
     or ARRAY) to ac N+1 (AC3 if N is missing) (and ac N+2 (AC4)
     if double word).  N is the highest ac saved.  maprh is a
     list of those ac's which need relocation of their right
     halfword in case of garbage collection.  The left halfwords
     must not contain any relocatable information.  Thus the
     routine is of type TA3.


             MACRO   GETTADD par[,N,maprh]

     This macro expands into a call to a RTS-routine which loads
     the dynamic address of a TEXT parameter called by NAME.  For
     the rest see GETADD.


             MACRO   GETAADD par[,N,maprh]

     This macro expands into a call to a RTS-routine which loads
     the dynamic address of an ARRAY called by NAME.  It is the
     only way of accessing such a parameter.  For the rest see
     GETADD.


             MACRO   GETVAL  par[,N,maprh]

     This macro expands into a call to a RTS-routine which loads
     the value of a parameter called by name.  For the rest see
     GETADD.


             MACRO   ASSIGN  par,aclhs,acrhs

     This macro expands into a call to a RTS-routine which
     performs an assignment to a parameter called by NAME.  The
     dynamic address of the parameter has previously been
     computed to AC aclhs (and aclhs+1 if dynamic address is 2
     words).  The value to be assigned has been computed to AC
     acrhs (and acrhs+1 if doubleword value).  The SIMRTS-routine
     performs all necessary type conversion and qualification
     checking.  It is a type TA2 routine.
DECsystem-10 SIMULA Language Handbook, part II           Page 196
APPENDIX E.5  STANDARD MACROS AND CONSTANTS IN MACSIM.


             MACRO   GETTYPE ac,par

     This macro loads ac with the type of an actual parameter
     called by NAME.


             MACRO   GETKIND ac,par

     This macro loads ac with the kind of an actual parameter
     called by NAME.


             MACRO   SETTYPE typ,par[,ac<16>]

     This macro sets the formal type to typ for a parameter
     called by NAME.  It is used to force type conversion in
     GETVAL and ASSIGN.  ac is a temporary accumulator.


     The macros GETTYPE, GETKIND and SETTYPE are useful in
     NOCHECK procedures.


     The following macros can be used in procedures called with
     all parameters in ac's (QUICK procedures):

             MACRO   QUICKPROC

     This macro should be called directly after "search MACSIM"
     in a QUICK procedure.  It defines QUICK=1.




     Some useful constants:


             CONSTANT   QNOTYPE
             CONSTANT   QINTEGER
             CONSTANT   QREAL
             CONSTANT   QLONGREAL
             CONSTANT   QCHARACTER
             CONSTANT   QBOOLEAN
             CONSTANT   QTEXT
             CONSTANT   QREF
             CONSTANT   QLABEL

     These constants define the type codes.


             CONSTANT   QSIMPLE
DECsystem-10 SIMULA Language Handbook, part II           Page 197
APPENDIX E.5  STANDARD MACROS AND CONSTANTS IN MACSIM.


             CONSTANT   QARRAY
             CONSTANT   QCLASS
             CONSTANT   QPROCEDURE

     These constants define the kind codes.  SWITCH has type
     QLABEL and kind QPROCEDURE.




             CONSTANT   NONE

     This constant defines the representation of the object
     constant NONE.


             CONSTANT   IMAGE

     This constant defines the offset of the attribute IMAGE in a
     file object.
DECsystem-10 SIMULA Language Handbook, part II           Page 198
APPENDIX E.6  MACRO-10 PROGRAMMING EXAMPLES.


E.6  MACRO-10 PROGRAMMING EXAMPLES


E.6.1  Example on CODE procedures

     In this example we have a MACRO-10 procedure which performs
     a summation utilizing Jensens device.


     The file contains both the SIMULA specification and the
     MACRO-10 code.  Note the use of COMMENT and !.  Since
     COMMENT in MACRO-10 is terminated by a second occurrence of
     the first non-blank character following the word COMMENT,
     the whole SIMULA heading is taken to be a comment by the
     MACRO-10 compiler.  In MACRO-10, a semicolon turns the rest
     of a line into a comment.  If every semicolon in the
     MACRO-10 code part is followed by !, the MACRO-10 code is
     regarded as a series of comments by SIMULA.  The last
     comment is terminated by the semicolon following END.  The
     file extension should be .MAC, which means that the SIMULA
     specification must be compiled via .R SIMULA, since the MAC
     extension forces MACRO-10 to be used if a COMPILE, EXECUTE,
     or DEBUG command is issued.


             COMMENT * SIMULA specification;
             OPTIONS(/E:CODE,CHECK,sument);
             REAL PROCEDURE sum(m,n,f,i);
             NAME f,i;
             REAL f;
             INTEGER m,n,i;

             COMMENT The corresponding SIMULA code would be:

     !      BEGIN
     !         REAL s;
     !         FOR i:=m STEP 1 UNTIL n DO
     !         s:=s+f;
     !         sum:=s;
     !      END;
DECsystem-10 SIMULA Language Handbook, part II           Page 199
APPENDIX E.6  MACRO-10 PROGRAMMING EXAMPLES.


             !*;! MACRO-10 code !*;!

             TITLE   sum
             SEARCH  macsim
             ENTRY   sument

             SPECIFY<
                     PROC    sum,<m,n,f,i>
                     NAME    f,i
                     REAL    sum,f
                     INTEGER m,n,i
                     >

     sument: MOVE    3,m     ;! Start index of loop

     loop:   CAMLE   3,n
             RETURN          ;! at end of interval
             GETADD  i,3
             ASSIGN  i,4,3
             GETVAL  f,3
             FADRM   4,sum   ;! add f into sum
             AOJA    3,loop  ;! STEP 1, go to start of loop
             END;


     Note that the END statement must not contain any start
     address.  The ENTRY statement gives the start address of the
     procedure and the start address for the main program is
     created by the SIMULA compiler.  Then sum(1,n,i,i) =
     n*(n+1)/2 and sqrt(sum(1,n,a(i)**2,i)) = length of vector a


     The following monitor commands will compile and execute the
     modules in the example (assuming MACSIM.UNV is available on
     DSK:, UNV:  or SYS:):

     .R SIMULA
     *sum.mac
     *^C
     .EXECUTE sum.mac,main

     Note that the ATR file must be generated by SIMULA before
     the EXECUTE command can be used.
DECsystem-10 SIMULA Language Handbook, part II           Page 200
APPENDIX E.6  MACRO-10 PROGRAMMING EXAMPLES.


E.6.2  Example on QUICK procedures

     This example shows how a QUICK procedure is written to
     perform a text handling task.  Refer to B.1 for the text
     variable representation.  Note that MACSIM is used with the
     assembly parameter QUICK=1.  Since the text parameter is
     used also to return the result, the procedure name is not
     used.  The dot in the procedure name avoids name clashes.
     Note also that one file, e g REST.MAC, can be compiled both
     with SIMULA and MACRO-10 through use of the comment
     conventions.  See E.6.1.


     COMMENT * SIMULA specification;

             OPTIONS(/EXTERN:QUICK,REST);
             TEXT PROCEDURE rest(t); TEXT t;
             COMMENT Computes t.sub(t.pos,t.length+1-pos);


     !*;! MACRO-10 code !*;!

             TITLE   REST
             SUBTTL  Compute text reference to text after pos
             SALL
             SEARCH  MACSIM
             ENTRY   REST
             QUICK==1
             SPECIFY<
             PROC    .REST,T
             TEXT    .REST,T
             >

     REST:   EXCH    T,(XTAC)        ;!Parameter to standard ac's
             EXCH    T+1,1(XTAC)
             HLRZ    X0,T+1          ;!Length
             SUBI    X0,(T+1)        ;! - pos + 1
             JUMPLE  X0,L1           ;!Anything left?
             HLRZ    X1,T            ;!Subtext offset
             ADDI    X1,(T+1)        ;! + pos - 1 gives
             HRLM    X1,T            ;!New offset
             HRLZM   X0,T+1          ;!New length, Pos=1
             GOTO    L2
     L1:     SETZB   T,T+1           ;!NOTEXT
     L2:     EXCH    T+1,1(XTAC)
             EXCH    T,(XTAC)
             RETURN
             END;
DECsystem-10 SIMULA Language Handbook, part II           Page 201
APPENDIX E.6  MACRO-10 PROGRAMMING EXAMPLES.


     REST could be called by the following piece of code:

     BEGIN
         EXTERNAL TEXT PROCEDURE rest;
         TEXT t1,t2;
         t1:-Copy("1234567");
         t1.setpos(5);
         t2:-rest(t1);
         Outtext("rest(t1)="); Outtext(t2); Outimage;
     END;


     The statement t2:-rest(t1) is compiled to:

             DMOVE   3,2(15) ;t1
             MOVEI   2,3     ;Indicate top ac=3
             PUSHJ   17,rest
             DMOVEM  3,4(15) ;t2


     The program output will be:

     rest(t1)=567
DECsystem-10 SIMULA Language Handbook, part II           Page 202
APPENDIX F RUN-TIME SYSTEM COMPONENTS


APPENDIX F RUN-TIME SYSTEM COMPONENTS
=====================================


     The Run-Time System contains several modules corresponding
     to files with extension MAC and the compiled REL files.  The
     most frequently used modules are loaded in the high segment,
     and the rest is loaded with the SIMULA program in the low
     segment.  In this appendix the modules are listed with their
     most important entry points, corresponding to system
     classes, procedures or special SIMULA constructs.

     The following modules are loaded in the high segment
     (SIMRTS).


     CP     handles classes and prefixed blocks.

            Subroutine          SIMULA notation

             .CPCA              CALL
             .CPDT              DETACH
             .CPNE              NEW <class identifier>
             .CPRS              RESUME
             .CPSP              <class id> BEGIN


     CS     central part, handles some run-time tasks performed
            in most SIMULA programs.


     IO and IONF perform I/O handling.

            Subroutine          SIMULA notation

             .IOBO              BREAKOUTIMAGE
             .IOCL              CLOSE
             .IOEJ              EJECT
             .IOFD              FIELD
             .IOIG              INIMAGE
             .IOLI              LASTITEM
             .IOLP              LINES PER PAGE
             .IOLT              LOCATE
             .IOOG              OUTIMAGE
             .IOOP              OPEN
             .IOSP              SPACING
DECsystem-10 SIMULA Language Handbook, part II           Page 203
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     IOED   performs I/O handling in connection with text
            handling (editing functions)

            Subroutine          SIMULA notation

             .IOIC              INCHAR
             .IOIF              INFRAC
             .IOII              ININT
             .IOIR              INREAL
             .IOIT              INTEXT
             .IOOC              OUTCHAR
             .IOOF              OUTFRAC
             .IOOI              OUTINT
             .IOOR              OUTREAL
             .IOOT              OUTTEXT
             .IOOX              OUTFIX


     PH     handles parameter transmissions for procedures.


     OCIN and OCIO initialize a SIMULA program execution, handle
            file specifications.


     OCEP   handles end of SIMULA programs, traps and UUO's and
            loads SIMDDT


     SA     handles storage allocation, garbage collection.


     SIMRT1 and SIMRT2 contain transfer vectors for references to
            the high segment from the low segment and the code to
            swap high segments.  The modules are used in the two
            high segments version of the run time system.


     SIMRTS contains the transfer vector for references to the
            high segment from the low segment.  This module is
            used in the single high segment version of the run
            time system.


DECsystem-10 SIMULA Language Handbook, part II           Page 204
APPENDIX F RUN-TIME SYSTEM COMPONENTS


            TX and TXBL perform text handling.


            Subroutine          SIMULA notation

             .TXBL              BLANKS
             .TXCY              COPY
             .TXGC              GETCHAR
             .TXGF              GETFRAC
             .TXGI              GETINT
             .TXGR              GETREAL
             .TXLT              LOWTEN
             .TXMN              MAIN
             .TXPC              PUTCHAR
             .TXPF              PUTFRAC
             .TXPI              PUTINT
             .TXPR              PUTREAL
             .TXPX              PUTFIX
             .TXRE              Value relation (e.g. T1<=T2)
             .TXSE              SETPOS
             .TXST              STRIP
             .TXSU              SUB
             .TXVA              Value assignment (e.g. T1:=T2)




DECsystem-10 SIMULA Language Handbook, part II           Page 205
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     The following modules contain routines to be loaded into the
     low segment with the SIMULA program.  The corresponding rel
     files are collected by FUDGE2 into the library file
     SIMLIB.REL.  Some routines are taken from SYS:FORLIB.  These
     are marked with an asterisk (*).



     ACOS.  ARCCOSINE single precision

            subroutine          SIMULA name
            * ACOS.             ARCCOS


     ALOG.  contains logarithm function single precision.

            subroutine          SIMULA name
            * ALOG.             LN


     ASIN.  contains ARCSINE function single precision.

            subroutine          SIMULA name
            * ASIN.             ARCSIN


     ATAN.  contains ARCTANGENT single precision.

            subroutine          SIMULA name
            * ATAN.             ARCTAN


     CFRXIT FORTRAN interface

            subroutine
            * CEXIT.            used when returning from F40
            library subroutine


     COSH.  hyperbolic COSINE single precision

            subroutine          SIMULA name
            * COSH.             COSH


     DATAN. contains ARCTANGENT double precision

            subroutine          SIMULA name
            * DATAN.            ARCTAN
DECsystem-10 SIMULA Language Handbook, part II           Page 206
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     DEXP.  contains exponential function double precision

            subroutine          SIMULA name
            * DEXP.             EXP


     DEXP.2 computes a floating point number in double precision
            raised to an integer power.

            subroutine          SIMULA notation
            * DEXP2.            A**B


     DEXP.3 computes a floating point number in double precision
            raised to a floating point number in double
            precision.

            subroutine          SIMULA notation
            * DEXP.3            A**B


     DLOG.  logarithm function double precision.

            subroutines         SIMULA name
            * DLOG.             LN


     DSIN.  contains SINE and COSINE double precision

            subroutines         SIMULA name
            * DCOS.             COS
            * DSIN.             SIN


     DSQRT. computes square root double precision.

            subroutine          SIMULA name
            * DSQRT.            SQRT


     EXIDOT FORTRAN interface

            subroutine
     * EXIT.                     Performs EXIT UUO - FORTRAN
                     program (final) exit


     EXP.   exponential function single precision

            subroutine          SIMULA name
            * EXP.              EXP
DECsystem-10 SIMULA Language Handbook, part II           Page 207
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     EXP1   calculates an integer raised to an integer power,
            single precision.

            subroutine          SIMULA notation
            * EXP1.             A**B


     EXP2   calculates a floating point number raised to a fixed
            point power.

            subroutine          SIMULA notation
            * EXP2.             A**B


     EXP3   calculates a floating point number raised to a
            floating point power, single precision.

            subroutine          SIMULA name
            * EXP3.             A**B

     FORXIT handles FORTRAN interface

            subroutine
     * EXIT                      Program exit initiated from F40
                     library subroutine


     MA     contains auxiliary mathematical subroutines.

            subroutines         function
             .MACI              convert from long real to integer
             .MACL              convert from integer to long real


     OCSP   sets up the environment for a SIMULA program, loads
            the (initial) high segment and passes control to
            OCIN.


     PHFO   handles interface between SIMULA and FORTRAN.


     PHPT   handles parameter transmission to formal, virtual and
            external MACRO-10 procedures.


DECsystem-10 SIMULA Language Handbook, part II           Page 208
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     RD     random drawing routines.

            subroutine          SIMULA name
             .RDDI              DISCRETE
             .RDDR              DRAW
             .RDER              ERLANG
             .RDHI              HISTD
             .RDHO              HISTO
             .RDLI              LINEAR
             .RDNE              NEGEXP
             .RDNO              NORMAL
             .RDPO              POISSON
             .RDRA              RANDINT
             .RDUN              UNIFORM


     SANE   allocates event notices for SIMULATION.


     SIN    contains routines to handle SINE and COSINE, single
            precision.

            subroutine          SIMULA name
            * COS.              COS
            * SIN.              SIN


     SINH   hyperbolic SINE function, single precision.

            subroutine          SIMULA name
            * SINH.             SINH


     SQRT   square root single precision

            subroutine          SIMULA name
            * SQRT.             SQRT


DECsystem-10 SIMULA Language Handbook, part II           Page 209
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     SS     implements SIMSET


            subroutine          SIMULA name
             .SSCA               CARDINAL
             .SSCL               CLEAR
             .SSEY               EMPTY
             .SSFO               FOLLOW
             .SSHD               HEAD
             .SSIT               INTO
             .SSLG               LINKAGE
             .SSLK               LINK
             .SSOU               OUT
             .SSPC               PRECEDE
             .SSPD               PRED
             .SSSC               SUC
             .SSST               SIMSET

     SU     implements SIMULATION.

            subroutine          SIMULA name
             .SUAC              ACTIVATE,REACTIVATE
             .SUAM              ACCUM
             .SUCA              CANCEL
             .SUEV              EVTIME
             .SUHO              HOLD
             .SUMA              MAIN PROGRAM
             .SUNE              NEXTEV
             .SUPA              PASSIVATE
             .SUPS              PROCESS
             .SUSI              SIMULATION
             .SUWA              WAIT


     TAN    contains TANGENT single precision

            subroutine          SIMULA name
            TAN.                 TAN


     TANH   hyperbolic TANGENT single precision.

            subroutine          SIMULA name
            * TANH.             TANH
DECsystem-10 SIMULA Language Handbook, part II           Page 210
APPENDIX F RUN-TIME SYSTEM COMPONENTS


     Run-Time module sizes (may be changed in the future).

            Module              Size(octal)

            ACOS.               55
            ALOG.               111
            ASIN.               54
            ATAN.               66
            CFRXIT              6
            COSH.               45
            CP                  370
            CS                  704
            DATAN.              141
            DEXP.               163
            DEXP.2              74
            DEXP.3              62
            DLOG.               205
            DSIN.               211
            DSQRT.              101
            EXIDOT              1
            EXP.                74
            EXP1                102
            EXP2                143
            EXP3                111
            FORXIT              5
            IO                  2411
            IOED                321
            IONF                1557
            MA                  40
            OCEP                1260
            OCIN                3445
            OCIO                545
            OCSP                367
            PH                  330
            PHFO                300
            PHPT                577
            RD                  567
            SA                  1772
            SANE                67
            SIMRT1              306
            SIMRT2              306
            SIMRTS              210
            SIN.                113
            SINH.               74
            SQRT                46
            SS                  274
            SU                  677
            TAN                 61
            TANH.               63
            TX                  2006
            TXBL                402
DECsystem-10 SIMULA Language Handbook, part II           Page 211
APPENDIX F RUN-TIME SYSTEM COMPONENTS


APPENDIX G RESERVED SIMULA WORDS AND STANDARD IDENTIFIERS
=========================================================


     The following words are reserved SIMULA words and must not
     be used for other purposes.


               ACTIVATE            LE
               AFTER               LONG
               AND                 LT
               ARRAY               NAME
               AT                  NE
               BEFORE              NEW
               BEGIN               NONE
               BOOLEAN             NOT
               CHARACTER           NOTEXT
               CLASS               OR
               COMMENT             OPTIONS
               DELAY               OTHERWISE
               DO                  PRIOR
               ELSE                PROCEDURE
               END                 PROTECTED
               EQ                  QUA
               EQV                 REACTIVATE
               EXTERNAL            REAL
               FALSE               REF
               FOR                 SHORT
               GE                  STEP
               GO                  SWITCH
               GOTO                TEXT
               GT                  THEN
               HIDDEN              THIS
               IF                  TO
               IMP                 TRUE
               IN                  UNTIL
               INNER               VALUE
               INSPECT             VIRTUAL
               INTEGER             WHEN
               IS                  WHILE
               LABEL
DECsystem-10 SIMULA Language Handbook, part II           Page 212
APPENDIX G RESERVED SIMULA WORDS AND STANDARD IDENTIFIERS


     The following words are SIMULA standard identifiers and not
     reserved words, i.e.  they may be redeclared.


          ABS               HOLD              OUTREAL
          ACCUM             IDLE              OUTTEXT
          ARCCOS            IMAGE             PASSIVATE
          ARCSIN            INCHAR            POISSON
          ARCTAN            INFILE            POS
          BLANKS            INFRAC            PRECEDE
          BREAKOUTIMAGE     INIMAGE           PRED
          CALL              ININT             PREV
          CANCEL            INREAL            PRINTFILE
          CARDINAL          INTEXT            PROCESS
          CHAR              INTO              PUTCHAR
          CLEAR             LAST              PUTFIX
          CLOSE             LASTITEM          PUTFRAC
          COPY              LENGTH            PUTINT
          COS               LETTER            PUTREAL
          COSH              LINE              RANDINT
          CURRENT           LINEAR            RANK
          DETACH            LINESPERPAGE      RESUME
          DIGIT             LINK              SETPOS
          DIRECTFILE        LINKAGE           SIGN
          DISCRETE          LN                SIMSET
          DRAW              LOCATE            SIMULATION
          EJECT             LOCATION          SIN
          EMPTY             LOWTEN            SINH
          ENDFILE           MAIN              SPACING
          ENTIER            MOD               SQRT
          ERLANG            MORE              STRIP
          EVTIME            NEGEXP            SUB
          EXP               NEXTEV            SUC
          FIRST             NORMAL            SYSIN
          FOLLOW            OPEN              SYSOUT
          GETCHAR           OUT               TAN
          GETFRAC           OUTCHAR           TANH
          GETINT            OUTFILE           TERMINATED
          GETREAL           OUTFIX            TIME
          HEAD              OUTFRAC           UNIFORM
          HISTD             OUTIMAGE          WAIT
          HISTO             OUTINT
DECsystem-10 SIMULA Language Handbook, part II                Page 213
APPENDIX H  SAMPLE JOB LISTINGS


APPENDIX H SAMPLE JOB LISTINGS
==============================


H.1 THE R COMMAND
     The following command cause the system to input to the compiler
     the concatenation of two source files, SRC1.SIM and SRC2.SIM.
     The compiler produces object code in the file OBJECT.REL and
     LIST.LST contains a listing of the complete input file together
     with a cross reference table.

  .R SIMULA

  *OBJECT.REL,LIST.LST=SRC1/C,SRC2

  NO ERRORS DETECTED
  *SIMPRO/C/I

         8     OPTIONS(/H);
  SIM005  W LINE     8     HELP NOT VALID IN OPTIONS STATEMENT,
                           IGNORED
 
        17     LOOP:
        18     SYSUT.OUTTEXT("WHICH RECORD?");
  SIM362  E LINE    17     IDENTIFIER SYSUT IS NOT DECLARED 
        23    LOCATION(I);
  SIM337  E LINE    23     INCORRECT NUMBER OF PARAMETERS TO LOCATION 

  ERRORS DETECTED:
      1 TYPE W MESSAGES
      2 TYPE E MESSAGES

  *^C
  .


     The last command to the compiler caused the source program
     SIMPRO.SIM to be compiled.  A cross reference listing was
     generated and named SIMPRO.LST and the created object code file
     was called SIMPRO.REL.  A line number table in the rel file was
     also generated.  The program contains errors and messages were
     output on the TTY.
DECsystem-10 SIMULA Language Handbook, part II                Page 214
APPENDIX H  SAMPLE JOB LISTINGS


H.2 THE COMPILE COMMAND
     To concatenate source files when using the COMPILE command, a
     + sign  should  be  used.   A cross reference listing of both
     source files, named SRC1.LST, will be created.

  .COMPILE/CREF SRC1+SRC2

  SIMULA:  SRC1

  EXIT

  .


H.3 THE LOAD COMMAND

     SIMPRO, the same source file  as  above,  is  compiled.   The  -W
     switch  suppresses the warning message.  The switch -A suppresses
     code for array bounds checking.  Switches  given in this  way  
     (via COMPIL) must not be separated by comma or slash.

  .LOAD SIMPRO(-W-A)

  SIMULA:  SIMPRO
   LOOP:
      SYSUT.OUTTEXT("WHICH RECORD?");
  SIM362  E LINE    17     IDENTIFIER SYSUT IS NOT DECLARED 
      LOCATION(I);
  SIM337  E LINE    23     INCORRECT NUMBER OF PARAMETERS TO LOCATION 

  ERRORS DETECTED:
      1 TYPE W MESSAGES
      2 TYPE E MESSAGES
  LINK:  Loading

  EXIT

  .
DECsystem-10 SIMULA Language Handbook, part II                Page 215
APPENDIX H  SAMPLE JOB LISTINGS


H.4 THE EXECUTE COMMAND

  .EXECUTE DF1A

  SIMULA:  DF1A
  LINK:  Loading
  [LNKXCT DF1A Execution]
  NUMBER OF RECORDS IN DF1.DAT =    49

  1 Garbage collection executed during 0 ms

  End of SIMULA program execution.
  CPU time: 1.45  Elapsed time: 7.84 

  .


H.5 THE DEBUG COMMAND

     The SIMULA compiler may also be invoked using the debug  command.
     For further examples on the use of SIMDDT see paragraph 9 of this
     appendix!

  .DEBUG DF1A

  SIMULA:  DF1A
  LINK:  Loading
  [LNKXCT DF1A Execution]
  SIMDDT STARTED 
  *P
  NUMBER OF RECORDS IN DF1.DAT =    49

  1 Garbage collection executed during 18 ms

  End of SIMULA program execution.
  CPU time: 1.41  Elapsed time: 3.60 

  .
DECsystem-10 SIMULA Language Handbook, part II                Page 216
APPENDIX H  SAMPLE JOB LISTINGS


H.6 CONTROL CARDS IN BATCH

     The $SIMULA card can be used if the SPRINT program (Spooling
     PRocessor for INpuT) is modified to recognize this control card.
     The general format of the $SIMULA card is:
     $SIMULA dev:prog.sim[PPN](SS...)/SW1/SW2.../SWn
     where
     (SS...) is processor switches in short notation
     /SW1/SW2.../SWn is the switches that control the mode of input
     interpretation and the listing of the compiled program.
     For a detailed description refer to 3.4.

     The example below illustrates how data can be input to a SIMULA
     program when the program is executing in the batch system.


  $JOB name [proj,prog]
  $PASSWORD:password
  $DECK SYSIN
  SYSIN ON DSK
  $EOD
  $SIMULA PROG.SIM(-WC)
  BEGIN
        SYSIN.IMAGE:-SYSOUT.IMAGE;
        INIMAGE;
        OUTIMAGE;
  END
  $EOD
  $EXECUTE
  *DEFAULT IS SYSIN FROM TTY
  .ASS DSK SYSIN
  $EXECUTE
  ;DSK:SYSIN created by the $DECK SYSIN card is read.
  .ASS CDR SYSIN
  $DATA
  SYSIN ON SPOOLED CDR
  $EOD
  ;The $DATA card will generate a funny named spooled CDR file.
  ;In this example SYSIN is used, but other files can be used in
  ;the same way.
  $EOJ


DECsystem-10 SIMULA Language Handbook, part II                Page 217
APPENDIX H  SAMPLE JOB LISTINGS


     When the file above on cards or on a disk file is input to SPRINT
     the following CTL file will be generated and submitted.


  .COMPIL /COMP/SIM DSK:PROG.SIM(-WC)/LIST
  .EXECUT /LINK/REL DSK:PROG.REL
  *DEFAULT IS SYSIN FROM TTY
  .ASS DSK SYSIN
  .EXECUT /LINK/REL DSK:PROG.REL
  ;DSK:SYSIN created by the $DECK SYSIN card is read
  .ASS CDR SYSIN
  .SET CDR TD9
  .EXECUT /LINK/REL DSK:PROG.REL
  ;The $DATA card will generate a funny named spooled CDR file.
  ;In this example SYSIN is used, but other files can be used in
  ;the same way.
  %FIN:: .DELETE DSK:TD9.CDR


     The job will produce the following log file:


  12:42:52 STDAT 16-OCT-74 QZ 601A7vm  SPRINT Version 1(634)
                 Running on DSK
  12:42:52 STCRD $JOB name [proj,prog]
  12:42:52 STERR %SPTEPF Extraneous Password Card Found - Ignored
  12:42:52 STCRD $DECK SYSIN
  12:42:52 STMSG File  DSK:SYSIN.  Created - 1 Cards Read - 
                1 Blocks Written
  12:42:52 STCRD $EOD
  12:42:52 STCRD $SIMULA PROG.SIM(-WC)
  12:42:53 STMSG File  DSK:PROG.SIM  Created - 5 Cards Read - 
                1 Blocks Written
  12:42:53 STCRD $EOD
  12:42:53 STCRD $EXECUTE
  12:42:53 STCRD $EXECUTE
  12:42:53 STCRD $DATA
  12:42:53 STMSG File  DSK:TD9.CDR  Created - 1 Cards Read - 
                1 Blocks Written
  12:42:53 STCRD $EOD
  12:42:53 STCRD $EOJ
  12:42:53 STSUM End of File After 26 Cards
  12:42:53 STSUM Batch Input Request Created
  12:42:58 BVERS  BATCON 10(107) INP: SUBJOB 01 OF 14
  12:42:58 BDATE  16-Oct-74
  12:42:58 BASUM  name[proj,prog] FOR **[proj,prog]
                 Log file in [proj,prog] 
                Request created at  12:42:55 16-Oct-74
                Unique: 2 Restart: 1
  12:42:58 MONTR  
  12:42:58 MONTR  .LOGIN proj/prog
DECsystem-10 SIMULA Language Handbook, part II                Page 218
APPENDIX H  SAMPLE JOB LISTINGS


  12:43:02 USER   JOB 18 QZ 601A7vm TTY76
  12:43:04 USER   Means left: -291607,50 Kr
  12:43:04 USER   [LGNJSP Other jobs same PPN]
  12:43:07 USER   1243 16-Oct-74 Wed
  12:43:12 USER   
  12:43:12 USER   QZ 601A7vm 12:43:08 TTY76
  12:43:12 USER   Job 18   User OWNER
  12:43:12 USER   .SET TIME 0
  12:43:12 MONTR  .SET TIME 300
  12:43:12 MONTR  
  12:43:12 MONTR  .SET SPOOL ALL
  12:43:13 MONTR  
  12:43:13 MONTR  ..COMPIL /COMP/SIM DSK:PROG.SIM(-WC)/LIST
  12:43:17 USER   
  12:43:17 USER   SIMULA:  PROG
  12:43:24 MONTR  
  12:43:24 MONTR  EXIT
  12:43:24 MONTR  
  12:43:24 MONTR  ..EXECUT /LINK/REL DSK:PROG.REL
  12:43:26 USER   LINK: Loading
  12:43:28 USER   [LNKXCT PROG Execution]
  12:43:29 USER   *DEFAULT IS SYSIN FROM TTY
  12:43:29 USER   DEFAULT IS SYSIN FROM TTY
  12:43:29 USER   
  12:43:29 USER   End of SIMULA program execution.
  12:43:29 USER   CPU time: 0.11 Elapsed time: 0.62 
  12:43:29 MONTR  
  12:43:29 MONTR  ..ASS DSK SYSIN
  12:43:29 MONTR  DSK assigned
  12:43:29 MONTR  
  12:43:29 MONTR  ..EXECUT /LINK/REL DSK:PROG.REL
  12:43:30 USER   LINK: Loading
  12:43:33 USER   [LNKXCT PROG Execution]
  12:43:33 USER   SYSIN ON DSK
  12:43:33 USER    
  12:43:33 USER   1 Garbage collection executed during 19 ms
  12:43:33 USER   
  12:43:33 USER   End of SIMULA program execution.
  12:43:33 USER   CPU time: 0.13 Elapsed time: 1.06 
  12:43:34 MONTR  
  12:43:34 MONTR  .
                ;DSK:SYSIN created by the $DECK SYSIN card is read
  12:43:34 MONTR  .ASS CDR SYSIN
  12:43:34 MONTR  %Logical name was in use, Spooled CDR assigned
  12:43:34 MONTR  
  12:43:34 MONTR  ..SET CDR TD9
  12:43:34 MONTR  
  12:43:34 MONTR  ..EXECUT /LINK/REL DSK:PROG.REL
  12:43:35 USER   LINK: Loading
  12:43:36 USER   [LNKXCT PROG Execution]
  12:43:37 USER   SYSIN ON SPOOLED CDR
DECsystem-10 SIMULA Language Handbook, part II                Page 219
APPENDIX H  SAMPLE JOB LISTINGS


  12:43:37 USER    
  12:43:37 USER   1 Garbage collection executed during 0 ms
  12:43:37 USER   
  12:43:37 USER   End of SIMULA program execution.
  12:43:37 USER   CPU time: 0.12 Elapsed time: 0.28 
  12:43:37 MONTR  
  12:43:37 MONTR  .
                ;The $DATA card will generate a funny named spooled
                 CDR file.
                ;In this example SYSIN is used, but other files can be
                 used in
                ;the same way.


  H.7 EXAMPLE OF CTL FILE IN BATCH

       The following CTL file was used:

   .execute df2a
   .execute df2d
   *5
   *000000
   *150
   *old end
   *160
   *new end
   *155
   *000000
   *-1


       The following LOG file was generated:
       (Only relevant parts of LOG file shown)

  14:39:15 MONTR  ..execute df2a
  14:39:22 USER   
  14:39:22 USER   SIMULA:  DF2A
  14:39:40 USER   LINK:   Loading
  14:39:40 USER   [LNKXCT DF2A Execution]
  14:39:53 USER   NUMBER OF RECORDS IN DF2.DAT =   150
  14:39:53 USER     
  14:39:53 USER   1 Garbage collection executed during 30 ms
  14:39:53 USER   
  14:39:53 USER   End of SIMULA program execution.
  14:39:53 USER   CPU time: 1.52   Elapsed time: 13.06 
  14:39:58 MONTR  
  14:39:58 MONTR  ..execute df2d
  14:40:00 USER   
  14:40:00 USER   SIMULA:  DF2D
  14:40:10 USER   LINK:   Loading
  14:40:10 USER   [LNKXCT DF2D Execution]
DECsystem-10 SIMULA Language Handbook, part II                Page 220
APPENDIX H  SAMPLE JOB LISTINGS


  14:40:10 USER   WHICH RECORD?
  14:40:10 USER   *5
  14:40:10 USER   OLD RECORD:
  14:40:10 USER   000153040110020
  14:40:10 USER   NEW RECORD:
  14:40:10 USER   *000000
  14:40:10 USER   WHICH RECORD?
  14:40:10 USER   *150
  14:40:10 USER   OLD RECORD:
  14:40:10 USER   001683100614210
  14:40:10 USER   NEW RECORD:
  14:40:10 USER   *old end
  14:40:11 USER   WHICH RECORD?
  14:40:11 USER   *160
  14:40:11 USER   OLD RECORD:
  14:40:11 USER   --NON-EXISTENT--
  14:40:11 USER   NEW RECORD:
  14:40:11 USER   *new end
  14:40:11 USER   WHICH RECORD?
  14:40:11 USER   *155
  14:40:11 USER   OLD RECORD:
  14:40:11 USER   /*
  14:40:11 USER   NEW RECORD:
  14:40:11 USER   *000000
  14:40:12 USER   WHICH RECORD?
  14:40:12 USER   *-1
  14:40:12 USER   END OF UPDATE
  14:40:12 USER     
  14:40:12 USER   1 Garbage collection executed during 11 ms
  14:40:12 USER   
  14:40:12 USER   End of SIMULA program execution.
  14:40:12 MONTR  CPU time: 0.26   Elapsed time: 2.66 
  14:40:12 MONTR  
  14:40:12 MONTR  .
DECsystem-10 SIMULA Language Handbook, part II                Page 221
APPENDIX H  SAMPLE JOB LISTINGS


  H.8 SOURCE CODE LISTING WITH ERRORS AND
             CROSS REFERENCE TABLE


     The first line of the header shows the version of the compiler
     and the creation date and time of the listing.  The second line
     contains information on the source text:  Name, PPN, creation
     date and time.  Text given in a PAGE switch will be added to the
     standard header.  The page number consists of a main number
     updated at form feeds in the source text and a secondary number
     updated at line overflow or PAGE switches.  The default value is
     55 lines per page including the header.  The BEGIN/END numbers
     are printed in the left margin.  If several BEGINs and/or ENDs
     appear on the same line, only the numbers of the first BEGIN and
     last END are printed.  Line numbers are provided if they are not
     present in the source text.  If there are faulty line numbers
     present they are replaced by correct ones.  An error message is
     inserted in the listing after the source code line to which it
     refers.  If a faulty statement covers more than one line the
     error message appears after the last faulty line.  If, on the
     other hand, there are several statements on a line the faulty one
     is marked like the one in line 22 below.
DECsystem-10 SIMULA Language Handbook, part II                Page 222
APPENDIX H  SAMPLE JOB LISTINGS


     SIMULA    1   2-OCT-1974  13:22             PAGE    1
     SIMPRO.SIM   [13,325]   2-OCT-1974  12:52  

     B1   1      BEGIN
          2 
          3 COMMENT  ***  DF2D         ***
          4    ***  THIS PROGRAM UPDATES  ***
          5    ***  RECORDS IN DF2.DAT    ***
          6 ;
          7 
          8    OPTIONS(/H);

     SIM005  W LINE     8     HELP NOT VALID IN OPTIONS STATEMENT,
                              IGNORED 

          9 
         10    REF(DIRECTFILE) FIL1;
         11    INTEGER  I;
         12    FIL1:-NEW DIRECTFILE("FIL1 DF2.DAT/I:15");
         13 
         14    INSPECT FIL1 DO
     B2  15        BEGIN
         16       OPEN(BLANKS(15));
         17    LOOP:
         18       SYSUT.OUTTEXT("WHICH RECORD?");

     SIM362  E LINE    17     IDENTIFIER SYSUT IS NOT DECLARED 

         19       SYSOUT.OUTIMAGE;
         20       SYSIN.INIMAGE;
         21       I:=SYSIN.ININT;
         22       IF I = -1 THEN GOTO 0VER;  LOCATION(I);

     SIM154  E LINE    22     MISSING BINARY OPERATOR 
     SIM362  E LINE    22     IDENTIFIER VER IS NOT DECLARED 
     SIM360  E LINE    22     INVALID OPERAND TYPE OF OPERATOR GOTO 
     SIM337  E LINE    22:1   INCORRECT NUMBER OF PARAMETERS TO
                              LOCATION 

         23       SYSOUT.OUTTEXT("OLD RECORD:"); SYSOUT.OUTIMAGE;
         24       IF ENDFILE THEN
         25          SYSOUT.OUTTEXT("--NON-EXISTENT--")
     B3  26           ELSE  BEGIN
         27          INIMAGE;
         28          SYSOUT.OUTTEXT(IMAGE.STRIP)
     E3  29              END;
         30       SYSOUT.OUTIMAGE;
         31       OUTTEXT(BLANKS(15));
         32       SETPOS(1);
         33       SYSOUT.OUTTEXT("NEW RECORD:");
DECsystem-10 SIMULA Language Handbook, part II                Page 223
APPENDIX H  SAMPLE JOB LISTINGS


     SIMULA    1   2-OCT-1974  13:22             PAGE   1-1
     SIMPRO.SIM   [13,325]   2-OCT-1974  12:52  

         34       SYSOUT.OUTIMAGE;
         35       SYSIN.INIMAGE;
         36       LOCATE(I);
         37       OUTTEXT(SYSIN.IMAGE.STRIP); OUTIMAGE;
         38       GOTO LOOP;
         39    OVER: CLOSE;
     E2  40        END;
         41    OUTTEXT("END OF UPDATE"); OUTIMAGE;
     E1  42     END


     DEFAULT SWITCHES USED


     ERRORS DETECTED:
         1 TYPE W MESSAGES
         5 TYPE E MESSAGES
DECsystem-10 SIMULA Language Handbook, part II                Page 224
APPENDIX H  SAMPLE JOB LISTINGS


     SIMULA    1   2-OCT-1974  13:22             PAGE    2
     SIMPRO.SIM   [13,325]   2-OCT-1974  12:52   CROSS REFERENCE TABLE


     BLANKS           16       31   
     CLOSE            39   
     DIRECTFILE       10       12   
     ENDFILE          24   
     FIL1             10D      12       14   
     I                11D      21       22M      36   
     IMAGE            28       37   
     INIMAGE          20       27       35   
     ININT            21   
     LOCATE           36   
     LOCATION         22   
     LOOP             17D      38   
     OPEN             16   
     OUTIMAGE         19       23       30       34       37       41
     OUTTEXT          18       23       25       28       31       33
                      37       41   
     OVER             39D  
     SETPOS           32   
     STRIP            28       37   
     SYSIN            20       21       35       37   
     SYSOUT           19       23M      25       28       30       33
                      34   
     SYSUT            18   
     VER              22   

     The cross reference table shows where identifiers  were  declared
     and used.  For each identifier the line numbers of all references
     are listed.  The line number may be  succeeded  by  one  or  more
     letters with the following meaning:

     D  line contains declaration
     E  external identifier
     M  more than one reference to same identifier on this line
DECsystem-10 SIMULA Language Handbook, part II                Page 225
APPENDIX H.9 SIMDDT EXAMPLES, PROGRAM LISTING


     SIMULA    1A(121)  30-SEP-1974  20:50     PAGE    1
     DEMDDT.SIM     [13,127]  27-SEP-1974  11:50
     B1     1   BEGIN  COMMENT simddt demonstration program;
            2       INTEGER indexb1;  REAL rb1;  BOOLEAN bb1;
            3       TEXT tb1;  TEXT ARRAY tab1[1:3];
            4   
            5       TEXT PROCEDURE p1(fip1);
            6       INTEGER fip1;
     B2     7       BEGIN
            8           p2("TYPE INPUT TEXT");
            9           p1:-Intext(fip1);
     E2    10       END p1;
           11 
           12       PROCEDURE p2(ftp2);
           13       VALUE ftp2; TEXT ftp2;
     B3    14       BEGIN
           15           Outtext(ftp2);
           16           Outimage;
     E3    17       END p2;
           18 
     B4    19       Simulation BEGIN
           20           INTEGER isb;  REF (pc) refpc;
           21 
           22           Process CLASS pc;
     B5    23           BEGIN
           24               INTEGER ipc;  LONG REAL lrpc;
           25               CHARACTER ARRAY chapc[-1:2,0:1];
           26 
           27               ls: ipc:=ipc+1;
           28               Hold (10);
           29               GOTO ls;
     E5    30           END of pc;
           31 
           32           p2("ENTER SIMULATION");
           33           isb:=10;
           34           refpc:-NEW pc;
           35           ACTIVATE refpc;
           36           REACTIVATE Current AT 100;
           37           INSPECT refpc DO
           38           lrpc:=-1;
           39           p2("EXIT SIMULATION");
     E4    40       END of simulation block;
           41   
           42       tb1:-p1(3);
           43       p2("PROGRAM IS LOOPING WHEN BB1 IS FALSE");
           44       l:IF NOT bb1 THEN GOTO l;
           45       p2("ERROR WHEN INDEXB1 IS 0");
           46       tab1[indexb1]:-tb1;
           47       p2("ERROR CORRECTED");
     E1    48   END of simddt demonstration program;
DECsystem-10 SIMULA Language Handbook, part II                Page 226
APPENDIX H.9 SIMDDT EXAMPLES, ERROR DETECTED


     ;in appendix H.9 all user input
     ;is given with lower case letters
     ;and the output from the system with
     ;upper case.
     ;
     ;Terminal dialogue, error is found
     .debug demddt/list
     LINK: Loading
     [LNKXCT DEMDDT Execution]
     SIMDDT STARTED 
     *; set breakpoints
     stop at 27 ,6 "6"
     *stop at 38 if ipc=isb
     *proceed
     ENTER SIMULATION
     STOP AT MAIN:27 "6    " ,6
     *scheduled
     SCHEDULED PROCESSES 
         EVTIME=  5.0000000E+01 PC O 022157  DETACHED MAIN:29
         EVTIME=  1.0000000E+02 MAINPROGRAM O 021517  DETACHED 
     *input chapc[0,1]:='c'
     *input  chapc[-1,0]:=' '
     *proceed
     STOP AT MAIN:38 IPC = 10
     *chain
     OPERATING CHAIN 
         PC O 022157  DETACHED MAIN:29 INSPECT BLOCK 
         PREFIXED BLOCK SIMULATION O 021502  DETACHED MAIN:37
     *output refpc.lrpc,chapc,isb
     REFPC.LRPC = 0
     CHAPC[-1:2,0:1]
         [-1,0] = CHAR 9 
         [0,1] = 'c'
     ISB = 10
     *proceed
     EXIT SIMULATION
     TYPE INPUT TEXT
     123
     PROGRAM IS LOOPING WHEN BB1 IS FALSE
     ^C
     ^C
     .reenter
     ZYD623 SIMDDT ENTERED, PROGRAM INTERRUPTED AT MAIN:43
     *input bb1:=true
     *input tab1[1]:-tb1
     *input tb1:="56"
     *proceed
      ... CONTINUING ...
     ERROR WHEN INDEXB1 IS 0
     ? ERROR IN JOB 10 AT  MAIN:46
     ZYQ002 ARRAY INDEX OUT OF BOUNDS 
DECsystem-10 SIMULA Language Handbook, part II                Page 227
APPENDIX H.9 SIMDDT EXAMPLES, ERROR DETECTED


     *variables
     VARIABLES 
     MAIN O 000243  DETACHED O 000000
         BB1 = TRUE
         TB1 == O 022132 LENGTH= 3 POS= 4 "56
         TAB1[1:3]
             [1] == O 022132 LENGTH= 3 POS= 4 "56
     INFILE O 021130  TERMINATED 
         IMAGE == O 021154 LENGTH= 72 POS= 4 "123
     PRINTFILE O 021175  TERMINATED 
         IMAGE == O 021224 LENGTH= 72 POS= 1 " 
     PREFIXED BLOCK SIMULATION O 021451  TERMINATED 
         ISB = 10
         REFPC == PC O 022101  DETACHED MAIN:29
         MAIN == MAINPROGRAM O 021466  DETACHED O 003350
     MAINPROGRAM O 021466  DETACHED O 003350
     PC O 022101  DETACHED MAIN:29
         IPC = 10
         LRPC = -1.000000000000000E+00
         CHAPC[-1:2,0:1]
             [-1,0] = CHAR 9 
             [0,1] = 'c'
     *exit
     1 Garbage collection executed during 17 ms
     End of SIMULA program execution.
     CPU time: 0.77 Elapsed time: 17.24 
     .
DECsystem-10 SIMULA Language Handbook, part II                Page 228
APPENDIX H.9 SIMDDT EXAMPLES, ERROR CORRECTED


     ;terminal dialogue, error is corrected
     ;
     .execute demddt
     LINK: Loading
     [LNKXCT DEMDDT Execution]
     ENTER SIMULATION
     EXIT SIMULATION
     TYPE INPUT TEXT
     ^C
     .reenter
     190
     ZYD623 SIMDDT ENTERED, PROGRAM INTERRUPTED AT MAIN:9
     *; enter simddt via ^C and reenter
     ; monitor commands, note that user input must
     ; be given before simddt can start
     input bb1:=true
     *input indexb1:=3
     *proceed
     PROGRAM IS LOOPING WHEN BB1 IS FALSE
     ERROR WHEN INDEXB1 IS 0
     ERROR CORRECTED
     End of SIMULA program execution.
     CPU time: 0.29 Elapsed time: 12.74 
     .continue
     ZYD623 SIMDDT ENTERED, PROGRAM INTERRUPTED AT MAIN:49
     *; enter simddt after normal program exit
     noarrays
     VARIABLES EXCEPT ARRAYS 
     ZYD632 GARBAGE COLLECTOR NOT CALLED BEFORE VARIABLES TYPED 
     MAIN O 000243  DETACHED O 000000
         INDEXB1 = 3
         BB1 = TRUE
     INFILE O 021130  TERMINATED 
         IMAGE == O 021154 LENGTH= 72 POS= 4 "190
     PRINTFILE O 021175  TERMINATED 
     PREFIXED BLOCK SIMULATION O 021502  TERMINATED 
         ISB = 10
         REFPC == PC O 022157  DETACHED MAIN:29
         MAIN == MAINPROGRAM O 021517  DETACHED O 003350
     MAINPROGRAM O 021517  DETACHED O 003350
     P2 O 022131  MAIN:33
         FTP2 == O 022142 LENGTH= 16 POS= 1 "ENTER SIMULATION"
     PC O 022157  DETACHED MAIN:29
         IPC = 10
         LRPC = -1.000000000000000E+00
     P2 O 022226  MAIN:40
         FTP2 == O 022237 LENGTH= 15 POS= 1 "EXIT SIMULATION"
     P1 O 022253  MAIN:42
         FIP1 = 3
     P2 O 022266  MAIN:9
         FTP2 == O 022277 LENGTH= 15 POS= 1 "TYPE INPUT TEXT"
DECsystem-10 SIMULA Language Handbook, part II                Page 229
APPENDIX H.9 SIMDDT EXAMPLES, ERROR CORRECTED


     P2 O 022315  MAIN:44
         FTP2 == O 022326 LENGTH= 36 POS= 1 "PROGRAM IS LOOPING
     WHEN BB1 IS FALSE"
     P2 O 022346  MAIN:46
         FTP2 == O 022357 LENGTH= 23 POS= 1 "ERROR WHEN INDEXB1
     IS 0"
     P2 O 022374  MAIN:48
         FTP2 == O 022405 LENGTH= 15 POS= 1 "ERROR CORRECTED"
     *^C
     .
DECsystem-10 SIMULA Language Handbook, part II                Page 230
APPENDIX H.9 SIMDDT EXAMPLES, TRACING


     ;terminal dialogue, use simddt for tracing
     ;
     .load demddt
     LINK: Loading
     EXIT
     .save
     Job saved
     .reenter
     SIMDDT STARTED 
     *; use simddt for program tracing
     ; set breakpoints
     at 8 fip1
     *at 14 ftp2
     *at 28 if ipc<=4
     *at 39 ifchanged refpc.lrpc
     *stop at 43 if tb1 =/=notext
     *; direct simddt output to file
     use demtra.lst
     *; list the breakpoints
     breaks
     *proceed
     ENTER SIMULATION
     EXIT SIMULATION
     TYPE INPUT TEXT
     *111
     STOP AT MAIN:43 TB1 == O 022736 LENGTH= 3 POS= 4 "111"
     *output bb1,indexb1
     BB1 = FALSE
     INDEXB1 = 0
     *input bb1:=true
     *input indexb1:=2
     *proceed
     PROGRAM IS LOOPING WHEN BB1 IS FALSE
     ERROR WHEN INDEXB1 IS 0
     ERROR CORRECTED
     1 Garbage collection executed during 0 ms
     FILE: DEMTRA CLOSED AT TERMINATION
     End of SIMULA program execution.
     CPU time: 0.71 Elapsed time: 7.72 
     ;
     ;
     ;
     ;
     .type demtra.lst
     STOP AT MAIN:43 IF TB1 =/= NOTEXT
     AT MAIN:39 IFCHANGED REFPC.LRPC
     AT MAIN:28 IF IPC <= 4
     AT MAIN:15 FTP2
     AT MAIN:8 FIP1
      
     AT MAIN:15 FTP2 == O 022574 LENGTH= 16 POS= 1 "ENTER
DECsystem-10 SIMULA Language Handbook, part II                Page 231
APPENDIX H.9 SIMDDT EXAMPLES, TRACING


     SIMULATION"
     AT MAIN:28 IPC = 1
     AT MAIN:28 IPC = 2
     AT MAIN:28 IPC = 3
     AT MAIN:28 IPC = 4
     AT MAIN:39 REFPC.LRPC = -1.000000000000000E+00
     AT MAIN:15 FTP2 == O 022671 LENGTH= 15 POS= 1 "EXIT
     SIMULATION"
     AT MAIN:8 FIP1 = 3
     AT MAIN:15 FTP2 == O 022731 LENGTH= 15 POS= 1 "TYPE INPUT
     TEXT"
     STOP AT MAIN:43 TB1 == O 022736 LENGTH= 3 POS= 4 "111"
      
     BB1 = FALSE
     INDEXB1 = 0
      
     AT MAIN:15 FTP2 == O 022760 LENGTH= 36 POS= 1 "PROGRAM IS
     LOOPING WHEN BB1 IS FALSE"
     AT MAIN:15 FTP2 == O 023011 LENGTH= 23 POS= 1 "ERROR WHEN
     INDEXB1 IS 0"
     AT MAIN:15 FTP2 == O 023037 LENGTH= 15 POS= 1 "ERROR
     CORRECTED"
DECsystem-10 SIMULA Language Handbook, part II                Page 232
APPENDIX H.9 SIMDDT EXAMPLES, BATCH  


     .type demct4.ctl
     ;
     ;
     ;
     ;simula batch job with input
     ; data placed in the control file.
     ;demddb is equal to demddt with loop
     ; removed, lines 43 and 44 start with !.
     ;simddt will be called when the error is detected
     ; and when simddt requests input the batch control
     ; system will stop the execution (? in output) and
     ; start the monitor command after the 
     ; .if (noerror) batch command.
     ;the reenter command will cause simddt
     ; to continue where it was interrupted.
     .execute demddb
     *888
     *999
     .IF (NOERROR) .GOTO OK
     .REENTER
     *;simddt  will read the commands
     *;placed after the reenter monitor
     *;command.
     *output indexb1
     *exit
     OK::.


     .submit demct4.ctl
     ;
     ;
     ;
     ;
     ;terminal dialogue, run batch job
     ;
     .type demct4.log
     .
     .
     .
     20:27:24 MONTR  .
     20:27:24 MONTR  .execute demddb
     20:27:28 USER   
     20:27:29 USER   SIMULA:  DEMDDB
     20:27:35 USER   LINK: Loading
     20:27:37 USER   [LNKXCT DEMDDB Execution]
     20:27:40 USER   ENTER SIMULATION
     20:27:40 USER   EXIT SIMULATION
     20:27:40 USER   TYPE INPUT TEXT
     20:27:40 USER   *888
     20:27:44 USER   ERROR WHEN INDEXB1 IS 0
     20:27:44 USER   
DECsystem-10 SIMULA Language Handbook, part II                Page 233
APPENDIX H.9 SIMDDT EXAMPLES, BATCH  


     20:27:44 USER   ? ERROR IN JOB 13 AT  MAIN:46
     20:27:44 USER   ZYQ002 ARRAY INDEX OUT OF BOUNDS 
     20:27:44 USER   *
                     *999
     20:27:44 BATCH  .IF (NOERROR) .GOTO OK
     20:27:45 MONTR  .REENTER
     20:27:45 USER   
     20:27:45 USER    ... continuing ...
     20:27:45 USER   *;simddt  will read the commands
     20:27:47 USER   *;placed after the reenter monitor
     20:27:47 USER   *;command.
     20:27:47 USER   *output indexb1
     20:27:48 USER   0
     20:27:48 USER   *exit
     20:27:49 USER   
     20:27:49 USER   End of SIMULA program execution.
     20:27:49 USER   CPU time: 0.25 Elapsed time: 9.04 
     20:27:49 MONTR  
     20:27:49 MONTR  .
                     OK:
     20:27:50 MONTR  .


DECsystem-10 SIMULA Language Handbook, part II                Page 234
APPENDIX H.9 SIMDDT EXAMPLES, SEPARATE COMPILATION


     SIMULA    1A(121)  30-SEP-1974  20:50     PAGE    1
     p2.SIM [13,127]  25-SEP-1974  22:22 
       
           1   OPTIONS(/EXTERNAL);
           2  PROCEDURE p2(ftp2);
           3         VALUE ftp2; TEXT ftp2;
     B1    4         BEGIN
           5               Outtext(ftp2);
           6               Outimage;
     E1    7         END of p2;
      
     SWITCHES CHANGED FROM DEFAULT:
      
        E EXTERNAL CLASS/PROCEDURE
      
     NO ERRORS DETECTED





     SIMULA    1A(121)  30-SEP-1974  20:50     PAGE    1
     DEMDDE.SIM     [13,127]  27-SEP-1974  11:50
     B1     1   BEGIN  COMMENT simddt demonstration program;
            2       INTEGER indexb1;  REAL rb1;  BOOLEAN bb1;
            3       TEXT tb1;  TEXT ARRAY tab1[1:3];
            4   
            5       TEXT PROCEDURE p1(fip1);
            6       INTEGER fip1;
     B2     7       BEGIN
            8           p2("TYPE INPUT TEXT");
            9           p1:-Intext(fip1);
     E2    10       END p1;
           11 
           12       EXTERNAL PROCEDURE p2;
           13
           14
           15
           16
     E3    17
           18
     B3    19       Simulation BEGIN
     .
     .
     .
     .
DECsystem-10 SIMULA Language Handbook, part II                Page 235
APPENDIX H.9 SIMDDT EXAMPLES, SEPARATE COMPILATION


     ;terminal dialogue, separate compilation
     ; of simula modules.
     ;
     ;when no special switches are set (see next page)
     ;the extension of the first file in the debug
     ;command determines which debug system is used.
     ;
     ;
     ;
     .debug p2,demdde
     SIMULA:p2
     SIMULA:demdde
     LINK: Loading
     [LNKXCT DEMDDE Execution]
     SIMDDT STARTED 
     *;debugging external modules
     stop at p2:6
     *proceed
     STOP AT P2:6 
     *chain
     OPERATING CHAIN 
         P2 O 022137  MAIN:33
         PREFIXED BLOCK SIMULATION O 021510  DETACHED MAIN:20
     *remove at 6
     *stop at 42
      stop at 42
     ZYD637 INVALID LINE NUMBER 
     *stop at main:42
     *proceed
     ENTER SIMULATION
     EXIT SIMULATION
     STOP AT MAIN:42 
     *output bb1
     FALSE
     *exit
     End of SIMULA program execution.
     CPU time: 0.29 Elapsed time: 11.88 
     .
DECsystem-10 SIMULA Language Handbook, part II                Page 236
APPENDIX H.9 SIMDDT EXAMPLES, BOTH DDT AND SIMDDT


     ;terminal dialogue, use of both ddt and simddt
     ;
     .debug %"debug:ddt" demddt
     LINK: Loading
     [LINKDEB DDT Execution]
         
     $g
     simddt STARTED
     *stop at 7
     *proceed
     STOP AT MAIN:7
     *;exit SIMddt and enter DDT
     ^C
     .ddt
     15/ 27030
     jrst 2,@.jbren$x
     ... CONTINUING ...
     ;simddt entered from ddt
     ;simddt still expecting command
     output bb1
     FALSE
     *;continue normal processing
     .
     .
     .
     .
DECsystem-10 SIMULA Language Handbook, part II                Page 237
APPENDIX I ERROR REPORT


APPENDIX I  ERROR REPORT
========================


     Software errors in the SIMULA system should be reported to
     SIMULA maintenance, Section 142, Swedish National Defence
     Research Institute, S-104 50 STOCKOLM 80, SWEDEN using the
     error report form on the next page (or a copy of it).

     The failing program and relevant input data (listings and,
     if necessary, convenient storage medium) should be submitted
     together with the report.  If the error can be isolated in a
     smaller and simpler program, this program should be
     submitted.

     If there has been any changes made to the SIMULA system at
     your installation, please indicate this on the error report
     and submit listings of changed software components with all
     modifications indicated.
DECsystem-10 SIMULA Language Handbook, part II                Page 238
APPENDIX I ERROR REPORT


                   DECsystem-10 SIMULA ERROR REPORT

------------------------------------------------------------------
 Send report to SIMULA maintenance, Section 142, Swedish National   
    Defence Research Institute, S-104 50, STOCKHOLM 80, SWEDEN.  
------------------------------------------------------------------
INSTALLATION:                                RELEASE NO:
CUSTOMER'S NAME:                             TELEPHONE:
ADDRESS:                                     YOUR REFERENCE:

ATTACHED TO THIS REPORT ARE:                  COMPILATION LISTING []
TTY OR LOG LISTING   []   SOURCE PROGRAM []   OBJECT PROGRAM      []
TEST MATERIAL        []            OTHER []:

PLEASE INDICATE MODIFICATIONS TO THE SIMULA SYSTEM:
NO []     YES [] COMPONENTS:

PROBLEM DESCRIPTION:


















                                                     CONTINUED []
-----------------------------------------------------------------
                   For use by FOA/ENEA:           
-----------------------------------------------------------------
PROBLEM ANALYSIS:




CORRECTIVE ACTION TAKEN:                     DATE:




CORRECTED IN RELEASE NO:
DATE FOR CUSTOMER CONTACT:
-----------------------------------------------------------------
                !  !  !  !  !  !  !  PLEASE REFER TO THIS NUMBER
REGISTRATION NO !  !  !  !  !  !  !  IN FURTHER CORRESPONDENCE.
DECsystem-10 SIMULA Language Handbook, part II           Page 239
APPENDIX J PROGRAM MEASUREMENT SYSTEM


APPENDIX J:  PROGRAM MEASUREMENT SYSTEM.
=======================================

     FQC - MEASUREMENT AND TRACING SYSTEM FOR SIMULA PROGRAMS
     ========================================================

     If a SIMULA program has been developed which will be used
     very often, e.g.  as a part in a regularly used production
     system, it is often profitable to make some efforts to
     optimize the program.

     A central and sometimes non-trivial problem in program
     optimization is to find the innermost loops of the program.
     Once the execution profile of a program is known it is
     usually easy to make it faster with a few changes such as
     modifications in processing algorithms or by using a small
     machine language subroutine.

     DEC-10 SIMULA is delivered with a frequency measurement
     system which assists in spotting frequently executed parts
     of a SIMULA program.  The system consists of two SIMULA
     programs, FQCRED and FQCLST.

     The system is used as follows:

     The program to be analyzed must have been tested well enough
     to run to normal completion.  It is read by the program
     FQCRED which produces two modified versions of it, one of
     which is a compilable SIMULA program (.FQ1+.FQ2) and the
     other a listing later used to produce the frequency listing
     (.FQD).  The modified compilable program is automatically
     compiled (.FQR), linked and started.  It will, if normally
     terminated, produce a file of measured frequencies (.FQS)
     (subsequent runs will optionally update the frequencies in
     .FQS).  This file is merged with the listing output from
     FQCRED by the program FQCLST, which produces the final
     output (.FQL).

     The user may also measure the execution time for different
     parts of his program by editing calls to a procedure Z_T(I)
     into his program.  A call with I > 0 initiates a timing
     which is ended by a call with the corresponding negative I.
     The logic is as follows:
     +100>=I>0 T0[I]:= cptime;
     -100<=I<0 J:=-I;  ACC[J]:= ACC[J]+(cptime-T0[J]);
     Calls to Z_T may be overlapping (even partly).
DECsystem-10 SIMULA Language Handbook, part II           Page 240
APPENDIX J PROGRAM MEASUREMENT SYSTEM


     For example:

     BEGIN
      ....
      Z_T(+1);------------+
      ....                |
      Z_T(+2);---------+  |
      ....             |  |
      Z_T(+3);------+  |  |
      ....          |  |  |
      Z_T(-2);------)--+  |
      ....          |     |
      Z_T(-3);------+     |
      ....                |
      Z_T(-1);------------+
      ....
     END

     The resulting CPU-times will be presented at the end of the
     result file (.FQL).  For reliable results, do not try to
     measure too small intervals (depending on the precision of
     the timing).  Note that only such measurements that yielded
     accumulated times > 0 will be printed.

     The measured program should satisfy some restrictions:


     1.  The program must not contain the identifiers Z_Q, Z_T or
         Z__.


     2.  The program should not use any files on DSK:  named
         <program name>.FQ1 .FQ2 .FQR .FQD .FQS .FQL or .FQT.


     3.  The program should terminate through its last END.  I.e.
         not through a call to Exit or via SIMDDT.
DECsystem-10 SIMULA Language Handbook, part II           Page 241
APPENDIX J PROGRAM MEASUREMENT SYSTEM


     4.  The source code lines should preferably not contain any
         internal TABs (leading TABs are OK).  If so, the
         produced frequency indicators (|) might be misplaced
         (within such a line).  TABs may be removed with .COPY
         temp.sim=prog.sim(W).


     Note that the frequency indicators will be positioned at the
     first position of the symbol counted.  Its related number
     should be interpreted as the number of times this symbol has
     been PASSED during the execution.  An indicated label (L:)
     will thus tell how many times control passed the label from
     left, excluding explicit jumps (GO TO L).

     TRACING

     By adding the switch /T to the file specification requested
     by FQCRED a trace file (.FQT) will be produced, containing
     the number of each executed (counted) statement.  This may
     be useful when debugging Simulation programs or programs
     making use of Resume/Detach.  If the program terminates with
     an error the file with logical name TRACE must be closed
     before leaving SIMDDT (*Close TRACE).

     The result file (.FQL) will contain information about the
     number of the first traced statement on each source line.
     Consecutive numbers will be indicated as xx-yy in .FQT.
     Note that the file is created in APPEND mode adding new
     traces to the end of the file.  The trace file will contain
     the first six characters of the traced symbol followed by
     its statement number.

     Adding a number to the trace switch (/T:x) will trace the
     executed statements the first x times.  Every statement
     number will be displayed (no xx-yy compacting).  X must be
     >= 0, /T:0 is equivalent to /T.

     The use of tracing will considerably increase the execution
     time of the modified program.  Thus it is not recommended to
     use timing (Z_T) together with tracing.  The tracing may be
     switched off by calling the procedure TRACEOFF.  It may be
     activated again by calling TRACEON.

     If you want to include any of your external modules in the
     analysis, run the program SIMEXP prior to FQCRED.

     The following session illustrates the use of the system on
     the SIMULA program FLOPY.SIM.

          .RUN PUB:FQCRED
DECsystem-10 SIMULA Language Handbook, part II           Page 242
APPENDIX J PROGRAM MEASUREMENT SYSTEM


          Program:flopy

          FQCRED: CPU time: 1.40]
          Running modified program: SIMULA:  FLOPY
          LINK: Loading
          [LNKXCT FLOPY Execution]

          If you want to have the result run FQCLST.
          To accumulate the frequencies just type: START

          End of SIMULA program execution.
          CPU time: 1.44 Elapsed time: 3.08 

          ; The program may also be rerun
          ; with .EX[/REL flopy.FQR]

          .RUN PUB:FQCLST

          Program:flopy

          Result on file: DSK:FLOPY.FQL

          .DIRECT/F flopy

          FLOPY.SIM    User program
          FLOPY.FQ1    Modified file part 1 (prolog)
          FLOPY.FQ2    Modified file part 2 (epilog)
          FLOPY.FQD    Edited skeleton file with bars (|)
          FLOPY.FQR    REL-file from compilation of FQ1+FQ2
          FLOPY.FQS    Frequency + timing data (binary)
          FLOPY.FQL    Result file (merged FQS+FQD)


          .TYPE flopy.fql

                  BEGIN COMMENT FREQUENCY MEASUREMENT EXAMPLE;
                      INTEGER u,k;   TEXT t;
                      z_t(+1);
               1      |1
                      WHILE Draw(0.999,u) DO u:= u+2;
            1636      |1                     |1636
                      z_t(-1);
               1      |1
                      z_t(+2);
               1      |1
                      FOR u:= 1 STEP 1 UNTIL 5000 DO
               1      |1
                      IF t = NOTEXT THEN k:=k+1;
            5000      |5000              |5000
                      z_t(-2);
               1      |1
DECsystem-10 SIMULA Language Handbook, part II           Page 243
APPENDIX J PROGRAM MEASUREMENT SYSTEM


                      z_t(+3);
               1      |1
                      FOR u:= 1 step 1 UNTIL 5000 DO
               1      |1
                      IF t == NOTEXT THEN k:=k+1;
            5000      |5000               |5000
                      z_t(-3);
               1      |1
                      z_t(+4);
               1      |1
                      FOR u:= 1 step 1 UNTIL 5000 DO
               1      |1
                      IF TRUE THEN k:=k+1;
            5000      |5000        |5000
                      z_t(-4);
               1      |1
                  END;
               1  |1

          FQC results:
          Max frequency:      5000
          Sum frequency:     31649
          No. of executions:     1

          CPU timing: Total   1.08 sec.

          Call no.    Time spent    % of runtime
              1          0.095           8.77
              2          0.499          46.08
              3          0.250          23.08
              4          0.239          22.07


     Cleaning up afterwards might be done with .DELETE *.FQ?  
DECsystem-10 SIMULA Language Handbook, part II           Page 244
APPENDIX K TECO, SOS OR EDITS ON SIMULA PROGRAMS


K.   USING TECO, SOS OR EDITS ON SIMULA PROGRAMS
     ===========================================



K.1  WHY LINE NUMBERED SIMULA SOURCE PROGRAMS?

     Run time error messages in SIMULA include the number of the
     source program line at which the error occurred.  With the
     SIMULA debugging system (SIMDDT) you can place breakpoints
     at given lines in the source pogram.

     It is possible to use SIMDDT without line numbered source
     programs.  The SIMULA compiler will then number all lines in
     the source program seqentially starting with 1.  This
     numbering is printed on source program listings produced by
     the compiler.

     However, every time you insert a new line into a source
     program, the numbers of all later lines will be changed.
     This means that you cannot always use a slightly out-of-date
     program listing to decide where to put your breakpoints or
     to find out at which line the error occurred.

     If you use line numbered source files, the line number is
     usually incremented by 10 or more between successive lines.
     This gives you the possibility to insert new lines into a
     source program without changing all following line numbers.
     An old source program listing is then often sufficient when
     debugging with SIMDDT.

     If you have a line numbered file with the line number
     incremented by 10 between successive lines, you can even
     insert more than 9 new lines between two old lines with TECO
     and SIMULA.

     You can give the new lines blank line numbers.  The SIMULA
     compiler will then assign line numbers to the blank numbered
     lines during the compilation.

     The SIMULA compiler will increment the line number by 1
     until a source line is encountered which has a number larger
     than that incremented by the SIMULA compiler.  If a file has
     three lines with numbers 140, 150 and 160, and 15 lines with
     blank number fields are put between line 140 and 150, then
     the SIMULA compiler will assign the numbers 141 to 155 to
     the new lines, and the old line 150 will be numbered 156.
     Line 160 and later lines in the source file will keep their
     original numbers.

     The algorithm in the SIMULA compiler is to compare the line
     number in the source file (if any) with the previous line
     number incremented by 1, and assign the larger of the two
     numbers to the line.
DECsystem-10 SIMULA Language Handbook, part II           Page 245
APPENDIX K TECO, SOS OR EDITS ON SIMULA PROGRAMS


     You can also let TECO or PIP renumber the file instead of
     accepting the automatic renumbering done by the SIMULA
     compiler.

     Example:

     File with 15 inserted new lines between two old lines:
     00140   comment line before insertion;
             comment first inserted line with blank line number;
             comment second inserted line with blank line number;
      . . . etc . . .
             comment 15th inserted line;
     00150   comment line after insertion;
     00160   comment line after line after insertion;

     File as numbered by the SIMULA compiler:
     00140   comment line before insertion;
       141   comment first inserted line with blank line number;
       142   comment second inserted line with blank line number;
      . . . etc . . .
       155   comment 15th inserted line;
       156   comment line after insertion;
     00160   comment line after line after insertion;

     As you can see from the example above, only one line after
     the insertion had to be renumbered by the SIMULA compiler.
     All succeeding lines keep their old numbers.


K.2  WHICH TEXT EDITOR SHOULD YOU USE?

     You may find it natural to use a line number oriented text
     editor like SOS or EDITS for line numbered files.  TECO has,
     however, the advantage of blank line numbers which means
     that there is no limit to the number of new lines you can
     insert between successive old lines in the file without
     renumbering the file.  WARNING:  SOS does not accept such
     files with blank line numbers that TECO can produce.


K.3 HOW TO USE SOS OR EDITS ON SIMULA SOURCE PROGRAMS

     When using SOS or EDITS you often split a file into several
     pages, each with its own line sequencing.  When given such a
     file, however, the SIMULA compiler will have to renumber
     parts of pages with overlapping line numbers and this might
     cause a lot of warning messages.  To avoid this you are
     advised to resequence the file monotonically by using the
     NP-command of SOS or N-command of EDITS:
                       NP <step> ,/1:/*,M
     where    2<=   step   <=entier(65535/number of lines).
     If there are less than 650 lines in your file you may
     accordingly use the default step size of 100.  The step size
     must not be 1, because the page marks that EDITS or SOS
DECsystem-10 SIMULA Language Handbook, part II           Page 246
APPENDIX K TECO, SOS OR EDITS ON SIMULA PROGRAMS


     inserts will be given line numbers by the SIMULA compiler
     and a step size of 1 would cause the rest of the file to be
     resequenced.

     If you prefer to use TECO, you should read the rest of this
     appendix.


K.4  HOW TO GIVE A FILE NEW LINE NUMBERS WITH TECO

     If you want to put line numbers on a previously unnumbered
     file, or if you want to resequence a file with new line
     numbers with the increment 10 between succeeding lines, then
     you should use the switch GENLSN with the .TECO or EB
     commands.

     Example:

     TECO simprg.sim/genlsn

     R TECO
     EBsimprg.sim/genlsn$y$$


K.5  EDITING A LINE NUMBERED FILE WITH TECO

     Editing a line numbered file is very similar to editing a
     file without line numbers.  You only have to remember that
     each line begins with a line number.  This line number is
     either five digits followed by a TAB or five spaces followed
     by a TAB.

     When you insert new lines into a file, you need not give
     them any line number.  TECO will automatically give them a
     line number of five spaces and a TAB when the file is output
     on disk.

     If you wish, you can give new lines explicit line numbers by
     inserting the new line number, followed by a tab, into the
     beginning of the new line.

     Example:

     File before editing:
     00140   Comment line before insertion;
     00150   Comment line after insertion;

     to insert a new line with blank line number you can write:
     s00150$0licomment new line to get a blank line number;$$

     to insert a new line with the line number 145 you can write:
     s00150$0li145   comment new line with line number and TAB;$$

     If you want a new line to begin with a sequence consisting
DECsystem-10 SIMULA Language Handbook, part II           Page 247
APPENDIX K TECO, SOS OR EDITS ON SIMULA PROGRAMS


     of five or less spaces or digits followed by a TAB, but do
     not want the sequence to be interpreted by TECO as a line
     number, then just insert five spaces and a TAB in front of
     that sequence.
DECsystem-10 SIMULA Language Handbook, part II           Page 248
APPENDIX L AUTOMATIC EDITING OF SIMULA PROGRAMS


     APPENDIX L AUTOMATIC EDITING OF SIMULA PROGRAMS
     ===============================================


     The SIMED program converts SIMULA source program files.  The
     program is able to


     1.  Indent the program (for better readability), and at the
         same time -

     2.  Count the number of BEGIN-END pairs.

     3.  Convert reserved words, standard and user identifiers to
         1) UPPER CASE 2) lower case or 3) Edit Case (1st char.
         upper case).

     4.  [Re]number the output file.


     Lines which become too long at indentation are split up at
     an appropriate position.  Long text constants will be split
     up according to the new, concatenated text constant format:
     "ABC"
     "DEF"

     Split up lines will not be indented properly if they contain
     BEGIN or END.  Also, numerical constants containing blanks
     may occasionally be improperly split.  The programmer is
     recommended to start source code lines with BEGIN and END
     resp.

     New command format for SIMED version 2:

     [outfile=]infile[/switches...]

     for example:

     outfile=infile/i:4/r:80/e:13200
     (Devices NUL:  and TTY:  are accepted.)

     Default switches:
     /I:4                Indent step 4.  Removes leading blanks
                         and tabs.  If negative then leading
                         blanks and tabs will be kept.

     /E:13200(UEL00)     Perform editing on the following items:
                         reserved words, standard ids, own ids,
                         Comments&Options, Text&Character
                         constants resp.  1 (U) = Upper CASE, 2
                         (L) = Lower Case, 3 (E) = Edit case, 0 =
DECsystem-10 SIMULA Language Handbook, part II           Page 249
APPENDIX L AUTOMATIC EDITING OF SIMULA PROGRAMS


                         no change.

     /R:80               Outfile record length 80.

     Other switches:
     /SIMSET             Recognize SIMSET identifiers (default
                         for SIMSET and SIMULATION blocks)

     /-SIMSET            Do not recognize SIMSET ids

     /SIMULATION         Recognize SIMULATION identifiers
                         (default for SIMULATION blocks)

     /-SIMULATION        Do not recognize SIMULATION ids

     /TABS               Use tabs in indentation (default)

     /-TABS              Do not use tabs

     /NUMBERED:xx        Produce line numbered output, incr.  xx
                         (default 100).  Explicit increment will
                         renumber the file.  The switch is
                         default if input file has line numbers.

     /-NUMBERED          Suppress line numbers on output.
                         (default if input file lacks line
                         numbers).

     /Z:n                Suppress indentation for n block levels
                         (default 0).  May be < 0 (>= -10),
                         assuming surrounding levels.

     /G                  Perform last COMPIL command after
                         processing

     !xxx                Run program XXX after processing

     Your own default switches can also be given in a file
     SWITCH.INI on your area with format:

     SIMED               /switch/switch...

     Example:  If you want files to be edited with reserved words
     in lower case, your own identifiers in upper case, and
     standard identifiers with upper case initial letter,
     standard indentation=2, record length=100, put the following
     line in SWITCH.INI:

     SIMED               /E:LEU/I:2/R:100

     Trailing zeros in the E switch may be omitted - the system
DECsystem-10 SIMULA Language Handbook, part II           Page 250
APPENDIX L AUTOMATIC EDITING OF SIMULA PROGRAMS


     default will be used in those positions.  You can always
     override the default values in the command to SIMED.

     Default extension is SIM.  Default outfile name is infile
     name.

     If you want only default values, the command string to edit
     the file X.SIM with the same output file name is simply X.

     The shortest possible command to apply SIMED to a file X.SIM
     is -

                         .R SIMED-X

     SIMED will take what follows after a minus sign as the first
     command and exit after editing.  CONTINUE will put SIMED in
     command mode, expecting further commands.  START or
     START-<command-string> may also be used in that situation.

     Exit from SIMED by entering ^Z or ^C.

     [The file SYS:SIMED.DAT used by SIMED version 1 is no longer
     required.]
DECsystem-10 SIMULA Language Handbook, part II           Page 251
APPENDIX M CONVERSION OF SIMULA PROGRAMS


     APPENDIX M CONVERSION OF SIMULA PROGRAMS
     ========================================


M.1 CONVERSION FROM IBM 360/370 SIMULA TO DEC SYSTEM-10 SIMULA

M.1.1 WHAT IS DONE BY THE IBMSIM PROGRAM

     The program IBMSIM can be used to perform the following
     conversion tasks:

   > Change the IBM source input control records like %PAGE,
     %TITLE, %SOURCE etc.  to their DEC 10 equivalents.

   > Eliminate IBM source control cards %(NO)LIST, %INDENT=n and
     %(NO)RESWD etc.  In order to indent your program, use the
     SIMED program (see appendix L) afterwards.

   > Convert long real constants to DEC 10 format.

   > Issue a warning if numerical constants are out of range.

   > Eliminate card sequence numbers if present.


M.1.2 WHAT IS NOT CONSIDERED BY THE IBMSIM PROGRAM

   > Conversion of hexadecimal constants to DEC 10 format.

   > IBM file names longer than six characters will not be unique
     if the first parts of two of more filenames are equal.

   > Maximal number of subscripts is 10 on DEC 10 and 127 on IBM.

   > Virtual quantities may may only be of the types defined in
     the COMMON BASE:  LABEL, SWITCH or PROCEDURE.  This problem
     is due to the extension of the IBM system and could often be
     overcome by the use of virtual type procedures.

   > Subscript checking is done for each element separately in
     the DEC 10 SIMULA system.  In the IBM system only the
     resulting index is checked.

   > The standard procedures RANK and CHAR return different
     results due to different collating sequences.  However,
     programs could often be written to be independent of this
     effect.

   > The facilities for creating and using EXTERNAL modules are
     much more powerful, and thus different, on the DEC 10.
DECsystem-10 SIMULA Language Handbook, part II           Page 252
APPENDIX M CONVERSION OF SIMULA PROGRAMS


   > Some of the mathematical standard procedures are not
     supplied in double precision in the first DEC 10 SIMULA
     release.  (The compiler will warn you in such cases.)

   > The maximum floating point number is approx.  1.7&+38, while
     for IBM it is about &+75.  A warning will be issued if the
     program contains real constants out of range.

   > The input file must not contain line numbers.




M.2 CONVERSION FROM DEC SYSTEM-10 TO IBM 360/370 SIMULA

M.2.1 WHAT IS DONE BY THE SIMIBM PROGRAM

     The program SIMIBM can be used to perform the following
     conversion tasks:

   > All lower case letters are translated to upper case.

   > Long real numerical constants are converted to IBM format.

   > All calls to standard procedure BREAKOUTIMAGE are replaced
     with OUTIMAGE.

   > The special COMMENT symbol '!' is converted to "COMMENT ".

   > The exponentiation symbol '^' is converted to "**".

   > All square brackets are converted to parentheses.

   > All lines longer than 72 characters are split.  The program
     tries to split the line at an appropriate position.
     However, numerical constants containing blanks or tabs could
     occasionally be improperly split.

   > The NOT symbol '\' and the NOT-EQUAL symbol '\=' are
     converted to NOT and NE respectively.

   > All tabs are translated to blank(s).

   > OPTIONS is translated to COMMENT.

M.2.2 WHAT IS NOT DONE BY THE SIMIBM PROGRAM

   > External declarations must be removed before processing.
     Use the SIMEXP program before running SIMIBM.

   > The input file must not contain line numbers.
DECsystem-10 SIMULA Language Handbook, part II           Page 253
APPENDIX M CONVERSION OF SIMULA PROGRAMS


M.3  CONVERSION FROM CDC SIMULA TO DEC SYSTEM-10 SIMULA

M.3.1 WHAT IS DONE BY THE CDCSIM PROGRAM

     The program CDCSIM can be used to perform the following
     conversion tasks:

   > Change characters from the CDC to the ASCII character set.

   > Change certain SIMULA words which are differently spelled on
     CDC and DEC (e.g.  "POWER" to "**", ".," to ";").

   > Find CDC identifiers longer than 12 characters, which are
     different but equal in their first 12 characters, and rename
     a few characters in one of them since only the first 12
     characters are significant on DEC SIMULA.

   > Rename identifiers which are reserved words on DEC but not
     on CDC (e.g.  ELSE or THEN).

   > Remove the delimiters surrounding operator words on CDC.

   > Optionally change CDC REAL variables and constants to
     DECsystem-10 LONG REAL, because of the smaller precision of
     REAL on the DECsystem-10.

   > Remove blanks inside identifiers.

M.3.2 WHAT IS NOT DONE BY THE CDCSIM PROGRAM

     Here is an incomplete list of things not done by the CDCSIM
     program:

   > Conversion of TEXT and CHARACTER constants.

   > Conversion of COMMENTS.

   > Conversion of the format of declarations of external FORTRAN
     and ASSEMBLY procedures.

   > Conversion because RANK and CHAR work differently with the
     CDC and the ASCII character codes.

M.3.3 PROBLEMS WHICH MAY OCCUR

     You may have trouble with multi-line text constants in some
     special cases.

     Since the conversion of the CDCSIM program from IBM to DEC
     SIMULA, it has only been tested on one very large CDC
     program, which program however was converted correctly.
DECsystem-10 SIMULA Language Handbook, part II           Page 254
APPENDIX M CONVERSION OF SIMULA PROGRAMS


     CDCSIM has however been tested very thoroughly on many IBM
     SIMULA installations before conversion to DEC.

M.3.4 HOW TO USE THE CDCSIM PROGRAM

     Just run the program and answer the questions put to you.
     The program will ask for:
   > File name for input CDC program and output DEC program.
   > If you want to list the output program on the TTY.
   > If you want the program to modify long identifiers to avoid
     name clashes.
   > If you want to modify yourself the first 8 characters of
     such clashing identifiers.

     The program will use default values for all input parameters
     except the file name of the CDC program.  Help is available
     by answering ?  to the questions given by the program.

     If you modify long identifiers, then the program will
     produce a temporary file TEMP.TMP.

     The program also has a facility to convert from UNIVAC to
     IBM SIMULA, but this facility has not been tested on DEC.
     The facility is triggered by a line "%CON" in the input
     file.

M.3.5 ACKNOWLEDGEMENT

     CDCSIM was originally produced by the Norwegian Computing
     Center for converting UNIVAC and CDC SIMULA programs to IBM.
     We are very grateful for their permission to modify it for
     CDC to DEC conversion.
DECsystem-10 SIMULA Language Handbook, part II           Page 255
APPENDIX N, THE DEC SYSTEM-10 SIMULA PROGRAM LIBRARY





APPENDIX N:  THE DEC SYSTEM-10 SIMULA PROGRAM LIBRARY
=====================================================


     This APPENDIX has been moved to the DECsystem-10 SIMULA
     Language Handbook Part III.  
DECsystem-10 SIMULA Language Handbook, part II           Page 256
APPENDIX O DUMP OF GENERATED CODE


     APPENDIX O DUMP OF CODE GENERATED BY THE SIMULA COMPILER
     ========================================================



     ;The simula compiler does not contain any
     ;built-in routine for generating a Macro 10
     ;listing of the generated code.
     ;It is possible to get such a listing with the
     ;help of the monitor command DUMP (or the DUMP program).
     ;You need a program listing with the
     ;line number table (Y switch set on
     ;during compilation) and a link map listing.
     ;
     ;
     .load /map simcod(ly)
     SIMULA: SIMCOD
     LINK: Loading
     EXIT
     .save
     Job saved
     .type simcod.lst

     SIMULA    1A(121)   1-OCT-1974  17:40     PAGE    1
     SIMCOD.SIM          [13,127]   1-OCT-1974  17:35 

     B1                      1 BEGIN
                             2     INTEGER ARRAY a[1:2];
                             3     PROCEDURE p;;
                             4     a[1]:=a[1]+1;
                             5     p;
     E1                      6 END

     DEFAULT SWITCHES USED

     NO ERRORS DETECTED


     SIMULA    1A(121)   1-OCT-1974  17:40     PAGE    2
     SIMCOD.SIM          [13,127]   1-OCT-1974  17:35  LINE
     NUMBER TABLE

     0  000052
     1  000060
     2  000062
     3  000067
     3  000070
     4  000071
     5  000100
     6  000102
     7  000104
DECsystem-10 SIMULA Language Handbook, part II           Page 257
APPENDIX O DUMP OF GENERATED CODE


     .type simcod.map


                          LINK-10 symbol map of SIMCOD  page 1
                         Produced by LINK-10 version 1B(131) on 
     1-Oct-74

     Low  segment starts at  0 ends at 710 length 711 = 1P
                         Start address is    212, located in
     program .MAIN
         
                          *************
     JOBDAT-INITIAL-SYMBOLS
                         Zero length module
                          *************

     .MAIN               from DSK:SIMCOD.REL[13,127] created by
     SIMULA /KI10
                         Low  segment starts at 140 ends at 363
     length 224 

                         .MAIN          212 Global symbol
     Relocatable         
                         .MAINL         313 Global symbol
     Relocatable         
                          *************
     OCSP                from SYS:SIMLIB.REL[1,4]
     .
     .
     ;Suppose that you want to get a listing of the
     ;code generated from statements in lines 4-6 in the
     ;simcod program. Then look at the line number table
     ;entries for these lines and also at the LINK-10 map
     ; for the program, where you find the .MAIN module 
     ;start address which is usually 140.
     ;Line 4 starts at address 000071 and
     ;line 6 ends at 000103.
     .get simcod
     Job setup

     .dump /OUT:TTY:/MODE:SYM/WIDTH:30/JUSTIFY:L/IRADIX:8
      /d [(140+71) & (140+103)

     231/                MOVE   5,2(15)                
     232/                MOVEI  6,1                    
     233/                CAML   6,4(5)                 
     234/                CAMLE  6,5(5)                 
     235/                UUO001 2                      
     236/                ADD    6,2(5)                 
     237/                AOS    3,(6)                  
     240/                MOVEI  1,251                  
DECsystem-10 SIMULA Language Handbook, part II           Page 258
APPENDIX O DUMP OF GENERATED CODE


     241/                PUSHJ  17,400011              
     242/                MOVEI  1,                     
     243/                DPB    1,143                  

     EXIT
DECsystem-10 SIMULA Language Handbook, part II           Page 259
APPENDIX P, CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA





APPENDIX P:  CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA
=========================================================


P.1  WHY TRANSLATE FROM ALGOL TO SIMULA?

     Here are some reasons why you may want to go over from
     DECsystem-10 ALGOL to DECsystem-10 SIMULA:

   > To use facilities which SIMULA has but not ALGOL, e.g.
     better data structuring, a garbage collector, simulation
     facilities, the SIMDDT system, higher security against
     programming errors, direct access i/o.

   > To use the text string handling in SIMULA, which is roughly
     five times faster than in ALGOL.

   > To use the formatted i/o in SIMULA, which is roughly twice
     as fast in SIMULA as in ALGOL.

     On the other hand, a SIMULA compilation takes nearly twice
     as long CPU time and requires about twice as much core as an
     ALGOL compilation.  For vector and matrix operations, SIMULA
     is faster with array bound check, ALGOL is faster without
     array bound check.

     What is said above applies to ALGOL version 3B and SIMULA
     version 3.

     If you want to make your own comparisons of the efficiency
     of ALGOL versus SIMULA, you are advised to compile the
     SIMULA programs with the option settings
     options(/-q/-a/-i/-d).  This will remove some debugging
     features from SIMULA which ALGOL version 3B does not have,
     and thus give a more just comparison.

P.2  WHY SIMULA IS NOT COMPATIBLE WITH DEC 10 ALGOL?

     The DECsystem-10 SIMULA system is made highly compatible
     with SIMULA on other computers, in order to make it easy to
     transfer SIMULA programs between computers of different
     manufacture.  Unfortunately, this compatibility with other
     SIMULA systems had to mean less good compatibility with
     DECsystem-10 ALGOL.

     The main areas of bad compatibility between ALGOL and SIMULA
     on the DECsystem-10 are input-output and text string
     handling.
DECsystem-10 SIMULA Language Handbook, part II           Page 260
APPENDIX P, CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA


     This appendix does not give a complete description of all
     that has to be changed to translate a program from ALGOL to
     SIMULA but some of the major points of difficulty are
     illustrated with examples.

P.3  TEXT STRING HANDLING

     Change STRING to TEXT when declaring text string variables.

     In SIMULA, a TEXT variable may not refer to a constant.
     Change T:= "TEXT CONSTANT" to T:- COPY("TEXT CONSTANT").

     Redeclare all INTEGER variables, which you use to store
     single characters, as CHARACTER variables.  In the
     following, the letter C indicates such a variable.

     Change C:= T.[N] into C:= FETCHAR(T,N).  Often repeated such
     ALGOL statements can be replaced by a single T.SUB operation
     in SIMULA.  (FETCHAR must be declared as an EXTERNAL
     CHARACTER PROCEDURE.)

     Instead of the procedure LINK, use the concatenation
     procedure CONC.  (CONC must be declared as an EXTERNAL TEXT
     PROCEDURE.)

     Replace LENGTH(T) by T.LENGTH.  Often, the SIMULA procedure
     MORE can be used instead of the ALGOL procedure LENGTH as in
     the following example:
     Change
     FOR I:= 1 UNTIL LENGTH(T) DO IF T.[I] = " ".[1] THEN ...
     into
     WHILE T.MORE DO IF T.GETCHAR = ' ' THEN ...

     Replace COPY(T,M) by COPY(T.SUB(1,M)), or by only
     T.SUB(1,M), if you are not going to independently modify the
     two texts.

     Replace NEWSTRING(N,7) by BLANKS(N).  Only 7-bit byte
     strings can be handled using the TEXT concept of SIMULA.

     Remove DELETE procedure calls from your program.  SIMULA has
     a garbage collector, so you need not bother with
     deallocation of core.  However, at a few special occasions,
     it might be worthwile to replace DELETE(T) by T:-NOTEXT.

DECsystem-10 SIMULA Language Handbook, part II           Page 261
APPENDIX P, CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA


P.4  INPUT/OUTPUT

     Replace INSYMBOL(C) by C:= INCHAR.  (Sometimes, the
     procedure GETCH is preferable.  GETCH must be declared as an
     EXTERNAL CHARACTER PROCEDURE.)

     Replace NEXTSYMBOL(C) by
     C:= IF MORE THEN IMAGE.SUB(POS,1).GETCHAR ELSE CHAR(13);

     Replace OUTSYMBOL(C) by OUTCHAR(C).  (Sometimes, OUTSYMBOL
     is better replaced by OUTCHR(SYSOUT,C,1).  OUTCHR must be
     declared as an EXTERNAL PROCEDURE.)

     Replace BREAKOUTPUT by BREAKOUTIMAGE.

     Replace WRITE(T) where T is a string variable or constant,
     by OUTTEXT(T).

     IMPORTANT:  You cannot use the special line editing
     characters inside output strings in SIMULA.  Replace them by
     calls to the corresponding explicit procedures.  For
     example, convert
     WRITE("FIRST LINE[N]SECOND LINE");
     into
     OUTTEXT("FIRST LINE");  OUTIMAGE;  OUTTEXT("SECOND LINE");

     Replace PAGE by EJECT(1) and NEWLINE by OUTIMAGE.

     Replace SPACE(N) by SETPOS(POS+N) and TAB by
     OUTCHAR(CHAR(9)).

     Instead of READ and PRINT you must choose the appropriate
     SIMULA procedure depending on the type of the argument.  For
     example, if R is a real value, PRINT(R,10,5) is converted
     into OUTFIX(R,5,17) and PRINT(R,0,5) is converted into
     OUTREAL(R,6,12).

     Note that SIMULA normally expects that the letter E is used
     in input data for the power-of-ten symbol.  This can however
     be changed to other characters with the SIMULA built-in
     procedure LOWTEN.

     BACKSPACE, ENDFILE and REWIND are not currently available in
     DECsystem-10 SIMULA (version 3).

     READOCTAL must be programmed in SIMULA, IOCHAN must be
     programmed in MACRO 10, except when you use IOCHAN to test
     for end-of-file.  In the latter case, use the SIMULA
     built-in procedure ENDFILE.

     For ordinary input and output to the TTY, you can in SIMULA
DECsystem-10 SIMULA Language Handbook, part II           Page 262
APPENDIX P, CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA


     directly use ININT, INREAL, OUTINT etc.  If you want to use
     other devices, the following information may be helpful:

     Instead of

     OUTPUT(5,"DSK");
     OPENFILE(5,"TEST.DAT",%177,%000011000050);

     write for example

     REF (OUTFILE) CHANNEL5;
     CHANNEL5:- NEW OUTFILE("DSK:  TEST.DAT[11,50] <177>");
     CHANNEL5.OPEN(BLANKS(130));

     Instead of CLOSEFILE(5) write for example CHANNEL5.CLOSE.

     Remove calls to the procedure RELEASE, since this function
     is automatically performed by the garbage collector in
     SIMULA.  In some cases, you might have to replace RELEASE(5)
     by CHANNEL5:- NONE.

     Instead of SELECTINPUT(5) you can for example write
     INSPECT CHANNEL5 DO
     BEGIN ...  END;

     The effect of SELECTINPUT might be simulated by:
                         REF (Outfile) ARRAY outchannels[1:10];
                         REF (Outfile) outchannel;
                         PROCEDURE selectinput(i); INTEGER i;
                         outchannel:-outchannels[i];
                         ...
                         outchannel.Outtext(...)
                         etc...

P.5  MISCELLANEOUS

     The so called "fat comma" method of inserting comments into
     procedure statements is not allowed in SIMULA.  Use ordinary
     comments instead.  Example:
     SPUR (A) ORDER:(7) RESULT TO:(V)
     can be changed to:
     SPUR (A, !ORDER;  7, !RESULT TO;  V);

     If you use "." as a readability symbol in identifiers,
     change it to "_".  Example:  TOP.OF.STACK in ALGOL is
     changed to TOP_OF_STACK in SIMULA.

     Not equal is "#" in ALGOL, "NE" in SIMULA.

     Octal constants in SIMULA begin with "8R", not with "%".
DECsystem-10 SIMULA Language Handbook, part II           Page 263
APPENDIX P, CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA


     "_" may not be used in SIMULA as an alternative to ":=".

     "DIV" in ALGOL is "//" in SIMULA.

     The operator "REM" in ALGOL should be changed to use the
     built-in INTEGER PROCEDURE "MOD" in SIMULA.

     SIMULA does not have the ALGOL built-in procedures BOOL,
     INT, IMIN, IMAX, RMIN, RMAX.

     The LONG REAL and REAL standard procedures (SIN etc.) have
     the same name in SIMULA.  The type of the procedure depends
     on the type of the argument.  Some of them are however
     always REAL.

     "CHECKON 1" in ALGOL is "OPTIONS(/ARRAY)" in SIMULA,
     "CHECKOFF 1" in ALGOL is "OPTIONS(/-ARRAY)" in SIMULA.
     Unlike ALGOL, checking of array bounds is default in SIMULA,
     and must be explicitly set off if you do not want it.

     FORWARD declarations in ALGOL can be removed in SIMULA.

     "LISTON" in ALGOL is "OPTIONS(/LIST)" in SIMULA.
     "LISTOFF" in ALGOL is "OPTIONS(/-LIST)" in SIMULA.

     SIMULA does not have the OWN concept of ALGOL.  You can get
     something similar (but much more powerful) by using a SIMULA
     class.

     Only the twelve first characters of an identifier are
     significant in SIMULA.

     The "@" symbol cannot be used for powers-of-ten in SIMULA
     source programs.  Use "&" instead.  The power-of-ten symbol
     for input data can be set dynamically with the SIMULA
     built-in procedure LOWTEN.  Default is "E".

     Do not double the characters [, ] and ;  in SIMULA TEXT
     constants.  However, " is doubled just as in ALGOL.

     Assignments inside expressions are not allowed in SIMULA.
     Change e.g. A:= B + (C:= D + E);  into C:= D + E;  A:= B +
     C;

     You cannot in SIMULA omit the STEP in FOR-statements.
     Change FOR V:= E1 UNTIL E3 DO S into FOR V:= E1 STEP 1 UNTIL
     E3 DO S.

     Simple variables (not TEXTs or ARRAYs) are in SIMULA by
     default transferred by VALUE in procedure calls, not by
     NAME.  If you need NAME transmission, this must be
DECsystem-10 SIMULA Language Handbook, part II           Page 264
APPENDIX P, CONVERSION FROM DEC 10 ALGOL TO DEC 10 SIMULA


     explicitly declared, e.g.
     PROCEDURE P(X);  NAME X;  REAL X;

     If an actual TEXT parameter is a constant, the corresponding
     formal parameter must in SIMULA always be declared as either
     VALUE or NAME in the procedure heading.

     The procedures DIM, LB, UB, GFIELD, SFIELD are not available
     in SIMULA but can easily be written as external MACRO 10
     procedures to SIMULA.

     The method of calling external FORTRAN procedures is
     slightly different in SIMULA.  For example instead of
     CALL(FORT,X,Y) you write in SIMULA:

     OPTIONS(/E:F40,FORT);                 -\  In a file called
     PROCEDURE FORT(A,B); REAL A, B;;      -/  FORT.SIM
      ...
     EXTERNAL PROCEDURE FORT;
      ...
     FORT(X,Y);

     Input-output is not allowed in FORTRAN when called from
     SIMULA.

     Further information about calling FORTRAN is given in
     appendix E.
DECsystem-10 SIMULA Language Handbook, part II           Page 265
INDEX


     INDEX
     =====



       in file name at run-time  .  51

     $  in logical name  . . . . .  50
     $, in file name at run time .  51
     $SIMULA card  . . . . . . . .  20, 216

     % in logical name . . . . . .  50
     %, in file name at run time .  51

     * (asterisk) in run-time file descriptor  51

     .SIM extension  . . . . . . .  17

     /SIMULA . . . . . . . . . . .  17

     10, power of, symbol  . . . .  261, 263

     <CR>  . . . . . . . . . . . .  15
     <IDENTIFICATION2> in SIMDDT .  69
     <IDENTIFICATION2> used in OUTPUT SIMDDT command  71
     <IDENTIFICATION> in SIMDDT  .  69
     <LINE> in SIMDDT  . . . . . .  68
     <MODULE> in SIMDDT  . . . . .  68
     <NNNNN> in SIMDDT . . . . . .  68
     <RELATION OPERATOR> . . . . .  70
     <STRING> in SIMDDT  . . . . .  69
     <SUBSCRIPT LIST> in SIMDDT  .  69

     ?LNKUGS undefined global symbols  18

     @ delimiter . . . . . . . . .  53
     @, SIMDDT command . . . . . .  75

     ABORT procedure, SIMDDT message  167
     ABS, system function  . . . .  29
     ACCESS switch . . . . . . . .  54, 57
     ACCUM, parameters . . . . . .  37
     actual record size in directfile  59
     ALGOL, conversion from ALGOL to SIMULA  259
     ALL, SIMDDT command . . . . .  75
     ALTMODE character . . . . . .  62
     altmode, object time I/O  . .  56
     Antithetic variables  . . . .  30
     append mode . . . . . . . . .  54, 57
     ARCCOS, system function . . .  29
     ARCCOSINE single precision, entry point  205
     ARCSIN, system function . . .  29
     ARCSINE function single precision, entry point  205
     ARCTAN, system function . . .  29
     ARCTANGENT single precision, entry point  205
     Arithmetic constants in source programs  88
     array bound checking, efficiency of  259
     ARRAY dimensions, number of, error message  118
     Array record, internal representation  93
     ARRAY size, error message . .  155
     ARRAY subscript, error message  150
     ARRAY switch  . . . . . . . .  23
     Array variables, internal representation  93
     ARRAY, utility macro for external MACRO-10 procedures  193
     ASCII device control characters  61
     ASCII mode I/O  . . . . . . .  49
     Assembly language procedures called from SIMULA  188
     Assembly language, external procedure  184
     ASSIGN command  . . . . . . .  50
     ASSIGN, utility macro for external MACRO-10 procedures  195
     asterisk (*) in run-time file descriptor  51
     AT, SIMDDT command  . . . . .  70
     ATR libraries . . . . . . . .  42
     Attributes, internal order  .  102
     Automatic editing of SIMULA programs by the SIMED program  248
     automatic library search  . .  24

     BACKSPACE (DECsystem-10 ALGOL)  261
     Basic symbols . . . . . . . .  88
     BASICIO . . . . . . . . . . .  61
     Batch . . . . . . . . . . . .  20, 216
     Bibliograhpy  . . . . . . . .  9
     Binary constants  . . . . . .  32
     binary mode I/O . . . . . . .  49
     blank line numbers  . . . . .  244
     Block instance, internal representation  98
     block level . . . . . . . . .  23
     Block level for external module  45
     BOOL (DECsystem-10 ALGOL) . .  263
     Boolean constants . . . . . .  89
     Boolean variables, internal representation  91
     BOOLEAN, utility macro for external MACRO-10 procedures  193
     BREAKOUTIMAGE . . . . . . . .  33, 57
     BREAKOUTPUT (DECsystem-10 ALGOL)  261
     breakpoint  . . . . . . . . .  63
     breakpoint in SIMDDT  . . . .  70
     breakpoints, line numbers for  244
     BREAKS, SIMDDT command  . . .  70
     buffer area . . . . . . . . .  54
     buffer ring . . . . . . . . .  54
     BUFFER switch . . . . . . . .  54

     CALL system procedure . . . .  33
     Capacity limitations, error message  125, 133, 155
     Capacity restrictions . . . .  35
     CARD batch example  . . . . .  216
     Card input to the compiler  .  86
     Cardinal function, efficiency of  79
     carriage return . . . . . . .  15
     CARRIAGE RETURN character . .  62
     carriage return, object time I/O  56
     CDC REAL precision higher than on DEC  253
     CDC SIMULA program conversion to DEC  253
     CDCSIM conversion program . .  253
     CHAIN, SIMDDT command . . . .  73
     CHAR built-in function  . . .  61
     CHAR, system function . . . .  29
     Character constants . . . . .  89
     CHARACTER constants, allowed characters in  61
     character conversion during I/O  61
     Character representation  . .  29, 87
     Character representation of special characters  87
     Character representation, initialization  29
     Character set, error message   115
     Character variables, internal representation  91
     CHARACTER, utility macro for external MACRO-10 procedures  193
     characters, device control, in ASCII-ISO  61
     CHECK . . . . . . . . . . . .  25
     CHECKOFF (DECsystem-10 ALGOL)  263
     CHECKON (DECsystem-10 ALGOL)   263
     class BASICIO . . . . . . . .  61
     class directfile  . . . . . .  59
     class infile  . . . . . . . .  56
     class instance  . . . . . . .  24
     Class instance, internal representation  99
     class outfile . . . . . . . .  57
     class printfile . . . . . . .  58
     close files . . . . . . . . .  152
     CLOSE, SIMDDT command . . . .  75
     CLOSEFILE (DECsystem-10 ALGOL)  262
     CODE  . . . . . . . . . . . .  25
     CODE MACRO-10 procedures, example  198
     Collating sequence  . . . . .  29
     colon, error message  . . . .  108
     comma . . . . . . . . . . . .  15
     command examples  . . . . . .  17
     command syntax (SIMDDT) . . .  68
     commands (COMPIL) . . . . . .  17
     comment . . . . . . . . . . .  34
     Comment conventions . . . . .  32
     Comment in source programs  .  89
     Common base definition  . . .  8
     Compatibility of programs to other computers  81
     compatibility with DECsystem-10 ALGOL  259
     compatibility with SIMULA on other computers  259
     COMPIL CUSP . . . . . . . . .  17
     COMPIL-class commands . . . .  17
     compilation core requirements  11
     COMPILE . . . . . . . . . . .  17
     Compile monitor command, example  214
     compiler commands . . . . . .  14
     Compiler input  . . . . . . .  86
     COMPILER SOURCE CODE DIAGNOSTICS  107
     compiler switches . . . . . .  15
     compiler switches DEBUGS and IDENTIFICATION  64
     Components, Run-Time system, entry points  202
     concatenation of source files  17
     Constants in source programs   88
     contents, table of  . . . . .  3
     CONTINUE command  . . . . . .  65
     Control cards in batch  . . .  216
     Control cards to SPRINT . . .  22
     Control Data SIMULA program conversion  253
     Control-C . . . . . . . . . .  16
     Control-Z character . . . . .  62
     Controlled variable, restrictions  37
     conversational input and output  261
     conversion from ALGOL to SIMULA  259
     conversion from CDC to DEC of SIMULA programs  253
     conversion of SIMULA programs  11, 252
     Conversion of SIMULA programs from UNIVAC to DEC  254
     conversion of source code . .  11
     CONVERT source program conversion program  254
     COPY TEXT procedure . . . . .  260
     Copyright . . . . . . . . . .  2
     Copyright of the SIMULA system  2
     core requirements . . . . . .  11
     Core size of run time system, entry points  210
     core usage, optimization of .  80
     Coroutine handling, error message  154
     COS, system function  . . . .  29
     COSH, system function . . . .  29
     cost of using SIMULA as compared to ALGOL  259
     CP module, entry points . . .  202
     Creating line numbered files in SIMULA  55
     CREF (in COMPIL)  . . . . . .  17
     CREF switch . . . . . . . . .  23
     cross reference listing . . .  23
     CS module, entry points . . .  202
     CTL file, example . . . . . .  219

     DATA TRANSMISSION in ALGOL versus SIMULA  261
     Ddt   . . . . . . . . . . . .  236
     DDT when you wanted SIMDDT  .  64
     debug mode (SIMDDT) . . . . .  68
     DEBUG monitor command . . . .  17, 45, 64
     DEBUG monitor command, example  215
     Debugging system (SIMDDT) . .  63
     debugging system (SIMDDT) and line numbers  244
     DEBUGS switch . . . . . . . .  23
     DEC monitors  . . . . . . . .  10
     DECsystem-10 ALGOL, conversion into SIMULA  259
     DECUS library . . . . . . . .  9
     defining documents  . . . . .  8
     DELETE (DECsystem-10 ALGOL) .  260
     delimiters in file descriptor  15
     DETACH, error message . . . .  154
     device control characters in ASCII-ISO  61
     device, in run-time file descriptor  50
     device, source  . . . . . . .  14
     devices for directfile  . . .  60
     devices for infile  . . . . .  57
     devices for outfile . . . . .  57
     devices for printfile . . . .  58
     Diagnostic messages at run time  147
     Diagnostic messages from the compiler  107
     Dimensions, number of, error message  118
     directfile  . . . . . . . . .  59
     DISCRETE, parameters  . . . .  37
     disk block  . . . . . . . . .  59
     Display record, internal representation  97
     Display terminals, how to avoid automatic eject  85
     DISPLAY, SIMDDT command . . .  72
     distribution of library programs  255
     DIV operator (DECsystem-10 ALGOL)  263
     dollar in logical name  . . .  50
     dollar, in file name at run-time  51
     double precision  . . . . . .  34
     DUMP monitor command  . . . .  256
     Dynamic addresses, internal representation  94
     Dynamic records, internal representation  97

     Edit overflow . . . . . . . .  28
     Editing characters in source programs  90
     editing of SIMULA source programs  244
     Editing SIMULA programs automatically by the SIMED program  248
     EDITS text editor . . . . . .  245
     efficiency of SIMULA compared to ALGOL  259
     Efficient call on MACRO-10 procedures  188
     Efficient program writing . .  78
     EJECT . . . . . . . . . . . .  58
     END comment warnings  . . . .  90
     END comments in source programs  90
     end of file record  . . . . .  56, 60
     ENDFILE (DECsystem-10 ALGOL)   261
     ENDFILE, for directfile . . .  60
     ENDFILE, for infile . . . . .  56
     ENTERDEBUG procedure, SIMDDT message  167
     ENTIER, system function . . .  29
     equal sign  . . . . . . . . .  15
     Erroneous programs, treatment of, error message  150
     error messages  . . . . . . .  24
     error messages from LINK-10 .  18
     Error messages from the compiler  107
     Error messages, at run time .  147
     error mode (SIMDDT) . . . . .  68
     Error report  . . . . . . . .  237
     ESCAPE character  . . . . . .  62
     escape from run-time dialogue  49
     Eventnotice record, internal representation  100
     Eventnotice, internal representation  101
     examples of SIMDDT commands .  76
     EXECUTE . . . . . . . . . . .  17
     EXECUTE monitor command . . .  45
     Execution time error messages  147
     EXIT, SIMDDT command  . . . .  75
     EXP, system function  . . . .  29
     exponent part of PUTREAL and OUTREAL  28
     exponential function double precision, entry point  206
     extension, in run-time file descriptor  50
     extension, listfile . . . . .  14
     extensions  . . . . . . . . .  34
     external class  . . . . . . .  23
     EXTERNAL declaration  . . . .  39
     EXTERNAL FORTRAN or MACRO, error message  109
     external image  . . . . . . .  59
     external libraries for ATR and REL files  44
     external library specification  24
     External module, block level of  45
     external modules  . . . . . .  39
     external procedure in FORTRAN  185
     External procedure in MACRO-10  188
     external procedure in MACRO-10 or FORTRAN  184
     external program  . . . . . .  23
     EXTERNAL switch . . . . . . .  23, 25
     External switch in options statement  45

     fat comma comment convention of ALGOL 60  262
     file allocation . . . . . . .  57
     file definitions  . . . . . .  49
     file descriptor . . . . . . .  50
     file descriptor delimiters  .  15
     file descriptor format  . . .  14
     File handling at run time, error message  151, 156
     file name, in run-time file descriptor  50
     file object . . . . . . . . .  49
     file specification at run time  49, 54
     file specification in /RUNSWITCHES  24
     File specifications in /RUNSWITCHES  26
     filename, listfile  . . . . .  14
     FILES switch  . . . . . . . .  54
     FOR statement, controlled variable, restrictions  37
     FOR statements, efficiency considerations  79
     FORLIB functions, entry points  205
     FORM FEED character . . . . .  62
     form feed, in printfile . . .  58
     form feed, object I/O . . . .  56
     Formal parameter, specifications  38
     formatted i/o, efficiency of   259
     FORSIM utility program  . . .  185
     FORTRAN calls, ALGOL versus SIMULA  264
     FORTRAN external procedure  .  185
     FORTRAN external procedures using i/o  185
     FORTRAN external procedures using the FORTRAN high segment  185
     FORTRAN interface, entry points  207
     FORTRAN library functions used in SIMULA, entry points  205
     FORTRAN library, error message  167
     FORTRAN programming example .  187
     FORTRAN, error message  . . .  109
     FORTRAN, external procedure .  184
     FORWARD declarations  . . . .  263
     FORWARD declarations (DECsystem-10 ALGOL)  263
     FQC program for program measurements  239
     Fraction format, input  . . .  28
     FREECHANNEL, utility macro for external MACRO-10 procedures  194
     Frequency count on program execution  239
     FUDGE2 program for handling libraries  44
     Function designator instance, internal representation  99
     Functions, standard . . . . .  211
     Funny file name at run-time .  51

     garbage collection  . . . . .  54
     garbage collection, optimization of  80
     generated code  . . . . . . .  256
     GENLSN switch for TECO  . . .  246
     GET monitor command . . . . .  64
     GETAADD, utility macro for external MACRO-10 procedures  195
     GETADD, utility macro for external MACRO-10 procedures  195
     GETCHANNEL, utility macro for external MACRO-10 procedures  194
     GETREAL precision . . . . . .  79
     GETTADD, utility macro for external MACRO-10 procedures  195
     GETTYPE, utility macro for external MACRO-10 procedures  196
     GETVAL, utility macro for external MACRO-10 procedures  195
     global run-time switches  . .  54
     GO TO, error message  . . . .  155

     Hardware representation . . .  86
     help files  . . . . . . . . .  12
     HELP switch . . . . . . . . .  23
     HELP switch at run-time . . .  55
     HELP, SIMDDT command  . . . .  75
     Hexadecimal constants . . . .  32
     HIDDEN specification  . . . .  34
     High segment  . . . . . . . .  11
     High segment at run time, entry points  202
     high segment components, Run Time System, entry points  202
     high segment of FORTRAN . . .  185
     HISTD, parameters . . . . . .  37

     I/O at run time, error message  152, 156
     I/O in SIMULA programs  . . .  49
     I/O, in FORTRAN subroutines called from SIMULA  185
     IBM 360/370 . . . . . . . . .  8
     IDENTIFICATION switch . . . .  24
     Identifier representation . .  88
     Identifiers, number of, error message  125
     Identifiers, standard . . . .  211
     IF-statement, error messages   118
     IFCHANGED, SIMDDT command keyword  70
     IFEOF, utility macro for external MACRO-10 procedures  194
     IFNEOF, utility macro for external MACRO-10 procedures  194
     image size in directfile  . .  59
     image size of SYSIN . . . . .  61
     image size of SYSOUT  . . . .  61
     IMAGESIZE switch  . . . . . .  55, 59
     IMAX (DECsystem-10 ALGOL) . .  263
     IMIN (DECsystem-10 ALGOL) . .  263
     Improving the layout of SIMULA programs automatically (SIMED program)  248
     index . . . . . . . . . . . .  265
     indirect delimiter  . . . . .  53
     indirect specification file .  53
     infile  . . . . . . . . . . .  56
     INIMAGE, for infile . . . . .  56
     INIMAGE, utility macro for external MACRO-10 procedures  194
     Initialization of random number streams  30
     INPUT (DECsystem-10 ALGOL)  .  262
     input to SIMDDT . . . . . . .  66
     Input to the compiler . . . .  86
     INPUT, SIMDDT command . . . .  72
     Input-output at run time, error message  152, 156
     input-output, efficiency of .  259
     INPUT/OUTPUT in ALGOL versus SIMULA  261
     input/output in SIMULA  . . .  49
     input/output, in FORTRAN subroutines called from SIMULA  185
     INREAL precision  . . . . . .  79
     Inspect statement, efficiency of  79
     INSPECT, SIMDDT command . . .  72
     INSYMBOL (DECsystem-10 ALGOL)  261
     INT (DECsystem-10 ALGOL)  . .  263
     Integer constants . . . . . .  88
     integer constants . . . . . .  34
     integer to long real, entry point  207
     Integer variables, internal representation  91
     INTEGER, utility macro for external MACRO-10 procedures  193
     Internal representation . . .  91
     IO module, entry points . . .  202
     IOCHAN (DECsystem-10 ALGOL) .  261
     IOED module, entry points . .  203
     IONF module, entry points . .  202
     ISO device control characters  61
     ISO-7 . . . . . . . . . . . .  49

     Jumps, error message  . . . .  155

     KA10 CPU  . . . . . . . . . .  9
     Keywords  . . . . . . . . . .  88
     KI10 CPU  . . . . . . . . . .  9
     KL10 CPU  . . . . . . . . . .  9

     LABEL, utility macro for external MACRO-10 procedures  193
     Labels, unsigned integer  . .  38
     language extensions . . . . .  34
     leading spaces in command . .  15
     leading tabs in commands  . .  15
     left arrow  . . . . . . . . .  15
     legal characters in command .  15
     libraries of attribute files   42
     library of programs . . . . .  255
     library search at compile-time  24
     LIMIT switch  . . . . . . . .  55, 57
     Line editing characters in source programs  90
     LINE FEED character . . . . .  62
     line feed, object I/O . . . .  56
     line number in SIMDDT . . . .  68
     line number table . . . . . .  24-25
     Line number, error message  .  110
     line numbered files . . . . .  244
     Line numbering of files . . .  55
     Line numbers in input files .  86
     line numbers, blank . . . . .  244
     line numbers, format of . . .  246
     LINEAR, parameters  . . . . .  37
     LINED text editor . . . . . .  245
     LINESPERPAGE  . . . . . . . .  58
     LINK as used in DECsystem-10 ALGOL  260
     LINK-10 error messages  . . .  18
     LINK-10 error messages, explanation  17
     LINK-10 Linking loader  . . .  10
     Linkage class, internal representation  102
     LIST (in COMPIL)  . . . . . .  17
     LIST switch . . . . . . . . .  15, 24
     listfile  . . . . . . . . . .  14
     listfile extension  . . . . .  14
     listfile, default extension .  14
     listfile, page heading  . . .  25
     LISTOFF (DECsystem-10 ALGOL)   263
     LISTON (DECsystem-10 ALGOL) .  263
     Literature list . . . . . . .  9
     LN, system function . . . . .  29
     LNKUGS error message, explanation of  17
     LNKUGS undefined global symbols  18
     LOAD commands, errors caused by  17
     LOAD monitor command  . . . .  17, 45, 64
     LOAD monitor command without SIMULA-modified COMPIL  18
     LOAD monitor command, example  214
     Loading and executing programs with external modules  44
     local run-time switches . . .  54
     LOCATION  . . . . . . . . . .  60
     logarithm function double precision, entry point  206
     logarithm function single precision, entry point  205
     logical name  . . . . . . . .  50
     LONG REAL . . . . . . . . . .  34
     Long real constants . . . . .  89
     long real to integer, entry point  207
     Long real variables, internal representation  91
     LONGREAL, utility macro for external MACRO-10 procedures  193
     Low segment, RTS, entry points  205
     Lower case letters  . . . . .  88
     Lower case letters, use in portable program  29
     Lowered ten symbol  . . . . .  88
     lstfile . . . . . . . . . . .  14
     lstfile extension . . . . . .  14
     lstfile, default filename . .  14
     lstfile, page heading . . . .  25

     MA module, entry points . . .  207
     Macro 10 listing of generated code  256
     MACRO-10 procedures called from SIMULA  188
     MACRO-10 procedures, external, entry points  207
     Macro-10 procedures, how to write simula specifications  198
     MACRO-10 programming examples  198
     MACRO-10, external procedure   184
     magnetic tape . . . . . . . .  54
     main program  . . . . . . . .  23
     MAKLIB program for handling libraries  44
     Mathematical functions available  29
     Mathematical functions, argument and result type  29
     Mathematical functions, error message  167
     Mathematical subroutines in SIMLIB, entry points  205
     memory allocation, optimization of  80
     Messages, error, at run time   147
     Messages, error, from the compiler  107
     minus, error message  . . . .  108
     MOD, system function  . . . .  29
     monitor . . . . . . . . . . .  10

     NAME parameter transmission, ALGOL versus SIMULA  263
     NAME, utility macro for external MACRO-10 procedures  193
     National characters . . . . .  32
     NEW . . . . . . . . . . . . .  49
     NEWSTRING (DECsystem-10 ALGOL)  260
     NEXTSYMBOL (DECsystem-10 ALGOL)  261
     NOERR switch  . . . . . . . .  24
     NONE, internal representation  92
     NOPROCEED, SIMDDT command . .  75
     Norwegian Computing Center  .  254
     NULL character  . . . . . . .  62
     Null character  . . . . . . .  29
     Number sign, in file name at run-time  51
     Numbered lines in source programs  86
     NUMBERED switch . . . . . . .  55

     object program execution  . .  24
     object program I/O  . . . . .  49
     Object time error messages  .  147
     Object time system  . . . . .  11
     Object time system, entry points  202
     OCEP module, entry points . .  203
     OCIN module, entry points . .  203
     OCIO module, entry points . .  203
     OCSP module, entry points . .  207
     Octal constants . . . . . . .  32
     Octal digits in file name at run-time  51
     old source program listings, validity of line numbers  244
     OPENFILE (DECsystem-10 ALGOL)  262
     Operator words  . . . . . . .  88
     Operator words in SIMULA  . .  211
     Optimization of programs  . .  78, 239
     optimization, degree of in the compiler  259
     OPTIONS statement . . . . . .  25
     OPTIONS statement, error messages  108
     Options statement, external switch  45
     ordering SIMULA . . . . . . .  9
     outfile . . . . . . . . . . .  57
     OUTIMAGE, for infile  . . . .  56
     OUTIMAGE, for outfile . . . .  57
     OUTIMAGE, utility macro for external MACRO-10 procedures  194
     OUTPUT (DECsystem-10 ALGOL) .  262
     output from SIMDDT  . . . . .  66
     OUTPUT in ALGOL versus SIMULA  261
     output in FORTRAN subroutines called from SIMULA  185
     output, efficiency of . . . .  259
     OUTPUT, SIMDDT command  . . .  71
     OUTSYMBOL (DECsystem-10 ALGOL)  261
     Overflow, error message . . .  111, 115
     OWN . . . . . . . . . . . . .  38
     OWN (DECsystem-10 ALGOL)  . .  263
     OWN declaration . . . . . . .  263

     PAGE (DECsystem-10 ALGOL) . .  261
     page heading, list file . . .  25
     PAGE switch . . . . . . . . .  24-25
     Page, new, in program listing  221
     parameter delimiter . . . . .  38
     parameter transmision, ALGOL versus SIMULA  263
     Parameter transmission efficiency  79
     Parameter transmission to procedures  37
     Parameters to PROCEDUREs, error message  160
     Parameters, internal order  .  102
     Parameters, internal representation  96
     Part-compilation  . . . . . .  39
     percent, in file name at run-time  51
     percent, in logical name  . .  50
     Performance measurements  . .  239
     PH module, entry points . . .  203
     PHFO module, entry points . .  207
     physical block size . . . . .  59
     physical record size in directfile  59
     Portability of programs to other computers  81
     Portability of SIMULA from CDC to DEC  253
     power of ten symbol . . . . .  28
     power-of-ten symbol . . . . .  261, 263
     ppn, in run-time file descriptor  51
     precision, of REAL's: CDC compared to DEC  253
     Prefix block instance, internal representation  100
     PREV, system function . . . .  34
     PRINT (DECsystem-10 ALGOL)  .  261
     printfile . . . . . . . . . .  58
     PROC, utility macro for external MACRO-10 procedures  193
     PROCEDURE call, error message  160
     procedure in MACRO-10 or FORTRAN  184
     Procedure instance, internal representation  98
     Procedure parameter transmission  37
     Procedure parameter transmission efficiency  79
     PROCEDURE parameters, ALGOL versus SIMULA  263
     PROCEDURE, utility macro for external MACRO-10 procedures  193
     PROCEED, SIMDDT command . . .  73
     Process class, internal representation  102
     Program input to the compiler  86
     program library . . . . . . .  255
     Program listing . . . . . . .  25, 221
     Program measurement and optimization  239
     Program, source, input to the compiler  86
     Programs on cards . . . . . .  86
     PROTECTED specification . . .  34
     protection, in run-time file descriptor  51
     Pseudo random number generator  30
     Pseudo-random drawing, error message  162

     QUALIFICATION switch  . . . .  24
     Quasi-parallel processing, error message  154
     QUICK . . . . . . . . . . . .  25
     QUICK MACRO-10 procedures, example  200
     QUICK, assembly parameter in MACSIM  193
     QUICK, external MACRO-10 procedure  188
     QUICKPROC, macro in MACSIM  .  193, 196

     R command . . . . . . . . . .  14
     Radix constants . . . . . . .  88
     radix representation  . . . .  34
     random access . . . . . . . .  49, 59
     Random drawing procedures, parameters  37
     random drawing routines, entry points  208
     Random drawing, error message  162
     Random drawing, generator . .  30
     Random number generator . . .  30
     RANK, system function . . . .  29
     RD module, entry points . . .  208
     READ (DECsystem-10 ALGOL) . .  261
     read only file  . . . . . . .  54
     READOCTAL (DECsystem-10 ALGOL)  261
     Real constants  . . . . . . .  88
     REAL precision on CDC and on DEC  253
     Real variables, internal representation  91
     REAL, utility macro for external MACRO-10 procedures  193
     record size in directfile . .  55, 59
     REENTER monitor command . . .  10, 64
     REENTER, error message  . . .  177
     Reentrant code, generation of  11
     Reentrant high segment  . . .  11
     REF, utility macro for external MACRO-10 procedures  193
     Reference variables, internal representation  92
     References  . . . . . . . . .  9
     relative record number  . . .  59
     RELEASE (DECsystem-10 ALGOL)   262
     Release of SIMULA, conditions of  2
     Release version of SIMULA . .  1
     relfile . . . . . . . . . . .  14
     REM operator (DECsystem-10 ALGOL)  263
     REMOVE, SIMDDT command  . . .  70
     renumbering of source program lines  244
     Representation in hardware  .  86
     Representation of identifiers  88
     Representation of special characters  87
     Reserved SIMULA words . . . .  211
     Responsibility for errors . .  2
     Restrictions on the compiler   35
     restrictions with FORTRAN as called from SIMULA  185
     RESUME, error message . . . .  154
     RETURN, utility macro for external MACRO-10 procedures  194
     REWIND (DECsystem-10 ALGOL) .  261
     RMAX (DECsystem-10 ALGOL) . .  263
     RMIN (DECsystem-10 ALGOL) . .  263
     RONLY . . . . . . . . . . . .  54
     RTS I/O . . . . . . . . . . .  49
     Run time error messages . . .  147
     run time errors . . . . . . .  65
     run-time core requirements  .  11
     run-time dialoque, escape from  49
     run-time I/O  . . . . . . . .  49
     Run-Time module sizes, entry points  210
     run-time switches . . . . . .  52, 54
     Run-time system . . . . . . .  11
     Run-Time systems components, entry points  202
     RUNSWITCHES switch  . . . . .  24, 26, 52

     SA module, entry points . . .  203
     SANE module, entry points . .  208
     SAVE monitor command  . . . .  64
     SCHEDULED, SIMDDT command . .  74
     search list for ATR files . .  42
     SEARCH switch . . . . . . . .  24, 26
     segmentation into separately compiled parts  39
     SELECTINPUT (DECsystem-10 ALGOL)  262
     Separate compilation  . . . .  39
     Separate compilation, simddt example  235
     separately compiled FORTRAN procedure  185
     Separately compiled module, block level of  45
     Separately compiled procedure in MACRO-10  188
     separately compiled procedure in MACRO-10 or FORTRAN  184
     sequential access . . . . . .  56-57
     SETTYPE, utility macro for external MACRO-10 procedures  196
     SFD in run-time file descriptor  51
     Sharable reentrant code, generation of  11
     SHORT INTEGER . . . . . . . .  34
     Short integer variables, internal representation  91
     SIGN, system function . . . .  29
     SIMCOM.HLP  . . . . . . . . .  12
     SIMDDT  . . . . . . . . . . .  23, 63
     Simddt and ddt  . . . . . . .  236
     SIMDDT command examples . . .  76
     SIMDDT commands . . . . . . .  70
     Simddt examples . . . . . . .  225
     SIMDDT, automatic loading of   11
     SIMDDT, handling of line numbered source programs  244
     SIMDDT, loading of  . . . . .  64
     SIMDDT.HLP  . . . . . . . . .  12
     SIMDIR program  . . . . . . .  11
     SIMED program for editing SIMULA program files  248
     SIMLIB  . . . . . . . . . . .  10
     SIMLIB, library file, entry points  205
     SIMRT1, SIMRT2 modules, entry points  203
     SIMRTS module, entry points .  203
     SIMRTS, entry points  . . . .  202
     SIMRTS.HLP  . . . . . . . . .  12, 55
     SIMULA debugging system . . .  63
     SIMULA program conversion . .  11
     SIMULA program library  . . .  255
     SIMULA Standard identifiers .  212
     SIMULA Standards group  . . .  8
     SIMULA, reserved words  . . .  211
     SIMULA.HLP  . . . . . . . . .  12
     Simulation block, internal representation  101
     SIMULATION, CLASS, error message  163
     SIMULATION, concurrent instances of  27
     SIN, system function  . . . .  29
     SINH, system function . . . .  29
     SIZE switch . . . . . . . . .  55, 57-58
     Software performance report .  237
     Software problem report . . .  237
     SON OF STOPGAP text editor  .  245
     SOS text editor . . . . . . .  245
     source code conversion  . . .  11
     source device . . . . . . . .  14
     Source program conversion . .  253
     Source program input to the compiler  86
     Source program listing  . . .  25, 221
     SPACE (DECsystem-10 ALGOL)  .  261
     spaces in commands  . . . . .  15
     Spaces in source programs . .  90
     SPACING . . . . . . . . . . .  58
     Special character representation  87
     Special characters in file name at run-time  51
     specification file  . . . . .  52
     SPECIFY, utility macro for external MACRO-10 procedures  193
     speed of SIMULA as compared to ALGOL  259
     Spooled CDR data file . . . .  20
     spooled devices . . . . . . .  49
     SPR . . . . . . . . . . . . .  237
     SPRINT control cards  . . . .  22
     SQRT, system function . . . .  29
     square brackets . . . . . . .  15
     square root single precision, entry point  208
     SS module, entry points . . .  209
     Standard functions  . . . . .  79
     Standard identiiers . . . . .  212
     Standardization of SIMULA . .  8
     star (*) in run-time file descriptor  51
     STOP AT, SIMDDT command . . .  70
     STOPGAP, SON OF, text editor   245
     string  . . . . . . . . . . .  38
     STRING concept of ALGOL 60  .  260
     string handling in ALGOL versus SIMULA  260
     string handling, efficiency of  259
     Structured programming  . . .  78
     SU module, entry points . . .  209
     sub-file directories in run-time file descriptor  51
     Subclass instance, internal representation  100
     Subclass, order of declarations  38
     switch designator, side effects  38
     switch value  . . . . . . . .  55
     SWITCH, attribute of terminated class instance  38
     SWITCH, utility macro for external MACRO-10 procedures  193
     Switches for the $SIMULA card  21
     switches, compiler  . . . . .  15, 23
     SWITCHes, error messages  . .  108, 155
     symbol table for SIMDDT . . .  23
     syntax of commands  . . . . .  14
     SYSIN . . . . . . . . . . . .  61
     SYSIN, used as specification file  53
     SYSOUT  . . . . . . . . . . .  61
     System prefixes, level of declaration  27
     System prefixes, restrictions  27

     TAB (DECsystem-10 ALGOL)  . .  261
     TAB character, use after line numbers  247
     tabs in commands  . . . . . .  15
     TAN module, entry point . . .  209
     TAN, system function  . . . .  29
     TANGENT single precision, entry point  209
     TANH, system function . . . .  29
     TECO text editor  . . . . . .  244-245
     ten, power of, symbol . . . .  261, 263
     terminal input and output . .  261
     TEXT constant . . . . . . . .  32
     TEXT constant used in assignments  260
     TEXT constant, error message   108, 111
     TEXT constant, length of, error message  115
     Text constants  . . . . . . .  89
     TEXT constants, allowed characters in  61
     text constants, multi-line  .  82
     text editing of SIMULA source programs  244
     TEXT editing, error message .  164
     text editor . . . . . . . . .  245
     text editor, selection of . .  245
     Text record, internal representation  92
     TEXT string handling in ALGOL versus SIMULA  260
     text string handling, efficiency of  259
     TEXT value constant . . . . .  32
     Text variables, internal representation  92
     TEXT, utility macro for external MACRO-10 procedures  193
     TIME procedure  . . . . . . .  31
     Title in program listing  . .  221
     Tracing of programs . . . . .  239
     Transmission mode for parameters, default  38
     Transport of SIMULA programs from CDC  253
     Transportability of programs to other computers  81
     TTY input and output  . . . .  261
     TX module, entry points . . .  204
     TXBL module, entry points . .  204

     UFD file access at run-time .  51
     Undefined global symbols, LINK-10 error message  18
     Underline . . . . . . . . . .  15
     unique logical name . . . . .  50, 52
     UNIVAC SIMULA programs conversion to DEC  254
     Unreduced subblock, internal representation  98
     unsigned integer labels . . .  38
     unspooled devices . . . . . .  49
     unwritten record in directfile  60
     USE, SIMDDT command . . . . .  73
     utility programs  . . . . . .  11
     utility programs library  . .  255

     VALUE parameter transmission, ALGOL versus SIMULA  263
     VALUE, utility macro for external MACRO-10 procedures  193
     Variables, internal order . .  102
     VARIABLES, SIMDDT command . .  74
     VERTICAL TAB character  . . .  62
     vertical tab, object I/O  . .  56
     Virtual matches, restrictions and rules  28
     VIRTUAL, error message  . . .  117

     warning message . . . . . . .  24
     Warning messages from the compiler  78
     WARNING switch  . . . . . . .  24
     WHILE statement . . . . . . .  34
     WHILE statements, efficiency considerations  79
     WORDALIGNED switch  . . . . .  55
     WRITE (DECsystem-10 ALGOL)  .  261

     Y switch  . . . . . . . . . .  25

     [ (DECsystem-10 ALGOL)  . . .  261, 263
     [STOP] BREAKS . . . . . . . .  63

     _ (DECsystem-10 ALGOL)  . . .  263
     # (DECsystem-10 ALGOL)  . . .  262
     ^C - REENTER in SIMDDT  . . .  67
     ^O monitor command in SIMDDT   67
     ^C monitor command  . . . . .  64

   
