


                 
















                    GGG   PPPP    SSS    SSS    SSS
                   G   G  P   P  S   S  S   S  S   S
                   G      P   P  S      S      S
                   G      PPPP    SSS    SSS    SSS
                   G GGG  P          S      S      S
                   G  G   P      S   S  S   S  S   S
                   GGGG   P       SSS    SSS    SSS 




     U   U   SSS   EEEEE  RRRR       N   N   OOO   TTTTT  EEEEE  
     SSS
     U   U  S   S  E      R   R      NN  N  O   O    T    E      S 
      S
     U   U  S      E      R   R      N N N  O   O    T    E      S
     U   U   SSS   EEE    RRRR       N N N  O   O    T    EEE    
     SSS
     U   U      S  E      R R        N N N  O   O    T    E        
      S
     U   U  S   S  E      R  R       N  NN  O   O    T    E      S 
      S
      UUU    SSS   EEEEE  R   R      N   N   OOO     T    EEEEE  
     SSS
GPSSS USER NOTES                                             Page 2


1.   INTRODUCTION
     ------------

          GPSSS is a SIMULA class which adds to SIMULA some of  the
     useful  objects  and procedures of Gordon's GPSS.  It includes
     declarations for the following objects:

     1.  Transactions

     2.  Facilities (here referred to as stations)

     3.  Storages

     4.  Queues


          The procedures enable  the  transactions  to  occopy  and
     release the resources.  Statistics on resource utilisation are
     automatically  collected  and  printed  at  the  end  of   the
     simulation.


          The ADVANCE statement of GPSS has been  replaced  by  the
     more flexible SIMULA scheduling statements such as HOLD (...),
     ACTIVATE and REACTIVATE.  In addition, a WAIT UNTIL  procedure
     is   available   to   allow   conditional   scheduling.    The
     transactions can be assigned priorities to provide FIFO,  LIFO
     and other scheduling policies.  


          Other procedures permit enquiries as to the status of the
     resources The user can also ask for the printing of statistics
     during a run and can reset the  simulation  to  try  alternate
     policies.  Completely different models can also be done in one
     run.  


          With GPSSS, a user can write simulation programs with the
     same facility and brevity as with GPSS.  In addition , the use
     of SIMULA as a base language retains the programming  features
     of  current  high  level  languages  such  as block structure,
     procedures, arithmetic, string handling and I/O.


          In this brief note, we shall assume that the  reader  has
     knowledge of both GPSS [1] and SIMULA [2].


     1.   GPSS/360, User's Manual, IBM Corp., Form No. H20-0360 
GPSSS USER NOTES                                             Page 3
Introduction


     2.   Ole-Johan Dahl, K. Nygard, SIMULA 67 Common Base 
         Definition, Norvegian Computing Center, Oslo, Norway. 







2.   STRUCTURE OF THE PROGRAM
     ------------------------

          GPSSS can be used as a block prefix or  as  a  prefix  to
     another CLASS at one an only one block level in a program.  It
     is to be used like the  standard  system  classes  SIMSET  and
     SIMULATION.



          The user program can be considered  as  made  up  of  two
     parts :

     1.  definition of the transaction attributes and actions

     2.  the  main  program  which  initialises  and  controls  the
         simulation.   In  particular, the main program must create
         the first transaction.



          The  following  trivial  example  shows  a  model   where
     customers  arrive  at  random  in  a  system  and  leave after
     spending 10 minutes.
GPSSS USER NOTES                                             Page 4
Structure of the program


     1.  begin

     2.     external class GPSSS ;

     3.     GPSSS(1,1,1) begin

     4.        TRANSACTION class customer;

     5.        begin

     6.              activate new customer
                     delay uniform(0,15,U);

     7.              HOLD(10);

     8.        end;

     9.        comment now the main program;

    10.        activate new customer delay 0;

    11.        HOLD(100);

    12.     end   GPSSS example;

    13.  end   of  program



          In this example, the upper case words are  procedures  or
     objects already defined either in GPSSS or in SIMULATION.  The
     main program  starts  the  first  customer  with  an  activate
     statement  and  then waits for 100 time units:  the simulation
     will therefore last 100 minutes (simulated time).



          The transactions in GPSSS are defined as classes prefixed
     by  TRANSACTION.   The TRANSACTION class, defined in GPSSS, is
     itself prefixed by PROCESS and can be scheduled with the usual
     SIMULA  statements.   In  the example, each customer generates
     its successor and waits 10 units before leaving the system.



          The familiar facilities, storage and queues of  GPSS  are
     provided in GPSSS along with the procedures needed to use them
     as well as some other features.  Here is a list of  procedures
     and  variables  defined  in GPSSS along with indications as to
     where they should be used :
GPSSS USER NOTES                                             Page 5
Structure of the program


          A)  PROCEDURES FOR TRANSACTIONS
              ---------------------------

            - ENTER_STATION  (N)
            - LEAVE_STATION  (N)
            - ENTER_STORAGE  (N, SIZE)
            - LEAVE_STORAGE  (N, SIZE)
            - ENTER_QUEUE    (N)
            - LEAVE_QUEUE    (N)



          B)  MAIN PROGRAM PROCEDURES
              -----------------------

            - SET_STORAGE  (N, MAX_CONTENTS)
            - RESTART



          C)  GENERAL USE PROCEDURES
              ----------------------

            - GPSSS_TIME
            - WAIT_UNTIL  ( < BOOL EXPR > )
            - STANDARD_REPORT
            - CONTENTS_STATION  (N)
            - CONTENTS_STORAGE  (N)
            - CONTENTS_QUEUE    (N)
            - WAITING_STATION   (N)
            - WAITING_STORAGE   (N)
            - WAITING_QUEUE     (N)




          D)  TRANSACTION ATTRIBUTES
              ----------------------

            - PRIORITY
            - TIME MARK
            - ID



          E)  GLOBAL VARIABLES
              ----------------

            - U
GPSSS USER NOTES                                             Page 6
Structure of the program


          F)  PROCEDURES IN VERSION GPSSST
              ----------------------------

            - TRACE_OBJECTS
            - STATION_NAME      (N,new_name)
            - STORAGE_NAME      (N,new_name)
            - QUEUE_NAME        (N,new_name)
            - TRANS_NAME        ( new_name )
            - HOLD_UNTIL_READY
            - OUTTIME            ( TIME )
            - BEGIN_TIME        ( TIME )



          Now we shall consider  these  in  more  detail,  treating
     first what can be used in transactions, then the main program,
     the global features, and finally the version GPSSST.



3.  TRANSACTIONS
    ------------


          Each transaction has three variables predifined :


           integer  ID;
           real     TIME_MARK,PRIORITY;



          When a transaction is created, PRIORITY is set  to  zero,
     TIME_MARK  is  set to current time and a unique identification
     integer is placed in ID.


          PRIORITY  is  used  by  the  system  procedures  when   a
     transaction  is  placed  in a queue or does a WAIT_UNTIL.  The
     order is by increasing value of  PRIORITY.   For  transactions
     with  equal  priorities,  the ordering is FIFO (first in first
     out) if PRIORITY is positive and LIFO (last in first  out)  if
     negative.   The user can therefore effect different scheduling
     policies by changing PRIORITY during execution.  For example :


GPSSS USER NOTES                                             Page 7
Transaction


          FIFO    - PRIORITY :=   GPSSS_TIME
                  - PRIORITY := < positive constant >
          LIFO    - PRIORITY := - GPSSS_TIME
                  - PRIORITY := < negative constant >
          OTHERS  - PRIORITY := < priority value >
                  - PRIORITY := < deadline for completion >



          Although  priority  sheduling  is   allowed,   preemptive
     scheduling  is  not implemented.  It should be noted that time
     scheduling with the HOLD, ACTIVATE and  REACTIVATE  statements
     of SIMULA do not order event notices by PRIORITY.



          TIME_MARK is not used by GPSSS but the user could  employ
     it to get statistics on transit times through a system.



          It is not recommended that ID be altered.  It is used  by
     GPSSS  error  messages  and has been found quite valuable as a
     means of tracing transactions.



          The  procedures  affecting  resources  and   their   GPSS
     equivalent are shown below :



                      GPSSS                         GPSS
                      -----                         ----

          - ENTER_STATION  (N)               SEIZE   N
          - LEAVE_STATION  (N)               RELEASE N
          - ENTER_STORAGE  (N, SIZE)         ENTER   N, SIZE
          - LEAVE_STORAGE  (N, SIZE)         LEAVE   N, SIZE
          - ENTER_QUEUE    (N)               QUEUE   N
          - LEAVE_QUEUE    (N)               DEPART  N


GPSSS USER NOTES                                             Page 8
Transaction


          The parameter N is an  integer  identifying  a  resource.
     The limits are set as parameters to GPSSS :  
     GPSSS(max_stations, max_storages, max_queues)
     The data structure for each resource is only allocated when it
     is  required  and statistics are printed only for the resource
     utilised so  that  the  numbering  need  not  be  consecutive.
     Although  the  procedures  are  equivalent to the GPSS ones we
     have changed the nomenclature to  facilitate  their  use.   In
     this system the term FACILITY has been replaced by STATION.


4.     MAIN PROGRAM
       ------------


          The main program serves  to  initialise  the  simulation,
     print out statistics and terminate.  It will probaply make use
     of some of the general procedures described  later.   Here  we
     mention  only the two procedures peculier to the main program.
     They are :


          - RESTART
          - SET_STORAGE (N, MAX_CONTENTS)


          RESTART flushes the model so that a new run can be  tried
     with different parameters or a different model can be run.  It
     calls STANDARD_REPORT to print statistics,  gets  rid  of  all
     transactions and resources, resets GPSSS_TIME to zero and U to
     987654321.



          SET_STORAGE creates storages and their maximum  capacity.
     If  a  storage is used before having been created in this way,
     it will be assigned on arbitrary very large capacity.



          Although the main program  looks  in  many  ways  like  a
     transaction,  it  is  in  fact a different sort of entity.  It
     cannot  therefore  use  the  ENTER   and   LEAVE   procedures.
     Moreover,  it does not have the attributes ( ID, PRIORITY, and
     TIME_MARK) of a transaction.


GPSSS USER NOTES                                             Page 9


5.  GLOBAL PROCEDURES AND VARIABELS
    -------------------------------



          These are global and may be referred to anywhere  in  the
     program.    They   include   enquiry   procedures,  reporting,
     conditional scheduling and a random number seed.


          The enquiry procedures are concerned with simulated  time
     and the state of resources.  There is first:
          real procedure GPSSS_TIME;  - - - - - -;
     which  returns  the  elapsed  time  since  the  start  of  the
     simulation  or  the  last  use  of  RESTART.   This  procedure
     replaces the SIMULA standard procedure TIME which  should  not
     be used.


          The other enquire procedures return  integer  values  for
     the number of transactions waiting for a resource or the space
     utilised in a resource (CONTENTS_).  These have the form :

                     --         --   --         --
                     [ CONTENTS_ ]   [ STATION   ]
                     [           ]   [           ]
     <enq. proc>::=  [           ]   [ STORAGE   ] (N).
                     [           ]   [           ]
                     [ WAITING_  ]   [ QUEUE     ]
                     --         --   --         --

          when "[" , "]" indicate  selection  of  one  alternative.
     WAITING_QUEUE,  though  allowed,  will of course always return
     zero.


          STANDARD REPORT has been modelled on the GPSS report.  It
     does  not  give cumulative statistics, rather it gives results
     since the last report.

GPSSS USER NOTES                                            Page 10
Global procedures and variabels


          WAIT_UNTIL ( <  bool.   expr  >  )  is  a  very  powerful
     procedure.  It can be used either by a transaction or the main
     program.  It causes the caller to suspend its  activity  until
     the expression becomes true.  The complexity of the expression
     is only limited by the syntax  of  SIMULA.   This  feature  is
     axpensive as the expressions are tested after every event but,
     if it not used, no overhead  is  encurred.   The  transactions
     stopped  on  a WAIT_UNTIL are kept in priority order as in any
     other queue.  The main program which does not have a  priority
     attribute is always tested last.


          Finally, there is a global  integer  "U"  initialised  to
     987654321  which  may  be  used  as  a  seed for random number
     generators.


6.  VERSION GPSSST
    --------------



          This is added in version GPSSST :


          TRACE_OBJECTS will print out the transactions in order of
     appearence.    Each   transaction  will  be  followed  by  its
     occurrences.  This procedure should be called at  the  and  of
     the  simulation.   Data for the trace is only collected if the
     Boolean variable OBJECT_TRACE_ON is true.

     Example :
       
        OBJECT     2
        ======    ==
        
     Entered queue     1   at time        9:15
     Leaved  queue     1   at time        9:20
     Entered station   1   at time        9:20
     Leaved  station   1   at time        9:37
        
        
     Time spent in queue         :        0:05
     Time spent in station       :        0:17
         

GPSSS USER NOTES                                            Page 11
Version gpssst


          The texts in the listing above can be made more  readable
     by        the       procedures       STATION_NAME(N,new_name),
     STORAGE_NAME(N,new_name)      QUEUE_NAME(N,new_name)       and
     TRANS_NAME( new_name ) .


          The statements STATION_NAME(1,"waiting room");
     QUEUE_NAME(1,"Doctor's office");  and TRANS_NAME( "Patient");
     will make the example above look like this :

             Patient    2
             =======   ==
        
        
     Entered waiting room     at time         9:15
     Leaved  waiting room     at time         9:20
     Entered doctor's office  at time         9:20
     Leaved  doctor's office  at time         9:37
        
        
     Time spent in waiting room     :         0:05
     Time spent in doctor's office  :         0:17
        


          TRACE is a procedure which will print out the occurrences
     in  order  of  appearence.   This  will  be done at the time a
     transaction enters or leaves a facility.  Trace will  be  done
     when the Boolean variable TRACE_ON is true.  TRACE need not be
     called in users program.  You need only set  "TRACE_ON:=TRUE;"
     and TRACE will automatically be called in GPSSST.

     Example :
        
     object   1 entering  queue     1    at time        9:00
     object   1 leaving   queue     1    at time        9:00
     object   1 entering  station   1    at time        9:00
     object   2 entering  queue     1    at time        9:15
        

     Or if the texts is changed as mentioned above :


             
     Patient 1 entering  waiting room    at time        9:00
     Patient 1 leaving   waiting room    at time        9:00
     Patient 1 entering  doctor's office at time        9:00
     Patient 2 entering  waiting room    at time        9:15
          

GPSSS USER NOTES                                            Page 12
Version gpssst


          HOLD_UNTIL_READY  can  be  called  in  the  main  program
     between the simulation and the call on TRACE_OBJECTS.


          The time value, given by the SIMULA  procedure  TIME,  is
     changed by the procedure           

          PUTTIME( <time> ) :
     Puttime edits a REAL variable representing a TIME value
     left justified into the text FIELD in
     seconds    if UNIT = 'S'
     minutes    if UNIT = 'M'   (default)
     hours      if UNIT = 'H'
     days       if UNIT = 'D'
         
     The FIELD must have a minimum length of
     12 if secdec  0
     15 if secdec = 0
     16+secdec  if secdec > 0
         
     Format:
         
     [-]dddD  hh:mm[.ss[.xxx...]]
         
     where
     ddd        is number of days       (Blanked if day  1)
     hh is number of hours
     mm is number of minutes
     ss is number of seconds (only if SECDEC >= 0)
     xxx        is fraction of second with SECDEC digits
         
     Unit and secdec is to be given as parameters to GPSSST  :
     GPSSST( maxqueues, maxstation, maxstorages, unit, secdec );
        
     If you have a certain time of day when the simulation
     starts, you set it as: i.e BEGIN_TIME( 9.00 ) ; in
     the begining of your program.
     If you want to print the time of day yourself, you only 
     need to call the procedure OUTTIME( TIME ) ;
      i.e.  OUTTIME( GPSSS_TIME + BEGIN_TIME( 9.00 ) ) ;

     "NOREPORT:= TRUE;" will supress the STANDARD_REPORT message.
GPSSS USER NOTES                                            Page 13


7.  SAMPLE PROGRAMS
    ---------------



          Here follows two sample user programs.  The  first  is  a
     crude  cumputer  simulation  and the second shows the combined
     effect of "wait_until" and priorities.

          Program 1
          ---------

          Here jobs arrive at random at  a  computer  center  where
     they are placed in an input queue.  When storage is available,
     a job is brought into core and  proceeds  to  run  alternating
     between  requests for CPU time and IO.  After 10 such loops it
     leaves the system.


          The program (Fig 1) shows the use of  enter_  and  leave_
     procedures.   Storage  1 represents core, station 1 represents
     the CPU and the queues 1 and 4 gather statistics on  the  time
     through the system and the waits for the CPU respectively.


          The main program uses  RESTART  to  do  two  passes  with
     different  sizes  of  main storage.  STANDARD_REPORT serves to
     get statistics on the warm-up period for one of the runs.
GPSSS USER NOTES                                            Page 14
Sample programs


BEGIN
    EXTERNAL CLASS GPSSS;
    GPSSS(4,1,1)  BEGIN
    COMMENT
    *********************************
    ***                           ***
    ***  USER  PGM  STARTS  HERE  ***
    ***                           ***
    *********************************
    COMMENT **************  TEST PROBLEM 1 **************;
        transaction  CLASS  job ;
        BEGIN
            INTEGER  i,size,u1;
            ACTIVATE   NEW  job  DELAY  Negexp(1/20,u);
            size := Randint(1,10,u);
            u1 := u;
            enter_queue(1);
            enter_storage (1,size);
            FOR  i := 1  STEP  1  UNTIL  10  DO   BEGIN
                enter_queue (4);
                enter_station (1);
                leave_queue(4);
                hold(Negexp(1,u1));
                leave_station(1);
                hold(Uniform(0,5,u1));
            END ;
            leave_storage(1,size);
            leave_queue(1);
        END ;
        Outtext(
        "TEST  PROBLEM 1 - CRUDE COMPUTER SIMULATION");
        Outimage;
        Outtext(
        "-2 PASSES WITH DIFFERENT MEMORY SIZE,10K AND 15K");
        Outimage;
        COMMENT          PASS 1 WITH 10K  ;
        set_storage(1,10);
        ACTIVATE   NEW  job;
        hold(300);
        COMMENT        REPORT ON WARM UP PERIOD    ;
        standard_report;
        hold(300);
        COMMENT      PASS 2;
        restart;
        set_storage(1,15);
        ACTIVATE   NEW  job;
        hold(300);
    END  OF FIRST TEST PROBLEM;
END
GPSSS USER NOTES                                            Page 15
Sample programs


                FIGURE  1  -  CRUDE COMPUTER SIMULATION
                ---------------------------------------
GPSSS USER NOTES                                            Page 16
Sample programs


               Program 2
               ---------

          Here several X transactions as well as the  main  program
     wait for a Boolean condition, GO_SIGNAL, to become true.  This
     condition is set by  transaction  Y.   Each  transaction  then
     prints  out  its  ID  and  its PRIORITY.  This shows the queue
     ordering by increasing value of PRIORITY with FIFO or LIFO for
     equal  values  depending wether PRIORITY is positive (or zero)
     or negative.  The main program is always reactivated last.


BEGIN
External class GPSSS;
    COMMENT *********  TEST PROBLEM 2  *********************
    TEST OF <WAIT_UNTIL> STATEMENT AND PRIORITY QUEUEING
    - IF PRIORITY OF 1 (P1) < PRIORITY OF 2 (P2) THEN
    P1 IS PLACED BEFORE P2
    - IF P1=P2 THEN THE ORDER IS FIFO FOR POSITIVE P1
    AND LIFO FOR P1<0
    - NON TRANSACTION OBJECTS SUCH AS MAIN PROGRAM ARE 
    PLACED AFTER ALL OTHERS.
           
********************************************************;
    GPSSS(1,1,1)   BEGIN
        transaction  CLASS  x (param);  REAL  param;
        BEGIN
            priority := param;
            wait_until ( go_signal );
            Outint(id,5); Outfix(param,2,6); Outimage;
        END ;
        transaction  CLASS  y;
        BEGIN   go_signal :=  TRUE   END ;
        INTEGER  i;  Boolean  go_signal;
        Eject(1); Outtext(
        "PROBLEM  2 - TEST OF PRIORITIES AND WAIT_UNTIL");
        Outimage;
        FOR  i := -1  STEP  1  UNTIL  1  DO   BEGIN
            ACTIVATE   NEW  x(i)  DELAY  1 ;
            ACTIVATE   NEW  x(i);
        END ;
        ACTIVATE   NEW  y  AT   5 ;
        wait_until( go_signal);
        Outtext("MAIN  PROG");  Outimage;
        hold(1);
    END  TEST PROGRAM 2;
END USER PGM


                FIGURE  2  -  USE OF WAIT_UNTIL
                -------------------------------
GPSSS USER NOTES                                               Page 17
Sample programs


***************************    -VERSION 4.1-
***   MONTREAL  GPSSS   ***
***  SIMULATION REPORT  ***
***************************


PASSE  =  1

START  TIME=       0.00
END    TIME=     300.00


* STATIONS *
************

              AVERAGE                AVERAGE
   STATION   UTILISATION  ENTRIES   TRANSIT TIME   STATUS

      1             0.43        90           1.42      BUSY



* STORAGES *
************

                      AVG.     AVG.            THRU  TIME    CONTENTS
STORAGE   CAPACITY  CONTENTS   UTIL.  ENTRIES    / UNIT      MAX  NOW

    1        10        5.18   0.5178      10       35.30     10     5



* QUEUES *
**********

                  MAX.     CURRENT     AVG.      AVG.
QUEUE   ENTRIES  CONTENTS  CONTENTS  CONTENTS  TIME/TRANS

   1      11         5         3       1.61      43.95
   4      90         2         0       0.16       0.54










          FIGURE  - 3 -  TYPICAL OUTPUT PROBLEM   1.
          -----------------------------------------
GPSSS USER NOTES                                               Page 18
Sample programs


          PROBLEM  2 - TEST OF PRIORITIES AND WAIT_UNTIL

              4 -1.00
              1 -1.00
              2  0.00
              5  0.00
              3  1.00
              6  1.00
             MAIN  PROG


          ***************************    -VERSION 4.1-
          ***   MONTREAL  GPSSS   ***
          ***  SIMULATION REPORT  ***
          ***************************


          PASSE  =  1

          START  TIME=      0.00
          END    TIME=      6.00


          * NO STATIONS *


          * NO STORAGES *


          * NO QUEUES *




















                    FIGURE  - 4 - OUTPUT PROBLEM   2.
                    --------------------------------
