



DECSYSTEM-10 SIMULA Language Handbook, Part I
---------------------------------------------

By Graham Birtwistle, Lars Enderin, Mats Ohlin and Jacob Palme



Abstract
--------

The DECsystem-10 SIMULA Language  Handbook  contains  the  information
necessary  for an applications programmer who intends to use SIMULA on
a DECsystem-10 computer.

Part I contains a description of the SIMULA programming language.   It
is  a  guide  to  the language consisting of four chapters.  The first
chapter introduces SIMULA by way of  some  fully  discussed  examples.
Chapter  two  gives  the  syntax  and  semantics of SIMULA.  The third
chapter describes (with furhter examples) the standard system  classes
and  text  handling  facilities.  The last chapter deals with separate
compilation of procedures  and  classes.   Part  II  contains  special
information  for  DECsystem-10.  Part III describes the SIMULA Utility
Library (LIBSIM).

SIMULA is a general-purpose high-level programming language comparable
in  power  to  PL/I or Algol 68.  SIMULA is based on ALGOL 60 with the
addition  of  record-oriented  dynamic  memory  allocation,  reference
(pointer)  structures,  sets and queues, text- and character handling,
sequential and direct access input-output,  quasi-parallel  sequencing
(coroutines) and process (event) oriented simulation capabilities.

SIMULA  is  designed  in  a  way  which  makes  it  easy  to   produce
perspiciuous,  well-structured,  readable and secure programs.  SIMULA
is well adapted to structured programming methodology.

SIMULA will often considerably reduce the programming time compared to
conventional languages like FORTRAN, COBOL, or PL/I.

SIMULA on the DECsystem-10 contains two major additions to the  SIMULA
language:  A system for separately compiled program modules in SIMULA,
FORTRAN, or MACRO 10 and a powerful on-line debugging system, SIMDDT.

The DECsystem-10 SIMULA compiler requires 25  to  30K  user  area  and
compiles at roughly half the speed of the DECsystem-10 ALGOL compiler.
The CPU time when running SIMULA programs is about  the  same  as  for
ALGOL,  faster  for  input-output and text string handling, slower for
stack-oriented memory allocation.

Key word and phrases:  Computer,  Programming,  Programming  Language,
SIMULA,  DECsystem-10,  Digital  Equipment,  PL/I, Algol 60, Algol 68,
Fortran,  Cobol,  Dynamic  Memory  Allocation,  List  structure,  Data
structure,  Record,  Set,  Queue,  Text, String, Character, Coroutine,
Process,   Event,   Simulation,   Structured   Programming,   Separate
Compilation, Part-compilation, Debugging, On-line debugging.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 2
CHAPTER 1



























Copyright (c) Swedish National  Defense  Research  Institute  and  the
Norwegian Computing Center.

This handbook may not be sold, bought, copied or otherwise distributed
for  usage  primarily  as a manual with another SIMULA system than the
DECsystem-10 SIMULA system.

The word "SIMULA" is a registered trademark of the Norwegian Computing
Center.

NTIS Number:  PB-243 064.

DECsystem-10 SIMULA was produced and is presently  maintained  by  the
Swedish  National  Defense  Research  Institute,  Section 142, S-10450
Stockholm 80, Sweden.  If you send  your  name  and  address  to  that
address,  you  will  be  put  on the mailing list for a newsletter for
DECsystem-10 SIMULA users.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 3
CHAPTER 1


                               CONTENTS
                               --------



          BIBLIOGRAHPHY

  CHAPTER 1  BASIC SIMULA
  -----------------------

          COMPILE TIME AND RUN TIME

          1.1  THE HIGHEST MARK

          1.2  NUMBERING A CROSSWORD PUZZLE

          1.3  GEOMETRIC APPLICATIONS

          1.4  SIMULATION OF A QUEUEING SITUATION


  CHAPTER 2  THE SYNTAX AND SEMANTICS OF SIMULA
  ---------------------------------------------

          2.1  METHOD OF SYNTAX SPECIFICATION

          2.2  BASIC SYMBOLS AND SYNTACTIC VARIABLES

             2.2.1  LANGUAGE CHARACTER SET
             2.2.2  BASIC SYMBOLS
             2.2.3  DATA CHARACTER SET
             2.2.4  THE USE OF BLANKS
             2.2.5  COMMENT CONVENTIONS
             2.2.6  CODING SIMULA PROGRAMS

          2.3  IDENTIFIERS

          2.4  TYPES AND CONSTANTS

             2.4.1  TYPES
             2.4.2  CONSTANTS

          2.5  DECLARATIONS

             2.5.1  TYPE DECLARATIONS
             2.5.2  ARRAY DECLARATIONS
             2.5.3  SWITCH DECLARATIONS
             2.5.4  PROCEDURE DECLARATIONS
             2.5.5  CLASS DECLARATIONS
             2.5.6  EXTERNAL DECLARATIONS
             2.5.7  HIDDEN PROTECTED SPECIFICATIONS
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 4
CHAPTER 1


          2.6  EXPRESSIONS

             2.6.1  VARIABLES
             2.6.2  FUNCTION DESIGNATORS
             2.6.3  ARITHMETIC EXPRESSIONS
             2.6.4  BOOLEAN EXPRESSIONS
             2.6.5  CHARACTER EXPRESSIONS
             2.6.6  DESIGNATIONAL EXPRESSIONS
             2.6.7  OBJECT EXPRESSIONS
             2.6.8  TEXT EXPRESSIONS AND TEXT VALUES

          2.7  BLOCKS AND STATEMENTS

             2.7.1  BLOCKS AND COMPOUND STATEMENTS
             2.7.2  STATEMENTS

  CHAPTER 3  SYSTEM CLASSES AND TEXT HANDLING
  -------------------------------------------

          3.1  PROGRAM STRUCTURE

          3.2  CLASS SIMSET

          3.3  CLASS SIMULATION

          3.4  TEXT

          3.5  CLASS BASICIO

  CHAPTER 4  SEPARATE COMPILATION
  -------------------------------

          4.1 WHY SEPARATE COMPILATION?

          4.2 GOOD AND BAD SEPARATE COMPILATION

          4.3 WHAT SIMULA CONCEPTS CAN BE SEPARATELY COMPILED?

          4.4 HOW IS SEPARATE COMPILATION SPECIFIED?

          4.5 EXAMPLES OF PARTITIONING OF SIMULA PROGRAMS

APPENDIX A:  ISO-7 (ASCII) CHARACTERS AS USED IN SIMULA

APPENDIX B:  SYSTEM PROCEDURES

APPENDIX C:  SKELETONS OF THE SYSTEM CLASSES AND SYSTEM PROCEDURES

INDEX
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 5
CHAPTER 1


                            BIBLIOGRAHPHY
                            -------------



(Defining document of ALGOL  part  of  the  SIMULA  Language)  Revised
Report  on  the  Algorithmic  Language  ALGOL  60.   Comm.  ACM, 1963,
Vol. 6, No. 1, pp. 1-17.

(Defining document of SIMULA part of the SIMULA  Language)  SIMULA  67
Common  Base  Language.   Publ.  no S-22.  Norwegian Computing Center,
Forskningsveien 1b, Oslo, Norway.

(Beginners textbook on SIMULA) SIMULA BEGIN.  Studentlitteratur, Fack,
S-221  01  Lund  1, Sweden,   or   Mason and Lipscomb, Petrocelli Book
Division, 384 Fifth Avenue, New York, N Y 10018, U S A.

(Short introduction) A Primer on the CLASS  and  Pointer  Concepts  in
SIMULA.   Report  C 10043, Rapportcentralen, FOA 1, S-104 50 Stockholm
80, Sweden.

(Regular newsletter for SIMULA users)  SIMULA  newsletter.   Norwegian
Computing Center, Forskningsveien 1b, Oslo, Norway.

(Newsletter  for  DECsystem-10  SIMULA  users)   DECsystem-10   SIMULA
Gazette.   Section  142,  Swedish National Defense Research Institute,
S-104 50 Stockholm 80, SWEDEN.

DEC-system   10   SIMULA   Reference   Card.     Report    C    10039,
Rapportcentralen, FOA 1, S-104 50 Stockholm 80, Sweden.

DEC-system 10 SIMULA Language Handbook:
   Part I:  The programming language SIMULA.  Report no.  C8398.
   Part II:  DECsystem-10 Dependent  information,  debugging.   Report
   no.  C8399.
   Part III:  Utility Library.  Report no.  C10045.
   Rapportcentralen, FOA 1, S-104 50 Stockholm 80, SWEDEN.

The DECsystem-10 SIMULA Handbooks and the  primer  on  the  CLASS  and
Pointer  Concepts will also be available as RUNOFF files on the SIMULA
distribution tape.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 6
CHAPTER 1


                       CHAPTER 1  BASIC SIMULA
                       -----------------------



The main purpose of this chapter is to introduce the concepts  of  the
SIMULA  programming  language.   This  is  done  through  examples  of
increasing scope.

The framing of a problem for computer  solution  takes  place  in  two
phases.   The  first  design  phase consists of analysing the problem,
decomposing it into its components, classifying these  components  and
planning  the  flow  of the computations.  The second phase is coding,
that is expressing the plan of phase one in  a  programming  language.
With  many  programming  languages  this  will  amount  to  a complete
rewriting,  as  the  natural  human   modes   of   decomposition   and
classification are not available within the language.  This is not the
case with SIMULA, where concepts for a given problem or  problem  area
can be formulated directly in the language itself.

Thus SIMULA is more than just  a  notation  for  describing  computing
processes - it also provides a framework for concept creation and is a
tool of thought in problem analysis.

The main features of SIMULA are presented in examples.



When developing the SIMULA program we will  use  capital  letters  for
items which are valid SIMULA, and lower case letters otherwise.

Thus

     IF the carwash is idle THEN ACTIVATE the carwash

has two parts

     the carwash is idle
     the carwash

which have yet to be put into SIMULA.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 7
CHAPTER 1


COMPILE TIME AND RUN TIME
-------------------------

When a program is presented to a  computer  it  is  processed  in  two
distinct  phases.   In  the first phase, the program written in SIMULA
(the source program) is translated  into  its  equivalent  in  another
language  already  "known"  by  the computer.  During this translation
stage, known as compile  time,  the  source  program  is  checked  for
syntactic  and  semantic  errors  (illegal  constructions,  undeclared
variables, etc.) and,  if  any  are  found,  the  execution  phase  is
omitted.   SIMULA has been designed to trap as many errors as possible
at compile time.

After successful compilation, the source program is no  longer  needed
and  the  computer  operates  on its translated form called the object
program.  Since the two programs are equivalent, there is no need  for
us  to  think of program execution in terms of the object program - we
can retain a mental picture of its execution in terms  of  the  SIMULA
source   program.    The  object  program  is  executed  supported  by
prewritten routines called the run time system (RTS).   This  step  is
called run time.  At run time, the program data is read in when needed
and results printed out when requested in  the  program.   Any  errors
occurring at run time are called run time errors.



1.1  THE HIGHEST MARK
     ----------------

A class of students sits an examination and marks are awarded  in  the
range  0-100  as  whole  numbers (INTEGERS).  A list of these marks is
presented to the computer.  Write a program to find the highest mark.

A simple plan for the problem is this.  Trace down the list of numbers
and  process  them  one  by  one - at each stage comparing the present
value with the highest value met so far.  (It is convenient  to  carry
along  the  highest value so far met to avoid repeated back-checking).
If the  present  value  is  the  higher,  then  it  replaces  the  old
highest-value-met,  otherwise  it  has  no  significance.  As the only
information we need retain is now noted, the present list value can be
discarded.   Thus  it  is  not  necessary  to retain the whole list of
numbers in the computer.  The process is repeated taking the remaining
list  members  in  turn  until  the  list  is  exhausted when the last
highest-value-met is the number we require.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 8
CHAPTER 1.1


To follow this scheme we need note  and  compare  the  values  of  two
variables  (called  "variables"  because  their values vary during the
calculations).  These we call "PRESENT" and "HIGHEST",  the  presently
considered  list value and the highest value met so far, respectively.
A partial description of these actions could be:

           step 1:  let "PRESENT" be the new input value

           step 2:  if "PRESENT" is greater than "HIGHEST"  then  copy
                    the former's value into "HIGHEST".

The most concise and textually clear way of writing these  actions  is
to write them in a programming language - in this case SIMULA.

                                                         line no.
                                                         --------

READ:  PRESENT := ININT;                                    1
            IF PRESENT > HIGHEST THEN HIGHEST := PRESENT;   2
            GOTO READ;                                      3

This piece of program contains three  basic  statements  of  different
types:



assignment-statement  (line 1)
--------------------

     variable := expression

where the value of  the  expression  on  the  right  is  computed  and
assigned  to the variable on the left, i.e., the variable takes on the
value of the expression.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                   Page 9
CHAPTER 1.1


conditional-statement  (line 2)
---------------------

     IF condition THEN statement

where the statement is executed only if the condition is TRUE.

Another form of conditional statement is

     IF condition THEN statement 1
                  ELSE statement 2

which is evaluated as:

     1)  evaluate the condition

     2)  if it is TRUE execute statement 1 and skip statement 2, if it
         is FALSE then skip statement 1 and execute statement 2.

e.g.:

     IF X < 0 THEN Y := -X ELSE Y := X

will assign the magnitude of X to Y.


GOTO-statement  (line 3)
--------------

     GOTO READ

which alters the sequence of execution  of  the  statements  from  the
textual sequence to the one labelled "READ" (in this case).

Assignments  are  computational  statements  where  data  values   are
altered.   GOTO  and IF-THEN-ELSE constructions are control statements
which respectively alter the program flow, and cause statements to  be
skipped if the given condition does not hold.

The common operation of reading in the  next  INTEGER  (whole  number)
value  is  achieved  by writing "ININT" whose value is that next whole
number in the input stream.  "ININT" is thus  a  value  which  can  be
assigned to a variable.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 10
CHAPTER 1.1


To separate out one statement from another  in  a  program  semicolons
(';')  are  used.   Remember that statements do not themselves contain
semicolons.  The other punctuation mark used here is the  colon  (':')
which  separates  out  a  label from the statement it identifies.  Any
statement may be labelled, but the label is unnecessary unless  it  is
the object of a GOTO-statement.

This program segment is non-terminating and will go on asking for more
and  more  input,  which is not quite what we intended.  One method of
overcoming this is to terminate the input stream with  an  "impossible
number"  (say,  any  negative  number) and test for this number at the
head of the loop.  When the impossible number is met, it is  a  signal
to  go  out  of the main loop, print out the contents of "HIGHEST" and
terminate the program.

Using this technique, the whole program is:

                                                       line no.
                                                       --------

     BEGIN  INTEGER PRESENT, HIGHEST;                      1
     READ:  PRESENT := ININT;                              2
            IF PRESENT < 0 THEN GOTO PRINT;                3
            IF PRESENT > HIGHEST THEN HIGHEST := PRESENT;  4
            GOTO READ;                                     5
     PRINT: OUTTEXT ("THE HIGHEST VALUE = ");              6
            OUTINT (HIGHEST, 3);                           7
     END                                                   8

Sample data set
---------------

input:  14  63  17  -2
-----

output:  THE HIGHEST VALUE = 63
------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 11
CHAPTER 1.1


The unexplained lines are:

line 1:  INTEGER PRESENT, HIGHEST
declares two variables identified by PRESENT  and  HIGHEST.   The  key
word  INTEGER  gives  the  type  of  these  variables and introduces a
measure of security into the language.

INTEGER variables may only hold whole numbers.   Other  types  include
REAL (for fractional numbers), BOOLEAN (which can only take the values
TRUE  and  FALSE) ...... By  giving  variables  types  we   have   the
possibility to spot such errors as

     PRESENT := TRUE  (TRUE is not an INTEGER value)

or

     IF HIGHEST THEN .... (HIGHEST can not have the
                           value TRUE or FALSE).

On declaration, variables take initial values according to their type.
INTEGER  variables  take  the  value 0, REAL variables 0.0 and BOOLEAN
variables FALSE.  The initial values of other types will be noted when
they are introduced.


line 3:  IF PRESENT < 0 THEN GOTO PRINT
transfers control to the statement labelled "PRINT" if the input value
is  negative.   Otherwise the next statement to be executed is that on
line 4.


line 6:  OUTTEXT ("THE HIGHEST VALUE = ")
causes the text constant to be output - text constants are enclosed in
double  quotes  (")  so  that  there  can be no confusion between, for
example

     "12"  a text constant     12 a number
     "END" a text constant     END a key word

This program takes the form of a block.  Writing a typical declaration
as "D", and a typical statement as "S", then a block has the form

     BEGIN  D; D; .....; D; S; S; S; .....; S; END

Notice that declarations are always grouped at the head of a block and
the statements (actions upon them) come afterwards.  As semicolons are
used to terminate the various components of  the  block,  it  is  thus
possible  to make the text visually clear and as appealing as possible
by aligning, putting labels well to the left, etc.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 12
CHAPTER 1.1


The program just written was not carefully planned - it was  built  up
atom  by  atom  and  fitted  together.  This is reflected in the final
result which is awkward to follow.  For programs to be easily read and
understood  it is essential to decompose the problem into its distinct
components  and  then  decompose  these  still  further  into  smaller
components, until the atoms of the problem are reached.  In this way a
clear overall framework is guaranteed.  A fresh  set  of  actions  for
this problem could be planned by splitting the problem into two phases
as follows:

     read/compute ;  write

which leads directly to a formulation along the lines

FOR PRESENT := next value WHILE PRESENT not negative DO
     replace HIGHEST by PRESENT if PRESENT is the greater;
WRITE (HIGHEST)

Expressed in SIMULA, the corresponding program is:

                                                         line no.
                                                         --------

  BEGIN  INTEGER PRESENT, HIGHEST;                          1
         FOR PRESENT := ININT WHILE PRESENT >= 0 DO         2
            IF PRESENT > HIGHEST THEN HIGHEST := PRESENT;   3
         OUTTEXT ("THE HIGHEST VALUE = ");                  5
         OUTINT(HIGHEST,9);                                 6
  END                                                       7

The only new feature is the FOR-statement spanning lines 2-3.

This FOR-statement is  a  control  statement  used  for  organising  a
repetition  while  a  condition  is met (PRESENT >= 0, PRESENT greater
than or equal to 0).  The general form is:

     FOR  assignment WHILE condition DO
          controlled-statement

which is understood as follows:

   F1:  the assignment is made (PRESENT := ININT)

   F2:  if the condition is TRUE the controlled statement (line 3)  is
         executed, and then control returns back to F1 (the next value
         is read in ...).  If the condition is FALSE,  control  leaves
         the  FOR-statement and the statement following the controlled
         statement (line 4) is executed.

The comments in parentheses refer to the given example.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 13
CHAPTER 1.1


When the source program has been compiled  and  execution  begins,  an
instance  of  the  program  block is created, the data spaces created,
their values initialized according to their type and then execution of
their actions begins.  A convenient picture of a block instance is:

          ----------------
          !   RTS info   !
          ----------------
          ! declarations !
          ----------------
          !   actions    !
          ----------------

Some aspects of the RTS info (run time  system  information)  will  be
explained later.

When the actions are executed, each occurrence of an identifier in the
actions  may  be  considered  matched  with the occurrence of the same
identifier in the block instance head, as below:

          ------------------------
          !       RTS info       !
          ------------------------
          ! INTEGER PRESENT    0 !
          !                      !
          ! INTEGER HIGHEST    0 ! <----
          ------------------------     !
          !                      !     !
          !  FOR PRESENT :=...   ! >----
          ------------------------

(In practice, the matching is mostly  done  in  the  compile  step  to
minimize  running-time,  but conceptually we may think of the matching
as a look-up among  the  declared  variables  as  illustrated  in  the
figure).   This  method  of  matching is known as the Binding Rule for
variables.   (It  is  extended  later).   It  follows  that  all  such
quantities  must  be  declared  and that an identifier can be declared
only once in any block.  By picturing block instances in this fashion,
these points seem very obvious.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 14
CHAPTER 1.2


1.2   NUMBERING A CROSSWORD PUZZLE
      ----------------------------

Suppose we are given an N x N crossword puzzle filled with  blank  and
blocked off out squares and are faced with the problem of locating and
numbering those squares from which words can begin.


e.g.      ---------------------
          !   !   !   !!!!!   !
          ! 1 !   ! 2 !!!!! 3 !
          !   !   !   !!!!!   !
          ---------------------
          !   !!!!!   !   !   !
          !   !!!!! 4 !   !   !
          !   !!!!!   !   !   !
          ---------------------
          !   !!!!!   !!!!!   !
          !   !!!!!   !!!!!   !
          !   !!!!!   !!!!!   !
          ---------------------
          !   !   !   !   !   !
          ! 5 ! 6 !   ! 7 !   !
          !   !   !   !   !   !
          ---------------------
          !   !   !   !   !   !
          ! 8 !   !   !   !   !
          !   !   !   !   !   !
          ---------------------

A little testing by hand will soon show that an across clue can  begin
if three consective squares have the pattern


A:        -----------------
          !!!!!     !     !
          !!!!!  ^  !     !
          !!!!!  !  !     !
          -------!---------
                 !
             across clue can begin here
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 15
CHAPTER 1.2


and a down clue where three consecutive squares have the pattern

          -----
          !!!!!
          !!!!!
B:        -----
          !   !
          ! <-!--- down clue can begin here
          !   !
          -----
          !   !
          !   !
          !   !
          -----

Thus by sweeping through the board  and  matching  patterns,  all  the
clue-starting  squares  can  be found.  This pattern matching fails if
part of either pattern A or B  falls  outside  the  board,  which  can
happen only if the centre square is matched with an edge square of the
board, as below:


                      +++++ B
                      +++++
                      +++++
          oooooooooooo+++++oooo
          o   o   o   +   +   o
          o   o   o   +   +   o
    A +++++++++++++ooo+++++oooo
      +++++   +   +   +   +   o
      +++++   +   +   +   +   o
      +++++++++++++ooo+++++oooo
          o   o   o   o   o   o
          o   o   o   o   o   o
          ooooooooooooooooooooo
          o   o   o   o   o   o
          o   o   o   o   o   o
          ooooooooooooooooooooo
          o   o   o   o   o   o
          o   o   o   o   o   o
          ooooooooooooooooooooo
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 16
CHAPTER 1.2


Instead of complicating the program by  making  the  edges  a  special
case, it is much easier to extend the crossword by blocked out squares
all the way round its edge.


             0 ------- N+1

            **************
            **************
            **************
            ***        ***
            *** 1----N ***
            ***        ***
            ***        ***
            **************
            **************
            **************

In this way, the method of matching  patterns  holds  good  for  every
square  in  which we are interested except for one special case.  This
is when a blank square is surrounded by blocked out squares:


              *****
              *****
              *****
          *****   *****
          *****   *****
          *****   *****
              *****
              *****
              *****

which for obvious reasons does not seem to  occur  in  practice.   Its
occurrence  is  not  catered  for  in  our program, but it is a simple
matter to allow for it.

The representation of the crossword needs some background explanation.
When  a  mathematician is engaged on a problem concerned with a single
triangle, there is a strong possibility of his identifying  the  sides
of  the  triangle  by  "a",  "b"  and  "c".  When faced with a problem
involving many triangles, the method of  identification  will  usually
change  to  the  use of subscripted variables, naming the sides of the
first  triangle  "a1",  "b1",  "c1",  of  the   second   "a2",   "b2",
"c2", ... of  the  j'th.   "aj",  "bj", "cj", etc.  Besides saving the
trouble of inventing many unique names, the notation also invites  the
grouping  of  like  data under one identifier.  The notation is easily
extended - if    we     require     variables     with     two,     or
three, .... subscripts, we simply write

          b      c
           i,j    i,j,k       ...

respectively, using commas to separate out the various components.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 17
CHAPTER 1.2


In programs demanding the storage of much data of the same type, it is
inconvenient to declare variables one at a time, and the concept of an
ARRAY is introduced to allow the simultaneous  specification  of  many
variables  all  of  the  same  type  and  with  the  same  identifier,
distinguishable only through the use of "subscripts".  We can not  use
the  matematician's  notation  of subscripted variables as it occupies
more than one physical line.

But we can write on one line and separate out the  identfier  and  the
components  by  use  of square brackets '[' and ']'.  In this way, the
mathematical

          A         B         C
           I         I,J       I,J,K

are written as:

          A[I]      B[I,J]    C[I,J,K]

respectively.

When an array is declared, the following information is needed:

1.   an identifier for the array,

2.   the type of the array, which fixes the type of each component,

3.   how many distinct variables the declaration involves.   This  can
     be found by giving the range of each subscript.

A simple array declaration is

     INTEGER ARRAY LONGSIDE[0:6]

which gives for use seven subscripted variables, each of type  INTEGER
and each initialized to zero.  They may be referred to as

     LONGSIDE[0], LONGSIDE[1], ....., LONGSIDE[6]

To make the use of subscripted variables flexible, one is  allowed  to
write  arithmetic  expressions  in the subscript positions, so that if
I = 2, for example, then LONGSIDE[2*I] and LONGSIDE[4]  refer  to  the
same quantity.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 18
CHAPTER 1.2


A CHARACTER ARRAY is used to represent  the  crossword.   A  blank  is
represented  by the CHARACTER constant ' ' and a blocked out square by
'*'.  The declaration of the ARRAY is:

     CHARACTER ARRAY CWORD [0:N+1, 0:N+1]

representing the crossword (dimensions  1  through  N),  and  the  rim
(dimensions 0 and N+1).  This will make available (N+2)^2 variables of
type CHARACTER each initialized to the initial value ' ', binary  zero
(CHAR(0)).    N.B.    several   CHARACTERS   are   not   visible  when
printed - this is one of them.

The strategy is (in words):

1.   N, the number of rows and columns  of  the  crossword  itself  is
     given on the first input line

2.   Read in the data - each row being represented on  a  fresh  input
     line

     Characters may be read in one  by  one  by  successive  calls  on
     INCHAR.

          C  := INCHAR

     will assign the current input character to C and  make  the  next
     character the new current.  In this way, repeated calls on INCHAR
     successively sweep across the input line.

3.   Scan through the crossword along each internal row  in  turn  and
     match  the  patterns A and B on each internal square.  If a match
     is found, print out the row  number,  column  number  and  serial
     number of the corresponding clue.

     This prosaic description suggests the planning stages:

          read in the crossword;
          scan through the crossword and write where necessary;


read in the crossword;
----------------------

This planning stage is itself further divisible into two parts:

     set the rim values;  read the internal values;

which are discussed in turn.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 19
CHAPTER 1.2


     set the rim values;
     -------------------

     The rim may be divided into four parts, each of  N+1  squares  as
     shown:


                       ROWNO = 0
                       COLNO = 0 --> N
                         !
                         !
                    -----V-------------------------
                    !                      !      !
                    !                      !      !
                    -----------------------!      !
                    !     !                !      !
                    !     !                !      !
ROWNO = 1 -> N + 1 -->    !                !    <----ROWNO = 0 ->N
COLNO = 0           !     !                !      !  COLNO = N + 1
                    !     !                !      !
                    !     !                !      !
                    !     !                !      !
                    !     !------------------------
                    !     !                       !
                    !     !        ^              !
                    !     !        !              !
                    ---------------!---------------
                                   !
                          ROWNO = N + 1
                          COLNO = 1 -> N + 1
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 20
CHAPTER 1.2


This leads to the formulation:

FOR ROWNO is 0 through N DO

          CWORD[0,ROWNO] := '*';
          CWORD[ROWNO,N+1] := '*';
          CWORD[N+1,ROWNO+1] := '*';
          CWORD[ROWNO+1,0] := '*';

read the internal values;
-------------------------

For the kernel position 1 through N, this is:

     FOR ROWNO is 1 through N DO

          next input line;

          sweep across the row for COLNO is 1 through N

          and at each stage read in the next character

          and assign it to CWORD [ROWNO, COLNO];

But the controlled statement can just as well be written  by  using  a
FOR-statement:

     FOR ROWNO is 1 through N DO

          next input line;

          FOR COLNO is col 1 through N DO

              CWORD [ROWNO, COLNO] := INCHAR;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 21
CHAPTER 1.2


Scan Through the Crossword and Write Where Necessary;
-----------------------------------------------------

This stage consists of scanning the crossword and  matching  patterns.
If  the current square is not a blank, it can not start a clue and may
be skipped.

     FOR ROWNO is 1 through N DO
     FOR COLNO is 1 through N DO
               IF CWORD [ROWNO, COLNO] = ' ' THEN

                    IF pattern A fits or pattern B fits THEN

                         WRITE (ROWNO, COLNO, serial number)

We are now in a position to write the program.



Program:
-------

We can not start the program by:

          BEGIN INTEGER N;
               CHARACTER ARRAY CWORD [0:N+1, 0:N+1];
               N := ININT;
               .....

because the block is created and initialized before  any  actions  are
executed.   Thus,  the array bounds will not have the desired value as
N=0 at this time.

Again,

          BEGIN INTEGER N;
               N := ININT;
               CHARACTER ARRAY CWORD [0:N+1, 0:N+1];
               .....

is illegal as the declarations are not grouped  at  the  head  of  the
block.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 22
CHAPTER 1.2


The way out is to create an inner block thus:

          BEGIN INTEGER N;
               N := ININT;
               BEGIN  CHARACTER ARRAY CWORD [0:N+1, 0:N+1];
               .....
               END;
          END

An inner block is counted as a special type of statement, so that  the
outer block has the form:

          BEGIN               declaration
               statement;     (N := ININT)
               statement;     (inner block)
          END

which is legal.

The whole program is:
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 23
CHAPTER 1.2


                                                                 line no.
                                                                 --------


BEGIN   INTEGER N, EDGE;                                             1
        N := ININT; EDGE := N+1;                                     2
     BEGIN   INTEGER ROWNO, COLNO, SERIALNO;                         3
             CHARACTER ARRAY CWORD[0:EDGE, 0:EDGE];                  4
             COMMENT ***WE NOW OUTPUT THE HEADING*** ;               5
             OUTTEXT ("CROSSWORD NUMBERING");                        6
             OUTIMAGE;                                               7
             OUTTEXT ("  ROW  COL  SER.NO"); OUTIMAGE;               8
             COMMENT ***THE READING PHASE FOLLOWS -                  9
                        EACH ROW IS ON A NEW CARD*** ;              10
             FOR ROWNO := 0 STEP 1 UNTIL N DO                       11
                 CWORD[0, ROWNO] := CWORD[ROWNO, N+1] :=            12
                 CWORD[N+1, ROWNO+1] := CWORD[ROWNO+1, 0] := '*';   13
             FOR ROWNO := 1 STEP 1 UNTIL N DO                       14
             BEGIN INIMAGE;                                         15
                   FOR COLNO := 1 STEP 1 UNTIL N DO                 16
                       CWORD[ROWNO, COLNO] := INCHAR;               17
             END;                                                   18
             COMMENT ***THE NUMBERING PHASE FOLLOWS*** ;            19
             FOR ROWNO := 1 STEP 1 UNTIL N DO                       20
                 FOR COLNO := 1 STEP 1 UNTIL N DO                   21
                     IF CWORD[ROWNO, COLNO] = ' ' THEN              22
                     BEGIN  IF (CWORD[ROWNO, COLNO-1] = '*' AND     23
                               CWORD[ROWNO, COLNO+1] = ' ')         24
                            OR (CWORD[ROWNO-1, COLNO] = '*' AND     25
                               CWORD[ROWNO+1, COLNO] = ' ') THEN    26
                            BEGIN  SERIALNO := SERIALNO+1;          27
                                   OUTINT(ROWNO, 5);                28
                                   OUTINT(COLNO, 5);                29
                                   OUTINT(SERIALNO, 8);             30
                                   OUTIMAGE;                        31
                     END;                                           32
                END;                                                33
               END;                                                 34
               OUTTEXT ("CROSSWORD DIMENSION = ");                  35
               OUTINT (N, 2);                                       36
               OUTIMAGE;                                            37
             END                                                    38


In which the variable EDGE has been used to avoid repeated  evaluation
of N+1.  Descriptive text has been inserted between the symbol COMMENT
and the succeeding semicolon.  A comment is not executed -  it  serves
to make the program more understandable.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 24
CHAPTER 1.2


Sample data:

Input:    7

          .......         (dot '.' denotes space)
          .*.*.*.
          .....*.
          .*..**.
          ...*...
          .*...*.
          .......


Output:

          CROSSWORD NUMBERING
            ROW  COL   SER.NO
              1    1        1
              1    3        2
              1    5        3
              1    7        4
              3    1        5
              3    4        6
              4    3        7
              5    1        8
              5    5        9
              6    3       10
              6    4       11
              7    1       12

          CROSSWORD DIMENSION = 7
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 25
CHAPTER 1.2


Discussion
----------

The new  features  are  considered  in  the  order  of  their  textual
appearance:

line no
-------

     5    Descriptive text  may  be  inserted  between  the  key  word
          COMMENT and the next semicolon.

    11    When a piece of program is to be repeated a known number  of
          times a second type of FOR-statement may be used.  This is:

          FOR controlled-variable := A1 STEP A2 UNTIL A3 DO
              controlled-statement

          where A1, A2,  A3  are  arithmetic  expressions.   Here  the
          controlled-statement is executed N+1 times with ROWNO taking
          the values 0, 1, 2, ....., N in turn.

    12    This is an example of a multiple assignment  statement.   It
          is equivalent to

          BEGIN  CWORD[ROWNO+1, 0] := '*';
                 CWORD[N+1, ROWNO+1] := CWORD[ROWNO+1, 0];
                 CWORD[ROWNO, N+1] := CWORD[N+1, ROWNO+1];
                 CWORD[0,ROWNO] := CWORD[ROWNO, N+1];

          END

          but is more readable.

    15    INIMAGE
          which skips to the beginning of the next input line.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 26
CHAPTER 1.2


 23-25    OR and AND
          which are used in conditions.

          C1 OR C2 OR ...  OR CN

          is TRUE if any of the conditions C1, C2, ...  CN  are  TRUE,
          otherwise it is FALSE.

          C1 AND C2 ...  AND CN

          is TRUE only if every one of the conditions C1 through CN is
          TRUE.

          In the given example which is of the type

          (C1 AND C2) OR (C3 AND C4)

          parantheses have been  used  to  group  C1  AND  C2  as  one
          subexpression,  C3  AND  C4  as another.  Parentheses can be
          used to group expressions of any type.


 27-32    A grouping of the form

          BEGIN  statement;
                 statement;
                 statement;

          END

          is called a compound-statement and is yet  another  form  of
          statement.   If  the  FOR-statement  of lines 14-18 had been
          written:

          FOR ROWNO := 1 STEP 1 UNTIL N DO
              INIMAGE;
              FOR COLNO := .....

          then only the input statement INIMAGE would  be  executed  N
          times before passing on to the next statement

              FOR COLNO :=
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 27
CHAPTER 1.2


When the program is executed, the RTS initially creates only the outer
block.  A visualisation of this outer block is:


                    -------------------
                    !                 !
                    ! RTS information !
                    !                 !
                    -------------------
                    !                 !
                    ! INTEGER  N   0  !
                    ! INTEGER EDGE 0  !
                    !                 !
                    -------------------
                    !                 !
     current -----> ! N := ININT      !
     statement      ! EDGE := N + 1   !
                    ! <INNER BLOCK>   !
                    ! OUTTEXT ...     !
                    ! OUTINT (N,2)    !
                    ! OUTIMAGE        !
                    -------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 28
CHAPTER 1.2


At this stage only the two variables declared in the outer block, i.e.
N and EDGE exist.  The inner block is created when the third statement
is encountered.  Assuming an input value for N of 7, the new  snapshot
when the inner block has been created is:


                    -------------------
                    !                 !
                    ! RTS information !<--------
                    !                 !        !
                    -------------------        !  TEXTUAL LINK
                    !                 !        !  to textually
                    ! INTEGER  N   7  !        !  enclosing block.
outer block         ! INTEGER EDGE 8  !        !
                    ! ....            !        !
                    !                 !        !
                --->! <INNER BLOCK>   !        !
                !   ! ....            !        !
                !   !                 !        !
                !   -------------------        !
                !                              !
                !                              !
                !                              !
                !                              !
                !   ------------------------   !
                !   !            !         !   !
                ----------O      !     O--------
                    !            !         !
                    ------------------------
                    ! INTEGER ROWNO    0   !
                    ! INTEGER COLNO    0   !
inner block         ! INTEGER SERIALNO 0   !     -------------------
                    ! CHARACTER ARRAY CWORD----->!Array            !
                    !                      !     !character        !
                    !                      !     !variables        !
                    ------------------------     !all initialized  !
                    !                      !     !to "binary zero" !
current  ---------->!....                  !     -------------------
statement           !                      !
                    ------------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 29
CHAPTER 1.2


Note that the layout of all blocks is the  same.   We  use  dots  ....
where  the  actions of blocks are irrelevant to the immediate point at
hand.

The bounds of the array are given as

          [ 0 : EDGE, 0 : EDGE ]

EDGE is not defined in the inner block although it clearly exists as a
program  element.  Accordingly, the primitive Binding Rule for finding
meanings for identifiers given in section 1 is modified to:

1.   Look in the immediate block head for a  match.   If  found,  then
     that is the identifier we are after.

2.   If no match is found, then continue the search  via  the  textual
     link  to  the textually surrounding block and try to find a match
     there.

For programs with many nested blocks, step 2  is  repeated  until  the
match is found.

When the actions of the inner block are completed, it is  deleted  and
control  returns  to  the  outer  block resuming at its next statement
which is

          OUTTEXT .....

The snapshot after return is:

               -------------------
               ! RTS information !
               -------------------
               !                 !
               ! INTEGER    N  7 !
               ! INTEGER EDGE  8 !
               ! ....            !
               ! <INNER BLOCK>   !
current  ----->! OUTTEXT         !
statement      ! ....            !
               -------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 30
CHAPTER 1.2


A more complete picture could be given as follows.  On creation of the
outer block, we have:

               ------------------
               !       !        !<---
               ------------------   !
               ! ININT          !   !
               ! INIMAGE        !   !
               ! OUTINT         !   !     RTS block
               ! OUTIMAGE       !   !
               ! ....           !   !
               ------------------   !
                                    !
                                    !
                                    !
                                    !
               ------------------   !
               !       !        !   !
               !       !  O----------
               !       !        !
               ------------------
               ! INTEGER  N   0 !
               ! INTEGER EDGE 0 !        program outer block
current  ----->! N := ININT   0 !
statement      ! .....          !
               ------------------

which shows that the standard system procedures for input  and  output
(many  more will be given later) are found in the normal way, and that
all the user-defined blocks collapse in the same way.   We  shall  not
use  this  more  complete snapshot in the future (just to save space),
but it is as well to remember its significance.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 31
CHAPTER 1.3


1.3   GEOMETRIC APPLICATIONS
      ----------------------

As an illustration of how SIMULA allows  for  concept  description  we
turn to the problem of automatic drawing - where the program describes
and generates figures, and their plotting is done  mechanically.   (It
is  beyond  our scope to define the last stage).  We consider the task
of generating the following figure for output:


                   * * * 
               *     *     *
             *       *       *
            *        *        *
           *         *         *
          *          *          *
          *          *          *
          *        * * *        *
          *      *   *   *      *
          *    *     *     *    *
           * *       *       * *
            *        *        *
             *       *       *
               *     *     *
                   * * * 


The program can be decomposed into 4 stages:

     1.  classification
         --------------

         What are the components in the  program  -  such  as  points,
         lines, circles?

     2.  generation
         ----------

         Generate representations of these components:

           L   Right leg
            1

           L   Left leg
            2

           L   Vertical bar
            3

           C   Circle
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 32
CHAPTER 1.3


     3.  assemble the figures
         --------------------

         Link the components together into a figure

         F
          \
           \
            >L1--->L2--->L3--->C

     4.  output
         ------

         Plot the figure.

The  complete  program  introduces  several  new  features  which  are
introduced as needed.



Classification and generation
-----------------------------

To describe compound patterns such as points, lines  and  circles,  we
build upon the most general concept we have met so far - the block.  A
block is a description of a structure and it written, in general, by

     BEGIN   declarations; actions;   END

When a block instance is generated its actions are executed  and  when
they are exhausted that instance is deleted never to reappear.

Here we have a need to describe patterns for points, lines and circles
and  create  instances  of  them which remain available.  We need that
ability  to  create  representations  of   several   points,   several
lines, ..... to  build  up  the  figure.   It  is  essential that once
created their structures remain available, and so they will have to be
given names so that they may be referred to.

These are achieved in SIMULA  by  the  CLASS  and  REFerence  variable
concepts.

Example:
-------

The following program generates  the  representations  of  two  points
R(2,0)  and  S  (which  is  displaced from R by (-1,2)) and the line L
through S with length 2 and at an angle of 45 degrees to the  positive
x-axis.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 33
CHAPTER 1.3


Figure:
------


                    Y          *
                    ^        *
                    !      *
                  2 +    *
                    !    S
                    !
                  1 +
                    !
         -2   -1    !    1    2
     -----+----+----!----+----*----->
                    !         R     X
                    !
                    !
                    !
                    !
                    !



Program
-------

                                                           line no.
                                                           --------

BEGIN       CLASS POINT(X,Y); REAL X,Y;                        1
            BEGIN ................ END;                        2
            CLASS LINE(P,LENGTH,ANGLE); REF(POINT) P;          3
                                REAL LENGTH, ANGLE;            4
            BEGIN ................ END;                        5
            REF(POINT)R,S; REF(LINE)L;                         6
            R :- NEW POINT (2,0);                              7
            S :- NEW POINT (R.X-1,R.Y+2);                      8
            L :- NEW LINE (S,2,45);                            9
            ............                                      10
END                                                           11
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 34
CHAPTER 1.3


                SNAPSHOT IMMEDIATELY BEFORE THE PROGRAM END
                -------------------------------------------


                                         -------------------
                                         !        !        !
                                    ---->! POINT1 !   PB   !
                                    !    !        !        !
                                    !    -------------------
           -------------------      !    !                 !
           !        !        !      !    ! REAL  X     2   !
           !   PB   !    .   !      !    ! REAL  Y     0   !
           !        !        !      !    !                 !
           -------------------      !    -------------------
           !                 !      !
           ! CLASS POINT     !      !
           ! CLASS LINE      !      !    -------------------
           ! REF (POINT) R .-!-------    !        !        !
           ! REF (POINT) S .-!---------->! POINT2 !   PB   !<---
           ! REF (LINE)  L .-!-------    !        !        !   !
           !                 !      !    -------------------   !
           ! L :- .....      !      !    !                 !   !
           !                 !      !    ! REAL  X     1   !   !
current    !                 !      !    ! REAL  Y     2   !   !
       --->! .....           !      !    !                 !   !
statement  !                 !      !    -------------------   !
           -------------------      !                          !
                                    !                          !
                                    !    -------------------   !
                                    !    !        !        !   !
                                    ---->! LINE1  !   PB   !   !
                                         !        !        !   !
                                         -------------------   !
                                         !                 !   !
                                         ! REF (POINT) P .-!----
                                         ! REAL LENGTH   2 !
                                         ! REAL ANGLE   45 !
                                         !                 !
                                         -------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 35
CHAPTER 1.3


N.B.  to save a multitude of links,  we  have  adopted  the  following
notation for the RTS information at the head of each block:

          ------------------------------------
          ! Name of this ! Name of textually !
          !    block     !  enclosing block  !
          ------------------------------------

so that

          ------------------------
          ! POINT 1 !    PB      !
          ------------------------

means:    this is the first POINT to be created, and the textual  link
          is to the block named PB, i.e.  the actual program block.

Notice also the way the  parameters  are  transmitted.   The  REAL (1)
parameters,  a  copy of the value of actual parameter is made local to
the object.  The REF(POINT) variable in the line object, the reference
value  of  the  actual  parameter  (the object POINT2) is copied.  Any
succeeding operation on a parameter works with these local copies.





























-------------
(1)  This also holds for INTEGER,  BOOLEAN  and  CHARACTER  variables - the
so-called value types.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 36
CHAPTER 1.3


Discussion
----------

The declaration of a class may take the forms (rather simplified):

     1)  CLASS A (formal parameters);  specifications;
         BEGIN  declarations;
                actions;
         END

         or, if it has no parameters,

     2)  CLASS B;
         BEGIN  declarations;
                actions;
         END

If the  class  has  parameters  then  each  one  must  have  its  type
specified.   The specifications may be in any order.  Instances of the
classes may be generated by

     1)  NEW A (actual-parameters)

Where the actual parameters correspond in number, order  and  type  to
those in the declaration, or

     2)  NEW B

When a class instance (henceforth  "an  object"  for  distinction)  is
generated,  its parameter values are transferred, its actions executed
and then control  returns  to  its  place  of  generation.   Then  its
whereabouts (a reference to it) may be assigned so that the object has
an identification and it may be accessed.

e.g.  in R :- NEW POINT (2,0)

the reference value of the POINT object is assigned to R after it  has
been generated.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 37
CHAPTER 1.3


Parameters and  declarations  together  are  called  attributes.   The
attributes  of  an  object  may  be accessed from inside the object by
their identifier.  From  without,  the  object  must  be  named  first
followed by a separating dot ('.') then the attribute, as

     R.X  REAL X - coordinate of the POINT R

     L.P  REF(POINT) quantity, the point of application of L.

Note that from the program block  there  are  two  references  to  the
second  point  (POINT  2) - either  S  or  L.P.   It  follows that the
attributes of S may be referred to as

     S.X  or  L.P.X,  and
     S.Y  or  L.P.Y

from the program block.

Reference variables are given a qualification  for  security  reasons.
For example, if R is REF(POINT) and L is REF(LINE) then:

     R.X  is valid as R  is  REF(POINT)  and  POINT  objects  have  an
          attribute X.  Further the type of R.X is REAL.

     L.P  is valid and is of type REF(POINT)

but neither R.P nor L.X will be valid bacause R can never reference an
object  having  a  P  attribute (and similarly for L.X).  By designing
SIMULA in this way, illegal attempts at accessing can be  detected  as
early as possible - i.e.  at compile time.

At run time, errors can still occur - for example, if R references  no
object  (NONE)  and  a  request  for  R.X occurs.  NONE clearly has no
attributes.  To guard against such errors two reference comparators ==
and =/= are a part of SIMULA.

  R == S  is TRUE only if both R and S reference the same  object,  or
          both reference NONE.

The opposite holds for R =/= S.

One can now test

     IF R =/= NONE THEN R.X := ......
               ELSE OUTTEXT ("R IS CURRENTLY NONE")

and use the  ELSE  option  to  give  a  suitable  warning  message  or
alternative action.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 38
CHAPTER 1.3


The initial value of all REF variables is NONE, i.e.  no object.

Before proceeding to outline the  assembly  stage,  we  take  time  to
introduce another concept - that of a PROCEDURE.

A common task in manipulating lines is to  rotate  a  line  through  a
certain  number  of  degrees.  To generate a new LINE referenced by L2
which "rotates" L1 through say 75 degrees, we could write

     L2 :- NEW LINE(L1.P,L1.LENGTH,L1.ANGLE+75)

which is both tedious to write and  not  very  clear.   The  PROCEDURE
concept enables us to write

     L2 :- L1.ROTATED(75)

by defining a suitable PROCEDURE "ROTATED" as a part of  the  body  of
CLASS LINE.

The PROCEDURE must do the following:

     1)  generate a new LINE object

     2)  pass as parameters the POINT and LENGTH attributes of L1  (it
         is  L1's  attribute ROTATED so these are available directly),
         and add 75 to the ANGLE of L1

     3)  return a reference to the new LINE object

CLASS LINE is now written:

         CLASS LINE(P,LENGTH,ANGLE);  REF(POINT)P;
                             REAL LENGTH,ANGLE:
         BEGIN REF(LINE) PROCEDURE ROTATED(THETA);  REAL THETA;
               ROTATED :- NEW LINE(P,LENGTH,ANGLE+THETA);
         END

The PROCEDURE concept enables common action clusters  to  be  designed
and  tested  as  components,  and  replaces  many  actions by a single
identifier.  This makes programs easy to  decompose  and  considerably
more readable.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 39
CHAPTER 1.3


Procedures are used in two senses:  either as statements, such as

     OUTTEXT("THE HIGHEST VALUE = ")

or   INIMAGE ,

or as values, as in

     PRESENT := ININT

or   L2 :- L1.ROTATED(90)

In both cases, the procedure is activated by  the  occurrence  of  its
identifier  and actual parameters (if any).  If the procedure is to be
used as a statement then its declaration has the form

     PROCEDURE identifier;  PROCEDURE-body

or  PROCEDURE identifier parameter-description
          PROCEDURE-body

where a PROCEDURE-body is a statement.

If the PROCEDURE is to return a value then the procedure  is  given  a
type and the value to be returned is assigned to a special variable of
that type by the actions of the PROCEDURE-body.

e.g.

     REF(LINE)PROCEDURE ROTATED(THETA); REAL THETA;
        ROTATED :- NEW LINE(P,LENGTH,ANGLE+THETA)

where the result is assigned to a REF(LINE) variable "ROTATED"  inside
the PROCEDURE-body.

On activation of a procedure, copies  of  the  values  of  the  actual
parameters  are  transferred  to  the procedure if the "modes" part is
empty (as here).  A rather different method of parameter  transmission
(by  NAME)  is  also  available  for  procedures  and  its use will be
explained shortly.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 40
CHAPTER 1.3


Assemble the figures
--------------------

The grouping of the lines and circles  into  figures  is  not  trivial
because:

      -  figures can have a variable number of components

      -  the type of components varies (it can either be REF(LINE)  or
         REF(CIRCLE)).

One neat way of assembling the components is by using a stack.   In  a
stack,  each  piece  of  information  is  stored on the top and pushes
previous members lower down.  Ignoring the  qualification  aspect  for
the moment, we can picture a stack S before and after a new member has
been inserted by:

before
------

                  ---       ---
          S !---->!2!------>!1!
                  ---       ---
             
                ---
                !3!
                ---


after
-----

                  ---        ---        ---
          S !---->!3!------->!2!------->!1!
                  ---        ---        ---

Whatever object is stacked, the actual mechanism for so doing  is  the
same.   It  follows  that  we  should  be  able  to  isolate stackable
qualities, define them, and be able to build them onto other concepts.
The  concept  of  stackable  needs  one  reference  variable "NEXT" to
reference the next lower member of the stack (or NONE  if  the  bottom
member).  So we can begin with the outline:

     CLASS STACKABLE;
     BEGIN REF(?) NEXT;  ..........  END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 41
CHAPTER 1.3


To build stackability into information carrying objects such as  LINES
and   CIRCLES,  we  use  a  prefix  notation  and  write  their  class
declarations as:

               CLASS STACKABLE ......;
     STACKABLE CLASS LINE ...........;
     STACKABLE CLASS CIRCLE .........;

Now LINE and STACKABLE objects have the appearances:

                  ------------------   ------------------
                  !        !       !   !        !       !
                  ------------------   ------------------
          prefix  * REF ( ? ) NEXT *   * REF ( ? ) NEXT *
                  ------------------   ------------------
                  !                !
                  ! REF (POINT) P  !
          main    !                !
          part    ! REAL LENGTH    !
                  !                !
                  ! REAL ANGLE     !
                  ------------------

                      LINE OBJECT       STACKABLE OBJECT

In other words, LINE objects now  have  the  concept  of  stackability
built into them.

We are now in a position to resolve the question of the  qualification
of  NEXT.   Clearly,  if we have a stack then each object in the stack
must have a STACKABLE part or else it could not be  inserted.   If  we
define NEXT to have the qualification REF(STACKABLE), we are then sure
that each variable "NEXT" in the stack  chain  will  reference  either
NONE or else an object which is at least "STACKABLE sized".  This does
mean that we have to relax our strict rules of  referencing  to  allow
the  NEXT  variables  to  reference  any member of a class prefixed by
STACKABLE.  Let us see how this works.  Suppose we have:

         BEGIN REF(STACKABLE)ST;
               REF(LINE)L;
               L :- NEW LINE(NEW POINT(0,0), 1,0);
               ST :- L;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 42
CHAPTER 1.3


The assignments are valid but the range of direct attribute  accessing
is  restricted  to  the  qualification level of the reference variable
concerned.

                 ----------------------------
                 !             !            !
                 ----------------------------
          ST---->! REF (STACKABLE) NEXT     !
                 ----------------------------
                 ! REF (POINT) P         ---!------>
                 ! REAL      LENGTH     1.0 !
          L ---->! REAL      ANGLE      0.0 !
                 ----------------------------

Thus

     ST.NEXT
     L.ANGLE
     L.LENGTH
     L.P

are valid.  So also is L.NEXT as, if L references an object,  it  must
be  at  least "LINE sized" and thus contain a STACKABLE part and so an
attribute NEXT.  But we can not allow

       ST.LENGTH         ST.ANGLE           ST.P

so easily, as ST may also reference STACKABLE or CIRCLE objects  which
have no such properties.

On the other hand we do not wish to disallow accessing the LINE object
at  the  LINE level via ST - what we do is to make it manifest that we
are entering a LINE object by requiring the user to write

     ST QUA LINE.P
     ST QUA LINE.LENGTH
     ST QUA LINE.ANGLE

This enables compile time checking:  "ST QUA LINE" - can ST  reference
a  LINE  object  ?   Yes,  as  its qualification is REF(STACKABLE) and
STACKABLE  prefixes  LINE.   ST  QUA  LINE.P - have  LINE  OBJECTS  AN
ATTRIBUTE "P" ?  YES.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 43
CHAPTER 1.3


Before writing the actual program,  we  take  time  to  introduce  the
concept  of call by NAME.  Suppose we wish to insert a LINE object (L)
and CIRCLE object (C) into a stack (ST).

The coding is:

     L.NEXT := ST;
     ST :- L;
     COMMENT ***NOW L IS INSERTED*** ;
     C.NEXT :- ST;
     ST :- C;
     COMMENT ***NOW C IS INSERTED***;

Snapshots before and after the insertion of L are:

before
------


                    ----------
                    !        !
           ST .---->!     .  !
                    !        !
                    ----------
                    !        !
                    !        !<--- Z
                    !        !
                    ----------
                           
            ----------
            !        !
     L ---->!     .  !
            !        !
            ----------
            !        !
            !        !
            !        !
            ----------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 44
CHAPTER 1.3


after
-----

                       ----------
                       !        !
                  ---->!     .  !
           ST .   !    !        !
              !   !    ----------
              !   !    !        !
              !   !    !        !<--- Z
              !   !    !        !
              !   !    ----------
              V   !
            ----------
            !     !  !
            !     .  !
            !        !
            ----------
            !        !
     L ---->!        !
            !        !
            ----------

The coding is a repeat except for a parameter saying which  object  is
to  be  inserted.   The  PROCEDURE  concept  enables  us to give CLASS
STACKABLE procedure attribute "INTO", and then we can write

     L.INTO (ST)
     C.INTO (ST)

for the same effect.  This is not only more concise, but more readable
than  before.   This  time  we have to be rather careful about how the
parameter is transmitted.  It is  the  purpose  of  the  procedure  to
actually  alter  the  value of the variable ST itself to reference not
its current value Z but the new entry.  In other words, we do not want
to  operate upon the value of ST (its object reference) but manipulate
variable ST itself.  This can be done by specifying the  parameter  to
be  called by NAME, as follows.  The new definition of CLASS STACKABLE
is:

     CLASS STACKABLE;
     BEGIN  REF(STACKABLE)NEXT;
            PROCEDURE INTO(H); NAME H; REF(STACKABLE)H;
            BEGIN  NEXT :- H;
                   H :- THIS STACKABLE;
            END;
     END

(The new keyword THIS refers to the "local object", i.e.  L if we call
L.INTO, and C if we call C.INTO).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 45
CHAPTER 1.3


It is worthwhile spending extra time to show how  the  NAME  parameter
mechanism works.  Consider the program skeleton:

     BEGIN  CLASS STACKABLE...........;
              STACKABLE CLASS LINE......;
              REF(LINE)L,Z;
              REF(STACKABLE)ST;
              ..........
              COMMENT ***L AND Z ARE NOW GENERATED, AND Z
                         SET "INTO" ST*** ;
              L.INTO(ST)
     END

A snapshot before the call is made is:


     ----------------------
     ! PB      !          !
     ----------------------
     ! CLASS STACKABLE    !
     ! CLASS LINE         !      -----------
     ! REF (STACKABLE) ST-!----->! L1 ! PB !
     !                    !      !    !    !
     ! REF (LINE) Z-------!----->-----------
     ! REF (LINE) L-------!---   !   NEXT  !
     ----------------------  !   !   INTO  !
                             !   -----------
                             !
                             !   -----------
                             --->! L2 ! PB !
                                 -----------
                                 !   NEXT  !
                                 !   INTO  !
                                 -----------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 46
CHAPTER 1.3


After activation of the procedure, we have:

     ----------------------      --------------
     ! PB      !          ! ---->!  L1  ! PB  !
     !         !          !      !      !     !
     ---------------------- ! !->--------------
     ! CLASS STACKABLE    ! ! !  ! NEXT  NONE !
     ! CLASS LINE         ! ! !  !    INTO    !
     ! REF (STACKABLE) ST-!-- !  --------------
     ! REF (LINE) Z-------!----
     ! REF (LINE) L-------!--    --------------
     !      ...           ! !--->!  L2  ! PB  !<---
     !    L.INTO(ST)      !      --------------   !
     ----------------------      ! NEXT  NONE !   !
                  ^              !    INTO    !   !
                  !              --------------   !
                  !                               !
                  !              --------------   !
                  !              !     !   .--!----
                  !              --------------
                  ---------------!--H         !
                                 ! NEXT :- H  !
                                 ! H :- THIS  !
                                 --------------

Note the textual links of  the  various  blocks - those  of  the  LINK
objects  are  to  the program block, that of the procedure block is to
the object referenced by L (i.e.  L2).  H is not given a value  but  a
link  back  to  the  actual  parameter.   Every  occurrence of H means
"re-evaluate the corresponding quantity".

For the first statement:

     NEXT :- H

NEXT is found by the normal binding rule in the block L2  (it  is  L's
NEXT) and this is set to reference H.  But H is called by NAME, so the
actual parameter corresponding to H is looked up and its current value
returned.  This is assigned to NEXT.

The next statement

     H :- THIS STACKABLE

assigns a reference to the "nearest"  STACKABLE  object  (the  one  to
which  the procedure is textually linked) to H.  But again H is called
by NAME and so this means assigning to ST the object L2.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 47
CHAPTER 1.3


These statements are then equivalent to

     NEXT :- ST;
     ST :- THIS STACKABLE;

Another way of explaining call by NAME is to say that every occurrence
of  the formal parameter is textually replaced by the actual parameter
in the procedure instance.


The program:
-----------

We aim to produce the following structure prior to plotting:

                       --------
          DRAW ------->! NEXT-!----
                       --------   !
                       !      !   !
                       !      !   !
                  L1   --------   !
                                  !
                                  !
                       --------<---
                       ! NEXT-!----
                       --------   !
                       !      !   !
                       !      !   !
                  L2   --------   !
                                  !
                                  !
                       --------<---
                       ! NEXT-!----
                       --------   !
                       !      !   !
                       !      !   !
                  L3   --------   !
                                  !
                                  !
                       --------<---
                       ! NEXT !
                       --------
                       !      !
                       !      !
                  C    --------

The following concepts are needed

     STACKABLE
     POINT
     LINE
     CIRCLE

- once these have been defined we can proceed with object generation.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 48
CHAPTER 1.3


Outlines of the classes are

     CLASS STACKABLE;
     BEGIN  REF(STACKABLE)NEXT;
            PROCEDURE INTO ............;
     END;

     STACKABLE CLASS LINE(P,LENGTH,ANGLE);
               REF(POINT)P; REAL LENGTH,ANGLE;
     BEGIN .............................. END;

     STACKABLE CLASS CIRCLE(CP,RAD);
               REF(POINT)CP; REAL RAD;
     BEGIN .............................. END;

     CLASS POINT(X,Y); REAL X,Y;
     BEGIN ................ END;


The components are:


                   * * * 
               *     *     *
             *       *       *
            *        *        *
           *         * L       *
          *          *   3      *
          *          *          *   C
          *        * * *        *
          * L    *   *   * L    *
          *  2 *     *     * 1  *
           * *       *       * *
            *        *        *
             *       *       *
               *     *     *
                   * * * 


and one piece of coding to generate them could be:

     ORIGO :- NEW POINT(0,0);
     L1 :- NEW LINE(ORIGO,1,-45);
     L2 :- NEW LINE(ORIGO,1,225);
     L3 :- NEW LINE(NEW POINT(0,-1),2,90);
     C  :- NEW CIRCLE(ORIGO,1);
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 49
CHAPTER 1.3


Although this coding is quite terse, we can in fact make it much  more
readable  by  use  of  procedures  local  to  classes  POINT and LINE.
Defining suitable procedures, we can replace the above coding by:

     ORIGO :- NEW POINT(0,0);
     L1 :- ORIGO.RAY(1,-45);
     L2 :- L1.ROTATED(-90);
     L3 :- NEW POINT(0,-1).RAY(2,90);
     C  :- ORIGO.RING(1);

The clearness of this piece of program means that it is not only  easy
to read and understand, but also easy to write.  From a wider point of
view this is ideal because it invites draughtsmen who are not (expert)
programmers to use the concepts we have developed.

We explain only one of the procedures RAY, ROTATED, RING as  they  are
fairly similar.  Let us choose "RING".

     ORIGO.RING(1)

has replaced the original

     NEW CIRCLE(ORIGO,1)

and must, therefore, achieve the same effects.  These are:

     1.  generate a new CIRCLE object

     2.  set in ORIGO and 1 as actual parameter values

     3.  return a reference to the new CIRCLE object.

The procedure is written local to class POINT and is available through
the dot notation.  The declaration of CLASS POINT becomes:

     CLASS POINT(X,Y);  REAL X,Y;
     BEGIN REF(CIRCLE) PROCEDURE RING(R);  REAL R;
                  RING :- NEW CIRCLE(THIS POINT,R);
     END

This procedure is given the type REF(CIRCLE) as it is to return a  new
CIRCLE object as value.  The type of the calling expression

     ORIGO.RING(1)

is REF(CIRCLE).  THIS POINT is a reference  to  the  POINT  object  to
which the PROCEDURE RING is an attribute, in this case ORIGO.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 50
CHAPTER 1.3


The whole program is:


                                                               line no.
                                                               --------

BEGIN  CLASS PLOTTING;                                            1
       BEGIN CLASS STACKABLE;                                     2
             BEGIN  REF(STACKABLE)NEXT;                           3
                    PROCEDURE INTO(H); NAME H; REF(STACKABLE)H;   4
                    BEGIN  NEXT :- H;                             5
                          H :- THIS STACKABLE;                    6
                    END ***OF INTO*** ;                           7
             END *STACKABLE*** ;                                  8

             CLASS POINT(X,Y); REAL X,Y;                          9
             BEGIN  REF(LINE) PROCEDURE RAY(L,A); REAL L,A;      10
                      RAY :- NEW LINE(THIS POINT,L,A);           11
                    REF(CIRCLE) PROCEDURE RING(R); REAL R;       12
                      RING :- NEW CIRCLE(THIS POINT,R);          13
             END ***OF POINT*** ;                                14

   STACKABLE CLASS LINE(P,LENGTH,ANGLE); REF(POINT)P;            15
                                   REAL LENGTH,ANGLE;            16
             BEGIN  REF(LINE) PROCEDURE ROTATED(THETA);          17
                          REAL THETA;                            18
                    ROTATED :- NEW LINE(P,LENGTH,ANGLE+THETA);   19
                   IF P == NONE OR LENGTH <= 0 THEN              20
                    BEGIN  OUTTEXT("BAD POINT");                 21
                          OUTIMAGE;                              22
                    END;                                         23
             END ***OF LINE*** ;                                 34
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 51
CHAPTER 1.3


STACKABLE CLASS CIRCLE(CP,RADIUS); REF(POINT)CP;                 25
                                   REAL RADIUS;                  26
          BEGIN  IF CP == NONE OR RADIUS <= 0 THEN               27
                    BEGIN  OUTTEXT("BAD CIRCLE");                38
                           OUTIMAGE;                             29
                    END;                                         30
          END ***OF CIRCLE*** ;                                  31

          PROCEDURE PLOT ......;                                 32

          REF(STACKABLE)DRAW;                                    33
          REF(POINT)ORIGO;                                       34
          ORIGO :- NEW POINT(0,0)                                35
  END ***OF PLOTTING*** ;                                        36

PLOTTING BEGIN  REF(LINE)L1,L2,L3,                               37
                REF(CIRCLE)C;                                    38
GENERATE:       INSPECT ORIGO DO                                 39
                BEGIN  L1 :- RAY(1,-45);                         40
                       L2 :- L1.ROTATED(-90);                    41
                       L3 :- NEW POINT(0,-1).RAY(2,90);          42
                        C :- RING(1)                             43
                END;                                             44
ASSEMBLE:        C.INTO(DRAW);                                   45
                L1.INTO(DRAW);                                   46
                L2.INTO(DRAW);                                   47
                L3.INTO(DRAW);                                   48
                PLOT;                                            49
        END ***OF PREFIXED BLOCK*** ;                            50
END                                                              51
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 52
CHAPTER 1.3


Discussion
----------


line no
-------

 1-36     Defines the concepts needed for the plotting of  figures  as
          CLASS PLOTTING.

          - stacking   lines 2-8
          - points     lines 9-14
          - lines      lines 15-24
          - circles    lines 25-31
          - plot       line 32

          and contains as actions the generation of  the  origin  line
          35.  Note that LINE and CIRCLE are prefixed by STACKABLE and
          that their definitions contain actions  which  will  give  a
          warning  message  if  the objects under generation are badly
          described.

 37-50    PLOTTING is used to prefix a  block.   When  this  block  is
          entered  all the concepts of PLOTTING are available for use,
          and the user operates in a built in environment.

 39-44    The construction

               INSPECT X DO statement

          is another method of accessing objects.   If  X == NONE  the
          statement is skipped, otherwise an attribute A of the object
          X is available without the need to write X.A.

          Here RING(1) is equivalent to ORIGO.RING(1) written  outside
          this  construction  as  ORIGO has an attribute RING.  On the
          other hand, as ORIGO has no attribute L1, L1 stands for  the
          REF(LINE) quantity declared in line 37.

   49     The plotting procedure is called and the appropriate  output
          displayed.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 53
CHAPTER 1.4


1.4  SIMULATION OF A QUEUING SITUATION
     ---------------------------------

We can best motivate the need for, and uses of, simulation by means of
an  example.  Consider the case of a garage owner who has installed an
automatic car wash  which  services  cars  one  at  a  time.   As  his
efficiently run service gets more and more popular, the owner is faced
with a dilemma.  As more customers use  the  car  wash  their  average
waiting  time  will  tend  to  increase  and  the service becomes less
attractive.  The owner may now react in two ways - build  further  car
washes  which  will  keep  the  present  customers happy (and probably
attract more), or do nothing  and  let  the  customer  flow  stabilize
itself  at  a  lower  level.   As  the  building of further car washes
entails considerable expense, this is  not  a  decision  to  be  taken
lightly and demands some investigation.

It is at this  point  that  simulation  can  help.   Simulation  is  a
technique   for   representing   a  dynamic  system  by  a  model  and
experimenting with the model in order to gain  information  about  the
system.   The  approach  is  useful  if  the system is not amenable to
analytic techniques and direct experimentation with the  system  (such
as building the car washes and seeing what happens) is impractical.



Car Wash Simulation
-------------------

Suppose the car wash services cars one at  a  time  and  each  service
takes  10  minutes.   When a car arrives it goes straight into the car
wash if the latter is standing idle, otherwise it  must  wait  in  the
queue.   As  long  as  cars are waiting, the car wash is in continuous
operation serving on the first-come, first-served principle.

If the arrival times of the cars have been recorded for one day then a
very  simple  model is capable of reproducing the essential aspects of
the system on that day.  This model can generate data which  describes
the  performance  of  the  installation - such  as  use  of equipment,
average number of waiting cars, time spent by each car.

The operation of the system consists of two critical events:

     1.  THE ARRIVAL OF A CAR.  The arrival time is noted.  If the car
         wash  is idle a ten minute service starts at once.  Otherwise
         the car goes to the end of the queue.

     2.  END OF SERVICE.  The elapsed time for that car is  noted  and
         the  car  leaves  the system.  If cars are waiting, the first
         one in the queue is served and another 10 minute  service  is
         started.  Otherwise the machine becomes idle.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 54
CHAPTER 1.4


The car wash, of course, starts in the idle state and awaits the first
arrival.

In order to understand the  model  better,  we  consider  a  trace  of
history of the model over a short period when cars arrive at the times
(in minutes) 6, 10, 13, 28, 42, 43, 48.  The state of the  model  only
changes  at  the  two critical times noted above:  when a car arrives,
when a service is finished.  Accordingly we need only trace  at  these
times.



                              Car wash trace
                              --------------


     time      event
     ----      -----

       0  the car wash awaits the first arrival
       6  car 1 arrives and goes into the car wash
      10  car 2 arrives and must wait
      13  car 3 arrives and waits in the queue
      16  car 1 leaves the system
          car 2 is served
      26  car 2 leaves the system
          car 3 enters the car wash
      28  car 4 arrives and waits in the queue
      36  car 3 leaves the system
          car 4 enters the car wash
      42  car 5 arrives and must wait
      43  car 6 arrives and must wait
      46  car 4 leaves the system
          car 5 enters the car wash
      48  car 7 arrives and must wait
      56  car 5 leaves the system
          car 6 enters the car wash
      66  car 6 leaves the system
          car 7 enters the car wash
      76  car 7 leaves the system
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 55
CHAPTER 1.4


The data recorded by the cars is:


     Car            1   2   3   4   5   6   7

     Arrival        6  10  13  28  42  43  48

     Departure     16  26  36  47  56  66  76

     Elapsed time  10  16  23  18  14  23  28

     Average time spent is  132/7 = 18.8 minutes

By comparing these results with those from the actual system,  it  can
be  verified  that the model is sufficiently accurate.  The management
wishes to reduce the average time spent.  The model can be used again,
this  time with two car washes operating on the same data.  We add the
decision rule that machine 1 should be used if  both  are  idle.   The
results of the trace are:


     Car            1   2   3   4   5   6   7

     Arrival        6  10  13  28  42  43  48

     Departure     16  20  26  38  52  53  62

     Elapsed time  10  10  13  10  10  10  14

     Served by
     machine        1   2   1   1   1   2   1

     Average time spent is  77/7 = 11 minutes

For this sample, then, the average time spent  waiting  in  the  queue
prior  to  service is reduced from nearly 9 minutes to 1 minute by the
building of an extra car wash.  Note how important it is to have  both
models working on exactly the same data.

Clearly no management should base its  decisions  upon  such  a  small
sample.  To arrive at better estimates it is necessary to simulate the
system for several days.  If the necessary data cannot  be  collected,
it  may  be  appropriate  to  use a statistical model to represent the
arrival of the cars.  (Moreover the characteristics of the car arrival
process  -  i.e.   the  customer  behavior - may vary with the service
capacity as well as with other  future  changes  in  the  car  washing
market).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 56
CHAPTER 1.4


The CLASS SIMULATION
--------------------

SIMULA is provided with a predefined system  CLASS  SIMULATION,  which
contains  all the necessary concepts for queues and active and passive
components.

When the identifier  SIMULATION  is  used  to  prefix  a  block  these
concepts  become  available  to  the user.  (The details are not given
here).

There are three CLASSES within SIMULATION of prime importance:

     PROCESS  -  which is used to prefix classes  whose  objects  have
                 active and passive phases.

     LINK     -  which prefixes classes whose objects are to be placed
                 in, and removed from, queues.

     HEAD     -  which serves as the head of a queue

N.B.  PROCESS is itself prefixed by LINK, so that PROCESS objects have
      the queue membership attributes.



The program for one car wash
----------------------------

One can view the system with the cars as passive objects being  pushed
through the system by the car wash.  The outline of CLASS CAR is

     LINK CLASS CAR (NUMBER); INTEGER NUMBER;
     BEGIN  record entry time;
            go into queue;
            IF car wash idle THEN ACTIVATE car wash;
     END

Prefixing the CLASS with LINK gives each CAR object the ability to  be
placed in a queue.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 57
CHAPTER 1.4


Having recorded the entry time, the CAR object goes in at the  end  of
the  queue.  (If the car wash is idle then this means that this CAR is
the first member of the queue).   If  the  car  wash  is  idle  it  is
activated  (whereupon  it  services the first member in the queue), if
the car wash is not idle then this CAR awaits its turn.

     PROCESS CLASS WASH (QUEUE); REF(HEAD)QUEUE;
     BEGIN
     SERVE:  take the first car out of the queue;
             service it for ten minutes;
             record the serviced car's exit time;
             send the car out of the system;
             IF the queue is empty THEN PASSIVATE;
             GOTO SERVE;
     END

By prefixing CLASS WASH with "PROCESS", WASH  objects  are  given  the
ability to be active components in the SIMULATION.  The initially idle
WASH object is activated by the first car.

The active cycle of a car wash starts by taking the first CAR  out  of
the  queue.   After  a ten minute pause, the serviced CAR has its exit
time recorded (the present simulation time) and is despatched from the
system.   If the queue is not empty, these actions are repeated (GO TO
SERVE),  otherwise  the  machine  becomes  idle  (PASSIVATE)  and   is
activated by the next CAR's arrival, whereupon the cycle starts again.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 58
CHAPTER 1.4


The complete program is:

                                                               line no.
                                                               --------

SIMULATION                                                        1
BEGIN  LINK CLASS CAR (NUMBER); INTEGER NUMBER                    2
       BEGIN  INTEGER INAT;                                       3
              INAT := TIME;                                       4
              INTO(CARWASH.QUEUE);                                5
              IF CARWASH.IDLE THEN ACTIVATE CARWASH;              6
       END ***OF CAR*** ;                                         7
       PROCESS CLASS WASH(QUEUE); REF(HEAD)QUEUE;                 8
       BEGIN  REF(CAR)SERVED;                                     9
       SERVE: SERVED :- QUEUE.FIRST                              10
              SERVED.OUT;                                        11
              HOLD(10);                                          12
              INSPECT SERVED DO                                  13
              BEGIN  OUTINT(NUMBER, 10);                         14
                     OUTINT(INAT, 10); OUTINT(TIME, 10);         15
                     OUTINT(TIME-INAT, 10);                      16
                     OUTIMAGE;                                   17
              END;                                               18
              SERVED :- NONE;                                    19
              IF QUEUE.EMPTY THEN PASSIVATE;                     20
              GOTO SERVE                                         21
       END ***OF WASH***;                                        22
       REF(WASH)CARWASH;                                         23
       INTEGER I,J,U;                                            24
       CARWASH :- NEW WASH(NEW HEAD);                            25
       U := ININT;                                               26
       J := ININT;                                               27
       OUTTEXT("       SIMULATION OF ONE CAR WASH");             28
       OUTIMAGE;                                                 29
       OUTTEXT("   CAR NO.    INTIME   OUTTIME  ELAPSED TIME");  30
       FOR I := 1 STEP 1 UNTIL J DO                              31
       BEGIN  NEW CAR(I);                                        32
              HOLD(POISSON(12,U));                               33
       END;                                                      34
       HOLD(10000);                                              35
END                                                              36



DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 59
CHAPTER 1.4


Sample input:
------------

3       100



Segment of output:
-----------------


                        SIMULATION OF ONE CAR WASH
                        --------------------------


     CAR NO.  INTIME  OUTTIME  ELAPSED TIME

         1       0       10         10
         2      14       24         10
         3      29       39         10
         4      37       49         12
         5      50       60         10
         6      67       77         10
         7      81       91         10
         8      96      106         10
         9     108      118         10
        10     121      131         10
        11     131      141         10
        12     142      152         10
        13     154      164         10
        14     163      174         11
        15     180      190         10
        16     186      200         14
        17     194      210         16
        18     208      220         12
        19     218      230         12
        20     233      243         10
        21     252      262         10
        22     256      272         16
        23     263      282         19
        24     273      292         19
        25     287      302         15



DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 60
CHAPTER 1.4


Discussion:
----------


     Line
     ----

       1       The program block is prefixed by CLASS SIMULATION which
               gives the programmer the predefined concepts of queues,
               and PROCESS objects which can be active or passive.

     2-36      The user-defined program

     2-7       CLASS CAR is defined.  Each CAR is distinguished by its
               NUMBER.  On generation of a CAR

       3       The entry time is recorded.  "TIME" is a system defined
               procedure returning the current system time.

       4       The CAR enters the queue as last  member.   INTO  is  a
               procedure property of all LINK objects.

       5       If the car wash is idle then it is activated.  IDLE  is
               another  system defined procedure, local to all PROCESS
               objects.

               This is the last action of a CAR object, thereafter  it
               is pushed through the system by the WASH.

     8-22      CLASS WASH is defined.

       9       SERVED is used to reference the currently serviced car.

     10-11     When the car wash is made active it starts to serve the
               next car, SERVED is set to reference the next candidate
               for service and that car is removed from the queue.

      12       HOLD(T) is a call on a system procedure which  suspends
               the actions of the car wash (in this case) for a length
               of time T.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 61
CHAPTER 1.4


     13-18     The car wash is active again, 10  minutes  later.   The
               relevant data is output.

      19       The only reference  to  the  CAR  SERVED  is  lost - it
               disappears from the simulation.

      20       If the queue  is  empty,  the  car  wash  becomes  idle
               (passivates  itself).   It  will  only become active on
               command from the next car.

      21       The actions are repeated.

      25       A WASH object is generated and referenced  by  CARWASH.
               It  has  a  NEW HEAD as parameter (which serves to hold
               the waiting CAR objects).

     27-30     N, the number of CAR objects to be generated,  is  read
               in, and suitable text headings are output.

     31-34     J new CAR objects are generated and automatically enter
               the  queue.   In  between  the generation of successive
               objects, the program holds itself, "reappearing"  after
               a  time  delay  taken from a POISSON distribution.  The
               standard random drawing procedures available in  SIMULA
               are fully discussed in Appendix B.

      35       Having generated the last  car,  the  program  suspends
               itself  for  a sufficiently long time to make sure that
               they have all been serviced.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 62
CHAPTER 2


               CHAPTER 2  THE SYNTAX AND SEMANTICS OF SIMULA
               ---------------------------------------------



2.1  METHOD OF SYNTAX SPECIFICATION
     ------------------------------

When  a  SIMULA  construction  and  all  its  variants  can   not   be
economically described in words, its exact range will be shown using a
system of notation which is standard throughout Part 2.

The notation is not in itself a part of SIMULA, nor restricted  solely
to  SIMULA.   It  may  be  used  to  describe the syntax (or allowable
constructions) of any programming language, and  provides  a  compact,
visually  clear  and  precise explanation of the general patterns that
the language permits.  It is important to realise  that  it  does  not
describe  the  meaning  of these constructions (their semantics), only
their structure.  In other words, it indicates:

      -  the order in which language elements may or must be  combined
         with each other,

      -  the punctuation that is required, and

      -  the full range of options.

No such convenient shorthand is yet available for  the  semantics,  so
that  interpretation  of  a  legal construction has to be described in
words.

We begin by noting that various patterns of basic symbols  continually
recur  in  SIMULA.   Instead  of  repeating  the  listing of the basic
symbols each  time,  they  are  first  grouped  together  as  a  named
syntactic  variable, and from then on we need use only that name.  The
idea extends itself  that  further  syntactic  variables  may  now  be
defined in terms of those already defined and possibly basic symbols.

The SIMULA basic symbols are represented by special  characters,  such
as

     +       /       )       ;       ^

by combinations of special characters, such as

     :-      **      =/=

and by key words in capital letters, such as

     PROCEDURE    CLASS    REAL    BEGIN
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 63
CHAPTER 2.1


When we define a syntactic variable, its name will usually be  written
in lower case letters for distinction:

     e.g    block    statement    digit

A certain ambiguity can arise when the name of  a  syntactic  variable
consists of two words, such as

     prefixed block

To ensure that these are interpreted as one syntactic unit and not for
example,  an  occurrence  of  a  syntactic  variable  named "prefixed"
followed by a syntactic variable named "block", a hyphen  is  inserted
between the words, as:

     prefixed-block

In certain cases, when a  basic  symbol  is  an  integral  part  of  a
syntactic  variable,  it is clearer to use upper-case letters.  Again,
we avoid possible ambiguities by following the upper-case letters by a
hyphen:

     e.g.    FOR-statement     GOTO-statement

We now give two examples to show  the  uniqueness  of  interpretations
using this technique:

     1.  IF BOOLEAN-expression THEN
         denotes an occurrence of the basic symbol "IF" followed by  a
         "BOOLEAN-expression"  followed  by an occurrence of the basic
         symbol "THEN".

     2.  REF(CLASS-identifier)
         denotes an occurrence of the basic symbol "REF"  followed  by
         an  occurrence  of  the  left  parenthesis  "(" followed by a
         "CLASS-identifier" followed by an  occurrence  of  the  right
         parenthesis ")".  The separation between "REF" and "(" occurs
         because if a basic symbol is  a  key  word  it  may  only  be
         composed of letters.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 64
CHAPTER 2.1


Bearing these in mind, the following rules  explain  the  use  of  the
notation as applied to SIMULA.

     1.  A syntactic variable  is  a  general  class  of  elements  in
         SIMULA.  The name of the syntactic variable must consist of:

         A.  lower-case letters
             lower-case letters separated by hyphens
             lower-case letters followed by a digit

             e.g.   identifier
                    compound-statement
                    identifierl
                    simple-object-expression

         B.  a  combination  of  upper-case  letters  and   lower-case
             letters.   There  must  be  one portion of all upper-case
             letters and  at  least  one  portion  of  all  lower-case
             letters separated, one from another, by hyphens:

             e.g.     PROCEDURE-statement

         All such units  used  in  this  section  are  defined  either
         formally using this notation or else in words.

     2.  A basic  symbol  denotes  an  occurrence  of  the  characters
         represented.  A basic symbol is either a key word or else one
         or more special characters

         e.g.   BEGIN    END
                  +      =/=

         N.B.  When a basic symbol consists of more than one character
         no intervening spaces may appear.

         Thus, for example,

              BEG IN    =/ =

         are both faulty representations.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 65
CHAPTER 2.1


     3.  The term syntactic unit, which is used in  subsequent  rules,
         is defined by

         A.  a single syntactic variable or basic symbol, or

         B.  any collection of  syntactic  variables,  basic  symbols,
             syntax-language  symbols  (the  symbols [, ],        ,...
             whose uses are defined in subsequent rules) surrounded by
             braces or brackets.

         Examples:

               digit letter

               [digit]
               [letter]

               digit

               digit ...

                 **  **
     4.  Braces **    ** are used as group markers.
                 **  **

         Example:  the definition of an object-relation is

         object-relation
         ---------------

                                       **    **
                                       *  IN  *
             simple-object-expression **      ** CLASS-identifier
                                       *  IS  *
                                       **    **

         The vertical stacking of syntactic units indicates the  range
         of available choices of which exactly one must be taken.  The
         example   shows   that    in    an    "object-relation",    a
         "simple-object-expression"  must  be  followed by the literal
         occurrence of either "IN" of "IS" (but not both) and then  by
         a "CLASS-identifier".
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 66
CHAPTER 2.1


     5.  The exclamation point  !  indicates alternatives.

         Example:  the definition of a digit is

         digit
         -----
                   0!1!2!3!4!5!6!7!8!9

         This has the same interpretation as

              ** **
              * 0 *
              * 1 *
              * 2 *
              * 3 *
             ** 4 **
              * 5 *
              * 6 *
              * 7 *
              * 8 *
              * 9 *
              ** **

         but saves considerable  space.   Both  the  methods,  rule  4
         (**    **)  and  rule  5  ( ! )  are  used  in this manual to
         display alternatives.  We will usually stick to  the  use  of
         braces  as  this notation is clearer, and use ! only when the
         former notation takes up too much space.

     6.  Square brackets [ ] denote  options.   Anything  enclosed  in
         square brackets may appear once or not at all.

         Examples:  the definition of a CLASS-declaration is

         CLASS-declaration
         -----------------

              [CLASS-identifier] main-part

         This denotes a syntactic unit "main-part" optionally preceded
         by a "CLASS-identifier".

         If alternatives are also optional, we use  vertical  stacking
         within the square brackets.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 67
CHAPTER 2.1


         Thus the much simplified version of an activation-statement

             ACTIVATE      [ BEFORE Y              ]
                           [ AT time [PRIOR]       ]

         would allow the following alternatives:

             ACTIVATE X
             ACTIVATE X BEFORE Y
             ACTIVATE X AT time
             ACTIVATE X AT time PRIOR

     7.  Three  dots ... denote  the  occurrence  of  the  immediataly
         preceding  grouping  one or more times in succession, i.e.  a
         repetition.

         Examples:

         The definition of digits is:

         digits
         ------

              digit ...

         denoting the occurrence of at least one digit such as

              1
              0935
              1976

         The definition of a compound-statement is:

         compound-statement
         ------------------

              BEGIN [statement ;]... [statement]  END

         (The  statement  preceding  END  may  be  terminated   by   a
         semicolon;  DUMMY-statement)

         Examples;

             BEGIN END
             BEGIN ; END

             BEGIN  statement  END
             BEGIN  statement ; END
             BEGIN  statement;
                    statement;
                    statement;
             END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 68
CHAPTER 2.2


2.2  BASIC SYMBOLS AND SYNTACTIC VARIABLES

A program written in SIMULA may contain only

     basic symbols
     identifiers
     constants

Apart from  CHARACTER-constants,  TEXT-constants  and  comments  where
extra  latitude  is  allowed,  a  program must contain only characters
belonging  to  the  language  character   set.    These   are   either
alphanumeric  characters,  special  symbols or key words.  Examples of
special symbols are

     +       -       (       )       [       ]

which have obvious interpretations.  In addition,  SIMULA  needs  many
other  special  symbols and, instead of using peculiar combinations of
special characters for their representation,  SIMULA  uses  key  words
such  as  BEGIN,  CLASS.   These  key  words  are  reserved within the
language and may be used only as key words.



2.2.1  LANGUAGE CHARACTER SET

The SIMULA basic symbol set is  built  up  from  a  character  set  of
alphabetic-characters, decimal-digits and special-characters.

There are 52 international alphabetic-characters - the upper and lower
case  letters  A  through  Z,  a  through z.  DECsystem-10 SIMULA also
regards the swedish letters AA (A with  a  circle),  AE  (A  with  two
dots),  OE  (O  with  two  dots) as alphabetic (see below).  Except in
certain constants, the upper  and  lower  case  version  of  the  same
letters are interpreted as identical.

There are 10 decimal-digits - the digits 0 through 9.

An alphanumeric-character is  either  an  alphabetic  character  or  a
decimal digit.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 69
CHAPTER 2.2.1


The special-characters may have  an  independent  meaning  within  the
language  (such  as + or -) or may be used in combinations (such as :=
or =/=).  Their names and the graphics by which they  are  represented
are:


     name                   graphic
     ----                   -------

     blank or space             
     plus                      +
     minus                     -
     asterisk or multiply      *
     divide                    /
     equals                    =
     greater than              >
     less than                 <
     not                       \ (alt. representation "NOT")
     comma                     ,
     dot or period             .
     exponent                  &
     colon                     :
     semicolon                 ;
     uparrow                   ^
     left parenthesis          (
     right parenthesis         )
     character quote           '
     text quote                "
     underscore                -
     left square bracket       [
     right square bracket      ]
     exclamation sign          !
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 70
CHAPTER 2.2.1


The swedish letters AE AA OE ae aa  oe  correspond  to  the  following
international equivalents:


     Swedish    International    Octal    Decimal
     letter         symbol       rank       rank
     --------------------------------------------
                     
        AA             $          044         36
        AE             #          043         35
        OE             @          100         64
        aa             }          175        125
        ae             {          173        123
        oe             `          140         96


                              !! IMPORTANT !!

               The   use   of   these   characters   in
               identifiers  does  not  agree  with  the
               standard  definition   of   the   SIMULA
               programming  language.   Programmers are
               therefore  advised  not  to  use   these
               letters  in  identifiers.   If  you  use
               them, note that all lower  case  letters
               in  identifiers  are  interpreted by the
               compiler identical to the  corresponding
               upper-case    letter,    ae    is   thus
               interpreted as AE, aa as AA  and  oe  as
               OE.

A full description of the DECsystem-10 SIMULA character set  is  given
in appendix A to the DECsystem-10 SIMULA Language Handbook part I.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 71
CHAPTER 2.2.2


2.2.2  BASIC SYMBOLS

Any  program  written  in  SIMULA  may   contain   only   alphanumeric
characters, the special characters and device control characters (like
tab and formfeed), except  within  CHARACTER-  or  TEXT-constants  and
comments  (see  DATA CHARACTER SET section 2.3).  Certain combinations
of these allowable characters have special significance and are called
basic symbols.

They fall into two classes:

     delimeters
     key-words



delimiters
----------

The delimiters used by the language are divided into 6 types:

     1.  Arithmetic-operators
     2.  Logical-operators
     3.  Brackets
     4.  Reference-comparators
     5.  Relational-operators
     6.  Separators

     1.  Arithmetic-operators

         The arithmetic-operators are:

             +   denoting addition or unary plus
             -   denoting subtraction or unary minus
             *   denoting multiplication
             /   denoting division
        ^ or **  denoting "raised to the power of"
             //  denoting integer division

     2.  Logical-operators

         The five logical-operators denoting NOT, OR, AND, EQV and IMP
         (the   last  two  representing  equivalence  and  implication
         respectively) are represented by key words.  In the  case  of
         NOT there is the alternative representation '\'.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 72
CHAPTER 2.2.2


     3.  Brackets

         The brackets are:

         The brackets
         (    )
         are used in expressions, for enclosing  parameter  lists  and
         for array and switch bounds and indices, the square brackets
         [    ]
         only be used for array and switch bounds and indices.

             '   encloses character constants
             "   encloses text constants

     4.  Reference-comparators

         The reference-comparators are:

             ==  denoting reference equal to
             =/= denoting reference not equal to

     5.  Relational-operators

         The relational-operators have  dual  representations  as  key
         words and symbol combinations

             =   (or EQ)  denoting equal to
             \=  (or NE)  denoting not equal to
             >   (or GT)  denoting greater than
             >=  (or GE)  denoting greater than or equal to
             <   (or LT)  denoting less than
             <=  (or LE)  denoting less than or equal to
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 73
CHAPTER 2.2.2


     6.  Separators


         name           graphic         use
         ----           -------         ---

         comma             ,     separating elements in lists

         dot               .     denoting decimal point in REAL
                                 numbers;  remote accessing

         colon             :     follows labels; follows VIRTUAL;
                                 separates array bounds in array
                                 declarations

         becomes           :=    in value assignments

         denotes           :-    in reference assignments

         semicolon         ;     separates declarations and
                                 statements; separates various parts
                                 of procedure and class headings

         exclamation mark  !     may be used instead of COMMENT to
                                 indicate the start of a comment

         blank                   used as a separator

         underscore        _     used in identifiers (e.g.
                                 RATE_OF_PAY)

            ( )            &     power-of-ten symbol in REAL and
                                     10 LONG REAL constants.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 74
CHAPTER 2.2.2


key-words
---------

A key-word is an identifier which is a part of the  language  and  its
use  is  reserved  for  that  purpose.  Key-words may be classified as
follows: (1)

     1.  Statement-brackets
     2.  Declarators
     3.  Specificators
     4.  Operators
     5.  Key-word-constants

     1.  Statement-brackets

         The statement-brackets are:

              BEGIN
              END

         which are used to demark the limits of  blocks  and  compound
         statements.

     2.  Declarators

         The declarators are:

             BOOLEAN
             CHARACTER
             INTEGER
             SHORT INTEGER
             REAL
             LONG REAL
             TEXT
             REF (CLASS-identifier)
             CLASS
             PROCEDURE
             SWITCH
             ARRAY

         which are used in declarations and specification lists.   The
         key  words SHORT and INTEGER, LONG and REAL must be separated
         by at least one space, as

             SHORT   .[...]  INTEGER
             LONG    .[...]  REAL

-------------
(1)  In  addition  to  this,  the  word  OPTIONS  is  a  reserved  word  in
DECsystem-10  SIMULA  and  is used in the OPTIONS statement to give certain
machine-dependent information to the system (e.g.  if  you  want  a  source
program  listing  or  not,  if  you  want to generate symbol tables for the
SIMULA Debugging System or not etc.).  For further  information  about  the
OPTIONS statement see the DECsystem-10 SIMULA Language Handbook part II.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 75
CHAPTER 2.2.2


     3.  Specificators

         The specificators are:

             HIDDEN
             LABEL
             NAME
             PROTECTED
             VALUE
             VIRTUAL

         which are used in specification parts to  procedures  (LABEL,
         NAME,   VALUE)   or   to  classes  (VALUE,  VIRTUAL,  HIDDEN,
         PROTECTED).

     4.  Operators

         The operators are divided into 4 classes:

             logical-operators
             relational-operators
             sequential-operators
             special-operators

         The logical-operators are:

             AND         denoting the logical and
             OR          denoting the logical inclusive or
             NOT (or \)  denoting logical negation
             EQV         denoting logical equivalence
             IMP         denoting logical implication

         The relational-operators are:

             EQ (or =)   denoting equal to
             NE (or \=)  denoting not equal to
             GT (or >)   denoting greater than
             GE (or =)   denoting greater than or equal to
             LT (or <)   denoting less than
             LE (or <=)  denoting less than or equal to
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 76
CHAPTER 2.2.2


         The sequential-operators are:

             GOTO
             used in GOTO-statements.  GOTO may also be written
             GO  ...  TO (with any number of blanks between GO and TO,
             which means that GO and TO both are reserved words),

             FOR
             STEP
             UNTIL
             WHILE
             DO
             used in WHILE- and FOR-statements (DO also appears in
             connection-statements),

             IF
             THEN
             ELSE
             used in conditional-statements and
             conditional-expressions,

             INSPECT
             WHEN
             DO
             OTHERWISE
             used in connection-statements.  (DO also appears in
             WHILE- and FOR-statements),

             ACTIVATE
             REACTIVATE
             DELAY
             AFTER
             BEFORE
             AT
             PRIOR
             used in activation-statements,

             INNER
             used in CLASS-bodies to alter the order of execution of
             statements from their textual order,
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 77
CHAPTER 2.2.2


         The special-operators are:

             NEW
             is used in generating objects,

             THIS
             THIS CLASS-identifier represents a reference to the
             nearest textually enclosing object of a class equal to or
             inner to that of the CLASS-identifier,

             QUA
             defines the scope of a reference expression,

             IS
             IN
             used to test class membership,

             COMMENT or !
             used to insert descriptive text among the basic symbols
             of a program.

         The key-word-constants are:

             TRUE
             FALSE
             represent logical values,

             NONE
             represents the "no object reference",

             NOTEXT
             represents "no text object", i.e.  the empty text.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 78
CHAPTER 2.2.3


2.2.3  DATA CHARACTER SET

Although the language character set is a fixed  set  defined  for  the
language,  the  data  character set has not been limited.  Data may be
represented by  characters  from  the  language  set  plus  any  other
ISO-7(ISO R 646) characters.



Collating sequence
------------------

The 128 members of the data character set have associated with them  a
unique  INTEGER  value  in the range 0-127.  This sequence is known as
the collating sequence.  It is thus possible to  make  comparisons  of
CHARACTERs  meaningful  by  comparing the associated numerical values,
such as

     'A'  <  'B'
     INCHAR  =  ' '

Parts of the collating sequence are given in Appendix A.



2.2.4  THE USE OF BLANKS

Identifiers, composite operators (e.g.  =/=), key words (e.g.   BEGIN)
may  not contain blanks.  Blanks are permitted as CHARACTER-constants,
in TEXT-constants and in arithmetic constants.

Identifiers, constants and key words may not be immediately  adjacent.
They   must  be  separated  by  an  arithmetic  operator,  parenthesis
(  () [ or ]  ),  reference  comparator,  negation  (\),  non-key-word
relational   operator   (<,<=,=,\=,>,>=,==,=/=),  comma,  dot,  colon,
becomes  symbol  (:=),  denotes  symbol  (:-),  semicolon,  or  blank.
Moreover additional intervening blanks are always permitted.

Examples:

         X + Y      is equivalent to X+Y
         A [I ]     is equivalent to A[I]
         A  :=X :=Y is equivalent to A:=X:=Y
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 79
CHAPTER 2.2.5


2.2.5  COMMENT CONVENTIONS

Comments are used  for  documentation  (the  insertion  of  a  textual
description  of  part  of  the  program) and do not participate in the
execution of a program.  The following conventions hold:


Sequence of basic symbols
-------------------------


The sequence:                                          ! is equiv. to:
                                                       !
                           **                     **   !
           **         **   *  any sequence from    *   !
           *  COMMENT  *   *  the data character . *   !
Delimiter **     !     ** **  set not including    ** ;! Delimiter
           *           *   *  a semicolon          *   !
           **         **   **                     **   !
                                                       !
     **                             **                 !
     *  any sequence from the data   *                 !
END **  character set not including  **                ! END
     *  END!ELSE!WHEN!OTHERWISE!;    *                 !
     **                             **

Examples:

1.  BEGIN COMMENT***THE NEXT BLOCK IS USED FOR PAY-ROLL
                   CALCULATIONS***;

            BEGIN .....
                  .....
            END OF PAY-ROLL BLOCK;
            .....
    END

WHERE THE STRINGS "COMMENT .... ;" and "OF PAY-ROLL BLOCK" are treated
as comments.

2.  IF X > 0 THEN BEGIN .....
                  END OF TRUE PART
             ELSE BEGIN .....
                  END OF FALSE PART;

WHERE THE STRINGS "OF TRUE PART" and "OF FALSE PART"  are  treated  as
comments.

3.  X := X !THAT WAS X;**2 COMMENT**SQUARED;;
    is equivalent, as regards program execution, to 
    X := X**2;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 80
CHAPTER 2.2.5


2.2.6  CODING SIMULA PROGRAMS

A SIMULA source program on the DECsystem-10 may contain lines with  up
to  135  characters.   The  lines may be line-numbered in the standard
DECsystem-10 way.  Some of the lines in a line-numbered source program
may have blank line numbers.

If you convert SIMULA source programs from a system which expects  the
source program in columns 1-72, you should remove columns 73-80.  (You
can use PIP, the IBMSIM, or the CDCSIM program to do this.)

This will be  described  in  greater  detail  in  DECsystem-10  SIMULA
Language Handbook Part II.


2.3  IDENTIFIERS
     -----------

An identifier is a string of alphanumeric  or  underscore  characters,
not  contained  in  a  comment or constant, preceded and followed by a
delimiter - the initial character must be a letter.



identifier
----------

         letter[ letter ! digit ! _ ]...

Examples:

         valid identifiers
         -----

         X
         SIMULA_67
         A15
         MORGAN_PLUS_4

         invalid identifiers
         -------

         END        reserved for use as a keyword
         SYM BOL    contains a blank
         3C         does not begin with a letter
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 81
chapter 2.3


Length of identifiers
---------------------

Identifiers in a SIMULA program may  be  composed  of  any  number  of
alphanumeric or underscore characters, but in DECsystem-10 SIMULA only
the first twelve are significant.  Thus if two identifiers contain the
same first twelve characters they are considered equivalent.

       e.g.  BIORTHOGONAL   and
             BIORTHOGONALISATION

will both be treated as occurrences of the identifier

             BIORTHOGONAL

NOTE ! THE  USE  OF  DIFFERENT  EXTERNAL  IDENTIFIERS  (PROCEDURES  or
CLASSES)  which  are  equivalent  in  the  first six characters is not
recommended.


Identifiers and key words
-------------------------

It is not possible  to  use  a  key  word  as  an  identifier.   Every
occurrence  would be treated as an occurrence of that key word and its
use as an identifier would result in errors.



Basic binding rules
-------------------

Variables, arrays, switches, procedures and classes  are  said  to  be
quantities.   Identifiers  serve to identify quantities, or they stand
as labels or formal parameters.  Identifiers have no inherent  meaning
and  may  be  chosen  freely  (except that they may not clash with key
words).

Every identifier used in a program must be declared.  This is achieved
by:

     1.  A declaration  (section  5),  if  the  identifier  defines  a
         quantity.   It  is  then  said  to  be a J-variable, J-ARRAY,
         J-PROCEDURE-, PROCEDURE-, CLASS-identifier where J stands for
         the type of the declared quantity.

     2.  Its occurrence as a label (section  5.6)  if  the  identifier
         stands as a label.  It is then said to be a LABEL-identifier.

     3.  Its occurrence in  the  formal-parameter-list  (section  5.4,
         5.5)  of  a PROCEDURE- or CLASS-declaration.  It is then said
         to be a formal-parameter.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 82
chapter 2.3


The  identification  of  the  definition  of  a  given  identifier  is
determined  by binding rules.  The basic binding rules given below are
later extended in the cases of remote accessing (section 6.1), VIRTUAL
quantities (section 5.5), and connection (section 7.2).

     1.  If the  identifier  is  defined  within  the  smallest  block
         (section 7.1) textually enclosing the given occurrence by its
         occurrence as a quantity  or  label,  then  it  denotes  that
         quantity or label.

         The statement  following  a  procedure  heading  or  a  class
         heading  is  always considered to be a block, which makes the
         binding to formal parameters a special case.

     2.  Otherwise if the block is a procedure or a class body and the
         given  identifier is identical with a formal parameter in the
         associated procedure or class heading,  then  it  stands  for
         that formal parameter.

Otherwise, these rules are applied by considering the  smallest  block
textually enclosing the block which has been previously considered.

If these steps lead to more than one definition or to  no  definition,
then the identification is illegal.

Example:

         line 1      BEGIN PROCEDURE A;
              2              X := X + 1;
              3              REAL X;
              4              BEGIN REAL X;
              5                    X := 2;
              6              LAB:  A;
              7              END;
              8      END

The block spanning lines  4-7  is  textually  enclosed  in  the  block
spanning lines 1-8.  The procedure declaration of lines 1-2 is treated
as though it were

         PROCEDURE A;
         BEGIN  <dummy-declaration>;
                X := X + 1;
         END;

Thus the occurrence of X at line 5 is bound  to  the  declarations  of
line  4,  whereas  in  the  invocation  of the procedure at line 6 the
binding rule for the occurrence of X in the procedure body is  to  the
variable declared at line 3.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 83
chapter 2.4


2.4  TYPES AND CONSTANTS
     -------------------

Constants and variables possess values and types.  Both the value  and
type of a constant are determined by the way it is written.  The value
of a variable is the one most recently assigned to it, or its  initial
value  if  no assignment has yet been made, and its type is determined
by its declaration.



2.4.1  TYPES

Type is subdivided into two classes by:

type
----
           **               **
           *                 *
          **  value-type     **
           *  reference-type *
           *                 *
           **               **

where value-type and reference-type are defined by:


value-type
----------


           **               **
           * [SHORT ]INTEGER *
          **  [LONG ]REAL    **
           *  BOOLEAN        *
           * CHARACTER       *
           **               **


reference-type
--------------


           **                     **
           *                       *
          ** REF(CLASS-identifier) **
           * TEXT                  *
           *                       *
           **                     **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 84
CHAPTER 2.4.2


2.4.2  CONSTANTS

A constant is a fixed, unvarying quantity that  denotes  itself,  i.e.
it  can not alter during the course of a program.  Each constant has a
uniquely defined type.  The discussion of constants follows the order:

         arithmetic-constants
         BOOLEAN-constants
         CHARACTER-constants
         object-reference-constant
         TEXT-constant

Null characters (characters with RANK = 0 or  RANK = 177(8) = 127(10))
are  ignored  wherever  they appear in input source programs, and they
can thus appear anywhere within a constant.



arithmetic-constants
--------------------

Arithmetic-constants may be written with the bases 2, 4, 8, 10 or  16.
The  base  10 (decimal)  is  assumed unless otherwise indicated.  Note
that

     1.  The use of arithmetic-constants is optimised by the system

     2.  Any '+' or  '-'  sign  preceding  an  arithmetic-constant  is
         treated separately.



decimal-constant
----------------

Decimal-constants are interpreted according to  conventional  notation
with  '&'  or  '&&'  representing  the  exponent  sign.   If a decimal
constant contains either a decimal point,  or  an  exponent  sign,  or
both,  it  is  interpreted  as  a  (LONG)  REAL number, if it contains
neither a decimal point nor an exponent sign, it is taken to represent
an INTEGER number.


decimal-digit
-------------


           **                   **
           *                     *
          ** 0!1!2!3!4!5!6!7!8!9 **
           *                     *
           **                   **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 85
CHAPTER 2.4.2


decimal-digits
--------------

         decimal-digit ...

representing a run of at least one decimal digit.

Examples:
--------        000
                  1
             315730


INTEGER-constant
----------------

decimal digits

The range of values is the set of whole numbers from 0 through  2^35-1
(=34 359 738 367).   If the magnitude is equal to or exceeds 2^35, the
number is interpreted as a REAL constant.

Examples:
--------          0
                 91
              81472

[LONG]REAL-constant
-------------------


      **                                                  **
      *  **                                  **            *
      *  *  .decimal-digits                   *            *
      * **  decimal-digits.decimal-digits     **  exponent *
      *  *  decimal-digits                    *            *
      *  **                                  **            *
     **                                                    **
      *     .decimal-digits                                *
      *     decimal-digits.decimal-digits                  *
      *     exponent                                       *
      **                                                  **

where exponent takes the form
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 86
CHAPTER 2.4.2


exponent
--------

               [+]
          & [&][-]decimal-digits

i.e.  the symbol '&' or '&&', optionally followed  by  a  '+'  or  '-'
sign,  followed  by  an  INTEGER-constant.   The exponent represents a
scale factor expressed as an integral power of 10.

The range of values of  (LONG)  REAL-constants  is  0.147&-38  through
0.170&+39  (approximately).   A  true zero is also representable.  The
symbol '&' indicates REAL constants, the symbol  '&&'  indicates  LONG
REAL  constants.   The precision is approximately 9 decimal digits for
REAL constants and 18 decimal digits for LONG REAL constants.

Examples
--------

Valid
-----
                      0.0
                  999.999
                 57.6&+21     REAL
                     .3&1
                      3&1
                      &-1

           314.1592653&&0
          21.2274568&&+03    LONG REAL


Invalid
-------
                       3.      No digit after the decimal-point
                  3,149.2      Embedded comma
                    33.4&      No scale factor
                  23.4&87      Out of range
   
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 87
CHAPTER 2.4.2


Other number systems than decimal
---------------------------------

Constants may have a radix of 2, 4, 8 or 16 by  putting  the  sequence
"nR"  where n is the radix, immediately in front of the constant.  For
radix  16,  the  letters  A  through  F  are  used  to  represent  the
hexadecimal equivalents of 10 to 15.

Examples:

     16R56789     hexadecimal
     16RB1FF      hexadecimal
     2R10110011   binary
     8R7777777    octal



BOOLEAN-constants
-----------------

These are the  key  words  FALSE  and  TRUE  whose  interpretation  is
obvious.


CHARACTER-constants are represented by
-------------------

'[any one printable member of the data character set]'  (1)

Examples:

Valid CHARACTER-constants:
-----

     'X'
     '&'
     ' '
     '''    the character quote itself

Invalid CHARACTER-constants:
-------

     ':-'    two data character set members
     'A '    blanks are significant in character constants
     X       no embedding character quotes
     '4      no terminating character quote.






-------------
(1)  By a printable character is meant a character with RANK
between 40 and 176 (octal), i.e.  32 and 126 (decimal).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 88
CHAPTER 2.4.2


TEXT-constants have the form
--------------

"[any sequence of printable members of the data character set]"(2)

A TEXT constant can contain the device control characters VT,  CR,  LF
and  FF,  but  these are not treated as part of the text constant.  To
include the character " in a text  constant,  repeat  it  twice.   The
length  of  a  TEXT  constant is the number of printable characters it
contains.  The length may be a natural number in the range  0  through
2^15.   (Note that text variables can be longer than this!) Blanks are
significant in text constants.

(However, a text variable can contain device control  characters,  and
it  is  easy  to  copy  a  text  constant  to  a variable and then use
"T.PUTCHAR(CHAR(n))" to insert the character  with  RANK  n  (decimal)
into it.)

Examples


Valid TEXT constants
-----

     "THISTEXTCONSTANTHASNOBLANKS"
     "THIS ONE HAS"
     """THIS ONE BEGINS AND ENDS WITH A DOUBLE-QUOTE"""

     "MULTI-"  \   Equivalent to:
     "LINE "    -  "MULTI-LINE TEXT"
     "TEXT"    /


Invalid TEXT constants:
-------

     "ONE " TOO MANY"       imbedded double-quote is not doubled
     "NEVER ENDING          contains no terminating double-quote


Object-reference-constant
-------------------------

There is only one object-reference-constant, namely

     NONE

Any object reference variable may take the value NONE.



-------------
(2)  By a printable character is meant a character with RANK
between 40 and 176 (octal), i.e.  between 32 and 126 (decimal).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 89
CHAPTER 2.5


2.5  DECLARATIONS
     ------------

Declarations introduce a measure of  security  into  the  language  by
associating  identifiers  with variables, arrays, switches, procedures
and classes used in the programs.

A declaration determines the type and structure of a quantity.

Declarations must appear in a block head,  and  upon  exit  from  that
block  (unless  it  is the outermost block of a class body), they lose
their significance.


declaration
-----------


           **                      **
           *  TYPE-declaration      *
           *  ARRAY-declaration     *
           *  SWITCH-declaration    *
          **  PROCEDURE-declaration **
           *  CLASS-declaration     *
           *  EXTERNAL-declaration  *
           **                      **

Common to  each  of  the  succeeding  sections,  which  discuss  these
declarations, is the definition of an identifier-list.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 90
CHAPTER 2.5


identifier-list
---------------

     identifier [, identifier]...

in which the identifiers must all be different.


Examples:
--------


Valid
-----

     AXOLOTL
     A, B, MARY, B_14


Invalid
-------

     A  B           no separating comma

     A, END, Q      END is a  key  word  and  is  not  allowed  as  an
                    identifier.

     B1,B2, B1      the same identifier appears twice

BIORTHOGONAL, BIORTHOGONALISATION
                    the identifiers are not distinct (only  the  first
                    twelve characters are significant).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 91
CHAPTER 2.5.1


2.5.1  TYPE DECLARATIONS

Type  declarations  associate  each  identifier  in   the   associated
identifier  list  with a variable of a given type.  This restricts the
range of values that may be assigned to that variable.


type-declaration
----------------


           **                       **
           *  [LONG]REAL             *
           *  [SHORT]INTEGER (3)     *
           *  CHARACTER              *
          **  BOOLEAN                **  identifier-list
           *  REF(CLASS-identifier)  *
           *  TEXT                   *
           **                       **


Examples:
--------


valid:
-----

     value-type     REAL R1, R2
                    LONG REAL P1
                    INTEGER I, J, K
                    SHORT INTEGER SH1
                    CHARACTER A, B, C, D
                    BOOLEAN B1, B2, B3

     reference-type REF(POINT) P, Q
                    TEXT MY_STRING, YOUR_STRING


invalid:
-------

     SHORT REAL ONE          No such type
     REF LINE_1, LINE_2      No such type - the qualification
                                      is omitted.

INTEGER and SHORT INTEGER variables may only assume whole numbers.

REAL and LONG REAL variables may only assume numbers.


-------------
(3)  SHORT is included for compatibility with 360/370 SIMULA,  but  on  the
DEC 10  both  SHORT INTEGERS and INTEGERS are in fact stored in full 36 bit
words.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 92
CHAPTER 2.5.1


N.B.  An arithmetic expression of any arithmetic type (SHORT  INTEGER,
INTEGER,  REAL,  LONG REAL) may be assigned to an arithmetic variable.
If the types do not correspond, the expression is first  converted  to
the type of the variable and then transferred, subject to its being in
range.  If it is not in range, then a run time error will result.

BOOLEAN variables may only assume the values TRUE and FALSE.

CHARACTER variables may only assume values  from  the  data  character
set.

TEXT variables may only assume strings of  characters  from  the  data
character set or NOTEXT.

REF variables may only assume the value NONE or references to  objects
belonging to their qualifying class or its subclasses.

SIMULA has no built-in COMPLEX arithmetic, but it is  easy  to  define
COMPLEX yourself as

          CLASS complex(re,im);
          REAL re, im;
          BEGIN
             REF (complex) PROCEDURE plus(arg2);
             REF (complex) arg2;
             BEGIN ...
             END;
             ...
          END;

Each variable declared in a type  declaration  has  an  initial  value
(given in the table below).  Thereafter the value of a variable is the
one last assigned to it, or if no assignment has yet  been  made,  the
initial value.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                       Page 93
CHAPTER 2.5.1


     Type      Initial value       Assignable range
     ----      -------------       ----------------


[SHORT] INTEGER     0        Whole number in the range  -2^35  through
                             2^35-1.


[LONG] REAL         0.0      Exact 0 or  +-  a  number  in  the  range
                             0.146 936 793 852 785 939&&-38         to
                             0.170 141 183 460 469 231&&+39    to    9
                             decimal  places for REAL variables and to
                             18   decimal   places    for    LONG REAL
                             variables.

BOOLEAN            FALSE     TRUE, FALSE.

CHARACTER          CHAR(0)   CHAR(0), CHAR(1), ...  CHAR(127).

REF(CLASS-         NONE      NONE or any object of the qualifying class
    identifier)              or included in the qualifying class.

TEXT               NOTEXT    NOTEXT or any string of  characters  from
                             the   data  character  set  of  length  0
                             through  2^18-1  characters.   The   text
                             constant "" is identical to NOTEXT.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 94
CHAPTER 2.5.2


2.5.2  ARRAY DECLARATIONS

An array is a structure of many components (subscripted variables) all
of  the  same type.  Each component has the same identifier (the array
identifier),  and  they  are  distinguished  one   from   another   by
subscripts.   Arrays  invite  the  user  to  group like data under one
identifier.

Arrays are declared with a certain shape.  They can have 1 through  10
dimensions  (which  is the number of subscripts necessary to specify a
certain component), and each dimension has a fixed range specified  by
giving an upper and lower bound.

Pictorial representations of one, two and three dimensional arrays are
now given.

One dimensional array

INTEGER ARRAY NUMBER [4:9];


         -------------
         ! NUMBER[4] !
         -------------
         ! NUMBER[5] !
         -------------
         ! NUMBER[6] !
         -------------
         ! NUMBER[7] !
         -------------
         ! NUMBER[8] !
         -------------
         ! NUMBER[9] !
         -------------


Dimensions 1:
Lower subscript bound = 4
Upper subscript bound = 9
Declares 6 subscripted variables each of type INTEGER and  initialized
to 0.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 95
CHAPTER 2.5.2


Example:

Find the sum of the components of the array NUMBER.

     SUM := 0;
     FOR I := 4 STEP 1 UNTIL 9 DO
         SUM := SUM + NUMBER[I];


Two dimensional array

REF(POINT) ARRAY A[0:3, 2:4];


         -------------------------------------
         ! A[0, 2]   !  A[0, 3]   !  A[0, 4] !
         -------------------------------------
         ! A[1, 2]   !  A[1, 3]   !  A[1, 4] !
         -------------------------------------
         ! A[2, 2]   !  A[2, 3]   !  A[2, 4] !
         -------------------------------------
         ! A[3, 2]   !  A[3, 3]   !  A[3, 4] !
         -------------------------------------


Dimensions 2:
Lower subscript bound 1 = 0
Upper subscript bound 1 = 3
Lower subscript bound 2 = 2
Upper subscript bound 2 = 4

Declares 12 subscripted variables each of  type  REF(POINT)  and  each
initialized to NONE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 96
CHAPTER 2.5.2


Example:

Scan the array and count how many subscripted variables are  currently
referencing NONE.

     COUNT := 0;
     FOR I := 0 STEP 1 UNTIL 3 DO
     FOR J := 2 STEP 1 UNTIL 4 DO
             IF A[I, J] == NONE
                THEN COUNT := COUNT + 1;


Three dimensional array

BOOLEAN ARRAY B[0:2, 0:3, -1:0];


         /-----------------------------------------------/
        / B[0,0,0]  / B[0,1,0]  / B[0,2,0]  / B[0,3,0]  /!
       /-----------/-----------/-----------/-----------/ !
      /           /           /           /           /  !
     /-----------------------------------------------/   !
     ! B[0,0,-1] ! B[0,1,-1] ! B[0,2,-1] ! B[0,3,-1] !   !
     !-----------------------------------------------!   !
     ! B[1,0,-1] ! B[1,1,-1] ! B[1,2,-1] ! B[1,3,-1] !   /
     !-----------------------------------------------!  /
     ! B[2,0,-1] ! B[2,1,-1] ! B[2,2,-1] ! B[2,3,-1] ! /
     !-----------------------------------------------!/


(Each component is represented by a cube).

Dimensions 3:
Lower subscript bound 1 = 0
Upper subscript bound 1 = 2
Lower subscript bound 2 = 0
Upper subscript bound 2 = 3
Lower subscript bound 3 = -1
Upper subscript bound 3 = 0

Scan through the array and set the values of each subscripted variable
to TRUE.

     FOR I := 0 STEP 1 UNTIL 2 DO
         FOR J := 0 STEP 1 UNTIL 3 DO
             FOR K := -1 STEP 1 UNTIL 0 DO
                 B[I,J,K] := TRUE;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 97
CHAPTER 2.5.2


ARRAY-declaration

     [type] ARRAY ARRAY-segment [,ARRAY-segment]...

ARRAY-segment

     identifier-list (lower-bound:upper-bound
                          [,lower-bound:upper-bound]...)


Examples:

ARRAY-segment          A[1:10]
                       B,C[1:15, 0:N**2]

ARRAY-declaration      ARRAY ALFA [0:N]
                       REF(LINE) ARRAY L,M[0:P.X]
                       TEXT ARRAY R,S[1:5], T[1:4,ININT:IF X=0
                                                 THEN 10 ELSE 100]


Each identifier in an array declaration is associated with an array of
a  given type (if no type is given, the type is taken to be REAL).  To
enable arrays of the same type, but with different shapes  (number  of
dimensions  and subscript ranges) to be declared in the same place, an
array declaration  contains  one  or  more  ARRAY-segments  which  are
identifier-lists  followed  by  their  common  shape.   The  number of
dimensions is the number of  upper-bound  lower-bound  pairs  and  the
range    of    each   subscript   is   specified   directly   by   the
upper-bound/lower-bound pairs taken in order.

Note that although the  lower-  and  upper-bounds  may  be  arithmetic
expressions  their  value is the rounded integer as evaluated on entry
to the block.  To be valid, the value of each lower bound must be less
than  or  equal  to  the value of its associated upper bound.  Neither
bound may refer to a quantity declared in the same  block  head.   The
value  of  each  subscripted  variable is initialized according to the
type of the array.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 98
CHAPTER 2.5.3


2.5.3  SWITCH DECLARATIONS

A switch is declared with a list  of  designational-expressions  which
are accessed by an index.  The length of the list, N, gives the number
of switch elements.  The value of each element is the current value of
the  designational-expression  (a  label  to  a  statement, or another
switch value).

SWITCH-declaration

SWITCH SWITCH-identifier := designational-expression
                                [,designational-expression]...


Examples:

SWITCH SW := L1, L2, T[N], M1
SWITCH T := M1, IF N<0 THEN L1 ELSE L3, M1


A SWITCH declaration contains a list of designational expressions each
of  which  is given a positive index (starting from 1) by counting the
items  in  the  list  from  left  to  right.    The   value   of   the
switch-designator  (see section 6.6) corresponding to a given index is
the current value of the designational expression having the index  in
the   corresponding   list.   (An  expression  in  a  switch  list  is
re-evaluated every time it is referred to).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                  Page 99
CHAPTER 2.5.4


2.5.4  PROCEDURE DECLARATION

A procedure declaration defines an  action  cluster  and  gives  it  a
formal  name.   The  action  cluster is the body of the PROCEDURE.  To
increase the generality of  the  concept,  there  are  facilities  for
transmitting  parameters  and  returning a function value at run time.
Thus a procedure is able to interact with its calling  environment  by
bindings established by the calling mechanism.

By means of the  procedure  concept,  special  instances  of  declared
action clusters become meaningful units within the SIMULA program.

PROCEDURE-declaration
---------------------


           **                              **
           *  proper-procedure-declaration  *
          **                                **
           *  function-declaration          *
           **                              **


proper-procedure-declaration
----------------------------

          PROCEDURE  PROCEDURE-heading  PROCEDURE-body

function-declaration
--------------------

          type PROCEDURE  PROCEDURE-heading  PROCEDURE-body

PROCEDURE-heading
-----------------


                      **                                          **
                      *                     ;                      *
PROCEDURE-IDENTIFIER **  formal-parameter-part mode-part spec-part **
                      *                                            *
                      **                                          **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 100
CHAPTER 2.5.4


formal-parameter-part
---------------------

(identifier-list);  (4)

mode-part


           **                              **
           *  VALUE  identifier-list;       *
          **                                **
           *  NAME   identifier-list;  ...  *
           **                              **

spec-part


      **                                                **
      *    **                **                          *
      *    *  type            *                          *
      *    *  [type] ARRAY    *                          *
      *    *  PROCEDURE       *                          *
     **   **  type PROCEDURE  **  identifier-list;  ...  **
      *    *  LABEL           *                          *
      *    *  SWITCH          *                          *
      *    **                **                          *
      **                                                **


procedure-body
--------------

          statement


Note for identifier-list in mode-part and spec-part:

a) Only identifiers from the formal-parameter-part may appear,
b) each of those identifiers must appear only once  in  the  mode-part
   and once in the spec-part.












(4)  The maximum number of parameters is 255.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 101
CHAPTER 2.5.4


Examples:

proper-procedure-declaration
----------------------------

     PROCEDURE SWAP(A,B); NAME A, B;
                          REAL A, B;
     BEGIN  REAL X;
            X := A;
            A := B; B := X;
     END ***SWAP***

     PROCEDURE OUTCOLUMN(A,N); REAL ARRAY A; INTEGER N;
     BEGIN  INTEGER J;
            FOR J := 1 STEP 1 UNTIL N DO
                BEGIN  OUTFIX (A[J], 5, 12);
                       OUTIMAGE;
                END;
     END ***OUTCOLUMN***

     PROCEDURE TREETRAVERSE(N); REF(NODE)N;
     INSPECT N DO
     BEGIN  TREETRAVERSE(LEFTBRANCH);
            DUMP;
            TREETRAVERSE(RIGHTBRANCH);
     END ***RECURSIVE TRAVERSE***

A proper-procedure is used as a statement in its own right.

     INIMAGE

     OUTTEXT("PROPER-PROCEDURE")

     IF B THEN SWAP(TEMP1,TEMP2)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 102
CHAPTER 2.5.4


function-declaration
--------------------

REF(POINT) PROCEDURE ADD(Q);  REF(POINT)Q;
   IF Q =/= NONE THEN ADD :- NEW POINT(X+Q.X,Y+Q.Y)

REAL PROCEDURE NORM(A,N);  REAL ARRAY A;  INTEGER N;
BEGIN REAL T;  INTEGER I;
       FOR I := 1 STEP 1 UNTIL N DO
           T := T + A[I]**2;
       NORM := SQRT(T)
END ***NORM***

INTEGER PROCEDURE FACTORIAL(N);  INTEGER N;
IF N < 0 THEN ERROR ELSE
   IF N < 2 THEN FACTORIAL := 1
            ELSE FACTORIAL := N*FACTORIAL(N-1)


A function returns a value of the type indicated in  its  declaration,
and  may be used wherever a value of that type is legal.  (It may also
be used as a statement in which case the function value is ignored);

     P :- R.ADD(S)

     X := NORM(MATRIX, 10)

     IF NORM (MATRIX, 10) < &-6 THEN
        OUTTEXT ("ELEMENTS ALL (ALMOST) ZERO")

A  PROCEDURE-declaration  defines  a  procedure  associated   with   a
PROCEDURE-identifier.   The chief component of a PROCEDURE declaration
is   the   PROCEDURE-body   which   may   be   activated   through   a
PROCEDURE-statement or a function-designator.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 103
CHAPTER 2.5.4


If the procedure has formal-parameters,  then  their  identifiers  are
listed  in  the formal-parameter part.  No formal-parameter identifier
may appear more than once, and specifications of all formal-parameters
must   be   supplied.   Whenever  the  procedure  is  activated  by  a
PROCEDURE-statement or function-designator, the formal-parameters  are
either  assigned  the  values of the actual-parameters (call by value,
call by reference) or else replaced by the actual-parameters (call  by
name).

Identifiers in the PROCEDURE-body which are not formal-parameters  are
local  if  declared within that body, otherwise they are non-local.  A
PROCEDURE-body  acts  like  a  block   regardless   of   its   format.
Consequently, the scope of any label to a statement within the body or
to the body itself can never be extended  beyond  the  PROCEDURE-body.
In  addition,  if  the  identifier of a formal-parameter is redeclared
within the PROCEDURE-body (or used as a  label),  it  is  given  local
significance    and   the   corresponding   actual-parameter   becomes
inaccessible.

When  a  PROCEDURE-declaration  is  given  a  type,  it  designates  a
function.   The type of this function is the type of the PROCEDURE and
for any activation  its  value  is  the  last  value  assigned  to  an
occurrence  of the PROCEDURE-identifier within the PROCEDURE-body.  If
no such assignment is made, then the result of the function-designator
takes  a  default  value  which is identical to the initial value of a
declared variable of that type.

Within the PROCEDURE-body of a function-procedure, an  assignment  may
be made to an occurrence of the PROCEDURE-identifier.  Every other use
of  the  PROCEDURE-identifier  denotes  another  activation   of   the
procedure (recursion).  Note that is perfectly legal to use a function
procedure call as a single statement  (exploating  it's  side  effects
probably).   For  example:  "SQRT(1);" is a legal statement as well as
"LASTITEM;" (skips blanks and tabs and returns TRUE if end-of-file  is
encountered - see section 3.5.)

Execution of the procedure stops when control is passed to  the  final
END  of  the  procedure  body.   Control is thereafter returned to the
place where the procedure was called.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 104
CHAPTER 2.5.4


PARAMETER TRANSMISSION

N.B.  There are three possible modes for parameter transmission

           call by value
           call by reference
           call by name

All three are allowable for parameters to procedures, but only call by
value  and  call  by  reference  are  valid for parameters to classes.
Since call by value and call by reference are common to procedure  and
class  declarations,  these  sections  apply  to class declarations as
well.

If no mode is specified in  the  mode  part,  then  the  parameter  is
transmitted by the appropriate default mode which is call by value for
value type parameters, and  call  by  reference  for  other  kinds  of
parameters.

The available transmission modes for legal  parameters  to  procedures
are shown in the following table:


                         PROCEDURE PARAMETERS

Parameter                          Transmission

                         by value    by reference    by name

value-type                   D             X            O
object-reference             X             D            O
TEXT                         O             D            O
value-type ARRAY             O             D            O
reference-type ARRAY         X             D            O
PROCEDURE                    X             D            O
type PROCEDURE               X             D            O
LABEL                        X             D            O
SWITCH                       X             D            O

D : default mode
O : optional
X : illegal
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 105
CHAPTER 2.5.4


Call by value
-------------

A formal-parameter called by value designates  a  local  copy  of  the
value  obtained  by  evaluating  the actual parameter.  The evaluation
takes place at the time of procedure entry.  Throughout  the  lifespan
of the procedure or class body, the formal-parameter acts like a local
variable (or value type array (5)) and its contents  may  be  accessed
and  changed  by  local  assignments.   In  the case of an object, the
contents may be accessed and changed from without by remote accessing.

Value specification is redundant for a parameter of value type.  There
is  no  call  by  value  option  for object references, reference-type
ARRAYS, PROCEDURES, type-PROCEDURES, LABELS and SWITCHES.

Example:

Given the program:

     BEGIN  PROCEDURE CALL_BY_VALUE_(X,Y,T1,T2,B);
            VALUE T1, T2, B;
            REAL X, Y; TEXT T1, T2; BOOLEAN ARRAY B;
            BEGIN .................... END;

            BOOLEAN ARRAY TRUTH[0:3];
            TEXT S;
            REAL NUM;
            NUM := 3.5; S :- COPY("+++");
            TRUTH[2] := TRUE;
            CALL_BY_VALUE(4,NUM,S,"O.K",TRUTH);
            ...
     END


















-----------------------------------------------------------
(5)  The type of an arithmetic ARRAY passed by VALUE must be identical
to the formal type.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 106
CHAPTER 2.5.4


then a snapshot on procedure entry shows the  initialized  values  for
the formal-parameters.

                  ---------------------------
                  !            !            !
                  !   BLOCK    !            !<---
                  !            !            !   !
                  !-------------------------!   !
                  !                         !   !      ---------
                  ! PROCEDURE CALL_BY_VALUE !   !      ! FALSE !
                  ! BOOLEAN ARRAY TRUTH  .--!---!----->! FALSE !
                  ! TEXT   S             .--!---!---   ! FALSE !
                  ! REAL   NUM      3.5     !   !  !   ! TRUE  !
                  !     .....               !   !  !   ! FALSE !
               -->! CALL_BY_VALUE           !   !  !   ---------
               !  !                         !   !  !
               !  ---------------------------   !  !   ---------
               !                                !  --->! "+++" !
               !  ---------------------------   !      ---------
               !  !            !            !   !
               ---!----.       !     .------!----      ---------
                  !            !            !    ----->! "+++" !
                  !-------------------------!    !     ---------
                  !                         !    !
                  ! REAL      X       4.0   !    !     ---------
                  ! REAL      Y       3.5   !    !  -->! "O.K."!
                  ! TEXT      T1       .----!-----  !  ---------
                  ! TEXT      T2       .----!--------
       current    ! BOOLEAN ARRAY B    .----!---       ---------
               -->!         .....           !  !       ! FALSE !
       statement  !                         !  ------->! FALSE !
                  ---------------------------          ! TRUE  !
                                                       ! FALSE !
                                                       ---------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 107
CHAPTER 2.5.4


Call by reference
-----------------

A formal-parameter called by reference designates a local copy of  the
reference  obtained  by evaluating the corresponding actual-parameter.
The evaluation takes place at the  time  of  the  procedure  entry  or
object  generation.   Throughout  the  lifespan  of  the PROCEDURE- or
CLASS-body, the formal-parameter acts like a local quantity.

If the formal-parameter is a reference-type variable, its contents may
be  changed  by  assignments  within the body (or externally by remote
accessing in the case of objects).

An ARRAY, PROCEDURE, LABEL or SWITCH  parameter  called  by  reference
remains fixed and references the same entity throughout its scope.  Of
course, the contents of an ARRAY  called  by  reference  may  well  be
changed through assignments to its components.

For an object-reference type  parameter  (which  may  be  a  variable,
PROCEDURE   or   an   ARRAY),   the   qualification  of  the  matching
actual-parameter may coincide with, or be inner to, the  qualification
of the formal-parameter.

SIMSET BEGIN  INTEGER PROCEDURE NULLREF(L,N);  REF(LINK) ARRAY L;
                                              INTEGER N;
              BEGIN  INTEGER J, COUNT;
                     FOR J := 1 STEP 1 UNTIL N DO
                         IF L[J] == NONE THEN COUNT := COUNT + 1;
                     NULLREF := COUNT;
              END;
              INTEGER C;
              REF(LINK) ARRAY Q[1:50];
              ......
              C := NULLREF(Q,50);
              ......
     END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 108
CHAPTER 2.5.4


On the procedure call, a snapshot is


           -----------------------
           !          !          !<-----
           -----------------------     !
           ! SIMSET              !     !
           -----------------------     !
           ! PROCEDURE NULLREF   !     !
           ! INTEGER  C          !     !     --------
           ! REF(LINK) ARRAY Q .-!-----!---->!   .--!---->
           !    ..........       !     !  -->--------
      ---->! C := NULLREF(1,50)  !     !  !  !   .--!---->
      !    !    ..........       !     !  !  --------
      !    -----------------------     !  !  ! NONE !
      !                                !  !  --------
      !                                !  !  ! NONE !
      !    -----------------------     !  !  --------
      -----!----.     !     .----!------  !  !      !
           -----------------------        !  !------!
           ! INTEGER NULLREF 0   !        !  !      !
           ! INTEGER N      50   !        !  --------
           ! REF(LINK) ARRAY L .-!---------  !  .---!---->
           !                     !           --------
current    !     ..........      !
       --->!                     !
statement  -----------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 109
CHAPTER 2.5.4


Call by name 
------------

Call by name is an optional transmission mode available for parameters
to   procedures,   but  not  to  classes.   It  represents  a  textual
replacement in that the formal-parameter may  be  considered  replaced
throughout the PROCEDURE-body by the corresponding actual-parameter.

Whereas call by value and call by reference operate on variables local
to  the  PROCEDURE-body  itself,  call  by  name operates on non-local
quantities  and  can  alter  global  quantities.   It   is   therefore
especially  useful  for the controlled alteration of several variables
external to the PROCEDURE-body.

The following rules apply:

1)  The  type  of  a  name  parameter  is  that  prescribed   by   the
    corresponding formal specification.

2)  If the type of the actual-parameter does not coincide with that of
    the  formal specification, then an evaluation of the expression is
    followed by an assignment of the value or reference obtained to  a
    fictitious  variable  of  the  latter  type.   This  assignment is
    subject to the rules of section 2.7.2.   The  value  or  reference
    obtained  by  the  evaluation  is  the  contents of the fictitious
    variable.

Section 2.7.2 defines the meaning of an assignment to a variable which
is  a  formal-parameter  called  by name, or is a subscripted variable
whose array identifier is a formal-parameter called by  name,  if  the
type of the actual parameter does not coincide with that of the formal
specification.

Assignment to a PROCEDURE-identifier which is a  formal  parameter  is
illegal, regardless of its transmission mode.

Notice that each dynamic occurrence of a  formal-parameter  called  by
name,   regardless  of  its  kind,  may  invoke  the  execution  of  a
non-trivial  expression,  e.g.    if   its   actual-parameter   is   a
remote-identifier.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 110
CHAPTER 2.5.4


Example:

     BEGIN  PROCEDURE SWAP(A,B);  NAME A, B;  REAL A, B;

            BEGIN  REAL X;
                   X := A;
                   A := B; B := X;
            END ***SWAP***;
            REAL P, Q;
            P := 4.0; Q := 5.7;
            SWAP(P,Q);
            ..........
     END


A snapshot at the procedure call is:


              -------------------
              !        !        !<----
              -------------------    !
              ! PROCEDURE SWAP  !    !
              ! REAL   P   4.0  !    !
              ! REAL   Q   5.7  !    !
              !   ..........    !    !
          --->! SWAP    (P,Q)   !    !
          !   -------------------    !
          !              ^ ^         !
          !              ! !         !
          !              ! !         !
          !   -----------!-!-----    !
          ----!---.    ! ! ! .--!-----
              -----------!-!-----
              !          ! !    !
              ! REAL  A  . !    !
              ! REAL  B    .    !
              ! REAL  X    0.0  !
              !                 !        Program Sequence Control
      PSC --->!    ..........   !        (PSC) references the current
              -------------------        statement


No local copies  are  made.   Every  occurrence  of  A  or  B  in  the
PROCEDURE-body  means a re-evaluation of the actual-parameter.  Notice
that the  actual-parameters  are  evaluated  in  the  context  of  the
procedure call.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 111
CHAPTER 2.5.5


2.5.5  CLASS DECLARATIONS

CLASS  declarations  define  concepts.   CLASS  instances  are  called
objects  and many objects of a given class may exist simultaneously to
be  examined  and   manipulated   by   the   program.    Objects   are
generalizations of blocks and procedures, as the environment of either
a block instance or a procedure instance can only observe  the  result
of its actions.


CLASS-declaration

          [CLASS-identifier]main-part


main-part


                        **                **
                        *         ;        *
CLASS CLASS-identifier **                  **
                        *  parameter-part  *
                        **                **

               [protection-part] [virtual-part] CLASS-body


parameter-part

(identifier-list);  [VALUE identifier-list;]...  CLASS-spec-part


CLASS-spec-part


      **                                                     **
      *   **                       **                         *
      *   * [LONG]REAL              *                         *
      *   * [SHORT]INTEGER          *                         *
      *   * CHARACTER               *                         *
     **  ** BOOLEAN                 **  identifier-list;  ... **
      *   * REF(CLASS-identifier)   *                         *
      *   * TEXT                    *                         *
      *   * [type]ARRAY             *                         *
      *   **                       **                         *
      **                                                     **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 112
CHAPTER 2.5.5


protection-part


      **                                 **
      *         **                  **    *
      *         *  HIDDEN            *    *
      *         *  PROTECTED         *    *
     **  [NOT] **  HIDDEN PROTECTED  **   **  ...
      *         *  PROTECTED HIDDEN  *    *
      *         **                  **    *
      **                                 **


virtual-part


               **                                               **
               *    **                **                         *
               *    *  PROCEDURE       *                         *
               *    *  type PROCEDURE  *                         *
     virtual: **   **  label           ** identifier-list;  ...  **
               *    *  SWITCH          *                         *
               *    **                **                         *
               **                                               **



CLASS-body


      **           **
      * statement   *
     **             **
      * split-body  *
      **           **


split-body

BEGIN [declaration;] ...  [statement;] ...  INNER
                           [;  statement] ...  END



The available transmission modes for legal parameters to  classes  are
shown in the following table:
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 113
CHAPTER 2.5.5


                           CLASS PARAMETERS

Parameter                    Transmission

                    call by value    call by reference
                    ---------------------------------

value-type                D                  X
reference-type            X                  D
TEXT                      O                  D
value-type ARRAY          O                  D
reference-type ARRAY      X                  D

D : default mode
O : optional
X : illegal


The transmission modes "call by value" and  "call  by  reference"  are
explained in section 2.5.4.

The bounds  of  an  array  declared  after  the  initial  BEGIN  of  a
CLASS-declaration  may be taken or computed from the parameters of the
CLASS.

The  discussion  of  CLASS-declarations  begins  by  considering   two
selected examples of increasing scope.


Example 1:  Empty prefix and virtual part

The declaration of a class A can have the form:


     CLASS A(fpA); spA;          ------------
                                 !  fpA     !
     BEGIN  dA;                  ------------
                                 !   dA     !
            actionsA;            ------------
                                 ! actionsA !
     END                         ------------


     CLASS A declaration       A object


A:          CLASS-identifier
fpA:        List of the format parameters of A
spA:        List of specifications of each of the formal
            parameters of A.
dA:         Declarations of the CLASS-body of A.
actionsA:   actions of the CLASS-body of A
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 114
CHAPTER 2.5.5


The CLASS-body of A is a block (one form of statement).

The quantities passed as parameters or declared in the outermost block
of  the  class  body  are  called  the  attributes  of class A and are
attributes of every object of  the  class.   Attributes  specified  as
formal-parameters  may  only  be simple variables or arrays.  Declared
attributes  may  be  simple  variables,   arrays,   proper-procedures,
function-procedures and classes.

The expression

     NEW A(...)

creates an object of  the  class  A  (the  order  and  number  of  the
actual-parameters  must  correspond  with  the order and number of the
formal-parameters)  and  commences  execution  of  its  actions.   The
execution  continues  until  the  final  END  of  the  class  body  is
encountered, when the execution is terminated.  However  this  may  be
interrupted in four ways - by a GOTO-statement (which leads out of the
object), or by calls on the system procedures  "detach",  "resume"  or
"call".   A  GOTO  exit will leave the object in the terminated state.
"Detach" suspends the actions of  the  class  body  and  names  it  an
independent  component  of  the program.  Its actions may be continued
later by a call on "resume".

An object is "attached" either under generation as a result of NEW  or
when it is "call"-ed.

In many cases, it may be better to use CALL or RESUME on class objects
instead  of  using  ordinary procedure calls.  CALL or RESUME on CLASS
objects have the following advantages compared to procedure calls:

- No memory is allocated, which means that CALL or  RESUME  uses  much
  less CPU time than a procedure call.

- Data can be kept within the class object between CALLs or RESUMEs.

On the other  hand,  procedure  calls  can  have  parameters,  but  no
parameters  can  be  transferred  to the class when you make a CALL or
RESUME on a class object.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 115
CHAPTER 2.5.5


Initialization of CLASS attributes.

There are three ways to initialize CLASS attributes in SIMULA:

1) Attributes which are parameters to the CLASS are initialized by the
actual parameters in the NEW command.

2) Attributes can be initialized by executable statements  before  the
first  "detach" in the CLASS.  This can for example be used to include
each new CLASS object into a set immediately at creation, or  to  give
each new CLASS object a unique number.

3) If none of the above is done, the  attribute  is  given  a  default
initial value, see chapter 2.5.1.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 116
CHAPTER 2.5.5


Example 2:  Non-empty prefix and empty virtual part

A CLASS-declaration may contain a prefix which is  the  identifier  of
another  class  declared either in the same block, or in the prefix to
the same block.  The prefixed class is a subclass of the prefix.

e.g.,


                                   ------------
                                   !   FPA    !
     A CLASS B(fpB); spB;          ------------
                                   !   DA     !
       BEGIN dB;                   ------------
                                   ! actionsA !
             actionsB;             ------------
                                   !   fpB    !
       END                         ------------
                                   !   DB     !
                                   ------------
                                   ! actionsB !
                                   ------------

     CLASS B declaration       B object


A B-object is a compound object  which  has  all  the  attributes  and
actions  of  the prefix A and the main-part of class B.  A B-object is
generated by

     NEW    B(apA, apB)

with a list of actual-parameters corresponding in number and order  to
those  of an A-object and those of the main-part of B.  On generation,
the actions of the A-part are executed first and  then  those  of  the
B-part.   The actions of the A-part have access to the attributes of A
only, the actions of the B-part to those of B and of A.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 117
CHAPTER 2.5.5


CLASS HIERARCHIES
-----------------

In general, a hierarchy of classes may be introduced.
e.g.

                    declarations

                    CLASS C1......;
                 C1 CLASS C2......;
                 C1 CLASS C3......;
                 C2 CLASS C4......;
                 C2 CLASS C5......;


    hierarchy                         objects
    ---------                         -------
                    
                   
                        C1       C2       C3       C4       C5
      ----C1----      ------   ------   ------   ------   ------
      !        !      ! C1 !   ! C1 !   ! C1 !   ! C1 !   ! C1 !
 ----C2----    C3     ------   ------   ------   ------   ------
 !        !                    ! C2 !   ! C3 !   ! C2 !   ! C2 !
C4        C5                   ------   ------   ------   ------
                                                 ! C4 !   ! C5 !
                                                 ------   ------


The prefix sequence of a class is  the  sequence  of  classes  in  its
prefix chain

e.g.  in the above figure, the prefix sequence of

          C1 is empty
          C2 is C1
          C5 is C1 C2
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 118
CHAPTER 2.5.5


If the prefix sequence of a class CN is C1, C2,....., CN-1, then a  CN
object may be depicted by:


                           ---------  **
                           !  C1   !   *
                           ---------   *
                           !  C2   !   **   classes outer to CK
                           ---------   *
                           ! ..... !   *
                       **  ---------  **
                       *   !  CK   !     class equal to CK
     subclasses of CK  *   ---------  **
     or classes       **   ! ..... !   *
     included in CK    *   ---------   **    classes inner to CK
                       *   !  CN   !   *
                       **  ---------  **


An object of a prefixed class is a compound object which is the  union
of  the  formal-parameters, declarations and actions of the classes in
its prefix sequence together with the structure  defined  in  its  own
main-part.

The mechanism  of  concatenation  may  be  extended  to  the  case  of
prefixed-blocks, e.g.

     SIMULATION  BEGIN
                        ...
                 END

The execution of a prefixed block begins by executing the  actions  of
the  initial operations of the class and then those of the block body.
The attributes of the class are accessible inside the block  body  and
this block is thus given a built-in environment in which to operate.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 119
CHAPTER 2.5.5


INNER
-----

The order of the execution of actions in an object may be altered from
their textual order by use of INNER.

Consider

     CLASS A ...;
     BEGIN ....;  S1;  INNER;  S2 END;

   A CLASS B ...;
     BEGIN .....;  S3 END

In an A object INNER acts  as  a  dummy  statement,  and  the  actions
executed are

     S1;  S2

In a B object, INNER forces execution of S3 before those of S2, thus

     S1;  S3;  S2


VIRTUAL QUANTITIES (6)
------------------

The  virtual  mechanism  is  a  method  of  extending  the  rules   of
accessibility, whilst still retaining security.  The virtual mechanism
is useful in two circumstances.

1)  to redefine attributes
2)  to give accessibility to attributes declared at inner levels

1)  attribute redefinition
    ----------------------

    Usually when a class hierarchy is constructed, an attribute has  a
    fixed  meaning  no  matter how many prefix levels are added to the
    class containing its declaration.

    Sometimes,  however,  we  may  wish  to  redefine  the   attribute
    throughout its scope.





---------------------------------------------------------------------
(6)  This section may be bypassed by readers starting to learn SIMULA.
Though  it  concerns  a  very useful mechanism, it is not necessary to
learn initially.  Most SIMULA programs do not use virtual quantities.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 120
CHAPTER 2.5.5


Example:  Consider the description of a  CLASS  ROW  for  manipulating
              vectors.

    CLASS ROW(A,N); REAL ARRAY A; INTEGER N;
    BEGIN  REAL PROCEDURE NORM;
           BEGIN  REAL T; INTEGER I;
                  FOR I := 1 STEP 1 UNTIL N DO
                      T := T + A[I]*A[I];
                      NORM := SQRT(T);
           END ***NORM***;
           PROCEDURE NORMALISE;
           BEGIN  REAL T; INTEGER I;
                  T := NORM;
                  IF T  NE 0 THEN
                     BEGIN  T := 1/T;
                            FOR I := 1 STEP 1 UNTIL N DO
                                A[I] := A[I]*T;
                     END;
           END ***NORMALISE***;
           IF N < 1 THEN ERROR;
    END ***ROW***

Note:  Procedure attributes to classes can be used to get  a  function
equivalent  to  several  entry points into subroutines as available in
other programming languages.


    A new ROW object has four attributes:

    1)  a REAL ARRAY A running from 1 through N
    2)  a specified upper bound N
    3)  a REAL PROCEDURE NORM which computes the square  root  of  the
        sum  of  the  square  of  its  components.   (NORM  gives  the
        "magnitude" of the ARRAY A).
    4)  a PROCEDURE NORMALISE which divides through each array element
        by the current value of NORM.

    If the user wishes to use a different NORM then the class  has  to
    be rewritten.

    However by altering the class outline to

         CLASS ROW(A,N);  REAL ARRAY A;  INTEGER N;
                         VIRTUAL :  REAL PROCEDURE NORM;
         BEGIN  REAL PROCEDURE NORM...;
                PROCEDURE NORMALISE...;
                IF N < 1 THEN ERROR;
         END ***ROW***

    it becomes possible to alter the definition of NORM in a  subclass
    of  ROW,  and  yet have the new meaning available at the ROW level
    where it is needed in any call on NORMALISE e.g.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 121
CHAPTER 2.5.5


         ROW CLASS ROW1;
             BEGIN  REAL PROCEDURE NORM;
                    BEGIN  REAL S,T; INTEGER I;
                             FOR J := 1 STEP 1 UNTIL N DO
                               BEGIN  T := ABS(A(I));
                                      IF T > S THEN S := T;
                               END;
                               NORM := S;
                    END ***NORM*** ;
             END ***ROW1***


           ROW OBJECT                      ROW1 OBJECT

    -----------------------          -----------------------
    ! REAL ARRAY A        !          ! REAL ARRAY A        !
    ! INTEGER N           !          ! INTEGER N           !
    ! VIRTUAL : NORM .----!---       ! VIRTUAL : NORM .----!---
    ! REAL PROCEDURE NORM !<-!       ! PROCEDURE NORMALISE !  !
    ! PROCEDURE NORMALISE !          -----------------------  !
    -----------------------          ! REAL PROCEDURE NORM !<--
                                     -----------------------


    IN A ROW1 object, the NORM attribute declared at the ROW level  is
    deleted and is never available.  Though the VIRTUAL mechanism, the
    only valid NORM attribute is that declared at the ROW1 level.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 122
CHAPTER 2.5.5


2)  Inner accessibility

    This is illustrated by an example.

    In processing a linked structure which contains objects of various
    classes,  (say  A,  B) the links are provided by their common part
    CLASS NODE.

         CLASS NODE;BEGIN REF(NODE)NEXT;  END;
         NODE CLASS A;  BEGIN PROCEDURE DUMP ....;  END;
         NODE CLASS B;  BEGIN PROCEDURE DUMP ....;  END;

    If the structure is linked by following REF(NODE) NEXT references,
    then, in the normal way, the information in the structure would be
    dumped by

         X :- FIRST;
         WHILE X =/= NONE DO
         BEGIN IF X IS A THEN X QUA A.DUMP
                          ELSE X QUA B.DUMP;
                X :- X.NEXT;
         END;

    which is tedious to write.  By writing the classes by

         CLASS NODE;  VIRTUAL :  PROCEDURE DUMP;
         BEGIN REF(NODE) NEXT;
                ...
         END ***NODE*** ;
         NODE CLASS A;
              BEGIN PROCEDURE DUMP ...;
              END;
         NODE CLASS B;
              BEGIN PROCEDURE DUMP ...;
         END;

    we can write instead

         X :- FIRST;
         WHILE X =/= NONE DO
         BEGIN X.DUMP;
                X :- X.NEXT;
         END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 123
CHAPTER 2.5.5


    A virtual quantity is either unmatched or  else  matched  with  an
    attribute  (with  the  same identifier) declared at the same or an
    inner prefix level.  The matching attribute must be  of  the  same
    type  as that specified in the virtual part, except in the case of
    object-reference-function-procedures.   The  type  REF(C)  may  be
    matched with the type REF(C) or type REF(D), where D is a subclass
    of C.  A VIRTUAL proper-PROCEDURE may be matched with any type  of
    procedure.  In both these cases, the type of the match is the type
    of the matching declaration.

    A virtual quantity of a given object can have at most one matching
    attribute.   If  matching  declarations are given at more than one
    prefix level, then the one at the innermost prefix level is taken.
    The  match  is  valid  at all prefix levels of the object equal or
    inner to that of the specification.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 124
CHAPTER 2.5.6


2.5.6  EXTERNAL DECLARATIONS


external-identifier
-------------------
                    
           **                                                           **
           *               **                                        **  *
identifier *  = identifier *  [  project number, programmer number ]  *  *
           *               **                                        **  *
           **                                                           **


external-declaration
--------------------
                                
          **                      **              **              **
          *  **      **            *              *                *
          *  *  type  * PROCEDURE  *              *                *
          *  **      **            *  external-   * external-      *
EXTERNAL **                        **             * ,              * ...
          *           CLASS        *  identifier  * identifier     *
          *                        *              *                *
          **                      **              **              **


The EXTERNAL declaration is used when a separately compiled  procedure
or CLASS written in SIMULA, MACRO 10 or FORTRAN is to be used.  In the
main program, the EXTERNAL declaration is put at the place  where  the
separately  compiled  segment  would  have been put if it had not been
separately compiled.  In a separately compiled procedure or class, the
EXTERNAL declaration is put in front of the source code.

The external identifier gives the file name of the disk file on  which
the  separately  compiled  segment  is  stored.  For FORTRAN and MACRO
procedures, the external identifier gives the filename  of  the  dummy
SIMULA  body for the procedure, often but not necessarily identical to
the filename of the FORTRAN or MACRO procedure itself.

More information about separate compilation is given  in  DECsystem-10
SIMULA  Language  Handbook Part I chapter 4 and in DECsystem-10 SIMULA
Language Handbook part II.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 125
CHAPTER 2.5.7


2.5.7  HIDDEN PROTECTED SPECIFICATIONS

[The HIDDEN PROTECTED specification is not available in release 1  and
2 of DECsystem-10 SIMULA, but available from release 3.]

The HIDDEN PROTECTED feature is a feature to increase the  reliability
and  security  of large software packages by dividing the package into
smaller  submodules  and  controlling  the   interface   between   the
submodules.

Many programming errors occur because a programmer, when writing  code
in  one  submodule,  is  not aware of the effect of that code on other
submodules.  If the interface between the modules is  controlled,  the
compiler  and  program  can  automatically  guard  against  many  such
programming errors.

This is especially important when several programmers are  working  on
the  same  project,  or when one programmer is writing a program using
one or several packages developed previously by someone else.

The natural submodule in SIMULA is a CLASS.  This CLASS  is  sometimes
separately  compiled  (See  Chapter  4).   However,  programs  using a
separately compiled CLASS do  not  ordinarily  use  directly  all  the
attributes  of  the  separately  compiled  CLASS.  Some attributes are
internal to the CLASS and only used by code inside the  CLASS.   Other
attributes  are "ports of entry" to the CLASS.  Often, these "ports of
entry" are PROCEDURE attributes to the  CLASS,  since  PROCEDUREs  can
include  code  to check the correctness of the input parameters before
performing the requested actions.

The simplest use of the HIDDEN PROTECTED specification is  to  declare
as  HIDDEN  PROTECTED  those attributes which are not to be accessible
outside the body of the CLASS.  Suppose for example  that  we  have  a
CLASS  "data base"  where  the  user of the CLASS need only access the
features of the CLASS  through  the  attribute  PROCEDUREs  "put"  and
"get".   All  other  attributes  of the CLASS are then declared HIDDEN
PROTECTED as in the following simplified excerpt:

    CLASS data_base;
    HIDDEN PROTECTED diskdata, has_been_read, filesize,
    filepos, internal;
    BEGIN
        REF (directfile) diskdata;
        BOOLEAN has_been_read;
        INTEGER filesize, filepos;
        PROCEDURE internal; COMMENT this PROCEDURE is only
        used internally inside the class data_base;;
        PROCEDURE PUT; COMMENT port accessible from
        outside the CLASS ...;;
        PROCEDURE GET; COMMENT port accessible from
        outside the CLASS ...;;
        COMMENT etc. ;
    END of data_base;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 126
CHAPTER 2.5.7


If most of the attributes of a CLASS are to be HIDDEN  PROTECTED,  and
only a few attributes are to be non-protected ports, then it is easier
to list the non-protected attributes.  This can be done using the  NOT
HIDDEN  PROTECTED specification.  The CLASS in the example above could
then instead begin:

    CLASS database;
    NOT HIDDEN PROTECTED put, get;
    BEGIN ...

The NOT HIDDEN PROTECTED specification indicates that  all  attributes
which  can be specified HIDDEN PROTECTED at that place in the program,
and which are not listed in the specification,  are  specified  to  be
HIDDEN PROTECTED.

The syntax of the HIDDEN PROTECTED specification is defined in section
2.5.5 above.


2.5.7.1  SEMANTICS OF THE HIDDEN PROTECTED SPECIFICATION

Attributes declared PROTECTED are only visible inside the body of  the
class where they have been specified PROTECTED, and inside the body of
subclasses to this class and inside the body of blocks  prefixed  with
this class or a subclass to it.

Note that inside this body, the attributes are  visible  not  only  by
direct  access  but  also  by  remote  access (dot notation or INSPECT
statements) to other objects of the  same  CLASS.   [NOTE!   Accessing
local  PROTECTED  attributes  remotely  has  not yet been confirmed by
SIMULA DEVELOPMENT GROUP.]

If an identifier in the source  program,  outside  this  scope,  would
without  PROTECTED  refer  to  the PROTECTED variable, that identifier
will instead act as if the PROTECTED variable cannot be seen, it  will
thus  either  refer to a statically enclosing identifier with the same
name, or it will give  the  compile  time  error  message  "UNDECLARED
IDENTIFIER".

Attributes declared HIDDEN are invisible in subclasses  to  the  class
where the HIDDEN specification occurs and in blocks prefixed with this
class or subclasses to it.

The  combined  specification  HIDDEN  PROTECTED  will  thus  make  the
variables  invisible  everywhere  except in the body of the class with
the HIDDEN PROTECTED specification.

A VIRTUAL attribute may only be specified PROTECTED in the same  CLASS
heading  where  the  VIRTUAL  specification  is  placed.  If a VIRTUAL
attribute is declared HIDDEN, the effect is that procedures  with  the
same name in subclasses will not take part in the virtual match.  They
will instead act as ordinary (non-virtual) procedures.

Attributes of a class may only be specified PROTECTED in  the  heading
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 127
CHAPTER 2.5.7.1


of  the  class where the attribute is declared.  Attributes of a class
may, however, be declared HIDDEN in a subclass to it.  Such  a  HIDDEN
specification will only be valid for subclasses to the class where the
HIDDEN specification is placed.

An attribute may not be specified HIDDEN except when it  is  specified
PROTECTED in the same class or in a superclass.

If a HIDDEN specification contains an identifier which  is  ambiguous,
because  the  same  identifier  has been used for different attributes
within the prefix chain,  then  the  HIDDEN  specification  will  take
effect  for  all  these  attributes  with the same name.  [NOTE!  This
mechanism  may  be  changed  in  the  future,  depending   on   SIMULA
DEVELOPMENT  GROUP decisions.  The definition might be changed so that
each HIDDEN just nullifies one PROTECTED level at a time.]

All HIDDEN specifications at the start of a certain CLASS must  either
be  of the NOT kind or of the positive kind.  Mixed specifications are
illegal.  The same is true for the PROTECTED specifications.  However,
HIDDEN and PROTECTED may be of different kind.


2.5.7.2  EXAMPLES OF USE OF THE HIDDEN PROTECTED SPECIFICATION

Example i: WRITE-PROTECTED ATTRIBUTES

The attributes "length", "width" and "height" of the  following  CLASS
can  be  given  values  when  a new CLASS object is generated, but can
never be changed in an existing CLASS object.

The attribute "density" can only  be  changed  through  the  procedure
"setdensity" which checks that the new value is within a legal range.

The attribute values can all be used outside the CLASS body,  but  not
redefined, since the externally accessible ports are all PROCEDUREs.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 128
CHAPTER 2.5.7.2


    CLASS box (internal_length, internal_width,
        internal_height, internal density);
    REAL internal_length, internal_width,
        internal_height, internal density;
    NOT HIDDEN PROTECTED length, width, height, density, set_density;
    BEGIN
        REAL PROCEDURE length; length:= internal_length;
        REAL PROCEDURE width; width:= internal_width;
        REAL PROCEDURE height; height:= internal_height;
        REAL PROCEDURE density; density:= internal_density;
        PROCEDURE set_density(new_density);
        IF new_density < 0 OR new_density > 10 THEN abort
        ELSE internal_density:= new_density;

        set_density(internal_density); COMMENT to check initial value;
        ...
    END;


Example ii:  SIMSET AS IN SIMULA COMMON BASE

CLASS simset;
BEGIN
    CLASS linkage;
    PROTECTED i_suc, i_pred;
    BEGIN
        REF (linkage) i_suc, i_pred;
    END;
    linkage CLASS link;
    HIDDEN i_suc, i_pred;
    BEGIN
        PROCEDURE out;
        BEGIN
            IF i_suc =/= NONE THEN
            BEGIN ....
            END;
        END;
    END;
END;

As is seen above, the internal, HIDDEN attributes i_suc and i_pred are
invisible  outside  LINKAGE,  except  within  the subclasses LINK (and
HEAD, analoguous  to  LINK)  since  they  are  declared  PROTECTED  in
LINKAGE, but declared HIDDEN in LINK (and HEAD).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 129
CHAPTER 2.5.7.2


Example iii:  INVISIBLE, NOT FORBIDDEN

This example shows that PROTECTED attributes are invisible rather than
forbidden:

BEGIN
    INTEGER b;

    CLASS a; HIDDEN PROTECTED b;
    BEGIN INTEGER b;
    END;

    a CLASS asub;
    BEGIN
        b:= 3; COMMENT legal, but refers to the b outside a;
    END;

    INSPECT NEW a DO
    BEGIN
        b:= 1; COMMENT legal, but refers to the b outside a;
    END;

    a BEGIN
        b:= 2; COMMENT legal, but refers to the b outside a;
    END;
END;


Example iv:  LABELS CAN ALSO BE HIDDEN

BEGIN
    CLASS a;
    HIDDEN PROTECTED la;
    BEGIN
        INNER;
        la: lb:
    END;

    a CLASS b;
    BEGIN
        GOTO la; COMMENT illegal;
        GOTO lb; COMMENT legal;
    END;
END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 130
CHAPTER 2.5.7.2


Example v:  PROTECTING THE NAME OF A CLASS.

BEGIN
    CLASS a;
    HIDDEN PROTECTED b;
    BEGIN
        REF (b) bl;
        CLASS b;
        BEGIN INTEGER i; END;
       bl:- NEW b;
    END of a;
    INSPECT NEW a DO outint(bl.i); COMMENT legal;
END;

Class a has a local class B  which  is  HIDDEN  and  PROTECTED.   This
protects  against  all  statements  where  the name of the local class
appears.  Thus, the following is impossible outside the body of a:

> Creation of new objects of the class b using the NEW statement.

> Declaration of references to b.

> Use of the WHEN clause in the INSPECT statement.

Nevertheless, it is possible to access the attributes of the  instance
of  the  class b referred to by the reference variable b1 in the class
a, since b1 is not HIDDEN PROTECTED.


Example vi:  PROTECTING THE "NEW" COMMAND OF SIMULA.

BEGIN
    CLASS c; HIDDEN PROTECTED b;
    BEGIN BOOLEAN b;
        CLASS d;
        BEGIN IF b THEN abort; END;
        COMMENT here, "NEW d" will not cause any error!!;
        b:= TRUE;
    END;
    INSPECT NEW c DO NEW d; COMMENT causes error!!!;
END;

If you want to protect just the "NEW" command and nothing  else,  this
construct  can  be used.  Note however that the construct in example v
causes compile time error, the construct in example vi causes run time
error.

Class c has a boolean attribute B which is used  to  indicate  if  the
statement  part is executed.  Such an attribute may be used to inhibit
instance generation of a local  class  through  a  programmed  runtime
check  like that on line 6.  The "NEW d" phrase on line 12 will result
in a call on the "abort" procedure.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 131
CHAPTER 2.6


2.6  EXPRESSIONS
     -----------

Expressions are rules for computing values.  Expressions may occur  on
the  right  hand sides of assignment statements, as actual parameters,
in FOR-statements, as array indices, etc.


expression


      **                          **
      *  arithmetic-expression     *
      *  condition                 *
      *  CHARACTER-expression      *
     **  designational-expression  **
      *  object-expression         *
      *  TEXT-expression           *
      *  TEXT-value                *
      **                          **


IF-clause

     IF condition THEN

The constituents of  expressions  are  operators  and  operands.   The
operands  are  constants,  variables  or function designators.  No two
operands may occur side by side - they must be separated by  at  least
one  operator.   A  discussion  of  variables and function designators
precedes the discussion of expressions.


value-expression


      **                       **
      *  arithmetic-expression  *
     **  condition              **
      *  CHARACTER-expression   *
      **                       **


reference-expression


      **                   **
      *  object-expression  *
     **                     **
      *  TEXT-expression    *
      **                   **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 132
CHAPTER 2.6.1


2.6.1  VARIABLES

The value of a variable may be used in expressions for forming  values
and  may  be  changed by assignments to that variable.  The value of a
variable is the value of the last assignment to  it,  or  its  initial
value if no assignment has yet been made.

variable


      **                      **
      *  simple-variable       *
     **  subscripted-variable  **
      *  remote-variable       *
      **                      **

simple-variable

     identifier


simple-variable


      **                 **
      *  identifier       *
     **                   **  (subscript-list)
      *  remote-variable  *
      **                 **

subscript-list

          arithmetic-expression [, arithmetic-expression]...


remote-variable


      **                            **
      *  simple-text-expression .    *
     **                              **  identifier
      *  simple-object-expression .  *
      **                            **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 133
CHAPTER 2.6.1


Examples:

simple-variable:              EPS
                              A15
                              A16_C

subscripted-variable:         SON[2]
                              ELEMENT[I,J]
                              THIS SQUARE.LONG_SIDE[2]

remote-variable:              ANNA.FATHER
                              APOSTLE(6).LEADER
                              C.P.X
                              LINE(2).SIDE(3)

A variable is a designation for a single value.


simple-variable

The type of the value of a particular simple variable is given in  the
declaration for that variable.


remote-variable

An attribute of an object is identified by the following information:

1)  a reference to the object
2)  a class which includes that of the object
3)  an attribute  identifier  defined  in  that  class  or  any  class
    belonging to its prefix sequence.

Let X be a simple object expression qualified by class  C,  and  A  an
attribute identifier.

Then X.A is valid if X =/= NONE and class C has at least one attribute
identified  by  A.   If  there is only one attribute with identifier A
contained in class C or in its prefix chain, then it is designated  by
X.A.   If  class C contains more than one attribute with identifier A,
then X.A designates the attribute with identifier A at  the  innermost
prefix level.

N.B.  The main part of any class declaration can contain at  most  one
attribute with that identifier.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 134
CHAPTER 2.6.1


Example:

     REF(C1) X1;  REF(C2) X2;  REF(C3) X3;  REF(C4) X4;

     CLASS C1(A);  REAL A;
     BEGIN ....................  END;

  C1 CLASS C2;
     BEGIN TEXT A;  ...  END;

  C2 CLASS C3;
     BEGIN ....................  END;

  C3 CLASS C4;
     BEGIN BOOLEAN A;  ........  END;

  X1 :- X2 :- X3 :- X4 :- NEW C4(6.0);


  remote-variable                  type
  ---------------       ----

X1.A, X2 QUA C1.A,
X3 QUA C1.A, X4 QUA C1.A           REAL

X1 QUA C2.A, X2.A,
X3 QUA C2.A, X4 QUA C2.A           TEXT

X1 QUA C3.A, X2 QUA C3.A,
X3.A, X4 QUA C3.A                  TEXT

X1 QUA C4.A, X2 QUA C4.A,
X3 QUA C4.A, X4.A                  BOOLEAN

It is not possible  to  access  either  label  or  switch  identifiers
remotely.

If class C or a class in its prefix chain contains a class  attribute,
then  accessing of any attribute in class C is only possible through a
connection statement.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 135
CHAPTER 2.6.1


Example:

     CLASS C1;  BEGIN REAL D;  END;
  C1 CLASS C2;
     BEGIN CLASS F.....;
            BOOLEAN Q;
     END;
     REF(C2)X;

Then X.F, X.Q, X.D
are all illegal attempts at remote accessing.

But it is legal to write

     INSPECT X DO
     BEGIN ...F...
            ...Q...
            ...D...
     END

or, for the REAL attribute of C1, X QUA C1.D.

A simple-text-expression is itself a compound structure in  the  sense
that   it   has   attributes  accessible  through  the  dot  notation.
TEXT-value  assignments  may  be  made  through   the   use   of   the
system-defined  procedure  SUB,  STRIP  and MAIN to sub-fields (T.SUB,
T.STRIP) and super-fields (T.MAIN) of the text object referenced by T.

e.g.  T.SUB(1,24) := "CHANGE IN FIRST 24 CHARS"
      T.MAIN.STRIP := NOTEXT


Subscripted variables

A  subscripted  variable  is  an  array  component.   The  type  of  a
subscripted  variable  is  the  type  of  the  array.  Each arithmetic
expression in the  subscript  list  is  called  a  subscript  and  the
complete list of subscripts is enclosed in parentheses (  ), or square
brackets [  ].  (Note:   Square  brackets  are  preferred  for  better
readability.)  Each  subscript  acts as a variable of type INTEGER and
the evaluation of the subscript is understood to be equivalent  to  an
assignment to this fictitious variable.

A run time error will occur when any of the subscripts is outside  the
declared  bounds  on  that  subscript  of the array.  This can, at the
programmers own risk, be removed with the compiler switch -A.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 136
CHAPTER 2.6.2


2.6.2  FUNCTION DESIGNATORS

A function designator denotes the value  obtained  by  evaluating  the
associated  procedure  body  when  supplied with the associated actual
parameter list (if any).


function-designator


      **                   **
      *  identifier         *
     **                     **    [actual-parameter-list]
      *  remote-identifier  *
      **                   **


actual-parameter-list

     (actual-parameter[, actual-parameter]...)


actual-parameter


      **                      **
      *  expression            *
      *  ARRAY-identifier      *
     **  SWITCH-identifier     **
      *  PROCEDURE-identifier  *
      *  LABEL-identifier      *
      **                      **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 137
CHAPTER 2.6.2


Examples:

     ININT
     INTEXT(20)
     SIN(A+B)
     H.FIRST
     CURRENT.NEXTEV.SUC
     POINT(5).MODULUS

Function-designators  denote  single  arithmetic,  BOOLEAN,  TEXT   or
CHARACTER  values  or  object-  or  TEXT-references.  These values are
obtained  by  applying  a  set  of  rules  defined  by  the  procedure
declaration  to a set of actual parameters.  The actual parameter list
must correspond in number and order to the formal  parameter  list  in
the corresponding procedure declaration.

Certain identifiers, expressed as procedures, are pre-defined  in  the
SIMULA  system.   A  list  is  given in Appendix B.  Calls to standard
procedures conform to the syntax of calls to declared  procedures  and
are  equivalent  to  normal  procedure  calls.   (Note,  however, that
standard procedures may not be passed as parameters.)  The  identifier
of  a system defined procedure is not reserved, and may be declared to
have another meaning at any level.  (This is not recommended  practice
as  it  will  obviously  make  the  program more difficult to read and
understand).  The identifier then assumes the new  meaning  throughout
the scope of the block in which it was declared.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 138
CHAPTER 2.6.3


2.6.3  ARITHMETIC EXPRESSIONS

An arithmetic expression is a rule for computing a number.


arithmetic-expression


      **                                        **
      *  simple-arithmetic-expression            *
     **  IF-clause simple-arithmetic-expression  **
      *            ELSE arithmetic-expression    *
      **                                        **


simple-arithmetic-expression

     [+!-] arithmetic-primary [arithmetic-operator arithmetic-
                                            primary] ...


arithmetic-primary


      **                                **
      *  arithmetic-constant             *
      *  arithmetic-variable             *
     **  arithmetic-funtion-designator   **
      *  (arithmetic-expression)         *
      **                                **


arithmetic-operator


     +   -   *   **   ^   /   //
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 139
CHAPTER 2.6.3


Examples:

arithmetic-primary

     15.7
     16R1FA
     X
     SIN(23*P1/180)
     (IF X>0 THEN X ELSE -X)

arithmetic-expression

     X**2 + Y**2
     X + A(J)**2
     EXP(2 + (IF B THEN 3 ELSE 4))
     IF X > 0 THEN 1 ELSE IF X < 0 THEN -1 ELSE 0
     -3*(-5)

Examples of incorrect arithmetic expressions:

(A + B) C)                     left parenthesis missing

-3*-5                          two operators together

(A + B) & - 0.5                & only allowed in constants

X + (IF Y < 0 THEN 2)          ELSE alternative is missing

X + IF Y < 0 THEN 2 ELSE 3     the IF expression must be
                                 enclosed in parentheses


The value of a simple-arithmetic-expression is the value  obtained  by
executing  the  arithmetic  operations on the actual numeric values of
the primaries of the  expression.   The  actual  numeric  value  of  a
primary is obvious in the case of numbers.

For variables, it is the current value (assigned last in  the  dynamic
sense);  and for function-designators it is the value arising from the
computing rules defining the function-procedure when  applied  to  the
current  values  of  the  procedure parameters in the expression.  For
arithmetic-expressions  enclosed  in  parenthesis,  the  value   must,
through  a  recursive analysis, be expressed in terms of the values of
primaries of the other three kinds.

In the more general arithmetic-expressions, which include IF- clauses,
a  simple-arithmetic-expression is selected on the basis of the actual
values of the BOOLEAN conditions.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 140
CHAPTER 2.6.3


If the form of the arithmetic expression is

     IF condition THEN simple-arithmetic-expression
                  ELSE arithmetic-expression

the selection of the appropriate value is made according to the rules:

1.  The condition in the IF-clause is evaluated.

2.  If the result of 1 is TRUE, then the value of  the  expression  is
    the  value  of  the  simple  arithmetic  expression  following the
    IF-clause.  Otherwise it is the value of the arithmetic expression
    following the ELSE.

    e.g.  IF X < 0 THEN 4 ELSE 17

          if X < 0 then the value is 4
          if X = 0 or X > 0 then the value is 17.


Arithmetic operators and types
------------------------------

Apart  from  the  CONDITIONS  of  IF-clauses,  the   constituents   of
arithmetic  expressions  are  of types SHORT INTEGER, INTEGER, REAL or
LONG REAL.

The following hierarchy may be associated with these types.

type number            type       shortened notation

     1        [SHORT]  INTEGER           I
     2                 REAL              R
     3                 LONG REAL         LR

The types are ranked according to their associated type number.   Thus
LONG REAL is higher than INTEGER, INTEGER is lower than REAL.

The meanings of the basic operators are:

     +     addition
     -     subtraction
     *     multiplication
^ or **    exponentiation
     /     division
     //    integer division
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 141
CHAPTER 2.6.3


The types of arithmetic expressions are given by the following rules:

1)  The operators + and - may be used as unary operators

         + operand
         - operand

    The type of the resulting expression is the type of the operand.

2)  The type of the arithmetic expression

         operand1 [+!-] operand2

    is the higher of the types of  operand1  and  operand2.   This  is
    displayed in the table:

    type of operand1    type of operand2

                         I    R    LR
                      ------------------
                      !
                   I  !  I    R    LR
                   R  !  R    R    LR
                  LR  ! LR   LR    LR

3)  / denotes division, and

         operand1 / operand2

    always results in an arithmetic expression of type  REAL  or  LONG
    REAL.   If  either  of  operand1 or operand2 are of type LONG REAL
    then so is the resulting expression, otherwise it is of type REAL.

    This is displayed in the table:

            type of operand1      type of operand2

                                    I    R    LR
                            ----------------------
                            !
                         I  !       R    R    LR
                         R  !       R    R    LR
                        LR  !      LR   LR    LR

    A run time error will always result if the value  of  operand2  is
    zero.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 142
CHAPTER 2.6.3


4)  // denotes integer division.  The operator is defined only between
    two operands of type INTEGER and gives the INTEGER result

         A // B = SIGN (A*B) * ENTIER (ABS(A/B))

    If, in

         operand1 // operand2

    the types of operand1 and operand2 are not both INTEGER, then they
    are  rounded  to  type  INTEGER and then the operation, as defined
    above, is carried out.

    Examples:

              10 // 5          =  2
               9 // 5          =  1
              -9 // 5          = -1
               9 //(-5)        = -1

5)  The operation

         operand1**operand2     or  operand1^operand2

    denotes exponentiation, where operand1 is the  base  and  operand2
    the exponent.

    e.g.     2**3          means    8 (=2*2*2)
             2**(3**4)     means    2 to the power
                                    (3 to the 4th power)
             2**3**4       means    2 cubed to the 4th power

    The type is REAL unless one of operand1 or  operand2  is  of  type
    LONG  REAL  when  it  is  LONG  REAL.   (This is a difference from
    Algol 60 where the type is INTEGER if both operands  are  positive
    INTEGERs.  However, if operand1 and operand2 are positive integers
    and the result is less than 134258569,  the  result  retains  full
    integer  precision.   In  the case where both operands are integer
    constants and operand2 is 2, no type conversion is performed.)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 143
CHAPTER 2.6.3


6)  When the type of an arithmetic expression can not be determined at
    compile-time,  it is considered to be the highest possible type in
    the hierarchy of the alternatives.

    If in

         IF X > 0 THEN P.R ELSE S

    the result of an expression is of  one  arithmetic  type  and  the
    expression  is  assigned to a variable of another arithmetic type,
    the result is converted to the appropriate type.

7)  For mathematical functions(like  SIN  or  TAN)  the  type  of  the
    function  is  the same as the type of the argument.  Some of these
    mathematical functions are not provided for the  LONG  REAL  type.
    In  that case, a warning message is given and the REAL function is
    used instead.  (See Appendix B.) Note that abs works according  to
    Algol  definiton  -  i.e.   abs  is  [LONG]  REAL  even  if actual
    parameter is INTEGER.  This might be changed  in  the  future  for
    compatibility reasons.)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 144
CHAPTER 2.6.3


Arithmetic operator precedence
------------------------------

The evaluation of an arithmetic-expression can be considered as taking
place  in  a  number  of scans through the expression, each scan going
from left to right:

1)  The values of the constants, variables  and  function  designators
    are evaluated.

2)  Any subexpression between a  left  parenthesis  and  its  matching
    right parenthesis is evaluated (according to rules 2, 3, 4, 5) and
    is used as a primary in subsequent calculations.

3)  All exponentiations are evaluated.

4)  All  multiplications,  divisions   and   integer   divisions   are
    evaluated.

5)  All additions and subtractions are evaluated.

The operator precedences may be summarized by

1.     (     )    [     ]
2.     **    ^
3.     *     /   //
4.     +     -


Arithmetics of REAL and LONG REAL quantities
--------------------------------------------

Quantities of type  REAL  and  LONG  REAL  are  defined  to  a  finite
accuracy.   Thus any operation performed on such quantities is subject
to a possible deviation.  The analysis of  the  possible  consequences
should be carried out by a numerical analyst.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 145
CHAPTER 2.6.4


2.6.4  CONDITIONS

Conditions (or BOOLEAN-expressions) return the values TRUE  or  FALSE.
Their   prime  use  is  in  conditional  expressions  and  conditional
statements.


condition
---------
                    
 **                                                       **
 *  BOOLEAN-primary [BOOLEAN-operator BOOLEAN-primary]...  *
**                                                         **
 *  IF-clause BOOLEAN-primary ELSE condition               *
 **                                                       **


BOOLEAN-primary
---------------
                    
           **                             **
           *  BOOLEAN-variable             *
**     **  *  BOOLEAN-function-designator  *
*  NOT  *  *  TRUE                         *
*   \   * **  FALSE                        **
**     **  *  relation                     *
           *  (condition)                  *
           **                             **


BOOLEAN-operator
----------------

      **                      **
      *                        *
     **  AND ! OR ! EQV ! IMP  **
      *                        *
      **                      **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                           Page 146
CHAPTER 2.6.4


relation
--------

 **                                                                      **
 *                                **     **                               *
 *                                *   =   *                               *
 *                                *   >   *                               *
 *                                *  >=   *                               *
 *  simple-value-expression      **   <   **  simple-value-expression     *
 *                                *  <=   *                               *
 *                                *  \=   *                               *
 *                                **     **                               *
 *                                                                        *
 *                                                                        *
 *                                **     **                               *
 *                                *  = =  *                               *
**  simple-reference-expression  **       ** simple-reference-expression  **
 *                                *  =/=  *                               *
 *                                **     **                               *
 *                                                                        *
 *                                                                        *
 *                                **     **                               *
 *                                *  IS   *                               *
 *  SIMPLE-REFERENCE-EXPRESSION  **       ** CLASS-IDENTIFIER             * 
 *                                *  IN   *                               *
 *                                **     **                               *
 **                                                                      **


Note the equivalent modes of writing:

           \         or          NOT
           =                     EQ
          \=                     NE
           <                     LT
          <=                     LE
           >                     GT
          >=                     GE

Examples:

     TRUE
     FATHER AND SON
     X = 0 OR \ (Y > C)
     NOT (X IN HEAD)
     T == NOTEXT
     FATHER =/= NONE
     C = 'A'
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 147
CHAPTER 2.6.4


BOOLEAN OPERATORS

The meanings of the logical operators

                NOT          not
                AND          and
                OR           or
                IMP          implication
                EQV          equivalent

are given in the table:

  P        !   T    T      F    F
           !
  Q        !   T    F      T    F
           !
------------------------------------
           !
NOT P      !   F    F      T    T   IF P THEN FALSE ELSE TRUE
P AND Q    !   T    F      F    F   IF P THEN Q ELSE FALSE
P OR Q     !   T    T      T    F   IF P THEN TRUE ELSE Q
P IMP Q    !   T    F      T    T   IF P THEN Q ELSE TRUE
P EQV Q    !   T    F      F    T   IF P THEN Q ELSE NOT Q


Note that a Boolean expression is  always  evaluated  completely.   in
some  cases  it  may  be  more effeicient or even necessary to use the
expanded form given by the table above.

For example:

          WHILE T.MORE AND T.GETCHAR = ' ' DO;

may work more safely coded:

          WHILE (IF T.MORE THEN T.GETCHAR = ' ' ELSE FALSE) DO;


Precedence of OPERATORS
-----------------------

The sequence of operations within one condition is from left to  right
with the following additional rules:

first:          arithmetic expressions (+, -, **, ^, /, //)
                   according to section 6.3
second:         relations (<, <=, =, NE, \=, >, >=, ==, =/=, IS, IN)
third:          NOT
fourth:         AND
fifth:          OR
sixth:          IMP
seventh:        EQV

The use of parentheses is interpreted as in section 6.3.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 148
CHAPTER 2.6.4


Relations

---------

1)  IS, IN

    The operators IS and IN test the class membership of a  referenced
    object:

    X IS C     is TRUE only if X is a reference to an object belonging
               to the class C, otherwise the value is FALSE

    X IN C     is TRUE only if X is a reference to an object belonging
               to either the class C or to a sub-class of C, otherwise
               the value is FALSE.

    Both X IN C and X IS C are FALSE if X == NONE.

2)  Reference comparators (==, =/=)

    These operators compare either two simple text references  or  two
    simple  object  expressions.  Two object (text) references X and Y
    are identical if  they  refer  to  the  same  object  (text  value
    instance)  or  if  both  are  NONE  (NOTEXT).  In these cases, the
    relation X == Y is TRUE.  Otherwise it is FALSE.

    The relation X =/= Y has the value of NOT (X == Y).

    If X and Y are two text references, then X =/= Y and  X  =  Y  may
    both  be  TRUE  if  X and Y refer to physically distinct character
    sequences which are equal.

3)  Value comparators (=, NE, \=, >, >=, <, <=)

    The relations take the value TRUE if the corresponding relation is
    satisfied  for  the  actual  values  of  the expressions involved,
    otherwise FALSE.

    Examples:

          5   =   3       is     FALSE
          ' ' =   '+'     is     FALSE
          X   <   0       is     FALSE if the current value  of  X  is
                                 positive  or  zero,  otherwise  it is
                                 TRUE
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 149
CHAPTER 2.6.4


If the values of two arithmetic expressions are compared and they  are
of  different  types,  then  the  value lower down in the hierarchy is
converted to the type of the higher before comparison is made.

Character values  may  be  compared  with  respect  to  the  collating
sequence.  A relation

     X  REL  Y

where X and Y are character values, and REL is a  relational  operator
has the same truth value as

     RANK(X)  REL RANK(Y)

Example:

     '+' < '='     is TRUE         RANK('+') = 43
                                   RANK('=') = 61

Two text values are equal if they are both empty or if they  are  both
instances of the same character sequence.  Otherwise they are unequal,
and then a text value T ranks lower than a text value U if one of  the
following conditions is fulfilled:

1)  T is empty
2)  U is equal to T followed by one or more characters
3)  If the first i-1 characters of T and U are the same, and  the  ith
    character of T ranks lower than the ith character of U.

Examples:

          NOTEXT = ""          TRUE
          "0" < "9"            TRUE
          "ABCDE"="ABCDEF"     FALSE
          "+12" NE "=12"       TRUE
          "ABC" = "ABCD"       FALSE
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 150
CHAPTER 2.6.5


2.6.5  CHARACTER EXPRESSIONS

CHARACTER-expression

     simple-character-expression
     IF-clause simple-character-expression
        ELSE character-expression

simple-character-expression

     CHARACTER-constant
     CHARACTER-variable
     CHARACTER-function-designator
     (CHARACTER-expression)

CHARACTER-constant

     '(any character from the data character set)'


Example:

     '''
     'A'
     IF X < 0 THEN ' ' ELSE 'Y'

The set of internal characters is ordered according to  the  collating
sequence  (Appendix  A).   The  collating  sequence  defines a one-one
mapping between internal characters  and  integers  expressed  by  the
function procedures:

     INTEGER PROCEDURE RANK (C);  CHARACTER C;

whose value is in the range 0 through 127 and

     CHARACTER PROCEDURE CHAR (N);  INTEGER N;

The parameter value must be in the range 0 through 127 otherwise a run
time error results.

Two character subsets are defined by the standard procedures

     BOOLEAN PROCEDURE DIGIT (C);  CHARACTER C;

which is TRUE only if C is a digit, and

     BOOLEAN PROCEDURE LETTER (C);  CHARACTER C;

which is TRUE only if C is an upper or lower case letter.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 151
CHAPTER 2.6.5


Example:

The following program scans an input file on SYSIN until "end of file"
is met and records the number of occurrences of the digits 0 - 9.

     BEGIN  INTEGER ARRAY INCIDENCES [RANK('0') : RANK('9')];
            CHARACTER C; INTEGER R;
            WHILE NOT LASTITEM DO
            BEGIN  C := INCHAR;
                   IF DIGIT (C) THEN
                      BEGIN  R := RANK(C);
                             INCIDENCES[R] := INCIDENCES[R] + 1;
                      END;
            END;
            ...
     END



2.6.6  DESIGNATIONAL EXPRESSIONS

A designational expression is a rule for  obtaining  the  label  of  a
statement.


designational-expression

     simple-designational-expression
     IF-clause simple-designational-expression
         ELSE designational-expression


simple-designational-expression

     LABEL-identifier
     SWITCH-identifier [subscript]
     (designational-expression)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 152
CHAPTER 2.6.6


Examples:

valid    LAB
         CHOOSE [I]
         SELECT [IF X < 0 THEN 2 ELSE 3]
         IF B < 0 THEN LAB_1 ELSE SLAB[1]

invalid  X.LAB                remote SWITCH- or LABEL-
                              identifiers are not allowed

The   principle   of   evaluation   is   analogous    to    that    of
arithmetic-expressions.   In  the  general case, the conditions in the
IF-clauses will select a simple-designational-expression.  If this  is
a  label  the  desired  result  is found.  A switch designator, on the
other hand, refers to the corresponding switch declaration and by  use
of    the    actual    numerical    value   of   its   subscript   (an
arithmetic-expression) selects one  of  the  designational-expressions
listed  in  the  switch  declaration  by  counting from left to right.
Since this value itself may be a switch designator, the definition  is
recursive.

The evaluation of the subscript is analogous to  that  of  subscripted
variables.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 153
CHAPTER 2.6.7


2.6.7  OBJECT EXPRESSIONS

An object-expression is a rule for computing a reference to an  object
or NONE.  The type of the expression is REF (qualification).


object-expression

     simple-object-expression
     IF-clause simple-object-expression
         ELSE object-expression


simple-object-expression

          NONE
          variable
          function-designator
          NEW CLASS-identifier[actual-parameter-part]
          THIS CLASS-identifier
          simple-object-expression QUA CLASS-identifier
          (object-expression)


Examples:

          X
          X.Y
          SIDE (3)
          THIS HEAD.SUC
          NEW INFILE("CARDS")
          THIS LINK QUA SUBCLASS.ATTRIB
          IF SUC IN LINK THEN SUC ELSE NONE
          IF X =/= NONE
             THEN (IF X.F =/= NONE THEN X.F.F ELSE NONE)
             ELSE NONE
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 154
CHAPTER 2.6.7


Qualification

The qualification of an object-expression is defined by the  following
rules:

1)  The expression NONE is qualified by a fictitious  class  which  is
    inner to all declared classes.

2)  A variable, array or function designator is qualified as stated in
    the  declaration  (or specification, see below) of the variable or
    array or procedure in question.

3)  An object-generator, local-object or qualified-object is qualified
    by  the  class of the identifier following the symbol NEW, THIS or
    QUA respectively.

4)  A conditional object-expression is qualified by the class  at  the
    innermost  prefix  level  which includes the qualification of both
    alternatives.  If there  is  no  such  class,  the  expression  is
    illegal.

    In

         IF B THEN NONE ELSE S

    the qualification is that of S (by rule 1).

5)  A formal parameter of object-reference type is qualified according
    to  its  specification  regardless  of  the  qualification  of the
    corresponding actual parameter.

6)  The  qualification  of  a  function-designator   whose   procedure
    identifier  is  that  of a virtual quantity, depends on the access
    level.  The qualification is that of the matching declaration,  if
    any,  occurring  at the highest prefix level equal to or less than
    the access level, or if none, that of the virtual specification.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 155
CHAPTER 2.6.7


Object generators       (NEW A....)

An object-generator invokes the generation and execution of an  object
belonging  to  the  identified class.  The object is a new instance of
the corresponding (concatenated) class body.   The  evaluation  of  an
object generator consists of the following actions.

1)  The object is generated and the actual parameters  of  the  object
    generator  are  evaluated.  The parameter values and/or references
    are transmitted.  (For parameter transmission modes,  see  section
    5.4).

2)  Control enters the body of the object through  its  initial  BEGIN
    whereby it becomes operating in the "attached" state.

    The evaluation of the object generator is completed:

    Case a:  Whenever the basic procedure  "detach"  is  executed  "on
    behalf of" the generated object (see CHAPTER 3, section 1) or

    Case b:  upon exit through the final end of the object.

The value of an object-generator is the object generated as the result
of  its  evaluation.   The state of the object after the evaluation is
either "detached" (case a) or "terminated" (case b).

In the SIMULA language, no command is available to  explicitly  remove
or  destroy  a  class  instance.   This is instead done by a so-called
garbage  collector,  which  automatically  will  remove  those   class
instances which are not accessible from a program.

Example I:  If the only way to access a certain class  object  is  the
reference  variable A, then changing the value of A will cause removal
of the object (e.g.  "A:- NONE").

Example II:  If the only way to  access  a  certain  class  object  is
through its membership in a set, then the set operator "out" will make
it inaccessible and thus remove it.  If the only way for  the  program
to  reach  members  of  a  set  or other data structure is through one
reference, e.g.  a reference to the head of the set, then assigning  a
new value to this reference will remove the entire set.  


Qualification in connection with reference-assignment

Consider the object-reference-assignment

          V:- object-expression

Both the left part and the right part have a qualification.  Let these
be  Ql  and  Qr  respectively - note  that  NONE is here considered as
having a  universal  qualification  which  is  inner  to  every  other
qualification.   The  situations that can arise are illustrated in the
context:
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 156
CHAPTER 2.6.7


       REF(CHAIN)C;          CLASS CHAIN.............;
       REF(MEMBER)M;         CLASS MEMBER............;
       REF(POINT)P:          MEMBER CLASS POINT......;
       REF(LINE)L;           MEMBER CLASS LINE.......;


CASE 1:  Ql is equal or outer to Qr
         E.G.

              A)     M:-NEW MEMBER;
              B)     M:-NEW POINT......;
              C)     M:-P;
              D)     M:-NONE;

         The assignment is  legal.   In  B),  the  attributes  of  the
         referenced POINT-object may be accessed by use of QUA as in

                     M QUA POINT.X

         or by use of INSPECT as in

                     INSPECT M QUA POINT DO ...  X ...

                     INSPECT M WHEN POINT DO ...  X ...

         Note the difference - in the first line a qualification error
         will occur if M denotes a LINE or is NONE, in the second line
         nothing  will   happen.    See   section   2.7.2   Connection
         statements.

Case 2:  Ql is inner to Qr
         e.g.

              A)    P:-NEW MEMBER;
              B)    P:-M;

         The assignment may be legal.  A) is clearly not,  but  B)  is
         legal  if  M  is  currently  referencing a POINT object or an
         object of a class inner to POINT, e.g.  after

              M:-NEW POINT...;

         This must be checked at runtime.

In cases 1 and 2,  the  qualifications  Ql  and  Qr  are  said  to  be
compatible.  Notice that compatibility is decided at compile time.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 157
CHAPTER 2.6.7


Case 3:  Ql and Qr are not compatible.
         e.g.

              A)    P:-NEW LINE.....;
              B)    P:-NEW CHAIN;
              C)    M:-C;

         The assignment is illegal.

Similar rules apply to the object-reference  assignments  implicit  in
the  passing  of  parameters  (FP:- AP)  and assignments to the result
variable in a function procedure body.

Multiple assignments take the form

     v1:- v2:- ... :- vn:- object-expression

and are equivalent to

     vn:- object-expression
     vn-1:- vn;
     ...
     v1:- v2;

The considerations above apply at each step.

The fact that an object-reference-assignment  is  always  checked  for
legality  (mainly at compile time) has the following implication.  For
any object-reference-variable or indeed, object-expression whose value
is  V  and  with  qualification Qv, the following is always true under
program execution:

     (V == NONE) OR (V IN Qv)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 158
CHAPTER 2.6.7


Local objects
-------------

A local-object "THIS C" is a meaningful expression within

1)  the class body of C or that of any subclass of C, or

2)  a connection block whose qualification is C or a subclass of C.

The value of a local-object in a given context is the object which is,
or  is  connected by, the smallest textually enclosing block instance,
in which the local object is a meaningful expression.  If there is  no
such  block,  the  local  object  is  illegal.   For  an instance of a
PROCEDURE- or CLASS-body, "textually enclosing" means  containing  its
declaration.



Instantaneous qualification
---------------------------

Let X represent any simple reference expression, and let C  and  D  be
class  identifiers  such  that  D  is  the  qualification  of  X.  The
qualified object "X QUA C" is then a legal object expression, provided
that  C includes D or is a subclass of D.  Otherwise, i.e., if C and D
belong to disjoint prefix sequences, the qualified object is illegal.

The evaluation of X QUA C at run time gives an error if the value of X
is  NONE,  or  an  object  belonging  to  a  class  not included in C.
Otherwise the value of X QUA C is that of X.  (Note the  qualification
of X is D, whilst that of X QUA C is C).



2.6.8  TEXT EXPRESSIONS AND TEXT VALUES

A TEXT-expression is a rule  for  computing  a  reference  to  a  TEXT
object.   A  TEXT-value  is  a  rule for computing the value of a text
(i.e., string of characters).



TEXT-expression
---------------

        **                                                     **
        * simple-text-expression                                *
       **                                                       **
        * IF-clause simple-text-expression ELSE TEXT-expression *
        **                                                     **
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 159
CHAPTER 2.6.8


simple-text-expression
----------------------

       ****************************
       * NOTEXT                   *
       * TEXT-variable            *
       * TEXT-function-designator *
       * (TEXT-expression)        *
       ****************************



TEXT-value
----------

       **************************
       * simple-text-expression *
       * text-constant          *
       **************************


Examples:
--------


valid
-----

TEXT-expression   NOTEXT
                  IF T.LENGTH < 5 THEN NOTEXT ELSE BLANKS(80)
                  (RUNE.T)
                  T.SUB(1,12)

TEXT-value        "ANOTHER CONSTANT"
                  NOTEXT
                  ""   (same as NOTEXT)


invalid
-------

                  IF T.LENGTH < 5 THEN "MAX FOUR"
                                  ELSE "MIN FIVE"

                  TEXT-constants   may   not   be   constituents    of
                  conditional expressions.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 160
CHAPTER 2.7


2.7  BLOCKS AND STATEMENTS
     ---------------------

A program is structured into blocks.  A block consists of a block head
which  defines  properties  of  the  block,  and a compound tail which
defines the actions of the block.  A block may be prefixed which means
that the block is built into a predefined environment.

There is no way for a block environment  to  interact  with  an  inner
block  (i.e.,  examine  its  current state).  The environment can only
observe the result of its  actions.   A  block  may  only  be  entered
through its initial BEGIN and attempts to do so by GOTO statements are
thus illegal.



2.7.1  BLOCKS AND COMPOUND STATEMENTS

program
-------

       block ! compount-statement



block
-----

       prefixed-block ! main-block



prefixed-block
--------------

                       **                       **  main-block
     CLASS-identifier ** [actual-parameter-list] **
                       **                       ****compound-statement



main-block
----------

     BEGIN [declaration;]...[statement;]... [statement]END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 161
CHAPTER 2.7.1


compound-statement
------------------

     BEGIN [statement;]...[statement]END

A block automatically introduces a new  level  of  nomenclature.   Any
identifier  may  be  declared or appear as a label in the block and is
then said to be local to it.  An entity represented inside a block has
no  existence outside it and any entity represented by this identifier
outside the block cannot be directly accessed by use of  it  (see  the
explanation of the binding rule in section 2.3).

When  a  block  is  prefixed,  the   identifiers   declared   in   the
corresponding  CLASS  are made available.  Nevertheless, an identifier
in the CLASS may be redefined in the main-block or compound-statement.

The execution of a block is as follows:

step 1:  if the block is prefixed then the actual parameters (if  any)
         are evaluated.

     2:  if the declarations of the block contain  array  bounds  then
         these  are evaluated.  (They may make reference to parameters
         of the prefix).

     3:  Execution of  the  statements  body  begins  with  the  first
         statement  of  the  prefix,  if any, otherwise with the first
         statement of the main block.  After execution  of  the  block
         body  (unless it is a GOTO statement) a block exit occurs and
         the  statement  textually  following  the  entire  block   is
         executed.

A CLASS identifier possibly followed by an actual parameter  list  can
prefix   a   main-block   or   compound-statement.   This  results  in
concatenating the object of the stated class with that  main-block  or
compound-statement,  which  means  that the capabilities of the stated
class and its including classes are available within  that  main-block
or compound statement.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 162
CHAPTER 2.7.1


When an  instance  of  a  prefixed  block  is  generated,  the  formal
parameters  of  the  class  are initialised as indicated by the actual
parameters of the block prefix.  A virtual quantity is  identified  by
the  quantity  defined  by a matching declaration in the block head of
the main-block or compound-statement, or by the matching definition at
the innermost prefix level of the prefix sequence.  The operation rule
of the concatenated object is defined by principles similar  to  those
given in section 5.5.

A  prefixed-block  plays  a  particular  role  in  the  quasi-parallel
sequencing  of  SIMULA:   it defines a quasi-parallel system, a system
whose  components  have  interactions  independent  from  the  program
outside the prefixed block, see CHAPTER 3.

The following restrictions must be observed when prefixing blocks:

An object in which reference is made to the object itself through  use
of THIS is an illegal block prefix.

The CLASS-identifier of a prefix must refer to a class  local  to  the
smallest block enclosing the prefixed block.  If that CLASS-identifier
is that of a system class, it refers to a  fictitious  declaration  of
that  system  class  occurring  in  the  block  head  of  the smallest
enclosing block.

A  compound-statement  is  a  means  of  grouping  several  statements
together to act as one unit, as in

     FOR I := 1 STEP 1 UNTIL 10 DO
         BEGIN  SUM := SUM + A[I];
                SUMSQ := SUMSQ + A[I]^2;
         END

where the controlled-statement is a compound-statement,

or of legalising a statement structure

     IF X > 0 THEN BEGIN  IF Y > 0 THEN QUADRANT := 1;
                   END

The structure is illegal without the BEGIN - END pair.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 163
CHAPTER 2.7.2


2.7.2  STATEMENTS

A statement is a unit of action in a program.  Sequences of statements
may be grouped together to form compound statements or blocks.

Special  notice  must  be  taken  of  conditional   statements   which
effectively prevent a certain ambiguity from arising.  For consider

     IF condition1 THEN IF condition2 THEN S2 ELSE S3

which has two interpretations

1)  IF condition1 THEN IF condition2 THEN S2 ELSE S3
                       -----------------------------

2)  IF condition1 THEN IF condition2 THEN S2 ELSE S3
                       ---------------------


This ambiguity is resolved by not allowing a conditional statement  to
follow the THEN symbol.  Now the two meanings are resolved by writing.

1)  IF condition1 THEN
       BEGIN  IF condition2 THEN S2 ELSE S3  END

2)  IF condition1 THEN BEGIN  IF condition2 THEN S2  END
                  ELSE S3
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 164
CHAPTER 2.7.2


The same sort  of  ambiguity  can  arise  with  a  WHILE-statement,  a
FOR-statement, or a connection statement following a THEN.

     IF condition1 THEN
         WHILE J < 10 DO
            IF condition2 THEN S1 ELSE S2

     IF condition3 THEN
        INSPECT X DO
        IF condition4 THEN S3 ELSE S4

Here the syntax forces the ELSE-branch to belong to the nearest  THEN,
but means that whereas we can write:

                        **                    **
                        * WHILE-statement      *
     IF condition THEN ** FOR-statement        **
                        * connection-statement *
                        **                    **


we can not write

                        **                    **
                        * WHILE-statement      *
     IF condition THEN ** FOR-statement        ** ELSE S
                        * connection statement *
                        **                    **

In this case, BEGIN - END are necessary round  the  WHILE-,  FOR-,  or
connection-statement.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 165
CHAPTER 2.7.2


OPEN AND CLOSED STATEMENTS
--------------------------


statement
---------

       **            **
       *              *
       * open         *
      ** closed       **
       * IF-statement *
       *              *
       **            **


open
----

            **                    **
            *                      *
            * FOR-statement        *
[label:].. ** WHILE-statement      **
            * connection-statement *
            *                      *
            **                    **


closed
------

            **                    **
            *                      *
            * block                *
            * compound-statement   *
            * activation-statement *
            * PROCEDURE-statement  *
[label:].. ** dummy-statement      **
            * GOTO-statement       *
            * assignment-statement *
            * object-generator     *
            *                      *
            **                    **


label
-----

          LABEL-identifier
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 166
CHAPTER 2.7.2


ASSIGNMENTS
-----------

Assignment-statements assign the value of  an  expression  to  one  or
several variables or procedure identifiers.  Assignment to a procedure
identifier may occur only within the body of  the  function  procedure
defining  the value of that function.  The process of assignment takes
place in three steps:

1)  any subscript expressions in the left variables are  evaluated  in
    sequence from left to right

2)  the expression is evaluated

3)  the value of the expression is assigned to the left part variables
    from right to left (see example below under Types).


assignment-state
----------------

      **                     **
      *                       *
      * value-assignment      *
     ** TEXT-value-assignment **
      * reference-assignment  *
      *                       *
      **                     **


value-assignment
----------------

     **                        **
     *                          *
     * variable :=              * ... VALUE-expression
     * PROCEDURE-identifier :=  *
     *                          *
     **                        **


Examples:
---------

          X := 3.45;
          C := D[I] := '+';
          P.X := R.X + S.X;

          Y := IF X > 0 THEN X ELSE -X;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 167
CHAPTER 2.7.2


TEXT-value-assignment
---------------------


       **                      **
       *                        *
       * variable:=             *
       * PROCEDURE-identifier:= *
      ** function-designator:=  **   ...TEXT-value
       * (IF-expression):=      *
       *                        *
       **                      **

Examples:
---------

          T:="MESSAGE";
          T.SUB(1,5):=S:="12345";
          (IF BOL THEN T1 ELSE T2):= "EOF";

          Consider the TEXT-value-assignment

               R := T;

          let the length of R be Lr and the length of T be Lt.  The
          assignment is legal if Lr >= Lt, otherwise a run time error
          results.

Lr = Lt     The text value of T is copied into R

Lr > Lt     The text value of T is copied into R left justified
            and the remaining Lr-Lt positions are filled with blanks

Assignments to overlapping texts are unpredictable.

e.g., with

          T.SUB(10,10) := T.SUB(15,10);
     or   T.SUB(15,10) := T.SUB(10,10);

The value assignment

          T := NOTEXT;

is an efficient way of setting the value of T to blanks.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 168
CHAPTER 2.7.2


reference-assignment
--------------------

       **                      **
       *                        *
       * variable:-             *
      ** PROCEDURE-identifier:- **   ...reference-expression
       *                        *
       **                      **


Examples:
---------

          T:-S:-U;
          T:-BLANKS(10);
          T:-NOTEXT;
          T:-T.STRIP;

          X:-Y:-Z;
          X:-NEW CL;
          X:-NONE;
          X:-MEMBER.SUC;


                                 NOTE

               In  case  of  type   REF   the   runtime
               qualification  of  the  righthandside of
               the assignment must be identical with or
               a  subclass  to the qualification of the
               lefthandside (see section 2.6.7).

               The qualification CLASS on both sides of
               the   assignment   statement   must   be
               declared in the  same  instance  of  the
               same block (e.g. CLASS body or PROCEDURE
               body).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 169
CHAPTER 2.7.2


Types
-----

The type of  the  expression  and  all  the  left  part  variables  or
PROCEDURE-identifiers   must  be  identical  except  in  the  case  of
arithmetic assignments.  In this case, the assignment

          v1 := v2 := ...... vn := expression

is equivalent to

          vn := expression
          vn-1 := vn
            .....
          v1 := v2

So that if X is REAL and I INTEGER,

          X := I := 3.57;

is equivalent to

          I := 4;
          X := 4.0;

and

          I := X := 3.57;

is equivalent to

          X := 3.57;
          I := 4;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 170
CHAPTER 2.7.2


GOTO-STATEMENTS
---------------

A GOTO statement interrupts the normal sequence  of  operations.   The
value  of  a designational expression indicates the value of the label
of the next statement to be executed.



GOTO-statement
--------------

          GOTO designational-expression


Examples:
---------

          GOTO L
          GOTO S[4]
          GOTO S[IF N=0 THEN 2 ELSE 6]
          GOTO IF N=0 THEN L1 ELSE L2

A GOTO statement may not lead into

     a connection statement
     a block which is not already active
     a FOR-statement

A GOTO statement leaving an attached object leaves the object  in  the
terminated state.

When the value of a designational  expression  is  a  switch  with  an
undefined  value  (the  index  is out of range), the GOTO statement is
equivalent to the dummy statement

e.g.,

          ;GOTO S[-1];        is equivalent to
          ; ;

The effect of

          ;GOTO S[IP];        assuming  IP  is  an  INTEGER  PROCEDURE
                              returning    an   undefined   value   is
                              equivalent to ;IP;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 171
CHAPTER 2.7.2


Example:
-------

The program below prints out the first three  verses  of  "The  Twelve
Days of Christmas".  The program logic is built around a SWITCH.

BEGIN  SWITCH CASE := LINE1, LINE2, LINE3;
       INTEGER VERSE;
       TEXT ARRAY T[1:3];
       T[1] :- COPY ("FIRST");
       T[2] :- COPY("SECOND");
       T[3] :- COPY("THIRD");


       WHILE VERSE <= 3 DO
       BEGIN

               VERSE := VERSE + 1;
               OUTTEXT("ON THE"); OUTTEXT(T(VERSE));
               OUTTEXT("DAY OF CHRISTMAS"); OUTIMAGE;
               OUTTEXT("MY TRUE LOVE SENT TO ME"); OUTIMAGE;
               GOTO CASE[VERSE];
LINE3:         OUTTEXT("THREE FRENCH HENS");
LINE2:         OUTTEXT("TWO TURTLE DOVES, AND");
LINE1:         OUTTEXT("A PARTRIDGE IN A PEAR TREE");
               EJECT(LINE + 2);
       END OF LOOP -
       NOTE THAT A FOR-LOOP WOULD HAVE MADE THE LABELS INVISIBLE;
END


OUTPUT:

          ON THE FIRST DAY OF CHRISTMAS
          MY TRUE LOVE SENT TO ME
          A PARTRIDGE IN A PEAR TREE

          ON THE SECOND DAY OF CHRISTMAS
          MY TRUE LOVE SENT TO ME
          TWO TURTLE DOVES, AND
          A PARTRIDGE IN A PEAR TREE

          ON THE THIRD DAY OF CHRISTMAS
          MY TRUE LOVE SENT TO ME
          THREE FRENCH HENS
          TWO TURTLE DOVES, AND
          A PARTRIDGE IN A PEAR TREE
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 172
CHAPTER 2.7.2


DUMMY STATEMENTS

A dummy-statement executes no actions.   It  is  a  fictive  statement
which  serves syntactical explanations.  In this way it is possible to
set several semicolons after each other and to place  a  label  before
END.



dummy-statement
---------------


Examples:
---------

          IF X > 0 THEN ELSE X := -X;  (Note dummy THEN-branch)

          BEGIN   ......   LAB : END;



dummy-statement and external procedures
---------------------------------------

A dummy-statement is  used  instead  of  the  body  for  a  separately
compiled  procedure which is actually written in another language than
SIMULA.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 173
CHAPTER 2.7.2


WHILE STATEMENTS

The WHILE-statement is used when  a  statement  is  to  be  repeatedly
executed as long as a condition is TRUE.



WHILE-statement
---------------

          WHILE condition DO statement


Examples:
---------

          WHILE NOT LASTITEM DO
          BEGIN  X := ININT;
                 COUNT := COUNT + 1;
                 SUM := SUM + X;

          END;

          X:-SET.FIRST;
          WHILE X =/= NONE DO
          BEGIN  IF X IN POINT THEN NOP := NOP + 1 ELSE
                    IF X IN LINE THEN NOL := NOL + 1 ELSE
                       ERROR("FALSE ENTRY");
                 X :- X.SUC;
          END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 174
CHAPTER 2.7.2


ACTIVATION STATEMENTS
---------------------

Activation statements are only valid inside a SIMULATION block.   They
are fully described in Chapter 3, section 3.



FOR STATEMENTS

FOR-statements are control statements which cause controlled-

statements to be executed zero or more times.

There are three basic types of FOR statement element.

1)  the controlled-statement is executed for a list of values (usually
    irregular).

         FOR I := 2, 13, 17 DO controlled-statement

2)  the controlled-statement is executed a known number of times

         FOR I := 1 STEP 1 UNTIL 10 DO
             X[I] := I*I;

3)  the controlled-statement is executed until a condition is met

         FOR X :- X.SUC WHILE X =/= NONE DO
             X QUA A.DUMP;

    To  increase  the  generality  of  the  concept,  these   elements
    themselves are allowed to form a list

         FOR I := 1, 2, 4 STEP 1 UNTIL 10, I*I WHILE I > 200 DO
           controlled statement
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 175
CHAPTER 2.7.2


FOR-statement
-------------

     [label:]...   FOR controlled-variable for-right-part DO
                       controlled statement



for-right-part
--------------

       **                                   **
       *                                     *
       * := value-element [,value-element]   *
      ** :- object-element [,object-element] **
       *                                     *
       **                                   **

value-element
-------------

       **                                                **
       *                                                  *
       * value-expression                                 *
       * arithmetic-expression STEP arithmetic-expression *
      **          UNTIL arithmetic-expression             **
       * value-expression WHILE condition                 *
       *                                                  *
       **                                                **



object-element
--------------

       **                                 **
       *                                   *
       * object-expression                 *
      ** object-expression WHILE condition **
       *                                   *
       **                                 **


Each  execution  of  the  controlled  statement  is  preceded  by   an
assignment  to  the  controlled-variable.   Assignments may change the
value  of  this  controlled   variable   during   execution   of   the
controlled-statement.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 176
CHAPTER 2.7.2


for list elements
-----------------

The for list elements are considered in the order in  which  they  are
written.   When one for list element is exhausted, control proceeds to
the next, until the last  for  list  element  in  the  list  has  been
exhausted.  Execution then continues after the controlled statement.

The effect of each type of for list element is defined below using the
following notation:

     C:  controlled variable

     V:  value expression

     O:  object expression

     A:  arithmetic expression

     B:  Boolean expression

     S:  controlled statement

The effect of the occurrence of expressions in for list  elements  may
be established by textual replacement in the definitions.

Alpha, beta,  gama  are  different  identifiers  which  are  not  used
elsewhere in the program.  O identifies a non-local simple variable of
the same type as A2.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 177
CHAPTER 2.7.2


    1.  V

        C := V;
        S;
        next for list element



    2.  A1 STEP A2 UNTIL A3

        C := A1;
        sigma := A2;

    a : IF sigma*(C-A3) > 0 THEN GOTO beta;
        S;
        sigma := A2;
        C := C + sigma;
        GOTO alpha;
    beta :  next for list element



    3.  V WHILE B

    alpha :  C := V;
        IF NOT B THEN GOTO beta;
        S;
        GOTO alpha;
    Beta :  next for list element

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 178
CHAPTER 2.7.2


    4.  O

        C :- O;
        S;
        next for list element



    5.  O WHILE B

    alpha :  C :- O;
        IF NOT B THEN GOTO beta;
        S;
        GOTO alpha;
    beta :  next for list element

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 179
CHAPTER 2.7.2


The controlled variable
-----------------------

The  controlled-variable  is  a  simple-variable  which   is   not   a
formal-parameter   called   by   name,   a   PROCEDURE-identifier,   a
remote-identifier nor a TEXT-identifier.

To be valid, all  for  list  elements  in  a  for  statement  must  be
semantically and syntactically valid.

In particular each implied assignment  is  subject  to  the  rules  of
section 7.2.1.3.



The value of the controlled variable upon exit
----------------------------------------------

Upon exit from the for statement, the controlled  variable  will  have
the  value  given  to it by the last (explicit or implicit) assignment
operation.



Labels local to the controlled statement
----------------------------------------

The controlled statement in a FOR-loop always acts as  if  it  were  a
block.   Hence,  labels  on  or  defined  within such loops may not be
accessed outside the controlled statement.

Thus it is illegal to write:

GO TO LAB;
FOR I:= 1,2,3 DO
BEGIN LAB:  ...  END;
but legal to write:
GO TO START;
WHILE .....  DO
BEGIN
....
START:
...
END OF LOOP;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 180
CHAPTER 2.7.2


PROCEDURE STATEMENTS
--------------------

A procedure-statement calls for the execution of  the  PROCEDURE-body.
Before  execution, the formal-parameters of the procedure are replaced
by the actual-parameters.



PROCEDURE-statement
-------------------

[simple-object-expression.] PROCEDURE-identifier [(expression
                                      [, expression]...)]


Examples:
---------

     INTO(H)
     OUTTEXT("***0***")
     SYSIN.INIMAGE

The procedure statement must have the same number of actual parameters
in the same order as the formal-parameters of the procedure heading.



Restrictions
------------

1)  An actual-parameter corresponding to a formal-parameter called  by
    NAME  which  is  assigned  to  within the PROCEDURE-body must be a
    variable.

2)  If the formal-parameter is an ARRAY (PROCEDURE), then  the  number
    of  dimensions  (actual-parameters) used within the PROCEDURE-body
    must correspond to the number of dimensions (actual-parameters) of
    the actual ARRAY (PROCEDURE).

3)  Arithmetic type procedures used as parameters must have exact type
    correspondence.   For REF-procedures the actual type must coincide
    with that if the formal parameter.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 181
CHAPTER 2.7.2


CONDITIONAL STATEMENTS
----------------------

Conditional statements cause certain  statements  to  be  executed  or
skipped  depending  on the current values of certain conditions.  They
provide an important structural framework in the language.



IF-statement
------------

              **                                      **
              *                                        *
              *             **                     **  *
              *             *                       *  *
              *             * WHILE-statement       *  *
              *             *                       *  *
              *             * FOR-statement         *  *
              * IF-clause  **                       ** *
              *             * connection-statement  *  *
              *             *                       *  *
[label:]...  **             * closed                *  **
              *             *                       *  *
              *             **                     **  *
              *                                        *
              * IF-clause closed                       *
              *                                        *
              *             ELSE statement             *
              *                                        *
              **                                      **


Examples:
---------

     L:  IF X > 0 THEN X := -X;


         IF X = 0 AND Y = 0 THEN
     L:     BEGIN OUTTEXT("ORIGIN");
                  OUTIMAGE;
            END;


            X :- T;
            WHILE X =/= NONE DO
            BEGIN  IF X QUA PERSON.MALE THEN MAN := MAN + 1
                                        ELSE WOMAN := WOMAN + 1;
                   X :- X.SUC;
            END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 182
CHAPTER 2.7.2


The statement sequence

     IF condition THEN S1;  S2

is equivalent to

(evaluate condition) S1; S2   if the condition is TRUE
(evaluate condition) S2       if the condition is FALSE.

The statement sequence

     IF condition THEN S1 ELSE S2;  T

is equivalent to

(evaluate condition) S1; T    if the condition is TRUE, and
(evaluate condition) S2; T    if the condition is FALSE.

A GOTO statement may lead directly into a conditional statement e.g.,

     IF B THEN  BEGIN OUTTEXT("TRUE");
                L:    OUTIMAGE;
                END
          ELSE  BEGIN OUTTEXT("FALSE");
                      GOTO L;
                END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 183
CHAPTER 2.7.2


CONNECTION STATEMENTS
---------------------

Connection-statements constitute a form of remote accessing  which  is
mainly  used as a user convenience if there are to be many accesses to
a particular object.

e.g.
     we may replace

     SYSBIN.INIMAGE;
     X := SYSBIN.INREAL;
     Y := SYSBIN.INREAL;
     C := SYSBIN.INCHAR;

     by

     INSPECT SYSBIN DO
     BEGIN  INIMAGE;
            X := INREAL;
            Y := INREAL;
            C := INCHAR;
     END



Connection statement
--------------------

                       **                                      **
                       *                                        *
                       *       statement                        *
INSPECT object-ref DO ** [WHEN CLASS-identifier DO statement]...**
               erence  *                [OTHERWISE statement]   *
                       *                                        *
                       **                                      **


Examples:
---------

     INSPECT SYSOUT DO
     BEGIN  OUTTEXT("TITLE");
            OUTIMAGE;
            EJECT(LINE+10);
     END;

     INSPECT X WHEN A DO OUTTEXT("X IN A")
               WHEN B DO OUTTEXT("X IN B")
               OTHERWISE OUTTEXT("ERROR");

     INSPECT X DO
       INSPECT Y DO P := Q
                 OTHERWISE OUTTEXT("Y==NONE");
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 184
CHAPTER 2.7.2


To avoid ambiguity, an OTHERWISE refers back to the nearest INSPECT.

The remote accessing of objects of classes may be accomplished by  the
dot  notation  or  by  connection.   In  most  cases  the  methods are
interchangeable but if the object  contains  class  attributes  (local
classes),  at  level  K, then attributes at levels KK >= K can only be
accessed by connection.

To access an attribute of an object we have to know:

1)  a reference to the object
2)  the qualification of the reference
3)  the attribute identifier.

The two variations are now explained:

1)  a)  INSPECT X DO S1 OTHERWISE S2
    b)  INSPECT X DO S1

    If X =/= NONE then the statement S1 is executed.  During execution
    of  this  statement  the reference variable of X is evaluated once
    and stored.  Access is now gained to the  denoted  object  at  the
    qualification  level of X.  All attributes of the qualifying class
    are now available by the occurrence of their identifiers.

    If X == NONE, then the statement S1 is skipped and  the  statement
    S2  is  executed in case a), and the whole connection statement is
    skipped in case b).

    In an otherwise branch, no connection holds.

    e.g.

                   CLASS A;
                   BEGIN REAL X; ..... END;
                 A CLASS B
                   BEGIN BOOLEAN Y; .. END;
                   REF(A)Q; REF(B)Z;

         INSPECT Q DO                   INSPECT Q QUA B DO
         BEGIN  X := 2;                 BEGIN  X := 2;
                THIS B.Y := FALSE;             Y := FALSE;
                Z :- NONE;                     Z :- NONE;
         END                            END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 185
CHAPTER 2.7.2


2)  INSPECT X WHEN A DO S1
              WHEN B DO S2
                 .....
              OTHERWISE T

    This descriminates on class membership  at  run  time.   The  WHEN
    clauses  are considered in turn.  If X is an object belonging to a
    class equal to or inner to the one identified in the  clause  then
    the   associated  statement  is  executed  and  the  rest  of  the
    connection-statement  is  skipped.    The   OTHERWISE-clause   (if
    present)  is  only  executed  if  X == NONE  or all preceding WHEN
    clauses are skipped.


OBJECT GENERATORS
-----------------

Object-generators were discussed in  section  2.6.7.   They  may  also
stand  as statements in their own right, in which case their reference
value is not assigned on exit.  This does not mean that they cannot be
referenced as the following example shows:

     LINK CLASS B(H); REF (HEAD)H;
     BEGIN  PTR :- THIS B;
            INTO(H);
     END

After execution of the statement

     NEW B(HD);

then  the  generated  object  is  referenced  by   PTR   and   HD.LAST
(if HD =/= NONE).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 186
CHAPTER 3


           CHAPTER 3 PROGRAM STRUCTURE AND SYSTEM FEATURES
           -----------------------------------------------



3.1  PROGRAM STRUCTURE
     -----------------

Without the CLASS concept, the run time structure of a SIMULA  program
is  essentially  that of a stack of blocks with the last created block
"active".  Given the program skeleton

     BEGIN  REAL X;
     L1:    S1;
            BEGIN  BOOLEAN B;
                   S2;
                   BEGIN  TEXT X;
            L3;           S3;
                   END;
     L2:           S4;
            END;
            S5;
     END

(where the S's denote statement sequences) then the structures at  run
time are

1.  during execution of S1 or S5

             -----------------
             !       !       !
             !       !       !
             -----------------
             ! REAL X        !     PSC denotes the
             -----------------
     PSC --->! L1:  S1       !     current statement
             ! <INNER BLOCK> !
             !      S5       !
             -----------------

    Only one variable REAL X exists.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 187
CHAPTER 3.1


2.  during execution of S2 (or S4)





             -----------------
              !       !       !<---
              !       !       !   !
              -----------------   !
              ! REAL X        !   !
              -----------------   !
              ! L1;  S1       !   !
          --->! <INNER BLOCK> !   !
          !   !      S5       !   !
          !   -----------------   !
          !                       !
          !                       !
          !   -----------------   !
          ----!--.    !    .--!---- 
              !       !       !
              -----------------
              ! BOOLEAN B     !
              -----------------
      PSC --->!      S2       !
              ! <INNER BLOCK> !
              ! L2:  S4       !
              -----------------

    Two varaibles REAL X and BOOLEAN B exist.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 188
CHAPTER 3.1


3.  during execution of S3

              -----------------
              !       !    .  !<---
              !       !       !   !
              -----------------   !
              ! REAL X        !   !
              -----------------   !
              ! L1:  S1       !   !
          --->! <INNER BLOCK> !   !
          !   !      S5       !   !
          !   -----------------   !
          !                       !
          !                       !
          !                       !         STACK OF
          !   -----------------   !
          ----!--.    !    .--!----        "ATTACHED"
              !       !       !<---
              -----------------   !          BLOCKS
              ! BOOLEAN B     !   !
              -----------------   !
              !      S2       !   !
          --->! <INNER BLOCK> !   !
          !   ! L2:  S4       !   !
          !   -----------------   !
          !                       !
          !                       !
          !                       !
          !   -----------------   !
          --->!--.    !    .--!----
              !       !       !
              -----------------
              ! TEXT X        !
              -----------------
              !               !
      PSC --->! L3:  S3       !
              !               !
              -----------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 189
CHAPTER 3.1


    Three variables exist:  REAL X, BOOLEAN B, TEXT X,  but  only  two
    are  accessible  by actions in the active block, for the REAL X of
    the outermost block has become inaccessible due to  an  identifier
    clash with TEXT X of the innermost block.

    Note that besides exiting from a block via its final  END,  it  is
    also  possible  to  exit  via  a GOTO-statement.  If the statement
    sequence S3 includes the statement

              GOTO L2

    then on execution  of  that  statement,  the  innermost  block  is
    deleted (the variable TEXT X will no longer exist).

    If the statement sequence S3 includes the statement

              GOTO L1

    then both the inner blocks will be deleted when that statement  is
    executed and both BOOLEAN B and TEXT X will no longer exist.


The CLASS concept initially gives the opportunity for data  structures
to exist in parallel.  The program

     BEGIN  CLASS A;..........;
            REF(A)U,V;
            U :- NEW A;
            BEGIN  CLASS B;..........;
                   REF(B)X;
                   REF(A)W;
                   V :- W :- NEW A;
                   X :- NEW B;
            L:     ..........
            END ***INNER BLOCK*** ;
            ..........
     END ***PROGRAM*** ;

has the representation below at the label L.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 190
CHAPTER 3.1


                               ------------------------------------
                               !                                  !
                               V                                  !
                 -----------------                                !
                 !       !       !<-----------------              !
OB: outer block  ! OB    !       !<---             !              !
                 -----------------   !             !              !
                 ! CLASS A       !   !       ---------      ---------
                 ! REF(A) U   .--!---!------>!   ! . !  --->!   ! . !
                 ! REF(A) V   .--!---!----   ---------  !  ---------
                 -----------------   !   !   !       !  ! ! !       !
                 ! <INNER BLOCK> !   !   !   !       !  ! ! !       !
                 ! ............  !   !   !   ---------  ! ! ---------
                 -----------------   !   !              ! !
                                     !   ---------------- !
                                     !                    !
                 -----------------   !                    !
IB: inner block  ! IB    !    .--!---^ <-------           !
                 -----------------   >-------!------------
                 ! CLASS B       !   ^        !
                 ! REF(A) W   .--!----  ---------
                 ! REF(B) X   .--!----->!   ! . !
                 -----------------      ---------
                 ! ..........    !      !       !
                 ! L: .......    !      !       !
                 -----------------      ---------


When the inner  block  is  deleted,  the  second  A  object  is  still
available  as  it is referenced by V.  On the other hand, the B object
must be  deleted  as  its  declaration  disappears  and  therefore  no
references exist.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 191
CHAPTER 3.1


At  this  level,  the  actions  of  each  object  are  executed  until
exhaustion  and  then  the object is left as an attribute structure in
the terminated state.  But there is a broad class  of  problems  which
cannot  be  modelled  by  this  mechanism,  e.g., when the actions are
executed in phases corresponding to  the  actual  concept  represented
being  active  or  passive.   For  example,  a customer in a shop goes
through the stages of queuing (passive) and buying  (active),  players
in  a  game of cards play, and then are passive until their turn comes
again.  We could picture a customer object, C, by:

             -----------------
             !       !       !
             !       !       !
     C------>-----------------
             ! enter shop    !
             !               !...active
             ! enter queue 1 !
             !               !
             !               !
             !               ! . . . passive
             !               !
             !               !
             ! served        !
             !               !...active
             ! enter queue 2 !
             !               !
             !               !
             !               ! . . . passive
             !               !
             !               !
             ! served        !
             !               !...active
             ! enter queue 3 !
             !               !
             !...............!
             !               !
             ! leave shop    !
             !               !
             -----------------


When C is passive its actions may be  made  active  again  by  a  call
RESUME(C).  The actions of C are resumed from where they were left off
last.  To mark off this program point objects can be made into program
components  supplied  with  a LOCAL SEQUENCE CONTROL (LSC) which marks
the current stage of execution of their actions.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 192
CHAPTER 3.1


A very simple example is that of two players playing  a  game.   Their
actions may be loosely described by

          ..........
      L:  play
          RESUME(opponent);
          GOTO L

When the first player is generated, we do not wish  to  execute  these
actions  as  the  opponent is not yet generated.  So we have to return
control to the main block and return a reference to this  player,  and
then  create  the  second  player.   A  second system PROCEDURE DETACH
serves this purpose.  On meeting DETACH, the object becomes  a  system
component  with  an  LSC  referencing  the  next statement, control is
returned to its object generator  and  with  it  a  reference  to  the
object.

The outline of a simple program for a two man game is:

     BEGIN  CLASS PLAYER;
            BEGIN  REF(PLAYER) OPPONENT;
                   DETACH;
            L:     play;
                   RESUME(OPPONENT);
                   GOTO L
            END;
            REF(PLAYER)P1,P2;
            P1 :- NEW PLAYER;
            P2 :- NEW PLAYER;
            P1.OPPONENT :- P2;  P2.OPPONENT :- P1;
            RESUME(P1);
            ..........
     END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 193
CHAPTER 3.1


A snapshot at the point where RESUME(P1) has just been executed is:

                           ----------------------
                         --! MB       !         !
                         ! ----------------------
                         ! ! PLAYER CLASS       !
                         ! ! P1     REF(PLAYER).!----
                         ! ! P2     REF(PLAYER).!---!---
                         ! !   ............     !   !  !
                         ! ! RESUME(P1)         !   !  !
               LSC       ->!   ............     !   !  !
                           ----------------------   !  !
                                                    !  !
                                                    !  !
                                                    !  !
                             -----------------------   !
                             !                         !    <--------
                             !                         !            !
                             !                         !            !
                             V                         V            !
           ------------------------  !--->------------------------  !
         --!-.        !       MB  !  !  --!-.        !       MB  !  !
         ! ------------------------  !  ! ------------------------  !
         ! ! OPPONENT REF(PLAYER).!---  ! ! OPPONENT REF(PLAYER).!---
         ! !     DETACH           !  LSC->!     DETACH           !
 LSC,PSC ->! L:  PLAY             !       ! L:  PLAY             !
           !     RESUME(OPPONENT) !       !     RESUME(OPPONENT) !
           !     GOTO L           !       !     GOTO L           !
           ------------------------       ------------------------

The PSC coincides with the LSC of the currently active component.

After P1 has played, P2 is resumed and the new snapshot is:


                            -----------------
                         ---!---. MB !      !
                         !  -----------------
                         !  !  ..........   !
                         !  !               !
                  LSC    -->!  RESUME(P1)   !
                            !               !
                            !  ..........   !
                            -----------------
                   
                   
       -----------------------             -----------------------
    ---!------.   !    MB    !          ---!------.   !   MB     !
    !  -----------------------          !  -----------------------
    !  !     ..........      !          !  !     ..........      !
    !  ! L: play             !  LSC,PSC -->! L: PLAY             !
LSC -->!    RESUME(OPPONENT) !             !    RESUME(OPPONENT) !
       !    GOTO L           !             !    GOTO L           !
       -----------------------             -----------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 194
CHAPTER 3.1


Note that there are three components here with LSC's:  the two players
and  the  program  block.   The  current  state  of the two objects is
"detached" - when they are program components with LSC's.  When  their
actions  are exhausted, they lose their LSC's and become "terminated".
Control returns to the main program block and continues from its  LSC.
Only a "detached" object may be resumed.

One  question  remains:   how  to  transfer  control   back   to   the
(unreferenced) main program block without terminating an object.  This
is achieved by a further call on DETACH.

In addition to sequencing PROCEDURES, "DETACH" and "RESUME", there  is
the  PROCEDURE  CALL which has one reference parameter which must be a
reference to a detached object.

The execution of CALL(Y) from within a  block  X,  will  "attach"  the
detached object Y to X and continue execution of the actions of Y.

The detailed description of program sequencing given in the "SIMULA 67
Common  Base  Language"  is  not repeated here.  Further enquiries are
directed to that document.

Semaphore variables to  control  critical  regions  are  normally  not
necessary  in  SIMULA,  since  control is only passed between parallel
processes by explicit commands.  However, it is very easy  to  program
semaphore variables as a CLASS semaphore.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 195
CHAPTER 3.2


3.2  THE SYSTEM CLASS SIMSET
     -----------------------

List processing concepts and list manipulating procedures are declared
in  the system classes within the CLASS SIMSET.  SIMSET can be used as
a block prefix or as a prefix to another CLASS at  one  and  only  one
block level in a program.

In SIMSET are provided the concepts  for  manipulating  two-way  lists
called  "sets".   Besides  the set members which carry information and
are prefixed by LINK, a set also  has  a  HEAD  which  has  attributes
giving  global  information  about  the set (e.g., how many members it
has).

A set is organised on the basis of references SUC and PRED  which  are
common to LINK and HEAD.


       ------------
H ---->! . SUC    !  SET HEAD
       ! !        !
       ! ! PRED .-!-------------------
       --!---------                  !
         !                           !
     !----                           !
     V                               !
-----------     -----------     -----------
! SUC .---!---->! SUC .---!---->! SUC     !       SET MEMBERS
!         !     !         !     !         !       PREFIXED BY
!   PRED  !<----!-. PRED  !<----!-. PRED  !       LINK
-----------     -----------     -----------


To protect the user from certain kinds of error, SUC and PRED are made
REF(LINK) PROCEDURES and so may not be assigned to.

The part common to both HEAD and LINK is declared separately in  CLASS
LINKAGE which is then used as a prefix to HEAD and LINK.

A skeleton of the CLASS SIMSET is thus

     CLASS SIMSET;
     BEGIN  CLASS LINKAGE............;
            LINKAGE CLASS LINK.......;
            LINKAGE CLASS HEAD.......;
     END ***SIMSET***

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 196
CHAPTER 3.2


This hierarchy may be pictorially represented by:

                        --------
                        ! PREV !
                        --------
                        ! SUC  !
                        --------
                        ! PRED !
         ------------------------------------
         !              LINKAGE             !
         !                                  !
         !                                  !
         !                                  !
         V                                  V
    ------------                         -----------
    ! FIRST    !                         ! OUT     !
    ! LAST     !                         ! INTO    !
    ! EMPTY    !                         ! PRECEDE !
    ! CARDINAL !                         ! FOLLOW  !
    ! CLEAR    !                         -----------
    ------------
                                             LINK
       HEAD


in which the procedures local to each of the classes  are  denoted  by
their identifiers.

An outline of the individual  classes  is  now  given  containing  the
procedure-headings   and   a   prose  description  of  their  actions.
Throughout  the  prose   descriptions   which   are   illustrated   by
representative calls, we assume that the declarations

          REF(HEAD)HD;
          REF(LINK)LK;
          REF(LINKAGE)LG;

are valid.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 197
CHAPTER 3.2


CLASS LINKAGE
-------------

          CLASS LINKAGE;
          BEGIN  REF(LINK) PROCEDURE SUC;.....;
                 REF(LINK) PROCEDURE PRED;....;
                 REF(LINKAGE) PROCEDURE PREV;.;
          END ***OF LINKAGE*** ;


REF(LINK) PROCEDURE SUC;.....;

LK.SUC              returns a reference to the succeeding  set  member
                    if  LK  is in a set, and LK is not the last member
                    of the set, otherwise it returns NONE.

HD.SUC              returns a reference to the first set member if the
                    set is not empty, otherwise NONE.


REF(LINK) PROCEDURE PRED;....;

LK.PRED             returns a reference to the preceding set member if
                    LK  is  in a set and LK is not the first member of
                    the set, otherwise NONE.

HD.PRED             returns a reference to the last set member if  the
                    set is not empty, otherwise NONE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 198
CHAPTER 3.2


REF(LINKAGE) PROCEDURE PREV;....;

LK.PREV             returns NONE if LK is not in a set, a reference to
                    the  set  head  if  LK  is  first member of a set,
                    otherwise  it  returns   a   reference   to   LK's
                    predecessor.

HD.PREV             returns  a  reference  to  HD  if  HD  is   empty,
                    otherwise  a  reference  to the last member of the
                    set with head HD.

                                 NOTE

               By following PREV it is possible to give
               a  reference  to  the  head  of a set in
               which a LINK  object  is  a  member,  as
               shown  in  the  following procedure (not
               local to LINKAGE, LINK or HEAD).

          REF(HEAD) PROCEDURE THESETHEADOF(LK); REF(LINK)LK;
          BEGIN  REF(LINKAGE)X;
                 IF LK =/= NONE THEN
                 BEGIN X :- LK.PREV;
                       WHILE X IN LINK DO
                             X :- X.PREV;
                       THESETHEADOF :- X;
                 END;
          END ***THESETHEADOF***
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 199
CHAPTER 3.2


CLASS HEAD
----------


          LINKAGE CLASS HEAD;
          BEGIN  PROCEDURE CLEAR;................;
                 REF(LINK) PROCEDURE FIRST;......;
                 REF(LINK) PROCEDURE LAST;.......;
                 BOOLEAN PROCEDURE EMPTY;........;
                 INTEGER PROCEDURE CARDINAL;.....;
          END ***OF HEAD***


REF(LINK) PROCEDURE FIRST;.....;

HD.FIRST            is equivalent to HD.SUC


REF(LINK) PROCEDURE LAST;.....;

HD.LAST             is equivalent to HD.PRED


BOOLEAN PROCEDURE EMPTY;.....;

HD.EMPTY            returns TRUE  if  HD  references  a  set  with  no
                    members,  FALSE if HD references a set with one or
                    more members.


INTEGER PROCEDURE CARDINAL;.....;

HD.CARDINAL         returns how many members the set HD contains (0 if
                    HD is empty).


PROCEDURE CLEAR;.....;

HD.CLEAR            removes all members from the set, making it empty.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 200
CHAPTER 3.2


CLASS LINK
----------

          LINKAGE CLASS LINK;
          BEGIN  PROCEDURE OUT;..........;
                 PROCEDURE INTO(H); REF(HEAD)H;..........;
                 PROCEDURE PRECEDE(X); REF(LINKAGE)X;....;
                 PROCEDURE FOLLOW(X); REF(LINKAGE)X;.....;
          END ***OF LINK***


PROCEDURE OUT;.....;

LK.OUT              removes LK from a set and re-establishes the  SUC,
                    PRED    connections    between    its   previously
                    neighbouring members.  If LK was not a set member,
                    no action is taken.


PROCEDURE INTO(H);  REF(HEAD)H;......;

LK.INTO(HD)         LK.OUT is called first.  If HD == NONE  no  action
                    is taken.  If HD =/= NONE, LK goes into the set HD
                    as the new last member.


PROCEDURE PRECEDE(X);  REF(LINKAGE)X;......;

LK.PRECEDE(LG)      LK.OUT is called first.  If LG == NONE or  is  not
                    in  a  set  then  no action is taken, otherwise LK
                    goes into the same set as LG as  the  new  LG.PRED
                    (LG may reference either a HEAD or a LINK object).


PROCEDURE FOLLOW(X);  REF(LINKAGE)X;......;

LK.FOLLOW(LG)       as PRECEDE except that LK becomes the new LG.SUC

The use of reference variables and the fact  that  an  object  of  any
CLASS  inner to CLASS LINK may be inserted in a set give the following
desirable features:

1)  ordered sets can be manipulated by efficient standard procedures

2)  both  the  successor  and  predecessor  of  a  LINK   object   are
    immediately accessible

3)  the set members can be objects of different classes.

Note that a LINK object can only be in one set at a time.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 201
CHAPTER 3.2


Example on the use of SIMSET
----------------------------

The example is concerned with the dealing of a hand of cards, 13 cards
each  in  rotation,  to  a  table  of  four players.  It shows how the
concepts HEAD and LINK of SIMSET may be used as a platform upon  which
to build more general concepts.

The patterns to be described are

          CLASS CARD
          CLASS DECK
          CLASS HAND

Initially the CARD objects are created and inserted into a DECK in the
order  of  their generation (which is non-random).  Skeletons of these
two CLASSES are

     LINK CLASS CARD(COLOUR,RANK);  INTEGER COLOUR, RANK;
     BEGIN.......................................... END;
     HEAD CLASS DECK;
     BEGIN .....  END;

Immediately prior to the dealing, the situation may be represented by

                         --------
  CARDDECK--->        ---! HEAD !-------------------
                      !  --------                  !
                      !  ! DECK !                  !
                      !  --------                  !
                      !                            !
                      !                            !
                      !                            !
                      V                            V
           ------------<-->------------<- ... ->------------
CARD       !  LINK    !   !  LINK    !          !  LINK    !
           ------------   ------------          ------------
OBJECTS    ! COLOUR 1 !   ! COLOUR 2 !          ! COLOUR 4 !
           !  RANK  1 !   !  RANK  1 !          !  RANK 13 !
           ------------   ------------          ------------


A deal consists of removing the 52 cards in random order from CARDDECK
and inserting them into the HANDS in rotation.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 202
CHAPTER 3.2


It is convenient to describe each HAND by

          CLASS HAND;
          BEGIN  REF(HEAD) ARRAY SUIT[1:4];
                 generate four heads representing the four
                      possible suits;
          END ***HAND***

After generation and the dealing of the CARDS, a HAND  object  can  be
visualised by:

          -----------    --- --- --- ---
          ! SUIT[1] !--->! ! ! ! ! ! ! !          4 CLUBS
          !         !    --- --- --- ---
          -----------    --- --- ---
          ! SUIT[2] !--->! ! ! ! ! !              3 DIAMONDS
          !         !    --- --- ---
          -----------    --- ---
          ! SUIT[3] !--->! ! ! !                  2 HEARTS
          !         !    --- ---
          -----------    --- --- --- ---
          ! SUIT[4] !--->! ! ! ! ! ! ! !          4 SPADES
          !         !    --- --- --- ---
          -----------


Now the CARDS may be ranked in order of their attribute  RANK  and  in
the appropriate SUIT.  The actions of the program are:

          Generate the deck;
          Deal the hands;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 203
CHAPTER 3.2


Generate the deck
-----------------

These actions may be made local to  CLASS  DECK,  which  now  has  the
outline

          HEAD CLASS DECK;
          BEGIN  INTEGER I,J;
                 FOR J := 1 through 13 DO
                     FOR I := 1 through 4 DO
                         NEW CARD(I,J).INTO(THIS HEAD)
          END ***DECK***

On generation of a DECK object, the representation  of  the  CARDS  is
automatically generated.



Deal the hands
--------------

This part consists of randomly selecting the Nth card and  placing  it
in the appropriate SUIT of the current PLAYER.  Let J denote the index
of the current PLAYER (J = 1,2,3 or 4), then the actions are:

          J := 0;
          FOR I := 52 STEP -1 UNTIL 1 DO
          BEGIN  C :- the randomly selected card;
                 IF J = 4 THEN J := 1 ELSE J := J + 1;
                 COMMENT ***SELECT INDEX OF CURRENT PLAYER*** ;
                 place C in PLAYER(J)
          END;

There remains the tasks of writing the selection  procedure,  and  the
procedure  to place the CARD C in the current HAND.  These are done by
PROCEDURE SELECT local to CLASS DECK  and  PROCEDURE  PLACE  local  to
CLASS HAND.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 204
CHAPTER 3.2


The final program is:

SIMSET
BEGIN  HEAD CLASS DECK;
       BEGIN  REF(CARD) PROCEDURE SELECT(N); INTEGER N;
              BEGIN  REF(CARD)X; INTEGER I;
                     X :- FIRST QUA CARD;
                     FOR I := 2 STEP 1 UNTIL N DO
                         X :- X.SUC;
                     SELECT :- X;
              END ***SELECT*** ;
              INTEGER I,J;
              FOR I := 1 STEP 1 UNTIL 13 DO
                  FOR J := 1 STEP 1 UNTIL 4 DO
                     NEW CARD(J,I).INTO(THIS HEAD);
       END ***DECK*** ;

       LINK CLASS CARD(COLOUR,RANK); INTEGER COLOUR, RANK;;
       COMMENT ***COLOUR = 1  REPRESENTS CLUBS
                           2  REPRESENTS DIAMONDS
                           3  REPRESENTS HEARTS
                           4  REPRESENTS SPADES
                    RANK = 1  REPRESENTS ACE
                          2-10  OBVIOUS
                          11  JACK
                          12  QUEEN
                          13  KING*** ;

CLASS HAND;
BEGIN  PROCEDURE PLACE(C); REF(CARD)C;
       BEGIN  REF(HEAD)S; REF(CARD)X;
              S :- SUIT[C.COLOUR];
              IF NOT S.EMPTY THEN
              BEGIN  X :- S.FIRST QUA CARD;
                     WHILE X =/= NONE DO
                     BEGIN  IF X.RANK > C.RANK THEN
                               BEGIN  C.PRECEDE(X);
                                      GOTO L;
                               END;
                               X:- X.SUC;
                     END;
              END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 205
CHAPTER 3.2


              COMMENT ***WE ENTER HERE IF S IS EMPTY OR
                         IF C.RANK IS THE HIGHEST MET
                         SO FAR*** ;
              C.INTO(S);
  L:   END ***PLACE*** ;

       REF(HEAD) ARRAY SUIT[1:4];
       SUIT[1] :- NEW HEAD;
       SUIT[2] :- NEW HEAD;
       SUIT[3] :- NEW HEAD;
       SUIT[4] :- NEW HEAD;
END ***HAND*** ;

       REF (CARD) C;
       REF (DECK) CARDDECK;
       INTEGER I,J,U;
       REF(HAND) ARRAY PLAYER[1:4];
       U := ININT; COMMENT ***INPUT THE RANDOM STREAM BASE*** ;
       CARDDECK :- NEW DECK;
       COMMENT ***GENERATES THE WHOLE PACK OF 52 CARDS IN
                       NON-RANDOM ORDER***;
       FOR I := 1 STEP 1 UNTIL 4 DO
           PLAYER[I] :- NEW HAND;
       FOR I := 52 STEP -1 UNTIL 1 DO
       BEGIN  C :- CARDDECK.SELECT(RANDINT(1,I,U));
              IF J = 4 THEN J := 1 ELSE J := J + 1;
              PLAYER[J].PLACE(C);
       END;
END ***PROGRAM***
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 206
CHAPTER 3.3


3.3  THE SYSTEM CLASS SIMULATION
     ---------------------------

The CLASS SIMULATION is prefixed by SIMSET and provides,  in  addition
to  SIMSET's  set  concepts,  the notions of a time axis and processes
(entities which interact over a period of time).

The time axis consists of a  set  of  event  notices  which  have  two
attributes,  a  reference to the PROCESS they represent (PROC) and the
time of its next scheduled event  (EVTIME).   The  event  notices  are
ranked  according to the values of the time variable (EVTIME).  We can
picture the time axis with four scheduled events by:


        **************   ***************   ***************   ***************
EVENT   * EVTIME 5.0 *   * EVTIME 10.0 *   * EVTIME 11.0 *   * EVTIME 11.0 *
NOTICES * PROC   .   *   * PROC   .    *   *  PROC   .   *   * PROC   .    *
        **************   ***************   ***************   ***************
                 !                !                  !                !
                 !                !                  !                !
                 V                V                  V                V
        **************   ***************   ***************   ***************
      --*-- .  *     * --*-- .  *      * --*-- .  *      * --*-- .  *      *
      ! ************** ! *************** ! *************** ! ***************
      ! *            * ! *             * ! *             * ! *             *
      ! *            * ! * L: DETACH;  * ! *             * ! *             *
      ->*            * ->*  GOTO L;    * ->*             * ->*             *
        *            *   *             *   *             *   *             *
        **************   ***************   ***************   ***************
               ^                 ^
               !                 !
               !                 !
            CURRENT            MAIN


The first PROCESS represented in the time axis is always referenced by
CURRENT  and  the system time is the value of its scheduled next event
(here 5.0).  An object of any class prefixed by PROCESS  may  take  an
active  and  passive  part  in  a  simulation.  The organization is so
framed that the PSC lies within CURRENT and its actions are  executed.
When  the  active phase if over, that PROCESS may be rescheduled for a
later active phase (for example, by REACTIVATE  or  HOLD)  or  removed
from  the  timing  tree  (by  PASSIVATE or WAIT).  It is apparent that
RESUME is  too  primitive  for  this  purpose  since  rescheduling  or
removing  EVENT  NOTICES is involved as well as switching the PSC from
one PROCESS object to another.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 207
CHAPTER 3.3


However, RESUME and DETACH  do  form  the  basis  for  the  scheduling
procedures.   To  prevent  the  user  from destroying system security,
event notices may not be explicitly referenced by the user -  he  must
use   the  system  procedures  for  scheduling  or  rescheduling.   In
addition, it is strongly recommended that explicit  use  of  "DETACH",
"RESUME" and "CALL" be avoided within a SIMULATION block.

There is one special PROCESS object which plays  a  key  role  in  any
SIMULATION  -  one referenced by MAIN.  Whenever MAIN becomes CURRENT,
it causes the actions of the SIMULATION block itself to be  continued.
The corresponding event notice can then be rescheduled (typically by a
call on HOLD) and then the action switches from the  SIMULATION  block
to  the new CURRENT.  Thus the SIMULATION block is itself treated as a
program component during the SIMULATION.

The class outline is

     SIMSET CLASS SIMULATION;
     BEGIN  LINK CLASS PROCESS.....;
            REF(PROCESS) PROCEDURE CURRENT;.....;
            REAL PROCEDURE TIME;.....;
            COMMENT ***SCHEDULING PROCEDURES*** ;
            PROCEDURE HOLD;.......;
            PROCEDURE PASSIVATE;..;
            PROCEDURE WAIT;.......;
            PROCEDURE CANCEL;.....;
            PROCEDURE ACTIVATE;...;
            PROCEDURE ACCUM;......;
            REF("the main program")MAIN;
            COMMENT ***HERE FOLLOW ACTIONS WHICH SET UP THE
                       TIME AXIS AT TIME ZERO*** ;
     END ***SIMULATION***


We now give a prose discussion of the attributes of CLASS SIMULATION:
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 208
CHAPTER 3.3


CLASS PROCESS
-------------

     LINK CLASS PROCESS;
     BEGIN  BOOLEAN PROCEDURE IDLE;..........;
            BOOLEAN PROCEDURE TERMINATED;....;
            REAL PROCEDURE EVTIME;...........;
            REF(PROCESS) PROCEDURE NEXTEV;...;
            DETACH;
            INNER;
            PASSIVATE;
     END ***PROCESS***

An object of a class inner to CLASS PROCESS is a  PROCESS  object.   A
PROCESS object has the properties of CLASS LINK and can be manipulated
by sequencing statements.  Sequencing statements are used to insert or
delete  a  PROCESS  object from the time axis.  The state of a PROCESS
object after generation is "detached" and its LSC is positioned to the
first statement of the user defined operations rule.  When the actions
of the user defined subclass are exhausted, the unfinished actions  of
the  PROCESS  level are continued (following the INNER).  These remove
the object from the  time  axis  (PASSIVATE)  and  its  state  becomes
"terminated".

If a PROCESS object is not represented in the time axis,  then  it  is
terminated  or  passive  (its  actions  are not yet exhausted) and the
BOOLEAN PROCEDURE IDLE returns TRUE.  All PROCESS objects  represented
in  the  time  axis  are  said  to  be  suspended except for the first
(CURRENT) which is said to be active.

A call on EVTIME for a suspended or active PROCESS object returns  the
scheduled  time  of  its  next  event.   If  the  object is passive or
terminated, then a call on EVTIME results in a run time error.

-----------------------------------------------------------
!  PROCESS   !                                            !
!  object    !  result of procedure call                  !
-----------------------------------------------------------
!   state    ! IDLE  ! TERMINATED ! EVTIME                !
-----------------------------------------------------------
! active     ! FALSE !  FALSE     ! time of current event !
! suspended  ! FALSE !  FALSE     ! time of next event    !
! passive    ! TRUE  !  FALSE     ! run time error        !
! terminated ! TRUE  !  TRUE      ! run time error        !
-----------------------------------------------------------
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 209
CHAPTER 3.3


REF(PROCESS) PROCEDURE CURRENT;......;
                    returns  a  reference  to  the  currently   active
                    PROCESS  object.   There  is  one  special PROCESS
                    object in the system referenced  by  MAIN.   Every
                    time MAIN becomes CURRENT it causes the actions of
                    the SIMULATION block to be resumed.


REAL PROCEDURE TIME;.....;
                    always returns the current  value  of  the  system
                    time.


PROCEDURE HOLD(T);  REAL T;......;
                    HOLD(N)  reschedules  CURRENT  so  that  its  next
                    active phase will occur at TIME + N.  If the value
                    of the actual parameter N is negative, the call is
                    equivalent  to  HOLD(0).   After the rescheduling,
                    the actions of CURRENT are resumed.

                    Notice that HOLD(T) can be called  from  the  user
                    defined  SIMULATION  block in which case MAIN will
                    be rescheduled - i.e., the actions of the  program
                    block are suspended for N time units.


PROCEDURE PASSIVATE;......;
                    removes CURRENT from the time axis and resumes the
                    actions of the new CURRENT.  A run time error will
                    occur if the time axis is now empty.


PROCEDURE WAIT(S);  REF(HEAD)S;......;

                    PROCEDURE WAIT(S);  REF(HEAD)S;
                    BEGIN CURRENT.INTO(S);
                           PASSIVATE
                    END ***WAIT***

                    WAIT includes the currently active PROCESS  object
                    (this  could  be  MAIN) into a referenced set, and
                    then calls PASSIVATE.


PROCEDURE CANCEL(X);  REF(PROCESS)X;......;
                    CANCEL(P) where P is  a  reference  to  a  PROCESS
                    object  will delete the corresponding event notice
                    if any.  If P is currently active or suspended, it
                    thus  becomes  passive.   If P is a reference to a
                    passive or  terminated  PROCESS  object  or  NONE,
                    CANCEL(P)  has no effect.  Thus CANCEL(CURRENT) is
                    equivalent to PASSIVATE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 210
CHAPTER 3.3


PROCEDURE ACTIVATE
------------------

For user convenience, calls on the procedure ACTIVATE are  written  in
terms of the corresponding activation-statements.



activation-statement
--------------------

 **          **                       **                      **
 * ACTIVATE   *                       * [AT/DELAY time][PRIOR] *
**            ** PROCESS-expression1 ** [BEFORE/AFTER]PROCESS  **
 * REACTIVATE *                       *            expression2 *
 **          **                       **                      **


Let X be the value of PROCESS-expression1.  If the activator  ACTIVATE
is used, then the activation-statement will have no effect (other than
evaluating X) unless X is passive.  If  the  activator  REACTIVATE  is
used,  then  X  may  be active, suspended, or passive (in which latter
case, the activation-statement acts as an ACTIVATE statement).

The type of scheduling is determined by the  form  of  the  activation
statement.



Direct activation
-----------------

           **            **
           * ACTIVATE X   *
          ** REACTIVATE X **
           *              *
           **            **

X becomes the new CURRENT and  the  system  time  is  unchanged.   The
formerly  active  PROCESS  object from where the call was made becomes
suspended.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 211
CHAPTER 3.3


Timing clause
-------------

 **          **     **     **
 *ACTIVATE    *     *  AT   *
**            ** X **       **  T    [PRIOR] 
 * REACTIVATE *     * DELAY *
 **          **     **     **

The timing clause AT specifies the system time of the scheduled active
phase.  The clause

     DELAY T

is equivalent to

     AT current-system-time + T

The corresponding EVENT NOTICE is inserted according to the  specified
time,  normally after any EVENT NOTICE with the same system time;  the
symbol PRIOR may be used to specify insertion in front  of  any  EVENT
NOTICE with the same system time.



Default actions
---------------

"AT T", when  T  <  the  current-system-time,  is  equivalent  to  "AT
current-system-time".

DELAY T when T < 0 is equivalent to DELAY 0.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 212
CHAPTER 3.3


Relative activation
-------------------

      **          **       **      **
      * ACTIVATE   *       * BEFORE *
     **            **  X  **        **   Y
      * REACTIVATE *       * AFTER  *
      **          **       **      **


If Y is a reference to an active or suspended PROCESS object, then the
clause  BEFORE  Y  or  AFTER Y is used to insert an event notice for X
before or after that of Y and at the same system time.



Default actions
---------------

If Y is neither active nor suspended, then the activation-statement is
equivalent to

     CANCEL(X).

If X == Y, then the activation-statement is equivalent to

     CANCEL(X).



PROCEDURE ACCUM
---------------

     PROCEDURE ACCUM(A,B,C,D); NAME A,B,C; REAL A,B,C,D;
     BEGIN  A := A + C*(TIME-B);
            B := TIME;
            C := C + D
     END ***ACCUM***

ACCUM(P,Q,R,S) is used to accumulate the "system time integral" of the
variable  R.   The  accumulation  takes  place  in P.  The integral is
interpreted as a step function of the system time with Q  holding  the
system  time  when  P was last updated.  The value of S is the current
increment of the step function.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 213
CHAPTER 3.3


Before
------


         ^
         !
         !  
       --!--
   S     !
       --!--
         !
         !
         !
         !
         !
         !                     ------------  **
         !                     !//////////!   *
         !           ----------!//////////!   *
         !           !/////////!//////////!   **  R
         !-----------!/////////!//////////!   *
         !///////////!/////////!//////////!   *
         !///////////!/////////!//////////!  **
         ---------------------------------.--------------->
                                          ^
                                          !
                                          Q             time
                                        TIME
After a call on ACCUM(P,Q,R,S) we have


^
!
!
!
!
!
!                                ------------  **
!                                !//////////!   *
!                     -----------!//////////!   *
!                     !//////////!//////////!   *
!          -----------!//////////!//////////!   **  R
!          !//////////!//////////!//////////!   *
!----------!//////////!//////////!//////////!   *
!//////////!//////////!//////////!//////////!   *
!//////////!//////////!//////////!//////////!  **
--------------------------------------------.------------>
                                            ^
                                            !
                                            Q
                                          TIME


P contains result so far (shaded area).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 214
CHAPTER 3.3


Example on the use of SIMULATION
--------------------------------

The  program  is  a  description  of  a  simple  epidemic  model.    A
contagious,  non-lethal disease is spreading through a POPULATION of a
fixed size.  Certain countermeasures are  taken  by  a  public  health
organization.   Each  individual  infection  has  a  given  INCUBATION
period, during which the subject is noncontagious and has no SYMPTOMS,
followed by a contagious period of a given LENGTH.

                     COURSE OF INFECTION IN DAYS

            *                *            *            *
            *   INCUBATION   *   LENGTH   * thereafter *
            ********************************************
              NON-CONTAGIOUS   CONTAGIOUS     IMMUNE

Each DAY of the contagious period the subject may seek TREATMENT  from
the  public health organisation and get cured.  The probability of his
seeking treatment is stored in REAL ARRAY PROBTREAT [1:LENGTH].   Each
person  has  an  expected  number  of  CONTACTS  per day.  At one such
contact the probability of infecting a previously uninfected person is
PROBINFECT.

Once cured a person  becomes  immune.   If  untreated,  the  infection
ceases after the given period and the person becomes immune.

SICKP (sick persons) appear as PROCESSes in the system.   When  CURED,
or  when  the  disease has run its course, they leave the system.  The
very first infection is generated by the main program (user block).  A
person  infected  by  another  person is included as a member in a set
belonging to the infector (his environment (ENV)).  A person can be  a
member of at most one set.

As people are cured, they are removed from these sets which  gradually
split   up   into   smaller  sets.   The  latter  grow  independently,
disintegrate further, and so on.  As the number of  UNINFECTED  people
decreases,  the  growth  of  the contagion slows down until it finally
dies out.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 215
CHAPTER 3.3


The public countermeasures are represented  by  TREATMENTs  which  are
also  PROCESSes.   A  patient  is  removed from the environment set to
which he belongs, if any.  If he has visible symptoms,  he  is  cured.
In  addition  his environment is searched and each member is subjected
to a full treatment which may cause other environments to be  searched
etc.  A patient displaying no symptoms is given a mass treatment which
has a  probability  PROBMASS  of  success.   His  environment  is  not
searched.   In the present model, treatments act instantaneously.  The
simulation ends after SIMPERIOD units of time.

An outline of the problem description is

     SIMULATION
     BEGIN  PROCESS CLASS SICKP;
            BEGIN  REF(HEAD)ENV;
                   PROCEDURE INFECT;
                   ......
            END ***SICK PERSON*** ;
            PROCESS CLASS TREATMENT(PATIENT);
                          REF(SICKP)PATIENT;
            BEGIN ...................... END;
            ..........
     END ***SIMULATION BLOCK*** ;


We may now outline the class actions

     PROCESS CLASS SICKP;
     BEGIN  PROCEDURE INFECT;......;
            INTEGER TODAY; BOOLEAN SYMPTOMS;
            REF(HEAD)ENV;
            COMMENT ***wait incubation days for symptoms to
                       appear*** ;
            HOLD(incubation period);
            COMMENT ***now the symptoms are apparent.  If
                       "treatment today" is TRUE then a cure
                       is sought which also implies that the
                       environment of this SICK PERSON is
                       examined.  Also a number of contacts
                       are infected*** ;
            SYMPTOMS := TRUE;
            FOR TODAY := 1 through LENGTH DO
            BEGIN
                       IF treatment today THEN ACTIVATE NEW TREATMENT;
                       INFECT(todays contacts);
                       HOLD(1);
            END;
     END ***SICK PERSON*** ;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 216
CHAPTER 3.3


PROCEDURE INFECT(N); INTEGER N;

     BEGIN  INTEGER I;
            COMMENT ***N gives the number of contacts who can
                       be infected.  N random drawings are made
                       to see if the N contacts are to be infected.
                       If so a NEW SICKP is generated
                       and included in this SICKPs ENV and
                       activated*** ;
            FOR I := 1 through N DO
                IF Ith contact is infected THEN
                BEGIN  NEW SICKP.INTO(ENV);
                       ACTIVATE ENV.LAST;
                END;
     END ***INFECT***


PROCESS CLASS TREATMENT(PATIENT); REF(SICKP)PATIENT;
BEGIN  REF(SICKP)X;
       INSPECT PATIENT WHEN SICKP DO
       BEGIN  OUT;
              IF SYMPTOMS THEN
              BEGIN  CANCEL(PATIENT);
                     FOR X :- ENV.FIRST WHILE X =/= NONE DO
                         ACTIVATE NEW TREATMENT(X);
              END ELSE IF mass treatment successful
                          THEN CANCEL(PATIENT)
       END;
END ***TREATMENT***
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 217
CHAPTER 3.3


Explanation:
------------

A treatment tests the SYMPTOMS attribute of its parameter PATIENT.  If
TRUE  then  the  instantaneous  successful  treatment  is  given.  The
patient is removed from the set he is in (OUT) and becomes passive for
the  rest  of the simulation.  In addition his environment is searched
and a new treatment is activated for each member.   If  there  are  no
symptoms, the patient is given a cheap pill which has a probability of
being successful.  If successful the patient is instantaneously  cured
and  takes  no  further part in the simulation, but his environment is
not searched.

A complete description of the program now follows:

BEGIN   INTEGER POPULATION, LENGTH, CONTACTS, INCUBATION,
    UNINFECTED, U1, U2, U3, U4, I, NSICK;
    REAL PROBINFECT, PROBMASS, SIMPERIOD;
    COMMENT ***THE RANDOM STREAM BASES ARE READ IN*** ;
    U1 := ININT; U2 := ININT;
    U3 := ININT; U4 := ININT;
    UNINFECTED:= POPULATION := ININT;
    INCUBATION := ININT; LENGTH := ININT;
    CONTACTS := ININT;
    SIMPERIOD := INREAL;
    PROBINFECT := INREAL; PROBMASS := INREAL;
    SIMULATION BEGIN  REAL ARRAY PROBTREAT[1:LENGTH];

        BOOLEAN PROCEDURE THISPERSONCAUGHTIT;
        THISPERSONCAUGHTIT:=
        DRAW(PROBINFECT*UNINFECTED/POPULATION,U3);

        BOOLEAN PROCEDURE TREATED(DAY);
        INTEGER DAY;
        TREATED:= DRAW(PROBTREAT[DAY],U1);

        BOOLEAN PROCEDURE
        MASSTREATMENTSUCCESSFULL;
        MASSTREATMENTSUCCESSFULL:=
        DRAW(PROBMASS,U4);

        PROCESS CLASS SICKP;
        BEGIN  INTEGER TODAY;
            BOOLEAN SYMPTOMS;
            REF(HEAD)ENV;
            PROCEDURE INFECT(N); INTEGER N;
            BEGIN  INTEGER J;
                FOR J := 1 STEP 1 UNTIL N DO
                IF  THISPERSONCAUGHTIT
                THEN
                BEGIN  NEW SICKP.INTO(ENV);
                    ACTIVATE ENV.LAST;
                END;
            END ***INFECT*** ;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 218
CHAPTER 3.3


            NSICK:= NSICK + 1;
            IF UNINFECTED > 0 THEN
            UNINFECTED := UNINFECTED-1;
            ENV :- NEW HEAD;
            COMMENT ***NO SYMPTOMS APPEAR UNTIL
            AFTER INCUBATION DAYS***
            ;
            HOLD(INCUBATION); SYMPTOMS := TRUE;
            COMMENT ***NOW SYMPTOMS APPEAR AND
            THIS SICK PERSON MAY SEEK A
            CURE AND INFECT OTHERS EACH
            DAY*** ;
            FOR TODAY := 1 STEP 1 UNTIL LENGTH DO
            BEGIN  IF TREATED(TODAY) THEN
                ACTIVATE NEW TREATMENT(CURRENT);
                INFECT(POISSON(CONTACTS,U2));
                HOLD(1)
            END;
            NSICK:= NSICK - 1;
        END ***SICK PERSON*** ;

        PROCESS CLASS TREATMENT(PATIENT);
        REF(SICKP)PATIENT;
        BEGIN  REF(SICKP)X;
            INSPECT PATIENT WHEN SICKP DO
            BEGIN  OUT;
                IF SYMPTOMS THEN
                BEGIN  CANCEL(PATIENT);
                    NSICK:= NSICK - 1;
                    FOR X :- ENV.FIRST WHILE X =/= NONE DO
                    ACTIVATE NEW TREATMENT(X);
                END ELSE IF MASSTREATMENTSUCCESSFULL
                THEN
                BEGIN   NSICK:= NSICK - 1;
                    CANCEL(PATIENT);
                END;
            END;
        END ***TREATMENT*** ;

        PROCESS CLASS SPY;
        BEGIN
            WHILE TRUE DO
            BEGIN
                OUTINT(TIME,4);   SETPOS(NSICK+6);
                OUTCHAR('*');   OUTIMAGE;
                HOLD(1);
            END LOOP;
        END ***SPY***;

        ACTIVATE NEW SICKP;
        ACTIVATE NEW SPY DELAY 0;
        FOR I:= 1 STEP 1 UNTIL LENGTH DO
        PROBTREAT[I]:= INREAL;
        HOLD(SIMPERIOD);
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 219
CHAPTER 3.3


    END ***SIMULATION BLOCK*** ;
END ***PROGRAM***


IF SYSIN contains:

1 3 5 7
100 3 7
40 30 0.20 0.1
0.75 0.6 0.5 0.45 0.4 0.4 0.35

The resulting output will be:


   0  *
   1  *
   2  *
   3         *
   4       *
   5       *
   6        *
   7                 *
   8               *
   9                                *
  10                                *
  11                                     *
  12                                        *
  13                               *
  14                              *
  15                          *
  16               *
  17         *
  18      *
  19        *
  20        *
  21       *
  22    *
  23  *
  24    *
  25    *
  26    *
  27 *
  28 *
  29 *
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 220
CHAPTER 3.4


3.4  TEXT HANDLING FACILITIES
     ------------------------

The concept of TEXT is the key to  SIMULA's  input/output  facilities.
For  example  when  a  card is read in, the internal representation is
held as a string of 80 CHARACTERS with a  one  to  one  correspondence
between  the  nth  column  of  the  card  and the nth CHARACTER in the
string.  Such a string is called a TEXT-value and it is  housed  in  a
referenced TEXT-object.

          -------------------------------------------
     T--->!  THIS TEXT VALUE LIES IN A TEXT OBJECT. !
          -------------------------------------------

With TEXTs we have thus  a  combination  of  both  reference  (to  the
housing  object)  and  value  (the  string  of CHARACTERS) properties.
TEXTs resemble objects (of classes) in  that  they  posses  attributes
which  are  accessed  by  the  normal  remote accessing (dot notation)
technique, but TEXTs and their attributes are wholly system defined.

Whereas  a  CHARACTER  ARRAY  is  oriented  towards  accessing  single
characters  by direct means (subscripts), the TEXT concept is oriented
towards groupings  of  characters  and  sequentially  accessing  these
groups.

TEXT variables are declared in the usual fashion.

e.g.     TEXT R,S,T

and the initial value of each of these variables is  NOTEXT,  that  is
the empty string.

TEXT variables are capable of referencing TEXT objects, which  may  be
created by two system defined PROCEDURES - BLANKS and COPY:

          T :- BLANKS(N)

creates a TEXT object of length N characters, each initialised to  the
blank character.  After creation of the object, its reference value is
assigned to T.

          S :- COPY("SIMULA");

          R :- COPY(S)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 221
CHAPTER 3.4


COPY will accept either a TEXT value or a TEXT reference expression as
parameter,  creates  a TEXT object with value identical to that of the
actual parameter and of the same length, and returns  a  reference  to
it.  The result of the last two statements may be pictured by

             -----------------    ----------
     S .---->! 1 ! 1 ! 6 ! .-!--->! SIMULA !
             -----------------    ----------

             -----------------    ----------
     R .---->! 1 ! 1 ! 6 ! .-!--->! SIMULA !
             -----------------    ----------

                 magic box


Each TEXT variable has its own "magic  box"  which  gives  information
about  the  start position (SP), length (LG) and current position (CP)
of the object it currently references.   The  box  also  contains  the
reference  value  of  the  object itself.  The formal pattern of these
magic boxes is:

     --------------------------
     ! SP ! CP ! LG ! ref.val !
     --------------------------


A TEXT object may be referenced in subfields by use of  the  procedure
SUB

After          T :- COPY("SIMULA")

then           S :- T.SUB(5,2)

results in

                  -----------------    ----------
          T .---->! 1 ! 1 ! 6 ! .-!--->! SIMULA !
                  -----------------    ----------
                                             ^
                  -----------------          !
          S .---->! 5 ! 1 ! 2 ! .-!-----------
                  -----------------


S references the subfield of T  beginning  from  character  5  and  of
length 2.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 222
CHAPTER 3.4


The characters may be accessed one at a time by calls on GETCHAR which
returns  the  value  of the current character and increments the CP by
one.

After               C := T.GETCHAR;
                    D := T.GETCHAR

the snapshot is
             -----------------    ----------
     T .---->! 1 ! 3 ! 6 ! .-!--->! SIMULA !
             -----------------    ----------
                                         ^
                                         !
             -----------------           !
     S .---->! 5 ! 1 ! 2 ! .-!------------
             -----------------


and the values of C and D are 'S' and 'I' respectively.  As access was
made through T, only its CP has been incremented (twice).  The reverse
process of inserting a character value into the  current  position  is
achieved through use of PUTCHAR, which also increments the CP.

After               S.PUTCHAR('6);
                    S.PUTCHAR('7)

the snapshot is

             -----------------    ----------
     T .---->! 1 ! 3 ! 6 ! .-!--->! SIMU67 !
             -----------------    ----------
                                        ^
                                        !
             -----------------          !
     S .---->! 5 ! 3 ! 2 ! .-!-----------
             -----------------


Note that the value of T has been changed.  The CP of S is now out  of
range.  A further call

          S.PUTCHAR
or        S.GETCHAR

will result in a run time  error.   To  provide  a  check,  a  BOOLEAN
PROCEDURE  MORE  is  provided  which returns FALSE if the CP is out of
range and TRUE otherwise.  Currently,

          T.MORE = TRUE       S.MORE = FALSE
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 223
CHAPTER 3.4


Other useful system defined procedures are:

LENGTH    which returns the length of the currently
          referenced value
          (T.LENGTH = 6
           S.LENGTH = 2)

POS       which returns the value of the CP
          (T.POS = 3
           S.POS = 3)

SETPOS    which resets the CP.  (To reset the CP's of
          T and S back to their initial character, we write
          T.SETPOS(1)
          S.SETPOS(1) )

Text values may be transferred from one subject to another by

          S := T

or a value into an object by

          S := "TEXT VALUE"

Both are left justified.

The only restriction is that the TEXT object receiving the value  must
be  long  enough  to accept the value or else a run time error occurs.
Any positions not directly copied into are filled with blanks.

Several editing and de-editing procedures are defined  within  SIMULA.
These  convert  numbers  to  external  form  and vice versa.  They are
designed to operate repetitively across a field and are thus  oriented
towards formatted output and input.

The further detailed description of the TEXT  handling  facilities  is
given under the sub-sections

          LENGTH and MAIN
          subtexts
          character access
          text generation
          TEXT assignment
          TEXT editing

Throughout these subsections X, Y, Z denote TEXT references.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 224
CHAPTER 3.4


LENGTH and MAIN
---------------



INTEGER PROCEDURE LENGTH;
-------------------------

The value of X.LENGTH is the number of CHARACTERS in the  TEXT  object
referenced by X.

e.g.      after X :- BLANKS(10), then X.LENGTH = 10
          if Y == NOTEXT,       then Y.LENGTH = 0



TEXT PROCEDURE MAIN;
--------------------

X.MAIN is a reference to the TEXT object which is or contains the text
value referenced by X.

e.g.      after X :- BLANKS(20);
                Y :- X.SUB(1,10);
                Z :- NOTEXT;

          then X.MAIN == X
                Y.MAIN == X
                Z.MAIN == NOTEXT

The following relations hold for any TEXT reference X

          X.MAIN.LENGTH >= X.LENGTH
          X.MAIN.MAIN == X.MAIN
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 225
CHAPTER 3.4


SUBTEXTS
--------



TEXT PROCEDURE SUB(I,N);  INTEGER I,N;
--------------------------------------

The call

          X.SUB(J,M)

designates that part of the TEXT object referneced by  X  starting  in
CHARACTER position J and of length M characters.

e.g.      after X :- COPY("MAIN NOT SUB-TEXT");
                T :- X.SUB(10,8);

          then T = "SUB-TEXT"

For X.SUB(J,M) to be a legal call, the subtext must be included in  X.
Thus

          J > 0
          J + M-1 <= X.LENGTH

If these conditions do not hold a run time error results.



TEXT PROCEDURE STRIP;
---------------------

STRIP is used to return a reference to a subfield  of  a  TEXT  object
which  differs  from  the original in that all blanks on the right are
ignored.  X.STRIP is thus equivalent to X.SUB(1,N) where the remaining
CHARACTERS  of X (from position N+1 and of length X.LENGTH-N), if any,
are all blanks.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 226
CHAPTER 3.4


CHARACTER access
----------------

The CHARACTERS, values housed in a TEXT object, are accessible one  at
a  time.   Any  TEXT  reference  contains a "position indicator" which
identifies the currently accessible CHARACTER of the  referenced  TEXT
object.

The position indicator of NOTEXT is 1.  A TEXT reference  obtained  by
calling  any  system defined TEXT procedure has its position indicator
set to 1.  The position indicator of a given  TEXT  reference  may  be
altered     by    the    PROCEDURES    SETPOS,    GETCHAR,    PUTCHAR,
TEXT-reference-assignment and any  editing  or  de-editing  PROCEDURE.
Position  indicators  are  left unaltered by TEXT reference relations,
TEXT value relations and TEXT value assignments.



INTEGER PROCEDURE POS;
----------------------

X.POS is the current value  of  the  position  indicator  of  X.   The
following relation is always TRUE.

          1 <= X.POS <= X.LENGTH + 1



PROCEDURE SETPOS(I);  INTEGER I;
--------------------------------

The effect of X.SETPOS(M) is to assign the value of M to the  position
indicator  of X, if 1 <= m <= X.LENGTH +1.  If M is out of this range,
then the value X.LENGTH + 1 is assigned.



BOOLEAN PROCEDURE MORE;
-----------------------

X.MORE is TRUE if the position indicator  of  X  is  in  the  range  1
through X.LENGTH, otherwise the value is FALSE.



CHARACTER PROCEDURE GETCHAR;
----------------------------

The value of X.GETCHAR is a copy of the currently accessible CHARACTER
of  X provided X.MORE is TRUE.  In addition, the position indicator of
X is then increased by one.  A run time error results  if  X.MORE  was
FALSE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 227
CHAPTER 3.4


PROCEDURE PUTCHAR(C);  CHARACTER C;
----------------------------------

The effect of X.PUTCHAR(C) is  to  replace  the  currently  accessible
CHARACTER  of  X  by  the value of C provided that X.MORE is TRUE.  In
addition the position indicator of X is then  increased  by  one.   If
X.MORE is FALSE, a run time error results.


Example:
--------

The PROCEDURE COMPRESS rearranges the CHARACTERS of  the  TEXT  object
referenced  by the actual parameter by collecting non-blank CHARACTERS
in the leftmost part of the TEXT object and filling in the  remainder,
if  any, with blanks.  Since the parameter is called by reference (and
not by name), its position indicator is unaltered.

          PROCEDURE COMPRESS(T); TEXT T;
          BEGIN  TEXT U; CHARACTER C;
                 T.SETPOS(1); U :- T;
          MOVELEFT:  WHILE U.MORE DO
                     BEGIN  C := U.GETCHAR;
                            IF C NE ' ' THEN T.PUTCHAR(C);
                     END;
                     COMMENT ***WE NOW FILL IN THE RIGHT WITH
                                BLANKS*** ;
                     T.SUB(T.POS,T.LENGTH-T.POS+1) := NOTEXT;
          END ***COMPRESS***


Note the use of a value assignment to T.SUB, and the use of NOTEXT  on
a right hand side as a neat way of filling a TEXT value to blanks.

After          X :- COPY("GET RID OF ALL BLANKS");
               COMPRESS(X);

THEN           X = "GETRIDOFALLBLANKS    "
               X.STRIP = "GETRIDOFALLBLANKS"
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 228
CHAPTER 3.4


TEXT generation
---------------

N.B.  Procedures BLANKS and COPY are non-local.



TEXT PROCEDURE BLANKS(N); INTEGER N;
------------------------------------

The reference value is a new TEXT object  of  length  N,  filled  with
blank CHARACTERS.

The value of the actual parameter, M, is restricted to

          0 <= M <= 2^18-1 = 262143

otherwise a run time error results.



TEXT PROCEDURE COPY(T); VALUE T; TEXT T;
----------------------------------------

The referenced value is a new TEXT object which is a copy of the  TEXT
value which is (or is referenced by) the actual parameter.

Example:
--------

          T :- COPY("DEC10SIMULA");

is equivalent to,

          T :- BLANKS(11);
          T := "DEC10SIMULA";

There is no explicit statement in SIMULA to delete or  destroy  TEXTs.
TEXTs are automatically removed by the garbage collector when there is
no way to refer to the TEXT any more from the program.  Note  that  as
long  as  there  is  a  way  to  refer from the program to any subtext
(except NOTEXT), the whole main TEXT is kept in  core  (and  available
through the procedure MAIN).  
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 229
CHAPTER 3.4


TEXT assignment
---------------

a)  TEXT-reference-assignment
    -------------------------

A TEXT-reference-assignment causes a copy of the TEXT-reference  (i.e.
the  magic  box  values)  obtained  by evaluating the right part to be
assigned to the left part variable -  this  includes  a  copy  of  its
position indicator.

e.g.      after          X :- COPY("ABCD");
                         X.SETPOS(3);
                         Y :- X;

          then           X.POS = 3
                         Y.POS = 3

In general, after        X :- P;    where P is a TEXT reference,

          then           X == P
                         X = P
                         X.POS = P.POS

are all TRUE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 230
CHAPTER 3.4


b)  TEXT-value-assignment
    ---------------------

Consider the value assignment

          T := P;

let the length of T be Ll, and the right  part  be  a  TEXT  value  of
length Lr.  There are three cases to consider:


Ll = Lr:            the character contents of the right part TEXT  are
                    copied to the left part TEXT

Ll > Lr:            the character  contents  of  the  right  part  are
                    copied into the leftmost Lr characters of the left
                    part TEXT, whose remaining  Ll-Lr  CHARACTERS  are
                    filled with blanks.

Ll < Lr:            a run time error results.


The POS of T (and P) will not be changed.

After     T :- COPY("EIGHT CHARS");
          T := "WRONG:11";

then      T = "WRONG:11   "

Note that

          T := NOTEXT;

is an efficient way to set all the character positions of T to blanks.


In a multiple TEXT value assignment (TA is a TEXT ARRAY)

          T[1] := T[2] := .....  T[N] := P;

then

          TA[J].LENGTH >= TA[J+1].LENGTH
for       J = 1,2,...,N-1 must be true.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 231
CHAPTER 3.4


Variable length TEXTs and TEXT concatenation.
--------------------------------------------

There are two ways in which you can achieve variable length  TEXTs  in
SIMULA.   You can either have variable length TEXTs with a fixed upper
length limit (like VARYING in PL/I), or with no upper limit.

In the first case, you allocate a main  text  with  the  upper  length
limit  as its length.  You can then use subtexts when you want shorter
texts, and you can change length by

          T:- T.MAIN.SUB(1,NEWLENGTH)

If you want no fixed upper limit (except the system limit 262143), you
can   allocate  new  texts  with  the  procedure  BLANKS,  e.g.   "t:-
BLANKS(newlength)".  A concatenation procedure would then for  example
copy the parts into subtexts of t by

          t.SUB(1,PART1.LENGTH):= PART1;
          T.SUB(PART1.LENGTH+1,PART2.LENGTH):= PART2;

(A concatenation procedure will be available  in  the  SIMULA  program
library.  See part III of the DECsystem-10 SIMULA Handbook.)

If you want linking of character  strings  without  copying,  you  can
easily implement this yourself in SIMULA using e.g. SIMSET.  
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 232
CHAPTER 3.4


Text editing and de-editing
---------------------------

TEXT editing and  de-editing  procedures  are  provided  to  transform
binary  values  into  text  strings  and  vice  versa.  The syntax for
numeric-text-values (external data) follows:


numeric-text-value
------------------

      **            **
      * grouped-item *
     ** real-item    **
      * integer-item *
      **            **


grouped-item
------------

     sign-part[[groups].]groups


groups
------

     [digits blank]... digits


real-item
---------

                **                                     **
                * [[digits].]digits[E sign-part digits] *
     sign-part **                                       **
                * E sign-part digits                    *
                **                                     **


integer-item
------------

          sign-part digits
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 233
CHAPTER 3.4


sign-part
---------

     [blank]...  [+-] [blank]...

where 'E' represents an exponent sign.  This CHARACTER may be  altered
by the user by use of the PROCEDURE LOWTEN (see Appendix B).

A numeric-text-value is a character  sequence  subject  to  the  above
rules.



De-editing procedures
---------------------

A de-editing procedure operating on a given TEXT reference X  operates
in the following way:

1)  The longest numeric item of the given form is  located,  contained
    within X and containing the first character of X.  If no such item
    can be found, a run  time  error  results.   Note  that  -  unlike
    GETCHAR  -  GETINT,  GETREAL  and  GETFRAC  always starts from the
    beginning of the text!

2)  The numeric item is interpreted as a number.  If it is outside the
    accepted  range  (see  CHAPTER  2, section 2.5.1) a run time error
    results.

3)  The position indicator of X is made  one  greater  than  the  last
    character of the numeric item.


****************************************************************
* N.B.  Unless otherwise stated, the de-editing procedures are *
*       illustrated in the context:                            *
*                                                              *
*           T :- COPY("1234.5+7.3E4AB");                       *
*           S :- T.SUB(7,6);                                   *
*           R :- T.SUB(5,2);                                   *
****************************************************************
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 234
CHAPTER 3.4


INTEGER PROCEDURE GETINT;
-------------------------

Locates an integer-item.

          T.GETINT = 1234
          S.GETINT = 7
          R.GETINT   causes a run time error



LONG REAL PROCEDURE GETREAL;
----------------------------

locates a real-item

          T.GETREAL = 1234.5
          S.GETREAL = 73000.0
          R.GETREAL = 0.5



INTEGER PROCEDURE GETFRAC;
--------------------------

Locates a grouped item.  In its interpretation, any number  of  single
blanks and one decimal point are ignored and the resulting value is an
INTEGER.

After     T := COPY(1 013.42");

then      T.GETFRAC = 101342



Editing procedures
------------------

Editing procedures in a given  text  reference  X  convert  arithmetic
values to numeric items.  After an editing operation, the numeric item
obtained is right adjusted in the TEXT X preceded by  padding  blanks.
The final value of the position indicator is X.LENGTH+1.

A positive number is edited with no sign.  If X == NOTEXT then  a  run
time error results, otherwise if X is too short to contain the numeric
item, an edit overflow is caused (X is filled with  asterisks)  and  a
warning message is given at the end of program execution.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 235
CHAPTER 3.4


PROCEDURE PUTINT(I); INTEGER I;
-------------------------------

T.PUTINT(VAL) converts the value of the parameter to an  integer  item
of the designated value.

For T.LENGTH = 10:

     T.PUTINT(-37)         -37
     T.PUTINT(118.8)       119



PROCEDURE PUTFIX(R,N); [LONG] REAL R; INTEGER N;
------------------------------------------------

T.PUTFIX(VAL,M) results in an integer-item  if  M=0,  or  a  real-item
(with  no  exponent) if M>1 with M digits after the decimal point.  It
designates a number equal in value to VAL rounded to M decimal places.
A run time error results if M<0.

     T.PUTFIX(18,0)               18
     T.PUTFIX(-1375.4,3)   -1375.400



PROCEDURE PUTREAL(R,N); [LONG] REAL R; INTEGER N;
-------------------------------------------------

T.PUTREAL(VAL,M) results in a real-item to M significant  places  with
an exponent

          X.XXXXXXXXE+-XX
          M figures

If M<0, a run time error results
If M=0, the exponent is preceded by a sign-part
If M=1, the exponent is preceded by an integer-item of one digit.

     For T.LENGTH = 10:

     T.PUTREAL(16,0)               E+01
     T.PUTREAL(-25.32,1)         -3E+01
     T.PUTREAL(-0.001472,3)   -1.47E-03
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 236
CHAPTER 3.4


PROCEDURE PUTFRAC(I,N);  INTEGER I,N;
-------------------------------------

T.PUTFRAC(VAL,M) results in a grouped-item

          XXX XXX.XXX XXX

If M=0, there is no decimal point.  If M>0, there are M  digits  after
the  decimal  point.   Each  digit  group  consists of 3 digits except
possibly the first and  the  last.   The  numeric  item  is  an  exact
representation of VAL*10(-M).

          T.PUTFRAC(10012416,3)         10 012.416

The editing and de-editing  procedures  are  oriented  towards  "fixed
field" text manipulation.


Example:
--------

     TEXT TR,TYPE,AMOUNT,PRICE,PAYMENT;
     INTEGER PAY,TOTAL;
     TR :- BLANKS(80);
           TYPE :- TR.SUB(1,5);
           AMOUNT :- TR.SUB(20,5);
           PRICE :- TR.SUB(30,6);
           PAYMENT :- TR.SUB(60,10);
     ..........
     IF TYPE = "ORDER" THEN
     BEGIN  PAY := AMOUNT.GETINT*PRICE.GETFRAC;
            TOTAL := TOTAL + PAY;
            PAYMENT.PUTFRAC(PAY,2);
     END;
     ..........
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 237
CHAPTER 3.5


3.5  THE SYSTEM CLASS BASICIO
     ------------------------

Files or data sets are collections of  data  external  to  a  program.
They  may  be  organised  in a sequential manner (a batch of cards) or
direct access manner (collection of items on a disc where each item is
specified directly).

A file is composed of several records each  of  which  is  an  ordered
sequence of CHARACTERS.





The internal representation of a record is naturally held  in  a  TEXT
object, but TEXT handling facilities alone are not enough for treating
input and output to secondary storage.  We need in addition

a)  means  for   tying   the   external   medium   to   the   internal
    representation,

b)  for transferring information (record-by-record)  either  from  the
    external file or to the external file, and

c)  either interpreting the information in the internal TEXT object in
    a  sequential  manner,  or  else  filling  the  TEXT  object  in a
    sequential manner.

A SIMULA system provides  system  classes  for  these  purposes.   The
system classes have the hierarchy


             -------file---------
             !       !          !
          INFILE  OUTFILE   DIRECTFILE
                     !
                 PRINTFILE


The identifier "file" is not accessible by the user - it  defines  the
parts common to the subclasses.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 238
CHAPTER 3.5


The four types of defined file are:


INFILE         a sequential input file which transfers  data  from  an
               external file to the program

OUTFILE        a sequential output file which transfers data from  the
               program to an external file

PRINTFILE      (a subclass of OUTFILE) a sequential file with  special
               extra facilities for transmitting information to a line
               printer or conversational terminal

DIRECTFILE     a direct file with facilities for input and output


Each file object has a TEXT parameter  called  "name",  which  is  not
accessible  by  the  user after creation of the file object.  When the
file object is created, this parameter  specifies  (possibly  together
with  a  specification  file)  the  device,  filename  etc.   Example:
"IN DTA0: X.Y" or "OUT DSK: X.Q".  For  further  information  see  the
DECsystem-10 SIMULA Language Handbook part II.

The CLASS file has the declaration:

     CLASS file(name); VALUE name; TEXT name;
                       VIRTUAL : PROCEDURE OPEN, CLOSE;

     BEGIN  TEXT IMAGE; BOOLEAN opened;

            PROCEDURE SETPOS(I); INTEGER I;
                 IMAGE.SETPOS(I);

            INTEGER PROCEDURE POS;
                 POS := IMAGE.POS;

            BOOLEAN PROCEDURE MORE;
                 MORE := IMAGE.MORE;

            INTEGER PROCEDURE LENGTH;
                 LENGTH := IMAGE.LENGTH;

     END ***file***
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 239
CHAPTER 3.5


The variable IMAGE references a TEXT object  value  which  acts  as  a
buffer containing the information currently being processed.

The PROCEDURES SETPOS, POS, MORE and  LENGTH  defined  local  to  file
operate  on  the  buffer  IMAGE.   Given  a  reference  X to an object
belonging to a subclass of file, then it is now possible to write  the
more convenient

          X.MORE          X.LENGTH          ..........

Instead of (the still valid)

          X.IMAGE.MORE    X.IMAGE.LENGTH    ..........

The PROCEDURES OPEN and CLOSE, which are specified as VIRTUAL but have
no  matching  declaration at the "file" level, complete the definition
of CLASS file.  The matching PROCEDURES declared in the subclasses  of
"file"  conform  to  the patterns below with possible minor variations
depending upon  the  subclass.   The  variations  are  listed  in  the
appropriate following sub-sections.

The PROCEDURE outlines are:

     PROCEDURE OPEN(BUF); TEXT BUF;
     BEGIN  IF opened THEN error;
            IMAGE :- BUF; opened := TRUE;
     END;

     PROCEDURE CLOSE;
     BEGIN  ..........
            IMAGE :- NOTEXT; opened := FALSE;
     END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 240
CHAPTER 3.5


No information can be processed through a "file" object until  it  has
not only been generated but also opened.  This can only be achieved by
a call on the PROCEDURE OPEN whose actual  parameter  is  assigned  to
IMAGE and acts as the buffer.  A call on OPEN when a "file" is already
open gives a run time error.

The PROCEDURE CLOSE closes a file and  releases  the  buffer  (by  the
assignment  IMAGE  :-  NOTEXT).   No  information  may  be transmitted
through a closed "file" object, but  it  may  be  opened  again  by  a
further call on OPEN.



CLASS INFILE
------------

file CLASS INFILE;  VIRTUAL :  PROCEDURE INIMAGE;
                     BOOLEAN PROCEDURE ENDFILE;

BEGIN  PROCEDURE OPEN(BUF); TEXT BUF;.....;
       PROCEDURE CLOSE;......;
       BOOLEAN PROCEDURE ENDFILE;.........;
       CHARACTER PROCEDURE INCHAR;........;
       BOOLEAN PROCEDURE LASTITEM;........;
       INTEGER PROCEDURE ININT;...........;
       REAL PROCEDURE INREAL;.............;
       INTEGER PROCEDURE INFRAC;..........;
       TEXT PROCEDURE INTEXT(W); INTEGER W;......;
END ***INFILE***
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 241
CHAPTER 3.5


PROCEDURE OPEN
--------------

conforms to the  pattern  listed  with  CLASS  file  but  in  addition
positions the current position indicator to "LENGTH+1".



PROCEDURE CLOSE
---------------

conforms to the pattern listed with CLASS file.



PROCEDURE ENDFILE
-----------------

returns TRUE before the INFILE is opened (by  OPEN),  if  the  end  of
external  file  marker has been met, and if the INFILE has been closed
(by a call on CLOSE).



PROCEDURE INIMAGE
-----------------

transfers an external file record into the TEXT  IMAGE.   A  run  time
error  will  occur if the TEXT object referenced by IMAGE is too short
to contain the record.  If the record is shorter  than  IMAGE,  is  is
left  adjusted  and  the  remainder  of  IMAGE  is filled with blanks.
Finally the position indicator of IMAGE is set to 1.   When  the  last
record  has  been  read  in,  and  INIMAGE  is called again, a call of
ENDFILE will return  TRUE.   Any  further  call  on  INIMAGE,  INCHAR,
INTEXT, ININT, INREAL or INFRAC will result in a run time error.



BOOLEAN PROCEDURE LASTITEM;
---------------------------

returns FALSE only if the  external  file  contains  more  information
(non-blank  CHARACTERS).   It  scans  past  all  blank  CHARACTERS and
horizontal tabs (calling INIMAGE if need  be).   If  LASTITEM  returns
FALSE  then  the  currently accessible CHARACTER of IMAGE is the first
non-blank CHARACTER.  If ENDFILE returns TRUE, a call on LASTITEM also
returns TRUE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 242
CHAPTER 3.5


CHARACTER PROCEDURE INCHAR;
---------------------------

gives access to the next available CHARACTER and scans  past  it.   If
IMAGE.MORE  is FALSE, then INIMAGE is called once and the value of the
call is the first CHARACTER of the new image.  INCHAR gives a run time
error if an attempt is made to read past the last record in the file.



TEXT PROCEDURE INTEXT(W);  INTEGER W;
------------------------------------

INTEXT(M) creates a copy of the next M CHARACTERS (which may be spread
over  several records) and returns a reference to this copy.  If M < 0
or M > 2^18-1 then a run time error results.  A run  time  error  will
also  result  if the file does not contain M more CHARACTERS, i.e.  an
attempt is made to read past the last record.

The remaining PROCEDURES treat the file  as  a  continuous  stream  of
records.   They  scan  past  any  number of blanks and horizontal tabs
(calling INIMAGE if need be) and then de-edit a numeric item lying  in
one  image.   This  is  done by calling LASTITEM (which scans past the
blanks and tabs) and then referencing the  remainder  of  the  current
IMAGE  by  a  temporary  TEXT  variable,  say  T.   The  value  of the
"IN***"-PROCEDURE call is the  value  of  the  corresponding  call  on
T."GET***".   On  exit,  the  current position indicator is updated to
reference past the de-edited  field,  i.e.   to  reference  the  first
CHARACTER which is not a part of the de-edited numeric item.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 243
CHAPTER 3.5


e.g.

                            T
                           / \
        !<-----------------   ----------------->!
-------------------------------------------------         intermediate
! ..... !   !   ! 1 ! 2 ! 3 ! . ! 5 ! A ! ..... ! <---IMAGE
-------------------------------------------------             step
          ^
          !
       current
      position
      indicator


                            T.GETINT = 123



     --------------------------------------------------
     ! ...... !   !   ! 1 ! 2 ! 3 ! . ! 5 ! A ! ..... !
     --------------------------------------------------
                                    ^
                                    !
                                 current
                                position
                                indicator


                             ININT = 123


Run time errors will result if the remaining CHARACTERS  in  the  file
are blanks (LASTITEM = TRUE) or if the item is not numeric.

An outline of ININT is:

     INTEGER PROCEDURE ININT;
     BEGIN TEXT T; IF LASTITEM THEN ERROR;
             T :- IMAGE.SUB(POS,LENGTH-POS+1);
             ININT := T.GETINT;
             SETPOS(POS+T.POS-1);
     END ***ININT***

INREAL and INFRAC follow the same pattern.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 244
CHAPTER 3.5


CLASS OUTFILE
-------------

file CLASS OUTFILE; VIRTUAL : PROCEDURE OUTIMAGE;
BEGIN  PROCEDURE OPEN(BUF); TEXT BUF;....;
       PROCEDURE CLOSE;..................;
       PROCEDURE OUTIMAGE;...............;
       PROCEDURE OUTINT(I,W); INTEGER I,W;.....................;
       PROCEDURE OUTFIX(R,N,W); [LONG] REAL R; INTEGER N,W;....;
       PROCEDURE OUTREAL(R,N,W); [LONG] REAL R; INTEGER N,W;...;
       PROCEDURE OUTFRAC(I,N,W); INTEGER I,N,W;................;
       PROCEDURE OUTTEXT(T); VALUE T; TEXT T;..................;
       PROCEDURE OUTCHAR(C); CHARACTER C;......................;
END ***OUTFILE***



PROCEDURE OPEN(BUF); TEXT BUF;
------------------------------

Follows the pattern set by the PROCEDURE OPEN listed with CLASS file.



PROCEDURE CLOSE;
----------------

Conforms to the pattern set by the PROCEDURE CLOSE listed  with  CLASS
file  but  in  addition  checks  the  value  of  POS.  If POS > 1 then
presumably extra information has been copied into IMAGE since the last
call on OUTIMAGE.

Accordingly, if POS > 1, OUTIMAGE  will  be  called  once  before  the
OUTFILE is closed.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 245
CHAPTER 3.5


PROCEDURE OUTIMAGE;
-------------------

OUTIMAGE transfers the contents of IMAGE to the external file creating
a  copy  as  a  new  record.   IMAGE is then cleared to blanks and its
current position indicator set to one.



PROCEDURE BREAKOUTIMAGE;
------------------------

BREAKOUTIMAGE works exactly as OUTIMAGE with the only difference  that
no  carriage  return-linefeed is output at the end of the line.  Thus,
the IMAGE is cleared in the same way as for  OUTIMAGE.   BREAKOUTIMAGE
is  useful when writing conversational programs, to ask a question and
get the answer on the same line.  Note that BREAKOUTIMAGE will  output
any trailing blanks of the image up to POS, while OUTIMAGE will always
strip off these blanks.



PROCEDURE OUTTEXT(T);  VALUE T;  TEXT T;
----------------------------------------

A copy of the CHARACTER sequence represented by the  actual  parameter
is  edited  into  IMAGE  from  the current position.  If the remaining
length of IMAGE is insufficient, OUTIMAGE is called  and  output  will
start  at the first position of a fresh image.  if T.LENGTH is greater
than IMAGE.LENGTH then a run time error will occur.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 246
CHAPTER 3.5


PROCEDURE OUTCHAR(C);  CHARACTER C;
----------------------------------

Outputs the value  of  C  into  the  current  position  of  IMAGE  (if
MORE = FALSE,  then  OUTIMAGE  is  called first).  In either case, the
current position indicator is then incremented.

The remaining PROCEDURES are all based upon the  PUT-PROCEDURES  local
to  TEXTs.  The corresponding OUT-PROCEDURES are augmented by an extra
parameter W which specifies the field width.


             -------------------------------------
             !/////////!         !     !         !
IMAGE .----->!/////////!         !     !         !
             !/////////!         !  ^  !         !
             -----------------------!-------------
                                    !
              !       ! !       !   !
              --------- ---------   !
                                    !
                                     Final position of current
               portion    FIELD      position indicator
              of IMAGE
               already
                filled


The editing PROCEDURE  commences  by  establishing  a  temporary  TEXT
reference  (FIELD)  to  the next sequence of W CHARACTERS lying in one
IMAGE.  If the current IMAGE has not enough space  left,  OUTIMAGE  is
called.   Then  the  value  is  edited by calling FIELD."PUT***" where
"PUT***" is the  PUT-PROCEDURE  corresponding  to  the  OUT-PROCEDURE.
Finally  the current position indicator is increased by W to reference
- past the just-edited field.


     PROCEDURE OUTINT(I,W); INTEGER I,W;
          FIELD(W).PUTINT(I);

     PROCEDURE OUTFRAC(I,N,W); INTEGER I,N,W;
          FIELD(W).PUTFRAC(I,N);

     PROCEDURE OUTREAL(P,N,W); [LONG] REAL P; INTEGER N,W;
          FIELD(W).PUTREAL(P,N);

     PROCEDURE OUTFIX(P,M,W); [LONG] REAL P; INTEGER M,W;
          FIELD(W).PUTFIX(P,M);
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 247
CHAPTER 3.5


CLASS PRINTFILE
---------------

     OUTFILE CLASS PRINTFILE;
     BEGIN  PROCEDURE OPEN(BUF); TEXT BUF;...............;
            PROCEDURE CLOSE;.....;
            PROCEDURE LINESPERPAGE(N); INTEGER N;........;
            INTEGER PROCEDURE LINE(N); INTEGER N;........;
            PROCEDURE SPACING(N); INTEGER N;.............;
            PROCEDURE EJECT(N); INTEGER N;...............;
            PROCEDURE OUTIMAGE;..........................;
     END ***PRINTFILE***


CLASS PRINTFILE further orients the prefixing  CLASS  OUTFILE  towards
conversational terminal (TTY:) or line printer output.  The PROCEDURES
OPEN and CLOSE take the pattern of  those  local  to  OUTFILE  but  in
addition OPEN positions to the top of the next page.



PROCEDURE LINESPERPAGE(N);  INTEGER N;
-------------------------------------

Initially the number of printable lines per  page  is  fixed  at  some
value  (V)  dependent  upon  the installation.  A call LINESPERPAGE(M)
will alter this figure to allow only M printable lines per page.  If M
= -1 then no automatic page skips will occur.  This is recommended for
display terminal output.



PROCEDURE SPACING(N);  INTEGER N;
--------------------------------

Initially the spacing is  1  and  successive  images  are  printed  on
successive  lines.   A  call  SPACING(M)  will  alter this to separate
successive lines by M-1 blank lines.  This becomes effective after the
next call on OUTIMAGE.  If M > "current value of lines per page", or M
< 0, then a run time error results.  If M = 0, overprinting will occur
- successive images being printed on the same physical line.



PROCEDURE EJECT(N);  INTEGER N;
------------------------------

This PROCEDURE skips to a certain  line  on  the  page  -  (it  avoids
calling  OUTIMAGE  several  times).  EJECT(L) will position to line on
this page if this is further down the current page (if L >  LINE),  or
else skip to LINE L of the next page if L <= LINE.

A run time error occurs if L <= 0.  If L > LINESPERPAGE,  EJECT(L)  is
equivalent to EJECT(1).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 248
CHAPTER 3.5


INTEGER PROCEDURE LINE;
-----------------------

This PROCEDURE returns the INTEGER value  of  the  line  number  which
indicates  the  next line to be printed.  Thus EJECT(LINE+3) will skip
three lines and not alter spacing.  After each call on  OUTIMAGE,  the
line number is incremented by the current spacing.



PROCEDURE OUTIMAGE;
-------------------

This PROCEDURE acts like the  OUTIMAGE  of  OUTFILE  but  in  addition
increments the line number by spacing, and will position to the top of
the next page if the current page is filled.


Example:
--------

This example shows the use of three types of file and how to open  and
close  them.  The example was chosen to demonstrate these features and
how formatting is available by use of the sub-text concept.  The logic
of  the  example  is  particularly simple.  A file of transactions has
been punched on cards in the format


col  1-5       customer number               CNO
col  7-16      sum of debit transactions     DB
col 19-28      sum of credit transactions    CR


Each transaction is on  a  fresh  card.   The  information  is  to  be
compressed  and recorded on a new sequential file on tape.  The length
of each tape record is 15 CHARACTERS, and its format is:


               5           10
          *************************
          *   CNR   *   CR - DB   *
          *************************

          customer   total sum of
           number    transactions


Checks are made that the customer number is valid (1-3-7 digit  check)
and  that  the card is validly punched.  If not, a copy of the card is
printed on a line printer, and the scan continues.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 249
CHAPTER 3.5


Note that the INFILE and PRINTFILE share the same buffer.


                                     *******
                                    *      *
                              -----* CARDS *
                              !    *       *
                              !    *********
                              !
                              !
       ***********************************************
       *       *                                     *
BUFFER *       *               CUSTOMER              *
       *       *                                     *
       ***********************************************
                         !            !
                         !            !
                  --------            --------
                  !                          !
                  !                          !
             ***********                 ***********
             *         *                 *         *
NCUSTOMER.   *         *                 * PRINTER *
   IMAGE     *         *                 *        *
             ***********                 * * * * *
                  !                       * * * *
                  !
             ------
             !
             !
          ****** 
         *      *
        *  TAPE  *
         *      *
          ****** 
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 250
CHAPTER 3.5


BEGIN
    EXTERNAL INTEGER PROCEDURE checkint;
    TEXT cnr, db, cr, nr, t1, t2, t3, t4, kt, tsum,
    ts, buffer, err;
    INTEGER sum, balance;
    REF(Infile) customercards;
    REF(Printfile) print;
    REF(Outfile) ncustomer;

    BOOLEAN PROCEDURE nonnumeric(t); TEXT t;
    COMMENT ***THIS PROCEDURE RETURNS TRUE IF THE TEXT
    PARAMETER CAN NOT BE NUMERICALLY INTER-
    PRETED FROM THE LEFT*** ;
    BEGIN
        t.Setpos(1);
        nonnumeric:= checkint(t) NE 1;
    END;

    buffer :- Blanks(132);
    COMMENT ***CONSTRUCT THE CARDFILE*** ;
    customercards :- NEW Infile("CCARD DSK: CCARD.CDR");
    customercards.Open(buffer.Sub(10,80));
    cnr :- buffer.Sub(10,5);
    nr :- cnr.Sub(1,4);
    t1 :- nr.Sub(1,1);
    t2 :- nr.Sub(2,1);
    t3 :- nr.Sub(3,1);
    t4 :- nr.Sub(4,1);
    kt :- cnr.Sub(5,1);
    db :- buffer.Sub(16,10);
    cr :- buffer.Sub(28,10);

    COMMENT ***CONSTRUCT PRINTFILE*** ;
    print :- NEW Printfile("PRINT LPT:");
    print.Open(buffer);
    err:- buffer.Sub(1,6);

    COMMENT ***CONSTRUCT TAPEFILE*** ;
    ncustomer :- NEW Outfile("NCUSTOMER MTA:");
    ncustomer.Open(Blanks(15));

    COMMENT ***CONSTRUCT WORKING TEXT TSUM*** ;
    tsum :- Blanks(3);
    ts :- tsum.Sub(3,1);
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 251
CHAPTER 3.5


    INSPECT ncustomer DO
    BEGIN
        customercards.Inimage;
        WHILE NOT customercards.Endfile DO
        BEGIN IF nonnumeric(cnr) OR
            nonnumeric(db) OR
            nonnumeric(cr)
            THEN error:
            BEGIN err:= "ERROR"; print.Outimage
            END ELSE
            BEGIN COMMENT ***137 DIGIT CHECK*** ;
                sum := 7*(t1.Getint + t4.Getint) +
                3*t3.Getint + t2.Getint;
                tsum.Putint(sum);
                IF ts NE kt THEN GOTO error;

                COMMENT ***OUTPUT TO TAPE*** ;
                balance := cr.Getint - db.Getint;
                Outtext(cnr);
                Outint(balance,10);
                Outimage;
            END;
            customercards.Inimage;
        END;
    END ***INSPECT NCUSTOMER*** ;

    slutt: customercards.Close;
    ncustomer.Close;
    print.Close
END
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 252
CHAPTER 3.5


CLASS DIRECTFILE
----------------

file CLASS DIRECTFILE;
     VIRTUAL: PROCEDURE LOCATE, ENDFILE, INIMAGE, OUTIMAGE;
BEGIN  PROCEDURE OPEN(BUF); TEXT BUF;  . . . . . . . . . . . . ;
       PROCEDURE CLOSE;  . . . . . . . . . . . . . . . . . . . ;
       INTEGER PROCEDURE LOCATION; . . . . . . . . . . . . . . ;
       PROCEDURE LOCATE(I); INTEGER I; . . . . . . . . . . . . ;
       BOOLEAN PROCEDURE ENDFILE;  . . . . . . . . . . . . . . ;
       PROCEDURE INIMAGE; . . . . . . . . . . . . . . . . . . .;
       CHARACTER PROCEDURE INCHAR; . . . . . . . . . . . . . . ;
       BOOLEAN PROCEDURE LASTITEM; . . . . . . . . . . . . . . ;
       INTEGER PROCEDURE ININT; . . . . . . . . . . . . . . . .;
       REAL PROCEDURE INREAL; . . . . . . . . . . . . . . . . .;
       INTEGER PROCEDURE INFRAC; . . . . . . . . . . . . . . . ;
       TEXT PROCEDURE INTEXT(W); INTEGER W; . . . . . . . . . .;
       PROCEDURE OUTIMAGE; . . . . . . . . . . . . . . . . . . ;
       PROCEDURE OUTCHAR(C); CHARACTER C; . . . . . . . . . . .;
       PROCEDURE OUTINT(I,W); INTEGER I,W; . . . . . . . . . . ;
       PROCEDURE OUTFIX(R,N,W); [LONG] REAL R; INTEGER N,W;. . ;
       PROCEDURE OUTREAL(R,N,W); [LONG] REAL R; INTEGER M,W;. .;
       PROCEDURE OUTFRAC(I,N,W); INTEGER I,N,W; . . . . . . . .;
       PROCEDURE OUTTEXT(T); VALUE T; TEXT T; . . . . . . . . .;
END ***DIRECTFILE***


A directfile represents an external file in which  individual  records
are  addressed by indices (ordinal numbers).  The index of the current
record is returned by a call on LOCATION.  The current record  may  be
copied into the program by a call on INIMAGE, or overwritten by a call
on OUTIMAGE.  In either case, the sequentially  next  record  is  then
taken as the current record.  This sequential accessing may be altered
at any time a call LOCATE(M) which will locate the Mth external record
and make it the new current record.

If M <= 0 and OUTIMAGE is called, then a run time error will occur.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 253
CHAPTER 3.5


PROCEDURE OPEN
--------------

conforms to the pattern of OPEN in CLASS file but in addition  locates
the first record.



PROCEDURE CLOSE
---------------

conforms to the pattern of CLOSE in CLASS file.



PROCEDURE ENDFILE
-----------------

is FALSE if the current index locates a record in the file.

Calls on the PROCEDURE INIMAGE will cause run a time error if  ENDFILE
is  TRUE.   Otherwise  INIMAGE  (and OUTIMAGE) conform to these of the
same identifiers in INFILE and OUTFILE but in addition  increment  the
index of the current record by one.

The remaining PROCEDURES are analogous to the corresponding PROCEDURES
of INFILE and OUTFILE.

A more complete description of DIRECTFILE  is  given  in  DECsystem-10
SIMULA Language Handbook Part II.



DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 254
CHAPTER 3.5


CLASS BASICIO
-------------

The system defined file facilities are grouped together in  the  CLASS
BASICIO whose skeleton reads:

CLASS BASICIO(sysinlength,sysoutlength);
INTEGER sysinlength,sysoutlength;
BEGIN  CLASS file. .  .  .  .  .  .  ;
       file CLASS INFILE. .  .  .  . ;
       file CLASS OUTFILE. .  .  .  .;
       file CLASS DIRECTFILE. .  .  .;
       OUTFILE CLASS PRINTFILE. .  . ;
       REF(INFILE)sysin;
       REF(PRINTFILE)sysout;
       REF(INFILE) PROCEDURE SYSIN; SYSIN :- sysin;
       REF(PRINTFILE) PROCEDURE SYSOUT; SYSOUT :- sysout;
       sysin :- NEW INFILE("SYSIN");
       sysin.OPEN(BLANKS(sysinlength));   See note 1)
       sysout :- NEW PRINTFILE("SYSOUT");
       sysout.OPEN(BLANKS(sysoutlength));   See note 1)
       INNER;
       sysin.CLOSE; sysout.CLOSE;
END ***BASICIO***















1) The image sizes of SYSIN and SYSOUT depend on the device.   If  the
device  is a conversational terminal with a known linelingth, then the
image size is the linelength of the device.  If the device  is  not  a
conversational  terminal  or  has  no known linelength, then the image
size is 80 for SYSIN and 132 for SYSOUT.  Note however that is is very
easy   for   a   programmer   to   change   this   by   writing   e.g.
"sysin.image:-blanks(200);"  or  "sysout.image:-blanks(600);"  in  his
source  program.   A  SIMULA program will not be able to accept longer
input or produce longer output lines on SYSIN  and  SYSOUT.   A  large
imagesize  will  thus  allow longer lines but will give more expensive
calls to inimage and outimage.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 255
CHAPTER 3.5


BASICIO  contains  actions  to  generate  an  INFILE,  SYSIN,  and   a
PRINTFILE,  SYSOUT.   For  a  conversational  job, the default is that
SYSIN and SYSOUT both refer to the  conversational  terminal.   For  a
batch  job,  the  default  is  that  SYSIN refers to the control file,
SYSOUT to the batch job log.  This can be changed by  the  programmer,
e.g.   to make SYSIN refer to a disk file, a card reader or a magnetic
tape and to make SYSOUT refer to a disk file or the line printer.  For
more  information  about  this,  see  the DECsystem-10 SIMULA Language
Handbook part II.

SYSIN and SYSOUT are accessible only through PROCEDURES which copy the
values  of certain identifiers (sysin, sysout) which are otherwise not
accessible by the user.

A user's program behaves as though it is enclosed as follows:

BASICIO(80,80)
              BEGIN  INSPECT SYSIN DO
                     INSPECT SYSOUT DO
                         <program>
              END;

When a user program begins  the  system  automatically  generates  two
files  -  one INFILE for input referenced by SYSIN, and one for output
referenced by SYSOUT.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 256
CHAPTER 3.5


SYSIN .---                    ----------INIMAGE-----
         !                    !                    !
         V                    V                    !
    -----------        ------------                !
    ! IMAGE .-!------->!          !                !
    ! ININT   !        ------------                !
    ! INREAL  !                                    !
    ! INTEXT  !                                    !
    ! INIMAGE !                                    !
    -----------                              -------------
                                             !           !
                                             !  -------  !
                                             ! !       ! !
                             conversational  ! !       ! !
                                   terminal  ! !       ! !
                                             ! !       ! !
                                             !  -------  !
                                             !           !
                                             -------------
                                                   ^
                                                   !
                                                   !
SYSOUT .---                                        !
          !                                        !
          V                                        !
    -------------            ---------------
    ! IMAGE .---!----------->!             !       !
    ! OUTINT    !            ---------------       !
    ! OUTREAL   !                  !               !
    ! OUTTEXT   !                  !               !
    ! OUTIMAGE  !                  ----OUTIMAGE-----
    ! EJECT     !
    ! . .. .. . !
    -------------


DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 257
CHAPTER 3.5


When the actions of the user defined program  are  exhausted,  control
returns  to the prefix level of the BASICIO object and continues after
the  INNER.   The  following  two  statements  close  the  two  system
generated files.

The inspect statements enclosing the program allow the user  to  write
ININT,   INIMAGE,.....   instead  of  SYSIN.ININT,  SYSIN.INIMAGE  and
OUTREAL, OUTIMAGE,....  instead  of  SYSOUT.OUTREAL,  SYSOUT.OUTIMAGE.
There are attribute name clashes

          OPEN      which should never be used for
          CLOSE     SYSIN or SYSOUT

          IMAGE
          SETPOS
          POS
          MORE
          LENGTH


When  these  occur  they  are  naturally  bound  to  SYSOUT  and   the
corresponding   attributes   of  SYSIN  may  be  obtained  by  writing
SYSIN.SETPOS, SYSIN.IMAGE et.  Alternatively, an input section may  be
written as

 INSPECT SYSIN DO
 BEGIN

          input - in this block occurrences IMAGE,
          SETPOS, POS, MORE and length are bound to SYSIN
 END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 258
CHAPTER 4


                   CHAPTER 4: SEPARATE COMPILATION
                   -------------------------------



4.1  Why separate compilation?
     -------------------------

There are basically two reasons for separate compilation:

1)  When several programmers are working on a large  program  product,
    then  there is a need for dividing that large program product into
    modules so that:

    a)  These modules can be compiled and tested separately.

    b)  There is a defined interface between the modules and automatic
        checking  that  the  modules  do  not communicate outside this
        defined interface.

2)  For  a  large  computer  program,  the  compilation  time  can  be
    shortened  with  separate  compilation.  This will lower costs and
    also lower turn-around times.  The latter is especifally important
    on  conversational  time-sharing computers, where fast turn-around
    is natural and expected.



DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 259
CHAPTER 4.2


4.2  Good and bad separate compilation
     ---------------------------------

The two main requirements of a good system  for  separate  compilation
are security and efficiency.

By security is meant that the compiler should provide  error  checking
as  thorough as if the modules had been compiled as one large program.
Especially important is checking the type and structure of data  which
is  transferred  between  separately compiled modules.  This interface
between modules must be definable and checkable.  This checking  makes
it easier to design a program in such a way that you can feel sure and
even prove that the program is correct.

As a warning, look at most FORTRAN systems, where the compiler usually
does  not  check the data which is transferred between subroutines (as
parameters or as COMMON blocks), and where this is  one  of  the  most
common reasons for difficult-to-find errors in large FORTRAN programs.

Efficiency requires that compilation should really be done separately.
We  do  not want to achieve "separate compilation" by recompiling most
of the program every time, or by deferring a lot  of  the  compilation
work to the Linking Loader (which handles the whole program) or to the
run time system (making execution time slower because of error  checks
at run time).

Both these requirements cannot be completely fulfilled, since security
requires  that  the  compiler does some scanning of other modules when
one module is compiled separately.  However,  the  SIMULA  system  for
separate  compilation  reduces  this  unavoidable double-scanning to a
minimum while still retaining complete security.

Separate compilation in SIMULA can also be combined  with  the  HIDDEN
PROTECTED  concept  (See  Chapter 2.5.7) to provide further control of
the module interface.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 260
CHAPTER 4.3


4.3  What SIMULA concepts can be separately compiled?
     -----------------------------------------------

In SIMULA, procedures and classes can be  separately  compiled.   This
gives  large  freedom to the programmer to structure his program as he
wants.  He can, if he so wishes, compile separately

     1.  Coroutines - that is e.g.  routines working on a common  data
         buffer,  one fills the buffer, but only when it is empty, the
         other empties the buffer, but only when it is full.

     2.  Passive data blocks - a class can be  a  separately  compiled
         data  block corresponding to the COMMON statement in FORTRAN.
         The passive data structure can  also  be  some  more  complex
         structure,  such  as  an  ordered  or  unordered  set of data
         blocks, a tree structure or any other kind of data structure.

     3.  Program levels - by using the subclass concept of  SIMULA,  a
         program  can  be  written  at  several  levels.   Each  level
         introduces more  advanced  concepts  based  on  the  concepts
         introduced  in  the  previous  levels,  and  each  level is a
         subclass of a separately compiled class.  The main program is
         a  "high-level"  program utilizing the "lower-level" concepts
         introduced by the previous separately compiled classes.

These examples show that the SIMULA system for separate compilation is
flexible  and  allows  the programmer to partition his program in many
conceptually different ways into separately compiled modules.

Examples will be provided in section 4.5 of this handbook.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 261
CHAPTER 4.4


4.4  How is separate compilation specified?
     --------------------------------------

The use of a separately compiled module is specified by  the  EXTERNAL
declaration  in  SIMULA.   You  write  "EXTERNAL  CLASS  X,  Y, Z;" or
"EXTERNAL PROCEDURE A, B, C;" to tell the system that you are going to
use these separately compiled classes and procedures.

The syntax of the EXTERNAL declaration is given in  chapter  2.5.6  of
this  handbook.   For  information  about  EXTERNAL  modules  in other
languages than SIMULA, see part II of the DECsystem-10 SIMULA Language
Handbook.

In the main  program,  you  can  put  these  declarations  anywhere  a
procedure  or  class  declaration is allowed.  The separately compiled
modules will then be available throughout the block in which they  are
declared, just as ordinary non-separate procedures and classes.

If you want  to  use  a  separately  compiled  module  inside  another
separately compiled module, then you put the EXTERNAL statement before
the beginning of the other separately  compiled  module  in  the  main
program.

This is easiest to understand by examples, and  several  examples  are
given in the rest of this chapter.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 262
CHAPTER 4.5


4.5  Examples of partitioning of SIMULA programs.
     -------------------------------------------



4.5.1  A number of separately compiled procedures
       ------------------------------------------
       with a common data area.
       -----------------------

The FORTRAN COMMON statement defines a collection of global  variables
which are available in some or all FORTRAN SUBROUTINES.

You can achieve a very similar effect in SIMULA  by  using  a  passive
separately compiled class.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

CLASS common;
BEGIN REAL x; INTEGER ARRAY y(1:10,1:100);
   COMMENT etcetera.;
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS common;
PROCEDURE procl(tocommon);
REF (common) tocommon;
INSPECT tocommon DO
BEGIN COMMENT Body of the PROCEDURE proc1;
COMMENT here all the variables in the common data area are
directly available just as in a FORTRAN subroutine with a
COMMON statement in it;
END of proc1;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS common;
PROCEDURE proc2(tocommon);

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 263
CHAPTER 4.5.1


BEGIN COMMENT Main program;
   EXTERNAL CLASS common;
   EXTERNAL PROCEDURE proc1, proc2, ... etc ...;
   INSPECT NEW common Do
   BEGIN COMMENT Body of the main program, where all the
      variables in common are directly available just as in
      a FORTRAN main program with a COMMON statement;
      ...
      proc1(THIS common);
      ...
      proc2(THIS common);
      ...
   END;
END of the main program;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

In FORTRAN you can have several different labelled COMMON blocks  with
different  names.   In  the  same  way, you can in SIMULA have several
separately compiled CLASSes and begin each procedure by

"INSPECT tocommon1 DO INSPECT tocommon2 DO INSPECT tocommon3
DO ...  etc ..."

The SIMULA CLASS is of  course  much  more  general-purpose  than  the
FORTRAN  COMMON.   The CLASS can for example contain initialization of
the data variables in the CLASS and standard procedures  for  handling
the  data  in the CLASS.  All this is wellknown to someone with SIMULA
experience.

Also, you can in SIMULA have more than one copy  of  the  same  CLASS,
with  different values for the data variables in them.  In FORTRAN you
can only have one copy of the data in each COMMON block.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 264
CHAPTER 4.5.2


4.5.2  Each separately compiled module extends
       ---------------------------------------
       the previous one.
       ----------------

In SIMULA you can write a basic  CLASS  defining  some  new  concepts.
Then  you  can in a series of SUBCLASSES refine the basic class.  Your
program will be written at different levels, where each level uses the
new concepts defined at the previous level.

For example, you may have the following levels:

Database     - introduce the data  structures  of  a  relational  data
               base.

Datamake     - introduce procedures to enter data into the  relational
               data base.

Datause      - introduce procedures to get data  from  the  relational
               data base.

Family       - introduce the special case of family relationships.

Main program - utilize  the  concepts  to  write   a   program   using
               relational  data  bases  with  family  relationships in
               them.

In SIMULA you can write such a program structure like this:
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 265
CHAPTER 4.5.2


 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

CLASS database;
BEGIN ... END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS database;
database CLASS datamake;
BEGIN ... END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS database, datamake;
datamake CLASS datause;
BEGIN ... END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS database, datamake, datause;
datause CLASS family;
BEGIN ... END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

BEGIN COMMENT main program;
   EXTERNAL CLASS database, datamake, datause, family;
   family BEGIN
      ... here the new concepts can be used freely ...
   END;
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 266
CHAPTER 4.5.3


4.5.3  A list of items is transferred to
       ---------------------------------
       separately compiled procedures.
       ------------------------------

You may want to write a program to process sets  of  items.   Usually,
when  you call a separately compiled procedure, you want to transfer a
set of items to it.  The sets are stored  in  a  linear  list  with  a
reference variable "next" referring to the next item in the list.

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

CLASS item(next, number, size, label);
REF (item) next;
INTEGER number, size; TEXT label;;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS item;
PROCEDURE itemscan(itemlist);
REF (item) itemlist;
BEGIN
   REF (item) scanneditem;
   scanneditem:- itemlist;
   WHILE scanneditem =/= NONE DO
   INSPECT scanneditem DO
   BEGIN COMMENT treatment of one item in the list;
      ...
      scanneditem:- next;
   END;
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

BEGIN COMMENT main program;
   EXTERNAL CLASS item;
   EXTERNAL PROCEDURE itemscan;
   REF (item) itemlist;
   ...
   itemlist:- NEW item(itemlist,n,s,"TO OFFICE");
   ...
   itemscan(itemlist);
   ...
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

Instead of a linear list, you could in this way transfer an  arbitrary
data  structure  such  as  a  tree,  a ring, a relational data base of
whatever you want to transfer  as  data  to  the  separately  compiled
procedures and classes.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 267
CHAPTER 4.5.4


4.5.4  Separate compilation with simset and simulation.
       ------------------------------------------------

The standard system classes "simset" and "simulation"  can  themselves
be  regarded as a special kind of separately compiled classes.  You do
not have to declare them in any "EXTERNAL" declaration.

There are classes declared  inside  "simset"  and  "simulation",  e.g.
"link"  and  "process".   They  are not themselves separately compiled
classes.

This means that a separately compiled  class  can  be  a  subclass  of
"simset"  or  of  "simulation",  but  not  a  subclass  of  "link"  or
"process".

It is not possible to write a separately compiled CLASS  or  PROCEDURE
using SIMSET or SIMULATION except as separately compiled subclasses to
SIMSET or to SIMULATION.

If you want to compile separately a subclass of e.g.   "process"  then
you  can  still  do  it.   You  then  compile separately a subclass of
"simulation" which contains within it a subclass  of  "process".   The
following example will show how to do it:

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

simulation CLASS craneandtruck;
BEGIN
   process CLASS crane;
   BEGIN ... END;
   process CLASS truck;
   BEGIN ... END;
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

EXTERNAL CLASS craneandtruck;
craneandtruck CLASS harbour;
BEGIN
   process CLASS ship;
   BEGIN ... END;
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

BEGIN COMMENT main program;
   EXTERNAL CLASS craneandtruck, harbour;
   harbour BEGIN COMMENT here you can use the new processes
      crane, truck and ship;
      ...
   END;
END;

 - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 268
CHAPTER 4.5.4


In the above example, we first compile two  subclasses  of  "process",
"crane"  and  "truck"  in  one  separately  compiled module, the class
"craneandtruck".  We then compile the  third  subclass  of  "process",
"ship"  in  a  second separately compiled module, the class "harbour".
Finally, in the main program, a simulation  is  programmed  using  the
three new processes crane, truck and ship.



4.6  A way of understanding part-compilation in SIMULA
     -------------------------------------------------

A way to understand  intuitively  how  part-compilation  works  is  to
describe  it in the following way.  By this is not meant that a SIMULA
compiler  necessarily  will  implement  part-compilation  in  the  way
described below.

When an EXTERNAL declaration  occurs  inside  the  main  program,  the
effect  is  the  same  as if the whole text of the separately compiled
class or procedure was copied into the main program at that point.

When an EXTERNAL declaration occurs in  front  of  another  separately
compiled  class  of  procedure,  this does not imply any such copying.
Instead, this serves to inform  the  compiler  that  when  this  other
module   is   later   on  copied  into  the  main  program,  then  the
EXTERNAL-declared module is already available at  that  point  in  the
main program.



4.7  How is part-compilation implemented in the DEC-system-10
     --------------------------------------------------------
     SIMULA system?
     --------------

The difficulty in implementing part-compilation in a SIMULA system  is
to ensure full error-checking security.  To do this, the compiler must
know about other  separately  compiled  modules  when  one  module  is
compiled, since some errors can only be found by comparing information
in several separately compiled modules.

The solution in the DEC-system-10 is that  each  module,  when  it  is
compiled,  outputs  not  only a file with the object program, but also
another file with the description of externally accessible  attributes
of that module.  (That is;  Attributes of a separately compiled class,
parameters of a separately compiled procedure.) This  other  file  has
the extension ".ATR".
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 269
CHAPTER 4.7


When an EXTERNAL statement is encountered, the attribute file for that
module is read in by the compiler.  This means that the error-checking
can wholly be done at compile-time.  There is no  need  to  check  the
parameter  types  of  procedure  parameters  at  run time.  Most other
Algol-like languages do this parameter type checking at run  time,  or
else they do not check the parameter types at all.



4.8  Implementation-dependent restrictions on separate compilation
     -------------------------------------------------------------

Some program changes in one  module  forces  re-compilation  of  other
modules.  This is just like in FORTRAN;  when the number of parameters
to a FORTRAN SUBROUTINE is changed, all other SUBROUTINES  which  call
the  changed  SUBROUTINE  must be modified and re-compiled, and when a
COMMON statement is modified, all SUBROUTINES containing the  modified
COMMON must be re-compiled.

The difference in SIMULA is that the compiler will  tell  you  if  you
forgot  to  re-compile  some  module  which had to be re-compiled.  In
FORTRAN, you are usually not told, and the results may  be  disastrous
when you try to run the program.

The basic rule is:  If a SIMULA part-compiled module  is  modified  so
that  its attributes are modified, then all other modules referring to
it by EXTERNAL statements must also be modified.

Note however, that if you only make  internal  changes  in  a  module,
which  do not alter the attributes, then in most cases no other module
need be re-compiled.

The DEC-system-10 SIMULA system also requires that when you compile  a
separately  compiled  class,  you  must  give  as  a  parameter to the
compiler the block level of the place where it is copied into the main
program.  This restriction is not as severe as you may feel initially,
since:

     1.  Default  is  the  outermost  block,  where  you  usually  put
         EXTERNAL declarations.

     2.  If you do not  follow  this  rule,  the  compiler  tells  you
         exactly  which  modules you have to re-compile at which block
         level.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 270
CHAPTER 5


                        CHAPTER 5   REAL TIME
                        ---------------------

******************************IMPORTANT*******************************

This chapter describes  an  additional  facility  which  will  not  be
included  in release 1 of the DECsystem-10 SIMULA system.  We have not
yet decided whether to implement this facility at  all,  the  decision
depends  on  whether  users  of the DECsystem-10 SIMULA system require
this facility.

**********************************************************************

The simplest kind of real time  application  is  the  execution  of  a
conversational  program  running  under a time-sharing system with one
external user talking to the program through  a  terminal  such  as  a
display unit or a typewriter terminal.

This simple kind of conversation  can  already  easily  be  programmed
using  the  concepts  described  in  chapter  1-4 in this manual.  The
time-sharing operating system will handle all the real  time  problems
for the SIMULA program.

But as soon as we want more  than  one  real  process  to  communicate
simultaneously  with  the  SIMULA  program, then we need more advanced
real time capabilities.

Examples:

      -  During a simulation, we may  want  to  program  part  of  the
         simulation  in  SIMULA  but  let real components, for example
         real  human  participants,  play   certain   parts   in   the
         simulation.

      -  We  want  to  let  more  than  one  user  at   his   terminal
         simultaneously  access a data base, both fetching and storing
         information in it.  One master program has to coordinate  the
         data  base  accesses  to that two users do not simultaneously
         try to update the same record.  We might want to  write  this
         program in SIMULA.

To program such applications, some additional facilities are necessary
in the SIMULA programming language.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 271
CHAPTER 5


5.1  Procedures WAIT(TERMINALQUEUE), DATAREADY and HOLD(0).
     -----------------------------------------------------

The execution of a SIMULA process is only interrupted  where  explicit
statements  like  "HOLD" or "PASSIVATE" cause control to transfer from
the process to the scheduler.  A common error  when  programming  real
time  programs  is  that  one  parallel  process uses half-ready data,
procuced by another parallel process.  For small  in-core  updates,  a
programmer  in  SIMULA can avoid this error by only putting statements
like "HOLD" and "PASSIVATE" at places in the source program where data
updates are complete.

For more complex updates, a special process can be written  to  access
the  critical  data,  and  other  processes  requesting updates can be
queued to the special process.   When  a  SIMULA  process  executes  a
statement  like "HOLD" or "PASSIVATE", then control goes to the SIMULA
scheduler, which then transfers control to another process.

"HOLD(A)" stops execution of the current process but asks  the  SIMULA
scheduler  to  restart  it after A time units.  If A is zero, then the
current process is stopped and  placed  at  the  end  of  a  queue  of
currently  active  processes.   If  a number of processes successively
make "HOLD(0.0)" then they will thus get CPU power in  a  round  robin
fashion.

A  SIMULA  programmer  can  thus  ensure  fast  response  to  external
interrupts  by  not  making  too  much computations between successive
"HOLDS".
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 272
CHAPTER 5


"PASSIVATE"  stops  the  current  process  indefinitely,  it  must  be
activated again from some other process.

Processes waiting for external interrupts are put into a special queue
called TERMINALQUEUE.  As soon as control is transferred to the SIMULA
scheduler (e.g.  by calls to "HOLD" or "PASSIVATE") then the scheduler
first  scans  this  queue  to  see  if data has arrived from the input
device associated with the terminal process.

If a process is found in the TERMINALQUEUE for which data has  arrived
on  the  associated  input device, then the SIMULA scheduler activates
this process immediately.

The event created by the first external interrupt found is thus placed
in  front  of  other currently active processes in the sequencing set.
This, however, is not done at the time of the interrupt,  the  placing
is  done at the time of the next activation of the scheduler after the
interrupt.

Inside a process, a call  "WAIT(TERMINALQUEUE)"  will  thus  tell  the
system  to  make this process passive, but to reactivate it as soon as
new data has arrived on the input device associated with the process.

A new "BOOLEAN" standard procedure  "DATAREADY"  is  also  introduced.
Dataready is an attribute to INFILE and is TRUE if and only if data is
available (i.e.  has arrived from the  terminal  device)  for  reading
with INIMAGE.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 273
CHAPTER 5


5.2  Procedures TIMEOFDAY, SYNCHRONIZE and DESYNCHRONIZE
     --------------------------------------------------

For real time applications, we may also want to synchronize  simulated
time   with  real  time.   For  this  there  are  three  new  standard
procedures:

REAL PROCEDURE timeofday;  COMMENT gives time  in  seconds  since  the
beginning of the current day;

PROCEDURE   synchronize(timeunit);  REAL    timeunit;  COMMENT    this
procedure starts synchronization of real and simulated time;

PROCEDURE desynchronize;  COMMENT and this stops synchronization;

Of course perfect synchronization of real and simulated  time  is  not
possible  since  the speed of the computer itself is not infinite.  By
synchronization is meant that the simulated time since  the  beginning
of  the  current  synchronization period must never be larger than the
real time since the same beginning.

If the SIMULA scheduler finds that the next process  to  be  scheduled
has  a  too  large  simulated time, then the SIMULA scheduler lets the
SIMULA program go to sleep  for  the  necessary  time  interval.   Any
interrupts  caused  by  input  will  however  start the SIMULA program
again.  (On a DEC system-10 computer, the HIBERNATE UUO can be used to
program this.)

The parameter "timeunit" to the procedure "synchronize" is there since
the  time  unit  may not be the same in the simulation and in the real
world.  "timeunit" is the size of the simulation time unit in seconds.
Thus,  if  simulated time is measured in seconds, "timeunit" should be
1.0, if simulated time is measured  in  hours,  "timeunit"  should  be
60*60.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 274
CHAPTER 5


5.3  Application examples
     --------------------

In this section you can see how the new concepts can  be  used.   Some
examples  will  be given of real time programs written in SIMULA using
the new concepts.

The programs are not always  complete.   Three  dots  indicate  places
where something has been left out.



5.3.1  Simultaneous, uninterfered dialogue between
       -------------------------------------------
       the computer and several real terminals
       ---------------------------------------

One master terminal reads file specifications for the other  terminals
and  starts up one copy of the SIMULA CLASS "terminal" for each of the
other terminals.  Each of these "terminal  processes"  will  open  the
connection  to  its  real  terminal,  and  then  go into a loop of (a)
waiting for input and (b) producing answers.

Each of these terminal loops will go on independently  of  the  other,
and the SIMULA scheduler will distribute control between the "terminal
processes".

terminalprocess CLASS terminal(file specifications);
TEXT file specifications;
INSPECT fromterminal DO
INSPECT NEW outfile(file specifications) DO
BEGIN
   PROCEDURE open terminal connections; ...
   PROCEDURE read the input and produce an answer; ...

   open terminal connections;
   WHILE TRUE DO
   BEGIN
      wait(terminalqueue);
      read the input and produce an answer;
   END;
END;

WHILE TRUE DO
BEGIN
   PROCEDURE
   read file specifications for a conversational terminal;
   ...
   TEXT file specifications;

   wait(terminalqueue);
   read file specifications for a conversational terminal;
   ACTIVATE NEW terminal(NEW infile(file specifications),
END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 275
CHAPTER 5


5.3.2  Data base system, several terminals
       -----------------------------------
       use the same data base
       ----------------------

This is a very simple example of  a  data  base  system  with  several
conversational  terminals  which independently put requests (questions
or updates) to a data base.  The actual data  base  accesses  must  be
done  for only one request at a time to avoid errors when one terminal
tries to read what another terminal is updating.

The SIMULA program contains one process  for  each  terminal  and  one
process for the data base.

The terminal processes wait for input from their respective terminals.
When  a  data  base request has been received, the terminal process is
put into a queue of data base requests.

The data base process takes one terminal process at a time  from  this
queue  and processes the data base request.  Thereafter, the data base
process ACTIVATEs the terminal process again.   When  ACTIVATEd,  this
terminal  process  writes the answer to its terminal and waits for new
requests from it.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 276
CHAPTER 5


REF (head) request queue; REF (data base) the data base;

terminalprocess CLASS terminal(file specifications);
TEXT file specifications;
INSPECT fromterminal DO
INSPECT NEW outfile(file specifications) DO
BEGIN
   PROCEDURE open terminal line; ...
   PROCEDURE read and prepare data base request; ...
   PROCEDURE write the answer to the request; ...

   WHILE TRUE DO
   BEGIN
      wait(terminalqueue);
      read and prepare data base request;
      ACTIVATE the data base;
      wait(request queue);
      write the answer to the request;
   END;
END;

process CLASS data base;
INSPECT NEW directfile(data base file specifications) DO
BEGIN
   PROCEDURE open data base file; ...
   PROCEDURE
   put the request to the data base and find the answer;
   ...

   open data base file;
   WHILE TRUE DO
   INSPECT request queue.first WHEN terminal DO
   BEGIN
      out; COMMENT to remove the terminal from the request
      queue;
      put the request to the data base and find the answer;
      ACTIVATE THIS terminal;
   END OTHERWISE passivate;
END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 277
CHAPTER 5


5.3.3  Limited response time for the terminal operator
       -----------------------------------------------

This is a very simple example of a program which is  coordinated  with
the  time  in  the  real  world.   A  question  is given to a terminal
operator and the program waits for an answer.  The program should take
different action depending on whether the answer is received within 60
seconds or not.

To do  this,  the  new  standard  procedure  SYNCHRONIZE  is  used  to
synchronize real time with the simulated time in SIMULA.

terminalprocess CLASS terminal(file specifications);
TEXT file specifications;
INSPECT fromterminal DO
INSPECT NEW outfile(file specifications) DO
BEGIN
   REAL questiontime;
   PROCEDURE open terminal connection; ...
   PROCEDURE write question to the terminal; ...
   PROCEDURE process fast answer; ...
   PROCEDURE process slow answer; ...

   open terminal connection;
   synchronize(1.0);
   write question to the terminal;
   questiontime:= time;
   wait(terminalqueue);
   IF time - questiontime < 60.0 THEN
   process fast answer ELSE
   process slow answer;
END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 278
CHAPTER 5


5.3.4  A conversational time-sharing system
       ------------------------------------

The conversational time-sharing system in this  example  could  be  an
interpreter for a language like APL or FOCAL or AID.

Highest priority is given to those input  commands  which  are  to  be
performed  directly.   Lower  priority  is  given  to  input  commands
requesting the execution of a stored  program.   When  several  stored
programs  are  in execution at the same time, CPU power is distributed
between them in a round robin fashion letting each program perform one
statement in the stored program before continuing to the next program.

terminalprocess CLASS terminal(file specifications);
TEXT file specifications;
INSPECT fromterminal DO
INSPECT NEW outfile(file specifications) DO
BEGIN
   PROCEDURE open terminal connections; ...
   PROCEDURE read the input and produce an answer;
   BEGIN
      BOOLEAN more statements, execute command;
      PROCEDURE read and interpret an input line; ...
      PROCEDURE execute the next stored program statement;
      ...
      PROCEDURE perform the command from the input line; ...
      read and interpret an input line;
      IF NOT execute command THEN
      perform the command from the input line ELSE
      WHILE more statements DO
      BEGIN
         HOLD(0); COMMENT to transfer control to another
         process;
         execute the next stored program statement;
      END;
   END;

   open terminal connections;
   WHILE TRUE DO
   BEGIN
      wait(terminalqueue);
      read the input and produce an answer;
   END;
END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 279
CHAPTER 5


5.3.5  Coordinated control of simultaneous real processes
       --------------------------------------------------

When  a  real  time  computer  program   communicates   with   several
simultaneous  processes  in  the  real world, the computer program may
want to control itself or the real-world processes  depending  on  the
results in the various processes.

Example 1:  A simulation program may want to continue  the  simulation
when all the terminals have answered certain questions.

Example 2:  A process control program may monitor  several  real-world
processes,   and  initiate  other  real-world  actions  when  previous
processes are ready.

This is similar to PERT-networks in planning,  where  certain  actions
must wait for other actions to finish.

To illustrate this, a simple example assumes a robot with three  arms.
A  process  "put  nail in board" in initiated.  This process initiates
three simultaneous processes, the first arm gets a hammer, the  second
arm gets a nail, and the third arm gets a board.  When all these three
precesses are finished, the hammer is used to push the nail  into  the
board.

In other languages, special constructs like "fork" and "join" are used
to  create parallel processes and then continue when all the processes
are ready.  But the same thing is very simple to  program  in  SIMULA,
and  in  SIMULA  we  do  not  have  to  wtin  until a process is fully
finished, we can also easily start a later process when still runnning
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 280
APPENDIX A


                              APPENDIX A
                              ----------

ISO-R 646 (=ASCII)  Characters  as  used  in  SIMULA  source  programs
outside comments.


Character      Manual  Octal  Decimal        Comment
---------      ------  -----  -------        -------

Null             ^@     000      0      Ignored  on   source   program
                                        input.

Control-A        ^A     001      1      Illegal   in   SIMULA   source
                                        programs.

Control-B        ^B     002      2      Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-C        ^C     003      3      Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-D        ^D     004      4      Illegal   in   SIMULA   source
                                        programs.

Control-E        ^E     005      5      Illegal   in   SIMULA   source
                                        programs

Control-F        ^F     006      6      Monitor command.   Illegal  in
                                        SIMULA source programs

Bell             ^G     007      7      Illegal   in   SIMULA   source
                                        programs.

Backspace        ^H     010      8      Illegal   in   SIMULA   source
                                        programs.

Tab              ^I HT  011      9      Illegal, but replaced by space
                                        in    character    and    text
                                        constants,     otherwise     a
                                        separator.

Line Feed        ^J LF  012      10     Increments  line   number (1),
                                        otherwise  replaced by a space
                                        in    character     constants,
                                        ignored  in text constants and
                                        interpreted  as  a   separator
                                        outside.


---------------------------------------------------
(1)  Certain successions of these characters indicate  only  one  line
number incrementation for the whole group of characters.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 281
APPENDIX A


Vertical Tab     VT     013      11     See "Line Feed" above.

Form Feed        FF     014      12     Gives  new  page  in   program
                                        listing.

Carriage return  CR     015      13     Ignored  in  text   constants,
                                        treated as a separator outside
                                        text constants.

Control-N        ^N     016      14     Illegal   in   SIMULA   source
                                        programs.

Control-O        ^O     017      15     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-P        ^P     020      16     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-Q        ^Q     021      17     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-R        ^R     022      18     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-S        ^S     023      19     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-T        ^T     024      20     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-U        ^U     025      21     Monitor command.   Illegal  in
                                        SIMULA source programs.

Control-V        ^V     026      22     Illegal   in   SIMULA   source
                                        programs.

Control-W        ^W     027      23     Illegal   in   SIMULA   source
                                        programs.

Control-X        ^X     030      24     Illegal   in   SIMULA   source
                                        programs.

Control-Y        ^Y     031      25     Illegal   in   SIMULA   source
                                        programs.

Control-Z        ^Z     032      26     Signifies end-of-file in input
                                        data   to  a  SIMULA  program.
                                        Illegal   in   SIMULA   source
                                        programs.

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 282
APPENDIX A


Altmode          ^[     033      27     Illegal   in   SIMULA   source
                                        programs.
Control-Shift-L  ^\     034      28     Illegal   in   SIMULA   source
                                        programs.

Control-Shift-M  ^]     035      29     Illegal   in   SIMULA   source
                                        programs.

Control-Shift-N  ^^     036      30     Illegal   in   SIMULA   source
                                        programs.

Control-Shift-O  ^_     037      31     Illegal   in   SIMULA   source
                                        programs.

Space                   040      32     Ignored     in      arithmetic
                                        constants,  accepted  in  text
                                        and    character    constants,
                                        otherwise a separator(2).

!                       041      33     Valid in  text  and  character
                                        constants, also an alternative
                                        to the SIMULA word COMMENT.

"                       042      34     Start   and   end   of    text
                                        constants, doubled inside text
                                        constants,    valid     inside
                                        character constants.

#                       043      35     Treated as a letter in  source
                                        programs, Swedish letter "AE".
                                        Equivalent    to    "{"     in
                                        identifiers.

$                       044      36     Treated as a letter in  source
                                        programs, Swedish letter "AA".
                                        Equivalent    to    "}"     in
                                        identifiers.

%                       045      37     Only  allowed  in   text   and
                                        character constants(2).

&                       046      38     Used to indicate exponent part
                                        of    [LONG]REAL    constants,
                                        otherwise only allowed in TEXT
                                        and CHARACTER CONSTANTS(2).






---------------------------------------------
(2)  This appendix does not treat the use of characters in comments.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 283
APPENDIX A


'                       047      39     Valid    inside    text    and
                                        character constants, otherwise
                                        start of a character constant.

(                       050      40     Valid    inside    text    and
                                        character  constants.  Used in
                                        expressions,   for   procedure
                                        parameters   and  indices  and
                                        array bounds.
)                       051      41     See (.

*                       052      42     Valid    inside    text    and
                                        character constants, otherwise
                                        multiplication     (*)      or
                                        exponentiation operator (**).

+                       053      43     Valid    inside    text    and
                                        character constants, otherwise
                                        addition operator.

,                       054      44     Valid    inside    text    and
                                        character constants, otherwise
                                        separator  between  parameters
                                        and between indices.

-                       055      45     Valid    inside    text    and
                                        character constants, otherwise
                                        subtract  and  used  in   ":-"
                                        operator.

.                       056      46     Valid    inside    text    and
                                        character  constants,  decimal
                                        point   in   real   constants,
                                        separates  reference  variable
                                        and class parameter for remote
                                        accessing.

/                       057      47     Valid    inside    text    and
                                        character constants, otherwise
                                        division and relational  (used
                                        in =/=) operator.

0                       060      48     Digit.

1                       061      49     Digit.

2                       062      50     Digit.

3                       063      51     Digit.

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 284
APPENDIX A


4                       064      52     Digit.

5                       065      53     Digit.

6                       066      54     Digitl

7                       067      55     Digit.

8                       070      56     Digit.

9                       071      57     Digit.
:                       072      58     Itself in text  and  character
                                        constants.   Used  to separate
                                        lower and upper  array  bound,
                                        used    in   ":="   and   ":-"
                                        operator.

;                       073      59     Itself in text  and  character
                                        constants.   Signifies  end of
                                        comment, end of declaration or
                                        end of statement.

<                       074      60     Itself in text  and  character
                                        constants.           Otherwise
                                        comparative operator

=                       075      61     Itself in text  and  character
                                        constants.    Used   in   ":="
                                        operator.   Used  for  several
                                        comparative operators.

>                       076      62     Itself in text  and  character
                                        constants.           Otherwise
                                        comparative operator.

?                       077      63     Itself in text  and  character
                                        constants.           Otherwise
                                        illegal(2).

@                       100      64     Swedish      letter      "OE".
                                        Equivalent     to    "`"    in
                                        identifiers.

A                       101      65     Letter.

B                       102      66     Letter.

C                       103      67     Letter.

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 285
APPENDIX A


D                       104      68     Letter.

E                       105      69     Letter.

F                       106      70     Letter.

G                       107      71     Letter.

H                       110      72     Letter.

I                       111      73     Letter.

J                       112      74     Letter.

K                       113      75     Letter.

L                       114      76     Letter.

M                       115      77     Letter.
N                       116      78     Letter.

O                       117      79     Letter.

P                       120      80     Letter.

Q                       121      81     Letter.

R                       122      82     Letter.

S                       123      83     Letter.

T                       124      84     Letter.

U                       125      85     Letter.

V                       126      86     Letter.

W                       127      87     Letter.

X                       130      88     Letter.

Y                       131      89     Letter.

Z                       132      90     Letter.

[                       133      91     Itself   inside    text    and
                                        character constants, otherwise
                                        array index indicator.

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 286
APPENDIX A


\                       134      92     Itself   inside    text    and
                                        character constants, otherwise
                                        the "NOT" operator and used in
                                        the "\=" operator.

]                       135      93     Itself   inside    text    and
                                        character constants, otherwise
                                        array index indicator.

^                       136      94     Itself   inside    text    and
                                        character constants, otherwise
                                        exponentiation.

_                       137      95     Itself   inside    text    and
                                        character  constants,  allowed
                                        in identifiers.

`                       140      96     Swedish      letter      "oe".
                                        Equivalent     to    "@"    in
                                        identifiers.
a                       141      97     Letter.  Equivalent to "A"  in
                                        identifiers.

b                       142      98     Letter.  Equivalent to "B"  in
                                        identifiers.

c                       143      99     Letter.  Equivalent to "C"  in
                                        identifiers.

d                       144      100    Letter.  Equivalent to "D"  in
                                        identifiers.

e                       145      101    Letter.  Equivalent to "E"  in
                                        identifiers.

f                       146      102    Letter.  Equivalent to "F"  in
                                        identifiers.

g                       147      103    Letter.  Equivalent to "G"  in
                                        identifiers.

h                       150      104    Letter.  Equivalent to "H"  in
                                        identifiers.

i                       151      105    Letter.  Equivalent to "I"  in
                                        identifiers.

j                       152      106    Letter.  Equivalent to "J"  in
                                        identifiers.

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 287
APPENDIX A


k                       153      107    Letter.  Equivalent to "K"  in
                                        identifiers.

l                       154      108    Letter.  Equivalent to "L"  in
                                        identifiers.

m                       155      109    Letter.  Equivalent to "M"  in
                                        identifiers.

n                       156      110    Letter.  Equivalent to "N"  in
                                        identifiers.

o                       157      111    Letter.  Equivalent to "O"  in
                                        identifiers.

p                       160      112    Letter.  Equivalent to "P"  in
                                        identifiers.

q                       161      113    Letter.  Equivalent to "Q"  in
                                        identifiers.
r                       162      114    Letter.  Equivalent to "R"  in
                                        identifiers.

s                       163      115    Letter.  Equivalent to "S"  in
                                        identifiers.

t                       164      116    Letter.  Equivalent to "T"  in
                                        identifiers.

u                       165      117    Letter.  Equivalent to "U"  in
                                        identifiers.

v                       166      118    Letter.  Equivalent to "V"  in
                                        identifiers.

w                       167      119    Letter.  Equivalent to "W"  in
                                        identifiers.

x                       170      120    Letter.  Equivalent to "X"  in
                                        identifiers.

y                       171      121    Letter.  Equivalent to "Y"  in
                                        identifiers.

z                       172      122    Letter.  Equivalent to "Z"  in
                                        identifiers.

{                       173      123    Swedish      letter      "ae".
                                        Equivalent     to    "#"    in
                                        identifiers.

DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 288
APPENDIX A


                        174      124    Only   legal   in   text   and
                                        character constants(2).

$                       175      125    Swedish      letter      "aa".
                                        Equivalent     to    "$"    in
                                        identifiers.

~                       176      126    Only  allowed  in   text   and
                                        character constants(2).

Rubout RO               177      127    Ignored  in   source   program
                                        input.
----------------------------------------------------------------------


Note that the use of the Swedish letters A  with  two  dots  above  it
(AE),  A with a circle above it (AA) and O with two dots above it (OE)
and their lower case representations is  not  allowed  in  identifiers
according to the SIMULA 67 Standard.  The DECsystem-10 SIMULA compiler
accepts these letters in identifiers, but programmers are  recommended
not  to  use them if they want their programs to conform to the SIMULA
standard.

Character constants in SIMULA are initialized to CHAR(0).

When comparing two text strings or character constants, the  numerical
values in the table above are used.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 289
APPENDIX B


                              APPENDIX B
                              ----------

                    THE SYSTEM DEFINED PROCEDURES
                    -----------------------------



Calls to system defined procedures conform to the syntax of  calls  to
declared  procedures.   The  identifier of a standard procedure may be
redefined to have another meaning at any block level.  The  identifier
then  assumes  the  new  meaning  throughout  the  scope of the block.
Standard procedures are available to any SIMULA program.

The system defined procedures detailed  below  are  grouped  into  the
following sections

          Arithmetic functions
          CHARACTER handling
          Random drawing procedures
          Utility procedures

For details of other procedures:

for TEXT handling                    see Chapter 3, section 4

for Sequencing procedures            see Chapter 3, section 1

for Procedures local to SIMSET       see Chapter 3, section 2

for Procedures local to SIMULATION   see Chapter 3, section 3

for Procedures local to subclasses
    of CLASS file                    see Chapter 5, section 5


A skeleton outline of all system defined  procedures  and  classes  is
given as APPENDIX C.



Arithmetic functions
--------------------

Certain identifiers, expressed as procedures are defined by the SIMULA
system for standard arithmetic functions.

ABS(E)         modulus (absolute value) of E

ARCCOS(E) *
ARCSIN(E) *
ARCTAN(E)      return  the  principal  values   of   the   arc-cosine,
               arc-sine,  arc-tangent  of E (the result is measured in
               radians)
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 290
APPENDIX B


COS(E)
SIN(E)
TAN(E) *       return the cosine, sine, tangent of E (E is measured in
               radians)

COSH(E) *
SINH(E) *
TANH(E) *      return  the   hyperbolic   cosine,   hyperbolic   sine,
               hyperbolic tangent of E

EXP(E)         exponential function of E (e^E).

LN(E)          natural logarithm of E (ln E).  If E <= 0, a  run  time
               error results.

SQRT(E)        returns the square root of E if E >= 0.  If E  <  0,  a
               run time error results.

The above 13 functions operate on arithmetic arguments.  If  the  type
of  E is INTEGER or REAL, then the function value is of type REAL.  If
the type of E is LONG REAL, then the function value is  of  type  LONG
REAL.   However,  LONG  REAL  versions of the functions marked with an
asterisk above (ARCCOS, ARCSIN, TAN, COSH, SINH  and  TANH)  will  not
initially  be available in the DECsystem-10 SIMULA system.  Therefore,
even if E is of type LONG REAL, the REAL function will be used  and  a
warning message will be given at compile-time.

SIGN(E)        sign of the value of E

                  1 if E > 0
               =  0 if E = 0
                 -1 if E < 0

ENTIER(E)      largest whole number less than or equal to E (equal  to
               or to the left of E on the real axis).

               e.g.  ENTIER(5.3)  =  5
                     ENTIER(-4.7) = -5
                     ENTIER(1)    =  1

The above 2 functions operate upon [LONG] REAL or INTEGER values of  E
and yield values of type INTEGER.

MOD(M,N)       M modulo N, that is

               M-(M//N)*N

               e.g.  MOD (7,3)      is 1
                     MOD (-48,5)    is -3

Note that MOD is not equivalent to the  mathematical  modulo  function
for negative arguments.

The function operates on INTEGER arguments, [LONG]REAL arguments being
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 291
APPENDIX B


rounded.  The result is INTEGER.  We are investigating the possibility
of modifying the  MOD  function  for  negative  values  of  M  to  the
definition M-ENTIER(M/N)*N.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 292
APPENDIX B


CHARACTER handling
------------------

Two CHARACTER subsets are defined by the standard procedures:

     BOOLEAN PROCEDURE DIGIT(C);  CHARACTER C;
     ----------------------------------------

which is TRUE if C is a digit, FALSE otherwise.

     BOOLEAN PROCEDURE LETTER(C);  CHARACTER C;
     -----------------------------------------

which is TRUE if C is an upper or lower case letter, FALSE otherwise.

The collating sequence defines a one-one mapping between the  INTEGERS
and the internal CHARACTER representation (see APPENDIX A).

     INTEGER PROCEDURE RANK(C);  CHARACTER C;
     ---------------------------------------

returns a value in the range 0 through 127.

     CHARACTER PROCEDURE CHAR(N);  INTEGER N;
     --------------------------------------

if the parameter value is not in the range 0 through 127, a  run  time
error  results.   Otherwise  the  procedure returns the CHARACTER with
value N.

Examples:
--------

          RANK('+')  =  43
          RANK('A')  =  65
          CHAR(57)   = '9'
          CHAR(8R40) = ' '
     RANK(CHAR(127)) = 127

          DIGIT(C)  =  RANK(C) >= 48 AND RANK(C) <=57
          DIGIT(C)  =  C >= '0' AND C <= '9'
          LETTER(C) = (C>= 'A' AND C <= 'Z')
                       OR (C >= 'a' AND C <= 'z')
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 293
APPENDIX B


Random drawing procedures
-------------------------

The random drawing procedures produce, in successive calls,  a  stream
of  random  numbers  taken  from  a specified distribution.  As a side
effect, the procedures update the stream variable U (which must always
be  an  INTEGER  variable)  thus advancing the specified stream by one
step.

      BOOLEAN PROCEDURE DRAW(A,U); NAME U; REAL A; INTEGER U;
      -------------------------------------------------------

         If 0 < A < 1, the value is TRUE  with  probability  A,  FALSE
         with probability 1-A.

         If A <= 0, the value is always FALSE.

         If A >= 1, the value is always TRUE.


      INTEGER PROCEDURE RANDINT(A,B,U); NAME U; INTEGER A,B,U;
      --------------------------------------------------------

         If A <= B, the value is one of the INTEGERS

              A, A+1, A+2, ....., B-1, B

         with equal probability.

         If A > B, a run time error results.


      REAL PROCEDURE UNIFORM(A,B,U); NAME U; REAL A,B; INTEGER U;
      -----------------------------------------------------------

         If A < B, the value is uniformly distributed between A and B.

         If A >= B, a run time error results.


      REAL PROCEDURE NORMAL(A,B,U); NAME U; REAL A,B; INTEGER U;
      ----------------------------------------------------------

         The value is normally distributed with mean "A" and  standard
         deviation  "B".   An  approximation  function is used for the
         normal distribution.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 294
APPENDIX B


      REAL PROCEDURE NEGEXP(A,U); NAME U; REAL A; INTEGER U;
      ------------------------------------------------------

         If A > 0, the value is  drawn  from  a  negative  exponential
         distribution  with  mean "1/A".  This is the same as a random
         waiting time in a Poisson distributed arrival pattern with an
         expected number of arrivals per time unit equal to "A".

         If A <= 0, a run time error results.


      INTEGER PROCEDURE POISSON(A,U); NAME U; REAL A; INTEGER U;
      ----------------------------------------------------------

         The value is a drawing from  the  Poisson  distribution  with
         parameter "A".

         If A > 20.0, the value is approximated by

              ENTIER(0.5 + NORMAL(A,SQRT(A),U)).

         If A < 0, the value is zero.


      REAL PROCEDURE ERLANG(A,B,U); NAME U; REAL A,B; INTEGER U;
      ----------------------------------------------------------

         If A <= 0 or B <= 0, a run time error results.

         If A > 0 and B > 0, then the value  is  a  drawing  from  the
         Erlang  distribution  with  mean "1/A" and standard deviation
         "1/(A*SQRT(B)).
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 295
APPENDIX B


      INTEGER PROCEDURE DISCRETE(A,U); NAME U; REAL ARRAY A;  (1)
      ------------------------------------------------------
                                  INTEGER U;
                                  ----------

         The one dimensional REAL ARRAY A, augmented by a unit element
         one  to  the  right, is interpreted as a step function of the
         subscript,  defining  a  discrete  (cumulative)  distribution
         function.  The function value is an INTEGER in the range

              "A.lower bound" through "A.upper bound+1"

         It is defined as the smallest I such that

              A(I) > U

         where U is a basic drawing and A(upper bound+1) = 1.0.


      REAL PROCEDURE LINEAR(A,B,U); NAME U; REAL ARRAY A,B;  (1)
      -----------------------------------------------------
                                  INTEGER U;
                                  ----------

         The  value  is  a  drawing  from  a  cumulative  distribution
         function  F,  which  is obtained by linear interpolation in a
         non-equidistant table defined by A and B, such that

              A(K)  =  F(B(I))

         It is assumed that A and B are one  dimensional  REAL  ARRAYS
         with  the  same bounds, that the first and last elements of A
         are equal to 0.0 and 1.0 respectively, and that

              A(I) >= A(J)
                            for I > J
              B(I) >= B(J)














(1)  NOTE.  NO CHECKING OF THE  CORRECTNESS  OF  THE  ARRAY  PARAMETER
CONTENTS IS PERFORMED.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 296
APPENDIX B


      INTEGER PROCEDURE HISTD(A,U);  NAME U;  REAL ARRAY A; (1)
      ---------------------------------------------------
                                  INTEGER U;
                                  ----------

         The value is an INTEGER in the range "A.lower bound"  through
         "A.upper  bound",  where  A  is  a one dimensional REAL ARRAY
         interpreted as a histogram defining the relative  frequencies
         of values.



     Utility procedures
     ------------------

     PROCEDURE HISTO(A,B,C,D);  REAL ARRAY A,B;  (1)

                               REAL C,D;

A call on HISTO updates a histogram defined  by  the  one  dimensional
ARRAYS (INTEGER or REAL) A,B according to observation C with weight D.
A(I) is incremented by D, where I is the smallest  INTEGER  such  that
C <= B(i).  It is assumed that the length of A is one greater than the
length of B.  The last element of A corresponds to those  observations
which are greater than all the elements of B.


     PROCEDURE LOWTEN(C); CHARACTER C;
     ---------------------------------

Without use of LOWTEN, the CHARACTER 'E' represents the exponent  sign
in  any  numeric item to edited or de-edited.  A call on "LOWTEN" with
actual parameter "EXPSIGN" will replace "E" by the value of EXPSIGN in
future  editing  and de-editing.  C must not be a digit, sign, period,
or an ASCII character with RANK <= 32 or RANK = 127.
















(1)  Note.  No checking of the  correctness  of  the  array  parameter
contents is performed.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 297
APPENDIX C


                              APPENDIX C
                              ----------

         SKELETON OF THE SYSTEM CLASSES AND SYSTEM PROCEDURES
         ----------------------------------------------------



Contents:
--------

     SYSTEM DEFINED PROCEDURES
          ARITHMETIC FUNCTIONS
          CHARACTER HANDLING
          TEXT HANDLING
          SEQUENCING PROCEDURES
          RANDOM DRAWING PROCEDURES
          UTILITY PROCEDURES

     SYSTEM DEFINED CLASSES
          CLASS SIMSET
          CLASS SIMULATION
          SUBCLASSES of file

     PROGRAM ENVIRONMENT


                      SYSTEM DEFINED PROCEDURES
                      -------------------------

                         ARITHMETIC FUNCTIONS
                         --------------------

*REAL PROCEDURE ABS(X); REAL X;
*REAL PROCEDURE ARCCOS(X); REAL X;
*REAL PROCESURE ARCSIN(X); REAL X;
 REAL PROCEDURE ARCTAN(X); REAL X;
 REAL PROCEDURE COS(X); REAL X;
*REAL PROCEDURE COSH(X); REAL X;
 REAL PROCEDURE EXP(X); REAL X;
 REAL PROCEDURE LN(X); REAL X;
 REAL PROCEDURE SIN(X); REAL X;
*REAL PROCEDURE SINH(X); REAL X;
 REAL PROCEDURE SQRT(X); REAL X;
*REAL PROCEDURE TAN(X); REAL X;
*REAL PROCEDURE TANH(X); REAL X;

N.B.  If the  actual  parameter  on  a  call  to  some  of  the  above
non-starred  procedures  is LONG REAL, then a LONG REAL result will be
returned.

INTEGER PROCEDURE ENTIER(X); REAL X;
INTEGER PROCEDURE MOD(X,Y); INTEGER X,Y;
INTEGER PROCEDURE SIGN(X); REAL X;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 298
APPENDIX C


                          CHARACTER HANDLING
                          ------------------


  BOOLEAN PROCEDURE DIGIT(C);  CHARACTER C;
  BOOLEAN PROCEDURE LETTER(C);  CHARACTER C;
CHARACTER PROCEDURE CHAR(N);   INTEGER N;
  INTEGER PROCEDURE RANK(C);  CHARACTER C;



                            TEXT HANDLING
                            -------------


TEXT OBJECT GENERATION
----------------------

     TEXT PROCEDURE COPY(T);  VALUE T;  TEXT T;
     TEXT PROCEDURE BLANKS(N);  INTEGER N;

TEXT ATTRIBUTES
---------------

CHARACTER PROCEDURE GETCHAR;
  INTEGER PROCEDURE GETFRAC;
  INTEGER PROCEDURE GETINT;
     REAL PROCEDURE GETREAL;
  INTEGER PROCEDURE LENGTH;
     TEXT PROCEDURE MAIN;
  BOOLEAN PROCEDURE MORE;
  INTEGER PROCEDURE POS;
          PROCEDURE PUTCHAR(C);  CHARACTER C;
          PROCEDURE PUTFIX(X,N);  [LONG] REAL X;  INTEGER N;
          PROCEDURE PUTFRAC(I,N);  INTEGER I,N;
          PROCEDURE PUTINT(I);  INTEGER I;
          PROCEDURE PUTREAL(X,N);  [LONG] REAL X;  INTEGER N;
          PROCEDURE SETPOS(N);  INTEGER N;
     TEXT PROCEDURE STRIP;
     TEXT PROCEDURE SUB(I,N);  INTEGER I,N;


                        SEQUENCING PROCEDURES
                        ---------------------

          PROCEDURE CALL(X);  REF(anyclass)X;
          PROCEDURE DETACH;
          PROCEDURE RESUME(Y);  REF(anyclass)X;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 299
APPENDIX C


                      RANDOM DRAWING PROCEDURES
                      -------------------------

  INTEGER PROCEDURE DISCRETE(A,U);  NAME U;  ARRAY A;  INTEGER U;
  BOOLEAN PROCEDURE DRAW(A,U);  NAME U;  REAL A;  INTEGER U;
     REAL PROCEDURE ERLANG(A,B,U);  NAME U;  REAL A,B;  INTEGER U;
  INTEGER PROCEDURE HISTD(A,U);  NAME U;  ARRAY A;  INTEGER U;
     REAL PROCEDURE LINEAR(A,B,U);  NAME U;  ARRAY A,B;  INTEGER U;
     REAL PROCEDURE NEGEXP(A,U);  NAME U;  REAL A;  INTEGER U;
     REAL PROCEDURE NORMAL(A,B,U);  NAME U;  REAL A,B;  INTEGER U;
  INTEGER PROCEDURE POISSON(A,U);  NAME U;  REAL A;  INTEGER U;
  INTEGER PROCEDURE RANDINT(A,B,U);  NAME U;  INTEGER A,B,U;
     REAL PROCEDURE UNIFORM(A,B,U);  NAME U;  REAL A,B;  INTEGER U;


                          UTILITY PROCEDURES
                          ------------------

          PROCEDURE HISTO(A,B,C,D);  ARRAY A,B;  REAL C,D;
          PROCEDURE LOWTEN(C);  CHARACTER C;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 300
APPENDIX C


                        SYSTEM DEFINED CLASSES
                        ----------------------


CLASS SIMSET:
------------


CLASS SIMSET;
BEGIN  CLASS LINKAGE;
       BEGIN  REF(LINK) PROCEDURE SUC;
              REF(LINK) PROCEDURE PRED;
              REF(LINKAGE) PROCEDURE PREV;
       END ***LINKAGE*** ;

LINKAGE CLASS LINK;
       BEGIN  PROCEDURE OUT;
              PROCEDURE INTO(H); REF(HEAD)H;
              PROCEDURE PRECEDE(X); REF(LINKAGE)X;
              PROCEDURE FOLLOW(X); REF(LINKAGE)X;
       END ***LINK*** ;

LINKAGE CLASS HEAD;
       BEGIN  REF(LINK) PROCEDURE FIRST;
              REF(LINK) PROCEDURE LAST;
              PROCEDURE CLEAR;
              BOOLEAN PROCEDURE EMPTY;
              INTEGER PROCEDURE CARDINAL;
       END ***HEAD*** ;

END ***SIMSET*** ;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 301
APPENDIX C


CLASS SIMULATION
----------------

SIMSET CLASS SIMULATION;
       BEGIN  LINK CLASS PROCESS;
              BEGIN  BOOLEAN PROCEDURE IDLE;
                     BOOLEAN PROCEDURE TERMINATED;
                     REAL PROCEDURE EVTIME;
                     REF(PROCESS) PROCEDURE NEXTEV;
              END ***PROCESS*** ;

              REF(PROCESS) PROCEDURE CURRENT;
              LONG REAL PROCEDURE TIME;
              PROCEDURE HOLD(T); REAL T;
              PROCEDURE PASSIVATE;
              PROCEDURE WAIT(Q); REF(HEAD)Q;
              PROCEDURE CANCEL(X); REF(PROCESS)X;
              PROCEDURE ACCUM(A,B,C,D); NAME A,B,C;
                                        REAL A,B,C,D;
              REF(main program)MAIN;
              <ACTIVATION-statements>
       END;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 302
APPENDIX C


SUBCLASSES of file
------------------

CLASS file(name); VALUE name; TEXT name;
                  VIRTUAL : PROCEDURE OPEN, CLOSE;

BEGIN  TEXT IMAGE;
       INTEGER PROCEDURE LENGTH;
       BOOLEAN PROCEDURE MORE;
       INTEGER PROCEDURE POS;
       PROCEDURE SETPOS(I); INTEGER I;
END ***file*** ;

file CLASS INFILE; VIRTUAL : BOOLEAN PROCEDURE ENDFILE;
                                     PROCEDURE IMAGE;

BEGIN           PROCEDURE CLOSE;
        BOOLEAN PROCEDURE ENDFILE;
      CHARACTER PROCEDURE INCHAR;
                PROCEDURE INIMAGE;
        INTEGER PROCEDURE ININT;
        INTEGER PROCEDURE INFRAC;
           REAL PROCEDURE INREAL;
           TEXT PROCEDURE INTEXT(N); INTEGER N;
        BOOLEAN PROCEDURE LASTITEM;
                PROCEDURE OPEN(T); TEXT T;
END ***INFILE*** ;

file CLASS OUTFILE; VIRTUAL : PROCEDURE OUTIMAGE;
BEGIN  PROCEDURE CLOSE;
       PROCEDURE OPEN(T); TEXT T;
       PROCEDURE OUTCHAR(C); CHARACTER C;
       PROCEDURE OUTFIX(R,N,W); [LONG] REAL R; INTEGER N,W;
       PROCEDURE OUTFRAC(I,N,W); INTEGER I,N,W;
       PROCEDURE OUTIMAGE;
       PROCEDURE BREAKOUTIMAGE;
       PROCEDURE OUTINT(I,W); INTEGER I,W;
       PROCEDURE OUTREAL(X,N,W); [LONG] REAL R; INTEGER N,W;
       PROCEDURE OUTTEXT(T); VALUE T; TEXT T;
END ***OUTFILE*** ;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 303
APPENDIX C


OUTFILE CLASS PRINTFILE;
BEGIN         PROCEDURE CLOSE;
              PROCEDURE EJECT(N); INTEGER N;
      INTEGER PROCEDURE LINE;
              PROCEDURE LINESPERPAGE(N); INTEGER N;
              PROCEDURE OPEN(T); TEXT T;
              PROCEDURE OUTIMAGE;
              PROCEDURE SPACING(N); INTEGER N;
END ***PRINTFILE*** ;

file CLASS DIRECTFILE; VIRTUAL : PROCEDURE LOCATE OUTIMAGE, INIMAGE;
                                 BOOLEAN PROCEDURE ENDFILE;
BEGIN           PROCEDURE CLOSE;
        BOOLEAN PROCEDURE ENDFILE;
      CHARACTER PROCEDURE INCHAR;
        INTEGER PROCEDURE INFRAC;
                PROCEDURE INIMAGE;
        INTEGER PROCEDURE ININT;
      LONG REAL PROCEDURE INREAL;
           TEXT PROCEDURE INTEXT(N); INTEGER N;
        BOOLEAN PROCEDURE LASTITEM;
                PROCEDURE LOCATE(I); INTEGER I;
        INTEGER PROCEDURE LOCATION;
                PROCEDURE OPEN(T); TEXT T;
                PROCEDURE OUTCHAR(C); CHARACTER C;
                PROCEDURE OUTFIX(X,N,W); [LONG] REAL X; INTEGER N,W;
                PROCEDURE OUTFRAC(I,N,W); INTEGER I,N,W;
                PROCEDURE OUTIMAGE;
                PROCEDURE OUTINT(I,W); INTEGER I,W;
                PROCEDURE OUTREAL(X,N,W); [LONG] REAL X; INTEGER N,W;
                PROCEDURE OUTTEXT(T); VALUE T; TEXT T;
END ***DIRECTFILE*** ;
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                 Page 304
APPENDIX C


PROGRAM ENVIRONMENT
-------------------

A user's program behaves as though enclosed as below:  (1)

     basicio(80,80)  BEGIN  INSPECT SYSIN DO
                            INSPECT SYSOUT DO
                               <program>
                   END

where "basicio" is defined by

       CLASS basicio(sysinlength,sysoutlength);
       INTEGER sysinlength,sysoutlength;
       BEGIN REF(INFILE) PROCEDURE SYSIN;
                 SYSIN:- sysin;
             REF(OUTFILE) PROCEDURE SYSOUT;
                 sysout:- sysout;
        file CLASS INFILE;
        file CLASS OUTFILE;
     OUTFILE CLASS PRINTFILE;
        file CLASS DIRECTFILE;
             sysin :- NEW INFILE("SYSIN");
             SYSIN.OPEN(BLANKS(sysinlength));)  (1)
             sysout :- NEW OUTFILE("SYSOUT");
             SYSOUT.OPEN(BLANKS(sysoutlength));  (1)
             INNER;
             SYSIN.CLOSE;
             SYSOUT.CLOSE;
         END ***basicio*** ;





















-----------------------------------------------------------
(1)  The image length of sysin and sysout  is  device  dependent,  see
section 3.5.
DECSYSTEM-10 SIMULA LANGUAGE HANDBOOK, PART I                Page 1000
APPENDIX C


                                index
                                -----


References in the index to the page number 1000 are to be
interpreted as references to parts II or III of the DECsystem-10
SIMULA Language Handbook.



!!! 5.0 Conversational terminals, use of more than one  269
!!! 5.0 HIBERNATE UUO of DECsystem-10  269
!!! 5.0 Multi-terminal system  . .  269
!!! 5.0 Real time computer applications  269
!!! 5.0 Terminals, more than one used by the same program  269
!!! 5.0 TTY-s, more than one used by the same program  269
!!! 5.3 FORK statement . . . . . .  269
!!! 5.3 JOIN statement . . . . . .  269
!!! 5.3 Semaphore variables  . . .  269
!!! 5.3.5 Industrial robot control  269
!!! 5.3.5 Process control applications  269
!!! 5.3.5 Robot control  . . . . .  269

ABS function . . . . . . . . . . .  289
Access into a CLASS object . . . .  134-135, 156, 183-184
Access into a CLASS object (Simple introduction)  37
Accessible . . . . . . . . . . . .  189
Accessing  . . . . . . . . . . . .  36
ACCUM  . . . . . . . . . . . . . .  207
Activate . . . . . . . . . . . . .  207, 210
Activate statement, syntax and semantics  210
Activation statement (in table of statement kinds)  165
Activation statements (in table of statement kinds)  174
Active . . . . . . . . . . . . . .  56, 186
Actual parameter . . . . . . . . .  136
Actual parameter list  . . . . . .  136
Actual parameter part  . . . . . .  153
Actual parameter part in expression  153
Actual parameter when making NEW class objects  116
Actual parameter, correspondence with formal  114
Actual parameter, introduction . .  35
Actual parameter, redeclaration of  103
Actual parameter, transfer by name  109-110
Actual parameter, transfer by reference  107
Actual parameter, transfer by value  105
Actual parameter, transfer of  . .  103
Actual-formal parameter correspondence  137
Addition sign (+)  . . . . . . . .  71
Address of DECsystem-10 SIMULA maintenance  2
AFTER in the activate statement  .  76, 210
Allocate of structure instances  .  155, 185
Allocation of TEXT character strings  228
Alphabetic character . . . . . . .  68
Alphanumeric character . . . . . .  71
Alternatives . . . . . . . . . . .  66
ALTMODE character  . . . . . . . .  282
Ampersand character (&)  . . . . .  84
Ampersand character (&)  . . . . .  282
AND  . . . . . . . . . . . . . . .  26, 75, 147
ARCCOS function  . . . . . . . . .  289
ARCSIN function  . . . . . . . . .  289
ARCTAN function  . . . . . . . . .  289
Argument to a procedure, see Parameter  103-104
Argument to an array . . . . . . .  135
Arguments to a CLASS . . . . . . .  113
Arithmetic constants . . . . . . .  84, 138
Arithmetic expression in assignment statement  169
Arithmetic expressions . . . . . .  131-132, 138
Arithmetic expressions, as array subscript  132, 135
Arithmetic expressions, syntax and semantics of  138
Arithmetic function designator . .  139
Arithmetic IF statement  . . . . .  11
Arithmetic operator precedence . .  144
Arithmetic operators . . . . . . .  71, 138
Arithmetic operators and types . .  140
Arithmetic primary . . . . . . . .  138
Arithmetic type conversion . . . .  92
Arithmetic variable  . . . . . . .  138
Arithmetics of (LONG)REAL quantities  140
ARRAY  . . . . . . . . . . . . . .  17, 72, 94
ARRAY as a parameter . . . . . . .  100
ARRAY as CLASS attribute . . . . .  113
ARRAY bounds, exceeding of . . . .  135
ARRAY component  . . . . . . . . .  94, 135
ARRAY declaration  . . . . . . . .  94, 97
ARRAY dimension  . . . . . . . . .  94
ARRAY identifier . . . . . . . . .  136
ARRAY initialization of  . . . . .  94, 97
ARRAY segment  . . . . . . . . . .  97
ARRAY, as CLASS parameter  . . . .  113
ARRAY, three-dimensional . . . . .  96
ARRAY, two-dimensional . . . . . .  95
ASCII 7 bit character set  . . . .  78, 280
Assembly language procedure  . . .  124
Assembly language(MACRO 10) procedures, see part II  1000
Assignable range of variables, table  93
Assignable range, BOOLEAN  . . . .  92
Assignable range, CHARACTER  . . .  92
Assignable range, INTEGER  . . . .  91
Assignable range, LONG REAL  . . .  91
Assignable range, REAL . . . . . .  91
Assignable range, REF  . . . . . .  92
Assignable range, SHORT INTEGER  .  91
Assignable range, TEXT . . . . . .  92
Assignment . . . . . . . . . . . .  8, 132, 165-166
Asterisk (*) . . . . . . . . . . .  69
AT in the activate statement . . .  76, 210
Attached state . . . . . . . . . .  188
Attribute  . . . . . . . . . . . .  37, 133
Attribute redefinition (VIRTUAL) .  116, 119-120
Attributes of CLASSes  . . . . . .  114

Basic binding rules  . . . . . . .  81
Basic concepts of SIMULA . . . . .  6
Basic symbol . . . . . . . . . . .  62, 64, 68, 71
Basic symbol set . . . . . . . . .  71
Basic symbols and syntactic variables  68
BASICIO  . . . . . . . . . . . . .  237
Batch jobs, see part II  . . . . .  1000
Becomes sign (:=)  . . . . . . . .  73
BEFORE . . . . . . . . . . . . . .  76
BEFORE in the activate statement .  210
BEGIN  . . . . . . . . . . . . . .  74
BEGIN (In CLASS declaration) . . .  112
BEGIN as start of a block  . . . .  160
BEGIN as start of a compound statement  161
Bi-directional list  . . . . . . .  195
Bibliography . . . . . . . . . . .  5
Binary constant  . . . . . . . . .  87
Binary i/o, see part III . . . . .  1000
Binding rule . . . . . . . . . . .  13, 81
Binding rules, connection  . . . .  184
Binding rules, remote accessing  .  133
Binding rules, virtual quantities   120
Blank  . . . . . . . . . . . . . .  220, 223
Blank character  . . . . . . . . .  73
Blank, in CHARACTER constant . . .  87
Blank, in TEXT constant  . . . . .  88
BLANKS, procedure for allocation of TEXTs  228
Block  . . . . . . . . . . . . . .  11, 160, 163
Block head . . . . . . . . . . . .  89, 160
Block instance . . . . . . . . . .  13
Block prefix SIMSET  . . . . . . .  195
Blocks and compound statements . .  160
Blocks and statements  . . . . . .  160
BOOLEAN  . . . . . . . . . . . . .  74, 91
BOOLEAN CLASS attribute  . . . . .  111
BOOLEAN condition governing loop .  173
BOOLEAN expression . . . . . . . .  145
BOOLEAN function designator  . . .  145
BOOLEAN operator . . . . . . . . .  145, 147
BOOLEAN primary  . . . . . . . . .  145
BOOLEAN variable . . . . . . . . .  145
BOOLEAN, assignable range  . . . .  93
Bounds of an array, exceeding of .  135
Bounds of ARRAY as CLASS attribute  113
Braces . . . . . . . . . . . . . .  65
Bracket, square ([ and ])  . . . .  72, 94
Brackets . . . . . . . . . . . . .  71
Branch on condition  . . . . . . .  181
BREAKOUTIMAGE  . . . . . . . . . .  245
Buffer . . . . . . . . . . . . . .  239
Built-in mathematical functions, type of  143

Call by NAME for procedures, table  104
Call by NAME of CLASS parameters (disallowed)  111
Call by NAME parameter in FOR statement  179
Call by NAME, disallowed to classes  104
Call by NAME, example of use . . .  101
Call by NAME, semantics  . . . . .  109-110
Call by NAME, syntax of  . . . . .  100
Call by reference for procedures, table  104
Call by reference of CLASS parameters  113
Call by reference, default . . . .  104
CALL by VALUE  . . . . . . . . . .  100
CALL by VALUE for procedures, table  104
CALL by VALUE of CLASS parameters   113
CALL by VALUE, default . . . . . .  104
CALL of a CLASS object . . . . . .  114
Call of a subroutine . . . . . . .  180
CALL statement of FORTRAN and PL/I  180
CALL, procedure for attaching class objects  194
Calling a procedure  . . . . . . .  180
CANCEL . . . . . . . . . . . . . .  207, 209
Car wash simulation  . . . . . . .  53
Card reader  . . . . . . . . . . .  255
Card source program input  . . . .  80
CARRIAGE RETURN character  . . . .  281
CASE statement, see INSPECT  . . .  183
CASE statement, see SWITCH . . . .  98
CASE statement, see VIRTUAL procedures  119
Case, upper and lower  . . . . . .  68
Catenation of TEXTs  . . . . . . .  231
Chaining of items  . . . . . . . .  195
CHAR PROCEDURE converts integer to character  292
CHARACTER  . . . . . . . . . . . .  78, 91
CHARACTER access (to TEXTs)  . . .  222
CHARACTER ARRAY  . . . . . . . . .  220
CHARACTER as CLASS parameter . . .  111
CHARACTER constant . . . . . . . .  150
CHARACTER expression . . . . . . .  131, 150
CHARACTER function designator  . .  150
CHARACTER quote (')  . . . . . . .  72, 87
Character set  . . . . . . . . . .  78, 280
CHARACTER string . . . . . . . . .  220
Character string memory allocation  228
Character string processing  . . .  220
Character strings, concatenation of  231
CHARACTER to INTEGER conversion  .  150
CHARACTER values, comparison . . .  148-149
CHARACTER variable . . . . . . . .  150
CHARACTER, assignable range  . . .  93
CHARACTER, printable . . . . . . .  87
CHARACTER, upper and lower case of  68
CHARACTER-INTEGER conversion . . .  292
Circular list  . . . . . . . . . .  195
CLASS  . . . . . . . . . . . . . .  32, 74
CLASS (Simple introduction)  . . .  32
CLASS attribute initialization . .  115
CLASS BASICIO  . . . . . . . . . .  237
CLASS body . . . . . . . . . . . .  38, 89, 105, 107, 111-114, 118
CLASS body, generation of  . . . .  155
CLASS body, protection of access to  125
CLASS declaration  . . . . . . . .  36, 111
CLASS DIRECTFILE . . . . . . . . .  237-238, 252
CLASS entry points . . . . . . . .  120
CLASS FILE . . . . . . . . . . . .  237
CLASS HEAD . . . . . . . . . . . .  56, 195
CLASS HEAD in SIMSET . . . . . . .  195
CLASS hierarchies  . . . . . . . .  117
CLASS identifier . . . . . . . . .  111
CLASS identifier as block prefix .  160
CLASS identifier in expression with IN or IS  148
CLASS identifier in NEW statement   153
CLASS INFILE . . . . . . . . . . .  237-238, 240
CLASS instance . . . . . . . . . .  111
CLASS LINK in SIMSET . . . . . . .  56, 195
CLASS LINKAGE in SIMSET  . . . . .  195
CLASS object generation  . . . . .  155, 185
CLASS OUTFILE  . . . . . . . . . .  237, 244
CLASS parameters (table) . . . . .  113
CLASS PRINTFILE  . . . . . . . . .  237, 247
CLASS PROCESS  . . . . . . . . . .  56
CLASS SIMSET . . . . . . . . . . .  195
CLASS SIMSET, prefix to CLASS SIMULATION  206
CLASS SIMULATION . . . . . . . . .  56, 207
CLASS SIMULATION makes activation statements valid  174
CLASS specification part . . . . .  113
CLASS treatment  . . . . . . . . .  215
CLOSE  . . . . . . . . . . . . . .  238-241, 244, 247, 252-253, 257
Closed statements  . . . . . . . .  165
Co-routine sequensing  . . . . . .  191-192, 208
Collating sequence . . . . . . . .  78
Colon (:)  . . . . . . . . . . . .  10, 69, 112
Colon (:) after label  . . . . . .  165
Column 73-80 . . . . . . . . . . .  80
Column of input-output line = image.pos  238-239
Comma (,)  . . . . . . . . . . . .  73
Comma (,) in array subscript list   132
Comma (,) in procedure call statement  180
Comma (,), use between subscripts   136
COMMENT  . . . . . . . . . . . . .  23, 73
COMMON statement of FORTRAN  . . .  259-260
Comparing operators  . . . . . . .  146
Compile time . . . . . . . . . . .  7
Compile time and run time  . . . .  7
Compile time error messages, see part II  1000
Compiler switches, see part II . .  1000
COMPLEX arithmetic . . . . . . . .  92
Compound statement . . . . . . . .  26, 160, 163
Compound tail  . . . . . . . . . .  160
Concatenation of TEXTs . . . . . .  231
Concatenation of texts, see part III  1000
Condition  . . . . . . . . . . . .  131, 139
Conditional branch . . . . . . . .  181
Conditional loop . . . . . . . . .  173
Conditional statement  . . . . . .  9
Conditional statement, IF-THEN-ELSE ambiguity  163
Connection block . . . . . . . . .  158
Connection statement . . . . . . .  164, 183
Connection statement, syntax and semantics  183
Constants  . . . . . . . . . . . .  83-88
Constants, arithmetic  . . . . . .  84
Constants, binary  . . . . . . . .  87
Constants, Boolean . . . . . . . .  87
Constants, character . . . . . . .  87
Constants, decimal . . . . . . . .  84
Constants, hexadecimal . . . . . .  87
Constants, integer . . . . . . . .  85
Constants, logical . . . . . . . .  87
Constants, octal . . . . . . . . .  87
Constants, reference . . . . . . .  88
Constants, text (=character string)  88
Constants, use in expression . . .  138
Constants, [long] real . . . . . .  85
Controlled statement . . . . . . .  174
Controlled variable  . . . . . . .  175
Conversational i/o, see part III .  1000
Conversational terminal  . . . . .  256
Conversational terminal, output to  238, 245, 247, 254-256
Conversion between CHARACTER and INTEGER  292
Conversion from INTEGER to CHARACTER  150
Conversion from numerical value to TEXT  234
Conversion from REAL to INTEGER  .  290
Conversion from TEXT to numerical value  226, 232-233
COPY procedure for copying TEXTs .  220, 228
Copying of character strings (TEXTs)  228
COS function . . . . . . . . . . .  289
COSH function  . . . . . . . . . .  290
CPU efficiency, procedure call versus class call  114
Creation of a new object . . . . .  155, 185
Critical regions . . . . . . . . .  194
CRT terminal, output to  . . . . .  247
CURRENT in CLASS SIMULATION  . . .  206-207

Data Base Handling, see part III .  1000
Data base handling, see part III .  1000
Data character set . . . . . . . .  71
Data collection  . . . . . . . . .  212
Data set handling  . . . . . . . .  237
De-editing procedures  . . . . . .  223, 226, 232-233, 236
Debugging system (SIMDDT), see part II  1000
Decimal constant . . . . . . . . .  84-86
Decimal digit  . . . . . . . . . .  68, 84
Declaration  . . . . . . . . . . .  89
Declaration as part of a block . .  160
Declaration of a CLASS . . . . . .  111
Declarator . . . . . . . . . . . .  74
DECsystem-10 dependent parts of SIMULA, see part II  1000
Default action (AFTER/BEFORE)  . .  211
Default action (AT/DELAY)  . . . .  211
Default initial variable value (table)  92
Default mode of parameter transmission  104
Default value of a function designator  103
Defense Research Institute (Swedish)  2
Defining document of the SIMULA Language  5
DELAY in ACTIVATE statement  . . .  76, 210
Delete character (Octal 177) . . .  84
Delete of TEXTs  . . . . . . . . .  228
Deletion of CLASS objects  . . . .  155
Delimiters . . . . . . . . . . . .  71
Denotes sign (:-)  . . . . . . . .  73
Depending bounds of an ARRAY . . .  113
Designational expression . . . . .  98, 131, 151, 170
Destroy of CLASS objects . . . . .  155
Destroy of TEXTs . . . . . . . . .  228
DETACH (outside CLASS SIMULATION)   114, 155, 192
DETACH (outside CLASS SIMULATION), semantics  192
DETACH in CLASS SIMULATION . . . .  207
Detached state . . . . . . . . . .  155
Device control characters  . . . .  71
Diagnostics from the SIMULA system, see part II  1000
Diagram  . . . . . . . . . . . . .  31
Digit  . . . . . . . . . . . . . .  232, 283
Digit in identifiers . . . . . . .  80
DIGIT, BOOLEAN PROCEDURE . . . . .  292
Digital constant in source program  85
Direct access file . . . . . . . .  252
Direct activation  . . . . . . . .  210
DIRECTFILE . . . . . . . . . . . .  252, 303
DIRECTFILE, see part II  . . . . .  1000
DISCRETE random drawing procedure   295
Display terminal, output to  . . .  247
Divide (/) . . . . . . . . . . . .  69
DO . . . . . . . . . . . . . . . .  76
DO in FOR statement  . . . . . . .  174-175
DO in INSPECT statement  . . . . .  183
DO in WHILE statement  . . . . . .  173
DO statement in FORTRAN  . . . . .  174
DO statement in PL/I . . . . . . .  164
Dot (.)  . . . . . . . . . . . . .  69
Dot (.) as decimal point . . . . .  84
Dot (.) preceding procedure call statement  180
Dot (.), for remote accessing into class objects  49, 133
Double quote (") . . . . . . . . .  282
Double quote inside TEXT constants  88
DRAW random drawing procedure  . .  293
Dummy statement  . . . . . . . . .  165, 170, 172
Dummy statement behaviour of INNER  119
Dummy statement instead of CLASS body  124
Dynamic memory allocation  . . . .  155
Dynamic memory allocation, introduction  36

E, exponent sign . . . . . . . . .  235
EBCDIC character set . . . . . . .  78, 280
EDITed input . . . . . . . . . . .  240
EDITed output  . . . . . . . . . .  244
Editing of SIMULA source programs, see part II  1000
Editing procedures . . . . . . . .  232, 234
Efficiency of quasi-parallel processing  114
Efficiency, procedure call versus class call  114
EJECT  . . . . . . . . . . . . . .  247-248
Element oriented i/o . . . . . . .  243
Element oriented input . . . . . .  240
Element oriented output  . . . . .  244
ELSE . . . . . . . . . . . . . . .  76, 138
ELSE in object expression  . . . .  153
ELSE, with character expression  .  150
Empty part and VIRTUAL part  . . .  113
Empty TEXT value (NOTEXT)  . . . .  77
END  . . . . . . . . . . . . . . .  79, 161
END in CLASS declaration . . . . .  112
END of a block . . . . . . . . . .  160
END of a compound statement  . . .  161
End of file  . . . . . . . . . . .  240-241
End of file condition: procedure LASTITEM  240-243, 252
ENDFILE  . . . . . . . . . . . . .  240-241
ENTIER function  . . . . . . . . .  290
Entry points into a subroutine . .  120
EQ (=) . . . . . . . . . . . . . .  72, 146
Equal to sign (=)  . . . . . . . .  69, 72
Equivalence (EQV) Boolean (logical) operator  75
Equivalence = shared storage, use garbage collector  155
Equivalence of TEXTs, see Subtext   225
EQV  . . . . . . . . . . . . . . .  75, 147
ERLANG random drawing procedure  .  294
Error messages, see part II  . . .  1000
Error report form, see part II . .  1000
Event generation in CLASS SIMULATION  208-209
Event in CLASS SIMULATION  . . . .  206
Event notice in CLASS SIMULATION .  206
Evtime in CLASS SIMULATION . . . .  206, 208
Examples . . . . . . . . . . . . .  6
Exclamation mark (!) . . . . . . .  73
Exit from a block  . . . . . . . .  89
EXP function . . . . . . . . . . .  289
Exponent sign (&)  . . . . . . . .  69
Exponent sign (&)  . . . . . . . .  84
Exponent sign in decimal constant   84
Exponent, in [LONG] REAL constant   84
Expression . . . . . . . . . . . .  131, 136
Expression in assignment statement  166
EXTERNAL CLASS . . . . . . . . . .  261-263
EXTERNAL CLASS, see part II  . . .  1000
External data  . . . . . . . . . .  237-238
EXTERNAL declaration . . . . . . .  124
External file  . . . . . . . . . .  237
EXTERNAL PROCEDURE . . . . . . . .  261, 263
EXTERNAL PROCEDURE, see part II  .  1000
External record  . . . . . . . . .  237

FALSE  . . . . . . . . . . . . . .  77, 87, 145
Field  . . . . . . . . . . . . . .  242, 246
Figure . . . . . . . . . . . . . .  31
File . . . . . . . . . . . . . . .  237
File handling  . . . . . . . . . .  237
File handling, DEC 10 dependent parts, see part II  1000
File handling, direct random access  252
File name  . . . . . . . . . . . .  238
First value of CLASS attributes  .  115
Fixed field text editing . . . . .  235
Floating point constant  . . . . .  84-85
Floating point expressions . . . .  140-142
Floating point value range . . . .  93
FOA  . . . . . . . . . . . . . . .  2
FOLLOW in SIMSET . . . . . . . . .  196, 200
FOR  . . . . . . . . . . . . . . .  76
FOR list element . . . . . . . . .  176
FOR statement  . . . . . . . . . .  12, 174
FOR statement and local labels . .  179
FOR statement, ambiguity with  . .  164
FOR statement, restrictions on, see part II  1000
FORM FEED character  . . . . . . .  71, 281
Formal parameter . . . . . . . . .  81
Formal parameter part  . . . . . .  109
Formal-actual parameter correspondence  137
Formalism of syntax description in this manual  62
FORMAT statement of FORTRAN  . . .  233-234
FORMATted input  . . . . . . . . .  240
FORMATted output . . . . . . . . .  244
FORTRAN subroutine called from SIMULA  124
FORTRAN subroutine called from SIMULA, see part II  1000
FREE of storage  . . . . . . . . .  155
Free on TEXTs  . . . . . . . . . .  228
Function . . . . . . . . . . . . .  99
Function declaration . . . . . . .  99
Function designator  . . . . . . .  131, 136, 153

Garbage collection of TEXTs  . . .  228
Garbage collector  . . . . . . . .  155
GE (>=)  . . . . . . . . . . . . .  72, 146
Generated object . . . . . . . . .  155
Generation of new class objects  .  155, 185
Generation of TEXT character strings  228
Geometrical application  . . . . .  31
GETCHAR  . . . . . . . . . . . . .  226
GETFRAC  . . . . . . . . . . . . .  234
GETINT . . . . . . . . . . . . . .  234
GETREAL  . . . . . . . . . . . . .  234
GO TO  . . . . . . . . . . . . . .  170
GO TO exit . . . . . . . . . . . .  114, 189
GO TO statement  . . . . . . . . .  9, 76, 170, 189
GO TO, assigned  . . . . . . . . .  98
GO TO, computed  . . . . . . . . .  98
Graphic terminal handling, see part III  1000
Graphical applictions  . . . . . .  31
Greater than (>) . . . . . . . . .  69, 72, 146
Greater than on characters . . . .  78
Greater than or equal to sign (>=)  72
Group markers  . . . . . . . . . .  234
Grouped item . . . . . . . . . . .  234
GT (>) . . . . . . . . . . . . . .  72, 146

Hardware representation, see part II  1000
HEAD in SIMSET . . . . . . . . . .  195-196, 199
Heap memory  . . . . . . . . . . .  155
Hexadecimal constant . . . . . . .  87
HIDDEN PROTECTED protection feature  125
HIDDEN specification . . . . . . .  125
HIDDEN, syntax . . . . . . . . . .  75
HISTD random drawing procedure . .  296
HOLD in CLASS SIMULATION . . . . .  206-207, 209
Hyperbolic functions . . . . . . .  290

i/o, see Input-output  . . . . . .  237
IBM 360/370 type compatibility with  91
Identifier . . . . . . . . . . . .  68, 89, 189
Identifier clash . . . . . . . . .  137, 189
Identifier list  . . . . . . . . .  91, 100, 111
Identifier, with upper and lower case letters in  68
Identifiers and key words  . . . .  81
Idle in CLASS SIMULATION . . . . .  208
IF . . . . . . . . . . . . . . . .  76
IF clause  . . . . . . . . . . . .  131, 138-140, 145, 150, 158
IF clause  . . . . . . . . . . . .  181
IF clause example of use in expression  139
IF clause in object expression . .  154
IF clause in text expression . . .  159
IF clause, with character expression  150
IF statement . . . . . . . . . . .  181
IF statement, ambiguity with . . .  163
IFIX function  . . . . . . . . . .  290
IMAGE  . . . . . . . . . . . . . .  238-245
IMAGE size for SYSIN and SYSOUT  .  254
IMP  . . . . . . . . . . . . . . .  75, 147
Implication (IMP) Boolean operator  75, 147
IN . . . . . . . . . . . . . . . .  77, 148
INCHAR . . . . . . . . . . . . . .  240-242, 252
INCLUDED CLASSes of prefixing CLASSes  118
Index to an array  . . . . . . . .  135
INFILE . . . . . . . . . . . . . .  237, 240, 254, 302
INFILE, see part II  . . . . . . .  1000
INFRAC . . . . . . . . . . . . . .  240-241, 243, 252
INIMAGE  . . . . . . . . . . . . .  240-241, 252
ININT  . . . . . . . . . . . . . .  240
Initial value for each variable type (table)  92-93
Initial value of CLASS attributes.  115
Initial value, introduction  . . .  11
Initial value, type dependency of   83
Initialization of CLASS attributes.  115
INNER  . . . . . . . . . . . . . .  76, 107, 112, 118-119, 122
INNER accesibility (VIRTUAL) . . .  119
Inner block  . . . . . . . . . . .  22
INNER levels, access by connection statement  184
INNER, example with protection . .  129
INNER, use in BASICIO  . . . . . .  254, 257
Input from TTY, IMAGE size (Line length)  254
Input, formatted . . . . . . . . .  240
Input-output . . . . . . . . . . .  237
Input-output, DEC 10 dependent parts, see part II  1000
Input-output, element oriented . .  243
input-output, non-formatted, binary, see part III  1000
input-output, record oriented  . .  241
Input-output, record oriented, see part III  1000
INREAL . . . . . . . . . . . . . .  240-241, 243, 252, 256
INSPECT  . . . . . . . . . . . . .  52, 76, 164, 183
INSPECT syntax and semantics . . .  183
Instantaneous qualification  . . .  158
INT function . . . . . . . . . . .  290
INTEGER  . . . . . . . . . . . . .  74, 85, 91
INTEGER as CLASS attributes  . . .  111
INTEGER constant . . . . . . . . .  85
INTEGER declaration  . . . . . . .  91
INTEGER division sign (//) . . . .  71
INTEGER from REAL conversion . . .  290
INTEGER in expressions . . . . . .  140
INTEGER item . . . . . . . . . . .  235
INTEGER, assignable range  . . . .  93
INTEGER-CHARACTER conversion . . .  150, 292
INTEXT . . . . . . . . . . . . . .  240-242, 252, 256
INTO in SIMSET . . . . . . . . . .  196, 200
IS . . . . . . . . . . . . . . . .  77, 148
ISO 7 bit character set  . . . . .  78, 280
Iteration statement  . . . . . . .  174

Jump on condition  . . . . . . . .  181
Jump statement . . . . . . . . . .  170
Jump statement, variable, computed, assigned  98

Key word . . . . . . . . . . . . .  62, 71
Key word constant  . . . . . . . .  71
Kill of TEXTs  . . . . . . . . . .  228

Label  . . . . . . . . . . . . . .  73, 100, 165, 170
Label as formal parameter  . . . .  81
Label before END . . . . . . . . .  172
Label identifier . . . . . . . . .  136, 151
Label in front of FOR-statement  .  175
Label inside a procedure . . . . .  103
Label, as procedure parameter  . .  105
Label, as procedure parameter by reference  107
Label, as procedure parameter, table  104
Label, hiding of . . . . . . . . .  129
Label, local to a FOR statement  .  171
Label, variable  . . . . . . . . .  98
Label, virtual . . . . . . . . . .  112
Language character set . . . . . .  68, 71
Language used in this manual . . .  62
LASTITEM . . . . . . . . . . . . .  240-243, 252
LE (<=)  . . . . . . . . . . . . .  72, 146
Left parenthesis (() . . . . . . .  78, 94, 111, 151
Left parenthesis (() in expression  138
Left parenthesis ((), use in CLASS declaration  111
Left square bracket  . . . . . . .  94
LENGTH . . . . . . . . . . . . . .  224
LENGTH of a file image . . . . . .  238
LENGTH of a TEXT . . . . . . . . .  220
Length of a text value . . . . . .  224
Length of identifiers  . . . . . .  81
Length of input lines, SYSIN from TTY  254
Length of output lines, SYSOUT to TTY  254
Less than on characters  . . . . .  78
Less than or equal to sign (<=)  .  72
Less than sign (<) . . . . . . . .  72
Letter . . . . . . . . . . . . . .  282
Letter in identifier . . . . . . .  80
LETTER, BOOLEAN PROCEDURE  . . . .  292
Letter, Swedish  . . . . . . . . .  68
Letter, upper and lower case of  .  68
Line . . . . . . . . . . . . . . .  238-240
LINE FEED character  . . . . . . .  280
Line in input or output  . . . . .  240-245
Line length  . . . . . . . . . . .  80
Line number generation . . . . . .  280-281
Line numbered source program files, see part II  1000
Line printer . . . . . . . . . . .  247-248, 255
LINEAR random drawing procedure  .  295
Linelength . . . . . . . . . . . .  238-239
Linelength, default value for SYSIN and SYSOUT  254
LINESPERPAGE . . . . . . . . . . .  247
LINK in SIMSET . . . . . . . . . .  195, 200
LINKAGE in SIMSET  . . . . . . . .  195, 197
Linked lists of items  . . . . . .  195
Linking of TEXTs . . . . . . . . .  231
List processing  . . . . . . . . .  195
List processing (Simple introduction)  40
Listing of program, division into pages  281
Literal constants  . . . . . . . .  83-88
Litterature  . . . . . . . . . . .  5
LN function  . . . . . . . . . . .  290
Local object . . . . . . . . . . .  158
Local quantity in a block  . . . .  161
Local sequence control (LSC) . . .  191
LOCATE . . . . . . . . . . . . . .  252-253
Location . . . . . . . . . . . . .  252
Logarithm  . . . . . . . . . . . .  290
Logical AND  . . . . . . . . . . .  75
Logical condition governing loop .  173
Logical equivalence (EQV)  . . . .  75
Logical expression . . . . . . . .  145
Logical IF statement . . . . . . .  181
Logical implication (IMP)  . . . .  75
Logical inclusive or (OR)  . . . .  75
Logical negation (NOT, \)  . . . .  71
Logical operator . . . . . . . . .  71, 145
LONG REAL  . . . . . . . . . . . .  73
LONG REAL as CLASS attribute . . .  111
LONG REAL constant . . . . . . . .  84-85
LONG REAL declaration  . . . . . .  91
LONG REAL in expression  . . . . .  140
LONG REAL, assignable range  . . .  91, 93
LONG REAL, availability of functions in  290
LONG REAL, syntax  . . . . . . . .  91
Loop statement . . . . . . . . . .  174
Loop, conditional  . . . . . . . .  173
Lower bound  . . . . . . . . . . .  94
Lower case characters  . . . . . .  68
Lower subscript bound  . . . . . .  94
LOWTEN . . . . . . . . . . . . . .  233, 296
LSC  . . . . . . . . . . . . . . .  191
LT (<) . . . . . . . . . . . . . .  72, 146

MACRO 10 procedure called from SIMULA program  124
MACRO 10 procedure called from SIMULA, see part II  1000
Mailing list for users of DECsystem-10 SIMULA  2
Main block = part of block after prefix  160
MAIN in CLASS SIMULATION . . . . .  206-207, 209
MAIN of TEXTs  . . . . . . . . . .  224
Main part of CLASS declaration . .  111
Manuals, list of . . . . . . . . .  5
Matching attribute (VIRTUAL) . . .  123
Matching qualification . . . . . .  107
Mathematical functions . . . . . .  289
Mathematical functions, type of  .  143
Matrix handling  . . . . . . . . .  95
Maximum value of variables, table   93
Memory allocation for TEXT character strings  228
Metalanguage in this manual  . . .  62
Minimum value of variables, table   93
Minus (-)  . . . . . . . . . . . .  71
MOD function . . . . . . . . . . .  290
Mode part  . . . . . . . . . . . .  99
Modulo function  . . . . . . . . .  290
MORE . . . . . . . . . . . . . . .  222, 226, 246
Multi-terminal applications, see part III  1000
Multiple assignment  . . . . . . .  25
Multiplication sign (*)  . . . . .  71

NAME parameter to a CLASS (disallowed)  111
NAME parameter transmission, introduction  39
NAME parameter transmission, semantics  109-110
NAME parameters for procedures, table  104
NAME parameters to classes disallowed  104
NAME, example of use . . . . . . .  101
NAME, syntax . . . . . . . . . . .  75
NAME, syntax of  . . . . . . . . .  100
National character . . . . . . . .  68, 282, 284, 286-288
National Defense Research Institute (Swedish)  2
NE (\=)  . . . . . . . . . . . . .  146
NE (\=)  . . . . . . . . . . . . .  72
NEGEXP random drawing procedure  .  294
NEW (Example)  . . . . . . . . . .  49
NEW (Simple introduction)  . . . .  36
NEW operator, parameter correspondence to  114
NEW operator, semantics  . . . . .  155
NEW operator, table of parameter transmission  113
NEW statement, semantics . . . . .  185
NEW TEXT generation  . . . . . . .  228
NEW, syntax  . . . . . . . . . . .  77, 153
Newsletter on SIMULA . . . . . . .  5
Nextev in CLASS SIMULATION . . . .  208
Non-empty prefix and empty virtual part  116
Non-formatted i/o, see part III  .  1000
NONE . . . . . . . . . . . . . . .  37, 77, 88, 153
NONE in object expression  . . . .  153
NORMAL random drawing procedure  .  293
Norwegian Computing Centre . . . .  5
NOT (\)  . . . . . . . . . . . . .  146
NOT (\)  . . . . . . . . . . . . .  71
NOT (\)  . . . . . . . . . . . . .  71
NOT EQUAL TO SIGN (\=) . . . . . .  72
NOT EQUAL TO SIGN (\=) . . . . . .  70
Notation used in this manual . . .  62
NOTEXT . . . . . . . . . . . . . .  77, 220
NOTEXT in TEXT expression  . . . .  159
NOTEXT, POS of . . . . . . . . . .  226
NOTEXT, use of to make a TEXT wholly blank  227
Null character (Octal 177) . . . .  84
Null character (Octal zero)  . . .  84
Number constant in source program   85
Number systems . . . . . . . . . .  87
Number, binary, octal or hexadecimal  87
Number, decimal  . . . . . . . . .  84
Number, integer  . . . . . . . . .  85
Number, [LONG] REAL  . . . . . . .  84
Numeric item . . . . . . . . . . .  233-234
Numeric text values  . . . . . . .  233-234
Numerical value to TEXT conversion  234
Numerical value, conversion from TEXT  233

Object . . . . . . . . . . . . . .  153
Object element . . . . . . . . . .  175
Object expression  . . . . . . . .  131-133, 148, 153-154, 176
Object expression, syntax and semantics of  153
Object generator . . . . . . . . .  153, 185
Object in expression . . . . . . .  153
Object of a CLASS  . . . . . . . .  111
Object program . . . . . . . . . .  7
Object-time error messages, see part II  1000
Octal constant . . . . . . . . . .  87
One dimensional array  . . . . . .  94
Open . . . . . . . . . . . . . . .  240
Open statement . . . . . . . . . .  165
Operand  . . . . . . . . . . . . .  131, 141-142
Operator . . . . . . . . . . . . .  71, 131, 138, 140, 144
Operator word  . . . . . . . . . .  71
OPTIONS statement  . . . . . . . .  74
OPTIONS statement, see part II . .  1000
OR . . . . . . . . . . . . . . . .  26, 75, 147
OTHERWISE  . . . . . . . . . . . .  76, 183-184
OUT in SIMSET  . . . . . . . . . .  200
OUTCHAR  . . . . . . . . . . . . .  244, 246, 252
Outer block  . . . . . . . . . . .  22
OUTER CLASS declarations . . . . .  118
OUTFILE  . . . . . . . . . . . . .  237, 244, 302
OUTFILE, see part II . . . . . . .  1000
OUTFIX . . . . . . . . . . . . . .  244, 246, 252
OUTFRAC  . . . . . . . . . . . . .  244, 246, 252
OUTINT . . . . . . . . . . . . . .  244, 246, 252, 256
Output statistics collection . . .  212
Output, formatted  . . . . . . . .  244
OUTREAL  . . . . . . . . . . . . .  246, 252, 256
OUTTEXT, example of use  . . . . .  101

Packing and unpacking into parts of words, see part III  1000
Pages, division of program listing into  281
Parallel processing of vectors . .  174
Parallel processing with implicit time axis  208
Parallel processing without implicit time axis  191-192
Parameter part of CLASS declaration  111
Parameter to a CLASS . . . . . . .  113
Parameter to a PROCEDURE . . . . .  99
Parameter transmission . . . . . .  104
Parameter transmission modes to classes  104
Parameter transmission to a procedure  103
Parameters to a procedure  . . . .  104
Parenthesis, square ([ and ])  . .  72
Parenthesises (( and ))  . . . . .  94, 283
Parenthesises, square ([ and ])  .  94
Part-compilation . . . . . . . . .  258
Part-compilation, see part II  . .  1000
PASSIVATE in CLASS SIMULATION  . .  206-207, 209
Passive  . . . . . . . . . . . . .  56, 191
Period (.) . . . . . . . . . . . .  69
PICTURE statement of COBOL . . . .  233
Plotting . . . . . . . . . . . . .  31
Plotting, see part III . . . . . .  1000
Plus (+) . . . . . . . . . . . . .  71
Pointer variable, use of . . . . .  133, 183-184
Pointer variable, use of in expression  153
POISSON random drawing procedure .  294
POS  . . . . . . . . . . . . . . .  223, 226
POS of a file image  . . . . . . .  244
Power sign (** or ^) . . . . . . .  71
PRECEDE in SIMSET  . . . . . . . .  200
Precedence of operators  . . . . .  147
Precision of variables, table  . .  93
PRED in SIMSET . . . . . . . . . .  195-197
Prefix chain of CLASS declarations  117
Prefix sequence  . . . . . . . . .  41, 162
Prefixed block . . . . . . . . . .  52, 160
PREV in SIMSET . . . . . . . . . .  197-198
Primer on SIMULA . . . . . . . . .  5
Printable character  . . . . . . .  87
PRINTFILE  . . . . . . . . . . . .  237, 247, 254, 303
PRINTFILE, see part II . . . . . .  1000
PRIOR in activate statement  . . .  76, 210
PROCEDURE  . . . . . . . . . . . .  38, 73, 99
PROCEDURE as CLASS attribute . . .  112, 114
PROCEDURE body . . . . . . . . . .  39, 82, 99
PROCEDURE call, efficiency of  . .  114
PROCEDURE CHAR . . . . . . . . . .  150
PROCEDURE COMPRESS . . . . . . . .  227
PROCEDURE declaration  . . . . . .  38, 99
PROCEDURE declaration in outermost CLASS body  112
PROCEDURE DIGIT  . . . . . . . . .  150
PROCEDURE FACTORIAL (INTEGER)  . .  102
PROCEDURE heading  . . . . . . . .  99
PROCEDURE identifier . . . . . . .  99, 136
PROCEDURE LETTER . . . . . . . . .  150
PROCEDURE NORM (REAL)  . . . . . .  102
PROCEDURE NULLREF (INTEGER)  . . .  107
PROCEDURE OUTCOLUMN  . . . . . . .  101
PROCEDURE parameter transmission .  103
PROCEDURE parameters . . . . . . .  104-105
PROCEDURE parameters (table) . . .  104
PROCEDURE PLACE  . . . . . . . . .  203-204
PROCEDURE RANK . . . . . . . . . .  150
PROCEDURE SELECT . . . . . . . . .  203-204
PROCEDURE statement  . . . . . . .  180
PROCEDURE TREETRAVERSE . . . . . .  101
PROCEDURE, call by value . . . . .  100
PROCEDURE, return from . . . . . .  103
PROCESS (Introduction) . . . . . .  56
Process control applications, see part III  1000
PROCESS expression . . . . . . . .  210
PROCESS in CLASS SIMULATION  . . .  206-208
PROCESS object (table of states) .  206-210
Program  . . . . . . . . . . . . .  160
Program = block or compound statement  160
Program content  . . . . . . . . .  68
Program library, see part III  . .  1000
Program sequence control . . . . .  186
Program structure  . . . . . . . .  186
Proper PROCEDURE declaration . . .  99
PROTECTED protection feature . . .  125
PROTECTED, syntax  . . . . . . . .  75
Protection . . . . . . . . . . . .  125
PSC  . . . . . . . . . . . . . . .  186
Punched card source program input   80
PUTCHAR  . . . . . . . . . . . . .  222
PUTFIX . . . . . . . . . . . . . .  235, 246
PUTINT . . . . . . . . . . . . . .  235
PUTREAL  . . . . . . . . . . . . .  235, 246

QUA, example of use  . . . . . . .  134, 153
QUA, qualification of result . . .  154
QUA, semantics . . . . . . . . . .  156
QUA, syntax  . . . . . . . . . . .  77, 153
Qualification  . . . . . . . . . .  37
Qualification error  . . . . . . .  168
Qualification in object expression  153
Qualification of actual parameter   107
Qualifying CLASS . . . . . . . . .  92
Quantity . . . . . . . . . . . . .  93
Quasi-parallel processing with implicit time axis  208
Quasi-parallel processing without implicit time axis  191-192
Quasi-parallel processing, efficiency of  114
Quasi-parallel system, definition by a prefixed block  162
Quote, double (")  . . . . . . . .  282
Quote, double, inside TEXT constants  88
Quote, single (')  . . . . . . . .  283

Radix  . . . . . . . . . . . . . .  87
Raised to the power of sign (** or ^)  71
RANDINT random drawing procedure .  293
Random access to disk file records  252
Random access to disk file records, see part II and III  1000
Random drawing procedures  . . . .  293
Range of values, BOOLEAN variable   92
Range of values, CHARACTER variable  92
Range of values, INTEGER constant   85
Range of values, INTEGER variable   91
Range of values, LONG REAL constant  86
Range of values, LONG REAL variable  91
Range of values, REAL constant . .  86
Range of values, REAL variable . .  91
Range of values, REF variable  . .  92
Range of values, SHORT INTEGER constant  85
Range of values, SHORT INTEGER variable  91
Range of values, TEXT variable . .  92
Range of variables, table of . . .  93
RANK . . . . . . . . . . . . . . .  149-151
RANK, INTEGER PROCEDURE  . . . . .  292
REACTIVATE in CLASS SIMULATION . .  76, 206, 210
REAL . . . . . . . . . . . . . . .  73, 91
REAL constant  . . . . . . . . . .  84-85
REAL declaration . . . . . . . . .  91
REAL in expression . . . . . . . .  140
REAL item  . . . . . . . . . . . .  235
Real time applications with many terminals, see part III  1000
REAL to INTEGER conversion . . . .  290
REAL, as CLASS attribute . . . . .  111
REAL, assignable range . . . . . .  91, 93
Record . . . . . . . . . . . . . .  238-240
Record declaration . . . . . . . .  111
Record oriented i/o, see part III   1000
Record oriented input  . . . . . .  240-241
Record oriented output . . . . . .  244
Recursion  . . . . . . . . . . . .  103
Redefines = shared storage, use garbage collector  155
Redefines on TEXTs, see Subtext  .  225
REF  . . . . . . . . . . . . . . .  74, 83, 91
REF parameters to separately compiled PROCEDURES  266
REF variable, assignable range . .  93
REF variables, use of (Simple introduction)  32
REF variables, use of to access into CLASS objects  133, 183-184
REF, as CLASS attribute  . . . . .  111
Reference assignment . . . . . . .  166, 168
Reference comparator . . . . . . .  71
Reference comparator, main treatment of  148
Reference equal (==) . . . . . . .  72, 146-148, 157
Reference equal (==), main treatment of  148
Reference not equal (=/=)  . . . .  72, 146, 148
Reference type . . . . . . . . . .  83
Reference variable . . . . . . . .  32
Reference variable, use of in expression  153
Reference variables (Simple introduction)  32
Reference variables, use of for accessing data  183-184
References (= Bibliography)  . . .  5
Relation . . . . . . . . . . . . .  145-147
Relational operator  . . . . . . .  71
Remainder at division, function for  290
Remote accessing . . . . . . . . .  37, 133, 183-184
Remote identifier  . . . . . . . .  136
Remote-variable  . . . . . . . . .  132
Removal of CLASS objects . . . . .  155
Removal of TEXTs . . . . . . . . .  228
Repetition . . . . . . . . . . . .  67, 174
Repetition, conditional  . . . . .  173
Reserved word  . . . . . . . . . .  74
Reserved words (table) see part II  1000
Restrictions in the DEC 10 SIMULA system, see part II  1000
RESUME in CLASS SIMULATION . . . .  206-207
RESUME procedure operating on class instances  114, 191
RESUME, semantics  . . . . . . . .  191-192
RETURN from a CLASS execution  . .  192
RETURN from a subroutine . . . . .  103
RETURN value from a procedure  . .  39
Right parenthesis ())  . . . . . .  78, 94, 111, 151
Right parenthesis ()) in expression  138
Right parenthesis ()), use in CLASS declaration  111
Right square bracket . . . . . . .  94
RTS block  . . . . . . . . . . . .  28
RTS info . . . . . . . . . . . . .  13, 35
Run time . . . . . . . . . . . . .  7
Run time error . . . . . . . . . .  37, 240-243, 247
Run time structure . . . . . . . .  186
Run time system  . . . . . . . . .  7
Run time system information  . . .  13
Run-time error messages, see part II  1000

Safe conversational i/o, see part III  1000
Scheduling with implicit time axis  208
Scheduling without implicit time axis  191-192
Scope  . . . . . . . . . . . . . .  81-82
Security . . . . . . . . . . . . .  37, 119, 125
Security although separate compilation  259
Security by module protection  . .  125
Segmentation into separately compiled modules  258
Segmentation of programs . . . . .  125
Semantics  . . . . . . . . . . . .  62
Semaphore variables  . . . . . . .  194
Semicolon (;)  . . . . . . . . . .  10, 73, 99
Separate compilation . . . . . . .  258
Separate compilation, External declaration  124
Separate compilation, see part II   1000
Separator  . . . . . . . . . . . .  71
Sequential file organisation . . .  237
Sequential operator  . . . . . . .  75
Set handling . . . . . . . . . . .  195
SETPOS on file objects . . . . . .  238-239, 257
SETPOS on TEXTs  . . . . . . . . .  223, 226
Shared storage . . . . . . . . . .  155
SHORT INTEGER  . . . . . . . . . .  74, 83, 91
SHORT INTEGER constant . . . . . .  83
SHORT INTEGER in expression  . . .  140
SHORT INTEGER, as CLASS attribute   111
SHORT INTEGER, assignable range  .  93
SIGN function  . . . . . . . . . .  290
Sign part  . . . . . . . . . . . .  233
SIMDDT (Debugging system), see part II  1000
Simple arithmetic expression . . .  138
Simple character expression  . . .  150
Simple designational expression  .  151
Simple object expression . . . . .  133, 148, 180
Simple reference expression in relation  146
Simple TEXT expression . . . . . .  132, 158
Simple value expression in realtion  146
Simple variable  . . . . . . . . .  132, 176
SIMSET . . . . . . . . . . . . . .  195, 297
SIMSET and separately compiled CLASS-es  267
SIMSET, prefix to SIMULATION . . .  207
SIMULA Language standard definition  5
SIMULA maintenance on DECsystem-10, address  2
SIMULA newsletter  . . . . . . . .  5
SIMULA on DECsystem-10, how to get info on updates  2
SIMULATION . . . . . . . . . . . .  297
SIMULATION and separately compiled CLASS-es  267-268
Simulation capabilities of SIMULA (Introduction)  53
SIMULATION, a SIMULA CLASS (Introduction)  56
Simulation, example of . . . . . .  214
SIN function . . . . . . . . . . .  290
SIN function, type of  . . . . . .  143
Single quote (') . . . . . . . . .  283
SINH function  . . . . . . . . . .  290
Sinus function . . . . . . . . . .  139
SKIP PAGE, see EJECT . . . . . . .  247
Sorting order of characters  . . .  78
Source program . . . . . . . . . .  7
Source program line length . . . .  80
Space character  . . . . . . . . .  73
SPACING  . . . . . . . . . . . . .  247-248
SPEC part  . . . . . . . . . . . .  100
Special character  . . . . . . . .  62, 71
Specificator . . . . . . . . . . .  74
Split body . . . . . . . . . . . .  112
SQRT function  . . . . . . . . . .  290
Square bracket ([ and ]) . . . . .  66, 72, 94
Square root function . . . . . . .  290
Square root function, type of  . .  143
Stack  . . . . . . . . . . . . . .  40
Stack of attached blocks . . . . .  188
Stack of blocks  . . . . . . . . .  188
Standard system PROCEDURES . . . .  30
Standardization of SIMULA  . . . .  5
Start value of CLASS attributes  .  115
Statement  . . . . . . . . . . . .  8, 163
Statement bracket  . . . . . . . .  74
Statement number, variable . . . .  98
Statement, compound or block . . .  160
Statements, table of allowed kinds of  165
Statistics collection  . . . . . .  212
STEP . . . . . . . . . . . . . . .  76, 175
Storage reorganisation . . . . . .  155
String of characters, concatenation of  231
String of characters, memory allocation for  228
String processing  . . . . . . . .  220
STRIP  . . . . . . . . . . . . . .  225
Structure declaration  . . . . . .  111
SUB  . . . . . . . . . . . . . . .  221, 225
Subclass . . . . . . . . . . . . .  92, 116, 118, 120, 123
Subclass, protection against . . .  126
Subroutine . . . . . . . . . . . .  99
Subroutine entry points  . . . . .  120
Subscript  . . . . . . . . . . . .  132-133, 135
Subscript bound  . . . . . . . . .  94, 135
Subscript bounds of CLASS attribute  113
Subscript list . . . . . . . . . .  132
Subscript of SWITCH  . . . . . . .  151
Subscripted variable . . . . . . .  94
Subtexts . . . . . . . . . . . . .  225
Subtraction, sign (-)  . . . . . .  71
SUC in SIMSET  . . . . . . . . . .  195-197
Swedish Defense Research Institute  2
Swedish letter . . . . . . . . . .  68, 282, 284, 286-288
SWITCH . . . . . . . . . . . . . .  74
SWITCH declaration . . . . . . . .  98
SWITCH designator  . . . . . . . .  98
SWITCH identifier  . . . . . . . .  98, 136, 151
SWITCH list  . . . . . . . . . . .  98
SWITCH, as CLASS attribute . . . .  112
SWITCH, as PROCEDURE parameter . .  100
Switches to the compiler . . . . .  74
Switches to the compiler, see part II  1000
Syntactic unit . . . . . . . . . .  63, 65
Syntactic variable . . . . . . . .  62
Syntactical description language in this manual  62
Syntax . . . . . . . . . . . . . .  62
SYSIN  . . . . . . . . . . . . . .  254-256
SYSIN, IMAGE size  . . . . . . . .  254
SYSOUT . . . . . . . . . . . . . .  254-257

TAB character  . . . . . . . . . .  71, 280
TAN function . . . . . . . . . . .  290
TAN function, type of  . . . . . .  143
TANH function  . . . . . . . . . .  290
Terminated . . . . . . . . . . . .  155, 191
Terminated in CLASS SIMULATION . .  208-209
TEXT . . . . . . . . . . . . . . .  74, 91, 220, 237, 240-242, 244
TEXT assignment  . . . . . . . . .  220
TEXT constant containing double quote (")  88
TEXT constant in TEXT expression .  159
TEXT editing and de-editing  . . .  223
Text editing of SIMULA source programs, see part II  1000
TEXT expression  . . . . . . . . .  131-132, 135, 158-159
TEXT expression and TEXT value . .  159
TEXT expression, syntax and semantics of  158
TEXT function designator . . . . .  159, 167
TEXT generation  . . . . . . . . .  228
TEXT handling  . . . . . . . . . .  220
Text handling utility package, see part III  1000
TEXT object  . . . . . . . . . . .  220
TEXT quote (") . . . . . . . . . .  69, 88
TEXT reference assignment  . . . .  221
TEXT reference, comparison of  . .  148
TEXT to numerical value conversion  233
TEXT value . . . . . . . . . . . .  131, 159, 220
TEXT value assignment  . . . . . .  166, 226
TEXT value, conversion from numerical  234
TEXT values, comparison of . . . .  148
TEXT variable  . . . . . . . . . .  159, 220
TEXT variable, assignable range  .  93
TEXT, as CLASS attribute . . . . .  111
TEXT, output of  . . . . . . . . .  245
Textbook on SIMULA . . . . . . . .  5
TEXTs with variable length . . . .  231
TEXTs, concatenation of  . . . . .  231
Textual link . . . . . . . . . . .  29
THEN . . . . . . . . . . . . . . .  76, 131, 163
THEN, ambiguity after  . . . . . .  163
THIS . . . . . . . . . . . . . . .  77, 153, 158
THIS, illegality for prefixed blocks  162
Time axis in CLASS SIMULATION  . .  206
Time in CLASS SIMULATION . . . . .  206
Time, procedure in CLASS SIMULATION  207, 209
Timing clause in CLASS SIMULATION   211
TO . . . . . . . . . . . . . . . .  76
Trace of a model . . . . . . . . .  54
Transplantation  . . . . . . . . .  168
Transput . . . . . . . . . . . . .  237
Transput, DEC 10 dependent parts, see part II  1000
Trigonometric functions  . . . . .  289
TRUE . . . . . . . . . . . . . . .  77, 87, 146
TTY  . . . . . . . . . . . . . . .  238, 245, 247, 254-256
TTY terminal . . . . . . . . . . .  256
TTY terminal, output to  . . . . .  238
TTY WIDTH  . . . . . . . . . . . .  254
Two way list . . . . . . . . . . .  195
Type . . . . . . . . . . . . . . .  83
Type ARRAY, as CLASS attribute . .  111
Type conversion (arithmetic) . . .  92
Type conversion(CHARACTER to INTEGER)  150
Type conversion(INTEGER to CHARACTER)  150
Type declaration . . . . . . . . .  89, 91
Type of arithmetic expression  . .  140
Type of PROCEDURE parameters . . .  104
Types and constants  . . . . . . .  83

Undefined values are impossible in SIMULA  115
Underscore (_) . . . . . . . . . .  73
Unformatted i/o, see part III  . .  1000
UNIFORM random drawing procedure .  293
UNTIL  . . . . . . . . . . . . . .  76, 175
updates, how to get info on  . . .  2
Upper bound  . . . . . . . . . . .  94
Upper case characters  . . . . . .  68
Upper subscript bound  . . . . . .  94

VALUE (Parameter transmission mode)  105
VALUE (Parameter transmission mode), default  104
Value assignment . . . . . . . . .  167
Value comparators  . . . . . . . .  148
VALUE declaration of CLASS parameter  111
Value expression . . . . . . . . .  176
VALUE of a constant  . . . . . . .  83
Value of controlled variable on exit  179
VALUE Parameter for procedure, table  104
VALUE parameter transmission, introduction  39
Value type . . . . . . . . . . . .  83, 91
VALUE, syntax  . . . . . . . . . .  75
Values of variables, table of range  93
Variable . . . . . . . . . . . . .  132, 153
Variable length character strings (TEXTs)  231
Variable name declarations . . . .  91
Variable type declarations . . . .  91
Variable values, table of allowed values  93
Variable, assignment to  . . . . .  132
Variable, use in expression  . . .  131
Variable, value of . . . . . . . .  83, 132
VARYING declaration of character strings  231
Vector . . . . . . . . . . . . . .  94
Vertical stroke (|)  . . . . . . .  66
VERTICAL TAB character . . . . . .  281
Video terminal, output to  . . . .  247
VIRTUAL  . . . . . . . . . . . . .  75
VIRTUAL attributes of files  . . .  238-240, 244, 252
VIRTUAL quantities . . . . . . . .  119
VIRTUAL, attribute redefinition  .  116
VIRTUAL, semantics . . . . . . . .  119
VIRTUAL, syntax  . . . . . . . . .  112

WAIT in CLASS SIMULATION . . . . .  206-207, 209
WHEN . . . . . . . . . . . . . . .  76, 183
WHILE  . . . . . . . . . . . . . .  76, 173
WHILE statement  . . . . . . . . .  173
WHILE, ambiguity with  . . . . . .  164
Whole number . . . . . . . . . . .  85, 87, 91
WIDTH of TTY . . . . . . . . . . .  254


