      SUBROUTINE HCHPLT (KODE,INTRVL,MINX,MINY,MAXX,MAXY,LASTX,LASTY)
C     HCHPLT                                                    09/20/67
C     RECTANGULAR AREA HATCHING SUBROUTINE FOR PLOT PACKAGE GENPLT-II
C     THIS SUBROUTINE IS NOT MEANT TO BE CALLED DIRECTLY BY USER.
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE HCHPLT ARGUMENT LIST DEFINITIONS
C
C     KODE   = 1 PLOTS DIAGONAL HATCH LINES RISING FROM LEFT TO RIGHT.
C     KODE   = 2 PLOTS DIAGONAL HATCH LINES RISING FROM RIGHT TO LEFT.
C     KODE   = 3 PLOTS HORIZONTAL HATCH LINES.
C     KODE   = 4 PLOTS VERTICAL HATCH LINES.
C     KODE   = 5 PLOTS DIAGONAL CROSSHATCHING.
C     KODE   = 6 PLOTS CROSSHATCHING OF HORIZONTAL AND VERTICAL LINES.
C     INTRVL = GRID COORDINATE SEPARATION OF HATCH LINES.
C     MINX   = HORIZONTAL GRID DISTANCE FROM ORIGIN TO LEFT HATCH EDGE.
C     MINY   = VERTICAL GRID DISTANCE FROM ORIGIN TO LOWER HATCH EDGE.
C     MAXX   = HORIZONTAL GRID DISTANCE FROM ORIGIN TO RIGHT HATCH EDGE.
C     MAXY   = VERTICAL GRID DISTANCE FROM ORIGIN TO UPPER HATCH EDGE.
C     LASTX  = LAST X GRID COORDINATE PLOTTED.
C     LASTY  = LAST Y GRID COORDINATE PLOTTED.
C
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      MODE = ILINE
      IF(INTRVL)1,1,2
    1 INTRVL=1
    2 MOVEX=MAXX-MINX
      MOVEY=MAXY-MINY
      GO TO (3,20,36,42,3,36,46),KODE
C
C     *******PLOT DIAGONAL HATCH LINES RISING FROM LEFT TO RIGHT********
    3 LEFTX=MINX-MOVEY
    4 LEFTX=LEFTX+INTRVL
      IF(LEFTX-MINX)5,6,6
    5 NEWY=MINY+MINX-LEFTX
      CALL PENUP (LASTX,LASTY,MINX,NEWY)
      GO TO 8
    6 IF(LEFTX-MAXX)7,18,18
    7 CALL PENUP (LASTX,LASTY,LEFTX,MINY)
    8 IF(MAXX-LEFTX-MOVEY)9,9,10
    9 NEWY=MINY+MAXX-LEFTX
      CALL PENDWN(LASTX,LASTY,MAXX,NEWY)
      GO TO 11
   10 NEWX=LEFTX+MOVEY
      CALL PENDWN(LASTX,LASTY,NEWX,MAXY)
   11 LEFTX=LEFTX+INTRVL
      IF(LEFTX-MAXX)12,18,18
   12 IF(MAXX-LEFTX-MOVEY)13,13,14
   13 NEWY=MINY+MAXX-LEFTX
      CALL PENUP (LASTX,LASTY,MAXX,NEWY)
      GO TO 15
   14 NEWX=LEFTX+MOVEY
      CALL PENUP (LASTX,LASTY,NEWX,MAXY)
   15 IF(LEFTX-MINX)16,17,17
   16 NEWY=MINY+MINX-LEFTX
      CALL PENDWN(LASTX,LASTY,MINX,NEWY)
      GO TO 4
   17 CALL PENDWN(LASTX,LASTY,LEFTX,MINY)
      GO TO 4
   18 IF(KODE-5)19,20,19
   19 RETURN
C
C     *******PLOT DIAGONAL HATCH LINES RISING FROM RIGHT TO LEFT********
   20 LEFTX=MINX-MOVEY
   21 LEFTX=LEFTX+INTRVL
      IF(LEFTX-MINX)22,23,23
   22 NEWY=MAXY-MINX+LEFTX
      CALL PENUP (LASTX,LASTY,MINX,NEWY)
      GO TO 25
   23 IF(LEFTX-MAXX)24,35,35
   24 CALL PENUP (LASTX,LASTY,LEFTX,MAXY)
   25 IF(MAXX-LEFTX-MOVEY)26,26,27
   26 NEWY=MAXY-MAXX+LEFTX
      CALL PENDWN(LASTX,LASTY,MAXX,NEWY)
      GO TO 28
   27 NEWX=LEFTX+MOVEY
      CALL PENDWN(LASTX,LASTY,NEWX,MINY)
   28 LEFTX=LEFTX+INTRVL
      IF(LEFTX-MAXX)29,35,35
   29 IF(MAXX-LEFTX-MOVEY)30,30,31
   30 NEWY=MAXY-MAXX+LEFTX
      CALL PENUP (LASTX,LASTY,MAXX,NEWY)
      GO TO 32
   31 NEWX=LEFTX+MOVEY
      CALL PENUP (LASTX,LASTY,NEWX,MINY)
   32 IF(LEFTX-MINX)33,34,34
   33 NEWY=MAXY-MINX+LEFTX
      CALL PENDWN(LASTX,LASTY,MINX,NEWY)
      GO TO 21
   34 CALL PENDWN(LASTX,LASTY,LEFTX,MAXY)
      GO TO 21
   35 RETURN
C
C     *******************PLOT HORIZONTAL HATCH LINES********************
   36 LOWRY=MINY
   37 LOWRY=LOWRY+INTRVL
      IF(LOWRY-MAXY)38,40,40
   38 CALL PENUP (LASTX,LASTY,MINX,LOWRY)
      CALL PENDWN(LASTX,LASTY,MAXX,LOWRY)
      LOWRY=LOWRY+INTRVL
      IF(LOWRY-MAXY)39,40,40
   39 CALL PENUP (LASTX,LASTY,MAXX,LOWRY)
      CALL PENDWN(LASTX,LASTY,MINX,LOWRY)
      GO TO 37
   40 IF(KODE-6)41,42,41
   41 RETURN
C
C     ********************PLOT VERTICAL HATCH LINES*********************
   42 LEFTX=MINX
   43 LEFTX=LEFTX+INTRVL
      IF(LEFTX-MAXX)44,46,46
   44 CALL PENUP (LASTX,LASTY,LEFTX,MINY)
      CALL PENDWN(LASTX,LASTY,LEFTX,MAXY)
      LEFTX=LEFTX+INTRVL
      IF(LEFTX-MAXX)45,46,46
   45 CALL PENUP (LASTX,LASTY,LEFTX,MAXY)
      CALL PENDWN(LASTX,LASTY,LEFTX,MINY)
      GO TO 43
   46 RETURN
      END
