@DEFINE S: <DECUS.T.37.SSP>
; THIS CONTROL FILE EXECUTES THE SAMPLE TEST PROGRAMS SUPPLIED
; WITH SSP, AND DESCRIBED IN THE SSP MANUAL. THE INPUT FILES XXXXX.DAT
; ARE COPIES OF THE INPUT DATA CARDS DESCRIBED IN THE MANUAL.
; S: IS THE LOGICAL DEVICE WHERE SSP.REL IS KEPT.
;
; DEFINE I/O UNITS TO BE DISK
; 5 IS INPUT, 6 IS OUTPUT, 13 IS SCRATCH
;
@DEFINE 5: DSK:
@DEFINE 6: DSK:
@DEFINE 13: DSK:
;
; DATA SCREENING SAMPLE
;
@RENAME DASCR.DAT FOR05.DAT
@EXECUTE DASCR.SMP,MATIN.SSS,BOOL.SSS,HIST.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT DASCR.DAT
@RENAME FOR06.DAT DASCR.OUT
;
; MULTIPLE LINEAR REGRESSION
;
@RENAME REGRE.DAT FOR05.DAT
@EXECUTE REGRE.SMP,DATA.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT REGRE.DAT
@RENAME FOR06.DAT REGRE.OUT
;
; POLYNOMIAL REGRESSION
;
@RENAME POLRG.DAT FOR05.DAT
@EXECUTE POLRG.SMP,PLOT.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT POLRG.DAT
@RENAME FOR06.DAT POLRG.OUT
;
; STEPWISE MULTIPLE REGRESSION
;
@RENAME STEPR.DAT FOR05.DAT
@EXECUTE STEPR.SMP,DATA.SSS,STOUT.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT STEPR.DAT
@RENAME FOR06.DAT STEPR.OUT
;
; CANONICAL CORRELATION
;
@RENAME MCANO.DAT FOR05.DAT
@EXECUTE MCANO.SMP,DATA.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT MCANO.DAT
@RENAME FOR06.DAT MCANO.OUT
;
; ANALYSIS OF VARIANCE
;
@RENAME ANOVA.DAT FOR05.DAT
@EXECUTE ANOVA.SMP,S:SSP.REL/SEA
@RENAME FOR05.DAT ANOVA.DAT
@RENAME FOR06.DAT ANOVA.OUT
;
; DISCRIMINANT ANALYSIS
;
@RENAME MDISC.DAT FOR05.DAT
@EXECUTE MDISC.SMP,S:SSP.REL/SEA
@RENAME FOR05.DAT MDISC.DAT
@RENAME FOR06.DAT MDISC.OUT
;
; FACTOR ANALYSIS
;
@RENAME FACTO.DAT FOR05.DAT
@EXECUTE FACTO.SMP,DATA.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT FACTO.DAT
@RENAME FOR06.DAT FACTO.OUT
;
; KOLMOGOROV-SMIRNOV TEST
;
@RENAME KOLM.DAT FOR05.DAT
@EXECUTE KOLM.SMP,S:SSP.REL/SEA
@RENAME FOR05.DAT KOLM.DAT
@RENAME FOR06.DAT KOLM.OUT
;
; TRIPLE EXPONENTIAL SMOOTHING
;
@RENAME EXPON.DAT FOR05.DAT
@EXECUTE EXPON.SMP,S:SSP.REL/SEA
@RENAME FOR05.DAT EXPON.DAT
@RENAME FOR06.DAT EXPON.OUT
;
; MATRIX ADDITION
;
@RENAME ADSAM.DAT FOR05.DAT
@EXECUTE ADSAM.SMP,MATIN.SSS,MXOUT.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT ADSAM.DAT
@RENAME FOR06.DAT ADSAM.OUT
;
; NUMERICAL QUADRATURE INTEGRATION
;
@RENAME QDINT.DAT FOR05.DAT
@EXECUTE QDINT.SMP,S:SSP.REL/SEA
@RENAME FOR05.DAT QDINT.DAT
@RENAME FOR06.DAT QDINT.OUT
;
; RUNGE-KUTTA INTEGRATION
;
@RENAME RKINT.DAT FOR05.DAT
@EXECUTE RKINT.SMP,FUN.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT RKINT.DAT
@RENAME FOR06.DAT RKINT.OUT
;
; POLYNOMIAL ROOTS
;
@RENAME SMPRT.DAT FOR05.DAT
@EXECUTE SMPRT.SMP,S:SSP.REL/SEA
@RENAME FOR05.DAT SMPRT.DAT
@RENAME FOR06.DAT SMPRT.OUT
;
; SOLUTION OF SIMULTANEOUS EQUATIONS
;
@RENAME SOLN.DAT FOR05.DAT
@EXECUTE SOLN.SMP,MATIN.SSS,MXOUT.SSS,S:SSP.REL/SEA
@RENAME FOR05.DAT SOLN.DAT
@RENAME FOR06.DAT SOLN.OUT
;
; NOW PRINT THE RESULTS
@PRINT *.OUT/DELETE
; AND CLEAN UP
@DELETE FOR13.DAT
