LEX version 1.13D			FORTRA    		19-Oct-84

    1	%| 
    2	 | FORTRAN.LEX: 
    3	 | 
    4	 | Lexical analyzer for FORVER version 2.6 
    5	 |% 
    6	 
    7	upper_case	= [A-Z]. 
    8	lower_case	= [a-z]. 
    9	letter		= upper_case | lower_case. 
   10	 
   11	digit		= [0-9]. 
   12	octal		= [0-7]. 
   13	exponent	= 'E' [+\-]? digit+. 
   14	double_exponent	= 'D' [+\-]? digit+. 
   15	 
   16	sp		= '\040'. 
   17	tab		= '\011'. 
   18	ch_bof		= '\b'		% beginning-of-file %. 
   19	ch_eof		= '\e'		% end-of-file %. 
   20	 
   21	id_or_constant	= letter (letter | digit)* 
   22			| digit+. 
   23	 
   24	eol		= [\b\015] '\012'*		% end-of-line % 
   25			|	   '\012'. 
   26	 
   27	line_char	= -[\000-\010\012-\037\177\b\e]	% legal	chars in a line	%. 
   28	printing	= -[\000-\040\177\b\e]		% non-whitespace %. 
   29	whitespace	=  [\040\011]			% space	or tab %. 
   30	space		= '\040'			% just a space %. 
   31	quote_char	= -[\000-\010\012-\037\177\b\e']% "quotable" chars % 
   32			|  eol space* tab digit		% eol with continuation	too % 
   33			|  eol '     ' printing. 
   34	 
   35	separator	-> whitespace+ <skip>		% space	or tab %. 
   36	 
   37	contline	-> ('!'	line_char*)?		% perhaps it's got an in-line comment % 
   38			   ( eol '     ' printing	% standard cont. line % 
   39			   | eol tab digit )		% FORTRAN-10 cont. line	% 
   40				<skip>. 
   41	 
   42	end_line	-> ';' 
   43			 | ('!'	line_char*) ?		% perhaps it's got an in-line comment % 
   44			   eol ( ' '* |	tab ). 
   45	 
   46	end_file	-> ch_eof			% end-of-file char %. 
   47	 
   48	identifier	-> letter (letter | digit)* <check> % your average FORTRAN identifier %. 
   49	function_identifier			% what happens to a FUNCTION name %. 
   50	intrinsic_identifier			% for things like SIN,COS,EXP,... %. 
   51	array_identifier			% to make it different from FUNCTION names %. 
   52	 
   53		% constants % 
   54	 
   55	string_constant	-> "'" ("''" | quote_char)* "'"	% just that: a string constant %. 
   56	hollerith_constant -> digit+ 'H' <holstr> % this requires a special semantic action %. 
   57	 
   58	label_constant	-> [$&]	digit+		% eg. passing a	label to a SUBROUTINE %. 
   59	boolean_constant -> '.TRUE.' | '.FALSE.' % just	what you thought %. 
   60	 
   61	integer_constant -> digit+ / ('.EQ' | '.' [AOXNLGFTaoxnlgft] | nil) 
   62			  | '"' octal+	<intcnv>. 
   63	real_constant	-> ( digit+ '.'	digit* 
   64			   | digit* '.'	digit+)	exponent? 
   65			 | digit+ exponent. 
   66	double_constant	-> ( digit+ '.'	digit* 
   67			   | digit* '.'	digit+)	double_exponent 
   68			 | digit+ double_exponent. 
   69	 
   70		% arithmetic operators % 
   71	 
   72	'+'	-> '+'. 
   73	'\-'	-> '\-'			% \ because of possible	misunderstandings. %. 
   74	'*'	-> '*'. 
   75	'/'	-> '/'. 
   76	 
   77	'**'	-> '**'	| '^'		% allow	^ as an	alternate to **	%. 
   78	 
   79		% logical operators % 
   80	 
   81	and		-> '.AND.'. 
   82	or		-> '.OR.'. 
   83	not		-> '.NOT.'. 
   84	f10_logical_ops	-> '.XOR.'	% FORTRAN-10 special logical operators % 
   85			 | '.EQV.'. 
   86	 
   87		% relational operators % 
   88	 
   89	'<'		-> '.LT.' | '<'. 
   90	'<='		-> '.LE.' | '<='. 
   91	'=='		-> '.EQ.' | '=='. 
   92	'#', '=/='	-> '.NE.' | '#'. 
   93	'>='		-> '.GE.' | '>='. 
   94	'>'		-> '.GT.' | '>'. 
   95	 
   96		% miscelaneous terminals % 
   97	 
   98	'='	-> '='. 
   99	','	-> ','. 
  100	'('	-> '('. 
  101	')'	-> ')'. 
  102	':'	-> ':'		% in array bounds declarations %. 
  103	'$'	-> '$'		% in formats %. 
  104	 
  105		% types	of constants/variables/expressions % 
  106	 
  107	integer		> 'INTEGER'. 
  108	real		> 'REAL'. 
  109	double		> 'DOUBLE'. 
  110	precision	> 'PRECISION'. 
  111	complex		> 'COMPLEX'. 
  112	logical		> 'LOGICAL'. 
  113	string. 
  114	label. 
  115	undeclared. 
  116	 
  117		% declaration pseudo-reserved words % 
  118	 
  119	dimension	> 'DIMENSION'. 
  120	implicit	> 'IMPLICIT'. 
  121	common		> 'COMMON'. 
  122	equivalence	> 'EQUIVALENCE'. 
  123	external	> 'EXTERNAL'. 
  124	parameter	> 'PARAMETER'. 
  125	data		> 'DATA'. 
  126	assign		> 'ASSIGN'. 
  127	namelist	> 'NAMELIST'. 
  128	format		> 'FORMAT'. 
  129	 
  130		% procedure definition pseudo-reserved words % 
  131	 
  132	subroutine	> 'SUBROUTINE'. 
  133	function	> 'FUNCTION'. 
  134	entry		> 'ENTRY'. 
  135	block		> 'BLOCK'.		% from BLOCK DATA % 
  136	program		> 'PROGRAM'. 
  137	 
  138	%*** END and END FILE are special, need	a separate DFA section for them	***% 
  139	end		-> 'END' / whitespace*. 
  140	endf		-> 'END' / whitespace+ 'FILE'. 
  141	 
  142	include		> 'INCLUDE'. 
  143	 
  144		% control pseudo-reserved words	% 
  145	 
  146	goto		> 'GOTO'. 
  147	go		> 'GO'. 
  148	to		> 'TO'. 
  149	call		> 'CALL'. 
  150	do		> 'DO'. 
  151	if		> 'IF'. 
  152	continue	> 'CONTINUE'. 
  153	return		> 'RETURN'. 
  154	stop		> 'STOP'. 
  155	pause		> 'PAUSE'. 
  156	 
  157		% I/O statement	pseudo-reserved	words % 
  158	 
  159	read		> 'READ'. 
  160	write		> 'WRITE'. 
  161	open		> 'OPEN'. 
  162	close		> 'CLOSE'. 
  163	rewind		> 'REWIND'. 
  164	file		> 'FILE'.		% from END FILE	n % 
  165	type		> 'TYPE'. 
  166	accept		> 'ACCEPT'. 
  167	print		> 'PRINT'. 
  168	punch		> 'PUNCH'. 
  169	input		> 'INPUT'. 
  170	reread		> 'REREAD'. 
  171	encode		> 'ENCODE'. 
  172	decode		> 'DECODE'. 
  173	find		> 'FIND'. 
  174	record		> 'RECORD'. 
  175	unload		> 'UNLOAD'. 
  176	backspace	> 'BACKSPACE'. 
  177	skip		> 'SKIP'. 
  178	backfile	> 'BACKFILE'. 
  179	 
  180		% and I	think this is FORTRAN! % 

Lexical analyzer: FORTRA
Tokens defined:   91
NFA states:       421
DFA states:       115 (gained 21 states in minimization)
CPU time:         53.86 seconds.
