%|
 | FORTRAN.LEX:
 |
 | Lexical analyzer for FORVER version 2.6
 |%

upper_case	= [A-Z].
lower_case	= [a-z].
letter		= upper_case | lower_case.

digit		= [0-9].
octal		= [0-7].
exponent	= 'E' [+\-]? digit+.
double_exponent	= 'D' [+\-]? digit+.

sp		= '\040'.
tab		= '\011'.
ch_bof		= '\b'		% beginning-of-file %.
ch_eof		= '\e'		% end-of-file %.

id_or_constant	= letter (letter | digit)*
		| digit+.

eol		= [\b\015] '\012'*		% end-of-line %
		|	   '\012'.

line_char	= -[\000-\010\012-\037\177\b\e]	% legal	chars in a line	%.
printing	= -[\000-\040\177\b\e]		% non-whitespace %.
whitespace	=  [\040\011]			% space	or tab %.
space		= '\040'			% just a space %.
quote_char	= -[\000-\010\012-\037\177\b\e']% "quotable" chars %
		|  eol space* tab digit		% eol with continuation	too %
		|  eol '     ' printing.

separator	-> whitespace+ <skip>		% space	or tab %.

contline	-> ('!'	line_char*)?		% perhaps it's got an in-line comment %
		   ( eol '     ' printing	% standard cont. line %
		   | eol tab digit )		% FORTRAN-10 cont. line	%
			<skip>.

end_line	-> ';'
		 | ('!'	line_char*) ?		% perhaps it's got an in-line comment %
		   eol ( ' '* |	tab ).

end_file	-> ch_eof			% end-of-file char %.

identifier	-> letter (letter | digit)* <check> % your average FORTRAN identifier %.
function_identifier			% what happens to a FUNCTION name %.
intrinsic_identifier			% for things like SIN,COS,EXP,... %.
array_identifier			% to make it different from FUNCTION names %.

	% constants %

string_constant	-> "'" ("''" | quote_char)* "'"	% just that: a string constant %.
hollerith_constant -> digit+ 'H' <holstr> % this requires a special semantic action %.

label_constant	-> [$&]	digit+		% eg. passing a	label to a SUBROUTINE %.
boolean_constant -> '.TRUE.' | '.FALSE.' % just	what you thought %.

integer_constant -> digit+ / ('.EQ' | '.' [AOXNLGFTaoxnlgft] | nil)
		  | '"' octal+	<intcnv>.
real_constant	-> ( digit+ '.'	digit*
		   | digit* '.'	digit+)	exponent?
		 | digit+ exponent.
double_constant	-> ( digit+ '.'	digit*
		   | digit* '.'	digit+)	double_exponent
		 | digit+ double_exponent.

	% arithmetic operators %

'+'	-> '+'.
'\-'	-> '\-'			% \ because of possible	misunderstandings. %.
'*'	-> '*'.
'/'	-> '/'.

'**'	-> '**'	| '^'		% allow	^ as an	alternate to **	%.

	% logical operators %

and		-> '.AND.'.
or		-> '.OR.'.
not		-> '.NOT.'.
f10_logical_ops	-> '.XOR.'	% FORTRAN-10 special logical operators %
		 | '.EQV.'.

	% relational operators %

'<'		-> '.LT.' | '<'.
'<='		-> '.LE.' | '<='.
'=='		-> '.EQ.' | '=='.
'#', '=/='	-> '.NE.' | '#'.
'>='		-> '.GE.' | '>='.
'>'		-> '.GT.' | '>'.

	% miscelaneous terminals %

'='	-> '='.
','	-> ','.
'('	-> '('.
')'	-> ')'.
':'	-> ':'		% in array bounds declarations %.
'$'	-> '$'		% in formats %.

	% types	of constants/variables/expressions %

integer		> 'INTEGER'.
real		> 'REAL'.
double		> 'DOUBLE'.
precision	> 'PRECISION'.
complex		> 'COMPLEX'.
logical		> 'LOGICAL'.
string.
label.
undeclared.

	% declaration pseudo-reserved words %

dimension	> 'DIMENSION'.
implicit	> 'IMPLICIT'.
common		> 'COMMON'.
equivalence	> 'EQUIVALENCE'.
external	> 'EXTERNAL'.
parameter	> 'PARAMETER'.
data		> 'DATA'.
assign		> 'ASSIGN'.
namelist	> 'NAMELIST'.
format		> 'FORMAT'.

	% procedure definition pseudo-reserved words %

subroutine	> 'SUBROUTINE'.
function	> 'FUNCTION'.
entry		> 'ENTRY'.
block		> 'BLOCK'.		% from BLOCK DATA %
program		> 'PROGRAM'.

%*** END and END FILE are special, need	a separate DFA section for them	***%
end		-> 'END' / whitespace*.
endf		-> 'END' / whitespace+ 'FILE'.

include		> 'INCLUDE'.

	% control pseudo-reserved words	%

goto		> 'GOTO'.
go		> 'GO'.
to		> 'TO'.
call		> 'CALL'.
do		> 'DO'.
if		> 'IF'.
continue	> 'CONTINUE'.
return		> 'RETURN'.
stop		> 'STOP'.
pause		> 'PAUSE'.

	% I/O statement	pseudo-reserved	words %

read		> 'READ'.
write		> 'WRITE'.
open		> 'OPEN'.
close		> 'CLOSE'.
rewind		> 'REWIND'.
file		> 'FILE'.		% from END FILE	n %
type		> 'TYPE'.
accept		> 'ACCEPT'.
print		> 'PRINT'.
punch		> 'PUNCH'.
input		> 'INPUT'.
reread		> 'REREAD'.
encode		> 'ENCODE'.
decode		> 'DECODE'.
find		> 'FIND'.
record		> 'RECORD'.
unload		> 'UNLOAD'.
backspace	> 'BACKSPACE'.
skip		> 'SKIP'.
backfile	> 'BACKFILE'.

	% and I	think this is FORTRAN! %
