@Begin(Text,RightMargin +6,LeftMargin +6)
@PageHeading(center "FORVER.OPR - Notes on using FORVER")
 
This file documents FORVER version 2.4 and attempts to describe some of
its limitations so that users can avoid some of these.
 
@Heading(Limitations imposed by FORVER on FORTRAN source files)
@Begin(Enumerate)
Keywords like "SUBROUTINE", "END" and "IF" can only be used in the
"normal" context, ie.  FORVER doesn't understand things like
"IF(3)=1.3".  So if FORVER starts pouring out endless syntax errors,
this might well be the cause.
 
Identifiers, constants, etc..@. cannot have imbedded spaces, and may
not be split accross lines (ie. with a continuation line).  This means
that constants in DATA statements must be all on one line (each
constant must be on one line, apart from that continuation lines may be
used freely, with no limit).  An exception to this are string constants
(quoted strings only: Hollerith constants still have to be all on the
same line).  So watch out for this kind of problem.
 
Similarly, all "identifier" symbols must have at least one separator
between them, for instance "DO 10 I=1,5" cannot be written as
"DO10I=1,5".
 
Instrinsic function names must be explicitly declared if they are to be
used as normal variable names.  Eg@. you'll have to declare something
like "INTEGER ISIGN" if you want to write something like "ISIGN = 1".
@End(Enumerate)
 
This is about all there is to FORVER in the way of restrictions to the
FORTRAN syntax.
 
@Heading(Calling up FORVER and running it)
You invoke FORVER with the monitor command:
@Display(.R FORVER)
FORVER will then announce itself and display its prompt:
@Display(FVR>)
To this you must reply with the name of the FORTRAN file you wish to
verify. The extension is defaulted to ".FOR".
 
After the file name, you can specify a number of switches, whose
meaning is explained in more detail in HLP:FORVER.HLP and
DOC:FORVER.DOC.
 
After the source program has been munged by FORVER, and if there are
references to routines not defined within this source file, You will
get a prompt saying "Search:", to which you must answer one of:
@Begin(Itemize)
?<return>@\This will list the names of the yet undefined routines
referenced in your program.
 
<return>@\Hitting just the <return> key will forget about the currently
undefined routines and proceed to verify calls to those that are
defined.  Verification is obviously not done for the undefined
references.
 
filename@\By specifying a filespec (extension defaults to ".VTR")
FORVER will search an "attribute library file" containing the pertinent
information related to the routines defined there.  Notice that this
file is generated by default unless disabled by the /VTR toggle switch
in the FORVER command line.
@End(Itemize)
@End(Text)
