      SUBROUTINE AXES (XO,YO,TITLE,NCHAR,AXSLEN,ANGLE,FIRST,DELTA,
     * TICSPC,IPOWER,NUMDIG,LABTIC)
C
C
C    THIS ROUTINE IS USED TO DRAW AN AXIS.
C
C
C    CALLING SEQUENCE:
C
C      CALL AXIS (XO,YO,TITLE,NCHAR,AXSLEN,ANGLE,FIRST,DELTA)
C
C    (XO,YO) - (I) THE STARTING POINT OF THE AXIS
C
C    TITLE   - (I) THE TITLE TO BE PUT ON THE AXIS
C
C    NCHAR   - (I) THE NUMBER OF CHARACTERS IN THE TITLE (IF NEGATIVE
C                PUT THE TITLE ON THE CLOCKWISE SIDE OF THE AXIS, IF
C                POSITIVE PUT THE TITLE ON THE COUNTER-CLOCKWISE SIDE
C                OF THE AXIS, OR IF ZERO DON'T PUT THE TITLE ON, BUT
C                PUT NUMBERING ON THE COUNTER-CLOCKWISE SIDE)
C
C    AXSLEN  - (I) THE LENGTH OF THE AXIS IN INCHES
C
C    ANGLE   - (I) THE ANGLE IN DEGREES TO ROTATE THE AXIS
C
C    FIRST   - (I) THE INITIAL VALUE TO PUT ON THE AXIS
C
C    DELTA   - (I) THE INCREMENT VALUE (THIS VALUE IS ADDED AT EACH TIC
C                MARK)
C
C
C    CALLING SEQUENCE:
C
C      CALL AXES (XO,YO,TITLE,NCHAR,AXSLEN,ANGLE,FIRST,DELTA,
C     * TICSPC,IPOWER,NUMDIG,LABTIC)
C
C    XO, YO, TITLE, NCHAR, AXSLEN, ANGLE, FIRST AND DELTA ARE THE SAME
C      AS IN AXIS
C
C    TICSPC  - (I) THE DISTANCE BETWEEN TIC MARKS
C
C    IPOWER  - (I) THE POWER TO RAISE THE NUMBERS ON THE AXIS TOO
C
C    NUMDIG  - (I) THE NUMBER OF DIGITS AFTER THE DECIMAL POINT WANTED
C                (IF INTEGERS ARE WANTED NUMDIG SHOULD BE SET EQUAL TO
C                -1, IF NO NUMBERS ARE WANTED NUMDIG SHOULD BE SET EQUAL
C                TO 999)
C
C    LABTIC  - (I) THE DELTA FOR LABELING THE TIC MARKS (IF NO LABTIC IS
C                LESS THAN ONE NO LABELING WILL BE DONE)
C
C
C    SUBPROGRAMS USED:
C
C      IFIX, SIGN, IABS, ALOG10, FLOAT, COSD, SYMBOL, SIND, NUMBER,
C      ABS AND PLOT
C
C
      DIMENSION TITLE(1)
      LOGICAL NUMFLG
      EQUIVALENCE (DIG,YNUM0),(XNUM,XNUM0),(IEXP,EXP)

      POWER = 1.0
      GOTO 10

      ENTRY AXIS (XO,YO,TITLE,NCHAR,AXSLEN,ANGLE,FIRST,DELTA)

      IPOWER = 0
      POWER = 1.0
      TICSPC = 1.0
      NUMDIG = 2
      LABTIC = 1

      EXP = ALOG10(ABS(DELTA))
      IF (EXP .LT. 0.0) EXP = EXP - 1.0
      IEXP = EXP + 0.0000001
      IF (IABS(IEXP) .LE. 2) GOTO 10
      IPOWER = IEXP
      POWER = 10.0 ** (-IEXP)
10    FIRST0 = FIRST * POWER
      DELTA0 = DELTA * POWER

      AXSLN = ABS(AXSLEN)
      TICSP = ABS(TICSPC)
      SINE = SIND(ANGLE)
      COSINE = COSD(ANGLE)
      XTIC = TICSP * COSINE
      YTIC = TICSP * SINE
      SIDE = SIGN(0.07,FLOAT(NCHAR))
      X = XO
      Y = YO

      NUMFLG = NUMDIG .EQ. 999 .OR. LABTIC .LE. 0
      IF (NUMFLG) GOTO 20
      CUR = FIRST0
      YNUM = -0.2
      IF (SIDE .GE. 0.0) YNUM = 0.1

20    N = AXSLN / TICSP + 0.0000001
      N2 = N / 2

      DO 60 I = 0,N

         IF (I .NE. N2 .OR. NCHAR .EQ. 0) GOTO 30
         ICHAR = IABS(NCHAR)
         XNUM0 = (AXSLN - FLOAT(ICHAR) * 0.15) / 2.0
         IF (IPOWER .NE. 0) XNUM0 = XNUM0 - 0.525
         YNUM0 = -0.40
         IF (SIDE .GE. 0) YNUM0 = 0.25
         XN = XO - YNUM0 * SINE + XNUM0 * COSINE
         YN = YO + XNUM0 * SINE + YNUM0 * COSINE
         CALL SYMBOL (XN,YN,0.15,TITLE,ANGLE,ICHAR)
         IF (IPOWER .EQ. 0) GOTO 30
         CALL SYMBOL (999.,999.,0.15,' (*10 )',ANGLE,9)
         XNUM0 = XNUM0 + FLOAT(ICHAR + 5) * 0.15
         YNUM0 = YNUM0 + 0.12
         XN = XO - YNUM0 * SINE + XNUM0 * COSINE
         YN = YO + XNUM0 * SINE + YNUM0 * COSINE
         CALL NUMBER (XN,YN,0.06,FLOAT(IPOWER),ANGLE,-1)

30       IF (NUMFLG) GOTO 50
         IF (I .NE. I / LABTIC * LABTIC) GOTO 40
         XN = X - YNUM * SINE - 0.1 * COSINE
         YN = Y - 0.1 * SINE + YNUM * COSINE
         CALL NUMBER (XN,YN,0.1,CUR,ANGLE,NUMDIG)
40       CUR = CUR + DELTA0 * TICSP

50       XN = X - SIDE * SINE
         YN = Y + SIDE * COSINE
         CALL PLOT (XN,YN,3)
         CALL PLOT (X,Y,2)
         IF (I .EQ. N) GOTO 70
         X = X + XTIC
         Y = Y + YTIC
60       CALL PLOT (X,Y,2)

70    X = XO + AXSLN * COSINE
      Y = YO + AXSLN * SINE
      CALL PLOT (X,Y,2)

      RETURN
      END
    
