c Ridit analysis program
c Updated July 1982
c By Peter J. Plourd II and Ardoth A. Hassler
c The Catholic University of America
c
c Ridit ("relative to an identified distribution") analysis
c was developed by Irwin D.J. Bross in 1958
c
c Input and Output Variables:
c
c	KT - Terminal input from user
c	KR - Input file containing data for calculations
c	KW - The output file
c
	COMMON NSAMP,AN(2),KR,KW
	DIMENSION OBS(25,2),FMT(16)
        NCOEF=9
        NSAMP=2
        AN(1)=0
        AN(2)=0
	KT=5
	KR=21
	KW=22
c
c The input and output files are opened
c
	WRITE(KT,5)
5	FORMAT(' *',$)
	READ (KT,7)INFIL
7	FORMAT(2A5)
        OPEN (UNIT=KR,FILE=INFIL)
	OPEN (UNIT=KW,FILE='RIDIT.LST')
c
c Data is read in from data file. Initially the number of cases
c then the format of the data, and finally the data is read in.
c
        READ(KR,10)N
10      FORMAT(I)
        READ(KR,20)FMT
20      FORMAT(16A5)
	READ(KR,25)WISE
25	FORMAT(A1)
        WRITE(KW,30)
30      FORMAT(22X,'RIDIT ANALYSIS'//24X,'INPUT DATA'//
     1  25X,'1',5X,'2',4X,'TOTAL'/)
	IF(WISE.EQ.'C'.OR.WISE.EQ.'c')GO TO 61
c
c The data is stored column wise and is read in here
c
        DO 60 I=1,N
        READ(KR,FMT)(OBS(I,J),J=1,2)
60      CONTINUE
	GO TO 66
c
c The data is stored row wise and is read in here
c
61	DO 65 J=1,2
	READ(KR,FMT)(OBS(I,J),I=1,N)
65	CONTINUE
c
c Summation of the case values
c
66	DO 69 I=1,N
        WRITE(KW,68)I,(OBS(I,J),J=1,2)
68      FORMAT(17X,I2,3X,F5.0,1X,F5.0)
        AN(1)=AN(1)+OBS(I,1)
        AN(2)=AN(2)+OBS(I,2)
69	CONTINUE
c
c Total value of the combined case
c
        TOT=AN(1)+AN(2)
        WRITE(KW,70)AN(1),AN(2),TOT
70      FORMAT(/12X,'TOTAL',5X,F5.0,1X,F5.0,3X,F5.0)

        CALL RIDIT(N,OBS)
c
c Processing is completed and the files are closed
c
	CLOSE(UNIT=KW)
        CLOSE(UNIT=KR)
	END
c
c The actual Ridit calculations are done in this subprogram
c and the results printed to the output file
c
	SUBROUTINE RIDIT(NCELLS,OBS)
c
c Written by Ardoth A. Hassler
c
c A brief description of the calculation of the Ridits for
c the identified distribution.
c
c  1.  The initial entries for the cell total are first halved,
c  2.  The entries are then totaled cumulatively, but offset by
c      one category.
c  3.  The sum of the values calculated in one and two.
c  4.  The first Ridit is calculated by taking the values from three
c      and dividing by the total sample size
c  5.  The sample Ridits are the product of the Identified Distribution
c      Ridits and the cell totals for the distribution.
c
c  Arrays:
c
c      Ridits - Identification Distribution Ridits
c      Amean - Mean values
c      Obs - Observation matrix
c
	COMMON NSAMP,AN(2),KR,KW
	DIMENSION RIDITS(10),AMEAN(2),OBS(25,2)
	J=1
        CUM=0.
	WRITE(KW,5)
5 	FORMAT(//25X,'RIDITS'/)
c
c Cumulative frequency of the cells, offset by one cell
c and add half of the cell total
c
 	DO 10 I=1,NCELLS
	IF(I.GT.1)CUM=CUM+OBS(I-1,J)
	RIDITS(I)=.5*OBS(I,J)+CUM
10	CONTINUE
c
c The Ridits are calculated and printed here
c
	DO 20 I=1,NCELLS
 	RIDITS(I)=RIDITS(I)/AN(J)
	RIDITX=RIDITS(I)*OBS(I,2)
	WRITE(KW,15)I,RIDITS(I),RIDITX
15	FORMAT(17X,I2,3X,F6.3,1X,F6.3)
20	CONTINUE
c
c Calculation of the samples mean value
c
	DO 40 J=1,NSAMP
	AMEAN(J)=0.
	DO 30 I=1,NCELLS
	AMEAN(J)=AMEAN(J)+RIDITS(I)*OBS(I,J)
30	CONTINUE
 	AMEAN(J)=AMEAN(J)/AN(J)
40	CONTINUE
c
c Standard error and Z value is calculated
c
 	SE=SQRT(AN(1)+AN(2))/(2.*SQRT(3*AN(1)*AN(2)))
 	Z=(AMEAN(2)-AMEAN(1))/SE

c
c Printing out of final results from the analysis
c
        WRITE(KW,50)AMEAN(1),AMEAN(2)
50      FORMAT(/12X,'MEAN',7X,F5.3,2X,F5.3)
	WRITE(KW,60)SE,Z
60      FORMAT(//14X,'Z:',F10.4//1X,'STANDARD ERROR:',F10.4)
	RETURN
	END
