

















                         GT40 SOFTWARE PACKAGE
                             GIDUS - DISLIB



                          AUTHOR - BILL WILDER

                         COMPLETED: 15-MARCH-76


                THIS DOCUMENTATION WAS LAST UPDATED ON:

                             21-DECEMBER-76
                                                                  Page 2


                           TABLE OF CONTENTS



CHAPTER I GT40 HARDWARE AND PROGRAMMING CONCEPTS             1-1
  1.1  GENERAL HARDWARE                                      1-1
  1.2  DISPLAY PROCESSOR                                     1-2
  1.3  DISPLAY INSTRUCTIONS                                  1-3
  1.4  DPU DATA TYPES                                        1-5
  1.5  GT40 PROGRAMMING EXAMPLES                             1-7
    1.5.1  MACRO-11 EXAMPLE                                  1-9
  1.6  GT40 PROGRAMMING SUMMARY                             1-10


CHAPTER II GIDUS-DISLIB INTERACTION                          2-1


CHAPTER III USING GIDUS                                      3-1
  3.1  GT40 BOOTSTRAP PROGRAM                                3-1
  3.2  PROGRAM LOAD EXAMPLE                                  3-3
  3.3  INTERACTING WITH GIDUS                                3-6
  3.4  GIDUS COMMANDS                                       3-11
  3.5  GIDUS ERROR MESSAGES                                 3-14
    3.5.1  WARNINGS                                         3-14
    3.5.2  FATAL ERRORS                                     3-15
  3.6  RE-STARTING GIDUS                                    3-16
                                                                  Page 3


CHAPTER IV USING DISLIB                                      4-1
  4.1  INITIALIZATION ROUTINES (CATEGORY I)                  4-3
    4.1.1  SUBROUTINE START                                  4-3
  4.2  DISPLAY CREATION ROUTINES (CATEGORY II)               4-5
    4.2.1  SUBROUTINE SCALE                                  4-6
    4.2.2  SUBROUTINE INIT                                   4-8
    4.2.3  SUBROUTINE POINT                                 4-10
    4.2.4  SUBROUTINE VECTOR                                4-11
    4.2.5  SUBROUTINE MOVE                                  4-12
    4.2.6  SUBROUTINE JOIN                                  4-13
    4.2.7  SUBROUTINE DOT                                   4-14
    4.2.8  SUBROUTINE TEXT                                  4-15
    4.2.9  SUBROUTINE SETMOD                                4-17
    4.2.10 SUBROUTINE SETA                                  4-18
    4.2.11 SUBROUTINE ADFILE                                4-19
    4.2.12 INTEGER FUNCTION DSTAT                           4-21
    4.2.13 SUBROUTINE GETPOS                                4-22
  4.3  DISPLAY MANIPULATION ROUTINES (CATEGORY III)         4-23
    4.3.1  SUBROUTINE ENABLE                                4-23
    4.3.2  SUBROUTINE DISABL                                4-25
    4.3.3  SUBROUTINE DELETE                                4-26
    4.3.4  SUBROUTINE MOVFIL                                4-27
  4.4  POINTER ROUTINES (CATEGORY IV)                       4-28
    4.4.1  SUBROUTINE GETMP                                 4-28
    4.4.2  SUBROUTINE MOVEMP                                4-29
    4.4.3  SUBROUTINE GETAP                                 4-30
    4.4.4  SUBROUTINE MOVEAP                                4-30
  4.5  LIGHT PEN ROUTINES (CATEGORY V)                      4-31
    4.5.1  SUBROUTINE LPON                                  4-31
    4.5.2  SUBROUTINE LPOFF                                 4-32
    4.5.3  SUBROUTINE LPHIT                                 4-33
    4.5.4  SUBROUTINE LLPHIT                                4-34
  4.6  GT40 MANIPULATION ROUTINES (CATEGORY VI)             4-35
    4.6.1  SUBROUTINE CLEAR                                 4-35
    4.6.2  SUBROUTINE PHOTO                                 4-36
    4.6.3  SUBROUTINE RESET                                 4-37
  4.7  LOG ROUTINES (CATEGORY VII)                          4-38
    4.7.1  SUBROUTINE LOGON                                 4-38
    4.7.2  SUBROUTINE LOGOFF                                4-39
    4.7.3  SUBROUTINE ERROR                                 4-40
  4.8  OPTION ROUTINES (CATEGORY VIII)                      4-41
    4.8.1  SUBROUTINE ADDOPT                                4-41
    4.8.2  SUBROUTINE SNDOPT                                4-43
    4.8.3  SUBROUTINE GETOPT                                4-44
    4.8.4  SUBROUTINE OPTOFF                                4-46
    4.8.5  SUBROUTINE OPTON                                 4-47
    4.8.6  SUBROUTINE CLROPT                                4-48
                                                                  Page 4


  4.9  TERMINATION ROUTINES (CATEGORY IX)                   4-49
    4.9.1  SUBROUTINE FINI                                  4-49
  4.10 INTERNAL ROUTINES (CATEGORY X)                       4-50


CHAPTER V DISLIB COMMON BLOCKS                               5-1
  5.1  LOG BLOCK                                             5-2
  5.2  SCALE BLOCK                                           5-3
  5.3  MODE BLOCK                                            5-4
  5.4  STATUS-A BLOCK                                        5-5
  5.5  OPTION BLOCK                                          5-6
  5.6  MISCELLANEOUS BLOCK                                   5-7


CHAPTER VI DISLIB PROGRAMMING EXAMPLES                       6-1
  6.1  CAT-EYE DEMONSTRATION                                 6-1
  6.2  ELLIPSE DEMONSTRATION                                 6-4
  6.3  TEXT DEMONSTRATION                                    6-7
  6.4  OPTION DEMONSTRATION                                  6-9


CHAPTER VII DISLIB SUMMARY                                   7-1
  7.1  COMPILING AND RUNNING PROGRAMS                        7-1
  7.2  STOPPING YOUR PROGRAM                                 7-2
  7.3  SUMMARY                                               7-3
                                                                  Page 5


INTRODUCTION:

     THIS MANUAL IS A USER'S GUIDE TO THE INTERACTIVE  GRAPHICS  PACKAGE
(GIDUS - DISLIB) DEVELOPED AT ACADIA UNIVERSITY.  ACADIA'S MAIN COMPUTER
IS A SMALL DECSYSTEM-10 WITH A KA PROCESSOR  AND  112K  OF  MAIN  MEMORY
(I.E.   A  1040).   ONE OF THE TERMINALS CONNECTED WITH THE 10 IS A GT40
GRAPHICS TERMINAL (FOR A DESRIPTION OF THE HARDWARE AND  PROGRAMMING  OF
THE GT40, SEE THE FOLLOWING SECTION).

     GIDUS, WHICH STANDS FOR "GT40 INTERACTIVE DISPLAY  UTILITY  SYSTEM"
IS  A  MINI-OPERATING  SYSTEM  FOR  THE  GT40.  ITS PURPOSE IS TO HANDLE
COMMUNICATIONS WITH THE 10, AND PROVIDE MEMORY MANAGEMENT FACILITIES FOR
DISPLAY  FILES WHICH ARE TRANSMITTED BY THE 10.  DISLIB WHICH STANDS FOR
"DISPLAY LIBRARY" IS A COLLECTION OF FORTRAN CALLABLE SUBROUTINES,  USED
TO CREATE DISPLAY FILES AND TRANSMIT THEM TO THE GT40.

     AN IMPORTANT CONCEPT TO UNDERSTAND FROM THE BEGINNING IS - "WHAT IS
A  DISPLAY FILE?".  THE NAME IS A BIT MISLEADING SINCE A DISPLAY FILE IS
NOT A FILE IN THE USUAL  SENSE  OF  THE  WORD  (I.E.   A  COLLECTION  OF
INFORMATION ON SECONDARY STORAGE OR SOME EXTERNAL MEDIUM).  TO DISLIB, A
DISPLAY FILE IS AN INTEGER VECTOR OF SOME ARBITRARY LENGTH.  THE DISPLAY
CREATION  ROUTINES USE THESE VECTORS AS A HOLDING AREA IN WHICH TO BUILD
A DISPLAY.  ONCE THE DISPLAY IS COMPLETED, IT IS TRANSMITTED TO THE GT40
WHERE GIDUS ADDS IT TO A LINKED LIST OF PREVIOUSLY CREATED DISPLAYS.  TO
THE GT40, THIS DISPLAY FILE BECOMES A DISPLAY PROGRAM TO BE EXECUTED  BY
THE DPU (SEE FOLLOWING SECTION).












                               CHAPTER 1

                   HARDWARE AND PROGRAMMING CONCEPTS



1.1  GENERAL HARDWARE:

     THE GT40 IS A STAND ALONE MINI-COMPUTER.  IT IS A PDP-11/05 WITH 8K
WORDS  OF  MAIN MEMORY (8192, 16-BIT WORDS).  THE 11/05 IS MEMBER OF THE
PDP-11 FAMILY OF COMPUTERS AND HAS AN INSTRUCTION SET WHICH IS A  SUBSET
OF  AN  11/45 IN ADDITION TO BEING A STAND ALONE MINI-COMPUTER, THE GT40
CONTAINS THE HARDWARE NECESSARY FOR DISPLAYING GRAPHICS.

     THIS DISPLAY HARDWARE CONSISTS OF A CATHODE RAY  TUBE(CRT),  CALLED
THE  VR14,  A  DISPLAY  PROCESSING  UNIT  (THE  DPU),  AND  A LIGHT-PEN.
CERTAINLY THE MOST VISIBLE OF THESE ELEMENTS IS THE CRT, BUT IT  IS  THE
DPU  WHICH  IS  OF  MOST  INTEREST  TO  THE PROGRAMMER WISHING TO CREATE
DISPLAYS.  JUST AS A PROGRAMMER HAS  TO  WRITE  A  PROGRAM  TO  SUM  TWO
NUMBERS,  IT  IS  ALSO NECESSARY TO WRITE A PROGRAM TO DISPLAY A LINE ON
THE SCREEN OF THE GT40.  THE DIFFERENCE BETWEEN THE TWO PROGRAMS IS THAT
THE  FIRST  WOULD BE EXECUTED BY THE CPU (CENTRAL PROCESSING UNIT) WHILE
THE SECOND WOULD BE EXECUTED BY THE DPU.

     PROGRAMMING THE DPU, HOWEVER, IS ACTUALLY QUITE A SIMPLE TASK.  THE
CPU HAS MANY, MANY INSTRUCTIONS, AND SEVERAL DIFFERENT ADDRESSING MODES.
IN ADDITION, DATA TYPES ARE DETERMINED BY THE PROGRAM RUNNING (I.E.  DID
THE  CPU  JUST  FETCH  A  WORD  CONTAINING AN INTEGER, OR FLOATING POINT
NUMBER, OR DID IT JUST FETCH TWO BYTES REPRESENTING  ASCII  CHARACTERS).
THE  DPU ON THE OTHER HAND HAS VERY FEW INSTRUCTIONS (ONLY FIVE) AND HAS
ONLY SEVEN FIXED DATA TYPES.  BOTH THE CPU  AND  THE  DPU  WORK  ON  THE
STORED  PROGRAM CONCEPT.  THIS MEANS PROGRAM AND DATA ARE BOTH CONTAINED
IN CORE MEMORY (THE 8K MENTIONED EARLIER) AND IT IS THE JOB OF  WHATEVER
PROCESSOR  INVOLVED  TO  FETCH  INSTRUCTIONS  AND  INTERPRET  DATA.  ONE
SIGNIFICANT DIFFERENCE BETWEEN THE PROCESSORS  IS  THAT  THE  CPU  IS  A
READ/WRITE  PROCESSOR  (HAVING  THE  ABILITY  TO MODIFY WORDS IN MEMORY)
WHILE THE DPU IS  A  READ  ONLY  PROCESSOR.   ONCE  THE  DPU  HAS  BEGUN
EXECUTING  A  DISPLAY PROGRAM IT SIMPLY RUNS UNTIL IT ENCOUNTERS THE END
OF THE PROGRAM AND THEN STOPS.  IT HAS NO CAPABILITY  OF  MODIFYING  THE
PROGRAM  IT  IS  EXECUTING.   NOTE  THAT  THE  CPU AND THE DPU SHARE THE
AVAILABLE MEMORY.  IT  IS  NECESSARY  THAT  THE  PROGRAMS  FOR  THE  TWO
PROCESSORS  ARE KEPT SEPARATE.  IF THE CPU ATTEMPTS TO EXECUTE A DISPLAY
PROGRAM OR THE DPU ATTEMPTS  TO  EXECUTE  A  CPU  PROGRAM,  DISASTER  IS
GUARANTEED.   UNPREDICTABLE RESULTS WILL OCCUR AND THE PROGRAM WILL HAVE
TO BE RE-STARTED, OR MORE LIKELY RE-LOADED.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-2


     THE CPU, BEING THE MORE POWERFUL AND GENERAL  PURPOSE  OF  THE  TWO
PROCESSORS,  IS  THE DOMINANT PROCESSOR OF THE GT40.  GENERALLY THE GT40
IS PROGRAMMED SO THAT THE CPU CREATES A PROGRAM FOR THE DPU, AND  STARTS
IT  RUNNING.   FURTHERMORE,  IF  THE  DPU  EVER  CAUSES  AN INTERRUPT (A
LIGHT-PEN HIT FOR EXAMPLE) IT IS THE CPU WHICH  SERVICES  THE  INTERRUPT
AND RE-STARTS THE DPU.



1.2  DISPLAY PROCESSOR:

     AS MENTIONED EARLIER THE DPU HAS FIVE INSTRUCTIONS AND  SEVEN  DATA
TYPES.   BEFORE  DISCUSSING THESE INSTRUCIONS AND DATA TYPES A FEW TERMS
WILL BE EXPLAINED:

     THE GT40 HAS 1024 VIEWABLE POINTS IN THE X DIRECTION (THE BASE LINE
OF THE SCREEN) AND 768 VIEWABLE POINTS IN THE Y DIRECTION.  THE DISTANCE
BETWEEN THESE POINTS IS REFERRED TO AS A RASTER UNIT.   THE  LOWER  LEFT
HAND  CORNER OF THE SCREEN IS RASTER POSITION (0, 0) AND THE UPPER RIGHT
HAND CORNER IS RASTER POSITION (1023, 767).

     DISPLAY DATA ARE EITHER RELATIVE OR ABSOLUTE.   AN  EXAMPLE  OF  AN
ABSOLUTE  DATUM  WOULD  BE  A  POINT  SPECIFIED  BY  A  PHYSICAL X AND Y
CO-ORDINATE.  A RELATIVE DATUM WOULD BE SPECIFIED AS  OFFSETS  FROM  THE
CURRENT  POSITION  OF  THE  DISPLAY  BEAM.   A  DISPLAY  THAT IS TOTALLY
RELATIVE ABOUT AN ABSOLUTE POINT HAS THE ADVANTAGE  THAT  CHANGING  THAT
ONE  POINT  WILL  MOVE THE ENTIRE DISPLAY.  A DISPLAY CONSISTING OF MORE
THAN ONE ABSOLUTE POINT, CANNOT BE MOVED IN THE SAME MANNER, UNLESS  ALL
ABSOLUTE POINTS ARE RELOCATED.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-3


1.3  DISPLAY INSTRUCTIONS:

     1) SET GRAPHIC MODE:

     THIS INSTRUCTION IS THE MOST IMPORTANT.  IT INFORMS THE DPU HOW  TO
INTERPRET THE DATA FOLLOWING (I.E.  LINES, POINTS, OR CHARACTERS, ETC.).
THE SGM INSTRUCTION ALSO INFORMS THE  DPU  OF  GRAPHIC  CHARACTERISTICS.
THESE  INCLUDE SUCH THINGS AS DISPLAY INTENSITY (FROM 0 - LOWEST, TO 7 -
BRIGHTEST), BLINK (A DISPLAY,  OR  A  PORTION  OF  IT  MAY  BE  HARDWARE
BLINKED),  THE  TYPE  OF  LINE TO DRAW (SOLID, LONG-DASH, SHORT-DASH, OR
DOT-DASH), AND FINALLY WHETHER THE DISPLAY IS  LIGHT  PEN  SENSITIVE  OR
NOT.  AN SGM INSTRUCTION REMAINS IN EFFECT UNTIL ANOTHER SGM INSTRUCTION
IS EXECUTED.

     2 ) DISPLAY JUMP INSTRUCTION (DJMP)

     THE  NEXT  MOST  IMPORTANT  INSTRUCTION   IS   THE   DISPLAY   JUMP
INSTRUCTION.   THIS  INSTRUCTION  INFORMS  THE  DPU  OF WHICH ADDRESS IT
SHOULD BRANCH TO IN ORDER TO PICK UP THE NEXT INSTRUCTION.   NORMALLY  A
DISPLAY  IS  EXECUTED  SEQUENTIALLY (I.E.  ONE WORD AFTER ANOTHER).  THE
DJMP INSTRUCTION ALLOWS A USER TO CREATE A DISPLAY PROGRAM WHICH IS  NOT
STORED CONTIGUOUSLY IN MEMORY.

     3) LOAD STATUS REGISTER A (LOAD-A)

     THIS INSTRUCTION IS USED TO INFORM THE DPU  OF  ADDITIONAL  DISPLAY
CHARACTERISTICS.   TWO OF THESE PARAMETERS ARE ITALICS (I.E.  CHARACTERS
WILL BE ITALICIZED INSTEAD OF NORMAL FONT), AND  LIGHT  PEN  SENSITIVITY
(I.E.   POINTS  OF  LIGHT  PEN  INTERACTION  WILL  BE  INTENSIFIED).  IN
ADDITION THIS INSTRUCTION CAN BE SET UP TO STOP THE DPU.  NOTE THAT WHEN
THE DPU IS STOPPED THE DISPLAY ON THE SCREEN WILL BEGIN TO FADE.  UNLESS
THE DPU IS RE-STARTED (BY THE CPU) WITHIN A SHORT TIME, THE DISPLAY WILL
DISAPPEAR  ENTIRELY.   OFTEN  DJMPS ARE USED TO PUT THE DPU INTO A LOOP,
ENDLESSLY EXECUTING A DISPLAY PROGRAM OVER AND OVER.  A DISPLAY  HAS  TO
BE  CONSTANTLY  REFRESHED OR IT WILL DISAPPEAR FROM THE SCREEN.  THIS IS
DUE TO THE FACT THAT THE PHOSPHOR, AT ANY PARTICULAR POINT ON THE SCREEN
BEGINS  TO FADE IMMEDIATELY AFTER BEING INTENSIFIED BY THE DISPLAY BEAM.
IF A DISPLAY PROGRAM IS QUITE LONG, YOU WILL NOTICE THE DISPLAY FLICKER,
DUE  TO  THE LENGTH OF TIME IT TAKES FOR THE DISPLAY BEAM TO REFRESH ANY
GIVEN POINT.

     WITH THIS IN MIND, THE QUESTION IMMEDIATELY OCCURS - "WHY STOP  THE
DISPLAY?".   DISPLAY  STOPS ARE SOMETIMES NECESSARY DUE TO THE FACT THAT
THE CPU AND DPU BOTH SHARE THE SAME  MEMORY.   IT  IS  OFTEN  USEFUL  TO
MODIFY  A  DISPLAY PROGRAM (E.G.  SUPPOSING YOU WANTED TO MOVE A DISPLAY
AROUND).  A POSSIBLE CONFLICT MIGHT OCCUR IF THE CPU  WAS  TO  MODIFY  A
WORD  OF  A  DISPLAY  FILE AT THE SAME TIME THE DPU ATTEMPTED TO EXECUTE
THAT WORD AS AN INSTRUCTION, OR INTERPRET IT AS DATA.  IF THIS  CONFLICT
IS  ALLOWED  TO GO UNRESOLVED (I.E.  THE CPU ACTIVELY UPDATING A RUNNING
DISPLAY) THE DISPLAY MIGHT CRASH (INDEED THIS DOES OCCUR).  THE SOLUTION
TO  THE  PROBLEM IS TO PLACE A LOAD-A INSTRUCTION (WITH STOP BITS ON) AT
THE END OF THE DISPLAY.  THE CPU CAN DETECT WHEN THE STOP HAS  OCCURRED,
MODIFY  THE  DISPLAY PROGRAM, AND RE-START THE DISPLAY.  THIS ALL OCCURS
SO QUICKLY THAT THE DISPLAY SEEMS CONSTANTLY VISIBLE.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-4


     THE DPU HAS TWO ADDITIONAL INSTRUCTIONS (NEITHER OF WHICH ARE  USED
BY GIDUS DISPLAYS).

     4) LOAD STATUS REGISTER B (LOAD-B)

     THIS INSTRUCTION IS USED TO SET THE INCREMENT BETWEEN  POINTS  WHEN
INTERPRETING DATA IN GRAPHPLOT MODE.  GRAPHPLOT MODE IS DISCUSSED LATER,
BUT IS NOT IMPLEMENTED IN THE GIDUS-DISLIB SYSTEM BECAUSE OF ITS LIMITED
USE.

     5) DISPLAY NO-OPERATION (DNOP)

     THIS IS A DISPLAY INSTRUCTION WHICH CAUSES NOTHING TO  HAPPEN.   IT
IS  NOT  QUITE  AS  USELESS  AS  IT  MIGHT  SEEM,  SINCE IT IS SOMETIMES
CONVENIENT TO CREATE A DISPLAY WHICH IS LONGER THAN MIGHT  INITIALLY  BE
NEEDED.  DNOPS CAN BE USED TO PAD A DISPLAY IN THIS MANNER.  NONE OF THE
DISLIB DISPLAY CREATION ROUTINES ADDS DNOPS TO A DISPLAY FILE.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-5


1.4  DPU DATA TYPES:

     AS MENTIONED ABOVE, THE DPU  IS  CAPABLE  OF  DISTINGUISHING  SEVEN
DIFFERENT  TYPES  OF  DISPLAY  DATA.   HOW  A PARTICULAR WORD FETCHED IS
INTERPRETED BY THE DPU DEPENDS ON THE DATA MODE LAST SELECTED BY AN  SGM
INSTRUCTION.  THESE DATA TYPES ARE AS FOLLOWS:

     1) CHARACTER MODE (RELATIVE)

     THE NEXT  DATA  WORD  FETCHED  IS  ASSUMED  TO  CONTAIN  TWO  ASCII
CHARACTERS.   THESE  ARE  DRAWN ON THE SCREEN AT THE CURRENT POSITION OF
THE DISPLAY BEAM.  THE CHARACTERS ARE OF A FIXED SIZE ( 6  BY  8  RASTER
DOT  MATRIX),  BUT  ITALICS  OR  NORMAL FONT MAY BE SELECTED BY A LOAD-A
INSTRUCTION.  SINCE CHARACTERS ARE DRAWN BY THE  HARDWARE,  RATHER  THAN
SOFTWARE, THEIR SIZE AND ROTATION CANNOT BE VARIED.

     2) POINT MODE (ABSOLUTE)

     THE NEXT TWO DATA WORDS FETCHED ARE ASSUMED TO BE ABSOLUTE  (X  AND
Y)  CO-ORDINATES.  THE DISPLAY BEAM CONTINUES DRAWING GRAPHICS FROM THAT
POINT.  THE POINT MAY BE ENABLED OR DISABLED; IF ENABLED, THE  POINT  IS
VISIBLE.

     3) LONG VECTOR MODE (RELATIVE)

     THE NEXT  TWO  DATA  WORDS  FETCHED  ARE  ASSUMED  TO  BE  RELATIVE
DISPLACEMENTS  (FROM  THE CURRENT POSITION OF THE DISPLAY BEAM) IN THE X
AND Y DIRECTIONS.  THESE DISPLACEMENTS MAY BE POSITIVE OR NEGATIVE,  AND
THE  VECTOR  SO  DESCRIBED  MAY  BE  ENABLED  OR DISABLED.  IF ENABLED A
VISIBLE LINE IS ADDED TO THE SCREEN.  IF DISABLED AN INVISIBLE  LINE  IS
ADDED  TO  THE  SCREEN,  THE  EFFECT BEING TO MOVE THE DISPLAY BEAM.  AN
INVISBLE VECTOR IS SOMEWHAT ANALAGOUS TO MOVING A PLOTTER PEN, WITH  THE
PEN  RAISED.  AN INVISIBLE VECTOR IS PREFERRED TO A POINT, BECAUSE IT IS
RELATIVE.

     4) SHORT VECTOR MODE (RELATIVE)

     THIS WORKS THE SAME WAY AS LONG VECTORS, EXCEPT ONLY  ONE  WORD  IS
USED  TO  CONTAIN  THE X AND Y DEFLECTIONS.  SINCE ONLY ONE WORD IS USED
THERE IS A MAXIMUM DISPLACEMENT OF 63 RASTER UNITS IN EITHER  DIRECTION.
IF THERE ARE A GROUP OF POINTS TO BE JOINED TOGETHER (AND THEY ARE CLOSE
ENOUGH) THEY COULD BE JOINED BY EITHER LONG  OR  SHORT  VECTORS.   SHORT
VECTORS  WOULD  BE  PREFERRED  SINCE  IT  RESULTS  IN  A SMALLER DISPLAY
PROGRAM.

     5) RELATIVE POINT MODE (RELATIVE)

     RELATIVE POINT MODE IS TO POINT MODE WHAT SHORT VECTORS ARE TO LONG
VECTORS.   THERE IS ONE CRUCIAL DIFFERENCE HOWEVER, AND THAT IS THE FACT
THAT POINT MODE IS ABSOLUTE, BUT RELATIVE  POINT  MODE  IS  OBVIOUSLY  -
RELATIVE.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-6


     6) GRAPH-X MODE (ABSOLUTE)

     THIS DATA MODE IS USED FOR PLOTTING FUNCTIONS IN X OF Y.  THE  NEXT
DATA WORD FETCHED IS AN ABSOLUTE X CO-ORDINATE.  THE Y INCREMENT BETWEEN
POINTS IS ESTABLISHED  WITH  A  LOAD-B  INSTRUCTION.   (GRAPH-X  IS  NOT
SUPPORTED BY THE GIDUS-DISLIB PACKAGE).

     7) GRAPH-Y MODE (ABSOLUTE)

     THIS IS VERY SIMILAR TO GRAPH-X MODE EXCEPT THAT THIS IS  USED  FOR
PLOTTING  FUNCTIONS  IN  Y  OF  X.  (AGAIN THIS MODE IS NOT SUPPORTED BY
GIDUS-DISLIB).  GRAPH-PLOT MODE IS OF LIMITED USE FOR TWO  REASONS.   1)
IT  CREATES AN ABSOLUTE DISPLAY, AND 2) GRAPH-PLOT PLOTS A FUNCTION WITH
POINTS INSTEAD OF VECTORS, WHICH MEANS YOUR  INCREMENT  MUST  BE  CHOSEN
QUITE SMALL BEFORE A MEANINGFUL FUNCTION APPEARS.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-7


1.5  GT40 PROGRAMMING EXAMPLE:

     THE FOLLOWING IS AN EXAMPLE OF A DISPLAY PROGRAM FOLLOWED BY A  FEW
NOTES.   HOPEFULLY, IT WILL MAKE THE PRECEDING DISCUSSION CLEARER.  NOTE
THAT A LINE PRECEDED BY I INDICATES AN INSTRUCTION, AND A LINE  PRECEDED
BY D INDICATES A DATA WORD:


START:   I-      SGM (POINT, INTENSITY 2, NO-BLINK, SOLID LINE)
         D-      100 (DISABLED)
         D-      100
         I-      SGM (LONG VECTOR)
         D-      100 (ENABLED)
         D-      0
         D-      0 (ENABLED)
         D-      100
         I-      SGM (LONG VECTOR, DASHED LINE)
         D-      -100 (ENABLED)
         D-      0
         I-      SGM (LONG VECTOR, BLINK)
         D-      0 (ENABLED)
         D-      -100
         I-      SGM (SHORT VECTOR)
         D-      10 X, -30 Y (DISABLED)
         I-      SGM (CHARACTER, NO BLINK)
         I-      LOAD-A (ITALICS)
         D-      BO
         D-      X<BLANK>
         I-      DJMP
         I-      START

     NOTES:

     EACH LINE CORRESPONDS TO ONE WORD OF MEMORY.

     THE FIRST INSTRUCTION IS AN SGM WHICH SPECIFIES THAT DATA FOLLOWING
IS  TO  BE INTERPRETED AS ABSOLUTE POINTS, THERE SHOULD BE NO BLINK, AND
ANY LINES DRAWN SHOULD BE SOLID.

     THE NEXT TWO WORDS GIVE THE ABSOLUTE  LOCATION  WHERE  THE  DISPLAY
BEAM SHOULD START.  SINCE THE POINT IS DISABLED, NO DOT WOULD APPEAR.

     THE NEXT  INSTRUCTION  SPECIFIES  THAT  DATA  FOLLOWING  IS  TO  BE
INTERPRETED  AS  LONG VECTORS WHICH ARE RELATIVE.  THE VECTOR IS ENABLED
(I.E.  VISIBLE) AND EXTENDS  100  RASTER  UNITS  TO  THE  RIGHT,  THE  Y
POSITION  IS  UNCHANGED.   THIS WOULD POSITION THE DISPLAY BEAM AT (200,
100) - ABSOLUTE RASTER CO-ORDINATES.

     THE NEXT TWO WORDS (AGAIN LONG VECTOR), MEAN DRAW A  SOLID  VISIBLE
LINE,  STRAIGHT  UP - 100 RASTER UNITS.  THIS WOULD POSITION THE DISPLAY
BEAM AT (200, 200) - ABSOLUTE RASTER.

     THE FOLLOWING INSTRUCTION INDICATES THAT THE  DATA  TYPE  IS  STILL
LONG VECTORS, BUT LINES SHOULD NOW BE DASHED.
HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-8


     THE NEXT TWO DATA WORDS CAUSE A VISIBLE DASHED VECTOR TO  BE  DRAWN
FROM  (200,  200)  TO  (100, 200) LEAVING THE DISPLAY BEAM AT THE LATTER
POSITION.

     THE FOLLOWING INSTRUCTION INDICATES THAT THE  DATA  TYPE  IS  STILL
LONG VECTOR, LINE TYPE IS DASHED, AND THAT THE VECTOR SHOULD BLINK.

     THE NEXT TWO DATA WORDS CAUSE A DASHED, BLINKING VECTOR TO BE DRAWN
FROM  (100,  200)  TO  (100,  100) LEAVING THE DISPLAY BEAM WHERE IT WAS
INITIALLY POSITIONED BY THE FIRST POINT INSTRUCTION.

     THE NEXT INSTRUCTION SPECIFIES SHORT VECTORS.

     THE FOLLOWING DATA WORD CAUSES THE DISPLAY BEAM TO MOVE TO LOCATION
(110, 70) BUT NO VECTOR IS DRAWN.

     THE NEXT  INSTRUCTION  INDICATES  THAT  DATA  FOLLOWING  IS  TO  BE
INTERPRETED AS CHARACTERS, AND THAT THEY SHOULD NOT BLINK.

     THE NEXT INSTRUCTION INDICATES THAT ITALICS FONT IS ENABLED.   NOTE
THAT  THE  LOAD-A INSTRUCTION DOES NOT CHANGE THE GRAPHIC MODE (I.E.  IT
IS STILL CHARACTER MODE).

     THE NEXT TWO DATA WORDS CONTAIN THE CHARACTERS "BOX "  WHICH  WOULD
BE DISPLAYED ON THE SCREEN, STARTING AT LOCATION (110, 70).

     FINALLY, THE LAST INSTRUCTION (WHICH IS TWO WORDS LONG) IS  A  DJMP
BACK  TO THE START OF THIS DISPLAY PROGRAM.  A DJMP IS THE ONLY TWO WORD
DISPLAY INSTRUCTION.  (THINK OF "START:" IN  THE  ABOVE  EXAMPLE,  AS  A
SYMBOLIC ADDRESS).


                                  NOTE


                    IF THE  CPU  ALTERED  THE  SECOND  OR
               THIRD  WORD  OF  THIS  PROGRAM, THE EFFECT
               WOULD BE TO MOVE THE ENTIRE DISPLAY.


HARDWARE AND PROGRAMMING CONCEPTS                               Page 1-9


1.5.1  MACRO-11 PROGRAM EXAMPLE:

     HERE IS THE PRECEDING EXAMPLE, CODED IN MACRO-11.



         .TITLE  DEMO - DEMONSTRATION PROGRAM
         .MCALL  GRAPHIC                 ; RETRIEVE MACROS
         GRAPHIC                         ; DO THE DEFINITIONS
         ;
         ; THIS DEMONSTRATION PROGRAM ILLUSTRATES DPU
         ; PROGRAMMING. THIS PROGRAM DRAWS A BOX ON THE
         ; SCREEN AT LOCATION (100, 100)
         ;
BEGIN:   MOV     #START,@#DPC            ; START PROGRAM RUNNING
         WAIT                            ; AND HANG UP THE CPU
         .RADIX  10
         ;
         ;
START:   POINT ! INT2 ! BLKOFF ! LINE0
         100
         100
         LONGV
         INTX ! 100
         0
         INTX
         100
         LONGV ! LINE1
         INTX ! MINUSX ! 100
         0
         LONGV ! BLKON
         INTX
         MINUSY ! 100
         RELATV
         ^O2536
         CHAR ! BLKOFF
         STATSA ! ITAL1
         .ASCII  /BOX /
         DJMP
         START
         ;
         ;
         .END    BEGIN
HARDWARE AND PROGRAMMING CONCEPTS                              Page 1-10


1.6  GT40 PROGRAMMING SUMMARY:

     ANYONE  SERIOUS  ABOUT  PROGRAMMING  THE  GT40   TO   ITS   FULLEST
CAPABILITIES,  OR  INTERESTED IN UNDERSTANDING AS MUCH AS POSSIBLE ABOUT
ITS OPERATION, WOULD BE ADVISED TO PROGRAM IT IN MACHINE LANGUAGE.   ONE
OF THE DECSYSTEM-10 CUSPS IS "MACDLX.SHR" WHICH IS A CROSS ASSEMBLER FOR
PDP 11'S.  ONCE YOUR PROGRAM HAS BEEN ASSEMBLED IT MAY  BE  LOADED  INTO
THE  GT40 WITH THE PROGRAM LOADER IN THE GT40 ACCOUNT.  THE GT40 ACCOUNT
ALSO CONTAINS A SYSTEM MACRO LIBRARY (SYSMAC.SML) TO AID IN CREATING DPU
INSTRUCTIONS AND DATA.

     PERSONS INTERESTED IN PROGRAMMING  HIGH-LEVEL  APPLICATIONS  (USING
GIDUS-DISLIB) WILL NOT NEED TO REMEMBER THE GT40 DETAILS JUST DISCUSSED.
THE DESCRIPTION OF THE DISLIB SUBROUTINES IS COMPLETE  ENOUGH  TO  ALLOW
HIGH-LEVEL  GRAPHICS  WITHOUT  CONCERN  FOR THE OPERATION OF THE CPU AND
DPU.












                               CHAPTER 2

                       GIDUS - DISLIB INTERACTION



     AS STATED PREVIOUSLY GIDUS IS A GT40 PROGRAM,  WHILE  DISLIB  IS  A
COLLECTION OF ROUTINES THAT WOULD BE CALLED BY A FORTRAN PROGRAM RUNNING
ON THE DECSYSTEM-10.  THE REASON FOR  THIS  TWO  PROGRAM,  TWO  COMPUTER
OPERATION  IS  AS FOLLOWS.  THE GT40 IS PRETTY MUCH DEDICATED TO BEING A
MEDIUM FOR DISPLAYING GRAPHIC DATA.  IT  IS  TRUE  THAT  THE  GT40  DOES
CONTAIN  A  GENERAL  PURPOSE  CPU WHICH COULD BE PROGRAMMED TO DO A WIDE
VARIETY OF TASKS INDEPENDENT OF THE DPU.  HOWEVER, THE MAIN PROCESSOR OF
THE GT40 IS QUITE WEAK (IT IS A MINI-COMPUTER), AND THE CPU IS DIFFICULT
TO PROGRAM (IT MUST BE PROGRAMMED IN ASSEMBLY LANGUAGE).   EVEN  IF  THE
GT40  COULD  BE  PROGRAMMED  IN  A HIGH - LEVEL LANGUAGE LIKE FORTRAN OR
ALGOL, THE LIMITED AMOUNT OF CORE IMPOSES SEVERE RESTRAINTS ON THE  TYPE
OF PROGRAM THAT COULD BE RUN.

     THE SOLUTION TO THIS PROBLEM IS  TO  PERFORM  ALL  THE  PROGRAMMING
NECESSARY  TO  CREATE  DISPLAYS  ON  THE  DECSYSTEM-10,  WHICH  HAS  THE
ADVANTAGE OF ADEQUATE AMOUNTS OF  CORE,  AND  THE  CAPABILITY  OF  BEING
PROGRAMMED  IN  A  SCIENTIFIC  LANGUAGE  SUCH  AS  FORTRAN.  THIS IS THE
APPROACH TAKEN BY THE GIDUS-DISLIB PACKAGE.

     THE 10 VIEWS THE GT40 AS A TERMINAL DEVICE, MAKING  NO  DISTINCTION
BETWEEN   IT   AND  A  TERMINAL  SUCH  AS  A  DECWRITER.   THE  GT40  IS
APPROXIMATELY EIGHT TIMES AS FAST AS THE DECWRITER, IF CONNECTED AT 2400
BAUD,  BUT  THE  10 IS COMPLETELY UNAWARE OF THE FACT THAT THE GT40 IS A
PROCESSING UNIT OF ITSELF.  THE 10 SEES THE GT40 AS A  DEVICE  THAT  CAN
TRANSMIT  OR  RECEIVE  8  BIT CHARACTERS.  IT IS THE GIDUS PROGRAM WHICH
INTERPRETS DATA BEING SENT FROM THE 10 AND DECIDES  WHAT  IS  A  DISPLAY
FILE AND WHAT IS NOT.

     THE DISLIB ROUTINES  COMMUNICATE  WITH  GIDUS  VIA  COMMANDS.   FOR
EXAMPLE,  A DISLIB ROUTINE MIGHT COMMAND GIDUS TO MOVE A CERTAIN DISPLAY
FILE TO A CERTAIN POSITION.  GIDUS WOULD EXECUTE THE COMMAND, AND  THEN,
BY  TRANSMITTING  A  STATUS  BUFFER  TO  THE 10, REPORT TO DISLIB ON THE
OPERATION OF THE COMMAND (I.E.  WAS THE COMMAND IN ERROR SOMEHOW, OR DID
THE  COMMAND  EXECUTE  PROPERLY).   AT  ALL TIMES THE 10 IS THE DOMINANT
PARTNER IN THE TWO COMPUTER ARRANGEMENT.  GIDUS  CAN  NEVER  INITIATE  A
COMMAND OF ITS OWN ACCORD AND TELL DISLIB WHAT TO DO.

     DISLIB  HAS  MANY  COMMANDS,  SEVERAL  OF  WHICH  ARE  INVOLVED  IN
TRANSMITTING DISPLAY FILES TO THE GT40.  A USER PROGRAM IMPLEMENTS THESE
COMMANDS VIA CALLS TO THE APPROPRIATE SUBROUTINES WHICH  ARE  DOCUMENTED
GIDUS - DISLIB INTERACTION                                      Page 2-2


IN CHAPTER 4.  IF GIDUS IS NOT RUNNING IN THE GT40, DISLIB WOULD BE ABLE
TO ACCOMPLISH LITTLE OF ITS  OWN.   SIMILARLY  GIDUS  REMAINS  BASICALLY
DORMANT,  UNTIL  A PROGRAM CONTAINING DISLIB ROUTINES IS INVOKED.  GIDUS
PERFORMS ONE FUNCTION,  HOWEVER,  INDEPENDENT  OF  WHATEVER  PROGRAM  IS
RUNNING  IN  THE  10,  AND  THAT IS THE FUNCTION OF TERMINAL SIMULATION.
MORE WILL BE DISCUSSED ABOUT THIS IN CHAPTER 3.












                               CHAPTER 3

                              USING GIDUS



3.1  GT40 BOOTSTRAP PROGRAM:

     GIDUS IS A STAND ALONE GT40 RESIDENT PROGRAM.  BEFORE ANY  DISPLAYS
(CREATED  BY  DISLIB)  CAN  BE  TRANSMITTED  TO  THE GT40, GIDUS MUST BE
RUNNING, IN ORDER TO ACCEPT THEM.  IT IS NECESSARY TO ACTIVATE THE  GT40
BOOTSTRAP PROGRAM IN ORDER TO LOAD GIDUS (OR ANY OTHER PROGRAM) INTO THE
GT40.  THE BOOTSTRAP IS A PROGRAM  WHICH  IS  IMPLEMENTED  IN  THE  GT40
HARDWARE.  THE PROGRAM IS RESIDENT IN READ ONLY MEMORY, AND CONSEQUENTLY
CANNOT BE MODIFIED OR DELETED.  THE BOOTSTRAP SERVES TWO PURPOSES.  ONCE
THE  BOOTSTRAP  HAS  BEEN  STARTED, THE GT40 WILL BEHAVE LIKE A TERMINAL
CONNECTED TO THE DECSYSTEM-10.  EACH CHARACTER YOU TYPE ON THE  KEYBOARD
WILL  BE  SENT  TO  THE 10, AND WHEN THE CHARACTER IS ECHOED BACK TO THE
GT40 IT  WILL  APPEAR  ON  THE  SCREEN.   WHEN  THE  SCREEN  HAS  BECOME
COMPLETELY FULL OF TEXT, DEPRESSING THE GT40 START SWITCH WILL CLEAR THE
SCREEN AND ONCE AGAIN RESUME OUTPUT AT THE UPPER LEFT HAND CORNER.  THIS
KEYBOARD  INPUT AND SCREEN OUTPUT ALLOW THE GT40 TO FUNCTION AS A NORMAL
TERMINAL.  IN OTHER WORDS, A USER MAY LOGIN, RUN ANY AVAILABLE  PROGRAM,
AND  LOG  OUT,  JUST  AS  HE MIGHT FROM ANY TERMINAL.  HOWEVER, WHEN THE
BOOTSTRAP PROGRAM IS RUNNING, IT IS NOT POSSIBLE TO DISPLAY ANY GRAPHICS
OTHER THAN THE CHARACTERS WHICH ARE OUTPUT FROM THE 10.

     THE SECOND FUNCTION OF THE BOOTSTRAP IS TO  ALLOW  PROGRAMS  TO  BE
LOADED  FROM THE 10 INTO THE GT40.  SINCE THE PROGRAM IS GOING TO RUN IN
THE GT40 IT MUST BE IN PDP 11/05  MACHINE  LANGUAGE  (I.E.   A  MACRO-11
PROGRAM  ASSEMBLED  BY  "MACDLX.SHR").   WHEN  THE  10  OUTPUTS  SPECIAL
CHARACTERS IN A SPECIAL SEQUENCE THE GT40 BOOTSTRAP GOES INTO ITS SECOND
MODE.   ALL TEXT ON THE SCREEN IS CLEARED.  CHARACTERS INCOMING FROM THE
10 ARE NOT DISPLAYED ON THE SCREEN, BUT ARE ADDED TO  MEMORY.   (THE  10
SENDS THE INFORMATION NECESSARY TO THE BOOTSTRAP, IN ORDER TO KNOW WHERE
TO LOAD THE PROGRAM).  ONCE THE PROGRAM HAS BEEN COMPLETELY LOADED,  THE
GT40  WILL  EITHER  HALT  (IN WHICH CASE THE PROGRAM JUST LOADED MUST BE
MANUALLY STARTED) OR OPTIONALLY THE PROGRAM WILL SELF-START.  (THIS  CAN
BE ACCOMPLISHED BY SPECIFYING A TRANSFER ADDRESS WITHIN THE PROGRAM).
USING GIDUS                                                     Page 3-2


     TWO PROGRAMS HAVE BEEN WRITTEN TO  ACCOMPLISH  THE  10  SIDE  OF  A
PROGRAM  LOAD  (I.E.   THESE  TWO PROGRAMS WILL PROPERLY ENCODE A PDP 11
BINARY FILE, AND  TRANSMIT  IT  TO  THE  GT40  WHERE  THE  BOOTSTRAP  IS
RUNNING).   THE TWO PROGRAMS ARE "LOADER" AND "LOADR6" BOTH OF WHICH ARE
ACCESSIBLE FROM THE GT40 ACCOUNT.  "LOADR6" IS A FAIR  BIT  SLOWER  THAN
"LOADER"  BUT ALLOWS A LARGER PROGRAM TO BE LOADED IN THE GT40.  IT WILL
NOT BE NECESSARY TO USE "LOADR6" IN ORDER TO LOAD GIDUS.  IF  ANYONE  IS
INTERESTED  IN  USING  "LOADR6"  THE  PROCEDURE  IS  IDENTICAL  TO  THAT
DESCRIBED FOR "LOADER".
USING GIDUS                                                     Page 3-3


3.2  PROGRAM LOAD EXAMPLE:

     THE FOLLOWING EXAMPLE IS A STEP BY STEP PROCEDURE  OF  A  DOWN-LINE
LOAD  FROM  THE  10 TO THE GT40.  IN THIS PARTICULAR EXAMPLE THE PROGRAM
"GIDUS.BIN" IS LOADED.  ANY OTHER PROGRAM MAY BE LOADED BY  SUBSTITUTING
THE  APPROPRIATE  FILENAME.   AT  ACADIA,  PROGRAMS  COMPRISING THE GT40
SOFTWARE PACKAGE ARE IN ACCOUNT [1600,2].  THIS WOULD  BE  DIFFERENT  AT
OTHER INSTALLATIONS.


1)       POWER UP THE GT40
         THIS IS ACCOMPLISHED BY TURNING THE POWER KEY TO ON.  THIS KEY,
HOWEVER,  MUST  NOT BE TURNED TO PANEL LOCK AS THIS WOULD PREVENT ANY OF
THE REMAINING CONSOLE SWITCHES FROM WORKING.


2)       TURN ON THE CRT
         JUST TO  THE  RIGHT  OF  THE  CRT  THERE  IS  A  SWITCH  MARKED
"POWER - OFF - BRIGHTNESS".   THIS  SHOULD  BE TURNED CLOCKWISE UNTIL IT
CLICKS ON AND THEN THE BRIGHTNESS SHOULD BE SET BETWEEN 50 - 70 PERCENT,
JUST TO THE RIGHT OF VERTICAL.


3)       DEPRESS THE SWITCH MARKED "ENABLE/HALT"
         THIS SWITCH SHOULD REMAIN IN THE DOWN POSITION, MEANING THE CPU
IS HALTED.


4)       PLACE THE OCTAL NUMBER 166000 IN THE SWITCH REGISTER
         ON THE LEFT PART OF THE  CONSOLE  THERE  ARE  SIXTEEN  SWITCHES
(NUMBERED  15  - 0).  COLLECTIVELY THESE SIXTEEN SWITCHES ARE CALLED THE
SWITCH REGISTER (SWR) AND ARE USED TO REPRESENT A  BINARY  NUMBER.   THE
LEFTMOST BIT (#15) IS THE MOST SIGNIFICANT AND THE RIGHTMOST BIT (#0) IS
THE LEAST SIGNIFICANT.  EACH OF THE 16 SWITCHES IS A TWO POSITION SWITCH
-  IF  UP  IT  MEANS  THE CORRESSPONDING BIT IS ON (SET = 1), IF DOWN IT
MEANS THE CORRESSPONDING BIT IS OFF (CLEARED  = 0).   THE  OCTAL  NUMBER
166000  IS  1 110 110 000 000 000  IN  BINARY.  WHEN THE SWITCH REGISTER
EQUALS 166000 BITS #15, 14, 13, 11,  AND  10  WOULD  BE  UP,  ALL  OTHER
SWITCHES WOULD BE DOWN.


5)       DEPRESS THE SWITCH MARKED "LOAD ADDRESS"
         THIS LOADS THE CONTENTS OF THE SWITCH REGISTER INTO A TEMPORARY
REGISTER WITHIN THE CPU WHERE THE BOOTSTRAP PROGRAM WILL SUBSEQUENTLY BE
STARTED.  PRESSING THE "LOAD ADDRESS" SWITCH WILL ALSO COPY THE SWR INTO
THE  ADDRESS/DATA  LIGHTS JUST ABOVE THESE SWITCHES, SO THAT THE ADDRESS
SELECTED MAY BE VERIFIED.  IF ONE OF THE LIGHTS IS BURNED  OUT  IT  WILL
NOT  AFFECT  THE  OPERATION  OF THE GT40.  (NOTE THAT THE "LOAD ADDRESS"
SWITCH IS ON A SPRING, AND WILL RETURN TO  THE  NEUTRAL  POSITION  AFTER
BEING DEPRESSED).


6)       RAISE THE HALT SWITCH TO ENABLE POSITION
         THIS ENABLES THE CPU
USING GIDUS                                                     Page 3-4


7)       DEPRESS THE START SWITCH
         IF ALL IS WELL THIS SHOULD START THE BOOTSTRAP PROGRAM  RUNNING
(IN  OTHER WORDS 166000 IS THE FIRST ADDRESS IN READ ONLY MEMORY, OF THE
BOOTSTRAP).  TO VERIFY THAT  THE  BOOTSTRAP  IS  RUNNING  PROPERLY,  TWO
THINGS  MAY  BE  DONE.   FIRST,  THE  ADDRESS/DATA  LIGHTS SHOULD NOW BE
FLICKERING;  SECONDLY, ANY CHARACTERS TYPED ON THE  KEYBOARD  SHOULD  BE
ECHOED  ON  THE SCREEN.  IT MAY BE NECESSARY TO TURN UP THE BRIGHTNESS A
BIT IN ORDER TO READ THEM.  ANOTHER TEST (TO DETERMINE IF THE MONITOR IS
SET  TO  ECHO  CHARACTERS) IS TO TYPE ^T (I.E.  CONTROL T).  THE MONITOR
SHOULD REPLY WITH A ONE LINE TRACE OF THE STATE OF  THE  JOB.   IF  THIS
FAILS REPEAT THE LOAD PROCEDURE FROM STEP (3).  IF YOU ARE FOLLOWING THE
PROCEDURE CORRECTLY, BUT NOT HAVING ANY SUCCESS, IT PROBABLY MEANS THERE
IS  SOMETHING WRONG WITH THE GT40 HARDWARE.  AT THE BACK OF THE KEYBOARD
THERE IS AN "ON/OFF" SWITCH WHICH SHOULD BE IN THE  "ON"  POSITION.   IF
THAT  IS  NOT  THE  PROBLEM,  THEN  CONTACT SOME MEMBER OF THE COMPUTING
CENTRE STAFF AND INFORM THEM OF THE PROBLEM.  (YOU SHOULD ALSO NOTE THAT
IF  THE DECSYSTEM-10 IS DOWN, IT OBVIOUSLY CANNOT ECHO CHARACTERS TO THE
GT40.  THIS IS NOT A PROBLEM WITH THE BOOTSTRAP).


8)       .LOGIN IF NECESSARY
         SINCE THE BOOTSTRAP IS NOW RUNNING, YOU SHOULD  LOGIN  TO  YOUR
ACCOUNT (IF YOU HAVE NOT DONE SO PREVIOUSLY).  IF YOU ARE RUNNING OUT OF
SCREEN SPACE, DEPRESS THE START SWITCH TO CLEAR THE  SCREEN  AND  RESUME
OUTPUT AT THE TOP LEFT HAND CORNER.


9)       .RUN LOADER[1600,2]
         RUN THE PROGRAM  "LOADER"  FROM  THE  GT40  ACCOUNT.   THIS  IS
ACCOMPLISHED  BY  THE MONITOR COMMAND ABOVE.  THE PROGRAM WILL COME BACK
REQUESTING WHICH FILE YOU WANT TO LOAD.  NOTE THAT YOU  SHOULD  USE  THE
MONITOR  ".RUN"  COMMAND  AND  NOT THE ".R" COMMAND WHICH IS USED TO RUN
SYSTEM PROGRAMS.


10)      *GIDUS.BIN[1600,2]$
         WHEN THE PROGRAM PROMPTS WITH THE ASTERISK TYPE IN THE NAME  OF
THE  PROGRAM YOU WANT TO LOAD.  IF YOU ARE LOADING GIDUS IT IS NECESSARY
TO SPECIFY THE GT40 ACCOUNT.   THE  FILENAME  SHOULD  BE  TERMINATED  BY
HITTING  THE  ESCAPE  KEY,  WHICH  WILL ECHO AS A DOLLAR SIGN.  CARRIAGE
RETURN WILL NOT TERMINATE THE FILENAME DIALOG.  FURTHERMORE  YOU  SHOULD
NOT  HIT  CARRIAGE  RETURN  AFTER HITTING ESCAPE OR THE LOAD WILL ALMOST
CERTAINLY FAIL.
USING GIDUS                                                     Page 3-5


     IF YOU HAVE FOLLOWED ALL OF THE STEPS  PROPERLY,  AND  ALL  OF  THE
RELEVANT  FILES  ARE  ACCESSIBLE,  THE  LOAD SHOULD NOW TAKE PLACE.  THE
FIRST THING YOU WILL NOTICE IS THAT THE  SCREEN  GOES  BLANK.   IT  WILL
REMAIN  THAT  WAY  UNTIL  THE  LOAD  IS  COMPLETED.  THE LOADING TIME IS
DIRECTLY PROPORTIONAL TO THE LENGTH OF THE PROGRAM TO BE LOADED, AND  TO
THE  LEVEL OF ACTIVITY WITHIN THE 10.  IN THE CASE OF GIDUS, WHEN THE 10
IS LIGHTLY LOADED, THE LOAD SHOULD TAKE ABOUT 50 - 60 SECONDS.   IF  THE
10  IS  VERY  BUSY  SWAPPING JOBS, THE LOAD COULD TAKE AS LONG AS TWO OR
THREE MINUTES.  (ON A RIDICULOUSLY LOADED SYSTEM THE 10 HAS  BEEN  KNOWN
TO  LEAVE JOBS SWAPPED OUT FOR AS LONG AS FIVE MINUTES OR MORE, HOWEVER,
GIDUS SHOULD RARELY TAKE THAT LONG TO LOAD).  AN  EXTREMELY  LARGE  GT40
PROGRAM  (7 OR 8K AS OPPOSED TO 3K FOR GIDUS) IS GOING TO TAKE THAT MUCH
LONGER AGAIN TO LOAD.  (AN EXAMPLE OF THIS IS THE PROGRAM "FOCAL.BIN").

     IF THE LOAD HAS FAILED THE SCREEN WILL REMAIN  BLANK  (REMEMBER  TO
LEAVE  A  REASONABLE  AMOUNT OF TIME FOR THE LOAD).  IF YOU SUSPECT THAT
THE LOAD HAS FAILED, THEN A VARIETY OF REASONS MIGHT EXPLAIN  WHY.   (1)
HITTING  CARRIAGE  RETURN  AFTER  ESCAPE  OR TYPING ANY OTHER CHARACTERS
DURING THE LOAD.  (2) PERHAPS ONE OF THE BYTES BEING TRANSMITTED TO  THE
GT40  WAS  CORRUPT  (HARDWARE  ERROR) AND COULD NOT BE CORRECTED (BY THE
SOFTWARE).  THE POSSIBILITY OF THIS TYPE OF ERROR IS ALWAYS PRESENT, BUT
FORTUNATELY IT IS A FAIRLY RARE OCCURRENCE AND NORMALLY THE SOFTWARE CAN
DETECT AND CORRECT IT.  IN THE MANY HUNDREDS OF LOADS PERFORMED,  DURING
SOFTWARE  DEVELOPMENT,  A LOAD HAD NEVER FAILED FOR THIS REASON, BUT THE
POSSIBILITY DOES EXIST.  (3) PERHAPS THE PROGRAM BEING  LOADED  WAS  TOO
LARGE  (>8K)  TO  FIT  IN  THE  GT40  MEMORY,  OR  (4) OFTEN THE LOAD IS
SUCCESSFUL, BUT THE USER PROGRAM IS NOT SUCCESSFUL IN CREATING A VISIBLE
DISPLAY.  THIS SHOULD NOT BE A PROBLEM WITH THE GIDUS PROGRAM.

     IN ORDER TO VERIFY WHETHER A LOAD FAILED OF ITS OWN, OR WHETHER THE
PROGRAM  LOADED  WAS BAD TO BEGIN WITH, IT IS NECESSARY TO READ THE FILE
"LOADER.LOG" WHICH WILL  BE  CREATED  IN  THE  USER'S  ACCOUNT  WHENEVER
"LOADER"  IS  RUN.   (USERS  SHOULD  NOT  HAVE INDEPENDENT FILES BY THAT
NAME).  SINCE IT IS NOT EASILY POSSIBLE TO DISPLAY TEXT  ON  THE  SCREEN
DURING  THE LOADING PROCESS, THE LOG FILE IS WRITTEN ON DISK.  THIS FILE
WOULD CONTAIN A SUMMARY OF TRANSMISSIONS MADE TO THE GT40 AS WELL AS ANY
ERROR  MESSAGES  IF  A  BAD LOAD WAS DETECTED.  THE FILE IS CREATED ANEW
EACH TIME A LOAD IS PERFORMED.   IT  WILL  BE  NECESSARY  TO  START  THE
BOOTSTRAP  PROGRAM,  IN ORDER TO GET A TYPE-OUT OF THE FILE.  (IN 99% OF
THE CASES, IF PROCEDURE IS PROPERLY FOLLOWED, GIDUS SHOULD LOAD WITH  NO
PROBLEMS).


                                  NOTE


                    IF  ONE  OF  THE  FIRST  INSTRUCTIONS
               EXECUTED BY THE LOADED PROGRAM IS A RESET,
               THEN THE LOG FILE WILL TERMINATE WITH  THE
               ERROR MESSAGE:

               "?  INVALID REPLY FROM GT40, LOADER HUNG".

               THIS MESSAGE MAY BE IGNORED.


USING GIDUS                                                     Page 3-6


3.3  INTERACTING WITH GIDUS

     AFTER GIDUS HAS BEEN SUCCESSFULLY  LOADED,  SEVERAL  DISPLAY  FILES
SHOULD  BECOME  VISIBLE.   THE  MOST  IMPORTANT  OF  THESE  IS AN 8 LINE
SCROLLED CHARACTER DISPLAY FILE, LOCATED AT THE BOTTOM  OF  THE  SCREEN.
(SCROLLING  MEANS  THAT EACH NEW LINE COMING IN WILL BE DISPLAYED AT THE
BOTTOM OF THE SCREEN,  CAUSING  ALL  PREVIOUS  LINES  TO  SHIFT  UP  ONE
POSITION,  FINALLY  DISAPPEARING FROM THE TOP OF THE DISPLAY FILE).  THE
ADVANTAGE OF SCROLLING IS THAT LINES REMAIN VISIBLE AS LONG AS POSSIBLE.
AND THAT IT IS NOT CONTINUALLY NECESSARY (AS WITH THE BOOTSTRAP) TO TAKE
SOME ACTION TO CLEAR THE DISPLAY FILE IN ORDER TO ALLOW  NEW  CHARACTERS
IN.   THIS  CHARACTER  DISPLAY FILE GIVES THE GIDUS USER A LINK WITH THE
DECSYSTEM-10  AND  ALLOWS  THE  GT40  TO  PERFORM  ALL  NORMAL  TERMINAL
FUNCTIONS.   MORE  SPECIFICALLY  THIS MEANS THAT EACH CHARACTER TYPED ON
THE KEYBOARD (WITH A FEW EXCEPTIONS) WILL BE SENT TO THE  10,  AND  THAT
EACH  CHARACTER RECEIVED BY THE GT40 FROM THE 10 (WITH A FEW EXCEPTIONS)
WILL BE DISPLAYED AS TEXT.  IN FACT, THE FIRST FEW LINES THAT ENTER THIS
DISPLAY  FILE  WILL  BE  THE  "END  OF EXECUTION" MESSAGE PRINTED BY THE
PROGRAM "LOADER".  WHEN THE DOT APPEARS AT THE LOWER LEFT CORNER OF  THE
SCREEN,  IT  MEANS  THE  USER IS NOW IN CONTACT WITH THE MONITOR AND MAY
ISSUE ANY VALID COMMAND, JUST AS HE MIGHT FROM ANY OTHER  TERMINAL.   TO
AID  IN  TYPING, A BLINKING CURSOR IS PROVIDED WHICH INDICATES WHERE THE
NEXT CHARACTER WILL BE PLACED.

     IN ADDITION TO THE CHARACTER DISPLAY FILE, THREE MORE DISPLAY FILES
ARE  INITIALLY VISIBLE (GIDUS HAS A TOTAL OF 10 DISPLAY FILES - EACH ONE
WILL BE DISCUSSED LATER).  THESE ARE THE  MAIN  POINTER,  THE  AUXILIARY
POINTER , AND A ONE LINE STATUS DISPLAY.

     INITIALLY THE ONE LINE STATUS DISPLAY WOULD LOOK AS FOLLOWS:

TI CH FR=11713 DU=12 DD=03 LA=00 MP=(0760,1320) AP=(1303,1320) LD TRACE


     EACH TERM HAS THE FOLLOWING MEANING:



     (TI) THE FIRST TWO CHARACTERS INDICATE THE  STATE  OF  GIDUS.   THE
VARIOUS ABBREVIATIONS AND MEANINGS ARE:


TI   -    TERMINAL INPUT
          ANY  CHARACTERS  TYPED  ON  THE  KEYBOARD  ARE  SENT  TO   THE
          DECSYSTEM-10 (I.E.  THE GT40 IS BEHAVING LIKE A TERMINAL).

GI   -    GIDUS INPUT
          EACH CHARACTER TYPED ON THE KEYBOARD  IS  SENT  TO  THE  GIDUS
          PROGRAM.   THIS  IS USED TO ENTER GIDUS COMMANDS WHICH WILL BE
          DISCUSSED LATER.

RC   -    RECEIVING
          THIS INDICATES THAT THE GIDUS PROGRAM IS RECEIVING  A  COMMAND
          FROM  THE DISLIB PACKAGE, OR IS RECEIVING A BLOCK OF A DISPLAY
          FILE WHICH IS BEING TRANSMITTED TO THE GT40.
USING GIDUS                                                     Page 3-7


TR   -    TRANSMITTING
          THIS MEANS THAT GIDUS IS TRANSMITTING  STATUS  INFORMATION  TO
          DISLIB.   A  STATUS TRANSMISSION IS MADE AFTER EACH COMMAND IS
          RECEIVED FROM THE 10.  IF NOTHING ELSE THE STATUS TRANSMISSION
          WOULD INFORM THE 10 THAT THE LAST COMMAND WAS RECEIVED INTACT,
          AND WAS EXECUTED PROPERLY.  NORMALLY THIS STATUS  TRANSMISSION
          TAKES  PLACE SO QUICKLY THAT "TR" MERELY APPEARS AS A BLINK IN
          THE STATUS DISPLAY.  IF IT APPEARS LONGER THAN  A  MOMENT,  IT
          PROBABLY MEANS THAT GIDUS HAS BEEN CORRUPTED.



     (CH) THE NEXT TWO CHARACTERS IN THE  STATUS  DISPLAY  INDICATE  THE
DESTINATION   OF   CHARCTERS   RECEIVED   FROM   THE  10.   THE  VARIOUS
ABBREVIATIONS AND MEANINGS ARE:


CH   -    CHARACTERS
          ANY CHARACTERS RECEIVED FROM THE 10  ARE  CONSIDERED  TERMINAL
          OUTPUT AND ARE ADDED TO THE CHARACTER DISPLAY FILE.  SCROLLING
          TAKES PLACE WHEN NECESSARY.

CO   -    COMMAND
          ANY CHARACTER RECEIVED FROM THE 10 IS BUFFERED  IN  A  COMMAND
          BUFFER.  WHEN THE ENTIRE COMMAND HAS BEEN RECEIVED, IT WILL BE
          EXECUTED.

AD   -    ADD
          ANY CHARACTER RECEIVED FROM THE 10 IS  ADDED  TO  THE  DISPLAY
          FILE,  CURRENTLY  BEING  BUILT IN THE GT40.  AT ANY TIME THERE
          WOULD BE ONLY ONE DISPLAY FILE UNDER CONSTRUCTION.



               (FR=11713)  THE  NEXT  EIGHT  CHARACTERS  IN  THE  STATUS
          DISPLAY  INDICATE  THE  AMOUNT  OF  FREE CORE REMAINING IN THE
          GT40.  THIS IS EXPRESSED AS  THE  NUMBER  OF  WORDS  REMAINING
          (FORMATTED IN OCTAL).  THE FREE CORE IS USED ENTIRELY FOR USER
          DISPLAY FILES.  IT SHOULD BE POINTED OUT AT  THIS  TIME,  THAT
          ALL  NUMBERS  DISPLAYED  DIRECTLY  BY  GIDUS, ARE FORMATTED IN
          OCTAL, AND THAT ALL  NUMBERS  INPUT  DIRECTLY  TO  GIDUS  (VIA
          COMMANDS)  SHOULD  BE  IN  OCTAL.   BASE  8  HAS ABSOLUTELY NO
          ADVANTAGE FOR THE USER, BUT WAS CHOSEN BECAUSE THE CPU HAS  NO
          MULTIPLY  OR DIVIDE INSTRUCTIONS, MAKING OCTAL FORMATTING MUCH
          EASIER THAN DECIMAL.



               (DU=12) THE NEXT FIVE CHARACTERS INDICATE THE  NUMBER  OF
          DISPLAY  FILES  IN  USE.   INITIALLY  THIS NUMBER IS 12 (OR 10
          DECIMAL) REFLECTING THE 10 GIDUS DISPLAYS.  THE GIDUS  PROGRAM
          CAN  ACCEPT A TOTAL OF 64 DISPLAY FILES, WHICH LEAVES ROOM FOR
          54 USER DISPLAY FILES.
USING GIDUS                                                     Page 3-8


               (DD=03) THE FOLLOWING FIVE CHARACTERS INDICATE THE NUMBER
          OF  DISPLAY  FILES  DISABLED.   ALL DISPLAY FILES IN GIDUS ARE
          CONNECTED IN A LINKED LIST.  IF THE DISPLAY FILE IS ENABLED IT
          IS PROCESSED BY THE DPU AND RESULTS IN A VISIBLE DISPLAY (WITH
          THREE EXCEPTIONS DISCUSSED LATER).  WHEN  A  DISPLAY  FILE  IS
          DISABLED,  IT REMAINS IN MEMORY, BUT THE LINKS TO AND FROM THE
          DISPLAY ARE BROKEN, SO THE  DPU  NEVER  GETS  TO  PROCESS  THE
          DISPLAY.   A  DISABLED  DISPLAY  FILE  IS  NOT  VISIBLE ON THE
          SCREEN.



               (LA=00) THE NEXT FIVE CHARACTERS GIVE THE DISPLAY  NUMBER
          OF  THE  LAST  USER  DISPLAY  ADDED BY THE DISLIB PACKAGE.  IF
          EQUAL TO ZERO IT MEANS NO USER DISPLAYS  ARE  PRESENT  IN  THE
          GT40.



               (MP=(0760,1320)) NEXT ARE THE X AND Y CO-ORDINATES OF THE
          MAIN  POINTER.   THESE  NUMBERS  WILL CHANGE AS THE POINTER IS
          MOVED ABOUT.



               (AP=(1303,1320))  NEXT  ARE  THE  CO-ORDINATES   OF   THE
          AUXILIARY POINTER.



               (LD) THE NEXT TWO CHARACTERS INDICATE THE  STATE  OF  THE
          LIGHT PEN.  THE VARIOUS ABBREVIATIONS AND MEANINGS ARE:


LD   -    LIGHT PEN DISABLED
          THIS MEANS THAT NO LIGHT PEN HITS WILL  BE  PROCESSED  BY  THE
          GIDUS  PROGRAM.  IF A USER WISHES TO GET A HIT, THEN THE LIGHT
          PEN MUST NOT BE IN THIS STATE.

LE   -    LIGHT PEN ENABLED
          THIS MEANS THE LIGHT PEN IS ENABLED, AND  THAT  THE  NEXT  HIT
          WILL BE PROCESSED BY THE PROGRAM.

LW   -    LIGHT PEN WAITING
          THIS MEANS THAT THE LIGHT PEN IS ENABLED, AND THAT  THE  GIDUS
          PROGRAM IS CURRENTLY WAITING FOR A HIT.  THIS WOULD COME ABOUT
          DUE TO A  REQUEST  FROM  DISLIB  FOR  LIGHT  PEN  DATA.   (SEE
          DOCUMENTATION  FOR  DISLIB ROUTINE LPHIT).  AS SOON AS THE HIT
          HAS BEEN RECEIVED AND PROCESSED, THE LIGHT PEN WILL GO TO  THE
          "LE" STATE.


USING GIDUS                                                     Page 3-9


     (TRACE) THE FINAL SIX CHARACTERS OF THE STATUS DISPLAY ARE USED  AS
A  TRACE  DISPLAY.  THE CONTENTS OF ANY VALID WORD ADDRESS MAY BE TRACED
BY THE GIDUS PROGRAM.  THIS INFORMATION IS USED PRIMARILY  IN  DEBUGGING
GIDUS AND IS EXPECTED TO BE OF LITTLE OR NO USE TO THE USER.

     EACH OF THE 10 GIDUS DISPLAY FILES WILL NOW BE DISCUSSED  IN  BRIEF
DETAIL.   PAY  PARTICULAR  ATTENTION TO THE DISPLAY FILE NUMBERS AS THEY
CAN BE USEFUL TO KNOW.  (DISPLAY NUMBERS ARE GIVEN FIRST IN OCTAL,  THEN
DECIMAL).

     [0 - 0] THIS IS THE FIRST DISPLAY FILE.  ITS PRIMARY PURPOSE IS  TO
BE THE HEAD NODE IN THE LINKED LIST OF DISPLAY FILES.  THIS DISPLAY FILE
IS ALWAYS ENABLED, BUT ADDS NOTHING VISIBLE TO THE SCREEN.  THE  DISPLAY
CANNOT BE DISABLED, NOR CAN IT BE DELETED.  AN ATTEMPT TO DO EITHER WILL
RESULT IN AN ERROR MESSAGE.

     [1 - 1] THE NEXT DISPLAY FILE IS THE CHARACTER  DISPLAY  FILE.   AS
WITH THE FIRST DISPLAY, AND ALL OTHER NON-USER DISPLAY FILES, IT MAY NOT
BE DELETED.  HOWEVER THE DISPLAY FILE MAY BE CLEARED  OR  DISABLED.   TO
CLEAR THE DISPLAY FILE, HOLD DOWN THE LOCK KEY AND HIT THE EOS KEY (THIS
IS DONE IN A SIMILAR  WAY  TO  HITTING  A  CONTROL  CHARACTER).   TYPING
LOCK/EOS  WILL  CLEAR THE SCREEN OF ALL CHARACTERS, AND RESET THE CURSOR
TO THE LOWER LEFT HAND CORNER.  (ANOTHER WAY  TO  CLEAR  THE  SCREEN  IS
THROUGH  DISLIB  -  SEE  THE DOCUMENTATION FOR ROUTINE CLEAR).  ONCE THE
DISPLAY HAS BEEN CLEARED, THE NEXT CHARACTER OUTPUT  FROM  THE  10  WILL
ONCE AGAIN ENTER THE CHARACTER DISPLAY FILE.  IN ADDITION, THE CHARACTER
DISPLAY FILE MAY BE DISABLED, WHICH REMOVES IT FROM THE SCREEN ENTIRELY.
IT WILL STILL BE UPDATED AS BEFORE, BUT NO CHANGES WILL BE VISIBLE UNTIL
IT IS RE-ENABLED.  A CLEAR IS PREFERRED TO A  DISABLE,  BECAUSE  ONCE  A
DISABLE  IS DONE, NO OUTPUT IS VISIBLE (INCLUDING SUCH MESSAGES AS "TIME
SHARING WILL CEASE IN  5  MINUTES"  ETC.).   A  DISABLE  COULD  BE  USED
HOWEVER,  IF  A  USER  WERE  TO  INSIST  ON REMOVING THE CURSOR FROM THE
SCREEN, BUT IT IS NOT A RECOMMENDED PRACTICE.

     [2 - 2] THE THIRD DISPLAY FILE IS THE STATUS DISPLAY FILE DISCUSSED
PREVIOUSLY.   THIS MAY BE ENABLED OR DISABLED AT WILL, BUT IT MAY NOT BE
DELETED.

     [3 - 3] THE FOURTH GIDUS DISPLAY  FILE  (NOTE  THAT  THE  FIRST  IS
NUMBERED ZERO) IS THE ERROR MESSAGE DISPLAY FILE.  ANY ERRORS THAT GIDUS
DETECTS WILL BE DISPLAYED HERE AS A BLINKING MESSAGE.  A DESCRIPTION  OF
THE  ERROR  MESSAGES  AND THEIR MEANINGS FOLLOWS THE DISCUSSION OF GIDUS
COMMANDS.  THE DISPLAY FILE IS ALWAYS ENABLED, ALTHOUGH THERE IS NOTHING
VISIBLE  UNLESS AN ERROR HAS OCCURRED.  DISPLAY NUMBER THREE MAY NEITHER
BE DISABLED NOR DELETED, AND AN ATTEMPT TO DO EITHER WILL RESULT  IN  AN
ERROR MESSAGE.  THE DISPLAY MAY BE CLEARED, HOWEVER, BY USE OF THE "OFF"
COMMAND TO BE DISCUSSED SHORTLY.

     [4 - 4] THE MAIN POINTER WHICH IS ENABLED FROM THE  START,  IS  THE
FIFTH  DISPLAY  FILE.   THIS  POINTER  IS  USED  INTERACTIVELY  TO  READ
CO-ORDINATES FROM THE SCREEN.  AT ANY TIME THE DISLIB  PACKAGE  CAN  SET
THE  POINTER  TO  ANY SCREEN CO-ORDINATES, AND SIMILARLY IT CAN READ THE
POSITION AT ANY TIME.  IN ADDITION THE POINTER POSITION CAN  BE  CHANGED
THROUGH  THE  USE OF GIDUS.  ON THE LEFT HAND SIDE OF THE KEYBOARD THERE
ARE FOUR ARROW KEYS, UP, DOWN, LEFT, AND RIGHT.  HITTING  THE  "UP"  KEY
USING GIDUS                                                    Page 3-10


WILL  CAUSE  THE  POINTER  TO MOVE UPWARD, HITTING THE KEY A SECOND TIME
WILL CAUSE IT TO STOP.  LIKEWISE FOR THE OTHER THREE KEYS.  HITTING  ANY
COMBINATION  OF A HORIZONTAL AND VERTICAL KEY WOULD CAUSE THE POINTER TO
MOVE  ALONG  THE  APPROPRAITE  DIAGONAL.   AS  THE  POINTER  MOVES   ITS
CO-ORDINATE  POSITION  IS  CONSTANTLY UPDATED IN THE STATUS DISPLAY.  NO
POINTER MOVEMENT WILL BE ENABLED UNLESS BIT #15 (THE  LEFTMOST  BIT)  OF
THE  SWITCH REGISTER IS ON.  THE MAIN POINTER MAY BE ENABLED OR DISABLED
BUT IT MAY NOT BE DELETED.

     [5 - 5] THE SIXTH DISPLAY FILE, THE  AUXILIARY  POINTER,  FUNCTIONS
IDENTICALLY TO THE MAIN POINTER WITH THE ONE DIFFERENCE THAT BIT #0 (THE
RIGHTMOST) MUST BE ON.  (IF BIT #15 IS ALSO ON, THE MAIN  POINTER  TAKES
PRECEDENCE,  AND  THE  AUXILIARY  POINTER WOULD NOT MOVE).  THE SPEED OF
BOTH POINTERS MAY BE VARIED BY THE SPEED COMMAND (SEE THE DESCRIPTION OF
GIDUS COMMANDS).

     [6 - 6] THE NEXT DISPLAY FILE IS THE MESSAGE DISPLAY FILE WHICH  IS
USED  TO  PROMPT  FOR  OPTION  REQUESTS.  NORMALLY THE USER WOULD NOT BE
CONCERNED WITH THIS DISPLAY FILE, AS IT IS HANDLED AUTOMATICALLY BY  THE
DISLIB  OPTION  ROUTINES.   (IN  PARTICULAR  SEE  THE  DOCUMENTATION FOR
ROUTINE GETOPT).  THIS DISPLAY FILE MAY BE ENABLED OR  DISABLED  BUT  IT
MAY NOT BE DELETED.

     [7 - 7] THE NEXT DISPLAY FILE IS THE GIDUS  COMMAND  DISPLAY  FILE.
IF  A  USER  IS  IN  TERMINAL  INPUT MODE (WHERE CHARACTERS TYPED ON THE
KEYBOARD ARE SENT TO THE MONITOR), TYPING  THE  "HOME"  KEY  WILL  PLACE
GIDUS IN GIDUS INPUT MODE.  AS SOON AS HOME HAS BEEN HIT, DISPLAY NUMBER
SEVEN WILL BECOME ENABLED.   THIS  DISPLAY  CONSISTS  OF  THE  PROMPTING
MESSAGE "GIDUS>>" FOLLOWED BY A TYPE-IN BUFFER.  EACH CHARACTER TYPED IN
ON THE KEYBOARD IS SENT TO THE GIDUS PROGRAM AND IS ECHOED ON  THE  LINE
NEXT  TO  THE  PROMPTING  MESSAGE.   WHEN  CARRIAGE  RETURN IS HIT GIDUS
ASSUMES IT HAS A COMPLETE LINE AND BEGINS PROCESSING THE COMMAND.  IF AT
ANY  TIME WHILE IN GIDUS INPUT MODE, THE HOME KEY IS HIT AGAIN, THEN THE
CURRENT COMMAND IS IGNORED,  AND  THE  PROGRAM  ONCE  AGAIN  REVERTS  TO
TERMINAL  INPUT  MODE,  LEAVING THE COMMAND DISPLAY FILE DISABLED.  THIS
DISPLAY FILE MAY BE ENABLED OR DISABLED IN THE USUAL  WAY,  ALTHOUGH  IT
MAKES  LITTLE  SENSE  TO  DO  SO,  SINCE IT IS AUTOMATICALLY ENABLED AND
DISABLED BY THE HOME KEY.  AS WITH ALL OTHER GIDUS DISPLAY  FILES,  THIS
FILE  MAY  NOT BE DELETED.  (SEE THE FOLLOWING SECTION FOR A DESCRIPTION
OF THE AVAILABLE GIDUS COMMANDS).

     [10 - 8] IN ADDITION TO THE  OPTION  PROMPT  MESSAGE  THERE  IS  AN
OPTION  POINTER  DISPLAY  FILE.   THIS POINTER IS USED TO INDICATE WHICH
OPTION WAS LAST SELECTED AND IS AUTOMATICALLY CONTROLLED BY  THE  OPTION
ROUTINES  WHICH  ARE  A PART OF THE DISLIB PACKAGE.  THIS POINTER MAY BE
ENABLED OR DISABLED IN THE USUAL WAY (NOTE THAT THE  DISPLAY  NUMBER  IS
OCTAL 10).  IN ADDITION THE POINTER MAY BE MOVED ABOUT THE SCREEN IN THE
SAME WAY AS ANY USER DISPLAY FILE - SEE THE DOCUMENTATION FOR THE DISLIB
ROUTINE MOVFIL, THIS DISPLAY MAY NOT BE DELETED.

     [77 - 63] THE LAST GIDUS DISPLAY FILE, IS  THE  TAIL  NODE  IN  THE
LINKED  LIST OF DISPLAY FILES.  AS WITH THE FIRST DISPLAY FILE (#0) THIS
ONE IS INVISIBLE, AND IS ALWAYS ENABLED.   ANY  ATTEMPT  TO  DISABLE  OR
DELETE  THIS  DISPLAY  WILL  RESULT  IN  AN ERROR MESSAGE.  USER DISPLAY
NUMBERS ARE 11 - 76 (OCTAL).
USING GIDUS                                                    Page 3-11


3.4  GIDUS COMMANDS

     GIDUS CONTAINS AN INTERNAL COMMAND INTERPRETER WHICH WILL RECOGNIZE
AND EXECUTE 12 COMMANDS.  IF AN UNRECOGNIZABLE COMMAND IS ENTERED (WHILE
IN GIDUS INPUT MODE), THEN NO ACTION WILL BE TAKEN.  IF A VALID  COMMAND
RESULTS  IN  AN  ERROR,  THEN  AN ERROR MESSAGE WILL APPEAR IN THE ERROR
MESSAGE DISPLAY FILE.  COMMANDS MAY BE ENTERED IN FULL OR ABBREVIATED TO
THE  FIRST  TWO LETTERS.  SOME COMMANDS TAKE ARGUMENTS IN THE FORM OF AN
OCTAL NUMBER;  THESE ARGUMENTS ARE DISCUSSED ALONG WITH THE  APPROPRIATE
COMMANDS.


DISABLE N
          N IS AN OCTAL NUMBER IN THE RANGE 0 - 77.  THIS COMMAND CAUSES
          THE  NUMBERED DISPLAY FILE TO BE DISABLED (I.E.  IT REMAINS IN
          THE GT40 BUT IS NOT VISIBLE ON  THE  SCREEN).   NO  ACTION  IS
          TAKEN  IF  THE  DISPLAY  DOES  NOT EXIST, OR IF THE DISPLAY IS
          ALREADY DISABLED.  POSSIBLE  ERRORS  INCLUDE  ILLEGAL  DISPLAY
          NUMBER,  OR  TRYING  TO DISABLE A DISPLAY FILE WHICH CANNOT BE
          DISABLED.   THREE  OF  THE  GIDUS  DISPLAY  FILES  CANNOT   BE
          DISABLED.   IN  ADDITION USER DISPLAYS MAY BE SET SO THAT THEY
          CANNOT BE DISABLED.

ENABLE N
          N IS AN OCTAL NUMBER IN THE  RANGE  0  TO  77.   THIS  COMMAND
          CAUSES  THE NUMBERED DISPLAY FILE TO BE ENABLED (I.E.  VISIBLE
          ON THE GT40 SCREEN).  NO ACTION IS TAKEN IF THE  DISPLAY  FILE
          IS  ALREADY ENABLED.  POSSIBLE ERRORS INCLUDE TRYING TO ENABLE
          A BAD DISPLAY NUMBER (OUTSIDE THE RANGE 0 - 77), OR TRYING  TO
          ENABLE A NON-EXISTENT DISPLAY.

SPEED N
          N IS AN OCTAL NUMBER IN THE RANGE 0 - 12.  THIS  COMMAND  SETS
          THE  SPEED  WITH  WHICH  THE  POINTERS WILL MOVE, 12 BEING THE
          FASTEST, 0 THE SLOWEST.  AT A SPEED OF 0 THE POINTERS  CAN  BE
          ADJUSTED   WITHIN   1  RASTER  UNIT,  WHICH  ALLOWS  FOR  FINE
          MEASURING.  NO ERRORS ARE POSSIBLE.

EXAMINE ADDRESS
          ADDRESS IS AN EVEN OCTAL NUMBER REPRESENTING SOME LOCATION  IN
          THE  GT40  MEMORY.   THE  CONTENTS  OF  THAT  LOCATION WILL BE
          FORMATTED IN OCTAL, AND  DISPLAYED  JUST  BELOW  THE  COMMAND.
          NORMALLY THIS COMMAND WOULD ONLY BE USED FOR DEBUGGING, AND IS
          EXPECTED TO BE OF LITTLE USE TO THE USER.  THE  ONLY  POSSIBLE
          ERROR  IS  ATTEMPTING TO EXAMINE A WORD IN NON-EXISTENT MEMORY
          (I.E.  AN ODD ADDRESS, OR AN ADDRESS OUTSIDE THE GT40'S MEMORY
          BOUND).
USING GIDUS                                                    Page 3-12


TRACE ADDRESS
          ADDRESS IS AN EVEN OCTAL ADDRESS, AS IN THE  EXAMINE  COMMAND.
          THIS  CAUSES  GIDUS  TO  START  TRACING  THE  CONTENTS  OF THE
          SELECTED  ADDRESS,  WITH  THE  TRACE  VISIBLE  IN  THE  STATUS
          DISPLAY.   TRACING LOCATION ZERO WILL CAUSE THE TRACE TO STOP,
          UNTIL A NEW TRACE ADDRESS IS SELECTED.  AS  WITH  THE  EXAMINE
          COMMAND,  THIS IS PRIMARILY INTENDED FOR DEBUGGING GIDUS.  THE
          ONLY POSSIBLE ERROR IS THE NON-EXISTENT MEMORY  REFERENCE,  AS
          IN THE EXAMINE COMMAND.

MODIFY N
          N IS ANY VALID OCTAL NUMBER REPRESENTING A 16 BIT BINARY WORD.
          N IS STORED IN THE LAST ADDRESS SELECTED BY A TRACE OR EXAMINE
          COMMAND, REPLACING WHATEVER WAS ORIGINALLY THERE.  AGAIN  THIS
          IS A DEBUGGING FEATURE.  USERS MAY USE THE MODIFY COMMAND WITH
          NO RESTRICTIONS, BUT THEY SHOULD EXPECT UNPREDICTABLE  PROGRAM
          BEHAVIOR.

DELETE N
          N IS AN OCTAL NUMBER IN THE RANGE 0 - 77.  THIS COMMAND CAUSES
          THE NUMBERED DISPLAY FILE TO BE DISABLED AND THEN REMOVED FROM
          MEMORY.  THE REST OF MEMORY  TAKEN  UP  BY  DISPLAY  FILES  IS
          COMPACTED,  FREEING  THE  SPACE  ORIGINALLY  TAKEN  UP  BY THE
          SELECTED DISPLAY.  IN ADDITION, THE NUMBER OF THE  DISPLAY  IS
          FREED,  ALLOWING  THAT  NUMBER  TO  BE ASSIGNED TO SOME FUTURE
          DISPLAY.  POSSIBLE ERRORS  INCLUDE  TRYING  TO  DELETE  A  BAD
          DISPLAY  NUMBER  (NOT IN THE RANGE 0 - 77), TRYING TO DELETE A
          NON-EXISTENT DISPLAY, OR TRYING TO DELETE A DISPLAY  WHICH  IS
          WRITE  PROTECTED.  NOTE THAT ALL GIDUS DISPLAY FILES ARE WRITE
          PROTECTED AND THAT USER DISPLAY FILES MAY OPTIONALLY BE  WRITE
          PROTECTED  (SEE  THE  DOCUMENTATION  FOR  THE  DISLIB ROUTINES
          ADFILE AND DSTAT).  A DELETE  TAKES  SLIGHTLY  LONGER  THAN  A
          DISABLE  DUE TO THE TIME TAKEN TO COMPACT MEMORY.  IN ADDITION
          YOU WILL NOTICE ALL DISPLAY FILES  BLINK  MOMENTARILY  WHEN  A
          DISPLAY  IS DELETED.  (THIS IS BECAUSE THE DPU MUST BE STOPPED
          WHILE THE DISPLAY FILES ARE BEING COMPACTED).

OFF (NO ARGUMENT)
          ONCE AN ERROR MESSAGE HAS BEEN DISPLAYED, IT  REMAINS  ON  THE
          SCREEN  UNTIL  A  NEW  ERROR MESSAGE REPLACES IT, OR UNTIL THE
          ERROR MESSAGE IS TURNED OFF WITH THE "OFF" COMMAND.  NO ERRORS
          ARE POSSIBLE.

LE (NO ARGUMENT)
          THIS COMMAND IS USED TO ENABLE THE LIGHT PEN.   IF  THE  LIGHT
          PEN  IS  DISABLED, NO HIT WILL BE PROCESSED.  THIS COMMAND MAY
          CHANGE THE STATUS OF THE LIGHT PEN, AND  THE  CHANGE  WILL  BE
          REFLECTED IN THE STATUS DISPLAY.

LD (NO ARGUMENT)
          THIS COMMAND IS JUST THE OPPOSITE OF THE "LE" COMMAND IN  THAT
          IT  CAUSES  THE LIGHT PEN TO BE DISABLED.  THE CHANGE, IF ANY,
          IN THE STATUS OF THE LIGHT PEN WILL BE REFLECTED IN THE STATUS
          DISPLAY.  AS WITH THE "LE" COMMAND, NO ERRORS ARE POSSIBLE.
USING GIDUS                                                    Page 3-13


RESET N
          THIS COMMAND CAUSES THE  GT40  TO  BE  RESET  TO  ITS  INITIAL
          STATUS.   THIS  MEANS  THE  MAIN  AND  AUXILIARY  POINTERS ARE
          RETURNED TO THEIR INITIAL POSITION, AND  THAT  THE  ORIGINALLY
          ENABLED  DISPLAY  FILES  WOULD  BE ENABLED, AND THE ORIGINALLY
          DISABLED DISPLAY FILES WOULD BE DISABLED.   IN  ADDITION,  ALL
          USER  DISPLAYS,  WHETHER  WRITE  PROTECTED  OR  NOT,  WILL  BE
          DELETED, AND THE LIGHT PEN WILL BE DISABLED.   NO  ERRORS  ARE
          POSSIBLE.   N IS AN OCTAL NUMBER IN THE RANGE (1 - 37) (1 - 31
          DECIMAL) WHICH SPECIFIES HOW MANY LINES OF SCROLLING TO SET UP
          IN THE CHARACTER DISPLAY FILE.  IF NO ARGUMENT IS SUPPLIED THE
          CHARACTER DISPLAY FILE IS LEFT AT ITS  CURRENT  SIZE,  BUT  IS
          CLEARED.   IF  MANY  LINES  ARE USED FOR SCROLLING, THEN THERE
          WILL CONSEQUENTLY BE LESS GT40 CORE FOR  USER  DISPLAY  FILES.
          AT  THE  DEFAULT  SETTING  OF  8  LINES THERE IS 4.9K FREE FOR
          DISPLAY FILES.  AT A SETTING OF 1 LINE  THERE  WOULD  BE  5.2K
          AVAILABLE, AND AT A SETTING OF 31 LINES THERE WOULD BE 4.3K.

HELP (NO ARGUMENT)
          THIS COMMAND GIVES A BRIEF  LISTING  OF  THE  AVAILABLE  GIDUS
          COMMANDS.


SIX OF THE GIDUS COMMANDS HAVE DISLIB COUNTERPARTS, WHICH WILL  FUNCTION
UNDER  PROGRAM  CONTROL.  THESE ARE DISABLE, ENABLE, DELETE, LE, LD, AND
RESET (SEE THE CORRESPONDING DOCUMENTATION FOR DISLIB  ROUTINES  DISABL,
ENABLE, DELETE, LPON, LPOFF, AND RESET.

     DO NOT FORGET THAT IT IS NECESSARY TO HIT THE HOME KEY IN ORDER  TO
RETURN TO TERMINAL INPUT MODE.


                                  NOTE


                    THE ARROW KEYS  (FOR  POINTERS),  AND
               THE "LOCK/EOS" KEY WILL NOT FUNCTION WHILE
               IN GIDUS INPUT MODE.



     IF WHEN TYPING A COMMAND YOU REALIZE YOU HAVE MADE A  MISTAKE,  HIT
THE  RUBOUT  KEY  TO DELETE EACH PREVIOUS CHARACTER (THEY WILL DISAPPEAR
FROM THE SCREEN AS THEY ARE RUBBED OUT).

     NORMALLY GIDUS COMMANDS NEED RARELY BE USED  SINCE  MOST  FUNCTIONS
CAN  BE PERFORMED UNDER PROGRAM CONTROL (VIA DISLIB), BUT THE ADDITIONAL
FLEXIBILITY IS  OFTEN  USEFUL;   PARTICULARLY  THE  ENABLE  AND  DISABLE
COMMANDS.
USING GIDUS                                                    Page 3-14


3.5  GIDUS ERROR MESSAGES

     THERE ARE SIX POSSIBLE ERRORS THAT GIDUS CAN DETECT AND INFORM  THE
USER  ABOUT.   THESE  ERRORS  ARE  DISPLAYED  IN THE ERROR DISPLAY FILE,
LOCATED JUST BELOW THE STATUS DISPLAY, AS A  BLINKING  MESSAGE.   ERRORS
MIGHT  OCCUR  DUE  TO BAD GIDUS COMMANDS OR POSSIBLY DUE TO BAD COMMANDS
TRANSMITTED BY DISLIB.  (IN THE SECOND CASE THE USER WOULD  BE  INFORMED
OF  THE  ERROR  TWICE.   ONCE  IN  THE  ERROR  MESSAGE DISPLAY FILE, AND
SECONDLY BY THE OFFENDING DISLIB ROUTINE WHICH REPORTS THE ERROR IN  THE
TEXT FILE).  ERROR MESSAGES WHICH ARE PRECEDED BY A PERCENT SIGN (%) ARE
CONSIDERED WARNING MESSAGES, WHILE THOSE PRECEDED BY A QUESTION MARK (?)
ARE  CONSIDERED  FATAL ERRORS.  IN THE EVENT OF A WARNING MESSAGE, GIDUS
WOULD CONTINUE WITH NO ACTION TAKEN.  SEE THE  DESCRIPTION  OF  THE  TWO
FATAL ERRORS FOR GIDUS OPERATION AFTER THE ERROR.



3.5.1  WARNINGS:

     %BAD DISPLAY NUMBER
     A REFERENCE HAS BEEN MADE TO A DISPLAY  NUMBER,  LESS  THAN  0,  OR
GREATER  THAN  77.   THIS  COULD  BE  FROM AN ENABLE, DISABLE, OR DELETE
COMMAND, OR POSSIBLY SEVERAL DISLIB ROUTINES.


%CANNOT DISABLE A NO-DISABLE DISPLAY FILE
     AN ATTEMPT HAS BEEN MADE TO DISABLE A DISPLAY FILE WHICH CANNOT  BE
DISABLED.   THIS  MAY BE ONE OF THE THREE SPECIAL GIDUS DISPLAYS, OR ANY
USER DISPLAY WHICH HAS BEEN PROTECTED IN THIS MANNER.  THIS ERROR  COULD
ONLY  OCCUR  IN  RESPONSE  TO A DISABLE COMMAND, IN GIDUS INPUT MODE, OR
RECEIVED FROM DISLIB.


%CANNOT DELETE A WRITE PROTECTED DISPLAY FILE
     AN ATTEMPT WAS MADE TO  DELETE  A  DISPLAY  FILE  WHICH  CANNOT  BE
DELETED.   THIS  MIGHT BE ANY OF THE GIDUS DISPLAYS, OR ANY USER DISPLAY
WHICH HAS BEEN PROTECTED IN THIS MANNER.  THIS ERROR COULD ONLY OCCUR IN
RESPONSE TO A DELETE COMMAND, FROM DISLIB, OR WHILE IN GIDUS INPUT MODE.


%DISPLAY DOES NOT EXIST
     AN ATTEMPT WAS MADE TO PERFORM SOME OPERATIONS ON A  DISPLAY  (SUCH
AS ENABLING IT, OR MOVING IT) WHEN THE DISPLAY DOES NOT EXIST.  IN OTHER
WORDS, THE DISPLAY NUMBER IS  VALID,  BUT  NO  DISPLAY  BY  THAT  NUMBER
EXISTS.   THIS  ERROR  COULD  OCCUR  DUE  TO  A GIDUS ENABLE COMMAND, OR
THROUGH ANY ONE OF SEVERAL COMMANDS RECEVIVED FROM DISLIB.
USING GIDUS                                                    Page 3-15


3.5.2  FATAL ERRORS:

?DISPLAY FILE NOT FOUND (DISPLAY TABLE CORRUPT)
     THIS ERROR SHOULD NOT OCCUR.  GIDUS HAS ALREADY DETERMINED THAT THE
DISPLAY  DOES  EXIST  AND IS SEARCHING FOR IT, WITHIN THE LINKED LIST OF
DISPLAY FILES (ACTUALLY THE SEARCH TAKES PLACE ON A  TABLE  REPRESENTING
THE LIST).  IF THIS ERROR OCCURS IT MEANS GIDUS HAS BECOME CORRUPTED AND
THAT THE PROGRAM  SHOULD  BE  RE-LOADED.   IF  THE  ERROR  OCCURS  UNDER
REPRODUCIBLE  CIRCUMSTANCES  IT  INDICATES  A  SERIOUS  BUG IN THE GIDUS
PROGRAM.  (THIS ERROR HAS NEVER OCCURRED DURING SOFTWARE DEVELOPMENT AND
TESTING).   IF  RELOADING  SEEMS  LIKE  A CUMBERSOME COURSE OF ACTION, A
RESET MAY BE ATTEMPTED, BUT A RE-LOAD WOULD BE SAFER COURSE OF ACTION.


?ODD ADDRESS REFERENCE?
     THIS ERROR IS MOST LIKELY  DUE  TO  AN  IMPROPER  ARGUMENT  IN  THE
EXAMINE,   OR   TRACE   COMMAND.    IF  THE  ERROR  OCCURS  UNDER  OTHER
CIRCUMSTANCES, IT INDICATES GIDUS HAS BECOME CORRUPTED.  WHEN THIS ERROR
OCCURS,  THE  CPU  HAS  BEEN  PROGRAMMED  TO HANG UP ON ONE INSTRUCTION,
RATHER THAN CONTINUING FROM THE INSTRUCTION IN ERROR.   SINCE  GIDUS  IS
ENTIRELY  INTERRUPT  DRIVEN, YOU MAY OFTEN CONTINUE AFTER THIS ERROR HAS
OCCURRED.  IF YOU SUSPECT A CORRUPT PROGRAM HOWEVER, IT WOULD BE A  WISE
IDEA TO RE-LOAD GIDUS.
USING GIDUS                                                    Page 3-16


3.6  RESTARTING GIDUS

     OCASSIONALLY IT MAY BE USEFUL TO HALT THE CPU,  AND  TURN  OFF  THE
GT40  POWER.   IT IS POSSIBLE TO RESTART GIDUS AFTER THIS HAS BEEN DONE,
THE RE-START ADDRESS BEING  1136  (OCTAL).   HERE  IS  A  STEP  BY  STEP
PROCEDURE FOR RE-STARTING THE PROGRAM:


1) POWER UP THE GT40

2) TURN ON THE CRT

3) DEPRESS THE HALT SWITCH (IF NOT ALREADY DONE)

4) SWITCH REGISTER GETS 1136 OCTAL
     THE NUMBER 1136 HAS BITS #9, 6, 4, 3, 2,  AND  1  SET,  ALL  OTHERS
EQUAL TO ZERO.

5) DEPRESS THE LOAD ADDRESS SWITCH

6) RAISE THE HALT SWITCH TO THE ENABLE POSITION

7) DEPRESS THE START SWITCH


     THIS SHOULD RE-START GIDUS IF IT IS  STILL  PRESENT  IN  THE  GT40.
NOTE  THAT  IT  TAKES  A  FEW  SECONDS FOR THE SCREEN TO BRIGHTEN BEFORE
DISPLAYS ARE VISIBLE).  IF THIS FAILS TO RE-START GIDUS,  IT  MEANS  THE
PROGRAM IS NO LONGER PRESENT IN THE GT40.














                               CHAPTER 4

                              USING DISLIB



DISLIB OVERVIEW:



     DISLIB (OR DISPLAY LIBRARY) IS A LIBRARY REL  FILE,  CONTAINING  61
SUBPROGRAMS IN 57 MODULES.  TWENTY-TWO OF THESE ROUTINES ARE INTERNAL TO
DISLIB BUT SEVERAL OF  THESE  COULD  BE  CALLED  DIRECTLY  FROM  A  USER
PROGRAM.

     A VERY SOPHISTICATED USER PROGRAM MIGHT UTILIZE 30 OR MORE  OF  THE
DISLIB  ROUTINES,  PARTICULARLY  IF  THE  PROGRAM WAS HIGHLY INTERACTIVE
(MAKING  USE  OF  THE  POINTERS,  THE  LIGHT  PEN,  AND  OPTION  LISTS).
GENERALLY  THOUGH,  A  PROGRAM  COULD ADEQUATELY GET BY WITH 20 OR FEWER
ROUTINES CALLED.

     NONE OF THE DISLIB ROUTINES ALLOWS A VARIABLE NUMBER OF PARAMETERS.
IN  OTHER WORDS, IF A ROUTINE IS EXPECTING PARAMETERS, IT IS EXPECTING A
FIXED NUMBER.   IF  A  ROUTINE  IS  CALLED  WITH  THE  WRONG  NUMBER  OF
PARAMETERS,  UNPREDICTABLE  RESULTS  WILL OCCUR, ALTHOUGH OFTEN THE USER
PROGRAM WOULD TERMINATE WITH SOME SORT OF SYSTEM ERROR  (E.G.   ?ILLEGAL
UUO).
USING DISLIB                                                    Page 4-2


     THE DISLIB PACKAGE CAN BE DIVIDED INTO DISTINCT CATEGORIES.   THESE
ARE:

     1.  INITIALIZATION

     2.  DISPLAY CREATION

     3.  DISPLAY MANIPULATION

     4.  POINTER

     5.  LIGHT PEN

     6.  GT40 MANIPULATION

     7.  LOG

     8.  OPTIONS

     9.  TERMINATION

    10.  INTERNAL


     EACH OF THESE CATEGORIES WILL NOW BE  DISCUSSED,  WITH  A  DETAILED
DESCRIPTION OF EACH ROUTINE WITHIN THE CATEGORY.


                                  NOTE


                    IN THE FOLLOWING  DISCUSSION,  UNLESS
               OTHERWISE INDICATED, ASSUME VARIABLE NAMES
               AND FUNCTIONS ARE OF THE FOLLOWING TYPE:

               IMPLICIT INTEGER (A - W, Z)
               IMPLICIT REAL (X - Y)


USING DISLIB                                                    Page 4-3


4.1  INITIALIZATION ROUTINES (CATEGORY I)

     THERE IS ONLY ONE ROUTINE IN THIS CATEGORY, SUBROUTINE START.



4.1.1  SUBROUTINE START

PROGRAM MODULE:  START.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO INITIALIZE  VARIABLES  WHICH  ARE
          INTERNAL  TO  DISLIB.   THESE  VARIABLES ARE STORED IN LABELED
          COMMON BLOCKS, AND ARE ACCESSIBLE TO ALL OF THE OTHER  FORTRAN
          MODULES.   A  CALL  TO  THIS  SUBROUTINE  SHOULD  BE THE FIRST
          EXECUTABLE STATEMENT IN A USER  PROGRAM,  AND  THE  SUBROUTINE
          SHOULD  NOT BE CALLED A SECOND TIME.  SEVERAL OF THE VARIABLES
          INITIALIZED  REPRESENT  DEFAULT  VALUES  THAT   MIGHT   AFFECT
          SUBSEQUENT DISPLAYS.  THESE ARE:

               SCALING (THE GT40 SCREEN IS SCALED TO PHYSICAL UNITS.  IN
          OTHER  WORDS,  THE  LOWER LEFT HAND CORNER IS (0., 0.) AND THE
          UPPER RIGHT HAND CORNER  IS  (1023.,  767.).   FOR  A  FURTHER
          DESCRIPTION  OF  SCALING, SEE THE DOCUMENTATION FOR SUBROUTINE
          SCALE).

               INTENSITY (DEFAULT DISPLAY INTENSITY IS  LEVEL  2.   THIS
          MAY SUBSEQUENTLY BE CHANGED VIA A CALL TO SUBROUTINE SETMOD).

               LIGHT PEN (THE DEFAULT ASSUMPTION FOR  DISPLAY  FILES  IS
          THAT  THEY  ARE  NOT  LIGHT  PEN  SENSITIVE.   IN  OTHER WORDS
          TOUCHING A DISPLAY WITH  THE  LIGHT  PEN  WILL  NOT  CAUSE  AN
          INTERRUPT  THAT COULD BE PROCESSED BY THE GIDUS PROGRAM.  THIS
          ASSUMPTION  MAY  SUBSEQUENTLY  BE  CHANGED  VIA  A   CALL   TO
          SUBROUTINE  SETMOD.  A SECOND DEFAULT IS ASSUMED FOR THE LIGHT
          PEN.  IF A DISPLAY IS LIGHT PEN SENSITIVE, AND IS HIT  BY  THE
          LIGHT  PEN, THEN THE POINT OF INTERACTION WILL BE INTENSIFIED.
          THIS ASSUMPTION MAY SUBSEQUENTLY BE  CHANGED  VIA  A  CALL  TO
          SUBROUTINE SETA).

               BLINK (THE DEFAULT VALUE FOR  BLINK  IS  OFF.   THIS  MAY
          SUBSEQUENTLY BE CHANGED VIA A CALL TO SETMOD).

               LINE TYPE (SUBROUTINE START SETS A DEFAULT LINE  TYPE  OF
          SOLID.   THIS  MAY  SUBSEQUENTLY  BE  CHANGED  VIA  A  CALL TO
          SETMOD).

               FONT (INITIALLY FONT IS ASSUMED TO BE NORMAL.   THIS  MAY
          SUBSEQUENTLY BE CHANGED VIA A CALL TO SETA).
USING DISLIB                                                    Page 4-4


               SHIFT (CHARACTERS  DISPLAYED  BY  THE  TEXT  ROUTINE  ARE
          ASSUMED TO BE SHIFTED-IN.  THIS MAY SUBSEQUENTLY BE CHANGED TO
          SHIFTED-OUT BY DISPLAYING SHIFT-OUT CHARACTERS VIA TEXT.   FOR
          A  FURTHER  DESCRIPTION  OF SPECIAL SHIFTED-OUT CHARACTERS SEE
          THE DOCUMENTATION FOR ROUTINE TEXT).

               THE OTHER INITIALIZATIONS PERFORMED BY START, OF INTEREST
          TO THE USER, CONCERN THE LOG FILE (FOR MORE INFORMATION ON THE
          LOG FILE, SEE THE DOCUMENTATION FOR  CATEGORY  VII  ROUTINES).
          START  ASSUMES  THAT LOGGING WILL INITIALLY BE DISABLED.  THIS
          MAY SUBSEQUENTLY BE CHANGED VIA A CALL  TO  SUBROUTINE  LOGON.
          THE  DEFAULT  UNIT  NUMBER FOR THE LOG FILE IS 20.  START ALSO
          INITIALIZES THE TWO ERROR COUNTS (FOR FATAL  AND  WARNING)  TO
          ZERO.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               CLROPT (CATEGORY VIII)


WARNINGS:

               ANY PROGRAM ATTEMPTING TO CREATE  DISPLAYS,  OR  INTERACT
          WITH  GIDUS  MUST  CALL  START PRIOR TO USING ANY OF THE OTHER
          DISLIB ROUTINES.  NO CHECK IS MADE TO INSURE  THAT  START  HAS
          BEEN  CALLED,  SO IT IS THE USER'S RESPONSIBILITY.  PREFERABLY
          START SHOULD BE CALLED AS THE FIRST EXECUTABLE STATEMENT IN  A
          USER'S PROGRAM.

               START SHOULD NEVER BE CALLED MORE THAN  ONCE  IN  A  USER
          PROGRAM (AGAIN NO CHECK IS MADE FOR THIS).  IF START IS CALLED
          MORE THAN ONCE IT MIGHT UPSET SOME DISLIB ROUTINES WHICH  RELY
          ON  THE COMMON BLOCKS NOT BEING DISTURBED.  IF IT IS NECESSARY
          TO  RE-INITIALIZE  DISPLAY  PARAMETERS,  LOG  PARAMETERS,   OR
          SCALING PARAMETERS, ROUTINES EXIST FOR THOSE PURPOSES.


EXAMPLE:

               CALL START
          SHOULD BE FIRST EXECUTABLE STATEMENT.
USING DISLIB                                                    Page 4-5


4.2  DISPLAY CREATION ROUTINES (CATEGORY II)

     DISPLAY FILES CREATED BY DISLIB ARE CONTAINED IN VECTORS.  THE USER
SELECTS  WHICH  VECTOR  IS  TO CONTAIN WHICH DISPLAY FILE, AND IT IS HIS
RESPONSIBILITY TO DIMENSION A VECTOR A REASONABLE SIZE.  (THE BIGGER THE
DISPLAY  FILE,  THE  LARGER  THE VECTOR WOULD HAVE TO BE - E.G.  A SMALL
DISPLAY CONSISTING OF A FEW LINES AND SOME TEXT COULD PROBABLY FIT IN  A
VECTOR  DIMENSIONED  AT  50 OR 100 WORDS.  A DISPLAY FILE WITH MANY LONG
LINES, OR POSSIBLY CURVES (WHICH REQUIRE MANY SHORT LINE SEGMENTS) MIGHT
REQUIRE  A  DISPLAY  FILE  OF  300  OR  400 WORDS.  THE LARGEST POSSIBLE
DISPLAY FILE, ONE COMPLETELY FILLING THE 5K OF FREE  CORE  IN  THE  GT40
WOULD  NEED  A  VECTOR  DIMENSIONED  AT  ABOUT 2500 WORDS).  EACH VECTOR
CONTAINING A DISPLAY FILE, IS PACKED TWO 16  BIT  WORDS  (I.E.   A  GT40
WORD)  PER ELEMENT.  THE FIRST FIVE WORDS OF EACH SUCH VECTOR CONTAIN NO
DISPLAY WORDS, BUT ARE USED TO CONTAIN INFORMATION ABOUT THE DISPLAY.

     A VECTOR REPRESENTING  A  DISPLAY  FILE  SHOULD  NEVER,  UNDER  ANY
CIRCUMSTANCES  BE  MODIFIED BY A USER PROGRAM.  IN OTHER WORDS IT IS NOT
NECESSARY  TO  ZERO  THE  VECTOR,  OR  OTHERWISE  INITIALIZE  IT.    ALL
MODIFICATIONS  TO  THE  VECTOR  WILL  BE  MADE BY THE APPROPRIATE DISLIB
ROUTINES.  READ OPERATIONS ON THE VECTOR (E.G.  K = VEC(J)) MAY BE  DONE
AT  ANY  TIME,  BUT THE INFORMATION SO OBTAINED IS UNLIKELY TO BE OF ANY
USE TO A USER PROGRAM.

     THE VECTOR MUST BE OF TYPE INTEGER.  MANY OF THE  DISPLAY  CREATION
ROUTINES  HAVE  N,  AND FILE AS THEIR FIRST TWO PARAMETERS.  FILE IS THE
VECTOR  DESCRIBED  ABOVE,  WHICH  CONTAINS  THE   DISPLAY   FILE   UNDER
CONSTRUCTION.   WHEN THE DISPLAY HAS BEEN COMPLETELY CREATED, IT IS FILE
THAT GETS TRANSMITTED TO THE GT40.  N IS A POINTER TO THE DISPLAY  FILE.
THIS  IS  AN  INTEGER  VARIABLE (A SCALAR) WHICH MUST BE SUPPLIED BY THE
USER.  N ALWAYS POINTS TO THE NEXT AVAILABLE BYTE WITHIN FILE  THAT  CAN
BE  USED BY A DISPLAY CREATION ROUTINE.  AS WITH FILE, N SHOULD NEVER BE
INITIALIZED OR MODIFIED BY THE USER PROGRAM (ALL MODIFICATIONS ARE  DONE
BY  THE  APPROPRIATE  DISLIB ROUTINES).  N DIVIDED BY 4 (SINCE THERE ARE
FOUR EIGHT BIT BYTES IN A 36 BIT WORD) WILL GIVE THE NUMBER OF  ELEMENTS
USED IN FILE.  THIS INFORMATION CAN BE PRINTED OUT JUST BEFORE A DISPLAY
IS SENT TO THE GT40 (VIA SUBROUTINE ADFILE) IN ORDER TO GET AN  IDEA  OF
THE   APPROPRIATE  DIMENSION  OF  FILE.   (IN  OTHER  WORDS,  YOU  MIGHT
ORIGINALLY DIMENSION FILE AT 700 WORDS AND LATER  LEARN  THAT  ONLY  200
WERE NEEDED).


                                  NOTE


                    WARNING  -  IF  N  OR  FILE  IS  EVER
               MODIFIED     BY    THE    USER    PROGRAM,
               UNPREDICTABLE RESULTS WILL  OCCUR.   IF  A
               DISPLAY  FILE IS CORRUPTED IN THIS MANNER,
               AND THEN TRANSMITTED TO THE GT40, IT MIGHT
               POSSIBLY CAUSE GIDUS TO CRASH.


USING DISLIB                                                    Page 4-6


4.2.1  SUBROUTINE SCALE(XMIN, YMIN, XMAX, YMAX)

PROGRAM MODULE:  SCALE.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO SET THE SCALING  FACTOR  FOR  THE
          GT40.  UNLIKE STANDARD CALCOMP SOFTWARE, WHERE ALL PLOTTING IS
          DONE IN PHYSICAL UNITS (INCHES), DISLIB  CREATES  GRAPHICS  IN
          TERMS  OF  USER  UNITS  (SCALED TO PHYSICAL UNITS INTERNALLY).
          THE  USER  NEVER  NEED  WORRY  ABOUT  THE  PHYSICAL   (RASTER)
          DIMENSIONS OF THE CRT.

               THE FIRST TWO PARAMETERS  SPECIFY  THE  CO-ORDINATES  THE
          USER WOULD LIKE TO ASSIGN TO THE LOWER LEFT HAND CORNER OF THE
          SCREEN (RASTER POSITION (0,  0)).   THE  LAST  TWO  PARAMETERS
          SPECIFY  THE CO-ORDINATES THE USER WOULD LIKE TO ASSIGN TO THE
          UPPER RIGHT HAND CORNER OF THE SCREEN (RASTER POSITION  (1023,
          767)).   ONCE  THESE  TWO POINTS HAVE BEEN DEFINED IN TERMS OF
          USER UNITS, THEN ANY POSITION ON THE SCREEN IS DEFINED.

               INITIALLY START SETS THE SCALE IN THE FOLLOWING MANNER  -
          CALL   SCALE(0., 0., 1023., 767.).    THIS   TYPE  OF  SCALING
          EQUIVALENCES USER  UNITS  AND  PHYSICAL  UNITS.   THE  SCALING
          FACTOR  MAY  BE CHANGED AT ANY TIME, BUT KEEP IN MIND THAT THE
          SCALE APPLIES TO ALL USER DISPLAY FILES  (I.E.   EACH  DISPLAY
          DOES  NOT  HAVE  ITS  OWN SCALING FACTOR).  ANY DISLIB ROUTINE
          THAT RETURNS AN (X, Y) POSITION, RETURNS THE  CO-ORDINATES  IN
          TERMS OF THE CURRENT SCALE.

               IF IT IS NECESSARY TO HAVE THE Y AXIS SCALED THE SAME  AS
          THE  X  AXIS  (I.E.  1 USER UNIT REPRESENTS THE SAME NUMBER OF
          RASTER UNITS ALONG EACH AXIS) THEN REMEMBER THAT ON  THE  CRT,
          WIDTH    TO   LENGTH   IS   RATIO   3:4.    TO   VERIFY   THIS
          (YMAX - YMIN) / (XMAX - XMIN) SHOULD EQUAL  .75.   IT  IS  NOT
          NECESSARY  TO  CONFORM  TO THIS CRITERION, UNLESS YOU WANT THE
          SCALING THE SAME IN BOTH DIRECTIONS.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               NONE
USING DISLIB                                                    Page 4-7


EXAMPLES:

               CALL SCALE(-2.5, -.625, 12.5, 10.625)
          THIS WOULD CENTRE A 10 UNIT SQUARE ON THE SCREEN OF THE  GT40.
          THE ORIGIN (0., 0.) WOULD BE THE LOWER LEFT HAND CORNER OF THE
          SQUARE.  USER POSITION (5., 5.) WOULD BE  THE  CENTRE  OF  THE
          CRT.

               CALL SCALE(-7.33, -5.5, 7.33, 5.5)
          AGAIN THIS WOULD CENTRE A 10 UNIT SQUARE ON THE SCREEN OF  THE
          GT40.   THIS  TIME  THE ORIGIN (0., 0.) WOULD BE THE CENTRE OF
          THE SCREEN, AND THE CENTRE OF THE SQUARE.
USING DISLIB                                                    Page 4-8


4.2.2  SUBROUTINE INIT(N, FILE, MAXDIM, X, Y)

PROGRAM MODULE:  INIT.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO INITIALIZE A DISPLAY  FILE.   ALL
          DISPLAY  FILES  MUST  BE  INIT'ED  PRIOR  TO  USING ANY OF THE
          DISPLAY CREATION ROUTINES WHICH ADD WORDS TO THE DISPLAY  FILE
          (I.E.   MOVE,  VECTOR,  JOIN,  POINT, DOT, OR TEXT).  N IS THE
          DISPLAY POINTER AS DESCRIBED  IN  SECTION  4.2.   FILE  IS  AN
          INTEGER  VECTOR  AS  DESCRIBED  IN  SECTION  4.2.  MAXDIM IS A
          VARIABLE OR CONSTANT WHICH IS  THE  ACTUAL  DIMENSION  OF  THE
          VECTOR.   ALL ROUTINES THAT ADD INFORMATION TO THE VECTOR WILL
          CHECK THAT MAXDIM IS NOT EXCEEDED.   THIS  SUBSCRIPT  CHECKING
          CAN BE DISABLED BY PASSING ZERO AS THE THIRD PARAMETER TO INIT
          (ALTHOUGH THERE IS ABSOLUTELY NO ADVANTAGE IN DOING THIS).   X
          AND  Y  IS  THE POSITION ON THE SCREEN IN USER UNITS WHERE YOU
          WANT THE DISPLAY TO START (REMEMBER TO  CALL  SCALE  PRIOR  TO
          CALLING INIT).

               ONCE A DISPLAY HAS BEEN  TRANSMITTED  TO  THE  GT40  (VIA
          ADFILE) THE VECTOR THAT CONTAINED THE DISPLAY FILE CAN BE USED
          FOR SOME OTHER PURPOSE.  HOWEVER,  IF  YOU  WANT  TO  USE  THE
          VECTOR  TO  BUILD  ANOTHER DISPLAY FILE, THEN YOU MUST RE-INIT
          IT.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               SETGM  (CATEGORY X)
               ADWORD (CATEGORY X)
               SETSTA (CATEGORY X)
               IPHYSX (CATEGORY X)
               IPHYSY (CATEGORY X)


WARNINGS:


               IF A USER ATTEMPTS TO EXTEND A DISPLAY FILE THAT HAS  NOT
          BEEN  INIT'ED, THE PROGRAM WILL STOP WITH AN ERROR MESSAGE.  N
          IS  EXAMINED  TO  DETERMINE  WHETHER  THE  DISPLAY  HAS   BEEN
          INITIALIZED;  NEVER MODIFY N OR FILE.
USING DISLIB                                                    Page 4-9


EXAMPLES:

               CALL INIT(N1, FILE1, 100, 0., 0.)
          THIS INITIALIZES A SMALL DISPLAY FILE (100 WORDS) BY THE  NAME
          OF  FILE1.   N1  IS  THE  POINTER  FOR  THE DISPLAY FILE.  THE
          DISPLAY WILL START AT USER POSITION (0., 0.)

               CALL INIT(IPT, IDISP, 1000, USERX(0), USERY(0))
          THIS INITIALIZES A FAIRLY LARGE DISPLAY  FILE  WITH  THE  NAME
          IDISP,  IPT  IS  THE  DISPLAY FILE POINTER.  THIS DISPLAY WILL
          START AT THE LOWER LEFT HAND  CORNER  OF  THE  SCREEN  (RASTER
          POSITION  (0, 0)).  (SEE CATEGORY X ROUTINES FOR A DESCRIPTION
          OF USERX AND USERY).
USING DISLIB                                                   Page 4-10


4.2.3  SUBROUTINE POINT(N, FILE, X, Y)

PROGRAM MODULE:  POINT.F4


DESCRIPTION:

               THIS ROUTINE ADDS AN ABSOLUTE DISABLED (I.E.   INVISIBLE)
          POINT  TO  THE  SPECIFIED  DISPLAY FILE.  THE POINT IS AT USER
          POSITION (X, Y).  THIS IS ONE METHOD  OF  MOVING  THE  DISPLAY
          BEAM TO A NEW POSITION, WITHOUT DISPLAYING ANY GRAPHICS.  (THE
          PREFERRED METHOD  WOULD  BE  VIA  SUBROUTINE  MOVE,  DISCUSSED
          SHORTLY).   THIS ROUTINE ADDS ABSOLUTE DATA TO A DISPLAY FILE.
          THE DISPLAY MAY STILL BE MOVED BUT ONLY THAT PORTION PRIOR  TO
          THE  ABSOLUTE POINT, WILL CHANGE POSITION.  POINT IS SOMETIMES
          USEFUL TO HAVE IN A DISPLAY FILE.  PARAMETERS N AND  FILE  ARE
          AS DISCUSSED IN SECTION 4.2.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               SETSTA (CATEGORY X)
               ADWORD (CATEGORY X)
               SETGM  (CATEGORY X)
               IPHYSX (CATEGORY X)
               IPHYSY (CATEGORY X)


EXAMPLES:


               CALL POINT(N, FILE, 10., 5.)
          ADDS AN ABSOLUTE POINT AT USER POSITION (10., 5.)  TO  DISPLAY
          FILE.

               CALL POINT(N, FILE, USERX(10), USERY(10))
          ADDS AN ABSOLUTE POINT AT RASTER POSITION (10, 10) TO  DISPLAY
          FILE.
USING DISLIB                                                   Page 4-11


4.2.4  SUBROUTINE VECTOR(N, FILE, X, Y)

PROGRAM MODULE:  VECTOR.F4


DESCRIPTION:

               THIS SUBROUTINE DRAWS A LINE FROM THE CURRENT POSITION OF
          THE  DISPLAY  BEAM  TO  THE USER POSITION (X, Y).  THE LINE IS
          VISIBLE.  THE CHARACTERISTICS OF  THE  LINE  (INTENSITY,  LINE
          TYPE,  BLINK,  AND  LIGHT PEN SENSITIVITY) MAY BE ALTERED BY A
          CALL TO SETMOD (WHICH SHOULD BE DONE PRIOR TO  CALLING  VECTOR
          IN  ORDER  TO HAVE ANY EFFECT).  WHENEVER POSSIBLE, THE VECTOR
          ADDED TO THE DISPLAY FILE WILL BE  A  SHORT  VECTOR.   IF  THE
          DISTANCE  BETWEEN THE DISPLAY BEAM AND THE DESIRED POSITION IS
          TOO GREAT, THEN A LONG VECTOR WILL BE  ADDED  TO  THE  DISPLAY
          FILE.  N AND FILE ARE AS DESCRIBED IN SECTION 4.2.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               ADLINE (CATEGORY X)


EXAMPLES:

               CALL VECTOR(N, FILE, 10., 10.)
               CALL SETMOD(2, .FALSE., .TRUE., 0)
               CALL VECTOR(N, FILE, 0., 10.)
          THIS EXAMPLE WOULD DRAW A VECTOR FROM THE CURRENT POSITION  OF
          THE  DISPLAY  BEAM TO USER (10., 10.).  THEN A BLINKING VECTOR
          WOULD BE ADDED TO POSITION (0., 10.).
USING DISLIB                                                   Page 4-12


     4.2.5  SUBROUTINE MOVE(N, FILE, X, Y)

PROGRAM MODULE:  MOVE.F4


DESCRIPTION:

               THIS ROUTINE IS IDENTICAL TO SUBROUTINE VECTOR  WITH  THE
          EXCEPTION  THAT  THE VECTOR ADDED TO THE DISPLAY FILE, WHETHER
          LONG OR SHORT, IS DISABLED (I.E.   INVISIBLE).   THIS  IS  THE
          PREFERRED  WAY TO MOVE THE DISPLAY BEAM (AS OPPOSED TO POINT),
          BECAUSE THE DATA ADDED TO THE DISPLAY FILE IS RELATIVE.   NOTE
          THAT ALL OF THE PARAMETERS THAT COULD BE MODIFIED BY SETMOD OR
          SETA  ARE  MEANINGLESS  FOR  A  MOVE,  SINCE  THE  VECTOR   IS
          INVISIBLE.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               ADLINE (CATEGORY X)


EXAMPLE:

               CALL MOVE(N, FILE, 10., 15.)
          THIS MOVES THE DISPLAY BEAM TO THE USER POSITION (10., 15.).
USING DISLIB                                                   Page 4-13


     4.2.6  SUBROUTINE JOIN(N, FILE, XST, YST, XEND, YEND)

PROGRAM MODULE:  JOIN.F4


DESCRIPTION:

               THIS  ROUTINE  JOINS  THE  USER  POINTS  (XST, YST)   AND
          (XEND, YEND)   WITH   A   VECTOR.   THIS  ROUTINE  IS  EXACTLY
          EQUIVALENT TO:

               CALL MOVE(N, FILE, XST, YST)
               CALL VECTOR(N, FILE, XEND, YEND)


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               MOVE   (CATEGORY II)
               VECTOR (CATEGORY II)


EXAMPLE:

               CALL JOIN(N, FILE, 0., 10., 10., 10.)
               CALL JOIN(N, FILE, 0., 0., 10., 0.)
          THIS EXAMPLE DRAWS TWO VECTORS, BOTH PARALLEL TO THE X AXIS.
USING DISLIB                                                   Page 4-14


4.2.7  SUBROUTINE DOT(N, FILE, X, Y)

PROGRAM MODULE:  DOT.F4


DESCRIPTION:

               THIS ROUTINE ADDS A VISIBLE DOT  (I.E.   ONE  RASTER  DOT
          ILLUMINATED)   AT  USER  POSITION  (X,  Y).   DOT  INSERTS  AN
          INVISIBLE VECTOR  TO  USER  POSITION  (X,  Y)  FOLLOWED  BY  A
          RELATIVE ENABLED POINT.  NOTE THAT RELATIVE POINTS, UNLIKE THE
          SUBROUTINE POINT, DOES NOT  RESULT  IN  ABSOLUTE  DATA.   THIS
          ROUTINE  ADDS  APPROXIMATELY  SIX WORDS TO A DISPLAY FILE EACH
          TIME IT IS CALLED, SO IT SHOULD BE USED SPARINGLY.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               IPHYSX (CATEGORY X)
               IPHYSY (CATEGORY X)
               USERX  (CATEGORY X)
               USERY  (CATEGORY X)
               MOVE   (CATEGORY II)
               SETGM  (CATEGORY X)
               ADWORD (CATEGORY X)


EXAMPLE:

               CALL DOT(N, FILE, X, 47.35)
          THIS EXAMPLE  ADDS  A  DOT  TO  A  DISPLAY  FILE  AT  POSITION
          (X, 47.35).  POSITION IS EXPRESSED IN USER UNITS (AS ALWAYS).
USING DISLIB                                                   Page 4-15


4.2.8  SUBROUTINE TEXT(N, FILE, STRING, COUNT)

PROGRAM MODULE:  TEXT.F4


DESCRIPTION:

               THIS ROUTINE IS  USED  TO  INSERT  TEXT  AT  THE  CURRENT
          POSITION  OF  THE DISPLAY BEAM.  THE PARAMETERS N AND FILE ARE
          AS DISCUSSED IN SECTION 4.2.  THE THIRD PARAMETER IS A VECTOR,
          CONTAINING  CHARACTERS  PACKED IN A5 FORMAT (5 SEVEN BIT ASCII
          CHARACTERS, LEFT JUSTIFIED  IN  A  36  BIT  WORD).   HOLLERITH
          CONSTANTS  (QUOTED STRINGS) ARE IN THIS FORMAT AND MAY BE USED
          FREELY.  COUNT IS THE NUMBER OF CHARACTERS IN THE STRING.

               TEXT SUPPORTS THE ENTIRE GT40 CHARACTER SET, SO THERE ARE
          A  FEW  SPECIAL  CONSIDERATIONS.   THE HARDWARE OF THE GT40 IS
          CAPABLE OF DISPLAYING ALL  128  ASCII  CODES.   THIS  INCLUDES
          UPPER  AND  LOWER  CASE, MANY SPECIAL SYMBOLS, AND SHIFTED-OUT
          SPECIAL SYMBOLS.  CHARACTERS MAY BE DISPLAYED IN  ONE  OF  TWO
          MODES, SHIFT-IN (OR NORMAL MODE) AND SHIFT-OUT (SPECIAL MODE).
          WHEN  SHIFTED-IN,  ALL  PRINTING  CHARACTERS   ARE   DISPLAYED
          NORMALLY  (PRINTING  CHARACTERS  HAVE OCTAL CODES GREATER THAN
          37).  NON-PRINTING CHARACTERS (OCTAL CODES LESS THAN 40)  HAVE
          NO  EFFECT  ON  THE  DISPLAY, WITH THE EXCEPTION OF BACKSPACE,
          LINE FEED, CARRIAGE RETURN,  AND  SHIFT-OUT  (OCTAL  CODE  16)
          WHICH  CAUSES  CHARACTERS  TO  BE INTERPRETED IN SPECIAL MODE.
          WHEN SHIFTED-OUT, ALL OCTAL CODES GREATER THAN 37 ARE  ILLEGAL
          AND  CAUSE  THE DPU TO STOP AFTER INTERRUPTING THE CPU.  OCTAL
          CODES LESS THAN 40 (WHICH ARE  NON-PRINTING  IN  NORMAL  MODE)
          BECOME SPECIAL SYMBOLS (INCLUDING SOME CHARACTERS OF THE GREEK
          ALPHABET).  WHEN IN SHIFTED-OUT MODE, THE  CHARACTER  SHIFT-IN
          (OCTAL CODE 17) CAUSES THE HARDWARE TO RETURN TO NORMAL MODE.

               WITH THIS IN MIND, TEXT PERFORMS IN THE FOLLOWING MANNER.
          INITIALLY  START  SETS  THE  DEFAULT  OF SHIFTED-IN MODE.  ALL
          NON-PRINTING CHARACTERS (INCLUDING CARRIAGE RETURN, LINE FEED,
          AND  BACKSPACE) ARE REPLACED BY QUESTION MARKS (?'S).  THE ONE
          EXCEPTION TO THIS  SUBSTITUTION  IS  THE  SHIFT-OUT  CHARACTER
          WHICH  IS  INSERTED  INTO THE DISPLAY FILE, AND CAUSES TEXT TO
          ENTER SHIFT-OUT MODE.  IN THIS MODE, ALL CHARACTERS PASSED  TO
          TEXT  ARE  CHECKED.   IF  ONE  OF  THEM  IS SHIFT-IN THEN TEXT
          RETURNS TO NORMAL PROCESSING.  IF  THE  CHARACTERS  ARE  LEGAL
          SHIFTED-OUT  CHARACTERS  THEN  THEY  ARE  ADDED TO THE DISPLAY
          FILE.  IF  THEY  ARE  ILLEGAL  SHIFT-OUT  CHARACTERS,  THEN  A
          SHIFT-IN IS INSERTED INTO THE DISPLAY FILE, AND IS FOLLOWED BY
          THE OFFENDING CHARACTER.
USING DISLIB                                                   Page 4-16


               ALTHOUGH TEXT HAS THE CAPABILITY  OF  HANDLING  THE  FULL
          ASCII CHARACTER SET, THE F40 COMPILER IS NOT QUITE SO FLEXIBLE
          (E.G.  YOU CANNOT HAVE LOWER CASE CHARACTERS  IN  A  HOLLERITH
          STRING  ETC.).  HOWEVER THE VECTOR OF CHARACTERS CAN ALWAYS BE
          SET UP NUMERICALLY.  AN EXAMPLE OF THIS WOULD  BE  ADDING  THE
          OCTAL  CONSTANT  201004020100  TO  AN  ELEMENT  OF A VECTOR TO
          CONVERT FROM UPPER TO LOWER CASE.  THE FONT OF ALL  CHARACTERS
          CAN BE ALTERED BY A CALL TO SUBROUTINE SETA.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               SETSTA (CATEGORY X)
               ADWORD (CATEGORY X)
               SETGM  (CATEGORY X)
               GFIELD (CATEGORY X)
               ADBYTE (CATEGORY X)


EXAMPLE:

               CALL MOVE(N, FILE, 200., 200.)
               CALL SETA(.FALSE., .FALSE.)
               VEC(1) = 'ABCDE'
               CALL TEXT(N, FILE, VEC, 5)
               CALL MOVE(N, FILE, 200., 180.)
               VEC(1) = VEC(1) + "201004020100
               CALL SETA(.TRUE., .FALSE.)
               CALL TEXT(N, FILE, VEC, 2)
          THIS DISPLAYS ABCDE AT USER POSITION (200.,  200.)  AND  LOWER
          CASE AB (IN ITALICS) AT USER POSITION (200., 180.)
USING DISLIB                                                   Page 4-17


4.2.9  SUBROUTINE SETMOD(INT, LP, BLINK, LINE)

PROGRAM MODULE:  SETMOD.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO ALTER THE CHARACTERISTICS OF  ALL
          DISPLAY  DATA  THAT FOLLOW UNTIL SETMOD IS CALLED AGAIN.  THIS
          ROUTINE MAY BE CALLED AT ANY TIME.  THE FIRST PARAMETER IS  AN
          INTEGER  VARIABLE OR CONSTANT, WHICH SETS THE INTENSITY OF THE
          DISPLAY (0 IS THE  LOWEST  -  QUITE  DIM,  7  IS  THE  HIGHEST
          INTENSITY  -  VERY BRIGHT).  THE SECOND PARAMETER IS A LOGICAL
          VARIABLE OR CONSTANT.  IF .TRUE.  THEN DISPLAY DATA  FOLLOWING
          IS  LIGHT PEN SENSITIVE (WILL CAUSE AN INTERRUPT IF HIT BY THE
          LIGHT PEN).  IF .FALSE.  THEN THE DISPLAY  DATA  FOLLOWING  IS
          NOT  LIGHT  PEN  SENSITIVE.   THE  THIRD  PARAMETER  IS ALSO A
          LOGICAL VARIABLE OR CONSTANT.  IF .TRUE.  THEN  THE  FOLLOWING
          DISPLAY  DATA  WILL  BLINK.   IF  .FALSE.   THEN THE FOLLOWING
          DISPLAY DATA WILL  NOT  BLINK.   THE  FINAL  PARAMETER  IS  AN
          INTEGER VARIABLE OR CONSTANT WHICH SHOULD BE IN THE RANGE (0 -
          3).  THIS PARAMETER SELECTS THE LINE TYPE (0 IS SOLID LINE,  1
          IS  LONG  DASHES, 2 IS SHORT DASHES, AND 3 IS DOT-DASH).  THIS
          PARAMETER ONLY AFFECTS VECTORS.  ONLY THE LOW ORDER THREE BITS
          OF  INTENSITY  ARE  USED, AND SIMILARLY ONLY THE LOW ORDER TWO
          BITS OF LINE ARE USED.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               NONE


WARNING:

               IT IS NOT A GOOD IDEA TO DRAW DISPLAYS WITH A  VERY  HIGH
          INTENSITY  (SAY  GREATER  THAN 4 OR 5) SINCE THIS CAN BURN OUT
          THE PHOSPHOR ON THE SCREEN, PARTICULARLY IF THE DISPLAY  STAYS
          IN THE SAME PLACE FOR A LONG TIME.


EXAMPLE:

               CALL SETMOD(5, .FALSE., .TRUE., 100)
          DISPLAY INTENSITY 5, NOT LIGHT PEN SENSITIVE, BLINK IS ON, AND
          LINE TYPE 0 (SOLID) [LOW ORDER TWO BITS = 00].
USING DISLIB                                                   Page 4-18


     4.2.10  SUBROUTINE SETA(ITAL, LP)

PROGRAM MODULE:  SETA.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO ALTER THE CHARACTERISTICS OF  ALL
          DISPLAY  DATA  THAT  FOLLOW  UNTIL SETA IS CALLED AGAIN.  THIS
          ROUTINE MAY BE  CALLED  AT  ANY  TIME.   BOTH  PARAMETERS  ARE
          LOGICAL  VARIABLES OR CONSTANTS).  THE FIRST PARAMETER IS USED
          TO SET CHARACTER FONT, IF .TRUE.  CHARACTERS WILL BE DISPLAYED
          AS ITALICS, IF .FALSE.  CHARACTERS WILL BE DISPLAYED IN NORMAL
          FONT.  IF THE SECOND PARAMETER IS .TRUE.   IT  INDICATES  THAT
          POINTS OF LIGHT PEN INTERACTION WILL BE INTENSIFIED (OF COURSE
          THAT  IS  ONLY  RELEVANT  TO  DISPLAYS  THAT  ARE  LIGHT   PEN
          SENSITIVE).   IF  THE SECOND PARAMETER IS .FALSE.  THEN POINTS
          OF LIGHT PEN INTERACTION WILL NOT BE INTENSIFIED.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               NONE


EXAMPLE:

               CALL SETA(.TRUE., .FALSE.)
          CHARACTERS WILL BE IN ITALICS AND LIGHT PEN HITS WILL  NOT  BE
          BRIGHTENED.
USING DISLIB                                                   Page 4-19


     4.2.11  SUBROUTINE ADFILE(N, FILE, STATUS, ID)

PROGRAM MODULE:  ADFILE.F4


DESCRIPTION:

               ONCE  A  DISPLAY  FILE  HAS  BEEN  CREATED,  IT  MUST  BE
          TRANSMITTED  TO  THE  GT40  BEFORE  IT  IS  OF  ANY USE.  THIS
          TRANSMISSION IS DONE BY ADFILE.  PARAMETERS N AND FILE ARE  AS
          DISCUSSED  IN  SECTION  4.2.  THE THIRD PARAMETER IS A DISPLAY
          STATUS WORD.  THIS STATUS WORD  HAS  BEARING  ON  WHETHER  THE
          DISPLAY   BEING  TRANSMITTED  WILL  BE  WRITE-PROTECTED  (I.E.
          CANNOT BE DELETED),  WHETHER  IT  WILL  BE  PROTECTED  AGAINST
          DISABLING,  OR  WHETHER  THE  DISPLAY  IS MOVEABLE OR NOT.  IN
          ADDITION THIS STATUS WORD CAN BE SET TO INDICATE  WHETHER  THE
          DISPLAY,  OR ANY PART OF IT IS LIGHT PEN SENSITIVE.  CURRENTLY
          GIDUS MAKES NO USE OF THIS LIGHT PEN STATUS, BUT IT MIGHT IN A
          FUTURE  VERSION.  THIS STATUS WORD CAN BE CREATED BY A CALL TO
          THE  FUNCTION  DSTAT  (SEE  FOLLOWING  ROUTINE).   THE   FINAL
          PARAMETER IN ADFILE MUST BE AN INTEGER VARIABLE.  IF ADFILE IS
          SUCCESSFUL IN TRANSMITTING THE DISPLAY FILE, THEN  GIDUS  WILL
          SELECT  THE  FIRST  AVAILABLE  DISPLAY  NUMBER,  WHICH WILL BE
          RETURNED AS ID.  THIS VARIABLE MAY THEN BE USED IN  SUBSEQUENT
          CALLS TO THE DISPLAY MANIPULATION ROUTINES (CATEGORY III).

               NOTE THAT THE DISPLAY, ONCE TRANSMITTED TO THE  GT40,  IS
          INITIALLY  DISABLED.   TO MAKE THE DISPLAY VISIBLE IT WOULD BE
          NECESSARY TO CALL ENABLE (CATEGORY III) AFTER THE ADFILE.


POSSIBLE ERRORS:

               ALL ERRORS ARE FATAL, AND RETURN ID = 0.  AN  INTELLIGENT
          USER  PROGRAM  WOULD  CHECK ID AFTER DOING AN ADFILE TO INSURE
          THAT THE DISPLAY WAS TRANSMITTED TO THE GT40 PROPERLY.

               ?NOT ENOUGH CORE FOR ADDITION
          THE DISPLAY FILE IS TOO BIG TO FIT IN THE REMAINING FREE  CORE
          IN  THE  GT40.   IF  IT IS NECESSARY TO TRANSMIT THIS DISPLAY,
          THEN SOME PREVIOUS DISPLAYS WOULD HAVE TO  BE  DELETED,  OR  A
          RESET COULD BE DONE.

               ?NO FREE DISPLAY SLOT FOR ADDITION
          THIS MEANS THAT ALL 54 USER DISPLAY FILES ARE IN USE  SO  THIS
          ONE  CANNOT  BE  ADDED.   IT  WOULD  BE  NECESSARY TO DELETE A
          PREVIOUS DISPLAY FILE IN ORDER FOR THIS ONE TO FIT.

               ?INVALID REPLY TO REQUEST TO ADD
          THIS IS A SYSTEM ERROR.  DISLIB HAS SENT A  COMMAND  TO  GIDUS
          REQUESTING  TO  ADD  A  DISPLAY  FILE.   GIDUS  REPLIES WITH A
          MEANINGLESS STATUS TRANSMISSION.
USING DISLIB                                                   Page 4-20


               ?ADD BLOCK FAILS
          AGAIN THIS IS A SYSTEM ERROR.  EACH DISPLAY FILE  IS  SENT  IN
          INDIVIDUAL  BLOCKS  OF  ABOUT  120  BYTES  EACH.  THIS MESSAGE
          INDICATES THAT A BLOCK HAS FAILED, SO THE ENTIRE ADFILE FAILS.
          THIS  ERROR  SHOULD BE PRECEDED BY ANOTHER ERROR MESSAGE (FROM
          ROUTINE SNDBLK - CATEGORY X) GIVING THE REASON WHY  THE  BLOCK
          FAILED.

               ?INVALID RESPONSE TO LAST BLOCK
          THE  LAST  BLOCK  THAT  ADFILE  SENDS  CONTAINS   THE   STATUS
          INFORMATION NEEDED BY GIDUS (I.E.  FROM THE STATUS PARAMETER).
          IF THIS BLOCK CANNOT BE PROPERLY TRANSMITTED THEN  THIS  ERROR
          (A SYSTEM ERROR) WILL OCCUR.


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               SNDBLK (CATEGORY X)


WARNING:

               AT NO TIME WHEN GIDUS AND DISLIB ARE  COMMUNICATING  WITH
          EACH  OTHER  (AND THIS IS ESPECIALLY EVIDENT DURING AN ADFILE)
          SHOULD THE USER  TYPE  ANYTHING  ON  THE  KEYBOARD.   KEYBOARD
          INTERRUPTS  ARE  ALMOST  GUARANTEED  TO  UPSET  TRANSMISSIONS,
          CAUSING CHECKSUM ERRORS OR  WORSE.   IF  IT  IS  NECESSARY  TO
          CTRL/C  OUT OF YOUR PROGRAM, THEN THIS CAN BE DONE, BUT DO NOT
          USE THE KEYBOARD FOR OTHER PURPOSES, UNLESS  GIDUS  IS  IN  TI
          STATE (TERMINAL INPUT).


EXAMPLES:

               CALL ADFILE(J, KD, 0, IK)
          THIS TRANSMITS A DISPLAY FILE KD WITH POINTER J.   THE  STATUS
          WORD  IS  EQUAL  TO  ZERO  INDICATING  NO SPECIAL STATUS.  THE
          DISPLAY NUMBER IS RETURNED IN IK, WHICH WOULD BE USED AS A TAG
          FOR SUBSEQUENT DISPLAY OPERATIONS.

               CALL ADFILE(IPOINT, IDFILE, DSTAT(0, 0, 0, -1), IDNUM(I))
          THIS TRANSMITS THE VECTOR IDFILE, POINTED TO BY  IPOINT.   THE
          STATUS  CALL SETS UP A STATUS WORD INDICATING THAT THE DISPLAY
          CAN BE MOVED.  THE I'TH ELEMENT OF VECTOR IDNUM  WILL  BE  THE
          DISPLAY TAG USED IN THE DISPLAY MANIPULATION ROUTINES.
USING DISLIB                                                   Page 4-21


4.2.12  INTEGER FUNCTION DSTAT(WPROT, NODIS, LPS, REL)

PROGRAM MODULE:  DSTAT.F4


DESCRIPTION:

               THIS FUNCTION IS USED TO RETURN AN  INTEGER  STATUS  WORD
          WHICH  CAN BE USED AS THE THIRD PARAMETER IN A CALL TO ADFILE.
          DSTAT TAKES FOUR PARAMETERS, ALL OF THEM LOGICAL.  IF WPROT IS
          .TRUE.   THEN  THE  DISPLAY  CANNOT  BE  DELETED.  IF NODIS IS
          .TRUE.  THEN THE DISPLAY CANNOT BE DISABLED.  IF LPS IS .TRUE.
          THEN  THE  DISPLAY ALLOWS LIGHT PEN HITS (CURRENTLY GIDUS PAYS
          NO ATTENTION TO THIS PARAMETER).  IF REL IS .TRUE.   THEN  THE
          DISPLAY  IS  CONSIDERED RELOCATABLE AND CAN BE MOVED ABOUT THE
          SCREEN  (VIA  MOVFIL).   REMEMBER  THAT  THIS  IS  AN  INTEGER
          FUNCTION AND SHOULD BE DECLARED INTEGER IN ANY PROGRAM CALLING
          IT.


                                       NOTE


                   IT IS NOT NECESSARY TO SPECIFY .TRUE.  OR .FALSE.
              EXPLICITLY,   WHEN  CALLING  A  ROUTINE  THAT  EXPECTS
              LOGICAL PARAMETERS.  INTEGERS MAY  BE  PASSED  INSTEAD
              WHERE  -1  IS  CONSIDERED  .TRUE.  AND 0 IS CONSIDERED
              .FALSE.




POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               NONE


EXAMPLE:

               J = DSTAT(.TRUE., 0, 0, -1)
          THIS RETURNS A STATUS WORD  WHICH  INDICATES  THE  DISPLAY  IS
          WRITE PROTECTED, IT MAY BE DISABLED, AND IT MAY BE MOVED ABOUT
          THE SCREEN.
USING DISLIB                                                   Page 4-22


4.2.13  SUBROUTINE GETPOS(N, FILE, X, Y)

PROGRAM MODULE:  GETPOS.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO RETURN THE CURRENT USER  POSITION
          OF  THE  DISPLAY BEAM WITHIN THE SPECIFIED DISPLAY FILE.  THIS
          ROUTINE IS ONLY SIGNIFICANT WHILE THE DISPLAY  FILE  IS  UNDER
          CONSTRUCTION.  IT IS NEVER NECESSARY TO CALL GETPOS, BUT IT IS
          SOMETIMES CONVENIENT TO KNOW WHERE YOU  ARE,  PARTICULARLY  IF
          YOU ARE BUILDING SEVERAL DISPLAY FILES AT THE SAME TIME,


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               USERX  (CATEGORY X)
               USERY  (CATEGORY X)


EXAMPLE:

               CALL GETPOS(N, FILE, XST, YST)
               CALL VECTOR(N, FILE, XST + 10., YST)
          EXTEND A VECTOR FROM THE CURRENT POSITION  TO  A  POSITION  10
          USER UNITS TO THE RIGHT.
USING DISLIB                                                   Page 4-23


     4.3  DISPLAY MANIPULATION ROUTINES (CATEGORY III)

     THIS CATEGORY OF ROUTINES IS USED TO MANIPULATE DISPLAY FILES  THAT
ARE RESIDENT IN THE GT40.  A USER DISPLAY FILE MAY BE ENABLED, DISABLED,
DELETED, OR MOVED ABOUT  THE  SCREEN.   REMEMBER  THAT  IN  THE  DISPLAY
CREATION  ROUTINES  THE  FIRST  TWO PARAMETERS (N AND FILE) WERE USED TO
IDENTIFY  A  PARTICULAR  DISPLAY  FILE.   IN  THE  DISPLAY  MANIPULATION
ROUTINES  A  DISPLAY  FILE  IS  IDENTIFIED BY THE DISPLAY TAG OR DISPLAY
NUMBER (I.E.  THE FOURTH PARAMETER RETURNED  BY  ADFILE).   ALL  OF  THE
ROUTINES IN THIS CATEGORY INTERACT WITH GIDUS (AS OPPOSED TO MOST OF THE
DISPLAY CREATION ROUTINES WHICH ARE NOT AWARE  OF  THE  GT40,  WITH  THE
EXCEPTION OF ADFILE).





4.3.1  SUBROUTINE ENABLE(ID)

PROGRAM MODULE:  ENABLE.F4


DESCRIPTION:

               THIS ROUTINE FUNCTIONS IN A SIMILAR MANNER TO  THE  GIDUS
          ENABLE  COMMAND.   THE ONE PARAMETER IS AN INTEGER VARIABLE OR
          CONSTANT IN THE RANGE 0 - 63 (OR 0 - 77 OCTAL).  IF A  DISPLAY
          OF  THAT  NUMBER  EXISTS,  THEN  IT WILL BECOME VISIBLE ON THE
          SCREEN.  REMEMBER THAT IT IS NECESSARY TO DO AN ENABLE AFTER A
          DISPLAY  FILE  HAS  BEEN TRANSMITTED TO GIDUS BY ADFILE, SINCE
          THE DEFAULT IS FOR THE DISPLAY TO BE DISABLED.


POSSIBLE ERRORS:

               %TRYING TO ENABLE A BAD DISPLAY  
          THE PARAMETER PASSED TO ENABLE WAS NOT AN INTEGER IN THE RANGE
          0 - 63.   THE NUMBER YOU ATTEMPTED TO ENABLE IS PRINTED TO THE
          RIGHT OF THE ERROR MESSAGE.

               %TRYING TO ENABLE A NON-EXISTENT DISPLAY
          THE PARAMETER PASSED WAS WITHIN THE LEGAL RANGE  (0 - 63)  BUT
          NO DISPLAY BY THAT NUMBER EXISTS.  THE NUMBER YOU ATTEMPTED TO
          ENABLE IS PRINTED TO THE RIGHT OF THE ERROR MESSAGE.
USING DISLIB                                                   Page 4-24


               ?INVALID RESPONSE TO ENABLE
          THE STATUS TRANSMISSION GIDUS SENT AFTER RECEIVING THE  ENABLE
          COMMAND  WAS  INVALID.   THIS  IS A SYSTEM ERROR THAT COULD BE
          CAUSED BY A CORRUPT GIDUS, OR  BY  A  BAD  TRANSMISSION.   THE
          NUMBER PRINTED TO THE RIGHT OF THE ERROR MESSAGE IS THE STATUS
          WORD RECEIVED FROM GIDUS.   THIS  ERROR  MESSAGE  RETURNS  THE
          PARAMETER   ID   AS   ZERO,   WHICH  HAS  ITS  ADVANTAGES  AND
          DISADVANTAGES.  THIS WOULD ALLOW A  USER  PROGRAM  TO  MONITOR
          WHETHER  THE  ENABLE  WERE SUCCESSFUL OR NOT.  BECAUSE OF THIS
          PARAMETER MODIFICATION, CONSTANTS SHOULD NOT BE PASSED TO THIS
          ROUTINE  UNLESS  THE  USER  IS  CONFIDENT THAT THE THIRD ERROR
          WOULD NOT OCCUR, OR IS WILLING TO SUFFER THE  CONSEQUENCES  IF
          IT DOES.


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL ENABLE(IDISP3)
               CALL ENABLE(IDNUM(J))
               MP = 4
               CALL ENABLE(MP)
          ENABLE DISPLAY NUMBERS IDISP3, IDNUM(J), AND ENABLE  THE  MAIN
          POINTER.
USING DISLIB                                                   Page 4-25


4.3.2  SUBROUTINE DISABL(ID)

PROGRAM MODULE:  DISABL.F4


DESCRIPTION:

               THIS ROUTINE  FUNCTIONS  IN  A  MANNER  VERY  SIMILAR  TO
          ENABLE,  EXCEPT THAT THE SPECIFIED DISPLAY FILE (IF IT EXISTS)
          IS DISABLED, WHICH MEANS IT IS STILL RESIDENT IN THE GT40  BUT
          NO LONGER VISIBLE.


POSSIBLE ERRORS:

               %TRYING TO DISABLE A BAD DISPLAY NUMBER
          (SIMILAR TO ENABLE)

               %TRYING TO DISABLE A NON-EXISTENT DISPLAY NUMBER
          (SIMILAR TO ENABLE)

               ?INVALID RESPONSE TO DISABLE
          (SIMILAR TO ENABLE, RETURNS ID = 0)

               %CANNOT DISABLE THIS DISPLAY
          THE DISPLAY NUMBER SPECIFIED IS  A  NO-DISABLE  DISPLAY  FILE.
          THIS  MIGHT  BE  ONE  OF THE THREE GIDUS DISPLAYS PROTECTED IN
          THIS MANNER, OR POSSIBLY A USER DISPLAY, PROTECTED BY ADFILE.


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL DISABL(ID)
               IST = 2
               CALL DISABL(IST)
          DISABLE DISPLAY NUMBER ID, AND THE GIDUS STATUS DISPLAY.
USING DISLIB                                                   Page 4-26


     4.3.3  SUBROUTINE DELETE(ID)

PROGRAM MODULE:  DELETE.F4


DESCRIPTION:

               THIS ROUTINE DISABLES THE SPECIFIED DISPLAY FILE AND THEN
          REMOVES IT FROM THE MEMORY OF THE GT40, FREEING THAT SPACE AND
          DISPLAY  NUMBER  FOR  SOME  FUTURE  DISPLAY.    THIS   ROUTINE
          FUNCTIONS  IN  A  MANNER  VERY  SIMILAR  TO  THE  GIDUS DELETE
          COMMAND.  WHEN A DISPLAY FILE IS BEING DELETED YOU WILL NOTICE
          ALL  DISPLAY FILES WILL BLINK OFF FOR A VERY SHORT TIME.  THIS
          IS BECAUSE IT IS NECESSARY TO STOP THE  DPU  WHILE  MEMORY  IS
          BEING  COMPACTED.   IF A USER PROGRAM SIMPLY DESIRES TO MAKE A
          DISPLAY FILE INVISIBLE, THEN A DISABL IS PREFERRED TO A DELETE
          BECAUSE IT IS FASTER.

               THE DELETE ROUTINE IS A NICE WAY OF KEEPING CONTINUITY ON
          THE  SCREEN OF THE GT40.  FOR EXAMPLE YOU MIGHT WANT TO MODIFY
          A DISPLAY, RE-TRANSMIT IT TO GIDUS, ENABLE IT, AND THEN DELETE
          THE  OLD  COPY.   THIS  GIVES  A  SMOOTH  FLOWING  INTERACTIVE
          PROGRAM.


POSSIBLE ERRORS:

               %TRYING TO DELETE A BAD DISPLAY NUMBER
          (SIMILAR TO ENABLE)

               %TRYING TO DELETE A NON-EXISTENT DISPLAY
          (SIMILAR TO ENABLE)

               ?INVALID REPLY TO DELETE
          (SIMILAR TO ENABLE, RETURNS ID = 0)

               %TRYING TO DELETE A WRITE-PROTECTED DISPLAY
          THE DISPLAY NUMBER SPECIFIED  IS  A  WRITE  PROTECTED  DISPLAY
          FILE.  THIS MIGHT BE ANY OF THE GIDUS DISPLAYS, OR POSSIBLY, A
          USER DISPLAY PROTECTED BY ADFILE.


ROUTINES CALLED

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL DELETE(ID3)
          DELETE THE DISPLAY FILE WITH DISPLAY NUMBER ID3.
USING DISLIB                                                   Page 4-27


     4.3.4  SUBROUTINE MOVFIL(ID, X, Y)

PROGRAM MODULE:  MOVFIL.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO MOVE THE SPECIFIED  DISPLAY  FILE
          TO  USER  POSITION  (X,  Y).   BEFORE  A DISPLAY CAN BE MOVED,
          ADFILE MUST HAVE TRANSMITTED A STATUS WORD  THAT  ALLOWED  THE
          FILE  TO  BE MOVED ABOUT THE SCREEN (SEE THE DOCUMENTATION FOR
          ROUTINE DSTAT).  THREE OF THE GIDUS DISPLAY FILES MAY BE MOVED
          (THE   MAIN   AND   AUXILIARY   POINTERS  -  SEE  CATEGORY  IV
          DOCUMENTATION), AND THE OPTION POINTER (SEE DOCUMENTATION  FOR
          ROUTINE  GETOPT  -  CATEGORY  VIII).   NOTE  THAT IF MOVFIL IS
          CALLED FOR A USER DISPLAY  FILE  CONTAINING  ABSOLUTE  POINTS,
          ONLY  THAT  PORTION  OF  THE  DISPLAY  FILE PRIOR TO THE FIRST
          ABSOLUTE POINT WILL CHANGE POSITION.


POSSIBLE ERRORS:

               %TRYING TO MOVE A BAD DISPLAY NUMBER
          (SIMILAR TO ENABLE)

               %TRYING TO MOVE A NON-EXISTENT DISPLAY
          (SIMILAR TO ENABLE)

               ?INVALID REPLY TO A MOVE COMMAND
          (SIMILAR TO ENABLE, RETURNS ID = 0)

               %TRYING TO MOVE A NON-RELOCATABLE DISPLAY
          THE DISPLAY FILE SPECIFIED MAY NOT BE MOVED.   THIS  COULD  BE
          MOST  OF  THE  GIDUS  DISPLAYS, OR A USER DISPLAY THAT DID NOT
          CONTAIN THE PROPER STATUS WORD.


ROUTINES CALLED:

               IPHYSX (CATEGORY X)
               IPHYSY (CATEGORY X)
               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL MOVFIL(8, 10., 10.)
               CALL MOVFIL(ID8, X, Y + 5.)
          THIS MOVES THE OPTION POINTER DISPLAY FILE  TO  USER  POSITION
          (10., 10.), AND THE USER DISPLAY ID8 TO POSITION (X, Y + 5.)
USING DISLIB                                                   Page 4-28


     4.4  POINTER ROUTINES (CATEGORY IV)

     THIS CATEGORY OF ROUTINES IS USED TO CONTROL THE TWO POINTERS (MAIN
AND AUXILIARY).  TWO FUNCTIONS ARE PROVIDED - 1) THE ABILITY TO MOVE THE
POINTERS ANYWHERE ON THE SCREEN, AND 2) THE ABILITY TO READ THE  CURRENT
POSITION  OF THE POINTERS.  THE SECOND FUNCTION IS PARTICULARY USEFUL IN
INTERACTIVE PROGRAMMING SINCE THE POSITION OF THE POINTERS CAN BE SET BY
GIDUS VIA THE ARROW KEYS).





4.4.1  SUBROUTINE GETMP(X, Y)

PROGRAM MODULE:  GETMP.F4


DESCRIPTION:

               THIS  SUBROUTINE  IS   USED   TO   RETURN   THE   CURRENT
          CO-ORDINATES  OF  THE  MAIN  POINTER,  IN USER UNITS.  IT WILL
          RETURN THE POSITION OF THE POINTER, REGARDLESS OF  WHETHER  IT
          IS ENABLED OR DISABLED.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               GETPTR (CATEGORY X)


EXAMPLE:

               CALL GETMP(XMP, YMP) RETURNS THE X POSITION AS  XMP,  AND
          THE Y POSITION AS YMP.
USING DISLIB                                                   Page 4-29


4.4.2  SUBROUTINE MOVEMP(X, Y)

PROGRAM MODULE:  MOVEMP.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO MOVE THE  MAIN  POINTER,  WHETHER
          ENABLED OR DISABLED, TO USER POSITION (X, Y).  THIS ROUTINE IS
          EXACTLY EQUIVALENT TO:

               CALL MOVFIL(4, X, Y)


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               MOVFIL (CATEGORY III)


EXAMPLE:

               CALL MOVEMP(X, Y + 5.)
          THIS  EXAMPLE  MOVES  THE  MAIN  POINTER  TO   USER   POSITION
          (X, Y + 5.).
USING DISLIB                                                   Page 4-30


     4.4.3  SUBROUTINE GETAP(X, Y)

PROGRAM MODULE:  GETAP.F4


DESCRIPTION:

               IDENTICAL   TO   SUBROUTINE   GETMP   EXCEPT   THAT   THE
          CO-ORDINATES RETURNED ARE THOSE OF THE AUXILIARY POINTER.







4.4.4  SUBROUTINE MOVEAP(X, Y)

PROGRAM MODULE:  MOVEAP.F4


DESCRIPTION:

               IDENTICAL TO  SUBROUTINE  MOVEMP,  EXCEPT  THE  AUXILIARY
          POINTER IS MOVED INSTEAD OF THE MAIN POINTER.
USING DISLIB                                                   Page 4-31


     4.5  LIGHT PEN ROUTINES (CATEGORY V)

     THIS CATEGORY OF ROUTINES IS USED TO CONTROL THE OPERATION  OF  THE
LIGHT  PEN.   WHEN A LIGHT PEN SENSITIVE DISPLAY IS HIT BY THE LIGHT PEN
GIDUS CAN DETERMINE THE NUMBER OF THE DISPLAY THAT WAS HIT,  AND  THE  X
AND Y CO-ORDINATES OF THE HIT.  THIS INFORMATION CAN THEN BE TRANSMITTED
TO DISLIB, WHERE IT BECOMES A USEFUL AID IN INTERACTIVE PROGRAMMING.





4.5.1  SUBROUTINE LPON

PROGRAM MODULE:  LPON.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO ENABLE THE LIGHT PEN, AND IS VERY
          SIMILAR  TO  THE  GIDUS  COMMAND  LE.  IF THE LIGHT PEN IS NOT
          ENABLED, THEN NO HITS ARE RECOGNIZED BY GIDUS.  WHEN THE LIGHT
          PEN  IS ENABLED, THE CHARACTERS "LE" ARE VISIBLE IN THE STATUS
          DISPLAY.


POSSIBLE ERRORS:

               ?INVALID REPLY TO LPON
          (I.E.  A BAD STATUS TRANSMISSION FROM GIDUS)


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL LPON
          THIS EXAMPLE ENABLES THE LIGHT PEN.
USING DISLIB                                                   Page 4-32


4.5.2  SUBROUTINE LPOFF

PROGRAM MODULE LPOFF.F4


DESCRIPTION:

               THIS ROUTINE IS JUST THE OPPOSITE  OF  LPON  IN  THAT  IT
          DISABLES  THE  LIGHT  PEN.   IT  IS  VERY SIMILAR TO THE GIDUS
          COMMAND LD.  WHEN THE LIGHT PEN  IS  DISABLED  THE  CHARACTERS
          "LD" WILL APPEAR IN THE STATUS DISPLAY.


POSSIBLE ERRORS:

               ?INVALID REPLY TO LPOFF
          (I.E.  A BAD STATUS TRANSMISSION FROM GIDUS)


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL LPOFF
          THIS DISABLES THE LIGHT PEN.
USING DISLIB                                                   Page 4-33


     4.5.3  SUBROUTINE LPHIT(ID, X, Y)

PROGRAM MODULE:  LPHIT.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO RETURN  THE  DISPLAY  NUMBER  AND
          USER POSITION (X, Y) OF THE NEXT LIGHT PEN HIT.  THIS WILL PUT
          GIDUS INTO A  WAIT  STATE  WHICH  WILL  BE  REFLECTED  BY  THE
          CHARACTERS "LW" IN THE STATUS DISPLAY.


POSSIBLE ERRORS:

               %LIGHT PEN NOT ENABLED
          THIS ROUTINE WAS CALLED WHEN THE LIGHT PEN WAS DISABLED SO  NO
          INFORMATION COULD BE RETURNED.  ALL PARAMETERS ARE RETURNED AS
          ZERO.  TO CORRECT THIS ERROR IT WOULD BE NECESSARY TO  PRECEDE
          THE  CALL  TO  LPHIT WITH A CALL TO LPON OR TO ISSUE THE GIDUS
          COMMAND "LE" PRIOR TO CALLING LPHIT.   REMEMBER  THAT  WHEN  A
          RESET IS DONE, THE LIGHT PEN IS DISABLED.

               ?INVALID REPLY TO LPHIT
          (I.E.  A BAD  STATUS  TRANSMISSION  FROM  GIDUS,  RETURNS  ALL
          PARAMETERS AS 0)


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               USERX  (CATEGORY X)
               USERY  (CATEGORY X)
               ERROR  (CATEGORY VII)


WARNING:

               THIS ROUTINE WILL WAIT FOREVER IF IT IS CALLED AND  THERE
          ARE  NO  LIGHT PEN SENSITIVE DISPLAYS ON THE SCREEN.  IN OTHER
          WORDS GIDUS IS WAITING FOR A HIT BUT IT IS NOT POSSIBLE TO GET
          ONE.


EXAMPLE:

               CALL LPHIT(IDISP, X, Y)
               CALL MOVFIL(IDISP, X, Y)
          THIS MOVES THE ORIGIN OF A DISPLAY FILE TO THE POSITION OF THE
          LIGHT PEN HIT ON THE DISPLAY FILE.
USING DISLIB                                                   Page 4-34


     4.5.4  SUBROUTINE LLPHIT(ID, X, Y)

PROGRAM MODULE:  LLPHIT.F4


DESCRIPTION:

               THIS ROUTINE IS ALMOST IDENTICAL TO LPHIT, EXCEPT INSTEAD
          OF  WAITING  FOR  A HIT IT RETURNS INFORMATION ON THE PREVIOUS
          LIGHT PEN HIT.  IF THERE WAS NO PREVIOUS LIGHT PEN  HIT,  THEN
          ALL PARAMETERS ARE RETURNED AS ZERO.
USING DISLIB                                                   Page 4-35


     4.6  GT40 MANIPULATION ROUTINES (CATEGORY VI)

     THIS CATEGORY OF ROUTINES IS USED TO MANIPULATE  DISPLAY  FILES  IN
THE GT40.





4.6.1  SUBROUTINE CLEAR

PROGRAM MODULE:  CLEAR.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO CLEAR THE CHARACTER DISPLAY  FILE
          (THE  8  LINE  SCROLLED  WORKING  AREA  AT  THE  BOTTOM OF THE
          SCREEN).  THE SAME EFFECT  MAY  BE  ACHIEVED  BY  HITTING  THE
          "LOCK/EOS"  KEY ON THE KEYBOARD.  AS MENTIONED BEFORE, A CLEAR
          IS PREFERRED TO A DISABL(1), BECAUSE A  CLEAR  ALLOWS  RESUMED
          OUTPUT  TO  BECOME  VISIBLE.  IT WOULD OFTEN BE USEFUL TO DO A
          CLEAR IN ORDER TO SEE USER DISPLAYS THAT  MIGHT  OTHERWISE  BE
          PARTIALLY OBSCURED BY TEXT.


POSSIBLE ERRORS:

               ?INVALID REPLY TO CLEAR
          (I.E.  A BAD STATUS TRANSMISSION FROM GIDUS)


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL CLEAR
          THIS EXAMPLE CLEARS THE CHARACTER DISPLAY FILE.
USING DISLIB                                                   Page 4-36


4.6.2  SUBROUTINE PHOTO(WAIT)

PROGRAM MODULE:  PHOTO.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO DISABLE ALL GIDUS  DISPLAY  FILES
          (EXCEPT  THE CHARACTER DISPLAY FILE WHICH IS CLEAR'ED) LEAVING
          ONLY USER DISPLAY FILES VISIBLE.  THIS ROUTINE WOULD BE USEFUL
          TO CALL IF YOU WANTED TO TAKE A PHOTOGRAPH OF DISPLAYS CREATED
          BY YOUR PROGRAM.  PHOTO HAS ONE PARAMETER WHICH  SHOULD  BE  A
          LOGICAL  VARIABLE  OR CONSTANT.  IF WAIT IS .TRUE.  THEN PHOTO
          WILL  PAUSE  THE  USER  PROGRAM  AT  MONITOR  LEVEL  (THIS  IS
          INDICATED BY THE APPEARANCE OF A PERIOD AT THE LOWER LEFT HAND
          CORNER OF THE SCREEN).  PAUSING A PROGRAM IN THIS MANNER WOULD
          GIVE  YOU  AS  MUCH  TIME  AS YOU WANTED TO TAKE PICTURES.  TO
          CONTINUE YOU SHOULD ISSUE THE MONITOR COMMAND ".CONTINUE".  IF
          WAIT   IS  .FALSE.   THEN  THE  USER  PROGRAM  WOULD  CONTINUE
          OPERATION IMMEDIATELY AFTER DISABLING THE GIDUS DISPLAY FILES.
          IN  ADDITION,  IF  WAIT  IS  .FALSE., THEN ANY OPTIONS PRESENT
          WOULD REMAIN ON THE SCREEN, WHEREAS IF  WAIT  IS  .TRUE.   THE
          OPTIONS WOULD BE TURNED OFF (DISABLED) FOR THE DURATION OF THE
          PAUSE.


POSSIBLE ERRORS:

               %PHOTO FAILS (BAD DISABLE)
          (I.E.  A BAD TRANSMISSION FROM GIDUS, DURING A DISABL)


ROUTINES CALLED:

               MONRET (CATEGORY X)
               DISABL (CATEGORY III)


EXAMPLE:

               CALL PHOTO(.TRUE.)
          DISABLES ALL GIDUS  DISPLAYS,  CLEARS  THE  CHARACTER  DISPLAY
          FILE,  DISABLES  OPTIONS  (IF  PRESENT), AND PAUSES AT MONITOR
          LEVEL.
USING DISLIB                                                   Page 4-37


4.6.3  SUBROUTINE RESET(LINES)

PROGRAM MODULE:  RESET.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO RESET THE  GT40  TO  ITS  INITIAL
          STATUS  AND  IS  FUNCTIONALLY  EQUIVALENT  TO  A  GIDUS  RESET
          COMMAND.  ALL USER DISPLAY FILES, WHETHER WRITE  PROTECTED  OR
          NOT  ARE DELETED.  BOTH POINTERS ARE RETURNED TO THEIR INITIAL
          POSITION.  THE LIGHT  PEN  IS  DISABLED.   FINALLY  ALL  GIDUS
          DISPLAYS  THAT  WERE ORIGINALLY DISABLED ARE DISABLED, AND ALL
          THAT WERE ORIGINALLY ENABLED, ARE ENABLED.  MOST USER PROGRAMS
          WOULD PROBABLY WANT TO CALL RESET SHORTLY AFTER CALLING START.
          HOWEVER, IF A USER PROGRAM DOES NOT CALL RESET, THEN  IT  WILL
          INHERIT  ANY USER DISPLAY FILES CREATED BY A PREVIOUS PROGRAM.
          NONE OF THE DISLIB PARAMETERS ARE AFFECTED BY  A  RESET.   THE
          INTEGER  PARAMETER  LINES  SPECIFIES  HOW  MANY  LINES OF TEXT
          SHOULD BE RESERVED FOR SCROLLING.  THIS PARAMETER SHOULD BE IN
          THE  RANGE  1  TO  31.  IF MORE THAN 27 LINES OF SCROLLING ARE
          SPECIFIED THEN THE STATUS DISPLAY AND  THE  TWO  POINTERS  ARE
          AUTOMATICALLY  DISABLED.   A  SCROLLING  AREA  OF 1 LINE, ONLY
          REQUIRES 40 WORDS OF GT40 MEMORY, WHEREAS A COMPLETE SCROLLING
          AREA  (31 LINES) WOULD REQUIRE MORE THAN 1K OF STORAGE.  USERS
          SHOULD SELECT A SCROLLING AREA BASED ON THE OTHER  CORE  NEEDS
          OF  THEIR PROGRAMS.  UNLIKE THE GIDUS RESET COMMAND, THE RESET
          SUBROUTINE REQUIRES THE PARAMETER TO BE PRESENT.


POSSIBLE ERRORS:

               ?INVALID REPLY TO RESET
          (I.E.  A BAD STATUS TRANSMISSION FROM GIDUS)


ROUTINES CALLED:

               SEND   (CATEGORY X)
               GET    (CATEGORY X)
               ERROR  (CATEGORY VII)


EXAMPLE:

               CALL RESET(8)
          THIS RESETS THE GT40 TO ITS INITIAL STATUS.
USING DISLIB                                                   Page 4-38


     4.7  LOG ROUTINES (CATEGORY VII)

     INITIALLY THIS CATEGORY OF ROUTINES WAS PRIMARILY USED IN DEBUGGING
DISLIB.   HOWEVER  THEY  HAVE  BEEN LEFT IN THE LIBRARY SINCE THEY MIGHT
FACILITATE USER DEBUGGING.  THE ROUTINE ERROR, IN PARTICULAR,  MIGHT  BE
OF SOME USE TO USER PROGRAMS THAT DO SOME FORM OF ERROR CHECKING.

     WHEN RUNNING A USER PROGRAM WHICH INVOKES DISLIB, IT IS POSSIBLE TO
ENABLE  A  LOG  FILE WHICH IS USED TO RECORD A RUNNING SUMMARY OF DISLIB
TRANSMISSIONS TO GIDUS, AND GIDUS TRANSMISSIONS  TO  DISLIB.   ALSO  ANY
ERROR  THAT  OCCURS  DURING THE OPERATION OF DISLIB WOULD BE RECORDED IN
THIS FILE, IN ADDITION TO BEING DISPLAYED IN THE CHARACTER DISPLAY FILE.
IF  THE PROGRAM FAILS TO OPERATE PROPERLY THIS FILE CAN BE DUMPED ON THE
PRINTER TO ANALYSE WHAT WENT WRONG.





4.7.1  SUBROUTINE LOGON

PROGRAM MODULE:  LOGON.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO ENABLE LOGGING.  THE  FIRST  TIME
          LOGON IS CALLED, THE LOG FILE IS CREATED.  SUBSEQUENT CALLS TO
          LOGON, RE-OPEN THE LOG FILE IN APPEND MODE.  EACH  TIME  LOGON
          IS CALLED, A TIME STAMP IS WRITTEN IN THE LOG.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               SFIELD (CATEGORY X)


EXAMPLE:

               CALL LOGON
          THIS ENABLES LOGGING ON FILE "DSK:DISLIB.LOG" (UNIT=20).
USING DISLIB                                                   Page 4-39


     4.7.2  SUBROUTINE LOGOFF

PROGRAM MODULE:  LOGOFF.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO DISABLE LOGGING, AND TO CLOSE THE
          LOG   FILE.    BY  USING  LOGON,  AND  LOGOFF  SELECTIVELY,  A
          PARTICULAR PORTION OF A PROGRAM MAY BE TRACED.  EACH TIME  THE
          LOG FILE IS DISABLED, A TIME STAMP IS WRITTEN IN THE LOG.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               SFIELD (CATEGORY X)


EXAMPLE:

               CALL LOGOFF
          DISABLE LOGGING, AND CLOSE THE LOG FILE.
USING DISLIB                                                   Page 4-40


     4.7.3  SUBROUTINE ERROR(STRING, ISTAT)

PROGRAM MODULE:  ERROR.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO PRINT AN  ERROR  MESSAGE  ON  THE
          GT40,  AND LOG THE ERROR MESSAGE INTO THE LOG FILE (IF LOGGING
          IS ENABLED).  THE FIRST PARAMETER IS A VECTOR CONTAINING ASCII
          CHARACTERS  IN  A5  FORMAT.   AS  WITH ROUTINE TEXT, HOLLERITH
          CONSTANTS COULD BE PASSED AS THIS  PARAMETER  AND  MOST  OFTEN
          WOULD  BE.   THIS  STRING  SHOULD  CONTAIN  NO  MORE  THAN  60
          CHARACTERS.  ISTAT IS A STATUS WORD  TO  ACCOMPANY  THE  ERROR
          MESSAGE.  IF ISTAT (AN INTEGER) IS NON-ZERO IT WILL BE PRINTED
          TO THE RIGHT OF THE ERROR MESSAGE, IN BOTH DECIMAL AND  OCTAL.
          ALL DISLIB ERRORS ARE REPORTED BY THIS ROUTINE.

               IF THE FIRST CHARACTER OF THE ERROR STRING IS  A  PERCENT
          SIGN  (%)  THEN  THE  ERROR  IS  CONSIDERED A WARNING, AND THE
          WARNING COUNT IS INCREMENTED.  IF THE FIRST CHARACTER  OF  THE
          ERROR  STRING  IS  A  QUESTION  MARK  (?)  THEN  THE  ERROR IS
          CONSIDERED FATAL (THE PROGRAM IS NOT STOPPED)  AND  THE  FATAL
          COUNT  IS INCREMENTED.  IN ADDITION, IF THE FIRST CHARACTER IS
          A QUESTION MARK, THEN THE GT40 BELL  WILL  SOUND  (ACTUALLY  A
          BEEP) AS THE ERROR MESSAGE IS PRINTED.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               SFIELD (CATEGORY X)
               GFIELD (CATEGORY X)
               SNDCHR (CATEGORY X)


EXAMPLES:

               CALL ERROR('A MESSAGE WITH NO STATUS', 0)
               CALL ERROR('%A WARNING WITH NO STATUS', 0)
               CALL ERROR('?FATAL ERROR = ', 8)
USING DISLIB                                                   Page 4-41


     4.8  OPTION ROUTINES (CATEGORY VIII)

     THE NEXT CATEGORY OF ROUTINES ARE USED IN CREATING AND MANIPULATING
AN  OPTION LIST.  AN OPTION LIST (OR MENU AS IT IS SOMETIMES CALLED) CAN
BE A VERY USEFUL AID IN INTERACTIVE PROGRAMMING.  THE OPTION  LISTS,  AS
IMPLEMENTED  IN  DISLIB,  CONSISTS  OF  10 LIGHT PEN SENSITIVE MESSAGES,
WHERE EACH MESSAGE CAN BE A MAXIMUM OF 15 CHARACTERS LONG.  EACH  OPTION
IS  ASSIGNED,  BY  THE  PROGRAMMER, A UNIQUE NUMBER IN THE RANGE 1 - 10.
THE PROGRAM CAN REQUEST AN OPTION AT WHICH TIME ONE OF  THE  10  OPTIONS
SHOULD  BE  TOUCHED  WITH THE LIGHT PEN.  THE PROGRAM CAN THEN DETERMINE
WHICH OPTION HAS BEEN SELECTED AND BRANCH ACCORDINGLY.  FOR  EXAMPLE,  A
PROGRAM MIGHT HAVE THE MESSAGE 'EXIT' AS OPTION 10.  IF THE NUMBER 10 IS
RETURNED WHEN THE PROGRAM REQUESTS AN OPTION  THEN  THE  PROGRAM  SHOULD
STOP.

     OPTIONS ARE ARRANGED VERTICALLY ON  THE  RIGHT  HAND  PART  OF  THE
SCREEN  (NEAR THE LIGHT PEN).  OPTION NUMBER 1 IS AT THE TOP, AND OPTION
10 AT THE BOTTOM.  IF AN OPTION SLOT HAS NOT  BEEN  ASSIGNED  A  MESSAGE
THEN  IT  WILL  CONSIST  OF ALL BLANK CHARACTERS WHICH CANNOT GENERATE A
LIGHT PEN HIT.





4.8.1  SUBROUTINE ADDOPT(OPTNO, OPTSTR, OPCT)

PROGRAM MODULE:  ADDOPT.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO CHANGE AN OPTION (INITIALLY START
          BLANKS  OUT  EACH OF THEM).  THE FIRST PARAMETER IS AN INTEGER
          VARIABLE OR CONSTANT, WHICH SHOULD BE IN THE RANGE (1  -  10).
          THIS  IS  THE  NUMBER  OF  THE OPTION YOU WISH TO CHANGE.  THE
          SECOND PARAMETER IS THE OPTION MESSAGE ITSELF.  THIS SHOULD BE
          A VECTOR, CONTAINING ASCII CHARACTERS PACKED IN A5 FORMAT.  AS
          IN ERROR AND TEXT, HOLLERITH CONSTANTS CAN BE PASSED  AS  THIS
          PARAMETER.   THE  THIRD  PARAMETER  IS  AN INTEGER CONSTANT OR
          VARIABLE IN  THE  RANGE  1  -  15.   THIS  IS  THE  NUMBER  OF
          CHARACTERS IN THE OPTION MESSAGE.  IF ANY OF THE CHARACTERS IN
          THE OPTION MESSAGE ARE NON-PRINTING (OCTAL CODES LESS THAN 40)
          THEN   THEY   WILL   BE  REPLACED  WITH  QUESTION  MARKS  (SEE
          DOCUMENTATION ON ROUTINE TEXT - CATEGORY II).  NOTE THAT  THIS
          ROUTINE SIMPLY MODIFIES THE ARRAY OF MESSAGES THAT IS INTERNAL
          TO DISLIB.  BEFORE ANY OF THE CHANGES ARE VISIBLE, THE OPTIONS
          WOULD HAVE TO BE TRANSMITTED TO THE GT40, VIA SNDOPT.


POSSIBLE ERRORS:

               %INVALID OPTION NUMBER
          THE FIRST PARAMETER WAS NOT AN INTEGER IN THE RANGE  1  -  10.
          THE OFFENDING VALUE IS PRINTED NEXT TO THE ERROR MESSAGE.
USING DISLIB                                                   Page 4-42


ROUTINES CALLED:

               ERROR  (CATEGORY VII)
               GFIELD (CATEGORY X)
               SFIELD (CATEGORY X)


EXAMPLE:

               CALL ADDOPT(1, 'RESET', 5)
               CALL ADDOPT(5, 14, 3)
               CALL ADDOPT(10, 'EXIT', 4)
          THIS EXAMPLE SETS UP OPTIONS 1  AND  10  PROPERLY.   OPTION  5
          WOULD APPEAR ON THE GT40 AS THREE QUESTION MARKS.
USING DISLIB                                                   Page 4-43


     4.8.2  SUBROUTINE SNDOPT(OPID)

PROGRAM MODULE SNDOPT.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO  TAKE  THE  OPTIONS,  CREATED  BY
          ADDOPT, AND TRANSMIT THEM TO THE GT40, VIA ADFILE.  THE OPTION
          LIST IS IMMEDIATELY ENABLED.  THE OPTION LIST WILL REPLACE ANY
          PREVIOUS OPTION LIST THAT WAS RESIDENT IN THE GT40.  NOTE THAT
          THIS ROUTINE REQUIRES TWO DISPLAY SLOTS (FROM THE 54 THAT WERE
          ORIGINALLY AVAILABLE FOR USER DISPLAYS).  ONE SLOT IS USED FOR
          THE OLD OPTION LIST (IF ANY) AND ANOTHER SLOT IS USED FOR  THE
          NEW  OPTION  LIST.  TOGETHER THESE DISPLAY FILES WOULD REQUIRE
          ABOUT 300 WORDS OF GT40 MEMORY.   THE  REASON  FOR  USING  TWO
          DISPLAY  FILES  IS  TO  ALLOW CONTINUITY (I.E.  THE OLD OPTION
          LIST IS NOT DELETED, UNTIL THE NEW  ONE  IS  RESIDENT  IN  THE
          GT40).   THE INTEGER PARAMETER OPID RETURNS THE DISPLAY NUMBER
          OF THE NEWLY CREATED OPTION LIST.  THIS  ALLOWS  THE  USER  TO
          DELETE THE OPTION LIST WHEN IT IS NO LONGER NEEDED.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               DISABL (CATEGORY III)
               MOVFIL (CATEGORY III)
               INIT   (CATEGORY II)
               SETMOD (CATEGORY II)
               SETA   (CATEGORY II)
               POINT  (CATEGORY II)
               TEXT   (CATEGORY II)
               ADFILE (CATEGORY II)
               ENABLE (CATEGORY III)


EXAMPLE:

               CALL SNDOPT(ID)
          THIS TRANSMITS THE CURRENT OPTION LIST TO  THE  GT40,  DELETES
          THE OLD OPTION LIST (IF ANY), AND ENABLES THE NEW, WHICH WOULD
          BE DISPLAY NUMBER ID.
USING DISLIB                                                   Page 4-44


     4.8.3  SUBROUTINE GETOPT(IOP)

PROGRAM MODULE:  GETOPT.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO RETURN THE OPTION NUMBER  OF  THE
          NEXT  OPTION HIT BY THE LIGHT PEN.  THIS NUMBER IS RETURNED IN
          THE INTEGER PARAMETER IOP.  THIS ROUTINE  CALLS  LPHIT  SO  IT
          WILL  WAIT  FOREVER IF THERE ARE NO OPTION LISTS ENABLED.  THE
          FIRST THING THIS ROUTINE DOES IS TO ENABLE THE LIGHT  PEN  (IT
          WILL  BE  LEFT  ENABLED, WHEN THE ROUTINE EXITS).  NEXT GETOPT
          ENABLES DISPLAY NUMBER 6 WHICH IS THE  OPTION  SELECT  MESSAGE
          (SEE  DESCRIPTION  OF  GIDUS  DISPLAY FILES).  THIS MESSAGE IS
          USED TO PROMPT FOR AN OPTION HIT.  NEXT THE ROUTINE WAITS  FOR
          A  HIT  ON THE OPTION LISTS (THIS CAN BE SEEN FROM THE "LW" IN
          THE STATUS  DISPLAY).   WHEN  THE  HIT  INFORMATION  HAS  BEEN
          RECEIVED,  THE  ROUTINE  WILL  DISABLE THE SELECT MESSAGE, AND
          THEN POSITION THE OPTION  POINTER  (DISPLAY  NUMBER  8  OR  10
          OCTAL) NEXT TO THE SELECTED OPTION.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               LPON   (CATEGORY V)
               ENABLE (CATEGORY III)
               LPHIT  (CATEGORY V)
               DISABL (CATEGORY III)
               IPHYSX (CATEGORY X)
               IPHYSY (CATEGORY X)
               USERX  (CATEGORY X)
               USERY  (CATEGORY X)
USING DISLIB                                                   Page 4-45


WARNING:

               IT MAY BE NECESSARY TO  TURN  UP  THE  INTENSITY  OF  THE
          DISPLAYS  IN  ORDER TO GET A LIGHT PEN HIT.  DO NOT LEAVE THIS
          INTENSITY UP TOO LONG  AS  IT  MIGHT  POSSIBLY  BURN  OUT  THE
          SCREEN.


EXAMPLE:

               CALL GETOPT(K)
          K IS IN THE RANGE 1 - 10 (THE LAST OPTION SELECTED).
USING DISLIB                                                   Page 4-46


     4.8.4  SUBROUTINE OPTOFF

PROGRAM MODULE:  OPTOFF.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO DISABLE ALL OPTION DISPLAY  FILES
          (SELECT  MESSAGE,  OPTION  LIST,  AND  OPTION  POINTER).  THIS
          ROUTINE IS PROVIDED AS A CONVENIENCE ONLY.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               DISABL (CATEGORY III)


EXAMPLE:

               CALL OPTOFF
          DISABLES ALL OPTION DISPLAY FILES.
USING DISLIB                                                   Page 4-47


     4.8.5  SUBROUTINE OPTON

PROGRAM MODULE:  OPTON.F4


DESCRIPTION:

               THIS ROUTINE IS JUST THE OPPOSITE OF OPTOFF, AND IT WOULD
          NORMALLY  BE  CALLED  AFTER  OPTOFF.  IT IS USED TO ENABLE THE
          OPTION POINTER AND OPTION LIST.  THE OPTION SELECT MESSAGE  IS
          LEFT DISABLED UNTIL THE NEXT CALL TO GETOPT.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               ENABLE (CATEGORY III)


EXAMPLE:

               CALL OPTON
          RE-ENABLE THE OPTION DISPLAY FILES.
USING DISLIB                                                   Page 4-48


     4.8.6  SUBROUTINE CLROPT(OPTNO)

PROGRAM MODULE:  CLROPT.F4


DESCRIPTION:

               THIS ROUTINE IS USED TO CLEAR (BLANK OUT)  THE  SPECIFIED
          OPTION.   OPTNO  IS  AN  INTEGER  VARIABLE  OR  CONSTANT WHICH
          INDICATES WHICH OPTION IS TO BE CLEARED.  IF OPTNO IS  NOT  IN
          THE  RANGE 1 - 10 THEN ALL OPTIONS ARE CLEARED.  THESE CHANGES
          WILL NOT BE VISIBLE UNTIL AFTER SNDOPT HAS BEEN CALLED.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               NONE


EXAMPLES:

               CALL CLROPT(0)
          THIS CLEARS ALL OPTIONS.

               CALL CLROPT(7)
          THIS CLEARS OPTION NUMBER 7.
USING DISLIB                                                   Page 4-49


4.9  TERMINATION ROUTINES (CATEGORY IX)

     THERE IS ONE ROUTINE IN THIS CATEGORY, SUBROUTINE FINI.





4.9.1  SUBROUTINE FINI

PROGRAM MODULE:  FINI.F4


DESCRIPTION:

               EVERY PROGRAM USING DISLIB ROUTINES SHOULD  EXIT  TO  THE
          MONITOR  WITH  A  CALL  TO FINI.  JUST AS START IS THE LOGICAL
          BEGINNING OF A PROGRAM, SO SHOULD FINI BE THE LOGICAL END OF A
          PROGRAM.  THE FUNCTION OF FINI IS TO MAKE SURE THE LOG FILE IS
          CLOSED PROPERLY, AND TO PRINT  AN  ERROR  SUMMARY  GIVING  THE
          NUMBER OF FATAL AND WARNING MESSAGES.  IF THERE WERE NO ERRORS
          THEN THERE WOULD BE NO SUMMARY.


POSSIBLE ERRORS:

               NONE


ROUTINES CALLED:

               CLRTTY (CATEGORY X)
               SNDCHR (CATEGORY X)
               LOGOFF (CATEGORY VII)


EXAMPLE:

               CALL FINI
          THIS STOPS THE PROGRAM.
USING DISLIB                                                   Page 4-50


     4.10  INTERNAL ROUTINES (CATEGORY X)

     ROUTINES IN THIS CATEGORY ARE USED INTERNALLY BY DISLIB.  IN  OTHER
WORDS,  MOST  OF  THE  USER  ROUTINES  (CATEGORIES I - IX) MAKE CALLS TO
ROUTINES IN THIS CATEGORY.  THESE  INTERNAL  ROUTINES  WILL  BE  BRIEFLY
DISCUSSED.   NORMALLY  A  USER  PROGRAM  WOULD  NOT  WANT  TO CALL THESE
ROUTINES, AND CERTAIN OF THEM SHOULD NEVER BE CALLED BY THE USER.  THOSE
MARKED WITH AN ASTERISK MIGHT BE OF SOME USE.




     SUBROUTINE SEND(CMD, DISNUM, X, Y)
SENDS A COMMAND TO THE GT40.


     SUBROUTINE GET(STATUS, X, Y, DISNUM)
RECEIVES A STATUS TRANSMISSION FROM THE GT40.


     (*) SUBROUTINE BYTES(WORD, BYTEL, BYTEH)
SPLITS WORD INTO TWO EIGHT BIT BYTES.


     SUBROUTINE WAITCH(CHAR)
RECEIVES ONE SIXBIT CHARACTER FROM THE GT40.


     (*) SUBROUTINE GETPTR(DISNUM, X, Y)
RETURNS POSITION OF POINTER - DISNUM.


     (*) INTEGER FUNCTION IPHYSX(X)
THIS ROUTINE RETURNS THE RASTER POSITION OF USER X AND IS  QUITE  USEFUL
IF  A  PROGRAM WISHES TO RELATE A USER POSITION TO A PARTICULAR PLACE ON
THE SCREEN.


     (*) INTEGER FUNCTION IPHYSY(Y)
THIS ROUTINE IS SIMILAR TO IPHYSX AND RETURNS  THE  RASTER  POSITION  OF
USER Y.


     (*) REAL FUNCTION USERX(IX)
THIS IS JUST THE OPPOSITE OF THE FUNCTION IPHYSX.  GIVEN  A  PHYSICAL  X
POSITION  (IN  RASTER  UNITS) THIS ROUTINE RETURNS THE X POSITION IN THE
CURRENT USER UNITS.


     (*) REAL FUNCTION USERY(IY)
THIS ROUTINE IS SIMILAR  TO  USERX  AND  RETURNS  THE  USER  Y  POSITION
CORRESPONDING TO A GIVEN Y RASTER POSITION.
USING DISLIB                                                   Page 4-51


     INTEGER FUNCTION SETGM(MODE, INT, LP, BLINK, LINE)
RETURNS AN SGM WORD.


     INTEGER FUNCTION SETSTA(ITAL, LP)
RETURNS A STATUS-A WORD.


     (*) SUBROUTINE ADLINE(N, FILE, X, Y, VISIBL)
INSERTS A (VISIBLE/INVISIBLE) VECTOR TO USER (X, Y).


     SUBROUTINE ADWORD(N, FILE, WORD)
ADDS A WORD TO THE DISPLAY FILE.


     SUBROUTINE ADBYTE(N, FILE, BYTE)
ADDS A BYTE TO THE DISPLAY FILE.


     SUBROUTINE SNDBLK(N, FILE, BLOCK)
SENDS A BLOCK OF A DISPLAY FILE TO THE GT40.


     (*) SUBROUTINE SFIELD(WORD, POS, LEN, BYTE)
THIS IS A GENERAL PURPOSE BYTE INSERTION ROUTINE AND COULD  BE  USED  IN
ANY  FORTRAN  PROGRAM.   THIS  ROUTINE BEHAVES IN THE SAME MANNER AS THE
ALGOL SFIELD PROCEDURE WHICH IS DOCUMENTED  IN  THE  DECSYSTEM-10  ALGOL
MANUAL.  THE ONLY EXCEPTION IS THAT ONLY ONE WORD ARGUMENTS ARE ALLOWED.
"WORD" IS THE WORD TO BE STORED INTO.  "POS" IS THE BIT  POSITION  (0  =
MOST  SIGNIFICANT  BIT OF WORD).  "LEN" IS THE SIZE OF THE BYTE IN BITS.
AND "BYTE" IS THE RIGHT JUSTIFIED VALUE TO BE STORED.


     (*) INTEGER FUNCTION GFIELD(WORD, POS, LEN)
THIS IS A GENERAL BYTE RETRIEVAL ROUTINE SIMILAR TO  SFIELD.   THE  BYTE
DESCRIBED BY THE ARGUMENTS IS RETURNED RIGHT JUSTIFIED.


     SUBROUTINE SETTTY
SETS TERMINAL CHARACTERISTICS FOR I/O.


     SUBROUTINE CLRTTY
RESETS TERMINAL CHARACTERISTICS


     (*) SUBROUTINE SNDCHR(CHAR)
SENDS AN IMAGE BYTE TO THE GT40.
USING DISLIB                                                   Page 4-52


     (*) INTEGER FUNCTION GETCHR(0)
RETURNS AN ASCII CHARACTER FROM THE GT40.
RETURNS -1 IF NO CHARACTER PRESENT.


     (*) SUBROUTINE MONRET
SUBROUTINE TO PAUSE AT MONITOR LEVEL.












                               CHAPTER 5

                          DISLIB COMMON BLOCKS



     THERE ARE SIX LABELED COMMON BLOCKS,  INTERNAL  TO  DISLIB.   THESE
COMMON  BLOCKS  ARE  MAINTAINED  AS A MEANS OF COMMUNICATION BETWEEN THE
USER ROUTINES (CATEGORIES I - IX) AND THE  INTERNAL  ROUTINES  (CATEGORY
X).   IT IS NEVER NECESSARY FOR THE USER PROGRAM TO DIRECTLY MEDDLE WITH
THE COMMON BLOCKS.  ALL MODIFICATIONS TO THE  VARIABLES  IN  COMMON  ARE
DONE  BY THE APPROPRIATE DISLIB ROUTINES.  HOWEVER, A VERY SOPHISTICATED
USER PROGRAM MIGHT WANT TO REFERENCE SOME OF THE VARIABLES, AND  IF  THE
USER  IS  SURE  HE KNOWS WHAT HE IS DOING, IT IS POSSIBLE TO MODIFY SOME
VARIABLES AS A SHORT-CUT TO AVOID CALLING DISLIB ROUTINES.  FOR  EXAMPLE
INSTEAD OF CALLING SETMOD WITH FOUR PARAMETERS, IT IS POSSIBLE TO MODIFY
JUST THE DESIRED PARAMETER IN THE COMMON BLOCK /MODBLK/.


     ALL VARIABLES IN THE COMMON BLOCKS ARE  INITIALIZED  BY  SUBROUTINE
START.   USER PROGRAMS SHOULD NOT ATTEMPT TO MAINTAIN INDEPENDENT COMMON
BLOCKS WITH THE SAME NAME.  EACH  OF  THE  COMMON  BLOCKS  WILL  NOW  BE
DISCUSSED IN DETAIL.
DISLIB COMMON BLOCKS                                            Page 5-2


5.1  LOG BLOCK (VARIABLES USED TO CONTROL THE LOG FILE)



          IMPLICIT INTEGER (A - Z)
          LOGICAL LOG
          COMMON /LOGBLK/ LOG, GTLOG, FATAL, WARN


LOG       -    IF .TRUE. THEN LOGGING WILL BE PERFORMED
          -    IF .FALSE. THEN NO LOGGING
          -    UPDATED BY LOGON AND LOGOFF
          -    START INITIALIZES AS .FALSE.

GTLOG     -    UNIT NUMBER FOR LOG FILE ("DSK:DISLIB.LOG")
          -    START INTIALIZES TO 20

FATAL     -    COUNT OF FATAL ERRORS (UPDATED BY ERROR)
          -    START INITIALIZES TO 0

WARN      -    COUNT OF WARNING ERRORS (UPDATED BY ERROR)
          -    START INITIALIZES TO 0
DISLIB COMMON BLOCKS                                            Page 5-3


5.2  SCALE BLOCK (VARIABLES USED IN SCALING)



          IMPLICIT INTEGER (A - W, Z)
          COMMON /SCLBLK/ XMIN, YMIN, XMAX, YMAX, BEAMX, BEAMY


XMIN      -    USER MINIMUM X (UPDATED BY SCALE)
          -    START INITIALIZES TO 0

YMIN      -    USER MINIMUM Y (UPDATED BY ROUTINE SCALE)
          -    START INITIALIZES TO 0

XMAX      -    USER MAXIMUM X (UPDATED BY ROUTINE SCALE)
          -    START INITIALIZES TO 1023.

YMAX      -    USER MAXIMUM Y (UPDATED BY ROUTINE SCALE)
          -    START INITIALIZES TO 767.

BEAMX     -    CURRENT RASTER X POSITION (UPDATED BY CATEGORY II)
          -    START INITIALIZES TO 0

BEAMY     -    CURRENT Y POSITION (UPDATED BY CATEGORY II)
          -    START INITIALIZES TO 0
DISLIB COMMON BLOCKS                                            Page 5-4


5.3  MODE BLOCK (VARIABLES USED IN SGM INSTRUCTION)



          IMPLICIT INTEGER (A - Z)
          LOGICAL LP, BLINK
          COMMON /MODBLK/ MODE, INT, LP, BLINK, LINE, OLDSGM


MODE      -    GRAPHIC DATA MODE (UPDATED BY CATEGORY II)
          -    START INITIALIZES TO 0

INT       -    GRAPHIC INTENSITY (UPDATED BY SETMOD)
          -    START INITIALIZES TO 2

LP        -    IF .TRUE. THEN L.P. SENSITIVE (UPDATED BY SETMOD)
          -    START INITIALIZES TO .FALSE.

BLINK     -    IF .TRUE. THEN BLINK (UPDATED BY SETMOD)
          -    START INITIALIZES TO .FALSE.

LINE      -    LINE TYPE (UPDATED BY SETMOD)
          -    START INITIALIZES TO 0 (SOLID LINE)

OLDSGM    -    CURRENT SGM INSTRUCTION (UPDATED BY SETGM)
          -    START INITIALIZES TO 0
DISLIB COMMON BLOCKS                                            Page 5-5


5.4  STATUS-A BLOCK (VARIABLES USED IN LOAD-A INSTRUCTIONS)



          INTEGER OLDSTA
          LOGICAL ITALA, LPA
          COMMON /STABLK/ ITALA, LPA, OLDSTA


ITALA     -    IF .TRUE. THEN ITALICS (UPDATED BY SETA)
          -    START INITIALIZES TO .FALSE.

LPA       -    IF .TRUE. THEN INTENSIFY HITS (UPDATED BY SETA)
          -    START INITIALIZES TO .TRUE.

OLDSTA    -    CURRENT LOAD-A INSTRUCTION (UPDATED BY SETSTA)
          -    START INITIALIZES TO 0
DISLIB COMMON BLOCKS                                            Page 5-6


5.5  OPTION BLOCK (VARIABLES USED IN CONTROLLING OPTIONS)



          IMPLICIT INTEGER (A - Z)
          COMMON /OPTBLK/ OPTION(10, 3), OPMSG, OPPTR, OPLIST


OPTION    -    ARRAY OF OPTIONS (UPDATED BY CATEGORY VIII)
          -    START INITIALIZES TO BLANKS

OPMSG     -    DISPLAY NUMBER OF PROMPT MESSAGE
          -    START INITIALIZES TO 8

OPPTR     -    DISPLAY NUMBER OF OPTION POINTER
          -    START INITIALIZES TO 6

OPLIST    -    DISPLAY NUMBER OF OPTION LIST (UPDATED BY SNDOPT)
          -    START INITIALIZES TO 0
DISLIB COMMON BLOCKS                                            Page 5-7


5.6  MISCELLANEOUS BLOCK

          INTEGER CHECK
          LOGICAL SHIFT
          COMMON /MSCBLK/ SHIFT, CHECK


SHIFT     -    IF .TRUE. THEN TEXT IS SHIFTED-OUT
          -    START INITIALIZES TO .FALSE.

CHECK     -    NUMBER OF CHECKSUM ERRORS FROM 10 TO GT40
          -    UPDATED BY GET
          -    START INITIALIZES TO 0












                               CHAPTER 6

                      DISLIB PROGRAMMING EXAMPLES



6.1  CATEYE DEMONSTRATION

          IMPLICIT INTEGER (A - Z)
C**********************************************************
C
C  THIS PROGRAM IS A DEMONSTRATION OF THE GT40
C  DISLIB PACKAGE. ORIGINAL CAT'S EYE DESIGN
C  COURTESY - ALEX NICHOLS.
C
C**********************************************************
          INTEGER FILE(1000)
          REAL USERX, USERY

C  FIRST STEP IS ALWAYS "CALL START"
          CALL START

C  ENABLE DISLIB LOG (NORMALLY USED FOR DEBUGGING)
          CALL LOGON

C  RESET GT40 TO INITIAL STATE
          CALL RESET(8)

C  INIT THE FILE, AND ENABLE SUBSCRIPT CHECKING
          CALL INIT(N, FILE, 1000, USERX(0), USERY(0))

C  SCALE IT SO THAT A 12 BY 6 UNIT RECTANGLE IS CENTRED
          CALL SCALE(-.144, -1.608, 12.144, 7.608)
DISLIB PROGRAMMING EXAMPLES                                     Page 6-2


C  CALL SUBROUTINE TO MESH SPECIFIED TRIANGLES
          CALL MESH(N, FILE, 1.5, 3., 6., 3., 6., 4.5, 20)
          CALL MESH(N, FILE, 6., 4.5, 6., 3., 10.5, 3., 20)
          CALL MESH(N, FILE, 1.5, 3., 6., 3., 6., 1.5, 20)
          CALL MESH(N, FILE, 6., 1.5, 6., 3., 10.5, 3., 20)
          CALL MESH(N, FILE, 6., 6., 4.5, 3., 6., 0., 20)
          CALL MESH(N, FILE, 6., 6., 7.5, 3., 6., 0., 20)
          CALL MESH(N, FILE, 6., 6., 0., 3., 6., 0., 30)
          CALL MESH(N, FILE, 6., 6., 12., 3., 6., 0., 30)
          CALL MESH(N, FILE, 4.5, 3., 6., 6., 0., 3., 20)
          CALL MESH(N, FILE, 4.5, 3., 6., 0., 0., 3., 20)
          CALL MESH(N, FILE, 7.5, 3., 6., 6., 12., 3., 20)
          CALL MESH(N, FILE, 7.5, 3., 6., 0., 12., 3., 20)

C  TURN ON ITALICS
          CALL SETA(.TRUE., .TRUE.)
          CALL MOVE(N, FILE, 5.2, -.5)

C  CHARACTERS ARE DISPLAYED AT INTENSITY 5
          CALL SETMOD(5, .FALSE., .FALSE., 0)
          CALL TEXT(N, FILE, 'CAT''S EYE', 9)

C  TURN OFF ITALICS
          CALL SETA(.FALSE., .TRUE.)
          CALL MOVE(N, FILE, 3., -.85)
          CALL TEXT(N, FILE, '  (ORIGINAL DESIGN - ALEX NICHOLS)', 34)

C  TRANSMIT TO GT40, DISNUM IS DISPLAY NUMBER
          CALL ADFILE(N, FILE, 0, DISNUM)

C  ENABLE (I.E. TURN ON THE DISPLAY)
          CALL ENABLE(DISNUM)

C  DISABLE THE SYSTEM DISPLAYS
          CALL PHOTO(.TRUE.)

C  CLOSE LOG FILE, AND STOP PROGRAM
          CALL FINI
          END
DISLIB PROGRAMMING EXAMPLES                                     Page 6-3


          SUBROUTINE MESH(N, FILE, XST, YST, XC, YC, XEND, YEND, NLINES)
C**********************************************************
C
C  THIS SUBROUTINE DOES THE ACTUAL MESHING
C  OF THE SPECIFIED RAY
C
C**********************************************************
          INTEGER FILE(N), NLINES
          REAL LINES

C  CALL MOVE TO (XST, YST) THEN VECTOR TO (XC, YC) & (XEND, YEND)
          CALL JOIN(N, FILE, XST, YST, XC, YC)
          CALL VECTOR(N, FILE, XEND, YEND)
          LINES = NLINES

C  LOOP FOR EACH LINE SEGMENT
          DO 100 IFRAC = 1, NLINES
          X1 = XST + (IFRAC - 1) / LINES * (XC - XST)
          Y1 = YST + (IFRAC - 1) / LINES * (YC - YST)
          X2 = XC + IFRAC / LINES * (XEND - XC)
          Y2 = YC + IFRAC / LINES * (YEND - YC)
          CALL JOIN(N, FILE, X1, Y1, X2, Y2)
100       CONTINUE
          RETURN
          END
DISLIB PROGRAMMING EXAMPLES                                     Page 6-4


6.2  ELLIPSE DEMONSTRATION

C************************************************************
C
C  THIS DEMONSTRATION PROGRAM DRAWS A SERIES OF ELLIPSES
C  ON THE SCREEN OF THE GT40. SUBSEQUENT ELLIPSES
C  ARE SHRUNK AND ROTATED
C
C************************************************************
          CALL START
          A = 5.
          B = 1.5
          CALL SCALE(-6., -4., 6., 4.)
100       CALL ELLIPS(A, B, R)
          A = A - .1
          B = B - 1.5/50.
          R = R - .1
          IF(A .GT. 0) GO TO 100
          CALL PHOTO(.TRUE.)
          CALL FINI
          END
DISLIB PROGRAMMING EXAMPLES                                     Page 6-5


          SUBROUTINE ELLIPS(A, B, R)
C************************************************************
C
C  THIS ROUTINE DRAWS AN ELLIPSE WITH MAJOR AXIS A
C  AND MINOR AXIS B THROUGH A ROTATION OF R RADIANS
C
C************************************************************
          INTEGER FILE(500)
          THETA = 0.
          X = A * COS(THETA)
          Y = B * SIN(THETA)
          CALL ROTATE(X, Y, R)
          CALL INIT(N, FILE, 500, X, Y)
          PI = 3.1415927
          AINC = PI / 40.
100       THETA = THETA + AINC
          X = A * COS(THETA)
          Y = B * SIN(THETA)
          CALL ROTATE(X, Y, R)
          CALL VECTOR(N, FILE, X, Y)
          IF(THETA .LE. 2 * PI) GO TO 100
          CALL ADFILE(N, FILE, 0, I)
          CALL ENABLE(I)
          RETURN
          END
DISLIB PROGRAMMING EXAMPLES                                     Page 6-6


          SUBROUTINE ROTATE(X, Y, R)
C************************************************************
C
C  THIS ROUTINE ROTATES A POINT (X, Y) THROUGH AN
C  ANGLE OF R RADIANS
C
C************************************************************
          XN = X * COS(R) + Y * SIN(R)
          Y = -X * SIN(R) + Y * COS(R)
          X = XN
          RETURN
          END
DISLIB PROGRAMMING EXAMPLES                                     Page 6-7


6.3  TEXT DEMONSTRATION PROGRAM

C************************************************************
C
C  THIS DEMONSTRATION PROGRAM IS USED TO DISPLAY THE
C  ENTIRE GT40 CHARACTER SET, VIA SUBROUTINE TEXT.
C  NOTE THAT THE SPECIAL CHARACTERS HAVE TO BE SET
C  UP NUMERICALLY
C
C************************************************************
          IMPLICIT INTEGER (A - W, Z)
          INTEGER FILE(250), SHIFT(10)

          CALL START
          CALL RESET(8)
          XST = 180.
          YST = 630.
          CALL INIT(N, FILE, 250, XST, YST)
          CALL TEXT(N, FILE, '   SPECIAL - ',13)
          CALL TEXT(N, FILE, ' ^!"#$%&''()*+,-./',17)
          CALL TEXT(N, FILE, '0123456789:;<=>?@',17)
          CALL SETA(.TRUE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 30.)
          CALL TEXT(N, FILE, '   ITALICS - ',13)
          CALL TEXT(N, FILE, ' ^!"#$%&''()*+,-./',17)
          CALL TEXT(N, FILE, '0123456789:;<=>?@',17)
          CALL SETA(.FALSE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 60.)
          CALL TEXT(N, FILE, 'UPPER CASE - ',13)
          SHIFT(1)='ABCDE'
          SHIFT(2)='FGHIJ'
          SHIFT(3)='KLMNO'
          SHIFT(4)='PQRST'
          SHIFT(5)='UVWXY'
          SHIFT(6)='Z'
          CALL TEXT(N, FILE, SHIFT, 26)
          CALL SETA(.TRUE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 90.)
          CALL TEXT(N, FILE, '   ITALICS - ',13)
          CALL TEXT(N, FILE, SHIFT, 26)
          DO 100 I = 1,6
          SHIFT(I) = SHIFT(I) + "201004020100
100       CONTINUE
          CALL SETA(.FALSE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 120.)
          CALL TEXT(N, FILE, 'LOWER CASE - ',13)
          CALL TEXT(N, FILE, SHIFT, 26)
          CALL SETA(.TRUE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 150.)
          CALL TEXT(N, FILE, '   ITALICS - ',13)
          CALL TEXT(N, FILE, SHIFT, 26)
DISLIB PROGRAMMING EXAMPLES                                     Page 6-8


          SHIFT(1) = "70000101006
          SHIFT(2) = "20120603420
          SHIFT(3) = "44241306032
          SHIFT(4) = "70402111046
          SHIFT(5) = "120522613460
          SHIFT(6) = "144643316072
          SHIFT(7) = "170761720100
          CALL SETA(.FALSE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 180.)
          CALL TEXT(N, FILE, ' SHIFT OUT - ',13)
          CALL TEXT(N, FILE, SHIFT, 33)
          CALL SETA(.TRUE., .TRUE.)
          CALL MOVE(N, FILE, XST, YST - 210.)
          CALL TEXT(N, FILE, '   ITALICS - ',13)
          CALL TEXT(N, FILE, SHIFT, 33)
          CALL SETA(.FALSE., .TRUE.)
          CALL ADFILE(N, FILE, 0, TXT)
          CALL ENABLE(TXT)
          CALL PHOTO(.FALSE.)
          TYPE 1
1         FORMAT(T30,'GT40 CHARACTER SET',3(/))
          CALL FINI
          END
DISLIB PROGRAMMING EXAMPLES                                     Page 6-9


6.4  OPTION DEMONSTRATION PROGRAM

C************************************************************
C
C  THIS PROGRAM IS A DEMONSTRATION PROGRAM ILLUSTRATING THE
C  USE OF OPTIONS. THREE OPTIONS WILL BE SET UP
C         1) WHEN "BEEP" IS SELECTED, RING THE GT40 BELL
C         2) WHEN "RE-START" IS SELECTED, RE-START THE PROGRAM
C         3) WHEN "EXIT" IS SELECTED, STOP THE PROGRAM
C
C************************************************************
          IMPLICIT INTEGER (A - Z)

          CALL START
100       CALL RESET
          CALL CLROPT(0)
          CALL ADDOPT(1, 'BEEP', 4)
          CALL ADDOPT(5, 'RE-START', 8)
          CALL ADDOPT(10, 'EXIT', 4)
          CALL SNDOPT(OPID)

200       CALL GETOPT(IOP)
          IF(IOP .EQ. 1) CALL SNDCHR("7)
          IF(IOP .EQ. 5) GO TO 100
          IF(IOP .EQ. 10) CALL FINI
          GO TO 200
          END












                               CHAPTER 7

                             DISLIB SUMMARY



7.1  COMPILING AND RUNNING PROGRAMS

     IN ORDER TO RUN A PROGRAM CONTAINING CALLS TO THE  DISLIB  ROUTINES
IT  IS  NECESSARY  TO  LINK  YOUR  PROGRAM  WITH THE LIBRARY IN THE GT40
ACCOUNT.  HERE ARE TWO EXAMPLES:


          .EXECUTE PROG.F4,SUB1.F4,SUB2.F4,DISLIB.REL[1600,2]/LIB


                                   OR


          .LOAD PROG.F4,SUB1.F4,SUB2.F4,DISLIB.REL[1600,2]/LIB
          .SAVE




     THE FIRST EXAMPLE EXECUTES A USER PROGRAM THAT  CONTAINS  TWO  USER
SUBROUTINES.   THE SECOND EXAMPLE IS SIMILAR EXCEPT INSTEAD OF EXECUTING
THE PROGRAM, IT IS SAVED AS A CORE IMAGE (.SAV FILE) FOR LATER EXECUTION
WITH  A  .RUN  COMMAND.   NOTICE  THAT THE DISLIB ROUTINES ARE LOADED IN
LIBRARY SEARCH MODE (/LIB  SWITCH).   THIS  LOADS  ONLY  THOSE  ROUTINES
NEEDED,  RATHER  THAN THE ENTIRE LIBRARY.  THIS SWITCH SHOULD BE USED IN
ORDER TO KEEP YOUR PROGRAM SMALL.
DISLIB SUMMARY                                                  Page 7-2


7.2  STOPPING YOUR PROGRAM

     IT IS OFTEN NECESSARY TO STOP PROGRAMS THAT ARE RUNNING BY  HITTING
CTRL/C.   MOST  OF  THE  TIME  THIS CAN BE DONE WITHOUT RUNNING INTO ANY
DIFFICULTY, BUT UNDER CERTAIN CIRCUMSTANCES DISLIB DOES NOT LIKE  TO  BE
INTERRUPTED.   THIS  IS  BECAUSE IT IS NECESSARY TO SET VARIOUS TERMINAL
CHARACTERISTICS TO ALLOW COMMUNICATION BETWEEN GIDUS  AND  DISLIB.   FOR
EXAMPLE  LOWER CASE IS ENABLED, BUT THE ECHO IS DISABLED.  IF YOU CTRL/C
OUT OF YOUR PROGRAM WITH THESE TERMINAL  CHARACTERISTICS  ALTERED,  THEN
YOU  WILL  HAVE DIFFICULTY USING THE KEYBOARD.  IF THIS SHOULD HAPPEN TO
YOU, RESTORE THE CHARACTERISTICS BY RUNNING THE SYSTEM  PROGRAM  INITIA.
THIS CAN BE ACCOMPLISHED WITH THE FOLLOWING MONITOR COMMAND:

          .INITIA



     NOTE THAT THIS COMMAND WILL NOT ECHO AS YOU TYPE IT IN, BUT YOU CAN
SEE  THE  RESULT  OF  YOUR  TYPING  BY  USING  THE  CTRL/R  KEY.  IF THE
CHARACTERS ECHO PROPERLY AS YOU TYPE THEM ON THE KEYBOARD THEN THERE  IS
NO NEED TO USE THIS COMMAND.
DISLIB SUMMARY                                                  Page 7-3


7.3  SUMMARY

     THE SOFTWARE PACKAGE (GIDUS AND DISLIB) IS QUITE  A  NEW  PIECE  OF
SOFTWARE,  SO  IT IS QUITE PROBABLE THAT THERE ARE SOME OUTSTANDING BUGS
NOT YET DISCOVERED.  IN ORDER TO  KEEP  UP  WITH  MODIFICATIONS  TO  THE
PACKAGE,  PARTICULARLY  AS  THEY  MIGHT  AFFECT  SUBROUTINE CALLS, USERS
SHOULD PERIODICALLY READ THE REVISION HISTORY  FILE  ("DSK:GT40.MOD"  IN
THE GT40 ACCOUNT).  PLEASE REPORT ANY BUGS, OR SUGGESTIONS TO:


          BILL WILDER - 126 U.  HALL (EXT.  437)
