Lesson "tops".




The manual for the course contains on paper all instructive texts in
the course. You can take the course without the manual, but the manual
is useful for reference during the course.

You can buy the manual from the program library at QZ,
Stockholms Datamaskincentral f`r h`gre utbildning och forskning,
S-10450 Stockholm 80, Sverige.

Write or telephone (no. 08-67 92 80) to the program librarian
and ask for a copy of "TOPS.MAN".
Lesson "tops01".




TOPSTEACH Release 4, July 1978.
===============================

TOPS01 - Talking to the DEC 10.
==============================

There is a manual for this course. The manual contains all instructive
texts within the course. You can take the course without the manual,
but it is better to get it, especially if you are using a display
terminal. The filename of the manual is "TOPS.MAN". Ask your computing
center how to get a copy of it.


When starting to use the DEC 10, you must first get connected to the
computer. Since this is done in different ways for different kinds
of terminals, I do not describe the procedure here. You can check
that you really are connected to the computer by pushing the
"RETURN" key on your terminal. If the computer responds with a "."
in the first column of a new line, then you are connected.


When you first get connected to the computer you are
communicating with a program called the MONITOR.
The monitor supervises everything that goes on
inside the computer. It will also interpret commands
that you type on your terminal. It is the monitor that
types the "." at the beginning of the line, saying:
"Here I am, at your service!"



When you are connected to the monitor, you can try some simple
commands. You can for example try the "DAY" command by typing
the word "DAY" followed by typing the "RETURN" key. The computer
will then answer with the date and the time.

Please note that just now you are communicating with
the lesson, you are NOT communicating with
the monitor. You can try out the "DAY" command only
if you first leave this lesson. Therefore wait until
the end of the lesson before you try it.



The delete key for correcting typing errors.
===========================================

When you are typing information to the computer, you may some
times make a typing error. But the computer will usually not
do what you tell it until you push the "RETURN" key.
If you become aware of your error before pushing
the "RETURN" key, then you can immediately correct it,.
To do that, you push the "DELETE" key on your terminal.
On some terminals, that key is marked "DEL" or "RUB OUT".
Say that you wanted to type "SWEDEN" and by mistake you
typed "SWD". You then push the "DELETE" key to remove the
erroneous "D", and then you continue with "EDEN".



You can delete as many characters as you wish as long as
you stay within the line. Therefore, if you have written "SWDEN" and
want to correct your error, you push the "DELETE" key three times to
delete succesively N, E, and D. Now, only "SW" is left
in the memory of the computer, and you can continue with "EDEN".



Programs are stored on disk areas. When you have a number and
password, you have your own disk area, identified by the
computer by the number.  The SYSTEM also has an area of disk
space, and this is accessable by all users of the computer.

If a program is stored on your own disk area you can run that
program by giving the command "RUN name.ext" where name is the
name you give your program, and ext is the extension of the
program. If you have created a program called "FRED.SAV"
then the monitor command "RUN FRED.SAV" will start to obey
the instructions given in the program "FRED.SAV".

If a program is stored on the system area, and is available to
all users, the command to run that program is "R name.ext".
To run the system program "LISP" you would type:
                R LISP
and the commands in that program would be obeyed.


Now this lesson will soon stop, so that you can try out the "DAY" command
for yourself. When you have tried it, you start the second lesson.

To start the second lesson,
if the lesson is stored on the system disk area you type "R TOPS02",
if the lesson is stored on your own disk area you type "RUN TOPS02".
After typing that you push the "RETURN" key.





When the computer types a dot(".") in column 1, then you know
that you are talking to the monitor, so that you can try out
the "DAY" command.

First only the finishing off of this lesson.



Summary
=======

Key             Effect
---             ------
RETURN          Finish a line and send it to the computer.
DELETE          Delete the character just typed.

Command         Effect
------          ------
RUN             Run a program on your own area.
R               Run a program on the system area.
DAY             Print the time and date.
Lesson "tops02".




Running ready-made programs.
===========================

When you started to run this lesson, you typed "RUN TOPS02"
on your terminal. This was because this lesson is a production
program saved for you.

If you want to start the execution of a production
program saved for you, then you type "RUN " followed by the
name of the production program. You can also start the execution
of system programs, that is programs which are common to all
users of this computer. To do this, you type "R " followed by
the name of the system program. If, for example, you wish
to start execution of the system program "BASIC", that is
the BASIC programming system, then you type "R BASIC".




The RUN and START commands to start execution.
=============================================

The meaning of the "RUN" command is
a) get the program into core,
b) start execution of the program.
If the program is already in core, then you can start it by
typing the "START" command.


If you have started execution of a program, then you cannot
type the monitor commands like "RUN" or "START". The reason
for this is that what you type goes to the program, not to
the monitor. If, for example, you should type "START"
now, then that message would go to this lesson program, not
to the monitor. Therefore you must first stop execution
of the ongoing program. For lessons created with the
GNOSIS system, you can always stop by typing "%". But this
is special for the gnosis system.


CONTROL-C to stop execution.
===========================

However, there is a way in which you can stop almost any
program. This is the so-called CONTROL-C. This is achieved
by simultaneously pushing both the "CONTROL" and the letter C
key on your terminal. After this, you will normally get to
the monitor. You will know when the monitor is there because
the monitor types "." in the first column of a line. Then you
know that you can write monitor commands like "RUN" or "START".

But don't push "CONTROL-C" now,
if you want to continue with this lesson.


The CONTINUE command to restart execution.
=========================================

After typing CONTROL-C you will get to the monitor, and you can
restart the program you were just running by typing "START". Then
you will get to the beginning of the lesson. You can also restart
by typing "CONTINUE". Then you will restart where you previously
stopped.

The CONTINUE facility does not work for all programs,
for example not for this lesson itself.




Double CONTROL-C to interrupt program loops.
===========================================

The CONTROL-C key will only interrupt the execution of
the program if the key combination is pushed when the user program
is expecting input from the terminal. However, if you are connected
to the computer through a full duplex line, then you can also
interrupt the computer when it is typing to you or when the computer
program is in a loop.

To do this, you push the CONTROL-C key combination twice,
instead of only once.







When you want to leave the computer terminal for a while, you
cannot just leave it or disconnect it, you have to perform
a LOGOUT. The simplest way to do this is to run the LOGOUT
program. Thus, when the monitor responds with a dot (".")
to you, you answer by typing "KJOB" and then pushing
the "RETURN" key.



Now this lesson ends. If you wish, you can restart it. You can always
type "%" to stop the restarted lesson if you do not
want to repeat the whole lesson, only repeat part of it.


Summary
=======

TWO control C:s will halt a running program.
ONE control C will stop a program waiting for input.

Command		Effect
-------		------
RUN		Runs a program stored on your own disk area.
R		Runs a program stored on the system area.
START		Starts a program already in core.
CONTINUE	Restarts a program which was interrupted by
		control C at the same point where execution
		was stopped.
KJOB		Log out.
Lesson "tops03".




TOPS03 - project-programmer numbers and logging in.
==================================================

Every user of the DEC 10 must have a project-programmer number.
This number consists of two octal numbers. The first octal number
is the number of the project you are working on. It is called
the project number. The second octal number is your own personal
programmer number, shared by no other programmer using the computer.



Octal numbers.
=============

An octal number is a number in the octal number system. The digits 8
and 9 are not permitted in that number system. Only the digits 0-7 are
permitted. The first seven numbers 1, 2, 3, 4, 5, 6 and 7 are
the same as in the decimal number system. But then comes the octal
number 10, which is the number after 7, that is the same number
which in the decimal number system is written 8. After 10 comes
the octal number 11.




The base of the decimal number system is 10. When you write 20, you
mean two times the base of the number system, that is 2 times 10.
When you write 30, you mean three times the base, that is 3 times 10.
The same is true in the octal number system, but there the base is
8(which is written "10" in the octal system). Thus 20 in the octal
system means two times the base, that is two times eight. The decimal
equivalent to the octal number 20 is therefore the decimal number
16, which is 2 times 8.



In the decimal system, 9 is the highest digit. Therefore, 10 comes
after 9 and 20 comes after 19 and 100 comes after 99. In the same
way, 7 is the highest digit in the octal system. Therefore, 10 comes
after 7 and 20 comes after 17 in the octal system.






The LOGIN command to get access to the facilities of the computer.
=================================================================

When you are connected to the DEC 10, you must perform a "LOGIN"
before you can use the computer. The LOGIN is a monitor command,
which is written to the monitor in response to a dot (".") from
the monitor. You write "LOGIN N,M" where N and
M are your project and programmer number.
When you do this, the monitor will respond with writing
"PASSWORD:". The monitor then expects you to type in your
own secret password. This password is known only to you, and ensures
that normally no one else but you can modify your files.




Changing your password.
======================

To ensure that your password is really secret, you may want to change
it now and then. You can change your password every time you make
a login. But be sure to remember your new password, otherwise you
will find it very difficult to use the computer anymore.


To change your password, you perform an ordinary LOGIN but
after typing in your old password, instead of pushing the RETURN
key, you push the ALTMODE key. On some terminals, this key is marked
ALT or ESCAPE or ESC. When you finish your old password with pushing
this key, then the computer will allow you to type in a new password.



If the ESCAPE key does not work, or if there is no such key,
you could sometimes push CONTROL-# instead, that is simultaneously
pushing the CONTROL and "#" key on your terminal. On other
terminals you should use CONTROL-[ or CONTROL-$ to get ESCAPE.
If nothing works, please consult your local system manager.

The ESCAPE character is not printable. Therefore, in this
lesson it will be printed as $. Wherever the $ character occurs
in this lesson, it does not really mean $, it means ESCAPE.


The LOGIN command invokes the LOGIN system program. Like any
other program, you can stop it by answering a question from the computer
with CONTROL-C. You will then get back monitor level again,
and you can start the LOGIN procedure all over again.


Lesson "tops04".




TOPS04 - Files.
==============

When you  have  logged  in,  the  disk  memory  of  the  computer  is
availableto you.  Here you can store data, source programs, compiled,
executable programs or any other kind of information which  you  want
to  process.  The  disk  is  divided  into FILES and every FILE has a
FILENAME, an EXTENSION  and  a  PROTECTION  CODE.  Files  are  stored
individually  for  each project-programmer number, so that your files
won't get mixed up with other people's files. 


The FILENAME is from one to six letters or digits.

The  EXTENSION is from one to three letters or digits, which indicate
what kind of file you have got.

The PROTECTION is three octal digits which indicate who is  permitted
to  do  what  to  the  file. The combination of FILENAME and
extension must be unique within the project-programmer number
of the owner of the file.


A typical file specification may look like this: PROG.ALG <057>.

PROG is the FILENAME, ALG is the EXTENSION, indicating that this file
contains  an ALGOL source program, <057> is the PROTECTION indicating
that only you can change your file, but other people on your  project
can read it.



Remember that the filename and extension can contain letters
and digits, but no other characters like brackets, punctuation
marks or the like.






The protection code.
===================

The protection code consists of three digits.
The first digit says what you yourself, as the owner of the file,
can do to it,  the second digit what other people on the same
project as you can do to the file, and the third digit what
other people on the computer can do to your file.





Each digit in the protection code can have a value from 0 to 7,
where 0 indicates all rights and 7 no rights.
Here is the meaning of all the values:

7  No access rights
6  Execute the file only
5  Read and execute the file
4  Append, read and execute the file
3  Update, append, read and execute the file
2  Write, update, append, read and execute the file
1  Rename, write, update, append, read and execute the file
0  Change protection, rename, write, update, append, read and
   execute the file.


The most important codes to remember are 7, 5 and 0.
7 is no rights at all,
5 is no rights to modify the file in any way,
  but rights to read and execute it,
0 is rights to do anything you like
  to the file.

The normal protection for new files is <057>, that is
you yourself can do anything you like, other people on
your project can read it, people outside your project
have no rights at all.





Summary
=======

The protection code is specified in the format
	<abc>
where a,b and c are octal digits.
a is the protection against the owner,
b is the protection against people with the same project number,
c is the protection against all others.

Digit	Meaning
-----   -------
7	No access rights
6	Execute the file only
5	Read and execute the file
4	Append, read and execute the file
3	Update, append, read and execute the file
2	Write, update, append, read and execute the file
1	Rename, write, update, append, read and execute the file
0	Change protection, rename, write, update, append, read and
	execute the file.
Lesson "tops05".




This lesson was written by Bo Tarras-Wahlberg and Jacob Palme,
FOA 1, S-104 50 Stockholm 80, Sweden.

Text editing.
============

If you want to create a text file from a terminal, if you want to
look at a text file or if you want to edit a text file, then you
need a text editor. The text editor is a program to help you look at
selected parts of a text file, change selected parts of the file or
put in new text where you want in the file.


The most wellknown text editors on the DEC 10 are SOS, TECO and VIDED.

SOS requires line numbers, and uses these for reference. But
you also have the ability to search for and replace small string
portions of a line. It is also possible to put a frequently used
sequence of commands into a file which, when called, will perform
the commands. SOS has very many usuful commands. Although SOS
has many commands, you can easily learn a useful subset of them.


TECO is a context editor. This means that you find the place to act
upon in a text by giving a search string. TECO will then search
through the text until a portion is found which is identical to the
search string. TECO also allows you to write small routines (written
in TECO) to perform complex editing operations. TECO is thus not
only an editor, but also a simple programming language for text
editing.


VIDED is a display editor. It can only be used with certain kinds
of display terminals. The idea with VIDED is that the full screen
shows a section of the text being modified, and that the screen
content is modified after each edit operation to show the text
after editing. VIDED is especially suited to the editing of texts
in ordinary language, tables, figures, nicely structured programs.
VIDED works best if the line between computer and terminal has a
speed of at least 120 characters/second.






Creating new text files.
=======================

When you want to create a new text file using one of the editors,
you type one of the monitor commands "SOS", "MAKE" or "R VIDED-"
"SOS" calls SOS, "MAKE" calls TECO, "R VIDED-" calls VIDED.


"SOS", "MAKE" and ".R VIDED-" like all other monitor commands
must be given to the monitor, that is typed when the monitor types
a "." to you to indicate its readiness to accept your commands.


After "SOS", "MAKE" or "R VIDED-" you must indicate the name of the
new file.

Example 1: If you want to create a LISP source program file for a
program called FIE, then you would type "MAKE FIE.LSP".

Example 2: IF you want to create a text file called LETTER.TXT,
then you would type ".R VIDED-LETTER.TXT".



Editing old text files.
======================

The "SOS" and "MAKE" commands were used to create new files.
If you want to look at or make changes or additions to an existing
file which you have stored away, then you would  use the
"SOS" or "TECO" commands. (The SOS command "SOS" is used both for
creating new text files and for editing old text files.)

The "SOS" command calls SOS, the "TECO" command
calls TECO. After the word "SOS" or "TECO" you must give the
name of the file. If you thus want to use SOS to look at a file
called "XYZ.LSP", then you type "SOS XYZ.LSP" to the monitor.




If you try to make a new file in TECO with the same name and extension
old one, then the old file would be destroyed. This might not be
what you intended. Therefore, you will get the error message
"SUPERSEDING EXISTING FILE".
When you get that error message, you can avoid destroying
the old file by immediately typing CONTROL-C.





You must now decide whether you are going to learn TECO, SOS or
VIDED. The next four lessons in this course are different depending
on whether you want to learn TECO or SOS. There are at present no
lessons in this course on VIDED, you will have to read the manual
instead.

Here are the main advantages with the three editors:


TECO  Allows the advanced programmer to write small text editing
      programs directly in TECO. No problem with renumbering of the
      lines, since there are normally no line numbers. TECO can however
      also handle line-numbered files.

SOS   Easier to learn and use for the beginner. Less easy to destroy
      your files by mistake. Uses line-numbered files, and some
      languages and on-line debugging systems work better with line-
      numbered source files. Also possible to write series of commands.

VIDED Immediate feed-back of the results after each edit operation.
      The screen always shows a segment of the text being edited.
      Cursor control keys on display terminals can be used. Special
      facilities for editing natural language texts like letters,
      manuscripts etc. Can only be used on certain display terminals.


Summary
=======

Command         Effect
-------         ------
SOS             Create or edit a file with the SOS editor.
MAKE            Create a file with the TECO editor.
TECO            Edit a file with the TECO editor.
R VIDED-        Create or edit a file with the VIDED editor.
Lesson "tops6s".





Text editing with SOS.
======================

SOS is a very powerful text editor on the DEC 10.
This course will not teach you all of the commands of SOS,
only the most useful ones.
SOS is a line editor; that is you normally use the line number(s)
as reference when you use a command in SOS.

SOS can be either in COMMAND mode or INSERT mode.

In the COMMAND mode you can use any of the commands
in SOS. When SOS is in COMMAND mode it types an asterisk ("*") in the
first position of the line, and waits for you to type a command.

In INSERT mode you can only insert a new text. In this mode SOS types
a line number in the left margin.



Inserting text into a file.
===========================

When you create a new file in SOS by using the "SOS" command,
you automatically enter the INSERT mode.
You just type a line of text that you want to insert and press
return key. A new line number will appear to the left and
you can continue to insert more text.



If you want to leave the insert mode and enter the command
mode you press the ALTMODE or ESCAPE key.
SOS will then type an asterisk which
means that you are in command mode.


The ESCAPE or ALTMODE key is a very important key.
If the ESCAPE key does not work, or if there is no such key,
you could sometimes push CONTROL-# instead, that is simultaneously
pushing the CONTROL and "#" key on your terminal. On other
terminals you should use CONTROL-[ or CONTROL-$ to get ESCAPE.
If nothing works, please consult your local system manager.

The ESCAPE character is not printable. Therefore, in this
lesson it will be printed as $. Wherever the $ character occurs
in this lesson, it does not really mean $, it means ESCAPE.



When you edit an old file in SOS you will instead enter 
the command mode after you type the SOS command.


If you are in command mode and want to insert a text
into the file, you can do this by using the INSERT command
which is written as the single letter "I".
After "I" you type the line number where you want to
have the text. Then you press the RETURN key and type your text.

EXAMPLE: You want to insert the text "BEGIN" at line 300.
Then you type "I300" , press the RETURN key and type "BEGIN".




If you want to insert a text at a line number which
is already occupied, SOS will give the inserted text
a line number between the number you wanted and the
following line number.

 EXAMPLE: You have the file below consisting of only
two lines.

00100    line 1
00200    line 2

If you type the command "I100", press the RETURN key
and type "INSERT" you will get the result:

00100    line 1
00150    INSERT
00200    line 2




The print command.
==================

When you are working with a file, you often need to look 
at specific lines in the file.
You can do that by using the "PRINT" command which is 
written as the single letter "P". After "P" you type
the number of the line you want to see.

EXAMPLE: If you want to look at line 100 you type "P100".

If you want to see more than one line then you type the number
of the first and the last line separated by a ":".

EXAMPLE:  P1000:1400
will print line 1000 up to line 1400.
This way of specifying a range of lines (two linenumbers
separated by a colon) applies to many SOS commands.

The symbol "^" indicates the first line and "*" the last line. 
These can be used instead of line numbers.


The character "." indicates current line.
That means the last line that has been printed
on your terminal. This character can be used instead of the
line number.



By using the "P" command without any specified line number
the current line and the next fifteen lines will be displayed.
If you type "P" once again, the next sixteen lines will be
printed. If you continue to give the "P" command, sixteen
lines will be printed every time.


You may print the line after current line without using
the PRINT command by just pushing the LINE FEED key.
(If you do not have a LINE FEED key on your terminal, you can
type CONTROL-J. That is press the CONTROL and "J" key at the
same time.)

If you want to print the line before current line you
push the ALTMODE or ESCAPE (ESC) key.




The delete command.
===================

Sometimes you want to delete lines you do not need 
any  more.
You can do that with the DELETE command.
It is written as the letter "D". After "D" you type
the number of the line you want to delete. If you want
to delete more than one line you separate the first
and last line number by a colon, as you did in the
PRINT command.

EXAMPLE:  D500:700
will delete lines 500 up to and including 700.




The replace command.
====================

If you want to replace a text with another text, you can
first delete the line with the "D" command and then 
insert the new text with the "I" command.
A better way is to use the REPLACE command, written "R".
It works as the "D" command and "I" command taking together.
After "R" you type the number of the line you want to replace.
Then press the RETURN key and type your new text.

EXAMPLE: If you want to replace the text "page" below you type
"R200" press the RETURN key and type your new text
in the same way as you did in the INSERT command.
00100    line 1
00200    page
00300    line 3




The copy command.
=================

It is possible to duplicate a line or group of lines
by using the COPY command in SOS.
You type a "C" followed by a line number where you want
to have the text. Type a comma and the number of the line 
you want to copy.

EXAMPLE: "C200,100" will copy the contents of line 100
into a new line numbered 200.

If you want to copy more than one line, you separate
the first and last number with a colon.

EXAMPLE: "C1000,100:500" will copy the contents of line
100 through 500 into a new location beginning with line 1000.



If there is not enough space when you use the COPY command,
SOS will renumber the lines and choose a smaller increment 
between the line numbers. 
SOS will inform the user by typing
INC=<increment>
If SOS cannot choose a small enough increment, it will 
type %OUT OF ORDER.
In that case only a part of the text will be copied.



Are you tired ?
We have only one command left.
It is the TRANSFER command and it is not more difficult
than the COPY command.



The transfer command.
=====================

If you want to transfer a line or a group of lines within 
a file you can use the TRANSFER command, written "T".
It works like the copy command but it also deletes the old
lines you copied.
First you type the "T", then the line number where you
want to have the text. Type a comma and the number of the
line you want to transfer.

EXAMPLE:   "T1000,100:500"  
will transfer lines 100 through 500 into the location
beginning with line 1000.





In this exercise we have only handled complete lines.
It is also possible in SOS to make changes within a line.
We will do that in lesson number 8.
The next lesson will teach you how to start and end SOS editing.


SOS is not easy to learn.
I am glad that you went on and did not end the lesson.


SOS is not easy to learn, but you have made great progress.


You have given very good answers and I am glad to have such
a clever student.


Perfect!!
You have given the right answer to all questions.
Have you used SOS before ??
If not, you have done an exellent job!!



Summary
=======

All these commands are for edit mode.

SOS Command	Effect
-----------	------
$		(ESCAPE) Print the previous line.
		(If in insert mode: Switch to edit mode)
LINE FEED	Print the next line.
In		Insert line with line number n.
Pn		Print line n.
Pm:n		Print all lines from m to n, inclusively.
Dn		Delete line n.
Dm:n		Delete all lines from m to n, inclusively.
Rn		Replace line n.
Rm:n		Replace all lines from m to n, inclusively.
Ck,m:n		Copy all lines between m and n to lines starting
		with line k.
Tk,m:n		Transfer all lines between m and n to line k
		and following lines.

These characters may also be used as line numbers:
^	First line
.	Current line
*	Last line.
Lesson "tops7s".





This lesson will teach you how to start and finish SOS editing.




Accessing SOS.
==============

One way to call SOS is by giving the monitor command "SOS".
SOS will then ask for the name of the file by printing

File:

You type the file name on the same line and push the RETURN key.
The file is now ready for editing.

EXAMPLE:  SOS<return>             SOS is called

          File:PROG.SIM<return>   The file PROG.SIM is ready
                                  for editing.




If you use the SOS command to edit a file that does not
exist, a new file with the given name will be created
and edited.


Another way to edit a file in SOS is by typing the "SOS"
command and the file name on the same line separated with
a blank.
EXAMPLE:  SOS TEST.ALG<return>
will enter SOS and edit the file TEST.ALG.

SOS will remember the last edited file so that the next
time yo want to edit the same file, you only have to type
"SOS".




In SOS you can also access a file in a READ-ONLY mode.
That is, you can find information in your file but you
can not perform any editing.
The reason to do this is when file protection does not
allowyou to enter SOS editing mode, or when you just
don't want to have any editing done by accident.
You enter this mode by typing a slash followed by READONLY
after the file name.
EXAMPLE:   SOS TEST.ALG/READONLY<return>
will access the file TEST.ALG in READ-ONLY mode.



Storing the file.
=================

When you have finished the editing of a file, you may want
to store the file on a disk.
To do that, you use the END command. It is written as the 
letter "E" in command mode.
The file will then be stored under the same name as when it
was edited.


It is also possible to store the file without the line numbers.
You do that with the "ES" command. (End without Sequence numbers.)
This command is useful if you want to use the file as a DATA-file.




If you for some reason realize that the current edition 
is worthless, you can use the END AND QUIT command.
It is written "EQ" and will return you to monitor
level without saving your edited file.



Example of the starting and finishing commands in SOS.

.SOS TEST.CBL             SOS is called and the file TEST.CBL is edited.
INPUT: TEST.CBL           Typed by SOS.
00100
  .
  .                       Insert your program.
  .
05000 $                   End the insert mode with ALTMODE or ESCAPE.
*E                        Store the edited file on disk.

[DSKB:TEST.CBL<057>]      Typed by SOS.

.                         Monitor level.

(The asterisk and the point are printed by SOS.)



It is possible to rename the file, when you use the
"E" or "ES" command.
EXAMPLE: E:NEW<return>
will store the file under the new name "NEW".




There is another command in SOS called SAVE WORLD.
It is written "W" and works like the end "E" command,
except that it will still keep you in the edit mode.
This command should be given from time to time.
It is used to save the current version of the file,
in case the system should crash.
If the system does crash, you will lose only the
updates made since the last "W" command was given.



The Go command.
===============

This command can only be used after you have given an 
execution command (such as EXECUTE, LOAD or COMPILE)
previously in the same session.
It works like the "E" command, but it also runs
the previous execution command.
The GO command is written "G".



It is also possible to use the GO command with the extension
S or Q.
The command "GS" saves your file on a disk and runs the
previous execution command.
The command "GQ" will not save your edited file, but will
run your last execution command again.


Summary
=======

SOS Command	Effect
-----------	------
E		Save the file with line numbers and exit from SOS.
ES		Save the file without line numbers and exit.
EQ		Skip the edited version and exit from SOS.
G		Same as "E", but execute last "EX" command after exit.
GS		Same as "ES", but execute last "EX" command after exit.
GQ		Same as "EQ", but execute last "EX" command after exit.
W		Save the edited file, but don't exit.
Lesson "tops8s".




The find command.
=================

In SOS you can locate an arbitrary text string within a file
without specifying the line number.
You do that with the FIND command. 
It is written as the letter "F" followed by the text string
you want to find. Push the ALTMODE or ESCAPE key and then
the RETURN key.



A very important key on your keyboard is the ESCAPE or ALTMODE key.
This is used all the time by SOS.
If the ESCAPE key does not work, or if there is no such key,
you could sometimes push CONTROL-# instead, that is simultaneously
pushing the CONTROL and "#" key on your terminal. On other
terminals you should use CONTROL-[ or CONTROL-$ to get ESCAPE.
If nothing works, please consult your local system manager.

The ESCAPE character is not printable. Therefore, in this
lesson it will be printed as $. Wherever the $ character occurs
in this lesson, it does not really mean $, it means ESCAPE.


EXAMPLE: FPROBLEM<escape><return>
will search for the first occurrence of the text "PROBLEM"
starting from current line.
(Current line is the line last written on your terminal.
When opening a file for editing, it is the first line.)

Sometimes I will put brackets ("<",">") around text to make it
easier to read. This does NOT mean that you should
type the brackets. For example, if the text says <escape>,
you should of course push the ESCAPE key on the keyboard.




It is also possible to search through a range of line numbers
for the first occurrence of a given text string.

EXAMPLE: FSOLUTION<escape>  500:1000 <return>
will search for the first occurrence of "SOLUTION" in lines
500 up to and including 1000.

When the text string is found, the text and the line number
will be printed by SOS.
If the specified text does not exist within the given range
SOS will indicate that by typing  %SEARCH FAILS.



After you have found an occurence of of the string, you may
continue the search by just typing F<return>, without any
search string or range.

example:  
           
FNEW<escape> 100:500 <return>            Search for the first occurrence
00150  T:-NEW POINT;                     of NEW in lines 100 trough 500.

F<return>                                Search for the next occurrence
00200  U:-NEW LINE;                      of NEW after line 150 and upto
                                         line 500.


(The line number and the text are printed by SOS.)




The Substitute command.
=======================

Sometimes the same string of text occurs frequently in a file.
It would be very tiresome to change every line one by one.
SOS provides a SUBSTITUTE command, written "S", that will substitute
every occurrence of a text string for another in a specified range.

EXAMPLE:  S<old text><escape><new text><escape> 100:500 <return>
will substitute the old text for the new text in lines 100 upto 500.



WARNING: Make sure that the old text only occurs at the places
you really want to change.
If you for example type the command  Sgo<escape>stop<escape> ^:*
the word Algol will be changed to Alstopl, which was probably not
your intention.

If no range is included in the command, only the first
possible substitution after the current line will be done.
This is analogous to the F command without a range.



The Alter command. (Intraline editing mode.)
============================================

The ALTER command is used for small changes within a line.
The command, written "A", places the user in a special editing
mode which has its own commands.
To enter ALTER mode you type "A" followed by a line number.
This mode uses a pointer within the line.
Think of the pointer as pointing between two characters on
the line. Initially it points before the first character on the
line. The special commands will affect characters in the
immediate vicinity of this pointer.


The special commands in ALTER mode are:

Moving the pointer.
-------------------
To advance the pointer one position to the right, strike
the space (blank) bar once. Each character in the text will 
be printed out, one by one, as the pointer moves forward.
This command may be preceded by an optional integer <n>. The command
will then be repeated <n> times. For example, if you want to move
the pointer 7 steps to the right you type "7 ".

Syntax: <n><SPACE>


To move the pointer to the left, use RUB OUT.
This will not delete anything as it would do in ordinary
SOS mode. You can also use DELETE, BACKSPACE or CONTROL-H.
As the pointer moves backwards, the characters passed over
are surrounded by backslashes (\...\).
This command may be preceded by an integer in the same way as
the previous command.

Syntax: <n><RUB OUT>

To move the pointer back to the beginning of the line beeing
edited, type "B".

Syntax: B


The delete command.
-------------------
To delete one character, move the pointer to the position just before
the character and press the "D" key.
The deleted character will be surrounded by double backslashes "\\".
The delete command can be preceded by an integer. For example, if you
want to delete 7 characters, you can type "DDDDDDD". You can also do
it by typing "7D".

Syntax: <n>D


The insert command.
-------------------
Move the pointer to the place where you
want to insert your text. Press the "I" key.
You can now insert any text you want starting from current position.
To indicate that the inserted text is ended, you push the 
ALTMODE or ESCAPE key. Afterwards, the pointer will be pointing
after the inserted text.
"<string>" means the string you want to insert.

Syntax: I<string><ESCAPE>

If you have made an insertion and want to finish ALTER mode
immediately, then you can push RETURN without pushing ESCAPE first.

The "I" command has a special feature to split up a line: If you
type "I", then LINE FEED and RETURN, the current line will be
split up at the pointer, which will be positioned at the beginning
of the new line.


Terminating command.
--------------------
When no more editing is necessary, you should push the 
RETURN key. This causes the rest of the line to be printed.
It also ends the ALTER mode.


Another way to move the pointer in ALTER mode is to use the SKIP command.

The skip command.
-----------------
This command will move the pointer to just before the next
occurence of a specified character in the line.
It is written "S" and followed by that character to which you want 
to move the pointer. If the "S" is preceded by an integer <n>,
SOS will look for the <n>:th occurence of the specified character.

Syntax: <n>S<character>



EXAMPLE: Suppose you have the line

00200    A = B + C +

with the pointer before A.
If you give the skip command "2S+", SOS will type

00200    A = B + C 

and put the pointer before the second "+".
You can now continue and give the delete command "D".
Push the RETURN key and you will get the result:

00200    A = B + C



The print command.
------------------
If you have made several corrections in alter mode, the line
might look "dirty" with a lot of backslashes on the screen.
If you type "P", the line will be reprinted up to the pointer's
position.

Syntax: P



The replace command.
--------------------
You type "R", and then a string ended with ESCAPE. The replace
command will then delete one character and put in the string at
the pointer. If you want to delete more than one character, you
can type the number <n> before you type "R". The replace command
works exactly as <n>DI<string><ESCAPE>, that is the delete and
insert commands combined.

Syntax: <n>R<string><ESCAPE>



Suppose you have the text

04711	(TECO TERROR)

Use the replace command to change it to

04711	(LISP TERROR)

When you have typed the replace command, also type the
"P" command to see the line. Try to minimize the number of
key pushes.



Undoing changes.
----------------
If you have made some corrections in alter mode which you
regret, you can get back the old version of the line by
typing CONTROL U. This command will also reposition the
pointer to the beginning of the line.

Syntax: <CONTROL U>

You can also use the quit command. It is written "Q" and works
as CONTROL U, but the "Q" command also terminates alter mode.


There will be no more questions on the ALTER command.
If you are going to use SOS you are recommended to get
used to this command. It can be very effective if you
use it correctly.


The number command.
===================

As you know, each line in SOS has a line number.
The increment in line numbers is 100 by default.
If you want to change this you can use the NUMBER command.
It is written "N" and followed by the new increment.
By only typing "N" you will get an increment of 100.

EXAMPLE:  If you want to renumber a file with a new increment
of 500, you type "N500"
(The first line will then get line number 500.)


It is also possible to renumber only some of the lines in a file.

EXAMPLE:  N50,100:500
will renumber lines 100 through 500 with a new increment of 50.



A more complete number command has the format:
    N<increment>,<old range>,<first number in new range>
where the arguments may be omitted from the right.
EXAMPLE:  N50,100:500,1000
will renumber lines 100 through 500 with a new increment of 50,
giving the first renumbered line the number 1000.


To change the increment in line numbers that you get in INSERT mode,
you use the INSERT command followed by a comma and the new increment.

EXAMPLE:  I210,10
will start inserting at line 210 with the new increment of 10.



Summary
=======

SOS Command		Effect
-----------		------
F<str>$m:n		Print the first line in the range m:n
			which contains tre string <str>.
F<str>$			Print the first line in the range
			current line:last line wcich contains <str>.
F			Look for the same string as in the last
			F command in the range next line:last line.
S<str1>$<str2>$m:n	Substitute all occurences of <str1> to <str2>
			in the range m:n.
S<str1>$<str2>$		Substitute in the range current line:last line.
S			Execute the last substitute command in the
			range next line:last line.
Nk,m:n,s		Renumber the lines m:n with new increment k
			and start at line s.
Im,n			Insert a line at line number m with new
			increment n.
An			Start ALTER mode at line n.

ALTER mode commands
-------------------
n<SPACE>	Move the pointer n steps to the right.
n<RUB OUT>	Move the pointer n steps to the left.	
nD		Delete n characters.
I<str>$		Insert the string <str> at the pointer.
<RETURN>	Make the ALTER mode changes permanent and leave ALTER.
nS<character>	Put the pointer to after the n:th occurence
		of the character.

P		Print the line up to the pointer.
nR<str>$	Delete n characters and put in the string <str>.
<CONTROL U>	Undo the ALTER changes and start again.
Q		Same as CONTROL U, but leave ALTER mode.

Lesson "tops9s".




Division into pages.
====================

Earlier, we have assumed that the file consists only of one page.
In SOS you have the possibility to insert page marks anywhere
in your file. In this way you can divide your file into
smaller pieces. Line numbers start anew within each page, and
if you print the file, each page will start on a new  sheet
of paper., but a SOS page may extend over several printer pages.


For every command that includes a line number, you can also
specify a page number by typing:
                      
         line number/ page number

EXAMPLE:   D500/2
will delete line 500 on page 2.

If you do not specify any page number, the command will be made for
current page.




Instead of the first, current and last page, you can use
"^", "." and "*" like you did in the line specifications.



If the specified page does not exist, the error message
"%No such page" is printed by SOS.



If you want to specify a range of line numbers you type a 
colon ":" to separate the first and the last line.

EXAMPLE:  P1000/5:*/*
will print line 1000 on page 5 up to the last line on the last page.




There is another form of range specification in SOS.
This form specifies the starting line and a number of lines
separated by a "!".

EXAMPLE: 100/3!4
specifies 4 lines starting with line 100 on page 3.




Addition and subtraction can also be used in line and page 
specifications.

EXAMPLE: 
           /5-3               Page 2.
           /.+1               The next page.
           /.-1               The previous page.
         .-1:.+1              Three lines, including current line.




The Mark command.
=================

To insert a page mark into your text, you use the MARK command.
It is written as "M" followed by a line number and will insert
a page mark immediately before the specified line number.

EXAMPLE:  M5200/3
will insert a page mark before line 5200 on page 3.

The page numbers are always consecutive, so inserting a page 
mark will increase all the following page numbers by one.

If the specified page number does not exist, the error
message %NO SUCH PAGE is printed by SOS.



If you want to insert a page mark after the last line on current
page, you can type "M99999". The next insert command will then refer 
to the new page.



The kill command.
==================

To delete a page mark (page number), you use the KILL command.
It is typed as "K" followed by a slash and the page mark you
want to delete. The page mark has the same number as the page
which follows it. There is no page mark number 1.

EXAMPLE:  K/5
will delete the page mark in front of line five.

Do not mix up the kill "K" and delete "D" commands in SOS.

D/5 will delete the contents of page 5. (Not the page mark)
K/5 will delete the page marks on page 5. (Not the contents)


NOTE: The page marks are numbered by counting from the beginning
of the file. After you have removed a page mark, all page  marks
further out in the file get numbers one less than they had before.
To remove all page marks, the best way is to do K/2 repeatedly
until you get the error message "%No such page".


If you try to kill page number one or a page number that 
does not exist, you will get the error message %NO SUCH PAGE




When a page mark is removed, the lines of the adjoining pages are
not renumbered. No information is lost, but several lines
may have the same line number.
It is wise to give an "N" command after one or more "K" commands.


The join command.
=================

This command will join two consecutive lines into one.
The command is typed "J" followed by the line number of the first line.
The combined line that is formed will be given the specified line number.

EXAMPLE: J500/3
will join line 500 and the next line on page three.
The extended line will get the line number 500.

If the joined line is too long, you will get the message %LINE TOO LONG.
If it is the last line on the page, you get %NO NEXT LINE.




The give information command.
=============================

Any time you are in SOS command mode, you can request the value
of a parameter by using the GIVE INFORMATION command.
It is typed as  =<parameter><return>

EXAMPLE of parameters:

            INC       Print the current increment in line numbers.
            .         Print current line / current page
            BIG       Print the page number of the largest page.
            ERROR     Print the last error message.
            NAME      Print the name of the file
            STRING    Print the text strings used by the find and 
                      substitute commands.




Many of the SOS commands that we have been talking about can be
used in a more advanced manner.
You can for instance use the copy command to copy lines 
from other files.
The substitute and find commands can be used for groups of characters.
There are also many commands in SOS that we have not talked about.
All this would, however, go beyond the scope of this introductory
course in SOS.


How to learn more about SOS:
============================
The file HLP:SOS.HLP contains a summary of all SOS commands
and parameters. It will be typed on your terminal when you give
the monitor command:
		HELP SOS
You need not be logged in to use the HELP command, but you
must get out of the TOPSTEACH course.


Summary
=======

For a line number in a command you can specify a page number
by adding a slash ("/") and the page number to the line number.
The characters "^","." and "*" can also be used:
/^	is the first page
/.	is the current page
/*	is the last page.

In most commands where you can use a line number, you can also use
line number/page number .

You can give a range specification of the form m/n!k, which
means k lines starting with line m on page n.

SOS Commands	Effect
------------	------
Jm/n		Append line m on page n with the line after that one.
Mm/n		Put in a page mark at line m on page n.
K/n		Delete page mark n.
Lesson "tops6t".




Text editing with TECO.
======================

TECO is one of the most powerful text editors on the DEC 10.
This course will not teach you all commands of TECO, only a
few of the mostly used ones.


The ESCAPE key.
===============

A very important key on your keyboard is the ESCAPE or ALTMODE key.
This is used all the time by TECO.
If the ESCAPE key does not work, or if there is no such key,
you could sometimes push CONTROL-# instead, that is simultaneously
pushing the CONTROL and "#" key on your terminal. On other
terminals you should use CONTROL-[ or CONTROL-$ to get ESCAPE.
If nothing works, please consult your local system manager.

The ESCAPE character is not printable. Therefore, in this
lesson it will be printed as $. Wherever the $ character occurs
in this lesson, it does not really mean $, it means ESCAPE.




Inserting text into the file.
============================

The first thing you do when you are creating a new file is to
insert some text into the new file. You do this by using the
"INSERT" command which is written with the single letter "I".
After "I" follows the text to be inserted, and the text is
finished by an ESCAPE.

EXAMPLE: to insert the text "BEGIN" you type "IBEGIN$".



You can also insert several lines of text with one insert command.
EXAMPLE: to insert the text
"BEGIN
    TEXT FIRSTWORD, SECONDWORD;
"
You should type on your terminal
IBEGIN
   TEXT FIRSTWORD, SECONDWORD;
$
You end each line by pushing the RETURN key, just as you would do
on an electric typewriter.








The last question was difficult, but you made it,
which shows that you are clever.



Moving the position pointer in the text file.
============================================

When you are using TECO, there is always an imaginary pointer
referring to a position in a file. Usually, the pointer refers
to the end of the place where the last TECO command was done.
After the TECO command "IABC$", this pointer is thus referring
to the character after the newly inserted "C" in "ABC".
Each new TECO command always begins its actions where this
pointer is referring.

Example: If an insert("I") command is done in the string
"123456789" with the pointer referring to the
"6", then the new insertion is done between "5" and "6" in
the buffer.





Some simple commands for moving the pointer:
nC = move the pointer n characters forward in the file.
nR = move the pointer n characters backward in the file.
J = move the pointer to the beginning of the current page of the file.
ZJ = move the pointer to the end of the current page of the file.
0L = move the pointer to the beginning of the current line.
nL = move the pointer to the beginning of the n-th line from
previous position of the pointer.

You should substitute an integer for "n" in the commands
"nC", "nL" and "nR" above. The integer n can be negative, to
move the pointer backwards in the file.





The last question was quite difficult. But you did it!! Good!!



Looking at selected parts of the file.
=====================================

If you want to print out part of the text in the file on your
terminal, then you use the "T" command. Some examples:
0T = print from the beginning of this line up to pointer.
T = print from the pointer to the end of this line.
-3T = print from three lines before the pointer up to the pointer.
3T = print three lines forward from the pointer.
HT = print the whole current page from the input file.


EXAMPLE: if the buffer contains
"BEGIN
BOOLEAN GOOD, BAD;
TEXT SUNSHINE, THUNDER;
"
and the pointer refers to the "," after "SUNSHINE", then
"0T" will print out "TEXT SUNSHINE",
"T" will print out ", THUNDER;
"
"-T" will print out
"BOOLEAN GOOD, BAD;
TEXT SUNSHINE"





You may feel that I am deliberately trying to defeat
you with too hard questions. But as long as you succeed
as well as you are doing, you are still coming out on
top, are you not?


Executing strings of TECO commands.
==================================

When you write commands to TECO, they are just stored until
you push the ESCAPE key twice in sequence. Then all the commands
are executed. Thus, by typing "0TT$$" you can print the whole
current line and by typing "IABCD$-3T2T$$" you can first insert
"ABCD" at the pointer and then print five surrounding lines.



Leaving TECO.
============

When you are ready with TECO, you write the "EX$$" command to
leave TECO if you want to save the new file.
If you do not want to save the new file, then you leave TECO with
control-c.


I know this lesson was not easy, but you have worked
hard and patiently. That is good.


Now you know enough about TECO to experiment a little yourself
with it before taking the next lesson.

You can get into TECO by writing "MAKE TEST.TMP" to the
monitor. But first you must leave this lesson.


Summary
=======

TECO Command	Effect
------------	------
$$		Two ESCAPEs finishes and executes a command string.
I<string>$	inserts the text <string> at the pointer.
EX		Ends the editing and leaves TECO.

Moving the pointer
------------------
nC	move the pointer n characters forward in the file.
nR	move the pointer n characters backward in the file.
J	move the pointer to the beginning of the current page of the file.
ZJ	move the pointer to the end of the current page of the file.
0L	move the pointer to the beginning of the current line.
nL	move the pointer to the beginning of the n-th line from
	previous position of the pointer.

You should substitute an integer for "n" in the commands
"nC", "nL" and "nR" above. The integer n can be negative, to
move the pointer backwards in the file.

The print command
-----------------
0T	print from the beginning of this line up to pointer.
T	print from the pointer to the end of this line.
-3T	print from three lines before the pointer up to the pointer.
3T	print three lines forward from the pointer.
HT	print the whole current page from the input file.
Lesson "tops7t".




Searches and deletions with TECO.
================================

The "D" command of TECO is used to delete a few characters
in a text. The deletion begins at the pointer position.
"nD" deletes n characters from the pointer forwards,
"-nD" deletes n characters backwards from the pointer,
(Where "n" stands for an integer number.)
"D" is the same as "1D" and "-D" is the same as "-1D".

Example: if you have the text "THE SUNNSHINE" and want to
change it to "THE SUNSHINE", and if the pointer initially
is at the beginning of the text, then you can write
to TECO "6CD$$" or "7CD$$" or "7C-D$$" or "8C-D$$".




With the DELETE ("D") command you remove a certain number of
characters. There is also a command for removing a certain number
of lines. This is the "K" command.

"nK" will remove n lines from the position of the pointer.
Example: "0LK" will remove the current line,
"0K" will remove the current line up to the position of the pointer,
"K" will remove the part of the current line after the
position of the pointer,
"0L5K" will remove five full lines.



The search "S" command.
======================

The simplest way to move the pointer to the correct place is
usually to use the "S" command, since then you will not have
to count the characters.

The "S" command consists of the letter "S", a search string,
and is ended by the ESCAPE key.


Example: "S4444$" searches for the first occurence of the
string "4444" in the text. The search begins at the current
position of the pointer. After the search, the pointer is placed
at the position immediately following the matching
string in the file.

Thus "S4444$" on the text "012344445678" will position the
pointer at the character "5" in the file.





You are doing very well. Congratulations.


The last question was not simple, but you made it.
Congratulations.


You may precede the "S" command with an integer i. In that
case the computer will look for the i:th occurence of the
string. For example, a possible answer to the previous
question is:
    2SN$2D$$
That is, delete two characters after the second occurence of "N".


Sometimes you want to replace a word in the file with another
word. A simple way to do this is the "FS" command which has
two argument strings. The command searches for a match to
the first argument, and replaces the match part of the
file with the second argument.

Example: "FSONE$TWO$$" will search for the first occurence of
the word "ONE" and change it to "TWO".



If you precede the "FS" commad with an integer i, only the i:th
occurence of the search string will be substituted.


After a search, you often want to check that you have arrived at the
right place before you do any deletions or insertions. This can be
done by "T" to print the text after the pointer or "0T" to print
the text up to the pointer.

Example: to search for "BERNHARD" and then print the text up to the
new pointer position, you write "SBERNHARD$0T$$".


I know this lesson was difficult, but thank you for your diligence.


Before going on to the next lesson, try out the new
commands "D", "K", "S" and "FS" with TECO.


Summary
=======

TECO Command	Effect
------------	------
nD		Delete n characters
nK		Delete n lines starting from the pointer
0K		Delete the line up to the pointer
nS<str>$	Search for the n:th occurence of the string
		<str> in th text
nFS<str1>$<str2>$
		Substitute the string <str2> for the n:th
		occurence of the string <str1> in the text.
Lesson "tops8t".




Partitioning of text files into pages.
=====================================

When you are using TECO to handle a large text file,
then you usually divide that file into pages. Each page should
contain less than about 50 lines of text.

When the file is printed, a new page is always printed at the top of
a new paper form.

You divide a file into pages by insertion of the special character
FORM FEED into the file. There is a key for that character on your
terminals and you can insert it just like any other character.
On some terminals, the FORM FEED key is labeled FF or ERASE PAGE.



We will assume that your terminal does not have any FORM FEED
key. However, you can still use TECO. There is a special command
in TECO to insert characters which have no key on your terminal.
Instead, you use the decimal value of the character. The decimal
value of FORM FEED is "12". To insert that character into a file
you write the TECO command string "12I$". This command string
will introduce one character with a decimal value of 12, that is,
one FORM FEED character.

To divide a file into pages, you simply execute that command string
to insert FORM FEED characters into your file.


To divide a text file into pages, you simply insert a FORM FEED
with TECO just as you would insert any other text into your file.
That is, you write the letter "I", you push "FORM FEED" and then
you push "ESCAPE" twice.


After a file has been divided into pages, all the TECO commands
you have learned so far will only work within one page.

Thus for example:
"J" will place the pointer at the beginning of the current page
    (not at the beginning of the entire file),
"ZJ" will place the pointer at the end of the current page,
"S" will only search within the current page,
"T" will only print within the current page etc.


TECO commands for page handling.
===============================

This means that you cannot serach for, skip or delete
FORM FEED characters using the ordinary "S", "L" or "D"
commands of TECO.

There are instead special commands for this. The most important
ones are the "P" and the "A" commands.

"P" means move the pointer to the beginning of the next page
in the text file.
"A" means append the next page to the current page and remove
the FORM FEED between the two pages.





Searching from page to page.
===========================

The search command ("S") will only work within the current page.

If the string you are looking for is on the next page, the search
will not succeed.

There is therefore the "N" command which continues searching over
page boundaries.

The "N" command is used exactly as the "S" command.
There is also a "FN" command corresponding to the
"FS" command but searching over page boundaries.




Avoid too large pages.
=====================

A warning: if your file contains too large pages, or if it does
not contain any page boundaries, then TECO will automatically
assume invisible page boundaries at regular intervals in your text.
Thus you may unexpectedly find that a search with an "S" command
will not succeed. In that case, either use the "N" command or
use the "P" command to get to the next page and then use the
"S" command to search within that page.

This difficulty will not occur if you divide
your file into small enough pages.


Moving to a previous page.
=========================

If you are on one page, and want to move to the next page,
you just use the "P" command. Moving backwards to previous
pages is more difficult.

The simplest way to move backwards is to leave TECO and
then enter TECO again at the beginning of the file. You do
this by first writing "EX$$", then waiting until you get
to the monitor, and then writing "TECO" to get back to TECO
again.

It is anyway always good practice to perform this operation of
leaving and entering TECO now and then, since if there is
a machine failure, you may lose everything that
you did since the last time you entered TECO.


Summary
=======

TECO Command	Effect
------------	------
I<form feed>$	Insert a page mark
P		Move the pointer to the next page
A		Append the next page and remove the page mark
nN<str>$	Search for the first occurence of the string
		<str> over page boundaries
nFN<str1>$<str2>$ Substitute the n:th occurence of <str1> to
		  <str2> and look over page boundaries.
Lesson "tops9t".




TECO as a programming language.
==============================

TECO is in reality a programming language in which you can
write executable text editing routines. However, such capabilities
in general go beyond the scope of this introductory course.

The simplest case of a program is a loop. A loop in TECO can be used
if you want to do the same editing action at several places in the text.
You do not have to type in the string of the same TECO command
more than once if you use a loop.


Writing iterative loops with TECO.
=================================

A loop consists of a number, the character "<", a TECO command
string and finally the character ">".

Example: "3<FS $  $>$$" indicates a loop. The number 3 tells
TECO to execute the command string inside the "<" ">" brackets
three times. Once in each iteration, a space is found and
changed to two spaces.

Thus, the command example above will, if it is applied to
"this text line, change the line to:"
"this  text  line,  change the line to:"




You do not have to put any number at all in front of the
loop brackets. If there is no such number, the loop continues
infinitely. However, there are commands you can put inside the
loop to stop it. One common such command is the ";" command,
which stops the loop at the end of the text file.

Example "<FNWORK$HAPPINESS$;>$$" will search through all pages
of the whole text file and change every occurence of "WORK" to
"HAPPINESS".


You are doing fine!



Q-registers for temporary data storage.
======================================

TECO like most other programming languages has variable cells
in which you can store information for later use. These cells
are called Q-register and they have one-character names:
either one of the letters A-Z or one of the digits 0-9.

Two common uses for Q-registers are

a) To store a complex TECO command string in them which you
want to execute many times.

b) To store text in them which you want to move from one place
in the text to another place, or which you want to insert at more
than one place in the text.


Macros = saved TECO command strings.
===================================

If you want to store a TECO command string in a Q-register, you
write "*" followed by the Q-register name, immediately after
executing the command string that you want to store in the
Q-register.

Example: You want to look, one at a time, on all lines containing
the word "ERROR". The first time you write the command string
"NERROR$0TT$$". Immediately after that you write
"*M" to store this command string in the Q-register M.
The next time you just write "MM$$" which means "execute
the TECO command string in Q-register M, that is exactly as
if you had written "NERROR$0TT$$" once more.

Every time thereafter, when you search through the file for
more occurences of the word "ERROR" you only have to type
"MM$$".




This is a very difficult lesson, but you are clever and stubborn.


You are a tough man (or woman). I think that these questions
were a little too easy for you...



Using Q-registers to store and move text segments.
=================================================

To insert text from the file into a Q-register you write "nXi" where
n is the number of lines to insert and i is the name of the
Q-register.

You can then move the contents of the Q-register back to the
file again by writing "Gi" where i is the Q-register name.

Example:
You have the text
"AAAA
CCCC
BBBB
" and want to get the lines in alphabetical order. This can
be done with the TECO command string "L1XAKLGA$$". Try to
understand why!!!


You will find more information about TECO in the manuals
"Introduction to TECO" and "TECO programmers reference manual".


Summary
=======

TECO Command	Effect
------------	------
n<commands enclosed in brackets>
		The commands will be executed n times.
*m		Store the last command string in Q-register m.
Mm		Execute the contents of Q-register m.
nXm		Move n lines of text into Q-register m.
Gm		Put the contents of Q-register m into
		the text at the pointer.
Lesson "tops10".




Monitor commands for file handling.
==================================

When you are communicating with the monitor, there is a large
set of monitor commands which you can write in answer to the
dot (".") which tells you that the monitor is expecting
a command from you.

You have already in previous lessons learnt the following commands:

.LOGIN to get access to the computer,
.R to execute a system program,
.RUN to execute one of you own programs,
.MAKE to create a new text file with TECO,
.TECO to edit an old text file with TECO,
.SOS to create and edit a text file with SOS.

In this lesson you will learn a few more useful monitor commands.


Which files have I got?
======================

The DIRECT command will list the names of all files,
which you have saved on disk. You just write DIRECT
to the monitor to get this listing. The listing
will give the name of the file, the size of it, and
the date and time when you last modified it.

if you write "DIRECT TOPS10.EXE" you get information about
only that single file.


You can also indicate a simple pattern, so that all files whose
names match the pattern are listed.

In such a pattern you can use "*" to stand for any filename or
any filename extension, and you can use "?" to stand for any
character in a filename or extension.

EXAMPLES:

"DIRECT *.SIM" will list the names of all files with the
extension "SIM", that is, all SIMULA source program files.

"DIRECT MYPROG.*" will list the names of all files
with the name "MYPROG", regardless of the extension.

"DIRECT TOPS??.*" will list the names of all files
whose first four characters are "TOPS",
and with any extension.




You can also list more than one filename pattern after the
word "DIRECT".

For example, "DIRECT PROG.FOR,PROG.REL,*.EXE"
will list the names of the two files PROG.FOR and PROG.REL
and will also list all files with the extension "EXE".


Just because you are so good, you will get a real hard
question.



Fantastic! You did it again!


On many of the monitor commands you can add switches explaining
how the command is to be performed. A typical example is the
switch "SLOW" which you can add to the "DIRECT" command.
This switch causes "DIRECT" to give more information about
each file; You will be told not only the date when it was
last modified but also the date when it was last used.


A switch must always be written with the character "/" in
front of it. That character indicates that a switch follows.

Example: DIRECT /SLOW *.*

Similarly the /FAST switch will cause filenames and
extensions only to be listed.
There are many other switches on the DIRECT command,
you can see a list of them in the DEC system 10 OPERATING
SYSTEMS COMMAND MANUAL.


You can also indicate that you want to look at files
under another project-programmer-number than your own.
You just write the project-programmer-number inside square
brackets after the filename.

Example "DIRECT *.ALG[13,100]" will list the names of all
ALGOL source programs under the project-programmer-number 13,100.

Second example: "DIRECT *.ALG[13,*]" will list all ALGOL source
program names on all programmer numbers in project 13.



A useful variation of the "DIRECT" command is to use the
"SINCE" switch to list only those files which have been
generated or modified after a certain time and date.

Example: "DIRECT *.*/SINCE:0" will list all files which
have been generated or modified this day.


Printout of text files.
======================

If you want to get a full listing of a text file, you can use the
TYPE or PRINT commands. TYPE prints the file(s) on your terminal,
PRINT prints the file(s) on the line printer.

Example: "TYPE TREE.SIM" will type the SIMULA program TREE on
your conversational terminal.

Second example: "PRINT TOPS??.GNO,*.ALG" will print on the line
printer all GNOSIS lessons in which the first four letters of
the name of the lesson are "TOPS" and will also print all ALGOL
source program files.


Changing the protection code.
============================

You can change the protection of a file by using the "PROTECT"
command. Suppose that you want to change the protection of
all files with the extension "EXE" to <555>. You then write
"PROTECT <555> *.EXE".

<555> means that everyone can read the file, but no one is
allowed to modify it. You can howewer yourself always change
the protection of the file with the "PROTECT" command e.g.
to <055> and then modify it.


Deleting files.
==============

You can delete a file with the "DELETE" command.
Example: "DELETE *.REL" will delete all your files which
have the extension "REL". Think carefully before using
the DELETE command. If you are not sure, write first
a "DIRECT" command with the same file specification, to
see what will be deleted before it is too late.

Second example: "DELETE A.ALG,B.ALG,C.ALG" will delete
these three files.


Renaming files.
==============

You can change the name of a file with the RENAME command.
Example "RENAME PROG.BAC=PROG.BAK" will change the name
of the file "PROG.BAK" to the new name "PROG.BAC". This is
a very useful command if you believe that you have destroyed
a file with TECO or SOS. The editors usually create backup copies
of your file  with the extension "BAK" for TECO, "Qxx" for SOS.
(Here xx are the same letters as in the original extension.)
But that backup copy will soon be dstroyed too if the
main file is destroyed, so by renaming it to the extension
"BAC" instead of "BAK" or "Qxx" you save it from being destroyed
by the editor.


Copying files.
=============

The COPY command can be used to copy a file. Example:
"COPY X.A=Y.A" will create a new file "X.A" which will
be identical to your old file "Y.A".

You can also copy together several old files into one
large new file.

"COPY AB.ALG=A.ALG,B.ALG" will create a new file containing
first the contents of "A.ALG" and then the contents of
"B.ALG".

"COPY SUM.REL=F?????.REL" will copy together the "REL"
files of all programs whose first letter is "F".


To copy the file RESULT.DAT from DSKB to DSKA you write:
	COPY DSKA:=DSKB:RESULT.DAT
You need not specify the file name(s) on the left hand side
if they are to be the same as on the right hand side.


DIRECT will list the names of files.
TYPE will print the whole file on the conversational terminal.
PRINT will print the whole file on the line printer.
COPY will create a copy of a file with a new name
     or in a different place.
PROTECT will change the protection of a file.
RENAME will change the name of a file.
DELETE will delete a file.





The "FILE" command.
==================

A DEC-tape is a very small magnetic tape which is useful
to store small or medium-size files like source programs.
On a DEC-tape, you can remove and replace files irrespective
of order, just as on the disk.

The "FILE" monitor command is used to move files between your disk
area and a DEC-tape.

There are several variants of this:
.FILE Z to zero a whole DEC-tape(dangerous!!!!)
.FILE D to remove named files from a DEC-tape
.FILE F to copy named files from disk to a DEC-tape
.FILE R to copy named files from a DEC-tape to disk
.FILE W to wait until all previous FILE commands
from you have been executed, etc.


Suppose that you want to move the two files 
"TOPS11.EXE" and "TOPS12.EXE" from the DEC-tape
"DEQZ23" to your disk area. Then you type
"FILE R,DEQZ23,TOPS11.EXE,TOPS12.EXE".
After that you push "RETURN" and then you
must wait until the files have been loaded.
You can know when this waiting ends by typing "FILE W"
and then wait until a monitor "." dot appears.



Summary
=======

Command		Effect
-------		------
DIRECT		will list the names of files.
TYPE		will print the whole file on the conversational terminal.
PRINT		will print the whole file on the line printer.
COPY		will create a copy of a file with a new name.
PROTECT		will change the protection of a file.
RENAME		will change the name of a file.
DELETE		will delete a file
FILE		handles reading and writing dectapes:

	FILE Z	to zero a whole DEC-tape(dangerous!!!!)
	FILE D	to remove named files from a DEC-tape
	FILE F	to copy named files from disk	to a DEC-tape
	FILE R	to copy named files from a DEC-tape	to disk
	FILE W	to wait until all previous FILE commands
		from you have been executed, etc.
Lesson "tops11".




Programming languages.
=====================

This section contains some value judgments concerning
the qualities of various programming languages. These
value judgments are only valid when comparing different
languages on the DEC 10. They are  n o t  valid when
comparing languages on different computers.

Example: When I say that MACRO 10 gives bad readability,
I mean that MACRO 10 gives bad readability compared to
other programming languages on the DEC 10.
I do  n o t  mean that MACRO 10 gives bad readability
compared to other assemblers on other computers.


Here are some of the programming languages on the DEC 10:

LANGUAGE  Com-  Inter- Num-  Data   Machine  Notes
          piler preter eri-  struc- indepen-
                       cal   tures  dent
-----------------------------------------------------------------------
AID       no    yes    yes   few    no       Slow execution. For simple
                                             desk calculator applications.
ALGOL     yes   no     yes   few    somewhat Secure language giving readable
                                             programs and efficient execution.
APL       no    yes    yes   yes    yes      Not very fast. Short powerful
                                             commands. Not very readable.
BASIC     yes   no     yes   few    yes      Easy to learn. Not very fast.


And here are some more programming languages on the DEC 10:

LANGUAGE  Com-  Inter- Num-  Data   Machine  Notes
          piler preter eri-  struc- indepen-
                       cal   tures  dent
-----------------------------------------------------------------------
BLISS     yes   no     yes   many   no       Machine close. Efficient.
                                             Readable. Bad security.
COBOL     yes   no     some  some   yes      Most suited for advanced
                                             file handling.
FORTRAN   yes    no     yes   few   somewhat Efficient execution. Bad
                                             security and readability.
LISP      yes   yes    yes   many   yes      General purpose. Short clear
                                             programs. Bad memory-efficiency.
MACRO 10  yes   no     yes   no/all no!      Assembler with macro processor.
                                             Very bad security and readability.
PASCAL    yes   no     yes   yes    yes      Good readability and structuring
                                             in spite of simplicity.
SIMULA    yes   no     yes   many   verygood General purpose. Efficient.
                                             Readable and secure programs.
SNOBOL    yes   yes    some  yes    verygood For simple text-processing
                                             applications.





The program will ask you a number of question about your
requirements on the programming language. Please do not answer
that all requirements are important to you. No language can
satisfy all different requirements. You have to make a choice
and only indicate that you need those properties of a language
which are especially important to you.



AID.
===

AID, also called JOSS, is a simple interpretive language with about
the same capabilities as an advanced desk calculator. It is mostly
suited for numerical applications. Execution is rather slow.

AID contains its own source program editor and file handler,
so that you do not have to learn TECO or SOS to use AID.



ALGOL.
=====

ALGOL is mostly suited for numerical applications, but the DEC imple-
mentation contains string-processing, though in a non-standardized
way. ALGOL gives readable and secure program and the compiler produces
efficient machine code.



APL.
===

Each APL command is very powerful, and most of them is only one character
long. Thus APL programs are very compact, although somewhat cryptic.
The language is general-purpose with large capabilites. It is fast
for an interpreted language, but still slow compared to compiled
languages.

APL on DEC 10 is a commercial program product. APL is best suited
to terminals which have the special APL character set.



BASIC.
=====

BASIC is a very simple language best suited to numerical applications.
BASIC is in many ways similar to FORTRAN, but includes commands
for manipulation of whole matrices.

BASIC uses its own line oriented editor, so that the BASIC user
does not have to learn to use a separate editor like SOS or TECO.



BLISS.
=====

BLISS is especially designed for the production of large efficient
software products. BLISS is specially tailored to the DEC 10
computer architecture, and the intention is that programs in
BLISS will be almost as efficient with time and memory as the
best assembly programs.

BLISS has an ALGOL-like structure and is very much oriented to
highly blocked and highly procedured programs.

The BLISS compiler requires between 45K and 60K of core(depending
on the size of the BLISS program being compiled) and this means
that BLISS cannot be used on some small memory installations.



COBOL
=====

COBOL is a language for such business applications, where you
are mostly doing input/output to files, tapes and other
i/o devices.

COBOL contains a system for on-line debugging.



FORTRAN.
=======

FORTRAN is the most widely used language for numerical applications.
FORTRAN has many disadvantages:

Bad security(that is error checking capability),
Bad readability of programs,
No dynamic memory allocation,
Very few data structuring facilities.

FORTRAN has a system for dividing a program into separately compiled
modules, which is not very secure or flexible, but which works better
than in many more advanced languages, and this is one reason for
the popularity of FORTRAN.


FORTRAN is also available on more computers than any other programming
language. FORTRAN is standardized, but the standard is a so-called
permissive standard. This means that there is no checking in most
FORTRAN systems that a program really uses only standard FORTRAN.
And since many FORTRAN compilers accept a language including
much more features than standard FORTRAN, the compatibility will be an
illusion except with rigorous programming discipline.

There is an online debugging systems, called FORDDT,
for FORTRAN programs.




LISP.
====

LISP programs are divided into many small procedures, which call
each other recursively. This way of writing a program will often
give simple and clear programs, once you have got used to it.

LISP is based on one very flexible kind of data structure, a kind
of linear list in which each element can itself be a list of
the same kind. This data structure can be adapted to most practical
application needs. LISP programs are themselves stored in the same
kind of data structure. This means that a LISP program can easily
manipulate or create or interpret programs in LISP or other languages.


LISP programs can be executed both interpretively and compiled.
An execution can also contain a mixture of compiled and interpreted
parts.

This makes it easy in LISP to program applications where the 
borderline between data and program is not very sharp.

LISP systems often do not use the memory in the computer very
efficiently.

There are two LISP systems available on the DEC 10, the
STANFORD and the BBN system. The BBN system is regarded as
the most advanced, especially for large programs requiring
virtual memory.



MACRO 10.
========

MACRO 10 is a conventional assembly language with a MACRO facility.
Such languages should be avoided, since they give very high
programming cost and very bad readability of programs.

If you desire high efficiency, you will probably get better results
by first programming in an advanced high-level language like
SIMULA or LISP, and then rewriting central parts of the program
only in BLISS or MACRO 10.

There is an on-line debugging system DDT for MACRO 10 programs.




PASCAL.
======

PASCAL is a simple language, rather easy to learn and use. In spite
of this, the language has good data structuring facilities and is
well suited to readable, well structured programs. The compiler
produces efficient code, and can produce shareable, reentrant
code.

The main restrictions of PASCAL is in the area of file handling.
Also, the security and structuring facilities are not as good
as in SIMULA, but on the other hand the language is smaller and
simpler and more efficient than SIMULA.



SIMULA.
======

SIMULA is a general-purpose high-level language. Data can be
structured according to the user's wishes, including list structures
and text strings. The program can be structured into routines
executed in parallel. Data and program can be combined into a SIMULA
CLASS which is a basic element in both program and data structuring.

SIMULA contains ALGOL as a subset. Compared to most other languages,
SIMULA gives very high security. By this is meant the ability of the
system to find programmer errors and the non-existent possibillity
that the program should de-rail out of the SIMULA framework.


The DEC 10 SIMULA compiler produces efficient object code
and requires a 30K memory area during compilation.

The SIMULA system for the DEC 10 contains a system for separate
compilation which is much more flexible than in FORTRAN and which,
in contrast to FORTRAN, will give full security. The DEC compiler
also contains an advanced on-line debugging system, SIMDDT.



SNOBOL.
======

SNOBOL is especially suited for text handling applications, e.g.
- Scanning a text to find certain patterns and do something there.
- Translation between not to dissimilar languages.
- Scanning a text for correctness.
- Preparing data for input.
- Prpearing data for good-looking output.

SNOBOL is not so well suited for such very advanced text-processing,
which in reality is mostly symbol and data structure manipulation.
There, LISP or SIMULA is better suited.

There are two SNOBOL systems on the DEC 10. The official system
is slow and requires much memory. The SPTBOL system is much faster
and requires less memory, but it is a commercial program product.



Monitor commands for compiling and loading.
==========================================

Programs in languages like FORTRAN, ALGOL or SIMULA are first compiled
and then linked using the LINK 10 or LOAD 10 loaders.

Programs in AID, APL, BASIC, LISP or SNOBOL are not handled in this
way, since those languages are either not compiled, or else use their
own linking loader. To learn how to execute programs in those languages,
you will have to look at the manual for that language.

Here is described the process using the standard DEC LINK or LOAD programs,
which is what you do with languages in ALGOL, BLISS, COBOL, FORTRAN,
MACRO 10 or SIMULA.


With those languages, the source program file should have an extension
indicating the language:
.ALG for ALGOL programs,
.BLI for BLISS programs,
.CBL for COBOL programs,
.FOR for FORTRAN programs,
.MAC for MACRO 10 programs or
.SIM for SIMULA programs.

These extensions tells the system which compiler to use when compiling
your program.



When you have created a source program with TECO or SOS, you want to
compile it, then load it, and then execute it. This can be done
respectively with the COMPILE monitor command,
LOAD monitor command and
START or RUN monitor command.

The COMPILE command will take a source program as input, and output
a relocatable object program with the extension .REL.

The LOAD command will take a relocatable object program with
the extension .REL as input, and will output an absolute object
program, ready to execute. This absolute object file will reside in
your core area, not on your disk area, and thus has no extension.

The START command will start the execution of the absolute program
in your core area.


Example: If you have a source program in SIMULA called PROG.SIM,
then

.COMPILE PROG.SIM will compile it, and produce a relocatable object
code file called PROG.REL.

.LOAD PROG.REL will thereafter load this relocatable object code
file into an absolute program in core.

.START will start the execution of that absolute program in
core.








Shortcuts.
=========

In practice, you do not have to write out all the three commands
COMPILE, LOAD and START.

You can write LOAD without first writing COMPILE. If you write
LOAD, then the system will automatically recompile your source
program. This automatic recompilation is done if there is no
relocatable object file to LOAD, and also if the source program
file is newer than the relocatable object file. Only if there
is a relocatable object file which is newer than the source
program file LOAD will load that object file.

There is also a command called "EXECUTE" which combines the
LOAD and START commands into one single command.

This means that the single command "EXECUTE" is enough to
compile, load and start execution of a source program.



It is also not nescessary to type the extensions unless you have
several program files with the same name. The system will look
at all files with the given name, and decide what needs to be done.


Saving absolute core images of programs.
=======================================

The "LOAD" command will make the loader put the executable
absolute object code into your core image area. You
can however also save it on disk for later execution
with the "RUN" command. To do this, you use the SAVE monitor
command.

You write "SAVE" followed by the filename under which you want
to save the program.

Example: You have a source program file "PROG.SIM" which you
want to compile and load and then save the executable object
program on disk. You then first write "LOAD PROG.SIM", and
then you write "SAVE PROG". The program will then be saved
in a disk file called "PROG.EXE". The extension ".EXE" indicates
that this is an absolute executable object program which can
be executed directly without either compilation or loading.




Program listings and cross-reference listings.
=============================================

There are many switches which you can write on the monitor
commands COMPILE, LOAD and EXECUTE.

Two important ones are:

LIST to get a line printer listing of your source program.
CREF to prepare data for a cross-reference listing of the
     identifiers in your source program.

Example: To compile "PROG.SIM" and also get a source program
listing on the line printer, you write "COMPILE PROG.SIM/LIST".


Summary
=======

The type of program files are indicated by their extensions:
.ALG for ALGOL programs,
.BLI for BLISS programs,
.CBL for COBOL programs,
.FOR for FORTRAN programs,
.LSP for LISP programs,
.MAC for MACRO 10 programs or
.SIM for SIMULA programs.

Command		Effect
-------		------
COMPILE		Compile a program
LOAD		Load a program into core
EXECUTE		Compile, load and start a program
SAVE		Save the core image in a file.

Switches to COMPILE, LOAD and EXECUTE are:
/LIST	Print the listing on the line printer
/CREF	Make a cross reference.
Lesson "tops12".




Logging out.
===========

You finish a session at the terminal by logging out. Logging out
disassociates the terminal from your project-programmer number.
This means that after logging out, a person at the terminal can
no longer pretend to be you, and cannot access your files in the
way you yourself can.

Logging out also influences accounting, so that your number is
not debited the cost of connection time and computer time any
longer. (The following text presumes that the batch and
spooling system is GALAXY.)


Rationing of the disk memory.
============================

Since the available disk memory is not unlimited, there is a
rationing on disk usage. This means that there is a quota of
disk memory allowed to you.

This quota is much lower after logging out than before. There-
fore, logging out time is a good time for deleting temporarary
files. Even if you did not exceed the logged out quota, you
may still want to delete files at log out time.


The monitor command for logging out is KJOB.
The simplest kind of logout is to type just "KJOB" which means
logout and save all files. This command can be shortened to "K".
If you try to  perform a "KJOB" when you are using more
than your logged-out quota, then the monitor will not allow
you to log out. The monitor will never allow you to log out
until you are below the logged-out quota.


KJOB options
============

If you type only "KJOB", the computer will perform an ordinary
logout. There are however a way to change the behaviour
of the "KJOB" command by adding a slash "/" and a letter
to the end of the command. The addition is called a switch.

KJOB	without switches performs an ordinary logout. Gives
	you some statistics about the job.
KJOB/N	works like KJOB but doesn't give any logout message.
KJOB/C	works like KJOB, but it will not disconnect you from
	the computer if you are using a telephone line. You
	can login again without redialling.
KJOB/H	Gives help information and does NOT log out.


Summary
=======

The KJOB variants are:

KJOB	without switches performs an ordinary logout. Gives
	you some statistics about the job.
KJOB/N	works like KJOB but doesn't give any logout message.
KJOB/C	works like KJOB, but it will not disconnect you from
	the computer if you are using a telephone line. You
	can login again without redialling.
KJOB/H	Gives help information and does NOT log out.


You have now finished the whole course of twelve lessons.
Thank you for your patience and hard work. I hope you
enjoyed learning to use the DEC 10 in this way.

If you have any comments on the course, such as what was
too difficult or too easy, or some question which should
be rephrased, then please write and tell me.

                                        Your teacher
	Jacob Palme, FOA HE 1, S-104 50 Stockholm 80, Sweden
  
