
	program Profilometer


c---
c  variable declarations  ( Group screen )

        Integer GRow, GCol, GCurField, GTermKeys(30)
        Integer GNumberOfFields, GLastKey
        Logical GNext, GPrevious, GExit, GRefresh

        character* 4    Version
        character* 9    Date
        character* 6    GroupID
        character* 3    Operator
        character*65    Description
        integer         ScanRate
        character* 6    StageVelocity


c---
c  variable declarations  ( Specimen screen )

        Integer SRow, SCol, SCurField, STermKeys(30)
        Integer SNumberOfFields, SLastKey
        Logical SNext, SPrevious, SExit, SRefresh

        character* 6    SpecimenID
        character*12    Orientation


c---
c Misc variables
	integer Abort
	logical More

c---
c Variable initialization

	data Abort /141/

	data GRow /1/ , GCol /1/ , SRow /11/ , SCol /39/

c---
c immediate termination on F1 key
        data GTermKeys/ 0, 1, 141, 27*0 /

        data STermKeys/ 30*0 /



        Version = '1.00'
        call Today( Date )
        GroupID = ' '
        Operator = ' '
        Description = ' '
        ScanRate = -1
        StageVelocity = '1.0'
	SpecimenID = ' '
	Orientation = 'Transverse'


c---
c Total number of screen parameters

        GNumberOfFields =   7

        SNumberOfFields =   2


c--	Initialize Terminal Routines
	call TTYinit
	call EchoOff
	call KpdOn


c--	Display Specimen Group Information

	GCurField = 3

100     call GroupClear( GRow, GCol )

        call GroupTextDsp( GRow, GCol )

        call GroupDataDsp( GRow, GCol
     1 , Version, Date, GroupID, Operator, Description, ScanRate
     1 , StageVelocity
     1   )


c--	repeat
200	continue

c--	  Get Specimen Group Information

300       call GroupEdit( GRow, GCol, GCurField, GTermKeys
     1   , Version, Date, GroupID, Operator, Description, ScanRate
     1   , StageVelocity
     1   , GNext, GPrevious, GExit, GRefresh, GLastKey )

	  if( GLastKey .eq. Abort ) then
	    call KpdOff
	    call ClrScr
	    stop '[Program Aborted]'

	  else if( GNext ) then
	    GCurField = 3

	  else if( GPrevious ) then
	    GCurField = GNumberOfFields

	  else if( GRefresh ) then
	    goto 100

	  end if


	  if( .not. GExit ) goto 300

390	  SCurField = 1

c--	  repeat
400	  continue

c--	    Display and get Specimen Information

            call SpecClear( SRow, SCol )

            call SpecTextDsp( SRow, SCol )

            call SpecDataDsp( SRow, SCol
     1     , SpecimenID, Orientation
     1       )

500         call SpecEdit( SRow, SCol, SCurField, STermKeys
     1     , SpecimenID, Orientation
     1     , SNext, SPrevious, SExit, SRefresh, SLastKey )

            if( SNext ) then
	      SCurField = 1

	    else if( SPrevious ) then
	      SCurField = SNumberOfFields

	    else if( SRefresh ) then
              call GroupClear( GRow, GCol )
              call GroupTextDsp( GRow, GCol )
              call GroupDataDsp( GRow, GCol
     1       , Version, Date, GroupID, Operator, Description, ScanRate
     1       , StageVelocity
     1         )
	      goto 400

	    end if


	    if( .not. SExit ) goto 500

c--	    Collect and Plot Test Data
	    call DoTest

c--	    More Specimens?
	    call MoreSpecs( More )

c--	      if Yes then Display Specimen Group Information
	      if( More ) then
                call GroupClear( GRow, GCol )
                call GroupTextDsp( GRow, GCol )
                call GroupDataDsp( GRow, GCol
     1         , Version, Date, GroupID, Operator, Description, ScanRate
     1         , StageVelocity
     1           )
	      end if

c--	  until no more specimens
	  if( More ) goto 390

c--	  Another Specimen Group?
	  call MoreGroups( More )

c--	until no more specimen groups
	if( More ) goto 100


	call KpdOff
	call ClrScr
	stop '[Normal Program Termination]'

c--	program end
	end

