      SUBROUTINE GRID(X,Y,DELX,DELY,NX,NY)
C
C
C    THIS ROUTINE IS USED TO DRAW A GRID
C
C
C    CALLING SEQUENCE:
C
C     (X,Y) - (I) COORDINATES OF THE CORNER OF THE GRID
C
C     DELX  - (I) DISTANCE (IN INCHES) BETWEEN GRID LINES IN THE X
C               DIRECTION
C
C     DELY  - (I) DISTANCE (IN INCHES) BETWEEN GRID LINES IN THE Y
C               DIRECTION
C
C     NX    - (I) NUMBER OF SPACES IN X DIRECTION WITHIN THE GRID
C
C     NY   - (I) NUMBER OF SPACES IN Y DIRECTION WITHIN THE GRID
C
C
C    SUBPROGRAMS USED:
C
C      FLOAT AND PLOT
C
C
      DIMENSION DX(6:7),DY(6:7),TDX(6:7),TDY(6:7)
      EQUIVALENCE (TDX(7),DX(6)),(TDY(7),DY(6))
      DATA DX(6),DY(6) / 0.,0. /


      DX(7) = DELX
      TDX(6) = -DELX * FLOAT(NX)
      DY(7) = DELY
      TDY(6) = DELY * FLOAT(NY)
      IPEN = 6

      CALL PLOT (X,Y,3)

      DO 10 I = 1,(NX * 2 + 1)
         CALL PLOT (DX(IPEN),TDY(IPEN),IPEN)
         IPEN = IPEN .XOR. 1
10       IF (IPEN .EQ. 6) TDY(6) = -TDY(6)

      IF ((NX .AND. 1) .EQ. 0)  DY(7) = -DY(7)

      DO 20 I = 1,(NY * 2 + 1)
         IPEN = IPEN .XOR. 1
         CALL PLOT (TDX(IPEN),DY(IPEN),IPEN)
20       IF (IPEN .EQ. 6) TDX(6) = -TDX(6)

      RETURN
      END
